# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from apache_openid import logging
from apache_openid.handlers.openid.actions import *
from apache_openid.handlers.openidteams.mixins import CookiedTeamsMixin

#from openid.extensions import teams
from apache_openid.handlers.openidteams import teams

class TeamsLoginAction(LoginAction, CookiedTeamsMixin):
    def add_openid_extensions(self, auth_request):
        # Request Launchpad teams information, if configured
        if len(self.authorized_teams) > 0:
            teams_request = teams.TeamsRequest(self.authorized_teams)
            auth_request.addExtension(teams_request)
        return auth_request

class TeamsReturnAction(ReturnAction, CookiedTeamsMixin):
    def complete_login(self, response):
        if len(self.authorized_teams) > 0:
            teams_response = teams.TeamsResponse.fromSuccessResponse(response)
            logging.debug('Teams response: %r',teams_response.is_member)
            self.cookied_teams = teams_response.is_member
        logging.debug('do_return: cookied_teams: %r', self.cookied_teams)
        super(TeamsReturnAction, self).complete_login(response)


class TeamsLogoutAction(LogoutAction, CookiedTeamsMixin):
    def do(self):
        try:
            del self.cookied_teams
            logging.debug("Deleted cookied teams")
        except KeyError:
            pass
        return super(TeamsLogoutAction, self).do()
