/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.parse;

import jd.xml.util.SaxUtil;
import jd.xml.xpath.model.parse.ParseHandler;
import jd.xml.xpath.model.parse.PullParseHandler;
import jd.xml.xpath.model.parse.Sax1ParseHandler;
import jd.xml.xpath.model.parse.Sax2ParseHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class ParseHandlerFactory {
    public static final String PROPERTY_NAME = "jd.xml.xpath.model.parser";
    private static Class pullParserClass_;

    public static Object createDefaultParser() throws SAXException {
        String string = System.getProperty(PROPERTY_NAME);
        if (string == null) {
            XMLReader xMLReader = SaxUtil.createXmlReader();
            System.setProperty(PROPERTY_NAME, xMLReader.getClass().getName());
            return xMLReader;
        }
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new SAXException("cannot create parser '" + string + "'", exception);
        }
    }

    public static ParseHandler createDefaultHandler() throws SAXException {
        return ParseHandlerFactory.createHandler(ParseHandlerFactory.createDefaultParser());
    }

    public static ParseHandler createHandler(Object object) throws SAXException {
        if (object == null) {
            return ParseHandlerFactory.createDefaultHandler();
        }
        if (object instanceof XMLReader) {
            return new Sax2ParseHandler((XMLReader)object);
        }
        if (object instanceof Parser) {
            return new Sax1ParseHandler((Parser)object);
        }
        if (pullParserClass_ != null && pullParserClass_.isAssignableFrom(object.getClass())) {
            return new PullParseHandler(object);
        }
        throw new IllegalArgumentException("don't know how to use parser: " + object.getClass().getName());
    }

    static {
        try {
            pullParserClass_ = Class.forName("org.xmlpull.v1.XmlPullParser");
        }
        catch (Exception exception) {
            pullParserClass_ = null;
        }
    }
}

