# 26.0.1

## Fixes
 - Fix `ssa` not being a known format.
 - Catch exception when parsing invalid bitrate.
 - Remove the `--my-ffmpeg` `--show-ffmpeg-commands` `--show-ffmpeg-debug` cli options.
 - Remove the `ae-ffmpeg` package dependency.
 - Remove unused args, functions.

 **Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/26.0.0...26.0.1


# 26.0.0

## Major
 - You can now preview videos before rendering is complete. (see footnote 1).
 - `unset` is now never a valid codec. Use `auto` instead.
 - `unset` is now not a valid bitrate value. Use `auto` instead.
 - Removed the `--extras` and `-qscale:v` cli options.
 - The `ae-ffmpeg` pypi package is deprecated and will be removed in a future release. Future versions of auto-editor will not ship ffmpeg cli binaries.
 - The `--my-ffmpeg` `--ffmpeg-location` `--show-ffmpeg-commands` and `--show-ffmpeg-debug` cli options are now deprecated and can be removed in a future `26.x` release.

## Features
 - Auto-Editor is consistency twice as fast as `25.x` if `-c:a pcm_s16le` is set.
 - Auto-Editor is now 20% faster to 50% slower with default options. (see footnotes 2 and 3).
 - Remove all uses of ffmpeg-cli in auto-editor, with the exception of a few holdouts (EBU norm, audio mixing, yt-dlp).
   * using GPL vs LGPL builds of PyAV now determine if the `libx264` or `libopen264` encoder is used.

## Fixes
 - Never write a "null frame" if the timeline is known to be linear. Fixes #468

## Footnotes
 - [1] You can preview media files if they are in the Matroska format (`.mkv`). Although `.mp4` hybrid could theoretically work, ffmpeg does not appear to have sufficient support yet. YMMV with other formats.
 - [2] Smaller files perform better. Larger files perform worse compared to `25.x` when using a solid state drive/fast storage.
 - [3] It should be possible to eventually recover this lost performance. Either with multiprocessing, or multi-threading with GIL-free builds of Python.

## Known Regressions
 - Data Streams, Attachment Streams, and Embedded Image (video) streams are now always dropped due to some limitations with the current version of PyAV. This should be fixed in a future version of `26.x`

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/25.3.1...26.0.0


# 25.3.1

## Features
 - Use PyAV 13.1

## Fixes
 - Make correct webvtt files, fixes #531
 - Don't open player when exporting as clip-sequence

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/25.3.0...25.3.1


# 25.3.0

## Features
 - Add `-dn` option. Allows data streams to be dropped from final output.
 - Allow using older version of final cut pro. Example: `--export final-cut-pro:version=10`

## Fixes
 - Add file "last modified time" to cache string. Fixes #536
 - Fix `motion` returning lower values than it should.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/25.2.0...25.3.0


# 25.2.0

## Features
 - Use PyAV 13
 - Add stacktraces to the Palet Programming Language
 - Add `input-port?` type and more procedures. Helpful for writing custom edit procedures in `config.pal`.

## Fixes
 - Prevent colon form from evaluating arguments eagerly
 - Set upper bounds on dependencies

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/25.1.0...25.2.0


# 25.1.0

## Features
 - Add the DaVinci Resolve FCP7 backend. It's not the default since there are known issues, but it is available if you're having other issues with the FCP11 backend.
 - Add `--config` flag option. When set, it will look for `./config.pal`. If found, it allows extending auto-editor by adding new editing methods by defining new procedures.

## Fixes
 - Fix "divide by zero error" when editing subtitle streams when a speed is exactly 0.
 - Removed the "speed" warning for the DaVinci Resolve FCP11 backend because it appears to not be true anymore for DaVinci Resolve 19 (maybe 18?) and newer.
 - Allow including/excluding the Palet standard environment for applications like pyinstaller.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/25.0.1...25.1.0


# 25.0.1

## Fixes
 - Hardcode that `.mp4` files support `srt` subtitles. Fixes #493
 - Info: display audio layout
 - Add PyAV License to the `--debug` screen
 - Improve argument parsing error messages

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/25.0.0...25.0.1


# 25.0.0

## Major
 - Switch versioning system from "CalVer weeks of the year" to SemVar.

## Features
 - Make temp directories lazily. This will mean a temp directory is not created at all in some cases.
 - Add the `--no-cache` option. When set, will prevent auto-editor from reading from or writing to a cache file.

## Fixes
 - Step around PyAV bug when getting pix_fmt. Fixes #489
 - Add `hevc_nevc` as a known encoder. Fixes #490
 - The cache is twice as small as the equivalent 24w31a would write.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w31a...25.0.0


# 24w31a

## What's Changed
 - Bug fix: never set the color primary if the value is 0
 - Palet: add `max-seq` and `min-seq` procedures

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w30a...24w31a


# 24w30a

## What's Changed
 - Upgrade to PyAV 12.3
 - Use PyAV to get encoder information instead of maintaining a big list
 - Audio analysis no longer writes a temporary WAV file

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w29a...24w30a


# 24w29a

## What's Changed
 - Use numpy's `.npz` for smaller and faster caching
 - Add `audio-levels` `motion-levels` to Palet
 - In general, remove lines of code

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w25a...24w29a


# 24w25a

## What's Changed
 - Only extract subtitle files when needed
 - Analyze subtitles robustly, don't rely on hacky methods
 - Assert generated timeline is monotonic (fixes #470)
 - Errors are now colored, will be disabled if NO_COLOR or AV_LOG_FORCE_NOCOLOR environment variable is set

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w24a...24w25a


# 24w24a

## What's Changed
 - Use `pyav` 12.1.0, the first release that is compatible with `av`
 - Handle import v1 timelines better

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w19a...24w24a


# 24w19a

## What's Changed
 - Round timebase to two-digits, which should fix a Premiere Pro issue
 - v3 format: offset is no longer implicitly multiplied by clip speed
 - Consider `libopus` a valid encoder

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w13a...24w19a


# 24w13a

## What's Changed
 - Color space handling has been improved
 - Having ffprobe is no longer required
 - `auto-editor subdump` now only uses/requires PyAV

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w09a...24w13a


# 24w09a

## What's Changed
 - By default, all tracks will now be considered when editing audio
 - Premiere Export: Fix 24w07a regression where only a single audio channel would play
 - Auto-Editor will now never attempt to copy attachments unless subtitle streams are present
 - `audio` `motion` `subtitle` are now no longer special lexer constructs

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w07a...24w09a


# 24w07a

## What's Changed
 - Fix crash on certain resolutions for legacy macs
 - Final Cut Export: always set "start" attribute even when value is 0
 - Premiere Export: additional tracks no longer need external wavs
 - Fix crash for all `.ts` media files

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w03a...24w07a


# 24w03a

## What's Changed
 - Analyzing motion is now 1.3x faster.
 - Changing the aspect ratio (adding padding) is now 2.7x faster.
 - Better support for the `yuv444p` `yuvj444p` pix_fmt's
 - Dropped the Pillow dependency
 - Upgrade pyav to 12.0.2

## Breaking Changes
 - Removed `--mark-as-loud` and `--mark-as-silent`. Use `--add-in`, `--cut-out` instead.
 - Removed `pixeldiff` as an option for `--edit`. Use `motion` instead.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w51a...24w03a
