//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/MaskResultsPresenter.h
//! @brief     Defines class MaskResultsPresenter
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_MASKRESULTSPRESENTER_H
#define BORNAGAIN_GUI_VIEW_MASK_MASKRESULTSPRESENTER_H

#include "GUI/View/Mask/MaskEditorFlags.h"
#include <QModelIndex>
#include <QObject>
#include <memory>

class IntensityDataItem;
class Datafield;

//! Updates bin values inside IntensityData to display current mask state. Returns IntensityData
//! to original state when requested.

class MaskResultsPresenter : public QObject {
    Q_OBJECT
public:
    MaskResultsPresenter(QWidget* parent = nullptr);
    ~MaskResultsPresenter();

    void setMaskContext(IntensityDataItem* intensityItem);

    void resetContext();

    void updatePresenter(MaskEditorFlags::PresentationType presentationType);

private:
    void setShowMaskMode();
    void setOriginalMode();
    void backup_data();
    Datafield* createMaskPresentation() const;

    IntensityDataItem* m_intensityDataItem;
    std::unique_ptr<Datafield> m_dataBackup;
    bool m_interpolation_flag_backup;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_MASKRESULTSPRESENTER_H
