#include "Base/Axis/Frame.h"

#include "Base/Axis/FrameUtil.h"
#include "Base/Axis/MakeScale.h"
#include "Base/Axis/Scale.h"
#include "Tests/GTestWrapper/google_test.h"

TEST(Frame, datafieldToFromBinf)
{
    Frame data1(newEquiDivision("axis0", 8, -5.0, 3.0), newEquiDivision("axis1", 3, 2.0, 5.0));
    Frame data2(newEquiDivision("axis0", 8, -10.0, 70.0), newEquiDivision("axis1", 3, -10.0, 20.0));

    double x(-4.5), y(2.5);
    FrameUtil::coordinatesToBinf(x, y, data1);
    FrameUtil::coordinatesFromBinf(x, y, data2);
    EXPECT_DOUBLE_EQ(x, -5.0);
    EXPECT_DOUBLE_EQ(y, -5.0);

    x = 3.1;
    y = 5.1;
    FrameUtil::coordinatesToBinf(x, y, data1);
    FrameUtil::coordinatesFromBinf(x, y, data2);
    EXPECT_DOUBLE_EQ(x, 71.0);
    EXPECT_DOUBLE_EQ(y, 21.0);
}

TEST(Frame, coordinateToFromBinf)
{
    Scale axis = EquiDivision("axis", 8, -5.0, 3.0);
    EXPECT_EQ(0.5, FrameUtil::coordinateToBinf(-4.5, axis));
    EXPECT_EQ(-4.5, FrameUtil::coordinateFromBinf(0.5, axis));

    EXPECT_EQ(1.0, FrameUtil::coordinateToBinf(-4.0, axis));
    EXPECT_EQ(-4.0, FrameUtil::coordinateFromBinf(1.0, axis));

    EXPECT_EQ(-0.5, FrameUtil::coordinateToBinf(-5.5, axis));
    EXPECT_EQ(-5.5, FrameUtil::coordinateFromBinf(-0.5, axis));

    EXPECT_EQ(8.0, FrameUtil::coordinateToBinf(3.0, axis));
    EXPECT_EQ(3.0, FrameUtil::coordinateFromBinf(8.0, axis));

    EXPECT_EQ(8.5, FrameUtil::coordinateToBinf(3.5, axis));
    EXPECT_EQ(3.5, FrameUtil::coordinateFromBinf(8.5, axis));
}
