#!/usr/bin/env python3
"""
Plot |F(q)| vs q for sphere.

"""
import bornagain as ba
import numpy as np
from matplotlib import pyplot as plt
from bornagain import ba_plot as bp, deg, nm, C3

if __name__ == '__main__':
    ff = ba.Sphere(1, True)
    qmax = 32

    v = ff.volume()
    n = <%= test_mode ? 11 : 1000 %>
    x = [qmax*i/(n - 1) for i in range(n)]
    y = [ff.formfactor(C3(q, 0, 0)).real/v for q in x]
    ym = [-f for f in y]

    plt.semilogy(x, y)
    plt.semilogy(x, ym)

    plt.xlim([0, qmax])
    plt.ylim([5e-5, 2])

    label_fontsize = 18
    plt.xlabel("$qR$", fontsize=label_fontsize)
    plt.ylabel("$|F(q)|$", fontsize=label_fontsize)

    plt.tight_layout()
    <%- if test_mode or figure_mode -%>
    plotargs = bp.parse_commandline()
    bp.export(**plotargs)
    <%- else -%>
    plt.show()
    <%- end -%>
