// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/views/views_export.h"
#include "ui/wm/public/masked_window_targeter.h"

namespace aura {
class Window;
}

namespace views {
class BubbleDelegateView;

// A convenient window-targeter that uses a mask based on the content-bounds of
// the bubble-frame.
class VIEWS_EXPORT BubbleWindowTargeter
    : public NON_EXPORTED_BASE(wm::MaskedWindowTargeter) {
 public:
  explicit BubbleWindowTargeter(BubbleDelegateView* bubble);
  virtual ~BubbleWindowTargeter();

 private:
  // wm::MaskedWindowTargeter:
  virtual bool GetHitTestMask(aura::Window* window,
                              gfx::Path* mask) const OVERRIDE;

  views::BubbleDelegateView* bubble_;

  DISALLOW_COPY_AND_ASSIGN(BubbleWindowTargeter);
};

}  // namespace views
