/****************************************************************************
 *    lib/c/Compiler.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Compiler.h"

namespace C {

Compiler::Compiler(Coala::CompilerOptions* options) {
	options_ = options;

	change_input(options_->getInputStream());
	
	printer_ = new Printer(options_->getOutputStream(), options_->getDebug(), options_->getFakeClassicalNegation(), options_->getIncremental(), options_->getReverseIncremental(), !options_->getWhereCheck(), !options_->getDirectEncoding(), options_->getLanguage());
}

Compiler::~Compiler() {

}

int Compiler::compile() {
	preProcessing(options_);
	int result = yyparse();
	postProcessing(printer_);
	
	return result;
}

int Compiler::yylex() {
	int token = lexer.yylex();

	if(token == IDENTIFIER)	yylval.str = new string(lexer.YYText());
	else if(token == NEG_IDENTI) {
			// remove leading negation sign '-' from fluent
			string *tmp_str = new string(lexer.YYText());
			tmp_str->erase(0,1); 
			
			yylval.str = tmp_str;
	}
	else if(token == VARIABLE) {
			yylval.str = new string(lexer.YYText());
	}
	else if(token == NUMBER) yylval.number = atoi(lexer.YYText());
		

	yylloc.first_line = lexer.lineno();
	yylloc.last_line = lexer.lineno();
	yylloc.text = (char *)lexer.YYText();

	return token;
}

void Compiler::yyerror(char *m) {
//	if(yylloc.text == "\n") yylloc.text = (char*)"[newline]";
	cerr << "\n\nError: Syntax error in line "<<yylloc.first_line<<" before token '"<<yylloc.text<<"'.\n";
	
	yyparse();
}

void Compiler::change_input(std::istream* new_in) {
	lexer.switch_streams(new_in, 0);
}

}
