/*
 * Copyright 2010 Google Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */
package com.google.java.contract.util;

/**
 * Utilities for objects.
 *
 * <p>These methods are intentionally name-compatible with
 * {@link com.google.common.base.Objects}, so as to make it easy
 * to switch between them.
 *
 * @author nhat.minh.le@huoc.org (Nhat Minh Lê)
 */
public final class Objects {
  private Objects() {
  }

  /**
   * Returns {@code true} if both its arguments are {@code null} or
   * they compare equal.
   */
  public static <T> boolean equal(T a, T b) {
    return a == null && b == null || a.equals(b);
  }
}
