/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::abstractValues__option_t::type& Options::operator[](
    options::abstractValues__option_t) const
{
  return d_holder->abstractValues;
}
template <> bool Options::wasSetByUser(options::abstractValues__option_t) const
{
  return d_holder->abstractValues__setByUser__;
}
template <> const options::bitblastStep__option_t::type& Options::operator[](
    options::bitblastStep__option_t) const
{
  return d_holder->bitblastStep;
}
template <> bool Options::wasSetByUser(options::bitblastStep__option_t) const
{
  return d_holder->bitblastStep__setByUser__;
}
template <> const options::bvSatConflictStep__option_t::type& Options::operator[](
    options::bvSatConflictStep__option_t) const
{
  return d_holder->bvSatConflictStep;
}
template <> bool Options::wasSetByUser(options::bvSatConflictStep__option_t) const
{
  return d_holder->bvSatConflictStep__setByUser__;
}
template <> const options::checkModels__option_t::type& Options::operator[](
    options::checkModels__option_t) const
{
  return d_holder->checkModels;
}
template <> bool Options::wasSetByUser(options::checkModels__option_t) const
{
  return d_holder->checkModels__setByUser__;
}
template <> void Options::set(
    options::checkProofs__option_t,
    const options::checkProofs__option_t::type& x)
{
  d_holder->checkProofs = x;
}
template <> const options::checkProofs__option_t::type& Options::operator[](
    options::checkProofs__option_t) const
{
  return d_holder->checkProofs;
}
template <> bool Options::wasSetByUser(options::checkProofs__option_t) const
{
  return d_holder->checkProofs__setByUser__;
}
template <> const options::checkSynthSol__option_t::type& Options::operator[](
    options::checkSynthSol__option_t) const
{
  return d_holder->checkSynthSol;
}
template <> bool Options::wasSetByUser(options::checkSynthSol__option_t) const
{
  return d_holder->checkSynthSol__setByUser__;
}
template <> void Options::set(
    options::checkUnsatCores__option_t,
    const options::checkUnsatCores__option_t::type& x)
{
  d_holder->checkUnsatCores = x;
}
template <> const options::checkUnsatCores__option_t::type& Options::operator[](
    options::checkUnsatCores__option_t) const
{
  return d_holder->checkUnsatCores;
}
template <> bool Options::wasSetByUser(options::checkUnsatCores__option_t) const
{
  return d_holder->checkUnsatCores__setByUser__;
}
template <> const options::cnfStep__option_t::type& Options::operator[](
    options::cnfStep__option_t) const
{
  return d_holder->cnfStep;
}
template <> bool Options::wasSetByUser(options::cnfStep__option_t) const
{
  return d_holder->cnfStep__setByUser__;
}
template <> const options::cpuTime__option_t::type& Options::operator[](
    options::cpuTime__option_t) const
{
  return d_holder->cpuTime;
}
template <> bool Options::wasSetByUser(options::cpuTime__option_t) const
{
  return d_holder->cpuTime__setByUser__;
}
template <> const options::decisionStep__option_t::type& Options::operator[](
    options::decisionStep__option_t) const
{
  return d_holder->decisionStep;
}
template <> bool Options::wasSetByUser(options::decisionStep__option_t) const
{
  return d_holder->decisionStep__setByUser__;
}
template <> const options::diagnosticChannelName__option_t::type& Options::operator[](
    options::diagnosticChannelName__option_t) const
{
  return d_holder->diagnosticChannelName;
}
template <> bool Options::wasSetByUser(options::diagnosticChannelName__option_t) const
{
  return d_holder->diagnosticChannelName__setByUser__;
}
template <> const options::dumpInstantiations__option_t::type& Options::operator[](
    options::dumpInstantiations__option_t) const
{
  return d_holder->dumpInstantiations;
}
template <> bool Options::wasSetByUser(options::dumpInstantiations__option_t) const
{
  return d_holder->dumpInstantiations__setByUser__;
}
template <> const options::dumpModels__option_t::type& Options::operator[](
    options::dumpModels__option_t) const
{
  return d_holder->dumpModels;
}
template <> bool Options::wasSetByUser(options::dumpModels__option_t) const
{
  return d_holder->dumpModels__setByUser__;
}
template <> const options::dumpProofs__option_t::type& Options::operator[](
    options::dumpProofs__option_t) const
{
  return d_holder->dumpProofs;
}
template <> bool Options::wasSetByUser(options::dumpProofs__option_t) const
{
  return d_holder->dumpProofs__setByUser__;
}
template <> void Options::set(
    options::dumpSynth__option_t,
    const options::dumpSynth__option_t::type& x)
{
  d_holder->dumpSynth = x;
}
template <> const options::dumpSynth__option_t::type& Options::operator[](
    options::dumpSynth__option_t) const
{
  return d_holder->dumpSynth;
}
template <> bool Options::wasSetByUser(options::dumpSynth__option_t) const
{
  return d_holder->dumpSynth__setByUser__;
}
template <> const options::dumpToFileName__option_t::type& Options::operator[](
    options::dumpToFileName__option_t) const
{
  return d_holder->dumpToFileName;
}
template <> bool Options::wasSetByUser(options::dumpToFileName__option_t) const
{
  return d_holder->dumpToFileName__setByUser__;
}
template <> const options::dumpUnsatCores__option_t::type& Options::operator[](
    options::dumpUnsatCores__option_t) const
{
  return d_holder->dumpUnsatCores;
}
template <> bool Options::wasSetByUser(options::dumpUnsatCores__option_t) const
{
  return d_holder->dumpUnsatCores__setByUser__;
}
template <> const options::dumpUnsatCoresFull__option_t::type& Options::operator[](
    options::dumpUnsatCoresFull__option_t) const
{
  return d_holder->dumpUnsatCoresFull;
}
template <> bool Options::wasSetByUser(options::dumpUnsatCoresFull__option_t) const
{
  return d_holder->dumpUnsatCoresFull__setByUser__;
}
template <> const options::dumpModeString__option_t::type& Options::operator[](
    options::dumpModeString__option_t) const
{
  return d_holder->dumpModeString;
}
template <> bool Options::wasSetByUser(options::dumpModeString__option_t) const
{
  return d_holder->dumpModeString__setByUser__;
}
template <> const options::expandDefinitions__option_t::type& Options::operator[](
    options::expandDefinitions__option_t) const
{
  return d_holder->expandDefinitions;
}
template <> bool Options::wasSetByUser(options::expandDefinitions__option_t) const
{
  return d_holder->expandDefinitions__setByUser__;
}
template <> void Options::set(
    options::extRewPrep__option_t,
    const options::extRewPrep__option_t::type& x)
{
  d_holder->extRewPrep = x;
}
template <> const options::extRewPrep__option_t::type& Options::operator[](
    options::extRewPrep__option_t) const
{
  return d_holder->extRewPrep;
}
template <> bool Options::wasSetByUser(options::extRewPrep__option_t) const
{
  return d_holder->extRewPrep__setByUser__;
}
template <> void Options::set(
    options::extRewPrepAgg__option_t,
    const options::extRewPrepAgg__option_t::type& x)
{
  d_holder->extRewPrepAgg = x;
}
template <> const options::extRewPrepAgg__option_t::type& Options::operator[](
    options::extRewPrepAgg__option_t) const
{
  return d_holder->extRewPrepAgg;
}
template <> bool Options::wasSetByUser(options::extRewPrepAgg__option_t) const
{
  return d_holder->extRewPrepAgg__setByUser__;
}
template <> const options::forceLogicString__option_t::type& Options::operator[](
    options::forceLogicString__option_t) const
{
  return d_holder->forceLogicString;
}
template <> bool Options::wasSetByUser(options::forceLogicString__option_t) const
{
  return d_holder->forceLogicString__setByUser__;
}
template <> const options::forceNoLimitCpuWhileDump__option_t::type& Options::operator[](
    options::forceNoLimitCpuWhileDump__option_t) const
{
  return d_holder->forceNoLimitCpuWhileDump;
}
template <> bool Options::wasSetByUser(options::forceNoLimitCpuWhileDump__option_t) const
{
  return d_holder->forceNoLimitCpuWhileDump__setByUser__;
}
template <> const options::hardLimit__option_t::type& Options::operator[](
    options::hardLimit__option_t) const
{
  return d_holder->hardLimit;
}
template <> bool Options::wasSetByUser(options::hardLimit__option_t) const
{
  return d_holder->hardLimit__setByUser__;
}
template <> const options::incrementalSolving__option_t::type& Options::operator[](
    options::incrementalSolving__option_t) const
{
  return d_holder->incrementalSolving;
}
template <> bool Options::wasSetByUser(options::incrementalSolving__option_t) const
{
  return d_holder->incrementalSolving__setByUser__;
}
template <> void Options::set(
    options::interactiveMode__option_t,
    const options::interactiveMode__option_t::type& x)
{
  d_holder->interactiveMode = x;
}
template <> const options::interactiveMode__option_t::type& Options::operator[](
    options::interactiveMode__option_t) const
{
  return d_holder->interactiveMode;
}
template <> bool Options::wasSetByUser(options::interactiveMode__option_t) const
{
  return d_holder->interactiveMode__setByUser__;
}
template <> void Options::set(
    options::doITESimp__option_t,
    const options::doITESimp__option_t::type& x)
{
  d_holder->doITESimp = x;
}
template <> const options::doITESimp__option_t::type& Options::operator[](
    options::doITESimp__option_t) const
{
  return d_holder->doITESimp;
}
template <> bool Options::wasSetByUser(options::doITESimp__option_t) const
{
  return d_holder->doITESimp__setByUser__;
}
template <> const options::lemmaStep__option_t::type& Options::operator[](
    options::lemmaStep__option_t) const
{
  return d_holder->lemmaStep;
}
template <> bool Options::wasSetByUser(options::lemmaStep__option_t) const
{
  return d_holder->lemmaStep__setByUser__;
}
template <> const options::modelUninterpDtEnum__option_t::type& Options::operator[](
    options::modelUninterpDtEnum__option_t) const
{
  return d_holder->modelUninterpDtEnum;
}
template <> bool Options::wasSetByUser(options::modelUninterpDtEnum__option_t) const
{
  return d_holder->modelUninterpDtEnum__setByUser__;
}
template <> const options::omitDontCares__option_t::type& Options::operator[](
    options::omitDontCares__option_t) const
{
  return d_holder->omitDontCares;
}
template <> bool Options::wasSetByUser(options::omitDontCares__option_t) const
{
  return d_holder->omitDontCares__setByUser__;
}
template <> void Options::set(
    options::doITESimpOnRepeat__option_t,
    const options::doITESimpOnRepeat__option_t::type& x)
{
  d_holder->doITESimpOnRepeat = x;
}
template <> const options::doITESimpOnRepeat__option_t::type& Options::operator[](
    options::doITESimpOnRepeat__option_t) const
{
  return d_holder->doITESimpOnRepeat;
}
template <> bool Options::wasSetByUser(options::doITESimpOnRepeat__option_t) const
{
  return d_holder->doITESimpOnRepeat__setByUser__;
}
template <> const options::parseStep__option_t::type& Options::operator[](
    options::parseStep__option_t) const
{
  return d_holder->parseStep;
}
template <> bool Options::wasSetByUser(options::parseStep__option_t) const
{
  return d_holder->parseStep__setByUser__;
}
template <> const options::preprocessStep__option_t::type& Options::operator[](
    options::preprocessStep__option_t) const
{
  return d_holder->preprocessStep;
}
template <> bool Options::wasSetByUser(options::preprocessStep__option_t) const
{
  return d_holder->preprocessStep__setByUser__;
}
template <> void Options::set(
    options::produceAssertions__option_t,
    const options::produceAssertions__option_t::type& x)
{
  d_holder->produceAssertions = x;
}
template <> const options::produceAssertions__option_t::type& Options::operator[](
    options::produceAssertions__option_t) const
{
  return d_holder->produceAssertions;
}
template <> bool Options::wasSetByUser(options::produceAssertions__option_t) const
{
  return d_holder->produceAssertions__setByUser__;
}
template <> const options::produceAssignments__option_t::type& Options::operator[](
    options::produceAssignments__option_t) const
{
  return d_holder->produceAssignments;
}
template <> bool Options::wasSetByUser(options::produceAssignments__option_t) const
{
  return d_holder->produceAssignments__setByUser__;
}
template <> const options::produceModels__option_t::type& Options::operator[](
    options::produceModels__option_t) const
{
  return d_holder->produceModels;
}
template <> bool Options::wasSetByUser(options::produceModels__option_t) const
{
  return d_holder->produceModels__setByUser__;
}
template <> const options::unsatAssumptions__option_t::type& Options::operator[](
    options::unsatAssumptions__option_t) const
{
  return d_holder->unsatAssumptions;
}
template <> bool Options::wasSetByUser(options::unsatAssumptions__option_t) const
{
  return d_holder->unsatAssumptions__setByUser__;
}
template <> const options::unsatCores__option_t::type& Options::operator[](
    options::unsatCores__option_t) const
{
  return d_holder->unsatCores;
}
template <> bool Options::wasSetByUser(options::unsatCores__option_t) const
{
  return d_holder->unsatCores__setByUser__;
}
template <> const options::proof__option_t::type& Options::operator[](
    options::proof__option_t) const
{
  return d_holder->proof;
}
template <> bool Options::wasSetByUser(options::proof__option_t) const
{
  return d_holder->proof__setByUser__;
}
template <> const options::quantifierStep__option_t::type& Options::operator[](
    options::quantifierStep__option_t) const
{
  return d_holder->quantifierStep;
}
template <> bool Options::wasSetByUser(options::quantifierStep__option_t) const
{
  return d_holder->quantifierStep__setByUser__;
}
template <> const options::regularChannelName__option_t::type& Options::operator[](
    options::regularChannelName__option_t) const
{
  return d_holder->regularChannelName;
}
template <> bool Options::wasSetByUser(options::regularChannelName__option_t) const
{
  return d_holder->regularChannelName__setByUser__;
}
template <> void Options::set(
    options::repeatSimp__option_t,
    const options::repeatSimp__option_t::type& x)
{
  d_holder->repeatSimp = x;
}
template <> const options::repeatSimp__option_t::type& Options::operator[](
    options::repeatSimp__option_t) const
{
  return d_holder->repeatSimp;
}
template <> bool Options::wasSetByUser(options::repeatSimp__option_t) const
{
  return d_holder->repeatSimp__setByUser__;
}
template <> const options::replayLogFilename__option_t::type& Options::operator[](
    options::replayLogFilename__option_t) const
{
  return d_holder->replayLogFilename;
}
template <> bool Options::wasSetByUser(options::replayLogFilename__option_t) const
{
  return d_holder->replayLogFilename__setByUser__;
}
template <> const options::replayInputFilename__option_t::type& Options::operator[](
    options::replayInputFilename__option_t) const
{
  return d_holder->replayInputFilename;
}
template <> bool Options::wasSetByUser(options::replayInputFilename__option_t) const
{
  return d_holder->replayInputFilename__setByUser__;
}
template <> const options::restartStep__option_t::type& Options::operator[](
    options::restartStep__option_t) const
{
  return d_holder->restartStep;
}
template <> bool Options::wasSetByUser(options::restartStep__option_t) const
{
  return d_holder->restartStep__setByUser__;
}
template <> const options::rewriteApplyToConst__option_t::type& Options::operator[](
    options::rewriteApplyToConst__option_t) const
{
  return d_holder->rewriteApplyToConst;
}
template <> bool Options::wasSetByUser(options::rewriteApplyToConst__option_t) const
{
  return d_holder->rewriteApplyToConst__setByUser__;
}
template <> const options::rewriteStep__option_t::type& Options::operator[](
    options::rewriteStep__option_t) const
{
  return d_holder->rewriteStep;
}
template <> bool Options::wasSetByUser(options::rewriteStep__option_t) const
{
  return d_holder->rewriteStep__setByUser__;
}
template <> const options::perCallResourceLimit__option_t::type& Options::operator[](
    options::perCallResourceLimit__option_t) const
{
  return d_holder->perCallResourceLimit;
}
template <> bool Options::wasSetByUser(options::perCallResourceLimit__option_t) const
{
  return d_holder->perCallResourceLimit__setByUser__;
}
template <> const options::cumulativeResourceLimit__option_t::type& Options::operator[](
    options::cumulativeResourceLimit__option_t) const
{
  return d_holder->cumulativeResourceLimit;
}
template <> bool Options::wasSetByUser(options::cumulativeResourceLimit__option_t) const
{
  return d_holder->cumulativeResourceLimit__setByUser__;
}
template <> const options::satConflictStep__option_t::type& Options::operator[](
    options::satConflictStep__option_t) const
{
  return d_holder->satConflictStep;
}
template <> bool Options::wasSetByUser(options::satConflictStep__option_t) const
{
  return d_holder->satConflictStep__setByUser__;
}
template <> void Options::set(
    options::compressItes__option_t,
    const options::compressItes__option_t::type& x)
{
  d_holder->compressItes = x;
}
template <> const options::compressItes__option_t::type& Options::operator[](
    options::compressItes__option_t) const
{
  return d_holder->compressItes;
}
template <> bool Options::wasSetByUser(options::compressItes__option_t) const
{
  return d_holder->compressItes__setByUser__;
}
template <> const options::zombieHuntThreshold__option_t::type& Options::operator[](
    options::zombieHuntThreshold__option_t) const
{
  return d_holder->zombieHuntThreshold;
}
template <> bool Options::wasSetByUser(options::zombieHuntThreshold__option_t) const
{
  return d_holder->zombieHuntThreshold__setByUser__;
}
template <> void Options::set(
    options::simplifyWithCareEnabled__option_t,
    const options::simplifyWithCareEnabled__option_t::type& x)
{
  d_holder->simplifyWithCareEnabled = x;
}
template <> const options::simplifyWithCareEnabled__option_t::type& Options::operator[](
    options::simplifyWithCareEnabled__option_t) const
{
  return d_holder->simplifyWithCareEnabled;
}
template <> bool Options::wasSetByUser(options::simplifyWithCareEnabled__option_t) const
{
  return d_holder->simplifyWithCareEnabled__setByUser__;
}
template <> void Options::set(
    options::simplificationMode__option_t,
    const options::simplificationMode__option_t::type& x)
{
  d_holder->simplificationMode = x;
}
template <> const options::simplificationMode__option_t::type& Options::operator[](
    options::simplificationMode__option_t) const
{
  return d_holder->simplificationMode;
}
template <> bool Options::wasSetByUser(options::simplificationMode__option_t) const
{
  return d_holder->simplificationMode__setByUser__;
}
template <> const options::solveIntAsBV__option_t::type& Options::operator[](
    options::solveIntAsBV__option_t) const
{
  return d_holder->solveIntAsBV;
}
template <> bool Options::wasSetByUser(options::solveIntAsBV__option_t) const
{
  return d_holder->solveIntAsBV__setByUser__;
}
template <> const options::solveRealAsInt__option_t::type& Options::operator[](
    options::solveRealAsInt__option_t) const
{
  return d_holder->solveRealAsInt;
}
template <> bool Options::wasSetByUser(options::solveRealAsInt__option_t) const
{
  return d_holder->solveRealAsInt__setByUser__;
}
template <> void Options::set(
    options::sortInference__option_t,
    const options::sortInference__option_t::type& x)
{
  d_holder->sortInference = x;
}
template <> const options::sortInference__option_t::type& Options::operator[](
    options::sortInference__option_t) const
{
  return d_holder->sortInference;
}
template <> bool Options::wasSetByUser(options::sortInference__option_t) const
{
  return d_holder->sortInference__setByUser__;
}
template <> const options::doStaticLearning__option_t::type& Options::operator[](
    options::doStaticLearning__option_t) const
{
  return d_holder->doStaticLearning;
}
template <> bool Options::wasSetByUser(options::doStaticLearning__option_t) const
{
  return d_holder->doStaticLearning__setByUser__;
}
template <> void Options::set(
    options::sygusOut__option_t,
    const options::sygusOut__option_t::type& x)
{
  d_holder->sygusOut = x;
}
template <> const options::sygusOut__option_t::type& Options::operator[](
    options::sygusOut__option_t) const
{
  return d_holder->sygusOut;
}
template <> bool Options::wasSetByUser(options::sygusOut__option_t) const
{
  return d_holder->sygusOut__setByUser__;
}
template <> const options::sygusPrintCallbacks__option_t::type& Options::operator[](
    options::sygusPrintCallbacks__option_t) const
{
  return d_holder->sygusPrintCallbacks;
}
template <> bool Options::wasSetByUser(options::sygusPrintCallbacks__option_t) const
{
  return d_holder->sygusPrintCallbacks__setByUser__;
}
template <> void Options::set(
    options::symmetryBreakerExp__option_t,
    const options::symmetryBreakerExp__option_t::type& x)
{
  d_holder->symmetryBreakerExp = x;
}
template <> const options::symmetryBreakerExp__option_t::type& Options::operator[](
    options::symmetryBreakerExp__option_t) const
{
  return d_holder->symmetryBreakerExp;
}
template <> bool Options::wasSetByUser(options::symmetryBreakerExp__option_t) const
{
  return d_holder->symmetryBreakerExp__setByUser__;
}
template <> const options::theoryCheckStep__option_t::type& Options::operator[](
    options::theoryCheckStep__option_t) const
{
  return d_holder->theoryCheckStep;
}
template <> bool Options::wasSetByUser(options::theoryCheckStep__option_t) const
{
  return d_holder->theoryCheckStep__setByUser__;
}
template <> const options::perCallMillisecondLimit__option_t::type& Options::operator[](
    options::perCallMillisecondLimit__option_t) const
{
  return d_holder->perCallMillisecondLimit;
}
template <> bool Options::wasSetByUser(options::perCallMillisecondLimit__option_t) const
{
  return d_holder->perCallMillisecondLimit__setByUser__;
}
template <> const options::cumulativeMillisecondLimit__option_t::type& Options::operator[](
    options::cumulativeMillisecondLimit__option_t) const
{
  return d_holder->cumulativeMillisecondLimit;
}
template <> bool Options::wasSetByUser(options::cumulativeMillisecondLimit__option_t) const
{
  return d_holder->cumulativeMillisecondLimit__setByUser__;
}
template <> void Options::set(
    options::unconstrainedSimp__option_t,
    const options::unconstrainedSimp__option_t::type& x)
{
  d_holder->unconstrainedSimp = x;
}
template <> const options::unconstrainedSimp__option_t::type& Options::operator[](
    options::unconstrainedSimp__option_t) const
{
  return d_holder->unconstrainedSimp;
}
template <> bool Options::wasSetByUser(options::unconstrainedSimp__option_t) const
{
  return d_holder->unconstrainedSimp__setByUser__;
}


namespace options {

struct abstractValues__option_t abstractValues;
struct bitblastStep__option_t bitblastStep;
struct bvSatConflictStep__option_t bvSatConflictStep;
struct checkModels__option_t checkModels;
struct checkProofs__option_t checkProofs;
struct checkSynthSol__option_t checkSynthSol;
struct checkUnsatCores__option_t checkUnsatCores;
struct cnfStep__option_t cnfStep;
struct cpuTime__option_t cpuTime;
struct decisionStep__option_t decisionStep;
struct diagnosticChannelName__option_t diagnosticChannelName;
struct dumpInstantiations__option_t dumpInstantiations;
struct dumpModels__option_t dumpModels;
struct dumpProofs__option_t dumpProofs;
struct dumpSynth__option_t dumpSynth;
struct dumpToFileName__option_t dumpToFileName;
struct dumpUnsatCores__option_t dumpUnsatCores;
struct dumpUnsatCoresFull__option_t dumpUnsatCoresFull;
struct dumpModeString__option_t dumpModeString;
struct expandDefinitions__option_t expandDefinitions;
struct extRewPrep__option_t extRewPrep;
struct extRewPrepAgg__option_t extRewPrepAgg;
struct forceLogicString__option_t forceLogicString;
struct forceNoLimitCpuWhileDump__option_t forceNoLimitCpuWhileDump;
struct hardLimit__option_t hardLimit;
struct incrementalSolving__option_t incrementalSolving;
struct interactiveMode__option_t interactiveMode;
struct doITESimp__option_t doITESimp;
struct lemmaStep__option_t lemmaStep;
struct modelUninterpDtEnum__option_t modelUninterpDtEnum;
struct omitDontCares__option_t omitDontCares;
struct doITESimpOnRepeat__option_t doITESimpOnRepeat;
struct parseStep__option_t parseStep;
struct preprocessStep__option_t preprocessStep;
struct produceAssertions__option_t produceAssertions;
struct produceAssignments__option_t produceAssignments;
struct produceModels__option_t produceModels;
struct unsatAssumptions__option_t unsatAssumptions;
struct unsatCores__option_t unsatCores;
struct proof__option_t proof;
struct quantifierStep__option_t quantifierStep;
struct regularChannelName__option_t regularChannelName;
struct repeatSimp__option_t repeatSimp;
struct replayLogFilename__option_t replayLogFilename;
struct replayInputFilename__option_t replayInputFilename;
struct restartStep__option_t restartStep;
struct rewriteApplyToConst__option_t rewriteApplyToConst;
struct rewriteStep__option_t rewriteStep;
struct perCallResourceLimit__option_t perCallResourceLimit;
struct cumulativeResourceLimit__option_t cumulativeResourceLimit;
struct satConflictStep__option_t satConflictStep;
struct compressItes__option_t compressItes;
struct zombieHuntThreshold__option_t zombieHuntThreshold;
struct simplifyWithCareEnabled__option_t simplifyWithCareEnabled;
struct simplificationMode__option_t simplificationMode;
struct solveIntAsBV__option_t solveIntAsBV;
struct solveRealAsInt__option_t solveRealAsInt;
struct sortInference__option_t sortInference;
struct doStaticLearning__option_t doStaticLearning;
struct sygusOut__option_t sygusOut;
struct sygusPrintCallbacks__option_t sygusPrintCallbacks;
struct symmetryBreakerExp__option_t symmetryBreakerExp;
struct theoryCheckStep__option_t theoryCheckStep;
struct perCallMillisecondLimit__option_t perCallMillisecondLimit;
struct cumulativeMillisecondLimit__option_t cumulativeMillisecondLimit;
struct unconstrainedSimp__option_t unconstrainedSimp;


}  // namespace options
}  // namespace CVC4
