/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************
 *
 **/
/**
  * Object s()
  * @type s
  * @super Object
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535890.aspx
*/

function s(){};
s.prototype= new Object();
/**
  * Property accessKey
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533062.aspx
*/

s.prototype.accessKey="";
/**
  * Property canHaveChildren
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533546.aspx
*/

s.prototype.canHaveChildren=false;
/**
  * Property canHaveHTML
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537836.aspx
*/

s.prototype.canHaveHTML=false;
/**
  * Property className
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533560.aspx
*/

s.prototype.className="";
/**
  * Property clientHeight
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533563.aspx
*/

s.prototype.clientHeight=0;
/**
  * Property clientLeft
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533564.aspx
*/

s.prototype.clientLeft=0;
/**
  * Property offsetLeft
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534200.aspx
*/

s.prototype.offsetLeft=0;
/**
  * Property clientTop
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533565.aspx
*/

s.prototype.clientTop=0;
/**
  * Property offsetTop
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534303.aspx
*/

s.prototype.offsetTop=0;
/**
  * Property clientWidth
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533566.aspx
*/

s.prototype.clientWidth=0;
/**
  * Property contentEditable
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537837.aspx
*/

s.prototype.contentEditable="";
/**
  * Property dir
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533728.aspx
*/

s.prototype.dir="";
/**
  * Property firstChild
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533755.aspx
*/

s.prototype.firstChild=new Object();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

s.prototype.childNodes= new childNodes();
/**
  * Property hideFocus
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533783.aspx
*/

s.prototype.hideFocus=false;
/**
  * Property id
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533880.aspx
*/

s.prototype.id="";
/**
  * Property innerHTML
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533897.aspx
*/

s.prototype.innerHTML="";
/**
  * Property innerText
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533899.aspx
*/

s.prototype.innerText="";
/**
  * Property isContentEditable
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537838.aspx
*/

s.prototype.isContentEditable=false;
/**
  * Property isDisabled
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533902.aspx
*/

s.prototype.isDisabled=false;
/**
  * Property isMultiLine
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537839.aspx
*/

s.prototype.isMultiLine=false;
/**
  * Property isTextEdit
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533920.aspx
*/

s.prototype.isTextEdit=false;
/**
  * Property TextRange
  * @type TextRange
  * @returns {TextRange}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535872.aspx
*/

s.prototype.TextRange= new TextRange();
/**
  * Property lang
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533935.aspx
*/

s.prototype.lang="";
/**
  * Property language
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533940.aspx
*/

s.prototype.language="";
/**
  * Property lastChild
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533943.aspx
*/

s.prototype.lastChild=new Object();
/**
  * Property nextSibling
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534189.aspx
*/

s.prototype.nextSibling=new Object();
/**
  * Property nodeName
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534190.aspx
*/

s.prototype.nodeName="";
/**
  * Property nodeType
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534191.aspx
*/

s.prototype.nodeType=0;
/**
  * Property nodeValue
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534192.aspx
*/

s.prototype.nodeValue=new Object();
/**
  * Property offsetHeight
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534199.aspx
*/

s.prototype.offsetHeight=0;
/**
  * Property offsetParent
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534302.aspx
*/

s.prototype.offsetParent=new Object();
/**
  * Property offsetWidth
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534304.aspx
*/

s.prototype.offsetWidth=0;
/**
  * Property onOffBehavior
  * @type DABoolean
  * @returns {DABoolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533630.aspx
*/

s.prototype.onOffBehavior=new DABoolean();
/**
  * Property outerHTML
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534310.aspx
*/

s.prototype.outerHTML="";
/**
  * Property outerText
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534311.aspx
*/

s.prototype.outerText="";
/**
  * Property ownerDocument
  * @type document
  * @returns {document}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534315.aspx
*/

s.prototype.ownerDocument=new document();
/**
  * Property document
  * @type document
  * @returns {document}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531073.aspx
*/

s.prototype.document= new document();
/**
  * Property parentElement
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534327.aspx
*/

s.prototype.parentElement=new Object();
/**
  * Property parentNode
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534328.aspx
*/

s.prototype.parentNode=new Object();
/**
  * Property parentTextEdit
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534330.aspx
*/

s.prototype.parentTextEdit=new Object();
/**
  * Property previousSibling
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534350.aspx
*/

s.prototype.previousSibling=new Object();
/**
  * Property readyState
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534358.aspx
*/

s.prototype.readyState=new Object();
/**
  * Property scopeName
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534388.aspx
*/

s.prototype.scopeName="";
/**
  * Property scrollHeight
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534615.aspx
*/

s.prototype.scrollHeight=new Object();
/**
  * Property scrollLeft
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534617.aspx
*/

s.prototype.scrollLeft=0;
/**
  * Property scrollTop
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534618.aspx
*/

s.prototype.scrollTop=0;
/**
  * Property scrollWidth
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534619.aspx
*/

s.prototype.scrollWidth=new Object();
/**
  * Property sourceIndex
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534635.aspx
*/

s.prototype.sourceIndex=0;
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

s.prototype.all= new all();
/**
  * Property tabIndex
  * @type Number
  * @returns {Number}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534654.aspx
*/

s.prototype.tabIndex=0;
/**
  * Property tagName
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534657.aspx
*/

s.prototype.tagName="";
/**
  * Property tagUrn
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534658.aspx
*/

s.prototype.tagUrn="";
/**
  * Property title
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534683.aspx
*/

s.prototype.title="";
/**
  * Property uniqueID
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534704.aspx
*/

s.prototype.uniqueID="";
/**
  * function addBehavior(sUrl)
  * @param {String} sUrl
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535922.aspx
*/

s.prototype.addBehavior=function(sUrl){};
/**
  * function appendChild(oNode)
  * @param {appendChild} oNode
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535934.aspx
*/

s.prototype.appendChild=function(oNode){};
/**
  * function applyElement(oNewElement)
  * @param {String} oNewElement
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536341.aspx
*/

s.prototype.applyElement=function(oNewElement){};
/**
  * function attachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {Boolean} fpNotify
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536343.aspx
*/

s.prototype.attachEvent=function(sEvent,fpNotify){};
/**
  * function blur()
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536347.aspx
*/

s.prototype.blur=function(){};
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

s.prototype.onblur= new onblur();
/**
  * function clearAttributes()
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536350.aspx
*/

s.prototype.clearAttributes=function(){};
/**
  * function click()
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536363.aspx
*/

s.prototype.click=function(){};
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

s.prototype.onclick= new onclick();
/**
  * function cloneNode(bCloneChildren)
  * @param {Boolean} bCloneChildren
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536365.aspx
*/

s.prototype.cloneNode=function(bCloneChildren){};
/**
  * function componentFromPoint(iCoordX,iCoordY)
  * @param {Number} iCoordX
  * @param {Number} iCoordY
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536375.aspx
*/

s.prototype.componentFromPoint=function(iCoordX,iCoordY){};
/**
  * function contains(oElement)
  * @param {Boolean} oElement
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536377.aspx
*/

s.prototype.contains=function(oElement){};
/**
  * function detachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {attachEvent} fpNotify
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536411.aspx
*/

s.prototype.detachEvent=function(sEvent,fpNotify){};
/**
  * function fireEvent(sEvent,oEventObject)
  * @param {String} sEvent
  * @param {event} oEventObject
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536423.aspx
*/

s.prototype.fireEvent=function(sEvent,oEventObject){};
/**
  * function focus()
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536425.aspx
*/

s.prototype.focus=function(){};
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

s.prototype.onfocus= new onfocus();
/**
  * function getAdjacentText(sWhere)
  * @param {String} sWhere
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536427.aspx
*/

s.prototype.getAdjacentText=function(sWhere){};
/**
  * function getAttribute(sAttrName,iFlags,sAttrName)
  * @param {String} sAttrName
  * @param {Number} iFlags
  * @param {getAttribute} sAttrName
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536429.aspx
*/

s.prototype.getAttribute=function(sAttrName,iFlags,sAttrName){};
/**
  * function getAttributeNode(sName)
  * @param {String} sName
  * @type attribute
  * @returns {attribute}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536430.aspx
*/

s.prototype.getAttributeNode=function(sName){};
/**
  * Property attribute
  * @type attribute
  * @returns {attribute}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535187.aspx
*/

s.prototype.attribute= new attribute();
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534184.aspx
*/

s.prototype.name="";
/**
  * function getBoundingClientRect()
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536433.aspx
*/

s.prototype.getBoundingClientRect=function(){};
/**
  * Property TextRectangle
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535906.aspx
*/

s.prototype.TextRectangle= new TextRectangle();
/**
  * function getClientRects()
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536435.aspx
*/

s.prototype.getClientRects=function(){};
/**
  * function getElementsByTagName(sTagName)
  * @param {String} sTagName
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536439.aspx
*/

s.prototype.getElementsByTagName=function(sTagName){};
/**
  * function getExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358797.aspx
*/

s.prototype.getExpression=function(sPropertyName){};
/**
  * function hasChildNodes()
  * @type HTML Elements
  * @returns {HTML}
 Elements
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536445.aspx
*/

s.prototype.hasChildNodes=function(){};
/**
  * function insertAdjacentElement(sWhere,oElement)
  * @param {String} sWhere
  * @param {insertAdjacentElement} oElement
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536451.aspx
*/

s.prototype.insertAdjacentElement=function(sWhere,oElement){};
/**
  * function insertAdjacentHTML(sWhere,sText)
  * @param {String} sWhere
  * @param {String} sText
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536452.aspx
*/

s.prototype.insertAdjacentHTML=function(sWhere,sText){};
/**
  * function insertAdjacentText(sWhere,sText)
  * @param {String} sWhere
  * @param {String} sText
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536453.aspx
*/

s.prototype.insertAdjacentText=function(sWhere,sText){};
/**
  * function insertBefore(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536454.aspx
*/

s.prototype.insertBefore=function(oNewNode,oChildNode){};
/**
  * function mergeAttributes(oSource,bPreserve)
  * @param {Object} oSource
  * @param {Boolean} bPreserve
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536614.aspx
*/

s.prototype.mergeAttributes=function(oSource,bPreserve){};
/**
  * function normalize()
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536646.aspx
*/

s.prototype.normalize=function(){};
/**
  * function releaseCapture()
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536689.aspx
*/

s.prototype.releaseCapture=function(){};
/**
  * function removeAttribute(sName,iCaseSensitive)
  * @param {String} sName
  * @param {Number} iCaseSensitive
  * @type Boolean
  * @returns {Boolean}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536696.aspx
*/

s.prototype.removeAttribute=function(sName,iCaseSensitive){};
/**
  * function removeAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536698.aspx
*/

s.prototype.removeAttributeNode=function(oSrcAttribute){};
/**
  * function removeBehavior(iID)
  * @param {Number} iID
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536700.aspx
*/

s.prototype.removeBehavior=function(iID){};
/**
  * function removeChild(oNode)
  * @param {Object} oNode
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536702.aspx
*/

s.prototype.removeChild=function(oNode){};
/**
  * function removeExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358798.aspx
*/

s.prototype.removeExpression=function(sPropertyName){};
/**
  * function removeNode(bRemoveChildren)
  * @param {Boolean} bRemoveChildren
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536708.aspx
*/

s.prototype.removeNode=function(bRemoveChildren){};
/**
  * function replaceAdjacentText(sWhere,sReplaceText)
  * @param {String} sWhere
  * @param {String} sReplaceText
  * @type String
  * @returns {String}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536714.aspx
*/

s.prototype.replaceAdjacentText=function(sWhere,sReplaceText){};
/**
  * function replaceChild(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536716.aspx
*/

s.prototype.replaceChild=function(oNewNode,oChildNode){};
/**
  * function replaceNode(oNewNode)
  * @param {Object} oNewNode
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536719.aspx
*/

s.prototype.replaceNode=function(oNewNode){};
/**
  * function scrollIntoView(bAlignToTop)
  * @param {Boolean} bAlignToTop
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536730.aspx
*/

s.prototype.scrollIntoView=function(bAlignToTop){};
/**
  * function setActive()
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536738.aspx
*/

s.prototype.setActive=function(){};
/**
  * function setAttribute(sName,vValue)
  * @param {String} sName
  * @param {Number} vValue
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536739.aspx
*/

s.prototype.setAttribute=function(sName,vValue){};
/**
  * function setAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536741.aspx
*/

s.prototype.setAttributeNode=function(oSrcAttribute){};
/**
  * function setCapture(bContainerCapture)
  * @param {Boolean} bContainerCapture
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536742.aspx
*/

s.prototype.setCapture=function(bContainerCapture){};
/**
  * function setExpression(sPropertyName,sExpression,sLanguage)
  * @param {String} sPropertyName
  * @param {String} sExpression
  * @param {String} sLanguage
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531196.aspx
*/

s.prototype.setExpression=function(sPropertyName,sExpression,sLanguage){};
/**
  * function swapNode(oNode)
  * @param {Object} oNode
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536774.aspx
*/

s.prototype.swapNode=function(oNode){};
/**
  * Property onactivate
  * @type onactivate
  * @returns {onactivate}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536787.aspx
*/

s.prototype.onactivate= new onactivate();
/**
  * Property activeElement
  * @type Object
  * @returns {Object}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533065.aspx
*/

s.prototype.activeElement=new Object();
/**
  * Property onbeforeactivate
  * @type onbeforeactivate
  * @returns {onbeforeactivate}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536791.aspx
*/

s.prototype.onbeforeactivate= new onbeforeactivate();
/**
  * Property onbeforecopy
  * @type onbeforecopy
  * @returns {onbeforecopy}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536901.aspx
*/

s.prototype.onbeforecopy= new onbeforecopy();
/**
  * Property onbeforecut
  * @type onbeforecut
  * @returns {onbeforecut}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536902.aspx
*/

s.prototype.onbeforecut= new onbeforecut();
/**
  * Property onbeforedeactivate
  * @type onbeforedeactivate
  * @returns {onbeforedeactivate}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536903.aspx
*/

s.prototype.onbeforedeactivate= new onbeforedeactivate();
/**
  * Property onbeforeeditfocus
  * @type onbeforeeditfocus
  * @returns {onbeforeeditfocus}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536904.aspx
*/

s.prototype.onbeforeeditfocus= new onbeforeeditfocus();
/**
  * Property onbeforepaste
  * @type onbeforepaste
  * @returns {onbeforepaste}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536905.aspx
*/

s.prototype.onbeforepaste= new onbeforepaste();
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

s.prototype.onblur= new onblur();
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

s.prototype.onclick= new onclick();
/**
  * Property oncontextmenu
  * @type oncontextmenu
  * @returns {oncontextmenu}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536914.aspx
*/

s.prototype.oncontextmenu= new oncontextmenu();
/**
  * Property oncontrolselect
  * @type oncontrolselect
  * @returns {oncontrolselect}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537844.aspx
*/

s.prototype.oncontrolselect= new oncontrolselect();
/**
  * Property oncopy
  * @type oncopy
  * @returns {oncopy}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536916.aspx
*/

s.prototype.oncopy= new oncopy();
/**
  * Property oncut
  * @type oncut
  * @returns {oncut}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536917.aspx
*/

s.prototype.oncut= new oncut();
/**
  * Property ondblclick
  * @type ondblclick
  * @returns {ondblclick}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536921.aspx
*/

s.prototype.ondblclick= new ondblclick();
/**
  * Property ondeactivate
  * @type ondeactivate
  * @returns {ondeactivate}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536922.aspx
*/

s.prototype.ondeactivate= new ondeactivate();
/**
  * Property ondrag
  * @type ondrag
  * @returns {ondrag}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536923.aspx
*/

s.prototype.ondrag= new ondrag();
/**
  * Property ondragend
  * @type ondragend
  * @returns {ondragend}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536924.aspx
*/

s.prototype.ondragend= new ondragend();
/**
  * Property ondragenter
  * @type ondragenter
  * @returns {ondragenter}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536925.aspx
*/

s.prototype.ondragenter= new ondragenter();
/**
  * Property ondragleave
  * @type ondragleave
  * @returns {ondragleave}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536926.aspx
*/

s.prototype.ondragleave= new ondragleave();
/**
  * Property ondragover
  * @type ondragover
  * @returns {ondragover}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536927.aspx
*/

s.prototype.ondragover= new ondragover();
/**
  * Property ondragstart
  * @type ondragstart
  * @returns {ondragstart}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536928.aspx
*/

s.prototype.ondragstart= new ondragstart();
/**
  * Property ondrop
  * @type ondrop
  * @returns {ondrop}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536929.aspx
*/

s.prototype.ondrop= new ondrop();
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

s.prototype.onfocus= new onfocus();
/**
  * Property onfocusin
  * @type onfocusin
  * @returns {onfocusin}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536935.aspx
*/

s.prototype.onfocusin= new onfocusin();
/**
  * Property onfocusout
  * @type onfocusout
  * @returns {onfocusout}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536936.aspx
*/

s.prototype.onfocusout= new onfocusout();
/**
  * Property onhelp
  * @type onhelp
  * @returns {onhelp}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536937.aspx
*/

s.prototype.onhelp= new onhelp();
/**
  * Property onkeydown
  * @type onkeydown
  * @returns {onkeydown}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536938.aspx
*/

s.prototype.onkeydown= new onkeydown();
/**
  * Property onkeypress
  * @type onkeypress
  * @returns {onkeypress}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536939.aspx
*/

s.prototype.onkeypress= new onkeypress();
/**
  * Property onkeyup
  * @type onkeyup
  * @returns {onkeyup}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536940.aspx
*/

s.prototype.onkeyup= new onkeyup();
/**
  * Property onlosecapture
  * @type onlosecapture
  * @returns {onlosecapture}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536943.aspx
*/

s.prototype.onlosecapture= new onlosecapture();
/**
  * Property onmousedown
  * @type onmousedown
  * @returns {onmousedown}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536944.aspx
*/

s.prototype.onmousedown= new onmousedown();
/**
  * Property onmouseenter
  * @type onmouseenter
  * @returns {onmouseenter}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536945.aspx
*/

s.prototype.onmouseenter= new onmouseenter();
/**
  * Property onmouseleave
  * @type onmouseleave
  * @returns {onmouseleave}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536946.aspx
*/

s.prototype.onmouseleave= new onmouseleave();
/**
  * Property onmousemove
  * @type onmousemove
  * @returns {onmousemove}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536947.aspx
*/

s.prototype.onmousemove= new onmousemove();
/**
  * Property onmouseout
  * @type onmouseout
  * @returns {onmouseout}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536948.aspx
*/

s.prototype.onmouseout= new onmouseout();
/**
  * Property onmouseover
  * @type onmouseover
  * @returns {onmouseover}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536949.aspx
*/

s.prototype.onmouseover= new onmouseover();
/**
  * Property onmouseup
  * @type onmouseup
  * @returns {onmouseup}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536950.aspx
*/

s.prototype.onmouseup= new onmouseup();
/**
  * Property onmousewheel
  * @type onmousewheel
  * @returns {onmousewheel}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536951.aspx
*/

s.prototype.onmousewheel= new onmousewheel();
/**
  * Property onmove
  * @type onmove
  * @returns {onmove}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536952.aspx
*/

s.prototype.onmove= new onmove();
/**
  * Property onmoveend
  * @type onmoveend
  * @returns {onmoveend}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536953.aspx
*/

s.prototype.onmoveend= new onmoveend();
/**
  * Property onmovestart
  * @type onmovestart
  * @returns {onmovestart}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536954.aspx
*/

s.prototype.onmovestart= new onmovestart();
/**
  * Property onpaste
  * @type onpaste
  * @returns {onpaste}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536955.aspx
*/

s.prototype.onpaste= new onpaste();
/**
  * Property onpropertychange
  * @type onpropertychange
  * @returns {onpropertychange}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536956.aspx
*/

s.prototype.onpropertychange= new onpropertychange();
/**
  * Property onreadystatechange
  * @type onreadystatechange
  * @returns {onreadystatechange}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536957.aspx
*/

s.prototype.onreadystatechange= new onreadystatechange();
/**
  * Property onresize
  * @type onresize
  * @returns {onresize}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536959.aspx
*/

s.prototype.onresize= new onresize();
/**
  * Property onresizeend
  * @type onresizeend
  * @returns {onresizeend}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536960.aspx
*/

s.prototype.onresizeend= new onresizeend();
/**
  * Property onresizestart
  * @type onresizestart
  * @returns {onresizestart}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536961.aspx
*/

s.prototype.onresizestart= new onresizestart();
/**
  * Property onselectstart
  * @type onselectstart
  * @returns {onselectstart}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536969.aspx
*/

s.prototype.onselectstart= new onselectstart();
/**
  * Property ontimeerror
  * @type ontimeerror
  * @returns {ontimeerror}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533588.aspx
*/

s.prototype.ontimeerror= new ontimeerror();
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

s.prototype.all= new all();
/**
  * Property attributes
  * @type attributes
  * @returns {attributes}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537438.aspx
*/

s.prototype.attributes= new attributes();
/**
  * Property behaviorUrns
  * @type behaviorUrns
  * @returns {behaviorUrns}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537439.aspx
*/

s.prototype.behaviorUrns= new behaviorUrns();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

s.prototype.childNodes= new childNodes();
/**
  * Property TextNode
  * @type TextNode
  * @returns {TextNode}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535905.aspx
*/

s.prototype.TextNode= new TextNode();
/**
  * Property children
  * @type children
  * @returns {children}
  * @memberOf s
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537446.aspx
*/

s.prototype.children= new children();
