!{\src2tex{textfont=tt}}
!!****m* etsf_dielectric/etsf_io_dielectric_copy
!! NAME
!!  etsf_io_dielectric_copy
!!
!! FUNCTION
!!    This routine copy all variable of a group from one file @ncid_from to another
!!    @ncid_to. If a variable is missing in the source file, this does not raise an
!!    error, it is simply skipped. But if a variable in the destination file is not
!!    defined, this will raise an error.
!!
!!    The copy is done per variable. This means that memory occupation is reduced
!!    during the copy.
!!
!!    Normally, copies are pristine copies. But if optional argument @split is
!!    given, then the read values are copied to the specified locations in split
!!    arrays. In that case, the destination variable must have a compatible definition
!!    with the split values.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid_to = 
!!     integer returned by an 'open' NetCDF call. This id must have write access
!!     granted. It will be modified by the routine. The file must be in write
!!     mode (see etsf_io_low_set_write_mode()).
!! * ncid_from = 
!!     integer returned by an 'open' NetCDF call. This id must have read access
!!     granted. It will be left untouched.
!! * dims <type(etsf_dims)> = 
!!     these dimensions correspond to the source_file ones and are used to allocate
!!     temporary arrays in memory during the copy.
!! * split <type(etsf_split)> = (optional) 
!!     if this argument is given, the values in the split definition (e.g. my_kpoints)
!!     are used to put the data in the destination file in a bigger array at the right
!!     placed.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_dielectric_copy(ncid_to, ncid_from, dims, lstat, error_data, &
  & split)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid_to
  integer, intent(in) :: ncid_from
  type(etsf_dims), intent(in) :: dims
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data
  type(etsf_split), optional, intent(in) :: split

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_dielectric_copy'
  type(etsf_split) :: my_split
  integer,allocatable :: varids(:,:)
  integer :: nvarids
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  integer :: istart
  integer :: idim1,idim2,idim3,idim4,idim5,idim6,idim7,idim8
  integer,allocatable :: istop(:)
  integer,allocatable :: jstart(:)
  integer,allocatable :: jend(:)
  type(etsf_dielectric) :: folder


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_dielectric_copy : enter'
!ENDDEBUG

  lstat = .false.
  call etsf_io_low_set_write_mode(ncid_to, lstat, error_data = error_data)
  if (.not. lstat) return
  
  allocate(varids(2,19))
  nvarids = 1
  
  ! Variable 'frequencies_dielectric_function'
  !  allocate and read data
  allocate(folder%frequencies_dielectric_function( &
    & dims%number_of_frequencies_dielectric_function, &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "frequencies_dielectric_function", &
                          & folder%frequencies_dielectric_function, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%frequencies_dielectric_function)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "frequencies_dielectric_function", &
                             & folder%frequencies_dielectric_function, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%frequencies_dielectric_function)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%frequencies_dielectric_function)
  
  lstat = .true.
  ! Variable 'qpoints_dielectric_function'
  !  allocate and read data
  allocate(folder%qpoints_dielectric_function( &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_reduced_dimensions))
  call etsf_io_low_read_var(ncid_from, "qpoints_dielectric_function", &
                          & folder%qpoints_dielectric_function, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%qpoints_dielectric_function)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "qpoints_dielectric_function", &
                             & folder%qpoints_dielectric_function, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%qpoints_dielectric_function)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%qpoints_dielectric_function)
  
  lstat = .true.
  ! Variable 'qpoints_gamma_limit'
  !  allocate and read data
  allocate(folder%qpoints_gamma_limit( &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_reduced_dimensions))
  call etsf_io_low_read_var(ncid_from, "qpoints_gamma_limit", &
                          & folder%qpoints_gamma_limit, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%qpoints_gamma_limit)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "qpoints_gamma_limit", &
                             & folder%qpoints_gamma_limit, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%qpoints_gamma_limit)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%qpoints_gamma_limit)
  
  lstat = .true.
  ! Variable 'dielectric_function'
  !  allocate and read data
  allocate(folder%dielectric_function%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_dielectric_function * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "dielectric_function", &
                          & folder%dielectric_function%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%dielectric_function%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(7), count(7))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(7))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_dielectric_function
      if (.not. associated(split%my_spins)) then
        istop(5)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(5) = size(split%my_spins)
        count(5) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim5 = 1, istop(5), 1
        if (associated(split%my_spins)) then
          start(5)  = split%my_spins(idim5)
        end if
        do idim4 = 1, istop(4), 1
          if (associated(split%my_spins)) then
            start(4)  = split%my_spins(idim4)
          end if
          call etsf_io_low_write_var(ncid_to, "dielectric_function", &
                                   & folder%dielectric_function%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%dielectric_function%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "dielectric_function", &
                               & folder%dielectric_function%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%dielectric_function%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%dielectric_function%data1D)
  
  lstat = .true.
  ! Variable 'dielectric_function_head'
  !  allocate and read data
  allocate(folder%dielectric_function_head%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_dielectric_function * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "dielectric_function_head", &
                          & folder%dielectric_function_head%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%dielectric_function_head%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(5), count(5))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(5))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_dielectric_function
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(2)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(2) = size(split%my_spins)
        count(2) = 1
      end if
      len = len * dims%complex
      do idim3 = 1, istop(3), 1
        if (associated(split%my_spins)) then
          start(3)  = split%my_spins(idim3)
        end if
        do idim2 = 1, istop(2), 1
          if (associated(split%my_spins)) then
            start(2)  = split%my_spins(idim2)
          end if
          call etsf_io_low_write_var(ncid_to, "dielectric_function_head", &
                                   & folder%dielectric_function_head%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%dielectric_function_head%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "dielectric_function_head", &
                               & folder%dielectric_function_head%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%dielectric_function_head%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%dielectric_function_head%data1D)
  
  lstat = .true.
  ! Variable 'dielectric_function_lower_wing'
  !  allocate and read data
  allocate(folder%dielectric_function_lower_wing%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_gamma_limit * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "dielectric_function_lower_wing", &
                          & folder%dielectric_function_lower_wing%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%dielectric_function_lower_wing%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(6), count(6))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(6))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_gamma_limit
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim4 = 1, istop(4), 1
        if (associated(split%my_spins)) then
          start(4)  = split%my_spins(idim4)
        end if
        do idim3 = 1, istop(3), 1
          if (associated(split%my_spins)) then
            start(3)  = split%my_spins(idim3)
          end if
          call etsf_io_low_write_var(ncid_to, "dielectric_function_lower_wing", &
                                   & folder%dielectric_function_lower_wing%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%dielectric_function_lower_wing%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "dielectric_function_lower_wing", &
                               & folder%dielectric_function_lower_wing%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%dielectric_function_lower_wing%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%dielectric_function_lower_wing%data1D)
  
  lstat = .true.
  ! Variable 'dielectric_function_upper_wing'
  !  allocate and read data
  allocate(folder%dielectric_function_upper_wing%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_gamma_limit * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "dielectric_function_upper_wing", &
                          & folder%dielectric_function_upper_wing%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%dielectric_function_upper_wing%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(6), count(6))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(6))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_gamma_limit
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim4 = 1, istop(4), 1
        if (associated(split%my_spins)) then
          start(4)  = split%my_spins(idim4)
        end if
        do idim3 = 1, istop(3), 1
          if (associated(split%my_spins)) then
            start(3)  = split%my_spins(idim3)
          end if
          call etsf_io_low_write_var(ncid_to, "dielectric_function_upper_wing", &
                                   & folder%dielectric_function_upper_wing%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%dielectric_function_upper_wing%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "dielectric_function_upper_wing", &
                               & folder%dielectric_function_upper_wing%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%dielectric_function_upper_wing%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%dielectric_function_upper_wing%data1D)
  
  lstat = .true.
  ! Variable 'inverse_dielectric_function'
  !  allocate and read data
  allocate(folder%inverse_dielectric_function%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_dielectric_function * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "inverse_dielectric_function", &
                          & folder%inverse_dielectric_function%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%inverse_dielectric_function%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(7), count(7))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(7))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_dielectric_function
      if (.not. associated(split%my_spins)) then
        istop(5)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(5) = size(split%my_spins)
        count(5) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim5 = 1, istop(5), 1
        if (associated(split%my_spins)) then
          start(5)  = split%my_spins(idim5)
        end if
        do idim4 = 1, istop(4), 1
          if (associated(split%my_spins)) then
            start(4)  = split%my_spins(idim4)
          end if
          call etsf_io_low_write_var(ncid_to, "inverse_dielectric_function", &
                                   & folder%inverse_dielectric_function%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%inverse_dielectric_function%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "inverse_dielectric_function", &
                               & folder%inverse_dielectric_function%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%inverse_dielectric_function%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%inverse_dielectric_function%data1D)
  
  lstat = .true.
  ! Variable 'inverse_dielectric_function_head'
  !  allocate and read data
  allocate(folder%inverse_dielectric_function_head%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_dielectric_function * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "inverse_dielectric_function_head", &
                          & folder%inverse_dielectric_function_head%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%inverse_dielectric_function_head%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(5), count(5))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(5))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_dielectric_function
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(2)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(2) = size(split%my_spins)
        count(2) = 1
      end if
      len = len * dims%complex
      do idim3 = 1, istop(3), 1
        if (associated(split%my_spins)) then
          start(3)  = split%my_spins(idim3)
        end if
        do idim2 = 1, istop(2), 1
          if (associated(split%my_spins)) then
            start(2)  = split%my_spins(idim2)
          end if
          call etsf_io_low_write_var(ncid_to, "inverse_dielectric_function_head", &
                                   & folder%inverse_dielectric_function_head%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%inverse_dielectric_function_head%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "inverse_dielectric_function_head", &
                               & folder%inverse_dielectric_function_head%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%inverse_dielectric_function_head%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%inverse_dielectric_function_head%data1D)
  
  lstat = .true.
  ! Variable 'inverse_dielectric_function_lower_wing'
  !  allocate and read data
  allocate(folder%inverse_dielectric_function_lower_wing%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_gamma_limit * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "inverse_dielectric_function_lower_wing", &
                          & folder%inverse_dielectric_function_lower_wing%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%inverse_dielectric_function_lower_wing%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(6), count(6))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(6))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_gamma_limit
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim4 = 1, istop(4), 1
        if (associated(split%my_spins)) then
          start(4)  = split%my_spins(idim4)
        end if
        do idim3 = 1, istop(3), 1
          if (associated(split%my_spins)) then
            start(3)  = split%my_spins(idim3)
          end if
          call etsf_io_low_write_var(ncid_to, "inverse_dielectric_function_lower_wing", &
                                   & folder%inverse_dielectric_function_lower_wing%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%inverse_dielectric_function_lower_wing%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "inverse_dielectric_function_lower_wing", &
                               & folder%inverse_dielectric_function_lower_wing%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%inverse_dielectric_function_lower_wing%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%inverse_dielectric_function_lower_wing%data1D)
  
  lstat = .true.
  ! Variable 'inverse_dielectric_function_upper_wing'
  !  allocate and read data
  allocate(folder%inverse_dielectric_function_upper_wing%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_gamma_limit * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "inverse_dielectric_function_upper_wing", &
                          & folder%inverse_dielectric_function_upper_wing%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%inverse_dielectric_function_upper_wing%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(6), count(6))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(6))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_gamma_limit
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim4 = 1, istop(4), 1
        if (associated(split%my_spins)) then
          start(4)  = split%my_spins(idim4)
        end if
        do idim3 = 1, istop(3), 1
          if (associated(split%my_spins)) then
            start(3)  = split%my_spins(idim3)
          end if
          call etsf_io_low_write_var(ncid_to, "inverse_dielectric_function_upper_wing", &
                                   & folder%inverse_dielectric_function_upper_wing%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%inverse_dielectric_function_upper_wing%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "inverse_dielectric_function_upper_wing", &
                               & folder%inverse_dielectric_function_upper_wing%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%inverse_dielectric_function_upper_wing%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%inverse_dielectric_function_upper_wing%data1D)
  
  lstat = .true.
  ! Variable 'polarizability'
  !  allocate and read data
  allocate(folder%polarizability%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_dielectric_function * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "polarizability", &
                          & folder%polarizability%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%polarizability%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(7), count(7))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(7))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_dielectric_function
      if (.not. associated(split%my_spins)) then
        istop(5)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(5) = size(split%my_spins)
        count(5) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim5 = 1, istop(5), 1
        if (associated(split%my_spins)) then
          start(5)  = split%my_spins(idim5)
        end if
        do idim4 = 1, istop(4), 1
          if (associated(split%my_spins)) then
            start(4)  = split%my_spins(idim4)
          end if
          call etsf_io_low_write_var(ncid_to, "polarizability", &
                                   & folder%polarizability%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%polarizability%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "polarizability", &
                               & folder%polarizability%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%polarizability%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%polarizability%data1D)
  
  lstat = .true.
  ! Variable 'polarizability_head'
  !  allocate and read data
  allocate(folder%polarizability_head%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_dielectric_function * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "polarizability_head", &
                          & folder%polarizability_head%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%polarizability_head%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(5), count(5))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(5))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_dielectric_function
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(2)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(2) = size(split%my_spins)
        count(2) = 1
      end if
      len = len * dims%complex
      do idim3 = 1, istop(3), 1
        if (associated(split%my_spins)) then
          start(3)  = split%my_spins(idim3)
        end if
        do idim2 = 1, istop(2), 1
          if (associated(split%my_spins)) then
            start(2)  = split%my_spins(idim2)
          end if
          call etsf_io_low_write_var(ncid_to, "polarizability_head", &
                                   & folder%polarizability_head%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%polarizability_head%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "polarizability_head", &
                               & folder%polarizability_head%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%polarizability_head%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%polarizability_head%data1D)
  
  lstat = .true.
  ! Variable 'polarizability_lower_wing'
  !  allocate and read data
  allocate(folder%polarizability_lower_wing%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_gamma_limit * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "polarizability_lower_wing", &
                          & folder%polarizability_lower_wing%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%polarizability_lower_wing%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(6), count(6))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(6))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_gamma_limit
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim4 = 1, istop(4), 1
        if (associated(split%my_spins)) then
          start(4)  = split%my_spins(idim4)
        end if
        do idim3 = 1, istop(3), 1
          if (associated(split%my_spins)) then
            start(3)  = split%my_spins(idim3)
          end if
          call etsf_io_low_write_var(ncid_to, "polarizability_lower_wing", &
                                   & folder%polarizability_lower_wing%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%polarizability_lower_wing%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "polarizability_lower_wing", &
                               & folder%polarizability_lower_wing%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%polarizability_lower_wing%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%polarizability_lower_wing%data1D)
  
  lstat = .true.
  ! Variable 'polarizability_upper_wing'
  !  allocate and read data
  allocate(folder%polarizability_upper_wing%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_gamma_limit * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "polarizability_upper_wing", &
                          & folder%polarizability_upper_wing%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%polarizability_upper_wing%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(6), count(6))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(6))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_gamma_limit
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim4 = 1, istop(4), 1
        if (associated(split%my_spins)) then
          start(4)  = split%my_spins(idim4)
        end if
        do idim3 = 1, istop(3), 1
          if (associated(split%my_spins)) then
            start(3)  = split%my_spins(idim3)
          end if
          call etsf_io_low_write_var(ncid_to, "polarizability_upper_wing", &
                                   & folder%polarizability_upper_wing%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%polarizability_upper_wing%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "polarizability_upper_wing", &
                               & folder%polarizability_upper_wing%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%polarizability_upper_wing%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%polarizability_upper_wing%data1D)
  
  lstat = .true.
  ! Variable 'inverse_polarizability'
  !  allocate and read data
  allocate(folder%inverse_polarizability%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_dielectric_function * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "inverse_polarizability", &
                          & folder%inverse_polarizability%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%inverse_polarizability%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(7), count(7))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(7))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_dielectric_function
      if (.not. associated(split%my_spins)) then
        istop(5)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(5) = size(split%my_spins)
        count(5) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim5 = 1, istop(5), 1
        if (associated(split%my_spins)) then
          start(5)  = split%my_spins(idim5)
        end if
        do idim4 = 1, istop(4), 1
          if (associated(split%my_spins)) then
            start(4)  = split%my_spins(idim4)
          end if
          call etsf_io_low_write_var(ncid_to, "inverse_polarizability", &
                                   & folder%inverse_polarizability%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%inverse_polarizability%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "inverse_polarizability", &
                               & folder%inverse_polarizability%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%inverse_polarizability%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%inverse_polarizability%data1D)
  
  lstat = .true.
  ! Variable 'inverse_polarizability_head'
  !  allocate and read data
  allocate(folder%inverse_polarizability_head%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_dielectric_function * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "inverse_polarizability_head", &
                          & folder%inverse_polarizability_head%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%inverse_polarizability_head%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(5), count(5))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(5))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_dielectric_function
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(2)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(2) = size(split%my_spins)
        count(2) = 1
      end if
      len = len * dims%complex
      do idim3 = 1, istop(3), 1
        if (associated(split%my_spins)) then
          start(3)  = split%my_spins(idim3)
        end if
        do idim2 = 1, istop(2), 1
          if (associated(split%my_spins)) then
            start(2)  = split%my_spins(idim2)
          end if
          call etsf_io_low_write_var(ncid_to, "inverse_polarizability_head", &
                                   & folder%inverse_polarizability_head%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%inverse_polarizability_head%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "inverse_polarizability_head", &
                               & folder%inverse_polarizability_head%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%inverse_polarizability_head%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%inverse_polarizability_head%data1D)
  
  lstat = .true.
  ! Variable 'inverse_polarizability_lower_wing'
  !  allocate and read data
  allocate(folder%inverse_polarizability_lower_wing%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_gamma_limit * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "inverse_polarizability_lower_wing", &
                          & folder%inverse_polarizability_lower_wing%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%inverse_polarizability_lower_wing%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(6), count(6))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(6))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_gamma_limit
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim4 = 1, istop(4), 1
        if (associated(split%my_spins)) then
          start(4)  = split%my_spins(idim4)
        end if
        do idim3 = 1, istop(3), 1
          if (associated(split%my_spins)) then
            start(3)  = split%my_spins(idim3)
          end if
          call etsf_io_low_write_var(ncid_to, "inverse_polarizability_lower_wing", &
                                   & folder%inverse_polarizability_lower_wing%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%inverse_polarizability_lower_wing%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "inverse_polarizability_lower_wing", &
                               & folder%inverse_polarizability_lower_wing%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%inverse_polarizability_lower_wing%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%inverse_polarizability_lower_wing%data1D)
  
  lstat = .true.
  ! Variable 'inverse_polarizability_upper_wing'
  !  allocate and read data
  allocate(folder%inverse_polarizability_upper_wing%data1D( &
    & dims%number_of_frequencies_dielectric_function * &
    & dims%number_of_qpoints_gamma_limit * &
    & dims%my_number_of_spins * &
    & dims%my_number_of_spins * &
    & dims%number_of_coefficients_dielectric_function * &
    & dims%complex))
  call etsf_io_low_read_var(ncid_from, "inverse_polarizability_upper_wing", &
                          & folder%inverse_polarizability_upper_wing%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%inverse_polarizability_upper_wing%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(6), count(6))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(6))
      istart   = 1
      len      = 1
      len = len * dims%number_of_frequencies_dielectric_function
      len = len * dims%number_of_qpoints_gamma_limit
      if (.not. associated(split%my_spins)) then
        istop(4)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(4) = size(split%my_spins)
        count(4) = 1
      end if
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      len = len * dims%number_of_coefficients_dielectric_function
      len = len * dims%complex
      do idim4 = 1, istop(4), 1
        if (associated(split%my_spins)) then
          start(4)  = split%my_spins(idim4)
        end if
        do idim3 = 1, istop(3), 1
          if (associated(split%my_spins)) then
            start(3)  = split%my_spins(idim3)
          end if
          call etsf_io_low_write_var(ncid_to, "inverse_polarizability_upper_wing", &
                                   & folder%inverse_polarizability_upper_wing%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%inverse_polarizability_upper_wing%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "inverse_polarizability_upper_wing", &
                               & folder%inverse_polarizability_upper_wing%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%inverse_polarizability_upper_wing%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%inverse_polarizability_upper_wing%data1D)
  
  lstat = .true.
  
  ! We copy all the attributes (ETSF and non-ETSF) of the group variables.
  call etsf_io_low_set_define_mode(ncid_to, lstat, error_data = error_data)
  if (.not. lstat) nvarids = 0
  do len = 1, nvarids - 1, 1
    call etsf_io_low_copy_all_att(ncid_from, ncid_to, varids(1, len), varids(2, len), &
                                & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      exit
    end if
  end do
  deallocate(varids)

!DEBUG
!write (*,*) 'etsf_io_dielectric_copy : exit'
!ENDDEBUG

end subroutine etsf_io_dielectric_copy
!!***
