// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file typesPubSubTypes.hpp
 * This header file contains the declaration of the serialization functions.
 *
 * This file was generated by the tool fastddsgen.
 */


#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_TYPES_PUBSUBTYPES_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_TYPES_PUBSUBTYPES_HPP

#include <fastdds/dds/core/policy/QosPolicies.hpp>
#include <fastdds/dds/topic/TopicDataType.hpp>
#include <fastdds/rtps/common/InstanceHandle.hpp>
#include <fastdds/rtps/common/SerializedPayload.hpp>
#include <fastdds/utils/md5.hpp>

#include "types.hpp"


#if !defined(FASTDDS_GEN_API_VER) || (FASTDDS_GEN_API_VER != 3)
#error \
    Generated types is not compatible with current installed Fast DDS. Please, regenerate it with fastddsgen.
#endif  // FASTDDS_GEN_API_VER

namespace eprosima
{
    namespace fastdds
    {
        namespace statistics
        {
            namespace detail
            {

                /*!
                 * @brief This class represents the TopicDataType of the type EntityId_s defined by the user in the IDL file.
                 * @ingroup types
                 */
                class EntityId_sPubSubType : public eprosima::fastdds::dds::TopicDataType
                {
                public:

                    typedef EntityId_s type;

                    eProsima_user_DllExport EntityId_sPubSubType();

                    eProsima_user_DllExport ~EntityId_sPubSubType() override;

                    eProsima_user_DllExport bool serialize(
                            const void* const data,
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool deserialize(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            void* data) override;

                    eProsima_user_DllExport uint32_t calculate_serialized_size(
                            const void* const data,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool compute_key(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport bool compute_key(
                            const void* const data,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport void* create_data() override;

                    eProsima_user_DllExport void delete_data(
                            void* data) override;

                    //Register TypeObject representation in Fast DDS TypeObjectRegistry
                    eProsima_user_DllExport void register_type_object_representation() override;

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                    eProsima_user_DllExport inline bool is_bounded() const override
                    {
                        return true;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                    eProsima_user_DllExport inline bool is_plain(
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                    {
                        static_cast<void>(data_representation);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                    eProsima_user_DllExport inline bool construct_sample(
                            void* memory) const override
                    {
                        static_cast<void>(memory);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

                private:

                    eprosima::fastdds::MD5 md5_;
                    unsigned char* key_buffer_;

                };

                /*!
                 * @brief This class represents the TopicDataType of the type GuidPrefix_s defined by the user in the IDL file.
                 * @ingroup types
                 */
                class GuidPrefix_sPubSubType : public eprosima::fastdds::dds::TopicDataType
                {
                public:

                    typedef GuidPrefix_s type;

                    eProsima_user_DllExport GuidPrefix_sPubSubType();

                    eProsima_user_DllExport ~GuidPrefix_sPubSubType() override;

                    eProsima_user_DllExport bool serialize(
                            const void* const data,
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool deserialize(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            void* data) override;

                    eProsima_user_DllExport uint32_t calculate_serialized_size(
                            const void* const data,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool compute_key(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport bool compute_key(
                            const void* const data,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport void* create_data() override;

                    eProsima_user_DllExport void delete_data(
                            void* data) override;

                    //Register TypeObject representation in Fast DDS TypeObjectRegistry
                    eProsima_user_DllExport void register_type_object_representation() override;

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                    eProsima_user_DllExport inline bool is_bounded() const override
                    {
                        return true;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                    eProsima_user_DllExport inline bool is_plain(
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                    {
                        static_cast<void>(data_representation);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                    eProsima_user_DllExport inline bool construct_sample(
                            void* memory) const override
                    {
                        static_cast<void>(memory);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

                private:

                    eprosima::fastdds::MD5 md5_;
                    unsigned char* key_buffer_;

                };

                /*!
                 * @brief This class represents the TopicDataType of the type GUID_s defined by the user in the IDL file.
                 * @ingroup types
                 */
                class GUID_sPubSubType : public eprosima::fastdds::dds::TopicDataType
                {
                public:

                    typedef GUID_s type;

                    eProsima_user_DllExport GUID_sPubSubType();

                    eProsima_user_DllExport ~GUID_sPubSubType() override;

                    eProsima_user_DllExport bool serialize(
                            const void* const data,
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool deserialize(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            void* data) override;

                    eProsima_user_DllExport uint32_t calculate_serialized_size(
                            const void* const data,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool compute_key(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport bool compute_key(
                            const void* const data,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport void* create_data() override;

                    eProsima_user_DllExport void delete_data(
                            void* data) override;

                    //Register TypeObject representation in Fast DDS TypeObjectRegistry
                    eProsima_user_DllExport void register_type_object_representation() override;

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                    eProsima_user_DllExport inline bool is_bounded() const override
                    {
                        return true;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                    eProsima_user_DllExport inline bool is_plain(
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                    {
                        static_cast<void>(data_representation);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                    eProsima_user_DllExport inline bool construct_sample(
                            void* memory) const override
                    {
                        static_cast<void>(memory);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

                private:

                    eprosima::fastdds::MD5 md5_;
                    unsigned char* key_buffer_;

                };

                /*!
                 * @brief This class represents the TopicDataType of the type SequenceNumber_s defined by the user in the IDL file.
                 * @ingroup types
                 */
                class SequenceNumber_sPubSubType : public eprosima::fastdds::dds::TopicDataType
                {
                public:

                    typedef SequenceNumber_s type;

                    eProsima_user_DllExport SequenceNumber_sPubSubType();

                    eProsima_user_DllExport ~SequenceNumber_sPubSubType() override;

                    eProsima_user_DllExport bool serialize(
                            const void* const data,
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool deserialize(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            void* data) override;

                    eProsima_user_DllExport uint32_t calculate_serialized_size(
                            const void* const data,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool compute_key(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport bool compute_key(
                            const void* const data,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport void* create_data() override;

                    eProsima_user_DllExport void delete_data(
                            void* data) override;

                    //Register TypeObject representation in Fast DDS TypeObjectRegistry
                    eProsima_user_DllExport void register_type_object_representation() override;

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                    eProsima_user_DllExport inline bool is_bounded() const override
                    {
                        return true;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                    eProsima_user_DllExport inline bool is_plain(
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                    {
                        static_cast<void>(data_representation);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                    eProsima_user_DllExport inline bool construct_sample(
                            void* memory) const override
                    {
                        static_cast<void>(memory);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

                private:

                    eprosima::fastdds::MD5 md5_;
                    unsigned char* key_buffer_;

                };

                /*!
                 * @brief This class represents the TopicDataType of the type SampleIdentity_s defined by the user in the IDL file.
                 * @ingroup types
                 */
                class SampleIdentity_sPubSubType : public eprosima::fastdds::dds::TopicDataType
                {
                public:

                    typedef SampleIdentity_s type;

                    eProsima_user_DllExport SampleIdentity_sPubSubType();

                    eProsima_user_DllExport ~SampleIdentity_sPubSubType() override;

                    eProsima_user_DllExport bool serialize(
                            const void* const data,
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool deserialize(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            void* data) override;

                    eProsima_user_DllExport uint32_t calculate_serialized_size(
                            const void* const data,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool compute_key(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport bool compute_key(
                            const void* const data,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport void* create_data() override;

                    eProsima_user_DllExport void delete_data(
                            void* data) override;

                    //Register TypeObject representation in Fast DDS TypeObjectRegistry
                    eProsima_user_DllExport void register_type_object_representation() override;

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                    eProsima_user_DllExport inline bool is_bounded() const override
                    {
                        return true;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                    eProsima_user_DllExport inline bool is_plain(
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                    {
                        static_cast<void>(data_representation);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                    eProsima_user_DllExport inline bool construct_sample(
                            void* memory) const override
                    {
                        static_cast<void>(memory);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

                private:

                    eprosima::fastdds::MD5 md5_;
                    unsigned char* key_buffer_;

                };

                /*!
                 * @brief This class represents the TopicDataType of the type Locator_s defined by the user in the IDL file.
                 * @ingroup types
                 */
                class Locator_sPubSubType : public eprosima::fastdds::dds::TopicDataType
                {
                public:

                    typedef Locator_s type;

                    eProsima_user_DllExport Locator_sPubSubType();

                    eProsima_user_DllExport ~Locator_sPubSubType() override;

                    eProsima_user_DllExport bool serialize(
                            const void* const data,
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool deserialize(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            void* data) override;

                    eProsima_user_DllExport uint32_t calculate_serialized_size(
                            const void* const data,
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                    eProsima_user_DllExport bool compute_key(
                            eprosima::fastdds::rtps::SerializedPayload_t& payload,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport bool compute_key(
                            const void* const data,
                            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                            bool force_md5 = false) override;

                    eProsima_user_DllExport void* create_data() override;

                    eProsima_user_DllExport void delete_data(
                            void* data) override;

                    //Register TypeObject representation in Fast DDS TypeObjectRegistry
                    eProsima_user_DllExport void register_type_object_representation() override;

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                    eProsima_user_DllExport inline bool is_bounded() const override
                    {
                        return true;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

                #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                    eProsima_user_DllExport inline bool is_plain(
                            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                    {
                        static_cast<void>(data_representation);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                    eProsima_user_DllExport inline bool construct_sample(
                            void* memory) const override
                    {
                        static_cast<void>(memory);
                        return false;
                    }

                #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

                private:

                    eprosima::fastdds::MD5 md5_;
                    unsigned char* key_buffer_;

                };
            } // namespace detail

            /*!
             * @brief This class represents the TopicDataType of the type DiscoveryTime defined by the user in the IDL file.
             * @ingroup types
             */
            class DiscoveryTimePubSubType : public eprosima::fastdds::dds::TopicDataType
            {
            public:

                typedef DiscoveryTime type;

                eProsima_user_DllExport DiscoveryTimePubSubType();

                eProsima_user_DllExport ~DiscoveryTimePubSubType() override;

                eProsima_user_DllExport bool serialize(
                        const void* const data,
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool deserialize(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        void* data) override;

                eProsima_user_DllExport uint32_t calculate_serialized_size(
                        const void* const data,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool compute_key(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport bool compute_key(
                        const void* const data,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport void* create_data() override;

                eProsima_user_DllExport void delete_data(
                        void* data) override;

                //Register TypeObject representation in Fast DDS TypeObjectRegistry
                eProsima_user_DllExport void register_type_object_representation() override;

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                eProsima_user_DllExport inline bool is_bounded() const override
                {
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                eProsima_user_DllExport inline bool is_plain(
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                {
                    static_cast<void>(data_representation);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

            #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                eProsima_user_DllExport inline bool construct_sample(
                        void* memory) const override
                {
                    static_cast<void>(memory);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

            private:

                eprosima::fastdds::MD5 md5_;
                unsigned char* key_buffer_;

            };

            /*!
             * @brief This class represents the TopicDataType of the type EntityCount defined by the user in the IDL file.
             * @ingroup types
             */
            class EntityCountPubSubType : public eprosima::fastdds::dds::TopicDataType
            {
            public:

                typedef EntityCount type;

                eProsima_user_DllExport EntityCountPubSubType();

                eProsima_user_DllExport ~EntityCountPubSubType() override;

                eProsima_user_DllExport bool serialize(
                        const void* const data,
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool deserialize(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        void* data) override;

                eProsima_user_DllExport uint32_t calculate_serialized_size(
                        const void* const data,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool compute_key(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport bool compute_key(
                        const void* const data,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport void* create_data() override;

                eProsima_user_DllExport void delete_data(
                        void* data) override;

                //Register TypeObject representation in Fast DDS TypeObjectRegistry
                eProsima_user_DllExport void register_type_object_representation() override;

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                eProsima_user_DllExport inline bool is_bounded() const override
                {
                    return true;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                eProsima_user_DllExport inline bool is_plain(
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                {
                    static_cast<void>(data_representation);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

            #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                eProsima_user_DllExport inline bool construct_sample(
                        void* memory) const override
                {
                    static_cast<void>(memory);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

            private:

                eprosima::fastdds::MD5 md5_;
                unsigned char* key_buffer_;

            };

            /*!
             * @brief This class represents the TopicDataType of the type SampleIdentityCount defined by the user in the IDL file.
             * @ingroup types
             */
            class SampleIdentityCountPubSubType : public eprosima::fastdds::dds::TopicDataType
            {
            public:

                typedef SampleIdentityCount type;

                eProsima_user_DllExport SampleIdentityCountPubSubType();

                eProsima_user_DllExport ~SampleIdentityCountPubSubType() override;

                eProsima_user_DllExport bool serialize(
                        const void* const data,
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool deserialize(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        void* data) override;

                eProsima_user_DllExport uint32_t calculate_serialized_size(
                        const void* const data,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool compute_key(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport bool compute_key(
                        const void* const data,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport void* create_data() override;

                eProsima_user_DllExport void delete_data(
                        void* data) override;

                //Register TypeObject representation in Fast DDS TypeObjectRegistry
                eProsima_user_DllExport void register_type_object_representation() override;

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                eProsima_user_DllExport inline bool is_bounded() const override
                {
                    return true;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                eProsima_user_DllExport inline bool is_plain(
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                {
                    static_cast<void>(data_representation);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

            #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                eProsima_user_DllExport inline bool construct_sample(
                        void* memory) const override
                {
                    static_cast<void>(memory);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

            private:

                eprosima::fastdds::MD5 md5_;
                unsigned char* key_buffer_;

            };

            /*!
             * @brief This class represents the TopicDataType of the type Entity2LocatorTraffic defined by the user in the IDL file.
             * @ingroup types
             */
            class Entity2LocatorTrafficPubSubType : public eprosima::fastdds::dds::TopicDataType
            {
            public:

                typedef Entity2LocatorTraffic type;

                eProsima_user_DllExport Entity2LocatorTrafficPubSubType();

                eProsima_user_DllExport ~Entity2LocatorTrafficPubSubType() override;

                eProsima_user_DllExport bool serialize(
                        const void* const data,
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool deserialize(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        void* data) override;

                eProsima_user_DllExport uint32_t calculate_serialized_size(
                        const void* const data,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool compute_key(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport bool compute_key(
                        const void* const data,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport void* create_data() override;

                eProsima_user_DllExport void delete_data(
                        void* data) override;

                //Register TypeObject representation in Fast DDS TypeObjectRegistry
                eProsima_user_DllExport void register_type_object_representation() override;

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                eProsima_user_DllExport inline bool is_bounded() const override
                {
                    return true;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                eProsima_user_DllExport inline bool is_plain(
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                {
                    static_cast<void>(data_representation);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

            #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                eProsima_user_DllExport inline bool construct_sample(
                        void* memory) const override
                {
                    static_cast<void>(memory);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

            private:

                eprosima::fastdds::MD5 md5_;
                unsigned char* key_buffer_;

            };

            /*!
             * @brief This class represents the TopicDataType of the type WriterReaderData defined by the user in the IDL file.
             * @ingroup types
             */
            class WriterReaderDataPubSubType : public eprosima::fastdds::dds::TopicDataType
            {
            public:

                typedef WriterReaderData type;

                eProsima_user_DllExport WriterReaderDataPubSubType();

                eProsima_user_DllExport ~WriterReaderDataPubSubType() override;

                eProsima_user_DllExport bool serialize(
                        const void* const data,
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool deserialize(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        void* data) override;

                eProsima_user_DllExport uint32_t calculate_serialized_size(
                        const void* const data,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool compute_key(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport bool compute_key(
                        const void* const data,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport void* create_data() override;

                eProsima_user_DllExport void delete_data(
                        void* data) override;

                //Register TypeObject representation in Fast DDS TypeObjectRegistry
                eProsima_user_DllExport void register_type_object_representation() override;

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                eProsima_user_DllExport inline bool is_bounded() const override
                {
                    return true;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                eProsima_user_DllExport inline bool is_plain(
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                {
                    static_cast<void>(data_representation);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

            #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                eProsima_user_DllExport inline bool construct_sample(
                        void* memory) const override
                {
                    static_cast<void>(memory);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

            private:

                eprosima::fastdds::MD5 md5_;
                unsigned char* key_buffer_;

            };

            /*!
             * @brief This class represents the TopicDataType of the type Locator2LocatorData defined by the user in the IDL file.
             * @ingroup types
             */
            class Locator2LocatorDataPubSubType : public eprosima::fastdds::dds::TopicDataType
            {
            public:

                typedef Locator2LocatorData type;

                eProsima_user_DllExport Locator2LocatorDataPubSubType();

                eProsima_user_DllExport ~Locator2LocatorDataPubSubType() override;

                eProsima_user_DllExport bool serialize(
                        const void* const data,
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool deserialize(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        void* data) override;

                eProsima_user_DllExport uint32_t calculate_serialized_size(
                        const void* const data,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool compute_key(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport bool compute_key(
                        const void* const data,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport void* create_data() override;

                eProsima_user_DllExport void delete_data(
                        void* data) override;

                //Register TypeObject representation in Fast DDS TypeObjectRegistry
                eProsima_user_DllExport void register_type_object_representation() override;

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                eProsima_user_DllExport inline bool is_bounded() const override
                {
                    return true;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                eProsima_user_DllExport inline bool is_plain(
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                {
                    static_cast<void>(data_representation);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

            #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                eProsima_user_DllExport inline bool construct_sample(
                        void* memory) const override
                {
                    static_cast<void>(memory);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

            private:

                eprosima::fastdds::MD5 md5_;
                unsigned char* key_buffer_;

            };

            /*!
             * @brief This class represents the TopicDataType of the type EntityData defined by the user in the IDL file.
             * @ingroup types
             */
            class EntityDataPubSubType : public eprosima::fastdds::dds::TopicDataType
            {
            public:

                typedef EntityData type;

                eProsima_user_DllExport EntityDataPubSubType();

                eProsima_user_DllExport ~EntityDataPubSubType() override;

                eProsima_user_DllExport bool serialize(
                        const void* const data,
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool deserialize(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        void* data) override;

                eProsima_user_DllExport uint32_t calculate_serialized_size(
                        const void* const data,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool compute_key(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport bool compute_key(
                        const void* const data,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport void* create_data() override;

                eProsima_user_DllExport void delete_data(
                        void* data) override;

                //Register TypeObject representation in Fast DDS TypeObjectRegistry
                eProsima_user_DllExport void register_type_object_representation() override;

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                eProsima_user_DllExport inline bool is_bounded() const override
                {
                    return true;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                eProsima_user_DllExport inline bool is_plain(
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                {
                    static_cast<void>(data_representation);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

            #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                eProsima_user_DllExport inline bool construct_sample(
                        void* memory) const override
                {
                    static_cast<void>(memory);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

            private:

                eprosima::fastdds::MD5 md5_;
                unsigned char* key_buffer_;

            };

            /*!
             * @brief This class represents the TopicDataType of the type PhysicalData defined by the user in the IDL file.
             * @ingroup types
             */
            class PhysicalDataPubSubType : public eprosima::fastdds::dds::TopicDataType
            {
            public:

                typedef PhysicalData type;

                eProsima_user_DllExport PhysicalDataPubSubType();

                eProsima_user_DllExport ~PhysicalDataPubSubType() override;

                eProsima_user_DllExport bool serialize(
                        const void* const data,
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool deserialize(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        void* data) override;

                eProsima_user_DllExport uint32_t calculate_serialized_size(
                        const void* const data,
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

                eProsima_user_DllExport bool compute_key(
                        eprosima::fastdds::rtps::SerializedPayload_t& payload,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport bool compute_key(
                        const void* const data,
                        eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                        bool force_md5 = false) override;

                eProsima_user_DllExport void* create_data() override;

                eProsima_user_DllExport void delete_data(
                        void* data) override;

                //Register TypeObject representation in Fast DDS TypeObjectRegistry
                eProsima_user_DllExport void register_type_object_representation() override;

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
                eProsima_user_DllExport inline bool is_bounded() const override
                {
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

            #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

                eProsima_user_DllExport inline bool is_plain(
                        eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
                {
                    static_cast<void>(data_representation);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

            #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
                eProsima_user_DllExport inline bool construct_sample(
                        void* memory) const override
                {
                    static_cast<void>(memory);
                    return false;
                }

            #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

            private:

                eprosima::fastdds::MD5 md5_;
                unsigned char* key_buffer_;

            };
            namespace EventKind
            {
            } // namespace EventKind

        } // namespace statistics
    } // namespace fastdds
} // namespace eprosima

#endif // FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_TYPES_PUBSUBTYPES_HPP

