/* $Id: Register.hpp 4984 2010-10-19 14:54:10Z potyra $ 
 *
 * Register: a virtual register in the intermediate code.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __REGISTER_HPP_INCLUDED
#define __REGISTER_HPP_INCLUDED

#include "intermediate/operands/Operand.hpp"

namespace intermediate {

//! one virtual register.
/** This class represents a virtual register, with a given type.
 */
class Register : public Operand {
private:
	friend class RegisterFactory;

	//! private c'tor, use RegisterFactory instead
	/** @param t type of the virtual register.
	 *  @param n number of the virtual register.
	 */
	Register(enum OpType t, size_t n) : Operand(t), num(n) {}
public:
	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor &v) {
		v.visit(*this);
	}

	//! unique number
	size_t num;

};

}; /* namespace intermediate */

#endif /* __REGISTER_HPP_INCLUDED */
