// Tres en raya (Multijugador) - Fenix Proyecto 1.0
// Programado por Titonus usando libreria fsock

// Dinamica del juego:
// Gana la partida aquel que consiga formar una linea horizontal, vertical o diagonal con 3 de sus figuras.
// Las figuras del servidor son circulos y la del cliente rectangulos.

// La dinamica de envio/recepcion de datos consiste en que cada mensaje que envie el emisor (servidor o cliente) 
// ha de ser confirmado de que ha sido recibido por el receptor (servidor o cliente) salvo en el caso de que uno de 
// los dos jugadores desconecte de forma manual, salvo este caso, si un mensaje no es confirmado por el receptor 
// o uno de los dos jugadores no obtiene respuesta del otro al esperar un tiempo, la partida es finalizada.

// *Notas: 
// 1. La direccion IP/Host a la que ha de conectarse el cliente esta reflejada en el archivo de texto 'ipservidor.txt'
// 2. Para el correcto funcionamiento es necesario tener abiertos y correctamente configurados los puertos UDP siguientes:
// Por defecto el puerto 33333 (definido en la seccion constantes) y el siguiente a este, que es el 33334

PROGRAM TRES_EN_RAYA;

import "fsock"; // Importamos libreria "fsock.dll"

CONST
puerto=33333; // Puerto a usar 33333 (por defecto)

GLOBAL
// Variables
int socketEscucha, socketEnvio; //Sockets UDP
int ipRecibida; //Para poder contestar
int puertoRecibido; //Para poder contestar

int turno; // Contiene informacion sobre estado del juego (0 turno del oponente - 1 turno del jugador - 2 desconexion/error - 3 fin partida (ha ganado uno, dependiendo de a quien le corresponda el turno, esta informacion la enviara el servidor o el cliente) - 4 peticion para jugar - 5 peticion aceptada - 6 'ping' para comprobar que tanto el servidor y cliente siguen disponibles)
int imagen_raton; // Para cargar imagen raton
int fichero_ip; // Variable que maneja el fichero donde se encuentra la direccion IP/Host (usada por el cliente para conectar al servidor)
string ip; // Direccion IP/Host (usada por el cliente para conectar al servidor)
int figuras_tablero[2][2]; // 9 posibles figuras a dibujar en el tablero (1 indica que ya esta ocupada la posicion)
int figuras_propias[2][2]; // En este array bidimensional se marcan a 1 solamente las figuras propias
int i,j; // Para bucles for
BEGIN
	full_screen=false; // Modo ventana
	
	fsock_init(); // Inicializamos la libreria fsock

	graph_mode=mode_16bits; // Modo 16 bits

	// Lectura del fichero de texto
	fichero_ip=fopen("ipservidor.txt",o_read); // Abrimos archivo de texto para leer direccion IP/Host
	ip=fgets(fichero_ip); // Conseguimos IP/Host
	fclose(fichero_ip); // Cerramos el archivo
	//..

	set_mode(m320x240); // Resolucion pantalla

	imagen_raton=load_png("raton.png"); // Cargamos imagen del raton

	set_title("Tres en raya (Multijugador)"); // Titulo ventana
	say("Tres en raya (Multijugador) iniciado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
	say(""); // Mensaje consola	

	menu(); // Llamamos al proceso menu
END;

PROCESS menu()
PRIVATE
int opcion_elegida=0;// Para el bucle while (0 no se ha elegido opcion, 1 si)
BEGIN
turno=0;
// Reiniciamos las figuras del tablero a 0
for (i=0;i<=2;i++)
	for (j=0;j<=2;j++)
	figuras_tablero[i][j]=0;
	figuras_propias[i][j]=0;
	end
end;

clear_screen();

drawing_map(0,0);

mouse.graph=0; // Sin grafico el raton

// Texto para elegir una opcion (Menu)
delete_Text(0);
write(0,160,60,4,"Tres en raya (Multijugador)");
write(0,160,100,4,"1. Jugar (Actuar como Servidor)");
write(0,160,120,4,"2. Jugar (Actuar como Cliente)");
write(0,160,140,4,"3. Abandonar el juego");

	while (!opcion_elegida) // Esperamos a que se eliga una opcion	
		if key(_1): opcion_elegida=1;
				delete_text(0);

				socketEscucha = udpsock_open();
				socketEnvio = udpsock_open();

				fsock_bind(socketEscucha, puerto); //Abrimos el socketEscucha para escucha (cliente) en el puerto 'puerto'

				//Socketset para comprobar actividad en el socketEscucha
				fsock_socketset_free(0);
				fsock_socketset_add(0, socketEscucha); 

				say("Actuando como servidor en: localhost:"+puerto+" ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				say("Esperando conexion de un jugador ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				servidor(); // Llamamos al proceso servidor
				end;
		if key(_2): opcion_elegida=1;
				delete_text(0);

				socketEscucha = udpsock_open();
				socketEnvio = udpsock_open();

				fsock_bind(socketEscucha, puerto+1); //Abrimos el socketEscucha para escucha (servidor) en el puerto 'puerto+1'

				//Socketset para comprobar actividad en el socketEscucha
				fsock_socketset_free(0);
				fsock_socketset_add(0, socketEscucha); 

				say("Actuando como cliente ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				say("Conectando con: "+ip+":"+puerto+" ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				say("Peticion para jugar enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				cliente(); // Llamamos al proceso servidor
				end;
		if key(_3): fsock_quit();exit (1,"Salir"); // Cerramos libreria y salimos
				end;
	frame;
	end;
END


PROCESS servidor()
PRIVATE
int cliente_conectado=0; // Para bucle while (0 no ha conectado un cliente, 1 si)
int texto; // Para borrar texto en pantalla de turno del oponente
int estado_oponente; // Aqui guardamos la informacion que recibimos del oponente (2 desconexion/error - 3 fin partida - 6 'ping' - 7-15 casilla seleccionada)
int haciendo_ping; // Si esta a 1 es que estamos realizando un 'ping' (6)
int seleccionada; // Indica la casilla que hemos podido seleccionar una casilla y se procede a enviar datos (1 a 9) - Se pone a valor 10 para esperar la confirmacion de que se ha recibido el mensaje
int casilla; // De 7 a 15 (para enviarlo en un paquete)
int linea; // Vale 3 si se ha formado una linea horizontal, vertical o diagonal
int empate; // Vale 1 si ha habido empate
BEGIN

	timer[0]=0; // Contador a 0
	write(0,160,120,4,"Esperando conexion de un jugador ...");
		
		while (!cliente_conectado and !key(_esc)) // Esperamos conexion de algun cliente hasta que se haya conectado alguno o cancelemos pulsando escape

			// 'Parpadeo del mensaje de texto'
			if (timer[0]>50) delete_text(0);end;
			if (timer[0]>100) timer[0]=0;write(0,160,120,4,"Esperando conexion de un jugador ...");end;
			//..

			// Miramos cada 100 ms si hay actividad en el socketEscucha
			if (fsock_select(0,100)<=0)
				fsock_socketset_add(0, socketEscucha); //Despues de comprobar que actividad volvemos a rellenar el socketset
			else

				turno = 0;

				//Llegada de algun paquete
				udpsock_recv(socketEscucha, &turno, 4, &ipRecibida, &puertoRecibido);
			
				if (turno==4) 

					say("Peticion para jugar recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					say("Peticion para jugar aceptada, comienza la partida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					cliente_conectado=1;
					turno=5;
					
					udpsock_send(socketEnvio, &turno, 4, fsock_get_ipstr(&ipRecibida), puerto+1); 
					/* Enviamos confirmacion de que la peticion del cliente ha sido aceptada a la ipRecibida y puerto+1
					No lo enviamos a puertoRecibido porque el cliente tiene 'bindeado' solo el puerto+1 y no el del socket
					del envio. (Puede resultar poco preciso no asegurarse de que el cliente recibe este paquete, pero lo hacemos asi porque cuando 
					finalizemos y enviemos el movimiento de nuestra primera jugada (y cualquiera) esperamos confirmacion de que lo ha recibido
					en caso negativo la partida se finaliza */
					turno=1; // Es el turno del servidor
				else;
					say("Peticion erronea o desconocida recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				end
			end;
			
			frame;
		end;
		
		if (cliente_conectado==0) 
			say ("Servidor cancelado/finalizado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			fsock_socketset_free(0); // Vaciamos socketset
			fsock_close(socketEscucha); // Cerramos socket 
			fsock_close(socketEnvio); // Cerramos socket
			menu(); // Llamamos al proceso menu();
			return;
		end
		
		// Comienza la partida
		delete_text(0);
		write(0,160,5,4,"Tres en raya (Servidor)");
		timer[0]=0;timer[1]=0;
		// Dibujando tablero
		drawing_color(RGB(255,255,255)); //Color blanco las primitivas
		draw_line(120,45,120,195);
		draw_line(200,45,200,195);
		draw_line(60,80,260,80);
		draw_line(60,160,260,160);
LOOP
		// Miramos cada 100 ms si hay actividad en el socketEscucha
		if (fsock_select(0,100)<=0)
			fsock_socketset_add(0, socketEscucha); //Despues de comprobar que actividad volvemos a rellenar el socketset
		else
			estado_oponente=0;

			//Llegada de algun paquete
			udpsock_recv(socketEscucha, &estado_oponente, 4, &ipRecibida, &puertoRecibido);

				if (estado_oponente==2) 
					say("El cliente ha desconectado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
					fsock_socketset_free(0); // Vaciamos socketset
					fsock_close(socketEscucha); // Cerramos socket 
					fsock_close(socketEnvio); // Cerramos socket

					delete_text(0);
					clear_screen();

					write(0,160,120,4,"El cliente se ha desconectado!");
					write(0,160,140,4,"Pulsa Escape para continuar");

						while (!key(_esc))
							frame;
						end

					menu(); // Llamamos al proceso menu()
					return;				
				else 
					if (estado_oponente==3) 
						say("Partida finalizada, has perdido ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"Has perdido!");
						write(0,160,140,4,"Pulsa Escape para continuar");

						while (!key(_esc))
							frame;
						end

						menu(); // Llamamos al proceso menu()
						return;					
					end;
					if (estado_oponente<0 and estado_oponente>15);
					say("Peticion erronea o desconocida recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					end;
				end
		end;

		if (key(_esc)) // Cancelando partida
			say ("Servidor cancelado/finalizado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			turno=2; // Desconexion/error
			udpsock_send(socketEnvio, &turno, 4, fsock_get_ipstr(&ipRecibida), puerto+1);

			fsock_socketset_free(0); // Vaciamos socketset
			fsock_close(socketEscucha); // Cerramos socket 
			fsock_close(socketEnvio); // Cerramos socket
			menu(); // Llamamos al proceso menu();
			return;
		end
		
			if (turno==0) // Turno del oponente

				// 'Parpadeo del mensaje de texto'
				if (timer[0]>50) delete_text(texto);end;
				if (timer[0]>100) timer[0]=0;texto=write(0,160,225,4,"Turno del oponente");end;
				//..

				// Marcando casilla del oponente, recibiendo datos
				if (estado_oponente>6 and estado_oponente<16) // Se ha recibido una casilla seleccionada por el cliente
					timer[0]=0;timer[1]=0;
						if (texto>0) delete_text(texto);end// Eliminar texto que pueda permanecer en pantalla
					say("Casilla seleccionada por el cliente recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					turno=1;
				
					// Mandamos confirmacion de que hemos recibido el mensaje (ahora es el turno del servidor)
					udpsock_send(socketEnvio, &turno, 4, fsock_get_ipstr(&ipRecibida), puerto+1);

					drawing_color(RGB(255,255,255)); //Color blanco las primitivas

					switch (estado_oponente)
						case (7):
							figuras_tablero[0][0]=1;draw_rect(65,50,115,75);							
						end;
						case (8):
							figuras_tablero[0][1]=1;draw_rect(125,50,195,75);
						end;
						case (9):
							figuras_tablero[0][2]=1;draw_rect(205,50,255,75);
						end;
						case (10):
							figuras_tablero[1][0]=1;draw_rect(65,85,115,155);
						end;
						case (11):
							figuras_tablero[1][1]=1;draw_rect(125,85,195,155);
						end;
						case (12):
							figuras_tablero[1][2]=1;draw_rect(205,85,255,155);
						end;
						case (13):
							figuras_tablero[2][0]=1;draw_rect(65,165,115,190);
						end;
						case (14):
							figuras_tablero[2][1]=1;draw_rect(125,165,195,190);
						end;
						case (15):
							figuras_tablero[2][2]=1;draw_rect(205,165,255,190);
						end;	
					end;
				
					// Comprobacion de si hay un empate
					for (i=0;i<=2;i++)
						for (j=0;j<=2;j++)
							if (figuras_tablero[i][j]) empate=1;else empate=0;break;end
						end;
						if (empate==0) break;end
					end;
				
					if (empate==1) // Hay un empate
						say("Partida finalizada, ha habido empate ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"Empate!");
						write(0,160,140,4,"Pulsa Escape para continuar");

						while (!key(_esc))
							frame;
						end

						menu(); // Llamamos al proceso menu()
						return;
					end;
			end;
			//..
			
			/* Si en 30 segundos no hemos recibido informacion (seal) del oponente es por dos causas:
				1. El oponente se esta pensando mucho la jugada :-)
				2. El oponente no tiene conexion o cualquier otro error similar (ha desconectado y no nos ha llegado dicho mensaje)
			Por ello enviamos un 'ping' (6) para saber si aun sigue ahi, prorrogando el tiempo en caso afirmativo, 
			en caso de no obtener respuesta, se produce una desconexion (finalizacion de la partida).
			*/
			if (timer[1]>3000)
				timer[1]=0;
				haciendo_ping=1;
				estado_oponente=6;
				say("Peticion de ping enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				udpsock_send(socketEnvio, &estado_oponente, 4, fsock_get_ipstr(&ipRecibida), puerto+1);

				estado_oponente=0;
			end
			
			if (haciendo_ping)
				if (estado_oponente==6)
					say ("Peticion de ping recibida por el cliente ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					haciendo_ping=0;
					timer[1]=0;
				else
					if (timer[1]>300)
						timer[1]=0;haciendo_ping=0;
						say("El cliente no responde ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"El cliente no responde!");
						write(0,160,140,4,"Pulsa Escape para continuar");

						while (!key(_esc))
							frame;
						end

						menu(); // Llamamos al proceso menu()
						return;		
					end;
				end;
			end;
			//..			
			end
			
			if (turno==1) // Nuestro turno
				dibujar_raton();

				drawing_color(RGB(255,255,255)); //Color blanco las primitivas
			
				// Seleccionando una casilla y envio, recepcion de datos
				if (seleccionada==0 and mouse.left and mouse.x>=60 and mouse.x<=260 and mouse.y>=45 and mouse.y<=195)
					if (mouse.x<120)
						if (mouse.y<80 and !figuras_tablero[0][0])
							figuras_tablero[0][0]=1;figuras_propias[0][0]=1;seleccionada=1;draw_circle(90,55,15);end
						if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][0])
							figuras_tablero[1][0]=1;figuras_propias[1][0]=1;seleccionada=4;draw_circle(90,120,15);end
						if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][0])
							figuras_tablero[2][0]=1;figuras_propias[2][0]=1;seleccionada=7;draw_circle(90,180,15);end					
					end;
					if (mouse.x>120 and mouse.x<200)
						if (mouse.y<80 and !figuras_tablero[0][1])
							figuras_tablero[0][1]=1;figuras_propias[0][1]=1;seleccionada=2;draw_circle(160,55,15);end
						if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][1])
							figuras_tablero[1][1]=1;figuras_propias[1][1]=1;seleccionada=5;draw_circle(160,120,15);end
						if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][1])
							figuras_tablero[2][1]=1;figuras_propias[2][1]=1;seleccionada=8;draw_circle(160,180,15);end					
					end;				
					if (mouse.x>200 and mouse.x<260)
						if (mouse.y<80 and !figuras_tablero[0][2])
							figuras_tablero[0][2]=1;figuras_propias[0][2]=1;seleccionada=3;draw_circle(230,55,15);end
						if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][2])
							figuras_tablero[1][2]=1;figuras_propias[1][2]=1;seleccionada=6;draw_circle(230,120,15);end
						if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][2])
							figuras_tablero[2][2]=1;figuras_propias[2][2]=1;seleccionada=9;draw_circle(230,180,15);end					
					end;
							
			end;
			
			if (seleccionada>0 and seleccionada!=10)
				timer[1]=0;
				casilla=seleccionada+6;
				say("Casilla seleccionada enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				udpsock_send(socketEnvio, &casilla, 4, fsock_get_ipstr(&ipRecibida), puerto+1);

				seleccionada=10;
			end;
			
			if (seleccionada==10)
				/* Hemos de recibir la confirmacion del mensaje enviado (casilla seleccionada), si esta no llegase en 3 segundos, la partida finaliza
				El dato que hemos de recibir es un 1, que indica que ahora es el turno del oponente */
				if (estado_oponente==1)
					seleccionada=0;timer[1]=0;timer[0]=0;
					texto=write(0,160,225,4,"Turno del oponente");
					say("El cliente ha recibido la casilla seleccionada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
					turno=0;
					
					// Comprobacion de si hay un empate
					for (i=0;i<=2;i++)
						for (j=0;j<=2;j++)
						if (figuras_tablero[i][j]) empate=1;else empate=0;break;end
						end;
						if (empate==0) break;end
					end;
				
					if (empate==1) // Hay un empate
						say("Partida finalizada, ha habido empate ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"Empate!");
						write(0,160,140,4,"Pulsa Escape para continuar");

						while (!key(_esc))
							frame;
						end

						menu(); // Llamamos al proceso menu()
						return;
					end;
				
					// Comprobamos si el servidor ha ganado
					for (i=0;i<=2;i++) // Lineas horizontales
						linea=0;
						for (j=0;j<=2;j++)
						if (figuras_propias[i][j]) linea++;end				
						end;
						if (linea==3) turno=3;break;end						
					end;
					
					for (j=0;j<=2;j++) // Lineas verticales
						linea=0;
						for (i=0;i<=2;i++)
						if (figuras_propias[i][j]) linea++;end
						end;
						if (linea==3) turno=3;break;end						
					end;
					
					if (figuras_propias[0][0] and figuras_propias[1][1] and figuras_propias[2][2]) turno=3;end
					if (figuras_propias[0][2] and figuras_propias[1][1] and figuras_propias[2][0]) turno=3;end
					
					if (turno==3) // En caso afirmativo, acabamos la partida y enviamos el mensaje
						udpsock_send(socketEnvio, &turno, 4, fsock_get_ipstr(&ipRecibida), puerto+1);

						say("Partida finalizada, has ganado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"Has ganado!");
						write(0,160,140,4,"Pulsa Escape para continuar");

						while (!key(_esc))
							frame;
						end

						menu(); // Llamamos al proceso menu()
						return;				
					end;
					//..

				else if (timer[1]>300)
					timer[1]=0;
					say("El cliente no responde (no ha recibido la casilla seleccionada) ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
					fsock_socketset_free(0); // Vaciamos socketset
					fsock_close(socketEscucha); // Cerramos socket 
					fsock_close(socketEnvio); // Cerramos socket

					delete_text(0);
					clear_screen();

					write(0,160,120,4,"El cliente no responde!");
					write(0,160,140,4,"Pulsa Escape para continuar");

					while (!key(_esc))
						frame;
					end

					menu(); // Llamamos al proceso menu()
					return;
					end;
				end
			end;
			
			//..
			
			// Respondiendo a peticion de ping
			if (estado_oponente==6)
				timer[1]=0;
				say("Respondiendo peticion de ping al cliente ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				udpsock_send(socketEnvio, &estado_oponente, 4, fsock_get_ipstr(&ipRecibida), puerto+1);

				estado_oponente=0;
			end;
			
			// Si en 35 segundos (el oponente que no tiene su turno envia un ping cada 30 segundos) no 
			// hemos recibido una peticion para responder a un ping finalizaremos la partida
			if (timer[1]>3500)
				timer[1]=0;
				say("El cliente no responde (no ha enviado peticion de ping) ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				fsock_socketset_free(0); // Vaciamos socketset
				fsock_close(socketEscucha); // Cerramos socket 
				fsock_close(socketEnvio); // Cerramos socket

				delete_text(0);
				clear_screen();

				write(0,160,120,4,"El cliente no responde!");
				write(0,160,140,4,"Pulsa Escape para continuar");
	
				while (!key(_esc))
					frame;
				end

				menu(); // Llamamos al proceso menu()
				return;				
			end;
			
			end;						
FRAME;
END;
END;


PROCESS cliente()
PRIVATE
int conectado=0; // Para bucle while (0 no hay seal del servidor, 1 si)
int reintentos=0; // Controla el n de intetos para conectar al servidor (hay 3 intentos fijados en el codigo para conectar con el servidor, con 3 segundos entre cada uno)
int texto; // Para borrar texto en pantalla de turno del oponente
int estado_oponente; // Aqui guardamos la informacion que recibimos del oponente (2 desconexion/error - 3 fin partida - 6 'ping' - 7-15 casilla seleccionada)
int haciendo_ping; // Si esta a 1 es que estamos realizando un 'ping' (6)
int seleccionada; // Indica la casilla que hemos podido seleccionar una casilla y se procede a enviar datos (1 a 9) - Se pone a valor 10 para esperar la confirmacion de que se ha recibido el mensaje
int casilla; // De 7 a 15 (para enviarlo en un paquete)
int linea; // Vale 3 si se ha formado una linea horizontal, vertical o diagonal
int empate; // Vale 1 si ha habido empate
BEGIN
	turno=4; // Peticion para jugar (si cambiamos por ejemplo esto a 5, el servidor no aceptara)

	udpsock_send(socketEnvio, &turno, 4, ip, puerto); // Enviamos paquete para conectar al servidor

	timer[0]=0; // Contador a 0
	timer[1]=1; // Contador a 0
	write(0,160,120,4,"Conectando con el servidor ...");
		
		while (!conectado and !key(_esc)) // Esperamos conexion con el servidor o cancelamos pulsando escape
			// 'Parpadeo del mensaje de texto'
			if (timer[0]>50) delete_text(0);end;
			if (timer[0]>100) timer[0]=0;write(0,160,120,4,"Conectando con el servidor ...");end;
			//..
			if (timer[1]>300 and conectado==0) 
				reintentos++;

				if (reintentos!=3) // Si no se han cumplido aun los 3 intentos, volvemos a intentar conectar
					say("Peticion para jugar enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					udpsock_send(socketEnvio, &turno, 4, ip, puerto); // Enviamos paquete para conectar al servidor

					timer[1]=0;
				else; // Si no, cancelamos y volvemos al menu
					say ("El servidor no responde ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					fsock_socketset_free(0); // Vaciamos socketset
					fsock_close(socketEscucha); // Cerramos socket 
					fsock_close(socketEnvio); // Cerramos socket

					delete_text(0);
					clear_screen();

					write(0,160,120,4,"El servidor no responde!");
					write(0,160,140,4,"Pulsa Escape para continuar");
	
					while (!key(_esc))
						frame;
					end

					menu(); // Llamamos al proceso menu()
					return;
				end;			
			end;

			// Miramos cada 100 ms si hay actividad en el socketEscucha
			if (fsock_select(0,100)<=0)
				fsock_socketset_add(0, socketEscucha); //Despues de comprobar que actividad volvemos a rellenar el socketset
			else
				turno=0;

				//Llegada de algun paquete (ipRecibida ya sabemos cual sera la de ipservidor.txt y puertoRecibido nos da igual saberlo)
				udpsock_recv(socketEscucha, &turno, 4, &ipRecibida, &puertoRecibido); // Llegada de algun paquete			
				
					if (turno==5) 
						say("Peticion para jugar aceptada, comienza la partida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
						conectado=1;
						turno=0; // Es el turno del servidor (oponente)
					else;
						say("Peticion erronea o desconocida recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					end
			end;
		frame;
		end;
		
		if (conectado==0) 
			say ("Cliente cancelado/finalizado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			fsock_socketset_free(0); // Vaciamos socketset
			fsock_close(socketEscucha); // Cerramos socket 
			fsock_close(socketEnvio); // Cerramos socket
			menu(); // Llamamos al proceso menu()
			return;
		end
		
		// Comienza la partida
		delete_text(0);
		write(0,160,5,4,"Tres en raya (Cliente)");
		texto=write(0,160,225,4,"Turno del oponente");
		timer[0]=0;timer[1]=0;
		// Dibujando tablero
		drawing_color(RGB(255,255,255)); //Color blanco las primitivas
		draw_line(120,45,120,195);
		draw_line(200,45,200,195);
		draw_line(60,80,260,80);
		draw_line(60,160,260,160);	
LOOP
		// Miramos cada 100 ms si hay actividad en el socketEscucha
		if (fsock_select(0,100)<=0)
			fsock_socketset_add(0, socketEscucha); //Despues de comprobar que actividad volvemos a rellenar el socketset
		else
			estado_oponente=0;

			//Llegada de algun paquete (ipRecibida ya sabemos cual sera la de ipservidor.txt y puertoRecibido nos da igual saberlo)
			udpsock_recv(socketEscucha, &estado_oponente, 4, &ipRecibida, &puertoRecibido); // Llegada de algun paquete			

				if (estado_oponente==2) 
					say("El servidor ha desconectado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
					fsock_socketset_free(0); // Vaciamos socketset
					fsock_close(socketEscucha); // Cerramos socket 
					fsock_close(socketEnvio); // Cerramos socket

					delete_text(0);
					clear_screen();

					write(0,160,120,4,"El servidor se ha desconectado!");
					write(0,160,140,4,"Pulsa Escape para continuar");
	
					while (!key(_esc))
						frame;
					end

					menu(); // Llamamos al proceso menu()
					return;				
				else if (estado_oponente==3) 
					say("Partida finalizada, has perdido ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					fsock_socketset_free(0); // Vaciamos socketset
					fsock_close(socketEscucha); // Cerramos socket 
					fsock_close(socketEnvio); // Cerramos socket

					delete_text(0);
					clear_screen();

					write(0,160,120,4,"Has perdido!");
					write(0,160,140,4,"Pulsa Escape para continuar");
	
					while (!key(_esc))
						frame;
					end

					menu(); // Llamamos al proceso menu()					
					return;
					end;
					if (estado_oponente<0 and estado_oponente>15);
					say("Peticion erronea o desconocida recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					end;
				end
		end;

		if (key(_esc)) // Cancelando partida
			say ("Cliente cancelado/finalizado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			turno=2; // Desconexion/error
			
			// Enviamos desconexion/error (no esperamos que lo haya recibido por ello si el destinatario no la recibe, habra de esperar hasta que el detecte que ya no hay partida)
			udpsock_send(socketEnvio, &turno, 4, ip, puerto);

			fsock_socketset_free(0); // Vaciamos socketset
			fsock_close(socketEscucha); // Cerramos socket 
			fsock_close(socketEnvio); // Cerramos socket
			menu(); // Llamamos al proceso menu();
			return;
		end

			if (turno==0) // Turno del oponente
				// 'Parpadeo del mensaje de texto'
				if (timer[0]>50) delete_text(texto);end;
				if (timer[0]>100) timer[0]=0;texto=write(0,160,225,4,"Turno del oponente");end;
				//..

				// Marcando casilla del oponente, recibiendo datos
				if (estado_oponente>6 and estado_oponente<16) // Se ha recibido una casilla seleccionada por el servidor
					timer[0]=0;timer[1]=0;
					if (texto>0) delete_text(texto);end // Eliminar texto que pueda permanecer en pantalla
					say("Casilla seleccionada por el servidor recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					turno=1;

					udpsock_send(socketEnvio, &turno, 4, ip, puerto); // Mandamos confirmacion de que hemos recibido el mensaje (ahora es el turno del cliente)

					drawing_color(RGB(255,255,255)); //Color blanco las primitivas

						switch (estado_oponente)
							case (7):
								figuras_tablero[0][0]=1;draw_circle(90,55,15);
							end;
							case (8):
								figuras_tablero[0][1]=1;draw_circle(160,55,15);
							end;
							case (9):
								figuras_tablero[0][2]=1;draw_circle(230,55,15);
							end;
							case (10):
								figuras_tablero[1][0]=1;draw_circle(90,120,15);
							end;
							case (11):
								figuras_tablero[1][1]=1;draw_circle(160,120,15);
							end;
							case (12):
								figuras_tablero[1][2]=1;draw_circle(230,120,15);
							end;
							case (13):
								figuras_tablero[2][0]=1;draw_circle(90,180,15);
							end;
							case (14):
								figuras_tablero[2][1]=1;draw_circle(160,180,15);
							end;
							case (15):
								figuras_tablero[2][2]=1;draw_circle(230,180,15);
							end;				
						end;
				
					// Comprobacion de si hay un empate
					for (i=0;i<=2;i++)
						for (j=0;j<=2;j++)
							if (figuras_tablero[i][j]) empate=1;else empate=0;break;end
						end;
						if (empate==0) break;end
					end;
				
					if (empate==1) // Hay un empate
						say("Partida finalizada, ha habido empate ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"Empate!");
						write(0,160,140,4,"Pulsa Escape para continuar");
	
						while (!key(_esc))
							frame;
						end

						menu(); // Llamamos al proceso menu()
						return;
					end;
			end;
			//..
			
			/* Si en 30 segundos no hemos recibido informacion (seal) del oponente es por dos causas:
				1. El oponente se esta pensando mucho la jugada :-)
				2. El oponente no tiene conexion o cualquier otro error similar (ha desconectado y no nos ha llegado dicho mensaje)
			Por ello enviamos un 'ping' (6) para saber si aun sigue ahi, prorrogando el tiempo en caso afirmativo, 
			en caso de no obtener respuesta, se produce una desconexion (finalizacion de la partida).
			*/
			if (timer[1]>3000)
				timer[1]=0;
				haciendo_ping=1;
				estado_oponente=6;
				say("Peticion de ping enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				udpsock_send(socketEnvio, &estado_oponente, 4, ip, puerto);

				estado_oponente=0;
			end
			
			if (haciendo_ping)
				if (estado_oponente==6)
					say ("Peticion de ping recibida por el servidor ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					haciendo_ping=0;
					timer[1]=0;
				else
					if (timer[1]>300)
						timer[1]=0;
						say("El servidor no responde ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"El servidor no responde!");
						write(0,160,140,4,"Pulsa Escape para continuar");
	
						while (!key(_esc))
							frame;
						end	

						menu(); // Llamamos al proceso menu()
						return;		
					end;
				end;
			end;
			//..
			
			end
			
			if (turno==1) // Nuestro turno
				dibujar_raton();

				drawing_color(RGB(255,255,255)); //Color blanco las primitivas

				// Seleccionando una casilla y envio, recepcion de datos
				if (seleccionada==0 and mouse.left and mouse.x>=60 and mouse.x<=260 and mouse.y>=45 and mouse.y<=195)
					if (mouse.x<120)
						if (mouse.y<80 and !figuras_tablero[0][0])
							figuras_tablero[0][0]=1;figuras_propias[0][0]=1;seleccionada=1;draw_rect(65,50,115,75);end
						if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][0])
							figuras_tablero[1][0]=1;figuras_propias[1][0]=1;seleccionada=4;draw_rect(65,85,115,155);end
						if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][0])
							figuras_tablero[2][0]=1;figuras_propias[2][0]=1;seleccionada=7;draw_rect(65,165,115,190);end					
					end;
					if (mouse.x>120 and mouse.x<200)
						if (mouse.y<80 and !figuras_tablero[0][1])
							figuras_tablero[0][1]=1;figuras_propias[0][1]=1;seleccionada=2;draw_rect(125,50,195,75);end
						if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][1])
							figuras_tablero[1][1]=1;figuras_propias[1][1]=1;seleccionada=5;draw_rect(125,85,195,155);end
						if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][1])
							figuras_tablero[2][1]=1;figuras_propias[2][1]=1;seleccionada=8;draw_rect(125,165,195,190);end					
						end;				
					if (mouse.x>200 and mouse.x<260)
						if (mouse.y<80 and !figuras_tablero[0][2])
							figuras_tablero[0][2]=1;figuras_propias[0][2]=1;seleccionada=3;draw_rect(205,50,255,75);end
						if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][2])
							figuras_tablero[1][2]=1;figuras_propias[1][2]=1;seleccionada=6;draw_rect(205,85,255,155);end
						if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][2])
							figuras_tablero[2][2]=1;figuras_propias[2][2]=1;seleccionada=9;draw_rect(205,165,255,190);end					
					end;				
			end;
			
			if (seleccionada>0 and seleccionada!=10)
				timer[1]=0;
				casilla=seleccionada+6;
				say("Casilla seleccionada enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				udpsock_send(socketEnvio, &casilla, 4, ip, puerto);

				seleccionada=10;
			end;
			
			if (seleccionada==10)
				/* Hemos de recibir la confirmacion del mensaje enviado (casilla seleccionada), si esta no llegase en 3 segundos, la partida finaliza
				El dato que hemos de recibir es un 1, que indica que ahora es el turno del oponente */
				if (estado_oponente==1)
					seleccionada=0;
					texto=write(0,160,225,4,"Turno del oponente");
					say("El servidor ha recibido la casilla seleccionada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
					turno=0;
				
					// Comprobacion de si hay un empate
					for (i=0;i<=2;i++)
						for (j=0;j<=2;j++)
							if (figuras_tablero[i][j]) empate=1;else empate=0;break;end
						end;
						if (empate==0) break;end
					end;
				
					if (empate==1) // Hay un empate
						say("Partida finalizada, ha habido empate ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"Empate!");
						write(0,160,140,4,"Pulsa Escape para continuar");
	
						while (!key(_esc))
							frame;
						end
						menu(); // Llamamos al proceso menu()
						return;
					end;
				
					// Comprobamos si el cliente ha ganado
					for (i=0;i<=2;i++) // Lineas horizontales
						linea=0;
						for (j=0;j<=2;j++)
							if (figuras_propias[i][j]) linea++;end				
						end;
						if (linea==3) turno=3;break;end						
					end;
					
					for (j=0;j<=2;j++) // Lineas verticales
						linea=0;
						for (i=0;i<=2;i++)
							if (figuras_propias[i][j]) linea++;end
						end;
						if (linea==3) turno=3;break;end						
					end;
					
					if (figuras_propias[0][0] and figuras_propias[1][1] and figuras_propias[2][2]) turno=3;end
					if (figuras_propias[0][2] and figuras_propias[1][1] and figuras_propias[2][0]) turno=3;end
					
					if (turno==3) // En caso afirmativo, acabamos la partida y enviamos el mensaje
						udpsock_send(socketEnvio, &turno, 4, ip, puerto);

						say("Partida finalizada, has ganado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
						fsock_socketset_free(0); // Vaciamos socketset
						fsock_close(socketEscucha); // Cerramos socket 
						fsock_close(socketEnvio); // Cerramos socket

						delete_text(0);
						clear_screen();

						write(0,160,120,4,"Has ganado!");
						write(0,160,140,4,"Pulsa Escape para continuar");
	
						while (!key(_esc))
							frame;
						end

						menu(); // Llamamos al proceso menu()
						return;				
					end;
					//..
					
				else if (timer[1]>300)
					timer[1]=0;
					say("El servidor no responde (no ha recibido la casilla seleccionada) ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
					fsock_socketset_free(0); // Vaciamos socketset
					fsock_close(socketEscucha); // Cerramos socket 
					fsock_close(socketEnvio); // Cerramos socket
					menu(); // Llamamos al proceso menu()
					return;
					end;
				end
			end;
			//..
			
			// Respondiendo a peticion de ping
			if (estado_oponente==6)
				timer[1]=0;
				say("Respondiendo peticion de ping al servidor ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				udpsock_send(socketEnvio, &estado_oponente, 4, ip, puerto);
				estado_oponente=0;
			end;
			
			// Si en 35 segundos (el oponente que no tiene su turno envia un ping cada 30 segundos) no 
			// hemos recibido una peticion para responder a un ping finalizaremos la partida
			if (timer[1]>3500)
				timer[1]=0;
				say("El servidor no responde (no ha enviado peticion de ping) ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				fsock_socketset_free(0); // Vaciamos socketset
				fsock_close(socketEscucha); // Cerramos socket 
				fsock_close(socketEnvio); // Cerramos socket

				delete_text(0);
				clear_screen();

				write(0,160,120,4,"El servidor no responde!");
				write(0,160,140,4,"Pulsa Escape para continuar");
	
				while (!key(_esc))
					frame;
				end

				menu(); // Llamamos al proceso menu()
				return;				
			end;
			
			end;			
FRAME;
END;
END;

PROCESS dibujar_raton()
BEGIN
x = mouse.x;
y = mouse.y;

graph = imagen_raton;

FRAME;
END;