/*
 * Decompiled with CFR 0.152.
 */
package thredds.datatype.prefs;

import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;
import thredds.ui.MultilineTooltip;
import ucar.nc2.units.TimeDuration;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.FldInputVerifier;
import ucar.util.prefs.ui.PersistenceManager;

public class DurationField
extends Field {
    protected JTextComponent tf;

    public DurationField(String name, String label, TimeDuration defValue, PersistenceManager storeData) {
        super(name, label, storeData);
        this.validValue = this.getStoreValue(defValue);
        this.tf = new JTextField(){

            public JToolTip createToolTip() {
                return new MultilineTooltip();
            }
        };
        this.tf.setToolTipText("Formats:\n udunits time duration string");
        this.tf.setInputVerifier(new FldInputVerifier(this.tf, this));
        if (this.validValue != null) {
            this.tf.setText(this.validValue.toString());
        }
        this.finish();
    }

    public JComponent getEditComponent() {
        return this.tf;
    }

    public TimeDuration getTimeDuration() {
        return (TimeDuration)this.getValue();
    }

    protected boolean _validate(StringBuffer buff) {
        String editValue = this.tf.getText().trim();
        if (editValue.length() == 0) {
            return true;
        }
        try {
            new TimeDuration(this.tf.getText());
            return true;
        }
        catch (ParseException e) {
            buff.append(this.label).append(": ").append(e.getMessage());
            return false;
        }
    }

    protected Object getEditValue() {
        String editValue = this.tf.getText().trim();
        if (editValue.length() == 0) {
            return null;
        }
        try {
            return new TimeDuration(editValue);
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected void setEditValue(Object value) {
        if (value == null) {
            this.tf.setText("");
        } else {
            this.tf.setText(value.toString());
        }
    }

    protected void setStoreValue(Object value) {
        if (this.storeData != null) {
            if (value == null) {
                this.storeData.putObject(this.name, value);
            } else {
                this.storeData.putObject(this.name, new TimeDuration((TimeDuration)value));
            }
        }
    }

    protected Object getStoreValue(Object defValue) {
        Object value2;
        Object value = defValue;
        if (this.storeData != null && (value2 = this.storeData.getObject(this.name)) != null) {
            value = value2;
        }
        if (value == null) {
            return null;
        }
        return new TimeDuration((TimeDuration)value);
    }
}

