/*
 * Copyright (C) 2014-2024 Canonical
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __SB_KEY_DEF_H__
#define __SB_KEY_DEF_H__

uint8_t ubuntu_key[] = {
	0x30, 0x82, 0x04, 0x34, 0x30, 0x82, 0x03, 0x1c, 0xa0, 0x03, 0x02, 0x01,
	0x02, 0x02, 0x09, 0x00, 0xb9, 0x41, 0x24, 0xa0, 0x18, 0x2c, 0x92, 0x67,
	0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01,
	0x0b, 0x05, 0x00, 0x30, 0x81, 0x84, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03,
	0x55, 0x04, 0x06, 0x13, 0x02, 0x47, 0x42, 0x31, 0x14, 0x30, 0x12, 0x06,
	0x03, 0x55, 0x04, 0x08, 0x0c, 0x0b, 0x49, 0x73, 0x6c, 0x65, 0x20, 0x6f,
	0x66, 0x20, 0x4d, 0x61, 0x6e, 0x31, 0x10, 0x30, 0x0e, 0x06, 0x03, 0x55,
	0x04, 0x07, 0x0c, 0x07, 0x44, 0x6f, 0x75, 0x67, 0x6c, 0x61, 0x73, 0x31,
	0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x0e, 0x43, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x4c, 0x74, 0x64, 0x2e,
	0x31, 0x34, 0x30, 0x32, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x2b, 0x43,
	0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x4c, 0x74, 0x64,
	0x2e, 0x20, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x20, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x32,
	0x30, 0x34, 0x31, 0x32, 0x31, 0x31, 0x31, 0x32, 0x35, 0x31, 0x5a, 0x17,
	0x0d, 0x34, 0x32, 0x30, 0x34, 0x31, 0x31, 0x31, 0x31, 0x31, 0x32, 0x35,
	0x31, 0x5a, 0x30, 0x81, 0x84, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55,
	0x04, 0x06, 0x13, 0x02, 0x47, 0x42, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03,
	0x55, 0x04, 0x08, 0x0c, 0x0b, 0x49, 0x73, 0x6c, 0x65, 0x20, 0x6f, 0x66,
	0x20, 0x4d, 0x61, 0x6e, 0x31, 0x10, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x04,
	0x07, 0x0c, 0x07, 0x44, 0x6f, 0x75, 0x67, 0x6c, 0x61, 0x73, 0x31, 0x17,
	0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x0e, 0x43, 0x61, 0x6e,
	0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x4c, 0x74, 0x64, 0x2e, 0x31,
	0x34, 0x30, 0x32, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x2b, 0x43, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x4c, 0x74, 0x64, 0x2e,
	0x20, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x20, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06,
	0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00,
	0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01,
	0x01, 0x00, 0xbf, 0x5b, 0x3a, 0x16, 0x74, 0xee, 0x21, 0x5d, 0xae, 0x61,
	0xed, 0x9d, 0x56, 0xac, 0xbd, 0xde, 0xde, 0x72, 0xf3, 0xdd, 0x7e, 0x2d,
	0x4c, 0x62, 0x0f, 0xac, 0xc0, 0x6d, 0x48, 0x08, 0x11, 0xcf, 0x8d, 0x8b,
	0xfb, 0x61, 0x1f, 0x27, 0xcc, 0x11, 0x6e, 0xd9, 0x55, 0x3d, 0x39, 0x54,
	0xeb, 0x40, 0x3b, 0xb1, 0xbb, 0xe2, 0x85, 0x34, 0x79, 0xca, 0xf7, 0x7b,
	0xbf, 0xba, 0x7a, 0xc8, 0x10, 0x2d, 0x19, 0x7d, 0xad, 0x59, 0xcf, 0xa6,
	0xd4, 0xe9, 0x4e, 0x0f, 0xda, 0xae, 0x52, 0xea, 0x4c, 0x9e, 0x90, 0xce,
	0xc6, 0x99, 0x0d, 0x4e, 0x67, 0x65, 0x78, 0x5d, 0xf9, 0xd1, 0xd5, 0x38,
	0x4a, 0x4a, 0x7a, 0x8f, 0x93, 0x9c, 0x7f, 0x1a, 0xa3, 0x85, 0xdb, 0xce,
	0xfa, 0x8b, 0xf7, 0xc2, 0xa2, 0x21, 0x2d, 0x9b, 0x54, 0x41, 0x35, 0x10,
	0x57, 0x13, 0x8d, 0x6c, 0xbc, 0x29, 0x06, 0x50, 0x4a, 0x7e, 0xea, 0x99,
	0xa9, 0x68, 0xa7, 0x3b, 0xc7, 0x07, 0x1b, 0x32, 0x9e, 0xa0, 0x19, 0x87,
	0x0e, 0x79, 0xbb, 0x68, 0x99, 0x2d, 0x7e, 0x93, 0x52, 0xe5, 0xf6, 0xeb,
	0xc9, 0x9b, 0xf9, 0x2b, 0xed, 0xb8, 0x68, 0x49, 0xbc, 0xd9, 0x95, 0x50,
	0x40, 0x5b, 0xc5, 0xb2, 0x71, 0xaa, 0xeb, 0x5c, 0x57, 0xde, 0x71, 0xf9,
	0x40, 0x0a, 0xdd, 0x5b, 0xac, 0x1e, 0x84, 0x2d, 0x50, 0x1a, 0x52, 0xd6,
	0xe1, 0xf3, 0x6b, 0x6e, 0x90, 0x64, 0x4f, 0x5b, 0xb4, 0xeb, 0x20, 0xe4,
	0x61, 0x10, 0xda, 0x5a, 0xf0, 0xea, 0xe4, 0x42, 0xd7, 0x01, 0xc4, 0xfe,
	0x21, 0x1f, 0xd9, 0xb9, 0xc0, 0x54, 0x95, 0x42, 0x81, 0x52, 0x72, 0x1f,
	0x49, 0x64, 0x7a, 0xc8, 0x6c, 0x24, 0xf1, 0x08, 0x70, 0x0b, 0x4d, 0xa5,
	0xa0, 0x32, 0xd1, 0xa0, 0x1c, 0x57, 0xa8, 0x4d, 0xe3, 0xaf, 0xa5, 0x8e,
	0x05, 0x05, 0x3e, 0x10, 0x43, 0xa1, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3,
	0x81, 0xa6, 0x30, 0x81, 0xa3, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e,
	0x04, 0x16, 0x04, 0x14, 0xad, 0x91, 0x99, 0x0b, 0xc2, 0x2a, 0xb1, 0xf5,
	0x17, 0x04, 0x8c, 0x23, 0xb6, 0x65, 0x5a, 0x26, 0x8e, 0x34, 0x5a, 0x63,
	0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80,
	0x14, 0xad, 0x91, 0x99, 0x0b, 0xc2, 0x2a, 0xb1, 0xf5, 0x17, 0x04, 0x8c,
	0x23, 0xb6, 0x65, 0x5a, 0x26, 0x8e, 0x34, 0x5a, 0x63, 0x30, 0x0f, 0x06,
	0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01,
	0x01, 0xff, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x04, 0x04, 0x03,
	0x02, 0x01, 0x86, 0x30, 0x43, 0x06, 0x03, 0x55, 0x1d, 0x1f, 0x04, 0x3c,
	0x30, 0x3a, 0x30, 0x38, 0xa0, 0x36, 0xa0, 0x34, 0x86, 0x32, 0x68, 0x74,
	0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x63, 0x61, 0x6e,
	0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x2d, 0x62, 0x6f, 0x6f, 0x74, 0x2d, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x2d, 0x63, 0x61, 0x2e, 0x63, 0x72, 0x6c,
	0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01,
	0x0b, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x3f, 0x7d, 0xf6, 0x76,
	0xa5, 0xb3, 0x83, 0xb4, 0x2b, 0x7a, 0xd0, 0x6d, 0x52, 0x1a, 0x03, 0x83,
	0xc4, 0x12, 0xa7, 0x50, 0x9c, 0x47, 0x92, 0xcc, 0xc0, 0x94, 0x77, 0x82,
	0xd2, 0xae, 0x57, 0xb3, 0x99, 0x04, 0xf5, 0x32, 0x3a, 0xc6, 0x55, 0x1d,
	0x07, 0xdb, 0x12, 0xa9, 0x56, 0xfa, 0xd8, 0xd4, 0x76, 0x20, 0xeb, 0xe4,
	0xc3, 0x51, 0xdb, 0x9a, 0x5c, 0x9c, 0x92, 0x3f, 0x18, 0x73, 0xda, 0x94,
	0x6a, 0xa1, 0x99, 0x38, 0x8c, 0xa4, 0x88, 0x6d, 0xc1, 0xfc, 0x39, 0x71,
	0xd0, 0x74, 0x76, 0x16, 0x03, 0x3e, 0x56, 0x23, 0x35, 0xd5, 0x55, 0x47,
	0x5b, 0x1a, 0x1d, 0x41, 0xc2, 0xd3, 0x12, 0x4c, 0xdc, 0xff, 0xae, 0x0a,
	0x92, 0x9c, 0x62, 0x0a, 0x17, 0x01, 0x9c, 0x73, 0xe0, 0x5e, 0xb1, 0xfd,
	0xbc, 0xd6, 0xb5, 0x19, 0x11, 0x7a, 0x7e, 0xcd, 0x3e, 0x03, 0x7e, 0x66,
	0xdb, 0x5b, 0xa8, 0xc9, 0x39, 0x48, 0x51, 0xff, 0x53, 0xe1, 0x9c, 0x31,
	0x53, 0x91, 0x1b, 0x3b, 0x10, 0x75, 0x03, 0x17, 0xba, 0xe6, 0x81, 0x02,
	0x80, 0x94, 0x70, 0x4c, 0x46, 0xb7, 0x94, 0xb0, 0x3d, 0x15, 0xcd, 0x1f,
	0x8e, 0x02, 0xe0, 0x68, 0x02, 0x8f, 0xfb, 0xf9, 0x47, 0x1d, 0x7d, 0xa2,
	0x01, 0xc6, 0x07, 0x51, 0xc4, 0x9a, 0xcc, 0xed, 0xdd, 0xcf, 0xa3, 0x5d,
	0xed, 0x92, 0xbb, 0xbe, 0xd1, 0xfd, 0xe6, 0xec, 0x1f, 0x33, 0x51, 0x73,
	0x04, 0xbe, 0x3c, 0x72, 0xb0, 0x7d, 0x08, 0xf8, 0x01, 0xff, 0x98, 0x7d,
	0xcb, 0x9c, 0xe0, 0x69, 0x39, 0x77, 0x25, 0x47, 0x71, 0x88, 0xb1, 0x8d,
	0x27, 0xa5, 0x2e, 0xa8, 0xf7, 0x3f, 0x5f, 0x80, 0x69, 0x97, 0x3e, 0xa9,
	0xf4, 0x99, 0x14, 0xdb, 0xce, 0x03, 0x0e, 0x0b, 0x66, 0xc4, 0x1c, 0x6d,
	0xbd, 0xb8, 0x27, 0x77, 0xc1, 0x42, 0x94, 0xbd, 0xfc, 0x6a, 0x0a, 0xbc,
};
uint32_t ubuntu_key_len = sizeof(ubuntu_key);

uint8_t ms_uefi_ca_2011_key[] = {
	0x30, 0x82, 0x06, 0x10, 0x30, 0x82, 0x03, 0xf8, 0xa0, 0x03, 0x02, 0x01,
	0x02, 0x02, 0x0a, 0x61, 0x08, 0xd3, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01,
	0x01, 0x0b, 0x05, 0x00, 0x30, 0x81, 0x91, 0x31, 0x0b, 0x30, 0x09, 0x06,
	0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x13, 0x30, 0x11,
	0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x0a, 0x57, 0x61, 0x73, 0x68, 0x69,
	0x6e, 0x67, 0x74, 0x6f, 0x6e, 0x31, 0x10, 0x30, 0x0e, 0x06, 0x03, 0x55,
	0x04, 0x07, 0x13, 0x07, 0x52, 0x65, 0x64, 0x6d, 0x6f, 0x6e, 0x64, 0x31,
	0x1e, 0x30, 0x1c, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x15, 0x4d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x6f, 0x66, 0x74, 0x20, 0x43, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x31, 0x3b, 0x30, 0x39, 0x06,
	0x03, 0x55, 0x04, 0x03, 0x13, 0x32, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x6f, 0x66, 0x74, 0x20, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x54, 0x68, 0x69, 0x72, 0x64, 0x20, 0x50, 0x61,
	0x72, 0x74, 0x79, 0x20, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x30, 0x1e, 0x17, 0x0d,
	0x31, 0x31, 0x30, 0x36, 0x32, 0x37, 0x32, 0x31, 0x32, 0x32, 0x34, 0x35,
	0x5a, 0x17, 0x0d, 0x32, 0x36, 0x30, 0x36, 0x32, 0x37, 0x32, 0x31, 0x33,
	0x32, 0x34, 0x35, 0x5a, 0x30, 0x81, 0x81, 0x31, 0x0b, 0x30, 0x09, 0x06,
	0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x13, 0x30, 0x11,
	0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x0a, 0x57, 0x61, 0x73, 0x68, 0x69,
	0x6e, 0x67, 0x74, 0x6f, 0x6e, 0x31, 0x10, 0x30, 0x0e, 0x06, 0x03, 0x55,
	0x04, 0x07, 0x13, 0x07, 0x52, 0x65, 0x64, 0x6d, 0x6f, 0x6e, 0x64, 0x31,
	0x1e, 0x30, 0x1c, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x15, 0x4d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x6f, 0x66, 0x74, 0x20, 0x43, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x31, 0x2b, 0x30, 0x29, 0x06,
	0x03, 0x55, 0x04, 0x03, 0x13, 0x22, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x6f, 0x66, 0x74, 0x20, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x55, 0x45, 0x46, 0x49, 0x20, 0x43, 0x41, 0x20,
	0x32, 0x30, 0x31, 0x31, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09,
	0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03,
	0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01,
	0x00, 0xa5, 0x08, 0x6c, 0x4c, 0xc7, 0x45, 0x09, 0x6a, 0x4b, 0x0c, 0xa4,
	0xc0, 0x87, 0x7f, 0x06, 0x75, 0x0c, 0x43, 0x01, 0x54, 0x64, 0xe0, 0x16,
	0x7f, 0x07, 0xed, 0x92, 0x7d, 0x0b, 0xb2, 0x73, 0xbf, 0x0c, 0x0a, 0xc6,
	0x4a, 0x45, 0x61, 0xa0, 0xc5, 0x16, 0x2d, 0x96, 0xd3, 0xf5, 0x2b, 0xa0,
	0xfb, 0x4d, 0x49, 0x9b, 0x41, 0x80, 0x90, 0x3c, 0xb9, 0x54, 0xfd, 0xe6,
	0xbc, 0xd1, 0x9d, 0xc4, 0xa4, 0x18, 0x8a, 0x7f, 0x41, 0x8a, 0x5c, 0x59,
	0x83, 0x68, 0x32, 0xbb, 0x8c, 0x47, 0xc9, 0xee, 0x71, 0xbc, 0x21, 0x4f,
	0x9a, 0x8a, 0x7c, 0xff, 0x44, 0x3f, 0x8d, 0x8f, 0x32, 0xb2, 0x26, 0x48,
	0xae, 0x75, 0xb5, 0xee, 0xc9, 0x4c, 0x1e, 0x4a, 0x19, 0x7e, 0xe4, 0x82,
	0x9a, 0x1d, 0x78, 0x77, 0x4d, 0x0c, 0xb0, 0xbd, 0xf6, 0x0f, 0xd3, 0x16,
	0xd3, 0xbc, 0xfa, 0x2b, 0xa5, 0x51, 0x38, 0x5d, 0xf5, 0xfb, 0xba, 0xdb,
	0x78, 0x02, 0xdb, 0xff, 0xec, 0x0a, 0x1b, 0x96, 0xd5, 0x83, 0xb8, 0x19,
	0x13, 0xe9, 0xb6, 0xc0, 0x7b, 0x40, 0x7b, 0xe1, 0x1f, 0x28, 0x27, 0xc9,
	0xfa, 0xef, 0x56, 0x5e, 0x1c, 0xe6, 0x7e, 0x94, 0x7e, 0xc0, 0xf0, 0x44,
	0xb2, 0x79, 0x39, 0xe5, 0xda, 0xb2, 0x62, 0x8b, 0x4d, 0xbf, 0x38, 0x70,
	0xe2, 0x68, 0x24, 0x14, 0xc9, 0x33, 0xa4, 0x08, 0x37, 0xd5, 0x58, 0x69,
	0x5e, 0xd3, 0x7c, 0xed, 0xc1, 0x04, 0x53, 0x08, 0xe7, 0x4e, 0xb0, 0x2a,
	0x87, 0x63, 0x08, 0x61, 0x6f, 0x63, 0x15, 0x59, 0xea, 0xb2, 0x2b, 0x79,
	0xd7, 0x0c, 0x61, 0x67, 0x8a, 0x5b, 0xfd, 0x5e, 0xad, 0x87, 0x7f, 0xba,
	0x86, 0x67, 0x4f, 0x71, 0x58, 0x12, 0x22, 0x04, 0x22, 0x22, 0xce, 0x8b,
	0xef, 0x54, 0x71, 0x00, 0xce, 0x50, 0x35, 0x58, 0x76, 0x95, 0x08, 0xee,
	0x6a, 0xb1, 0xa2, 0x01, 0xd5, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x82,
	0x01, 0x76, 0x30, 0x82, 0x01, 0x72, 0x30, 0x12, 0x06, 0x09, 0x2b, 0x06,
	0x01, 0x04, 0x01, 0x82, 0x37, 0x15, 0x01, 0x04, 0x05, 0x02, 0x03, 0x01,
	0x00, 0x01, 0x30, 0x23, 0x06, 0x09, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82,
	0x37, 0x15, 0x02, 0x04, 0x16, 0x04, 0x14, 0xf8, 0xc1, 0x6b, 0xb7, 0x7f,
	0x77, 0x53, 0x4a, 0xf3, 0x25, 0x37, 0x1d, 0x4e, 0xa1, 0x26, 0x7b, 0x0f,
	0x20, 0x70, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16,
	0x04, 0x14, 0x13, 0xad, 0xbf, 0x43, 0x09, 0xbd, 0x82, 0x70, 0x9c, 0x8c,
	0xd5, 0x4f, 0x31, 0x6e, 0xd5, 0x22, 0x98, 0x8a, 0x1b, 0xd4, 0x30, 0x19,
	0x06, 0x09, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x14, 0x02, 0x04,
	0x0c, 0x1e, 0x0a, 0x00, 0x53, 0x00, 0x75, 0x00, 0x62, 0x00, 0x43, 0x00,
	0x41, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x04, 0x04, 0x03, 0x02,
	0x01, 0x86, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff,
	0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x1f, 0x06, 0x03, 0x55,
	0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x45, 0x66, 0x52, 0x43,
	0xe1, 0x7e, 0x58, 0x11, 0xbf, 0xd6, 0x4e, 0x9e, 0x23, 0x55, 0x08, 0x3b,
	0x3a, 0x22, 0x6a, 0xa8, 0x30, 0x5c, 0x06, 0x03, 0x55, 0x1d, 0x1f, 0x04,
	0x55, 0x30, 0x53, 0x30, 0x51, 0xa0, 0x4f, 0xa0, 0x4d, 0x86, 0x4b, 0x68,
	0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x63, 0x72, 0x6c, 0x2e, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x6f, 0x66, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x70, 0x6b, 0x69, 0x2f, 0x63, 0x72, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2f, 0x4d, 0x69, 0x63, 0x43, 0x6f, 0x72, 0x54,
	0x68, 0x69, 0x50, 0x61, 0x72, 0x4d, 0x61, 0x72, 0x52, 0x6f, 0x6f, 0x5f,
	0x32, 0x30, 0x31, 0x30, 0x2d, 0x31, 0x30, 0x2d, 0x30, 0x35, 0x2e, 0x63,
	0x72, 0x6c, 0x30, 0x60, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05, 0x07,
	0x01, 0x01, 0x04, 0x54, 0x30, 0x52, 0x30, 0x50, 0x06, 0x08, 0x2b, 0x06,
	0x01, 0x05, 0x05, 0x07, 0x30, 0x02, 0x86, 0x44, 0x68, 0x74, 0x74, 0x70,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x6f, 0x66, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x70, 0x6b, 0x69,
	0x2f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x2f, 0x4d, 0x69, 0x63, 0x43, 0x6f,
	0x72, 0x54, 0x68, 0x69, 0x50, 0x61, 0x72, 0x4d, 0x61, 0x72, 0x52, 0x6f,
	0x6f, 0x5f, 0x32, 0x30, 0x31, 0x30, 0x2d, 0x31, 0x30, 0x2d, 0x30, 0x35,
	0x2e, 0x63, 0x72, 0x74, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
	0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00,
	0x35, 0x08, 0x42, 0xff, 0x30, 0xcc, 0xce, 0xf7, 0x76, 0x0c, 0xad, 0x10,
	0x68, 0x58, 0x35, 0x29, 0x46, 0x32, 0x76, 0x27, 0x7c, 0xef, 0x12, 0x41,
	0x27, 0x42, 0x1b, 0x4a, 0xaa, 0x6d, 0x81, 0x38, 0x48, 0x59, 0x13, 0x55,
	0xf3, 0xe9, 0x58, 0x34, 0xa6, 0x16, 0x0b, 0x82, 0xaa, 0x5d, 0xad, 0x82,
	0xda, 0x80, 0x83, 0x41, 0x06, 0x8f, 0xb4, 0x1d, 0xf2, 0x03, 0xb9, 0xf3,
	0x1a, 0x5d, 0x1b, 0xf1, 0x50, 0x90, 0xf9, 0xb3, 0x55, 0x84, 0x42, 0x28,
	0x1c, 0x20, 0xbd, 0xb2, 0xae, 0x51, 0x14, 0xc5, 0xc0, 0xac, 0x97, 0x95,
	0x21, 0x1c, 0x90, 0xdb, 0x0f, 0xfc, 0x77, 0x9e, 0x95, 0x73, 0x91, 0x88,
	0xca, 0xbd, 0xbd, 0x52, 0xb9, 0x05, 0x50, 0x0d, 0xdf, 0x57, 0x9e, 0xa0,
	0x61, 0xed, 0x0d, 0xe5, 0x6d, 0x25, 0xd9, 0x40, 0x0f, 0x17, 0x40, 0xc8,
	0xce, 0xa3, 0x4a, 0xc2, 0x4d, 0xaf, 0x9a, 0x12, 0x1d, 0x08, 0x54, 0x8f,
	0xbd, 0xc7, 0xbc, 0xb9, 0x2b, 0x3d, 0x49, 0x2b, 0x1f, 0x32, 0xfc, 0x6a,
	0x21, 0x69, 0x4f, 0x9b, 0xc8, 0x7e, 0x42, 0x34, 0xfc, 0x36, 0x06, 0x17,
	0x8b, 0x8f, 0x20, 0x40, 0xc0, 0xb3, 0x9a, 0x25, 0x75, 0x27, 0xcd, 0xc9,
	0x03, 0xa3, 0xf6, 0x5d, 0xd1, 0xe7, 0x36, 0x54, 0x7a, 0xb9, 0x50, 0xb5,
	0xd3, 0x12, 0xd1, 0x07, 0xbf, 0xbb, 0x74, 0xdf, 0xdc, 0x1e, 0x8f, 0x80,
	0xd5, 0xed, 0x18, 0xf4, 0x2f, 0x14, 0x16, 0x6b, 0x2f, 0xde, 0x66, 0x8c,
	0xb0, 0x23, 0xe5, 0xc7, 0x84, 0xd8, 0xed, 0xea, 0xc1, 0x33, 0x82, 0xad,
	0x56, 0x4b, 0x18, 0x2d, 0xf1, 0x68, 0x95, 0x07, 0xcd, 0xcf, 0xf0, 0x72,
	0xf0, 0xae, 0xbb, 0xdd, 0x86, 0x85, 0x98, 0x2c, 0x21, 0x4c, 0x33, 0x2b,
	0xf0, 0x0f, 0x4a, 0xf0, 0x68, 0x87, 0xb5, 0x92, 0x55, 0x32, 0x75, 0xa1,
	0x6a, 0x82, 0x6a, 0x3c, 0xa3, 0x25, 0x11, 0xa4, 0xed, 0xad, 0xd7, 0x04,
	0xae, 0xcb, 0xd8, 0x40, 0x59, 0xa0, 0x84, 0xd1, 0x95, 0x4c, 0x62, 0x91,
	0x22, 0x1a, 0x74, 0x1d, 0x8c, 0x3d, 0x47, 0x0e, 0x44, 0xa6, 0xe4, 0xb0,
	0x9b, 0x34, 0x35, 0xb1, 0xfa, 0xb6, 0x53, 0xa8, 0x2c, 0x81, 0xec, 0xa4,
	0x05, 0x71, 0xc8, 0x9d, 0xb8, 0xba, 0xe8, 0x1b, 0x44, 0x66, 0xe4, 0x47,
	0x54, 0x0e, 0x8e, 0x56, 0x7f, 0xb3, 0x9f, 0x16, 0x98, 0xb2, 0x86, 0xd0,
	0x68, 0x3e, 0x90, 0x23, 0xb5, 0x2f, 0x5e, 0x8f, 0x50, 0x85, 0x8d, 0xc6,
	0x8d, 0x82, 0x5f, 0x41, 0xa1, 0xf4, 0x2e, 0x0d, 0xe0, 0x99, 0xd2, 0x6c,
	0x75, 0xe4, 0xb6, 0x69, 0xb5, 0x21, 0x86, 0xfa, 0x07, 0xd1, 0xf6, 0xe2,
	0x4d, 0xd1, 0xda, 0xad, 0x2c, 0x77, 0x53, 0x1e, 0x25, 0x32, 0x37, 0xc7,
	0x6c, 0x52, 0x72, 0x95, 0x86, 0xb0, 0xf1, 0x35, 0x61, 0x6a, 0x19, 0xf5,
	0xb2, 0x3b, 0x81, 0x50, 0x56, 0xa6, 0x32, 0x2d, 0xfe, 0xa2, 0x89, 0xf9,
	0x42, 0x86, 0x27, 0x18, 0x55, 0xa1, 0x82, 0xca, 0x5a, 0x9b, 0xf8, 0x30,
	0x98, 0x54, 0x14, 0xa6, 0x47, 0x96, 0x25, 0x2f, 0xc8, 0x26, 0xe4, 0x41,
	0x94, 0x1a, 0x5c, 0x02, 0x3f, 0xe5, 0x96, 0xe3, 0x85, 0x5b, 0x3c, 0x3e,
	0x3f, 0xbb, 0x47, 0x16, 0x72, 0x55, 0xe2, 0x25, 0x22, 0xb1, 0xd9, 0x7b,
	0xe7, 0x03, 0x06, 0x2a, 0xa3, 0xf7, 0x1e, 0x90, 0x46, 0xc3, 0x00, 0x0d,
	0xd6, 0x19, 0x89, 0xe3, 0x0e, 0x35, 0x27, 0x62, 0x03, 0x71, 0x15, 0xa6,
	0xef, 0xd0, 0x27, 0xa0, 0xa0, 0x59, 0x37, 0x60, 0xf8, 0x38, 0x94, 0xb8,
	0xe0, 0x78, 0x70, 0xf8, 0xba, 0x4c, 0x86, 0x87, 0x94, 0xf6, 0xe0, 0xae,
	0x02, 0x45, 0xee, 0x65, 0xc2, 0xb6, 0xa3, 0x7e, 0x69, 0x16, 0x75, 0x07,
	0x92, 0x9b, 0xf5, 0xa6, 0xbc, 0x59, 0x83, 0x58,
};
uint32_t ms_uefi_ca_2011_key_len = sizeof(ms_uefi_ca_2011_key);

#endif
