{- This module was generated from data in the Kate syntax
   highlighting file ini.xml, version 1.1, by Jan Janssen (medhefgo@web.de) -}

module Text.Highlighting.Kate.Syntax.Ini
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "INI Files"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.ini;*.pls;*.kcfgc"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("INI Files","ini")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("INI Files","ini") -> return ()
      ("INI Files","Value") -> (popContext) >> pEndLine
      ("INI Files","Comment") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "on off default defaults localhost null true false yes no normal e_all e_error e_warning e_parse e_notice e_strict e_core_error e_core_warning e_compile_error e_compile_warning e_user_error e_user_warning e_user_notice"

regex_'3b'2e'2a'24 = compileRegex ";.*$"
regex_'23'2e'2a'24 = compileRegex "#.*$"

parseRules ("INI Files","ini") =
  (((pRangeDetect '[' ']' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("INI Files","Value"))
   <|>
   ((pFirstNonSpace >> pDetectChar False ';' >>= withAttribute CommentTok) >>~ pushContext ("INI Files","Comment"))
   <|>
   ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("INI Files","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("INI Files","ini")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("INI Files","Value") =
  (((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'3b'2e'2a'24 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("INI Files","Value")) >> pDefault >>= withAttribute StringTok))

parseRules ("INI Files","Comment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("INI Files","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("INI Files","ini") <|> fail ("Unknown context" ++ show x)
