// SPDX-License-Identifier: MIT
// Generated using Intel Graphics Assembler 1.1.0-int

#include "gpgpu_shader.h"

#define MD5_SUM_IGA64_ASMS f0c9d803408104207f0427e387a8050c

struct iga64_template const iga64_code_gpgpu_fill[] = {
	{ .gen_ver = 2000, .size = 44, .code = (const uint32_t []) {
		0x00080061, 0x01050000, 0x00000104, 0x00000000,
		0x00000069, 0x02058220, 0x02000014, 0x00000004,
		0x00000061, 0x02150220, 0x00000064, 0x00000000,
		0x000c0061, 0x04054220, 0x00000000, 0x00000000,
		0x00101c61, 0x05050220, 0x00000104, 0x00000000,
		0x00041b61, 0x04550220, 0x00220205, 0x00000000,
		0x00000061, 0x04754550, 0x00000000, 0x000f000f,
		0x00132031, 0x00000000, 0xd00e0494, 0x04000000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 52, .code = (const uint32_t []) {
		0x00020061, 0x01050000, 0x00000104, 0x00000000,
		0x00000069, 0x02058220, 0x02000024, 0x00000004,
		0x00000061, 0x02250220, 0x000000c4, 0x00000000,
		0x00030061, 0x04054220, 0x00000000, 0x00000000,
		0x00041c61, 0x05050220, 0x00000104, 0x00000000,
		0x00011b61, 0x04050220, 0x00220205, 0x00000000,
		0x00000061, 0x04454220, 0x00000000, 0x0000000f,
		0x00000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x00044031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 48, .code = (const uint32_t []) {
		0x00080061, 0x01050000, 0x00000104, 0x00000000,
		0x00000069, 0x02058220, 0x02000014, 0x00000004,
		0x00000061, 0x02150220, 0x00000064, 0x00000000,
		0x000c0061, 0x04054220, 0x00000000, 0x00000000,
		0x00101c61, 0x05050220, 0x00000104, 0x00000000,
		0x00041b61, 0x04050220, 0x00220205, 0x00000000,
		0x00000061, 0x04254220, 0x00000000, 0x0000000f,
		0x00000061, 0x04450220, 0x00000054, 0x00000000,
		0x00132031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 52, .code = (const uint32_t []) {
		0x00020061, 0x01050000, 0x00000104, 0x00000000,
		0x00000069, 0x02058220, 0x02000024, 0x00000004,
		0x00000061, 0x02250220, 0x000000c4, 0x00000000,
		0x00030061, 0x04054220, 0x00000000, 0x00000000,
		0x00041c61, 0x05050220, 0x00000104, 0x00000000,
		0x00011b61, 0x04050220, 0x00220205, 0x00000000,
		0x00000061, 0x04454220, 0x00000000, 0x0000000f,
		0x00000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x00044031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 48, .code = (const uint32_t []) {
		0x00020061, 0x01050000, 0x00000104, 0x00000000,
		0x00000069, 0x02058220, 0x02000024, 0x00000004,
		0x00000061, 0x02250220, 0x000000c4, 0x00000000,
		0x00030061, 0x04054220, 0x00000000, 0x00000000,
		0x00040461, 0x05050220, 0x00000104, 0x00000000,
		0x00010361, 0x04050220, 0x00220205, 0x00000000,
		0x00000061, 0x04454220, 0x00000000, 0x0000000f,
		0x00000061, 0x04850220, 0x000000a4, 0x00000000,
		0x00049031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_read_a64_d32[] = {
	{ .gen_ver = 2000, .size = 40, .code = (const uint32_t []) {
		0x800c0061, 0x1e054330, 0x00000000, 0x00000000,
		0x80000061, 0x1e054220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e154220, 0x00000000, 0xc0ded001,
		0x80000061, 0x1e254220, 0x00000000, 0x0000003f,
		0x80000061, 0x1e454220, 0x00000000, 0x0000003f,
		0x80000061, 0x1e754220, 0x00000000, 0x00000003,
		0x80032031, 0x1f0c0000, 0xf8061e0c, 0x00a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 0, .code = (const uint32_t []) {

	}}
};

struct iga64_template const iga64_code_write_a64_d32[] = {
	{ .gen_ver = 2000, .size = 48, .code = (const uint32_t []) {
		0x800c0061, 0x1e054330, 0x00000000, 0x00000000,
		0x80000061, 0x1e054220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e154220, 0x00000000, 0xc0ded001,
		0x80000061, 0x1e254220, 0x00000000, 0x0000003f,
		0x80000061, 0x1e454220, 0x00000000, 0x0000003f,
		0x80000061, 0x1e754220, 0x00000000, 0x00000003,
		0x800c0061, 0x1f054330, 0x00000000, 0x00000000,
		0x80000061, 0x1f054220, 0x00000000, 0xc0ded002,
		0x80032031, 0x00000000, 0xf80e1e0c, 0x00801f0c,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 0, .code = (const uint32_t []) {

	}}
};

struct iga64_template const iga64_code_end_system_routine_step_if_eq[] = {
	{ .gen_ver = 2000, .size = 48, .code = (const uint32_t []) {
		0x80000966, 0x80018220, 0x02008000, 0x00008000,
		0x80000965, 0x80118220, 0x02008010, 0xc0ded000,
		0x800c0961, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e554220, 0x00000000, 0x00000000,
		0x80000061, 0x1e654220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e754220, 0x00000000, 0x00000003,
		0x80032031, 0x1f0c0000, 0xd0061e8c, 0x04000000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80008070, 0x00018220, 0x22001f04, 0xc0ded002,
		0x84000965, 0x80118220, 0x02008010, 0xc0ded003,
		0x80000965, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 52, .code = (const uint32_t []) {
		0x80000966, 0x80018220, 0x02008000, 0x00008000,
		0x80000965, 0x80218220, 0x02008020, 0xc0ded000,
		0x80030961, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x00000003,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x1f0c0000, 0xc0001e0c, 0x02400000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80002070, 0x00018220, 0x22001f04, 0xc0ded002,
		0x81000965, 0x80218220, 0x02008020, 0xc0ded003,
		0x80000965, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 48, .code = (const uint32_t []) {
		0x80000966, 0x80018220, 0x02008000, 0x00008000,
		0x80000965, 0x80118220, 0x02008010, 0xc0ded000,
		0x800c0961, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e154220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e254220, 0x00000000, 0x00000003,
		0x80000061, 0x1e450220, 0x00000054, 0x00000000,
		0x80032031, 0x1f0c0000, 0xc0001e0c, 0x02400000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80008070, 0x00018220, 0x22001f04, 0xc0ded002,
		0x84000965, 0x80118220, 0x02008010, 0xc0ded003,
		0x80000965, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 52, .code = (const uint32_t []) {
		0x80000966, 0x80018220, 0x02008000, 0x00008000,
		0x80000965, 0x80218220, 0x02008020, 0xc0ded000,
		0x80030961, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x00000003,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x1f0c0000, 0xc0001e0c, 0x02400000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80002070, 0x00018220, 0x22001f04, 0xc0ded002,
		0x81000965, 0x80218220, 0x02008020, 0xc0ded003,
		0x80000965, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 48, .code = (const uint32_t []) {
		0x80000166, 0x80018220, 0x02008000, 0x00008000,
		0x80000165, 0x80218220, 0x02008020, 0xc0ded000,
		0x80030161, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x00000003,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80009031, 0x1f0c0000, 0xc0001e0c, 0x02400000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80002070, 0x00018220, 0x22001f04, 0xc0ded002,
		0x81000165, 0x80218220, 0x02008020, 0xc0ded003,
		0x80000165, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_end_system_routine[] = {
	{ .gen_ver = 2000, .size = 12, .code = (const uint32_t []) {
		0x80000965, 0x80118220, 0x02008010, 0xc0ded000,
		0x80000965, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 12, .code = (const uint32_t []) {
		0x80000965, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000965, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 12, .code = (const uint32_t []) {
		0x80000965, 0x80118220, 0x02008010, 0xc0ded000,
		0x80000965, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 12, .code = (const uint32_t []) {
		0x80000965, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000965, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 12, .code = (const uint32_t []) {
		0x80000165, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000165, 0x80018220, 0x02008000, 0x7ffffffd,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_breakpoint_suppress[] = {
	{ .gen_ver = 1250, .size = 8, .code = (const uint32_t []) {
		0x80000966, 0x80018220, 0x02008000, 0x00008000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x80000166, 0x80018220, 0x02008000, 0x00008000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_write_on_exception[] = {
	{ .gen_ver = 2000, .size = 52, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded002,
		0x800c0061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04558220, 0x02000014, 0x00000002,
		0x80001940, 0x04558220, 0x02000454, 0xc0ded000,
		0x80000040, 0x04658220, 0x02000064, 0xc0ded001,
		0x80000061, 0x04754220, 0x00000000, 0x00000003,
		0x80000965, 0x03058220, 0x02008010, 0xc0ded003,
		0x80000961, 0x30014220, 0x00000000, 0x00000000,
		0x80001a70, 0x00018220, 0x12000304, 0xc0ded004,
		0x84032031, 0x00000000, 0xd00e0494, 0x04000000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 60, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded002,
		0x80030061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0xc0ded000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded001,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80000965, 0x03058220, 0x02008020, 0xc0ded003,
		0x80000961, 0x30014220, 0x00000000, 0x00000000,
		0x80001a70, 0x00018220, 0x12000304, 0xc0ded004,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x81004031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 56, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded002,
		0x800c0061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000014, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0xc0ded000,
		0x80000040, 0x04158220, 0x02000064, 0xc0ded001,
		0x80000061, 0x04254220, 0x00000000, 0x00000003,
		0x80000061, 0x04450220, 0x00000054, 0x00000000,
		0x80000965, 0x03058220, 0x02008010, 0xc0ded003,
		0x80000961, 0x30014220, 0x00000000, 0x00000000,
		0x80001a70, 0x00018220, 0x12000304, 0xc0ded004,
		0x84032031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 60, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded002,
		0x80030061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0xc0ded000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded001,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80000965, 0x03058220, 0x02008020, 0xc0ded003,
		0x80000961, 0x30014220, 0x00000000, 0x00000000,
		0x80001a70, 0x00018220, 0x12000304, 0xc0ded004,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x81004031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 56, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded002,
		0x80030061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80000140, 0x04058220, 0x02000404, 0xc0ded000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded001,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80000165, 0x03058220, 0x02008020, 0xc0ded003,
		0x80000161, 0x30014220, 0x00000000, 0x00000000,
		0x80000270, 0x00018220, 0x12000304, 0xc0ded004,
		0x81009031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_set_exception[] = {
	{ .gen_ver = 2000, .size = 8, .code = (const uint32_t []) {
		0x80000966, 0x80118220, 0x02008010, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 8, .code = (const uint32_t []) {
		0x80000966, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 8, .code = (const uint32_t []) {
		0x80000966, 0x80118220, 0x02008010, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 8, .code = (const uint32_t []) {
		0x80000966, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x80000166, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_clear_exception[] = {
	{ .gen_ver = 2000, .size = 8, .code = (const uint32_t []) {
		0x80000965, 0x80118220, 0x02008010, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 8, .code = (const uint32_t []) {
		0x80000965, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 8, .code = (const uint32_t []) {
		0x80000965, 0x80118220, 0x02008010, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 8, .code = (const uint32_t []) {
		0x80000965, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x80000165, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_media_block_write[] = {
	{ .gen_ver = 2000, .size = 40, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded001,
		0x800c0061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04558220, 0x02000014, 0x00000002,
		0x80001940, 0x04558220, 0x02000454, 0x00000000,
		0x80000040, 0x04658220, 0x02000064, 0xc0ded000,
		0x80000061, 0x04754220, 0x00000000, 0x00000003,
		0x80032031, 0x00000000, 0xd00e0494, 0x04000000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 48, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded001,
		0x80030061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0x00000000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded000,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 44, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded001,
		0x800c0061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000014, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0x00000000,
		0x80000040, 0x04158220, 0x02000064, 0xc0ded000,
		0x80000061, 0x04254220, 0x00000000, 0x00000003,
		0x80000061, 0x04450220, 0x00000054, 0x00000000,
		0x80032031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 48, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded001,
		0x80030061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0x00000000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded000,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 44, .code = (const uint32_t []) {
		0x80000061, 0x05054220, 0x00000000, 0xc0ded001,
		0x80030061, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80000140, 0x04058220, 0x02000404, 0x00000000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded000,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80009031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_write_aip[] = {
	{ .gen_ver = 2000, .size = 8, .code = (const uint32_t []) {
		0x80000940, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 8, .code = (const uint32_t []) {
		0x80000940, 0x80418220, 0x02008040, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 8, .code = (const uint32_t []) {
		0x80000940, 0x80218220, 0x02008020, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 8, .code = (const uint32_t []) {
		0x80000940, 0x80418220, 0x02008040, 0xc0ded000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x80000140, 0x80418220, 0x02008040, 0xc0ded000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_media_block_write_aip[] = {
	{ .gen_ver = 2000, .size = 40, .code = (const uint32_t []) {
		0x80000961, 0x05050220, 0x00008020, 0x00000000,
		0x800c0961, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04558220, 0x02000014, 0x00000002,
		0x80001940, 0x04558220, 0x02000454, 0x00000000,
		0x80000040, 0x04658220, 0x02000064, 0xc0ded000,
		0x80000061, 0x04754220, 0x00000000, 0x00000003,
		0x80032031, 0x00000000, 0xd00e0494, 0x04000000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 48, .code = (const uint32_t []) {
		0x80000961, 0x05050220, 0x00008040, 0x00000000,
		0x80030961, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0x00000000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded000,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 44, .code = (const uint32_t []) {
		0x80000961, 0x05050220, 0x00008020, 0x00000000,
		0x800c0961, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000014, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0x00000000,
		0x80000040, 0x04158220, 0x02000064, 0xc0ded000,
		0x80000061, 0x04254220, 0x00000000, 0x00000003,
		0x80000061, 0x04450220, 0x00000054, 0x00000000,
		0x80032031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 48, .code = (const uint32_t []) {
		0x80000961, 0x05050220, 0x00008040, 0x00000000,
		0x80030961, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80001940, 0x04058220, 0x02000404, 0x00000000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded000,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 44, .code = (const uint32_t []) {
		0x80000161, 0x05050220, 0x00008040, 0x00000000,
		0x80030161, 0x04054220, 0x00000000, 0x00000000,
		0x80000069, 0x04058220, 0x02000024, 0x00000002,
		0x80000140, 0x04058220, 0x02000404, 0x00000000,
		0x80000040, 0x04258220, 0x020000c4, 0xc0ded000,
		0x80000061, 0x04454220, 0x00000000, 0x00000003,
		0x80000061, 0x04850220, 0x000000a4, 0x00000000,
		0x80009031, 0x00000000, 0xc0000414, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_common_target_write[] = {
	{ .gen_ver = 2000, .size = 52, .code = (const uint32_t []) {
		0x80100061, 0x1f054220, 0x00000000, 0x00000000,
		0x80000061, 0x1f054220, 0x00000000, 0xc0ded001,
		0x80000061, 0x1f154220, 0x00000000, 0xc0ded002,
		0x80000061, 0x1f254220, 0x00000000, 0xc0ded003,
		0x80000061, 0x1f354220, 0x00000000, 0xc0ded004,
		0x800c0061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e554220, 0x00000000, 0x00000000,
		0x80000061, 0x1e654220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e754220, 0x00000000, 0x0000000f,
		0x80032031, 0x00000000, 0xd00e1e94, 0x04000000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 56, .code = (const uint32_t []) {
		0x80040061, 0x1f054220, 0x00000000, 0x00000000,
		0x80000061, 0x1f054220, 0x00000000, 0xc0ded001,
		0x80000061, 0x1f254220, 0x00000000, 0xc0ded002,
		0x80000061, 0x1f454220, 0x00000000, 0xc0ded003,
		0x80000061, 0x1f654220, 0x00000000, 0xc0ded004,
		0x80030061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x0000000f,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x00000000, 0xc0001e14, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 52, .code = (const uint32_t []) {
		0x80100061, 0x1f054220, 0x00000000, 0x00000000,
		0x80000061, 0x1f054220, 0x00000000, 0xc0ded001,
		0x80000061, 0x1f154220, 0x00000000, 0xc0ded002,
		0x80000061, 0x1f254220, 0x00000000, 0xc0ded003,
		0x80000061, 0x1f354220, 0x00000000, 0xc0ded004,
		0x800c0061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e154220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e254220, 0x00000000, 0x0000000f,
		0x80000061, 0x1e450220, 0x00000054, 0x00000000,
		0x80032031, 0x00000000, 0xc0001e14, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 56, .code = (const uint32_t []) {
		0x80040061, 0x1f054220, 0x00000000, 0x00000000,
		0x80000061, 0x1f054220, 0x00000000, 0xc0ded001,
		0x80000061, 0x1f254220, 0x00000000, 0xc0ded002,
		0x80000061, 0x1f454220, 0x00000000, 0xc0ded003,
		0x80000061, 0x1f654220, 0x00000000, 0xc0ded004,
		0x80030061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x0000000f,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x00000000, 0xc0001e14, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 52, .code = (const uint32_t []) {
		0x80040061, 0x1f054220, 0x00000000, 0x00000000,
		0x80000061, 0x1f054220, 0x00000000, 0xc0ded001,
		0x80000061, 0x1f254220, 0x00000000, 0xc0ded002,
		0x80000061, 0x1f454220, 0x00000000, 0xc0ded003,
		0x80000061, 0x1f654220, 0x00000000, 0xc0ded004,
		0x80030061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x0000000f,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80009031, 0x00000000, 0xc0001e14, 0x02a00000,
		0x80000001, 0x00010000, 0x20000000, 0x00000000,
		0x80000001, 0x00010000, 0x30000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_inc_r40_jump_neq[] = {
	{ .gen_ver = 2000, .size = 20, .code = (const uint32_t []) {
		0x80000040, 0x28058220, 0x02002804, 0x00000001,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80001a70, 0x00018220, 0x22002804, 0xc0ded000,
		0x84000020, 0x00004000, 0x00000000, 0xffffffd0,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 20, .code = (const uint32_t []) {
		0x80000040, 0x28058220, 0x02002804, 0x00000001,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80001a70, 0x00018220, 0x22002804, 0xc0ded000,
		0x81000020, 0x00004000, 0x00000000, 0xffffffd0,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 20, .code = (const uint32_t []) {
		0x80000040, 0x28058220, 0x02002804, 0x00000001,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80001a70, 0x00018220, 0x22002804, 0xc0ded000,
		0x84000020, 0x00004000, 0x00000000, 0xffffffd0,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 20, .code = (const uint32_t []) {
		0x80000040, 0x28058220, 0x02002804, 0x00000001,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80001a70, 0x00018220, 0x22002804, 0xc0ded000,
		0x81000020, 0x00004000, 0x00000000, 0xffffffd0,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 20, .code = (const uint32_t []) {
		0x80000040, 0x28058220, 0x02002804, 0x00000001,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80000270, 0x00018220, 0x22002804, 0xc0ded000,
		0x81000120, 0x00004000, 0x00000000, 0xffffffd0,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_clear_r40[] = {
	{ .gen_ver = 1250, .size = 8, .code = (const uint32_t []) {
		0x80000061, 0x28054220, 0x00000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x80000061, 0x28054220, 0x00000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_jump_dw_neq[] = {
	{ .gen_ver = 2000, .size = 36, .code = (const uint32_t []) {
		0x800c0061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e554220, 0x00000000, 0x00000000,
		0x80000061, 0x1e654220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e754220, 0x00000000, 0x00000003,
		0x80032031, 0x1f0c0000, 0xd0061e8c, 0x04000000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80008070, 0x00018220, 0x22001f04, 0xc0ded001,
		0x84000020, 0x00004000, 0x00000000, 0xffffff90,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 40, .code = (const uint32_t []) {
		0x80030061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x00000003,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x1f0c0000, 0xc0001e0c, 0x02400000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80002070, 0x00018220, 0x22001f04, 0xc0ded001,
		0x81000020, 0x00004000, 0x00000000, 0xffffff80,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 36, .code = (const uint32_t []) {
		0x800c0061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e154220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e254220, 0x00000000, 0x00000003,
		0x80000061, 0x1e450220, 0x00000054, 0x00000000,
		0x80032031, 0x1f0c0000, 0xc0001e0c, 0x02400000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80008070, 0x00018220, 0x22001f04, 0xc0ded001,
		0x84000020, 0x00004000, 0x00000000, 0xffffff90,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 40, .code = (const uint32_t []) {
		0x80030061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x00000003,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80004031, 0x1f0c0000, 0xc0001e0c, 0x02400000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80002070, 0x00018220, 0x22001f04, 0xc0ded001,
		0x81000020, 0x00004000, 0x00000000, 0xffffff80,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 36, .code = (const uint32_t []) {
		0x80030061, 0x1e054220, 0x00000000, 0x00000000,
		0x80000061, 0x1e254220, 0x00000000, 0xc0ded000,
		0x80000061, 0x1e454220, 0x00000000, 0x00000003,
		0x80000061, 0x1e850220, 0x000000a4, 0x00000000,
		0x80009031, 0x1f0c0000, 0xc0001e0c, 0x02400000,
		0x80000061, 0x30014220, 0x00000000, 0x00000000,
		0x80002070, 0x00018220, 0x22001f04, 0xc0ded001,
		0x81000120, 0x00004000, 0x00000000, 0xffffff90,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_jump[] = {
	{ .gen_ver = 1250, .size = 8, .code = (const uint32_t []) {
		0x80000020, 0x00004000, 0x00000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x80000020, 0x00004000, 0x00000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_eot[] = {
	{ .gen_ver = 2000, .size = 8, .code = (const uint32_t []) {
		0x800c0061, 0x70050220, 0x00460005, 0x00000000,
		0x800f2031, 0x00000004, 0x3000700c, 0x00000000,
	}},
	{ .gen_ver = 1270, .size = 12, .code = (const uint32_t []) {
		0x80030061, 0x70050220, 0x00460005, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80034031, 0x00000004, 0x3000700c, 0x00000000,
	}},
	{ .gen_ver = 1260, .size = 8, .code = (const uint32_t []) {
		0x800c0061, 0x70050220, 0x00460005, 0x00000000,
		0x800f2031, 0x00000004, 0x3000700c, 0x00000000,
	}},
	{ .gen_ver = 1250, .size = 12, .code = (const uint32_t []) {
		0x80030061, 0x70050220, 0x00460005, 0x00000000,
		0x80001901, 0x00010000, 0x00000000, 0x00000000,
		0x80034031, 0x00000004, 0x3000700c, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x80030061, 0x70050220, 0x00460005, 0x00000000,
		0x80049031, 0x00000004, 0x7020700c, 0x10000000,
	}}
};

struct iga64_template const iga64_code_nop[] = {
	{ .gen_ver = 1250, .size = 8, .code = (const uint32_t []) {
		0x00000060, 0x00000000, 0x00000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x00000060, 0x00000000, 0x00000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};

struct iga64_template const iga64_code_sync_host[] = {
	{ .gen_ver = 1250, .size = 8, .code = (const uint32_t []) {
		0x80000001, 0x00010000, 0xf0000000, 0x00000000,
		0x80000901, 0x00010000, 0x00000000, 0x00000000,
	}},
	{ .gen_ver = 0, .size = 8, .code = (const uint32_t []) {
		0x80000001, 0x00010000, 0xf0000000, 0x00000000,
		0x80000101, 0x00010000, 0x00000000, 0x00000000,
	}}
};
