/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleEntryAsyncQueue<T> {
    private static Log log = LogFactory.getLog(SingleEntryAsyncQueue.class);
    private final AtomicReference<T> poisonData;
    private final int timeoutInSeconds;
    private final ArrayBlockingQueue<T> holder;

    public SingleEntryAsyncQueue(int timeoutInSecs) {
        this.timeoutInSeconds = timeoutInSecs;
        this.holder = new ArrayBlockingQueue(1);
        this.poisonData = new AtomicReference();
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    protected void setPoison(T poisonInstance) {
        this.poisonData.set(poisonInstance);
    }

    protected boolean isPoison(T poisonSample) {
        boolean result = false;
        T poison = this.poisonData.get();
        if (null != poison && poison.equals(poisonSample)) {
            result = true;
        }
        return result;
    }

    protected T pollToGetContentUntilTimeout() {
        T result = this.holder.poll();
        if (null != result) {
            log.debug("data was waiting: " + result);
        }
        if (this.timeoutInSeconds > 0 && null == result) {
            long now = System.currentTimeMillis();
            long deadline = now + (long)this.timeoutInSeconds * 1000L;
            while (now < deadline) {
                try {
                    log.debug("waiting for data for at most " + (deadline - now) + " more ms");
                    result = this.holder.poll(deadline - now, TimeUnit.MILLISECONDS);
                    log.debug("data from polling: " + result);
                    now = deadline;
                }
                catch (InterruptedException ie) {
                    now = System.currentTimeMillis();
                    log.debug("was interrupted; resuming wait");
                }
            }
        }
        return result;
    }

    protected boolean putContent(T thing) {
        log.debug("putting command: " + thing);
        boolean res = this.holder.offer(thing);
        log.debug("..command put?: " + res);
        return res;
    }

    protected boolean isEmpty() {
        return 0 == this.holder.size();
    }

    protected T peek() {
        return this.holder.peek();
    }

    protected boolean poisonPollers() {
        boolean result = true;
        if (null != this.poisonData.get()) {
            this.putContent(this.poisonData.get());
        } else {
            result = false;
            this.holder.clear();
        }
        return result;
    }
}

