/*
   Copyright (C) 2016-2017 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef VIEWERPLUGINEXTERNALCONFIGUREDIALOG_H
#define VIEWERPLUGINEXTERNALCONFIGUREDIALOG_H

#include <PimCommon/ConfigurePluginDialog>
class ViewerPluginExternalConfigureWidget;
class ViewerPluginExternalConfigureDialog : public PimCommon::ConfigurePluginDialog
{
    Q_OBJECT
public:
    explicit ViewerPluginExternalConfigureDialog(QWidget *parent = nullptr);
    ~ViewerPluginExternalConfigureDialog();

protected:
    QWidget *createLayout() override;
    void save() override;
    void load() override;
    void help() override;
private:
    ViewerPluginExternalConfigureWidget *mConfigWidget = nullptr;
};

#endif // VIEWERPLUGINEXTERNALCONFIGUREDIALOG_H
