set(KTIKZ_PACKAGE_NAME "KtikZ")

include(InstallRequiredSystemLibraries)
#set(CPACK_PACKAGE_NAME "KtikZ")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "KtikZ is a program for making pictures using TikZ")
set(CPACK_PACKAGE_VENDOR "Florian Hackenberger")
set(CPACK_PACKAGE_VERSION ${KTIKZ_VERSION})
#set(CPACK_PACKAGE_VERSION_MAJOR "0")
#set(CPACK_PACKAGE_VERSION_MINOR "10")
#set(CPACK_PACKAGE_VERSION_PATCH "0")
string(REGEX REPLACE "\\..*" "" CPACK_PACKAGE_VERSION_MAJOR ${CPACK_PACKAGE_VERSION})
string(REGEX REPLACE "([0-9]*)\\.([0-9]*)(\\.([0-9]*))?" "\\2" CPACK_PACKAGE_VERSION_MINOR ${CPACK_PACKAGE_VERSION})
string(REGEX REPLACE "([0-9]*)\\.([0-9]*)(\\.)?" "" CPACK_PACKAGE_VERSION_PATCH ${CPACK_PACKAGE_VERSION})
if("${CPACK_PACKAGE_VERSION_PATCH}" STREQUAL "") # if ${CPACK_PACKAGE_VERSION} is of the form 0.10 instead of 0.10.3
	set(CPACK_PACKAGE_VERSION_PATCH "0")
endif("${CPACK_PACKAGE_VERSION_PATCH}" STREQUAL "")
set(CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/README.md")
set(CPACK_PACKAGE_INSTALL_DIRECTORY "${KTIKZ_PACKAGE_NAME} ${CPACK_PACKAGE_VERSION}")
set(CPACK_RESOURCE_FILE_README "${CMAKE_CURRENT_SOURCE_DIR}/README.md")
set(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/LICENSE.GPL2")
set(CPACK_SOURCE_GENERATOR "TBZ2")
set(CPACK_SOURCE_IGNORE_FILES "/.svn/;/build*/*;/templates/;Makefile;~$;.qch$;.qhc$;/debian/;.exe$")
set(CPACK_SOURCE_PACKAGE_FILE_NAME "${CMAKE_PROJECT_NAME}-${CPACK_PACKAGE_VERSION}")
set(CPACK_SET_DESTDIR TRUE)
if(WIN32 AND NOT UNIX)
	# There is a bug in NSI that does not handle full unix paths properly. Make
	# sure there is at least one set of four (4) backslashes.
#	set(CPACK_PACKAGE_ICON "${CMake_SOURCE_DIR}/Utilities/Release\\\\InstallIcon.bmp")
	set(CPACK_PACKAGE_INSTALL_REGISTRY_KEY "${KTIKZ_PACKAGE_NAME} ${CPACK_PACKAGE_VERSION}")
	set(CPACK_NSIS_INSTALLED_ICON_NAME "bin\\\\ktikz.exe")
	set(CPACK_NSIS_DISPLAY_NAME "${CPACK_PACKAGE_INSTALL_DIRECTORY} ${KTIKZ_PACKAGE_NAME}")
	set(CPACK_NSIS_HELP_LINK "http:\\\\\\\\www.hackenberger.at/ktikz-editor-for-the-tikz-language")
	set(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\www.hackenberger.at/ktikz-editor-for-the-tikz-language")
	set(CPACK_NSIS_CONTACT "florian@hackenberger.at")
	set(CPACK_NSIS_MODIFY_PATH ON)
else(WIN32 AND NOT UNIX)
	set(CPACK_STRIP_FILES "bin/ktikz")
	set(CPACK_SOURCE_STRIP_FILES "")
endif(WIN32 AND NOT UNIX)
set(CPACK_PACKAGE_EXECUTABLES "ktikz;${KTIKZ_PACKAGE_NAME}")
#execute_process(COMMAND dpkg --print-architecture OUTPUT_VARIABLE DEBIAN_PACKAGE_ARCHITECTURE)
#set(CPACK_DEBIAN_PACKAGE_ARCHITECTURE ${DEBIAN_PACKAGE_ARCHITECTURE})
set(CPACK_DEBIAN_PACKAGE_DEPENDS "libkdeui5 (>=4.3.0), libpoppler-qt4-4 (>=0.6), poppler-utils (>=0.6), pgf")
set(CPACK_DEBIAN_PACKAGE_RECOMMENDS "khelpcenter4")
set(CPACK_DEBIAN_PACKAGE_MAINTAINER "Florian Hackenberger <florian@hackenberger.at>")
set(CPACK_DEBIAN_PACKAGE_SECTION "graphics")
#set(CPACK_DEBIAN_PACKAGE_PRIORITY "optional")
