#!/bin/sh
#
# Copyright (c) Members of the EGEE Collaboration. 2004-2010.
# See http://www.eu-egee.org/partners/ for details on the copyright
# holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 2009-
#    Oscar Koeroo <okoeroo@nikhef.nl>
#    Mischa Sall\'e <msalle@nikhef.nl>
#    David Groep <davidg@nikhef.nl>
#    NIKHEF Amsterdam, the Netherlands
#    <grid-mw-security@nikhef.nl> 
#
# 2007-2009
#    Oscar Koeroo <okoeroo@nikhef.nl>
#    David Groep <davidg@nikhef.nl>
#    NIKHEF Amsterdam, the Netherlands
#
# 2003-2007
#    Martijn Steenbakkers <martijn@nikhef.nl>
#    Oscar Koeroo <okoeroo@nikhef.nl>
#    David Groep <davidg@nikhef.nl>
#    NIKHEF Amsterdam, the Netherlands
#


ETC_GRID_SEC="/etc/grid-security"
GSI_AUTHZ_FILE="$ETC_GRID_SEC/gsi-authz.conf"
GLITE_LOCATION="/opt/glite"

# DON'T use uname -i, but use uname -m since that's also supported on debian
# On 64 bit: uname -m gives x86_64, on 32 bit, usually gives i686
if [ "x`uname -m`" = "xx86_64" ]; then
   GLOBUS_FLAVOR="gcc64"
   # Make sure libdir is also correct: if lib64 symlink or not existing: use lib
   if test -h "/usr/lib64" -o ! -e "/usr/lib64" ; then
      GLITE_LOCATION_LIB="$GLITE_LOCATION/lib"
   else
      GLITE_LOCATION_LIB="$GLITE_LOCATION/lib64"
   fi
else
   GLOBUS_FLAVOR="gcc32"
   GLITE_LOCATION_LIB="$GLITE_LOCATION/lib"
fi


SHARED_OBJECT_FILETYPE=".so"
GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE_PREFIX="liblcas_lcmaps_gt4_mapping"

GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE="$GLITE_LOCATION_LIB"/"$GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE_PREFIX$SHARED_OBJECT_FILETYPE"
GLITE_GT4_GLOBUS_FLAVOR_INTERFACE_SHARED_OBJECT_FILE="$GLITE_LOCATION_LIB"/"$GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE_PREFIX"_"$GLOBUS_FLAVOR$SHARED_OBJECT_FILETYPE"




writegsiauthz() {
cat > $GSI_AUTHZ_FILE << EOF
globus_mapping $GLITE_GT4_GLOBUS_FLAVOR_INTERFACE_SHARED_OBJECT_FILE lcmaps_callout
EOF

chmod 0644 $GSI_AUTHZ_FILE
}



debug() {
    echo "Using the following environment variables:"
    echo

    echo "\$ETC_GRID_SEC                                         " $ETC_GRID_SEC
    echo "\$GSI_AUTHZ_FILE                                       " $GSI_AUTHZ_FILE
    echo "\$GLITE_LOCATION                                       " $GLITE_LOCATION
    echo "\$GLITE_LOCATION                                       " $GLITE_LOCATION_LIB

    echo 
    echo "\$GLOBUS_FLAVOR                                        " $GLOBUS_FLAVOR
    echo "\$SHARED_OBJECT_FILETYPE                               " $SHARED_OBJECT_FILETYPE
    echo "\$GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE_PREFIX        " $GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE_PREFIX
    echo

    echo "\$GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE               " $GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE
    echo "\$GLITE_GT4_GLOBUS_FLAVOR_INTERFACE_SHARED_OBJECT_FILE " $GLITE_GT4_GLOBUS_FLAVOR_INTERFACE_SHARED_OBJECT_FILE
    echo 
}


install() {
    if [ -f "$GSI_AUTHZ_FILE" ]; then
        mv -v $GSI_AUTHZ_FILE $GSI_AUTHZ_FILE.is-replaced
    fi

    if [ ! -f "$GLITE_GT4_GLOBUS_FLAVOR_INTERFACE_SHARED_OBJECT_FILE" ]; then
        if [ ! -f "$GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE" ]; then
            echo "Error: Interface doesn't exist at '$GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE'."
            echo "Error: Please search for '$GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE_PREFIX$SHARED_OBJECT_FILETYPE' and link it to '$GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE_PREFIX$GLOBUS_FLAVOR$SHARED_OBJECT_FILETYPE' and adjust the '$GSI_AUTHZ_FILE' accordingly"
            exit 2;
        else
            # Link at the start place
            ln -s $GLITE_GT4_INTERFACE_SHARED_OBJECT_FILE $GLITE_GT4_GLOBUS_FLAVOR_INTERFACE_SHARED_OBJECT_FILE
        fi
    fi


    if [ ! -f $GLITE_GT4_GLOBUS_FLAVOR_INTERFACE_SHARED_OBJECT_FILE ]; then
        echo "Error: couldn't find the interface file '$GLITE_GT4_GLOBUS_FLAVOR_INTERFACE_SHARED_OBJECT_FILE' or a (sym)link to the interface"
        exit 3;
    else
        writegsiauthz;
    fi
   
}



deinstall() {
    if [ -f "$GSI_AUTHZ_FILE" ]; then
        mv -v $GSI_AUTHZ_FILE $GSI_AUTHZ_FILE.deinstalled
    fi
}


case "$1" in
    install)
        install;
    ;;

    deinstall)
        deinstall;
    ;;

    debug)
        debug;
    ;;

    *)
        echo $"Usage: $0 {install|deinstall|debug}";
        exit 1;
esac

exit 0;
