# LCMAPS policy file/plugin definition
#
# default path
path = /usr/lib/lcmaps

# Plugin definitions:
example          = "lcmaps_plugin_example.mod"
                       "Some bogus arguments"
localaccount     = "lcmaps_localaccount.mod"
                       "-gridmapfile /etc/grid-security/grid-mapfile"
poolaccount      = "lcmaps_poolaccount.mod"
                       "-gridmapfile /etc/grid-security/grid-mapfile"
                       "-gridmapdir /etc/grid-security/gridmapdir"
                       "-override_inconsistency" 
posix_enf        = "lcmaps_posix_enf.mod"
                       "-maxuid 1"
                       "-maxpgid 1"
                       "-maxsgid 32"
vomsextract      = "lcmaps_voms.mod"
                       "-vomsdir /etc/grid-security/vomsdir"
                       "-certdir /etc/grid-security/certificates"
vomslocalgroup   = "lcmaps_voms_localgroup.mod"
                       "-groupmapfile /etc/grid-security/groupmapfile"
                       "-mapmin 0"
vomspoolgroup    = "lcmaps_voms_poolgroup.mod"
                       "-groupmapfile /etc/grid-security/groupmapfile"
                       "-groupmapdir /etc/grid-security/groupmapdir"
                       "-override_inconsistency" 
                       "-mapmin 0"
vomspoolaccount  = "lcmaps_voms_poolaccount.mod"
                       "-gridmapfile /etc/grid-security/grid-mapfile"
                       "-gridmapdir /etc/grid-security/gridmapdir"
ldap_enf         = "lcmaps_ldap_enf.mod"
                       "-maxuid  1"
                       "-maxpgid 1"
                       "-maxsgid 32"
                       "-hostname ldap.example.org"
                       "-port 389"
                       "-require_all_groups yes"
                       "-dn_manager \"cn=Manager,dc=root\""
                       "-ldap_pw /etc/lcmaps/test_pw"
                       "-sb_groups \"ou=LocalGroups,dc=foobar,dc=ough\""
                       "-sb_user \"ou=LocalUsers,dc=foobar,dc=ough\""
                       "-timeout 5"

# Policies:
voms:
localaccount -> posix_enf | vomsextract
vomsextract -> vomslocalgroup
vomslocalgroup -> vomspoolgroup
vomspoolgroup -> vomspoolaccount
vomspoolaccount -> ldap_enf
ldap_enf -> posix_enf

standaard:
localaccount -> posix_enf | poolaccount
poolaccount -> posix_enf
