<?php
/*
# Copyright 2004, Commission scolaire de Laval, Stephane Bond
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'dbFunctions.php';
	require_once 'Node.php';
	
	/**
	*
	* Find all nodes relating a users and his groups 
	* 
	* @package MILLE-CONFIGURATOR
	*/
	class HWGroupFinder {

		/**
		* hardware
		* @access private
		* @var string
		*/
		var $hardware;
		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $lastError;
		/**
		* Nodes ids
		* @access private
		* @var string
		*/
		var $nodesIds;
		
		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $isError;

		function HWGroupFinder($node, $hardware) {
			$this->notFound = false;
			$this->hardware = $hardware;
			
			// Retrieve all hwgroups in the node scope
			if (!$node->getRightval()) return;
			$where='N.leftval<' . $node->getRightval() . ' AND N.rightval>=' . $node->getRightval() . ' ORDER BY N.leftval DESC';
			$from='nodes N INNER JOIN nodes NH ON NH.id_parent=N.id AND NH.nodetype='.HWGROUP_TYPE.' INNER JOIN hwgroupsrule H ON H.nodes_id=NH.id';
			$hwgrules = $this->getFromDB("NH.*, H.*",$where,$from,false,true);
			// Test matching groups
			if (is_array($hwgrules)) {
				foreach ($hwgrules as $hwg) {
					$hwgr = new HWGroupRule($hwg);
					if (!$tab[$hwgr->getNodeID()]=="no" && $hwgr->match($hardware))
						$tab[$hwgr->getNodeID()]="yes";
					else
						$tab[$hwgr->getNodeID()]="no";
				}
				
				// Set selected groups
				foreach ($tab as $key=>$value) {
					if ($value=="yes")
						$this->nodesIds[] = $key;
				}
			}
		}
		
		
		/**
		* Return true if not found
		*
		* @access public
		* @return int
		*/
		function notFound() {
			return $this->notFound;
		}
		
		
		/**
		* Get the nodes found
		*
		* @access public
		* @return int
		*/
		function getNodesIds() {
			return $this->nodesIds;
		}

		/**
		* Return yes if the object exists
		* To be used just after the construction
		*
		* @access public
		* @return float
		*/
		function isError() {
			return $this->isError;
		}

		/**
		* Get the last error
		*
		* @access public
		* @return float
		*/
		function lastError() {
			return $this->lastError;
		}
		
		/**
		* GetFromDB
		*
		* @access private
		* @return array
		*/
		function getFromDB($column,$where,$from="nodes",$isFatal=true,$multiple = false) {
			$query='SELECT '.$column.' FROM '.$from.' WHERE '.$where;
			if ($multiple) {
				$result = select($query.";");
			}
			else {
				$result = singleResultSelect($query);
			}
			if (!$result) {	
				$this->lastError = getMessage('not_found').$query; 
				$this->notFound = true; 
				if ($isFatal) 
					$this->isError = true; return NULL; 
			}
			elseif (!is_array($result)) { 
				$this->lastError = getMessage('db_error').$result." : ".$query; 
				if ($isFatal) $this->isError = true; return NULL;
			}
			return $result;
		}
		
	}
?>
