/***************************************************************************
                          cuserlist.h  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CUSERLIST_H
#define CUSERLIST_H

/**
  *@author Mathias Küster
  *
  * The list of users is a map to nicks to CMessageMyInfo objects.
  * Using std::map means it is ordered by nick, but this property is
  * not required nor used.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cmutex.h>
#include <dclib/core/types.h>

#include <map>

class CDCMessage;
class CMessageNickList;
class CMessageOpList;
class CMessageMyInfo;

typedef std::map<CString, CMessageMyInfo*> MyInfoMap;

class CUserList {

public:
	/** */
	CUserList();
	/** */
	virtual ~CUserList();

	/** */
	void Clear();
	
	/** user list functions */
	void InitUserList( CMessageNickList * NickList );
	/** */
	void InitOperatorList( CMessageOpList * OpList );
	/** */
	bool AppendUser( CString & nick, bool getinfo = true );
	/** */
	void RemoveUser( CString & nick );
	/** */
	bool UpdateUser( CMessageMyInfo * pMyInfo );
	/** */
	bool IsUserOnline( CString & nick );
	/** */
	bool IsAdmin( const CString & nick );
	/** */
	eUserClientVersion GetUserClientVersion( const CString & nick );
	/** */
	bool GetUserMyInfo( CString nick, CMessageMyInfo * p );
	/** */
	bool SetUserTransferInfo( CString nick, CDCMessage * msg );
	/**
	 * Sets the nick's IP.
	 *
	 * Returns true if there is a user and the IP was
	 * different. This will not mean much since
	 * details from transfers include the port but
	 * details from the UserIP2 extensions do not.
	 */
	bool SetUserIP( const CString & nick, const CString & ip );
	/** */
	ulonglong ShareSize() { return m_nShareSize; };
	/**
	 * Returns the nick in the userlist after the given nick.
	 * If nick is empty, returns the first nick.
	 * Returns an empty string if there are no nicks in the list,
	 * the given nick is not in the list, or the given nick is the last nick.
	 */
	CString GetNextNick( const CString & nick );

private:
	/** */
	CMutex m_Mutex;
	/** */
	MyInfoMap m_MyInfoMap;
	/** */
	ulonglong m_nShareSize;
};

#endif
