/* DbFieldInfo.c generated by valac 0.20.1, the Vala compiler
 * generated from DbFieldInfo.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdavala
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 *
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgda/libgda.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GdaDataDbFieldInfoForeignKeyPrivate GdaDataDbFieldInfoForeignKeyPrivate;

#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_TYPE_MATCH (gda_data_db_field_info_foreign_key_match_get_type ())

#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_TYPE_RULE (gda_data_db_field_info_foreign_key_rule_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GdaDataDbFieldInfoParamSpecForeignKey GdaDataDbFieldInfoParamSpecForeignKey;

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gboolean (*compatible) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gboolean (*equivalent) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gchar* (*to_string) (GdaDataDbFieldInfo* self);
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

struct _GdaDataDbFieldInfoForeignKey {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GdaDataDbFieldInfoForeignKeyPrivate * priv;
};

struct _GdaDataDbFieldInfoForeignKeyClass {
	GTypeClass parent_class;
	void (*finalize) (GdaDataDbFieldInfoForeignKey *self);
};

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gboolean (*equal) (GdaDataDbField* self, GdaDataDbField* field);
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	void (*copy) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	gboolean (*equal) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	gboolean (*compatible) (GdaDataDbTable* self, GdaDataDbTable* table);
	gboolean (*equivalent) (GdaDataDbTable* self, GdaDataDbTable* table);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_NONE,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_FULL,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_PARTIAL
} GdaDataDbFieldInfoForeignKeyMatch;

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NONE,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_NULL,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_RESTRICT,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NO_ACTION
} GdaDataDbFieldInfoForeignKeyRule;

struct _GdaDataDbFieldInfoForeignKeyPrivate {
	gchar* _name;
	gchar* _refname;
	GdaDataDbTable* _reftable;
	GeeArrayList* _refcol;
	GdaDataDbFieldInfoForeignKeyMatch _match;
	GdaDataDbFieldInfoForeignKeyRule _update_rule;
	GdaDataDbFieldInfoForeignKeyRule _delete_rule;
};

struct _GdaDataDbFieldInfoParamSpecForeignKey {
	GParamSpec parent_instance;
};


static gpointer gda_data_db_field_info_foreign_key_parent_class = NULL;

GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value, gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value, gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GdaDataDbFieldInfoAttribute* gda_data_db_field_info_attribute_items (int* result_length1);
gchar* gda_data_db_field_info_attribute_to_string (GdaDataDbFieldInfoAttribute self);
GdaDataDbFieldInfoAttribute gda_data_db_field_info_attribute_from_string (const gchar* str);
gboolean gda_data_db_field_info_compatible (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
static gboolean gda_data_db_field_info_real_compatible (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
GType gda_data_db_field_info_get_value_type (GdaDataDbFieldInfo* self);
GdaDataDbFieldInfoAttribute gda_data_db_field_info_get_attributes (GdaDataDbFieldInfo* self);
gboolean gda_data_db_field_info_equivalent (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
static gboolean gda_data_db_field_info_real_equivalent (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
const gchar* gda_data_db_field_info_get_name (GdaDataDbFieldInfo* self);
gchar* gda_data_db_field_info_to_string (GdaDataDbFieldInfo* self);
static gchar* gda_data_db_field_info_real_to_string (GdaDataDbFieldInfo* self);
GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_get_fkey (GdaDataDbFieldInfo* self);
gchar* gda_data_db_field_info_foreign_key_to_string (GdaDataDbFieldInfoForeignKey* self);
GValue* gda_data_db_field_info_get_default_value (GdaDataDbFieldInfo* self);
const gchar* gda_data_db_field_info_get_desc (GdaDataDbFieldInfo* self);
gint gda_data_db_field_info_get_ordinal (GdaDataDbFieldInfo* self);
void gda_data_db_field_info_set_ordinal (GdaDataDbFieldInfo* self, gint value);
void gda_data_db_field_info_set_value_type (GdaDataDbFieldInfo* self, GType value);
void gda_data_db_field_info_set_attributes (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
void gda_data_db_field_info_set_default_value (GdaDataDbFieldInfo* self, GValue* value);
void gda_data_db_field_info_set_name (GdaDataDbFieldInfo* self, const gchar* value);
void gda_data_db_field_info_set_desc (GdaDataDbFieldInfo* self, const gchar* value);
gint gda_data_db_field_info_get_precision (GdaDataDbFieldInfo* self);
void gda_data_db_field_info_set_precision (GdaDataDbFieldInfo* self, gint value);
gint gda_data_db_field_info_get_scale (GdaDataDbFieldInfo* self);
void gda_data_db_field_info_set_scale (GdaDataDbFieldInfo* self, gint value);
void gda_data_db_field_info_set_fkey (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_foreign_key_match_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_foreign_key_rule_get_type (void) G_GNUC_CONST;
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyPrivate))
enum  {
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_DUMMY_PROPERTY
};
GdaDataDbFieldInfoForeignKeyMatch* gda_data_db_field_info_foreign_key_match_items (int* result_length1);
gchar* gda_data_db_field_info_foreign_key_match_to_string (GdaDataDbFieldInfoForeignKeyMatch self);
GdaDataDbFieldInfoForeignKeyMatch gda_data_db_field_info_foreign_key_match_from_string (const gchar* str);
GdaDataDbFieldInfoForeignKeyRule* gda_data_db_field_info_foreign_key_rule_items (int* result_length1);
gchar* gda_data_db_field_info_foreign_key_rule_to_string (GdaDataDbFieldInfoForeignKeyRule self);
GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_rule_from_string (const gchar* str);
GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_foreign_key_new (void);
GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_foreign_key_construct (GType object_type);
void gda_data_db_field_info_foreign_key_set_refcol (GdaDataDbFieldInfoForeignKey* self, GeeArrayList* value);
gboolean gda_data_db_field_info_foreign_key_equal (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKey* fkey);
const gchar* gda_data_db_field_info_foreign_key_get_name (GdaDataDbFieldInfoForeignKey* self);
const gchar* gda_data_db_field_info_foreign_key_get_refname (GdaDataDbFieldInfoForeignKey* self);
GdaDataDbTable* gda_data_db_field_info_foreign_key_get_reftable (GdaDataDbFieldInfoForeignKey* self);
GdaDataDbFieldInfoForeignKeyMatch gda_data_db_field_info_foreign_key_get_match (GdaDataDbFieldInfoForeignKey* self);
GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_get_update_rule (GdaDataDbFieldInfoForeignKey* self);
GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_get_delete_rule (GdaDataDbFieldInfoForeignKey* self);
GeeArrayList* gda_data_db_field_info_foreign_key_get_refcol (GdaDataDbFieldInfoForeignKey* self);
const gchar* gda_data_db_named_object_get_name (GdaDataDbNamedObject* self);
void gda_data_db_field_info_foreign_key_set_name (GdaDataDbFieldInfoForeignKey* self, const gchar* value);
void gda_data_db_field_info_foreign_key_set_refname (GdaDataDbFieldInfoForeignKey* self, const gchar* value);
void gda_data_db_field_info_foreign_key_set_reftable (GdaDataDbFieldInfoForeignKey* self, GdaDataDbTable* value);
void gda_data_db_field_info_foreign_key_set_match (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyMatch value);
void gda_data_db_field_info_foreign_key_set_update_rule (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyRule value);
void gda_data_db_field_info_foreign_key_set_delete_rule (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyRule value);
static void gda_data_db_field_info_foreign_key_finalize (GdaDataDbFieldInfoForeignKey* obj);


GdaDataDbFieldInfoAttribute* gda_data_db_field_info_attribute_items (int* result_length1) {
	GdaDataDbFieldInfoAttribute* result = NULL;
	GdaDataDbFieldInfoAttribute* _tmp0_ = NULL;
	GdaDataDbFieldInfoAttribute* _tmp1_;
	gint _tmp1__length1;
	_tmp0_ = g_new0 (GdaDataDbFieldInfoAttribute, 8);
	_tmp0_[0] = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE;
	_tmp0_[1] = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY;
	_tmp0_[2] = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE;
	_tmp0_[3] = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY;
	_tmp0_[4] = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK;
	_tmp0_[5] = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT;
	_tmp0_[6] = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL;
	_tmp0_[7] = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 8;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


gchar* gda_data_db_field_info_attribute_to_string (GdaDataDbFieldInfoAttribute self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	const gchar* _tmp17_;
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	if ((self & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = str;
		_tmp2_ = g_strconcat (_tmp1_, "NONE ", NULL);
		_g_free0 (str);
		str = _tmp2_;
	}
	if ((self & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = str;
		_tmp4_ = g_strconcat (_tmp3_, "PRIMARY_KEY ", NULL);
		_g_free0 (str);
		str = _tmp4_;
	}
	if ((self & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = str;
		_tmp6_ = g_strconcat (_tmp5_, "UNIQUE ", NULL);
		_g_free0 (str);
		str = _tmp6_;
	}
	if ((self & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = str;
		_tmp8_ = g_strconcat (_tmp7_, "FOREIGN_KEY ", NULL);
		_g_free0 (str);
		str = _tmp8_;
	}
	if ((self & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = str;
		_tmp10_ = g_strconcat (_tmp9_, "CHECK ", NULL);
		_g_free0 (str);
		str = _tmp10_;
	}
	if ((self & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = str;
		_tmp12_ = g_strconcat (_tmp11_, "HAVE_DEFAULT ", NULL);
		_g_free0 (str);
		str = _tmp12_;
	}
	if ((self & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = str;
		_tmp14_ = g_strconcat (_tmp13_, "CAN_BE_NULL ", NULL);
		_g_free0 (str);
		str = _tmp14_;
	}
	if ((self & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = str;
		_tmp16_ = g_strconcat (_tmp15_, "AUTO_INCREMENT ", NULL);
		_g_free0 (str);
		str = _tmp16_;
	}
	_tmp17_ = str;
	if (g_strcmp0 (_tmp17_, "") == 0) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("NONE");
		result = _tmp18_;
		_g_free0 (str);
		return result;
	}
	result = str;
	return result;
}


GdaDataDbFieldInfoAttribute gda_data_db_field_info_attribute_from_string (const gchar* str) {
	GdaDataDbFieldInfoAttribute result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "NONE") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE;
		return result;
	}
	_tmp1_ = str;
	if (g_strcmp0 (_tmp1_, "PRIMARY_KEY") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY;
		return result;
	}
	_tmp2_ = str;
	if (g_strcmp0 (_tmp2_, "PRIMARY KEY") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY;
		return result;
	}
	_tmp3_ = str;
	if (g_strcmp0 (_tmp3_, "UNIQUE") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE;
		return result;
	}
	_tmp4_ = str;
	if (g_strcmp0 (_tmp4_, "FOREIGN_KEY") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY;
		return result;
	}
	_tmp5_ = str;
	if (g_strcmp0 (_tmp5_, "FOREIGN KEY") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY;
		return result;
	}
	_tmp6_ = str;
	if (g_strcmp0 (_tmp6_, "CHECK") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK;
		return result;
	}
	_tmp7_ = str;
	if (g_strcmp0 (_tmp7_, "HAVE_DEFAULT") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT;
		return result;
	}
	_tmp8_ = str;
	if (g_strcmp0 (_tmp8_, "CAN_BE_NULL") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL;
		return result;
	}
	_tmp9_ = str;
	if (g_strcmp0 (_tmp9_, "AUTO_INCREMENT") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT;
		return result;
	}
	result = GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE;
	return result;
}


GType gda_data_db_field_info_attribute_get_type (void) {
	static volatile gsize gda_data_db_field_info_attribute_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_info_attribute_type_id__volatile)) {
		static const GFlagsValue values[] = {{GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE, "GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE", "none"}, {GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY, "GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY", "primary-key"}, {GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE, "GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE", "unique"}, {GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY, "GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY", "foreign-key"}, {GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK, "GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK", "check"}, {GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT, "GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT", "have-default"}, {GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL, "GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL", "can-be-null"}, {GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT, "GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT", "auto-increment"}, {0, NULL, NULL}};
		GType gda_data_db_field_info_attribute_type_id;
		gda_data_db_field_info_attribute_type_id = g_flags_register_static ("GdaDataDbFieldInfoAttribute", values);
		g_once_init_leave (&gda_data_db_field_info_attribute_type_id__volatile, gda_data_db_field_info_attribute_type_id);
	}
	return gda_data_db_field_info_attribute_type_id__volatile;
}


static gboolean gda_data_db_field_info_real_compatible (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field) {
	gboolean result = FALSE;
	GType _tmp0_;
	GType _tmp1_;
	GdaDataDbFieldInfo* _tmp2_;
	GType _tmp3_;
	GType _tmp4_;
	GdaDataDbFieldInfoAttribute _tmp5_;
	GdaDataDbFieldInfoAttribute _tmp6_;
	g_return_val_if_fail (field != NULL, FALSE);
	_tmp0_ = gda_data_db_field_info_get_value_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = field;
	_tmp3_ = gda_data_db_field_info_get_value_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp1_ != _tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = gda_data_db_field_info_get_attributes (self);
	_tmp6_ = _tmp5_;
	if ((_tmp6_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) {
		GdaDataDbFieldInfo* _tmp7_;
		GdaDataDbFieldInfoAttribute _tmp8_;
		GdaDataDbFieldInfoAttribute _tmp9_;
		_tmp7_ = field;
		_tmp8_ = gda_data_db_field_info_get_attributes (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!((_tmp9_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL)) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


gboolean gda_data_db_field_info_compatible (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->compatible (self, field);
}


static gboolean gda_data_db_field_info_real_equivalent (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GdaDataDbFieldInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GType _tmp5_;
	GType _tmp6_;
	GdaDataDbFieldInfo* _tmp7_;
	GType _tmp8_;
	GType _tmp9_;
	GdaDataDbFieldInfoAttribute _tmp10_;
	GdaDataDbFieldInfoAttribute _tmp11_;
	GdaDataDbFieldInfoAttribute _tmp15_;
	GdaDataDbFieldInfoAttribute _tmp16_;
	GdaDataDbFieldInfoAttribute _tmp20_;
	GdaDataDbFieldInfoAttribute _tmp21_;
	GdaDataDbFieldInfoAttribute _tmp25_;
	GdaDataDbFieldInfoAttribute _tmp26_;
	g_return_val_if_fail (field != NULL, FALSE);
	_tmp0_ = gda_data_db_field_info_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = field;
	_tmp3_ = gda_data_db_field_info_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp1_, _tmp4_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp5_ = gda_data_db_field_info_get_value_type (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = field;
	_tmp8_ = gda_data_db_field_info_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp6_ != _tmp9_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = gda_data_db_field_info_get_attributes (self);
	_tmp11_ = _tmp10_;
	if ((_tmp11_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) {
		GdaDataDbFieldInfo* _tmp12_;
		GdaDataDbFieldInfoAttribute _tmp13_;
		GdaDataDbFieldInfoAttribute _tmp14_;
		_tmp12_ = field;
		_tmp13_ = gda_data_db_field_info_get_attributes (_tmp12_);
		_tmp14_ = _tmp13_;
		if (!((_tmp14_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY)) {
			result = FALSE;
			return result;
		}
	}
	_tmp15_ = gda_data_db_field_info_get_attributes (self);
	_tmp16_ = _tmp15_;
	if ((_tmp16_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE) {
		GdaDataDbFieldInfo* _tmp17_;
		GdaDataDbFieldInfoAttribute _tmp18_;
		GdaDataDbFieldInfoAttribute _tmp19_;
		_tmp17_ = field;
		_tmp18_ = gda_data_db_field_info_get_attributes (_tmp17_);
		_tmp19_ = _tmp18_;
		if (!((_tmp19_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE)) {
			result = FALSE;
			return result;
		}
	}
	_tmp20_ = gda_data_db_field_info_get_attributes (self);
	_tmp21_ = _tmp20_;
	if ((_tmp21_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK) {
		GdaDataDbFieldInfo* _tmp22_;
		GdaDataDbFieldInfoAttribute _tmp23_;
		GdaDataDbFieldInfoAttribute _tmp24_;
		_tmp22_ = field;
		_tmp23_ = gda_data_db_field_info_get_attributes (_tmp22_);
		_tmp24_ = _tmp23_;
		if (!((_tmp24_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK)) {
			result = FALSE;
			return result;
		}
	}
	_tmp25_ = gda_data_db_field_info_get_attributes (self);
	_tmp26_ = _tmp25_;
	if ((_tmp26_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) {
		GdaDataDbFieldInfo* _tmp27_;
		GdaDataDbFieldInfoAttribute _tmp28_;
		GdaDataDbFieldInfoAttribute _tmp29_;
		_tmp27_ = field;
		_tmp28_ = gda_data_db_field_info_get_attributes (_tmp27_);
		_tmp29_ = _tmp28_;
		if (!((_tmp29_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL)) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


gboolean gda_data_db_field_info_equivalent (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->equivalent (self, field);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* gda_data_db_field_info_real_to_string (GdaDataDbFieldInfo* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* fk;
	GdaDataDbFieldInfoForeignKey* _tmp1_;
	GdaDataDbFieldInfoForeignKey* _tmp2_;
	gchar* _tmp6_ = NULL;
	GValue* _tmp7_;
	GValue* _tmp8_;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_ = NULL;
	GType _tmp26_;
	GType _tmp27_;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GdaDataDbFieldInfoAttribute _tmp30_;
	GdaDataDbFieldInfoAttribute _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	_tmp0_ = g_strdup ("");
	fk = _tmp0_;
	_tmp1_ = gda_data_db_field_info_get_fkey (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GdaDataDbFieldInfoForeignKey* _tmp3_;
		GdaDataDbFieldInfoForeignKey* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp3_ = gda_data_db_field_info_get_fkey (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = gda_data_db_field_info_foreign_key_to_string (_tmp4_);
		_g_free0 (fk);
		fk = _tmp5_;
	}
	_tmp7_ = gda_data_db_field_info_get_default_value (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp9_;
	} else {
		GValue* _tmp10_;
		GValue* _tmp11_;
		GValue _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp10_ = gda_data_db_field_info_get_default_value (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = *_tmp11_;
		_tmp13_ = gda_value_stringify (&_tmp12_);
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp13_;
	}
	_tmp15_ = gda_data_db_field_info_get_desc (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == NULL) {
		_tmp14_ = "";
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = gda_data_db_field_info_get_desc (self);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_;
	}
	_tmp19_ = gda_data_db_field_info_get_ordinal (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf ("%i", _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gda_data_db_field_info_get_name (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = string_to_string (_tmp24_);
	_tmp26_ = gda_data_db_field_info_get_value_type (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_type_name (_tmp27_);
	_tmp29_ = string_to_string (_tmp28_);
	_tmp30_ = gda_data_db_field_info_get_attributes (self);
	_tmp31_ = _tmp30_;
	_tmp32_ = gda_data_db_field_info_attribute_to_string (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = fk;
	_tmp35_ = string_to_string (_tmp34_);
	_tmp36_ = g_strconcat ("([", _tmp22_, "],[", _tmp25_, "],[", _tmp29_, "],[%s],[", _tmp33_, "],[%s],[", _tmp35_, "])", NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp6_;
	_tmp39_ = _tmp14_;
	_tmp40_ = g_strdup_printf (_tmp37_, _tmp38_, _tmp39_);
	_tmp41_ = _tmp40_;
	_g_free0 (_tmp37_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp22_);
	result = _tmp41_;
	_g_free0 (_tmp6_);
	_g_free0 (fk);
	return result;
}


gchar* gda_data_db_field_info_to_string (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->to_string (self);
}


gint gda_data_db_field_info_get_ordinal (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_ordinal (self);
}


void gda_data_db_field_info_set_ordinal (GdaDataDbFieldInfo* self, gint value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_ordinal (self, value);
}


GType gda_data_db_field_info_get_value_type (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, 0UL);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_value_type (self);
}


void gda_data_db_field_info_set_value_type (GdaDataDbFieldInfo* self, GType value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_value_type (self, value);
}


GdaDataDbFieldInfoAttribute gda_data_db_field_info_get_attributes (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_attributes (self);
}


void gda_data_db_field_info_set_attributes (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_attributes (self, value);
}


GValue* gda_data_db_field_info_get_default_value (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_default_value (self);
}


void gda_data_db_field_info_set_default_value (GdaDataDbFieldInfo* self, GValue* value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_default_value (self, value);
}


const gchar* gda_data_db_field_info_get_name (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_name (self);
}


void gda_data_db_field_info_set_name (GdaDataDbFieldInfo* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_name (self, value);
}


const gchar* gda_data_db_field_info_get_desc (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_desc (self);
}


void gda_data_db_field_info_set_desc (GdaDataDbFieldInfo* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_desc (self, value);
}


gint gda_data_db_field_info_get_precision (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_precision (self);
}


void gda_data_db_field_info_set_precision (GdaDataDbFieldInfo* self, gint value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_precision (self, value);
}


gint gda_data_db_field_info_get_scale (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_scale (self);
}


void gda_data_db_field_info_set_scale (GdaDataDbFieldInfo* self, gint value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_scale (self, value);
}


GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_get_fkey (GdaDataDbFieldInfo* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->get_fkey (self);
}


void gda_data_db_field_info_set_fkey (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_INFO_GET_INTERFACE (self)->set_fkey (self, value);
}


GdaDataDbFieldInfoForeignKeyMatch* gda_data_db_field_info_foreign_key_match_items (int* result_length1) {
	GdaDataDbFieldInfoForeignKeyMatch* result = NULL;
	GdaDataDbFieldInfoForeignKeyMatch* _tmp0_ = NULL;
	GdaDataDbFieldInfoForeignKeyMatch* _tmp1_;
	gint _tmp1__length1;
	_tmp0_ = g_new0 (GdaDataDbFieldInfoForeignKeyMatch, 3);
	_tmp0_[0] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_NONE;
	_tmp0_[1] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_FULL;
	_tmp0_[2] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_PARTIAL;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


gchar* gda_data_db_field_info_foreign_key_match_to_string (GdaDataDbFieldInfoForeignKeyMatch self) {
	gchar* result = NULL;
	gchar* _tmp2_;
	switch (self) {
		case GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_FULL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("FULL");
			result = _tmp0_;
			return result;
		}
		case GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_PARTIAL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("PARTIAL");
			result = _tmp1_;
			return result;
		}
		default:
		break;
	}
	_tmp2_ = g_strdup ("NONE");
	result = _tmp2_;
	return result;
}


GdaDataDbFieldInfoForeignKeyMatch gda_data_db_field_info_foreign_key_match_from_string (const gchar* str) {
	GdaDataDbFieldInfoForeignKeyMatch result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "FULL") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_FULL;
		return result;
	}
	_tmp1_ = str;
	if (g_strcmp0 (_tmp1_, "PARTIAL") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_PARTIAL;
		return result;
	}
	result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_NONE;
	return result;
}


GType gda_data_db_field_info_foreign_key_match_get_type (void) {
	static volatile gsize gda_data_db_field_info_foreign_key_match_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_info_foreign_key_match_type_id__volatile)) {
		static const GEnumValue values[] = {{GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_NONE, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_NONE", "none"}, {GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_FULL, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_FULL", "full"}, {GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_PARTIAL, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_PARTIAL", "partial"}, {0, NULL, NULL}};
		GType gda_data_db_field_info_foreign_key_match_type_id;
		gda_data_db_field_info_foreign_key_match_type_id = g_enum_register_static ("GdaDataDbFieldInfoForeignKeyMatch", values);
		g_once_init_leave (&gda_data_db_field_info_foreign_key_match_type_id__volatile, gda_data_db_field_info_foreign_key_match_type_id);
	}
	return gda_data_db_field_info_foreign_key_match_type_id__volatile;
}


GdaDataDbFieldInfoForeignKeyRule* gda_data_db_field_info_foreign_key_rule_items (int* result_length1) {
	GdaDataDbFieldInfoForeignKeyRule* result = NULL;
	GdaDataDbFieldInfoForeignKeyRule* _tmp0_ = NULL;
	GdaDataDbFieldInfoForeignKeyRule* _tmp1_;
	gint _tmp1__length1;
	_tmp0_ = g_new0 (GdaDataDbFieldInfoForeignKeyRule, 6);
	_tmp0_[0] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NONE;
	_tmp0_[1] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE;
	_tmp0_[2] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_NULL;
	_tmp0_[3] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT;
	_tmp0_[4] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_RESTRICT;
	_tmp0_[5] = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NO_ACTION;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 6;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


gchar* gda_data_db_field_info_foreign_key_rule_to_string (GdaDataDbFieldInfoForeignKeyRule self) {
	gchar* result = NULL;
	gchar* _tmp5_;
	switch (self) {
		case GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("CASCADE");
			result = _tmp0_;
			return result;
		}
		case GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_NULL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("SET_NULL");
			result = _tmp1_;
			return result;
		}
		case GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SET_DEFAULT");
			result = _tmp2_;
			return result;
		}
		case GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_RESTRICT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("RESTRICT");
			result = _tmp3_;
			return result;
		}
		case GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NO_ACTION:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("NO_ACTION");
			result = _tmp4_;
			return result;
		}
		default:
		break;
	}
	_tmp5_ = g_strdup ("NONE");
	result = _tmp5_;
	return result;
}


GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_rule_from_string (const gchar* str) {
	GdaDataDbFieldInfoForeignKeyRule result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "CASCADE") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE;
		return result;
	}
	_tmp1_ = str;
	if (g_strcmp0 (_tmp1_, "SET_NULL") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_NULL;
		return result;
	}
	_tmp2_ = str;
	if (g_strcmp0 (_tmp2_, "SET NULL") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_NULL;
		return result;
	}
	_tmp3_ = str;
	if (g_strcmp0 (_tmp3_, "SET_DEFAULT") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT;
		return result;
	}
	_tmp4_ = str;
	if (g_strcmp0 (_tmp4_, "SET DEFAULT") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT;
		return result;
	}
	_tmp5_ = str;
	if (g_strcmp0 (_tmp5_, "RESTRICT") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_RESTRICT;
		return result;
	}
	_tmp6_ = str;
	if (g_strcmp0 (_tmp6_, "NO_ACTION") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NO_ACTION;
		return result;
	}
	_tmp7_ = str;
	if (g_strcmp0 (_tmp7_, "NO ACTION") == 0) {
		result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NO_ACTION;
		return result;
	}
	result = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NONE;
	return result;
}


GType gda_data_db_field_info_foreign_key_rule_get_type (void) {
	static volatile gsize gda_data_db_field_info_foreign_key_rule_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_info_foreign_key_rule_type_id__volatile)) {
		static const GEnumValue values[] = {{GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NONE, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NONE", "none"}, {GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE", "cascade"}, {GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_NULL, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_NULL", "set-null"}, {GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT", "set-default"}, {GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_RESTRICT, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_RESTRICT", "restrict"}, {GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NO_ACTION, "GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NO_ACTION", "no-action"}, {0, NULL, NULL}};
		GType gda_data_db_field_info_foreign_key_rule_type_id;
		gda_data_db_field_info_foreign_key_rule_type_id = g_enum_register_static ("GdaDataDbFieldInfoForeignKeyRule", values);
		g_once_init_leave (&gda_data_db_field_info_foreign_key_rule_type_id__volatile, gda_data_db_field_info_foreign_key_rule_type_id);
	}
	return gda_data_db_field_info_foreign_key_rule_type_id__volatile;
}


GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_foreign_key_construct (GType object_type) {
	GdaDataDbFieldInfoForeignKey* self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (GdaDataDbFieldInfoForeignKey*) g_type_create_instance (object_type);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	gda_data_db_field_info_foreign_key_set_refcol (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}


GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_foreign_key_new (void) {
	return gda_data_db_field_info_foreign_key_construct (GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean gda_data_db_field_info_foreign_key_equal (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKey* fkey) {
	gboolean result = FALSE;
	GdaDataDbFieldInfoForeignKey* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GdaDataDbFieldInfoForeignKey* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GdaDataDbFieldInfoForeignKey* _tmp6_;
	GdaDataDbTable* _tmp7_;
	GdaDataDbTable* _tmp8_;
	GdaDataDbFieldInfoForeignKey* _tmp9_;
	GdaDataDbFieldInfoForeignKeyMatch _tmp10_;
	GdaDataDbFieldInfoForeignKeyMatch _tmp11_;
	GdaDataDbFieldInfoForeignKey* _tmp12_;
	GdaDataDbFieldInfoForeignKeyRule _tmp13_;
	GdaDataDbFieldInfoForeignKeyRule _tmp14_;
	GdaDataDbFieldInfoForeignKey* _tmp15_;
	GdaDataDbFieldInfoForeignKeyRule _tmp16_;
	GdaDataDbFieldInfoForeignKeyRule _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (fkey != NULL, FALSE);
	_tmp0_ = fkey;
	_tmp1_ = _tmp0_->priv->_name;
	_tmp2_ = self->priv->_name;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = fkey;
	_tmp4_ = _tmp3_->priv->_refname;
	_tmp5_ = self->priv->_refname;
	if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp6_ = fkey;
	_tmp7_ = _tmp6_->priv->_reftable;
	_tmp8_ = self->priv->_reftable;
	if (_tmp7_ != _tmp8_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = fkey;
	_tmp10_ = _tmp9_->priv->_match;
	_tmp11_ = self->priv->_match;
	if (_tmp10_ != _tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = fkey;
	_tmp13_ = _tmp12_->priv->_update_rule;
	_tmp14_ = self->priv->_update_rule;
	if (_tmp13_ != _tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp15_ = fkey;
	_tmp16_ = _tmp15_->priv->_delete_rule;
	_tmp17_ = self->priv->_delete_rule;
	if (_tmp16_ != _tmp17_) {
		result = FALSE;
		return result;
	}
	{
		GdaDataDbFieldInfoForeignKey* _tmp18_;
		GeeArrayList* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _rc_list;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _rc_size;
		gint _rc_index;
		_tmp18_ = fkey;
		_tmp19_ = _tmp18_->priv->_refcol;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_rc_list = _tmp20_;
		_tmp21_ = _rc_list;
		_tmp22_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_rc_size = _tmp23_;
		_rc_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			GeeArrayList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* rc;
			GeeArrayList* _tmp30_;
			const gchar* _tmp31_;
			gboolean _tmp32_ = FALSE;
			_tmp24_ = _rc_index;
			_rc_index = _tmp24_ + 1;
			_tmp25_ = _rc_index;
			_tmp26_ = _rc_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _rc_list;
			_tmp28_ = _rc_index;
			_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
			rc = (gchar*) _tmp29_;
			_tmp30_ = self->priv->_refcol;
			_tmp31_ = rc;
			_tmp32_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp30_, _tmp31_);
			if (!_tmp32_) {
				result = FALSE;
				_g_free0 (rc);
				_g_object_unref0 (_rc_list);
				return result;
			}
			_g_free0 (rc);
		}
		_g_object_unref0 (_rc_list);
	}
	result = TRUE;
	return result;
}


gchar* gda_data_db_field_info_foreign_key_to_string (GdaDataDbFieldInfoForeignKey* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* s;
	const gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_;
	const gchar* _tmp20_ = NULL;
	GdaDataDbTable* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GdaDataDbFieldInfoForeignKeyMatch _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	GdaDataDbFieldInfoForeignKeyRule _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	GdaDataDbFieldInfoForeignKeyRule _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _str_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _str_size;
		gint _str_index;
		_tmp1_ = self->priv->_refcol;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_str_list = _tmp2_;
		_tmp3_ = _str_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_str_size = _tmp5_;
		_str_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* str;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp6_ = _str_index;
			_str_index = _tmp6_ + 1;
			_tmp7_ = _str_index;
			_tmp8_ = _str_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _str_list;
			_tmp10_ = _str_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			str = (gchar*) _tmp11_;
			_tmp12_ = s;
			_tmp13_ = str;
			_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
			_g_free0 (s);
			s = _tmp16_;
			_g_free0 (_tmp15_);
			_g_free0 (str);
		}
		_g_object_unref0 (_str_list);
	}
	_tmp17_ = self->priv->_name;
	_tmp18_ = string_to_string (_tmp17_);
	_tmp19_ = self->priv->_refname;
	_tmp20_ = string_to_string (_tmp19_);
	_tmp21_ = self->priv->_reftable;
	_tmp22_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = string_to_string (_tmp23_);
	_tmp25_ = s;
	_tmp26_ = string_to_string (_tmp25_);
	_tmp27_ = self->priv->_match;
	_tmp28_ = gda_data_db_field_info_foreign_key_match_to_string (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->_update_rule;
	_tmp31_ = gda_data_db_field_info_foreign_key_rule_to_string (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->_delete_rule;
	_tmp34_ = gda_data_db_field_info_foreign_key_rule_to_string (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat ("{[", _tmp18_, "],[", _tmp20_, "],[", _tmp24_, "],[", _tmp26_, "],[", _tmp29_, "],[", _tmp32_, "],[", _tmp35_, "]}", NULL);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp35_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp29_);
	result = _tmp37_;
	_g_free0 (s);
	return result;
}


const gchar* gda_data_db_field_info_foreign_key_get_name (GdaDataDbFieldInfoForeignKey* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void gda_data_db_field_info_foreign_key_set_name (GdaDataDbFieldInfoForeignKey* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
}


const gchar* gda_data_db_field_info_foreign_key_get_refname (GdaDataDbFieldInfoForeignKey* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_refname;
	result = _tmp0_;
	return result;
}


void gda_data_db_field_info_foreign_key_set_refname (GdaDataDbFieldInfoForeignKey* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_refname);
	self->priv->_refname = _tmp1_;
}


GdaDataDbTable* gda_data_db_field_info_foreign_key_get_reftable (GdaDataDbFieldInfoForeignKey* self) {
	GdaDataDbTable* result;
	GdaDataDbTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reftable;
	result = _tmp0_;
	return result;
}


void gda_data_db_field_info_foreign_key_set_reftable (GdaDataDbFieldInfoForeignKey* self, GdaDataDbTable* value) {
	GdaDataDbTable* _tmp0_;
	GdaDataDbTable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_reftable);
	self->priv->_reftable = _tmp1_;
}


GeeArrayList* gda_data_db_field_info_foreign_key_get_refcol (GdaDataDbFieldInfoForeignKey* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_refcol;
	result = _tmp0_;
	return result;
}


void gda_data_db_field_info_foreign_key_set_refcol (GdaDataDbFieldInfoForeignKey* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_refcol);
	self->priv->_refcol = _tmp1_;
}


GdaDataDbFieldInfoForeignKeyMatch gda_data_db_field_info_foreign_key_get_match (GdaDataDbFieldInfoForeignKey* self) {
	GdaDataDbFieldInfoForeignKeyMatch result;
	GdaDataDbFieldInfoForeignKeyMatch _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_match;
	result = _tmp0_;
	return result;
}


void gda_data_db_field_info_foreign_key_set_match (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyMatch value) {
	GdaDataDbFieldInfoForeignKeyMatch _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_match = _tmp0_;
}


GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_get_update_rule (GdaDataDbFieldInfoForeignKey* self) {
	GdaDataDbFieldInfoForeignKeyRule result;
	GdaDataDbFieldInfoForeignKeyRule _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_update_rule;
	result = _tmp0_;
	return result;
}


void gda_data_db_field_info_foreign_key_set_update_rule (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyRule value) {
	GdaDataDbFieldInfoForeignKeyRule _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_update_rule = _tmp0_;
}


GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_get_delete_rule (GdaDataDbFieldInfoForeignKey* self) {
	GdaDataDbFieldInfoForeignKeyRule result;
	GdaDataDbFieldInfoForeignKeyRule _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_delete_rule;
	result = _tmp0_;
	return result;
}


void gda_data_db_field_info_foreign_key_set_delete_rule (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyRule value) {
	GdaDataDbFieldInfoForeignKeyRule _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_delete_rule = _tmp0_;
}


static void gda_data_db_field_info_value_foreign_key_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gda_data_db_field_info_value_foreign_key_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gda_data_db_field_info_foreign_key_unref (value->data[0].v_pointer);
	}
}


static void gda_data_db_field_info_value_foreign_key_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gda_data_db_field_info_foreign_key_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gda_data_db_field_info_value_foreign_key_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gda_data_db_field_info_value_foreign_key_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GdaDataDbFieldInfoForeignKey* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gda_data_db_field_info_foreign_key_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gda_data_db_field_info_value_foreign_key_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GdaDataDbFieldInfoForeignKey** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gda_data_db_field_info_foreign_key_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GdaDataDbFieldInfoParamSpecForeignKey* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY), NULL);
	return value->data[0].v_pointer;
}


void gda_data_db_field_info_value_set_foreign_key (GValue* value, gpointer v_object) {
	GdaDataDbFieldInfoForeignKey* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gda_data_db_field_info_foreign_key_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gda_data_db_field_info_foreign_key_unref (old);
	}
}


void gda_data_db_field_info_value_take_foreign_key (GValue* value, gpointer v_object) {
	GdaDataDbFieldInfoForeignKey* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gda_data_db_field_info_foreign_key_unref (old);
	}
}


static void gda_data_db_field_info_foreign_key_class_init (GdaDataDbFieldInfoForeignKeyClass * klass) {
	gda_data_db_field_info_foreign_key_parent_class = g_type_class_peek_parent (klass);
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS (klass)->finalize = gda_data_db_field_info_foreign_key_finalize;
	g_type_class_add_private (klass, sizeof (GdaDataDbFieldInfoForeignKeyPrivate));
}


static void gda_data_db_field_info_foreign_key_instance_init (GdaDataDbFieldInfoForeignKey * self) {
	self->priv = GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gda_data_db_field_info_foreign_key_finalize (GdaDataDbFieldInfoForeignKey* obj) {
	GdaDataDbFieldInfoForeignKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_refname);
	_g_object_unref0 (self->priv->_reftable);
	_g_object_unref0 (self->priv->_refcol);
}


GType gda_data_db_field_info_foreign_key_get_type (void) {
	static volatile gsize gda_data_db_field_info_foreign_key_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_info_foreign_key_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gda_data_db_field_info_value_foreign_key_init, gda_data_db_field_info_value_foreign_key_free_value, gda_data_db_field_info_value_foreign_key_copy_value, gda_data_db_field_info_value_foreign_key_peek_pointer, "p", gda_data_db_field_info_value_foreign_key_collect_value, "p", gda_data_db_field_info_value_foreign_key_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataDbFieldInfoForeignKeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_db_field_info_foreign_key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdaDataDbFieldInfoForeignKey), 0, (GInstanceInitFunc) gda_data_db_field_info_foreign_key_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gda_data_db_field_info_foreign_key_type_id;
		gda_data_db_field_info_foreign_key_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GdaDataDbFieldInfoForeignKey", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gda_data_db_field_info_foreign_key_type_id__volatile, gda_data_db_field_info_foreign_key_type_id);
	}
	return gda_data_db_field_info_foreign_key_type_id__volatile;
}


gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance) {
	GdaDataDbFieldInfoForeignKey* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gda_data_db_field_info_foreign_key_unref (gpointer instance) {
	GdaDataDbFieldInfoForeignKey* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void gda_data_db_field_info_base_init (GdaDataDbFieldInfoIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_int ("ordinal", "ordinal", "ordinal", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_gtype ("value-type", "value-type", "value-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_flags ("attributes", "attributes", "attributes", GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("desc", "desc", "desc", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("precision", "precision", "precision", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("scale", "scale", "scale", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, gda_data_db_field_info_param_spec_foreign_key ("fkey", "fkey", "fkey", GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->compatible = gda_data_db_field_info_real_compatible;
		iface->equivalent = gda_data_db_field_info_real_equivalent;
		iface->to_string = gda_data_db_field_info_real_to_string;
	}
}


GType gda_data_db_field_info_get_type (void) {
	static volatile gsize gda_data_db_field_info_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataDbFieldInfoIface), (GBaseInitFunc) gda_data_db_field_info_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gda_data_db_field_info_type_id;
		gda_data_db_field_info_type_id = g_type_register_static (G_TYPE_INTERFACE, "GdaDataDbFieldInfo", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gda_data_db_field_info_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gda_data_db_field_info_type_id__volatile, gda_data_db_field_info_type_id);
	}
	return gda_data_db_field_info_type_id__volatile;
}



