/* Schema.c generated by valac 0.20.1, the Vala compiler
 * generated from Schema.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 *
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())

#define GDA_DATA_TYPE_SCHEMA (gda_data_schema_get_type ())
#define GDA_DATA_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_SCHEMA, GdaDataSchema))
#define GDA_DATA_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_SCHEMA, GdaDataSchemaClass))
#define GDA_DATA_IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_SCHEMA))
#define GDA_DATA_IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_SCHEMA))
#define GDA_DATA_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_SCHEMA, GdaDataSchemaClass))

typedef struct _GdaDataSchema GdaDataSchema;
typedef struct _GdaDataSchemaClass GdaDataSchemaClass;
typedef struct _GdaDataSchemaPrivate GdaDataSchemaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GDA_DATA_TYPE_TABLE (gda_data_table_get_type ())
#define GDA_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_TABLE, GdaDataTable))
#define GDA_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_TABLE, GdaDataTableClass))
#define GDA_DATA_IS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_TABLE))
#define GDA_DATA_IS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_TABLE))
#define GDA_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_TABLE, GdaDataTableClass))

typedef struct _GdaDataTable GdaDataTable;
typedef struct _GdaDataTableClass GdaDataTableClass;

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gboolean (*compatible) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gboolean (*equivalent) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gchar* (*to_string) (GdaDataDbFieldInfo* self);
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gboolean (*equal) (GdaDataDbField* self, GdaDataDbField* field);
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	void (*copy) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	gboolean (*equal) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	gboolean (*compatible) (GdaDataDbTable* self, GdaDataDbTable* table);
	gboolean (*equivalent) (GdaDataDbTable* self, GdaDataDbTable* table);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataSchema {
	GObject parent_instance;
	GdaDataSchemaPrivate * priv;
	GeeHashMap* _tables;
};

struct _GdaDataSchemaClass {
	GObjectClass parent_class;
};

struct _GdaDataSchemaPrivate {
	gboolean _update_meta;
	GdaConnection* _connection;
	gchar* _name;
	GdaDataDbCatalog* _catalog;
};


static gpointer gda_data_schema_parent_class = NULL;
static GdaDataDbObjectIface* gda_data_schema_gda_data_db_object_parent_iface = NULL;
static GdaDataDbNamedObjectIface* gda_data_schema_gda_data_db_named_object_parent_iface = NULL;
static GdaDataDbSchemaIface* gda_data_schema_gda_data_db_schema_parent_iface = NULL;

GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value, gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value, gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_schema_get_type (void) G_GNUC_CONST;
#define GDA_DATA_SCHEMA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GDA_DATA_TYPE_SCHEMA, GdaDataSchemaPrivate))
enum  {
	GDA_DATA_SCHEMA_DUMMY_PROPERTY,
	GDA_DATA_SCHEMA_CONNECTION,
	GDA_DATA_SCHEMA_UPDATE_META,
	GDA_DATA_SCHEMA_NAME,
	GDA_DATA_SCHEMA_CATALOG,
	GDA_DATA_SCHEMA_TABLES
};
static void gda_data_schema_real_update (GdaDataDbObject* base, GError** error);
GdaConnection* gda_data_db_object_get_connection (GdaDataDbObject* self);
GeeCollection* gda_data_db_schema_get_tables (GdaDataDbSchema* self);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
const gchar* gda_data_db_named_object_get_name (GdaDataDbNamedObject* self);
static GValue* _g_value_dup (GValue* self);
GdaDataTable* gda_data_table_new (void);
GdaDataTable* gda_data_table_construct (GType object_type);
GType gda_data_table_get_type (void) G_GNUC_CONST;
void gda_data_db_object_set_connection (GdaDataDbObject* self, GdaConnection* value);
void gda_data_db_named_object_set_name (GdaDataDbNamedObject* self, const gchar* value);
GdaDataDbTableTableType gda_data_db_table_table_type_from_string (const gchar* str);
void gda_data_db_table_set_table_type (GdaDataDbTable* self, GdaDataDbTableTableType value);
void gda_data_db_table_set_schema (GdaDataDbTable* self, GdaDataDbSchema* value);
static void gda_data_schema_real_save (GdaDataDbObject* base, GError** error);
static void gda_data_schema_real_append (GdaDataDbObject* base, GError** error);
static void gda_data_schema_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error);
GdaDataSchema* gda_data_schema_new (void);
GdaDataSchema* gda_data_schema_construct (GType object_type);
static void gda_data_schema_finalize (GObject* obj);
gboolean gda_data_db_object_get_update_meta (GdaDataDbObject* self);
GdaDataDbCatalog* gda_data_db_schema_get_catalog (GdaDataDbSchema* self);
static void _vala_gda_data_schema_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gda_data_db_object_set_update_meta (GdaDataDbObject* self, gboolean value);
void gda_data_db_schema_set_catalog (GdaDataDbSchema* self, GdaDataDbCatalog* value);
static void _vala_gda_data_schema_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void gda_data_schema_real_update (GdaDataDbObject* base, GError** error) {
	GdaDataSchema * self;
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	GdaConnection* _tmp2_;
	GdaConnection* _tmp3_;
	GdaMetaStore* _tmp4_ = NULL;
	GdaMetaStore* _tmp5_;
	GdaMetaStore* store;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* vals;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GValue _tmp14_ = {0};
	GValue v;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	GValue _tmp17_;
	GValue _tmp18_;
	GValue* _tmp19_;
	GdaMetaStore* _tmp20_;
	GHashTable* _tmp21_;
	GdaDataModel* _tmp22_ = NULL;
	GdaDataModel* mt;
	GError * _inner_error_ = NULL;
	self = (GdaDataSchema*) base;
	_tmp0_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp1_ = _tmp0_;
	gda_connection_update_meta_store (_tmp1_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gda_connection_get_meta_store (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	store = _tmp5_;
	_tmp6_ = gda_data_db_schema_get_tables ((GdaDataDbSchema*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gee_collection_clear (_tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, __vala_GValue_free0_);
	vals = _tmp11_;
	_tmp12_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self);
	_tmp13_ = _tmp12_;
	g_value_init (&_tmp14_, G_TYPE_STRING);
	g_value_set_string (&_tmp14_, _tmp13_);
	v = _tmp14_;
	_tmp15_ = vals;
	_tmp16_ = g_strdup ("name");
	_tmp17_ = v;
	_tmp18_ = _tmp17_;
	_tmp19_ = __g_value_dup0 (&_tmp18_);
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp19_);
	_tmp20_ = store;
	_tmp21_ = vals;
	_tmp22_ = gda_meta_store_extract_v (_tmp20_, "SELECT * FROM _tables WHERE schema_name = ##name::string", _tmp21_, &_inner_error_);
	mt = _tmp22_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		_g_hash_table_unref0 (vals);
		_g_object_unref0 (store);
		return;
	}
	{
		gint r;
		r = 0;
		{
			gboolean _tmp23_;
			_tmp23_ = TRUE;
			while (TRUE) {
				gboolean _tmp24_;
				gint _tmp26_;
				GdaDataModel* _tmp27_;
				gint _tmp28_ = 0;
				GdaDataTable* _tmp29_;
				GdaDataTable* t;
				GdaDataTable* _tmp30_;
				GdaConnection* _tmp31_;
				GdaConnection* _tmp32_;
				GdaDataModel* _tmp33_;
				GdaDataModel* _tmp34_;
				gint _tmp35_ = 0;
				gint _tmp36_;
				GValue* _tmp37_ = NULL;
				GValue* _tmp38_;
				GdaDataTable* _tmp39_;
				GdaDataModel* _tmp40_;
				GdaDataModel* _tmp41_;
				gint _tmp42_ = 0;
				gint _tmp43_;
				GValue* _tmp44_ = NULL;
				GValue* _tmp45_;
				GdaDataTable* _tmp46_;
				GdaDataDbTableTableType _tmp47_ = 0;
				GdaDataTable* _tmp48_;
				GeeCollection* _tmp49_;
				GeeCollection* _tmp50_;
				GeeCollection* _tmp51_;
				GdaDataTable* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				GdaDataTable* _tmp55_;
				_tmp24_ = _tmp23_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = r;
					r = _tmp25_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp26_ = r;
				_tmp27_ = mt;
				_tmp28_ = gda_data_model_get_n_rows (_tmp27_);
				if (!(_tmp26_ < _tmp28_)) {
					break;
				}
				_tmp29_ = gda_data_table_new ();
				t = _tmp29_;
				_tmp30_ = t;
				_tmp31_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp32_ = _tmp31_;
				gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp30_, _tmp32_);
				_tmp33_ = mt;
				_tmp34_ = mt;
				_tmp35_ = gda_data_model_get_column_index (_tmp34_, "table_name");
				_tmp36_ = r;
				_tmp37_ = gda_data_model_get_value_at (_tmp33_, _tmp35_, _tmp36_, &_inner_error_);
				_tmp38_ = _tmp37_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (t);
					_g_object_unref0 (mt);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					return;
				}
				_tmp39_ = t;
				gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp39_, g_value_get_string (_tmp38_));
				_tmp40_ = mt;
				_tmp41_ = mt;
				_tmp42_ = gda_data_model_get_column_index (_tmp41_, "table_type");
				_tmp43_ = r;
				_tmp44_ = gda_data_model_get_value_at (_tmp40_, _tmp42_, _tmp43_, &_inner_error_);
				_tmp45_ = _tmp44_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (t);
					_g_object_unref0 (mt);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					return;
				}
				_tmp46_ = t;
				_tmp47_ = gda_data_db_table_table_type_from_string (g_value_get_string (_tmp45_));
				gda_data_db_table_set_table_type ((GdaDataDbTable*) _tmp46_, _tmp47_);
				_tmp48_ = t;
				gda_data_db_table_set_schema ((GdaDataDbTable*) _tmp48_, (GdaDataDbSchema*) self);
				_tmp49_ = gda_data_db_schema_get_tables ((GdaDataDbSchema*) self);
				_tmp50_ = _tmp49_;
				_tmp51_ = _tmp50_;
				_tmp52_ = t;
				_tmp53_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = t;
				g_object_set ((GObject*) _tmp51_, _tmp54_, _tmp55_, NULL);
				_g_object_unref0 (_tmp51_);
				_g_object_unref0 (t);
			}
		}
	}
	_g_object_unref0 (mt);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	_g_hash_table_unref0 (vals);
	_g_object_unref0 (store);
}


static void gda_data_schema_real_save (GdaDataDbObject* base, GError** error) {
	GdaDataSchema * self;
	self = (GdaDataSchema*) base;
}


static void gda_data_schema_real_append (GdaDataDbObject* base, GError** error) {
	GdaDataSchema * self;
	self = (GdaDataSchema*) base;
}


static void gda_data_schema_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error) {
	GdaDataSchema * self;
	self = (GdaDataSchema*) base;
}


GdaDataSchema* gda_data_schema_construct (GType object_type) {
	GdaDataSchema * self = NULL;
	self = (GdaDataSchema*) g_object_new (object_type, NULL);
	return self;
}


GdaDataSchema* gda_data_schema_new (void) {
	return gda_data_schema_construct (GDA_DATA_TYPE_SCHEMA);
}


static GdaConnection* gda_data_schema_real_get_connection (GdaDataDbObject* base) {
	GdaConnection* result;
	GdaDataSchema* self;
	GdaConnection* _tmp0_;
	self = (GdaDataSchema*) base;
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static void gda_data_schema_real_set_connection (GdaDataDbObject* base, GdaConnection* value) {
	GdaDataSchema* self;
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	self = (GdaDataSchema*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	g_object_notify ((GObject *) self, "connection");
}


static gboolean gda_data_schema_real_get_update_meta (GdaDataDbObject* base) {
	gboolean result;
	GdaDataSchema* self;
	gboolean _tmp0_;
	self = (GdaDataSchema*) base;
	_tmp0_ = self->priv->_update_meta;
	result = _tmp0_;
	return result;
}


static void gda_data_schema_real_set_update_meta (GdaDataDbObject* base, gboolean value) {
	GdaDataSchema* self;
	gboolean _tmp0_;
	self = (GdaDataSchema*) base;
	_tmp0_ = value;
	self->priv->_update_meta = _tmp0_;
	g_object_notify ((GObject *) self, "update-meta");
}


static const gchar* gda_data_schema_real_get_name (GdaDataDbNamedObject* base) {
	const gchar* result;
	GdaDataSchema* self;
	const gchar* _tmp0_;
	self = (GdaDataSchema*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void gda_data_schema_real_set_name (GdaDataDbNamedObject* base, const gchar* value) {
	GdaDataSchema* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GdaDataSchema*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static GdaDataDbCatalog* gda_data_schema_real_get_catalog (GdaDataDbSchema* base) {
	GdaDataDbCatalog* result;
	GdaDataSchema* self;
	GdaDataDbCatalog* _tmp0_;
	self = (GdaDataSchema*) base;
	_tmp0_ = self->priv->_catalog;
	result = _tmp0_;
	return result;
}


static void gda_data_schema_real_set_catalog (GdaDataDbSchema* base, GdaDataDbCatalog* value) {
	GdaDataSchema* self;
	GdaDataDbCatalog* _tmp0_;
	GdaDataDbCatalog* _tmp1_;
	self = (GdaDataSchema*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_catalog);
	self->priv->_catalog = _tmp1_;
	g_object_notify ((GObject *) self, "catalog");
}


static GeeCollection* gda_data_schema_real_get_tables (GdaDataDbSchema* base) {
	GeeCollection* result;
	GdaDataSchema* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (GdaDataSchema*) base;
	_tmp0_ = self->_tables;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void gda_data_schema_class_init (GdaDataSchemaClass * klass) {
	gda_data_schema_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GdaDataSchemaPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gda_data_schema_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gda_data_schema_set_property;
	G_OBJECT_CLASS (klass)->finalize = gda_data_schema_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_SCHEMA_CONNECTION, g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_SCHEMA_UPDATE_META, g_param_spec_boolean ("update-meta", "update-meta", "update-meta", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_SCHEMA_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_SCHEMA_CATALOG, g_param_spec_object ("catalog", "catalog", "catalog", GDA_DATA_TYPE_DB_CATALOG, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_SCHEMA_TABLES, g_param_spec_object ("tables", "tables", "tables", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gda_data_schema_gda_data_db_object_interface_init (GdaDataDbObjectIface * iface) {
	gda_data_schema_gda_data_db_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->update = (void (*)(GdaDataDbObject*, GError**)) gda_data_schema_real_update;
	iface->save = (void (*)(GdaDataDbObject*, GError**)) gda_data_schema_real_save;
	iface->append = (void (*)(GdaDataDbObject*, GError**)) gda_data_schema_real_append;
	iface->drop = (void (*)(GdaDataDbObject*, gboolean, GError**)) gda_data_schema_real_drop;
	iface->get_connection = gda_data_schema_real_get_connection;
	iface->set_connection = gda_data_schema_real_set_connection;
	iface->get_update_meta = gda_data_schema_real_get_update_meta;
	iface->set_update_meta = gda_data_schema_real_set_update_meta;
}


static void gda_data_schema_gda_data_db_named_object_interface_init (GdaDataDbNamedObjectIface * iface) {
	gda_data_schema_gda_data_db_named_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = gda_data_schema_real_get_name;
	iface->set_name = gda_data_schema_real_set_name;
}


static void gda_data_schema_gda_data_db_schema_interface_init (GdaDataDbSchemaIface * iface) {
	gda_data_schema_gda_data_db_schema_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_catalog = gda_data_schema_real_get_catalog;
	iface->set_catalog = gda_data_schema_real_set_catalog;
	iface->get_tables = gda_data_schema_real_get_tables;
}


static void gda_data_schema_instance_init (GdaDataSchema * self) {
	GeeHashMap* _tmp0_;
	self->priv = GDA_DATA_SCHEMA_GET_PRIVATE (self);
	self->priv->_update_meta = FALSE;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDA_DATA_TYPE_DB_TABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_tables = _tmp0_;
}


static void gda_data_schema_finalize (GObject* obj) {
	GdaDataSchema * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GDA_DATA_TYPE_SCHEMA, GdaDataSchema);
	_g_object_unref0 (self->_tables);
	_g_object_unref0 (self->priv->_connection);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_catalog);
	G_OBJECT_CLASS (gda_data_schema_parent_class)->finalize (obj);
}


GType gda_data_schema_get_type (void) {
	static volatile gsize gda_data_schema_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_schema_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataSchemaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_schema_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdaDataSchema), 0, (GInstanceInitFunc) gda_data_schema_instance_init, NULL };
		static const GInterfaceInfo gda_data_db_object_info = { (GInterfaceInitFunc) gda_data_schema_gda_data_db_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_named_object_info = { (GInterfaceInitFunc) gda_data_schema_gda_data_db_named_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_schema_info = { (GInterfaceInitFunc) gda_data_schema_gda_data_db_schema_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gda_data_schema_type_id;
		gda_data_schema_type_id = g_type_register_static (G_TYPE_OBJECT, "GdaDataSchema", &g_define_type_info, 0);
		g_type_add_interface_static (gda_data_schema_type_id, GDA_DATA_TYPE_DB_OBJECT, &gda_data_db_object_info);
		g_type_add_interface_static (gda_data_schema_type_id, GDA_DATA_TYPE_DB_NAMED_OBJECT, &gda_data_db_named_object_info);
		g_type_add_interface_static (gda_data_schema_type_id, GDA_DATA_TYPE_DB_SCHEMA, &gda_data_db_schema_info);
		g_once_init_leave (&gda_data_schema_type_id__volatile, gda_data_schema_type_id);
	}
	return gda_data_schema_type_id__volatile;
}


static void _vala_gda_data_schema_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GdaDataSchema * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GDA_DATA_TYPE_SCHEMA, GdaDataSchema);
	switch (property_id) {
		case GDA_DATA_SCHEMA_CONNECTION:
		g_value_set_object (value, gda_data_db_object_get_connection ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_SCHEMA_UPDATE_META:
		g_value_set_boolean (value, gda_data_db_object_get_update_meta ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_SCHEMA_NAME:
		g_value_set_string (value, gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self));
		break;
		case GDA_DATA_SCHEMA_CATALOG:
		g_value_set_object (value, gda_data_db_schema_get_catalog ((GdaDataDbSchema*) self));
		break;
		case GDA_DATA_SCHEMA_TABLES:
		g_value_take_object (value, gda_data_db_schema_get_tables ((GdaDataDbSchema*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gda_data_schema_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GdaDataSchema * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GDA_DATA_TYPE_SCHEMA, GdaDataSchema);
	switch (property_id) {
		case GDA_DATA_SCHEMA_CONNECTION:
		gda_data_db_object_set_connection ((GdaDataDbObject*) self, g_value_get_object (value));
		break;
		case GDA_DATA_SCHEMA_UPDATE_META:
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, g_value_get_boolean (value));
		break;
		case GDA_DATA_SCHEMA_NAME:
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) self, g_value_get_string (value));
		break;
		case GDA_DATA_SCHEMA_CATALOG:
		gda_data_db_schema_set_catalog ((GdaDataDbSchema*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



