/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Finalizer;
import java.lang.ref.ReferenceQueue;
import sun.misc.CVM;
import sun.misc.ThreadRegistry;

public abstract class Reference {
    private Object referent;
    Reference next;
    ReferenceQueue queue;
    private static Object lock = new Object();
    private static Reference pending;

    static void handleAllEnqueued() {
        while (pending != null) {
            Reference reference;
            Reference reference2 = reference.next;
            reference = pending;
            pending = reference2 == reference ? null : reference2;
            reference.next = reference;
            ReferenceQueue referenceQueue = reference.queue;
            if (referenceQueue == ReferenceQueue.NULL) continue;
            referenceQueue.enqueue(reference);
        }
    }

    private static void createReferenceHandlerThread() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new ReferenceHandler(threadGroup, "Reference Handler");
        ((Thread)object).setPriority(10);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private static void restartReferenceThreads() {
        ThreadRegistry.resetExitRequest();
        Reference.createReferenceHandlerThread();
        Finalizer.startFinalizerThread();
    }

    private static void stopReferenceThreads() {
        ThreadRegistry.waitAllSystemThreadsExit();
        System.gc();
        System.gc();
        System.gc();
    }

    public Object get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.queue != ReferenceQueue.NULL && this.next != null;
        }
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    Reference(Object object) {
        this(object, null);
    }

    Reference(Object object, ReferenceQueue referenceQueue) {
        this.referent = object;
        this.queue = referenceQueue == null ? ReferenceQueue.NULL : referenceQueue;
    }

    static {
        if (!CVM.objectInflatePermanently(lock)) {
            throw new OutOfMemoryError();
        }
        pending = null;
        if (CVM.inMainLVM()) {
            Reference.createReferenceHandlerThread();
        }
    }

    private static class ReferenceHandler
    extends Thread {
        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ThreadRegistry.exitRequested()) {
                Reference reference;
                CVM.setThreadNoCompilationsFlag(true);
                Object object = lock;
                synchronized (object) {
                    if (pending == null) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    Reference reference2 = reference.next;
                    reference = pending;
                    pending = reference2 == reference ? null : reference2;
                    reference.next = reference;
                }
                CVM.setThreadNoCompilationsFlag(false);
                object = reference.queue;
                if (object == ReferenceQueue.NULL) continue;
                ((ReferenceQueue)object).enqueue(reference);
            }
        }
    }
}

