# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20170908113148;

my $formatters = [
                {
                  'pattern' => '(\\d{8})',
                  'leading_digits' => '56161'
                },
                {
                  'leading_digits' => '
            600|
            7(?:
              0|
              19[0-5]|
              2(?:
                [0235-79]|
                [14][017-9]|
                8(?:
                  [0-69]|
                  [78][089]
                )
              )|
              3(?:
                [05-8]|
                1(?:
                  [0189]|
                  7[5-9]
                )|
                2(?:
                  [0-49][089]|
                  [5-8]
                )|
                3[017-9]|
                4(?:
                  [07-9]|
                  11
                )|
                9(?:
                  [01689]|
                  [2-5][089]|
                  7[0189]
                )
              )|
              4(?:
                [056]|
                1(?:
                  [0135-9]|
                  [24][089]
                )|
                [29](?:
                  [0-7][089]|
                  [89]
                )|
                3(?:
                  [0-8][089]|
                  9
                )|
                [47](?:
                  [089]|
                  11|
                  7[02-8]
                )|
                8(?:
                  [0-24-7][089]|
                  [389]
                )
              )|
              5(?:
                [0346-9]|
                [15][017-9]|
                2(?:
                  [03-9]|
                  [12][089]
                )
              )|
              6(?:
                [0346-9]|
                1[0-257-9]|
                2(?:
                  [0-4]|
                  [5-9][089]
                )|
                5(?:
                  [0-367][089]|
                  [4589]
                )
              )|
              7(?:
                0(?:
                  [02-9]|
                  1[089]
                )|
                [1-9]
              )|
              8(?:
                [0-79]|
                8(?:
                  0[0189]|
                  11|
                  8[013-9]|
                  9
                )
              )|
              9(?:
                [089]|
                313|
                7(?:
                  [02-8]|
                  9[07-9]
                )
              )
            )|
            8(?:
              0(?:
                [01589]|
                6[67]|
                7(?:
                  [02-8]|
                  9[05-9]
                )
              )|
              1(?:
                [02-57-9]|
                1(?:
                  [0-35-9]|
                  4[0-46-9]
                )|
                6(?:
                  [089]|
                  7[02-8]
                )
              )|
              2(?:
                0(?:
                  [089]|
                  7[02]
                )|
                [14](?:
                  [089]|
                  7[02-8]
                )|
                [235-9]
              )|
              3(?:
                [0357-9]|
                1(?:
                  [089]|
                  7[02-6]
                )|
                2(?:
                  [09]|
                  77|
                  8[0-689]
                )|
                4(?:
                  0[1-7]|
                  [1-9]
                )|
                6(?:
                  [089]|
                  7[02-7]
                )
              )|
              [45]|
              6(?:
                [02457-9]|
                [136](?:
                  [089]|
                  7[02-8]
                )
              )|
              7(?:
                0[07-9]|
                [1-69]|
                [78](?:
                  [089]|
                  7[02-8]
                )
              )|
              8(?:
                [0-25-9]|
                3(?:
                  [089]|
                  7[02-8]
                )|
                4(?:
                  [0489]|
                  7[02-68]
                )
              )|
              9(?:
                [02-9]|
                1(?:
                  [0289]|
                  7[2-6]
                )
              )
            )|
            9
          ',
                  'pattern' => '(\\d{5})(\\d{5})'
                },
                {
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})',
                  'leading_digits' => '
            11|
            2[02]|
            33|
            4[04]|
            79[1-9]|
            80[2-46]
          '
                },
                {
                  'leading_digits' => '
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              [68][1-9]|
              7[1257]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[1-3]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[0-24-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              5[12]|
              [78]1|
              9[15]
            )|
            6(?:
              12|
              [2-4]1|
              5[17]|
              6[13]|
              7[14]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1|
              88
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          ',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'leading_digits' => '
            1(?:
              [23579]|
              [468][1-9]
            )|
            [2-8]
          ',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3})'
                },
                {
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})(\\d{3})',
                  'leading_digits' => '008'
                },
                {
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})',
                  'leading_digits' => '140'
                },
                {
                  'leading_digits' => '1600',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'leading_digits' => '1800',
                  'pattern' => '(\\d{4})(\\d{4,5})'
                },
                {
                  'leading_digits' => '1800',
                  'pattern' => '(\\d{4})(\\d{2,4})(\\d{4})'
                },
                {
                  'leading_digits' => '1860',
                  'pattern' => '(\\d{4})(\\d{3,4})(\\d{4})'
                },
                {
                  'leading_digits' => '18[06]',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'pager' => '',
                'personal_number' => '',
                'geographic' => '
          (?:
            11|
            2[02]|
            33|
            4[04]|
            79
          )[2-7]\\d{7}|
          3880\\d{6}|
          80[2-467]\\d{7}|
          (?:
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[014]|
              7[1257]|
              8[01346]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[1-3]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[0-24-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              [36][25]|
              22|
              4[28]|
              5[12]|
              [78]1|
              9[15]
            )|
            6(?:
              12|
              [2345]1|
              57|
              6[13]|
              7[14]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1|
              88
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          )[2-7]\\d{6}|
          (?:
            (?:
              1(?:
                2[35-8]|
                3[346-9]|
                4[236-9]|
                [59][0235-9]|
                6[235-9]|
                7[34689]|
                8[257-9]
              )|
              2(?:
                1[134689]|
                3[24-8]|
                4[2-8]|
                5[25689]|
                6[2-4679]|
                7[13-79]|
                8[2-479]|
                9[235-9]
              )|
              3(?:
                01|
                1[79]|
                2[1-5]|
                4[25-8]|
                5[125689]|
                6[235-7]|
                7[157-9]|
                8[2-467]
              )|
              4(?:
                1[14578]|
                2[5689]|
                3[2-467]|
                5[4-7]|
                6[35]|
                73|
                8[2689]|
                9[2389]
              )|
              5(?:
                [16][146-9]|
                2[14-8]|
                3[1346]|
                4[14-69]|
                5[46]|
                7[2-4]|
                8[2-8]|
                9[246]
              )|
              6(?:
                1[1358]|
                2[2457]|
                3[2-4]|
                4[235-7]|
                [57][2-689]|
                6[24-578]|
                8[1-6]
              )|
              8(?:
                1[1357-9]|
                2[235-8]|
                3[03-57-9]|
                4[0-24-9]|
                5\\d|
                6[2457-9]|
                7[1-6]|
                8[1256]|
                9[2-4]
              )
            )\\d|
            7(?:
              (?:
                1[013-9]|
                2[0235-9]|
                3[2679]|
                4[1-35689]|
                5[2-46-9]|
                [67][02-9]|
                9\\d
              )\\d|
              8(?:
                2[0-6]|
                [013-8]\\d
              )
            )
          )[2-7]\\d{5}
        ',
                'voip' => '',
                'mobile' => '
          (?:
            600[1-3]\\d|
            7(?:
              0\\d{3}|
              19[0-5]\\d|
              2(?:
                [0235679]\\d{2}|
                [14][017-9]\\d|
                8(?:
                  [0-59]\\d|
                  [678][089]
                )
              )|
              3(?:
                [05-8]\\d{2}|
                1(?:
                  [089]\\d|
                  11|
                  7[5-8]
                )|
                2(?:
                  [0-49][089]|
                  [5-8]\\d
                )|
                3[017-9]\\d|
                4(?:
                  [07-9]\\d|
                  11
                )|
                9(?:
                  [016-9]\\d|
                  [2-5][089]
                )
              )|
              4(?:
                0\\d{2}|
                1(?:
                  [015-9]\\d|
                  [23][089]|
                  4[089]
                )|
                2(?:
                  0[089]|
                  [1-7][089]|
                  [89]\\d
                )|
                3(?:
                  [0-8][089]|
                  9\\d
                )|
                4(?:
                  [089]\\d|
                  11|
                  7[02-8]
                )|
                [56]\\d[089]|
                7(?:
                  [089]\\d|
                  11|
                  7[02-8]
                )|
                8(?:
                  [0-24-7][089]|
                  [389]\\d
                )|
                9(?:
                  [0-6][089]|
                  7[089]|
                  [89]\\d
                )
              )|
              5(?:
                [0346-8]\\d{2}|
                1(?:
                  [07-9]\\d|
                  11
                )|
                2(?:
                  [04-9]\\d|
                  [123][089]
                )|
                5[017-9]\\d|
                9(?:
                  [0-6][089]|
                  [7-9]\\d
                )
              )|
              6(?:
                0(?:
                  [0-47]\\d|
                  [5689][089]
                )|
                (?:
                  1[0-257-9]|
                  [6-9]\\d
                )\\d|
                2(?:
                  [0-4]\\d|
                  [5-9][089]
                )|
                3(?:
                  [02-8][089]|
                  [19]\\d
                )|
                4\\d[089]|
                5(?:
                  [0-367][089]|
                  [4589]\\d
                )
              )|
              7(?:
                0(?:
                  0[02-9]|
                  [13-6][089]|
                  [289]\\d|
                  7[89]
                )|
                [1-9]\\d{2}
              )|
              8(?:
                [0-79]\\d{2}|
                8(?:
                  [089]\\d|
                  11|
                  7[02-9]
                )
              )|
              9(?:
                [089]\\d{2}|
                313|
                7(?:
                  [02-8]\\d|
                  9[07-9]
                )
              )
            )|
            8(?:
              0(?:
                [01589]\\d{2}|
                6[67]\\d|
                7(?:
                  [02-8]\\d|
                  9[05-9]
                )
              )|
              1(?:
                [02-57-9]\\d{2}|
                1(?:
                  [0-35-9]\\d|
                  4[0-46-9]
                )|
                6(?:
                  [089]\\d|
                  7[02-8]
                )
              )|
              2(?:
                0(?:
                  [089]\\d|
                  7[02]
                )|
                [14](?:
                  [089]\\d|
                  7[02-8]
                )|
                [235-9]\\d{2}
              )|
              3(?:
                [0357-9]\\d{2}|
                1(?:
                  [089]\\d|
                  7[02-6]
                )|
                2(?:
                  [09]\\d|
                  77|
                  8[0-689]
                )|
                4(?:
                  0[1-7]|
                  [1-9]\\d
                )|
                6(?:
                  [089]\\d|
                  7[02-7]
                )
              )|
              [45]\\d{3}|
              6(?:
                [02457-9]\\d{2}|
                1(?:
                  [089]\\d|
                  7[02-8]
                )|
                3(?:
                  [089]\\d|
                  7[02-8]
                )|
                6(?:
                  [08]\\d|
                  7[02-8]|
                  9\\d
                )
              )|
              7(?:
                0[07-9]\\d|
                [1-69]\\d{2}|
                [78](?:
                  [089]\\d|
                  7[02-8]
                )
              )|
              8(?:
                [0-25-9]\\d{2}|
                3(?:
                  [089]\\d|
                  7[02-8]
                )|
                4(?:
                  [0489]\\d|
                  7[02-68]
                )
              )|
              9(?:
                [02-9]\\d{2}|
                1(?:
                  [0289]\\d|
                  7[2-6]
                )
              )
            )|
            9\\d{4}
          )\\d{5}
        ',
                'toll_free' => '
          00800\\d{7}|
          1(?:
            600\\d{6}|
            80(?:
              0\\d{4,9}|
              3\\d{9}
            )
          )
        ',
                'specialrate' => '(1860\\d{7})|(186[12]\\d{9})|(140\\d{7})',
                'fixed_line' => '
          (?:
            11|
            2[02]|
            33|
            4[04]|
            79
          )[2-7]\\d{7}|
          3880\\d{6}|
          80[2-467]\\d{7}|
          (?:
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[014]|
              7[1257]|
              8[01346]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[1-3]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[0-24-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              [36][25]|
              22|
              4[28]|
              5[12]|
              [78]1|
              9[15]
            )|
            6(?:
              12|
              [2345]1|
              57|
              6[13]|
              7[14]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1|
              88
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          )[2-7]\\d{6}|
          (?:
            (?:
              1(?:
                2[35-8]|
                3[346-9]|
                4[236-9]|
                [59][0235-9]|
                6[235-9]|
                7[34689]|
                8[257-9]
              )|
              2(?:
                1[134689]|
                3[24-8]|
                4[2-8]|
                5[25689]|
                6[2-4679]|
                7[13-79]|
                8[2-479]|
                9[235-9]
              )|
              3(?:
                01|
                1[79]|
                2[1-5]|
                4[25-8]|
                5[125689]|
                6[235-7]|
                7[157-9]|
                8[2-467]
              )|
              4(?:
                1[14578]|
                2[5689]|
                3[2-467]|
                5[4-7]|
                6[35]|
                73|
                8[2689]|
                9[2389]
              )|
              5(?:
                [16][146-9]|
                2[14-8]|
                3[1346]|
                4[14-69]|
                5[46]|
                7[2-4]|
                8[2-8]|
                9[246]
              )|
              6(?:
                1[1358]|
                2[2457]|
                3[2-4]|
                4[235-7]|
                [57][2-689]|
                6[24-578]|
                8[1-6]
              )|
              8(?:
                1[1357-9]|
                2[235-8]|
                3[03-57-9]|
                4[0-24-9]|
                5\\d|
                6[2457-9]|
                7[1-6]|
                8[1256]|
                9[2-4]
              )
            )\\d|
            7(?:
              (?:
                1[013-9]|
                2[0235-9]|
                3[2679]|
                4[1-35689]|
                5[2-46-9]|
                [67][02-9]|
                9\\d
              )\\d|
              8(?:
                2[0-6]|
                [013-8]\\d
              )
            )
          )[2-7]\\d{5}
        '
              };
my %areanames = (
  9111 => "New\ Delhi",
  91120 => "Ghaziabad\/Dadri\,\ Uttar\ Pradesh",
  91121 => "Meerut\,\ Uttar\ Pradesh",
  91122 => "Hapur\,\ Uttar\ Pradesh",
  911232 => "Modinagar\,\ Uttar\ Pradesh",
  911233 => "Mawana\,\ Uttar\ Pradesh",
  911234 => "Baghpat\/Baraut\,\ Uttar\ Pradesh",
  911237 => "Sardhana\,\ Uttar\ Pradesh",
  91124 => "Gurgaon\,\ Haryana",
  911250 => "Charkhidadri\,\ Haryana",
  911251 => "Jhajjar\,\ Haryana",
  911252 => "Loharu\,\ Haryana",
  911253 => "Tohsham\,\ Haryana",
  911254 => "Bawanikhera\,\ Haryana",
  911255 => "Siwani\,\ Haryana",
  911257 => "Meham\,\ Haryana",
  911258 => "Kalanaur\,\ Haryana",
  911259 => "Kosli\,\ Haryana",
  911262 => "Rohtak\,\ Haryana",
  911263 => "Gohana\,\ Haryana",
  911267 => "Nuh\,\ Haryana",
  911268 => "Ferojpur\,\ Haryana",
  911274 => "Rewari\,\ Haryana",
  911275 => "Palwal\,\ Haryana",
  911276 => "Bahadurgarh\,\ Haryana",
  911281 => "Jatusana\,\ Haryana",
  911282 => "Narnaul\,\ Haryana",
  911284 => "Bawal\,\ Haryana",
  911285 => "Mohindergarh\,\ Haryana",
  91129 => "Faridabad\,\ Haryana",
  91130 => "Sonipat\,\ Haryana",
  91131 => "Muzaffarnagar\,\ Uttar\ Pradesh",
  91132 => "Saharanpur\,\ Uttar\ Pradesh",
  911331 => "Nakur\/Gangoh\,\ Uttar\ Pradesh",
  911332 => "Roorkee\,\ Uttarakhand",
  911334 => "Roorkee\/Haridwar\,\ Uttarakhand",
  911336 => "Deoband\,\ Uttar\ Pradesh",
  911341 => "Najibabad\,\ Uttar\ Pradesh",
  911342 => "Bijnor\,\ Uttar\ Pradesh",
  911343 => "Nagina\,\ Uttar\ Pradesh",
  911344 => "Dhampur\,\ Uttar\ Pradesh",
  911345 => "Bijnor\/Chandpur\,\ Uttar\ Pradesh",
  911346 => "Pauri\/Bubakhal\,\ Uttarakhand",
  911348 => "Lansdowne\/Syunsi\,\ Uttarakhand",
  91135 => "Dehradun\,\ Uttarakhand",
  911360 => "Dehradun\ Chakrata\/Dakpattar\,\ Uttarakhand",
  911363 => "Karnaprayag\,\ Uttarakhand",
  911364 => "Ukhimath\/Guptkashi\,\ Uttarakhand",
  911368 => "Pauri\,\ Uttarakhand",
  911370 => "Devprayag\/Jakholi\,\ Uttarakhand",
  911371 => "Dunda\,\ Uttarakhand",
  911372 => "Chamoli\,\ Uttarakhand",
  911373 => "Purola\,\ Uttarakhand",
  911374 => "Bhatwari\/Uttarkashi\,\ Uttarakhand",
  911375 => "Rajgarhi\,\ Uttarakhand",
  911376 => "Tehri\,\ Uttarakhand",
  911377 => "Bhatwari\/Gangotri\,\ Uttarakhand",
  911378 => "Devprayag\,\ Uttarakhand",
  911379 => "Pratapnagar\,\ Uttarakhand",
  911381 => "Joshimath\/Badrinath\,\ Uttarakhand",
  911382 => "Lansdowne\/Kotdwara\,\ Uttarakhand",
  911386 => "Lansdowne\,\ Uttarakhand",
  911389 => "Joshimath\,\ Uttarakhand",
  911392 => "Budhana\,\ Uttar\ Pradesh",
  911396 => "Jansath\/Khatauli\,\ Uttar\ Pradesh",
  911398 => "Kairana\/Shamli\,\ Uttar\ Pradesh",
  91141 => "Jaipur\,\ Rajasthan",
  911420 => "Baswa\/Bandikui\,\ Rajasthan",
  911421 => "Kotputli\,\ Rajasthan",
  911422 => "Viratnagar\/Shahpura\,\ Rajasthan",
  911423 => "Amber\/Chomu\,\ Rajasthan",
  911424 => "Phulera\/Renwal\,\ Rajasthan",
  911425 => "Phulera\/Sambhar\,\ Rajasthan",
  911426 => "Jamwa\ Ramgarh\/Achrol\,\ Rajasthan",
  911427 => "Dausa\,\ Rajasthan",
  911428 => "Dudu\,\ Rajasthan",
  911429 => "Bassi\,\ Rajasthan",
  911430 => "Phagi\,\ Rajasthan",
  911431 => "Lalsot\,\ Rajasthan",
  911432 => "Tonk\,\ Rajasthan",
  911433 => "Todaraisingh\,\ Rajasthan",
  911434 => "Deoli\,\ Rajasthan",
  911435 => "Tonk\/Piploo\,\ Rajasthan",
  911436 => "Uniayara\,\ Rajasthan",
  911437 => "Malpura\,\ Rajasthan",
  911438 => "Newai\,\ Rajasthan",
  91144 => "Alwar\,\ Rajasthan",
  91145 => "Ajmer\,\ Rajasthan",
  911460 => "Kishangarhbas\/Khairthal\,\ Rajasthan",
  911461 => "Bansur\,\ Rajasthan",
  911462 => "Beawar\,\ Rajasthan",
  911463 => "Kishangarh\,\ Rajasthan",
  911464 => "Rajgarh\,\ Rajasthan",
  911465 => "Thanaghazi\,\ Rajasthan",
  911466 => "Kekri\,\ Rajasthan",
  911467 => "Kekri\,\ Rajasthan",
  911468 => "Ramgarh\,\ Rajasthan",
  911469 => "Tijara\,\ Rajasthan",
  911470 => "Dungla\,\ Rajasthan",
  911471 => "Rashmi\,\ Rajasthan",
  911472 => "Chittorgarh\,\ Rajasthan",
  911473 => "Barisadri\,\ Rajasthan",
  911474 => "Begun\,\ Rajasthan",
  911475 => "Begun\/Rawatbhata\,\ Rajasthan",
  911476 => "Kapasan\,\ Rajasthan",
  911477 => "Nimbahera\,\ Rajasthan",
  911478 => "Pratapgarh\,\ Rajasthan",
  911479 => "Pratapgarh\/Arnod\,\ Rajasthan",
  911480 => "Asind\,\ Rajasthan",
  911481 => "Raipur\,\ Rajasthan",
  911482 => "Bhilwara\,\ Rajasthan",
  911483 => "Hurda\/Gulabpura\,\ Rajasthan",
  911484 => "Shahapura\,\ Rajasthan",
  911485 => "Jahazpur\,\ Rajasthan",
  911486 => "Mandal\,\ Rajasthan",
  911487 => "Banera\,\ Rajasthan",
  911488 => "Kotri\,\ Rajasthan",
  911489 => "Mandalgarh\,\ Rajasthan",
  911491 => "Nasirabad\,\ Rajasthan",
  911492 => "Laxmangarh\/Kherli\,\ Rajasthan",
  911493 => "Tijara\,\ Rajasthan",
  911494 => "Behror\,\ Rajasthan",
  911495 => "Mandawar\,\ Rajasthan",
  911496 => "Sarwar\,\ Rajasthan",
  911497 => "Kishangarh\,\ Rajasthan",
  911498 => "Anupgarh\,\ Rajasthan",
  911499 => "Sangaria\,\ Rajasthan",
  911501 => "Srikaranpur\,\ Rajasthan",
  911502 => "Nohar\/Jedasar\,\ Rajasthan",
  911503 => "Sadulshahar\,\ Rajasthan",
  911504 => "Bhadra\,\ Rajasthan",
  911505 => "Padampur\,\ Rajasthan",
  911506 => "Anupgarh\/Gharsana\,\ Rajasthan",
  911507 => "Raisinghnagar\,\ Rajasthan",
  911508 => "Suratgarh\/Goluwala\,\ Rajasthan",
  911509 => "Suratgarh\,\ Rajasthan",
  91151 => "Bikaner\,\ Rajasthan",
  911520 => "Bikaner\/Chhatargarh\,\ Rajasthan",
  911521 => "Bikaner\/Jaimalsar\,\ Rajasthan",
  911522 => "Bikaner\/Jamsar\,\ Rajasthan",
  911523 => "Bikaner\/Poogal\,\ Rajasthan",
  911526 => "Lunkaransar\/Mahajan\,\ Rajasthan",
  911527 => "Lunkaransar\/Rajasarb\,\ Rajasthan",
  911528 => "Lunkaransar\,\ Rajasthan",
  911529 => "Lunkaransar\/Kanholi\,\ Rajasthan",
  911531 => "Nokha\,\ Rajasthan",
  911532 => "Nokha\/Nathusar\,\ Rajasthan",
  911533 => "Kolayat\/Goddo\,\ Rajasthan",
  911534 => "Kolayat\,\ Rajasthan",
  911535 => "Kolayat\/Bajju\,\ Rajasthan",
  911536 => "Kolayat\/Daitra\,\ Rajasthan",
  911537 => "Nohar\/Rawatsar\,\ Rajasthan",
  911539 => "Tibbi\,\ Rajasthan",
  91154 => "Sriganganagar\,\ Rajasthan",
  911552 => "Hanumangarh\,\ Rajasthan",
  911555 => "Nohar\,\ Rajasthan",
  911559 => "Rajgarh\,\ Rajasthan",
  911560 => "Sujangarh\/Bidasar\,\ Rajasthan",
  911561 => "Taranagar\,\ Rajasthan",
  911562 => "Churu\,\ Rajasthan",
  911563 => "Sardarshahar\/Jaitsisar\,\ Rajasthan",
  911564 => "Sardarshahar\,\ Rajasthan",
  911565 => "Sri\ Dungargarh\,\ Rajasthan",
  911566 => "Sri\ Dungargarh\/Sudsar\,\ Rajasthan",
  911567 => "Ratangarh\,\ Rajasthan",
  911568 => "Sujangarh\,\ Rajasthan",
  911569 => "Sujangarh\/Lalgarh\,\ Rajasthan",
  911570 => "Laxmangarh\/Nechwa\,\ Rajasthan",
  911571 => "Fatehpur\,\ Rajasthan",
  911572 => "Sikar\,\ Rajasthan",
  911573 => "Laxmangarh\,\ Rajasthan",
  911574 => "Neem\ Ka\ Thana\,\ Rajasthan",
  911575 => "Srimadhopur\,\ Rajasthan",
  911576 => "Dantaramgarh\/Shyamji\,\ Rajasthan",
  911577 => "Dantaramgarh\,\ Rajasthan",
  911580 => "Deedwana\,\ Rajasthan",
  911581 => "Ladnun\,\ Rajasthan",
  911582 => "Nagaur\,\ Rajasthan",
  911583 => "Jayal\,\ Rajasthan",
  911584 => "Nagaur\/Mundwa\ Marwar\,\ Rajasthan",
  911585 => "Nagaur\/Khinwsar\,\ Rajasthan",
  911586 => "Nawa\/Kuchamancity\,\ Rajasthan",
  911587 => "Degana\,\ Rajasthan",
  911588 => "Parbatsar\/Makrana\,\ Rajasthan",
  911589 => "Parbatsar\,\ Rajasthan",
  911590 => "Merta\,\ Rajasthan",
  911591 => "Merta\/Gotan\,\ Rajasthan",
  911592 => "Jhunjhunu\,\ Rajasthan",
  911593 => "Khetri\,\ Rajasthan",
  911594 => "Udaipurwati\,\ Rajasthan",
  911595 => "Jhunjhunu\/Bissau\,\ Rajasthan",
  911596 => "Chirawa\,\ Rajasthan",
  91160 => "Kharar\,\ Punjab",
  91161 => "Ludhiana\,\ Punjab",
  911624 => "Jagraon\,\ Punjab",
  911628 => "Samrala\,\ Punjab",
  911632 => "Ferozepur\,\ Punjab",
  911633 => "Muktasar\,\ Punjab",
  911634 => "Abohar\,\ Punjab",
  911635 => "Kotkapura\,\ Punjab",
  911636 => "Moga\,\ Punjab",
  911637 => "Malaut\,\ Punjab",
  911638 => "Fazilka\,\ Punjab",
  911639 => "Faridakot\,\ Punjab",
  91164 => "Bhatinda\,\ Punjab",
  911651 => "Phulmandi\,\ Punjab",
  911652 => "Mansa\,\ Punjab",
  911655 => "Raman\,\ Punjab",
  911659 => "Sardulgarh\,\ Punjab",
  911662 => "Hissar\,\ Haryana",
  911663 => "Hansi\,\ Haryana",
  911664 => "Bhiwani\,\ Haryana",
  911666 => "Sirsa\,\ Haryana",
  911667 => "Fatehabad\,\ Haryana",
  911668 => "Dabwali\,\ Haryana",
  911669 => "Adampur\ Mandi\,\ Haryana",
  911672 => "Sangrur\,\ Punjab",
  911675 => "Malerkotla\,\ Punjab",
  911676 => "Sunam\,\ Punjab",
  911679 => "Barnala\,\ Punjab",
  911681 => "Jind\,\ Haryana",
  911682 => "Zira\,\ Punjab",
  911683 => "Julana\,\ Haryana",
  911684 => "Narwana\,\ Haryana",
  911685 => "Guruharsahai\,\ Punjab",
  911686 => "Safidon\,\ Haryana",
  911692 => "Tohana\,\ Haryana",
  911693 => "Barwala\,\ Haryana",
  911696 => "Kalanwali\,\ Haryana",
  911697 => "Ratia\,\ Haryana",
  911698 => "Ellenabad\,\ Haryana",
  911702 => "Nahan\,\ Himachal\ Pradesh",
  911704 => "Paonta\,\ Himachal\ Pradesh",
  91171 => "Ambala\,\ Haryana",
  91172 => "Chandigarh\,\ Punjab",
  911731 => "Barara\,\ Haryana",
  911732 => "Jagadhari\,\ Haryana",
  911733 => "Kalka\,\ Haryana",
  911734 => "Naraingarh\,\ Haryana",
  911735 => "Chaaharauli\,\ Haryana",
  911741 => "Pehowa\,\ Haryana",
  911743 => "Cheeka\,\ Haryana",
  911744 => "Kurukshetra\,\ Haryana",
  911745 => "Nilokheri\,\ Haryana",
  911746 => "Kaithal\,\ Haryana",
  911748 => "Gharaunda\,\ Haryana",
  911749 => "Assandh\,\ Haryana",
  91175 => "Patiala\,\ Punjab",
  911762 => "Rajpura\,\ Punjab",
  911763 => "Sarhind\,\ Punjab",
  911764 => "Samana\,\ Punjab",
  911765 => "Nabha\,\ Punjab",
  91177 => "Shimla\,\ Himachal\ Pradesh",
  911781 => "Rohru\,\ Himachal\ Pradesh",
  911782 => "Rampur\ Bushahar\,\ Himachal\ Pradesh",
  911783 => "Theog\,\ Himachal\ Pradesh",
  911785 => "Pooh\,\ Himachal\ Pradesh",
  911786 => "Kalpa\,\ Himachal\ Pradesh",
  911792 => "Solan\,\ Himachal\ Pradesh",
  911795 => "Nalagarh\,\ Himachal\ Pradesh",
  911796 => "Arki\,\ Himachal\ Pradesh",
  911799 => "Rajgarh\,\ Himachal\ Pradesh",
  91180 => "Panipat\,\ Haryana",
  91181 => "Jallandhar\,\ Punjab",
  911821 => "Nakodar\,\ Punjab",
  911822 => "Kapurthala\,\ Punjab",
  911823 => "Nawanshahar\,\ Punjab",
  911824 => "Phagwara\,\ Punjab",
  911826 => "Phillaur\,\ Punjab",
  911828 => "Sultanpur\ Lodhi\,\ Punjab",
  91183 => "Amritsar\,\ Punjab",
  91184 => "Karnal\,\ Haryana",
  911851 => "Patti\,\ Punjab",
  911852 => "Taran\,\ Punjab",
  911853 => "Rayya\,\ Punjab",
  911858 => "Ajnala\,\ Punjab",
  911859 => "Goindwal\,\ Punjab",
  91186 => "Pathankot\,\ Punjab",
  911870 => "Jugial\,\ Punjab",
  911871 => "Batala\,\ Punjab",
  911872 => "Quadian\,\ Punjab",
  911874 => "Gurdaspur\,\ Punjab",
  911875 => "Dinanagar\,\ Punjab",
  911881 => "Ropar\,\ Punjab",
  911882 => "Hoshiarpur\,\ Punjab",
  911883 => "Dasua\,\ Punjab",
  911884 => "Garhashanker\,\ Punjab",
  911885 => "Balachaur\,\ Punjab",
  911886 => "Tanda\ Urmar\,\ Punjab",
  911887 => "Nangal\,\ Punjab",
  911892 => "Kangra\/Dharamsala\,\ Himachal\ Pradesh",
  911893 => "Nurpur\,\ Himachal\ Pradesh",
  911894 => "Palampur\,\ Himachal\ Pradesh",
  911895 => "Bharmour\,\ Himachal\ Pradesh",
  911896 => "Churah\/Tissa\,\ Himachal\ Pradesh",
  911897 => "Pangi\/Killar\,\ Himachal\ Pradesh",
  911899 => "Chamba\,\ Himachal\ Pradesh",
  911900 => "Lahul\/Keylong\,\ Himachal\ Pradesh",
  911902 => "Kullu\,\ Himachal\ Pradesh",
  911903 => "Banjar\,\ Himachal\ Pradesh",
  911904 => "Nirmand\,\ Himachal\ Pradesh",
  911905 => "Mandi\,\ Himachal\ Pradesh",
  911906 => "Spiti\/Kaza\,\ Himachal\ Pradesh",
  911907 => "Sundernagar\,\ Himachal\ Pradesh",
  911908 => "Jogindernagar\,\ Himachal\ Pradesh",
  911909 => "Udaipur\,\ Himachal\ Pradesh",
  91191 => "Jammu\,\ Jammu\ And\ Kashmir",
  911921 => "Basholi\,\ Jammu\ And\ Kashmir",
  911922 => "Kathua\,\ Jammu\ And\ Kashmir",
  911923 => "Samba\,\ Jammu\ And\ Kashmir",
  911924 => "Akhnoor\,\ Jammu\ And\ Kashmir",
  911931 => "Kulgam\,\ Jammu\ And\ Kashmir",
  911932 => "Anantnag\,\ Jammu\ And\ Kashmir",
  911933 => "Pulwama\,\ Jammu\ And\ Kashmir",
  911936 => "Pahalgam\,\ Jammu\ And\ Kashmir",
  91194 => "Srinagar\,\ Jammu\ And\ Kashmir",
  911951 => "Badgam\,\ Jammu\ And\ Kashmir",
  911952 => "Baramulla\,\ Jammu\ And\ Kashmir",
  911954 => "Sopore\,\ Jammu\ And\ Kashmir",
  911955 => "Kupwara\,\ Jammu\ And\ Kashmir",
  911956 => "Uri\,\ Jammu\ And\ Kashmir",
  911957 => "Bandipur\,\ Jammu\ And\ Kashmir",
  911958 => "Karnah\,\ Jammu\ And\ Kashmir",
  911960 => "Nowshera\,\ Jammu\ And\ Kashmir",
  911962 => "Rajouri\,\ Jammu\ And\ Kashmir",
  911964 => "Kalakot\,\ Jammu\ And\ Kashmir",
  911965 => "Poonch\,\ Jammu\ And\ Kashmir",
  911970 => "Dehra\ Gopipur\,\ Himachal\ Pradesh",
  911972 => "Hamirpur\,\ Himachal\ Pradesh",
  911975 => "Una\,\ Himachal\ Pradesh",
  911976 => "Amb\,\ Himachal\ Pradesh",
  911978 => "Bilaspur\,\ Himachal\ Pradesh",
  911980 => "Nobra\,\ Jammu\ And\ Kashmir",
  911981 => "Nyoma\,\ Jammu\ And\ Kashmir",
  911982 => "Leh\,\ Jammu\ And\ Kashmir",
  911983 => "Zanaskar\,\ Jammu\ And\ Kashmir",
  911985 => "Kargil\,\ Jammu\ And\ Kashmir",
  911990 => "Ramnagar\,\ Jammu\ And\ Kashmir",
  911991 => "Reasi\,\ Jammu\ And\ Kashmir",
  911992 => "Udhampur\,\ Jammu\ And\ Kashmir",
  911995 => "Kishtwar\,\ Jammu\ And\ Kashmir",
  911996 => "Doda\,\ Jammu\ And\ Kashmir",
  911997 => "Bedarwah\,\ Jammu\ And\ Kashmir",
  911998 => "Ramban\,\ Jammu\ And\ Kashmir",
  911999 => "Mahore\,\ Jammu\ And\ Kashmir",
  9120 => "Pune\,\ Maharashtra",
  912111 => "Indapur\,\ Maharashtra",
  912112 => "Baramati\,\ Maharashtra",
  912113 => "Bhor\,\ Maharashtra",
  912114 => "Lonavala\,\ Maharashtra",
  912115 => "Saswad\,\ Maharashtra",
  912117 => "Daund\,\ Maharashtra",
  912118 => "Walchandnagar\,\ Maharashtra",
  912119 => "Kedgaon\,\ Maharashtra",
  91212 => "Chinchwad\,\ Maharashtra",
  912130 => "Velhe\,\ Maharashtra",
  912132 => "Junnar\,\ Maharashtra",
  912133 => "Manchar\,\ Maharashtra",
  912135 => "Rajgurunagar\,\ Maharashtra",
  912136 => "Urlikanchan\,\ Maharashtra",
  912137 => "Nahavara\,\ Maharashtra",
  912138 => "Shirur\,\ Maharashtra",
  912139 => "Pirangut\,\ Maharashtra",
  912140 => "Mangaon\,\ Maharashtra",
  912141 => "Alibagh\,\ Maharashtra",
  912142 => "Pali\,\ Maharashtra",
  912143 => "Pen\,\ Maharashtra",
  912144 => "Murud\,\ Maharashtra",
  912145 => "Mahad\,\ Maharashtra",
  912147 => "Shrivardhan\,\ Maharashtra",
  912148 => "Karjat\,\ Maharashtra",
  912149 => "Mahasala\,\ Maharashtra",
  91215 => "Navi\ Mumbai\/Turbhe\,\ Maharashtra",
  912160 => "Sakarwadi\,\ Maharashtra",
  912161 => "Vaduj\,\ Maharashtra",
  912162 => "Satara\,\ Maharashtra",
  912163 => "Koregaon\,\ Maharashtra",
  912164 => "Karad\,\ Maharashtra",
  912165 => "Dhiwadi\,\ Maharashtra",
  912166 => "Phaltan\,\ Maharashtra",
  912167 => "Wai\,\ Maharashtra",
  912168 => "Mahabaleswar\,\ Maharashtra",
  912169 => "Shirwal\,\ Maharashtra",
  91217 => "Sholapur\,\ Maharashtra",
  912181 => "Akkalkot\,\ Maharashtra",
  912182 => "Karmala\,\ Maharashtra",
  912183 => "Madha\,\ Maharashtra",
  912184 => "Barsi\,\ Maharashtra",
  912185 => "Malsuras\,\ Maharashtra",
  912186 => "Pandharpur\,\ Maharashtra",
  912187 => "Sangola\,\ Maharashtra",
  912188 => "Mangalwedha\,\ Maharashtra",
  912189 => "Mohol\,\ Maharashtra",
  912191 => "Poladpur\,\ Maharashtra",
  912192 => "Khopoli\,\ Maharashtra",
  912194 => "Roha\,\ Maharashtra",
  9122 => "Mumbai",
  91230 => "Khadakwasala\,\ Maharashtra",
  91231 => "Kolhapur\,\ Maharashtra",
  912320 => "Chandgad\,\ Maharashtra",
  912321 => "Radhanagar\,\ Maharashtra",
  912322 => "Shirol\/Jalsingpur\,\ Maharashtra",
  912323 => "Ajara\,\ Maharashtra",
  912324 => "Hatkangale\/Ichalkaranji\,\ Maharashtra",
  912325 => "Kagal\/Murgud\,\ Maharashtra",
  912326 => "Gaganbavada\,\ Maharashtra",
  912327 => "Gadhinglaj\,\ Maharashtra",
  912328 => "Panhala\,\ Maharashtra",
  912329 => "Shahuwadi\/Malakapur\,\ Maharashtra",
  91233 => "Sangli\,\ Maharashtra",
  912341 => "Kavathemankal\,\ Maharashtra",
  912342 => "Islampur\,\ Maharashtra",
  912343 => "Atpadi\,\ Maharashtra",
  912344 => "Jath\,\ Maharashtra",
  912345 => "Shirala\,\ Maharashtra",
  912346 => "Tasgaon\,\ Maharashtra",
  912347 => "Vita\,\ Maharashtra",
  912350 => "Madangad\,\ Maharashtra",
  912351 => "Langa\,\ Maharashtra",
  912352 => "Ratnagiri\,\ Maharashtra",
  912353 => "Rajapur\,\ Maharashtra",
  912354 => "Sanganeshwar\/Deorukh\,\ Maharashtra",
  912355 => "Chiplun\,\ Maharashtra",
  912356 => "Khed\,\ Maharashtra",
  912357 => "Malgund\,\ Maharashtra",
  912358 => "Dapoli\,\ Maharashtra",
  912359 => "Guhagar\,\ Maharashtra",
  912362 => "Kudal\,\ Maharashtra",
  912363 => "Sawantwadi\,\ Maharashtra",
  912364 => "Deogad\,\ Maharashtra",
  912365 => "Malwan\,\ Maharashtra",
  912366 => "Vengurla\,\ Maharashtra",
  912367 => "Kankavali\,\ Maharashtra",
  912371 => "Wathar\,\ Maharashtra",
  912372 => "Patan\,\ Maharashtra",
  912373 => "Mahaswad\,\ Maharashtra",
  912375 => "Pusegaon\,\ Maharashtra",
  912378 => "Medha\,\ Maharashtra",
  912381 => "Ahmedpur\,\ Maharashtra",
  912382 => "Latur\,\ Maharashtra",
  912383 => "Ausa\,\ Maharashtra",
  912384 => "Nilanga\,\ Maharashtra",
  912385 => "Udgir\,\ Maharashtra",
  91241 => "Ahmednagar\,\ Maharashtra",
  912421 => "Jamkhed\,\ Maharashtra",
  912422 => "Shri\ Rampur\,\ Maharashtra",
  912423 => "Koparagon\,\ Maharashtra",
  912424 => "Akole\,\ Maharashtra",
  912425 => "Sangamner\,\ Maharashtra",
  912426 => "Rahuri\,\ Maharashtra",
  912427 => "Newasa\,\ Maharashtra",
  912428 => "Pathardi\,\ Maharashtra",
  912429 => "Shevgaon\,\ Maharashtra",
  912430 => "Sillod\,\ Maharashtra",
  912431 => "Paithan\,\ Maharashtra",
  912432 => "Aurangabad\,\ Maharashtra",
  912433 => "Gangapur\,\ Maharashtra",
  912435 => "Kannad\,\ Maharashtra",
  912436 => "Vijapur\,\ Maharashtra",
  912437 => "Khultabad\,\ Maharashtra",
  912438 => "Soyegaon\,\ Maharashtra",
  912439 => "Golegaon\,\ Maharashtra",
  912441 => "Ashti\,\ Maharashtra",
  912442 => "Bhir\,\ Maharashtra",
  912443 => "Manjalegaon\,\ Maharashtra",
  912444 => "Patoda\,\ Maharashtra",
  912445 => "Kaij\,\ Maharashtra",
  912446 => "Ambejogai\,\ Maharashtra",
  912447 => "Gevrai\,\ Maharashtra",
  912451 => "Pathari\,\ Maharashtra",
  912452 => "Parbhani\,\ Maharashtra",
  912453 => "Gangakhed\,\ Maharashtra",
  912454 => "Basmatnagar\,\ Maharashtra",
  912455 => "Kalamnuri\,\ Maharashtra",
  912456 => "Hingoli\,\ Maharashtra",
  912457 => "Jintdor\,\ Maharashtra",
  912460 => "Delhi\ Tanda\,\ Maharashtra",
  912461 => "Mukhed\,\ Maharashtra",
  912462 => "Nanded\,\ Maharashtra",
  912463 => "Degloor\,\ Maharashtra",
  912465 => "Billoli\,\ Maharashtra",
  912466 => "Kandhar\,\ Maharashtra",
  912467 => "Bhokar\,\ Maharashtra",
  912468 => "Hadgaon\,\ Maharashtra",
  912469 => "Kinwat\,\ Maharashtra",
  912471 => "Tuljapur\,\ Maharashtra",
  912472 => "Osmanabad\,\ Maharashtra",
  912473 => "Kallam\,\ Maharashtra",
  912475 => "Omerga\,\ Maharashtra",
  912477 => "Paranda\,\ Maharashtra",
  912478 => "Bhoom\,\ Maharashtra",
  912481 => "Ner\,\ Maharashtra",
  912482 => "Jalna\,\ Maharashtra",
  912483 => "Ambad\,\ Maharashtra",
  912484 => "Partur\,\ Maharashtra",
  912485 => "Bhokardan\,\ Maharashtra",
  912487 => "Shrigonda\,\ Maharashtra",
  912488 => "Parner\,\ Maharashtra",
  912489 => "Karjat\,\ Maharashtra",
  91250 => "Bassein\,\ Maharashtra",
  91251 => "Kalyan\,\ Maharashtra",
  912520 => "Jawahar\,\ Maharashtra",
  912521 => "Talasari\,\ Maharashtra",
  912522 => "Bhiwandi\,\ Maharashtra",
  912524 => "Murbad\,\ Maharashtra",
  912525 => "Palghar\,\ Maharashtra",
  912526 => "Wada\,\ Maharashtra",
  912527 => "Shahapur\,\ Maharashtra",
  912528 => "Dahanu\,\ Maharashtra",
  912529 => "Mokhada\,\ Maharashtra",
  91253 => "Nasik\ City\,\ Maharashtra",
  912550 => "Niphad\,\ Maharashtra",
  912551 => "Sinnar\,\ Maharashtra",
  912552 => "Nandgaon\,\ Maharashtra",
  912553 => "Igatpuri\,\ Maharashtra",
  912554 => "Malegaon\,\ Maharashtra",
  912555 => "Satana\,\ Maharashtra",
  912556 => "Chanwad\,\ Maharashtra",
  912557 => "Dindori\,\ Maharashtra",
  912558 => "Peint\,\ Maharashtra",
  912559 => "Yeola\,\ Maharashtra",
  912560 => "Kusumba\,\ Maharashtra",
  912561 => "Pimpalner\,\ Maharashtra",
  912562 => "Dhule\,\ Maharashtra",
  912563 => "Shirpur\,\ Maharashtra",
  912564 => "Nandurbar\,\ Maharashtra",
  912565 => "Shahada\,\ Maharashtra",
  912566 => "Sindkheda\,\ Maharashtra",
  912567 => "Taloda\,\ Maharashtra",
  912568 => "Sakri\,\ Maharashtra",
  912569 => "Navapur\,\ Maharashtra",
  91257 => "Jalgaon\,\ Maharashtra",
  912580 => "Jamner\,\ Maharashtra",
  912582 => "Bhusawal\,\ Maharashtra",
  912583 => "Edalabad\,\ Maharashtra",
  912584 => "Raver\,\ Maharashtra",
  912585 => "Yawal\,\ Maharashtra",
  912586 => "Chopda\,\ Maharashtra",
  912587 => "Amalner\,\ Maharashtra",
  912588 => "Erandul\,\ Maharashtra",
  912589 => "Chalisgaon\,\ Maharashtra",
  912591 => "Manmad\,\ Maharashtra",
  912592 => "Kalwan\,\ Maharashtra",
  912593 => "Surgena\,\ Maharashtra",
  912594 => "Trimbak\,\ Maharashtra",
  912595 => "Dhadgaon\,\ Maharashtra",
  912596 => "Pachora\,\ Maharashtra",
  912597 => "Parola\,\ Maharashtra",
  912598 => "Umrane\,\ Maharashtra",
  912599 => "Bhudargad\/Gargoti\,\ Maharashtra",
  91260 => "Vapi\,\ Gujarat",
  91261 => "Surat\,\ Gujarat",
  912621 => "Sayan\,\ Gujarat",
  912622 => "Bardoli\,\ Gujarat",
  912623 => "Mandvi\,\ Gujarat",
  912624 => "Fortsongadh\,\ Gujarat",
  912625 => "Valod\,\ Gujarat",
  912626 => "Vyara\,\ Gujarat",
  912628 => "Nizar\,\ Gujarat",
  912629 => "M\.M\.Mangrol\,\ Gujarat",
  912630 => "Bansada\,\ Gujarat",
  912631 => "Ahwa\,\ Gujarat",
  912632 => "Valsad\,\ Gujarat",
  912633 => "Dharampur\,\ Gujarat",
  912634 => "Billimora\,\ Gujarat",
  912637 => "Navsari\,\ Gujarat",
  912640 => "Rajpipla\,\ Gujarat",
  912641 => "Amod\,\ Gujarat",
  912642 => "Bharuch\,\ Gujarat",
  912643 => "Valia\,\ Gujarat",
  912644 => "Jambusar\,\ Gujarat",
  912645 => "Jhagadia\,\ Gujarat",
  912646 => "Ankleshwar\,\ Gujarat",
  912649 => "Dediapada\,\ Gujarat",
  91265 => "Vadodara\,\ Gujarat",
  912661 => "Naswadi\,\ Gujarat",
  912662 => "Padra\,\ Gujarat",
  912663 => "Dabhoi\,\ Gujarat",
  912664 => "Pavijetpur\,\ Gujarat",
  912665 => "Sankheda\,\ Gujarat",
  912666 => "Miyagam\,\ Gujarat",
  912667 => "Savli\,\ Gujarat",
  912668 => "Waghodia\,\ Gujarat",
  912669 => "Chhota\ Udaipur\,\ Gujarat",
  912670 => "Shehra\,\ Gujarat",
  912672 => "Godhra\,\ Gujarat",
  912673 => "Dahod\,\ Gujarat",
  912674 => "Lunavada\,\ Gujarat",
  912675 => "Santrampur\,\ Gujarat",
  912676 => "Halol\,\ Gujarat",
  912677 => "Limkheda\,\ Gujarat",
  912678 => "Devgadhbaria\,\ Gujarat",
  912679 => "Jhalod\,\ Gujarat",
  91268 => "Nadiad\,\ Gujarat",
  912690 => "Balasinor\,\ Gujarat",
  912691 => "Kapad\ Wanj\,\ Gujarat",
  912692 => "Anand\,\ Gujarat",
  912694 => "Kheda\,\ Gujarat",
  912696 => "Borsad\,\ Gujarat",
  912697 => "Retlad\,\ Gujarat",
  912698 => "Khambat\,\ Gujarat",
  912699 => "Thasra\,\ Gujarat",
  912711 => "Barwala\,\ Gujarat",
  912712 => "Gandhi\ Nagar\,\ Gujarat",
  912713 => "Dhandhuka\,\ Gujarat",
  912714 => "Dholka\,\ Gujarat",
  912715 => "Viramgam\,\ Gujarat",
  912716 => "Dehgam\,\ Gujarat",
  912717 => "Sanand\,\ Gujarat",
  912718 => "Bareja\,\ Gujarat",
  912733 => "Harij\,\ Gujarat",
  912734 => "Chanasma\,\ Gujarat",
  912735 => "Deodar\,\ Gujarat",
  912737 => "Tharad\,\ Gujarat",
  912738 => "Santalpur\,\ Gujarat",
  912739 => "Vadgam\,\ Gujarat",
  912740 => "Vav\,\ Gujarat",
  912742 => "Palanpur\,\ Gujarat",
  912744 => "Deesa\,\ Gujarat",
  912746 => "Radhanpur\,\ Gujarat",
  912747 => "Thara\,\ Gujarat",
  912748 => "Dhanera\,\ Gujarat",
  912749 => "Danta\,\ Gujarat",
  912751 => "Chotila\,\ Gujarat",
  912752 => "Surendranagar\,\ Gujarat",
  912753 => "Limbdi\,\ Gujarat",
  912754 => "Dhrangadhra\,\ Gujarat",
  912755 => "Sayla\,\ Gujarat",
  912756 => "Muli\,\ Gujarat",
  912757 => "Dasada\,\ Gujarat",
  912758 => "Halvad\,\ Gujarat",
  912759 => "Lakhtar\,\ Gujarat",
  912761 => "Kheralu\,\ Gujarat",
  912762 => "Mehsana\,\ Gujarat",
  912763 => "Vijapur\,\ Gujarat",
  912764 => "Kalol\,\ Gujarat",
  912765 => "Visnagar\,\ Gujarat",
  912766 => "Patan\,\ Gujarat",
  912767 => "Sidhpur\,\ Gujarat",
  912770 => "Prantij\,\ Gujarat",
  912771 => "Bhiloda\,\ Gujarat",
  912772 => "Himatnagar\,\ Gujarat",
  912773 => "Malpur\,\ Gujarat",
  912774 => "Modasa\,\ Gujarat",
  912775 => "Khedbrahma\,\ Gujarat",
  912778 => "Idar\,\ Gujarat",
  912779 => "Bayad\,\ Gujarat",
  91278 => "Bhavnagar\,\ Gujarat",
  912791 => "Babra\,\ Gujarat",
  912792 => "Amreli\,\ Gujarat",
  912793 => "Damnagar\,\ Gujarat",
  912794 => "Rajula\,\ Gujarat",
  912795 => "Kodinar\,\ Gujarat",
  912796 => "Kunkawav\,\ Gujarat",
  912797 => "Dhari\,\ Gujarat",
  912801 => "Ranavav\,\ Gujarat",
  912803 => "Khavda\,\ Gujarat",
  912804 => "Kutiyana\,\ Gujarat",
  912806 => "Gogodar\,\ Gujarat",
  912808 => "Sumrasar\,\ Gujarat",
  91281 => "Rajkot\,\ Gujarat",
  912820 => "Paddhari\,\ Gujarat",
  912821 => "Jasdan\,\ Gujarat",
  912822 => "Morvi\,\ Gujarat",
  912823 => "Jetpur\,\ Gujarat",
  912824 => "Dhoraji\,\ Gujarat",
  912825 => "Gondal\,\ Gujarat",
  912826 => "Upleta\,\ Gujarat",
  912827 => "Kotdasanghani\,\ Gujarat",
  912828 => "Wankaner\,\ Gujarat",
  912829 => "Maliya\ Miyana\,\ Gujarat",
  912830 => "Rahpar\,\ Gujarat",
  912831 => "Nalia\,\ Gujarat",
  912832 => "Bhuj\,\ Gujarat",
  912833 => "Khambhalia\,\ Gujarat",
  912834 => "Kutchmandvi\,\ Gujarat",
  912835 => "Nakhatrana\,\ Gujarat",
  912836 => "Anjar\/Gandhidham\,\ Gujarat",
  912837 => "Bhachav\,\ Gujarat",
  912838 => "Mundra\,\ Gujarat",
  912839 => "Lakhpat\,\ Gujarat",
  912841 => "Vallabhipur\,\ Gujarat",
  912842 => "Talaja\,\ Gujarat",
  912843 => "Gariadhar\,\ Gujarat",
  912844 => "Mahuva\,\ Gujarat",
  912845 => "Savarkundla\,\ Gujarat",
  912846 => "Sihor\,\ Gujarat",
  912847 => "Gadhada\,\ Gujarat",
  912848 => "Palitana\,\ Gujarat",
  912849 => "Botad\,\ Gujarat",
  91285 => "Junagarh\,\ Gujarat",
  91286 => "Porbander\,\ Gujarat",
  912870 => "Malia\ Hatina\,\ Gujarat",
  912871 => "Keshod\,\ Gujarat",
  912872 => "Vanthali\,\ Gujarat",
  912873 => "Visavadar\,\ Gujarat",
  912874 => "Manavadar\,\ Gujarat",
  912875 => "Una\/Diu\,\ Gujarat",
  912876 => "Veraval\,\ Gujarat",
  912877 => "Talala\,\ Gujarat",
  912878 => "Mangrol\,\ Gujarat",
  91288 => "Jamnagar\,\ Gujarat",
  912891 => "Jamkalyanpur\,\ Gujarat",
  912892 => "Okha\,\ Gujarat",
  912893 => "Jodia\,\ Gujarat",
  912894 => "Kalawad\,\ Gujarat",
  912895 => "Lalpur\,\ Gujarat",
  912896 => "Bhanvad\,\ Gujarat",
  912897 => "Dhrol\,\ Gujarat",
  912898 => "Jamjodhpur\,\ Gujarat",
  912900 => "Siwana\/Samdari\,\ Rajasthan",
  912901 => "Siwana\,\ Rajasthan",
  912902 => "Barmer\/Kanot\,\ Rajasthan",
  912903 => "Chohtan\/Gangasar\,\ Rajasthan",
  912904 => "Deogarh\,\ Rajasthan",
  912905 => "Sarada\/Chawand\,\ Rajasthan",
  912906 => "Salumber\,\ Rajasthan",
  912907 => "Kherwara\,\ Rajasthan",
  912908 => "Amet\,\ Rajasthan",
  912909 => "Bhim\/Dawer\,\ Rajasthan",
  91291 => "Jodhpur\,\ Rajasthan",
  912920 => "Bilara\/Bhopalgarh\,\ Rajasthan",
  912921 => "Phalodi\/Bap\,\ Rajasthan",
  912922 => "Osian\,\ Rajasthan",
  912923 => "Phalodi\/Lohawat\,\ Rajasthan",
  912924 => "Phalodi\/Baroo\,\ Rajasthan",
  912925 => "Phalodi\,\ Rajasthan",
  912926 => "Osian\/Mathania\,\ Rajasthan",
  912927 => "Osian\/Dhanwara\,\ Rajasthan",
  912928 => "Shergarh\/Deechu\,\ Rajasthan",
  912929 => "Shergarh\/Balesar\,\ Rajasthan",
  912930 => "Bilara\/Piparcity\,\ Rajasthan",
  912931 => "Jodhpur\/Jhanwar\,\ Rajasthan",
  912932 => "Pali\,\ Rajasthan",
  912933 => "Bali\/Sumerpur\,\ Rajasthan",
  912934 => "Desuri\/Rani\,\ Rajasthan",
  912935 => "Marwar\ Junction\,\ Rajasthan",
  912936 => "Pali\/Rohat\,\ Rajasthan",
  912937 => "Raipur\,\ Rajasthan",
  912938 => "Bali\,\ Rajasthan",
  912939 => "Jaitaran\,\ Rajasthan",
  91294 => "Udaipur\ Girwa\/Udaipur\,\ Rajasthan",
  912950 => "Dhariawad\,\ Rajasthan",
  912951 => "Bhim\,\ Rajasthan",
  912952 => "Rajsamand\/Kankorli\,\ Rajasthan",
  912953 => "Nathdwara\,\ Rajasthan",
  912954 => "Kumbalgarh\/Charbhujaji\,\ Rajasthan",
  912955 => "Malvi\/Fatehnagar\,\ Rajasthan",
  912956 => "Gogunda\,\ Rajasthan",
  912957 => "Vallabhnagar\,\ Rajasthan",
  912958 => "Kotra\,\ Rajasthan",
  912959 => "Jhadol\,\ Rajasthan",
  912960 => "Sojat\,\ Rajasthan",
  912961 => "Ghatol\,\ Rajasthan",
  912962 => "Banswara\,\ Rajasthan",
  912963 => "Gerhi\/Partapur\,\ Rajasthan",
  912964 => "Dungarpur\,\ Rajasthan",
  912965 => "Kushalgarh\,\ Rajasthan",
  912966 => "Sagwara\,\ Rajasthan",
  912967 => "Aspur\,\ Rajasthan",
  912968 => "Bagidora\,\ Rajasthan",
  912969 => "Bhinmal\,\ Rajasthan",
  912970 => "Sanchore\/Hadecha\,\ Rajasthan",
  912971 => "Pindwara\,\ Rajasthan",
  912972 => "Sirohi\,\ Rajasthan",
  912973 => "Jalore\,\ Rajasthan",
  912974 => "Abu\ Road\,\ Rajasthan",
  912975 => "Reodar\,\ Rajasthan",
  912976 => "Sheoganj\/Posaliyan\,\ Rajasthan",
  912977 => "Jalore\/Sayla\,\ Rajasthan",
  912978 => "Ahore\,\ Rajasthan",
  912979 => "Sanchore\,\ Rajasthan",
  912980 => "Pachpadra\/Korna\,\ Rajasthan",
  912981 => "Sheo\/Harsani\,\ Rajasthan",
  912982 => "Barmer\,\ Rajasthan",
  912983 => "Barmer\/Gudda\,\ Rajasthan",
  912984 => "Barmer\/Sindari\,\ Rajasthan",
  912985 => "Barmer\/Ramsar\,\ Rajasthan",
  912986 => "Barmer\/Dhorimanna\,\ Rajasthan",
  912987 => "Sheo\,\ Rajasthan",
  912988 => "Pachpadra\/Balotra\,\ Rajasthan",
  912989 => "Chohtan\,\ Rajasthan",
  912990 => "Bhinmal\/Jasawantpura\,\ Rajasthan",
  912991 => "Jaisalmer\/Ramgarh\,\ Rajasthan",
  912992 => "Jaisalmer\,\ Rajasthan",
  912993 => "Jaisalmer\/Devikot\,\ Rajasthan",
  912994 => "Pokhran\,\ Rajasthan",
  912995 => "Pokhran\/Nachna\,\ Rajasthan",
  912996 => "Pokhran\/Loharki\,\ Rajasthan",
  912997 => "Jaisalmer\/Mohargarh\,\ Rajasthan",
  912998 => "Jaisalmer\/Khuiyals\,\ Rajasthan",
  912999 => "Jaisalmer\/Nehdai\,\ Rajasthan",
  913010 => "Jaisalmer\/Shahgarh\,\ Rajasthan",
  913011 => "Jaisalmer\/Pasewar\,\ Rajasthan",
  913012 => "Jaisalmer\/Mehsana\,\ Rajasthan",
  913013 => "Jaisalmer\/Dhanaua\,\ Rajasthan",
  913014 => "Jaisalmer\/Khuri\,\ Rajasthan",
  913015 => "Jaisalmer\/Myajlar\,\ Rajasthan",
  913016 => "Jaisalmer\/Jheenjaniyali\,\ Rajasthan",
  913017 => "Pokhran\/Madasar\,\ Rajasthan",
  913018 => "Jaisalmer\/Sadhna\,\ Rajasthan",
  913019 => "Pokhran\/Phalsoond\,\ Rajasthan",
  913174 => "Diamond\ Harbour\,\ West\ Bengal",
  913192 => "Andaman\ \&\ Nicobar\,\ Andaman\ Islands",
  913193 => "Andaman\ \&\ Nicobar\,\ Nicobar\ Islands",
  913210 => "Kakdwip\,\ West\ Bengal",
  913211 => "Arambag\,\ West\ Bengal",
  913212 => "Champadanga\,\ West\ Bengal",
  913213 => "Dhaniakhali\,\ West\ Bengal",
  913214 => "Jagatballavpur\,\ West\ Bengal",
  913215 => "Bongoan\,\ West\ Bengal",
  913216 => "Habra\,\ West\ Bengal",
  913217 => "Basirhat\,\ West\ Bengal",
  913218 => "Canning\,\ West\ Bengal",
  913220 => "Contai\,\ West\ Bengal",
  913221 => "Jhargram\,\ West\ Bengal",
  913222 => "Kharagpur\,\ West\ Bengal",
  913223 => "Nayagarh\/Kultikri\,\ West\ Bengal",
  913224 => "Haldia\,\ West\ Bengal",
  913225 => "Ghatal\,\ West\ Bengal",
  913227 => "Amlagora\,\ West\ Bengal",
  913228 => "Tamluk\,\ West\ Bengal",
  913229 => "Dantan\,\ West\ Bengal",
  913241 => "Gangajalghati\,\ West\ Bengal",
  913242 => "Bankura\,\ West\ Bengal",
  913243 => "Khatra\,\ West\ Bengal",
  913244 => "Bishnupur\,\ West\ Bengal",
  913251 => "Adra\,\ West\ Bengal",
  913252 => "Purulia\,\ West\ Bengal",
  913253 => "Manbazar\,\ West\ Bengal",
  913254 => "Jhalda\,\ West\ Bengal",
  91326 => "Dhanbad\,\ Bihar",
  9133 => "Kolkata\,\ West\ Bengal",
  91341 => "Asansol\,\ West\ Bengal",
  91342 => "Burdwan\,\ West\ Bengal",
  91343 => "Durgapur\,\ West\ Bengal",
  913451 => "Seharabazar\,\ West\ Bengal",
  913452 => "Guskara\,\ West\ Bengal",
  913453 => "Katwa\,\ West\ Bengal",
  913454 => "Kalna\,\ West\ Bengal",
  913461 => "Rampur\ Hat\,\ West\ Bengal",
  913462 => "Suri\,\ West\ Bengal",
  913463 => "Bolpur\,\ West\ Bengal",
  913465 => "Nalhati\,\ West\ Bengal",
  913471 => "Karimpur\,\ West\ Bengal",
  913472 => "Krishna\ Nagar\,\ West\ Bengal",
  913473 => "Ranaghat\,\ West\ Bengal",
  913474 => "Bethuadahari\,\ West\ Bengal",
  913481 => "Islampur\,\ West\ Bengal",
  913482 => "Berhampur\,\ West\ Bengal",
  913483 => "Murshidabad\/Jiaganj\,\ West\ Bengal",
  913484 => "Kandi\,\ West\ Bengal",
  913485 => "Dhuliyan\,\ West\ Bengal",
  913511 => "Bubulchandi\,\ West\ Bengal",
  913512 => "Malda\,\ West\ Bengal",
  913513 => "Harishchandrapur\,\ West\ Bengal",
  913521 => "Gangarampur\,\ West\ Bengal",
  913522 => "Balurghat\,\ West\ Bengal",
  913523 => "Raiganj\,\ West\ Bengal",
  913524 => "Harirampur\,\ West\ Bengal",
  913525 => "Dalkhola\,\ West\ Bengal",
  913526 => "Islampur\,\ West\ Bengal",
  91353 => "Siliguri\,\ West\ Bengal",
  91354 => "Darjeeling\,\ West\ Bengal",
  913552 => "Kalimpong\,\ West\ Bengal",
  913561 => "Jalpaiguri\,\ West\ Bengal",
  913562 => "Mal\ Bazar\,\ West\ Bengal",
  913563 => "Birpara\,\ West\ Bengal",
  913564 => "Alipurduar\,\ West\ Bengal",
  913565 => "Nagarakata\,\ West\ Bengal",
  913566 => "Kalchini\,\ West\ Bengal",
  913581 => "Dinhata\,\ West\ Bengal",
  913582 => "Coochbehar\,\ West\ Bengal",
  913583 => "Mathabhanga\,\ West\ Bengal",
  913584 => "Mekhliganj\,\ West\ Bengal",
  913592 => "Gangtok\,\ West\ Bengal",
  913595 => "Gauzing\/Nayabazar\,\ West\ Bengal",
  91360 => "Itanagar\/Ziro\,\ Arunachal\ Pradesh",
  91361 => "Guwahati\,\ Assam",
  913621 => "Boko\,\ Assam",
  913623 => "Barama\,\ Assam",
  913624 => "Nalbari\,\ Assam",
  913637 => "Cherrapunjee\,\ Meghalaya",
  913638 => "Nongpoh\,\ Meghalaya",
  913639 => "Baghmara\,\ Meghalaya",
  91364 => "Shillong\,\ Meghalaya",
  913650 => "Dadengiri\/Phulbari\,\ Meghalaya",
  913651 => "Tura\,\ Meghalaya",
  913652 => "Jowai\,\ Meghalaya",
  913653 => "Amlarem\/Dawki\,\ Meghalaya",
  913654 => "Nongstoin\,\ Meghalaya",
  913655 => "Khliehriat\,\ Meghalaya",
  913656 => "Mawkyrwat\,\ Meghalaya",
  913657 => "Mairang\,\ Meghalaya",
  913658 => "Williamnagar\,\ Meghalaya",
  913659 => "Resubelpara\/Mendipathar\,\ Meghalaya",
  913661 => "Kokrajhar\,\ Assam",
  913662 => "Dhubri\,\ Assam",
  913663 => "Goalpara\,\ Assam",
  913664 => "Hajo\,\ Assam",
  913665 => "Tarabarihat\,\ Assam",
  913666 => "Barpeta\ Road\,\ Assam",
  913667 => "Bilasipara\,\ Assam",
  913668 => "Bijni\,\ Assam",
  913669 => "Abhayapuri\,\ Assam",
  913670 => "Maibong\,\ Assam",
  913671 => "Diphu\,\ Assam",
  913672 => "Nagaon\,\ Assam",
  913673 => "Haflong\,\ Assam",
  913674 => "Hojai\,\ Assam",
  913675 => "Bokajan\,\ Assam",
  913676 => "Howraghat\,\ Assam",
  913677 => "Baithalangshu\,\ Assam",
  913678 => "Morigaon\,\ Assam",
  91368 => "Passighat\,\ Arunachal\ Pradesh",
  91369 => "Mokokchung\,\ Nagaland",
  91370 => "Kohima\,\ Nagaland",
  913711 => "Udalguri\,\ Assam",
  913712 => "Tezpur\,\ Assam",
  913713 => "Mangaldoi\,\ Assam",
  913714 => "Rangapara\,\ Assam",
  913715 => "Gohpur\,\ Assam",
  91372 => "Lungleh\,\ Mizoram",
  91373 => "Dibrugarh\,\ Assam",
  91374 => "Tinsukhia\,\ Assam",
  913751 => "Digboi\,\ Assam",
  913752 => "Lakhimpur\,\ Assam",
  913753 => "Dhemaji\,\ Assam",
  913754 => "Moranhat\,\ Assam",
  913756 => "Sadiya\,\ Assam",
  913758 => "Dhakuakhana\,\ Assam",
  913759 => "Bihupuria\,\ Assam",
  91376 => "Jorhat\,\ Assam",
  913771 => "Mariani\,\ Assam",
  913772 => "Sibsagar\,\ Assam",
  913774 => "Golaghat\,\ Assam",
  913775 => "Majuli\,\ Assam",
  913776 => "Bokakhat\,\ Assam",
  913777 => "Yangkiyang\,\ Arunachal\ Pradesh",
  913778 => "Pakkekesang\,\ Arunachal\ Pradesh",
  913779 => "Roing\/Mariso\,\ Arunachal\ Pradesh",
  913780 => "Dirang\,\ Arunachal\ Pradesh",
  913782 => "Kalaktung\/Bomdila\,\ Arunachal\ Pradesh",
  913783 => "Along\,\ Arunachal\ Pradesh",
  913784 => "Nefra\,\ Arunachal\ Pradesh",
  913785 => "Bameng\,\ Arunachal\ Pradesh",
  913786 => "Khonsa\,\ Arunachal\ Pradesh",
  913787 => "Seppa\,\ Arunachal\ Pradesh",
  913788 => "Kolaring\,\ Arunachal\ Pradesh",
  913789 => "Huri\,\ Arunachal\ Pradesh",
  913790 => "Tali\,\ Arunachal\ Pradesh",
  913791 => "Taliha\,\ Arunachal\ Pradesh",
  913792 => "Daporizo\,\ Arunachal\ Pradesh",
  913793 => "Mechuka\,\ Arunachal\ Pradesh",
  913794 => "Tawang\,\ Arunachal\ Pradesh",
  913795 => "Basar\,\ Arunachal\ Pradesh",
  913797 => "Pangin\,\ Arunachal\ Pradesh",
  913798 => "Mariyang\,\ Arunachal\ Pradesh",
  913799 => "Tuting\,\ Arunachal\ Pradesh",
  913800 => "Jairampur\,\ Arunachal\ Pradesh",
  913801 => "Anini\,\ Arunachal\ Pradesh",
  913802 => "Roing\/Arda\,\ Arunachal\ Pradesh",
  913803 => "Roing\,\ Arunachal\ Pradesh",
  913804 => "Tezu\,\ Arunachal\ Pradesh",
  913805 => "Hayuliang\,\ Arunachal\ Pradesh",
  913806 => "Chowkhem\,\ Arunachal\ Pradesh",
  913807 => "Miao\,\ Arunachal\ Pradesh",
  913808 => "Changlang\,\ Arunachal\ Pradesh",
  913809 => "Sagalee\,\ Arunachal\ Pradesh",
  91381 => "Agartala\,\ Tripura",
  913821 => "R\.K\.Pur\,\ Tripura",
  913822 => "Dharam\ Nagar\,\ Tripura",
  913823 => "Belonia\,\ Tripura",
  913824 => "Kailsahar\,\ Tripura",
  913825 => "Khowai\,\ Tripura",
  913826 => "Ambasa\,\ Tripura",
  913830 => "Champai\/Chiapui\,\ Mizoram",
  913831 => "Champa\,\ Mizoram",
  913834 => "Demagiri\,\ Mizoram",
  913835 => "Saiha\,\ Mizoram",
  913836 => "Saiha\/Tuipang\,\ Mizoram",
  913837 => "Kolasib\,\ Mizoram",
  913838 => "Aizwal\/Serchip\,\ Mizoram",
  913839 => "Jalukie\,\ Nagaland",
  913841 => "Vdarbondh\,\ Assam",
  913842 => "Silchar\,\ Assam",
  913843 => "Karimganj\,\ Assam",
  913844 => "Hailakandi\,\ Assam",
  913845 => "Ukhrul\ Central\,\ Manipur",
  913848 => "Thonbal\,\ Manipur",
  91385 => "Imphal\,\ Manipur",
  913860 => "Wokha\,\ Nagaland",
  913861 => "Tuengsang\,\ Nagaland",
  913862 => "Dimapur\,\ Nagaland",
  913863 => "Kiphire\,\ Nagaland",
  913865 => "Phek\,\ Nagaland",
  913867 => "Zuenheboto\,\ Nagaland",
  913869 => "Mon\,\ Nagaland",
  913870 => "Ukhrursouth\/Kassemkhulen\,\ Manipur",
  913871 => "Mao\/Korang\,\ Manipur",
  913872 => "Chandel\,\ Manipur",
  913873 => "Thinghat\,\ Manipur",
  913874 => "Churchandpur\,\ Manipur",
  913876 => "Jiribam\,\ Manipur",
  913877 => "Tamenglong\,\ Manipur",
  913878 => "Chakpikarong\,\ Manipur",
  913879 => "Bishenpur\,\ Manipur",
  913880 => "Sadarhills\/Kangpokai\,\ Manipur",
  91389 => "Aizawal\,\ Mizoram",
  9140 => "Hyderabad\ Local\,\ Andhra\ Pradesh",
  914111 => "Sriperumbudur\,\ Tamil\ Nadu",
  914112 => "Kancheepuram\,\ Tamil\ Nadu",
  914114 => "Chengalpattu\,\ Tamil\ Nadu",
  914115 => "Madurantakam\,\ Tamil\ Nadu",
  914116 => "Tiruvallur\,\ Tamil\ Nadu",
  914118 => "Tiruttani\,\ Tamil\ Nadu",
  914119 => "Ponneri\,\ Tamil\ Nadu",
  91413 => "Pondicherry\,\ Tamil\ Nadu",
  914142 => "Cuddalore\,\ Tamil\ Nadu",
  914143 => "Virudhachalam\,\ Tamil\ Nadu",
  914144 => "Chidambaram\,\ Tamil\ Nadu",
  914145 => "Gingee\,\ Tamil\ Nadu",
  914146 => "Villupuram\,\ Tamil\ Nadu",
  914147 => "Tindivanam\,\ Tamil\ Nadu",
  914149 => "Ulundurpet\,\ Tamil\ Nadu",
  914151 => "Kallakurichi\,\ Tamil\ Nadu",
  914153 => "Arakandanallur\,\ Tamil\ Nadu",
  91416 => "Vellore\,\ Tamil\ Nadu",
  914171 => "Gudiyatham\,\ Tamil\ Nadu",
  914172 => "Ranipet\,\ Tamil\ Nadu",
  914173 => "Arni\,\ Tamil\ Nadu",
  914174 => "Vaniyambadi\,\ Tamil\ Nadu",
  914175 => "Tiruvannamalai\,\ Tamil\ Nadu",
  914177 => "Arkonam\,\ Tamil\ Nadu",
  914179 => "Tirupattur\,\ Tamil\ Nadu",
  914181 => "Polur\,\ Tamil\ Nadu",
  914182 => "Tiruvettipuram\,\ Tamil\ Nadu",
  914183 => "Vandavasi\,\ Tamil\ Nadu",
  914188 => "Chengam\,\ Tamil\ Nadu",
  914202 => "Mulanur\,\ Tamil\ Nadu",
  914204 => "Kodumudi\,\ Tamil\ Nadu",
  91421 => "Tirupur\,\ Tamil\ Nadu",
  91422 => "Coimbatore\,\ Tamil\ Nadu",
  91423 => "Udhagamandalam\,\ Tamil\ Nadu",
  91424 => "Erode\,\ Tamil\ Nadu",
  914252 => "Udumalpet\,\ Tamil\ Nadu",
  914253 => "Anamalai\,\ Tamil\ Nadu",
  914254 => "Mettupalayam\,\ Tamil\ Nadu",
  914255 => "Palladam\,\ Tamil\ Nadu",
  914256 => "Bhavani\,\ Tamil\ Nadu",
  914257 => "Kangeyam\,\ Tamil\ Nadu",
  914258 => "Dharampuram\,\ Tamil\ Nadu",
  914259 => "Pollachi\,\ Tamil\ Nadu",
  914262 => "Gudalur\,\ Tamil\ Nadu",
  914266 => "Kotagiri\,\ Tamil\ Nadu",
  914268 => "Velur\,\ Tamil\ Nadu",
  91427 => "Salem\,\ Tamil\ Nadu",
  914281 => "Yercaud\,\ Tamil\ Nadu",
  914282 => "Attur\,\ Tamil\ Nadu",
  914283 => "Sankagiri\,\ Tamil\ Nadu",
  914285 => "Gobichettipalayam\,\ Tamil\ Nadu",
  914286 => "Namakkal\,\ Tamil\ Nadu",
  914287 => "Rasipuram\,\ Tamil\ Nadu",
  914288 => "Tiruchengode\,\ Tamil\ Nadu",
  914290 => "Omalur\,\ Tamil\ Nadu",
  914292 => "Valapady\,\ Tamil\ Nadu",
  914294 => "Perundurai\,\ Tamil\ Nadu",
  914295 => "Sathiyamangalam\,\ Tamil\ Nadu",
  914296 => "Avanashi\,\ Tamil\ Nadu",
  914298 => "Metturdam\,\ Tamil\ Nadu",
  91431 => "Tiruchchirappalli\,\ Tamil\ Nadu",
  914320 => "Aravakurichi\,\ Tamil\ Nadu",
  914322 => "Pudukkottai\,\ Tamil\ Nadu",
  914323 => "Kulithalai\,\ Tamil\ Nadu",
  914324 => "Karur\,\ Tamil\ Nadu",
  914326 => "Musiri\,\ Tamil\ Nadu",
  914327 => "Thuraiyur\,\ Tamil\ Nadu",
  914328 => "Perambalur\,\ Tamil\ Nadu",
  914329 => "Ariyalur\,\ Tamil\ Nadu",
  914331 => "Jayamkondan\,\ Tamil\ Nadu",
  914332 => "Manaparai\,\ Tamil\ Nadu",
  914333 => "Ponnamaravathi\,\ Tamil\ Nadu",
  914339 => "Keeranur\,\ Tamil\ Nadu",
  914341 => "Uthangarai\,\ Tamil\ Nadu",
  914342 => "Dharmapuri\,\ Tamil\ Nadu",
  914343 => "Krishnagiri\,\ Tamil\ Nadu",
  914344 => "Hosur\,\ Tamil\ Nadu",
  914346 => "Harur\,\ Tamil\ Nadu",
  914347 => "Denkanikota\,\ Tamil\ Nadu",
  914348 => "Palakkodu\,\ Tamil\ Nadu",
  91435 => "Kumbakonam\,\ Tamil\ Nadu",
  914362 => "Thanjavur\,\ Tamil\ Nadu",
  914364 => "Mayiladuthurai\,\ Tamil\ Nadu",
  914365 => "Nagapattinam\,\ Tamil\ Nadu",
  914366 => "Tiruvarur\,\ Tamil\ Nadu",
  914367 => "Mannargudi\,\ Tamil\ Nadu",
  914368 => "Karaikal\,\ Tamil\ Nadu",
  914369 => "Thiruthuraipoondi\,\ Tamil\ Nadu",
  914371 => "Arantangi\,\ Tamil\ Nadu",
  914372 => "Orathanad\,\ Tamil\ Nadu",
  914373 => "Pattukottai\,\ Tamil\ Nadu",
  914374 => "Papanasam\,\ Tamil\ Nadu",
  9144 => "Chennai\,\ Tamil\ Nadu",
  91451 => "Dindigul\,\ Tamil\ Nadu",
  91452 => "Madurai\,\ Tamil\ Nadu",
  914542 => "Kodaikanal\,\ Tamil\ Nadu",
  914543 => "Batlagundu\,\ Tamil\ Nadu",
  914544 => "Natham\,\ Tamil\ Nadu",
  914545 => "Palani\,\ Tamil\ Nadu",
  914546 => "Theni\,\ Tamil\ Nadu",
  914549 => "Thirumanglam\,\ Tamil\ Nadu",
  914551 => "Vedasandur\,\ Tamil\ Nadu",
  914552 => "Usilampatti\,\ Tamil\ Nadu",
  914553 => "Oddanchatram\,\ Tamil\ Nadu",
  914554 => "Cumbum\,\ Tamil\ Nadu",
  914561 => "Devakottai\,\ Tamil\ Nadu",
  914562 => "Virudhunagar\,\ Tamil\ Nadu",
  914563 => "Rajapalayam\,\ Tamil\ Nadu",
  914564 => "Paramakudi\,\ Tamil\ Nadu",
  914565 => "Karaikudi\,\ Tamil\ Nadu",
  914566 => "Aruppukottai\,\ Tamil\ Nadu",
  914567 => "Ramanathpuram\,\ Tamil\ Nadu",
  914573 => "Rameshwaram\,\ Tamil\ Nadu",
  914574 => "Manamadurai\,\ Tamil\ Nadu",
  914575 => "Sivaganga\,\ Tamil\ Nadu",
  914576 => "Mudukulathur\,\ Tamil\ Nadu",
  914577 => "Tirupathur\,\ Tamil\ Nadu",
  91460 => "Taliparamba\,\ Kerala",
  91461 => "Thoothukudi\,\ Tamil\ Nadu",
  91462 => "Tirunelvelli\,\ Tamil\ Nadu",
  914630 => "Srivaikundam\,\ Tamil\ Nadu",
  914632 => "Kovilpatti\,\ Tamil\ Nadu",
  914633 => "Tenkasi\,\ Tamil\ Nadu",
  914634 => "Ambasamudram\,\ Tamil\ Nadu",
  914635 => "Nanguneri\,\ Tamil\ Nadu",
  914636 => "Sankarankovil\,\ Tamil\ Nadu",
  914637 => "Valliyoor\,\ Tamil\ Nadu",
  914638 => "Vilathikulam\,\ Tamil\ Nadu",
  914639 => "Tiruchendur\,\ Tamil\ Nadu",
  914651 => "Kuzhithurai\,\ Tamil\ Nadu",
  914652 => "Nagercoil\,\ Tamil\ Nadu",
  91469 => "Tiruvalla\,\ Kerala",
  91470 => "Attingal\,\ Kerala",
  91471 => "Thiruvananthapuram\,\ Kerala",
  914728 => "Nedumangad\,\ Kerala",
  914733 => "Pathanamthitta\,\ Kerala",
  914734 => "Adoor\,\ Kerala",
  914735 => "Ranni\,\ Kerala",
  91474 => "Kollam\,\ Kerala",
  91475 => "Punalur\,\ Kerala",
  91476 => "Karunagapally\,\ Kerala",
  91477 => "Alappuzha\,\ Kerala",
  91478 => "Cherthala\,\ Kerala",
  91479 => "Mavelikkara\,\ Kerala",
  91480 => "Irinjalakuda\,\ Kerala",
  91481 => "Kottayam\,\ Kerala",
  914822 => "Palai\,\ Kerala",
  914828 => "Kanjirapally\,\ Kerala",
  914829 => "Vaikom\,\ Kerala",
  91483 => "Manjeri\,\ Kerala",
  91484 => "Ernakulam\,\ Kerala",
  91485 => "Muvattupuzha\,\ Kerala",
  914862 => "Thodupuzha\,\ Kerala",
  914864 => "Adimaly\,\ Kerala",
  914865 => "Munnar\,\ Kerala",
  914868 => "Nedumkandam\,\ Kerala",
  914869 => "Peermedu\,\ Kerala",
  91487 => "Thrissur\,\ Kerala",
  914884 => "Vadakkanchery\,\ Kerala",
  914885 => "Kunnamkulam\,\ Kerala",
  914890 => "Bitra\,\ Lakshadweep",
  914891 => "Amini\,\ Lakshadweep",
  914892 => "Minicoy\,\ Lakshadweep",
  914893 => "Androth\,\ Lakshadweep",
  914894 => "Agathy\,\ Lakshadweep",
  914895 => "Kalpeni\,\ Lakshadweep",
  914896 => "Kavaratti\,\ Lakshadweep",
  914897 => "Kadamath\,\ Lakshadweep",
  914898 => "Kiltan\,\ Lakshadweep",
  914899 => "Chetlat\,\ Lakshadweep",
  91490 => "Tellicherry\,\ Kerala",
  91491 => "Palakkad\,\ Kerala",
  914922 => "Alathur\,\ Kerala",
  914923 => "Koduvayur\,\ Kerala",
  914924 => "Mannarkad\,\ Kerala",
  914926 => "Shoranur\,\ Kerala",
  914931 => "Nilambur\,\ Kerala",
  914933 => "Perinthalmanna\,\ Kerala",
  914935 => "Mananthavady\,\ Kerala",
  914936 => "Kalpetta\,\ Kerala",
  91494 => "Tirur\,\ Kerala",
  91495 => "Kozhikode\,\ Kerala",
  91496 => "Vatakara\,\ Kerala",
  91497 => "Kannur\,\ Kerala",
  914982 => "Taliparamba\,\ Kerala",
  914985 => "Payyanur\,\ Kerala",
  914994 => "Kasaragod\,\ Kerala",
  914997 => "Kanhangad\,\ Kerala",
  914998 => "Uppala\,\ Kerala",
  915111 => "Akbarpur\,\ Uttar\ Pradesh",
  915112 => "Bilhaur\,\ Uttar\ Pradesh",
  915113 => "Bhognipur\/Pakhrayan\,\ Uttar\ Pradesh",
  915114 => "Derapur\/Jhinjak\,\ Uttar\ Pradesh",
  915115 => "Ghatampur\,\ Uttar\ Pradesh",
  91512 => "Kanpur\,\ Uttar\ Pradesh",
  915142 => "Purwa\/Bighapur\,\ Uttar\ Pradesh",
  915143 => "Hasanganj\,\ Uttar\ Pradesh",
  915144 => "Safipur\,\ Uttar\ Pradesh",
  91515 => "Unnao\,\ Uttar\ Pradesh",
  915162 => "Orai\,\ Uttar\ Pradesh",
  915164 => "Kalpi\,\ Uttar\ Pradesh",
  915165 => "Konch\,\ Uttar\ Pradesh",
  915168 => "Jalaun\,\ Uttar\ Pradesh",
  915170 => "Chirgaon\/Moth\,\ Uttar\ Pradesh",
  915171 => "Garauth\,\ Uttar\ Pradesh",
  915172 => "Mehraun\,\ Uttar\ Pradesh",
  915174 => "Jhansi\,\ Uttar\ Pradesh",
  915175 => "Lalitpur\/Talbehat\,\ Uttar\ Pradesh",
  915176 => "Lalitpur\,\ Uttar\ Pradesh",
  915178 => "Mauranipur\,\ Uttar\ Pradesh",
  915180 => "Fatehpur\,\ Uttar\ Pradesh",
  915181 => "Bindki\,\ Uttar\ Pradesh",
  915182 => "Khaga\,\ Uttar\ Pradesh",
  915183 => "Fatehpur\/Gazipur\,\ Uttar\ Pradesh",
  915190 => "Baberu\,\ Uttar\ Pradesh",
  915191 => "Naraini\/Attarra\,\ Uttar\ Pradesh",
  915192 => "Banda\,\ Uttar\ Pradesh",
  915194 => "Karvi\/Manikpur\,\ Uttar\ Pradesh",
  915195 => "Mau\/Rajapur\,\ Uttar\ Pradesh",
  915198 => "Karvi\,\ Uttar\ Pradesh",
  915212 => "Malihabad\,\ Uttar\ Pradesh",
  91522 => "Lucknow\,\ Uttar\ Pradesh",
  915240 => "Fatehpur\,\ Uttar\ Pradesh",
  915241 => "Ramsanehi\ Ghat\,\ Uttar\ Pradesh",
  915244 => "Haidergarh\,\ Uttar\ Pradesh",
  915248 => "Barabanki\,\ Uttar\ Pradesh",
  915250 => "Bahraich\/Bhinga\,\ Uttar\ Pradesh",
  915251 => "Kaisarganj\/Kaiserganj\,\ Uttar\ Pradesh",
  915252 => "Bahraich\/Bahrailh\,\ Uttar\ Pradesh",
  915253 => "Nanpara\,\ Uttar\ Pradesh",
  915254 => "Nanparah\/Mihinpurwa\,\ Uttar\ Pradesh",
  915255 => "Kaisarganh\/Mahasi\,\ Uttar\ Pradesh",
  915260 => "Tarabganj\,\ Uttar\ Pradesh",
  915261 => "Tarabganj\/Colonelganj\,\ Uttar\ Pradesh",
  915262 => "Gonda\,\ Uttar\ Pradesh",
  915263 => "Balarampur\/Balrampur\,\ Uttar\ Pradesh",
  915264 => "Balarampur\/Tulsipur\,\ Uttar\ Pradesh",
  915265 => "Utraula\,\ Uttar\ Pradesh",
  915270 => "Bikapur\,\ Uttar\ Pradesh",
  915271 => "Akbarpur\,\ Uttar\ Pradesh",
  915273 => "Tandai\/Tanda\,\ Uttar\ Pradesh",
  915274 => "Tanda\/Baskhari\,\ Uttar\ Pradesh",
  915275 => "Akbarpur\/Jalalpur\,\ Uttar\ Pradesh",
  915278 => "Faizabad\,\ Uttar\ Pradesh",
  915280 => "Rath\,\ Uttar\ Pradesh",
  915281 => "Mahoba\,\ Uttar\ Pradesh",
  915282 => "Hamirpur\,\ Uttar\ Pradesh",
  915283 => "Charkhari\,\ Uttar\ Pradesh",
  915284 => "Maudaha\,\ Uttar\ Pradesh",
  915311 => "Salon\,\ Uttar\ Pradesh",
  915313 => "Salon\/Jais\,\ Uttar\ Pradesh",
  915315 => "Dalmau\/Lalganj\,\ Uttar\ Pradesh",
  915317 => "Dalmau\,\ Uttar\ Pradesh",
  91532 => "Allahabad\,\ Uttar\ Pradesh",
  915331 => "Bharwari\,\ Uttar\ Pradesh",
  915332 => "Phoolpur\,\ Uttar\ Pradesh",
  915333 => "Karchhana\/Shankergarh\,\ Uttar\ Pradesh",
  915334 => "Meja\/Sirsa\,\ Uttar\ Pradesh",
  915335 => "Soraon\,\ Uttar\ Pradesh",
  915341 => "Kunda\,\ Uttar\ Pradesh",
  915342 => "Pratapgarh\,\ Uttar\ Pradesh",
  915343 => "Patti\,\ Uttar\ Pradesh",
  91535 => "Raibareli\,\ Uttar\ Pradesh",
  915361 => "Musafirkhana\,\ Uttar\ Pradesh",
  915362 => "Sultanpur\,\ Uttar\ Pradesh",
  915364 => "Kadipur\,\ Uttar\ Pradesh",
  915368 => "Amethi\,\ Uttar\ Pradesh",
  915412 => "Chandauli\/Mugalsarai\,\ Uttar\ Pradesh",
  915413 => "Chakia\,\ Uttar\ Pradesh",
  915414 => "Bhadohi\,\ Uttar\ Pradesh",
  91542 => "Varansi\,\ Uttar\ Pradesh",
  915440 => "Mirzapur\/Hallia\,\ Uttar\ Pradesh",
  915442 => "Mirzapur\,\ Uttar\ Pradesh",
  915443 => "Chunur\,\ Uttar\ Pradesh",
  915444 => "Robertsganj\,\ Uttar\ Pradesh",
  915445 => "Robertsganj\/Obra\,\ Uttar\ Pradesh",
  915446 => "Dudhi\/Pipri\,\ Uttar\ Pradesh",
  915447 => "Dudhi\,\ Uttar\ Pradesh",
  915450 => "Kerakat\,\ Uttar\ Pradesh",
  915451 => "Mariyahu\,\ Uttar\ Pradesh",
  915452 => "Jaunpur\,\ Uttar\ Pradesh",
  915453 => "Shahganj\,\ Uttar\ Pradesh",
  915454 => "Machlishahar\,\ Uttar\ Pradesh",
  915460 => "Phulpur\,\ Uttar\ Pradesh",
  915461 => "Ghosi\,\ Uttar\ Pradesh",
  915462 => "Azamgarh\,\ Uttar\ Pradesh",
  915463 => "Lalganj\,\ Uttar\ Pradesh",
  915464 => "Maunathbhanjan\,\ Uttar\ Pradesh",
  915465 => "Phulpur\/Atrawlia\,\ Uttar\ Pradesh",
  915466 => "Sagri\,\ Uttar\ Pradesh",
  91548 => "Ghazipur\,\ Uttar\ Pradesh",
  915491 => "Rasara\,\ Uttar\ Pradesh",
  915493 => "Mohamdabad\,\ Uttar\ Pradesh",
  915494 => "Bansdeeh\,\ Uttar\ Pradesh",
  915495 => "Saidpur\,\ Uttar\ Pradesh",
  915496 => "Ballia\/Raniganj\,\ Uttar\ Pradesh",
  915497 => "Zamania\,\ Uttar\ Pradesh",
  915498 => "Ballia\,\ Uttar\ Pradesh",
  91551 => "Gorakhpur\,\ Uttar\ Pradesh",
  915521 => "Bansgaon\/Barhal\ Ganj\,\ Uttar\ Pradesh",
  915522 => "Pharenda\/Compierganj\,\ Uttar\ Pradesh",
  915523 => "Maharajganj\,\ Uttar\ Pradesh",
  915524 => "Pharenda\/Anand\ Nagar\,\ Uttar\ Pradesh",
  915525 => "Bansgaon\,\ Uttar\ Pradesh",
  915541 => "Domariyaganj\,\ Uttar\ Pradesh",
  915542 => "Basti\,\ Uttar\ Pradesh",
  915543 => "Naugarh\/Barhani\,\ Uttar\ Pradesh",
  915544 => "Naugarh\/Tetribazar\,\ Uttar\ Pradesh",
  915545 => "Bansi\,\ Uttar\ Pradesh",
  915546 => "Harraiya\,\ Uttar\ Pradesh",
  915547 => "Khalilabad\,\ Uttar\ Pradesh",
  915548 => "Khalilabad\/Mehdawal\,\ Uttar\ Pradesh",
  915561 => "Salempur\/Barhaj\,\ Uttar\ Pradesh",
  915563 => "Captanganj\/Khadda\,\ Uttar\ Pradesh",
  915564 => "Padrauna\,\ Uttar\ Pradesh",
  915566 => "Salempur\,\ Uttar\ Pradesh",
  915567 => "Captanganj\,\ Uttar\ Pradesh",
  915568 => "Deoria\,\ Uttar\ Pradesh",
  915612 => "Ferozabad\,\ Uttar\ Pradesh",
  915613 => "Achhnera\,\ Uttar\ Pradesh",
  915614 => "Jarar\,\ Uttar\ Pradesh",
  91562 => "Agra\,\ Uttar\ Pradesh",
  915640 => "Kaman\,\ Rajasthan",
  915641 => "Deeg\,\ Rajasthan",
  915642 => "Dholpur\,\ Rajasthan",
  915643 => "Nadbai\,\ Rajasthan",
  915644 => "Bharatpur\,\ Rajasthan",
  915645 => "Rupbas\,\ Rajasthan",
  915646 => "Baseri\,\ Rajasthan",
  915647 => "Bari\,\ Rajasthan",
  915648 => "Bayana\,\ Rajasthan",
  91565 => "Mathura\,\ Uttar\ Pradesh",
  915661 => "Sadabad\,\ Uttar\ Pradesh",
  915662 => "Chhata\/Kosikalan\,\ Uttar\ Pradesh",
  915664 => "Mant\/Vrindavan\,\ Uttar\ Pradesh",
  915671 => "Jasrana\,\ Uttar\ Pradesh",
  915672 => "Mainpuri\,\ Uttar\ Pradesh",
  915673 => "Bhogaon\,\ Uttar\ Pradesh",
  915676 => "Shikohabad\,\ Uttar\ Pradesh",
  915677 => "Karhal\,\ Uttar\ Pradesh",
  915680 => "Bharthana\,\ Uttar\ Pradesh",
  915681 => "Bidhuna\,\ Uttar\ Pradesh",
  915683 => "Auraiya\,\ Uttar\ Pradesh",
  915688 => "Etawah\,\ Uttar\ Pradesh",
  915690 => "Kaimganj\,\ Uttar\ Pradesh",
  915691 => "Chhibramau\,\ Uttar\ Pradesh",
  915692 => "Farrukhabad\/Fategarh\,\ Uttar\ Pradesh",
  915694 => "Kannauj\,\ Uttar\ Pradesh",
  91571 => "Aligarh\,\ Uttar\ Pradesh",
  915721 => "Sikandra\ Rao\,\ Uttar\ Pradesh",
  915722 => "Hathras\,\ Uttar\ Pradesh",
  915723 => "Atrauli\,\ Uttar\ Pradesh",
  915724 => "Khair\,\ Uttar\ Pradesh",
  915731 => "Garhmukteshwar\,\ Uttar\ Pradesh",
  915732 => "Bulandshahr\,\ Uttar\ Pradesh",
  915733 => "Pahasu\,\ Uttar\ Pradesh",
  915734 => "Debai\,\ Uttar\ Pradesh",
  915735 => "Sikandrabad\,\ Uttar\ Pradesh",
  915736 => "Siyana\,\ Uttar\ Pradesh",
  915738 => "Khurja\,\ Uttar\ Pradesh",
  915740 => "Aliganj\/Ganjdundwara\,\ Uttar\ Pradesh",
  915742 => "Etah\,\ Uttar\ Pradesh",
  915744 => "Kasganj\,\ Uttar\ Pradesh",
  915745 => "Jalesar\,\ Uttar\ Pradesh",
  91581 => "Bareilly\,\ Uttar\ Pradesh",
  915821 => "Pitamberpur\,\ Uttar\ Pradesh",
  915822 => "Baheri\,\ Uttar\ Pradesh",
  915823 => "Aonla\,\ Uttar\ Pradesh",
  915824 => "Aonla\/Ramnagar\,\ Uttar\ Pradesh",
  915825 => "Nawabganj\,\ Uttar\ Pradesh",
  915831 => "Dataganj\,\ Uttar\ Pradesh",
  915832 => "Badaun\,\ Uttar\ Pradesh",
  915833 => "Sahaswan\,\ Uttar\ Pradesh",
  915834 => "Bisauli\,\ Uttar\ Pradesh",
  915836 => "Gunnaur\,\ Uttar\ Pradesh",
  915841 => "Tilhar\,\ Uttar\ Pradesh",
  915842 => "Shahjahanpur\,\ Uttar\ Pradesh",
  915843 => "Jalalabad\,\ Uttar\ Pradesh",
  915844 => "Powayan\,\ Uttar\ Pradesh",
  915850 => "Hardoi\/Baghavli\,\ Uttar\ Pradesh",
  915851 => "Bilgam\/Madhoganj\,\ Uttar\ Pradesh",
  915852 => "Hardoi\,\ Uttar\ Pradesh",
  915853 => "Shahabad\,\ Uttar\ Pradesh",
  915854 => "Sandila\,\ Uttar\ Pradesh",
  915855 => "Bilgram\/Sandi\,\ Uttar\ Pradesh",
  915861 => "Misrikh\/Aurangabad\,\ Uttar\ Pradesh",
  915862 => "Sitapur\,\ Uttar\ Pradesh",
  915863 => "Biswan\,\ Uttar\ Pradesh",
  915864 => "Sidhauli\/Mahmodabad\,\ Uttar\ Pradesh",
  915865 => "Misrikh\,\ Uttar\ Pradesh",
  915870 => "Bhira\,\ Uttar\ Pradesh",
  915871 => "Nighasan\/Palia\ Kalan\,\ Uttar\ Pradesh",
  915872 => "Kheri\,\ Uttar\ Pradesh",
  915873 => "Nighasan\/Tikunia\,\ Uttar\ Pradesh",
  915874 => "Nighasan\/Dhaurehra\,\ Uttar\ Pradesh",
  915875 => "Mohammadi\/Maigalganj\,\ Uttar\ Pradesh",
  915876 => "Mohammadi\,\ Uttar\ Pradesh",
  915880 => "Puranpur\,\ Uttar\ Pradesh",
  915881 => "Bisalpur\,\ Uttar\ Pradesh",
  915882 => "Pilibhit\,\ Uttar\ Pradesh",
  91591 => "Moradabad\,\ Uttar\ Pradesh",
  915921 => "Bilari\,\ Uttar\ Pradesh",
  915922 => "Amroha\,\ Uttar\ Pradesh",
  915923 => "Sambhal\,\ Uttar\ Pradesh",
  915924 => "Hasanpur\,\ Uttar\ Pradesh",
  915942 => "Nainital\,\ Uttar\ Pradesh",
  915943 => "Khatima\,\ Uttar\ Pradesh",
  915944 => "Kichha\/Rudrapur\,\ Uttar\ Pradesh",
  915945 => "Haldwani\/Chorgalian\,\ Uttar\ Pradesh",
  915946 => "Haldwani\,\ Uttar\ Pradesh",
  915947 => "Kashipur\,\ Uttar\ Pradesh",
  915948 => "Khatima\/Sitarganj\,\ Uttar\ Pradesh",
  915949 => "Kichha\/Bazpur\,\ Uttar\ Pradesh",
  91595 => "Rampur\,\ Uttar\ Pradesh",
  915960 => "Shahabad\,\ Uttar\ Pradesh",
  915961 => "Munsiari\,\ Uttar\ Pradesh",
  915962 => "Almora\,\ Uttar\ Pradesh",
  915963 => "Bageshwar\,\ Uttar\ Pradesh",
  915964 => "Pithoragarh\,\ Uttar\ Pradesh",
  915965 => "Champawat\,\ Uttar\ Pradesh",
  915966 => "Ranikhet\,\ Uttar\ Pradesh",
  915967 => "Dharchula\,\ Uttar\ Pradesh",
  916111 => "Hilsa\,\ Bihar",
  916112 => "Biharsharif\,\ Bihar",
  916114 => "Jahanabad\,\ Bihar",
  916115 => "Danapur\,\ Bihar",
  91612 => "Patna\,\ Bihar",
  916132 => "Barh\,\ Bihar",
  916135 => "Bikram\,\ Bihar",
  916150 => "Hathua\,\ Bihar",
  916151 => "Sidhawalia\,\ Bihar",
  916152 => "Chapra\,\ Bihar",
  916153 => "Maharajganj\,\ Bihar",
  916154 => "Siwan\,\ Bihar",
  916155 => "Ekma\,\ Bihar",
  916156 => "Gopalganj\,\ Bihar",
  916157 => "Mairwa\,\ Bihar",
  916158 => "Sonepur\,\ Bihar",
  916159 => "Masrakh\,\ Bihar",
  916180 => "Adhaura\,\ Bihar",
  916181 => "Piro\,\ Bihar",
  916182 => "Arrah\,\ Bihar",
  916183 => "Buxar\,\ Bihar",
  916184 => "Sasaram\,\ Bihar",
  916185 => "Bikramganj\,\ Bihar",
  916186 => "Aurangabad\,\ Bihar",
  916187 => "Mohania\,\ Bihar",
  916188 => "Rohtas\,\ Bihar",
  916189 => "Bhabhua\,\ Bihar",
  91621 => "Muzaffarpur\,\ Bihar",
  916222 => "Sheohar\,\ Bihar",
  916223 => "Motipur\,\ Bihar",
  916224 => "Hajipur\,\ Bihar",
  916226 => "Sitamarhi\,\ Bihar",
  916227 => "Mahua\,\ Bihar",
  916228 => "Pupri\,\ Bihar",
  916229 => "Bidupur\,\ Bihar",
  916242 => "Benipur\,\ Bihar",
  916243 => "Begusarai\,\ Bihar",
  916244 => "Khagaria\,\ Bihar",
  916245 => "Gogri\,\ Bihar",
  916246 => "Jainagar\,\ Bihar",
  916247 => "Singhwara\,\ Bihar",
  916250 => "Dhaka\,\ Bihar",
  916251 => "Bagaha\,\ Bihar",
  916252 => "Motihari\,\ Bihar",
  916253 => "Narkatiaganj\,\ Bihar",
  916254 => "Bettiah\,\ Bihar",
  916255 => "Raxaul\,\ Bihar",
  916256 => "Ramnagar\,\ Bihar",
  916257 => "Barachakia\,\ Bihar",
  916258 => "Areraj\,\ Bihar",
  916259 => "Pakridayal\,\ Bihar",
  916271 => "Benipatti\,\ Bihar",
  916272 => "Darbhanga\,\ Bihar",
  916273 => "Jhajharpur\,\ Bihar",
  916274 => "Samastipur\,\ Bihar",
  916275 => "Rosera\,\ Bihar",
  916276 => "Madhubani\,\ Bihar",
  916277 => "Phulparas\,\ Bihar",
  916278 => "Dalsinghsarai\,\ Bihar",
  916279 => "Barauni\,\ Bihar",
  91631 => "Gaya\,\ Bihar",
  916322 => "Wazirganj\,\ Bihar",
  916323 => "Dumraon\,\ Bihar",
  916324 => "Nawada\,\ Bihar",
  916325 => "Pakribarwan\,\ Bihar",
  916326 => "Sherghati\,\ Bihar",
  916327 => "Rafiganj\,\ Bihar",
  916328 => "Daudnagar\,\ Bihar",
  916331 => "Imamganj\,\ Bihar",
  916332 => "Nabinagar\,\ Bihar",
  916336 => "Rajauli\,\ Bihar",
  916337 => "Arwal\,\ Bihar",
  916341 => "Seikhpura\,\ Bihar",
  916342 => "H\.Kharagpur\,\ Bihar",
  916344 => "Monghyr\,\ Bihar",
  916345 => "Jamui\,\ Bihar",
  916346 => "Lakhisarai\,\ Bihar",
  916347 => "Chakai\,\ Bihar",
  916348 => "Mallehpur\,\ Bihar",
  916349 => "Jhajha\,\ Bihar",
  91641 => "Bhagalpur\,\ Bihar",
  916420 => "Amarpur\,\ Bihar",
  916421 => "Naugachia\,\ Bihar",
  916422 => "Godda\,\ Bihar",
  916423 => "Maheshpur\ Raj\,\ Bihar",
  916424 => "Banka\,\ Bihar",
  916425 => "Katoria\,\ Bihar",
  916426 => "Rajmahal\,\ Bihar",
  916427 => "Kathikund\,\ Bihar",
  916428 => "Nala\,\ Bihar",
  916429 => "Kahalgaon\,\ Bihar",
  916431 => "Jharmundi\,\ Bihar",
  916432 => "Deoghar\,\ Bihar",
  916433 => "Jamtara\,\ Bihar",
  916434 => "Dumka\,\ Bihar",
  916435 => "Pakur\,\ Bihar",
  916436 => "Sahibganj\,\ Bihar",
  916437 => "Mahagama\,\ Bihar",
  916438 => "Madhupur\,\ Bihar",
  916451 => "Barsoi\,\ Bihar",
  916452 => "Katihar\,\ Bihar",
  916453 => "Araria\,\ Bihar",
  916454 => "Purnea\,\ Bihar",
  916455 => "Forbesganj\,\ Bihar",
  916457 => "Korha\,\ Bihar",
  916459 => "Thakurganj\,\ Bihar",
  916461 => "Raniganj\,\ Bihar",
  916462 => "Dhamdaha\,\ Bihar",
  916466 => "Kishanganj\,\ Bihar",
  916467 => "Banmankhi\,\ Bihar",
  916471 => "Birpur\,\ Bihar",
  916473 => "Supaul\,\ Bihar",
  916475 => "S\.Bakhtiarpur\,\ Bihar",
  916476 => "Madhepura\,\ Bihar",
  916477 => "Triveniganj\,\ Bihar",
  916478 => "Saharsa\,\ Bihar",
  916479 => "Udakishanganj\,\ Bihar",
  91651 => "Ranchi\,\ Bihar",
  916522 => "Muri\,\ Bihar",
  916523 => "Ghaghra\,\ Bihar",
  916524 => "Gumla\,\ Bihar",
  916525 => "Simdega\,\ Bihar",
  916526 => "Lohardaga\,\ Bihar",
  916527 => "Kolebira\,\ Bihar",
  916528 => "Khunti\,\ Bihar",
  916529 => "Itki\,\ Bihar",
  916530 => "Bundu\,\ Bihar",
  916531 => "Mandar\,\ Bihar",
  916532 => "Giridih\,\ Bihar",
  916533 => "Basia\,\ Bihar",
  916534 => "Jhumaritalaiya\,\ Bihar",
  916535 => "Chainpur\,\ Bihar",
  916536 => "Palkot\,\ Bihar",
  916538 => "Torpa\,\ Bihar",
  916539 => "Bolwa\,\ Bihar",
  916540 => "Govindpur\,\ Bihar",
  916541 => "Chatra\,\ Bihar",
  916542 => "Bokaro\,\ Bihar",
  916543 => "Barhi\,\ Bihar",
  916544 => "Gomia\,\ Bihar",
  916545 => "Mandu\,\ Bihar",
  916546 => "Hazaribagh\,\ Bihar",
  916547 => "Chavparan\,\ Bihar",
  916548 => "Ichak\,\ Bihar",
  916549 => "Bermo\,\ Bihar",
  916550 => "Hunterganj\,\ Bihar",
  916551 => "Barkagaon\,\ Bihar",
  916553 => "Ramgarh\,\ Bihar",
  916554 => "Rajdhanwar\,\ Bihar",
  916556 => "Tisri\,\ Bihar",
  916557 => "Bagodar\,\ Bihar",
  916558 => "Dumri\(Isribazar\)\,\ Bihar",
  916559 => "Simaria\,\ Bihar",
  916560 => "Patan\,\ Bihar",
  916561 => "Garhwa\,\ Bihar",
  916562 => "Daltonganj\,\ Bihar",
  916563 => "Bhawanathpur\,\ Bihar",
  916564 => "Nagarutari\,\ Bihar",
  916565 => "Latehar\,\ Bihar",
  916566 => "Japla\,\ Bihar",
  916567 => "Barwadih\,\ Bihar",
  916568 => "Balumath\,\ Bihar",
  916569 => "Garu\,\ Bihar",
  91657 => "Jamshedpur\,\ Bihar",
  916581 => "Bhandaria\,\ Bihar",
  916582 => "Chaibasa\,\ Bihar",
  916583 => "Kharsawa\,\ Bihar",
  916584 => "Bishrampur\,\ Bihar",
  916585 => "Ghatsila\,\ Bihar",
  916586 => "Chainpur\,\ Bihar",
  916587 => "Chakardharpur\,\ Bihar",
  916588 => "Jagarnathpur\,\ Bihar",
  916589 => "Jhinkpani\,\ Bihar",
  916591 => "Chandil\,\ Bihar",
  916593 => "Manoharpur\,\ Bihar",
  916594 => "Baharagora\,\ Bihar",
  916596 => "Noamundi\,\ Bihar",
  916597 => "Saraikela\/Adstyapur\,\ Bihar",
  91661 => "Rourkela\,\ Odisha",
  916621 => "Hemgiri\,\ Odisha",
  916622 => "Sundargarh\,\ Odisha",
  916624 => "Rajgangpur\,\ Odisha",
  916625 => "Lahunipara\,\ Odisha",
  916626 => "Banaigarh\,\ Odisha",
  91663 => "Sambalpur\,\ Odisha",
  916640 => "Bagdihi\,\ Odisha",
  916641 => "Deodgarh\,\ Odisha",
  916642 => "Kuchinda\,\ Odisha",
  916643 => "Barkot\,\ Odisha",
  916644 => "Rairakhol\,\ Odisha",
  916645 => "Jharsuguda\,\ Odisha",
  916646 => "Bargarh\,\ Odisha",
  916647 => "Naktideul\,\ Odisha",
  916648 => "Patnagarh\,\ Odisha",
  916649 => "Jamankira\,\ Odisha",
  916651 => "Birmaharajpur\,\ Odisha",
  916652 => "Balangir\,\ Odisha",
  916653 => "Dunguripali\,\ Odisha",
  916654 => "Sonapur\,\ Odisha",
  916655 => "Titlagarh\,\ Odisha",
  916657 => "Kantabhanji\,\ Odisha",
  916670 => "Bhawanipatna\,\ Odisha",
  916671 => "Rajkhariar\,\ Odisha",
  916672 => "Dharamgarh\,\ Odisha",
  916673 => "Jayapatna\,\ Odisha",
  916675 => "T\.Rampur\,\ Odisha",
  916676 => "M\.Rampur\,\ Odisha",
  916677 => "Narlaroad\,\ Odisha",
  916678 => "Nowparatan\,\ Odisha",
  916679 => "Komana\,\ Odisha",
  916681 => "Jujumura\,\ Odisha",
  916682 => "Attabira\,\ Odisha",
  916683 => "Padmapur\,\ Odisha",
  916684 => "Paikamal\,\ Odisha",
  916685 => "Sohela\,\ Odisha",
  91671 => "Cuttack\,\ Odisha",
  916721 => "Narsinghpur\,\ Odisha",
  916722 => "Pardip\,\ Odisha",
  916723 => "Athgarh\,\ Odisha",
  916724 => "Jagatsinghpur\,\ Odisha",
  916725 => "Dhanmandal\,\ Odisha",
  916726 => "Jajapur\ Road\,\ Odisha",
  916727 => "Kendrapara\,\ Odisha",
  916728 => "Jajapur\ Town\,\ Odisha",
  916729 => "Pattamundai\,\ Odisha",
  916731 => "Anandapur\,\ Odisha",
  916732 => "Hindol\,\ Odisha",
  916733 => "Ghatgaon\,\ Odisha",
  916735 => "Telkoi\,\ Odisha",
  91674 => "Bhubaneshwar\,\ Odisha",
  916752 => "Puri\,\ Odisha",
  916753 => "Nayagarh\,\ Odisha",
  916755 => "Khurda\,\ Odisha",
  916756 => "Balugaon\,\ Odisha",
  916757 => "Daspalla\,\ Odisha",
  916758 => "Nimapara\,\ Odisha",
  916760 => "Talcher\,\ Odisha",
  916761 => "Chhendipada\,\ Odisha",
  916762 => "Dhenkanal\,\ Odisha",
  916763 => "Athmallik\,\ Odisha",
  916764 => "Anugul\,\ Odisha",
  916765 => "Palla\ Hara\,\ Odisha",
  916766 => "Keonjhar\,\ Odisha",
  916767 => "Barbil\,\ Odisha",
  916768 => "Parajang\,\ Odisha",
  916769 => "Kamakhyanagar\,\ Odisha",
  916781 => "Basta\,\ Odisha",
  916782 => "Balasore\,\ Odisha",
  916784 => "Bhadrak\,\ Odisha",
  916786 => "Chandbali\,\ Odisha",
  916788 => "Soro\,\ Odisha",
  916791 => "Bangiriposi\,\ Odisha",
  916792 => "Baripada\,\ Odisha",
  916793 => "Betanati\,\ Odisha",
  916794 => "Rairangpur\,\ Odisha",
  916795 => "Udala\,\ Odisha",
  916796 => "Karanjia\,\ Odisha",
  916797 => "Jashipur\,\ Odisha",
  91680 => "Berhampur\,\ Odisha",
  916810 => "Khalikote\,\ Odisha",
  916811 => "Chhatrapur\,\ Odisha",
  916814 => "Digapahandi\,\ Odisha",
  916815 => "Parlakhemundi\,\ Odisha",
  916816 => "Mohana\,\ Odisha",
  916817 => "R\.Udayigiri\,\ Odisha",
  916818 => "Buguda\,\ Odisha",
  916819 => "Surada\,\ Odisha",
  916821 => "Bhanjanagar\,\ Odisha",
  916822 => "Aska\,\ Odisha",
  916840 => "Tumudibandha\,\ Odisha",
  916841 => "Boudh\,\ Odisha",
  916842 => "Phulbani\,\ Odisha",
  916843 => "Puruna\ Katak\,\ Odisha",
  916844 => "Kantamal\,\ Odisha",
  916845 => "Phiringia\,\ Odisha",
  916846 => "Baliguda\,\ Odisha",
  916847 => "G\.Udayagiri\,\ Odisha",
  916848 => "Kotagarh\,\ Odisha",
  916849 => "Daringbadi\,\ Odisha",
  916850 => "Kalimela\,\ Odisha",
  916852 => "Koraput\,\ Odisha",
  916853 => "Sunabeda\,\ Odisha",
  916854 => "Jeypore\,\ Odisha",
  916855 => "Laxmipur\,\ Odisha",
  916856 => "Rayagada\,\ Odisha",
  916857 => "Gunupur\,\ Odisha",
  916858 => "Nowrangapur\,\ Odisha",
  916859 => "Motu\,\ Odisha",
  916860 => "Boriguma\,\ Odisha",
  916861 => "Malkangiri\,\ Odisha",
  916862 => "Gudari\,\ Odisha",
  916863 => "Bisam\ Cuttack\,\ Odisha",
  916864 => "Mathili\,\ Odisha",
  916865 => "Kashipur\,\ Odisha",
  916866 => "Umerkote\,\ Odisha",
  916867 => "Jharigan\,\ Odisha",
  916868 => "Nandapur\,\ Odisha",
  916869 => "Papadhandi\,\ Odisha",
  917100 => "Kuhi\,\ Maharashtra",
  917102 => "Parseoni\,\ Maharashtra",
  917103 => "Butibori\,\ Maharashtra",
  917104 => "Hingua\,\ Maharashtra",
  917105 => "Narkhed\,\ Maharashtra",
  917106 => "Bhiwapur\,\ Maharashtra",
  917109 => "Kamptee\,\ Maharashtra",
  917112 => "Katol\,\ Maharashtra",
  917113 => "Saoner\,\ Maharashtra",
  917114 => "Ramtek\,\ Maharashtra",
  917115 => "Mouda\,\ Maharashtra",
  917116 => "Umrer\,\ Maharashtra",
  917118 => "Kalmeshwar\,\ Maharashtra",
  91712 => "Nagpur\,\ Maharashtra",
  917131 => "Sironcha\,\ Maharashtra",
  917132 => "Gadchiroli\,\ Maharashtra",
  917133 => "Aheri\,\ Maharashtra",
  917134 => "Bhamregadh\,\ Maharashtra",
  917135 => "Chamorshi\,\ Maharashtra",
  917136 => "Etapalli\,\ Maharashtra",
  917137 => "Desaiganj\,\ Maharashtra",
  917138 => "Dhanora\,\ Maharashtra",
  917139 => "Kurkheda\,\ Maharashtra",
  917141 => "Betul\,\ Madhya\ Pradesh",
  917142 => "Bhimpur\,\ Madhya\ Pradesh",
  917143 => "Bhainsdehi\,\ Madhya\ Pradesh",
  917144 => "Atner\,\ Madhya\ Pradesh",
  917145 => "Chicholi\,\ Madhya\ Pradesh",
  917146 => "Ghorandogri\,\ Madhya\ Pradesh",
  917147 => "Multai\,\ Madhya\ Pradesh",
  917148 => "Prabha\ Pattan\,\ Madhya\ Pradesh",
  917149 => "Tamia\,\ Madhya\ Pradesh",
  917151 => "Samudrapur\,\ Maharashtra",
  917152 => "Wardha\,\ Maharashtra",
  917153 => "Hinganghat\,\ Maharashtra",
  917155 => "Seloo\,\ Maharashtra",
  917156 => "Talegaokarangal\,\ Maharashtra",
  917157 => "Arvi\,\ Maharashtra",
  917158 => "Deoli\,\ Maharashtra",
  917160 => "Jamai\,\ Madhya\ Pradesh",
  917161 => "Parasia\,\ Madhya\ Pradesh",
  917162 => "Chhindwara\,\ Madhya\ Pradesh",
  917164 => "Pandhurna\,\ Madhya\ Pradesh",
  917165 => "Saunsar\,\ Madhya\ Pradesh",
  917166 => "Chaurai\,\ Madhya\ Pradesh",
  917167 => "Amarwada\,\ Madhya\ Pradesh",
  917168 => "Harrai\,\ Madhya\ Pradesh",
  917169 => "Batkakhapa\,\ Madhya\ Pradesh",
  917170 => "Chumur\,\ Maharashtra",
  917171 => "Gond\ Pipri\,\ Maharashtra",
  917172 => "Chandrapur\,\ Maharashtra",
  917173 => "Rajura\,\ Maharashtra",
  917174 => "Mul\,\ Maharashtra",
  917175 => "Bhadrawati\,\ Maharashtra",
  917176 => "Warora\,\ Maharashtra",
  917177 => "Brahmapuri\,\ Maharashtra",
  917178 => "Sinderwahi\,\ Maharashtra",
  917179 => "Nagbhir\,\ Maharashtra",
  917180 => "Salekasa\,\ Maharashtra",
  917181 => "Lakhandur\,\ Maharashtra",
  917182 => "Gondia\,\ Maharashtra",
  917183 => "Tumsar\,\ Maharashtra",
  917184 => "Bhandara\,\ Maharashtra",
  917185 => "Pauni\,\ Maharashtra",
  917186 => "Sakoli\,\ Maharashtra",
  917187 => "Goregaon\,\ Maharashtra",
  917189 => "Amagaon\,\ Maharashtra",
  917196 => "Arjuni\ Morgaon\,\ Maharashtra",
  917197 => "Mohadi\,\ Maharashtra",
  917198 => "Tirora\,\ Maharashtra",
  917199 => "Deori\,\ Maharashtra",
  917201 => "Kalamb\,\ Maharashtra",
  917202 => "Ralegaon\,\ Maharashtra",
  917203 => "Babhulgaon\,\ Maharashtra",
  91721 => "Amravati\,\ Maharashtra",
  917220 => "Chhikaldara\,\ Maharashtra",
  917221 => "Nandgaon\,\ Maharashtra",
  917222 => "Chandurrly\,\ Maharashtra",
  917223 => "Achalpur\,\ Maharashtra",
  917224 => "Daryapur\,\ Maharashtra",
  917225 => "Tiwasa\,\ Maharashtra",
  917226 => "Dharani\,\ Maharashtra",
  917227 => "Chandurbazar\,\ Maharashtra",
  917228 => "Morshi\,\ Maharashtra",
  917229 => "Warlydwarud\,\ Maharashtra",
  917230 => "Ghatanji\,\ Maharashtra",
  917231 => "Umarkhed\,\ Maharashtra",
  917232 => "Yeotmal\,\ Maharashtra",
  917233 => "Pusad\,\ Maharashtra",
  917234 => "Digras\,\ Maharashtra",
  917235 => "Pandharkawada\,\ Maharashtra",
  917236 => "Maregaon\,\ Maharashtra",
  917237 => "Marigaon\,\ Maharashtra",
  917238 => "Darwaha\,\ Maharashtra",
  917239 => "Wani\,\ Maharashtra",
  91724 => "Akola\,\ Maharashtra",
  917251 => "Risod\,\ Maharashtra",
  917252 => "Washim\,\ Maharashtra",
  917253 => "Mangrulpur\,\ Maharashtra",
  917254 => "Malgaon\,\ Maharashtra",
  917255 => "Barshi\ Takli\,\ Maharashtra",
  917256 => "Murtizapur\,\ Maharashtra",
  917257 => "Balapur\,\ Maharashtra",
  917258 => "Akot\,\ Maharashtra",
  917260 => "Lonar\,\ Maharashtra",
  917261 => "Deolgaonraja\,\ Maharashtra",
  917262 => "Buldhana\,\ Maharashtra",
  917263 => "Khamgaon\,\ Maharashtra",
  917264 => "Chikhali\,\ Maharashtra",
  917265 => "Nandura\,\ Maharashtra",
  917266 => "Jalgaonjamod\,\ Maharashtra",
  917267 => "Malkapur\,\ Maharashtra",
  917268 => "Mekhar\,\ Maharashtra",
  917269 => "Sindkhedaraja\,\ Maharashtra",
  917270 => "Sonkatch\,\ Madhya\ Pradesh",
  917271 => "Bagli\,\ Madhya\ Pradesh",
  917272 => "Dewas\,\ Madhya\ Pradesh",
  917273 => "Kannod\,\ Madhya\ Pradesh",
  917274 => "Khategaon\,\ Madhya\ Pradesh",
  917279 => "Nandnva\,\ Maharashtra",
  917280 => "Barwaha\,\ Madhya\ Pradesh",
  917281 => "Sendhwa\,\ Madhya\ Pradesh",
  917282 => "Khargone\,\ Madhya\ Pradesh",
  917283 => "Maheshwar\,\ Madhya\ Pradesh",
  917284 => "Rajpur\,\ Madhya\ Pradesh",
  917285 => "Kasrawad\,\ Madhya\ Pradesh",
  917286 => "Khetia\,\ Madhya\ Pradesh",
  917287 => "Gogaon\,\ Madhya\ Pradesh",
  917288 => "Bhikangaon\,\ Madhya\ Pradesh",
  917289 => "Zhirnia\,\ Madhya\ Pradesh",
  917290 => "Badwani\,\ Madhya\ Pradesh",
  917291 => "Manawar\,\ Madhya\ Pradesh",
  917292 => "Dhar\,\ Madhya\ Pradesh",
  917294 => "Dharampuri\,\ Madhya\ Pradesh",
  917295 => "Badnawar\,\ Madhya\ Pradesh",
  917296 => "Sardarpur\,\ Madhya\ Pradesh",
  917297 => "Kukshi\,\ Madhya\ Pradesh",
  91731 => "Indore\,\ Madhya\ Pradesh",
  917320 => "Pandhana\,\ Madhya\ Pradesh",
  917321 => "Sanwer\,\ Madhya\ Pradesh",
  917322 => "Depalpur\,\ Madhya\ Pradesh",
  917323 => "Punasa\,\ Madhya\ Pradesh",
  917324 => "Mhow\,\ Madhya\ Pradesh",
  917325 => "Burhanpur\,\ Madhya\ Pradesh",
  917326 => "Baldi\,\ Madhya\ Pradesh",
  917327 => "Harsud\,\ Madhya\ Pradesh",
  917328 => "Khalwa\,\ Madhya\ Pradesh",
  917329 => "Khakner\,\ Madhya\ Pradesh",
  91733 => "Khandwa\,\ Madhya\ Pradesh",
  91734 => "Ujjain\,\ Madhya\ Pradesh",
  917360 => "Shujalpur\,\ Madhya\ Pradesh",
  917361 => "Susner\,\ Madhya\ Pradesh",
  917362 => "Agar\,\ Madhya\ Pradesh",
  917363 => "Berchha\,\ Madhya\ Pradesh",
  917364 => "Shajapur\,\ Madhya\ Pradesh",
  917365 => "Mahidpurcity\,\ Madhya\ Pradesh",
  917366 => "Khachrod\,\ Madhya\ Pradesh",
  917367 => "Badnagar\,\ Madhya\ Pradesh",
  917368 => "Ghatia\,\ Madhya\ Pradesh",
  917369 => "Tarana\,\ Madhya\ Pradesh",
  917370 => "Khilchipur\,\ Madhya\ Pradesh",
  917371 => "Sarangpur\,\ Madhya\ Pradesh",
  917372 => "Rajgarh\,\ Madhya\ Pradesh",
  917374 => "Biaora\,\ Madhya\ Pradesh",
  917375 => "Narsingharh\,\ Madhya\ Pradesh",
  917390 => "Thandla\,\ Madhya\ Pradesh",
  917391 => "Petlawad\,\ Madhya\ Pradesh",
  917392 => "Jhabua\,\ Madhya\ Pradesh",
  917393 => "Jobat\,\ Madhya\ Pradesh",
  917394 => "Alirajpur\,\ Madhya\ Pradesh",
  917395 => "Sondhwa\,\ Madhya\ Pradesh",
  917410 => "Alot\,\ Madhya\ Pradesh",
  917412 => "Ratlam\,\ Madhya\ Pradesh",
  917413 => "Sailana\,\ Madhya\ Pradesh",
  917414 => "Jaora\,\ Madhya\ Pradesh",
  917420 => "Jawad\,\ Madhya\ Pradesh",
  917421 => "Manasa\,\ Madhya\ Pradesh",
  917422 => "Mandsaur\,\ Madhya\ Pradesh",
  917423 => "Neemuch\,\ Madhya\ Pradesh",
  917424 => "Malhargarh\,\ Madhya\ Pradesh",
  917425 => "Garoth\,\ Madhya\ Pradesh",
  917426 => "Sitamau\,\ Madhya\ Pradesh",
  917427 => "Bhanpura\,\ Madhya\ Pradesh",
  917430 => "Khanpur\,\ Rajasthan",
  917431 => "Aklera\,\ Rajasthan",
  917432 => "Jhalawar\,\ Rajasthan",
  917433 => "Pachpahar\/Bhawanimandi\,\ Rajasthan",
  917434 => "Pirawa\/Raipur\,\ Rajasthan",
  917435 => "Gangdhar\,\ Rajasthan",
  917436 => "Hindoli\,\ Rajasthan",
  917437 => "Nainwa\,\ Rajasthan",
  917438 => "Keshoraipatan\/Patan\,\ Rajasthan",
  91744 => "Ladpura\/Kota\,\ Rajasthan",
  917450 => "Sangod\,\ Rajasthan",
  917451 => "Atru\,\ Rajasthan",
  917452 => "Chhabra\,\ Rajasthan",
  917453 => "Baran\,\ Rajasthan",
  917454 => "Chhipaborad\,\ Rajasthan",
  917455 => "Digod\/Sultanpur\,\ Rajasthan",
  917456 => "Kishanganj\/Bhanwargarh\,\ Rajasthan",
  917457 => "Mangrol\,\ Rajasthan",
  917458 => "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
  917459 => "Ramganj\ Mandi\,\ Rajasthan",
  917460 => "Sahabad\,\ Rajasthan",
  917461 => "Mahuwa\,\ Rajasthan",
  917462 => "Sawaimadhopur\,\ Rajasthan",
  917463 => "Gangapur\,\ Rajasthan",
  917464 => "Karauli\,\ Rajasthan",
  917465 => "Sapotra\,\ Rajasthan",
  917466 => "Bonli\,\ Rajasthan",
  917467 => "Bamanwas\,\ Rajasthan",
  917468 => "Khandar\,\ Rajasthan",
  917469 => "Hindaun\,\ Rajasthan",
  91747 => "Bundi\,\ Rajasthan",
  917480 => "Goharganj\,\ Madhya\ Pradesh",
  917481 => "Gairatganj\,\ Madhya\ Pradesh",
  917482 => "Raisen\,\ Madhya\ Pradesh",
  917484 => "Silwani\,\ Madhya\ Pradesh",
  917485 => "Udaipura\,\ Madhya\ Pradesh",
  917486 => "Bareli\,\ Madhya\ Pradesh",
  917487 => "Begamganj\,\ Madhya\ Pradesh",
  917490 => "Pohari\,\ Madhya\ Pradesh",
  917491 => "Narwar\,\ Madhya\ Pradesh",
  917492 => "Shivpuri\,\ Madhya\ Pradesh",
  917493 => "Karera\,\ Madhya\ Pradesh",
  917494 => "Kolaras\,\ Madhya\ Pradesh",
  917495 => "Badarwas\,\ Madhya\ Pradesh",
  917496 => "Pichhore\,\ Madhya\ Pradesh",
  917497 => "Khaniadhana\,\ Madhya\ Pradesh",
  91751 => "Gwalior\,\ Madhya\ Pradesh",
  917521 => "Seondha\,\ Madhya\ Pradesh",
  917522 => "Datia\,\ Madhya\ Pradesh",
  917523 => "Bhander\,\ Madhya\ Pradesh",
  917524 => "Dabra\,\ Madhya\ Pradesh",
  917525 => "Bhitarwar\,\ Madhya\ Pradesh",
  917526 => "Ghatigaon\,\ Madhya\ Pradesh",
  917527 => "Mehgaon\,\ Madhya\ Pradesh",
  917528 => "Bijaypur\,\ Madhya\ Pradesh",
  917529 => "Laher\,\ Madhya\ Pradesh",
  917530 => "Sheopurkalan\,\ Madhya\ Pradesh",
  917531 => "Baroda\,\ Madhya\ Pradesh",
  917532 => "Morena\,\ Madhya\ Pradesh",
  917533 => "Karhal\,\ Madhya\ Pradesh",
  917534 => "Bhind\,\ Madhya\ Pradesh",
  917535 => "Raghunathpur\,\ Madhya\ Pradesh",
  917536 => "Sabalgarh\,\ Madhya\ Pradesh",
  917537 => "Jora\,\ Madhya\ Pradesh",
  917538 => "Ambah\,\ Madhya\ Pradesh",
  917539 => "Gohad\,\ Madhya\ Pradesh",
  917540 => "Bamori\,\ Madhya\ Pradesh",
  917541 => "Isagarh\,\ Madhya\ Pradesh",
  917542 => "Guna\,\ Madhya\ Pradesh",
  917543 => "Ashoknagar\,\ Madhya\ Pradesh",
  917544 => "Raghogarh\,\ Madhya\ Pradesh",
  917545 => "Arone\,\ Madhya\ Pradesh",
  917546 => "Chachaura\,\ Madhya\ Pradesh",
  917547 => "Chanderi\,\ Madhya\ Pradesh",
  917548 => "Mungaoli\,\ Madhya\ Pradesh",
  91755 => "Bhopal\,\ Madhya\ Pradesh",
  917560 => "Ashta\,\ Madhya\ Pradesh",
  917561 => "Ichhawar\,\ Madhya\ Pradesh",
  917562 => "Sehore\,\ Madhya\ Pradesh",
  917563 => "Nasrullaganj\,\ Madhya\ Pradesh",
  917564 => "Budhni\,\ Madhya\ Pradesh",
  917565 => "Berasia\,\ Madhya\ Pradesh",
  917570 => "Seonimalwa\,\ Madhya\ Pradesh",
  917571 => "Khirkiya\,\ Madhya\ Pradesh",
  917572 => "Itarsi\,\ Madhya\ Pradesh",
  917573 => "Timarani\,\ Madhya\ Pradesh",
  917574 => "Hoshangabad\,\ Madhya\ Pradesh",
  917575 => "Sohagpur\,\ Madhya\ Pradesh",
  917576 => "Piparia\,\ Madhya\ Pradesh",
  917577 => "Harda\,\ Madhya\ Pradesh",
  917578 => "Pachmarhi\,\ Madhya\ Pradesh",
  917580 => "Bina\,\ Madhya\ Pradesh",
  917581 => "Khurai\,\ Madhya\ Pradesh",
  917582 => "Sagar\,\ Madhya\ Pradesh",
  917583 => "Banda\,\ Madhya\ Pradesh",
  917584 => "Rahatgarh\,\ Madhya\ Pradesh",
  917585 => "Rehli\,\ Madhya\ Pradesh",
  917586 => "Deori\,\ Madhya\ Pradesh",
  917590 => "Lateri\,\ Madhya\ Pradesh",
  917591 => "Sironj\,\ Madhya\ Pradesh",
  917592 => "Vidisha\,\ Madhya\ Pradesh",
  917593 => "Kurwai\,\ Madhya\ Pradesh",
  917594 => "Ganjbasoda\,\ Madhya\ Pradesh",
  917595 => "Nateran\,\ Madhya\ Pradesh",
  917596 => "Gyraspur\,\ Madhya\ Pradesh",
  917601 => "Patharia\,\ Madhya\ Pradesh",
  917603 => "Tendukheda\,\ Madhya\ Pradesh",
  917604 => "Hatta\,\ Madhya\ Pradesh",
  917605 => "Patera\,\ Madhya\ Pradesh",
  917606 => "Jabera\,\ Madhya\ Pradesh",
  917608 => "Bijawar\,\ Madhya\ Pradesh",
  917609 => "Buxwaha\,\ Madhya\ Pradesh",
  91761 => "Jabalpur\,\ Madhya\ Pradesh",
  917621 => "Patan\,\ Madhya\ Pradesh",
  917622 => "Katni\,\ Madhya\ Pradesh",
  917623 => "Kundam\,\ Madhya\ Pradesh",
  917624 => "Sihora\,\ Madhya\ Pradesh",
  917625 => "Umariapan\,\ Madhya\ Pradesh",
  917626 => "Vijayraghogarh\,\ Madhya\ Pradesh",
  917627 => "Manpur\,\ Madhya\ Pradesh",
  917628 => "Karpa\,\ Madhya\ Pradesh",
  917629 => "Pushprajgarh\,\ Madhya\ Pradesh",
  917630 => "Katangi\,\ Madhya\ Pradesh",
  917632 => "Balaghat\,\ Madhya\ Pradesh",
  917633 => "Waraseoni\,\ Madhya\ Pradesh",
  917634 => "Lamta\,\ Madhya\ Pradesh",
  917635 => "Lanji\,\ Madhya\ Pradesh",
  917636 => "Baihar\,\ Madhya\ Pradesh",
  917637 => "Birsa\,\ Madhya\ Pradesh",
  917638 => "Damoh\,\ Madhya\ Pradesh",
  917640 => "Shahpur\,\ Madhya\ Pradesh",
  917641 => "Niwas\,\ Madhya\ Pradesh",
  917642 => "Mandla\,\ Madhya\ Pradesh",
  917643 => "Bijadandi\,\ Madhya\ Pradesh",
  917644 => "Dindori\,\ Madhya\ Pradesh",
  917645 => "Karanjia\,\ Madhya\ Pradesh",
  917646 => "Nainpur\,\ Madhya\ Pradesh",
  917647 => "Ghughari\,\ Madhya\ Pradesh",
  917648 => "Mawai\,\ Madhya\ Pradesh",
  917649 => "Kakaiya\,\ Madhya\ Pradesh",
  917650 => "Beohari\,\ Madhya\ Pradesh",
  917651 => "Jaisinghnagar\,\ Madhya\ Pradesh",
  917652 => "Shahdol\,\ Madhya\ Pradesh",
  917653 => "Bandhavgarh\,\ Madhya\ Pradesh",
  917655 => "Birsinghpur\,\ Madhya\ Pradesh",
  917656 => "Kannodi\,\ Madhya\ Pradesh",
  917657 => "Jaitpur\,\ Madhya\ Pradesh",
  917658 => "Kotma\,\ Madhya\ Pradesh",
  917659 => "Jaithari\,\ Madhya\ Pradesh",
  917660 => "Sirmour\,\ Madhya\ Pradesh",
  917661 => "Teonthar\,\ Madhya\ Pradesh",
  917662 => "Rewa\,\ Madhya\ Pradesh",
  917663 => "Mauganj\,\ Madhya\ Pradesh",
  917664 => "Hanumana\,\ Madhya\ Pradesh",
  917670 => "Majhagwan\,\ Madhya\ Pradesh",
  917671 => "Jaitwara\,\ Madhya\ Pradesh",
  917672 => "Satna\,\ Madhya\ Pradesh",
  917673 => "Nagod\,\ Madhya\ Pradesh",
  917674 => "Maihar\,\ Madhya\ Pradesh",
  917675 => "Amarpatan\,\ Madhya\ Pradesh",
  917680 => "Niwari\,\ Madhya\ Pradesh",
  917681 => "Jatara\,\ Madhya\ Pradesh",
  917682 => "Chhatarpur\,\ Madhya\ Pradesh",
  917683 => "Tikamgarh\,\ Madhya\ Pradesh",
  917684 => "Baldeogarh\,\ Madhya\ Pradesh",
  917685 => "Nowgaon\,\ Madhya\ Pradesh",
  917686 => "Khajuraho\,\ Madhya\ Pradesh",
  917687 => "Laundi\,\ Madhya\ Pradesh",
  917688 => "Gourihar\,\ Madhya\ Pradesh",
  917689 => "Badamalhera\,\ Madhya\ Pradesh",
  917690 => "Lakhnadon\,\ Madhya\ Pradesh",
  917691 => "Chhapara\,\ Madhya\ Pradesh",
  917692 => "Seoni\,\ Madhya\ Pradesh",
  917693 => "Ghansour\,\ Madhya\ Pradesh",
  917694 => "Keolari\,\ Madhya\ Pradesh",
  917695 => "Gopalganj\,\ Madhya\ Pradesh",
  917700 => "Nagri\,\ Madhya\ Pradesh",
  917701 => "Pingeshwar\,\ Madhya\ Pradesh",
  917703 => "Manpur\,\ Madhya\ Pradesh",
  917704 => "Deobhog\,\ Madhya\ Pradesh",
  917705 => "Kurud\,\ Madhya\ Pradesh",
  917706 => "Gariaband\,\ Madhya\ Pradesh",
  917707 => "Bagbahera\,\ Madhya\ Pradesh",
  91771 => "Raipur\,\ Madhya\ Pradesh",
  917720 => "Arang\,\ Madhya\ Pradesh",
  917721 => "Neora\,\ Madhya\ Pradesh",
  917722 => "Dhamtari\,\ Madhya\ Pradesh",
  917723 => "Mahasamund\,\ Madhya\ Pradesh",
  917724 => "Basana\,\ Madhya\ Pradesh",
  917725 => "Saraipali\,\ Madhya\ Pradesh",
  917726 => "Bhatapara\,\ Madhya\ Pradesh",
  917727 => "Balodabazar\,\ Madhya\ Pradesh",
  917728 => "Kasdol\,\ Madhya\ Pradesh",
  917729 => "Bhilaigarh\,\ Madhya\ Pradesh",
  917730 => "Ajaigarh\,\ Madhya\ Pradesh",
  917731 => "Gunnore\,\ Madhya\ Pradesh",
  917732 => "Panna\,\ Madhya\ Pradesh",
  917733 => "Pawai\,\ Madhya\ Pradesh",
  917734 => "Shahnagar\,\ Madhya\ Pradesh",
  917740 => "Bodla\,\ Madhya\ Pradesh",
  917741 => "Kawardha\,\ Madhya\ Pradesh",
  917743 => "Chuikhadan\,\ Madhya\ Pradesh",
  917744 => "Rajandgaon\,\ Madhya\ Pradesh",
  917745 => "Chhuriakala\,\ Madhya\ Pradesh",
  917746 => "Manpur\,\ Madhya\ Pradesh",
  917747 => "Mohla\,\ Madhya\ Pradesh",
  917748 => "Dallirajhara\,\ Madhya\ Pradesh",
  917749 => "Balod\,\ Madhya\ Pradesh",
  917750 => "Marwahi\,\ Madhya\ Pradesh",
  917751 => "Pendra\,\ Madhya\ Pradesh",
  917752 => "Bilaspur\,\ Madhya\ Pradesh",
  917753 => "Kota\,\ Madhya\ Pradesh",
  917754 => "Pandaria\,\ Madhya\ Pradesh",
  917755 => "Mungeli\,\ Madhya\ Pradesh",
  917756 => "Lormi\,\ Madhya\ Pradesh",
  917757 => "Shakti\,\ Madhya\ Pradesh",
  917758 => "Dabhara\,\ Madhya\ Pradesh",
  917759 => "Korba\,\ Madhya\ Pradesh",
  917761 => "Tapkara\,\ Madhya\ Pradesh",
  917762 => "Raigarh\,\ Madhya\ Pradesh",
  917763 => "Jashpurnagar\,\ Madhya\ Pradesh",
  917764 => "Kunkuri\,\ Madhya\ Pradesh",
  917765 => "Pathalgaon\,\ Madhya\ Pradesh",
  917766 => "Dharamjaigarh\,\ Madhya\ Pradesh",
  917767 => "Gharghoda\,\ Madhya\ Pradesh",
  917768 => "Saranggarh\,\ Madhya\ Pradesh",
  917769 => "Bagicha\,\ Madhya\ Pradesh",
  917770 => "Kathdol\,\ Madhya\ Pradesh",
  917771 => "Manendragarh\,\ Madhya\ Pradesh",
  917772 => "Wadrainagar\,\ Madhya\ Pradesh",
  917773 => "Odgi\,\ Madhya\ Pradesh",
  917774 => "Ambikapur\,\ Madhya\ Pradesh",
  917775 => "Surajpur\,\ Madhya\ Pradesh",
  917776 => "Premnagar\,\ Madhya\ Pradesh",
  917777 => "Pratappur\,\ Madhya\ Pradesh",
  917778 => "Semaria\,\ Madhya\ Pradesh",
  917779 => "Ramchandrapur\,\ Madhya\ Pradesh",
  917781 => "Narainpur\,\ Madhya\ Pradesh",
  917782 => "Jagdalpur\,\ Madhya\ Pradesh",
  917783 => "Padamkot\,\ Madhya\ Pradesh",
  917784 => "Parasgaon\,\ Madhya\ Pradesh",
  917785 => "Makodi\,\ Madhya\ Pradesh",
  917786 => "Kondagaon\,\ Madhya\ Pradesh",
  917787 => "Jarwa\,\ Madhya\ Pradesh",
  917788 => "Luckwada\,\ Madhya\ Pradesh",
  917789 => "Bhairongarh\,\ Madhya\ Pradesh",
  917790 => "Babaichichli\,\ Madhya\ Pradesh",
  917791 => "Gadarwara\,\ Madhya\ Pradesh",
  917792 => "Narsinghpur\,\ Madhya\ Pradesh",
  917793 => "Kareli\,\ Madhya\ Pradesh",
  917794 => "Gotegaon\,\ Madhya\ Pradesh",
  917801 => "Deosar\,\ Madhya\ Pradesh",
  917802 => "Churhat\,\ Madhya\ Pradesh",
  917803 => "Majholi\,\ Madhya\ Pradesh",
  917804 => "Kusmi\,\ Madhya\ Pradesh",
  917805 => "Singrauli\,\ Madhya\ Pradesh",
  917806 => "Chitrangi\,\ Madhya\ Pradesh",
  917810 => "Uproda\,\ Madhya\ Pradesh",
  917811 => "Pasan\,\ Madhya\ Pradesh",
  917812 => "Damoh\,\ Madhya\ Pradesh",
  917813 => "Barpalli\,\ Madhya\ Pradesh",
  917815 => "Kathghora\,\ Madhya\ Pradesh",
  917816 => "Pali\,\ Madhya\ Pradesh",
  917817 => "Janjgir\,\ Madhya\ Pradesh",
  917818 => "Chandipara\,\ Madhya\ Pradesh",
  917819 => "Pandishankar\,\ Madhya\ Pradesh",
  917820 => "Khairagarh\,\ Madhya\ Pradesh",
  917821 => "Dhamda\,\ Madhya\ Pradesh",
  917822 => "Sidhi\,\ Madhya\ Pradesh",
  917823 => "Dongargarh\,\ Madhya\ Pradesh",
  917824 => "Bemetara\,\ Madhya\ Pradesh",
  917825 => "Berla\,\ Madhya\ Pradesh",
  917826 => "Patan\,\ Madhya\ Pradesh",
  917831 => "Balrampur\,\ Madhya\ Pradesh",
  917832 => "Rajpur\,\ Madhya\ Pradesh",
  917833 => "Udaipur\,\ Madhya\ Pradesh",
  917834 => "Sitapur\,\ Madhya\ Pradesh",
  917835 => "Bharathpur\,\ Madhya\ Pradesh",
  917836 => "Baikunthpur\,\ Madhya\ Pradesh",
  917840 => "Koyelibeda\,\ Madhya\ Pradesh",
  917841 => "Sarona\,\ Madhya\ Pradesh",
  917843 => "Durgakondal\,\ Madhya\ Pradesh",
  917844 => "Pakhanjur\,\ Madhya\ Pradesh",
  917846 => "Garpa\,\ Madhya\ Pradesh",
  917847 => "Antagarh\,\ Madhya\ Pradesh",
  917848 => "Keskal\,\ Madhya\ Pradesh",
  917849 => "Baderajpur\,\ Madhya\ Pradesh",
  917850 => "Bhanupratappur\,\ Madhya\ Pradesh",
  917851 => "Bhopalpatnam\,\ Madhya\ Pradesh",
  917852 => "Toynar\,\ Madhya\ Pradesh",
  917853 => "Bijapur\,\ Madhya\ Pradesh",
  917854 => "Ilamidi\,\ Madhya\ Pradesh",
  917855 => "Chingmut\,\ Madhya\ Pradesh",
  917856 => "Dantewada\,\ Madhya\ Pradesh",
  917857 => "Bacheli\,\ Madhya\ Pradesh",
  917858 => "Kuakunda\,\ Madhya\ Pradesh",
  917859 => "Lohadigundah\,\ Madhya\ Pradesh",
  917861 => "Netanar\,\ Madhya\ Pradesh",
  917862 => "Bastanar\,\ Madhya\ Pradesh",
  917863 => "Chingamut\,\ Madhya\ Pradesh",
  917864 => "Sukma\,\ Madhya\ Pradesh",
  917865 => "Gogunda\,\ Madhya\ Pradesh",
  917866 => "Konta\,\ Madhya\ Pradesh",
  917867 => "Bokaband\,\ Madhya\ Pradesh",
  917868 => "Kanker\,\ Madhya\ Pradesh",
  91788 => "Durg\,\ Madhya\ Pradesh",
  9179 => "Ahmedabad\ Local\,\ Gujarat",
  9180 => "Bangalore\,\ Karnataka",
  918110 => "Anekal\,\ Karnataka",
  918111 => "Hosakote\,\ Karnataka",
  918113 => "Channapatna\,\ Karnataka",
  918117 => "Kanakapura\,\ Karnataka",
  918118 => "Nelamangala\,\ Karnataka",
  918119 => "Doddaballapur\,\ Karnataka",
  918131 => "Gubbi\,\ Karnataka",
  918132 => "Kunigal\,\ Karnataka",
  918133 => "Chikkanayakanahalli\,\ Karnataka",
  918134 => "Tiptur\,\ Karnataka",
  918135 => "Sira\,\ Karnataka",
  918136 => "Pavagada\,\ Karnataka",
  918137 => "Madugiri\,\ Karnataka",
  918138 => "Koratageri\,\ Karnataka",
  918139 => "Turuvekere\,\ Karnataka",
  918150 => "Bagepalli\,\ Karnataka",
  918151 => "Malur\,\ Karnataka",
  918152 => "Kolar\,\ Karnataka",
  918153 => "Bangarpet\,\ Karnataka",
  918154 => "Chintamani\,\ Karnataka",
  918155 => "Gowribidanur\,\ Karnataka",
  918156 => "Chikkaballapur\,\ Karnataka",
  918157 => "Srinivasapur\,\ Karnataka",
  918158 => "Sidlaghatta\,\ Karnataka",
  918159 => "Mulbagal\,\ Karnataka",
  91816 => "Tumkur\,\ Karnataka",
  918170 => "Alur\,\ Karnataka",
  918172 => "Hassan\,\ Karnataka",
  918173 => "Sakleshpur\,\ Karnataka",
  918174 => "Arsikere\,\ Karnataka",
  918175 => "Holenarasipur\,\ Karnataka",
  918176 => "Cannarayapatna\,\ Karnataka",
  918177 => "Belur\,\ Karnataka",
  918180 => "Basavapatna\,\ Karnataka",
  918181 => "Thirthahalli\,\ Karnataka",
  918182 => "Shimoga\,\ Karnataka",
  918183 => "Sagar\,\ Karnataka",
  918184 => "Sorab\,\ Karnataka",
  918185 => "Hosanagara\,\ Karnataka",
  918186 => "Kargal\,\ Karnataka",
  918187 => "Shikaripura\,\ Karnataka",
  918188 => "Honnali\,\ Karnataka",
  918189 => "Channagiri\,\ Karnataka",
  918190 => "Tallak\,\ Karnataka",
  918191 => "Holalkere\,\ Karnataka",
  918192 => "Davangere\,\ Karnataka",
  918193 => "Hiriyur\,\ Karnataka",
  918194 => "Chitradurga\,\ Karnataka",
  918195 => "Challakere\,\ Karnataka",
  918196 => "Jagalur\,\ Karnataka",
  918198 => "Molkalmuru\,\ Karnataka",
  918199 => "Hosadurga\,\ Karnataka",
  91820 => "Udupi\,\ Karnataka",
  91821 => "Mysore\,\ Karnataka",
  918221 => "Nanjangud\,\ Karnataka",
  918222 => "Hunsur\,\ Karnataka",
  918223 => "K\.R\.Nagar\,\ Karnataka",
  918224 => "Kollegal\,\ Karnataka",
  918225 => "Cowdahalli\,\ Karnataka",
  918226 => "Chamrajnagar\,\ Karnataka",
  918227 => "T\.Narsipur\,\ Karnataka",
  918228 => "H\.D\.Kote\,\ Karnataka",
  918229 => "Gundlupet\,\ Karnataka",
  918230 => "Krishnarajapet\,\ Karnataka",
  918231 => "Malavalli\,\ Karnataka",
  918232 => "Mandya\,\ Karnataka",
  918234 => "Nagamangala\,\ Karnataka",
  918236 => "Pandavpura\,\ Karnataka",
  91824 => "Mangalore\,\ Karnataka",
  918251 => "Puttur\,\ Karnataka",
  918253 => "Hebri\,\ Karnataka",
  918254 => "Kundapur\,\ Karnataka",
  918255 => "Bantwal\,\ Karnataka",
  918256 => "Belthangady\,\ Karnataka",
  918257 => "Sullia\,\ Karnataka",
  918258 => "Karkala\,\ Karnataka",
  918259 => "Shankarnarayana\,\ Karnataka",
  918261 => "Tarikere\,\ Karnataka",
  918262 => "Chikmagalur\,\ Karnataka",
  918263 => "Mudigere\,\ Karnataka",
  918265 => "Koppa\,\ Karnataka",
  918266 => "Narsimharajapur\,\ Karnataka",
  918267 => "Kadur\,\ Karnataka",
  918272 => "Madikeri\,\ Karnataka",
  918274 => "Virajpet\,\ Karnataka",
  918276 => "Somwarpet\,\ Karnataka",
  918282 => "Bhadravati\,\ Karnataka",
  918283 => "Salkani\,\ Karnataka",
  918284 => "Haliyal\,\ Karnataka",
  918288 => "Bailhongal\,\ Karnataka",
  918289 => "Athani\,\ Karnataka",
  918301 => "Mundagod\,\ Karnataka",
  918304 => "Kundgol\,\ Karnataka",
  91831 => "Belgaum\,\ Karnataka",
  91832 => "Goa",
  918330 => "Saundatti\,\ Karnataka",
  918331 => "Raibag\/Kudchi\,\ Karnataka",
  918332 => "Gokak\,\ Karnataka",
  918333 => "Hukkeri\/Sankeshwar\,\ Karnataka",
  918334 => "Mudalgi\,\ Karnataka",
  918335 => "Ramdurg\,\ Karnataka",
  918336 => "Khanapur\,\ Karnataka",
  918337 => "Murugod\,\ Karnataka",
  918338 => "Chikkodi\,\ Karnataka",
  918339 => "Ainapur\,\ Karnataka",
  918350 => "Mudhol\,\ Karnataka",
  918351 => "Hungund\,\ Karnataka",
  918352 => "Bijapur\,\ Karnataka",
  918353 => "Jamkhandi\,\ Karnataka",
  918354 => "Bagalkot\,\ Karnataka",
  918355 => "Bableshwar\,\ Karnataka",
  918356 => "Muddebihal\,\ Karnataka",
  918357 => "Badami\,\ Karnataka",
  918358 => "Basavanabagewadi\,\ Karnataka",
  918359 => "Indi\,\ Karnataka",
  91836 => "Hubli\,\ Karnataka",
  918370 => "Kalghatagi\,\ Karnataka",
  918371 => "Mundargi\,\ Karnataka",
  918372 => "Gadag\,\ Karnataka",
  918373 => "Ranebennur\,\ Karnataka",
  918375 => "Haveri\,\ Karnataka",
  918376 => "Hirekerur\,\ Karnataka",
  918377 => "Nargund\,\ Karnataka",
  918378 => "Savanur\,\ Karnataka",
  918379 => "Hangal\,\ Karnataka",
  918380 => "Navalgund\,\ Karnataka",
  918381 => "Ron\,\ Karnataka",
  918382 => "Karwar\,\ Karnataka",
  918383 => "Joida\,\ Karnataka",
  918384 => "Sirsi\,\ Karnataka",
  918385 => "Bhatkal\,\ Karnataka",
  918386 => "Kumta\,\ Karnataka",
  918387 => "Honnavar\,\ Karnataka",
  918388 => "Ankola\,\ Karnataka",
  918389 => "Siddapur\,\ Karnataka",
  918391 => "Kudligi\,\ Karnataka",
  918392 => "Bellary\,\ Karnataka",
  918393 => "Kurugodu\,\ Karnataka",
  918394 => "Hospet\,\ Karnataka",
  918395 => "Sandur\,\ Karnataka",
  918396 => "Siruguppa\,\ Karnataka",
  918397 => "H\.B\.Halli\,\ Karnataka",
  918398 => "Harapanahalli\,\ Karnataka",
  918399 => "Huvinahadagali\,\ Karnataka",
  918402 => "Kanigiri\,\ Andhra\ Pradesh",
  918403 => "Yerragondapalem\,\ Andhra\ Pradesh",
  918404 => "Marturu\,\ Andhra\ Pradesh",
  918405 => "Giddalur\,\ Andhra\ Pradesh",
  918406 => "Cumbum\,\ Andhra\ Pradesh",
  918407 => "Darsi\,\ Andhra\ Pradesh",
  918408 => "Donakonda\,\ Andhra\ Pradesh",
  918411 => "Tanduru\,\ Andhra\ Pradesh",
  918412 => "Pargi\,\ Andhra\ Pradesh",
  918413 => "Hyderabad\ West\/Shamshabad\,\ Andhra\ Pradesh",
  918414 => "Ibrahimpatnam\,\ Andhra\ Pradesh",
  918415 => "Hyderabad\ East\/Ghatkeswar\,\ Andhra\ Pradesh",
  918416 => "Vikrabad\,\ Andhra\ Pradesh",
  918417 => "Chevella\,\ Andhra\ Pradesh",
  918418 => "Medchal\,\ Andhra\ Pradesh",
  918419 => "Yellapur\,\ Karnataka",
  918422 => "Chadchan\,\ Karnataka",
  918424 => "Devarahippargi\,\ Karnataka",
  918425 => "Biligi\,\ Karnataka",
  918426 => "Telgi\,\ Karnataka",
  918440 => "Nimburga\,\ Karnataka",
  918441 => "Sedam\,\ Karnataka",
  918442 => "Jewargi\,\ Karnataka",
  918443 => "Shorapur\,\ Karnataka",
  918444 => "Hunsagi\,\ Karnataka",
  918450 => "Andole\/Jogipet\,\ Andhra\ Pradesh",
  918451 => "Zahirabad\,\ Andhra\ Pradesh",
  918452 => "Medak\,\ Andhra\ Pradesh",
  918454 => "Gajwel\,\ Andhra\ Pradesh",
  918455 => "Sangareddy\,\ Andhra\ Pradesh",
  918456 => "Narayankhed\,\ Andhra\ Pradesh",
  918457 => "Siddipet\,\ Andhra\ Pradesh",
  918458 => "Narsapur\,\ Andhra\ Pradesh",
  918461 => "Dichpalli\,\ Andhra\ Pradesh",
  918462 => "Nizamabad\,\ Andhra\ Pradesh",
  918463 => "Armoor\,\ Andhra\ Pradesh",
  918464 => "Madnur\,\ Andhra\ Pradesh",
  918465 => "Yellareddy\,\ Andhra\ Pradesh",
  918466 => "Banswada\,\ Andhra\ Pradesh",
  918467 => "Bodhan\,\ Andhra\ Pradesh",
  918468 => "Kamareddy\,\ Andhra\ Pradesh",
  918470 => "Afzalpur\,\ Karnataka",
  918471 => "Mashal\,\ Karnataka",
  918472 => "Gulbarga\,\ Karnataka",
  918473 => "Yadgiri\,\ Karnataka",
  918474 => "Chittapur\,\ Karnataka",
  918475 => "Chincholi\,\ Karnataka",
  918476 => "Wadi\,\ Karnataka",
  918477 => "Aland\,\ Karnataka",
  918478 => "Kamalapur\,\ Karnataka",
  918479 => "Shahapur\,\ Karnataka",
  918481 => "Basavakalyan\,\ Karnataka",
  918482 => "Bidar\,\ Karnataka",
  918483 => "Humnabad\,\ Karnataka",
  918484 => "Bhalki\,\ Karnataka",
  918485 => "Aurad\,\ Karnataka",
  918487 => "Shirahatti\,\ Karnataka",
  918488 => "Sindagi\,\ Karnataka",
  918490 => "Pamuru\,\ Andhra\ Pradesh",
  918491 => "Kanaganapalle\,\ Andhra\ Pradesh",
  918492 => "Kambadur\,\ Andhra\ Pradesh",
  918493 => "Madakasira\,\ Andhra\ Pradesh",
  918494 => "Kadiri\,\ Andhra\ Pradesh",
  918495 => "Rayadurg\,\ Andhra\ Pradesh",
  918496 => "Uravakonda\,\ Andhra\ Pradesh",
  918497 => "Kalyandurg\,\ Andhra\ Pradesh",
  918498 => "Nallacheruvu\/Tanakallu\,\ Andhra\ Pradesh",
  918499 => "Podili\,\ Andhra\ Pradesh",
  918501 => "Kollapur\,\ Andhra\ Pradesh",
  918502 => "Alampur\,\ Andhra\ Pradesh",
  918503 => "Makthal\,\ Andhra\ Pradesh",
  918504 => "Atmakur\,\ Andhra\ Pradesh",
  918505 => "Kodangal\,\ Andhra\ Pradesh",
  918506 => "Narayanpet\,\ Andhra\ Pradesh",
  918510 => "Koilkuntla\,\ Andhra\ Pradesh",
  918512 => "Adoni\,\ Andhra\ Pradesh",
  918513 => "Nandikotkur\,\ Andhra\ Pradesh",
  918514 => "Nandyal\,\ Andhra\ Pradesh",
  918515 => "Banaganapalle\,\ Andhra\ Pradesh",
  918516 => "Dronachalam\,\ Andhra\ Pradesh",
  918517 => "Atmakur\,\ Andhra\ Pradesh",
  918518 => "Kurnool\,\ Andhra\ Pradesh",
  918519 => "Allagadda\,\ Andhra\ Pradesh",
  918520 => "Pattikonda\,\ Andhra\ Pradesh",
  918522 => "Peapalle\,\ Andhra\ Pradesh",
  918523 => "Alur\,\ Andhra\ Pradesh",
  918524 => "Srisailam\,\ Andhra\ Pradesh",
  918525 => "Gudur\/Kodumur\,\ Andhra\ Pradesh",
  918531 => "Deodurga\,\ Karnataka",
  918532 => "Raichur\,\ Karnataka",
  918533 => "Gangavathi\,\ Karnataka",
  918534 => "Yelburga\,\ Karnataka",
  918535 => "Sindhanur\,\ Karnataka",
  918536 => "Kustagi\,\ Karnataka",
  918537 => "Lingsugur\,\ Karnataka",
  918538 => "Manvi\,\ Karnataka",
  918539 => "Koppal\,\ Karnataka",
  918540 => "Nagarkurnool\,\ Andhra\ Pradesh",
  918541 => "Achampet\,\ Andhra\ Pradesh",
  918542 => "Mahabubnagar\,\ Andhra\ Pradesh",
  918543 => "Wanaparthy\,\ Andhra\ Pradesh",
  918545 => "Amangallu\,\ Andhra\ Pradesh",
  918546 => "Gadwal\,\ Andhra\ Pradesh",
  918548 => "Shadnagar\,\ Andhra\ Pradesh",
  918549 => "Kalwakurthy\,\ Andhra\ Pradesh",
  918550 => "Yellanuru\,\ Andhra\ Pradesh",
  918551 => "Garladinne\,\ Andhra\ Pradesh",
  918552 => "Gooty\/Guntakal\,\ Andhra\ Pradesh",
  918554 => "Anantapur\,\ Andhra\ Pradesh",
  918556 => "Hindupur\,\ Andhra\ Pradesh",
  918557 => "Penukonda\,\ Andhra\ Pradesh",
  918558 => "Tadipatri\,\ Andhra\ Pradesh",
  918559 => "Dharmavaram\,\ Andhra\ Pradesh",
  918560 => "Jammalamadugu\,\ Andhra\ Pradesh",
  918561 => "Rayachoti\,\ Andhra\ Pradesh",
  918562 => "Kadapa\,\ Andhra\ Pradesh",
  918563 => "Kamalapuram\/Yerraguntala\,\ Andhra\ Pradesh",
  918564 => "Proddatur\,\ Andhra\ Pradesh",
  918565 => "Rajampeta\,\ Andhra\ Pradesh",
  918566 => "Koduru\,\ Andhra\ Pradesh",
  918567 => "Lakkireddipalli\,\ Andhra\ Pradesh",
  918568 => "Pulivendla\,\ Andhra\ Pradesh",
  918569 => "Badvel\,\ Andhra\ Pradesh",
  918570 => "Kuppam\,\ Andhra\ Pradesh",
  918571 => "Madanapalli\,\ Andhra\ Pradesh",
  918572 => "Chittoor\,\ Andhra\ Pradesh",
  918573 => "Bangarupalem\,\ Andhra\ Pradesh",
  918576 => "Satyavedu\,\ Andhra\ Pradesh",
  918577 => "Putturu\,\ Andhra\ Pradesh",
  918578 => "Srikalahasthi\,\ Andhra\ Pradesh",
  918579 => "Palmaneru\,\ Andhra\ Pradesh",
  918581 => "Punganur\,\ Andhra\ Pradesh",
  918582 => "B\.Kothakota\,\ Andhra\ Pradesh",
  918583 => "Sodam\,\ Andhra\ Pradesh",
  918584 => "Piler\,\ Andhra\ Pradesh",
  918585 => "Pakala\,\ Andhra\ Pradesh",
  918586 => "Vayalpad\,\ Andhra\ Pradesh",
  918587 => "Venkatgirikota\,\ Andhra\ Pradesh",
  918588 => "Vaimpalli\,\ Andhra\ Pradesh",
  918589 => "Siddavattam\,\ Andhra\ Pradesh",
  918592 => "Ongole\,\ Andhra\ Pradesh",
  918593 => "Medarmetla\,\ Andhra\ Pradesh",
  918594 => "Chirala\,\ Andhra\ Pradesh",
  918596 => "Markapur\,\ Andhra\ Pradesh",
  918598 => "Kandukuru\,\ Andhra\ Pradesh",
  918599 => "Ulvapadu\,\ Andhra\ Pradesh",
  91861 => "Nellore\,\ Andhra\ Pradesh",
  918620 => "Udaygiri\,\ Andhra\ Pradesh",
  918621 => "Rapur\/Podalakur\,\ Andhra\ Pradesh",
  918622 => "Kovvur\,\ Andhra\ Pradesh",
  918623 => "Sullurpet\,\ Andhra\ Pradesh",
  918624 => "Gudur\,\ Andhra\ Pradesh",
  918625 => "Venkatgiri\,\ Andhra\ Pradesh",
  918626 => "Kavali\,\ Andhra\ Pradesh",
  918627 => "Atmakur\,\ Andhra\ Pradesh",
  918628 => "Chejerla\,\ Andhra\ Pradesh",
  918629 => "Vinjamuru\,\ Andhra\ Pradesh",
  91863 => "Guntur\,\ Andhra\ Pradesh",
  918640 => "Krosuru\,\ Andhra\ Pradesh",
  918641 => "Sattenapalli\,\ Andhra\ Pradesh",
  918642 => "Guntur\ Palnad\/Macherala\,\ Andhra\ Pradesh",
  918643 => "Bapatla\,\ Andhra\ Pradesh",
  918644 => "Tenali\,\ Andhra\ Pradesh",
  918645 => "Mangalagiri\,\ Andhra\ Pradesh",
  918646 => "Vinukonda\,\ Andhra\ Pradesh",
  918647 => "Narsaraopet\,\ Andhra\ Pradesh",
  918648 => "Repalle\,\ Andhra\ Pradesh",
  918649 => "Piduguralla\,\ Andhra\ Pradesh",
  918654 => "Jaggayyapet\,\ Andhra\ Pradesh",
  918656 => "Nuzvidu\,\ Andhra\ Pradesh",
  918659 => "Mylavaram\,\ Andhra\ Pradesh",
  91866 => "Vijayawada\,\ Andhra\ Pradesh",
  918671 => "Divi\/Challapalli\,\ Andhra\ Pradesh",
  918672 => "Bandar\/Machilipatnam\,\ Andhra\ Pradesh",
  918673 => "Tirivuru\,\ Andhra\ Pradesh",
  918674 => "Gudivada\,\ Andhra\ Pradesh",
  918676 => "Vuyyuru\,\ Andhra\ Pradesh",
  918677 => "Kaikaluru\,\ Andhra\ Pradesh",
  918678 => "Nandigama\,\ Andhra\ Pradesh",
  918680 => "Nidamanur\/Hillcolony\,\ Andhra\ Pradesh",
  918681 => "Chandoor\,\ Andhra\ Pradesh",
  918682 => "Nalgonda\,\ Andhra\ Pradesh",
  918683 => "Hazurnagar\,\ Andhra\ Pradesh",
  918684 => "Suryapet\,\ Andhra\ Pradesh",
  918685 => "Bhongir\,\ Andhra\ Pradesh",
  918689 => "Miryalguda\,\ Andhra\ Pradesh",
  918691 => "Devarakonda\,\ Andhra\ Pradesh",
  918692 => "Nampalle\,\ Andhra\ Pradesh",
  918693 => "Thungaturthy\,\ Andhra\ Pradesh",
  918694 => "Ramannapet\,\ Andhra\ Pradesh",
  91870 => "Warangal\,\ Andhra\ Pradesh",
  918710 => "Cherial\,\ Andhra\ Pradesh",
  918711 => "Wardhannapet\/Ghanapur\,\ Andhra\ Pradesh",
  918713 => "Parkal\,\ Andhra\ Pradesh",
  918715 => "Mulug\,\ Andhra\ Pradesh",
  918716 => "Jangaon\,\ Andhra\ Pradesh",
  918717 => "Eturnagaram\,\ Andhra\ Pradesh",
  918718 => "Narasampet\,\ Andhra\ Pradesh",
  918719 => "Mahabubbad\,\ Andhra\ Pradesh",
  918720 => "Mahadevapur\,\ Andhra\ Pradesh",
  918721 => "Husnabad\,\ Andhra\ Pradesh",
  918723 => "Sircilla\,\ Andhra\ Pradesh",
  918724 => "Jagtial\,\ Andhra\ Pradesh",
  918725 => "Metpalli\,\ Andhra\ Pradesh",
  918727 => "Huzurabad\,\ Andhra\ Pradesh",
  918728 => "Peddapalli\,\ Andhra\ Pradesh",
  918729 => "Manthani\,\ Andhra\ Pradesh",
  918730 => "Khanapur\,\ Andhra\ Pradesh",
  918731 => "Utnor\,\ Andhra\ Pradesh",
  918732 => "Adilabad\,\ Andhra\ Pradesh",
  918733 => "Asifabad\,\ Andhra\ Pradesh",
  918734 => "Nirmal\,\ Andhra\ Pradesh",
  918735 => "Bellampalli\,\ Andhra\ Pradesh",
  918736 => "Mancherial\,\ Andhra\ Pradesh",
  918737 => "Chinnor\,\ Andhra\ Pradesh",
  918738 => "Sirpurkagaznagar\,\ Andhra\ Pradesh",
  918739 => "Jannaram\/Luxittipet\,\ Andhra\ Pradesh",
  918740 => "Aswaraopet\,\ Andhra\ Pradesh",
  918741 => "Sudhimalla\/Tekulapalli\,\ Andhra\ Pradesh",
  918742 => "Khammam\,\ Andhra\ Pradesh",
  918743 => "Bhadrachalam\,\ Andhra\ Pradesh",
  918744 => "Kothagudem\,\ Andhra\ Pradesh",
  918745 => "Yellandu\,\ Andhra\ Pradesh",
  918746 => "Bhooragamphad\/Manuguru\,\ Andhra\ Pradesh",
  918747 => "Nuguru\/Cherla\,\ Andhra\ Pradesh",
  918748 => "V\.R\.Puram\,\ Andhra\ Pradesh",
  918749 => "Madhira\,\ Andhra\ Pradesh",
  918751 => "Boath\/Echoda\,\ Andhra\ Pradesh",
  918752 => "Bhainsa\,\ Andhra\ Pradesh",
  918753 => "Outsarangapalle\,\ Andhra\ Pradesh",
  918761 => "Sathupalli\,\ Andhra\ Pradesh",
  91877 => "Tirupathi\,\ Andhra\ Pradesh",
  91878 => "Karimnagar\,\ Andhra\ Pradesh",
  918811 => "Polavaram\,\ Andhra\ Pradesh",
  918812 => "Eluru\,\ Andhra\ Pradesh",
  918813 => "Eluru\ Kovvur\/Nidadavolu\,\ Andhra\ Pradesh",
  918814 => "Eluru\ Narsapur\/Palakole\,\ Andhra\ Pradesh",
  918816 => "Bhimavaram\,\ Andhra\ Pradesh",
  918818 => "Tadepalligudem\,\ Andhra\ Pradesh",
  918819 => "Tanuku\,\ Andhra\ Pradesh",
  918821 => "Jangareddygudem\,\ Andhra\ Pradesh",
  918823 => "Chintalapudi\,\ Andhra\ Pradesh",
  918829 => "Bhimadole\,\ Andhra\ Pradesh",
  91883 => "Rajahmundri\,\ Andhra\ Pradesh",
  91884 => "Kakinada\,\ Andhra\ Pradesh",
  918852 => "Peddapuram\,\ Andhra\ Pradesh",
  918854 => "Tuni\,\ Andhra\ Pradesh",
  918855 => "Mandapeta\/Ravulapalem\,\ Andhra\ Pradesh",
  918856 => "Amalapuram\,\ Andhra\ Pradesh",
  918857 => "Ramachandrapuram\,\ Andhra\ Pradesh",
  918862 => "Razole\,\ Andhra\ Pradesh",
  918863 => "Chavitidibbalu\,\ Andhra\ Pradesh",
  918864 => "Rampachodavaram\,\ Andhra\ Pradesh",
  918865 => "Yelavaram\,\ Andhra\ Pradesh",
  918868 => "Yeleswaram\,\ Andhra\ Pradesh",
  918869 => "Pithapuram\,\ Andhra\ Pradesh",
  91891 => "Visakhapatnam\,\ Andhra\ Pradesh",
  918922 => "Vizayanagaram\,\ Andhra\ Pradesh",
  918924 => "Anakapalle\,\ Andhra\ Pradesh",
  918931 => "Yelamanchili\,\ Andhra\ Pradesh",
  918932 => "Narsipatnam\,\ Andhra\ Pradesh",
  918933 => "Bheemunipatnam\,\ Andhra\ Pradesh",
  918934 => "Chodavaram\,\ Andhra\ Pradesh",
  918935 => "Paderu\,\ Andhra\ Pradesh",
  918936 => "Araku\,\ Andhra\ Pradesh",
  918937 => "Chintapalle\,\ Andhra\ Pradesh",
  918938 => "Sileru\,\ Andhra\ Pradesh",
  918941 => "Palakonda\/Rajam\,\ Andhra\ Pradesh",
  918942 => "Srikakulam\,\ Andhra\ Pradesh",
  918944 => "Bobbili\,\ Andhra\ Pradesh",
  918945 => "Tekkali\/Palasa\,\ Andhra\ Pradesh",
  918946 => "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
  918947 => "Sompeta\,\ Andhra\ Pradesh",
  918952 => "Chepurupalli\/Garividi\,\ Andhra\ Pradesh",
  918963 => "Parvathipuram\,\ Andhra\ Pradesh",
  918964 => "Saluru\,\ Andhra\ Pradesh",
  918965 => "Gajapathinagaram\,\ Andhra\ Pradesh",
  918966 => "Srungavarapukota\/Kothavalasa\,\ Andhra\ Pradesh",
);
    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+91|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
  
      return $self if ($self->is_valid());
      $number =~ s/(^0)//g;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
    return $self->is_valid() ? $self : undef;
}
1;