/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef HelperFactory_H
#define HelperFactory_H

#include <vector>
#include <string>

#include "LanguageHelper.h"

using std::vector;
using std::string;


// -----------------------------------------------------------------------------------
// class LanguageHelperFactory
// A simple object factory which handles a set of programming language helper objects.
// -----------------------------------------------------------------------------------

class LanguageHelperFactory
{
public:
   LanguageHelperFactory();
   ~LanguageHelperFactory();


    vector<LanguageHelper *> &languageHelpers();                  // returns a list of language helper objects
    LanguageHelper *languageHelper(const QString &languageName);  // returns a specified language helper object


private:
    vector<LanguageHelper *> languageHelpers_;
};


#endif
