/*******************************************************************************
* Copyright 2023-2024 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include <cstdint>
#include <vector>

namespace dnnl {
namespace impl {
namespace gpu {
namespace intel {
namespace jit {

// clang-format off
static const uint64_t _data[] = {
        0x000000133e4ccccd, 0x4000000000000001, 0x3ca8000000000051, 0x3d0500003ce00000, 0x3d2800003d1a0000, 0x3d6000003d500000, 0x3d8000003d7c0000, 0x3d9000003d8c0000,
        0x3da800003da00000, 0x3dd000003dc00000, 0x3de000003dd80000, 0x3dfc00003df00000, 0x3e0c00003e000000, 0x3e1800003e100000, 0x3e2800003e200000, 0x3e4000003e340000,
        0x3e5000003e460000, 0x3e6000003e580000, 0x3e7000003e6a0000, 0x3e8000003e7c0000, 0x3e8a00003e850000, 0x3e9000003e8c0000, 0x3e9c00003e960000, 0x3ea800003ea00000,
        0x3eb400003eaf0000, 0x3ec000003ebb8000, 0x3ecf00003ec60000, 0x3ed800003ed20000, 0x3ee100003ee00000, 0x3ef000003eee0000, 0x3f0000003efc0000, 0x3f0700003f040000,
        0x3f1000003f0c0000, 0x3f1840003f130000, 0x3f2000003f1c0000, 0x3f2800003f250000, 0x3f3400003f2d4000, 0x3f3d00003f39a000, 0x3f4800003f400000, 0x3f5340003f4f0000,
        0x3f6000003f580000, 0x3f7000003f640000, 0x3f8000003f7c0000, 0x0000000000000002, 0x000000273f800000, 0x3de000003da00000, 0x3e2000003e000000, 0x3e4000003e280000,
        0x3e7000003e600000, 0x3e8c00003e800000, 0x3e9c00003e900000, 0x3ea800003ea00000, 0x3ec000003eb60000, 0x3ed800003ed00000, 0x3ef000003ee00000, 0x3f0000003efc0000,
        0x3f0c00003f070000, 0x3f1600003f100000, 0x3f2000003f1c0000, 0x3f3400003f280000, 0x3f4800003f400000, 0x3f5800003f500000, 0x3f6400003f600000, 0x3f7c00003f700000,
        0x000000b83f800000, 0x49870000497c0000, 0x49900000498dc000, 0x49a2000049992000, 0x49af000049a80000, 0x49bd000049b64000, 0x49d2000049c58800, 0x49e5b00049dc8000,
        0x49fc000049f30000, 0x4a0700004a034000, 0x4a1000004a0dc000, 0x4a1c30004a190000, 0x4a2560004a220000, 0x4a2f00004a2b8000, 0x4a3d00004a340000, 0x4a5200004a421000,
        0x4a5c80004a580000, 0x4a7000004a65b000, 0x4a7c00004a781000, 0x4a89d0004a834000, 0x4a9000004a8dc000, 0x4a9920004a95a000, 0x4aa050004a9c4000, 0x4aa560004aa20000,
        0x4aac44004aa8c000, 0x4ab400004aaf8000, 0x4abd00004aba0c00, 0x4aca80004ac06000, 0x4ad800004ad2f000, 0x4ae3d0004adc8000, 0x4af300004aea0000, 0x4afc00004af81000,
        0x4b0340004aff3c00, 0x4b0c00004b070000, 0x4b1000004b0dc000, 0x4b15a0004b13a800, 0x4b1c00004b18ee00, 0x4b2200004b1e3400, 0x4b28c0004b256000, 0x4b37c0004b2f8000,
        0x4b4000004b3d0000, 0x4b4eb8004b48d000, 0x4b5800004b52f000, 0x4b6580004b5ec000, 0x4b7810004b700000, 0x4b8040004b7c0000, 0x4b87f0004b84e400, 0x4b9000004b8dc000,
        0x4b97e0004b948000, 0x4ba200004b9b6400, 0x4baa04004ba56000, 0x4bb6d0004baf8000, 0x4bc210004bbd0000, 0x4bd7a0004bca8000, 0x4bdc80004bd80000, 0x4bf300004be48400,
        0x4bfe4c004bf81000, 0x4c0b38004c059800, 0x4c1000004c0dc000, 0x4c1b40004c148000, 0x4c28c0004c220000, 0x4c3400004c2f8000, 0x4c4600004c3d0000, 0x4c5800004c4c3000,
        0x4c65b0004c5c8000, 0x4c83a0004c74e600, 0x4c9000004c8f7000, 0x4ca710004c97e000, 0x4cb94d804caf0000, 0x4ccdaa004cc00000, 0x4ce580004cdc8000, 0x4cfc00004ced4e00,
        0x4d07f0004d059800, 0x4d1000004d0dc000, 0x4d1d80004d148000, 0x4d2ea8004d28c000, 0x4d3b80004d340000, 0x4d4a26004d43c000, 0x4d5f20004d52f000, 0x4d7300004d666580,
        0x4d8700004d7c0000, 0x4d9c00004d8dc000, 0x4db640004da48800, 0x4dca80004dbf6800, 0x4df300004ddf2000, 0x4e0c00004e028000, 0x4e28c0004e192400, 0x4e3e20004e2ea800,
        0x4e6100004e52f000, 0x4e9000004e730000, 0x4ed5c0004eb7c000, 0x4f1a3f804ef30000, 0x4f8ca0004f45c100, 0x4190000000000096, 0x4250000042100000, 0x4280000042600000,
        0x42a0000042900000, 0x42c0000042a80000, 0x42e0000042d80000, 0x4300000042f00000, 0x43100000430c0000, 0x43200000431c0000, 0x4336000043280000, 0x434f000043400000,
        0x4358000043520000, 0x4370000043600000, 0x43800000437c0000, 0x438c000043870000, 0x4396000043900000, 0x43a00000439c0000, 0x43b4000043a80000, 0x43c8000043c00000,
        0x43d2000043cf0000, 0x43e0000043d80000, 0x43f0000043e40000, 0x4400000043fc0000, 0x4409c00044050000, 0x44100000440c0000, 0x441c000044160000, 0x4428000044200000,
        0x44340000442f0000, 0x44400000443b8000, 0x444a800044440000, 0x4458000044500000, 0x4463800044600000, 0x447c000044700000, 0x4484000044800000, 0x448c000044898000,
        0x4494800044900000, 0x44a0000044990000, 0x44a8000044a64000, 0x44b4000044af0000, 0x44c0000044bb8000, 0x44d0000044c60000, 0x44e0000044d80000, 0x44f0000044e40000,
        0x4500000044fc0000, 0x4508800045061000, 0x45100000450c0000, 0x451c000045130000, 0x4528000045200000, 0x4536000045328000, 0x45400000453b8000, 0x4555c000454a8000,
        0x4570000045600000, 0x45800000457c0000, 0x458c000045870000, 0x4596000045900000, 0x45a8c00045a00000, 0x45bb800045b52000, 0x45cf000045c00000, 0x45e0000045dc8000,
        0x45ff000045f3c000, 0x460c000046000000, 0x461d800046100000, 0x4634000046248800, 0x4655c00046400000, 0x467c000046600000, 0x4690000046844000, 0x46b5800046a00000,
        0x46dc800046c40000, 0x4702820046f28000, 0x472eae0047100000, 0x4758000047400000, 0x4793000047800000, 0x47d8000047b9a000, 0x4832200048059800, 0x48b58000486d8000,
        0x0000000f496a6000, 0x414000003f800000, 0x4210000041c00000, 0x4290000042400000, 0x4310000042c00000, 0x4390000043400000, 0x4410000043c00000, 0x44d8000044800000,
        0x0000000445900000, 0x400000003f800000, 0x4100000040800000, 0x3f80000000000001, 0x3f80000000000001, 0x4180000000000003, 0x4280000042000000, 0x3f8000000000000c,
        0x40e0000040c00000, 0x4110000041000000, 0x4130000041200000, 0x4150000041400000, 0x4170000041600000, 0x0000000141800000, 0x000000083f800000, 0x404000003f800000,
        0x40c0000040a00000, 0x4110000041000000, 0x4180000041400000, 0x3f8000000000001f, 0x4080000040400000, 0x40c0000040a00000, 0x4100000040e00000, 0x4130000041100000,
        0x4170000041400000, 0x4188000041800000, 0x41c0000041a80000, 0x41f8000041c80000, 0x421c000042040000, 0x424c000042400000, 0x4290000042800000, 0x42c0000042ae0000,
        0x42f6000042e60000, 0x43c0000043400000, 0x45c0000044580000, 0x0000000000000001, 0x0000000000000001, 0x3f80000000000003, 0x4040000040000000, 0x3f80000000000003,
        0x4040000040000000, 0x000000323cc39240, 0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050330400946604, 0x0022010e00301c04, 0xbdd5ceff001d1204,
        0x0a01bcba8ce9ffbc, 0xffbcc097d0ff002b, 0x0042010ebcbe513e, 0xb7dc74ff003d0011, 0x0011bcb2b173ffbc, 0xffbcbd15aeff004b, 0x00744d04bcb8743e, 0x006100110066010e,
        0xeb1dffbcb29141ff, 0xd1ff006f0011bca6, 0xbcb11917ffbcb8b6, 0x0081000d00860011, 0x0851ffbcb2985cff, 0x7aff008f030ebcaa, 0xbca683d1ffbc976a, 0x00bc001100dc8304,
        0x00a97b0400ae000d, 0xfa08ffbcaceb0bff, 0x47ff00b7020dbca4, 0xbc980012ffbca093, 0x00c9760400ce030e, 0x1bafffbc85f8fcff, 0xd1ff00d73501bc67, 0xbc90b735ffbca30b,
        0x00f2130e01000011, 0x99b20cff00ed010d, 0x010abc8b8547ffbc, 0xffbcaf637fff00fb, 0x0112020dbcb3cc91, 0x5d568fff010d100e, 0x4c01bc88910bffbc, 0xffbc79523aff011b,
        0x01b03c05bc1e0995, 0x014c1601016c0207, 0x01391a04013e030e, 0x8d3fffbb116934ff, 0x8bff014710043c8b, 0xbbfc36a0ffbc7cce, 0x01592505015e0107, 0x75c3ff3c07d14fff,
        0x40ff01674f043cb3, 0x3da6b153ff3cddb6, 0x01822d0401904e04, 0x5db35eff017d030e, 0x000dbbaa1430ff3c, 0xff3c965374ff018b, 0x01a2000d3d619167, 0x894070ff019d0e03,
        0x77043d640173ff3c, 0xff3df14131ff01ab, 0x01f8010d3e6c7d80, 0x01ca440401d86204, 0xb54fc8ff01c52e04, 0x010e3ccf47a5ff3b, 0xff3d8203deff01d3, 0x01ea000d3d0714ed,
        0x70f2aeff01e5000a, 0xa6043db5f305ff3d, 0xff3df72cf7ff01f3, 0x021c70043d770dde, 0x02094804020e5504, 0x35a1ff3d327c8bff, 0xf8ff021700073d97, 0x3e087452ff3dc782,
        0x02298104022eb304, 0xce9dff3e402eaeff, 0x6cff0237b5043e7c, 0x3dff568aff3e36cb, 0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x00503a0400946f04,
        0x0022130400302404, 0x99c6f3ff001d0c01, 0x010ebc97cb66ffbc, 0xffbc941503ff002b, 0x0042010ebc976a00, 0x91cc27ff003d0011, 0x070ebc8c7dd3ffbc, 0xffbc924f74ff004b,
        0x00745604bc98d1e0, 0x006100110066010e, 0x1bffffbc8d1361ff, 0x28ff006f070ebc82, 0xbc95a19affbc8c1c, 0x0081000d00860011, 0x8b87ffbc8d3fe3ff, 0x9cff008f030ebc85,
        0xbc80c12dffbc6703, 0x00bc010d00dc0011, 0x00a9130e00ae9304, 0x7251ffbc825a6fff, 0xc5ff00b7000abc8e, 0xbc602ca6ffbc7f5a, 0x00c9010e00ce8f04, 0x32e9ffbc68c286ff,
        0x2dff00d7040bbc78, 0xbc45df23ffbc560b, 0x00f242010100010d, 0x89167fff00ed2b01, 0x8e04bc6aef52ffbc, 0xffbc566548ff00fb, 0x01124c01bc34ace4, 0x62b144ff010d4201,
        0x8504bc3edbffffbc, 0xffbc2a79fbff011b, 0x01b05105bbfc6d1f, 0x014c0207016c2805, 0x0139030e013e1301, 0x0a5eff397fda66ff, 0x2fff01470107bc20, 0x3ca9b5bbff3be1d5,
        0x01592604015e4c04, 0xa4d0ffba059f9eff, 0x0dff0167000d3ccc, 0x3de90528ff3cf80f, 0x0182000d01904904, 0x0b8d6eff017d2604, 0x28043c206ee7ffbc, 0xff3c049951ff018b,
        0x01a200073d1a0303, 0xcb6059ff019d0806, 0x010dbc40b4eeff3c, 0xff3d5ed446ff01ab, 0x01f8010d3e0553c5, 0x01ca520401d86d04, 0x1c44d3ff01c5000d, 0x000d3cf79c94ff3c,
        0xff3d050563ff01d3, 0x01eaaf043d6b4d6f, 0x8c5abeff01e5000d, 0x070e3dc3d1b0ff3d, 0xff3ceea3d9ff01f3, 0x021c78043dfd846a, 0x02095704020e6504, 0x9c13ff3d2ee2dcff,
        0x5eff0217020d3d9c, 0x3e035c64ff3da9ee, 0x02290007022eb104, 0x4306ff3e24ffb3ff, 0xccff02378b053e58, 0x3de14e25ff3e28f1, 0x0000000500000013, 0x00000001000003e8,
        0x012001120000023c, 0x00503f0400946604, 0x0022140100301e04, 0x78115fff001d0301, 0x0012bc73f8d7ffbc, 0xffbc730219ff002b, 0x00421f01bc6c5b4d, 0x69f7c4ff003d030e,
        0x0011bc7181e4ffbc, 0xffbc6b9759ff004b, 0x0074000dbc5e58d0, 0x0061560400660011, 0x6f5cffbc6b6c1fff, 0xd9ff006f2a01bc63, 0xbc4f530bffbc6842, 0x0081570400860011,
        0x2587ffbc5fe1f1ff, 0x31ff008f2a01bc57, 0xbc40c947ffbc5980, 0x00bc001100dc8204, 0x00a9070e00ae000d, 0x18b8ffbc585e11ff, 0xbfff00b77104bc66, 0xbc456ba1ffbc51c4,
        0x00c9790400ce050e, 0x3cd2ffbc28e5f0ff, 0x9fff00d70c0ebc11, 0xbc54a035ffbc38b4, 0x00f200110100010d, 0x4f1359ff00ed000a, 0x3601bc3d19f8ffbc, 0xffbc560c7cff00fb,
        0x01120011bc14fb2b, 0x2c9468ff010d030e, 0x8f05bc467daaffbc, 0xffbbcd8613ff011b, 0x01b05105bc09ac4e, 0x014c1f04016c2805, 0x01391904013e000d, 0xc1a9ffbc317131ff,
        0x94ff01471004bbb6, 0x3ba13b8dffbbb314, 0x0159020e015e0007, 0xef49ffbc3018bbff, 0x44ff0167000d3bd3, 0x3d326a58ff3bcc42, 0x0182000d01904904, 0x9bca7dff017d2e04,
        0x36043c1fe2e2ffbb, 0xff3c48c545ff018b, 0x01a201073d16f9a9, 0x816db0ff019d0007, 0x010d3d35ad0eff3c, 0xff3d464a65ff01ab, 0x01f8010d3dfebf4e, 0x01ca500401d86f04,
        0xd0a942ff01c5000d, 0x000d3cb47108ff3b, 0xff3cd14c4aff01d3, 0x01eaa6043d3fc1a9, 0x78af32ff01e59e04, 0x070e3dde462aff3d, 0xff3d067fb0ff01f3, 0x021c7c043de0282e,
        0x02094a04020e6204, 0xc446ff3caedfc7ff, 0x58ff021700073d53, 0x3de46b56ff3da21c, 0x0229020d022eb104, 0xc613ff3dfdc8b3ff, 0xa5ff0237010e3e31, 0x3e1348e3ff3db6e5,
        0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050370400946604, 0x00220e0400302004, 0x42e06cff001d010e, 0x010ebc4605e6ffbc, 0xffbc3e7d7bff002b,
        0x00421501bc42d744, 0x3ed427ff003d070e, 0x0011bc46615bffbc, 0xffbc3e0547ff004b, 0x00742101bc34bca9, 0x006115010066070e, 0xb21cffbc3ea3b6ff, 0xa7ff006f1101bc34,
        0xbc4059cdffbc47eb, 0x0081000d00860011, 0xefbbffbc39247fff, 0x2cff008f020dbc30, 0xbc15127cffbc271d, 0x00bc001100dc8704, 0x00a9000a00ae000d, 0x057fffbc35af33ff,
        0xb7ff00b77904bc2a, 0xbc1ac427ffbc24b5, 0x00c93b0100ce020d, 0x4d63ffbc289b5eff, 0xf7ff00d74601bc0f, 0xbbdbcf15ffbc0e70, 0x00f200110100010d, 0x1ade58ff00ed0f0e,
        0x8c05bc34ff8dffbc, 0xffbbe6c126ff00fb, 0x01120011bc10b67c, 0x07781bff010d030e, 0x9304bc1b98c0ffbc, 0xffbbca932fff011b, 0x01b04c05bb95a2c3, 0x014c0107016c0207,
        0x01394901013e2b05, 0x8c08ffbb0982a1ff, 0x8bff0147000d3bbc, 0x3ca97206ff3b368d, 0x01592d04015e4204, 0x6fdaffbb0cb27eff, 0x98ff0167000d3c8e, 0x3d8931deff3c77c0,
        0x0182370401906404, 0x13515fff017d030e, 0x020dbb66108bff3c, 0xff3cb4a478ff018b, 0x01a2010d3d85d79f, 0x106851ff019d000d, 0x030e3d9f3a80ff3d, 0xff3deeeae5ff01ab,
        0x01f8020d3e43693d, 0x01ca4e0401d87104, 0x0346b2ff01c53704, 0x000d3c782de8ff3b, 0xff3ca21726ff01d3, 0x01ea010d3d1be855, 0x651a17ff01e58b05, 0x030b3cc7966fff3d,
        0xff3dac238eff01f3, 0x021c70043df9df43, 0x02094e04020e5c04, 0xf04dff3cfea8e9ff, 0xe3ff021700073d30, 0x3d9fc896ff3d69fb, 0x02298404022e8f05, 0x73e6ff3dcc5934ff,
        0x27ff0237b4043e13, 0x3d640d5eff3da4cf, 0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050490400946604, 0x00220c0100302904, 0x1cc745ff001d070e,
        0x0011bc20d465ffbc, 0xffbc1c0ba0ff002b, 0x0042010ebc169cf1, 0x114307ff003d0107, 0x0011bc0853ddffbc, 0xffbc1a5a0fff004b, 0x0074070ebc12cf23, 0x0061020d00660011,
        0x57c4ffbc0f7ff4ff, 0x50ff006f3001bc07, 0xbbf331cbffbc093e, 0x00810c0100861901, 0x4bc2ffbc2463daff, 0x7bff008f0011bc1d, 0xbc120cf1ffbc1a15, 0x00bc000d00dc9004,
        0x00a9140e00ae0a0b, 0x148dffbc0714b0ff, 0xf1ff00b73c01bc1a, 0xbbe91109ffbc0b3b, 0x00c9020d00ce0011, 0x3ec6ffbc033f6fff, 0x03ff00d74601bbf1, 0xbbbab9aeffbbeb51,
        0x00f2000a0100020d, 0xca312fff00ed8905, 0x4701bc06add8ffbb, 0xffbbf60eb0ff00fb, 0x0112050bbb9d1f09, 0x769cf6ff010d030b, 0x8a05bbc54150ffbb, 0xffbaf47652ff011b,
        0x01b03c05bb94862e, 0x014c1801016c0207, 0x01390a04013e030e, 0x40baffbbfceb5fff, 0xf9ff0147000a3b9d, 0xbba8a9c7ffbc2029, 0x0159020e015e0007, 0xcc70ffbc159eabff,
        0xe6ff0167010d3ba4, 0x3d4682e0ff3c210b, 0x0182060301905704, 0x59eb44ff017d070e, 0x000dbc7eb734ff3a, 0xff3bf3ec7dff018b, 0x01a2010d3cc4fcca, 0xd4276eff019d8d04,
        0x87043d8c59eeff3c, 0xff3dab825fff01ab, 0x01f86f043e2b8874, 0x01ca220401d83c04, 0x1147c1ff01c51704, 0x030ebad51842ffbc, 0xff3c2e6ef9ff01d3, 0x01ea000d3a0b4aec,
        0x7e97e2ff01e5070e, 0x6004bbafa72aff3c, 0xff3cdd77c1ff01f3, 0x021c010d3d2a7ec7, 0x0209000d020e010a, 0xcffbff3cd4239cff, 0xd3ff0217aa043d42, 0x3cf6d05eff3d8518,
        0x0229040b022e0007, 0x72faff3d831b24ff, 0x5cff0237b1043db2, 0x3d7ca18dff3de0e4, 0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050520400947c04,
        0x0022001100301801, 0x00007aff001d010d, 0x0b01bbfb3465ffbc, 0xffbbfb849cff002b, 0x00420011bbf41b0d, 0xf5ffb4ff003d020d, 0x3701bbe8af41ffbb, 0xffbbe5ce87ff004b,
        0x0074020dbbd62fd2, 0x0061070e00660011, 0xa592ffbbe0bf90ff, 0x83ff006f3701bbf6, 0xbbc4aa28ffbbe4d8, 0x0081600400860107, 0x9100ffbbd01e90ff, 0x2fff008f3201bbb4,
        0xbb9a0672ffbbc8f8, 0x00bc001200dc010d, 0x00a9000d00ae000a, 0x939bffbbe867b0ff, 0x7eff00b7130ebbca, 0xbbf4ce1bffbbbf85, 0x00c98f0500ce100e, 0x257effbb868269ff,
        0x2cff00d7170ebbc8, 0xbc0583b3ffbbbcf5, 0x00f2000a01004c01, 0xcd3306ff00ed0012, 0x030bbb93b76fffbb, 0xffbbafeac2ff00fb, 0x01120011bc0d0e73, 0xbbe138ff010d030b,
        0x8d05bba0af6bffbb, 0xffbb3ff7d5ff011b, 0x01b03c05bb988a7f, 0x014c2604016c0207, 0x01391601013e000d, 0xd55dffbba9ac47ff, 0x96ff01471604bc30, 0x3b83af9bffbb5aee,
        0x0159010e015e0007, 0x0b3bffbc04f42bff, 0xbfff0167000d3b60, 0x3cf7b49eff3b1ad7, 0x0182120501906604, 0x821523ff017d000d, 0x020d3c0282e1ffbb, 0xff3c701074ff018b,
        0x01a2000d3d4d3567, 0x244f2fff019d0f0e, 0x7d04bb21df44ff3d, 0xff3d75f56cff01ab, 0x01f87e043def7712, 0x01ca000d01d85804, 0x016235ff01c5000a, 0x3a043bffcb21ff3a,
        0xff3bb0b0cfff01d3, 0x01ea020d3c9dceeb, 0x4e1268ff01e5000d, 0x01073cf7c745ff3c, 0xff3d3f332cff01f3, 0x021c010d3d8d6cfa, 0x0209000d020e8405, 0x0374ff3d18a8b6ff,
        0x7dff02178f053d82, 0x3b347cacff3cdaac, 0x0229020d022e8b05, 0x66fcff3d8846d1ff, 0xafff0237b5043dcc, 0x3cf6a8daff3d6f04, 0x0000000500000013, 0x00000001000003e8,
        0x012001120000023c, 0x00505a0400947c04, 0x0022000d00302b04, 0xcbf8feff001d0011, 0x0107bbc7425dffbb, 0xffbbc5391dff002b, 0x00421b01bbbe6975, 0xc0f234ff003d070e,
        0x0011bbcd1a48ffbb, 0xffbbbe8b95ff004b, 0x0074020dbbae52ff, 0x006100110066080e, 0xc118ffbbb1d661ff, 0xadff006f2501bb9b, 0xbbb5d3feffbbcee9, 0x00814a0100860011,
        0x0b3fffbbb7b6c7ff, 0x41ff008f4101bba6, 0xbb6b1d9fffbb9369, 0x00bc9a0400dc010d, 0x00a9000d00ae0a0b, 0x92a4ffbbb25c8bff, 0x9aff00b70011bb8f, 0xbb74bba5ffbba4c0,
        0x00c9040b00ce000a, 0x9760ffbbc879e7ff, 0x06ff00d70011bb87, 0xbb252621ffbb91c3, 0x00f2070e01009a04, 0x92ca6eff00ed0011, 0x3401bb41b005ffbb, 0xffbbd978b6ff00fb,
        0x01128a05bb90c22b, 0x0e9d91ff010d050b, 0x000aba2e5abaffbb, 0xffbb89a8fcff011b, 0x01b03c05bad3ff61, 0x014c1e01016c0207, 0x01392a04013e030e, 0x75f2ff380ad82fff,
        0x2bff0147070e3c61, 0xbbee5a33ffbb4dd8, 0x0159040e015e020b, 0x0156ffbb4dc0ccff, 0x9bff016787043b86, 0x3dac6acfff3c3bdf, 0x0182360401905704, 0x95e4d5ff017d0303,
        0x000d3b3c4319ffbb, 0xff3b823b08ff018b, 0x01a2010d3c9d6da6, 0x46e9adff019d000d, 0x78043d127c70ff3c, 0xff3d56c133ff01ab, 0x01f87f043dccac6e, 0x01ca360401d84d04,
        0xe15c7eff01c51b04, 0x010e3b11a28effbb, 0xff3c59a555ff01d3, 0x01ea000d3b9a1e41, 0x46ab76ff01e5070e, 0x020dbbe0e419ff3c, 0xff3cb83dfcff01f3, 0x021c020d3d232a76,
        0x0209130e020e7e05, 0x3b11ff3d3acb77ff, 0x99ff0217a604bc8a, 0x3c111da3ff3d0119, 0x0229040b022e8905, 0x154eff3d92fdfeff, 0xc5ff0237b5043dfb, 0x3cc15f08ff3d510d,
        0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050430400947204, 0x0022060400302d04, 0xa5a840ff001d0011, 0x1101bba35466ffbb, 0xffbba06e65ff002b,
        0x00420107bb9b2155, 0x9e3f04ff003d0007, 0x2b01bb96dabdffbb, 0xffbb982812ff004b, 0x0074020dbb87703e, 0x006100070066070e, 0xbef5ffbb93fdb1ff, 0x13ff006f000abb85,
        0xbba46765ffbb9a2d, 0x0081170100863201, 0x7f65ffbba30feaff, 0xd5ff008f0007bb86, 0xbb516545ffbb899b, 0x00bc000a00dc0011, 0x00a9050b00ae000d, 0xe150ffbba8f04bff,
        0x0aff00b7020dbb95, 0xbb72a9a7ffbb85e2, 0x00c92b0100ce4601, 0x0bfbffbba7d0cdff, 0xb4ff00d7050bbb94, 0xbb62866cffbb853a, 0x00f2a00401008705, 0x253c3cff00ed060e,
        0x0f0ebb68be37ffbb, 0xffba5b4841ff00fb, 0x0112000abb295c5b, 0x4287a4ff010d010e, 0x010dbb9eed73ffbb, 0xffbb3fcdfcff011b, 0x01b03c05baae2fbd, 0x014c2a04016c0207,
        0x01391501013e0e04, 0xcc89ffbb95469aff, 0xd3ff0147000dbc37, 0x3b12269dffbb6d2a, 0x01591b0e015e2605, 0x0ab8ff3b4e2d97ff, 0xabff0167000dbb73, 0x3c8194d4ff3ac823,
        0x0182020d01907004, 0xe215ceff017d070e, 0x5c04bc3d9b8bff3b, 0xff3c9314d8ff018b, 0x01a2130e3d4c5383, 0x24f512ff019d8704, 0x8e043da06dd4ff3d, 0xffbc301d15ff01ab,
        0x01f862043c651eab, 0x01ca1f0401d83204, 0xf82e57ff01c51204, 0x5205bb4054baffbb, 0xff3b75acd1ff01d3, 0x01ea030ebb6b0a31, 0x7a34f5ff01e55705, 0x070e3bd96938ff3c,
        0xff3bbf428aff01f3, 0x021c000dbbf8fe79, 0x0209070b020e000a, 0x0c26ffbbdc5d81ff, 0x79ff02173d013c9e, 0x3cc3dc78ffbbb821, 0x0229030e022e020d, 0xeeb1ff3cd4d4a0ff,
        0xa5ff023700073dab, 0x3d67a221ff3d0174, 0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x0050560400948f04, 0x0022001100302301, 0x843e05ff001d1601,
        0x020dbb810af3ffbb, 0xffbb7d296dff002b, 0x00420011bb6c7d26, 0x7d8a13ff003d010d, 0x000ebb6790e5ffbb, 0xffbb160b9dff004b, 0x00740011bb613d2a, 0x00610f0e00668205,
        0x52a1ffbb5f717eff, 0x97ff006f8805bb81, 0xbb9bd4ecffbb8656, 0x0081010700860b0e, 0x5d9cffbb420e7cff, 0x33ff008f2801bb1e, 0xbb59e1e9ffbb8e7b, 0x00bc010a00dc000d,
        0x00a9000a00ae050b, 0x7ae7ffbb993a31ff, 0x59ff00b7000abb77, 0xbb0c28f2ffbb5021, 0x00c9000700ce0f0e, 0x69f1ffbb138951ff, 0xccff00d73001b9ed, 0xbb0bf3a2ffbb9174,
        0x00f2b50401000012, 0x44de25ff00ed0011, 0x010dbacf925cffbb, 0xffbb6a692fff00fb, 0x01128b05bba2c6e9, 0x6d1280ff010d4c01, 0x0002ba8ec1cbffbb, 0xffbb3b22f6ff011b,
        0x01b02705bac3c7bf, 0x014c4901016c1805, 0x01393604013e070e, 0x5f66ffbafde1e5ff, 0xefff01478a043c15, 0xbb8e3285ffbbef3c, 0x01590c06015e010e, 0x6ed3ffb9c2c2ebff,
        0x8eff0167000abc52, 0x3b94a023ffb9ecb8, 0x0182000d01903604, 0xbf6249ff017d1a01, 0x1904bbf26d5cffba, 0xff398c1946ff018b, 0x01a200073bc1198e, 0x67c412ff019d000a,
        0x010d3c174678ffbb, 0xff3c2b3e27ff01ab, 0x01f801073d2209a6, 0x01ca390401d86704, 0x98182fff01c51c04, 0x020d3b045881ffbb, 0xff3bca7bdcff01d3, 0x01ea010b3c8d587c,
        0xc45d94ff01e50906, 0x8f05bcb0d4beff3a, 0xff3cb461bcff01f3, 0x021c020d3b01ebcf, 0x0209010e020e7104, 0x9b62ff3c5cc0a0ff, 0xc1ff021780053b47, 0x3b253aecff3cdde6,
        0x0229020b022e040b, 0x4707ff3cdf1020ff, 0x55ff023780043d46, 0x3dddce2fff3d5638, 0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x0050300100949004,
        0x0022070e00301701, 0x522502ff001d0011, 0x7404bb49ef40ffbb, 0xffbb58eca1ff002b, 0x0042070ebb95f3b7, 0x4c14afff003d0011, 0x8504bb3aef08ffbb, 0xffbb4b1793ff004b,
        0x0074020dbb6bf152, 0x0061000a0066050b, 0x8bc6ffbb463ef9ff, 0xfcff006f0011bb28, 0xbb0a1c57ffbb39a5, 0x0081760400860011, 0x17f8ffbb362d53ff, 0x4eff008f0007bb11,
        0xbad2c1ffffbb1ac7, 0x00bc850500dc010d, 0x00a9150e00aea404, 0xd1fdffbaf4ebd6ff, 0xdbff00b78005bb4f, 0xbaecc2c9ffb9ac9d, 0x00c9040b00ce000a, 0xb552ffbb80c7e4ff,
        0x41ff00d7070ebb23, 0xba0beaadffbb0a0d, 0x00f2050d0100050b, 0xca5605ff00ed030b, 0x030bbb3b68d5ffba, 0xff3a272776ff00fb, 0x01120007bb1fdde1, 0x11dd8dff010d0002,
        0x0002398a0b52ffbb, 0xffb9ac57f7ff011b, 0x01b027053a7d27ba, 0x014c2201016c1a05, 0x01390006013e0601, 0x51e7ffbb949e7cff, 0x8fff0147030ebc44, 0xbb5cbd46ff3ac3bb,
        0x0159020e015e020b, 0xbdf9ffbbb44bc6ff, 0x6dff0167000d3ad7, 0x3c8ad939ff3b2c59, 0x01820a0601900207, 0xd1300fff017d000d, 0x0b063bdf0babffba, 0xffbc02855aff018b,
        0x01a28804bc76f4f8, 0xcb3b53ff019d010d, 0x000d3ccdfc71ff3b, 0xff3c356292ff01ab, 0x01f801073dac64d8, 0x01ca3d0401d88404, 0x6cb9a8ff01c51e04, 0x070e3b0c3a38ffbb,
        0xff3c11943cff01d3, 0x01ea010bbc01e60a, 0xf605efff01e50706, 0x8905bc4e8d3eff3a, 0xff3ced2a2dff01f3, 0x021c010d3c357657, 0x0209040b020e010a, 0x4180ff3b50fa22ff,
        0x2dff0217070e3c8d, 0x3d7be526ff3cc99a, 0x02297604022e030e, 0xec2fff3c9d68f1ff, 0xbaff02374c013d2e, 0x3d0a9fa7ff3e1e06, 0x0000000500000013, 0x00000001000003e8,
        0x012001120000023c, 0x0050270100944601, 0x0022000d00306104, 0x2575ceff001d070e, 0x1804bb2d2d60ffbb, 0xffbb241fd6ff002b, 0x00428404bb18fa76, 0x36d9aeff003d2401,
        0x2001bb0ba016ffbb, 0xffbb7fc243ff004b, 0x00740107bb3a0ddc, 0x00615d0400660007, 0xc1c8ffbb286cc4ff, 0xaaff006f0011bb1a, 0xbb089cccffbb1f02, 0x0081000d00860011,
        0x9801ffbb1b38d0ff, 0xfdff008f010dbb0f, 0xbacef1eeffbb0526, 0x00bc001100dcb704, 0x00a9000a00ae000d, 0x83ddffbb2bb0d7ff, 0xe4ff00b7000abb0c, 0xbade2c27ffbb0b53,
        0x00c9030b00ce020d, 0x2350ffbb06ef51ff, 0xbaff00d7a504ba9a, 0xb9890022ffba9512, 0x00f292050100010a, 0x9414dfff00ed010e, 0x000abac92d1bffb9, 0xffbb268ee5ff00fb,
        0x0112010ebabc6fb5, 0x2ae9ffff010d030b, 0x7f053a6c8528ff3b, 0xff3b1af61cff011b, 0x01b061053a1c3603, 0x014c1905016c4605, 0x01390e0e013e4f01, 0x8e71ffb9889bf6ff,
        0x28ff0147010abb77, 0x3ba415e2ffb94051, 0x0159020d015e3604, 0xabc6ffba6b1e6aff, 0x6dff016700073bf1, 0x3c443dadff3a2073, 0x0182020d01908704, 0x9558a3ff017d0f0e,
        0x6604bcac0249ff3b, 0xff3c2a06efff018b, 0x01a2130e3ccd1049, 0x980fedff019d4c01, 0x190e3cee3c34ff3d, 0xffbcee9ee6ff01ab, 0x01f8000dbc67da5a, 0x01ca040b01d8000a,
        0x5734bfff01c56e04, 0x070ebc5f2376ffbb, 0xff3baf85a5ff01d3, 0x01ea070e3cf3071e, 0x3fbb3bff01e5a604, 0x9904bb90ab24ff3c, 0xff3c96d5f5ff01f3, 0x021caf043d86273e,
        0x02097e04020e9e04, 0x1a1eff3bead9abff, 0x6fff0217a6043c98, 0x3c9c4ee4ff3d50cc, 0x0229010a022e010d, 0x8971ffbc553a48ff, 0x0fff0237b1043bb9, 0x3ba9babeff3d9679,
        0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x0050320100949004, 0x00221a010030020d, 0x054697ff001d6504, 0x8404bb2a7495ffbb, 0xffbafddaafff002b,
        0x00427b04bb137b48, 0x029d17ff003d1001, 0x8904bae349d0ffbb, 0xffbb25cec4ff004b, 0x0074010dbbab78c0, 0x00615f0400660007, 0x2f04ffbb0e0c9bff, 0x18ff006f0011baf2,
        0xbabea4abffbaeed5, 0x008101070086040d, 0xd188ffbac9ddaaff, 0xceff008f030bba8e, 0xbb07918aff38e58d, 0x00bc930500dc070b, 0x00a9010a00ae000d, 0x74feffbb1e8f2eff,
        0x99ff00b74c01ba37, 0xba6233feffbb225d, 0x00c9030b00ce000a, 0xb413ffbb535e1dff, 0x90ff00d7030eba9d, 0xbb24900affba5dc1, 0x00f200110100020d, 0xd23a41ff00edb204,
        0x8005bb051694ffba, 0xffb98627ebff00fb, 0x01120107baaab58f, 0x82cd4bff010d0002, 0xb3043a2ab641ffba, 0xff3a71d09aff011b, 0x01b0000db98d2a14, 0x014c0a0b016c000a,
        0x0139050b013e0f0e, 0xa189ffbbdbf4e3ff, 0x98ff01472805ba82, 0xbcb9ad21ffbb9f49, 0x01593b01015e8e04, 0x8734ffbb2f6a44ff, 0xc9ff0167070e3b89, 0x3d15bae0ff3c2a2f,
        0x01829e040190a104, 0x9c7a10ff017d3701, 0x9f043bd50916ffba, 0xff3d553e82ff018b, 0x01a2070e3c9d773e, 0x2c1c72ff019da604, 0x030bbb677842ff3d, 0xff3d1a54c2ff01ab,
        0x01f834053db08a98, 0x01ca060e01d82505, 0x00ef03ff01c50b06, 0x000bbc02e5c5ff3b, 0xff3ab45fa5ff01d3, 0x01ea01073d93373b, 0x822f13ff01e50806, 0x030ebc39ebf8ff3b,
        0xff3c20cfc7ff01f3, 0x021c6b043db89c8b, 0x0209010d020e0007, 0xfc81ff39f8d494ff, 0x39ff0217020d3bc6, 0x3c8d5f0eff3bc175, 0x02293401022e0007, 0x89beff3d84d176ff,
        0x45ff0237030e3c08, 0x3d983d66ff3c99b6, 0x0000000500000013, 0x00000001000003e8, 0x01207c050000023c, 0x0050a10400940111, 0x0022820400304601, 0xd5b4cfff001d0007,
        0x3801bac0f266ffba, 0xffbb03e018ff002b, 0x0042000dbaabe042, 0xc37d86ff003d010a, 0x7104ba55d9b3ffba, 0xffbaa30d2cff004b, 0x0074af04ba380609, 0x0061050b00660f0e,
        0xc490ffb96a8af2ff, 0x98ff006fa5043a49, 0xb9df470dffbab588, 0x00816d050086b404, 0x64bcff3ba1cb37ff, 0x70ff008fb6043acc, 0x3c432e88ff3c0761, 0x00bc720500dc0107,
        0x00a9360400ae160e, 0x8e23ffba2694ddff, 0x06ff00b705063b5e, 0x3abdb6abffbba477, 0x00c9020d00ce8d04, 0x780effb9d0602bff, 0xcfff00d700073c9f, 0x3cb90b9bff3d520f,
        0x00f28d0401009904, 0xc90edaff00ed020d, 0x000d3c89808eff3a, 0xff3c03fd66ff00fb, 0x0112000d3d0fde76, 0x47dfc5ff010d070e, 0x010d3d2b0bcdff3c, 0xff3d147dc3ff011b,
        0x01b085053d6dc1d5, 0x014ca804016c0111, 0x0139040d013ea104, 0x9bbbffbac3d007ff, 0xbaff0147000d39b1, 0xb954ebd2ffbaa039, 0x01598205015e0207, 0x295aff3a2dfcc9ff,
        0x9eff0167b004b9b5, 0xb964421dffbaf6e3, 0x0182010d01909e04, 0x39c3f8ff017d0207, 0x030bbcedaa73ffb9, 0xff3c80282fff018b, 0x01a202073d3bd01f, 0xfa2b51ff019d040b,
        0x010d3d5d9b38ff3c, 0xffbb23ebf4ff01ab, 0x01f8a6043d20d1a5, 0x01ca000701d89d04, 0x1b0058ff01c59c04, 0x01123c00c80affbb, 0xffbb1af63dff01d3, 0x01ea0111bc59bdf5,
        0x9ef0edff01e5a504, 0x070bbb12dd52ffba, 0xff3c8c56edff01f3, 0x021c91053d44db5c, 0x0209020d020e0207, 0x7f28ffba8d729aff, 0x78ff021701113ba0, 0xbc79d182ffbacffd,
        0x0229010e022ea704, 0xd1e5ffbc992761ff, 0xf7ff0237020dbc35, 0x3a317400ffbb319e, 0x0000000500000013, 0x00000001000003e8, 0x01207b050000023c, 0x00504c010094020b,
        0x0022011200304401, 0xc00f84ff001d000d, 0x010eba9f8211ffba, 0xff39ecec43ff002b, 0x00420007bb3e6ba2, 0x158ef9ff003dad04, 0x01113b14f62dffbb, 0xffba818110ff004b,
        0x0074000a3bf182db, 0x0061030d00660a06, 0x51c1ffbb39ffb7ff, 0xcaff006f090e3910, 0x3aedf4b1ffbc4895, 0x00814f0100869804, 0xea1eff3b280d2eff, 0x13ff008f060eba0e,
        0x3b84c0bbffb9f0db, 0x00bca10400dc0111, 0x00a9010700ae6004, 0x584bffbaa6ffa8ff, 0x83ff00b70007ba8c, 0xba3d5e26ffba9872, 0x00c90d0e00cea804, 0xb96cff399814fcff,
        0x36ff00d7af04ba1c, 0x3b240c91ff3a223f, 0x00f2020d01009404, 0x328126ff00ed5504, 0x86043bc94b78ffb9, 0xff3c2fd726ff00fb, 0x011276053d3fc423, 0xa48153ff010d000d,
        0x99043d20a889ff3c, 0xffbc686275ff011b, 0x01b001123c9e48c5, 0x014c030b016c000a, 0x0139af04013e040d, 0xd75effbad76d7fff, 0x43ff0147020bbb22, 0x3b0362edffb99158,
        0x01590002015e000d, 0x3d58ffbaccac3dff, 0x1eff01670002ba86, 0x3927ba80ffba84ce, 0x0182070e0190000d, 0x47b558ff017db004, 0x0002baad4512ffba, 0xff3a992b46ff018b,
        0x01a20007baca038f, 0x238193ff019d080e, 0x010e3aa31022ffba, 0xffb7daa1d2ff01ab, 0x01f8010d3aafc91b, 0x01ca9e0401d88b05, 0x0b488cff01c5010a, 0xa6043c4e750fffbb,
        0xff3cfea6aeff01d3, 0x01ea0007ba35ba0c, 0xce72c7ff01e58f05, 0x010ebba6914eff3b, 0xffbc2cff34ff01f3, 0x021cb104bb882475, 0x0209af04020e040b, 0xb522ff3c803455ff,
        0x79ff0217a7043d48, 0x3dc67d90ff3cfb3c, 0x02299105022e010e, 0x59e6ffbc4d9f10ff, 0xdcff0237020d3b4c, 0x3d60ee15ff3caf13, 0x0000000500000013, 0x00000001000003e8,
        0x012087050000023c, 0x0050000d00948505, 0x0022a60400308405, 0x85ae37ff001d8305, 0x01123af15299ffba, 0xffb95b5425ff002b, 0x0042000a3c2534cf, 0xf03c3aff003d0111,
        0xae04bc04de5dffba, 0xff3b77f21fff004b, 0x00740112bb0f551a, 0x0061060d00669904, 0xfc9affba5618f4ff, 0x0cff006f050b38ba, 0x3a03ad5affb9cefa, 0x0081000a0086010b,
        0xd44affbb0397c7ff, 0xdbff008fb1043ad4, 0x3b85e073ff3bcdec, 0x00bc030b00dc000a, 0x00a9970400ae0107, 0x127affbb87062dff, 0x9fff00b701123c4a, 0xbcca61fcffbb4205,
        0x00c9011200ce0007, 0x40e0ffba798011ff, 0xe9ff00d701073c8f, 0x3aba4bffffbbf17a, 0x00f2000201009c04, 0x98eef2ff00ed0111, 0x000dbcc00aafffba, 0xffbc2ed3c0ff00fb,
        0x011201123d111e8b, 0x0958b9ff010da704, 0x01073a7e8f7cffba, 0xff3cdd7bd5ff011b, 0x01b0020dbb044120, 0x014c040b016c9d04, 0x01390112013e000a, 0x733fffbaea8c08ff,
        0x0aff01479b04bc0c, 0x3bdf2466ffbb8a23, 0x01590002015e090b, 0x9174ffb9357323ff, 0x0dff01679a043c84, 0xbc03c3caff39199e, 0x018201110190a404, 0xad2a0eff017d040b,
        0x040bb9d98ee1ffba, 0xff3baf7dfcff018b, 0x01a2010b3d148018, 0x5cc21eff019dac04, 0x0112ba7bb6e5ffbc, 0xffba611bb2ff01ab, 0x01f80112bb5d48d5, 0x01ca010e01d80002,
        0xd3c5bbff01c50007, 0x000aba22d54dffba, 0xffbb5956cdff01d3, 0x01eab50438d556b8, 0x065e73ff01e5b104, 0x010e3a367313ffba, 0xffba6cea15ff01f3, 0x021cb104bb619540,
        0x0209ad04020e040b, 0xdff9ff3c3ead49ff, 0x73ff0217050b3d37, 0x3d3e85b5ff3df50e, 0x02290207022e010e, 0xd680ffb9af3f2aff, 0x38ff02370007bc77, 0x3d5f6263ff3caf7b,
        0x0000000500000013, 0x00000001000003e8, 0x012087050000023c, 0x00507b0500948505, 0x0022000a00307205, 0x9df824ff001d0b0e, 0x7005ba5b24ccffb9, 0xff38e8f0d4ff002b,
        0x004200023b10103d, 0xb6c91eff003d0112, 0x010a3bbd56e5ffb9, 0xffbab3bc9dff004b, 0x007401123be70e2d, 0x0061000d0066b404, 0x6165ffba6b331aff, 0x33ff006f070eb995,
        0x3b762703ff39313e, 0x00819e040086020d, 0xe0adffb99e2831ff, 0x78ff008fab043c6a, 0x3d77bf4cff3c89f7, 0x00bc030b00dc000a, 0x00a9020b00ae0107, 0x6173ffbc19ac42ff,
        0xb0ff00b7ab043ba2, 0x39df694dffbc9f2b, 0x00c9011200ce0007, 0x349effba4799a8ff, 0x23ff00d701073c65, 0x3a95099affbbc12f, 0x00f29b0401009c04, 0x6b80eaff00ed9704,
        0x01123cb37d0bffbb, 0xffbaa18a33ff00fb, 0x01120111bd8fee32, 0x060b6bff010d070e, 0x01073afb5ab9ff38, 0xff3cb12fddff011b, 0x01b0020dbad39b77, 0x014c9904016c9d04,
        0x01399304013e9404, 0xdad3ffbb1eabadff, 0xdfff014701113c0e, 0xbc993f7bffba8781, 0x01590111015e9a04, 0xaf37ffbac58f08ff, 0x8dff01679c043d2f, 0x3ac6e121ffbc3e5d,
        0x018201120190a504, 0x93a629ff017d050b, 0x040bb95616f9ffba, 0xff3ba11572ff018b, 0x01a2070e3cecd666, 0x4198f1ff019d0112, 0x0112bb968281ffba, 0xffb9b3ac2bff01ab,
        0x01f801123cd74403, 0x01ca000a01d80002, 0x7aa1b3ff01c5020e, 0x030bbb3744c1ffba, 0xff39f4a1b9ff01d3, 0x01eab504bbafe3bc, 0x408364ff01e50012, 0xb70439d10decffba,
        0xffbb14c77cff01f3, 0x021cb1043a244078, 0x0209ae04020e040b, 0x5070ff3c0ebe1fff, 0xe0ff021700023d34, 0x3d8e016effbc78eb, 0x0229b204022e010e, 0x2aa7ffbc402b4aff,
        0x7fff0237b3043a1c, 0x3d5faffdff3ccbeb, 0x0000000500000013, 0x00000001000003e8, 0x012087050000023c, 0x00507b0500948505, 0x0022000a00307205, 0x73fc95ff001d030d,
        0x70053a541ed3ffba, 0xff38ba5a14ff002b, 0x004200023ae6805b, 0x923a8aff003d0112, 0x99043b9778b8ffb9, 0xffbb23e440ff004b, 0x007401123b18f1bb, 0x0061000a0066b504,
        0x3475ffba23c91cff, 0x4fff006f070eb8e8, 0x3b8c2f00ff38da03, 0x00818d0400869904, 0x6879ffbb9c1c10ff, 0xafff008f02073b9f, 0xba71571bff3c9979, 0x00bc000700dc9d04,
        0x00a99c0400ae010a, 0xeeb1ffba9b77f6ff, 0x7bff00b7010ebc82, 0x38bae6abff3ca8fd, 0x00c9930400ce0112, 0x9f6affbad66110ff, 0xb5ff00d795043ab3, 0xbcc5f0bdffbc18ec,
        0x00f2011201000107, 0xe8018cff00eda704, 0x00073a4e19c4ffb9, 0xff3d0ced9aff00fb, 0x0112010b3c73053b, 0xcbbea0ff010d0002, 0xa804bc09024cffbc, 0xff3b6b5d74ff011b,
        0x01b08f05bb263d74, 0x014c010a016c010b, 0x0139010e013e0007, 0xa27effba6e8e73ff, 0x84ff01470207bbc8, 0xbb95000affbc40be, 0x01598905015e000d, 0x6c1eff3984fd55ff,
        0xeeff0167ad043b93, 0x3b0d43d3ffbbd473, 0x0182000201900107, 0x0a3e78ff017d0112, 0x01113b91168fffba, 0xff37b03d23ff018b, 0x01a202073c179fd5, 0xd98e41ff019d020d,
        0x01113bc6d3a6ffba, 0xffba4cd17fff01ab, 0x01f8a704bc47484d, 0x01caa60401d80112, 0xb91a05ff01c5000a, 0x0007bb95d95affba, 0xff3750f5a0ff01d3, 0x01ea0002bb0159c0,
        0x0831d7ff01e5000d, 0x010bbcd79ef3ffbc, 0xffbc31f9aaff01f3, 0x021cab04bae9931a, 0x02090002020e0112, 0x52e6ffbaadb30eff, 0x6bff0217aa0439e7, 0x3d0a49d7ff3b990f,
        0x02290111022e010a, 0xc3bdffba4a85d4ff, 0x1aff02370112bb6e, 0x3c2e51bbff39a58a, 0x0000000500000013, 0x00000001000003e8, 0x012087050000023c, 0x0050760500948d04,
        0x0022860400308704, 0x157a61ff001d4e01, 0x0e0e3a13cba8ffba, 0xff3bb5fbeaff002b, 0x0042010dbc007152, 0xc21205ff003d0112, 0x0112bc0fd996ffb9, 0xffb98f7995ff004b,
        0x007401113cf9d8b2, 0x0061010700667705, 0xfd6aff3a1c9d50ff, 0x7bff006f7c04ba4d, 0xb9e1f52cffba725f, 0x0081010a0086010e, 0x0740ffb904a13bff, 0x88ff008f000d3cf3,
        0xbcd0000cffbbf33f, 0x00bc011200dc8f04, 0x00a9060e00ae030b, 0x1282ffb919ded9ff, 0xefff00b73d01baa8, 0xb868e2fbffba3e94, 0x00c9000d00ce4c01, 0xb63effbb50d98cff,
        0x1dff00d7010d3d92, 0xbcd73fecffbb707d, 0x00f2ad0401000112, 0x553963ff00ed000a, 0x000aba18fef9ffb7, 0xffba3c8130ff00fb, 0x011200073a11b832, 0x55204eff010d000e,
        0x010d39edebbbffbc, 0xff3c040739ff011b, 0x01b0010d3cc45d62, 0x014c9904016ca604, 0x01399304013e9404, 0x74a9ffbb13e11cff, 0xceff014701113bce, 0xbc826b34ffba0e25,
        0x0159050b015e0112, 0x26cbffba6543e6ff, 0xd2ff0167040b3803, 0x3c926870ff3ac5ae, 0x018201120190a704, 0x698550ff017d030b, 0x000a39664ac4ffba, 0xffbb91c33fff018b,
        0x01a20111bc52b33a, 0x16be37ff019d000a, 0x070eb857c4ebffba, 0xffbb5a10f2ff01ab, 0x01f8b1043cad407a, 0x01ca000201d80112, 0xc25d4eff01c5040d, 0x020d3b48148cffba,
        0xff3ad772a5ff01d3, 0x01ea040bb9eff398, 0x671738ff01e5010b, 0x00023c49761cffbc, 0xffbc55a560ff01f3, 0x021c00023d43503f, 0x0209000a020e0111, 0xd764ffbac2a618ff,
        0x0bff0217b20439cf, 0x3a38ce30ffbd45eb, 0x02290111022eb504, 0x33aeff3a2b7c01ff, 0x8bff0237010b3c5c, 0xbb55c0acff3c709a, 0x0000000500000013, 0x00000001000003e8,
        0x010e87050000022a, 0x00507b0500948505, 0x0022000a00307205, 0x3261b0ff001d0d0e, 0x7005ba39098cffb9, 0xff38f82894ff002b, 0x004202073a9eddaf, 0x9ed031ff003d7705,
        0x010bb945d4cdff3a, 0xffbca9cea9ff004b, 0x0074020bba934fa7, 0x0061930400660107, 0x575affbb176507ff, 0xe9ff006f7d053aed, 0xbc60caa7ff3c5c09, 0x0081001100860112,
        0x5971ffba2d91f7ff, 0x23ff008f020db856, 0x3c984947ff3b4be5, 0x00b3001200ca010b, 0x00a9000d00ae7804, 0x81acff3ad36974ff, 0x0d3b11c16cff3ac7, 0xff00c0000a00c501,
        0x1abac4ffbc89d345, 0x000abd143c34ffbc, 0xa10400e0011100ee, 0xff39a0c515ff00db, 0x00e9b304ba772f59, 0xb378ffbbc1cce8ff, 0x010a01009d043d7f, 0xffbbde6bcaff00fb,
        0x01099f043c585bfc, 0xf0aeff3c699dd8ff, 0x9d04019e020d3abb, 0x030b013a040b015a, 0x16ff0127000a012c, 0x3b414eceffbb5b74, 0xbaf311ff01350002, 0x050b3ba42bd6ffbc,
        0xd3ff01470011014c, 0x3cca1f0fffbb51dc, 0x85fb17ff01558b05, 0xa604bb896c54ff3a, 0xa50401700112017e, 0xffb996b766ff016b, 0x01798f05ba818604, 0x40d9ff3c4f0202ff,
        0x01120190030ebc2a, 0xffb944af54ff018b, 0x0199a704bbb7df6c, 0x22deffbb3ffdbdff, 0x010e01e601113809, 0x000a01b8050b01c6, 0xffba6801f0ff01b3, 0x01c10207b88bf5d9,
        0x08a0ffb8ddad08ff, 0x880501d8ad043afd, 0xffbae1c5e1ff01d3, 0x01e100023a8006c0, 0xd5a4ffbaeae259ff, 0x0207020a8905b9a6, 0x7aff01f7010701fc, 0x3d3d3f42ff3ca74f,
        0xa59680ff0205b304, 0x0002bccbf48eff39, 0x63ff0217a604021c, 0xbc2e2ba7ff3ca201, 0x84963bff02250107, 0x0013bc1d2223ff3c, 0x03e8000000050000, 0x023c000000010000,
        0x150e012084050000, 0x6504005000020094, 0x0112002230040030, 0xffba30f210ff001d, 0x002b080ebad1301e, 0xa6b4ff38df892dff, 0x060b00420112bb23, 0xffba25f813ff003d,
        0x004b020bb9292fc0, 0x0bcdff3ad0c4f2ff, 0x09060074010a3c32, 0x69ff0061ae040066, 0x3b900ef6ffb90004, 0x1e9f9cff006f070e, 0x01123ab7258effbc, 0xcfff00819f040086,
        0xbacb73e2ffb9707f, 0x86bf35ff008fa204, 0x8c0439cfb0b8ff3c, 0x001200bc011200dc, 0x0eff00a9000a00ae, 0xb9fd5cbaff39af48, 0x1a4b5fff00b78704, 0x2003bacc22eaffba,
        0x35ff00c9790400ce, 0xbc1f142fffbc94a2, 0x633e18ff00d72805, 0xae04bcccba10ffbc, 0x020b00f201120100, 0xffbafea6feff00ed, 0x00fb2805ba4e57ec, 0x9503ffbb1f19b8ff,
        0x1e0e01124101bc06, 0xffbada2430ff010d, 0x011b1b0ebc13efa7, 0x8ab3ff3b8daee1ff, 0x011201b002073aea, 0x000a014c010e016c, 0x4bff0139030b013e, 0x384f851dffba2f48,
        0xdffb17ff0147a604, 0x000a39b53701ffb9, 0x7bff0159040e015e, 0xb9f764b1ffbac75e, 0x971f72ff0167b504, 0x010d3a08a700ffb9, 0x9d0401828b050190, 0xffbab63e33ff017d,
        0x018b010a3bdbcf11, 0x44afffbb2ad564ff, 0x900501a2040b3c08, 0xff3bdf6bb9ff019d, 0x01ab8505bb290ed0, 0xe422ff3e484cc0ff, 0xb60401f801123c7d, 0xab0401ca000201d8,
        0xffbb86208dff01c5, 0x01d3020dbaadff96, 0x700cffba283137ff, 0x010a01ea010b39eb, 0xffbb21c085ff01e5, 0x01f3b7043a959adc, 0x4921ffb974efc8ff, 0x8505021c030b3a23,
        0x04ff0209a204020e, 0x3d7d0f60ffbc3867, 0xd8a8e8ff0217010e, 0x8505394918e2ffbb, 0xe1ff0229010d022e, 0xbd95729cffbcaf7e, 0x919b50ff0237b004, 0x0013bc61f206ffbb,
        0x03e8000000050000, 0x022a000000010000, 0x8505010e87050000, 0x720500507b050094, 0x010e0022000a0030, 0xff393ba82eff001d, 0x002b0002b9f659ca, 0xa84bff38a7a15dff,
        0x9f04004200023a9d, 0xffb9b570eeff003d, 0x004b9d043b28144c, 0xb9faffbb180617ff, 0x01070074020b3ac8, 0xa0ff006197040066, 0x3af2b58affbad7bf, 0x3c8f8dff006f8205,
        0x9e043c409103ffbc, 0x77ff008182050086, 0xbabbe175ffb9b346, 0x6ac568ff008f0207, 0x010bba8144a3ff3b, 0x780400b3001100ca, 0xccff00a9000d00ae, 0x3ab1222bff3ab57f,
        0xc5010d3afabcb4ff, 0xf6e2ff00c0000a00, 0xffbc006f04ffbc57, 0x00ee000abcf858e8, 0x00db010e00e00112, 0x83b7ff3959cdc5ff, 0x09ff00e9010eba2d, 0x3b1e454fffbc2635,
        0x00fb9d040100000d, 0x6e3dffbb98f9dcff, 0x21ff0109020b396b, 0x3b7cff60ff3d3625, 0x015a9d04019e020d, 0x012c0002013a010e, 0xd4e1d2ff01279404, 0x9104bba16789ff3a,
        0xff39766f97ff0135, 0x014c01113bdca1c1, 0x35e61cff01479a04, 0x00073b167f56ffba, 0xffbb321d41ff0155, 0x017e0107bc15854c, 0x016b8d0501700111, 0x6d1fff3913a058ff,
        0x17ff01798d05b9bc, 0xbab74313ff3c0398, 0x018b030b01900111, 0xfbfeffba3d6507ff, 0x59ff01990002b89a, 0xbbc3fdf8ff3b1ac1, 0x01c6890501e60112, 0x01b3030e01b8040d,
        0xc539ffb7ce5821ff, 0x84ff01c1070d3b35, 0xb94946e0ff3b6b4a, 0x01d3000201d8b604, 0xa03effba75995bff, 0x07ff01e10007b936, 0x393fd842ffba31a3, 0x01fc010b020a8905,
        0x9d5b4eff01f70207, 0x02073a3aef55ffbc, 0xff3ce8e068ff0205, 0x021c0002bc5346f3, 0x3041f2ff0217b204, 0x01073b2799f8ffbc, 0xff3c46e4b1ff0225, 0x00000013bc00422a,
        0x000003e800000005, 0x0000023c00000001, 0x0094780501208405, 0x0030860400508c04, 0x001d011200224d01, 0x2018ffba0e0066ff, 0x1eff002b01123940, 0x3b28bff0ffba10db,
        0x003d020b00420112, 0x413affba8812ccff, 0x0aff004b010db90c, 0x3cdde0d6ffbc129c, 0x0066011200749204, 0x9ab951ff00613601, 0x000db9076769ffba, 0xff3a6af697ff006f,
        0x008638053ce8de94, 0x8902b8ff0081040e, 0x01123a1ac363ffbb, 0xffb87043d2ff008f, 0x00dc9e043c028073, 0x00ae800500bc9b04, 0x334ec3ff00a9010d, 0x99043abd449dffba,
        0xffbb115876ff00b7, 0x00ce01073bf78934, 0x3b826cff00c90112, 0x01113bd3cd96ffb9, 0xffba3227b5ff00d7, 0x01000111bcab9987, 0x00ed000d00f2b104, 0x1f4fffba803af8ff,
        0x0aff00fb8105b989, 0xb99af9dcff3a9468, 0x010da90401120002, 0x67cdff3cffe60dff, 0x98ff011b020dbc3e, 0x3ccdf5f1ffbadca6, 0x016c040b01b0000a, 0x013e8605014c0207,
        0x0def21ff01390007, 0x020dbbecd593ff3b, 0xffbae91137ff0147, 0x015e030b3a9ffb58, 0x3a0904ff0159a204, 0x8905b9f2fccbffbc, 0xffbcd5034aff0167, 0x01900111bb8dbc47,
        0x017d010701828505, 0xe6e2ffba3b0de8ff, 0x2fff018b010ebb10, 0xb9fdf2c9ff392836, 0x019d010d01a2af04, 0xd836ff3bab7586ff, 0xf2ff01ab070e3cfa, 0x3cdf1643ffbb86bd,
        0x01d8011201f80007, 0x01c59f0401ca0012, 0xe483ffbab8e8f4ff, 0xfdff01d39c04b9bf, 0xb918039dff3a457b, 0x01e59d0401ea8d05, 0xe6d9ff3b47ca7cff, 0xb7ff01f3010d3c74,
        0xbcbfb84bff3ab359, 0x020e9d04021c0002, 0x299139ff02099b04, 0xa904bca1baceffba, 0xff3bf7dfa1ff0217, 0x022e011238a94833, 0x3dc76eff02299f04, 0x9f04b91d1d87ffbb,
        0xff3c1fe415ff0237, 0x00000013bc08e4ce, 0x000003e800000005, 0x0000023c00000001, 0x0094850501208705, 0x0030720500507b05, 0x001d040b0022000a, 0x9583ffba26fcbcff,
        0x67ff002b00023a10, 0x3a6c9a7eff38c729, 0x003d740500420207, 0xd53dffbb09d2a1ff, 0xa6ff004b9e043a4e, 0x37a8ca15ffbc03da, 0x00667f0500748005, 0x12c984ff0061a104,
        0x010d3b765143ffba, 0xffba859e3aff006f, 0x008602073bc819cc, 0x09ae32ff00818d04, 0x01123ac2bb79ffbb, 0xffba0ed046ff008f, 0x00dc020bbc230354, 0x00ae000200bc0111,
        0x2d5bdfff00a97804, 0x7e043a8fd0ecff3a, 0xff3aedb2ecff00b7, 0x00ce000a3a7aaf4e, 0x61661aff00c9010d, 0x8605bcc25e35ffbc, 0xffbbca0097ff00d7, 0x010001073c140195,
        0x00ed011200f2030b, 0x702cffba581c5bff, 0xbbff00fb86053c35, 0x3ae55ccdffbb34ae, 0x010d011101129f04, 0x7ab9ff3b30e039ff, 0xaaff011ba804bc84, 0xbb26e1aaff3ba973,
        0x016c010b01b0010e, 0x013e010d014cb304, 0xa02d5eff0139ad04, 0x02073b03de81ffbb, 0xffbc89b3d5ff0147, 0x015e010d3a2dd855, 0x17dd9cff0159010a, 0x01113b5a33caffbb,
        0xffba946deeff0167, 0x0190a9043c74a63b, 0x017da6040182a804, 0x94f2ff3b00f013ff, 0xa7ff018b0112bb31, 0x3d2817e6ffb9a992, 0x019d010d01a28905, 0xe835ffbb3f22b0ff,
        0x6dff01ab01113c17, 0xbb46f2beffb891ff, 0x01d8040b01f8a304, 0x01c59c0401ca0112, 0x6db1ff3a2773dbff, 0xefff01d39b04ba3a, 0xbaf09e36ffbbeb50, 0x01e59a0401ea0112,
        0x6b09ffba9c5615ff, 0x72ff01f39d04393f, 0x3c36ea04ff368f3c, 0x020ea404021c080e, 0x30e04fff02090111, 0x01113c3100caffb9, 0xffb9c5d3ceff0217, 0x022e01113a8a1cb9,
        0x9e1301ff0229010a, 0x030b3ac59cc6ffb8, 0xff3a82c42dff0237, 0x000000133d253683, 0x000003e800000005, 0x0000023c00000001, 0x0094850501208705, 0x0030750500507a05,
        0x001d140e00224701, 0x0631ffb916075dff, 0x0bff002b2103bb31, 0x39cf3f08ff3b86a6, 0x003d011100420207, 0xb01affb91d9cc0ff, 0x8cff004b040b3b87, 0x3afc2a1dffbc12f6,
        0x006601120074030e, 0x688ad1ff00619104, 0x9904ba120447ff39, 0xffbb1d5c98ff006f, 0x008602073c278ff7, 0xf60186ff0081040b, 0x01113a280fe3ffba, 0xffba60697aff008f,
        0x00dc020bbc2bf08f, 0x00ae860500bc0111, 0x0aafe6ff00a97804, 0x7e043a661b10ff3a, 0xff3abe28baff00b7, 0x00ce000a3a488c3e, 0x3451b2ff00c9010d, 0x000dbc9b7e8effbc,
        0xffbbfd934aff00d7, 0x010000073b93afe0, 0x00ed9d0400f20112, 0x3090ff39b3205fff, 0xe8ff00fb010dba80, 0x3d4ba602ff3b73a3, 0x010d011101129c04, 0x7f29ff3aa02127ff,
        0xd8ff011b010abc8a, 0x3b6254dcffba0ba9, 0x016c010b01b0010e, 0x013e000a014cb204, 0xb6dc2dff0139010d, 0x8c05bc456c1cffbb, 0xffbb001c54ff0147, 0x015e010d3b21d2fd,
        0xc03b9fff0159010a, 0xb6043b2e8fd0ffba, 0xff3c6a10f9ff0167, 0x0190a90439885d4c, 0x017da6040182a804, 0x10bbff3ace4d0cff, 0x86ff018b0112bb0e, 0x3d067984ffb987a8,
        0x019d010d01a28905, 0x0d27ffbb18e88cff, 0xe7ff01ab01123bf3, 0xbb1f289cffb86998, 0x01d8010b01f8a304, 0x01c5010a01ca0107, 0x7dc0ffbba4571fff, 0x46ff01d39d043b55,
        0xbca9e764ffbc7a62, 0x01e5011201ea9c04, 0xe06eff39485bf9ff, 0x8bff01f3010abb8c, 0xbbf5c8d0ff3a9e14, 0x020e0112021ca604, 0x3baa5fff0209000a, 0x010aba4aeedbffb6,
        0xff3bf690d0ff0217, 0x022e8d053d3714bf, 0x1ab57fff0229070e, 0x01123afb6433ffba, 0xffb9acd231ff0237, 0x000000133b0c1910, 0x000003e800000005, 0x0000023c00000001,
        0x00948d0401208705, 0x0030020d00506405, 0x001d2e0400228c04, 0x8b10ffba28a27fff, 0x50ff002b00023887, 0xbd318149ff388e7d, 0x003d8a0400420112, 0x8165ffb9e044b0ff,
        0xc7ff004b5d04b916, 0x3c669dc2ff3b2606, 0x00668a0400748b04, 0x4f4579ff00618704, 0x010e39ed6ef7ffba, 0xff3bacd73cff006f, 0x00860112ba9168fc, 0x26ef37ff00818c04,
        0x010d39972d10ffba, 0xffbb4eebcbff008f, 0x00dc8f04bd2b4ed1, 0x00ae011200bc4c01, 0x47785cff00a9060e, 0x000d388dcdbeffbb, 0xffba65c3beff00b7, 0x00ce01113d4b6f54,
        0xecde05ff00c9000a, 0x010d3a21473affb9, 0xffbba7644dff00d7, 0x01000112bce377fc, 0x00ed030e00f2af04, 0xf438ffb81ea8b0ff, 0x69ff00fb7505b9e1, 0x36792247ff3b23fc,
        0x010d910401120207, 0x0c27ff3ca4c720ff, 0x4dff011b7d053a67, 0xbc31b643ff3c0c2b, 0x016ca10401b00002, 0x013e8a05014c8b05, 0x0fac77ff0139020b, 0x0112baf1f1b9ff3c,
        0xff38969125ff0147, 0x015e01123cfbd697, 0xa25c23ff01599c04, 0x9e04ba744481ff3a, 0xffbbbd5d64ff0167, 0x0190a604bcbb7fc6, 0x017d010a01820112, 0xc001ffba0c8713ff,
        0x33ff018ba3043b0e, 0x3ca96a52ffbb0442, 0x019d010d01a20111, 0x16d0ffb8d042c0ff, 0x58ff01aba704ba28, 0x3a9cb68cffbca8f3, 0x01d8020d01f8af04, 0x01c5000a01ca010b,
        0x49beffbbdbe2cdff, 0xe3ff01d3a504ba2f, 0xb8734726ff3b2136, 0x01e5011201eaa504, 0x3f42ffb9c0e560ff, 0xf2ff01f30112bc9d, 0x3cb41ca7ffb9cee9, 0x020e0112021c8b05,
        0x02afb1ff02098905, 0x070e3a64c8cfffba, 0xffbbdd09c5ff0217, 0x022e010a3c637848, 0xc623fdff0229010d, 0xb0043a7489f2ffba, 0xff3c1b88a3ff0237, 0x000000133a57455a,
        0x000003e800000005, 0x0000023c00000001, 0x0094850501208705, 0x00307d0500508005, 0x001d011200227c05, 0xed1effb9af2dfbff, 0xd7ff002b01123a4f, 0x3c21caf5ffb854b1,
        0x003d010d00420111, 0x9644ff390afeb1ff, 0xfbff004b7e05ba50, 0x3994ea52ffbc821d, 0x00669d040074020d, 0x11587eff0061040b, 0xa6043a58ed6cffbb, 0xff3b986706ff006f,
        0x00860111bb113c29, 0x83a148ff00818d04, 0x8305b96b46d7ff3a, 0xffbb2545c7ff008f, 0x00dc9d043c979d20, 0x00ae9a0400bc9b04, 0x80f352ff00a9020b, 0x010e3a75e8b0ffbb,
        0xff3d24e405ff00b7, 0x00ce0112bc68f368, 0x374628ff00c9000d, 0x9c043acbe973ff3b, 0xffbd4628dbff00d7, 0x01000107bb93a25c, 0x00eda80400f20112, 0xf9b6ffba747a93ff,
        0xbaff00fba80439f2, 0x3d180d6eff3bd2cc, 0x010d011201129f04, 0xb94cff3aadd7feff, 0xa9ff011ba804bc83, 0xbae667a0ff3b5df2, 0x016ca60401b0ae04, 0x013e9804014c9904,
        0x9d70feff0139010d, 0x01113c17c37cffba, 0xffba26035eff0147, 0x015e9a04bcfb8470, 0x54e97fff01590112, 0x9c043ce4b47fffba, 0xffbc0f4941ff0167, 0x0190a7043ab80289,
        0x017d030b0182070b, 0x66fbffbb825e11ff, 0x19ff018b0007bc48, 0x3bacd5a9ffba75d2, 0x019d020d01a20002, 0xc15aff3a53e89eff, 0x57ff01ab010dbbdf, 0x3bff7ec8ff3a82ff,
        0x01d88f0501f80107, 0x01c5b40401ca0111, 0xfe08ffb798c70dff, 0x20ff01d3000a3aac, 0xba494583ff3cc286, 0x01e5010a01eab004, 0xde3fff3a2aa0aeff, 0xccff01f3b2043beb,
        0x38a9a93dffbb0273, 0x020e0112021c020d, 0x711a48ff02090002, 0xb004399ffc92ffb9, 0xff3a9a0efeff0217, 0x022eb004bba52c99, 0x8d1496ff02298905, 0xb504bd16f5f0ff3d,
        0xff3ad7030eff0237, 0x00000013bae86457, 0x000003e800000005, 0x0000023c00000001, 0x0094830501208705, 0x0030470400504201, 0x001d011200223304, 0x6347ffb95d0a4dff,
        0xb2ff002b0112baa1, 0x3a966324ffb9e1d8, 0x003d000a00420112, 0xa49dffb8bb6becff, 0x59ff004b000db9fa, 0x3b763e31ffbaf00a, 0x006681050074ad04, 0x2af469ff0061030e,
        0x010ab94c0328ff3a, 0xffba39208cff006f, 0x00860112bc1bdfc8, 0x21bd24ff0081af04, 0xaf043a1102a4ffba, 0xff3d01cb06ff008f, 0x00dc85053b1231c8, 0x00ae910400bc0112,
        0xf15ed7ff00a9040b, 0xaa04b893bb7dff39, 0xffbabf56adff00b7, 0x00ce040bb87e0b98, 0xaeddafff00c9030b, 0x0007bc70ba6eff3b, 0xff3bd48521ff00d7, 0x0100000d3d0ed648,
        0x00ed010a00f20002, 0x41ddff3a5d7c8fff, 0xd9ff00fb0112bb0b, 0xbc0d7804ffb9fe31, 0x010d010a01128605, 0x8d8affbb0e8cdbff, 0xf8ff011b01123bcb, 0x3c08bb5eff38d824,
        0x016c010b01b0010e, 0x013e010d014cb204, 0xd416aaff01390002, 0x0207b9da03f2ffbb, 0xffbc54c8bbff0147, 0x015e010d3b81cf6b, 0x8f3096ff01590112, 0xb604baf72933ff3a,
        0xff3c38d14cff0167, 0x0190a90439c705c8, 0x017da6040182a704, 0x40edff3a8ac6b7ff, 0x99ff018b0112bb95, 0x3ca6c30bff3a3b1b, 0x019d040b01a28905, 0xf9a7ff3bb804fdff,
        0x29ff01ab0112bb15, 0xbb0fc6c6ff388bf8, 0x01d8000201f8a304, 0x01c5880501ca010a, 0x9776ff3b922df8ff, 0xe8ff01d30112b877, 0xbc9d0c67ff3b50b2, 0x01e5020b01ea0007,
        0xb9e1ffbbcbf730ff, 0x92ff01f3011239c9, 0xbbf4ade2ffba2434, 0x020ea604021ca704, 0xc5cebdff0209010a, 0x000a3c829647ff39, 0xff396a92adff0217, 0x022eac04bbbbc53a,
        0xb093b9ff02290111, 0x070e3c0d0290ffb7, 0xffb9573e58ff0237, 0x000000133a8c8f2f, 0x000003e800000005, 0x0000023c00000001, 0x0094850501208705, 0x0030630500508005,
        0x001d630400224801, 0x3522ffb931c9a9ff, 0xb6ff002b25033918, 0x399f14afff3b5877, 0x003d93040042030b, 0xc570ffba593a48ff, 0x59ff004b040b3ac0, 0x39ee7cd3ffbbabc0,
        0x00669d040074020d, 0xdd63eaff0061000a, 0xa6043ac75a84ffba, 0xff3b6519b9ff006f, 0x00860107bae914c8, 0x78dd60ff00818205, 0x0111bacb8055ff3a, 0xff398aa818ff008f,
        0x00dc020b3c1a9123, 0x00ae7e0400bc0112, 0xc4cc4eff00a9010b, 0x010b3b0c8268ff3a, 0xff3a63e680ff00b7, 0x00ce000a3ab5ab58, 0x029eb2ff00c9010d, 0x8605bc865dd2ffbc,
        0xffbb896b23ff00d7, 0x01009d043bc33885, 0x00ed8e0400f29404, 0x4b31ffb9691138ff, 0x78ff00fb01123bef, 0xbc075129ff3ad34f, 0x010da80401120112, 0xceffffba9df742ff,
        0x0cff011ba9043a47, 0xbba3432eff3bfdd1, 0x016c010b01b0010e, 0x013e010d014cb404, 0x5137bcff0139000a, 0xb2043a288501ffbb, 0xffbc14031dff0147, 0x015e01113b2c1040,
        0xcc6e1eff0159000a, 0x00073a9717b7ffba, 0xff3c99a758ff0167, 0x0190a9043bdcc487, 0x017d90050182a704, 0xdd07ff3a34b28eff, 0xaaff018b0112bbff, 0x3c8568d9ff3a15af,
        0x019d020701a28905, 0xf08bff3b910b34ff, 0x7aff01ab0111bb45, 0xbae60ae1ff385ff3, 0x01d8000201f8a304, 0x01c5010a01ca000d, 0x65bbff39456ae1ff, 0x9dff01d30112bbfb,
        0x3d00a318ffbba848, 0x01e59b0401ea0007, 0xefe3ffbb4993e2ff, 0x59ff01f3070b3ad8, 0x3c209f58ffbbbb91, 0x020e070b021ca704, 0x84e6f4ff02090002, 0x0111bb3e14a1ff3a,
        0xffb640b733ff0217, 0x022e010b3c155dd8, 0x88a56bff02290112, 0x070e3b966b0cffba, 0xffb653b024ff0237, 0x000000133a46d10f, 0x000003e800000005, 0x0000023c00000001,
        0x0094830501208705, 0x00306d0400507b05, 0x001d150400224804, 0xd363ffba48d058ff, 0x19ff002b0112b838, 0x3abc6ccdffb9c81c, 0x003d780500420b06, 0x250bff39e25a36ff,
        0x01ff004b070eb8d6, 0x3b2e2c24ffbbca93, 0x0066aa0400740207, 0xabf2e2ff00617d05, 0x070eb8cedf26ff3a, 0xffbb84745bff006f, 0x00867d053b2d619c, 0xad7397ff0081020d,
        0x01113ced8a9fff3a, 0xffb91f0a7dff008f, 0x00dc8505bc4e9645, 0x00ae930400bc0111, 0xa8b3bdff00a9010b, 0xa60439b2ef62ff3a, 0xffbaccb322ff00b7, 0x00ce050b38948486,
        0x867c69ff00c9030b, 0x010dbc1e6561ff3b, 0xff3c852db3ff00d7, 0x0100000d3dccf4e7, 0x00ed010a00f20002, 0xd17dff3a41217bff, 0x79ff00fb0112bad7, 0xbbea289fffb9c2d5,
        0x010da9040112020e, 0x8a8cff3a8bfcaaff, 0xf7ff011b0111bb86, 0x3d08efdcff3a10fb, 0x016ca40401b0ae04, 0x013e000a014ca304, 0xcbfe08ff01398b05, 0x0002bb2ba232ff39,
        0xffb9e9b6deff0147, 0x015e01113b9b7a32, 0x9bf8e2ff01590007, 0x010dbaa56690ffb9, 0xff3c4b9913ff0167, 0x0190010a3dc442c6, 0x017d020d01820002, 0x5c68ffb848c34eff,
        0x94ff018b010dbbbb, 0x3b8e0f96ffb9eb32, 0x019d011101a2a604, 0xde73ffbb2868a1ff, 0xffff01abac043ce9, 0xbb597616ff3b5512, 0x01d8920501f8030b, 0x01c5000a01ca0112,
        0xbc88ffba356c48ff, 0x14ff01d3b50437bc, 0xbc051632ff3b8c98, 0x01e5b20401eab404, 0x14c0ffba6cbda0ff, 0x20ff01f301113b23, 0xbc08fc10ffba14e0, 0x020e070e021c8a05,
        0x6f39baff0209040b, 0x0111ba42c94aff3c, 0xffb9b17acdff0217, 0x022e040b3d27ec3e, 0x22dbddff02298b05, 0x01123bb94452ffbc, 0xff373abd8cff0237, 0x00000013bb59799f,
        0x000003e800000005, 0x0000023c00000001, 0x0094830501208705, 0x00306d0400507b05, 0x001d070e00224804, 0x4fb3ffb9067680ff, 0x82ff002b0112ba7f, 0x3a96bd7dffb9a016,
        0x003d780500420b06, 0x509bff39b51505ff, 0xc6ff004b0105b8ab, 0xbbb26a26ff3b1c55, 0x0066aa0400740207, 0x898f20ff00617d05, 0x080eb8a57f67ff3a, 0xffbb41eb4bff006f,
        0x00867d053b25f6c7, 0x8ac2eeff0081020d, 0x01123cbe0880ff3a, 0xffb8fe7709ff008f, 0x00dc8505bc254507, 0x00ae920400bc0112, 0x13d71fff00a98204, 0xa804384d6b52ff3a,
        0xffba9d04b0ff00b7, 0x00ce040b38d32443, 0x572d7cff00c9030b, 0x0207bc23d381ff3b, 0xff3c9d410fff00d7, 0x0100000abce7fe1b, 0x00edaa0400f20112, 0x5accffb9a4d7afff,
        0xd8ff00fb010e3a84, 0x3b181723ffbbe363, 0x010d01110112030b, 0xc1f3ff3973433aff, 0xadff011b040b3b92, 0xb9b0fb20ffbd0e48, 0x016ca40401b0ae04, 0x013e9005014ca304,
        0xa1ff12ff01399904, 0x00023a1af6f0ffba, 0xffbc120ed1ff0147, 0x015e020d393e42e4, 0x0def3fff01590112, 0x01123c19cd08ffba, 0xffb969d840ff0167, 0x0190010a3e261e58,
        0x017d020d01820002, 0xe384ffb8209c72ff, 0xaaff018b020dbb95, 0x3b8b6215ffb9e489, 0x019d011101a2a604, 0x185bffbb06ba19ff, 0x3fff01aba7043cbb, 0x3b11161cffbb9c5b,
        0x01d8920501f8030b, 0x01c5010701ca0112, 0xfa80ff391b6922ff, 0xdbff01d3020db9fd, 0x3bffcfc3ff359743, 0x01e5b20401eab404, 0x7701ffba3d648dff, 0x5eff01f301113b02,
        0xbbdb2cdfffb9ee33, 0x020e070e021c8a05, 0x3f615bff0209040b, 0x0111ba1bd439ff3c, 0xffb98dfbceff0217, 0x022e040b3d065696, 0x00cc6aff0229af04, 0x011239881718ff3d,
        0xff3715648aff0237, 0x00000013bb2dfade, 0x000003e800000005, 0x0000023c00000001, 0x0094830501208705, 0x0030160e00506305, 0x001d7b0400229704, 0xe20bffb6ff10fcff,
        0x4fff002b09063a89, 0xbac3421bff3b0ec9, 0x003d011100420906, 0xb6cdffb9abbe81ff, 0xb8ff004b0005bb4b, 0x3b45eb7aff39e62d, 0x0066020700740002, 0x15b280ff00619004,
        0xa0043aa4c17cffba, 0xffbb2c6f54ff006f, 0x00869d043b173cc5, 0x16b380ff00819904, 0x01123a883b09ffbb, 0xffba1b878aff008f, 0x00dc9c043ba053a9, 0x00ae000d00bc9b04,
        0x9dbe64ff00a99a04, 0x9904bc37639bffba, 0xffb9cdae2bff00b7, 0x00ce01123c059c0d, 0xf8b100ff00c98405, 0x000d3ab491c8ffb9, 0xffbcec44b0ff00d7, 0x01000112bd61064e,
        0x00ed010700f2a804, 0x1fa4ffb9fef290ff, 0x00ff00fb8405bb24, 0x3a1ef9d6ffb9f256, 0x010d040b01128505, 0x8676ff3b7eb0cfff, 0xfaff011baa043cca, 0xbba4200fff3b825e,
        0x016c010701b0ad04, 0x013e8b05014c8c05, 0x943536ff0139a604, 0x0111bb07c9ecff3a, 0xff3aaf0cdeff0147, 0x015e0002bc0877ac, 0xf9a261ff0159ac04, 0x020dbcce8a0effb8,
        0xff3a782777ff0167, 0x0190010b3c283cf2, 0x017d010d01820207, 0xc8bcffbbe99a13ff, 0xb2ff018b0002bc56, 0x3a9ec2abffbc05ef, 0x019d890501a2aa04, 0x6db9ff3b03901bff,
        0x89ff01ab030bbaf0, 0xbbcd20faffba52a6, 0x01d8010a01f8010b, 0x01c5010701ca9005, 0x0709ffbcdae430ff, 0x95ff01d3b504bb5a, 0x3b2d9e85ffb9db65, 0x01e5b00401ea0107,
        0x07bbff3c28f594ff, 0x74ff01f302073b79, 0xba00d58cff3a9e26, 0x020e0112021c8c05, 0x834fe0ff0209b204, 0x0002ba2f577dff36, 0xff3c8be137ff0217, 0x022eae04394ad1a9,
        0x220690ff02290111, 0x020dbbe01d79ff37, 0xffb994d5ebff0237, 0x0000001339be6705, 0x000003e800000005, 0x0000023c00000001, 0x0094830501208705, 0x00306d0400507b05,
        0x001d150400224804, 0x81f4ffba15cebcff, 0xf4ff002b01123727, 0x3a76c5a8ffb968a1, 0x003d6f0500427705, 0xcda6ff395da9eeff, 0xf0ff004b010e39d9, 0xbad7b7d9ff39bae5,
        0x0066a90400740207, 0x782e33ff0061030e, 0x010eba1f70e0ff3a, 0xffbbafc765ff006f, 0x00867d0539d5454a, 0x4d8d95ff0081010e, 0x0112bb8416a2ff3c, 0xffb9abcd7cff008f,
        0x00dc9c04bc105388, 0x00ae990400bc9b04, 0xfb7bbcff00a99504, 0x0111bc20af8cffb8, 0xffba09e0a4ff00b7, 0x00ce01123c0aa73a, 0xc6f400ff00c98405, 0x030b3a90749effb9,
        0xffbca710acff00d7, 0x01000112bd2d158b, 0x00ed9e0400f2aa04, 0x9efbff3a9ba4e1ff, 0x84ff00fbae04ba81, 0x39484a62ff3ae69c, 0x010d030b01128405, 0x1ba5ff3c6e40e8ff,
        0xbaff011bb0043b88, 0xbbddf76cff3b5940, 0x016c010701b0ad04, 0x013e040b014c020d, 0x713afeff0139030b, 0x050bbb791907ff39, 0xff3bf57d90ff0147, 0x015e900539a9b224,
        0x40d87fff01598f05, 0x91053c52e873ffba, 0xffbd040774ff0167, 0x0190010b3a6358c0, 0x017d000d01820207, 0xf8ffffbbacdb34ff, 0x50ff018b0002bbee, 0x3a7e0455ffbbd64c,
        0x019da00401a20002, 0x2a11ffbc2bc3f5ff, 0xb1ff01aba404ba98, 0x3ae130ebffbb890f, 0x01d8010a01f8010b, 0x01c5010d01ca9305, 0x9878ffb91cab54ff, 0xd5ff01d30112bbad,
        0x3b79b6a8ffba688c, 0x01e5890501eab004, 0x2adcff3ac62d80ff, 0x80ff01f391053c07, 0x3b47395fff375514, 0x020e8805021c8a05, 0x663c7fff02090112, 0x0112bc274c63ffb9,
        0xffb9c6f36eff0217, 0x022e020d3bcf9760, 0x00d762ff0229b004, 0xb104b9ca03dbff3a, 0xff3bdf19a1ff0237, 0x00000013b9ad4bae, 0x000003e800000005, 0x0000023c00000001,
        0x0094830501208705, 0x0030000d00506305, 0x001d140e00224f01, 0xdfbdffb8fe1a7cff, 0xe0ff002b090bbb09, 0x38a2f957ffbab82f, 0x003d920400424301, 0x3f22ff39b7c6ceff,
        0x43ff004b0112bb37, 0x3aac59d9ffb9fe88, 0x0066020700740002, 0xffe6e4ff00619004, 0x97043a861ea6ffb9, 0xffbb723e6eff006f, 0x00869d043ab42f79, 0x652019ff00810111,
        0x0112bbbd8eddff39, 0xffb9e9ce25ff008f, 0x00dc85053b89f028, 0x00ae040b00bc020d, 0xdfaf49ff00a9030b, 0x0112bbc161f6ffb9, 0xffb9aac2bfff00b7, 0x00ce01113bf776f2,
        0x037a7bff00c9040d, 0x050b3b29c80affb7, 0xff3b8e6e06ff00d7, 0x0100020b3dd73ea4, 0x00ed000d00f20112, 0x156bff3b069c72ff, 0xf3ff00fb010d3aa1, 0xbc516a6affbb3ce0,
        0x010d00020112000d, 0xa40aff3978aa49ff, 0x76ff011b010abb0a, 0x3bfe0685ff39d679, 0x016c010701b0ad04, 0x013e040b014c020d, 0xab8ec1ff0139000a, 0x01123aa76367ffba,
        0xffb98a9a5bff0147, 0x015e90053b245ea0, 0x1a46a8ff01598f05, 0x00023c28b9f5ffba, 0xffbda58ed7ff0167, 0x0190010b3c27676f, 0x017d010d01820207, 0xedfcffbb91b2d5ff,
        0xf8ff018b000dbc13, 0x3b0a3b30ffbb6976, 0x019d8b0501a2a704, 0xeb24ff38f0d030ff, 0xcaff01ab01113c34, 0xbb968ab9ffb845f4, 0x01d8010a01f8010b, 0x01c5010d01cab404,
        0x66d2ff397bafafff, 0x90ff01d30111bc0b, 0x3c176c55ffb9f517, 0x01e5890501eab004, 0x4498ff3a9e8ac0ff, 0xfbff01f38f053bd8, 0x3b112f88ffb9e4a8, 0x020e000a021c8a05,
        0x0ab0daff02090112, 0x01123bfa91dfffba, 0xffb7418c29ff0217, 0x022e020dbbcd024f, 0xce2579ff0229b004, 0xb104b9a19cb4ff39, 0xff3bb27ae7ff0237, 0x00000013b98aa319,
        0x000003e800000005, 0x0000023c00000001, 0x0094830501208705, 0x00306d0400507b05, 0x001d060b00224804, 0x72ecffb954a059ff, 0xddff002b0002b716, 0x3b4a6b7affb85363,
        0x003d780500420b06, 0xcae1ff3985640cff, 0x34ff004b070eb764, 0x3b066b9effbb9173, 0x0066aa0400740207, 0x726b3dff00617d05, 0xae04b900d495ff3a, 0xffbb2af478ff006f,
        0x00867d053b046a4d, 0x90ba2aff00810112, 0x01123c38c8f8ffbb, 0xffb9d5e771ff008f, 0x00dc8505bbfb0fdb, 0x00ae940400bc9904, 0x9c3684ff00a9000a, 0x01123bb3dc5cffba,
        0xff3b23083dff00b7, 0x00ce0112bcc6aece, 0x54c813ff00c9a604, 0x050b3824054effba, 0xff3a71789bff00d7, 0x010000073c96cd46, 0x00ed050b00f20112, 0x2b8cff39f8c5a1ff,
        0x2eff00fb9d04b9de, 0x3c4ccf3eff390c43, 0x010d01110112a404, 0x448dff3a223b8fff, 0x06ff011b020dbba7, 0xbb36f8e1ff3aab7e, 0x016c020d01b0ae04, 0x013e9f04014ca104,
        0xce3152ff01399d04, 0x030b3bd7844dffb9, 0xffbbd467cfff0147, 0x015e070bb97fef6b, 0x11c43fff0159050b, 0x0111bbcbb97bff39, 0xff38d093bdff0167, 0x019090053b8c849a,
        0x017d8b0501828f05, 0x3576ff3a9ad47fff, 0x40ff018b030bbb23, 0x3cb68c96ff3b4d35, 0x019dad0401a20002, 0xf616ffbd847245ff, 0x91ff01ab9105bcdb, 0xbab0e840ff3cdeff,
        0x01d8920501f8030b, 0x01c5b60401ca0112, 0x78daffb98c776fff, 0xc2ff01d300023a27, 0x39b2b4efff3c025f, 0x01e5010d01eab004, 0xe544ff3b122e96ff, 0x22ff01f30112bd21,
        0xbb18d656ffb98067, 0x020eaf04021c8a05, 0x1d33d3ff02090112, 0x89053ccc3c13ff39, 0xffbaaf734dff0217, 0x022e040b3b1b3902, 0x049defff02298b05, 0x070e3b795335ffbc,
        0xffb9777867ff0237, 0x000000133ae90dc4, 0x000003e800000005, 0x0000023c00000001, 0x0094830501208705, 0x00306d0400507b05, 0x001d080b00224804, 0x1eafffb91cc663ff,
        0xb5ff002b0112b7d4, 0x3a3dce07ffb9284e, 0x003d700500427705, 0x74d6ff3927c48aff, 0x01ff004b010e39b2, 0xbab96bf7ff39952c, 0x0066aa0400740207, 0x41ef5fff00617d05,
        0x070eb8ce20d1ff3a, 0xffbb2cacdeff006f, 0x00867d053abf8db7, 0x131243ff0081010e, 0x0111bb7e4c94ff3c, 0xffb9ab1f8bff008f, 0x00dc8505bbc8d97c, 0x00ae010a00bc000d,
        0x242004ff00a90111, 0x0112bbb9dc6fffb8, 0xff3904212dff00b7, 0x00ceb1043bc009b0, 0xc6d7e3ff00c90112, 0xb2043b9e3502ff37, 0xffbd2ca15eff00d7, 0x0100000d39e1771e,
        0x00ed9e0400f2a604, 0x5e4dffb9a77e26ff, 0x23ff00fb0112bbc2, 0x3b458a9effb91d27, 0x010d020d01128605, 0xdc8bff3a03de0eff, 0x0cff011b0112bb83, 0x3bc49186ff3810ad,
        0x016c020d01b0ae04, 0x013e0002014ca104, 0x60a5a3ff01399005, 0x000dbc55c35cffba, 0xffbabe7f51ff0147, 0x015e010d3b81b690, 0x222a2bff0159010b, 0x011139ee8c02ffbb,
        0xffba57f478ff0167, 0x01909005bc1ae105, 0x017d8b0501828c05, 0x551dff3a77ba76ff, 0x00ff018b0002bc6d, 0x3bfa078cffbb223b, 0x019d011201a20002, 0xc74eff3b9d641cff,
        0xa0ff01abab04bd4b, 0x3cb26610ffba8d86, 0x01d8920501f8030b, 0x01c5020d01cab504, 0x7064ffb9135431ff, 0x9aff01d301123b3c, 0xbc13e68cff38fa55, 0x01e5930501eab404,
        0x7ebbffbacc61a5ff, 0x73ff01f301113a8d, 0xbbb2958cffb97cf2, 0x020eaf04021c040b, 0x1dec52ff02090111, 0xb4043d5aa6b8ffbc, 0xffba984b8fff0217, 0x022e01123c108121,
        0xc96295ff02290002, 0x070e3a164083ff36, 0xffbb4f7562ff0237, 0x000000133ca90b89, 0x000003e800000005, 0x0000023c00000001, 0x0094830501208705, 0x00306d0400507b05,
        0x001d070e00224804, 0x372dffb819eb7cff, 0x9dff002b2103ba31, 0xb8f4dd74ff3a68d0, 0x003d77050042180e, 0x1cdaff39d09df2ff, 0x00ff004b2405ba28, 0xbb93266affba9299,
        0x0066aa0400740207, 0x1b25f1ff00617d05, 0xae04b8a4e75cff3a, 0xffbb005bb2ff006f, 0x0086a3043ae0258a, 0x92b4c7ff00818205, 0x000abd79b6b8ffbb, 0xff3b05dc0aff008f,
        0x00dc8505bb124772, 0x00ae990400bc020d, 0x4a7086ff00a90112, 0xa604bbccb85aff3a, 0xff3ace0f92ff00b7, 0x00ce0111babd5057, 0x4bc039ff00c9040d, 0x050b3b10c275ff38,
        0xff3b7154aaff00d7, 0x010000073da2ad94, 0x00ed030e00f20112, 0x0d68ffb9c21e10ff, 0x69ff00fb010d3a29, 0x3c913688ff3a853e, 0x010d01110112a504, 0x7eeaff3a3c15dcff,
        0x9dff011b0107bb90, 0xb9813830ff3af849, 0x016c020d01b0ae04, 0x013e0002014ca104, 0xd0c529ff01399a04, 0x9e04bb29bf12ff39, 0xffb8347aebff0147, 0x015e030e3c01248c,
        0x1b8571ff0159a204, 0x0112ba04aadfff3c, 0xffb94c717aff0167, 0x019090053b104d81, 0x017da9040182aa04, 0xc188ff3a8db234ff, 0x23ff018b8e05bc6c, 0x3c913d9bff393f59,
        0x019d011101a20002, 0x05d6ff3b7bd360ff, 0x40ff01ab010bbd23, 0x3c8eb80effba6271, 0x01d8920501f8030b, 0x01c5020d01ca0112, 0x6c8dff387abd8bff, 0xa0ff01d3020dba3a,
        0x3bb29fa7ffb9b646, 0x01e5010d01eab004, 0x3d34ff3aeecbe1ff, 0x0bff01f3b204bd00, 0xb9565f58ffbade63, 0x020eaf04021c040b, 0x436b6bff02090007, 0x000a3d4030f9ffbc,
        0xff3b231ba1ff0217, 0x022e010dbb6e57e3, 0x59a3b8ff02290112, 0x0111bb407705ff39, 0xffb8f423ebff0237, 0x000000133b7073b8, 0x000003e800000005, 0x0000023c00000001,
        0x00944f0501208705, 0x00308c0400503105, 0x001d0f0400223a01, 0x870affb9f47045ff, 0xb4ff002b4a0438b7, 0xb81eeba8ff3a5443, 0x003d011200429204, 0xfeb3ffb99acf75ff,
        0x54ff004b040e3c9b, 0xb92b937affbb3003, 0x0066000200746804, 0xe9e4dbff00616104, 0x0112ba41f6e5ff38, 0xffb944fd9eff006f, 0x008601113c870be5, 0x2898ddff0081170e,
        0x00073a9d1870ffba, 0xffbb5f0362ff008f, 0x00dca5043c32a0a6, 0x00ae920400bc9404, 0xe576feff00a99004, 0x01123a85b459ffb9, 0xffba37a778ff00b7, 0x00ce7d053b4d486c,
        0x887742ff00c9070b, 0x7e053acb5467ff39, 0xffbbf287f2ff00d7, 0x01000111b96aec89, 0x00ed7b0500f27f05, 0xf972ffb930f9abff, 0x10ff00fba804bad7, 0x3a0a65b0ffba7c77,
        0x010d7d0501120002, 0x0f00ff3d501694ff, 0x68ff011b020d3bbc, 0x3cb325f7ffbbe4cd, 0x016c020d01b0ae04, 0x013e9904014ca104, 0x90ad2cff01399604, 0x9a04bc15fd51ffb9,
        0xff3bcbde6fff0147, 0x015e070bb9f428ff, 0x9a59a4ff0159030b, 0x0111bb3a971aff39, 0xff383386a6ff0167, 0x019090053b509349, 0x017d00020182a504, 0x2d90ff3b65341dff,
        0xa4ff018ba604bc01, 0xb9ca64ffff3c7eba, 0x019d910501a20002, 0xcba2ffbcca841aff, 0xc4ff01ab01113b1c, 0x3c052110ffbc7e3b, 0x01d8920501f8030b, 0x01c5000a01ca0111,
        0xa1d9ffba14fc78ff, 0xc4ff01d3b50438ee, 0xbc082ecbff3b0fde, 0x01e5b20401eab404, 0x6b77ffb9f32bb3ff, 0xb5ff01f301113aea, 0xbb8d870affb91f7b, 0x020e0112021c040b,
        0xcbe8daff02098905, 0x8905bc36ed2dffbc, 0xff3cc7cdbbff0217, 0x022e000d3a6fdd9b, 0xb0c37dff02290112, 0x8f05bb130a93ff38, 0xffb9e90429ff0237, 0x0000001339a2a04f,
        0x000003e800000005, 0x0000023300000001, 0x0094830501178705, 0x0030080600507805, 0x001d000d0022070b, 0x89cdffba054691ff, 0x6eff002b170e39c4, 0xbb20a863ff385f46,
        0x003d1d050042ac04, 0x6d8fffbb010fceff, 0xbbff004b070ebbe1, 0x3b3586ffffbaab68, 0x0066920400740111, 0x293be0ff00617e05, 0x7d053a85ddf3ff38, 0xffba824ce8ff006f,
        0x00869f04b986cc51, 0x1fc231ff0081020d, 0x00023bd88db3ffbb, 0xff3c85c83fff008f, 0x00d3850539917ab1, 0x00aea60400b3020b, 0x79c166ff00a9000d, 0x58ff3bb5d164ffbb,
        0x0400c59c043d0571, 0xba6d47afff00c09b, 0xce9f04bcaf0d29ff, 0x0dff3c19d8deff00, 0x0400f7b204b88db9, 0xff00e4a70400e9aa, 0x3f7a32ffb988e166, 0x56f1ff00f201113b,
        0x11bc0c7a44ff3a53, 0xff0104020d010901, 0x17d46cffb9dbf0c0, 0x9214ff0112010e3b, 0x0e3c498a13ffbc07, 0x040163010b01a701, 0x040135010d0143b4, 0x3a767870ff01309d,
        0x3e8c05bb06cdbaff, 0x49ffbb21a62cff01, 0x0a01550112bc1311, 0xba66331eff015000, 0x5e01073a80b83eff, 0x20ff3c738b78ff01, 0x040187a9043b9a9d, 0xff0174a6040179a7,
        0x53a571ff39ffed8a, 0x2ac0ff01820111bb, 0x053c543809ff3a30, 0xff0194b204019989, 0x8e1b31ff3b1b57f9, 0xb64eff01a20112bb, 0x04bac3d95cff393e, 0x0b01cf000201efa4,
        0xff01bc030e01c102, 0x227367ff3cc941f8, 0xf543ff01ca010a3b, 0x07bbe63351ff3a30, 0xff01dc880501e100, 0x310598ffbb20d205, 0x1220ff01ea0111b8, 0x04bbb210d2ffb8fa,
        0x050205070b0213a8, 0xbb47a342ff02008b, 0x0e8905ba003e45ff, 0xdbff3bce964bff02, 0x0402250111b8a0ea, 0xb90d9a52ff0220b6, 0x2eb40439810686ff, 0x73ff3a913d13ff02,
        0x05000000133ce071, 0x01000003e8000000, 0x050000023c000000, 0x0400945a05012087, 0x040030010e00506a, 0xff001d3904002259, 0x01d389ffb8e8d893, 0xa3a8ff002b4f013a,
        0x01b9ae472aff39a3, 0xff003d660400424f, 0x095bc7ffb6d76d5e, 0x36d6ff004b01113b, 0x04bbbad6bcffb898, 0x120066080e007479, 0xba0bcc8cff006101, 0x6f01123be49f6cff,
        0x15ffb9e10fe2ff00, 0x0e00865605bc63be, 0xb9a7a21fff008104, 0x8f01123a16fb23ff, 0x9cffba401ad8ff00, 0x0500dc0112bc5ca1, 0x0400aeae0400bc72, 0xb910174bff00a96d,
        0xb7af04ba2687b0ff, 0x9dffbb386668ff00, 0x0500ce9e043aa079, 0xb706620cff00c97d, 0xd7a70439ee4c56ff, 0x24ffba8ffa17ff00, 0x070100020d37e635, 0xff00eda10400f202,
        0x2b5fd9ffbaa3788b, 0xefcdff00fb96043c, 0x013abd4fa8ffbc4b, 0xff010d070e01124f, 0xe7efdfffbbb90d01, 0xb768ff011b040bbc, 0x0e3c9367f4ff3b72, 0x04016c010b01b001,
        0x04013e010d014cb4, 0x3a452d18ff01399d, 0x47b204bad7af7bff, 0x40ffbbcd28c1ff01, 0x04015e01123b3a5e, 0x3a633e54ff0159b7, 0x670107ba789b54ff, 0xc0ff3c42d5f8ff01,
        0x040190a9043b7761, 0xff017d010a0182a8, 0xcc9e5cffb6a85eaf, 0x4863ff018b01123b, 0x053c7bf3edff3991, 0xff019d030b01a289, 0xe9a8cfff3b82a3cf, 0x7c52ff01ab8a05ba,
        0x04380d3bbeffbbb1, 0x0401d8000201f8a4, 0xff01c59a0401ca9c, 0xc33d99ff3a57f4d2, 0x972eff01d30111bb, 0x073ba957cfffb950, 0xff01e5020d01ea00, 0xb12ee6ffb969594b,
        0x7f2cff01f3030bbb, 0x0aba954840ffbb99, 0x02020e0112021c00, 0xb9f5262eff020900, 0x17b40439aefea8ff, 0xf4ff3b24c3f4ff02, 0x11022e00023cb38d, 0x39378fe4ff022901,
        0x3701123ba75d4dff, 0xe6ffb8da143fff02, 0x0500000013bb3e6b, 0x01000003e8000000, 0x0500000233000000, 0x0500948305011787, 0x040030140e005063, 0xff001d7104002280,
        0xeaeddeffb70bb8a9, 0x32bbff002b011238, 0x123b32f4ceffba35, 0xff003d4e01004201, 0x447cbeff3a258552, 0xfdf5ff004b8e04ba, 0x02bad78174ffbc39, 0x0500660207007400,
        0xb80f4fe0ff006182, 0x6f660539f89867ff, 0xd3ff3bb96aabff00, 0x0400869d04ba3fd6, 0xbadc8a70ff008199, 0x8f01123ae92f8cff, 0xbeffb91d0184ff00, 0x0b00d385053b4ae3,
        0x0a00aea60400b302, 0xba5898efff00a900, 0x70c0ff3c2c98a4ff, 0x030b00c5050b3ccf, 0xff39b3463cff00c0, 0x00ce0111bbd5537c, 0x5d0affb91eb8d8ff, 0x000200f700073baa,
        0x34ff00e4011200e9, 0x3b695aa9ff39b433, 0xd23411ff00f2010a, 0x020d3bd76ca8ffba, 0xdbff010400020109, 0xbabd02e0ff3a14fc, 0xb9f579ff01120112, 0xae04bc5bde80ff3a,
        0xa1040163020d01a7, 0x0112013500020143, 0xff39a0e9edff0130, 0x013e9e04bb20d8a3, 0xc667ff396950ecff, 0x010b0155010d3bd5, 0xffbae658b2ff0150, 0x015e8805398c3f12,
        0xd4fcff3b67b632ff, 0x9a0401870107bb1f, 0x8eff017400110179, 0x3c3f4808ff398902, 0xe8b0e5ff0182a204, 0xad04b993f3c6ffbb, 0x18ff019401110199, 0xbbca5cd0ffbb3b4f,
        0x802b64ff01a20112, 0x030b3ddbdda8ffbb, 0x011201cf920501ef, 0xd5ff01bcb60401c1, 0x3a01577fffb98a4f, 0x15a32fff01ca020d, 0xb4043b987680ffba, 0xfcff01dc930501e1,
        0x3a7c7f4effba8775, 0x1d7b2bff01ea0112, 0x8a05bb92b912ffb9, 0x010d0205b2040213, 0xffb7e6b89cff0200, 0x020e01113be35719, 0xcc10ff398dd9eaff, 0x8b050225040bbc57,
        0xffbbcee3dcff0220, 0x022e070e3b1d3049, 0x6978ffb9130042ff, 0x0005000000133a8e, 0x0001000003e80000, 0x87050000023c0000, 0x7b05009483050120, 0x011200306a050050,
        0x3fff001d23040022, 0xb9806e8eff391467, 0x572cd8ff002b0007, 0x00023ad1c516ffba, 0xb1ff003d050e0042, 0xba66a57aff3a5827, 0xfc7d06ff004b9904, 0x02073ab186a8ffba,
        0x0111006681050074, 0xffb926f629ff0061, 0x006f010a3ad64b58, 0x91eeffb7e53f35ff, 0x7c050086040bbbc5, 0xff3b8ec472ff0081, 0x008f0112bb6f53fa, 0x6446ffba4f652bff,
        0xb10400dc85053b8d, 0xa90400aeaa0400bc, 0xffb8ae092bff00a9, 0x00b7020dbbfd8f13, 0xafedffb96df128ff, 0xb40400ce01123c29, 0xffba173722ff00c9, 0x00d7010e3a89b1d4,
        0xaa70ffbd50c9efff, 0x000a0100030b3b7a, 0x20ff00ed010700f2, 0xbb819c2dff3ab33b, 0x87e889ff00fb000d, 0x090b3b531594ffb8, 0x72ff010d010a0112, 0xbceabfb2ffbb1d54,
        0x83937eff011b0002, 0x010ebaeda2ceff3a, 0xb404016c010b01b0, 0x000a013e010d014c, 0xffbac8620dff0139, 0x01478c0539334187, 0xe368ffba5bc514ff, 0xb704015e0112bbd2,
        0xff3a38b4fbff0159, 0x01670107ba4a4240, 0xdda0ff3c2a8a78ff, 0x01120190a9043b1c, 0x80ff017da6040182, 0x3a841927ffba8d00, 0x663e5bff018b040b, 0x89053bb11e61ffb8,
        0x47ff019d880501a2, 0x3b6d5c00ffbafb6c, 0x4de20cff01ab0112, 0xa404ba9fd006ff39, 0x020b01d8000201f8, 0x30ff01c5000d01ca, 0x3ca3ecf4ff3b0d71, 0x0cc90fff01d3010a,
        0x0007bbc74f20ff3a, 0xbdff01e58c0501ea, 0xbaeb0d8cff3a45f1, 0x06224dff01f30111, 0xa804bb76ff57ff3a, 0x0112020e070b021c, 0xff38140a18ff0209, 0x02170111bb1761b6,
        0x9ce5ffb98829cfff, 0x0112022eb0043b59, 0xffb971f7e4ff0229, 0x023701113b5dcaf4, 0x3f24ff3832d737ff, 0x000500000013baf9, 0x0001000003e80000, 0x87050000023c0000,
        0x690400945a050120, 0x0112003066040050, 0x3eff001d080e0022, 0x3a00efd4ffb89023, 0x140052ff002b6504, 0x020dbc1c0424ff38, 0x04ff003d010d0042, 0xbbe4c685ffba16d5,
        0xdcf25fff004b0112, 0x6a043cbf91ecffb9, 0x3c01006601120074, 0xff389c61d8ff0061, 0x006f010eb9f5e2da, 0x2fa6ffbc5d3c5dff, 0x050b0086580538ba, 0xffb8c15033ff0081,
        0x008f01123ab9e26e, 0xcd0bffba03c1b1ff, 0xa90400dc0112bbc0, 0x070d00ae000a00bc, 0xffb7e58b18ff00a9, 0x00b79004bac0fd80, 0xc36effb967505eff, 0x7f0500cead04ba5a,
        0xff39960c76ff00c9, 0x00d7000a3aaff51d, 0x2379ffba35a10eff, 0x02070100020d398e, 0x0bff00ed8c0400f2, 0x3b656896ffbb0e83, 0x22e011ff00fb9504, 0x030e3a1767a4ffbc,
        0xecff010d050b0112, 0x3c7bf78eff3b2ad1, 0x7606b4ff011b4101, 0xae04bc9b5779ffbd, 0xa104016c020d01b0, 0x9005013e0002014c, 0xffba0e280cff0139, 0x0147000dbc203a9b,
        0x2151ffba3fd45cff, 0xa404015e010a3b2a, 0xff3a955c85ff0159, 0x0167ac04b9a48fc7, 0x4864ff3b520c86ff, 0xa9040190aa04bb39, 0xd7ff017d8d050182, 0x3bbe2f4dffb9dedd,
        0x91b303ff018b0112, 0xab04bd91c165ff3b, 0x76ff019d000201a2, 0xbac5134dff3cf00a, 0xb55b78ff01ab0002, 0x030b3bde5b43ffbb, 0xb10401d8930501f8, 0x5fff01c5020d01ca,
        0x3bd75c09ff38c5ad, 0x34fde0ff01d3b204, 0xb404399330d7ffbb, 0xe8ff01e5020d01ea, 0x3c5c517cffba1ddb, 0x2a536eff01f30111, 0x040bbbf4c0d6ffb9, 0x0112020e0002021c,
        0xffbc446665ff0209, 0x0217b4043d48ea19, 0x4263ffbadb8abeff, 0x0111022e000d3bdc, 0xff38ac7a6fff0229, 0x02378f05bb0bfb3b, 0xe789ffb994bd93ff, 0x000500000013398d,
        0x0001000003e80000, 0x87050000023c0000, 0x7204009470050120, 0x4c010030010a0050, 0x40ff001d6a040022, 0xbac52a67ffb90265, 0x188af4ff002b0002, 0x01123b063392ffb9,
        0x4aff003d14040042, 0xb97807c6ff39211d, 0xa1c376ff004b2701, 0x75043bc075feff3a, 0x1e01006601120074, 0xffbab78b7dff0061, 0x006f010eba04852c, 0x791eff3b6e905bff,
        0x130e00863001bc18, 0xff3bb13eb0ff0081, 0x008f3101bada8b5a, 0xb468ff3c16356aff, 0x940400dc010b391d, 0x011200ae500400bc, 0xffba154602ff00a9, 0x00b70112bc6e9c64,
        0xdd68ff3885dd07ff, 0x010e00ce71053b82, 0xff3d902b18ff00c9, 0x00d773053b02c983, 0x620bffbd06eb7cff, 0xae0401007e05bb8e, 0xc5ff00ed010a00f2, 0x3b5af5e6ffb9a2ab,
        0x5ddfd9ff00fb0111, 0x80053c455e4fffba, 0xccff010d01070112, 0xbb03862dff3ab372, 0x2c40bdff011ba404, 0x010eb969452cffb9, 0xb404016c010b01b0, 0x9d04013e010d014c,
        0xff39ec9dd8ff0139, 0x01470012ba8b4e30, 0x1128ff3bd934e9ff, 0x000a015e0111bb8c, 0xffba33cd32ff0159, 0x016701073a33baf7, 0xbe40ff3c20e878ff, 0x99040190a9043b0a,
        0x77ff017d94040182, 0xbc181970ff3a2b29, 0x0fddc4ff018b9a04, 0x890539010c74ff3c, 0x52ff019d010d01a2, 0x3b47e01dffbaf841, 0x904f88ff01ab8a05, 0xa40438080573ffbb,
        0x010a01d8000201f8, 0x62ff01c5900401ca, 0x3a788b17ffbb0bff, 0x0b7ac7ff01d38805, 0x020b3bf2f860ffbd, 0x49ff01e5010b01ea, 0xbc498b7bffbaa8da, 0xa58906ff01f30007,
        0x070ebb2ee032ff39, 0xa604020ea704021c, 0xff39e7b99cff0209, 0x0217000abac991cb, 0x8b03ff39df3b50ff, 0x000d022e0111b979, 0xffb9869954ff0229, 0x0237030b3ad8fc7b,
        0xbd40ffba91f6f1ff, 0x0005000000133c93, 0x0001000003e80000, 0x87050000023c0000, 0x7204009470050120, 0x660400306f040050, 0xdfff001d66050022, 0xba127ffeffb813cb,
        0xc58a25ff002b020d, 0x01123ae3a4b6ffb9, 0xf3ff003d090b0042, 0x377e5dc5ffba2668, 0x3e3807ff004b020e, 0x050bbb8371d1ff3c, 0x010a0066000d0074, 0xffbb1fdb83ff0061,
        0x006f020b3a5e45ca, 0x43c8ffba29eb95ff, 0x170e008601123ab7, 0xffba0170c9ff0081, 0x008f010d3a6052fb, 0x355dff3b9ce29bff, 0x710500dc010b3ccf, 0x000a00ae011200bc,
        0xff39cdaf8bff00a9, 0x00b7010ebb1acad1, 0xe783ff3d23ab68ff, 0x570400ce01073c66, 0xffbb71d7d5ff00c9, 0x00d7ad04b85baa10, 0xde53ffbbdab0dbff, 0xae0401007e053c3c,
        0x0cff00ed010a00f2, 0x3b2f2b23ffb98223, 0x317fdaff00fb0112, 0x80053c1de511ffba, 0x00ff010d01070112, 0xbad27048ff3a8f8f, 0x09cd27ff011ba404, 0x010eb93a9dadffb9,
        0xb404016c010b01b0, 0x000a013e8a05014c, 0xff3b173454ff0139, 0x0147000aba3f29c4, 0x8030ffbb495632ff, 0xb504015e01113a05, 0xff3aeb5984ff0159, 0x01670207b9494ae7,
        0xf755ff3bdd2167ff, 0x01110190a904ba95, 0x48ff017da6040182, 0x3a4368c7ffba8533, 0x708a51ff018b8b05, 0x8905ba473453ff3b, 0x50ff019dac0401a2, 0x3ace0f90ffbb71ea,
        0x049935ff01ab0112, 0xa404ba5ff778ff39, 0x9c0401d8000201f8, 0x0cff01c59a0401ca, 0xbb9ed0b0ff3a4288, 0xdd09abff01d30111, 0x01073b8504cdffb9, 0xa2ff01e5020b01ea,
        0xb922e83bffbb25f3, 0xe49b48ff01f39d04, 0x070ebbdf9f27ffba, 0xa604020ea704021c, 0xff39b9614dff0209, 0x0217ae04baa1417b, 0x7c9cff3a3e9b84ff, 0xb404022e0111b8b7,
        0xffb9ccbb08ff0229, 0x0237000739e566b7, 0x6529ff3c3483b7ff, 0x000500000013bbd5, 0x0001000003e80000, 0x87050000023c0000, 0x7204009470050120, 0x4b0100304f010050,
        0x24ff001d01120022, 0xb95429d8ff378fbb, 0x4ef1a3ff002b7104, 0x00023c2dc699ff3a, 0x49ff003d49050042, 0x38b2ced0ffbadba1, 0x1533feff004b0111, 0x75043c40b037ffba,
        0x3805006674040074, 0xff3a593ac3ff0061, 0x006f010ebaa71f68, 0x1f26ff3bac3dc2ff, 0x130e00863001bba4, 0xff3b8b185fff0081, 0x008f3101bab28f89, 0x96adff3bebba54ff,
        0xa20400dc010b38e6, 0x020700ae9f0400bc, 0xffb9860717ff00a9, 0x00b7010ebc302275, 0x93f3ff3cff4b21ff, 0x000a00ce010abbba, 0xffbc702a2cff00c9, 0x00d702073c404e81,
        0x29a5ffbca2d095ff, 0xae0401007e05baeb, 0xa1ff00ed770500f2, 0xb9d6bb96ff39ca4f, 0x0dffdcff00fb0111, 0x80053bfca1b5ffba, 0x5dff010d030e0112, 0xba92cb3fff3a9d06,
        0x259067ff011b9004, 0x010e371c643affba, 0xb204016c010b01b0, 0x9d04013eb004014c, 0xff3a4b85c9ff0139, 0x01478905baa0ea4b, 0xf7cbff3bbc0e4bff, 0x010d015e0207bc45,
        0xffb9694e81ff0159, 0x0167b4043b42c527, 0xf137ffbb676dfcff, 0xa8040190a904b996, 0xddff017d020b0182, 0xb941ee7fff3ba397, 0x2029b6ff018b0002, 0x89053c78f557ff3a,
        0x00ff019d020701a2, 0xbb1734adff3b1aa6, 0xd42878ff01ab0112, 0xa404ba332c69ff38, 0x9b0401d8a30401f8, 0xf8ff01c59a0401ca, 0xbbd229f3ffb818b6, 0x052d5aff01d38805,
        0x030b3a9d5b8fffbb, 0x97ff01e5011201ea, 0xbc0c29bbffb96a7a, 0x5ba8cfff01f30111, 0x070e3b6d14aeffba, 0x8b05020ea704021c, 0xffbac7af72ff0209, 0x0217000a38dbebbc,
        0xf1e6ff39a72c83ff, 0x000d022e0111b956, 0xffb94007faff0229, 0x023700073ab7d35a, 0xb751ff3c106965ff, 0x000500000013bbaa, 0x0001000003e80000, 0x87050000023c0000,
        0x320500944f050120, 0x1c0500300d060050, 0xc8ff001d060d0022, 0x3a134becffb9a5d3, 0xdf2ba3ff002b140e, 0x0005bb31a735ff39, 0x32ff003d050d0042, 0x3c2dafb5ff3b5dc0,
        0x82655bff004b0d0e, 0x000d3b40434bffbb, 0x01110066010a0074, 0xff387a6d7eff0061, 0x006f0111bafb9de0, 0x856fffb95f60e1ff, 0x7504008601113b87, 0xffb8e0ad6aff0081,
        0x008f7504ba5f63a8, 0x92f1ff3ae361e5ff, 0x940400dca5043c43, 0x900400ae920400bc, 0xffb9857c33ff00a9, 0x00b701123a78c56e, 0x1e16ffb9944a0bff, 0x070b00ce7d053b30,
        0xff393ce598ff00c9, 0x00d77e053aac81ae, 0x89cdffbbbd1ae1ff, 0x7f0501000112b9bc, 0x65ff00ed020e00f2, 0xb810ab9bffba8bf8, 0x684e30ff00fb8305, 0x0002b87587b0ff3a,
        0x30ff010da9040112, 0xbc29e1b9ff3cd01a, 0xfb853aff011b000a, 0x010ebc23d495ff3b, 0xb204016c010b01b0, 0x0002013e010d014c, 0xffbb00a630ff0139, 0x014702073999f819,
        0x71cbffbb73669fff, 0x010d015eb6043b96, 0xffb8f77f8cff0159, 0x0167000a3b9e0ed3, 0x2d9effbae23db7ff, 0x010a0190010d39ad, 0xdaff017d01120182, 0xba6f2730ff387e48,
        0x324a76ff018b0112, 0xb4043bca611fff39, 0x49ff019d011201a2, 0x3b9fe41dffba6d40, 0x8bd955ff01ab0111, 0xa404bbabf9f5ffb7, 0x010a01d8000201f8, 0x5aff01c5020b01ca,
        0x399f41d0ff3b7161, 0xded166ff01d38805, 0x000a3baba6c2ffbc, 0x07ff01e5011101ea, 0xbb21578aff3a8ce8, 0x2d34b1ff01f38905, 0x070eba526d14ff3b, 0x000a020ea704021c,
        0xff393afdbdff0209, 0x02178f05baaa5dbd, 0x3caeffb91ba522ff, 0xb404022e01113985, 0xffb99d4d06ff0229, 0x0237030b39cab953, 0x6aa5ffbb02553fff, 0x0005000000133c4a,
        0x0001000003e80000, 0x88050000023c0000, 0x7b05009486050120, 0x97040030010e0050, 0xf5ff001d8a040022, 0xbaa8bf1dff3910f0, 0xc17412ff002b010d, 0x6605baec8226ff3b,
        0x8cff003d010a0042, 0x39d6d780ffb9280c, 0xb9ceecff004b6705, 0x000dba343934ff3b, 0x01120066a7040074, 0xff393bd82aff0061, 0x006fa804bb276f02, 0xf0f1ff3ba3ce11ff,
        0x7d0500860112394a, 0xffba81e41dff0081, 0x008fa904397e27a4, 0xb653ff3b067d1fff, 0x000200dc0107bc05, 0x010a00ae011200bc, 0xffb97cbc71ff00a9, 0x00b7010a3b152b75,
        0x9d6fff3c2d403bff, 0x050b00ceb104bc47, 0xff392e13a7ff00c9, 0x00d70111bb142161, 0xe4acffba9236c3ff, 0x0002010001123cd3, 0xaaff00eda00400f2, 0xba50b588ff3b6602,
        0xb19966ff00fb8705, 0x030bb83c0d8cff3a, 0x54ff010d9f040112, 0xbab99b7dffbc422b, 0x936f21ff011baa04, 0x020bbbdb7062ffbc, 0x9304016c9b0401b0, 0x000d013e0012014c,
        0xff3a1b5693ff0139, 0x014700023b89c31b, 0xbbaeffbc0db0dcff, 0x0002015e000dbc43, 0xff3b8dbda0ff0159, 0x01679504bbdb5de8, 0xdbc8ff3bf78c30ff, 0x00020190040d3d3f,
        0x5bff017da7040182, 0xb9df912dffbbf98d, 0x4c2c83ff018b0107, 0x070dba050e52ff3a, 0xb5ff019da90401a2, 0xbb80df02ffbb5b55, 0xa1ee94ff01aba604, 0x020dbc292850ffbb,
        0x000701d89d0401f8, 0x4dff01c59c0401ca, 0x3b82c2c1ffb9f3a6, 0xcdc4f8ff01d38b05, 0x9f04bc3c0435ffba, 0xe6ff01e5011201ea, 0x3c5b7ad2ffbb72d3, 0xd201a0ff01f3000d,
        0x0002b937b659ff38, 0x0111020ea604021c, 0xffbabd2924ff0209, 0x0217a7043c56426c, 0x9c8effbc9e917fff, 0x0111022ea104b9f6, 0xff3b156680ff0229, 0x02370112bd6b24ea,
        0x4563ffba472ef9ff, 0x0005000000133ba6, 0x0001000003e80000, 0x87050000023c0000, 0x7d0500948b040120, 0x7205003088040050, 0xdeff001d6b050022, 0x39ca54feffb8317e,
        0x029b52ff002b7405, 0x010b3a1aefb5ffbb, 0xefff003d01120042, 0xbcff16b3ffb91b56, 0x626ab2ff004b0112, 0x01123bf4098affb9, 0x010e006680050074, 0xffb99f0eb5ff0061,
        0x006f00023a4e0b00, 0xa92aff3a754374ff, 0x010d00867e053af0, 0xffbbf09abdff0081, 0x008f020dbcf4eb0d, 0x8db5ffbb484289ff, 0x8c0400dc86053bd1, 0x000d00ae490100bc,
        0xffbb15740eff00a9, 0x00b701123c53c719, 0x6025ffb997c685ff, 0x5d0500ce8005bc8d, 0xffb64a92b1ff00c9, 0x00d7030b39d50cfd, 0x6732ff394e2634ff, 0x01120100000db9d7,
        0x46ff00edb50400f2, 0x3b9a52a9ff397037, 0xbc8e9bff00fbb104, 0x01123b9f6528ffbb, 0xd7ff010dae040112, 0x3aef5e02ffb9c6bc, 0x3c55fcff011b0107, 0x010ebb06edf8ff3c,
        0xb204016c010b01b0, 0x9205013eb004014c, 0xffb905323bff0139, 0x01470207bb2c5b4c, 0x5d15ffbc135a00ff, 0x0112015e01073b77, 0xff38a1150bff0159, 0x0167b4043b4ad48e,
        0x7044ffbad97ae6ff, 0x030b0190010d3989, 0x20ff017d00070182, 0xb9f72053ff3ad22b, 0xaee47aff018b040b, 0xb40438228d2cffbb, 0x35ff019d011101a2, 0x3b693538ffba1bb8,
        0xc8bf18ff01ab0111, 0xa404bba03caeff38, 0x9b0401d8a30401f8, 0x82ff01c59a0401ca, 0xbba2cb6dffb8344f, 0xcc23f8ff01d38805, 0x030b3a5ca6b3ffba, 0x93ff01e5011201ea,
        0xbbd92fc0ffb99be1, 0x469ab3ff01f30111, 0x040d3b42ba5bffba, 0x0111020e8905021c, 0xff39136569ff0209, 0x0217a704bafae250, 0x99d9ffb96991d4ff, 0xa904022e000238e3,
        0xff3bd92738ff0229, 0x0237ab043bb011fd, 0x57d3ffbb07e736ff, 0x000500000013bb96, 0x0001000003e80000, 0x87050000023c0000, 0x7d0500948b040120, 0x7905003088040050,
        0x05ff001d86040022, 0x3af38562ffb83c1f, 0x163864ff002b7a05, 0x010db9f544beff3b, 0xc0ff003d070e0042, 0x3a7faf22ffbb60df, 0xd19bd6ff004b0111, 0x01113c97da81ffb9,
        0x010e006680050074, 0xffb97e7de8ff0061, 0x006f83053a24d595, 0xee82ff3aa25f9cff, 0x7e050086000a39fb, 0xffbc512ba2ff0081, 0x008f000dbb1b7eeb, 0x539cffbb798b3bff,
        0x7d0500dc86053c43, 0x010a00ae010e00bc, 0xffba556d88ff00a9, 0x00b7030b3bac8544, 0xbc7bffb8cc3715ff, 0x7f0500ce010b3a1a, 0xffbc78e717ff00c9, 0x00d78505b9b6159f,
        0xe384ffb93058c5ff, 0x011201008f04ba13, 0x3cff00ed8e0400f2, 0xbb338a80ff3a0865, 0xedc854ff00fb000a, 0x000dbb7760d0ff3c, 0x44ff010d01120112, 0xbb9ed9adff397372,
        0xc82b04ff011b010e, 0x010e3b7be11dff38, 0x9005016c010b01b0, 0x010a013ea304014c, 0xff3ab7065eff0139, 0x01470207bb9f5f36, 0xbc43ffbb2d6a33ff, 0xa704015e010a3a0a,
        0xffbae77ca0ff0159, 0x0167000239e73770, 0x3510ffb9a72c60ff, 0xa3040190010d3ba8, 0xaeff017d00020182, 0x3b09f376ffbaca6e, 0xde7632ff018ba404, 0xaa04b9242520ff3b,
        0x19ff019da90401a2, 0xbc5b6d9dffb868b2, 0x8296dbff01abb104, 0xa404b9cb5cefff3b, 0x900401d8000201f8, 0xbeff01c5011201ca, 0xbbc20f6aff3a3e97, 0x0a2c8eff01d39504,
        0x9d0438bfce21ff3b, 0x2fff01e5020b01ea, 0x39f40438ffbaf135, 0x2a4c72ff01f3030b, 0xa60438dac0c8ffbb, 0x030e020e010a021c, 0xff3c1a0d10ff0209, 0x02170112ba6a1855,
        0xe4bdffbb4722c5ff, 0x030b022eac043c9c, 0xff3ab32e46ff0229, 0x02370112b997bf0a, 0xde42ffb8b1e47aff, 0x000500000013b923, 0x0001000003e80000, 0x87050000023c0000,
        0x320500944f050120, 0x000200300a0b0050, 0xcaff001d03050022, 0x37914249ffb9ed4b, 0x11a911ff002b0706, 0x3801bb05ae79ff3b, 0x3dff003d8d040042, 0x3b9f4e45ffb81ef4,
        0x41d49aff004b0112, 0x000d3b6b65ffffb9, 0x01120066010b0074, 0xffb8b2b3c4ff0061, 0x006f0207bb9ba168, 0xf10aff367b5ff3ff, 0x750400860111ba1a, 0xffb8b9351bff0081,
        0x008f0a0eba3d4832, 0xf8cfff3ae36fc4ff, 0x940400dca5043c80, 0x900400ae920400bc, 0xffb956513fff00a9, 0x00b7020d3a505940, 0xb0fcffb93314ddff, 0x080b00ce7d053b35,
        0xff389d1dc6ff00c9, 0x00d799043a687256, 0x2863ffbb863b45ff, 0xa8040100011138da, 0xbbff00ed000200f2, 0x3966a666ffba547c, 0xd9424bff00fbb404, 0x75053a9654c0ff38,
        0x27ff010d00020112, 0x3ba1deeaff3d7c0c, 0x06db23ff011b070e, 0xae043c77dff2ffbb, 0xa104016c020d01b0, 0x9c04013e9f04014c, 0xffb9f15b9bff0139, 0x0147a0043ad3d41d,
        0x0322ffbc001837ff, 0x9005015e9305370f, 0xff3825c892ff0159, 0x0167ac0439f0422c, 0xa93eff3a058738ff, 0xab0401900107bc8a, 0x9fff017daa040182, 0x3b557fa3ffba7a38,
        0x04a80aff018b0002, 0xad043b98b5b3ffbc, 0x70ff019dab0401a2, 0xbbc34ad5ffbb0afb, 0x94f768ff01ab0111, 0x030b3da8ebacffbb, 0x011201d8930501f8, 0x8cff01c5000a01ca,
        0x397ffe28ffb9e03d, 0x862492ff01d30002, 0xb404390df4d9ff3b, 0x2eff01e5020d01ea, 0x3c394cb7ffba0a90, 0x2cdefcff01f30112, 0x040bbbcd4967ffb9, 0x8905020e0112021c,
        0xffbcb07e3eff0209, 0x0217b004bbeeb1ea, 0x1b21ff3b918733ff, 0x0112022e000dbacd, 0xff37d1dd9eff0229, 0x02378f05bb20b18c, 0x9854ffb91bfcf9ff, 0x000000000000399f
};

const std::vector<uint64_t> &get_conv_model_xehpc_dw_data() {
    static std::vector<uint64_t> data(
            _data, _data + sizeof(_data) / sizeof(_data[0]));
    return data;
}
// clang-format on

} // namespace jit
} // namespace intel
} // namespace gpu
} // namespace impl
} // namespace dnnl
