#!/bin/bash

###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SoftwareInventoryIdentity.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SoftwareInventoryIdentity provider module";
Name = "SoftwareInventory_OpenDRIM_SoftwareInventoryIdentityModule";
Location = "cmpiSoftwareInventory_OpenDRIM_SoftwareInventoryIdentityProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SoftwareInventoryIdentity provider";
Name = "SoftwareInventory_OpenDRIM_SoftwareInventoryIdentityProvider";
ProviderModuleName = "SoftwareInventory_OpenDRIM_SoftwareInventoryIdentityModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SoftwareInventoryIdentity provider capabilities";
ProviderModuleName = "SoftwareInventory_OpenDRIM_SoftwareInventoryIdentityModule";
ProviderName = "SoftwareInventory_OpenDRIM_SoftwareInventoryIdentityProvider";
ClassName = "OpenDRIM_SoftwareInventoryIdentity";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"Antecedent", "Dependent", "UpgradeCondition", "OtherUpgradeCondition", "ElementSoftwareStatus"};
CapabilityID = "SoftwareInventory_OpenDRIM_SoftwareInventoryIdentity";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SoftwareInventoryIdentity.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SoftwareInventoryIdentity]   
   provider: SoftwareInventory_OpenDRIM_SoftwareInventoryIdentityProvider
   location: cmpiSoftwareInventory_OpenDRIM_SoftwareInventoryIdentityProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SoftwareInventoryIdentity.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SoftwareInventoryIdentity-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SoftwareInventoryIdentity.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
