/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _ALLOCATE_H_
#define _ALLOCATE_H_

#include <stdlib.h>
#include "GTLCore/Export.h"

extern "C" {

GTLCORE_EXPORT void* gtl_malloc( int _size );
GTLCORE_EXPORT void gtl_free( void* _data );

}

template<class T>
T* gtlAllocate()
{
  T* t = (T*)gtl_malloc( sizeof(T) );
  t->count = 0;
  return t;
}

template<class T>
void gtlFree( T* t)
{
  gtl_free(t);
}


#endif
