/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;

/****
 * 
 * @author Mathias Korepkat
 *
 */

/***
 * this class has some helpful methods to convert Strings to integer or double
 */
public class Convertions {
	
	
	/***
	 * converts String to a long
	 * @param value Number as String
	 * @return number as Long
	 */
	static public long getLong(String value)
	{
		value = validateAsNumber(value);
		if(value.length() == 0)
			return 0;
		long number = 0;
		int j = 1;
		value = value.trim();
		if(value.charAt(0) == '-')
		{
			value = value.substring(1);
			j=-1;
		}
		
		for(int i=0;i<value.length();i++)
		{
			number +=  ((Integer.parseInt(value.trim().substring(i, i+1)))) * Math.pow(10,(value.length()-i));
		}
		return j*(number/10);
	}
	
	/****
	 * deletes all invalid chars from text.
	 * @param text number that should be checked
	 * @return valid number as string.
	 */
	static public String validateAsNumber(String text)
	{
		String newText = "";
		String valid = "0123456789";
		if(text.trim().equals(""))
			return "";
		
		if(text.trim().subSequence(0, 1).toString().compareTo("-") == 0)
			newText = "-";
			
		for(int i=0;i<text.length();i++)
		{
			if(valid.contains(text.subSequence(i, i+1)))
				newText += text.subSequence(i, i+1);
		
		}
		return newText;
	}
	
	/***
	 * converts String to a double
	 * @param value Number as String
	 * @return number as double
	 */
	static public double getDouble(String value)
	{
		value = value.trim();
		value = validateAsDouble(value);
		int pointposition = (value.length())-value.lastIndexOf('.');
		value = value.replace(".", "");
		
		if(value.length() == 0)
			return 0.0;
		double number = 0.0;
		int j = 1;
		
		if(value.charAt(0) == '-')
		{
			value = value.substring(1);
			j=-1;
		}
		
		for(int i=0;i<value.length();i++)
		{
			if(value.substring(i, i+1).compareTo(".") != 0)
				number +=  ((Integer.parseInt(value.substring(i, i+1)))) * Math.pow(10,(value.length()-(i+pointposition)));
		}
		return j*number;
		
		
	}
	
	/****
	 * deletes all invalid chars from text.
	 * @param text number that should be checked
	 * @return valid number as string.
	 */
	static public String validateAsDouble(String text)
	{
		String newText = "";
		
		text.replace(",", ".");
		if(text.contains("."))
			text = text.subSequence(0, text.lastIndexOf('.')).toString().replace('.', ' ')+"."+text.substring(text.lastIndexOf('.')+1);
		else
			text = text+".0";
		String valid = ".-0123456789";
		for(int i=0;i<text.length();i++)
		{
			if(valid.contains(text.subSequence(i, i+1)))
				newText += text.subSequence(i, i+1);
		}
		
		return newText;
	}
	
	/***
	 * round a double value. the decimal place is set in {@link Config Config}.rounding
	 * @param value value that should be rounded
	 * @return rounded value
	 */
	static public double round(double value) {
		  value = value * Math.pow(10,Config.rounding);
		  value = Math.round(value);
		  return (double)value/ Math.pow(10,Config.rounding);
	}
}
