#include "rapidsax.hh"

namespace rapidsax {
namespace internal {

// Character class lookup table
//   bit 0: \0
//   bit 1: \t \r \r space
//   bit 2: <
//   bit 3: &
//   bit 4: '
//   bit 5: "
//   bit 6: / > ?
//   bit 7: ! =
const uint8_t lutChar[256] =
{
	// 0   1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x00,0x00,0x02,0x00,0x00, // 0
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 1
	0x02,0x80,0x20,0x00,0x00,0x00,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40, // 2
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x80,0x40,0x40, // 3
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 4
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 5
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 6
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 7
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 8
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 9
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // A
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // B
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // C
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // D
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // E
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // F
};

// Digits (dec and hex, 255 denotes end of numeric character reference)
const uint8_t lutDigits[256] =
{
	// 0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // 0
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // 1
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // 2
	   0,  1,  2,  3,  4,  5,  6,  7,  8,  9,255,255,255,255,255,255,  // 3
	 255, 10, 11, 12, 13, 14, 15,255,255,255,255,255,255,255,255,255,  // 4
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // 5
	 255, 10, 11, 12, 13, 14, 15,255,255,255,255,255,255,255,255,255,  // 6
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // 7
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // 8
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // 9
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // A
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // B
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // C
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // D
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  // E
	 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255   // F
};

} // namespace internal
} // namespace rapidsax
