# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2267 (opensc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63601);
 script_cve_id("CVE-2008-3972", "CVE-2008-2235", "CVE-2009-0368");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.6");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2009-2267 (opensc)";
 script_name(name);

 desc = "The remote host is missing an update to opensc
announced via advisory FEDORA-2009-2267.

Update Information:

Security update fixing CVE-2008-3972, CVE-2008-2235, and CVE-2009-0368.
ChangeLog:

* Fri Feb 27 2009 Tomas Mraz  - 0.11.7-1
- new upstream version - fixes CVE-2009-0368
* Thu Feb 26 2009 Fedora Release Engineering  - 0.11.6-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

References:

[ 1 ] Bug #487694 - CVE-2009-0368 opensc: insufficient access restrictions on private data
https://bugzilla.redhat.com/show_bug.cgi?id=487694
[ 2 ] Bug #457367 - CVE-2008-2235, CVE-2008-3972 opensc: incorrect initialization of Siemens CardOS M4 smart cards
https://bugzilla.redhat.com/show_bug.cgi?id=457367

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update opensc' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2267

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-2267 (opensc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mozilla-opensc-signer", rpm:"mozilla-opensc-signer~0.11.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc", rpm:"opensc~0.11.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc-devel", rpm:"opensc-devel~0.11.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc-debuginfo", rpm:"opensc-debuginfo~0.11.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
