# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2419 (knetworkmanager)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63527);
 script_cve_id("CVE-2009-0365", "CVE-2009-0578");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-2419 (knetworkmanager)";
 script_name(name);

 desc = "The remote host is missing an update to knetworkmanager
announced via advisory FEDORA-2009-2419.

ChangeLog:

* Tue Mar  3 2009 Dan Williams  - 0.7-0.8.20080926svn
- don't send blank passwords in settings (rh #486877)

References:

[ 1 ] Bug #487722 - CVE-2009-0365 NetworkManager: GetSecrets disclosure
https://bugzilla.redhat.com/show_bug.cgi?id=487722
[ 2 ] Bug #487752 - CVE-2009-0578 NetworkManager: local users can modify the connection settings
https://bugzilla.redhat.com/show_bug.cgi?id=487752

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update knetworkmanager' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2419

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2419 (knetworkmanager)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"knetworkmanager", rpm:"knetworkmanager~0.7~0.8.20080926svn.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"knetworkmanager-devel", rpm:"knetworkmanager-devel~0.7~0.8.20080926svn.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"knetworkmanager-openvpn", rpm:"knetworkmanager-openvpn~0.7~0.8.20080926svn.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"knetworkmanager-pptp", rpm:"knetworkmanager-pptp~0.7~0.8.20080926svn.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"knetworkmanager-vpnc", rpm:"knetworkmanager-vpnc~0.7~0.8.20080926svn.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"knetworkmanager-debuginfo", rpm:"knetworkmanager-debuginfo~0.7~0.8.20080926svn.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
