###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openldap2.2, openldap2.3 vulnerabilities USN-584-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840291);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "584-1");
  script_cve_id("CVE-2007-6698", "CVE-2008-0658");
  script_name( "Ubuntu Update for openldap2.2, openldap2.3 vulnerabilities USN-584-1");
  desc = "

  Vulnerability Insight:

  Jonathan Clarke discovered that the OpenLDAP slapd server did not
  properly handle modify requests when using the Berkeley DB backend
  and the NOOP control was used. An authenticated user with modify
  permissions could send a crafted modify request and cause a denial
  of service via application crash. Ubuntu 7.10 is not affected by
  this issue. (CVE-2007-6698)
  
  Ralf Haferkamp discovered that the OpenLDAP slapd server did not
  properly handle modrdn requests when using the Berkeley DB backend
  and the NOOP control was used. An authenticated user with modrdn
  permissions could send a crafted modrdn request and possibly cause a
  denial of service via application crash. (CVE-2007-6698)

  Affected Software/OS:
  openldap2.2, openldap2.3 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-March/000671.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openldap2.2, openldap2.3 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"ldap-utils", ver:"2.3.30-2ubuntu0.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libldap", ver:"2.3-0_2.3.30-2ubuntu0.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"slapd", ver:"2.3.30-2ubuntu0.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"ldap-utils", ver:"2.2.26-5ubuntu2.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libldap", ver:"2.2-7_2.2.26-5ubuntu2.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"slapd", ver:"2.2.26-5ubuntu2.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"ldap-utils", ver:"2.2.26-5ubuntu3.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libldap", ver:"2.2-7_2.2.26-5ubuntu3.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"slapd", ver:"2.2.26-5ubuntu3.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"ldap-utils", ver:"2.3.35-1ubuntu0.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libldap", ver:"2.3-0_2.3.35-1ubuntu0.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"slapd", ver:"2.3.35-1ubuntu0.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}