###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xvid_bof_vuln_jun09_win.nasl 2632 2009-06-03 15:16:31Z jun $
#
# Xvid Buffer Overflow Vulnerability (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800580);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0893", "CVE-2009-0894");
  script_bugtraq_id(35156, 35158);
  script_name("Xvid Buffer overflow Vulnerability (Win) - Jun09");
  desc = "

  Overview: This host has Xvid installed, and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  - Inadequate sanitation of user supplied data in 'decoder_iframe',
    'decoder_pframe' and 'decoder_bframe' fuctions in xvidcore/src/decoder.c
    and can be exploited by providing a crafted macroblock (aka MBlock) number
    in a video stream in a crafted movie file.
  - A boundary error in 'decoder_create' function n xvidcore/src/decoder.c
    can be exploited via vectors involving the DirectShow (aka DShow) frontend
    and improper handling of the XVID_ERR_MEMORY return code during processing
    of a crafted movie file

  Impact:
  Remote attackers may exploit this issue to cause multiple heap based buffer
  overflow, execute arbitrary code and may cause denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Xvid before 1.2.2 on Windows.

  Fix: Upgrade to Xvid 1.2.2 or later
  http://www.xvid.org/

  References:
  http://secunia.com/advisories/35274
  http://cvs.xvid.org/cvs/viewvc.cgi/xvidcore/src/decoder.c
  http://cvs.xvid.org/cvs/viewvc.cgi/xvidcore/src/decoder.c?r1=1.80&r2=1.81

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Xvid");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_xvid_detect_win.nasl");
  script_require_keys("Xvid/Win/Ver");
  exit(0);
}


include("version_func.inc");

xvidVer = get_kb_item("Xvid/Win/Ver");
if(xvidVer == NULL){
  exit(0);
}

if(version_is_less(version:xvidVer, test_version:"1.2.2")){
  security_hole(0);
}
