###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_wpp_enterprise_library_re_dos_vuln.nasl 4912 2009-09-24 14:54:24Z sep $
#
# Microsoft Windows Patterns & Practices EntLib DOS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900957);
  script_version("$Revision: 7922 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3275");
  script_name("Microsoft Windows Patterns & Practices EntLib DOS Vulnerability");
  desc = "
  Overview: This host has Microsoft Windows Patterns & Practices Enterprise
  Library installed and is prone to Denial of Service vulnerability.

  Vulnerability Insight:
  An error occurs in Blocks/Common/Src/Configuration/Manageability/Adm/
  AdmContentBuilder.cs while processing an input string composed of many '\' ie
  backslash characters followed by a double quote related to a certain regular
  expression.

  Impact:
  Successful attack could allow attackers to crash application or CPU consumption
  and to cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Windows Patterns & Practices Enterprise Library 3.1, 4.0 and 4.1

  Fix: Upgrade to Microsoft Windows Patterns & Practices Enterprise Library 5.0
  or later. For updates refer, http://www.codeplex.com/entlib

  References:
  http://www.securityfocus.com/archive/1/506453/100/0/threaded
  http://www.checkmarx.com/Upload/Documents/PDF/Checkmarx_OWASP_IL_2009_ReDoS.pdf

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Micosoft Windows Patterns & Practices EntLib");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_ms_wpp_enterprise_library_detect.nasl");
  script_require_keys("MS/WPP/EntLib/Ver");
  exit(0);
}


include("version_func.inc");

entlibVer = get_kb_item("MS/WPP/EntLib/Ver");
if(isnull(entlibVer)){
  exit(0);
}

# Grep for the version 3.1, 4.0 and 4.1
if(version_is_equal(version:entlibVer, test_version:"3.1.0.0") ||
   version_is_equal(version:entlibVer, test_version:"4.0.0.0") ||
   version_is_equal(version:entlibVer, test_version:"4.1.0.0")){
  security_warning(0);
}
