// Copyright 2009 Intel Corporation
// SPDX-License-Identifier: Apache-2.0

// Copyright (c) 2012 Leonhard Gruenschloss (leonhard@gruenschloss.org)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

// These matrices are based on the following publication:
//
// S. Joe and F. Y. Kuo: "Constructing Sobol sequences with better
// two-dimensional projections", SIAM J. Sci. Comput. 30, 2635-2654 (2008).
//
// The tabulated direction numbers are available here:
// http://web.maths.unsw.edu.au/~fkuo/sobol/new-joe-kuo-6.21201

#include "sobol.h"

namespace ospray {

const unsigned int Sobol_matrices[Sobol_numDimensions * Sobol_numBits] = {
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x8000000U,
    0x4000000U,
    0x2000000U,
    0x1000000U,
    0x800000U,
    0x400000U,
    0x200000U,
    0x100000U,
    0x80000U,
    0x40000U,
    0x20000U,
    0x10000U,
    0x8000U,
    0x4000U,
    0x2000U,
    0x1000U,
    0x800U,
    0x400U,
    0x200U,
    0x100U,
    0x80U,
    0x40U,
    0x20U,
    0x10U,
    0x8U,
    0x4U,
    0x2U,
    0x1U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x0U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0x88000000U,
    0xcc000000U,
    0xaa000000U,
    0xff000000U,
    0x80800000U,
    0xc0c00000U,
    0xa0a00000U,
    0xf0f00000U,
    0x88880000U,
    0xcccc0000U,
    0xaaaa0000U,
    0xffff0000U,
    0x80008000U,
    0xc000c000U,
    0xa000a000U,
    0xf000f000U,
    0x88008800U,
    0xcc00cc00U,
    0xaa00aa00U,
    0xff00ff00U,
    0x80808080U,
    0xc0c0c0c0U,
    0xa0a0a0a0U,
    0xf0f0f0f0U,
    0x88888888U,
    0xccccccccU,
    0xaaaaaaaaU,
    0xffffffffU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0x88000000U,
    0xcc000000U,
    0xaa000000U,
    0xff000000U,
    0x80800000U,
    0xc0c00000U,
    0xa0a00000U,
    0xf0f00000U,
    0x88880000U,
    0xcccc0000U,
    0xaaaa0000U,
    0xffff0000U,
    0x80008000U,
    0xc000c000U,
    0xa000a000U,
    0xf000f000U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0xe8000000U,
    0x5c000000U,
    0x8e000000U,
    0xc5000000U,
    0x68800000U,
    0x9cc00000U,
    0xee600000U,
    0x55900000U,
    0x80680000U,
    0xc09c0000U,
    0x60ee0000U,
    0x90550000U,
    0xe8808000U,
    0x5cc0c000U,
    0x8e606000U,
    0xc5909000U,
    0x6868e800U,
    0x9c9c5c00U,
    0xeeee8e00U,
    0x5555c500U,
    0x8000e880U,
    0xc0005cc0U,
    0x60008e60U,
    0x9000c590U,
    0xe8006868U,
    0x5c009c9cU,
    0x8e00eeeeU,
    0xc5005555U,
    0x68808000U,
    0x9cc0c000U,
    0xee606000U,
    0x55909000U,
    0x8068e800U,
    0xc09c5c00U,
    0x60ee8e00U,
    0x9055c500U,
    0xe880e880U,
    0x5cc05cc0U,
    0x8e608e60U,
    0xc590c590U,
    0x68686868U,
    0x9c9c9c9cU,
    0xeeeeeeeeU,
    0x55555555U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xf8000000U,
    0x74000000U,
    0xa2000000U,
    0x93000000U,
    0xd8800000U,
    0x25400000U,
    0x59e00000U,
    0xe6d00000U,
    0x78080000U,
    0xb40c0000U,
    0x82020000U,
    0xc3050000U,
    0x208f8000U,
    0x51474000U,
    0xfbea2000U,
    0x75d93000U,
    0xa0858800U,
    0x914e5400U,
    0xdbe79e00U,
    0x25db6d00U,
    0x58800080U,
    0xe54000c0U,
    0x79e00020U,
    0xb6d00050U,
    0x800800f8U,
    0xc00c0074U,
    0x200200a2U,
    0x50050093U,
    0xf80f80d8U,
    0x74074025U,
    0xa20a2059U,
    0x930930e6U,
    0xd88d8878U,
    0x254254b4U,
    0x59e59e82U,
    0xe6de6dc3U,
    0x780f80a0U,
    0xb4074091U,
    0x820a20dbU,
    0xc3093025U,
    0x208d8858U,
    0x514254e5U,
    0xfbe59e79U,
    0x75de6db6U,
    0xa08f8000U,
    0x91474000U,
    0xdbea2000U,
    0x25d93000U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0xf8000000U,
    0xdc000000U,
    0x7a000000U,
    0x9d000000U,
    0x5a800000U,
    0x2fc00000U,
    0xa1600000U,
    0xf0b00000U,
    0xda880000U,
    0x6fc40000U,
    0x81620000U,
    0x40bb0000U,
    0x22878000U,
    0xb3c9c000U,
    0xfb65a000U,
    0xddb2d000U,
    0x78022800U,
    0x9c0b3c00U,
    0x5a0fb600U,
    0x2d0ddb00U,
    0xa2878080U,
    0xf3c9c040U,
    0xdb65a020U,
    0x6db2d0b0U,
    0x800228f8U,
    0x400b3cdcU,
    0x200fb67aU,
    0xb00ddb9dU,
    0xf80780daU,
    0xdc09c06fU,
    0x7a05a081U,
    0x9d02d040U,
    0x5a8a2822U,
    0x2fcf3cb3U,
    0xa16db6fbU,
    0xf0b6dbddU,
    0xda8000f8U,
    0x6fc000dcU,
    0x8160007aU,
    0x40b0009dU,
    0x2288005aU,
    0xb3c4002fU,
    0xfb6200a1U,
    0xddbb00f0U,
    0x780780daU,
    0x9c09c06fU,
    0x5a05a081U,
    0x2d02d040U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0xc8000000U,
    0x24000000U,
    0x56000000U,
    0xfb000000U,
    0xe0800000U,
    0x70400000U,
    0xa8600000U,
    0x14300000U,
    0x9ec80000U,
    0xdf240000U,
    0xb6d60000U,
    0x8bbb0000U,
    0x48008000U,
    0x64004000U,
    0x36006000U,
    0xcb003000U,
    0x2880c800U,
    0x54402400U,
    0xfe605600U,
    0xef30fb00U,
    0x7e48e080U,
    0xaf647040U,
    0x1eb6a860U,
    0x9f8b1430U,
    0xd6c81ec8U,
    0xbb249f24U,
    0x80d6d6d6U,
    0x40bbbbbbU,
    0x60800000U,
    0x30400000U,
    0xc8600000U,
    0x24300000U,
    0x56c80000U,
    0xfb240000U,
    0xe0d60000U,
    0x70bb0000U,
    0xa8808000U,
    0x14404000U,
    0x9e606000U,
    0xdf303000U,
    0xb648c800U,
    0x8b642400U,
    0x48b65600U,
    0x648bfb00U,
    0x36486080U,
    0xcb643040U,
    0x28b6c860U,
    0x548b2430U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x58000000U,
    0x94000000U,
    0x3e000000U,
    0xe3000000U,
    0xbe800000U,
    0x23c00000U,
    0x1e200000U,
    0xf3100000U,
    0x46780000U,
    0x67840000U,
    0x78460000U,
    0x84670000U,
    0xc6788000U,
    0xa784c000U,
    0xd846a000U,
    0x5467d000U,
    0x9e78d800U,
    0x33845400U,
    0xe6469e00U,
    0xb7673300U,
    0x20f86680U,
    0x104477c0U,
    0xf8668020U,
    0x4477c010U,
    0x668020f8U,
    0x77c01044U,
    0x8020f866U,
    0xc0104477U,
    0xa0f86680U,
    0xd04477c0U,
    0x58668020U,
    0x9477c010U,
    0x3e8020f8U,
    0xe3c01044U,
    0xbe20f866U,
    0x23104477U,
    0x1e786680U,
    0xf38477c0U,
    0x46468020U,
    0x6767c010U,
    0x78f820f8U,
    0x84441044U,
    0xc666f866U,
    0xa7774477U,
    0xd800e680U,
    0x5400b7c0U,
    0x9e002020U,
    0x33001010U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x88000000U,
    0x24000000U,
    0x12000000U,
    0x2d000000U,
    0x76800000U,
    0x9e400000U,
    0x8200000U,
    0x64100000U,
    0xb2280000U,
    0x7d140000U,
    0xfea20000U,
    0xba490000U,
    0x1a248000U,
    0x491b4000U,
    0xc4b5a000U,
    0xe3739000U,
    0xf6800800U,
    0xde400400U,
    0xa8200a00U,
    0x34100500U,
    0x3a280880U,
    0x59140240U,
    0xeca20120U,
    0x974902d0U,
    0x6ca48768U,
    0xd75b49e4U,
    0xcc95a082U,
    0x87639641U,
    0x44a80322U,
    0xa35403d1U,
    0x568205eaU,
    0x8e590ea4U,
    0x200c8922U,
    0x100f46d1U,
    0x2817ad6bU,
    0x743a9ce7U,
    0x9a248000U,
    0x91b4000U,
    0x64b5a000U,
    0xb3739000U,
    0x7e800800U,
    0xfa400400U,
    0xba200a00U,
    0x19100500U,
    0x4ca80880U,
    0xc7540240U,
    0xe4820120U,
    0xf35902d0U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x28000000U,
    0xd4000000U,
    0x6a000000U,
    0x71000000U,
    0x38800000U,
    0x58400000U,
    0xea200000U,
    0x31100000U,
    0x98a80000U,
    0x8540000U,
    0xc22a0000U,
    0xe5250000U,
    0xf2b28000U,
    0x79484000U,
    0xfaa42000U,
    0xbd731000U,
    0x18a80800U,
    0x48540400U,
    0x622a0a00U,
    0xb5250500U,
    0xdab28280U,
    0xad484d40U,
    0x90a426a0U,
    0xcc731710U,
    0x20280b88U,
    0x10140184U,
    0x880a04a2U,
    0x84350611U,
    0x421a8b0aU,
    0xa51c4dc5U,
    0x528e2a82U,
    0x29561942U,
    0xd29a84a3U,
    0x695c4610U,
    0x72ae2b08U,
    0x39461dc6U,
    0x5ab28280U,
    0xed484d40U,
    0x30a426a0U,
    0x9c731710U,
    0x8280b88U,
    0xc4140184U,
    0xe20a04a2U,
    0xf5350611U,
    0x7a9a8b0aU,
    0xfd5c4dc5U,
    0xb8ae2a82U,
    0x18461942U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x98000000U,
    0x94000000U,
    0x8a000000U,
    0x5b000000U,
    0x33800000U,
    0xd9c00000U,
    0x72200000U,
    0x3f100000U,
    0xc1b80000U,
    0xa6ec0000U,
    0x53860000U,
    0x29f50000U,
    0xa3a8000U,
    0x1b2ac000U,
    0xd392e000U,
    0x69ff7000U,
    0xea380800U,
    0xab2c0400U,
    0x4ba60e00U,
    0xfde50b00U,
    0x60028980U,
    0xf006c940U,
    0x7834e8a0U,
    0x241a75b0U,
    0x123a8b38U,
    0xcf2ac99cU,
    0xb992e922U,
    0x82ff78f1U,
    0x41b80d9bU,
    0xe6ec072eU,
    0xb3860398U,
    0x99f50c2fU,
    0x923a8a1bU,
    0x8f2ac56eU,
    0x5992e2bbU,
    0x32ff70deU,
    0xd9b80980U,
    0x72ec0940U,
    0x398608a0U,
    0xc2f505b0U,
    0xa1ba8338U,
    0x56eacd9cU,
    0x2bb2e722U,
    0xdef73f1U,
    0x1800041bU,
    0xd4000e6eU,
    0x6a000b38U,
    0xeb00099fU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x8000000U,
    0x6c000000U,
    0x9e000000U,
    0x23000000U,
    0x57800000U,
    0xadc00000U,
    0x7fa00000U,
    0x91d00000U,
    0x49880000U,
    0xced40000U,
    0x880a0000U,
    0x2c0f0000U,
    0x3e0d8000U,
    0x3317c000U,
    0x5fb06000U,
    0xc1f8b000U,
    0xe18d8800U,
    0xb2d7c400U,
    0x1e106a00U,
    0x6328b100U,
    0xf7858880U,
    0xbdc3c2c0U,
    0x77ba63e0U,
    0xfdf7b330U,
    0xd7800df8U,
    0xedc0081cU,
    0xdfa0041aU,
    0x81d00a2dU,
    0x41880160U,
    0xa2d400f1U,
    0x160a069aU,
    0xf0f09edU,
    0x698d8200U,
    0x9ed7c500U,
    0x20106a81U,
    0x5028b7c2U,
    0xa8058160U,
    0x7c03c0f1U,
    0x961a669aU,
    0x4f27b9edU,
    0xc9880a00U,
    0x8ed40100U,
    0x280a0081U,
    0x3c0f06c2U,
    0x360d89e0U,
    0x5f17c231U,
    0xc1b0657aU,
    0xe2f8baddU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0x58000000U,
    0xac000000U,
    0x96000000U,
    0x2b000000U,
    0xd4800000U,
    0x9400000U,
    0xe2a00000U,
    0x52500000U,
    0x4e280000U,
    0xc71c0000U,
    0x629e0000U,
    0x12670000U,
    0x6e138000U,
    0xf731c000U,
    0x3a98a000U,
    0xbe449000U,
    0xf83b8800U,
    0xdc2dc400U,
    0xee06a200U,
    0xb7239300U,
    0x1aa80d80U,
    0x8e5c0ec0U,
    0xa03e0b60U,
    0x703701b0U,
    0x783b88c8U,
    0x9c2dca54U,
    0xce06a74aU,
    0x87239795U,
    0x42a801aaU,
    0x225c08e5U,
    0x363e0a03U,
    0x5b370703U,
    0xacbb8783U,
    0x956dc9c2U,
    0x2ca6ace0U,
    0xd5739872U,
    0xc800c2aU,
    0xe5400625U,
    0x54a00163U,
    0x495006b3U,
    0xc2a80f4bU,
    0x625c0396U,
    0x163e0baaU,
    0x6b370fe7U,
    0xf4bb8d80U,
    0x396dcec0U,
    0xbaa6ab60U,
    0xfe7391b0U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0xf8000000U,
    0x8c000000U,
    0xe2000000U,
    0x33000000U,
    0xf800000U,
    0x21400000U,
    0x95a00000U,
    0x5e700000U,
    0xd8080000U,
    0x1c240000U,
    0xba160000U,
    0xef370000U,
    0x15868000U,
    0x9e6fc000U,
    0x781b6000U,
    0x4c349000U,
    0x420e8800U,
    0x630bcc00U,
    0xf7ad6a00U,
    0xad739500U,
    0x77800780U,
    0x6d4004c0U,
    0xd7a00420U,
    0x3d700630U,
    0x2f880f78U,
    0xb1640ad4U,
    0xcdb6077aU,
    0x824706d7U,
    0xc20e8d78U,
    0xa30bc3d6U,
    0x57ad62fbU,
    0xfd739b14U,
    0x8f8004d8U,
    0xe1400424U,
    0x35a00620U,
    0xe700f30U,
    0x20080af8U,
    0x90240716U,
    0x581606dbU,
    0xdc370d24U,
    0x1a0683a0U,
    0xbf2fc2f0U,
    0xedbb6b5aU,
    0x12449ce7U,
    0x9a068000U,
    0x7f2fc000U,
    0x4dbb6000U,
    0x42449000U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x38000000U,
    0xc4000000U,
    0x42000000U,
    0xa3000000U,
    0xf1800000U,
    0xaa400000U,
    0xfce00000U,
    0x85100000U,
    0xe0080000U,
    0x500c0000U,
    0x58060000U,
    0x54090000U,
    0x7a038000U,
    0x670c4000U,
    0xb3842000U,
    0x94a3000U,
    0xd6f1800U,
    0x2f5aa400U,
    0x1ce7ce00U,
    0xd5145100U,
    0xb8000080U,
    0x40000c0U,
    0x22000060U,
    0x33000090U,
    0xc9800038U,
    0x6e4000c4U,
    0xbee00042U,
    0x261000a3U,
    0x118800f1U,
    0xfa4c00aaU,
    0xa4e600fcU,
    0xd1190085U,
    0x9a0b80e0U,
    0x37004050U,
    0xeb822058U,
    0x5d433054U,
    0x776c987aU,
    0x4856e467U,
    0xaf63eeb3U,
    0xdc5e6109U,
    0xb56f188dU,
    0x2b5aa4efU,
    0x3ee7ce7cU,
    0xe6145145U,
    0x71800000U,
    0x6a400000U,
    0x9ce00000U,
    0x15100000U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xa8000000U,
    0x54000000U,
    0x9a000000U,
    0x9d000000U,
    0x1e800000U,
    0x5cc00000U,
    0x7d200000U,
    0x8d100000U,
    0x24880000U,
    0x71c40000U,
    0xeba20000U,
    0x75df0000U,
    0x6ba28000U,
    0x35d14000U,
    0x4ba3a000U,
    0xc5d2d000U,
    0xe3a16800U,
    0x91db8c00U,
    0x79aef200U,
    0xcdf4100U,
    0x672a8080U,
    0x50154040U,
    0x1a01a020U,
    0xdd0dd0f0U,
    0x3e83e8a8U,
    0xaccacc54U,
    0xd52d529aU,
    0xd91d919dU,
    0xbe83e89eU,
    0xeccacc1cU,
    0xf52d525dU,
    0x291d917dU,
    0x1683e80cU,
    0xb8cacc65U,
    0x6f2d5251U,
    0xb41d9118U,
    0x803e85dU,
    0xe40acc7dU,
    0x120d528cU,
    0x390d9125U,
    0x2c8be8f1U,
    0x95cecca8U,
    0xf9af5255U,
    0x4cd29199U,
    0x4729681eU,
    0xa01f8c5cU,
    0xb20cf27dU,
    0x8900418dU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xd8000000U,
    0xc4000000U,
    0x46000000U,
    0x85000000U,
    0xa5800000U,
    0x76c00000U,
    0xada00000U,
    0x6ab00000U,
    0x2da80000U,
    0xaabc0000U,
    0xdaa0000U,
    0x7ab10000U,
    0xd5a78000U,
    0xbebd4000U,
    0x93a3e000U,
    0x3bb51000U,
    0x3629b800U,
    0x4d727c00U,
    0x9b836200U,
    0x27c4d700U,
    0xb629b880U,
    0x8d727cc0U,
    0xbb836220U,
    0xf7c4d7d0U,
    0x6e29b858U,
    0x49727c04U,
    0xfd836266U,
    0x72c4d755U,
    0xcba9b8fdU,
    0x3fb27c72U,
    0x502362cbU,
    0x1874d73fU,
    0xe601b8d0U,
    0x950e7cd8U,
    0x5d8962c6U,
    0x62c5d745U,
    0x33a63805U,
    0x2bb33c66U,
    0xce2a8255U,
    0x5970c77eU,
    0x58f8033U,
    0x66c1402bU,
    0x55a9e0ceU,
    0x7eb41059U,
    0xb3a63805U,
    0xebb33c66U,
    0xee2a8255U,
    0x8970c77eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0x38000000U,
    0x14000000U,
    0xf6000000U,
    0x67000000U,
    0x8f800000U,
    0x50400000U,
    0x8aa00000U,
    0xff00000U,
    0x12a80000U,
    0xabf40000U,
    0xfcaa0000U,
    0x28fb0000U,
    0xbd298000U,
    0xbba4000U,
    0x4e06e000U,
    0x330c3000U,
    0x59861800U,
    0xc74d3400U,
    0x3d2cb200U,
    0x4bb2cb00U,
    0x6e061880U,
    0xc30d3440U,
    0x618cb220U,
    0xd342cbf0U,
    0xcb2e18b8U,
    0x2cb93454U,
    0xe186b2d6U,
    0x9349cb97U,
    0xeb2f9837U,
    0xdcb77404U,
    0xd98a525cU,
    0x874efb98U,
    0x1d280025U,
    0xbbb400afU,
    0x560a00a0U,
    0xd70b00b0U,
    0x97818018U,
    0xb44e40e4U,
    0x44ace0ceU,
    0x7cf73073U,
    0x6b2f9879U,
    0x9cb77437U,
    0xf98a5205U,
    0x774efb5fU,
    0x25280018U,
    0xafb400e4U,
    0xa00a00ceU,
    0xb00b0073U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0x68000000U,
    0x64000000U,
    0x36000000U,
    0x6d000000U,
    0x41800000U,
    0xe0400000U,
    0xd2e00000U,
    0x9bf00000U,
    0xce80000U,
    0x52fc0000U,
    0x5b6a0000U,
    0x2fb30000U,
    0xa00c8000U,
    0x30054000U,
    0x4807e000U,
    0x940f9000U,
    0x5e01f800U,
    0x90e9400U,
    0x778a5600U,
    0x8d416b00U,
    0x9369f880U,
    0x7bb294c0U,
    0xde005620U,
    0xc9026bf0U,
    0x578d78e8U,
    0x7d4bd4a4U,
    0xfb6db616U,
    0x1fbefb9dU,
    0xe80000a9U,
    0xa4000044U,
    0x160000c4U,
    0x9d000006U,
    0x29800025U,
    0x844000d6U,
    0xe4e000bfU,
    0xf6f000d9U,
    0x4d6800edU,
    0xb2bc0082U,
    0x898a00c1U,
    0xb4430020U,
    0xace480f2U,
    0x62f9406bU,
    0x136de064U,
    0xbbbc9036U,
    0xfe0d786dU,
    0x390bd442U,
    0x3f8db6e1U,
    0x194efbd0U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x98000000U,
    0xf4000000U,
    0xae000000U,
    0xbb000000U,
    0xe7800000U,
    0x95c00000U,
    0x1c200000U,
    0xd0300000U,
    0xdba80000U,
    0x55f40000U,
    0xff820000U,
    0x21c10000U,
    0x12238000U,
    0x3b3a4000U,
    0xa42b6000U,
    0x3430f000U,
    0x4da69800U,
    0x4af3ec00U,
    0x2e043a00U,
    0xfb0a1f00U,
    0x47851880U,
    0xc5c9ac40U,
    0x842f5aa0U,
    0x243aef50U,
    0x75a38018U,
    0xeefa40b4U,
    0x180b600eU,
    0xb400f0ebU,
    0xe0e987fU,
    0xeb07ec61U,
    0x7f863ab2U,
    0x61cb1f6bU,
    0xb22698bcU,
    0x6b33ec80U,
    0x3c243a43U,
    0xc03a1fa1U,
    0xe3ad18d1U,
    0xf1fdacdaU,
    0xc98d5a55U,
    0x6ecbeffeU,
    0x5ba800a0U,
    0x15f40050U,
    0x5f820098U,
    0x71c100f4U,
    0x8a2380aeU,
    0xcf3a40bbU,
    0xa2b60e7U,
    0x8f30f095U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xb8000000U,
    0x3c000000U,
    0xce000000U,
    0x41000000U,
    0x21800000U,
    0x51c00000U,
    0x9600000U,
    0x85700000U,
    0xf2780000U,
    0x8e9c0000U,
    0x60020000U,
    0x70030000U,
    0x58038000U,
    0x8c02c000U,
    0x7602e000U,
    0x7d00f000U,
    0xef833800U,
    0x10c10400U,
    0x28e08600U,
    0xd4b14700U,
    0xfb182580U,
    0xbee15c0U,
    0x9279c9e0U,
    0xfe9d3a70U,
    0x38000008U,
    0xfc00000cU,
    0x2e00000eU,
    0xf100000bU,
    0x9980000bU,
    0x6dc00003U,
    0xc760000cU,
    0xc4700004U,
    0xd3f80002U,
    0xdf5c0005U,
    0x69620000U,
    0xf5730008U,
    0xaa7b800fU,
    0x29ec008U,
    0x1600e006U,
    0xd03f007U,
    0xb780b805U,
    0x9cc3c408U,
    0x5ee26607U,
    0xa9b1b707U,
    0x149b1d8eU,
    0x1b2f11c1U,
    0xba994fe2U,
    0x2a2c7d7dU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0x68000000U,
    0x3c000000U,
    0x8a000000U,
    0x51000000U,
    0xa9800000U,
    0xddc00000U,
    0x5ba00000U,
    0x39d00000U,
    0x95f80000U,
    0x56d40000U,
    0xa020000U,
    0x91030000U,
    0x49838000U,
    0xdc34000U,
    0x33a1a000U,
    0x5d0f000U,
    0x1ffa2800U,
    0x7d54400U,
    0xa380a600U,
    0x4cc07700U,
    0x1222ee80U,
    0x3413a740U,
    0xa65bf7e0U,
    0x5305ab50U,
    0x15f80008U,
    0x96d4000cU,
    0xea02000eU,
    0x4103000dU,
    0x21838006U,
    0x31c34003U,
    0xb9a1a008U,
    0x54d0f005U,
    0xb67a280aU,
    0xda15440dU,
    0xf820a605U,
    0x75107703U,
    0x87daee89U,
    0x62c7a745U,
    0xac59f7e0U,
    0xc206ab59U,
    0x5c7b800cU,
    0x9b17400cU,
    0xd9a3a00dU,
    0x44d3f00dU,
    0x3e79a807U,
    0x36160403U,
    0x1a210602U,
    0x18108701U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0x38000000U,
    0x8c000000U,
    0x7e000000U,
    0x71000000U,
    0xc8800000U,
    0x4c00000U,
    0x1ba00000U,
    0xbb700000U,
    0x4a980000U,
    0xc3bc0000U,
    0xa6020000U,
    0x6d010000U,
    0xee818000U,
    0x29c34000U,
    0x9520e000U,
    0x42b23000U,
    0xe7b9f800U,
    0xd0dc400U,
    0x3fb92200U,
    0x110d1300U,
    0x19bbee80U,
    0x3c0cadc0U,
    0x973a4a60U,
    0xc5cf7ef0U,
    0x3a180008U,
    0xb7c0004U,
    0xa3a20006U,
    0x7771000dU,
    0x54998003U,
    0x62bf4008U,
    0x5682e007U,
    0xe5c33007U,
    0x8b20780cU,
    0xe3b28400U,
    0x173bc201U,
    0x85ce230bU,
    0x5a1b9684U,
    0xdb7e29ccU,
    0x9ba1886aU,
    0xfb715df6U,
    0x2a9b9686U,
    0x13be29c6U,
    0x9e01886fU,
    0xe1015df9U,
    0x90839685U,
    0x58c229ccU,
    0x5da38862U,
    0x46705dfbU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0x8000000U,
    0x64000000U,
    0x6a000000U,
    0x89000000U,
    0xa5800000U,
    0xcb400000U,
    0x18200000U,
    0xad900000U,
    0xaf880000U,
    0x72f40000U,
    0x25820000U,
    0xb430000U,
    0xb8228000U,
    0x3d924000U,
    0xa7882000U,
    0x16f59000U,
    0x4f83a800U,
    0x82412400U,
    0x1da01600U,
    0xf6d16d00U,
    0xbfa84080U,
    0xbb672640U,
    0xe0091620U,
    0xf0b4efd0U,
    0x38228008U,
    0xfd92400cU,
    0x788200aU,
    0x86f59009U,
    0x4783a800U,
    0xe6412406U,
    0x77a01606U,
    0x7fd16d08U,
    0x1a28408aU,
    0x7027264cU,
    0xf8291621U,
    0x5d24efdaU,
    0x97aa8002U,
    0x8f66400bU,
    0x220a2008U,
    0x8db69009U,
    0xffa1280bU,
    0xdbd36405U,
    0xd028360cU,
    0x6924fd09U,
    0x55abe88eU,
    0xf2660244U,
    0xe5890020U,
    0xabf582d5U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x48000000U,
    0x8c000000U,
    0xd6000000U,
    0x39000000U,
    0xd5800000U,
    0x32400000U,
    0xb2a00000U,
    0x72100000U,
    0x53d80000U,
    0x82cc0000U,
    0xcb820000U,
    0x47430000U,
    0x91208000U,
    0xa9534000U,
    0x7cf92000U,
    0x4e9e3000U,
    0xfcf95800U,
    0x8e9fe400U,
    0xdcf9d600U,
    0x5e9c8900U,
    0x94f96a80U,
    0xd29fb840U,
    0x42f9b760U,
    0xeb9c9f30U,
    0x97788008U,
    0xd9df400cU,
    0x25db2002U,
    0xabcd300dU,
    0x7601d804U,
    0x2900a408U,
    0xbd82f60dU,
    0x6e41b903U,
    0x2ca0b28dU,
    0xc7131c43U,
    0x5059416bU,
    0x898e2637U,
    0xaca0b28dU,
    0x7131c44U,
    0x7059416eU,
    0x598e2639U,
    0xe4a0b285U,
    0x8b131c4eU,
    0xa6594168U,
    0x608e263aU,
    0x3120b28eU,
    0xb9531c4fU,
    0x14f94169U,
    0x129e263cU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xd8000000U,
    0xf4000000U,
    0x3e000000U,
    0x95000000U,
    0x8f800000U,
    0x3d400000U,
    0xf3200000U,
    0x2ef00000U,
    0xadc80000U,
    0xa0c0000U,
    0x8b220000U,
    0x4af30000U,
    0x6bc88000U,
    0x3b0d4000U,
    0xe2a16000U,
    0x16b0d000U,
    0x29687800U,
    0xbdbf1400U,
    0x33cb5e00U,
    0xf0c2500U,
    0xfca1b480U,
    0xd3b0afc0U,
    0x7eeb6920U,
    0x74fe4d30U,
    0xfee87808U,
    0xb4ff140cU,
    0xdeeb5e02U,
    0xe4fc2505U,
    0x6e9b48dU,
    0x10fcafcfU,
    0x38e96923U,
    0x85fd4d39U,
    0xb768f800U,
    0xb8be540fU,
    0x44483e0dU,
    0x964ff507U,
    0xe9814c87U,
    0x9c42fbcfU,
    0x62a1572bU,
    0xd6b2b83dU,
    0x969b486U,
    0xedbcafccU,
    0xebc96923U,
    0xfb0d4d36U,
    0xc2a0f80dU,
    0x46b25408U,
    0xf16a3e0aU,
    0x49bcf508U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x98000000U,
    0xa4000000U,
    0x7a000000U,
    0xd5000000U,
    0x2800000U,
    0x60400000U,
    0x51e00000U,
    0x88700000U,
    0x8c280000U,
    0x47c40000U,
    0xbe20000U,
    0xad710000U,
    0xb6aa8000U,
    0x3386c000U,
    0xb8006000U,
    0x54039000U,
    0x42036800U,
    0xc1019400U,
    0xe0826a00U,
    0x11431100U,
    0x2960af80U,
    0x3d3175c0U,
    0xdf4a3aa0U,
    0xaff49e10U,
    0xd62b6808U,
    0x62c59404U,
    0x31606a0aU,
    0xd932110bU,
    0x54a2f89U,
    0xcaf7b5caU,
    0x4caa5aa7U,
    0xa6870e1dU,
    0x1a800008U,
    0x84400002U,
    0x8be0000fU,
    0xed700003U,
    0x16a80001U,
    0x8384000eU,
    0x20020007U,
    0xf0010007U,
    0x3802800bU,
    0x1402c005U,
    0xe202600eU,
    0x7102900dU,
    0x7881e80cU,
    0xb5435408U,
    0x53600a0eU,
    0xe831810bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0x18000000U,
    0x34000000U,
    0x8a000000U,
    0x9d000000U,
    0x67800000U,
    0x82400000U,
    0x40e00000U,
    0x60f00000U,
    0x91480000U,
    0x29440000U,
    0x2d620000U,
    0xbfb30000U,
    0x162a8000U,
    0xfbf4c000U,
    0xe4ca6000U,
    0xc207d000U,
    0x2002a800U,
    0xf001b400U,
    0xb8037e00U,
    0x4021900U,
    0x92034b80U,
    0xa90327c0U,
    0xed81f320U,
    0x1f40d810U,
    0x27602808U,
    0xe2b1740cU,
    0xd1ab1e0aU,
    0x49b6c903U,
    0xbc2b6381U,
    0x96f653c3U,
    0x3b48ed28U,
    0x44451119U,
    0xf2e1cb8eU,
    0x39f3e7c4U,
    0xc4c9932eU,
    0x32040815U,
    0x98000000U,
    0xf400000dU,
    0x2a000000U,
    0xad000001U,
    0x7f800006U,
    0xb6400004U,
    0xcae00002U,
    0xfdf00003U,
    0xf6c8000dU,
    0xab040005U,
    0x6d82000dU,
    0xdf43000dU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x8000000U,
    0x4c000000U,
    0x2000000U,
    0xb5000000U,
    0x36800000U,
    0xc2c00000U,
    0x14200000U,
    0x7500000U,
    0x1bf80000U,
    0x50340000U,
    0x48a20000U,
    0xac910000U,
    0xd35b8000U,
    0xbca74000U,
    0x7bfa2000U,
    0xc0343000U,
    0xa0a18800U,
    0x30909400U,
    0xd95b7a00U,
    0x45a57b00U,
    0x4f7a7880U,
    0xb7f6f940U,
    0x82013de0U,
    0xf502dfd0U,
    0xd6820808U,
    0x12c3d404U,
    0x1c235a0eU,
    0x4b504b0dU,
    0x19f87080U,
    0xe5352d44U,
    0x7e2267e0U,
    0x6e5294dbU,
    0xc77a788bU,
    0xbbf6f948U,
    0x60013defU,
    0x9002dfddU,
    0xe8020809U,
    0x9c03d405U,
    0xa035a0aU,
    0xf9004b0cU,
    0x3480708eU,
    0x77c12d43U,
    0x22a067e6U,
    0xc59394d7U,
    0xfd9f880U,
    0x5765b94eU,
    0x53591de6U,
    0xfca7efd3U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x68000000U,
    0x4c000000U,
    0x76000000U,
    0xf7000000U,
    0x36800000U,
    0xd7400000U,
    0x87e00000U,
    0xef300000U,
    0xa3a80000U,
    0xd5440000U,
    0x23aa0000U,
    0x15470000U,
    0xc3a98000U,
    0x45464000U,
    0xaba82000U,
    0x9477000U,
    0xdda9f800U,
    0xfe44ac00U,
    0xeb292200U,
    0x2907f100U,
    0x6ccb3d80U,
    0xc6344dc0U,
    0xcf61b320U,
    0x137318d0U,
    0xeccb3d88U,
    0x6344dccU,
    0x2f61b32eU,
    0x437318d5U,
    0x84cb3d8eU,
    0x4a344dc8U,
    0x5961b329U,
    0xb47318daU,
    0xb24b3d8dU,
    0x9d744dc5U,
    0xde81b321U,
    0x5b4318d4U,
    0x11e33d87U,
    0x48304dc8U,
    0xfd2bb323U,
    0x4e0418d5U,
    0xd24abd8bU,
    0xd760dccU,
    0x56839329U,
    0x474368d5U,
    0xfe34586U,
    0xf332a1c3U,
    0xbdaab127U,
    0x6e4499d7U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0xc8000000U,
    0x74000000U,
    0x52000000U,
    0x3000000U,
    0xeb800000U,
    0x6f400000U,
    0x64600000U,
    0xdaf00000U,
    0x17980000U,
    0x297c0000U,
    0xa59a0000U,
    0xfa7d0000U,
    0xe61b8000U,
    0x713f4000U,
    0x1878a000U,
    0xdcce9000U,
    0xb661e800U,
    0x99f29c00U,
    0x9c184600U,
    0xd63e2100U,
    0x9fa5780U,
    0x548e0ac0U,
    0xa380a9e0U,
    0x5b413f30U,
    0x56625788U,
    0x49f20ac4U,
    0x341aa9e6U,
    0x323c3f39U,
    0x93f9d784U,
    0x238d4ac3U,
    0x1a0209e3U,
    0x3702af39U,
    0xd9803f8aU,
    0xfc43d6c5U,
    0x47e04fe5U,
    0xc1b18e34U,
    0x21f9e80bU,
    0xf08e9c07U,
    0x5982460fU,
    0xbc43210bU,
    0x27e1d78dU,
    0x51b14ac4U,
    0xe9f809e8U,
    0x848faf3fU,
    0xb83bf82U,
    0xbf4096ceU,
    0xcc62efe2U,
    0x3ef21e3bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0xb8000000U,
    0x4000000U,
    0x6e000000U,
    0x97000000U,
    0xf2800000U,
    0xedc00000U,
    0x13600000U,
    0x5c900000U,
    0xdb580000U,
    0x31e40000U,
    0x9da0000U,
    0xcc270000U,
    0x2b88000U,
    0x44b44000U,
    0xfe26000U,
    0xe6505000U,
    0x9ab9d800U,
    0x50b50c00U,
    0x79e29200U,
    0xa552fb00U,
    0xbe38bf80U,
    0x2e77d940U,
    0xf6000ae0U,
    0x830112d0U,
    0x84803f88U,
    0xaec3994cU,
    0x37e26aeaU,
    0x225142ddU,
    0x54b9e783U,
    0x17b6954cU,
    0x3360f8ecU,
    0x4c93b9d4U,
    0xc359580cU,
    0xe5e54c02U,
    0xdfdaf20dU,
    0x5f25ab01U,
    0x9e39e789U,
    0x3e76954dU,
    0xee00f8e7U,
    0x5703b9d0U,
    0x5281580aU,
    0x3dc14c05U,
    0xab60f20bU,
    0x5892ab0aU,
    0xb559678fU,
    0xa6e6d542U,
    0xfb5898e1U,
    0x21e4e9d1U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x68000000U,
    0xec000000U,
    0x22000000U,
    0x2b000000U,
    0x36800000U,
    0x9d400000U,
    0x6a200000U,
    0x16700000U,
    0x4de80000U,
    0x330c0000U,
    0x936a0000U,
    0x824f0000U,
    0x3b498000U,
    0x8f3fc000U,
    0x28202000U,
    0xcd707000U,
    0xf36aa800U,
    0x724fdc00U,
    0xb34bf200U,
    0x533e6900U,
    0x62207a80U,
    0xa7140c0U,
    0xe7ea6520U,
    0xc40d90f0U,
    0xefe9fa88U,
    0xd80e80ccU,
    0x45ea452eU,
    0x2f0de0f3U,
    0x396b528eU,
    0x754d5cc2U,
    0x47cbb72cU,
    0xd57c89f1U,
    0x5682a80dU,
    0x6d43dc0bU,
    0xe221f20aU,
    0xca716900U,
    0x7e9fa81U,
    0xf40e80c4U,
    0x87ea452dU,
    0x340de0fbU,
    0x67eb528cU,
    0x40d5cceU,
    0xfebb723U,
    0xe80c89f6U,
    0x2deaa806U,
    0xc30fdc0eU,
    0x1b6bf20cU,
    0x5e4e6900U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x28000000U,
    0xd4000000U,
    0x8a000000U,
    0xff000000U,
    0x84800000U,
    0x73c00000U,
    0x13200000U,
    0xc2b00000U,
    0xfb380000U,
    0x361c0000U,
    0x401a0000U,
    0xe0af0000U,
    0x11228000U,
    0x19b3c000U,
    0xfdb82000U,
    0x5edf9000U,
    0x75b88800U,
    0x7adfac00U,
    0xf7baba00U,
    0x61ddf300U,
    0xd1387e80U,
    0x391e55c0U,
    0xcc9ba860U,
    0x776cbeb0U,
    0xa000f688U,
    0xf001f9ccU,
    0x8011262U,
    0xe4014db3U,
    0xa200880aU,
    0x2b03ac01U,
    0xe80ba0aU,
    0x8cc2f30cU,
    0x97a2fe8aU,
    0xb17195caU,
    0xe8198869U,
    0xf4ac2eb3U,
    0xbb22fe8fU,
    0xd6b195c8U,
    0x51398867U,
    0xf91c2eb1U,
    0xec9afe84U,
    0x476d95c3U,
    0x88038861U,
    0x24032eb7U,
    0x82007e84U,
    0x1b0255c0U,
    0x2681a86bU,
    0x58c3beb3U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0xb8000000U,
    0x84000000U,
    0x1a000000U,
    0xaf000000U,
    0xbd800000U,
    0xdfc00000U,
    0x14e00000U,
    0x43500000U,
    0xda380000U,
    0x4e1c0000U,
    0x4cda0000U,
    0x364d0000U,
    0x29608000U,
    0xdc904000U,
    0x6ed86000U,
    0x5d4f5000U,
    0x2ee08800U,
    0xfc51ac00U,
    0x7fb81e00U,
    0x45dc8300U,
    0xfa3a4580U,
    0x5e1d6240U,
    0x54dbd360U,
    0xe24ec930U,
    0x8b62cd88U,
    0xf790ce44U,
    0xc959cd6aU,
    0x2d8f4a35U,
    0x87800803U,
    0x60c1ec0cU,
    0xb1607e0bU,
    0x4893d30fU,
    0x6cdacd80U,
    0x264cce45U,
    0x3163cd60U,
    0x8924a3eU,
    0xccd8880eU,
    0x764dac0dU,
    0x89621e0fU,
    0x8c918302U,
    0xd6dac584U,
    0xd94d2241U,
    0x34e3b363U,
    0x5351993cU,
    0xc23a4583U,
    0x9a1d624bU,
    0xeedbd36aU,
    0x1d4ec930U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0x8000000U,
    0xf4000000U,
    0xf6000000U,
    0x8b000000U,
    0xc9800000U,
    0x55400000U,
    0x67200000U,
    0xf3f00000U,
    0x34780000U,
    0x57440000U,
    0x1ada0000U,
    0xb1f50000U,
    0xa9818000U,
    0x6540c000U,
    0x8f23a000U,
    0x77f21000U,
    0xca7bf800U,
    0x2845fc00U,
    0x255afe00U,
    0x6fb67900U,
    0x7233a80U,
    0xc3f25ac0U,
    0xdc7aed60U,
    0xd34482d0U,
    0xe4d94288U,
    0xcef766c4U,
    0x9603b36eU,
    0xbb00ebd7U,
    0x21818008U,
    0xd140c00bU,
    0x9923a001U,
    0x8cf2100fU,
    0xbfbf80cU,
    0x8905fc0aU,
    0xb47afe09U,
    0x17467907U,
    0xfadb3a8fU,
    0xc1f65ac0U,
    0xa180ed67U,
    0x914182d4U,
    0x7920c281U,
    0xfcf3a6c7U,
    0x3fa1367U,
    0x7d07fbdbU,
    0x427bf80eU,
    0x9c45fc0fU,
    0x335afe0bU,
    0x94b6790eU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x68000000U,
    0xf4000000U,
    0x62000000U,
    0xdf000000U,
    0x79800000U,
    0xdd400000U,
    0x76e00000U,
    0x2cf00000U,
    0xcfb80000U,
    0x51ec0000U,
    0xc8da0000U,
    0x845d0000U,
    0x9b818000U,
    0x42434000U,
    0xef622000U,
    0x61b19000U,
    0xd1582800U,
    0x891cac00U,
    0x65626e00U,
    0xab10900U,
    0x2adbbd80U,
    0x1b5d86c0U,
    0x2014560U,
    0xf032470U,
    0xf1821588U,
    0xb9426ac4U,
    0x7ce10b6eU,
    0x7f3bd79U,
    0xd439800eU,
    0x53af400bU,
    0xc7b82008U,
    0x75ec9004U,
    0x22d9a801U,
    0x3f5fec02U,
    0xe8004e01U,
    0xb400990fU,
    0x8203958bU,
    0x4f012ac8U,
    0x11832b6bU,
    0x29422d7aU,
    0x14e1a80dU,
    0xf3f3ec05U,
    0xb63a4e0cU,
    0x8cad9907U,
    0xbe3a1582U,
    0xa8ae6ac3U,
    0x543b0b6eU,
    0x13aebd7bU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x18000000U,
    0xdc000000U,
    0x42000000U,
    0x37000000U,
    0x20800000U,
    0xf1400000U,
    0x28600000U,
    0x94900000U,
    0x87880000U,
    0xa83c0000U,
    0x556a0000U,
    0xe6ef0000U,
    0xf8038000U,
    0x4c024000U,
    0x3a01e000U,
    0xbb023000U,
    0x7a816800U,
    0x1a43ac00U,
    0x4ae18a00U,
    0x52d31900U,
    0x8f682380U,
    0xcded9740U,
    0xfa80bfa0U,
    0xda43f2b0U,
    0x2ae2cb88U,
    0x2d07b4cU,
    0x976ad5a6U,
    0x11eddbb5U,
    0xb8800009U,
    0xed400001U,
    0xa600002U,
    0xf3900006U,
    0xbf080003U,
    0x857c0002U,
    0x3f0a0006U,
    0x457f000aU,
    0x5f0b800aU,
    0x157e4005U,
    0x470be007U,
    0xc97d3007U,
    0x50ae807U,
    0xfe7dec0eU,
    0x258a6a06U,
    0xf3e2905U,
    0xdeacb88U,
    0x9bac7b45U,
    0x8a60d5a7U,
    0x3392dbbeU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0xf8000000U,
    0x34000000U,
    0x62000000U,
    0xf5000000U,
    0xa8800000U,
    0xfcc00000U,
    0x8e200000U,
    0x53f00000U,
    0xc7780000U,
    0x95740000U,
    0xb8020000U,
    0xd4e50000U,
    0xb2808000U,
    0xfdc0c000U,
    0x64a02000U,
    0xaa30f000U,
    0x19d8f800U,
    0xe443400U,
    0x935a6200U,
    0xe761f500U,
    0x657a2880U,
    0x40913cc0U,
    0xe0022e20U,
    0xd0e563f0U,
    0x8809f78U,
    0xccc09174U,
    0x56200202U,
    0x97f0e5e5U,
    0x5d788000U,
    0x5474c000U,
    0x72822000U,
    0xdd25f000U,
    0x94207800U,
    0x52f0f400U,
    0x2df84200U,
    0x6cb40500U,
    0x66a25080U,
    0x4fd5c8c0U,
    0x99d86c20U,
    0xce4466f0U,
    0xb35a4ff8U,
    0x176199b4U,
    0x9d7a4e22U,
    0x74917315U,
    0x8202b7f8U,
    0x25e5adb4U,
    0xa0002c22U,
    0x30008615U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0xf8000000U,
    0xec000000U,
    0x7e000000U,
    0x61000000U,
    0x5c800000U,
    0xe6c00000U,
    0xdda00000U,
    0x2a700000U,
    0x93380000U,
    0x13cc0000U,
    0xd3ce0000U,
    0x73790000U,
    0x83a08000U,
    0x7b70c000U,
    0x97b8a000U,
    0xe90cf000U,
    0x886ef800U,
    0xd409ec00U,
    0x3218fe00U,
    0xef7ca100U,
    0xc556fc80U,
    0x56c516c0U,
    0x4556a5a0U,
    0x96c50670U,
    0xe556cd38U,
    0x66c542ccU,
    0x1d56574eU,
    0x8ac549b9U,
    0x6356f800U,
    0xebc5ec00U,
    0x3fd6fe00U,
    0xd05a100U,
    0xe2767c80U,
    0x2775d6c0U,
    0x714e05a0U,
    0x34b9f670U,
    0xa2803538U,
    0x47c0aeccU,
    0x2120a94eU,
    0x3cb0e8b9U,
    0xb6988480U,
    0xd5bc3ac0U,
    0x3ef6fba0U,
    0x1b55770U,
    0xceec9b8U,
    0xeec9b80cU,
    0xc9b80ceeU,
    0xb80ceec9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x58000000U,
    0x2c000000U,
    0x9a000000U,
    0xf9000000U,
    0x3c800000U,
    0xb2c00000U,
    0xad200000U,
    0x3a300000U,
    0x89980000U,
    0x448c0000U,
    0x2eea0000U,
    0x6f810000U,
    0xef208000U,
    0x2f30c000U,
    0xf182000U,
    0xbf4cb000U,
    0xe74a5800U,
    0xcb712c00U,
    0x51981a00U,
    0xa88c3900U,
    0x94ea1c80U,
    0x268102c0U,
    0x8ba07520U,
    0xb1f0d630U,
    0x38383398U,
    0x7c7c0d8cU,
    0x52524a6aU,
    0x3d3df141U,
    0xd2525800U,
    0xfd3d2c00U,
    0xf2521a00U,
    0x4d3d3900U,
    0xaa529c80U,
    0x613dc2c0U,
    0x30525520U,
    0x983d6630U,
    0xcd2eb98U,
    0x2afde18cU,
    0xa1f2706aU,
    0x10cd7841U,
    0x286a1c80U,
    0x544102c0U,
    0x6807520U,
    0x3bc0d630U,
    0xe9a03398U,
    0x14f00d8cU,
    0xe6b84a6aU,
    0xabbcf141U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0xd8000000U,
    0xac000000U,
    0x8e000000U,
    0x9000000U,
    0x9e800000U,
    0xa1c00000U,
    0xcaa00000U,
    0x33700000U,
    0x95780000U,
    0x85c0000U,
    0x24b60000U,
    0x6a350000U,
    0x43788000U,
    0x6d5cc000U,
    0x14362000U,
    0x72f5b000U,
    0xcf585800U,
    0x53ec6c00U,
    0xc5eeae00U,
    0x40d9b900U,
    0xe016c680U,
    0x9045cdc0U,
    0x6880e4a0U,
    0x74c04a70U,
    0x2220f3f8U,
    0x87b0b59cU,
    0x9758b816U,
    0x3fecfc45U,
    0x6beec680U,
    0xf9d9cdc0U,
    0xa696e4a0U,
    0x9d854a70U,
    0x2c2073f8U,
    0x4eb0759cU,
    0x29d89816U,
    0x2e2c4c45U,
    0x794e1e80U,
    0x66a961c0U,
    0xbdee6aa0U,
    0x9cd94370U,
    0x9616ed78U,
    0x8545d45cU,
    0xa000d2b6U,
    0x7000bf35U,
    0xf800abf8U,
    0x1c00d99cU,
    0x56001616U,
    0xa5004545U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0xa8000000U,
    0x2c000000U,
    0xa2000000U,
    0x2d000000U,
    0xda800000U,
    0xf9400000U,
    0xec600000U,
    0x2b00000U,
    0x3d480000U,
    0x825c0000U,
    0x7d4a0000U,
    0x62610000U,
    0x8dc88000U,
    0xca1c4000U,
    0xa1aae000U,
    0x6891f000U,
    0x8c602800U,
    0xb2b06c00U,
    0x75484200U,
    0x5e5cdd00U,
    0x774a7280U,
    0x6361d540U,
    0xf548ce60U,
    0x1e5c6fb0U,
    0x974a07c8U,
    0x93618b1cU,
    0x5d48b92aU,
    0x325c0cd1U,
    0x354af280U,
    0xbe619540U,
    0x87c82e60U,
    0xcb1c9fb0U,
    0xd92aafc8U,
    0xbcd1a71cU,
    0xba801b2aU,
    0x494021d1U,
    0xa4602800U,
    0xdeb06c00U,
    0x37484200U,
    0x835cdd00U,
    0x5ca7280U,
    0xb621d540U,
    0xbb28ce60U,
    0x31ec6fb0U,
    0x708207c8U,
    0xe87d8b1cU,
    0xcc62b92aU,
    0x528d0cd1U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0xc8000000U,
    0x7c000000U,
    0x82000000U,
    0x4f000000U,
    0xbe800000U,
    0xedc00000U,
    0x21600000U,
    0xab700000U,
    0x78680000U,
    0x746c0000U,
    0x1e9a0000U,
    0xfdcb0000U,
    0x39088000U,
    0x2f1cc000U,
    0x4ef2e000U,
    0xc5a73000U,
    0x6d924800U,
    0xe1d7bc00U,
    0x4b7ae200U,
    0x487bbf00U,
    0xbc801680U,
    0x62c061c0U,
    0x7fe08b60U,
    0x76b0a870U,
    0x91088ce8U,
    0xa31caaacU,
    0xe4f2037aU,
    0xc6a7f47bU,
    0x99125e80U,
    0x3f17ddc0U,
    0x569a6960U,
    0x41cb1770U,
    0x5b089a68U,
    0x501ccb6cU,
    0x3872881aU,
    0x54675c0bU,
    0xcef2d268U,
    0x5a7776cU,
    0x8d926a1aU,
    0xd1d7e30bU,
    0x837a44e8U,
    0x347bd6acU,
    0x3e80017aU,
    0x2dc07b7bU,
    0xc1608000U,
    0x9b70c000U,
    0xb068e000U,
    0x86c3000U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x98000000U,
    0x2c000000U,
    0x6000000U,
    0xcd000000U,
    0x8a800000U,
    0x1bc00000U,
    0xffa00000U,
    0xad500000U,
    0x7af80000U,
    0xb3dc0000U,
    0x5b2e0000U,
    0x1f290000U,
    0x9d588000U,
    0xf28cc000U,
    0x7d62000U,
    0x71f51000U,
    0xd4f61800U,
    0xda65ec00U,
    0x632ea600U,
    0xe3291d00U,
    0x2358b280U,
    0x38ce7c0U,
    0x135641a0U,
    0x8b355c50U,
    0xa7d6ee78U,
    0xa1f5891cU,
    0x6cf6880eU,
    0xe665b4b9U,
    0xfd2eaa80U,
    0x2290bc0U,
    0xafd8e7a0U,
    0xd54c4150U,
    0x66765cf8U,
    0x3da56edcU,
    0x228ec9aeU,
    0xbf79e8e9U,
    0x4d20c4f8U,
    0x4a9042dcU,
    0x3b584faeU,
    0xef8ce5e9U,
    0x3556ee78U,
    0x5635891cU,
    0xb556880eU,
    0x9635b4b9U,
    0x9556aa80U,
    0x86350bc0U,
    0xd56e7a0U,
    0xaa354150U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x98000000U,
    0x54000000U,
    0x3a000000U,
    0x9d000000U,
    0x7e800000U,
    0x7f400000U,
    0x17200000U,
    0xab500000U,
    0x6df80000U,
    0x96a40000U,
    0x83d20000U,
    0x71e10000U,
    0xc0d88000U,
    0xe0f44000U,
    0x30aaa000U,
    0x8059000U,
    0xcc2a1800U,
    0x6e451400U,
    0xa78a1a00U,
    0xe3554d00U,
    0x1d2c680U,
    0x68e1fb40U,
    0xbc589520U,
    0xc6b4b250U,
    0xfb0a1178U,
    0x1515b0e4U,
    0xf272c872U,
    0xb1f12cf1U,
    0x2000de80U,
    0xd000ef40U,
    0x38008f20U,
    0xc400ff50U,
    0xa20057f8U,
    0xc9000ba4U,
    0x4480fd52U,
    0xe2400ea1U,
    0x69a0d7f8U,
    0xd4104ba4U,
    0x7ad85d52U,
    0x3df49ea1U,
    0xee2a4ff8U,
    0xe7451fa4U,
    0x430ae752U,
    0x911543a1U,
    0xf0721178U,
    0xe8f1b0e4U,
    0xfc80c872U,
    0x66402cf1U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x8000000U,
    0x84000000U,
    0xb2000000U,
    0xb9000000U,
    0xbe800000U,
    0x4fc00000U,
    0x55600000U,
    0xf8f00000U,
    0xac280000U,
    0x66d40000U,
    0xb30a0000U,
    0x8bb50000U,
    0xc7c88000U,
    0x11e4c000U,
    0xaa42e000U,
    0xa591b000U,
    0xd0ea8800U,
    0x78854400U,
    0x6c80d200U,
    0x86c0c900U,
    0x3e05680U,
    0x83307bc0U,
    0x4348ef60U,
    0xa324c5f0U,
    0x13a2a0a8U,
    0x1ba19014U,
    0x9f22d8eaU,
    0x2d61fc85U,
    0x94c25e80U,
    0x2a51ffc0U,
    0x658add60U,
    0x3075bcf0U,
    0xc8a87e28U,
    0x6414afd4U,
    0x2eae58aU,
    0xb185f075U,
    0x3a00a8a8U,
    0xfd001414U,
    0xec80eaeaU,
    0x46c08585U,
    0xe3e08000U,
    0x3330c000U,
    0x4b48e000U,
    0x2724b000U,
    0xa1a20800U,
    0xa2a18400U,
    0x21a23200U,
    0x62a17900U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x78000000U,
    0x24000000U,
    0x9e000000U,
    0x47000000U,
    0x67800000U,
    0xf7400000U,
    0xdf200000U,
    0xb3100000U,
    0x71680000U,
    0x8c4c0000U,
    0x32520000U,
    0xe5d50000U,
    0xaa528000U,
    0x31d5c000U,
    0x2c52e000U,
    0x62d5f000U,
    0xadd29800U,
    0xf695d400U,
    0x8b720600U,
    0xf5c59300U,
    0x42ba6180U,
    0x3dd96440U,
    0xdea0bea0U,
    0xe750d750U,
    0x37c84fc8U,
    0xbf1c9b1cU,
    0x839a1d9aU,
    0x9c94ec9U,
    0xa8484fc8U,
    0xac5c9b1cU,
    0xa2ba1d9aU,
    0xcdd94ec9U,
    0xc6a04fc8U,
    0xf3509b1cU,
    0xd1c81d9aU,
    0xdc1c4ec9U,
    0x7a1acfc8U,
    0xb9895b1cU,
    0x10e8fd9aU,
    0xe80cbec9U,
    0xcf2d7c8U,
    0xf2854f1cU,
    0x859a1b9aU,
    0x9ac9ddc9U,
    0x49c8ae48U,
    0x81c3f5cU,
    0xfc1a433aU,
    0xea896999U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x78000000U,
    0x9c000000U,
    0xee000000U,
    0x1b000000U,
    0xcb800000U,
    0xc3400000U,
    0xc7a00000U,
    0x5100000U,
    0x88680000U,
    0xc4740000U,
    0x225a0000U,
    0x3da10000U,
    0x345a8000U,
    0x7aa1c000U,
    0xf1da6000U,
    0x12e17000U,
    0x85fa1800U,
    0x48b1ec00U,
    0x2432f600U,
    0x92d5f700U,
    0x45803d80U,
    0xa8403440U,
    0x94207a20U,
    0xea50f150U,
    0xd9c81248U,
    0x46648524U,
    0x8fb24812U,
    0x21952485U,
    0x1a201248U,
    0x81508524U,
    0x8a484812U,
    0xa9242485U,
    0xde129248U,
    0xa3854524U,
    0xb7c82812U,
    0x9d645485U,
    0xa4320a48U,
    0x52d56924U,
    0xa580be12U,
    0x1840d385U,
    0xec202fc8U,
    0x7650b164U,
    0x37c83232U,
    0x5d64d5d5U,
    0x44328000U,
    0xe2d5c000U,
    0xdd806000U,
    0x84407000U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x58000000U,
    0x7c000000U,
    0xc2000000U,
    0xe1000000U,
    0xd800000U,
    0xd7c00000U,
    0x2aa00000U,
    0xf5300000U,
    0x9ba80000U,
    0xc0f40000U,
    0x20c60000U,
    0x702f0000U,
    0x48668000U,
    0x241f4000U,
    0xbe4ee000U,
    0x232b5000U,
    0xec28b800U,
    0xda342c00U,
    0xfde6fa00U,
    0xdfdf8d00U,
    0x6eee1780U,
    0x5b1b0ac0U,
    0xe0000520U,
    0x500093f0U,
    0x38008488U,
    0x6c008e04U,
    0x9a000bceU,
    0x9d00d8ebU,
    0xcf803c88U,
    0x36c0a204U,
    0x2720f1ceU,
    0x22f055ebU,
    0xb108ab08U,
    0x35c4e8c4U,
    0xbb6e14eeU,
    0xb0db961bU,
    0x68a09780U,
    0x54304ac0U,
    0xf628e520U,
    0x734c3f0U,
    0x5266bc88U,
    0xf91fe204U,
    0x11ce11ceU,
    0x5eb05ebU,
    0x93081308U,
    0x84c4c4c4U,
    0x8eeeeeeeU,
    0xb1b1b1bU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0xb8000000U,
    0xac000000U,
    0x72000000U,
    0xb1000000U,
    0x3800000U,
    0xd2c00000U,
    0xc1600000U,
    0x9b900000U,
    0x4e480000U,
    0xb740000U,
    0x864e0000U,
    0x3f0b0000U,
    0x68068000U,
    0x447f4000U,
    0x7648a000U,
    0xe7747000U,
    0xd44e9800U,
    0xbe0b9c00U,
    0xd3864a00U,
    0x3abf5d00U,
    0xc528d180U,
    0xcde413c0U,
    0x99865ae0U,
    0x67bfd550U,
    0x94a8c528U,
    0x9e24cde4U,
    0xe3669986U,
    0x82ef67bfU,
    0x698014a8U,
    0xbfc0de24U,
    0x28e0c366U,
    0x6450b2efU,
    0x46a8d180U,
    0x5f2413c0U,
    0x78e65ae0U,
    0xcc2fd550U,
    0x62e0c528U,
    0x3950cde4U,
    0x17289986U,
    0xce467bfU,
    0x20694a8U,
    0x297f9e24U,
    0x9fc86366U,
    0x18b4c2efU,
    0xdcae4980U,
    0xea5b8fc0U,
    0x2d2e10e0U,
    0xc99b8850U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x88000000U,
    0x44000000U,
    0x4a000000U,
    0x47000000U,
    0xdd800000U,
    0x42400000U,
    0xc3200000U,
    0x77100000U,
    0x75b80000U,
    0x966c0000U,
    0x715e0000U,
    0xfc950000U,
    0xa6e68000U,
    0xd9f9c000U,
    0x28386000U,
    0x142cb000U,
    0x527e6800U,
    0xfb853400U,
    0x5b5e4200U,
    0xb95c300U,
    0x1366f780U,
    0xafb9b540U,
    0x2918f6a0U,
    0x603cc150U,
    0xb0469498U,
    0x68a9927cU,
    0x34a09b66U,
    0xc250ebb9U,
    0x3186318U,
    0x973c273cU,
    0x5c66dc6U,
    0x1ee92ae9U,
    0x35807780U,
    0xb6407540U,
    0xe12096a0U,
    0x4107150U,
    0x6a38fc98U,
    0xd72ca67cU,
    0x25fed966U,
    0x8ec528b9U,
    0xcdfe9498U,
    0x7ac5927cU,
    0xeffe9b66U,
    0x9c5ebb9U,
    0xf07ee318U,
    0x4885e73cU,
    0xa4de0dc6U,
    0x3ad59ae9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xd8000000U,
    0xfc000000U,
    0xf6000000U,
    0xd5000000U,
    0xbf800000U,
    0x2c400000U,
    0xeee00000U,
    0x9700000U,
    0x19080000U,
    0x21640000U,
    0xad6a0000U,
    0xd3130000U,
    0x22828000U,
    0x9707c000U,
    0x98e0a000U,
    0x1c709000U,
    0x8688f800U,
    0x5d24ac00U,
    0x9b8a2e00U,
    0x26632900U,
    0xcd8ac980U,
    0x63633940U,
    0x8a0af160U,
    0xe323b530U,
    0x4aea8fe8U,
    0xc3534414U,
    0x1a623a62U,
    0x1b774b77U,
    0xe668be68U,
    0xed54d154U,
    0x3302e502U,
    0x5247d747U,
    0x1f80f800U,
    0xbc40ac00U,
    0x16e02e00U,
    0xa5702900U,
    0x37084980U,
    0x864f940U,
    0xe4ea5160U,
    0x2a532530U,
    0x73e277e8U,
    0xb237e814U,
    0x6f081462U,
    0x34646277U,
    0x32ea77e8U,
    0xaf53e814U,
    0x14621462U,
    0x62776277U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x58000000U,
    0xac000000U,
    0x6a000000U,
    0x85000000U,
    0xfb800000U,
    0xa8c00000U,
    0x84200000U,
    0xae300000U,
    0x4b080000U,
    0xe0740000U,
    0x10860000U,
    0x388f0000U,
    0xfc2e8000U,
    0x320b4000U,
    0x2980e000U,
    0x91c01000U,
    0x2da03800U,
    0x7ff0fc00U,
    0x6a83200U,
    0xcf842900U,
    0x4e2e9180U,
    0x5b0b2dc0U,
    0xd800ffa0U,
    0xec0046f0U,
    0xa00af28U,
    0xd5001e44U,
    0xa380038eU,
    0x4c074fbU,
    0xee2086a8U,
    0x2b308f84U,
    0xb0882e2eU,
    0x48b40b0bU,
    0x94a68000U,
    0x96bf4000U,
    0xb726e000U,
    0xd27f1000U,
    0x3906b800U,
    0xa94fbc00U,
    0xd18ed200U,
    0x4dfb3900U,
    0x2f282980U,
    0x5e4491c0U,
    0x638e2da0U,
    0x24fb7ff0U,
    0xdea886a8U,
    0x23848f84U,
    0x442e2e2eU,
    0x8e0b0b0bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0xe8000000U,
    0x44000000U,
    0x5e000000U,
    0xad000000U,
    0xef800000U,
    0x68400000U,
    0x84600000U,
    0xfe500000U,
    0xfd280000U,
    0x7f40000U,
    0x2c620000U,
    0xda4f0000U,
    0x53068000U,
    0x12dfc000U,
    0x6f802000U,
    0xa8403000U,
    0x24602800U,
    0xae501400U,
    0x15283a00U,
    0x43f41100U,
    0x72621780U,
    0x774f2b40U,
    0xbc86bbe0U,
    0x7a9fda10U,
    0xebe00118U,
    0x56100f94U,
    0xd948174aU,
    0xa9a415fdU,
    0x394a3118U,
    0x99bb2793U,
    0x21648341U,
    0x6590eff7U,
    0xd3068000U,
    0xd2dfc000U,
    0xcf802000U,
    0xf8403000U,
    0xcc602800U,
    0xea501400U,
    0x4b283a00U,
    0xeef41100U,
    0x9de21780U,
    0x1f0f2b40U,
    0x38e6bbe0U,
    0x84cfda10U,
    0x16c80118U,
    0x51e40f94U,
    0xf52a174aU,
    0x73eb15fdU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x18000000U,
    0x4000000U,
    0xda000000U,
    0x9000000U,
    0x22800000U,
    0xe8400000U,
    0xbc600000U,
    0xe300000U,
    0x7b580000U,
    0x378c0000U,
    0x14c20000U,
    0x874d0000U,
    0x99d48000U,
    0xbfb94000U,
    0x18802000U,
    0x91403000U,
    0xe6e01800U,
    0x52702c00U,
    0x5380600U,
    0x34bc0100U,
    0x971a3680U,
    0x51810240U,
    0x13f688a0U,
    0xde847a10U,
    0x466c8f18U,
    0x1745738cU,
    0x91fa26d6U,
    0x73f111e3U,
    0x6ece9b30U,
    0x5e384cd3U,
    0x1376b6f5U,
    0x4bc45caeU,
    0x7a8c8000U,
    0x4c354000U,
    0xb6422000U,
    0xaf0d3000U,
    0x45b49800U,
    0x1896c00U,
    0x7bd82600U,
    0xa2cc3100U,
    0x28222e80U,
    0xdc3d2e40U,
    0xbe6c8ea0U,
    0x63457b10U,
    0x33fa3998U,
    0xcef131ccU,
    0x8e4e8e76U,
    0xbb785bf3U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x88000000U,
    0x9c000000U,
    0x2e000000U,
    0x5000000U,
    0xab800000U,
    0x1c400000U,
    0x6e200000U,
    0x25100000U,
    0xfba80000U,
    0x94040000U,
    0xf26e0000U,
    0xb070000U,
    0xfeaa8000U,
    0x3fd1c000U,
    0xee202000U,
    0x65101000U,
    0xdba80800U,
    0xc4041400U,
    0x7a6e2200U,
    0x97072700U,
    0xd0aa8b80U,
    0x3ad1c140U,
    0x45a00ae0U,
    0x79501710U,
    0xb5881388U,
    0xe1141d44U,
    0x81c61ceaU,
    0x3030201U,
    0x22c4b71bU,
    0x31d6c381U,
    0xbb0ab54aU,
    0x4681d8e4U,
    0x5ba80800U,
    0x84041400U,
    0x5a6e2200U,
    0xc7072700U,
    0x58aa8b80U,
    0xa6d1c140U,
    0x6ba00ae0U,
    0x7c501710U,
    0x1e081388U,
    0xfd541d44U,
    0xefe61ceaU,
    0x26130201U,
    0xd96cb71bU,
    0xa5d2c381U,
    0x4964b54aU,
    0x4d86d8e4U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xc8000000U,
    0x3c000000U,
    0x3e000000U,
    0x67000000U,
    0xf9800000U,
    0xcc400000U,
    0x66600000U,
    0xb3100000U,
    0xaba80000U,
    0x5d240000U,
    0xc4fe0000U,
    0xb8cf0000U,
    0x66bb8000U,
    0x71a8c000U,
    0x10602000U,
    0x28103000U,
    0x4c280800U,
    0xa6641400U,
    0x931e3200U,
    0xfb9f0f00U,
    0x95738f80U,
    0xf89cd9c0U,
    0x86b61e60U,
    0x1bb0310U,
    0x880d9198U,
    0xdc13f8c4U,
    0x4e6db8eaU,
    0xff03e849U,
    0xdc596bfU,
    0xce27d3f3U,
    0x3f3bbdceU,
    0x2de8c47aU,
    0x9e000800U,
    0xf7001400U,
    0x11803200U,
    0xa0400f00U,
    0x90600f80U,
    0xe81019c0U,
    0x6c283e60U,
    0xf6643310U,
    0x5b1e1998U,
    0xc79f2cc4U,
    0xab73aaeaU,
    0x9f9cd749U,
    0x7f36113fU,
    0xcdfb1e33U,
    0xee6d91aeU,
    0x6f03c86aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x58000000U,
    0x44000000U,
    0x7e000000U,
    0x69000000U,
    0x5b800000U,
    0xdc400000U,
    0x5a200000U,
    0x87100000U,
    0xdad80000U,
    0x9bec0000U,
    0xbc420000U,
    0xca0f0000U,
    0x6f7c8000U,
    0xc6d9c000U,
    0xa1a02000U,
    0xab501000U,
    0xf8f80800U,
    0xe8fc2c00U,
    0x409a1600U,
    0x7ce31100U,
    0xf6be9f80U,
    0xb996da40U,
    0xcf7cb6e0U,
    0x36d9e710U,
    0xd9a03e88U,
    0x5f501dc4U,
    0xdef828b6U,
    0xc5fc1bfbU,
    0x651a2690U,
    0xc9a339c3U,
    0xf71e92bfU,
    0xe2c6dce6U,
    0x4f848800U,
    0x2a25ec00U,
    0xbf3a3600U,
    0xeb30100U,
    0xdc69780U,
    0xc92af640U,
    0xabc6a0e0U,
    0xa42af610U,
    0xae46a108U,
    0xa16ac784U,
    0xf7e69e56U,
    0xbe3afcebU,
    0x91e9818U,
    0xcbc6e407U,
    0x34049a09U,
    0x4665d71dU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x48000000U,
    0x74000000U,
    0xc2000000U,
    0xe7000000U,
    0xb5800000U,
    0xba400000U,
    0x9b200000U,
    0xa3d00000U,
    0x2f180000U,
    0x81840000U,
    0xd82a0000U,
    0xcc190000U,
    0x5e078000U,
    0xe138c000U,
    0xd8982000U,
    0x9cc41000U,
    0x568a2800U,
    0x65892c00U,
    0xa23f9200U,
    0xb76cdd00U,
    0xedaa1080U,
    0x365929c0U,
    0x65278560U,
    0xf2e8c290U,
    0xbf8014c8U,
    0x694025f4U,
    0x4ca01346U,
    0x4e9035a1U,
    0x49b8096aU,
    0xec140096U,
    0xae1201c9U,
    0x94d297aU,
    0x1cb59080U,
    0x16e5e9c0U,
    0xc595a560U,
    0x1235d290U,
    0xff0dbcc8U,
    0x99f1c9f4U,
    0xf407a146U,
    0x8238f8a1U,
    0x471831eaU,
    0x5840556U,
    0xf22a16a9U,
    0xef1936eaU,
    0x618794c8U,
    0xc878e5f4U,
    0x34383346U,
    0x625425a1U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x98000000U,
    0xb4000000U,
    0x52000000U,
    0x7000000U,
    0xbf800000U,
    0x5a400000U,
    0x3b200000U,
    0x91d00000U,
    0xd3380000U,
    0xfdec0000U,
    0x954a0000U,
    0x58f10000U,
    0xb5df8000U,
    0x91dc000U,
    0x86b82000U,
    0xa4ac1000U,
    0x7bea2800U,
    0xd0613c00U,
    0x2847a600U,
    0x8c61ed00U,
    0x166a3480U,
    0xcd2111c0U,
    0xce787e0U,
    0xb7f1ea90U,
    0x667208c8U,
    0x151d1974U,
    0x1895884eU,
    0x15ecc2bbU,
    0xf9678cb2U,
    0x1eb1fdacU,
    0x10d23f3fU,
    0x298d0bf3U,
    0xd70db480U,
    0x9790d1c0U,
    0xd635a7e0U,
    0x2d7cfa90U,
    0x5cffa0c8U,
    0xdfcde574U,
    0x4a000e4eU,
    0xf3003fbbU,
    0x4d801032U,
    0xad40106cU,
    0x1ca03edfU,
    0x7f901c63U,
    0xba1820c8U,
    0x6b3c2574U,
    0xf9f22e4eU,
    0xff5d2fbbU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0xf8000000U,
    0x4c000000U,
    0xa6000000U,
    0x89000000U,
    0x6e800000U,
    0x1a400000U,
    0x17600000U,
    0x4bf00000U,
    0xa2f80000U,
    0x7c5c0000U,
    0x7e360000U,
    0x551b0000U,
    0x40808000U,
    0x272d4000U,
    0x93982000U,
    0x7eac3000U,
    0x524e3800U,
    0x43071c00U,
    0xd1d6be00U,
    0x75c65300U,
    0xd7e08980U,
    0xacdd5240U,
    0xd16003a0U,
    0x72f02a90U,
    0xd47803d8U,
    0x5a1c1dfcU,
    0x37563f3eU,
    0xdbeb2e57U,
    0x2af8adadU,
    0xc8317196U,
    0x944e2e58U,
    0x7a072da7U,
    0xa756b180U,
    0x53864e40U,
    0x9e80bda0U,
    0x222d7990U,
    0xbb180a58U,
    0x9dec0fbcU,
    0xd3ae1c9eU,
    0x5eb734c7U,
    0xc24e9675U,
    0xcb6a706aU,
    0x65aeaf66U,
    0x9fda50f0U,
    0xf8b695adU,
    0x4b366d96U,
    0xa5989058U,
    0x7fc17ea7U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0xb8000000U,
    0x3c000000U,
    0xde000000U,
    0xdf000000U,
    0x29800000U,
    0x32400000U,
    0xe9200000U,
    0x62900000U,
    0x71d80000U,
    0x5e3c0000U,
    0x9f2e0000U,
    0x9e70000U,
    0x26b8000U,
    0x5176c000U,
    0x5ef82000U,
    0xafac1000U,
    0x81760800U,
    0xb69b0c00U,
    0x3be5ae00U,
    0xeb41cf00U,
    0x33eb9780U,
    0x2f36e7c0U,
    0xf1d82260U,
    0x1e3c1090U,
    0xbf2e1c48U,
    0x39e71ba4U,
    0xba6b85f6U,
    0x6d76ef4fU,
    0x80f83a2bU,
    0x70ac2929U,
    0xa8f638b2U,
    0x84db0c69U,
    0xd2c59f80U,
    0x89d1ebc0U,
    0x42338c60U,
    0x710adf90U,
    0x6ef60bc8U,
    0x17db3c64U,
    0xbd458796U,
    0x6891efdfU,
    0xe493ae63U,
    0xc2dafe8dU,
    0x18e3344U,
    0xc6373c26U,
    0x9313ba2bU,
    0x6f9ae929U,
    0xe12e18b2U,
    0xa6e71c69U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0xf8000000U,
    0x3c000000U,
    0x6e000000U,
    0x19000000U,
    0x50800000U,
    0xca400000U,
    0x7b200000U,
    0xafd00000U,
    0x97a80000U,
    0x4b9c0000U,
    0x55ae0000U,
    0x64ef0000U,
    0xf0288000U,
    0x68524000U,
    0x64082000U,
    0x820c1000U,
    0x8f262800U,
    0x75a33400U,
    0xf4aebe00U,
    0xa8614f00U,
    0x842ebb80U,
    0xf2215640U,
    0xa70e9c20U,
    0xb1f15690U,
    0xa6a6a8c8U,
    0xdf6d40f4U,
    0xcd88886aU,
    0x68c27fa7U,
    0x16002ccbU,
    0x650006ebU,
    0x9e803b62U,
    0x3403e30U,
    0xd3a01380U,
    0x59902240U,
    0x82880220U,
    0xfd4c0990U,
    0x92863b48U,
    0xe53322b4U,
    0xdea6aa4aU,
    0xa36d6637U,
    0x388bf83U,
    0xa1c2505fU,
    0xbe800f28U,
    0x93400707U,
    0x8ba03f83U,
    0xb590105fU,
    0x14882f28U,
    0xd84c1707U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0xc8000000U,
    0xbc000000U,
    0x4e000000U,
    0x57000000U,
    0x80800000U,
    0xa400000U,
    0xfd200000U,
    0x8db00000U,
    0xffa80000U,
    0xa6840000U,
    0x110e0000U,
    0x4bdf0000U,
    0x74d78000U,
    0xb8724000U,
    0x84082000U,
    0x8a741000U,
    0xbd061800U,
    0xedab3400U,
    0x2fd1b200U,
    0x6ed96f00U,
    0xad59b380U,
    0x5ed45c0U,
    0x23ff9820U,
    0x38b66690U,
    0x8e263548U,
    0x771b286cU,
    0x30f9866aU,
    0x121d6761U,
    0x8977a5e3U,
    0x7f827aa7U,
    0xe68029ddU,
    0x71403e20U,
    0x9ba02b80U,
    0xbcf031c0U,
    0x4080a20U,
    0xca741990U,
    0xdd061ec8U,
    0x3dab19acU,
    0xe7d18c4aU,
    0xd2d97ef1U,
    0xe359bb2bU,
    0x52ed630bU,
    0xa37fa597U,
    0x32f640d1U,
    0x730610abU,
    0xfaab12cbU,
    0xcf518fb7U,
    0xb4994941U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0xa8000000U,
    0xd4000000U,
    0xfa000000U,
    0xf9000000U,
    0x92800000U,
    0x19400000U,
    0x42a00000U,
    0x21500000U,
    0x8ef80000U,
    0xa7040000U,
    0x59920000U,
    0x36f90000U,
    0x2b2e8000U,
    0xffd04000U,
    0x51922000U,
    0x12f91000U,
    0x592e8800U,
    0x62d06c00U,
    0x91120a00U,
    0x26b92500U,
    0x730eb680U,
    0xa3c05240U,
    0xcfca2ea0U,
    0xb9ad2350U,
    0xe6c4a628U,
    0x136d5a14U,
    0x338e8d1eU,
    0xd7804a91U,
    0xc5ea104cU,
    0xc8bd07aaU,
    0x101cafd5U,
    0x58794965U,
    0x5c44a628U,
    0x9e2d5a14U,
    0xab2e8d1eU,
    0xbfd04a91U,
    0x7192104cU,
    0xa2f907aaU,
    0xf12eafd5U,
    0xb6d04965U,
    0x6b122628U,
    0xdfb91a14U,
    0xe18ead1eU,
    0xba805a91U,
    0x8d6a184cU,
    0x98fd2baaU,
    0x683c85d5U,
    0xb4697c65U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x58000000U,
    0x1c000000U,
    0x72000000U,
    0x4f000000U,
    0xa1800000U,
    0x77400000U,
    0x4da00000U,
    0xbd300000U,
    0xaef80000U,
    0x369c0000U,
    0x8ab60000U,
    0xa8850000U,
    0xfe18000U,
    0xea0dc000U,
    0xf3362000U,
    0x83c51000U,
    0xd041b800U,
    0xa83dec00U,
    0xa44e3600U,
    0xde191700U,
    0x6557a480U,
    0xf288ffc0U,
    0xa4d79e60U,
    0x75c8cad0U,
    0x517797e8U,
    0x64f8c08cU,
    0xd58f8ddeU,
    0x164eb77U,
    0x8cb9a345U,
    0x91a1edadU,
    0x6f7812a6U,
    0xb1dc0234U,
    0x7f1617e8U,
    0xb9b5008cU,
    0x8b19addeU,
    0x8f91fb77U,
    0xaa001b45U,
    0x130001adU,
    0x338024a6U,
    0x88401534U,
    0xb4203368U,
    0xd6703f4cU,
    0x915813beU,
    0xc4ac21a7U,
    0x85ce34adU,
    0xe9592d21U,
    0xc8f79f78U,
    0xffb8e943U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x88000000U,
    0x34000000U,
    0xa2000000U,
    0x3000000U,
    0x41800000U,
    0xf7400000U,
    0x3a00000U,
    0x4100000U,
    0x9a080000U,
    0x4f140000U,
    0xfb20000U,
    0xea550000U,
    0xd73b8000U,
    0x13a1c000U,
    0x2c122000U,
    0xfe451000U,
    0x6533a800U,
    0x38b5d400U,
    0x9a00200U,
    0x23101d00U,
    0x51880080U,
    0xdf5414c0U,
    0x67923260U,
    0x2e0530d0U,
    0xad13a868U,
    0xace5c1c4U,
    0xfb8816e2U,
    0xa8543e15U,
    0x24122b04U,
    0x8a452f91U,
    0x6733b14cU,
    0x6bb5da2dU,
    0xc0200068U,
    0xe05015c4U,
    0xf02814e2U,
    0xd8442315U,
    0xbc1a2b84U,
    0x96513b51U,
    0xa101832cU,
    0x42a0eafdU,
    0xb6bba800U,
    0xf4e1d400U,
    0x7b20200U,
    0x9e551d00U,
    0xd53b8080U,
    0x40a1d4c0U,
    0xe5921260U,
    0x3d0520d0U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0xb8000000U,
    0x1c000000U,
    0x82000000U,
    0xfb000000U,
    0xed800000U,
    0x87400000U,
    0xffa00000U,
    0x24300000U,
    0xde480000U,
    0x992c0000U,
    0xc6e60000U,
    0xd2dd0000U,
    0x64938000U,
    0x59a7c000U,
    0x1462000U,
    0xaaed1000U,
    0xd8dbb800U,
    0xeb8bf400U,
    0x92200e00U,
    0xe3701700U,
    0xc1e81880U,
    0x6d1c0ac0U,
    0xa0ae1560U,
    0x57f126d0U,
    0x20759f68U,
    0x707af7ccU,
    0x8855acf2U,
    0x740ad79bU,
    0x263d9651U,
    0x6556d9bbU,
    0x94b398b6U,
    0x91d7d322U,
    0x952e2768U,
    0x5cb103ccU,
    0x5d5a2f2U,
    0x634ac09bU,
    0x819d8ed1U,
    0x8d66d37bU,
    0x70fb8dd6U,
    0xeffbf5f2U,
    0x3c483800U,
    0xf22c3400U,
    0x73662e00U,
    0x999d0700U,
    0xa133a080U,
    0x9a97fec0U,
    0xb08e1b60U,
    0x4f8131d0U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x48000000U,
    0xac000000U,
    0x6000000U,
    0x95000000U,
    0x5800000U,
    0xc9400000U,
    0x3be00000U,
    0x8100000U,
    0xcc680000U,
    0xb6740000U,
    0xcd5e0000U,
    0xe1a70000U,
    0x635c8000U,
    0xa8e1c000U,
    0x98be2000U,
    0xb73000U,
    0x44b4a800U,
    0xfed5c400U,
    0x25803200U,
    0x19401b00U,
    0xd3e02980U,
    0xb4102140U,
    0x82681360U,
    0x8f741950U,
    0xcede0f78U,
    0xbde72744U,
    0x5d3cb27aU,
    0x69b1dfcdU,
    0x6f361dafU,
    0xbed30a6dU,
    0x458283cdU,
    0xa906c3a5U,
    0x8b82a778U,
    0x5006e344U,
    0x2802807aU,
    0x1c46c4cdU,
    0x5e62b42fU,
    0x7116eb2dU,
    0xafeab0adU,
    0x5a72eaf5U,
    0xab5c8000U,
    0xc4e1c000U,
    0x3ebe2000U,
    0x85b73000U,
    0x934a800U,
    0x9b95c400U,
    0x18603200U,
    0x84501b00U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0xf8000000U,
    0x34000000U,
    0x1a000000U,
    0xff000000U,
    0xf3800000U,
    0x93400000U,
    0x2da00000U,
    0x3e700000U,
    0x3d480000U,
    0x88cc0000U,
    0x52b20000U,
    0x8d910000U,
    0xce358000U,
    0x750cc000U,
    0x94922000U,
    0x84a11000U,
    0x5cdd9800U,
    0xd8b0f400U,
    0xeae81e00U,
    0xd9bc1d00U,
    0x47a1e80U,
    0x721d0bc0U,
    0x532782e0U,
    0xdede9d0U,
    0x8e6fade8U,
    0x1521e05cU,
    0x44dd8bb2U,
    0x7cb0e2e3U,
    0x68e819c4U,
    0xc2bc05f8U,
    0x15fa1c5fU,
    0x2a5d39b0U,
    0x9707b5e8U,
    0x5fddd45cU,
    0x6d07b5b2U,
    0x30ddefe3U,
    0x6879f44U,
    0x479dfa38U,
    0xc92780bfU,
    0xb2edcd60U,
    0x1def8680U,
    0x5661ffc0U,
    0x917d9ce0U,
    0x76c0f4d0U,
    0x4fa03368U,
    0xb5702b9cU,
    0xb4c82952U,
    0x348c1b33U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0x28000000U,
    0xfc000000U,
    0xb2000000U,
    0x5b000000U,
    0x3f800000U,
    0x7f400000U,
    0x89e00000U,
    0x22700000U,
    0xb3680000U,
    0xa3a40000U,
    0xdd360000U,
    0xfaad0000U,
    0xe1a38000U,
    0x7e6ec000U,
    0x71562000U,
    0xc09d3000U,
    0x36ab9800U,
    0xcbfac400U,
    0x81682a00U,
    0x38a40f00U,
    0x82b63480U,
    0x95ed12c0U,
    0x404385e0U,
    0xa01ee0d0U,
    0x703e2ef8U,
    0x38392e5cU,
    0xd41dbb3aU,
    0x4e17f339U,
    0xe92bbf35U,
    0x64baf937U,
    0x40880032U,
    0xf6d415b2U,
    0xabde36f8U,
    0x91492a5cU,
    0x10f5b13aU,
    0x7ef3cc39U,
    0x27fd93b5U,
    0x1b67eff7U,
    0x9fc38fd2U,
    0xf5eca62U,
    0xb1de3480U,
    0xf64912c0U,
    0xfd7585e0U,
    0x4ab3e0d0U,
    0xb99daef8U,
    0xba57ee5cU,
    0x174b9b3aU,
    0xd58ac339U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x8000000U,
    0x4c000000U,
    0xf6000000U,
    0x7f000000U,
    0x76800000U,
    0x19400000U,
    0x11a00000U,
    0x7bf00000U,
    0x8af80000U,
    0xa7540000U,
    0x42ae0000U,
    0xcb170000U,
    0xe4a58000U,
    0x8c124000U,
    0xd6562000U,
    0x2f431000U,
    0x4e8b9800U,
    0x5d454c00U,
    0xabd3a200U,
    0xf2e14300U,
    0x83058580U,
    0xc8e243c0U,
    0x4a2e27a0U,
    0xa1570950U,
    0x1585a3e8U,
    0xa1a25e3cU,
    0x338e209eU,
    0xa6a73345U,
    0x617dace3U,
    0x35f679a9U,
    0xf1a0205fU,
    0xbf0117dU,
    0xe2f82668U,
    0xdb541dfcU,
    0xbcae073eU,
    0xf8173a15U,
    0x64258f0bU,
    0xea526795U,
    0xb17620c1U,
    0x4df33238U,
    0xd5d3928bU,
    0x81e16855U,
    0x6385a561U,
    0x9ea27868U,
    0x250e34e3U,
    0x8fe735a9U,
    0x78dd825fU,
    0x206527dU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0xb8000000U,
    0x7c000000U,
    0x4a000000U,
    0xf3000000U,
    0x90800000U,
    0x81400000U,
    0x5fa00000U,
    0xfb900000U,
    0x5dd80000U,
    0x8cec0000U,
    0x5b360000U,
    0xc4b10000U,
    0xdf338000U,
    0x52974000U,
    0x166e2000U,
    0x891d1000U,
    0x7ba5a800U,
    0x1db65c00U,
    0x2c858e00U,
    0x2b664f00U,
    0x7cfd9a80U,
    0xa31a70c0U,
    0x18938220U,
    0xe5077350U,
    0x19b62368U,
    0xfaf11124U,
    0x4213a7d6U,
    0xd7477cabU,
    0x76963985U,
    0xf0211c58U,
    0xf86ba9f2U,
    0xdc3b49eaU,
    0x3a7839e8U,
    0x4b7c21e4U,
    0xecee05f6U,
    0xcb5d1ffbU,
    0xac85b2edU,
    0x6b66517cU,
    0xdcfd8024U,
    0xd31a7a41U,
    0xa0939aedU,
    0x99074d7cU,
    0x53b62e24U,
    0x9f12541U,
    0xd293a86dU,
    0x560761bcU,
    0x29362204U,
    0xbb11911U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x88000000U,
    0xd4000000U,
    0xea000000U,
    0xb7000000U,
    0xf5800000U,
    0xa5400000U,
    0xfea00000U,
    0x7e900000U,
    0x3eb80000U,
    0x9ef40000U,
    0x2e820000U,
    0xa6d90000U,
    0x729d8000U,
    0x98c9c000U,
    0x2fba2000U,
    0xda6d1000U,
    0x7f3fa800U,
    0x81c0ec00U,
    0xff3f8200U,
    0xc1c0e500U,
    0x5f3fb280U,
    0x71c0d1c0U,
    0xd73f9760U,
    0xa5c0e050U,
    0x3d3faf28U,
    0x12c0fb64U,
    0xc8bfa24eU,
    0xb780ea2dU,
    0x361f99e8U,
    0xc910fb82U,
    0x8a78141U,
    0x57e4d3bbU,
    0x26259da8U,
    0xf13deaa4U,
    0x54b8152eU,
    0x69f41a7dU,
    0x7b021ec0U,
    0xb3992ce6U,
    0x43d810fU,
    0x3259cc96U,
    0xfb021ec0U,
    0xf3992ce6U,
    0xa43d810fU,
    0x8259cc96U,
    0x73021ec0U,
    0x27992ce6U,
    0x4e3d810fU,
    0x3559cc96U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x8000000U,
    0x34000000U,
    0x1a000000U,
    0xd1000000U,
    0xac800000U,
    0x57400000U,
    0x43a00000U,
    0x18d00000U,
    0xd480000U,
    0xb2b40000U,
    0xe4620000U,
    0x52010000U,
    0xc5668000U,
    0xe6e94000U,
    0x8e0a2000U,
    0xdb251000U,
    0x55ec8800U,
    0x9f8c5400U,
    0x6c6a200U,
    0xbe395d00U,
    0xa3422e80U,
    0x39913040U,
    0xb98ea120U,
    0xf98d4cd0U,
    0xd9a03468U,
    0x89d02f74U,
    0x81c826f2U,
    0xb5f4193dU,
    0xafc200d0U,
    0x7ed10a64U,
    0xd22ea463U,
    0x855d6763U,
    0xc6e812e8U,
    0xde640b34U,
    0xd32a05d2U,
    0x61b518edU,
    0x85849238U,
    0xd7a84150U,
    0x12cc81b1U,
    0xf41c6f8eU,
    0x7a2e88d0U,
    0xa15d5e64U,
    0xf4e80663U,
    0x6b643a63U,
    0x6daa3c68U,
    0xd3f53b74U,
    0x70a4a4f2U,
    0x4938543dU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x8000000U,
    0xe4000000U,
    0xe6000000U,
    0x7000000U,
    0x10800000U,
    0x7d400000U,
    0x5da00000U,
    0x8f00000U,
    0x21180000U,
    0x37940000U,
    0xfdfa0000U,
    0xd8ef0000U,
    0xb9258000U,
    0x2be14000U,
    0xf7c22000U,
    0xddcb1000U,
    0x48e79800U,
    0x412a7c00U,
    0xc7a5a200U,
    0xf5a16900U,
    0x3ce20180U,
    0x5f7b2dc0U,
    0x2cdf9e20U,
    0xe70e5a50U,
    0xa0e78ce8U,
    0x152a6afcU,
    0x49a58de6U,
    0xe6a17f75U,
    0xc2621636U,
    0xc13b3e57U,
    0x87ff92e7U,
    0x95be41e1U,
    0xccdf9568U,
    0x570e7b3cU,
    0xc8e791c6U,
    0x12a5c25U,
    0xa7a5835eU,
    0x5a1456bU,
    0x34e20321U,
    0xbb7b1dc4U,
    0xcadf9636U,
    0xe00e7e57U,
    0xb067b2e7U,
    0x686a51e1U,
    0x14058d68U,
    0xee51473cU,
    0xe37a13c6U,
    0xf6af2525U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x38000000U,
    0xac000000U,
    0xa2000000U,
    0xcf000000U,
    0x57800000U,
    0x2fc00000U,
    0x63a00000U,
    0x51b00000U,
    0x16e80000U,
    0xd5740000U,
    0xf4e20000U,
    0xfa130000U,
    0x33448000U,
    0x5dc74000U,
    0xc4c4a000U,
    0x2077000U,
    0xbf64a800U,
    0x4fb75c00U,
    0x338ca600U,
    0xf9c37700U,
    0x32ee8e80U,
    0xe31044c0U,
    0x358a1b60U,
    0xc0a70f30U,
    0x8406a388U,
    0x46646b5cU,
    0xd9680e32U,
    0x26b40201U,
    0x2d42150aU,
    0x78a30b85U,
    0xe82cb75bU,
    0xc4736834U,
    0xa606950aU,
    0x49644b85U,
    0xaee8175bU,
    0xb9741834U,
    0x76e23d0aU,
    0x85131785U,
    0x5cc4b15bU,
    0xde076f34U,
    0x564b38aU,
    0x9cb75345U,
    0xfe0caa3bU,
    0xb5036004U,
    0xa4ce9002U,
    0x52607819U,
    0x17420409U,
    0x6ba31205U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x78000000U,
    0x6c000000U,
    0x7e000000U,
    0xff000000U,
    0x18800000U,
    0xc0c00000U,
    0x7ca00000U,
    0x5ab00000U,
    0xd9b80000U,
    0xc7040000U,
    0x94f20000U,
    0x8eed0000U,
    0xebe28000U,
    0x5676c000U,
    0xb62a000U,
    0x3ab6f000U,
    0x29c2a800U,
    0x8f06f400U,
    0x90fab600U,
    0xe4c2ef00U,
    0x6a8a980U,
    0xcf9fd0c0U,
    0x2c722fa0U,
    0x9e2d20f0U,
    0xcf429088U,
    0x70c6c65cU,
    0xd4da8ee6U,
    0x6eb2c39dU,
    0xdbb0bddaU,
    0x3e2bff26U,
    0x1f3806a2U,
    0x28c40e7bU,
    0xa8d23ddaU,
    0x689d3f26U,
    0x48faa6a2U,
    0x58c2fe7bU,
    0x20a895daU,
    0x4c9fcb26U,
    0x32f210a2U,
    0xcded117bU,
    0xd562bc5aU,
    0x15b6dbe6U,
    0x69429f02U,
    0x33c6c18bU,
    0xea5a84d2U,
    0x2d72e9baU,
    0xb990a7e4U,
    0x375bed16U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xd8000000U,
    0xf4000000U,
    0xd2000000U,
    0xab000000U,
    0x98800000U,
    0x90c00000U,
    0xeca00000U,
    0x82f00000U,
    0xe7e80000U,
    0x2a040000U,
    0xaf3e0000U,
    0x32b70000U,
    0xfff28000U,
    0x7e46c000U,
    0x4d72a000U,
    0x4186f000U,
    0x93528800U,
    0x3cb6fc00U,
    0xa9abe00U,
    0x5b82c100U,
    0xe46c8a80U,
    0xfa01ebc0U,
    0x27682ca0U,
    0x8ec40ff0U,
    0x319e3788U,
    0x2b471f4cU,
    0x589aa672U,
    0x3082d9cdU,
    0xdcec9bbdU,
    0x5ac1d860U,
    0x13c838c1U,
    0xf8342131U,
    0x4761bbdU,
    0xaa431860U,
    0x6f2498c1U,
    0x92f5d131U,
    0xcfbe13bdU,
    0xa6772460U,
    0xb95286c1U,
    0x93b6e031U,
    0x381a913dU,
    0xa442f3a0U,
    0x9a4cb461U,
    0xb731dec1U,
    0x66a02435U,
    0x1df03b2cU,
    0xd6820b3U,
    0x21c439fcU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x8000000U,
    0xc000000U,
    0x72000000U,
    0xf9000000U,
    0x4a800000U,
    0x86c00000U,
    0x14e00000U,
    0x7db00000U,
    0xf280000U,
    0x8dec0000U,
    0xe70a0000U,
    0x11830000U,
    0xad578000U,
    0xecdec000U,
    0x99b7a000U,
    0xe16ed000U,
    0x3e9f8800U,
    0x5082dc00U,
    0xa3958a00U,
    0xb401df00U,
    0x36421680U,
    0x271f2140U,
    0xf195a420U,
    0x3d01d0f0U,
    0xd4c22918U,
    0x9ddf139cU,
    0x9f75a0d2U,
    0xb5b1efe7U,
    0xe36a0f90U,
    0x6ff30ac7U,
    0x261fa0e5U,
    0x5f42f100U,
    0x55f58790U,
    0x7371d6c7U,
    0x578a2ae5U,
    0x22432e00U,
    0x21379110U,
    0xdeaef787U,
    0xc0ff8ec5U,
    0x9bf2fef0U,
    0xb05db808U,
    0x485de41bU,
    0xac602e17U,
    0x42701117U,
    0xf1483798U,
    0x469c2edcU,
    0xf4c22ef2U,
    0xeddf3017U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x28000000U,
    0xe4000000U,
    0x1e000000U,
    0xd000000U,
    0x4f800000U,
    0x3c00000U,
    0xb9e00000U,
    0xcad00000U,
    0xd8780000U,
    0xbc2c0000U,
    0xe27e0000U,
    0x8f410000U,
    0x90ef8000U,
    0xbb1c4000U,
    0xe68fa000U,
    0x320c5000U,
    0xe717b800U,
    0x14f04400U,
    0xf511b200U,
    0xc39d7d00U,
    0x99803580U,
    0xfac03e40U,
    0xa0600660U,
    0x70102eb0U,
    0x18183018U,
    0x9c3c0804U,
    0xd2660c06U,
    0xf77d1e0fU,
    0x5c89b319U,
    0x41617e9fU,
    0xf58624c2U,
    0x70ad00a8U,
    0xab718b19U,
    0xae8d7a9fU,
    0x861836c2U,
    0xd13c2da8U,
    0xfde60699U,
    0xa4bd00dfU,
    0xcd6982a2U,
    0x6fb17e18U,
    0x33fe0301U,
    0xc181369bU,
    0x68f88c4U,
    0x220c4ea7U,
    0xaf178000U,
    0xa0f04000U,
    0xc311a000U,
    0x2a9d5000U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x38000000U,
    0x2c000000U,
    0xd2000000U,
    0x8d000000U,
    0x70800000U,
    0x14c00000U,
    0xb2e00000U,
    0x51f00000U,
    0xf6280000U,
    0xb740000U,
    0x23c20000U,
    0x8b7b0000U,
    0x63858000U,
    0xab51c000U,
    0xd3e5a000U,
    0x9361d000U,
    0xffada800U,
    0x4125fc00U,
    0x72a7a600U,
    0x31daf700U,
    0x66481280U,
    0x83441440U,
    0x378a2ea0U,
    0x753f0170U,
    0x3c8f8a18U,
    0x56aef90cU,
    0xb78a1992U,
    0x353f20d1U,
    0x1c8f8de2U,
    0xe6aedd4fU,
    0x8f8a2f23U,
    0x193f05abU,
    0xce8fa5e2U,
    0x6baee14fU,
    0xff0a2923U,
    0xdff22abU,
    0x7c6f9f62U,
    0x3a5ec90fU,
    0x9220183U,
    0x68b04dbU,
    0x5fadaffaU,
    0xb125d843U,
    0x6aa790b1U,
    0xaddad27aU,
    0x8c483a80U,
    0x22442840U,
    0x950a28a0U,
    0xecff2670U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xd8000000U,
    0xec000000U,
    0xf2000000U,
    0x65000000U,
    0x87800000U,
    0x5c00000U,
    0x48a00000U,
    0xcb100000U,
    0x58f80000U,
    0xb3340000U,
    0x84d20000U,
    0xc9130000U,
    0xd5f58000U,
    0x50944000U,
    0x470da000U,
    0xfaa07000U,
    0xe5fb800U,
    0xef736400U,
    0x3e8a0e00U,
    0xf8371f00U,
    0x1c5f9280U,
    0x1a737640U,
    0x10a0b60U,
    0x41f71330U,
    0x7eff9748U,
    0x58637ef4U,
    0x2c7233f6U,
    0x92031479U,
    0x350d81a2U,
    0x5fa0610dU,
    0xe9dfb597U,
    0xbab340dcU,
    0xae2a1322U,
    0xdf27174dU,
    0xb6a7bef7U,
    0xcc4753ecU,
    0x258046aU,
    0x8d2429b9U,
    0xe3aa2d01U,
    0xc3e73795U,
    0x3387bdc8U,
    0xdb976cb4U,
    0xbf803696U,
    0x79c01849U,
    0x2a0046aU,
    0x121029b9U,
    0xf5782d01U,
    0x3ff43795U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0x58000000U,
    0xc4000000U,
    0x66000000U,
    0x3b000000U,
    0x39800000U,
    0xd7c00000U,
    0x10a00000U,
    0xbb700000U,
    0xf9f80000U,
    0x77f40000U,
    0x80a60000U,
    0xe30d0000U,
    0x3db48000U,
    0x11c64000U,
    0xbbcca000U,
    0xdaf27000U,
    0xea4a8800U,
    0x14f5400U,
    0xa61e00U,
    0x230d2500U,
    0x9db4a780U,
    0x81c65bc0U,
    0xe3cca1e0U,
    0x1ef27a30U,
    0x8c4a9bc8U,
    0x3a4f41ecU,
    0x39262a36U,
    0xf4cd23d1U,
    0x8d14bdffU,
    0x3ab65022U,
    0x1a34b0daU,
    0x69065b7fU,
    0xcec9a7fU,
    0xd9424be2U,
    0x492b13aU,
    0xe50b514fU,
    0x36d809b7U,
    0xe0441e0eU,
    0xf07e250cU,
    0x6849279eU,
    0xc4a9bc8U,
    0xfa4f41ecU,
    0x99262a36U,
    0x64cd23d1U,
    0xd514bdffU,
    0xfeb65022U,
    0x7c34b0daU,
    0x52065b7fU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0xb8000000U,
    0xb4000000U,
    0xfa000000U,
    0x47000000U,
    0xd1800000U,
    0x1fc00000U,
    0xe2e00000U,
    0x94100000U,
    0x4a580000U,
    0xf240000U,
    0xcd8e0000U,
    0xe9bb0000U,
    0xebe48000U,
    0xf8a64000U,
    0xc35ca000U,
    0x23925000U,
    0xa48a9800U,
    0xd50d5400U,
    0x3ae03600U,
    0x70103900U,
    0xe8582880U,
    0xec2438c0U,
    0x5e0e24e0U,
    0x57b3b30U,
    0x2284b258U,
    0x34767334U,
    0xba64be4eU,
    0xa766713dU,
    0xc1bc814dU,
    0xa78248a3U,
    0x56d2ad0cU,
    0x6e297e8eU,
    0xd6e31cdU,
    0xdeab2463U,
    0xd23cbfecU,
    0xb427cbeU,
    0x7fb2ab15U,
    0xb2f96f97U,
    0xcc562542U,
    0xee5f36b3U,
    0x4d0a9800U,
    0x3ecd5400U,
    0xc2003600U,
    0xb3003900U,
    0xcb802880U,
    0x48c038c0U,
    0x8b6024e0U,
    0x3fd03b30U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0xb8000000U,
    0x14000000U,
    0xd2000000U,
    0x6d000000U,
    0x25800000U,
    0x73c00000U,
    0x54e00000U,
    0x38500000U,
    0x54380000U,
    0xb2440000U,
    0x3d7e0000U,
    0x9dbf0000U,
    0x67958000U,
    0x86ad4000U,
    0x554da000U,
    0x71b95000U,
    0xc18bb800U,
    0x69824400U,
    0xa5801600U,
    0x33c00100U,
    0x34e00280U,
    0x68500a40U,
    0xec3813e0U,
    0xa64402b0U,
    0xef7e28d8U,
    0xf0bf09a4U,
    0x42158956U,
    0xf56d7e75U,
    0x1adaf69U,
    0x49e955eaU,
    0x95b3bbb4U,
    0xdbc66e55U,
    0x98fe15e9U,
    0xae7f1baaU,
    0x5375be54U,
    0xeefd6de5U,
    0xb975bfb1U,
    0xd7fd584eU,
    0x2ef584e2U,
    0x993d4120U,
    0xe7958000U,
    0xc6ad4000U,
    0x354da000U,
    0x21b95000U,
    0x798bb800U,
    0x7d824400U,
    0x77801600U,
    0x5ec00100U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x38000000U,
    0x2c000000U,
    0x86000000U,
    0x79000000U,
    0xe2800000U,
    0xd8c00000U,
    0xafe00000U,
    0xc0100000U,
    0xa0280000U,
    0x10140000U,
    0xc8720000U,
    0x14490000U,
    0xaa698000U,
    0xff0ec000U,
    0x9ba1a000U,
    0x3a0ad000U,
    0x777b9800U,
    0x6f97ec00U,
    0x60001600U,
    0xb0002700U,
    0xd8001780U,
    0xdc002940U,
    0xbe001720U,
    0x55002370U,
    0x648032d8U,
    0xa1c01874U,
    0x4d603b52U,
    0x18d00231U,
    0xfc831eeU,
    0xd0043113U,
    0x685a308cU,
    0x45d3ed4U,
    0x621bbe6eU,
    0xeb47f453U,
    0x31c831acU,
    0xc5043aa4U,
    0xecda1b36U,
    0x559d0567U,
    0x177bbddeU,
    0xdf97cbe5U,
    0xb8000000U,
    0x6c000000U,
    0x66000000U,
    0x89000000U,
    0xda800000U,
    0xf4c00000U,
    0x29e00000U,
    0xb9100000U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x48000000U,
    0x34000000U,
    0x3e000000U,
    0x1b000000U,
    0xe0800000U,
    0xe2c00000U,
    0xd3a00000U,
    0xc6500000U,
    0xa7080000U,
    0xacc0000U,
    0xf7e60000U,
    0x60010000U,
    0xf0188000U,
    0xa80ac000U,
    0x430a000U,
    0x7656f000U,
    0x2f7e9800U,
    0xdecbfc00U,
    0xf9880a00U,
    0x330c3100U,
    0x24c62580U,
    0x749107c0U,
    0xccb0a5a0U,
    0x5096f370U,
    0x6adea348U,
    0x79bffe4U,
    0xc8003d0aU,
    0xf4003797U,
    0xde000ad3U,
    0x2b002a27U,
    0xa88035bdU,
    0xd6c03b71U,
    0xeda03753U,
    0xdd5011e7U,
    0x47883a1dU,
    0xe80c0901U,
    0x2446299bU,
    0xa65115c3U,
    0x5710a8b7U,
    0xa2c6fce6U,
    0xf3d6a580U,
    0x1657c7c0U,
    0xdf6605a0U,
    0x76c10370U,
    0xfdb8bb48U,
    0x455ac3e4U,
    0xbb8970aU,
    0xaa5af697U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0x98000000U,
    0x9c000000U,
    0x4e000000U,
    0x59000000U,
    0x7800000U,
    0xddc00000U,
    0xdea00000U,
    0x1a300000U,
    0x23080000U,
    0x34a40000U,
    0xa13a0000U,
    0x8bc50000U,
    0xdb958000U,
    0x73d04000U,
    0x57bda000U,
    0x75847000U,
    0xfaafa800U,
    0x38154c00U,
    0xac280e00U,
    0xf6542b00U,
    0x35123d80U,
    0xd1910d40U,
    0x1887b460U,
    0x97414630U,
    0x9eba05c8U,
    0xfa0517bcU,
    0xf335b68aU,
    0x5ce040d5U,
    0xa5359124U,
    0x59e07e54U,
    0xccb5ade9U,
    0x2d20696cU,
    0x8d9584a4U,
    0x76d07f14U,
    0x3e3db789U,
    0x144745cU,
    0xbb8f94ecU,
    0x63e569e8U,
    0x1f801b63U,
    0x81c029b9U,
    0xb0a01580U,
    0xb3300140U,
    0xbc881a60U,
    0x75641d30U,
    0x319a1048U,
    0xc8f516fcU,
    0xff1daceaU,
    0x9ab45de5U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x8000000U,
    0x84000000U,
    0x92000000U,
    0x91000000U,
    0xbd800000U,
    0x8cc00000U,
    0x61600000U,
    0xc5b00000U,
    0x30d80000U,
    0x6f6c0000U,
    0x4af60000U,
    0xa530000U,
    0x5d2d8000U,
    0x8bc04000U,
    0x9fdba000U,
    0x45935000U,
    0x70f62800U,
    0x4f531400U,
    0x5aad8a00U,
    0x2006500U,
    0xd93b8680U,
    0x19e35540U,
    0xece23e0U,
    0xf84f1370U,
    0xfc63bd38U,
    0x2e4f775cU,
    0x9f5812eeU,
    0x32ac3ff7U,
    0xb6161d6bU,
    0x53231a3fU,
    0x495b0ceU,
    0xa51c5338U,
    0x77f5a053U,
    0xb1ac6d63U,
    0xdaada220U,
    0x42006ccfU,
    0xf93bbd38U,
    0x9e3775cU,
    0x6ce12eeU,
    0x7c4f3ff7U,
    0x6e639d6bU,
    0xbf4f5a3fU,
    0x22d810ceU,
    0xbe6c0338U,
    0xd7760853U,
    0x96933963U,
    0x344d8820U,
    0xca7059cfU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0x78000000U,
    0xac000000U,
    0x3a000000U,
    0xd000000U,
    0xf1800000U,
    0x6cc00000U,
    0xf5200000U,
    0x9df00000U,
    0x76a80000U,
    0x8640000U,
    0x141a0000U,
    0xb6230000U,
    0xc75f8000U,
    0x84944000U,
    0x3145a000U,
    0xa3b77000U,
    0x659a2800U,
    0x1ae30c00U,
    0x127f9600U,
    0xe9645700U,
    0x3fedb080U,
    0x7d35840U,
    0x4b801ae0U,
    0xa1c01470U,
    0x24a01728U,
    0x1302b4cU,
    0xfb883062U,
    0x39940d25U,
    0x58b22a4cU,
    0xb34737e1U,
    0x22c5b5f9U,
    0x5e7770e1U,
    0x33a3d64U,
    0xbad31cadU,
    0x2277859bU,
    0xb1307dc4U,
    0x63ff9728U,
    0x45a46b4cU,
    0xeacd9062U,
    0x6a237d25U,
    0x4528024cU,
    0x5a43be1U,
    0xaba23f9U,
    0xba1327e1U,
    0xcd578de4U,
    0xd1c044edU,
    0x9cd79f7bU,
    0x8d0069b4U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x98000000U,
    0x6c000000U,
    0xaa000000U,
    0x83000000U,
    0xd7800000U,
    0xc0c00000U,
    0xa1600000U,
    0x30d00000U,
    0x99280000U,
    0x8cf40000U,
    0x9b4a0000U,
    0xfbdb0000U,
    0x8ae88000U,
    0x12644000U,
    0x7f42a000U,
    0x35af5000U,
    0x87e21800U,
    0x28ef1c00U,
    0xb5429e00U,
    0xc6af5700U,
    0x28622c80U,
    0xb42f2bc0U,
    0x2622a760U,
    0x197f5cf0U,
    0xccca1bb8U,
    0x7b1b3704U,
    0xcb889c92U,
    0x12b443c9U,
    0x7e6ab378U,
    0xd55b66fbU,
    0xb6a81eb0U,
    0x50340a9bU,
    0xe82a30c0U,
    0x140b0dffU,
    0xf640bc22U,
    0xb1504e52U,
    0x38e8b738U,
    0xbd645cc4U,
    0xe2c29bf2U,
    0x466f4f39U,
    0x690230c0U,
    0xb4ff0dffU,
    0x270abc22U,
    0xf98b4e52U,
    0xfd803738U,
    0x3c01cc4U,
    0x96e03bf2U,
    0xc0101f39U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x28000000U,
    0x8c000000U,
    0x2e000000U,
    0xc3000000U,
    0xae800000U,
    0x79c00000U,
    0x9d200000U,
    0xe5d00000U,
    0xb680000U,
    0xd2ec0000U,
    0x1fa20000U,
    0xe2690000U,
    0x4d328000U,
    0x3dd8c000U,
    0xcf30a000U,
    0x40a1f000U,
    0xdaca3800U,
    0x3853c00U,
    0xb4109200U,
    0x1a71ef00U,
    0x19222180U,
    0xd7a923c0U,
    0x9e12b820U,
    0x2b08e2b0U,
    0x42d8a6e8U,
    0x678df404U,
    0x76481612U,
    0xc73c010fU,
    0x5cca3c92U,
    0x8c853d51U,
    0x5490b26cU,
    0x90b1dd58U,
    0x282227aU,
    0xc7b93555U,
    0x265a967eU,
    0xdf34c357U,
    0xf8928768U,
    0x2ec8d7c4U,
    0xb9f8ae32U,
    0xfd5de3bfU,
    0xd5a01a7aU,
    0x23100955U,
    0x5ec8047eU,
    0x31fc2c57U,
    0x216a26e8U,
    0xe3953404U,
    0x4458b612U,
    0x524df10fU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x48000000U,
    0x6c000000U,
    0x4e000000U,
    0x3b000000U,
    0x94800000U,
    0xc1c00000U,
    0xbe200000U,
    0xb3500000U,
    0x98880000U,
    0xffdc0000U,
    0xcd320000U,
    0x4bc10000U,
    0x17728000U,
    0x7aabc000U,
    0xeac8a000U,
    0x12b6f000U,
    0x56883800U,
    0x4dc2c00U,
    0x39b20a00U,
    0xfa010700U,
    0xe1528180U,
    0xa5fbd5c0U,
    0x3c4096a0U,
    0xd66aceb0U,
    0xf3a32a8U,
    0x8edd30a4U,
    0x90e083aaU,
    0x33fad423U,
    0x931234eeU,
    0x489108c7U,
    0xa7fa9830U,
    0x9977eeeaU,
    0x21fa87c6U,
    0xe77eda3U,
    0x9b7a8d3aU,
    0x84b7f479U,
    0xf9da8180U,
    0x9a27d5c0U,
    0x917296a0U,
    0xedabceb0U,
    0x5048b2a8U,
    0x9876f0a4U,
    0x342823aaU,
    0x1a4c2423U,
    0x511a0ceeU,
    0x8d8d24c7U,
    0x20689230U,
    0xd026e9eaU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x58000000U,
    0x44000000U,
    0x1a000000U,
    0xf1000000U,
    0x4e800000U,
    0xf5c00000U,
    0x32600000U,
    0x3d100000U,
    0x28f80000U,
    0xcaa40000U,
    0xcfee0000U,
    0x337f0000U,
    0xbbad8000U,
    0xc14bc000U,
    0xa6bba000U,
    0x1990d000U,
    0xa4783800U,
    0xca643400U,
    0xc90e0e00U,
    0x9aaf3500U,
    0xb7b59080U,
    0x873fed40U,
    0x69cdb520U,
    0x2c5bd130U,
    0xb643a738U,
    0x734c634U,
    0x299628a6U,
    0x4c1b18edU,
    0x2623b145U,
    0x5f24f736U,
    0x6dee3e30U,
    0x567f3cbdU,
    0xd72d86fdU,
    0x118bdc42U,
    0x985ba3b6U,
    0x6440f560U,
    0xea601080U,
    0x39102d40U,
    0x52f81520U,
    0xaba40130U,
    0xd96e1f38U,
    0x82bf3234U,
    0x93cd86a6U,
    0xd5bfdedU,
    0xc0c399c5U,
    0x26f4ee76U,
    0x59f62510U,
    0xc40b088dU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0xc8000000U,
    0xe4000000U,
    0x42000000U,
    0xbd000000U,
    0x6a800000U,
    0x5c00000U,
    0x2a200000U,
    0x89100000U,
    0xf0880000U,
    0x64dc0000U,
    0x2eb60000U,
    0x97830000U,
    0x4f578000U,
    0x3fe7c000U,
    0x9b69a000U,
    0x55b8f000U,
    0x32081800U,
    0xb51c0c00U,
    0x6e960a00U,
    0xb7930500U,
    0x5f5fa280U,
    0x7fbd640U,
    0xb77faa20U,
    0xf3ebde30U,
    0xcd778828U,
    0x62f7ef34U,
    0x1e19caaU,
    0x9864ce73U,
    0xfc3e0d0fU,
    0x7e5f2697U,
    0x23619858U,
    0xb9a4c129U,
    0x741e27a7U,
    0xba4f1fe3U,
    0x7169aed2U,
    0x3cb8d16aU,
    0x32882280U,
    0x19dc1640U,
    0xa4360a20U,
    0x62432e30U,
    0xad779028U,
    0x52f7e334U,
    0x29e196aaU,
    0x8c64cb73U,
    0x763e2f8fU,
    0x275f30d7U,
    0xbe19278U,
    0x164ef19U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0x48000000U,
    0xdc000000U,
    0x92000000U,
    0x53000000U,
    0x6c800000U,
    0x85c00000U,
    0x36600000U,
    0xe5500000U,
    0xc9f80000U,
    0xac6c0000U,
    0x8a6a0000U,
    0x27570000U,
    0x32e88000U,
    0xcfbc000U,
    0xd5faa000U,
    0x9e00d000U,
    0x29181800U,
    0x13fc1400U,
    0x23722a00U,
    0x74ab3300U,
    0xf19ab680U,
    0x6850e3c0U,
    0x6c601fa0U,
    0x2a5025b0U,
    0xd7782eb8U,
    0x6aac1c24U,
    0x988a2de6U,
    0x9bc7254fU,
    0x5f70b464U,
    0x16c7f60eU,
    0xfae89500U,
    0x90fbfb9bU,
    0xa7faac5cU,
    0xdd00c9eaU,
    0xd980746U,
    0x4a3c2b64U,
    0x87122e80U,
    0xc2fb37c0U,
    0x54e295a0U,
    0x41fcc6b0U,
    0xd06a0038U,
    0xe8572be4U,
    0x2c68b846U,
    0xca3be3ffU,
    0xc71ab45cU,
    0x2290ddeaU,
    0x44802d46U,
    0x9c01864U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x98000000U,
    0x6c000000U,
    0x2e000000U,
    0x71000000U,
    0x7c800000U,
    0xebc00000U,
    0xd2200000U,
    0x67500000U,
    0xd1d80000U,
    0xf1640000U,
    0xbc9a0000U,
    0x8bd10000U,
    0x2678000U,
    0xff1ac000U,
    0xbda5a000U,
    0xdf6ff000U,
    0xcdf83800U,
    0xf7340400U,
    0xe9c23e00U,
    0x2d752f00U,
    0xdaddad80U,
    0xe9bc740U,
    0x3c9a34a0U,
    0x4bd116b0U,
    0x6267b3a8U,
    0x2f1ad724U,
    0x25a586feU,
    0xb36fce8dU,
    0xe3f828d0U,
    0x863406edU,
    0x95420e9fU,
    0xc6b508c2U,
    0x8fdb6f8U,
    0x69cbd689U,
    0xed421cc1U,
    0xbab520ffU,
    0xdefd9580U,
    0xa4cbc340U,
    0x27c20aa0U,
    0x4c7539b0U,
    0x5e5d9e28U,
    0x595bd064U,
    0x58ba125eU,
    0x3181283dU,
    0xe13fa378U,
    0x44bed5c9U,
    0x379fb661U,
    0xb42ee94fU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xb8000000U,
    0xac000000U,
    0x6000000U,
    0xfd000000U,
    0xef800000U,
    0xf8c00000U,
    0x8c200000U,
    0xf6300000U,
    0xe5480000U,
    0x73c40000U,
    0x46ca0000U,
    0xdd750000U,
    0x1fcd8000U,
    0xe0814000U,
    0x106fa000U,
    0x48007000U,
    0xb4200800U,
    0x9a303c00U,
    0x43480600U,
    0xbec42700U,
    0x114a2f80U,
    0x89b51440U,
    0x95edba60U,
    0xebb14170U,
    0x1aa7b8e8U,
    0xc30473bcU,
    0x7eca125aU,
    0xb1751d7dU,
    0xb9cdaee0U,
    0x2d814cacU,
    0x47ef99c1U,
    0x1cc06b3dU,
    0x3e003188U,
    0x91001750U,
    0x498037fbU,
    0x35c01030U,
    0xdba00800U,
    0xa2f03c00U,
    0x6f680600U,
    0x78f42700U,
    0x4c022f80U,
    0x56711440U,
    0xd527ba60U,
    0xcbc44170U,
    0xeaea38e8U,
    0xdb4533bcU,
    0xe285b25aU,
    0xf456d7dU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x58000000U,
    0x14000000U,
    0x5a000000U,
    0x75000000U,
    0x6c800000U,
    0x87c00000U,
    0xdc600000U,
    0xf6700000U,
    0xcb780000U,
    0x4b840000U,
    0xd2660000U,
    0x79070000U,
    0x82c78000U,
    0xf8e4c000U,
    0x9db9a000U,
    0x917d000U,
    0xcae00800U,
    0x14b00400U,
    0x83983e00U,
    0x7e341100U,
    0xc77e0080U,
    0xa5f31840U,
    0xad598da0U,
    0x38a7fcb0U,
    0x7df80c38U,
    0xf9440c6cU,
    0xc2862dc6U,
    0x58b73b7dU,
    0xcddf9047U,
    0x5110c9a0U,
    0xdea7a2a8U,
    0x4e94ed38U,
    0xf6c194ffU,
    0x1293d98cU,
    0x40863cceU,
    0x79b73bf5U,
    0x5b5f8800U,
    0xf3d0c400U,
    0x36479e00U,
    0x2b24c100U,
    0xbbd98880U,
    0xda67dc40U,
    0x351813a0U,
    0xccf43db0U,
    0xd79e04b8U,
    0x8443102cU,
    0xe2419e66U,
    0x9153d6cdU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0xe8000000U,
    0x94000000U,
    0x42000000U,
    0x7b000000U,
    0x49800000U,
    0x3cc00000U,
    0x90200000U,
    0x58500000U,
    0x1c080000U,
    0xa64c0000U,
    0xd13e0000U,
    0xa6eb0000U,
    0x375c8000U,
    0xd7f94000U,
    0x81caa000U,
    0x78ce7000U,
    0x2a003800U,
    0x2f002c00U,
    0x6b802200U,
    0x37c03900U,
    0x31a02a80U,
    0xf0903bc0U,
    0xce2802e0U,
    0x851c11f0U,
    0x84b63668U,
    0x3c671924U,
    0x7642a30aU,
    0x29427f87U,
    0xaa9e134dU,
    0x97b3029U,
    0x7af4a198U,
    0xf1254044U,
    0x76dcb7a5U,
    0xcf397ecdU,
    0xdbea8272U,
    0xbf9e6733U,
    0xd5880000U,
    0x5a8c0000U,
    0x211e0000U,
    0x8ebb0000U,
    0xc3548000U,
    0xe5b54000U,
    0x12f4a000U,
    0xa5257000U,
    0x54dcb800U,
    0xc4396c00U,
    0x7a6a8200U,
    0x175e4900U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0x28000000U,
    0x14000000U,
    0x4a000000U,
    0xe3000000U,
    0x6f800000U,
    0x72c00000U,
    0x70200000U,
    0xe8300000U,
    0x34080000U,
    0xba3c0000U,
    0xcb0a0000U,
    0x7b850000U,
    0x38d28000U,
    0x9318c000U,
    0x87abe000U,
    0x46d4b000U,
    0xca000800U,
    0x23000c00U,
    0x4f800200U,
    0x82c00f00U,
    0x58200280U,
    0xfc300140U,
    0x7e0804a0U,
    0x593c0e30U,
    0xa48a06f8U,
    0x945072cU,
    0x48f28702U,
    0x7b28ce83U,
    0xb3a3e340U,
    0xfce8bba3U,
    0x10a04b0U,
    0x58850bb8U,
    0x7752818dU,
    0x11d8c631U,
    0xdf8beafaU,
    0xbae4b52dU,
    0xb4080000U,
    0x7a3c0000U,
    0xeb0a0000U,
    0x8b850000U,
    0x10d28000U,
    0x8718c000U,
    0xcdabe000U,
    0xa5d4b000U,
    0xa5800800U,
    0x51c00c00U,
    0x3fa00200U,
    0x6af00f00U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x28000000U,
    0x9c000000U,
    0x7e000000U,
    0xff000000U,
    0x43800000U,
    0x79c00000U,
    0xb8200000U,
    0x14100000U,
    0x52380000U,
    0xf9140000U,
    0x88a0000U,
    0xd8670000U,
    0x40ff8000U,
    0x108fc000U,
    0x7c78e000U,
    0x6ad27000U,
    0x5d800800U,
    0x96c00400U,
    0x33a00e00U,
    0xa1d00500U,
    0xbc180280U,
    0x8e0409c0U,
    0x673207e0U,
    0xa7b30ff0U,
    0xb3d58438U,
    0xa538c79cU,
    0xd69f6b82U,
    0x9759b141U,
    0x7b4aed23U,
    0xdd617b91U,
    0x26558688U,
    0xfff8cc86U,
    0xb33f688fU,
    0x5589bdc8U,
    0xfad2eaa7U,
    0xd5a5749dU,
    0xbac78000U,
    0x359bc000U,
    0xeaf2e000U,
    0x1db57000U,
    0x76ff8800U,
    0x638fc400U,
    0x89f8ee00U,
    0x20127500U,
    0xf0200a80U,
    0x98100dc0U,
    0xe43809e0U,
    0xca140af0U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0x48000000U,
    0x1c000000U,
    0xae000000U,
    0xf9000000U,
    0x6c800000U,
    0x95c00000U,
    0x7c200000U,
    0x3e300000U,
    0xe1080000U,
    0x489c0000U,
    0x6fd20000U,
    0x37270000U,
    0x59b8000U,
    0xe1764000U,
    0xcde72000U,
    0xb8277000U,
    0x94200800U,
    0x92300c00U,
    0x27080200U,
    0xdd9c0700U,
    0xe5520480U,
    0x47e701c0U,
    0xbb3b8ae0U,
    0xb3864f90U,
    0x3c4f26c8U,
    0x5b4b795cU,
    0x66da0fc2U,
    0xd3bb0fe3U,
    0xac498c10U,
    0x43514389U,
    0x42fca27dU,
    0x299132b2U,
    0xe76722b9U,
    0x78e77d87U,
    0x42800016U,
    0xacc009deU,
    0x30a00800U,
    0xdbf00c00U,
    0xd5280200U,
    0x6aac0700U,
    0x20da0480U,
    0x86bb01c0U,
    0x6c98ae0U,
    0x43914f90U,
    0xb45ca6c8U,
    0x6761395cU,
    0xb8cf2fc2U,
    0x628b7fe3U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0x48000000U,
    0xbc000000U,
    0xe000000U,
    0xe1000000U,
    0xb5800000U,
    0x3dc00000U,
    0x8c200000U,
    0xd6100000U,
    0x75180000U,
    0xd7b40000U,
    0x9ad20000U,
    0x648f0000U,
    0x50538000U,
    0x25c04000U,
    0x38296000U,
    0x4157000U,
    0x4a200800U,
    0xcb100400U,
    0xae980600U,
    0xdb740d00U,
    0xeb720480U,
    0x335f0bc0U,
    0xa76b80e0U,
    0xc5644e10U,
    0x62636b58U,
    0x8aee73dcU,
    0xc8180c2U,
    0x5c4f4961U,
    0xb3fae151U,
    0x2d15307bU,
    0x3a9652dU,
    0x98d57988U,
    0x13800be5U,
    0xf0c0054cU,
    0x1fa00a5aU,
    0x66d0055dU,
    0xab80800U,
    0x61640400U,
    0xd86a0600U,
    0xb9eb0d00U,
    0x86398480U,
    0x7d2b4bc0U,
    0xb90e0e0U,
    0x44fe3e10U,
    0xcd90e358U,
    0x59fe37dcU,
    0x1610e6c2U,
    0x553e3461U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0x98000000U,
    0x34000000U,
    0x12000000U,
    0x43000000U,
    0x4800000U,
    0xb8400000U,
    0x46200000U,
    0x41300000U,
    0x3fb80000U,
    0x58f40000U,
    0x74460000U,
    0x701d0000U,
    0x680c8000U,
    0x9c1cc000U,
    0x6e132000U,
    0xfd051000U,
    0x61980800U,
    0xedc40c00U,
    0xb9fe0e00U,
    0xbbe90d00U,
    0x80ca8980U,
    0x6041c340U,
    0x523fa120U,
    0x6329d430U,
    0x34b32848U,
    0xf0751784U,
    0xea000262U,
    0x67000513U,
    0x6e80047bU,
    0x1f400bcfU,
    0xc8a00fe4U,
    0x8e700071U,
    0x6f1807e8U,
    0xe2840675U,
    0x95e02cbU,
    0xd1990047U,
    0x65d28180U,
    0xf5c5cf40U,
    0x4de1af20U,
    0x49f0d930U,
    0x13c1a1c8U,
    0xfcc0d4c4U,
    0xde79a342U,
    0x3734d123U,
    0x36bfac33U,
    0xcb69dc4bU,
    0xa932d86U,
    0x55451562U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0x98000000U,
    0xec000000U,
    0xe000000U,
    0x29000000U,
    0x9f800000U,
    0xa9400000U,
    0x52200000U,
    0x8f300000U,
    0x32a80000U,
    0x1cd40000U,
    0xa8460000U,
    0x89ab0000U,
    0xac5b8000U,
    0x63964000U,
    0x5f65e000U,
    0x673f5000U,
    0xd6880800U,
    0xc6e40c00U,
    0x336e0a00U,
    0xa93f0500U,
    0x5fbd8980U,
    0x94d4ec0U,
    0x23660e0U,
    0x170d1290U,
    0xdea3e1f8U,
    0x12d45694U,
    0x81738722U,
    0x160241f3U,
    0x503e0aaU,
    0x31a45a0dU,
    0xd07b8be4U,
    0x55a648caU,
    0xca4de9ddU,
    0x6eab5b3dU,
    0xbaee08acU,
    0x57f06d4U,
    0x3c1d8180U,
    0x563d42c0U,
    0x653e6ae0U,
    0xc1a91790U,
    0x186de878U,
    0x219b5854U,
    0x284607c2U,
    0x49ab0363U,
    0xc5b8952U,
    0x33964099U,
    0xc765e6c6U,
    0x8b3f5c39U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0xf8000000U,
    0xfc000000U,
    0x1e000000U,
    0x2b000000U,
    0x67800000U,
    0xc5400000U,
    0xab200000U,
    0x27900000U,
    0x65680000U,
    0x9b2c0000U,
    0xdfae0000U,
    0x99570000U,
    0x852b8000U,
    0xf4a4c000U,
    0xfecee000U,
    0x405ad000U,
    0x5fae0800U,
    0xd9570400U,
    0x252b8a00U,
    0xc4a4c300U,
    0x6ceef80U,
    0xbc5adfc0U,
    0x41ae09e0U,
    0xf25706b0U,
    0x42ab8c78U,
    0x1e4cf54U,
    0xadeee532U,
    0x9bcaddb9U,
    0x24c60fb6U,
    0x697b0f02U,
    0x9d058182U,
    0x98b3c6c1U,
    0x28c56d60U,
    0x6f6e12f3U,
    0xda08e05aU,
    0x2921db07U,
    0xc2ab8c78U,
    0x41e4cf54U,
    0xdeee532U,
    0xabcaddb9U,
    0xdcc60fb6U,
    0x957b0f02U,
    0x83058182U,
    0xb3b3c6c1U,
    0x4f456d60U,
    0xaa2e12f3U,
    0x7128e05aU,
    0xeb1db07U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x68000000U,
    0x9c000000U,
    0x6000000U,
    0x2f000000U,
    0xf8800000U,
    0x2a400000U,
    0x7f200000U,
    0x30900000U,
    0xc6780000U,
    0x81040000U,
    0xeb8a0000U,
    0xa4df0000U,
    0x82458000U,
    0x4321c000U,
    0x46b12000U,
    0x11571000U,
    0x8d8a0800U,
    0x5bdf0400U,
    0xf2c58e00U,
    0x6561c900U,
    0x57912680U,
    0x92c719c0U,
    0xb5720860U,
    0xdf9b06f0U,
    0x9eef8188U,
    0xdb6ecba4U,
    0x6c8ca172U,
    0x6072dac9U,
    0xde312407U,
    0xeb171ee0U,
    0x7aaa0730U,
    0x674f05e9U,
    0x5abd8756U,
    0x5765c7fbU,
    0x429b2eecU,
    0x33581235U,
    0xb0978188U,
    0x866acba4U,
    0x6106a172U,
    0x7baddac9U,
    0xccf4a407U,
    0x1e76dee0U,
    0x453b2730U,
    0x698815e9U,
    0xe9cf8f56U,
    0xa7fec3fbU,
    0x24f4a0ecU,
    0xc276db35U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0xa8000000U,
    0x44000000U,
    0xc2000000U,
    0x13000000U,
    0xcf800000U,
    0xe2400000U,
    0x71200000U,
    0x6cb00000U,
    0xa5c80000U,
    0xa77c0000U,
    0x77ba0000U,
    0x9e690000U,
    0xf048000U,
    0x2182c000U,
    0x5740e000U,
    0x1fa51000U,
    0xfa720800U,
    0xbd150c00U,
    0x9abe8200U,
    0xdcebc700U,
    0x3fc46a80U,
    0x9867d440U,
    0x1e12e420U,
    0xdd001d30U,
    0xa8486f8U,
    0x24c2c524U,
    0xa3e0ef92U,
    0xb655158bU,
    0x8b1a04fcU,
    0xc3990307U,
    0x346c85a3U,
    0x780ec1f2U,
    0x5c12e19aU,
    0xe001eb7U,
    0xe5048c1aU,
    0xb682c076U,
    0x7ac0ec78U,
    0x9ee51164U,
    0xecd20bb2U,
    0x77e508bbU,
    0x8c568204U,
    0x427c623U,
    0x22366a31U,
    0x4332d479U,
    0x178c6566U,
    0xe5bddb0U,
    0xf708e9b9U,
    0xbd991184U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x18000000U,
    0x7c000000U,
    0x8e000000U,
    0x6f000000U,
    0x52800000U,
    0x1fc00000U,
    0x59200000U,
    0x71b00000U,
    0x2b780000U,
    0x5de40000U,
    0x90160000U,
    0xd8170000U,
    0x9c1f8000U,
    0x9e19c000U,
    0x770da000U,
    0x2ebb7000U,
    0x91ee0800U,
    0x36330c00U,
    0x23298e00U,
    0x34bec100U,
    0x4ea2180U,
    0xe186b7c0U,
    0xf355a0e0U,
    0xc1ef7af0U,
    0xe000328U,
    0xaf000cfcU,
    0xb2800a12U,
    0xfc001dbU,
    0x41200bd7U,
    0xdb004eeU,
    0xa57804c9U,
    0x32e40a8dU,
    0xc296097bU,
    0xc7d70f06U,
    0xc53f8055U,
    0xefa9c02eU,
    0x5c75a2a8U,
    0x735f7b3cU,
    0x1f80af2U,
    0xee240b2bU,
    0xbf3600ffU,
    0xaaa70412U,
    0x73e780dbU,
    0xcf3dca56U,
    0x62bba32cU,
    0xf7dc7c28U,
    0x2d29847cU,
    0x9bbec053U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x8000000U,
    0xf4000000U,
    0xa6000000U,
    0x77000000U,
    0x65800000U,
    0xd3c00000U,
    0x45200000U,
    0xe4900000U,
    0xd9680000U,
    0xbf4c0000U,
    0x28720000U,
    0x5de50000U,
    0x361d8000U,
    0x8f0bc000U,
    0x39a26000U,
    0x31ce7000U,
    0x9c3a0800U,
    0x2390400U,
    0xc9078a00U,
    0x5ea2cb00U,
    0xec4de080U,
    0xb3e0bf40U,
    0x1525e260U,
    0xfcacb370U,
    0x9557e458U,
    0xe549b23cU,
    0xd4a66d2U,
    0xe9427e09U,
    0xf7680576U,
    0x7c4c0cc4U,
    0x4bf2043fU,
    0x49250bd2U,
    0x1ebd8b8bU,
    0x4c5bc3b5U,
    0x3ea6666U,
    0x1d127cedU,
    0x8a00cd8U,
    0x3350097cU,
    0x92480eb2U,
    0x68dc0679U,
    0x3a9a01aeU,
    0xb26901b8U,
    0x98cf808dU,
    0x92bec6abU,
    0xf677eaa5U,
    0x36d9bd4dU,
    0x11a2648bU,
    0x35ce7936U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x48000000U,
    0xf4000000U,
    0x26000000U,
    0x61000000U,
    0x17800000U,
    0x8c00000U,
    0xbb200000U,
    0x4b00000U,
    0xe8580000U,
    0x5d540000U,
    0x1cc20000U,
    0x8d350000U,
    0x4d958000U,
    0xdbe64000U,
    0x3bbee000U,
    0x32d4b000U,
    0xb83a0800U,
    0xcc110c00U,
    0x2a2f8600U,
    0x2b374d00U,
    0xecb16480U,
    0xac53ff40U,
    0xe3536a60U,
    0xc1d6fa10U,
    0x489eef78U,
    0x264b18cU,
    0x16620132U,
    0x20450e0bU,
    0x696d8e65U,
    0x5ac24185U,
    0x3c04e654U,
    0x1205b10fU,
    0x27358473U,
    0xa6964769U,
    0x5746e1f4U,
    0x47f0bb3fU,
    0x998003f8U,
    0x8dc002ccU,
    0xa2a00d52U,
    0x4970091bU,
    0x2af80d9dU,
    0xc4240349U,
    0x7e3a0b06U,
    0xbd110814U,
    0x15af81eeU,
    0x7f74820U,
    0x39916cf2U,
    0x3de3fe2bU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0x78000000U,
    0x74000000U,
    0x7e000000U,
    0x5f000000U,
    0xd0800000U,
    0x75400000U,
    0x7d200000U,
    0x2d900000U,
    0x18f80000U,
    0x85fc0000U,
    0xd86e0000U,
    0xb8950000U,
    0x496b8000U,
    0xef0dc000U,
    0x8bb2000U,
    0x9179d000U,
    0xb360800U,
    0x7eb90400U,
    0xc25d8e00U,
    0xd1b4c700U,
    0x2ae6a780U,
    0x30cd1740U,
    0x59d0afe0U,
    0x3a7411f0U,
    0xe58d2b08U,
    0xb4c0d454U,
    0x1feb8652U,
    0xf14dc699U,
    0x3b1b2fefU,
    0xe6a9ddefU,
    0xc66e08eeU,
    0xd7950a6dU,
    0x1eb87acU,
    0x9e4dc98dU,
    0x739b2c5eU,
    0x97e9d385U,
    0xbd4e0488U,
    0xd1050714U,
    0xb79387b2U,
    0x31f1c069U,
    0x6552b67U,
    0x77acdafbU,
    0x91fd8f5cU,
    0x9664ca04U,
    0x7fbeaccbU,
    0x9de11376U,
    0x9c66a302U,
    0x5e8d1981U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0xc8000000U,
    0x24000000U,
    0x8e000000U,
    0x39000000U,
    0x6a800000U,
    0x60400000U,
    0x5aa00000U,
    0xf8700000U,
    0x96a80000U,
    0xc2540000U,
    0xe99a0000U,
    0xb5dd0000U,
    0x6d798000U,
    0xb6334000U,
    0xa5332000U,
    0xb8b35000U,
    0xab798800U,
    0x6b334c00U,
    0x61b32200U,
    0x71f35900U,
    0x53598480U,
    0xd7034e40U,
    0x23bb2ae0U,
    0x72d75a90U,
    0x46eb8228U,
    0xc0ca4844U,
    0xfdf8af4aU,
    0x89491517U,
    0x18092b42U,
    0xc1e5461U,
    0x1a2809d3U,
    0xef14024aU,
    0xbfba0795U,
    0xa0ed0a02U,
    0x8df18500U,
    0xf1574e81U,
    0x64212b42U,
    0x6e0a5461U,
    0x891209d3U,
    0x32b9024aU,
    0x8c6b8795U,
    0xf08a4a02U,
    0x4f58a500U,
    0xc5391e81U,
    0xc8a12342U,
    0xd34a5861U,
    0x17320bd3U,
    0x3890b4aU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0xf8000000U,
    0xbc000000U,
    0xca000000U,
    0x39000000U,
    0x13800000U,
    0x55400000U,
    0xbba00000U,
    0xd1700000U,
    0x6d880000U,
    0xf2440000U,
    0xbf360000U,
    0x8ab0000U,
    0x9be48000U,
    0x5b754000U,
    0x34986000U,
    0x91ec1000U,
    0xc2648800U,
    0xf7354c00U,
    0x3cb86a00U,
    0xc5dc1d00U,
    0xec4c8780U,
    0x680147c0U,
    0x240666a0U,
    0x6331e90U,
    0xdb1e06b8U,
    0x6e9f0294U,
    0x30da8d1aU,
    0x1dda4387U,
    0x406ae860U,
    0xfa0251b0U,
    0x713064e9U,
    0x2798120dU,
    0xb7a8c5eU,
    0xcaa4ec7U,
    0x8de2e680U,
    0xd8465243U,
    0x36066860U,
    0x933311b0U,
    0x5a9e04e9U,
    0x6edf020dU,
    0xaafa845eU,
    0x1cea42c7U,
    0x4fc2ec80U,
    0xb5765f43U,
    0xbae67e0U,
    0x59471a70U,
    0xf9800849U,
    0x7c40019dU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0xf8000000U,
    0xe4000000U,
    0xfa000000U,
    0xad000000U,
    0xb6800000U,
    0x89c00000U,
    0x92a00000U,
    0x53d00000U,
    0x6fb80000U,
    0x2d5c0000U,
    0xfa460000U,
    0xa1c50000U,
    0xfea88000U,
    0xd5d64000U,
    0xec992000U,
    0x34d23000U,
    0x8c088800U,
    0xf6064400U,
    0x1b212600U,
    0xcd8e3300U,
    0x744e8780U,
    0x1ec34a40U,
    0xa909a9a0U,
    0x3c9879d0U,
    0xbcf7ace8U,
    0xf00172dcU,
    0xd819288aU,
    0xb41238edU,
    0x32288c13U,
    0xb1164309U,
    0xa8b920aeU,
    0xdec238b1U,
    0x89108a59U,
    0x6c8a4784U,
    0x74df2a8fU,
    0xec173d20U,
    0xc6200413U,
    0xe3100709U,
    0x299806aeU,
    0x8e4c0bb1U,
    0xb3de0dd9U,
    0x1f890dc4U,
    0xb576832fU,
    0x2e5f44f0U,
    0xa3efa8fbU,
    0xb78d75d5U,
    0x99672e24U,
    0xc84b335cU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x68000000U,
    0xe4000000U,
    0x86000000U,
    0x9d000000U,
    0xe1800000U,
    0xb0c00000U,
    0xeda00000U,
    0x12f00000U,
    0x16980000U,
    0x7e740000U,
    0x2fc20000U,
    0xc72d0000U,
    0x56b38000U,
    0x5e624000U,
    0xdfe7e000U,
    0xbf387000U,
    0xda938800U,
    0x3c524c00U,
    0xc4dfee00U,
    0xc3bc7100U,
    0x8bc98e80U,
    0x610b4240U,
    0x3bae6660U,
    0xc7f338d0U,
    0xe31de098U,
    0x3091794cU,
    0xd37a00baU,
    0x566905ffU,
    0xebc987f1U,
    0xb10b43abU,
    0xb3ae62c6U,
    0x33f33acdU,
    0xd1dea7aU,
    0x49917cddU,
    0xb4fa09c0U,
    0x7ba900a2U,
    0xe7e98ff1U,
    0x133b4fabU,
    0x48966cc6U,
    0x5f773bcdU,
    0x3447ecfaU,
    0xf0c8729dU,
    0xcd8b81a0U,
    0xe2e64972U,
    0x6ebde1e9U,
    0xf26174a7U,
    0x4de20a1cU,
    0xdc1d06e2U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0xa8000000U,
    0x34000000U,
    0xd2000000U,
    0x59000000U,
    0xd6800000U,
    0xf1400000U,
    0x9aa00000U,
    0x8f500000U,
    0xada80000U,
    0x96cc0000U,
    0xa9420000U,
    0x46a10000U,
    0x49468000U,
    0x56af4000U,
    0xb1672000U,
    0xbaa51000U,
    0xff668800U,
    0x5bf4400U,
    0xa2ef2200U,
    0x7b791700U,
    0x1fac8280U,
    0x9fc24740U,
    0xa7e3af20U,
    0x2beb5290U,
    0x35e72fe8U,
    0x52e51854U,
    0x93468e8aU,
    0xbaf4e65U,
    0x3de72f32U,
    0x56e51238U,
    0xc9468c9eU,
    0x16af4e4fU,
    0x91672c06U,
    0xcaa51182U,
    0x576687c0U,
    0x31bf4f61U,
    0x70ef2732U,
    0x22791638U,
    0xc92c8e9eU,
    0x6e82494fU,
    0x3d43a686U,
    0xa4bb52c2U,
    0x984f2ae0U,
    0xc4291af1U,
    0x3a04825aU,
    0x4d0e4d2cU,
    0x74a1ad34U,
    0x4a52baU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x88000000U,
    0xcc000000U,
    0x5a000000U,
    0x77000000U,
    0x4e800000U,
    0x23400000U,
    0xd4a00000U,
    0xb4500000U,
    0xaa080000U,
    0x8f340000U,
    0x3a8a0000U,
    0xad570000U,
    0xbd948000U,
    0x1bfec000U,
    0xeacd2000U,
    0x41411000U,
    0x379c8800U,
    0x44cac400U,
    0xf8472a00U,
    0xb0161900U,
    0x58080080U,
    0xe43408c0U,
    0x60a0fa0U,
    0xa5170e70U,
    0xf5b48c68U,
    0x37eecef4U,
    0x80e528eaU,
    0x2e651c35U,
    0x3d3e8648U,
    0xf1b9cec7U,
    0x1f1a4e2U,
    0x3ddbd890U,
    0x9fd3a1f9U,
    0x9ce8d18cU,
    0x5c452aa4U,
    0x163514b1U,
    0x6d3686c8U,
    0x998dc607U,
    0xfdfbab42U,
    0x7fccd6e0U,
    0xace72d91U,
    0x44461f78U,
    0x5200024eU,
    0xfb000884U,
    0xb4800080U,
    0xc44008c0U,
    0x12200fa0U,
    0x5b100e70U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x68000000U,
    0xb4000000U,
    0xb6000000U,
    0x9000000U,
    0x40800000U,
    0xb9400000U,
    0x3ea00000U,
    0x54700000U,
    0x30180000U,
    0x482c0000U,
    0x24220000U,
    0xae310000U,
    0xd5378000U,
    0x42af4000U,
    0x67da000U,
    0x770c1000U,
    0xadaf8800U,
    0xb7c34c00U,
    0x22ffae00U,
    0x404d1700U,
    0xd6000e80U,
    0xb9000740U,
    0xc8800560U,
    0x7d400790U,
    0xe0a00288U,
    0xe97000d4U,
    0xc698088aU,
    0xf86c05d7U,
    0x5a020709U,
    0x43010f16U,
    0xdb8f81a8U,
    0x5ef34fa4U,
    0x1247ae52U,
    0x911110a8U,
    0x5cba0a25U,
    0x5b5d0193U,
    0xf1b58989U,
    0x75ee4856U,
    0x7dd224c8U,
    0x79cf5834U,
    0x47d024daU,
    0x8ace5c7cU,
    0x145facafU,
    0x103d1344U,
    0xd8180000U,
    0x3c2c0000U,
    0x72220000U,
    0xd7310000U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0xb8000000U,
    0xe4000000U,
    0x86000000U,
    0x8d000000U,
    0x4b800000U,
    0x8ec00000U,
    0x79a00000U,
    0x1df00000U,
    0xab180000U,
    0xf6b40000U,
    0x8d560000U,
    0xbb5d0000U,
    0xbe5f8000U,
    0x59f24000U,
    0x1d1f6000U,
    0x33a2f000U,
    0x8ae78800U,
    0xefb64c00U,
    0x28d16e00U,
    0x48bf100U,
    0xfe4e0380U,
    0x79e90240U,
    0xed098660U,
    0x9baf49d0U,
    0xd6c0ef38U,
    0x8d90b6acU,
    0x23d8e7faU,
    0xc224b50fU,
    0x3b0ee809U,
    0x8eb9ba87U,
    0x897162cfU,
    0x2d7bf92aU,
    0x8b5604b4U,
    0xf65d0164U,
    0x15df805cU,
    0xc73247f3U,
    0xdcbf6389U,
    0xca52f4c7U,
    0xa7ff8aafU,
    0x940241faU,
    0xee07680cU,
    0x3116f588U,
    0x39b181c6U,
    0x3deb4b2cU,
    0x5b0eecb8U,
    0x5eb9b4ecU,
    0xd171619aU,
    0xd97bfcdfU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x88000000U,
    0xbc000000U,
    0xba000000U,
    0x6b000000U,
    0xbb800000U,
    0x27400000U,
    0x30a00000U,
    0x6cd00000U,
    0xfff80000U,
    0x505c0000U,
    0xa10a0000U,
    0x788b0000U,
    0xf0f88000U,
    0x95dbc000U,
    0x37d6000U,
    0x2eba9000U,
    0x59f28800U,
    0x1150c400U,
    0x2985e600U,
    0x60615b00U,
    0x690fe080U,
    0xa4aa5fc0U,
    0xfad765a0U,
    0x76e199b0U,
    0x4f20d38U,
    0xb3d706b4U,
    0x272862aU,
    0xc610c0bdU,
    0xf125e767U,
    0xb15a01U,
    0xa4f7e102U,
    0x23f65181U,
    0x5a5d6642U,
    0x422a97e1U,
    0x7f2a8052U,
    0x6d9cc26bU,
    0xce57ea5fU,
    0xd4265cb5U,
    0xf6256728U,
    0x3936913cU,
    0xdc808125U,
    0xaec7cde0U,
    0xc0d76150U,
    0x5de193eaU,
    0xdf720c1dU,
    0x24970b54U,
    0xbad2877aU,
    0x16c0c357U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x58000000U,
    0x54000000U,
    0x56000000U,
    0x33000000U,
    0x54800000U,
    0xe4c00000U,
    0x17a00000U,
    0x18700000U,
    0xcf780000U,
    0x5c40000U,
    0xbe1e0000U,
    0xaf290000U,
    0x6e8f8000U,
    0x85dbc000U,
    0x7e23a000U,
    0xcf057000U,
    0x3e918800U,
    0xddf2cc00U,
    0x2a2c2600U,
    0x991eb500U,
    0xd922d80U,
    0x8947b940U,
    0xcee5ab60U,
    0x8e987a30U,
    0x15f80ec8U,
    0x4604020cU,
    0xcb3e079aU,
    0x309902f7U,
    0xbad7895fU,
    0x28afc860U,
    0x4ee5aab3U,
    0x4e987609U,
    0x75f8062dU,
    0x16040bcaU,
    0x933e078eU,
    0x649902d9U,
    0xecd78797U,
    0x1bafca6cU,
    0x1a65ad29U,
    0xaa5874feU,
    0x62580f72U,
    0xe7403aaU,
    0x5c460d3dU,
    0x615d04d0U,
    0x52c989baU,
    0xb486cda6U,
    0x74ea2ca7U,
    0x2f83b327U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x78000000U,
    0xdc000000U,
    0xca000000U,
    0x43000000U,
    0xe3800000U,
    0x9c400000U,
    0xb8a00000U,
    0x73d00000U,
    0x6c80000U,
    0x1c7c0000U,
    0xf8860000U,
    0xd3c30000U,
    0x36e88000U,
    0x6445c000U,
    0x24bb6000U,
    0x19c65000U,
    0x75ee8800U,
    0x87c6c400U,
    0xb8f3ea00U,
    0xa1539300U,
    0x61def80U,
    0x813c99c0U,
    0xa4bb6ea0U,
    0x59c65330U,
    0xd5ee8bb8U,
    0xb7c6c304U,
    0xc0f3eaaaU,
    0x7d539dcdU,
    0xcc1ded74U,
    0xc23c95f3U,
    0x473b649aU,
    0xc58650f5U,
    0x6d4e8330U,
    0xc416c3baU,
    0xc63be705U,
    0x612f90aaU,
    0x349be6ccU,
    0x11ff96f7U,
    0x71d3ee30U,
    0xa1c39d38U,
    0x49f5e644U,
    0xddd09249U,
    0xb3d5699fU,
    0xe6e9535fU,
    0x8c680a7cU,
    0xb0ac0c8dU,
    0x77ce0795U,
    0x20ff0ea2U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0x8000000U,
    0x5c000000U,
    0x3a000000U,
    0x2f000000U,
    0xac800000U,
    0x94c00000U,
    0x5fa00000U,
    0xc2700000U,
    0x44480000U,
    0xa1740000U,
    0x1afa0000U,
    0xe68b0000U,
    0x43f08000U,
    0x9732c000U,
    0xa8a4a000U,
    0x5add7000U,
    0x86aa8800U,
    0x73c9cc00U,
    0xf1c2a00U,
    0xfc9bb900U,
    0x3cf42880U,
    0x939fb9c0U,
    0xf04621a0U,
    0x3760b7f0U,
    0x37cca848U,
    0xa119798cU,
    0x15b884daU,
    0x1546ce17U,
    0x8cdea7acU,
    0xcb967d6bU,
    0x47a05bdU,
    0xc14b0033U,
    0x2ad086e9U,
    0x7e82cdffU,
    0x17cca0d3U,
    0xf1197179U,
    0xbdb887e4U,
    0xd946c8e7U,
    0xbedeab67U,
    0xb8967724U,
    0x92fa09c5U,
    0x7a8b0954U,
    0xd9f084ceU,
    0x2832c6baU,
    0xc24a945U,
    0x921d7c94U,
    0xe30a8f6eU,
    0x9eb9c84aU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x28000000U,
    0xc4000000U,
    0x3a000000U,
    0x9b000000U,
    0xa1800000U,
    0x93400000U,
    0xa0a00000U,
    0xf9f00000U,
    0x2a580000U,
    0x560c0000U,
    0xa5020000U,
    0xe0950000U,
    0xd9d88000U,
    0xba7dc000U,
    0xe07e000U,
    0x49049000U,
    0x1e828800U,
    0x78e4cc00U,
    0x80dd6e00U,
    0x3cec5700U,
    0x7addea80U,
    0x47dd9040U,
    0xab7805a0U,
    0xfcbc02b0U,
    0xcffa0698U,
    0x3f690274U,
    0x7e828b2aU,
    0xc8e4ca6fU,
    0x48dd6b1dU,
    0x88ec55e4U,
    0x68dde242U,
    0x18dd94a2U,
    0x30f80332U,
    0xf4fc0a58U,
    0xceda0495U,
    0x55d904b9U,
    0xf47a8705U,
    0x6718c7d0U,
    0xc7876cc8U,
    0x3e755c7dU,
    0x14076eb7U,
    0x42355dc8U,
    0xe7276dfdU,
    0x7855a74U,
    0xde5f6f2aU,
    0x6439586cU,
    0x6a256a1fU,
    0x23105c66U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x28000000U,
    0xa4000000U,
    0xfe000000U,
    0x3d000000U,
    0x82800000U,
    0xb3400000U,
    0x5a00000U,
    0x42f00000U,
    0x41780000U,
    0xa28c0000U,
    0x63620000U,
    0x3d8d0000U,
    0xbed98000U,
    0x33544000U,
    0xc5ba2000U,
    0x22fe1000U,
    0x31638800U,
    0x8aa54c00U,
    0xc779a600U,
    0xc3ab5700U,
    0x83e22a80U,
    0xb1c21640U,
    0x76d981e0U,
    0x275448d0U,
    0x73ba2ca8U,
    0xcbfe1674U,
    0x65e3853aU,
    0xa0e541bfU,
    0xbe59a5dfU,
    0xf1b55ccU,
    0x45ba24c4U,
    0xe2fe1a83U,
    0x51638e40U,
    0xfaa545e2U,
    0xef79a2d2U,
    0x67ab5dabU,
    0x7de22bf7U,
    0x8cc219f8U,
    0xf459861eU,
    0x941444ecU,
    0x761a2db7U,
    0x890e101aU,
    0x249b82ccU,
    0x2694e47U,
    0xdd3bacc0U,
    0x32965fa2U,
    0xfb63a532U,
    0xd1aa527bU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x88000000U,
    0x5c000000U,
    0xea000000U,
    0x43000000U,
    0x40800000U,
    0xfc400000U,
    0x9da00000U,
    0x19f00000U,
    0x90580000U,
    0xdf8c0000U,
    0x96ea0000U,
    0xc2d30000U,
    0xb4d48000U,
    0xfdcdc000U,
    0x8e49a000U,
    0xba835000U,
    0x87468800U,
    0xe922cc00U,
    0x238f2e00U,
    0x2ce19700U,
    0x99e9a080U,
    0x507359c0U,
    0x3f9e88a0U,
    0xe6eecf30U,
    0x4ac52288U,
    0xe8c29d04U,
    0x17e527faU,
    0xcd729c6fU,
    0xfa1d25adU,
    0x7b0e9d0cU,
    0x74af2a3cU,
    0x3a519cb6U,
    0xbc91abb2U,
    0x464f594bU,
    0xc68c8ca7U,
    0xfd41cf49U,
    0x5223afa5U,
    0xb71055c8U,
    0x66b20b66U,
    0xad5f08e9U,
    0x4a3e8417U,
    0x131ecc83U,
    0x589d27c1U,
    0x584e97a0U,
    0xa38f23b2U,
    0xece1954bU,
    0x79e9a2a7U,
    0x20735849U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0x58000000U,
    0x9c000000U,
    0x2a000000U,
    0xcf000000U,
    0x3d800000U,
    0x4c400000U,
    0xca00000U,
    0x70d00000U,
    0xb4780000U,
    0x60840000U,
    0xb2de0000U,
    0x6f6b0000U,
    0xb3188000U,
    0x878ac000U,
    0xbb4ee000U,
    0x7d285000U,
    0x4e9e8800U,
    0xebf5c400U,
    0x7d06600U,
    0x85dd9d00U,
    0x3eceed80U,
    0x3d685dc0U,
    0x503e8ca0U,
    0x1825c5f0U,
    0xfc286058U,
    0xfa199004U,
    0x9730efeaU,
    0xa193563dU,
    0x667e043fU,
    0xc3bb073cU,
    0x4d608bbfU,
    0xf80ec1ffU,
    0x6c10e79cU,
    0xc2035c4dU,
    0xdb2602a6U,
    0xd3af0b18U,
    0x356681e7U,
    0xd431cef8U,
    0xce2e6ef5U,
    0xc9269f32U,
    0x508e667bU,
    0x7af692b5U,
    0xcb766c53U,
    0xd532942aU,
    0x3a88679cU,
    0xd5c99c4dU,
    0x26c8e2a6U,
    0xc1575b18U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0xe8000000U,
    0xc000000U,
    0xbe000000U,
    0x2f000000U,
    0x73800000U,
    0x12400000U,
    0x3a600000U,
    0x16700000U,
    0x58680000U,
    0xf4c0000U,
    0x98f60000U,
    0x38b50000U,
    0x93fa8000U,
    0xd9014000U,
    0xe0b5a000U,
    0xc7dd3000U,
    0x7335a800U,
    0x59d3400U,
    0xc155ae00U,
    0x8fed3d00U,
    0xcf3da080U,
    0xa3a13dc0U,
    0x9a4bab60U,
    0xa6543f30U,
    0x40512c58U,
    0x7b657e14U,
    0xc2ec8ffeU,
    0xa5844f73U,
    0x71472278U,
    0x97e07b87U,
    0xbb1e05f7U,
    0xf9b9050cU,
    0x76c8c48U,
    0x44c4455cU,
    0xea72123U,
    0x20d07211U,
    0xfc960c48U,
    0xd1c5055cU,
    0x30128123U,
    0x580d4211U,
    0x1423a448U,
    0xca18315cU,
    0x75272f23U,
    0xee907f11U,
    0xf0f604c8U,
    0x74b50c9cU,
    0x4dfa8443U,
    0x66014021U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x8000000U,
    0x74000000U,
    0xea000000U,
    0x15000000U,
    0xdc800000U,
    0x40c00000U,
    0xe8e00000U,
    0xccd00000U,
    0xed80000U,
    0xfffc0000U,
    0xc17e0000U,
    0xe0a30000U,
    0x3ef98000U,
    0xa7ecc000U,
    0x9d63e000U,
    0xee9fd000U,
    0xc9e3e800U,
    0x1a5fdc00U,
    0xeb03ea00U,
    0x538fd500U,
    0x315bea80U,
    0x98b3d240U,
    0xf2c5e420U,
    0xa1c0d310U,
    0x1e6469e8U,
    0xb910171cU,
    0xaa998766U,
    0x7bfccbd1U,
    0x535bef8bU,
    0x39b3d82eU,
    0xe445e99cU,
    0x6400d324U,
    0x220468f3U,
    0x4100171aU,
    0xa6a18f05U,
    0x5dd0cfe3U,
    0x407de8f3U,
    0x662cd71aU,
    0xf3226f05U,
    0xef9f1fe3U,
    0x8f4600f3U,
    0xf78f0b1aU,
    0x335f8505U,
    0x49b3cae3U,
    0x5c646a73U,
    0x8810195aU,
    0xb4198125U,
    0xca3cc9f3U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xa8000000U,
    0x9c000000U,
    0xfa000000U,
    0xd3000000U,
    0xdb800000U,
    0xb4c00000U,
    0x88e00000U,
    0x62d00000U,
    0x39d80000U,
    0xae6c0000U,
    0x48860000U,
    0x8f410000U,
    0xcc2f8000U,
    0x92034000U,
    0x6f39a000U,
    0xf1829000U,
    0xcfd9a800U,
    0xcf529c00U,
    0x2c01aa00U,
    0x623e9100U,
    0x1707a080U,
    0xc5bf98c0U,
    0xa9c82f20U,
    0xe66cd5f0U,
    0x24a98298U,
    0xd424ebcU,
    0x2b162216U,
    0x2f81d491U,
    0xf2e00b8bU,
    0x71d00f77U,
    0xc2580f83U,
    0xcaac0f43U,
    0x68660461U,
    0x71910f93U,
    0xff78a0aU,
    0xef6f4f37U,
    0xfc3fac61U,
    0xca039393U,
    0x8b16200aU,
    0x3f81de37U,
    0x7ae00ce1U,
    0x3dd00b53U,
    0x90580f2aU,
    0x85ac0bc7U,
    0x49e60e79U,
    0x165105efU,
    0x5c978d3cU,
    0x397f4f56U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x88000000U,
    0xfc000000U,
    0xe6000000U,
    0x59000000U,
    0x18800000U,
    0xc1400000U,
    0x95600000U,
    0x1f700000U,
    0xf8480000U,
    0xfdc40000U,
    0xb6260000U,
    0xa1390000U,
    0x8c908000U,
    0xeb7ec000U,
    0xa254e000U,
    0xa2d6b000U,
    0xc7b4e800U,
    0xf0e6b400U,
    0x249ce600U,
    0x8752b700U,
    0x1c72ee80U,
    0xbfefb8c0U,
    0x4d2460e0U,
    0x72987d50U,
    0x16480168U,
    0x18c40144U,
    0xa8a6003eU,
    0x97904b3U,
    0x897081baU,
    0xc94ec86fU,
    0x297ce258U,
    0x1962bdbcU,
    0x915aecf1U,
    0x6d5bb29bU,
    0x8b4a695cU,
    0xd26577a2U,
    0xcafe84f1U,
    0xb83c69bU,
    0x9ee26f5cU,
    0x819170a2U,
    0x79f08271U,
    0x840eca5bU,
    0x321ce9bcU,
    0x9312baf2U,
    0x1f92ed99U,
    0xf4dfb3dfU,
    0x568c6962U,
    0xf46c7311U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0x58000000U,
    0x84000000U,
    0xca000000U,
    0x6b000000U,
    0x1f800000U,
    0x12400000U,
    0x98600000U,
    0xd3500000U,
    0xfce80000U,
    0x669c0000U,
    0x22ea0000U,
    0xbf9b0000U,
    0xe2418000U,
    0xf0474000U,
    0xdf6aa000U,
    0xead53000U,
    0x4382a800U,
    0x9c493c00U,
    0xd968a600U,
    0x77d23100U,
    0xa9292380U,
    0x68957940U,
    0xa3c38f20U,
    0xfb004ff0U,
    0x67a126d8U,
    0xa65972d4U,
    0xda41895eU,
    0x64474ee1U,
    0xad6aa510U,
    0xd5d531c8U,
    0xce02a81eU,
    0x610935c1U,
    0x9488a0e2U,
    0xddc23811U,
    0xd2212c4aU,
    0xcf19745dU,
    0xe5a18362U,
    0xf1574151U,
    0x5be2a36aU,
    0x8f193badU,
    0xc580a5baU,
    0xc14e3385U,
    0xd3c32a34U,
    0x530e754cU,
    0x8b8200aaU,
    0x6047024dU,
    0xa74b822aU,
    0x5ecc408dU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x68000000U,
    0xe4000000U,
    0x7e000000U,
    0x87000000U,
    0xda800000U,
    0x2c400000U,
    0x62600000U,
    0x3d700000U,
    0x9bd80000U,
    0x158c0000U,
    0x2f60000U,
    0xf83f0000U,
    0x6c388000U,
    0x6a354000U,
    0xc125e000U,
    0xd199f000U,
    0x6cfde800U,
    0xb715f400U,
    0x28be200U,
    0x506af100U,
    0xc0536480U,
    0x486fbf40U,
    0x5c4e8360U,
    0x1a4a4730U,
    0x117d66c8U,
    0x51dcb1f4U,
    0x848002eeU,
    0xbb400323U,
    0x70e00fd3U,
    0xa5300d3bU,
    0xefb8049cU,
    0x4bfc0188U,
    0x3dae0e97U,
    0x46f303dfU,
    0xd62e8eebU,
    0x833a47a5U,
    0x54a56a17U,
    0x9350bc9fU,
    0x34f60d8bU,
    0x8b3f0095U,
    0xb88cdfU,
    0x75754d6bU,
    0x6fc5ef65U,
    0xa3a9f3b6U,
    0x31c5eb0cU,
    0x34a9f450U,
    0x2345e9f9U,
    0xace9f33eU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0xd8000000U,
    0xfc000000U,
    0xba000000U,
    0x2f000000U,
    0xd0800000U,
    0x78c00000U,
    0xaae00000U,
    0x81f00000U,
    0x7680000U,
    0x42b40000U,
    0x33e20000U,
    0x5c6d0000U,
    0x1c0b8000U,
    0x8a244000U,
    0x972a6000U,
    0x5ca55000U,
    0x1ac26800U,
    0x79d15400U,
    0xeb406e00U,
    0x508c5300U,
    0x38c3e380U,
    0xcaec1cc0U,
    0xf1e38820U,
    0xdf504e30U,
    0xbea86d28U,
    0x89f85dbcU,
    0x7341e986U,
    0xccb116a3U,
    0xf2e00270U,
    0x3df00a48U,
    0xdd680f6eU,
    0x1db406beU,
    0x3b620e06U,
    0xd8ad0c60U,
    0xceb8d52U,
    0x24d449f9U,
    0x40c26d86U,
    0x66d150a0U,
    0x83c06572U,
    0xa44c57c9U,
    0xf023e8aeU,
    0x981c191cU,
    0x9c0b82f4U,
    0xca24426aU,
    0xf72a615eU,
    0x2ca55b94U,
    0xc2c26bbaU,
    0x85d159e4U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xb8000000U,
    0x74000000U,
    0x2000000U,
    0xbf000000U,
    0x18800000U,
    0x5c00000U,
    0x5be00000U,
    0x6af00000U,
    0xdb680000U,
    0x6b2c0000U,
    0x2aa20000U,
    0x72ef0000U,
    0x9f578000U,
    0xa12c4000U,
    0x49bc6000U,
    0xa4741000U,
    0x53b46800U,
    0x5f681400U,
    0x811e6e00U,
    0x399b1500U,
    0xc63e580U,
    0x9f845240U,
    0x294205a0U,
    0x3c1f09b0U,
    0x9e3f8c28U,
    0x11004decU,
    0xc19e6f96U,
    0x185b1a43U,
    0x8d83e1a0U,
    0x2e745fb1U,
    0x50aa052aU,
    0x99f3026fU,
    0xf5fd8ed7U,
    0xb3df4b61U,
    0xc6c1e9d2U,
    0xbd6b5d79U,
    0x6e158357U,
    0xf9334d21U,
    0x6d83e272U,
    0x7e7451c9U,
    0x88aa02ffU,
    0xfdf3068dU,
    0x4ffd8644U,
    0x78df473aU,
    0xdc41e2f7U,
    0x7ab5290U,
    0x2d758758U,
    0x960343a6U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0xc8000000U,
    0xdc000000U,
    0x12000000U,
    0x65000000U,
    0x6d800000U,
    0x97c00000U,
    0xc1e00000U,
    0x72f00000U,
    0xec680000U,
    0x85140000U,
    0xdd860000U,
    0x3fe10000U,
    0xeddd8000U,
    0xa8e8c000U,
    0x5559a000U,
    0xfab75000U,
    0x2f51a800U,
    0x93935400U,
    0x8dfae00U,
    0x85565b00U,
    0xa28c2280U,
    0xcb7b96c0U,
    0x958603a0U,
    0xa3e10090U,
    0x9fdd8d78U,
    0x3de8cdecU,
    0xf0d9a766U,
    0xb17755c3U,
    0xfcb1ad20U,
    0x84635452U,
    0x8937a7d8U,
    0x97825efcU,
    0xbeea235dU,
    0x866a90ceU,
    0x94338b36U,
    0x8e1dce1aU,
    0x170229ddU,
    0xf8be920eU,
    0x32558696U,
    0x8a0cc58aU,
    0xa137ae25U,
    0xfb825d22U,
    0x4ea2c50U,
    0xcf6a9bd9U,
    0x23b384fdU,
    0xa0ddc65cU,
    0xa962214eU,
    0x788e9b76U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0x38000000U,
    0x4c000000U,
    0x66000000U,
    0xfb000000U,
    0xc4800000U,
    0x4cc00000U,
    0x47e00000U,
    0x7b500000U,
    0x5b980000U,
    0xa640000U,
    0xb23a0000U,
    0x61310000U,
    0x418c8000U,
    0x4f684000U,
    0x91b86000U,
    0xc77fd000U,
    0xc5826800U,
    0x9d4edc00U,
    0x608eea00U,
    0xeee69b00U,
    0x8ed68980U,
    0x1ec94fc0U,
    0x76cce7e0U,
    0x72e39c70U,
    0x60f801a8U,
    0xb1f403bcU,
    0xe8420c56U,
    0x9b050bc9U,
    0x54ae8e0fU,
    0x24fd471fU,
    0x43eeec84U,
    0x69769eb0U,
    0x8aae8ecaU,
    0x53fd4a8fU,
    0xc16ee05eU,
    0xaeb69e27U,
    0x31ce8f62U,
    0x286d4933U,
    0xbb16ec08U,
    0x248295eeU,
    0x1cec816dU,
    0xff84e2cU,
    0xf40608cU,
    0x718bdb5eU,
    0x974067a7U,
    0x8d8bd8a3U,
    0xe9406ad2U,
    0x4a8bde79U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0xc8000000U,
    0xdc000000U,
    0x22000000U,
    0x4b000000U,
    0xa8800000U,
    0xc00000U,
    0xbfe00000U,
    0x19500000U,
    0xd8880000U,
    0x68e40000U,
    0x33c60000U,
    0xc3590000U,
    0x87858000U,
    0x3e494000U,
    0x5a366000U,
    0x9f01d000U,
    0x36906800U,
    0x59c8dc00U,
    0x947dee00U,
    0x6d359f00U,
    0x45858280U,
    0x854942c0U,
    0x5ab668a0U,
    0x73c1da70U,
    0x63706c28U,
    0xd798d57cU,
    0xc675ed56U,
    0x4e119a29U,
    0x61238e7eU,
    0x5f8045d7U,
    0xba5bedeaU,
    0x3c3c915eU,
    0xd2080ae4U,
    0xe3240c23U,
    0x44a60bb1U,
    0xeac90008U,
    0x28ed8eccU,
    0x93fd455fU,
    0x937868e7U,
    0x7fbcd521U,
    0x2a53ea32U,
    0xa4189e48U,
    0xf62e03adU,
    0xd52d010fU,
    0xf1ab8e7eU,
    0x2b6445d7U,
    0xcb9dedeaU,
    0x8465915eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0xc8000000U,
    0x44000000U,
    0x82000000U,
    0x2d000000U,
    0xef800000U,
    0x67400000U,
    0x48600000U,
    0xcaf00000U,
    0x62380000U,
    0x9d2c0000U,
    0xd78e0000U,
    0x3b570000U,
    0x46638000U,
    0x21cac000U,
    0x22a82000U,
    0x38c57000U,
    0x171e2800U,
    0xdebe7400U,
    0xa6f3aa00U,
    0x1423b900U,
    0xa380680U,
    0x492c0d40U,
    0xbd8e06a0U,
    0x82570b90U,
    0xe3e38a58U,
    0x2f8ac0e4U,
    0x748225eU,
    0xb875780bU,
    0xd2c6245dU,
    0xee227709U,
    0x5b25a5ddU,
    0x78a8bfc8U,
    0xf9ed89bdU,
    0xce9dc53bU,
    0xecbad94U,
    0xa00fb9b5U,
    0x90360565U,
    0xe83b089fU,
    0x940d896aU,
    0x4a2dca2eU,
    0x6913ab60U,
    0x6d93bf72U,
    0x4a600ee9U,
    0xa7f00dedU,
    0xadb80680U,
    0x2a6c0d40U,
    0x57ee06a0U,
    0xb5a70b90U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xd8000000U,
    0xc4000000U,
    0xc6000000U,
    0xa1000000U,
    0x6a800000U,
    0xb5c00000U,
    0xcae00000U,
    0x65700000U,
    0xec080000U,
    0x9a340000U,
    0x43120000U,
    0x7d9b0000U,
    0xa6768000U,
    0xd188c000U,
    0xdc536000U,
    0xe2879000U,
    0x79c96800U,
    0x80e89400U,
    0x6e4de600U,
    0xfd8b5300U,
    0xe6600b80U,
    0x31b00f40U,
    0xac680fe0U,
    0x3a840150U,
    0xbdfa0748U,
    0x46df0d0cU,
    0xcf6c8666U,
    0x9727c71bU,
    0x53b7e4c6U,
    0xfb5454a8U,
    0xc90c8e5fU,
    0xd697cc2dU,
    0x27dfee96U,
    0x5d05462U,
    0xb2f68613U,
    0x3148cca9U,
    0x8233625eU,
    0x2737962eU,
    0x2ba16f95U,
    0xaf6c9ae2U,
    0xa737e9d0U,
    0x6b945b8aU,
    0x4f6c81acU,
    0xd727c2d4U,
    0xb3b7e800U,
    0x8b545400U,
    0x110c8600U,
    0x1297c300U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0xb8000000U,
    0x14000000U,
    0x56000000U,
    0x29000000U,
    0x7d800000U,
    0xd6400000U,
    0xe1600000U,
    0x69d00000U,
    0x88380000U,
    0x7c1c0000U,
    0x5a020000U,
    0x7b2f0000U,
    0xbabe8000U,
    0x96dac000U,
    0x1ca0a000U,
    0x77d0b000U,
    0x7d1aa800U,
    0x4ba3bc00U,
    0x4f462200U,
    0x34c67d00U,
    0x13800980U,
    0x2b400c40U,
    0x6ae004e0U,
    0x869002d0U,
    0xacd80938U,
    0xd78c0eb4U,
    0x655a0caeU,
    0x47e30969U,
    0x1504814dU,
    0x47a9cc38U,
    0x1d7c2335U,
    0xf3f576eeU,
    0x533c8e88U,
    0xd6b5c51eU,
    0x74fe25c1U,
    0x739a78a2U,
    0x9b620e30U,
    0xc2ff07eaU,
    0x2a868d8fU,
    0xeec6c31bU,
    0xa8a2ae45U,
    0x31ffb966U,
    0xec242014U,
    0x2239719cU,
    0xcf068000U,
    0xfc86c000U,
    0x7c2a000U,
    0x752fb000U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x58000000U,
    0xf4000000U,
    0x4e000000U,
    0x57000000U,
    0xbf800000U,
    0xd0c00000U,
    0xf5e00000U,
    0x4f500000U,
    0xf5080000U,
    0xf2b40000U,
    0x66520000U,
    0xe5970000U,
    0x79c88000U,
    0x25434000U,
    0xa425a000U,
    0xc6301000U,
    0xeb1fa800U,
    0x2d831c00U,
    0x65ed2e00U,
    0xa7735b00U,
    0x393a0b80U,
    0x38b30440U,
    0x27728760U,
    0xf9304d30U,
    0x58b72a98U,
    0x5750573cU,
    0xa1208846U,
    0xaca74089U,
    0x197fadf6U,
    0xf61311d2U,
    0x13052bebU,
    0xc99756c7U,
    0x3e00449U,
    0x5c500d56U,
    0x3c8803c3U,
    0xf1740522U,
    0x3a320d51U,
    0xd907022aU,
    0x88a082e5U,
    0x1f67439bU,
    0x7d1fa9bfU,
    0x4e831c84U,
    0xf46d2828U,
    0x50b353e5U,
    0x2b5a0918U,
    0x53230f7cU,
    0x699a8126U,
    0x13d446b9U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x68000000U,
    0x1c000000U,
    0x3a000000U,
    0x7000000U,
    0xfc800000U,
    0xe6c00000U,
    0xd2600000U,
    0xf8b00000U,
    0xe8c80000U,
    0x93440000U,
    0xc9160000U,
    0x9d950000U,
    0x476d8000U,
    0x3f094000U,
    0x58b3e000U,
    0x38d71000U,
    0x6b5e6800U,
    0x4d1e5400U,
    0xd38d8e00U,
    0x66794b00U,
    0xfe9be080U,
    0x45e31ec0U,
    0xf0e06d20U,
    0xa77f55b0U,
    0x8f3e0268U,
    0x50a1051cU,
    0xd4d3826eU,
    0x39684f27U,
    0x5600668aU,
    0x150f570fU,
    0x87960675U,
    0xd0550af1U,
    0x5b8d8c09U,
    0xca7944ceU,
    0xcc9be4d7U,
    0xaee31702U,
    0x5e606a83U,
    0x5abf53c1U,
    0x9bde02a2U,
    0x49d10df3U,
    0x12fb8e8aU,
    0xb45c430fU,
    0xa5be6875U,
    0xe36e51f1U,
    0xe1258489U,
    0xe18d4e0eU,
    0x8d45e7f7U,
    0x503219b2U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x28000000U,
    0x7c000000U,
    0x5e000000U,
    0x9d000000U,
    0xde800000U,
    0x7d400000U,
    0xfbe00000U,
    0x2900000U,
    0x13480000U,
    0xbedc0000U,
    0x981e0000U,
    0x641d0000U,
    0xfa348000U,
    0x873ec000U,
    0x4985e000U,
    0x1ce07000U,
    0x9b316800U,
    0xc79ebc00U,
    0x49d48600U,
    0x29aecd00U,
    0xcccdec80U,
    0x533c76c0U,
    0xabaf6f60U,
    0x3fc3b210U,
    0xc8800e08U,
    0x4c400304U,
    0xb3600ed6U,
    0x8ed0013dU,
    0x402809eaU,
    0x200c05d4U,
    0xf03600bdU,
    0x381103a8U,
    0x54028474U,
    0x222fc9cfU,
    0xc30765b1U,
    0x438fb279U,
    0xa3d60d9eU,
    0x86810c1bU,
    0xf94a850cU,
    0x11f3c1d1U,
    0xad9961eaU,
    0x26d2b9d4U,
    0xfc0286bdU,
    0x9e2fcea8U,
    0x7d0768f4U,
    0xce8fbf0fU,
    0x55560ad1U,
    0x87c10069U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x8000000U,
    0xac000000U,
    0x12000000U,
    0x93000000U,
    0x39800000U,
    0x97400000U,
    0x82e00000U,
    0x47b00000U,
    0x36480000U,
    0x38640000U,
    0x916e0000U,
    0x87c10000U,
    0x431b8000U,
    0x61b64000U,
    0x2347a000U,
    0x44fa3000U,
    0x62bc2800U,
    0x22fc7400U,
    0x17b38e00U,
    0x2e624300U,
    0xec61a680U,
    0x275f3dc0U,
    0xaac9a9a0U,
    0xfb8b37f0U,
    0x5c6facb8U,
    0xf6e3344U,
    0x16fa2536U,
    0x91a974cfU,
    0x6b6e04eaU,
    0x88c1070dU,
    0x9b8e4aU,
    0xb9f6467eU,
    0x8227a731U,
    0xab0a3098U,
    0xfd9427f7U,
    0x596871edU,
    0xbf58bdbU,
    0x41374395U,
    0x8abc27bdU,
    0xbefc7493U,
    0x6db38a6aU,
    0x61624ecdU,
    0xcfe1a9eaU,
    0x8f1f328eU,
    0x3a9ad09U,
    0xb87b3e1cU,
    0xd147ab61U,
    0xe7fa32d2U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x28000000U,
    0x4000000U,
    0xee000000U,
    0xd3000000U,
    0xe3800000U,
    0xfa400000U,
    0x65e00000U,
    0x9d900000U,
    0xa1680000U,
    0x324c0000U,
    0x71ee0000U,
    0x3b830000U,
    0xa6668000U,
    0x17c94000U,
    0x5ca32000U,
    0x53def000U,
    0x12a5a800U,
    0x30c7bc00U,
    0x90e8e00U,
    0xe6854100U,
    0x86cd2480U,
    0x461dfd40U,
    0x17232460U,
    0x6d9ef170U,
    0xf945aed8U,
    0xae57b394U,
    0x63e684e6U,
    0x2a89473dU,
    0x7cc32628U,
    0x330efa8dU,
    0xf3ada750U,
    0xb25bbe48U,
    0xb1e885feU,
    0x5b9a4889U,
    0x764da95cU,
    0x3fcbbc58U,
    0x58808bd6U,
    0xbdd64e04U,
    0xc1a3a00cU,
    0xd348b310U,
    0xf36602a8U,
    0x835f07cdU,
    0x1b608330U,
    0xe7464f38U,
    0x254bab26U,
    0x1c44bb1dU,
    0xc2e80dbaU,
    0x80c0b65U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x68000000U,
    0x4c000000U,
    0x6000000U,
    0xf3000000U,
    0x25800000U,
    0xd2c00000U,
    0x51600000U,
    0xb00000U,
    0x2c480000U,
    0x8a2c0000U,
    0xd51e0000U,
    0xe6910000U,
    0xcf468000U,
    0xa7874000U,
    0x1bf6a000U,
    0xd9c45000U,
    0x70f82800U,
    0xa86f1400U,
    0xb0108e00U,
    0x783a4100U,
    0x442e2080U,
    0x1a1211c0U,
    0x9d280ee0U,
    0x9a9c0ff0U,
    0xf1560438U,
    0x70bd071cU,
    0x745881ceU,
    0xfe1649e7U,
    0xf73027b2U,
    0x5f831799U,
    0x1fee85cdU,
    0xa3db4fe7U,
    0xbdc0a2b3U,
    0x5ac9511aU,
    0xd68a10fU,
    0xe955f86U,
    0xc35ea581U,
    0xc1985743U,
    0xb8ce2a22U,
    0x94621f91U,
    0xee00030aU,
    0xff000145U,
    0x43800ae3U,
    0x71c009f0U,
    0x1ce00139U,
    0x9e70019fU,
    0x7b28050cU,
    0x799c0986U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x8000000U,
    0x4c000000U,
    0xb6000000U,
    0xf9000000U,
    0xb2800000U,
    0x93400000U,
    0x87e00000U,
    0x55900000U,
    0xc4c80000U,
    0x88040000U,
    0x8c2e0000U,
    0x56290000U,
    0x89228000U,
    0xba91c000U,
    0xdf41e000U,
    0x31c5f000U,
    0xacab6800U,
    0x76503c00U,
    0x1b448600U,
    0xbfccb00U,
    0x3ad6e80U,
    0x4ded33c0U,
    0x328003e0U,
    0x53400750U,
    0x67e00e48U,
    0x259001a4U,
    0xccc803d6U,
    0xc40408adU,
    0x3a2e0f52U,
    0xaf290249U,
    0x3ba28fa6U,
    0x29d1c4d6U,
    0x58a1e82eU,
    0x6455fb92U,
    0x6863612aU,
    0xfe543c35U,
    0x976a89fcU,
    0x5dd5ca1bU,
    0x8a8fed6cU,
    0xf77cffb3U,
    0xedc1ef9aU,
    0x6285f02dU,
    0xcb4b6f90U,
    0x53c03b2bU,
    0xd78c8134U,
    0xcff8c47fU,
    0x39836b5aU,
    0xe2c43b4eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x8000000U,
    0x64000000U,
    0xda000000U,
    0xc5000000U,
    0x8b800000U,
    0x66c00000U,
    0x9f600000U,
    0x88b00000U,
    0x6e580000U,
    0xb10c0000U,
    0x19b60000U,
    0xe7d30000U,
    0x5eeb8000U,
    0x2375c000U,
    0x1eb2a000U,
    0x8571d000U,
    0x2d812800U,
    0x55c81400U,
    0x4fe58a00U,
    0xeadacd00U,
    0xd1572280U,
    0x2fab1f40U,
    0xdcd60520U,
    0xea630e10U,
    0x9b338718U,
    0x64b9c33cU,
    0x9064a1ceU,
    0x8e12d8a7U,
    0xc732aab3U,
    0x2b1dbcbU,
    0xc36125c6U,
    0xeeb81e01U,
    0x3d5d8703U,
    0xd1a6cf81U,
    0xe3d92dc0U,
    0x34c41260U,
    0x7e538f30U,
    0xf909cb0aU,
    0x5dbcad26U,
    0xadded271U,
    0x93e4a72bU,
    0xccd2d3b7U,
    0xa252ab28U,
    0xdf01d5b6U,
    0x2eb92028U,
    0x5d741c36U,
    0x618b86e8U,
    0x7bc5c7d6U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0xb8000000U,
    0xe4000000U,
    0x76000000U,
    0x87000000U,
    0x5f800000U,
    0x12c00000U,
    0xf3600000U,
    0xfa900000U,
    0xe4780000U,
    0xd140000U,
    0x7aa20000U,
    0x245f0000U,
    0x2d388000U,
    0x8aa24000U,
    0x9c472000U,
    0xc912d000U,
    0xfc87a800U,
    0x1b649c00U,
    0x96828a00U,
    0xee794300U,
    0xe825a980U,
    0x6c3b9140U,
    0xa3a04e0U,
    0xe51b0a30U,
    0x16828098U,
    0x2e79465cU,
    0xc825a14eU,
    0x9c3b90c5U,
    0xb23a0e11U,
    0x11b0b08U,
    0x60828e15U,
    0xa9794cb8U,
    0x97a5a1cfU,
    0x8efb9b06U,
    0x415a0a30U,
    0xfb8b009aU,
    0x84fa865eU,
    0xa46d414eU,
    0xed07a0c5U,
    0xaaa49612U,
    0x6c628f09U,
    0x71294014U,
    0x18bda1bbU,
    0x6d7f954dU,
    0x118006c6U,
    0xb1c00712U,
    0xfae0018bU,
    0x9f5006d7U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0xe8000000U,
    0x54000000U,
    0x4e000000U,
    0xfd000000U,
    0xbf800000U,
    0x57400000U,
    0x32e00000U,
    0x36b00000U,
    0x16f80000U,
    0xd0b40000U,
    0x1fd60000U,
    0xd1270000U,
    0x5daa8000U,
    0x87ec000U,
    0x7259a000U,
    0xd163b000U,
    0x2beb2800U,
    0x8f197400U,
    0x189c8200U,
    0xfbe9cb00U,
    0xd70b2480U,
    0x4a97a40U,
    0x11e48260U,
    0x8c1dce90U,
    0x123d2518U,
    0xb73e75a4U,
    0x14b60e56U,
    0xa9d7075fU,
    0xc0328ca1U,
    0xe03aceb0U,
    0x5017a5eaU,
    0x1800b02dU,
    0xbc0fabe9U,
    0x1a04b52eU,
    0xb321aa68U,
    0x4297beeeU,
    0xe8dd2bc8U,
    0x658e75deU,
    0x44e0fe2U,
    0x20630b53U,
    0xc66481b9U,
    0xcf5dcf14U,
    0xcedd29bcU,
    0x8c8e7c72U,
    0x55ce03c8U,
    0x7a2301deU,
    0xa3048de2U,
    0xfaadc053U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x98000000U,
    0xb4000000U,
    0x7a000000U,
    0x97000000U,
    0x63800000U,
    0xf5400000U,
    0x70e00000U,
    0xd4900000U,
    0x66e80000U,
    0x2dac0000U,
    0xd8420000U,
    0xe4730000U,
    0x12778000U,
    0x7b554000U,
    0x3dcc2000U,
    0x10013000U,
    0x3833a800U,
    0x84287c00U,
    0xb2358e00U,
    0xbb264900U,
    0xadbbaf80U,
    0x18547e40U,
    0x847f8620U,
    0x42694e30U,
    0xe3662798U,
    0x89de3324U,
    0x6a0620b6U,
    0xaf0e355dU,
    0xe78e28c0U,
    0x47723fe3U,
    0xcbc42a52U,
    0x793d3189U,
    0x7e99ab8dU,
    0xa9f77f8bU,
    0x9a00028dU,
    0x700000bU,
    0x9b8004cdU,
    0x11400228U,
    0x92e000ffU,
    0xf79006b2U,
    0x7f680f58U,
    0x4fec0cc7U,
    0xcb220ae4U,
    0xc5a304d4U,
    0x47f834dU,
    0x82694068U,
    0x836628dfU,
    0xd9de3182U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x48000000U,
    0xf4000000U,
    0xd6000000U,
    0x8d000000U,
    0x46800000U,
    0x400000U,
    0x3be00000U,
    0x25100000U,
    0x2980000U,
    0xee5c0000U,
    0xdac60000U,
    0x9bf0000U,
    0xadd08000U,
    0xc82ac000U,
    0x3424e000U,
    0x7616b000U,
    0x5d326800U,
    0xe837c00U,
    0xf4460200U,
    0xedff0100U,
    0xa8308e80U,
    0x443ac240U,
    0xee3ce9e0U,
    0xe10ab790U,
    0x2c946108U,
    0xaf6c74d4U,
    0x266e85d6U,
    0xeed9c355U,
    0x7faa6d17U,
    0xf0df7ef4U,
    0xc6800c65U,
    0xc04005eeU,
    0x9be00479U,
    0xf51009cdU,
    0x4a980ac9U,
    0x1a5c06f6U,
    0xcc60866U,
    0x84bf03edU,
    0xeb50837aU,
    0xc86ac04dU,
    0xfc4e108U,
    0x5306b4d4U,
    0x5faa65d6U,
    0xe0df7355U,
    0x2e800517U,
    0xe44002f4U,
    0x5e00e65U,
    0x8c1004eeU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0xd8000000U,
    0x64000000U,
    0xaa000000U,
    0x69000000U,
    0x9a800000U,
    0xf4c00000U,
    0x9f600000U,
    0x75100000U,
    0x24b80000U,
    0xcfe40000U,
    0xb8fa0000U,
    0x697f0000U,
    0x422b8000U,
    0x1524c000U,
    0x74aee000U,
    0x87d89000U,
    0xb4ff6800U,
    0x7f435c00U,
    0xe51a0a00U,
    0x4caf0700U,
    0x73f38f80U,
    0x76d0cd40U,
    0xaa6ce720U,
    0xb18390d0U,
    0x7b4eeb08U,
    0x1f0895dcU,
    0x6da76a5eU,
    0xe5775f1dU,
    0x94380c3dU,
    0x92240aefU,
    0x9d1a0ce4U,
    0x58af01b9U,
    0x21f38125U,
    0xcbd0c859U,
    0x42ece996U,
    0x484397a2U,
    0xd4aee610U,
    0xf7d8976aU,
    0x4cff6f2cU,
    0xab435906U,
    0x971a0308U,
    0x41af09dcU,
    0x4373805eU,
    0xeb10c81dU,
    0xaf8cebbdU,
    0x30539bafU,
    0xc096e1c4U,
    0xa5fc9669U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x98000000U,
    0x1c000000U,
    0xe6000000U,
    0xdf000000U,
    0xae800000U,
    0xac00000U,
    0x7f600000U,
    0xe1100000U,
    0xcda80000U,
    0x92740000U,
    0x82aa0000U,
    0xb4d10000U,
    0xdc468000U,
    0x19b24000U,
    0x80526000U,
    0x5fba1000U,
    0x8f5ee800U,
    0xd9095c00U,
    0x1820e00U,
    0x5c650700U,
    0xd98c8f80U,
    0xe0734ac0U,
    0xefbce7e0U,
    0x177c5c30U,
    0xc5268c88U,
    0xe7a2415cU,
    0x837a6b1eU,
    0x770e15bdU,
    0xea94eaacU,
    0x90c85af6U,
    0xf66c8490U,
    0x8a3489aU,
    0x75f4e086U,
    0x1d850baU,
    0xc3c48dd7U,
    0x36d74a41U,
    0x895eeea2U,
    0x76095710U,
    0x57020c59U,
    0xfaa50066U,
    0xd8ec8308U,
    0xc2634b9cU,
    0x6a94ecfeU,
    0x50c8598dU,
    0x966c8e24U,
    0xb8a347aaU,
    0xedf4e18eU,
    0x1dd85a27U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0xa8000000U,
    0x9c000000U,
    0xf6000000U,
    0x15000000U,
    0x89800000U,
    0xe7c00000U,
    0x75600000U,
    0x9a300000U,
    0x9b280000U,
    0x489c0000U,
    0x944e0000U,
    0xd9ad0000U,
    0xefca8000U,
    0x9960c000U,
    0x54332000U,
    0xba199000U,
    0xab1fa800U,
    0x90885400U,
    0x30480600U,
    0x1bac0d00U,
    0x90e60480U,
    0xf3f100c0U,
    0x2f6485e0U,
    0xa13dc890U,
    0xa3b1a7f8U,
    0xe4d55f2cU,
    0x79ca87ceU,
    0x5c60c3dfU,
    0x95b320e4U,
    0x51d9942aU,
    0x807fa276U,
    0x83b854d3U,
    0xd4e00ed8U,
    0xa1f0085cU,
    0xf84807a7U,
    0x57ac0c8bU,
    0x2ee60d44U,
    0xeaf1039aU,
    0xf8e487ffU,
    0xcffdc317U,
    0xa951ac80U,
    0x8c2554c0U,
    0x1e0283e0U,
    0x690cc590U,
    0xefb52378U,
    0x5ad89fecU,
    0x60d3222eU,
    0x8be99b4fU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x78000000U,
    0xa4000000U,
    0x5e000000U,
    0xf3000000U,
    0x97800000U,
    0x6d400000U,
    0x4be00000U,
    0x18300000U,
    0x34280000U,
    0xc60c0000U,
    0x872a0000U,
    0xb1b70000U,
    0x3a7e8000U,
    0x824b4000U,
    0x86692000U,
    0xe876b000U,
    0xb375a800U,
    0xf8f6f400U,
    0x6f800600U,
    0x89400900U,
    0xf5e00980U,
    0x3b300740U,
    0xdba80260U,
    0xf4c0570U,
    0x92ca0c98U,
    0x5a8709e4U,
    0x99d68dc6U,
    0x29074757U,
    0x4aa327fcU,
    0x41f1bde3U,
    0xbd232330U,
    0xbcb1b37bU,
    0x6ec32dd5U,
    0xd081ba3fU,
    0x7ceb2a41U,
    0x418db5e3U,
    0x32412731U,
    0x6e7abd78U,
    0xd45fa0d7U,
    0x9941fdbfU,
    0x2dfe8000U,
    0xaf0b4000U,
    0x2d892000U,
    0x2046b000U,
    0xff5da800U,
    0x9afaf400U,
    0xb6aa0600U,
    0xcbf70900U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0x38000000U,
    0xc000000U,
    0x1e000000U,
    0x63000000U,
    0xcc800000U,
    0xb3c00000U,
    0xc6600000U,
    0xb0300000U,
    0x58180000U,
    0x5c140000U,
    0x56120000U,
    0x570d0000U,
    0xde848000U,
    0xcedf4000U,
    0x69cbe000U,
    0xcf6fd000U,
    0x2da56800U,
    0x2a599400U,
    0xbe000a00U,
    0x53000300U,
    0xd4800180U,
    0xcfc007c0U,
    0xe0600260U,
    0xdf3006f0U,
    0x8a980d28U,
    0x8cd40d0cU,
    0x5cf200aeU,
    0x54fd003fU,
    0x40fc89e7U,
    0x22fb4ec2U,
    0x67c1e0e0U,
    0xc476d0b1U,
    0xa533e089U,
    0xb38bdd9dU,
    0x94f6174U,
    0x52b0931bU,
    0x90ee8dc6U,
    0x2af64d93U,
    0x73c5695aU,
    0xa6699665U,
    0xe0180000U,
    0x10140000U,
    0x68120000U,
    0x440d0000U,
    0x2a048000U,
    0x711f4000U,
    0xb1abe000U,
    0x1c5fd000U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0xd8000000U,
    0xc4000000U,
    0xe2000000U,
    0x7b000000U,
    0x38800000U,
    0x10c00000U,
    0x3aa00000U,
    0xe0100000U,
    0x30180000U,
    0xb80c0000U,
    0x341e0000U,
    0x3a1b0000U,
    0xbf188000U,
    0xda9c4000U,
    0x6bcf6000U,
    0x2271000U,
    0xf0d21800U,
    0xabf5400U,
    0x58000200U,
    0x4000300U,
    0x82000180U,
    0x8b0003c0U,
    0xe0800360U,
    0xd4c00310U,
    0xd8a00388U,
    0x9b1001ecU,
    0x89800e2U,
    0xa8cc0043U,
    0xebe00eaU,
    0xda0b0380U,
    0x8f0080c0U,
    0x629042e0U,
    0x5fd160d0U,
    0x383c10e8U,
    0x4fca9afcU,
    0xd023176aU,
    0x33cf63afU,
    0x6271308U,
    0x72d21a43U,
    0x81bf57eaU,
    0xb8800000U,
    0xd0c00000U,
    0x5aa00000U,
    0x10100000U,
    0xe8180000U,
    0x7c0c0000U,
    0xd61e0000U,
    0x411b0000U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x18000000U,
    0x5c000000U,
    0xae000000U,
    0xa9000000U,
    0x3b800000U,
    0x78c00000U,
    0x18e00000U,
    0xb8100000U,
    0xcc180000U,
    0xe61c0000U,
    0x5d160000U,
    0xd1830000U,
    0x23cb8000U,
    0x2475c000U,
    0x52452000U,
    0x97bf7000U,
    0x3e231800U,
    0x31fd1c00U,
    0x43800200U,
    0x54c00300U,
    0x4ee00380U,
    0xfd1002c0U,
    0x41980060U,
    0x6bdc0170U,
    0xd07602b8U,
    0xb85302a4U,
    0xccb380eeU,
    0x2b9c1e3U,
    0xdbab2063U,
    0x183072e0U,
    0x8ce69b30U,
    0x2217df98U,
    0x6f18a374U,
    0x3689b046U,
    0x14dbb0fU,
    0x7f27ae51U,
    0x6e7e3b29U,
    0x995e6c2eU,
    0xe3351bc0U,
    0x207e1fa3U,
    0x804b8000U,
    0xc0b5c000U,
    0x4a52000U,
    0x36af7000U,
    0xd1bb1800U,
    0xf3211c00U,
    0xa8760200U,
    0x94530300U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x38000000U,
    0x44000000U,
    0xda000000U,
    0xe5000000U,
    0x59800000U,
    0x35400000U,
    0x5ca00000U,
    0x74100000U,
    0x2080000U,
    0xf1140000U,
    0x4b9e0000U,
    0xac470000U,
    0x9b288000U,
    0x7e4b4000U,
    0xe234a000U,
    0xe9cf3000U,
    0x2070a800U,
    0x75e89400U,
    0xa6a00200U,
    0x21100100U,
    0xc3880280U,
    0x705403c0U,
    0xf53e00e0U,
    0x79570110U,
    0x1aa08368U,
    0x5f1f4394U,
    0xac8aa166U,
    0x4d830d5U,
    0xe5f02972U,
    0x8ea7d5d0U,
    0xd02a208U,
    0x958c32c4U,
    0x334e2baeU,
    0xd7b0d571U,
    0x2a82208cU,
    0xcfc371e9U,
    0x1b6c8a60U,
    0xb36ce7f3U,
    0xdf640b07U,
    0x2977a512U,
    0x9a78a800U,
    0x80fc9400U,
    0x973e0200U,
    0x98570100U,
    0x39208280U,
    0x7f5f43c0U,
    0x91aaa0e0U,
    0x1883110U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0x58000000U,
    0x44000000U,
    0x32000000U,
    0x87000000U,
    0xc9800000U,
    0x8b400000U,
    0xb3200000U,
    0xb4100000U,
    0xfa080000U,
    0x3b140000U,
    0x6f9a0000U,
    0x664b0000U,
    0xb9a88000U,
    0xc4d64000U,
    0x4578e000U,
    0xf5bd3000U,
    0xaad36800U,
    0x14616400U,
    0x59200200U,
    0x37100100U,
    0xa1880280U,
    0xe7540340U,
    0x4d3a0160U,
    0x1d1b0110U,
    0xc28080c8U,
    0xccd2421cU,
    0x196ae326U,
    0x23a2322dU,
    0xcfc1eaccU,
    0x2ec26d0U,
    0x5ff861e8U,
    0x3d6f71ecU,
    0x21b98b3eU,
    0x60c356d9U,
    0x761e986U,
    0xfabc2703U,
    0x7f50615dU,
    0xe92b738aU,
    0x5f0b8a6dU,
    0xcd8c542cU,
    0x195b6800U,
    0xe4356400U,
    0x259a0200U,
    0x354b0100U,
    0xba288280U,
    0x5c964340U,
    0x55d8e160U,
    0x9ed3110U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x8000000U,
    0xf4000000U,
    0x86000000U,
    0xd7000000U,
    0x5e800000U,
    0xec400000U,
    0x9b600000U,
    0xe6100000U,
    0x27180000U,
    0x66840000U,
    0x420000U,
    0xe1610000U,
    0x430e8000U,
    0x2888c000U,
    0x35ee000U,
    0x29e9d000U,
    0x704c8800U,
    0x1975ec00U,
    0x8f180200U,
    0x42840300U,
    0xae420080U,
    0xd2610040U,
    0x938e8020U,
    0xe7c8c3d0U,
    0x40bee218U,
    0xf4b9d35cU,
    0x92b4897aU,
    0x75a1efb1U,
    0x3322006dU,
    0x23710098U,
    0xca16801cU,
    0x7d0cc1daU,
    0xd39ce021U,
    0x7c8d055U,
    0x70a20b14U,
    0xecad2ffeU,
    0x6ebee377U,
    0x7b9d016U,
    0x62348b2cU,
    0xaae1efbdU,
    0x78c20080U,
    0xa210040U,
    0xaeee8020U,
    0xc6d8c3d0U,
    0x3126e218U,
    0x8a7dd35cU,
    0x8f96897aU,
    0xa5d0efb1U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x88000000U,
    0x84000000U,
    0x12000000U,
    0xdd000000U,
    0xd6800000U,
    0x36400000U,
    0xd1e00000U,
    0x56100000U,
    0x6f080000U,
    0x3b9c0000U,
    0xb8da0000U,
    0xebb10000U,
    0x11e08000U,
    0xf61a4000U,
    0x5f0fa000U,
    0x639cd000U,
    0xb4cdc800U,
    0x7dbbbc00U,
    0xdee80200U,
    0xfd8c0100U,
    0xbfd20380U,
    0x842d0340U,
    0x333a8220U,
    0x44ab4210U,
    0x8a6f2048U,
    0x7ec69374U,
    0xeca26b5aU,
    0x7e776cd9U,
    0xd4cdc947U,
    0xedbbbc58U,
    0xb6e8003cU,
    0xa98c02aeU,
    0x25d20343U,
    0xdd2d02feU,
    0xf7ba822fU,
    0xafeb42bcU,
    0x8d0f226eU,
    0x1e969223U,
    0x524a6aceU,
    0x13fb6c77U,
    0x31fcb80U,
    0x3d96bf40U,
    0x1fd28020U,
    0xb4274310U,
    0x6b3d23c8U,
    0x48ab9034U,
    0x1c78e97aU,
    0xb1cc2ec9U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0xd8000000U,
    0xc000000U,
    0x1e000000U,
    0x5d000000U,
    0x2e800000U,
    0xd8400000U,
    0x83200000U,
    0xf2100000U,
    0xb3080000U,
    0xcb8c0000U,
    0x4ad60000U,
    0x9d7b0000U,
    0x20318000U,
    0x719bc000U,
    0xfdcfa000U,
    0x2cffd000U,
    0xfde60800U,
    0x8d72e400U,
    0x68280200U,
    0x759c0100U,
    0x87de0180U,
    0xbbf702c0U,
    0x9c678360U,
    0x38a0c030U,
    0x40de2078U,
    0xf2741174U,
    0x9da1a8baU,
    0xb2413761U,
    0x5c38080cU,
    0x9785e6c8U,
    0x7ccf814cU,
    0x747cc0eeU,
    0xaca023cbU,
    0x32d31085U,
    0x16e2b98U,
    0x363df482U,
    0x48982935U,
    0x1956f7a6U,
    0xbba1aac1U,
    0x1341355cU,
    0xd4b80980U,
    0xaec5e6c0U,
    0x176f8160U,
    0xf2cc130U,
    0xac0821f8U,
    0x8e0f13b4U,
    0x55102bdaU,
    0x4a9af751U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0xc8000000U,
    0xa4000000U,
    0xf2000000U,
    0x23000000U,
    0xba800000U,
    0x5ec00000U,
    0xc1600000U,
    0x1e100000U,
    0xb5180000U,
    0x8b9c0000U,
    0xb74e0000U,
    0xed390000U,
    0x25a48000U,
    0x98764000U,
    0x3906000U,
    0x335d5000U,
    0x8f20d800U,
    0xbeabac00U,
    0x4ef80200U,
    0xb4c0300U,
    0x23360380U,
    0x8b501c0U,
    0xeff28320U,
    0x5ad34290U,
    0x637ae3c8U,
    0x6512108cU,
    0x13943aeaU,
    0x4b40bd7bU,
    0x328b905U,
    0x98aaff78U,
    0x57f6db54U,
    0x36ceaceeU,
    0x3572807dU,
    0xb41343e4U,
    0x8a1ae3feU,
    0xaf0211bdU,
    0x9c8c3a0cU,
    0x47dcbfaaU,
    0xfce6ba1bU,
    0x853fc75U,
    0x9b25b80U,
    0xee68edc0U,
    0x429ae120U,
    0x12c21190U,
    0x76c3848U,
    0x770cbd4cU,
    0x409ebbcaU,
    0x39dffcebU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x58000000U,
    0x8c000000U,
    0x5a000000U,
    0xcd000000U,
    0x78800000U,
    0x2400000U,
    0x7600000U,
    0x5e100000U,
    0xe3180000U,
    0x938c0000U,
    0x25d20000U,
    0x64ab0000U,
    0xf5a18000U,
    0x2f234000U,
    0x9c7da000U,
    0x71991000U,
    0x34cd4800U,
    0x7e246c00U,
    0x26f80200U,
    0x52dc0300U,
    0x812a0180U,
    0xb7770240U,
    0x360b8160U,
    0xc7144230U,
    0x8d962168U,
    0x66dd5334U,
    0x72369e2U,
    0x18653c09U,
    0x9f916a1dU,
    0xbfde3e78U,
    0xc9a8e80cU,
    0x1d317f0eU,
    0x75674a77U,
    0x17136ee2U,
    0x7593805eU,
    0x1ad840f8U,
    0x9524221bU,
    0x166528bU,
    0x311ae924U,
    0x2a8a7d8dU,
    0x7b5ec980U,
    0x39fc2e40U,
    0x935c2360U,
    0xddfa5130U,
    0xed50e8e8U,
    0xeed7d74U,
    0xd6cd4a82U,
    0x6f246d39U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0x18000000U,
    0xcc000000U,
    0xe000000U,
    0xb1000000U,
    0x1a800000U,
    0xf3c00000U,
    0xb200000U,
    0x61100000U,
    0xb2980000U,
    0x7c40000U,
    0xb92e0000U,
    0xc6130000U,
    0xd5018000U,
    0xe085c000U,
    0xf0d82000U,
    0xb6a05000U,
    0xf557f800U,
    0x5ef8a400U,
    0x2f2e0200U,
    0x7b130300U,
    0xe1818080U,
    0xd245c1c0U,
    0xf9782060U,
    0xe8705330U,
    0x42eff838U,
    0x892ca6c4U,
    0x3e18026aU,
    0x490400cfU,
    0x868e00acU,
    0x95c30044U,
    0x6e3982aaU,
    0xb991c32fU,
    0xfe4e22dcU,
    0xa76751dcU,
    0x31607b3eU,
    0x8c6a644dU,
    0xb8f9a1efU,
    0x8a35905eU,
    0x8397d99fU,
    0xdd5cf4a4U,
    0x6af7f838U,
    0xbd28a6c4U,
    0xac16026aU,
    0x9e0700cfU,
    0xf91780acU,
    0xbe82c044U,
    0x29cfa2aaU,
    0x7822932fU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0xd8000000U,
    0x4000000U,
    0xe2000000U,
    0xe7000000U,
    0x95800000U,
    0xbdc00000U,
    0x6ba00000U,
    0xdf100000U,
    0x81880000U,
    0xe7cc0000U,
    0xd8aa0000U,
    0x708b0000U,
    0xdf488000U,
    0xfbf04000U,
    0x5d66e000U,
    0xf31b000U,
    0x5a433800U,
    0xc97f3400U,
    0x152a0200U,
    0x894b0100U,
    0x36e88180U,
    0x93e04140U,
    0x916ee360U,
    0x513db010U,
    0xb493b88U,
    0x81e4379cU,
    0xde6a8056U,
    0x28b743f7U,
    0xd884602eU,
    0x334af23cU,
    0x95ed5966U,
    0x847ec78fU,
    0x9bafdaeaU,
    0x7715875eU,
    0x6d89baabU,
    0x89d87558U,
    0x1a6603bU,
    0xe40df310U,
    0xf20fda07U,
    0x5f058676U,
    0xc181bb88U,
    0x87d4779cU,
    0x88ac6056U,
    0xa896f3f7U,
    0xdb4f582eU,
    0x19f9c63cU,
    0xba6d5b66U,
    0x9abec68fU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0xc8000000U,
    0x74000000U,
    0xa000000U,
    0xff000000U,
    0x45800000U,
    0xdec00000U,
    0xfde00000U,
    0xe7100000U,
    0xa9980000U,
    0xf8cc0000U,
    0x44fe0000U,
    0xeb890000U,
    0xb3d68000U,
    0x6b6d4000U,
    0x3a51e000U,
    0xc3a9b000U,
    0x26a95800U,
    0x6428fc00U,
    0x237e0200U,
    0x8e490300U,
    0xa9b68180U,
    0x29bd43c0U,
    0xe9a9e320U,
    0x89b5b1d0U,
    0x79af5828U,
    0xb1bdfffcU,
    0xc5ae8316U,
    0xcfb1407bU,
    0x30b7e277U,
    0x752cb05cU,
    0xabe1d986U,
    0x561cbe33U,
    0xb101633bU,
    0x1891f352U,
    0xe0483a59U,
    0xa4a90d16U,
    0x4f2e3a3eU,
    0xfcec0e42U,
    0x9786b994U,
    0xadc84d4fU,
    0x6e61d828U,
    0x48dcbffcU,
    0x2ce16316U,
    0xf81f07bU,
    0x81d03a77U,
    0x28650c5cU,
    0x1d03b86U,
    0xe8650d33U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x68000000U,
    0x24000000U,
    0xda000000U,
    0xc1000000U,
    0xd1800000U,
    0x17c00000U,
    0x2200000U,
    0x75100000U,
    0xa3980000U,
    0xd2c40000U,
    0x19a20000U,
    0xcbdd0000U,
    0x543c8000U,
    0x6a0f4000U,
    0x79022000U,
    0xbd933000U,
    0xf9c47800U,
    0x71360400U,
    0x41820200U,
    0xbfcd0300U,
    0x6248080U,
    0xbf0b4040U,
    0xa8021a0U,
    0x275e3090U,
    0xd460fb68U,
    0x8fd4704U,
    0xf0a22146U,
    0xde43335fU,
    0xa9fc7888U,
    0xd1220594U,
    0x9198012eU,
    0xf7c400dbU,
    0x3222038eU,
    0xd1d006bU,
    0xef9c83b6U,
    0x2cdf4167U,
    0x2ba2284U,
    0xdb473026U,
    0x927e7a2fU,
    0x7fef06d0U,
    0xe3c8368U,
    0x6b0f4304U,
    0x88822346U,
    0xba53305fU,
    0x93e47808U,
    0x202605d4U,
    0x381a008eU,
    0xac09004bU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x18000000U,
    0x1c000000U,
    0x3a000000U,
    0x29000000U,
    0x43800000U,
    0xd1c00000U,
    0x6c600000U,
    0xad100000U,
    0x25880000U,
    0x22dc0000U,
    0x96f20000U,
    0x27530000U,
    0x842b8000U,
    0xd9ab4000U,
    0x376f2000U,
    0x638f7000U,
    0xe1dfb800U,
    0x467cc00U,
    0x39120200U,
    0x1b830100U,
    0x2dc38380U,
    0xc6674240U,
    0x9c152060U,
    0x7a007070U,
    0xc90638e8U,
    0xd39f8ca4U,
    0xc9d6a30eU,
    0x70673247U,
    0x97131a31U,
    0xc9ffcf4U,
    0x61509af6U,
    0x4738bdfbU,
    0x4b25bb33U,
    0x2928cf79U,
    0xfc2b82feU,
    0x15ab4311U,
    0xf56f2264U,
    0xc68f71aeU,
    0x805fba97U,
    0xe0a7cf09U,
    0x2cf200e8U,
    0x4e5300a4U,
    0x27ab810eU,
    0x986b4347U,
    0x430f21b1U,
    0xd29f72b4U,
    0xfe57b896U,
    0xfbbcc8bU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0xc8000000U,
    0xc4000000U,
    0xf6000000U,
    0xd9000000U,
    0x38800000U,
    0xe3400000U,
    0x1ae00000U,
    0x9f100000U,
    0x19880000U,
    0xa7dc0000U,
    0x93b20000U,
    0xa6e90000U,
    0x55008000U,
    0x4a8ac000U,
    0x2c552000U,
    0x6b6c1000U,
    0x8ccde800U,
    0x242d1c00U,
    0xd43a0200U,
    0xcc350100U,
    0x20328380U,
    0x8223c240U,
    0x6535a320U,
    0x40b6d310U,
    0x6d70cbd8U,
    0x4dcd0f64U,
    0xf0adeae2U,
    0x957d1e8dU,
    0x31d201ebU,
    0x9ab9013cU,
    0xb66880c6U,
    0xe246c3cfU,
    0x6e6f22b6U,
    0xae5912efU,
    0xbc7f6a6eU,
    0x114eddc3U,
    0x95efa238U,
    0xe93d15cU,
    0x9a4a49beU,
    0x5272ce33U,
    0x244a4858U,
    0xf72cd24U,
    0xaca49c2U,
    0xa532cd9dU,
    0xe0aa4a33U,
    0x1d62ce58U,
    0x15c24a24U,
    0xfcaecd42U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0xb8000000U,
    0x3c000000U,
    0x56000000U,
    0x85000000U,
    0x6c800000U,
    0x51c00000U,
    0x70a00000U,
    0xeb100000U,
    0x95880000U,
    0x8b5c0000U,
    0x94660000U,
    0x4f270000U,
    0x135f8000U,
    0x387ec000U,
    0x713aa000U,
    0x22449000U,
    0x86eeb800U,
    0xcfe95400U,
    0xed6e0200U,
    0xd5bb0100U,
    0x17998380U,
    0xac49c0c0U,
    0x4fed22e0U,
    0xad6650f0U,
    0x35b21958U,
    0x278ac614U,
    0x145f3bb2U,
    0x73ec9447U,
    0xfb6d2042U,
    0xb0a6526cU,
    0x4b121b36U,
    0x459ac61dU,
    0x3573be9U,
    0x107096d8U,
    0x252b2127U,
    0xc0515272U,
    0xd1e598d4U,
    0x4c680652U,
    0x3239837U,
    0x1d5f055aU,
    0xb1741ad8U,
    0xf3bdc6d4U,
    0xca88b952U,
    0xccce54b7U,
    0xf031811aU,
    0x64c5c078U,
    0xe4232284U,
    0x66cd535aU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x68000000U,
    0xd4000000U,
    0x7e000000U,
    0x7b000000U,
    0xee800000U,
    0xb1c00000U,
    0xad600000U,
    0x51100000U,
    0xab880000U,
    0x444c0000U,
    0xc2260000U,
    0x25bd0000U,
    0x83e28000U,
    0xc0dbc000U,
    0x56ed6000U,
    0x4d4ad000U,
    0xd5afb800U,
    0xcbf1ec00U,
    0x44ce0200U,
    0x70e10100U,
    0x8a4c8180U,
    0x912ac0c0U,
    0x7f29e1a0U,
    0x7c2c1350U,
    0x7ea059f8U,
    0x3d60fdecU,
    0x290cd9baU,
    0x479a3fc7U,
    0xb64d3935U,
    0x7b2a2c84U,
    0x1a23608eU,
    0xd9abd381U,
    0x49e33ad0U,
    0xf5db2eeaU,
    0xab67e3edU,
    0xc60d1278U,
    0xb70cd82cU,
    0x4c9a3f9aU,
    0x50cd3b57U,
    0x2eea2fedU,
    0xa1436078U,
    0x27bbd12cU,
    0x72eb3a1aU,
    0x7b572d97U,
    0x2aa1e14dU,
    0x36011a8U,
    0x32065894U,
    0x991dff16U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x38000000U,
    0x74000000U,
    0x96000000U,
    0x77000000U,
    0x5a800000U,
    0xef400000U,
    0x1ee00000U,
    0x35100000U,
    0x6b880000U,
    0x6acc0000U,
    0x173e0000U,
    0x1eb70000U,
    0xd5768000U,
    0x8fc6c000U,
    0xd4b4e000U,
    0xc86e5000U,
    0x18526800U,
    0x47c9c00U,
    0xba560200U,
    0x856b0100U,
    0x67c08180U,
    0x8bdc3c0U,
    0xe27c60e0U,
    0xb55f91d0U,
    0xcbf00a58U,
    0xee840ddcU,
    0x59588b6aU,
    0xf9e5cebdU,
    0xa792ebfbU,
    0xc8c15e14U,
    0x962a62ceU,
    0xc33492bbU,
    0x58b08b64U,
    0xa79cfb6U,
    0x6944ea87U,
    0xe1ea5c8eU,
    0x438ae39bU,
    0x96d95354U,
    0xad24e9beU,
    0x7bba5cc3U,
    0x56e2e3d8U,
    0x3905521cU,
    0xe992e98aU,
    0x7bc15e6dU,
    0x2aa6023U,
    0xdf749008U,
    0xb2d08944U,
    0xd329cdd6U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0xd8000000U,
    0x64000000U,
    0xda000000U,
    0x97000000U,
    0x85800000U,
    0x18c00000U,
    0xb6a00000U,
    0x59100000U,
    0x70880000U,
    0xfe440000U,
    0x99f60000U,
    0xdc6b0000U,
    0xa4b48000U,
    0x82074000U,
    0xb308e000U,
    0x7f99b000U,
    0x3fc29800U,
    0xeb3a1400U,
    0x25de0200U,
    0x1c3f0100U,
    0x304a8080U,
    0x6ce842c0U,
    0x3aea6360U,
    0x8be5f190U,
    0x776fb68U,
    0x6720e65cU,
    0x3c27816U,
    0x1527a563U,
    0x48ca985aU,
    0xbebe16a4U,
    0x75080022U,
    0xa68401a9U,
    0xf5602efU,
    0x357b027dU,
    0xc3c808cU,
    0x184341a7U,
    0xf0fee168U,
    0x34f2b2a5U,
    0x1ef619f1U,
    0x71fd5552U,
    0x2076e3e8U,
    0x3ab6b09cU,
    0x7f001976U,
    0x799655f3U,
    0x86c263b2U,
    0x4bb1f238U,
    0x9388fb54U,
    0x89cfe55aU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0x28000000U,
    0x14000000U,
    0x6a000000U,
    0x91000000U,
    0x5800000U,
    0xb5400000U,
    0xbba00000U,
    0xa7100000U,
    0xda980000U,
    0x83dc0000U,
    0x7e7e0000U,
    0xee750000U,
    0xf66a8000U,
    0x2a794000U,
    0xa4782000U,
    0x776fb000U,
    0xf7fb2800U,
    0x2d37b400U,
    0xb2c60200U,
    0xabf90300U,
    0x632c8380U,
    0x81c043c0U,
    0xdb74a0a0U,
    0x91fff050U,
    0xa3789a8U,
    0xa8444644U,
    0xc8378a16U,
    0xed4445d5U,
    0x47b78b6eU,
    0x3904465cU,
    0xd1978a4aU,
    0x3f54469fU,
    0xdaaf8971U,
    0x8a98456dU,
    0x7bc98b47U,
    0x527144a8U,
    0x487d08e1U,
    0x316d0740U,
    0xc0f7aac5U,
    0xefa7f426U,
    0xed0aa228U,
    0x5b8af184U,
    0x5e5d08b6U,
    0xf73d0685U,
    0x2bcfa946U,
    0xaa6bf7d8U,
    0x646ca2fcU,
    0x9763f01aU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x48000000U,
    0xac000000U,
    0x8e000000U,
    0xe5000000U,
    0x4e800000U,
    0x97c00000U,
    0xe5600000U,
    0x3e900000U,
    0xfd80000U,
    0xe17c0000U,
    0xc920000U,
    0x2cd10000U,
    0xe6e98000U,
    0x5bc3c000U,
    0xbb6da000U,
    0x73905000U,
    0xfd593800U,
    0xb0b50c00U,
    0xa0e98200U,
    0xd2c3c300U,
    0x9beda380U,
    0x11505040U,
    0x1eb93920U,
    0xb5e50eb0U,
    0xc4518038U,
    0xe82fc094U,
    0xd627a2baU,
    0x4b3d521fU,
    0x11a2bab5U,
    0xfc67ce4aU,
    0x960da007U,
    0x21005311U,
    0x9c813a88U,
    0xa4c90eacU,
    0xaafb832eU,
    0xc5d2c025U,
    0x1664236aU,
    0x9103919fU,
    0xe48c9bddU,
    0xb0c95e9eU,
    0xd0fabab5U,
    0x4adbce4aU,
    0x9fffa007U,
    0x23415311U,
    0x3db0ba88U,
    0xb276ceacU,
    0x9304232eU,
    0x7f939025U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0xc8000000U,
    0x4000000U,
    0xa000000U,
    0x1b000000U,
    0xeb800000U,
    0x57400000U,
    0xfe00000U,
    0x63900000U,
    0xf3580000U,
    0xb5ec0000U,
    0x608a0000U,
    0xd4c10000U,
    0xecac8000U,
    0x7e6b4000U,
    0x47d26000U,
    0xa329f000U,
    0x932da800U,
    0x4b299c00U,
    0xe72c8200U,
    0x392b4300U,
    0xe0326180U,
    0x14b9f340U,
    0xa275ab20U,
    0xe1c59c10U,
    0x66268228U,
    0xa1aa436cU,
    0xe8fee22eU,
    0x5e02b21dU,
    0x191fcb1fU,
    0x94906d9eU,
    0x66d929e5U,
    0x8baeddbbU,
    0x83f4e1acU,
    0xcd83b24eU,
    0x5253492dU,
    0x5d6b2f27U,
    0x10534bdaU,
    0x826b2f27U,
    0x91d34bc8U,
    0x1e2b2f0eU,
    0xbdb34b1fU,
    0x2efb2d9eU,
    0x4b0b49e5U,
    0xe3872dbbU,
    0x335949acU,
    0xd5ea2e4eU,
    0xb09fcb2dU,
    0x1cd06c27U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0xb8000000U,
    0x94000000U,
    0x12000000U,
    0xdd000000U,
    0x86800000U,
    0xe0400000U,
    0xd2a00000U,
    0xb2900000U,
    0xa2480000U,
    0x97a40000U,
    0xb0120000U,
    0xe81f0000U,
    0xc168000U,
    0x96004000U,
    0x770ca000U,
    0xcf825000U,
    0x74de4800U,
    0xefe1f400U,
    0xe6b68200U,
    0xf0904100U,
    0xe744a080U,
    0x95265040U,
    0xfa4c4ae0U,
    0x73bef650U,
    0x2a000248U,
    0x9000274U,
    0xb480029aU,
    0x2d4003c1U,
    0xec2001aaU,
    0xc6d0009aU,
    0x62e802c1U,
    0xf834012aU,
    0x94da00daU,
    0x9ffb0021U,
    0x6ea4837aU,
    0xcc8f4092U,
    0xd9522355U,
    0xce261160U,
    0xb3c0eb13U,
    0xc87ca41fU,
    0x9e7e49aaU,
    0x8971f49aU,
    0x76fe80c1U,
    0xaa34402aU,
    0x69d6a05aU,
    0x9795061U,
    0x36fac99aU,
    0x8a2eb6c2U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0xf8000000U,
    0x74000000U,
    0x66000000U,
    0x13000000U,
    0x9b800000U,
    0x8a400000U,
    0xf6200000U,
    0x5f900000U,
    0x54480000U,
    0xf12c0000U,
    0x92160000U,
    0x35170000U,
    0xe8828000U,
    0x21cac000U,
    0x847d6000U,
    0xddadf000U,
    0x6dc58800U,
    0xb678a400U,
    0xf8a28200U,
    0x2d5ac100U,
    0x2bb56180U,
    0x96c1f0c0U,
    0xf1f38be0U,
    0xa8ffa5d0U,
    0x22680398U,
    0xeebc014cU,
    0xa65e03eeU,
    0xf43b02e9U,
    0x82948038U,
    0x60ddc0aeU,
    0xaffe0c9U,
    0xef673388U,
    0x7238e826U,
    0xe19556fdU,
    0x63470a7aU,
    0xc4b264f9U,
    0x875fe0c0U,
    0x4ab73172U,
    0x4850e99fU,
    0xb29571dU,
    0x3b190838U,
    0x678964aeU,
    0x4b62c9U,
    0xc72af288U,
    0x490f09a6U,
    0x229e663dU,
    0x70c9e19aU,
    0xa2e03129U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x28000000U,
    0xdc000000U,
    0x22000000U,
    0x27000000U,
    0xed800000U,
    0xa7c00000U,
    0xbf200000U,
    0x9900000U,
    0x51d80000U,
    0xd63c0000U,
    0x991a0000U,
    0xc89d0000U,
    0xdd478000U,
    0x8d6e4000U,
    0xe571e000U,
    0x196e3000U,
    0x8b64b800U,
    0xd46d0400U,
    0xcde78200U,
    0x943e4300U,
    0x2e09e380U,
    0xed023140U,
    0xf686b8a0U,
    0x385c0770U,
    0x17e20288U,
    0x8731039cU,
    0xdd858036U,
    0x1fcf43dfU,
    0xab2c625cU,
    0xa79d7356U,
    0x7cd2d9cfU,
    0xc0ad77c4U,
    0xf152dbd2U,
    0xf76d76bdU,
    0x8672d809U,
    0x72fd7453U,
    0xddaadbf2U,
    0x5fc1760dU,
    0x8b30d9e1U,
    0x179c75dfU,
    0x4d75a5cU,
    0x34a23756U,
    0xf5ebbcfU,
    0xf26004c4U,
    0x4cf80052U,
    0x38ac03fdU,
    0xc54202a9U,
    0xe9610023U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0x8000000U,
    0x8c000000U,
    0x5e000000U,
    0x1b000000U,
    0xda800000U,
    0x62c00000U,
    0xcc600000U,
    0x2e900000U,
    0xe8c80000U,
    0xed7c0000U,
    0x2d120000U,
    0x1d890000U,
    0xe4d8000U,
    0x29a9c000U,
    0x6e726000U,
    0x3392d000U,
    0x4d539800U,
    0x9724ec00U,
    0xcead8200U,
    0xb2f9c100U,
    0x2e5a6380U,
    0x99bed040U,
    0x96699820U,
    0xa781ee30U,
    0x975a0378U,
    0x5e35016cU,
    0x513f80eaU,
    0x11b0c1cbU,
    0x5a77e311U,
    0x1987128aU,
    0x9c53fadbU,
    0x8caf3fd9U,
    0xbffb99deU,
    0x83c8ecfdU,
    0x6ff78288U,
    0x2bccc15cU,
    0x13e5e1baU,
    0x6dce110bU,
    0x8cfe78d9U,
    0x6556fc76U,
    0xab21fb11U,
    0x68b63e8aU,
    0x3dfe18dbU,
    0x2edd2ed9U,
    0x3277e25eU,
    0xc58710bdU,
    0x2a53f8a8U,
    0xbaf3e6cU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x68000000U,
    0x5c000000U,
    0x56000000U,
    0x87000000U,
    0xa3800000U,
    0x22c00000U,
    0x30a00000U,
    0x95900000U,
    0xd5c80000U,
    0x1b3c0000U,
    0xdb560000U,
    0xdb650000U,
    0x55a78000U,
    0xfb14c000U,
    0x6589e000U,
    0x1dc5f000U,
    0x97259800U,
    0xd5407400U,
    0x686f8200U,
    0xfc28c100U,
    0x8dfe380U,
    0x71a0f0c0U,
    0x90219a0U,
    0x5094b570U,
    0x6b466358U,
    0xf37d331cU,
    0xe9b2790eU,
    0x9d1c844bU,
    0x8a9b9b62U,
    0xe2497626U,
    0xe3f6038fU,
    0x62f503b0U,
    0x5e6f83c3U,
    0xb28c256U,
    0x235fe16cU,
    0x3f60f2d6U,
    0x7a21917U,
    0x1e04b68cU,
    0x4b0e617dU,
    0x4d8133e5U,
    0xa1c478e2U,
    0xf12986e6U,
    0x3a541a2fU,
    0x97f1b6c0U,
    0x88e1e09bU,
    0xbf69f14aU,
    0x47bb9862U,
    0xfe19769dU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x48000000U,
    0x64000000U,
    0xb6000000U,
    0x19000000U,
    0xd6800000U,
    0x36c00000U,
    0x40200000U,
    0xd0900000U,
    0xa7d80000U,
    0x12bc0000U,
    0x60560000U,
    0xb6f10000U,
    0x70a08000U,
    0x4758c000U,
    0xfd6e2000U,
    0x16fc5000U,
    0x60b71800U,
    0xdf5aa400U,
    0xe1788200U,
    0x8ce4c300U,
    0xabb82380U,
    0xa6cd50c0U,
    0x18379920U,
    0x2c926590U,
    0xdcea0d8U,
    0x91a49364U,
    0x7dd938daU,
    0xf9a6f41bU,
    0xc9cf9a20U,
    0x37be65d2U,
    0xfcc0a1c7U,
    0x332993eeU,
    0x650fb87bU,
    0xbc9f3750U,
    0x55d9393aU,
    0x6da6f4abU,
    0xd7cf9968U,
    0x7abe676eU,
    0xd440a2f9U,
    0x78e9906fU,
    0x45afb9a0U,
    0x43cf3512U,
    0x64a138e7U,
    0x994af67eU,
    0x506198a3U,
    0xe636434U,
    0x636e21e0U,
    0x9bfc50b0U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x68000000U,
    0x74000000U,
    0xee000000U,
    0xc9000000U,
    0x8a800000U,
    0x27400000U,
    0xff600000U,
    0x8c900000U,
    0xda480000U,
    0xfbec0000U,
    0x32da0000U,
    0xc7a50000U,
    0x24328000U,
    0xf9efc000U,
    0x79c02000U,
    0x4631d000U,
    0xe2e22800U,
    0x90574c00U,
    0xf4fa8200U,
    0x6543c100U,
    0xd47a2180U,
    0x5d04d140U,
    0x7498a9a0U,
    0xe6548dd0U,
    0x51e0a1b8U,
    0x2dd71224U,
    0x982a8baaU,
    0x13fc5dddU,
    0x6c2085dU,
    0x49b69ee2U,
    0xbd30ab51U,
    0x1b688c8bU,
    0x2a92a0c1U,
    0x574e1213U,
    0xa76a08f5U,
    0xc08a9e61U,
    0x2842a8bcU,
    0xa8f18d9eU,
    0x9f5222afU,
    0xa378d094U,
    0x768aa9ddU,
    0xad5d8fa2U,
    0xd06822f1U,
    0xeb0dd15bU,
    0xf1902979U,
    0x9ece4c37U,
    0x25ba015fU,
    0x7f3502bcU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xe8000000U,
    0xe4000000U,
    0x1a000000U,
    0x11000000U,
    0x53800000U,
    0xb8c00000U,
    0x80e00000U,
    0xd1900000U,
    0xc5d80000U,
    0xbd740000U,
    0xba560000U,
    0xba50000U,
    0x79b88000U,
    0x4cad4000U,
    0xa5232000U,
    0x3cecf000U,
    0x7935800U,
    0x8ad9bc00U,
    0xd5e08200U,
    0xa8194300U,
    0x84152280U,
    0x8a19f0c0U,
    0xc913dba0U,
    0x5f90ff90U,
    0x46cda268U,
    0x8be4b344U,
    0x9308fbceU,
    0x2e980e23U,
    0x8550fba3U,
    0xeb2c0fd6U,
    0x1fe6fbffU,
    0x1190d71U,
    0x4b867887U,
    0x14c04e9dU,
    0x4ef358adU,
    0x3289be60U,
    0x63588385U,
    0x4c3d40f1U,
    0x937b20f2U,
    0x958f0b4U,
    0xd5255923U,
    0xb4ecbf16U,
    0x7380005fU,
    0x48c002e1U,
    0xc8e002efU,
    0x59001d9U,
    0x37d80163U,
    0x48740343U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xe8000000U,
    0x54000000U,
    0xbe000000U,
    0x1b000000U,
    0x7f800000U,
    0xa9c00000U,
    0xbf600000U,
    0x3d900000U,
    0xf8d80000U,
    0x55ec0000U,
    0x48da0000U,
    0x2de50000U,
    0x94d68000U,
    0x97e5c000U,
    0xd9c26000U,
    0xa7777000U,
    0xb183f800U,
    0xaacc0c00U,
    0x4cee8200U,
    0xc659c300U,
    0x5ea06180U,
    0xe6ee7140U,
    0xc3577ba0U,
    0xa20cd50U,
    0x88a060f8U,
    0x69ee736cU,
    0x62d7787eU,
    0xe8e0cfe7U,
    0xa040635dU,
    0xa9be72a6U,
    0x9b6f789bU,
    0x9b9ccc7bU,
    0x6fc2617dU,
    0x78777040U,
    0xf803fbd6U,
    0x1c0c0f85U,
    0xda0e80daU,
    0x1d09c33dU,
    0xd8986260U,
    0x3c5273c6U,
    0xb3b57addU,
    0xe679cfe6U,
    0x1314e13bU,
    0xbb92b22bU,
    0x9fc19805U,
    0xa07b7e6cU,
    0x140d7a08U,
    0x1e05ce32U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0x48000000U,
    0x14000000U,
    0x2a000000U,
    0x47000000U,
    0x1e800000U,
    0xf0400000U,
    0x96200000U,
    0x8900000U,
    0xb9580000U,
    0x4dbc0000U,
    0x454e0000U,
    0xa3b10000U,
    0x704e8000U,
    0x56234000U,
    0xe88de000U,
    0x49475000U,
    0x5ae4800U,
    0x5156a400U,
    0x89b68200U,
    0x374f4300U,
    0x48bbe380U,
    0x18da53c0U,
    0xdf76c920U,
    0xd38e450U,
    0xe81be2a8U,
    0xc40a521cU,
    0x720ecbfaU,
    0xeb14e401U,
    0x688de178U,
    0x89475372U,
    0xe5ae49cdU,
    0xa156a7eaU,
    0xc1b6824fU,
    0x234f421fU,
    0x62bbe0b1U,
    0x5fda53a6U,
    0xc1f6c81dU,
    0xfd78e782U,
    0x7e3be1f3U,
    0xcc9a51f5U,
    0xcb56caf8U,
    0xa6a8e4b2U,
    0x2dc3e2edU,
    0x2af650baU,
    0x95e0cb67U,
    0xf775e7c3U,
    0x293b606bU,
    0x6a0810f7U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x78000000U,
    0xe4000000U,
    0x42000000U,
    0x5d000000U,
    0xe5800000U,
    0xd8c00000U,
    0x1be00000U,
    0xb900000U,
    0xebd80000U,
    0xd740000U,
    0x65ca0000U,
    0x4e770000U,
    0xdb588000U,
    0xbc2a4000U,
    0xd8e0a000U,
    0x75123000U,
    0xb9905800U,
    0xdeda5c00U,
    0xd4e08200U,
    0xcb0e4300U,
    0x3292a280U,
    0x8c413340U,
    0x28bad9e0U,
    0x4ba31f90U,
    0xe52aa308U,
    0xcf653274U,
    0xf8c8d916U,
    0xbf01c23U,
    0xd380238fU,
    0xdfdc70beU,
    0x3762f827U,
    0xdccb6e01U,
    0xe9e259e1U,
    0x5e895ecaU,
    0x424a028aU,
    0xbb703eaU,
    0x8538803aU,
    0xbf7a4252U,
    0x50d8a3f6U,
    0x97f63088U,
    0x7582590fU,
    0xc0d95ffeU,
    0x8ff203c7U,
    0xe1930291U,
    0x2aca8069U,
    0x4ee943feU,
    0xa212207cU,
    0xed1f7359U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0x88000000U,
    0xac000000U,
    0xfe000000U,
    0xbf000000U,
    0x21800000U,
    0x2c400000U,
    0x86200000U,
    0x5e900000U,
    0x6dc80000U,
    0x7a640000U,
    0xa0ae0000U,
    0x17490000U,
    0x45b98000U,
    0x9bd5c000U,
    0x2970e000U,
    0x5f34b000U,
    0x7409c800U,
    0x6a05e400U,
    0x45178200U,
    0x3c9cc100U,
    0xc4c96080U,
    0x98e173c0U,
    0x2b792a20U,
    0x263156b0U,
    0xee9e49f8U,
    0xc5d927fcU,
    0x267ee206U,
    0xd6adb271U,
    0x45848b8U,
    0x9a24240aU,
    0x881626fU,
    0x8ec570a5U,
    0x2df7297cU,
    0x9fe855d0U,
    0x4eefcba8U,
    0x8868e414U,
    0x51a00272U,
    0x21d001d3U,
    0x146800c3U,
    0x47b401ddU,
    0xe2c60140U,
    0xb3fd03f6U,
    0xf0ff8069U,
    0x1768c2d4U,
    0x802f61c4U,
    0x858c71daU,
    0x3e4ea9c7U,
    0xe73d94b1U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xb8000000U,
    0x1c000000U,
    0x2a000000U,
    0xc7000000U,
    0x25800000U,
    0x49400000U,
    0xc9600000U,
    0xf2900000U,
    0x44c80000U,
    0xf4240000U,
    0x45ee0000U,
    0xff4f0000U,
    0x646f8000U,
    0x300f4000U,
    0xd819e000U,
    0xcc143000U,
    0x6211e800U,
    0x63138c00U,
    0x13818200U,
    0xa4404100U,
    0x2bf66080U,
    0x9e5b73c0U,
    0xc4e80ae0U,
    0xcfd7bc70U,
    0xf3b86aa8U,
    0x4fa7ce1cU,
    0xd5b1e216U,
    0x8aa033e5U,
    0x4337e945U,
    0x98788c7aU,
    0x8a00015bU,
    0x770001bcU,
    0xbd8001a9U,
    0xa5400204U,
    0x5b6000c2U,
    0x2990025fU,
    0x4b4801feU,
    0x7a640036U,
    0xa90e011aU,
    0x449f0084U,
    0xe9c783edU,
    0x36bb4266U,
    0xd93fe34dU,
    0xc77f3259U,
    0x439068ecU,
    0xac53ce7eU,
    0xaff7e199U,
    0x585b33e3U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0x78000000U,
    0x9c000000U,
    0x2a000000U,
    0x95000000U,
    0x20800000U,
    0xb9400000U,
    0x27e00000U,
    0xb9900000U,
    0xebd80000U,
    0xa7bc0000U,
    0x3cea0000U,
    0x9a070000U,
    0xfd178000U,
    0x24834000U,
    0xdf47a000U,
    0xe0f89000U,
    0x9011e800U,
    0x580b1c00U,
    0xac1d8200U,
    0x82144300U,
    0x71082380U,
    0x9687d340U,
    0x65c49e0U,
    0x92648e70U,
    0x2043eaa8U,
    0x75601d54U,
    0x39d80102U,
    0x6ebc02a5U,
    0xd66a02ffU,
    0x664703d6U,
    0x827782e7U,
    0xb85342baU,
    0x397fa0d9U,
    0x6bd492d9U,
    0x67a3ebe9U,
    0xdcf01c91U,
    0x4a00024dU,
    0x850000fbU,
    0xb880029cU,
    0xf54002d6U,
    0x75e00057U,
    0xb0900282U,
    0xe15801e5U,
    0x8bfc031fU,
    0x3b8a01a6U,
    0x9ad7024fU,
    0x312f80eeU,
    0x3aaf405bU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xb8000000U,
    0x34000000U,
    0xca000000U,
    0x59000000U,
    0x8a800000U,
    0x81c00000U,
    0x58e00000U,
    0x37900000U,
    0x9580000U,
    0xec3c0000U,
    0xabe60000U,
    0x941f0000U,
    0x5a028000U,
    0xb1134000U,
    0xb68a2000U,
    0xc7c0d000U,
    0xffeff800U,
    0x2e097c00U,
    0x5b048200U,
    0xbf9c4300U,
    0x4550a380U,
    0xf22f92c0U,
    0x88e3dae0U,
    0xff86acd0U,
    0x6551f928U,
    0xa22a7e64U,
    0x80e003aaU,
    0x739003c7U,
    0x9b580003U,
    0x313c02ceU,
    0x536601edU,
    0x78df0204U,
    0x426283adU,
    0x5e434133U,
    0x6db22221U,
    0x9dacd01dU,
    0x5b1fb9cU,
    0x61ba7c71U,
    0xa3b80375U,
    0x76ac0258U,
    0x23e012bU,
    0x10e300aaU,
    0x9b848047U,
    0xa75c42c3U,
    0x7730a02eU,
    0xf47f913dU,
    0x615bd92cU,
    0x102aaec9U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0x98000000U,
    0x6c000000U,
    0xaa000000U,
    0xcb000000U,
    0xdc800000U,
    0x18400000U,
    0xece00000U,
    0x93900000U,
    0x5ad80000U,
    0x19bc0000U,
    0x32ee0000U,
    0x5e9b0000U,
    0x7498000U,
    0xe6774000U,
    0x82c46000U,
    0x55bd1000U,
    0x88f7c800U,
    0xfd87bc00U,
    0x2fc78200U,
    0x383c4300U,
    0xf35e380U,
    0xd1a653c0U,
    0x16e5aa60U,
    0x108dadb0U,
    0x624fc8a8U,
    0xafebbc2cU,
    0x4b1182f2U,
    0x1c8b40a1U,
    0xf84a6253U,
    0x1cf6103eU,
    0xb8649a3U,
    0x36dcfefaU,
    0xb3b5e311U,
    0xf9e65137U,
    0x8205ab5cU,
    0x1f1dae76U,
    0xa97c8b3U,
    0x1157bdceU,
    0xf7f80abU,
    0x91504106U,
    0xcf63e2fbU,
    0x71515012U,
    0x3f7a2951U,
    0xe94ded5bU,
    0x53742ac2U,
    0x4346eec9U,
    0x9865aa9fU,
    0x9fcdae3cU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0xe8000000U,
    0x64000000U,
    0x2a000000U,
    0x9b000000U,
    0x5800000U,
    0x2fc00000U,
    0x18a00000U,
    0xd4900000U,
    0x61580000U,
    0xcae40000U,
    0x5ff60000U,
    0xb750000U,
    0xaa208000U,
    0x40cf4000U,
    0x2f346000U,
    0xcc433000U,
    0x26f3800U,
    0x68b0b400U,
    0xdc8e8200U,
    0x155e4300U,
    0x38e2e080U,
    0x48f970c0U,
    0x40fbdba0U,
    0x34fcc590U,
    0xc6f5daa8U,
    0xd1fdc56cU,
    0x9a7b5a96U,
    0x4a3877fU,
    0x8299b942U,
    0x7c5af502U,
    0x2a62600dU,
    0x2ca63317U,
    0xc697bae1U,
    0x665bf7aeU,
    0x596ce3d4U,
    0x4d387212U,
    0xc3555965U,
    0xe5f2855bU,
    0x886f3927U,
    0x3b0b7d9U,
    0x110e836aU,
    0x6e9e40aeU,
    0xe242e13bU,
    0x636971f8U,
    0xe23d90bU,
    0x4ad8c7c0U,
    0x8423d94fU,
    0x21d8c67aU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0xd8000000U,
    0x2c000000U,
    0xa2000000U,
    0x65000000U,
    0xe4800000U,
    0xa8c00000U,
    0xd2e00000U,
    0x2b900000U,
    0x9d480000U,
    0xf0bc0000U,
    0xc6ba0000U,
    0x3da30000U,
    0x26218000U,
    0x737a4000U,
    0x97d9a000U,
    0x8f7c1000U,
    0xadd9d800U,
    0x267e3c00U,
    0xbb538200U,
    0x33a54100U,
    0xa1222380U,
    0x12f55140U,
    0x8b89fb60U,
    0x2d546cb0U,
    0x78a1f888U,
    0x32b86c94U,
    0xb3b3fa12U,
    0xe1376ee3U,
    0xf2e079abU,
    0xdb922c5eU,
    0xf5425a1dU,
    0x54a77ea6U,
    0x90aba0e0U,
    0xd6a31331U,
    0x5a25a29U,
    0x5a377fa4U,
    0x963a31bU,
    0xdedf13d6U,
    0xc9f85a09U,
    0x60047d74U,
    0x100a22a3U,
    0x3819518aU,
    0x7c1bfb6fU,
    0x7a1b6cf5U,
    0x491279c3U,
    0x468d2ffbU,
    0xcdd9d826U,
    0x367e3ee1U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xc8000000U,
    0x14000000U,
    0x82000000U,
    0xc1000000U,
    0x14800000U,
    0x8dc00000U,
    0x61a00000U,
    0xe3900000U,
    0x4a580000U,
    0xd1e40000U,
    0x5f7a0000U,
    0xfb10000U,
    0xcc8e8000U,
    0xb1c64000U,
    0x87af2000U,
    0x38831000U,
    0x43c27800U,
    0xdea2d400U,
    0xf00c8200U,
    0x58034300U,
    0xfc03a080U,
    0xc6105140U,
    0x8b19db20U,
    0xc1968450U,
    0x1b4f5808U,
    0x2d74c404U,
    0x96ba7ad2U,
    0x2416d477U,
    0xfa0e8026U,
    0x6d06419eU,
    0x1a8f2081U,
    0x12d31153U,
    0x223a7807U,
    0x39d6d55dU,
    0x73ae82eeU,
    0xca96437aU,
    0x1ad72263U,
    0x1637135cU,
    0xebc07bfdU,
    0x7aa7d7ddU,
    0xca0000aeU,
    0x150000daU,
    0xb6800373U,
    0x1cc00274U,
    0xbd2000a9U,
    0x7a500187U,
    0xa9f8039dU,
    0xf374020eU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0x58000000U,
    0x3c000000U,
    0xe2000000U,
    0x4d000000U,
    0xcd800000U,
    0xadc00000U,
    0x8ae00000U,
    0x66900000U,
    0x43580000U,
    0x6da40000U,
    0xf53a0000U,
    0x49630000U,
    0xfc4b8000U,
    0x552a4000U,
    0xd97ca000U,
    0x84573000U,
    0x39397800U,
    0x637d3c00U,
    0xf5498200U,
    0x16bd4300U,
    0x83b52080U,
    0xb22a7140U,
    0xddec5960U,
    0x4a074cf0U,
    0xb91dd988U,
    0x6b8e0e34U,
    0x6ecaf9b6U,
    0xb0637cf7U,
    0x77d721cbU,
    0x4bed732aU,
    0x611ddb65U,
    0x978e0d32U,
    0xaccaf80aU,
    0xad637d56U,
    0xe25723e4U,
    0xda2d710dU,
    0x9fdda95U,
    0xbc1e0d3aU,
    0x2212f8feU,
    0x6d077e40U,
    0x9d8d20c3U,
    0xf5de705eU,
    0xb6ee59b3U,
    0x84904e35U,
    0xe5458c9U,
    0xa0334d08U,
    0x58ffda57U,
    0xc3890f38U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x58000000U,
    0xd4000000U,
    0xee000000U,
    0xab000000U,
    0x1b800000U,
    0x4a400000U,
    0x3fa00000U,
    0xca500000U,
    0x7fa80000U,
    0xaa5c0000U,
    0xefba0000U,
    0xf2570000U,
    0x3ba08000U,
    0x1c4ac000U,
    0x90b5e000U,
    0x7c9b000U,
    0xdafca800U,
    0x386e4400U,
    0x10b5e200U,
    0x47c9b100U,
    0xbafca980U,
    0xa86e4640U,
    0x48b5e360U,
    0x93c9b250U,
    0x54fcaa38U,
    0x36e44ecU,
    0x5335e30eU,
    0xd989b379U,
    0x6b5caac6U,
    0xc93e47c5U,
    0x2c9de2f0U,
    0x73d5b1d0U,
    0x84e6a978U,
    0x3b69440cU,
    0x173d621eU,
    0x6f9f71a1U,
    0x14534b3aU,
    0x3ca0f413U,
    0xcdc1c975U,
    0x57f13540U,
    0x4e6a978U,
    0x7b69440cU,
    0x773d621eU,
    0xff9f71a1U,
    0x4c534b3aU,
    0xe8a0f413U,
    0x23c1c975U,
    0xfcf13540U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x58000000U,
    0x9c000000U,
    0xe2000000U,
    0x8b000000U,
    0x52800000U,
    0x56c00000U,
    0x4a600000U,
    0xb6d00000U,
    0x3a680000U,
    0xded40000U,
    0xee6a0000U,
    0xf8df0000U,
    0x1b798000U,
    0xc3434000U,
    0x9428e000U,
    0x8d691000U,
    0x3e523800U,
    0x4bb85c00U,
    0x6c28e200U,
    0x41691100U,
    0xa4523880U,
    0x4cb85c40U,
    0x84a8e360U,
    0xa91370U,
    0x5eb23b08U,
    0x27a85e6cU,
    0xa620e22aU,
    0x3e6d122bU,
    0xc0d03a21U,
    0xb7735cb7U,
    0x695b62c3U,
    0xdb255150U,
    0xa1eb5998U,
    0x1860f54U,
    0xd8583aaeU,
    0xdeb75e5dU,
    0x67b961c8U,
    0x863e5061U,
    0x2e70d8d7U,
    0x98de4e33U,
    0x2b6b5998U,
    0x8b460f54U,
    0x50383aaeU,
    0xf3675e5dU,
    0x575161c8U,
    0x922a5061U,
    0x687ad8d7U,
    0x5dd14e33U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x48000000U,
    0x44000000U,
    0xca000000U,
    0xd000000U,
    0x28800000U,
    0x51400000U,
    0xd8a00000U,
    0x59500000U,
    0xbcb80000U,
    0xc34c0000U,
    0x49ae0000U,
    0xe7c50000U,
    0x96e68000U,
    0xf87c4000U,
    0xea372000U,
    0x3d015000U,
    0xa0910800U,
    0xf5444400U,
    0xa2b72200U,
    0x1c415300U,
    0xd0310b80U,
    0x581446c0U,
    0x9c0f2320U,
    0x960d5210U,
    0x7b1f08a8U,
    0xe39146f4U,
    0xfac9a382U,
    0x66611355U,
    0xf5302bcaU,
    0x448c1791U,
    0xaf4ea970U,
    0xb7ac5458U,
    0x88cf88ecU,
    0x4774070eU,
    0x3ae00abU,
    0x2ac50179U,
    0x5e668064U,
    0x193c41eaU,
    0x7a972081U,
    0x20515358U,
    0xd62908ecU,
    0x3b08470eU,
    0xc39920abU,
    0xaac45179U,
    0x9e778864U,
    0xf93805eaU,
    0xca800281U,
    0x68400058U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0xa8000000U,
    0xac000000U,
    0xe6000000U,
    0x9000000U,
    0x38800000U,
    0xe2c00000U,
    0x50a00000U,
    0xead00000U,
    0x2cb80000U,
    0x84d40000U,
    0x99ba0000U,
    0xf2410000U,
    0xde6f8000U,
    0x7c7dc000U,
    0xdf7ea000U,
    0x38e2d000U,
    0x53a6f800U,
    0xdd4ac400U,
    0xcffea200U,
    0xb622d300U,
    0xc506f880U,
    0x2e9ac440U,
    0x73c6a0a0U,
    0x7c36d1b0U,
    0xea1cfb18U,
    0x3f0bc464U,
    0xb9912042U,
    0x665f123bU,
    0xfc785a5aU,
    0x1f7817cfU,
    0x18e058f0U,
    0x43bc1428U,
    0x75425a3cU,
    0x63f91706U,
    0x502fdb09U,
    0xcc11d599U,
    0x1604fbe1U,
    0x910fc555U,
    0x2c9321dfU,
    0xca12c8U,
    0x13adda3cU,
    0x3d44d706U,
    0xfff17b09U,
    0xe230599U,
    0xc11a03e1U,
    0x64910155U,
    0x9cd783dfU,
    0x4da9c1c8U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x48000000U,
    0x64000000U,
    0xea000000U,
    0xc5000000U,
    0x4f800000U,
    0x75c00000U,
    0x3b600000U,
    0xa1d00000U,
    0xd9680000U,
    0xe0cc0000U,
    0x4cee0000U,
    0x18050000U,
    0x5c028000U,
    0x26084000U,
    0x7b122000U,
    0x289db000U,
    0x9b5a9800U,
    0xeb33dc00U,
    0x2a722200U,
    0xc4db100U,
    0xedb29b80U,
    0x4e3fdcc0U,
    0x15fc2320U,
    0xd198b090U,
    0x82d81828U,
    0x4dfb9fd4U,
    0x6d80021eU,
    0x94c00147U,
    0x7ee000c5U,
    0x21100153U,
    0xe588037bU,
    0x50dc03c4U,
    0x44e60276U,
    0x9c1901f3U,
    0x8604832bU,
    0xab0142ccU,
    0x509ea032U,
    0xb740f245U,
    0x65223878U,
    0x56a2cb7U,
    0x86d49a76U,
    0xd7e6ddf3U,
    0x98a12bU,
    0x8f49f3ccU,
    0xa92ebbb2U,
    0xbb776e85U,
    0xe1cc3b58U,
    0x396f2c27U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x58000000U,
    0x54000000U,
    0x72000000U,
    0xcf000000U,
    0xf2800000U,
    0x99400000U,
    0xcfa00000U,
    0xfb500000U,
    0x98b80000U,
    0x7dd40000U,
    0xe3ea0000U,
    0x257f0000U,
    0xbe308000U,
    0x56894000U,
    0xc35d6000U,
    0xbcad1000U,
    0xe7c94800U,
    0xb0f06400U,
    0xa9e56200U,
    0xce791300U,
    0xd6a34880U,
    0x9ccf6640U,
    0x8075e360U,
    0x37a05250U,
    0xff462948U,
    0x92b6757cU,
    0x76d6a8aaU,
    0x3b6f3435U,
    0x2733c876U,
    0xf1162591U,
    0xfb908248U,
    0x66d94382U,
    0xa3656099U,
    0x53391354U,
    0x13034bf8U,
    0x6c9f64a4U,
    0xc04de3beU,
    0x483453d3U,
    0x538c2b71U,
    0x1ad975a6U,
    0x6d7e2819U,
    0x72227514U,
    0x509ca898U,
    0xee4036f4U,
    0xd93b4af6U,
    0xd80b66afU,
    0x9407e3dbU,
    0x521b5193U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xd8000000U,
    0xdc000000U,
    0x62000000U,
    0xdf000000U,
    0x2c800000U,
    0x15400000U,
    0xbe600000U,
    0x2b500000U,
    0x43680000U,
    0x38cc0000U,
    0xaa60000U,
    0x4bf70000U,
    0x438d8000U,
    0x41c34000U,
    0xe7326000U,
    0x5f2cd000U,
    0xb321c800U,
    0xe9219c00U,
    0x9a3a6200U,
    0xcb0d100U,
    0x1aefcb80U,
    0xea1a9dc0U,
    0xb11e160U,
    0xda849270U,
    0xdc502a08U,
    0x2bf50ebcU,
    0x738249d2U,
    0x79c9de25U,
    0x4b2b82f1U,
    0xe5344311U,
    0xb03fe15fU,
    0xa7af9206U,
    0x5073a83bU,
    0x9e5d4d8eU,
    0x24f3ab39U,
    0x171d4fcdU,
    0x1893a87dU,
    0x934d4c6bU,
    0xaf7baad6U,
    0x62c14d5dU,
    0x79bdabbbU,
    0xdd664c4eU,
    0x55d82859U,
    0xb1290cbdU,
    0x62c49f5U,
    0x8ea2df17U,
    0xb5e80264U,
    0x1e8c0108U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x98000000U,
    0xa4000000U,
    0x5a000000U,
    0x33000000U,
    0xdf800000U,
    0x4ac00000U,
    0xa9600000U,
    0xa4d00000U,
    0x28680000U,
    0xd4440000U,
    0x732e0000U,
    0xc6f70000U,
    0x360a8000U,
    0x85044000U,
    0x1a80e000U,
    0xf045b000U,
    0x6928b800U,
    0x55e11c00U,
    0xd988e200U,
    0x57d1b100U,
    0x17eeba80U,
    0xe921cc0U,
    0x724c6060U,
    0x5e32f390U,
    0xe06cdbe8U,
    0x3847ec0cU,
    0x85223b1eU,
    0xa3e55ebbU,
    0xbc88034dU,
    0xdd54039fU,
    0x4fa6033fU,
    0x5ba3002aU,
    0xd9ac8061U,
    0xeea743d4U,
    0x5b2c626fU,
    0xbae2f0a2U,
    0x6804d87dU,
    0xdc03ef62U,
    0x6e0c3978U,
    0xc1125f81U,
    0xd08282e1U,
    0x6b504314U,
    0x8aa6e00fU,
    0xe126b232U,
    0x19e43915U,
    0x1f965faeU,
    0xaacc8206U,
    0x397742aaU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x8000000U,
    0x84000000U,
    0xea000000U,
    0x8f000000U,
    0x9c800000U,
    0x2ec00000U,
    0x86200000U,
    0x18d00000U,
    0xaf380000U,
    0x45540000U,
    0xa8620000U,
    0xf6350000U,
    0xc28000U,
    0x3204000U,
    0xfb4f6000U,
    0xc56dd000U,
    0x61b1b800U,
    0x589c9400U,
    0x24d76200U,
    0xf929d300U,
    0x5c4bb880U,
    0xded9740U,
    0xad6fe220U,
    0xd5b89110U,
    0x4a9c5b28U,
    0xf7c1057cU,
    0x3b1b852U,
    0x939c95abU,
    0x72576330U,
    0x88e9d21fU,
    0x4eebb86eU,
    0xbffd94feU,
    0x6e77e131U,
    0x73c9097U,
    0xd1465be5U,
    0x6a6004deU,
    0x2d313b06U,
    0x7e59d505U,
    0x26e28009U,
    0xbf04264U,
    0x7c7761b1U,
    0xd439d3d7U,
    0x2bd3bbc5U,
    0xa5a996ceU,
    0x5295e0aeU,
    0x5bc99339U,
    0xbda4d87bU,
    0xfe9045dfU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0x28000000U,
    0x2c000000U,
    0x82000000U,
    0x61000000U,
    0xbc800000U,
    0x5e400000U,
    0xbba00000U,
    0x88500000U,
    0x8ca80000U,
    0x43cc0000U,
    0xf9660000U,
    0xfda90000U,
    0xe7538000U,
    0x43214000U,
    0x980ba000U,
    0xa404d000U,
    0x3e1b6800U,
    0xbb1b2400U,
    0xd983a200U,
    0x4cd8d100U,
    0x6f56b80U,
    0xee6e25c0U,
    0xe63e22a0U,
    0x2a8c91b0U,
    0x89434988U,
    0x3eb444U,
    0xd5936852U,
    0x1ec724c9U,
    0xdfeda166U,
    0x26edd365U,
    0x3e68ebe0U,
    0x5e2a6506U,
    0x5e8001a3U,
    0xf4001e3U,
    0xcf2002d5U,
    0x8a10013eU,
    0x9d080139U,
    0x869c028eU,
    0x4b4e01b1U,
    0x8125014aU,
    0x19158223U,
    0x68984023U,
    0x48502275U,
    0x2cb9918eU,
    0xd3decb31U,
    0xa17af70aU,
    0xf9ad4943U,
    0x494bb533U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0xa8000000U,
    0x8c000000U,
    0xbe000000U,
    0x41000000U,
    0x31800000U,
    0x5c00000U,
    0x9ae00000U,
    0xe4d00000U,
    0x7b780000U,
    0x69140000U,
    0x7d9a0000U,
    0x9bd10000U,
    0xcbf38000U,
    0x7d52c000U,
    0xf2a1a000U,
    0x4de5f000U,
    0xd8429800U,
    0xd13c6c00U,
    0xa73ba200U,
    0x9a34f300U,
    0x8db11880U,
    0xfd6eac40U,
    0xcc1a00a0U,
    0x5e110130U,
    0x71138278U,
    0x8982c144U,
    0x21d9a266U,
    0xa8f1f227U,
    0x1bd89893U,
    0xbed6e97U,
    0x5d48232bU,
    0xe2a632b3U,
    0xe5f0bb1dU,
    0x545b5dbcU,
    0x6f209a62U,
    0xe6396d61U,
    0xabb22244U,
    0x8867311cU,
    0x679b3aa8U,
    0x28cd9cd6U,
    0x25633965U,
    0x18199cf8U,
    0xf4193804U,
    0xba189f46U,
    0x6312bad7U,
    0x669e5f8bU,
    0xf9491983U,
    0x10baae65U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x18000000U,
    0x94000000U,
    0xbe000000U,
    0xa7000000U,
    0x39800000U,
    0x6a400000U,
    0x6c600000U,
    0x55500000U,
    0x81e80000U,
    0x21040000U,
    0xda9a0000U,
    0x55d70000U,
    0xa5208000U,
    0xa6a4c000U,
    0x8dfe6000U,
    0x4b1cf000U,
    0x6397a800U,
    0x5b4fbc00U,
    0xeee46200U,
    0x348bf100U,
    0xad72a80U,
    0x38bb7e40U,
    0xfaf20260U,
    0xca930350U,
    0xdda8078U,
    0x9123c0dcU,
    0x88b6e086U,
    0x32fc33f9U,
    0xe693cb49U,
    0xb7d44fc9U,
    0x903b48e1U,
    0x82248c2dU,
    0xdf372a5bU,
    0x47ab7f42U,
    0xb77a0073U,
    0x2ec7030eU,
    0x4ea88145U,
    0x71f0c2f7U,
    0x490c6164U,
    0x668ff292U,
    0xf7cd2a23U,
    0x302c7f9eU,
    0x123280f5U,
    0xc727c0f7U,
    0xd3ace20cU,
    0x96b313eU,
    0x89d34b85U,
    0x77208fbfU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x8000000U,
    0x94000000U,
    0x36000000U,
    0xbd000000U,
    0x28800000U,
    0xa9c00000U,
    0x60a00000U,
    0x2cd00000U,
    0xc4380000U,
    0x4f1c0000U,
    0x6b820000U,
    0xc84d0000U,
    0x7e88000U,
    0x50b7c000U,
    0x34cd2000U,
    0x3837d000U,
    0x3d049800U,
    0xe88a0400U,
    0xc9cf2200U,
    0xb0bad300U,
    0x24cc1980U,
    0x502dc740U,
    0x791a0220U,
    0xd6810150U,
    0xe0d28158U,
    0xae26c1b4U,
    0x3007a082U,
    0x181d10f7U,
    0xfc19395aU,
    0x72161647U,
    0x830499b2U,
    0x18a049bU,
    0xb74f23acU,
    0x747ad3d2U,
    0x64ec1aafU,
    0x413dc56eU,
    0xeb820385U,
    0x84d0065U,
    0x67e88111U,
    0x80b7c1f3U,
    0x3ccd22f4U,
    0xac37d266U,
    0xb049a2dU,
    0x558a0599U,
    0xe14f22dfU,
    0x197ad222U,
    0x446c1aa3U,
    0x7cfdc668U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x8000000U,
    0xf4000000U,
    0xc6000000U,
    0xe9000000U,
    0xd6800000U,
    0xf2400000U,
    0x6200000U,
    0x4f500000U,
    0x86a80000U,
    0x8c1c0000U,
    0x1a1e0000U,
    0xb0d0000U,
    0x41888000U,
    0x31d9c000U,
    0x10e3a000U,
    0x94321000U,
    0xf05b6800U,
    0x613e1400U,
    0xe4dda200U,
    0xd46f1100U,
    0x997be980U,
    0x71fbd6c0U,
    0xf6a00220U,
    0xa41002d0U,
    0x3e080298U,
    0x750c0164U,
    0x5496037aU,
    0xd5410019U,
    0xcdbe8300U,
    0xad88c299U,
    0x9bd52140U,
    0x13f6d1f9U,
    0x21b84870U,
    0x799c511U,
    0x98d3691cU,
    0xa67217f7U,
    0xd66ba3abU,
    0xfe7e11bcU,
    0xda6d6b67U,
    0xa46f1453U,
    0xb16b22e8U,
    0x55ebd075U,
    0x88b8c866U,
    0xb10c06eeU,
    0xda86c92bU,
    0xa85105e5U,
    0x6d264807U,
    0xbed4c77aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0xc8000000U,
    0xfc000000U,
    0xc6000000U,
    0xa5000000U,
    0x7a800000U,
    0xc6400000U,
    0x8ee00000U,
    0x2f500000U,
    0x9a680000U,
    0xe0140000U,
    0x10060000U,
    0x981d0000U,
    0x44118000U,
    0xf201c000U,
    0x9f0b2000U,
    0x19979000U,
    0x19cc6800U,
    0x323e8c00U,
    0x67ed2200U,
    0x3bda9100U,
    0x5535e880U,
    0x6a6b4dc0U,
    0x68000120U,
    0xcc0002f0U,
    0x2e000398U,
    0x29000354U,
    0x748002caU,
    0x9f4000e9U,
    0x32600123U,
    0x4c100229U,
    0x6e080383U,
    0x9040099U,
    0x48e027bU,
    0x575902ddU,
    0xce7f8379U,
    0x8a08c048U,
    0xcb1ca23cU,
    0x738b5206U,
    0xc2d6c977U,
    0xd9a8df00U,
    0xe12a69e3U,
    0x10738d89U,
    0x2b14a3b3U,
    0x638f51a1U,
    0x5ad8cb9fU,
    0x9db1ddefU,
    0x1335ebd4U,
    0x8f6b4d69U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x58000000U,
    0xac000000U,
    0x6e000000U,
    0x41000000U,
    0x23800000U,
    0x46c00000U,
    0x22200000U,
    0x33d00000U,
    0x23a80000U,
    0x4a040000U,
    0x8b1e0000U,
    0xe89f0000U,
    0xe438000U,
    0x9c66c000U,
    0xf7ada000U,
    0x7811b000U,
    0x5c1cf800U,
    0x96023400U,
    0x5d13a200U,
    0x159eb100U,
    0xabd77a80U,
    0x6fb0f6c0U,
    0x34080360U,
    0x221403b0U,
    0x3f160338U,
    0x8a8b03c4U,
    0x915581eeU,
    0xa6edc3abU,
    0x3ef82130U,
    0x72fc71cbU,
    0xce4d800U,
    0xa5fe4433U,
    0x727778a4U,
    0xf6a0f66dU,
    0xfb800037U,
    0xaac00099U,
    0xec200212U,
    0xc2d00232U,
    0x58280191U,
    0xa0c4039dU,
    0xc73e039cU,
    0x9a4f01a9U,
    0xe6b83d9U,
    0x90a2c232U,
    0x5e93a1a2U,
    0xa35eb139U,
    0x71f778f1U,
    0x4060f51eU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x48000000U,
    0xc000000U,
    0xca000000U,
    0xfb000000U,
    0xb1800000U,
    0x5ec00000U,
    0xc9600000U,
    0xc1d00000U,
    0xaee80000U,
    0x46040000U,
    0x71020000U,
    0xea9d0000U,
    0xbf4b8000U,
    0xdfb04000U,
    0x4aee000U,
    0xa5377000U,
    0x13f8b800U,
    0x86891c00U,
    0xc54ce200U,
    0x9cba7100U,
    0xa13b3a80U,
    0x75ed5d40U,
    0xe7880320U,
    0xc7d40130U,
    0x7fea01a8U,
    0xfc9902acU,
    0x864983e6U,
    0x392d414bU,
    0x71e5600dU,
    0x818730ebU,
    0xa6d6587dU,
    0x7d7e6c63U,
    0x1fd458e1U,
    0xdbe36dadU,
    0xca9fd8c6U,
    0xaf532e26U,
    0x37b13876U,
    0x58a45d4eU,
    0x2729803aU,
    0xe4fd42f8U,
    0xfd0d6149U,
    0x60833301U,
    0xe4545920U,
    0x3e236e6dU,
    0x127fdafbU,
    0x60432ce5U,
    0x18393967U,
    0xd3705eabU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xa8000000U,
    0xfc000000U,
    0xaa000000U,
    0x63000000U,
    0x18800000U,
    0xbb400000U,
    0xa6e00000U,
    0x7a500000U,
    0x91680000U,
    0xfb940000U,
    0xe3d60000U,
    0x3db10000U,
    0x2cb18000U,
    0x43384000U,
    0x96efe000U,
    0xb2545000U,
    0xbd7c0800U,
    0x9974c00U,
    0xd4d1e200U,
    0x73315100U,
    0x5efb8880U,
    0x9e4e0fc0U,
    0x4f6780a0U,
    0x3e8942f0U,
    0x9a5e6228U,
    0x16c124cU,
    0x8393eac2U,
    0x47c31d1dU,
    0xc3adea33U,
    0x19a61d65U,
    0x92aa68a7U,
    0x563f5fc3U,
    0xb77c0934U,
    0xda974c2fU,
    0x4451e07fU,
    0xc471525eU,
    0xfa1b893eU,
    0x7b1e0d6eU,
    0x6c8f82b6U,
    0x1d5d4152U,
    0xc7e8639cU,
    0xfdcd11a3U,
    0x98aa6a1dU,
    0x853f5db3U,
    0x27fc0925U,
    0x6dd74e47U,
    0xe0b1e2d3U,
    0x2121528cU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0xd8000000U,
    0x24000000U,
    0xf2000000U,
    0x2b000000U,
    0x7f800000U,
    0xb2c00000U,
    0x24200000U,
    0x3d00000U,
    0xbca80000U,
    0xb0840000U,
    0xdf520000U,
    0xcdef0000U,
    0x506e8000U,
    0xf1bd4000U,
    0xfe0de000U,
    0xb517b000U,
    0xfa863800U,
    0xe04ef400U,
    0xe877e200U,
    0xe5bcb100U,
    0xa41aba80U,
    0xb20cb740U,
    0x8b1c8160U,
    0xaf824190U,
    0x6acb6148U,
    0x2ef3ecU,
    0xf1d9da9eU,
    0x97b6465bU,
    0xcf1f5958U,
    0x6d8f05a3U,
    0xe9c0bb8cU,
    0x53b7b649U,
    0x4d08000dU,
    0x4e9401e8U,
    0x6a5a019bU,
    0x377b0278U,
    0xb03481d3U,
    0x19c64314U,
    0x1bb9600dU,
    0x1111f22fU,
    0x489f5bc5U,
    0x6b4f0544U,
    0x47e0ba65U,
    0x8f67b5b3U,
    0xa42001c3U,
    0x43d0015bU,
    0x1ca8031fU,
    0x6084033dU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xd8000000U,
    0x4c000000U,
    0x22000000U,
    0xdf000000U,
    0x26800000U,
    0x8ec00000U,
    0xb0e00000U,
    0xefd00000U,
    0x73780000U,
    0xf4940000U,
    0x19d20000U,
    0x227f0000U,
    0x5f138000U,
    0xe6874000U,
    0xaed66000U,
    0xe0ea9000U,
    0x37c13800U,
    0x3f634c00U,
    0xd69c6200U,
    0xc6d19300U,
    0x4f8b880U,
    0xd1cf0d40U,
    0x566b8160U,
    0x41134230U,
    0x93846008U,
    0xc355923cU,
    0x26b2bbfaU,
    0xf4f40f0bU,
    0x99d2004bU,
    0xe27f03c3U,
    0x7f1381d7U,
    0xb68740a9U,
    0x76d661c4U,
    0xacea9206U,
    0x15c13839U,
    0xe0634f34U,
    0xf01c6046U,
    0x48119231U,
    0xb418bbe0U,
    0x3e1f0d98U,
    0x2513814cU,
    0xb587417aU,
    0x8a5660a3U,
    0xe12a910fU,
    0x79a13885U,
    0x12734e8eU,
    0x370460adU,
    0x295900aU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x68000000U,
    0xec000000U,
    0xfa000000U,
    0xfb000000U,
    0x61800000U,
    0x89c00000U,
    0xd9200000U,
    0x34d00000U,
    0x1a80000U,
    0x33840000U,
    0x7ece0000U,
    0xd2b90000U,
    0x1e0b8000U,
    0x3d1a4000U,
    0x9896e000U,
    0xa7557000U,
    0x4f635800U,
    0x893a9400U,
    0x8cd0e200U,
    0x15b87100U,
    0x7d8eda80U,
    0xfbddd4c0U,
    0x5e2383a0U,
    0xf75e42b0U,
    0xf778e168U,
    0x9d3c732cU,
    0xc2c0d826U,
    0x90a4d597U,
    0xf108028cU,
    0x1294023fU,
    0x94460300U,
    0xf2ed0229U,
    0x92ed833fU,
    0x42e74029U,
    0xbaf36396U,
    0xee633d6U,
    0x70f63a1fU,
    0x9de1a7f0U,
    0xfd635821U,
    0xee3a9703U,
    0xdf50e0d7U,
    0xbb7873c5U,
    0x572eda10U,
    0x51cdd5f1U,
    0x1d2b837bU,
    0x82ca4223U,
    0x30bee0a7U,
    0xc111720dU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x68000000U,
    0x6c000000U,
    0x62000000U,
    0x69000000U,
    0xc2800000U,
    0xf2c00000U,
    0x5e600000U,
    0x7dd00000U,
    0x3bf80000U,
    0x269c0000U,
    0xccc60000U,
    0x5d610000U,
    0x4a438000U,
    0x1b94000U,
    0x8f3ca000U,
    0x4fe21000U,
    0x809a7800U,
    0xcbd41c00U,
    0x64e2a200U,
    0x7b0f1300U,
    0x387f980U,
    0x3c405fc0U,
    0x3ea383a0U,
    0x22a942b0U,
    0xe8a4a008U,
    0x8dae1264U,
    0xdd247aaaU,
    0x2ee91e7bU,
    0xde0722f1U,
    0x33075353U,
    0x3f80da65U,
    0xa6470c91U,
    0xa3a359eaU,
    0x862e4e32U,
    0x7d67fbceU,
    0x1a505df8U,
    0xf9bb8025U,
    0x7b2542f1U,
    0x29faa3faU,
    0xe783110aU,
    0x259f862U,
    0x3dad5f96U,
    0x153e00c4U,
    0xd2fd0233U,
    0x2405835cU,
    0x5e184006U,
    0xf31f2295U,
    0x5f8b5250U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0xb8000000U,
    0xac000000U,
    0x46000000U,
    0x6b000000U,
    0xdf800000U,
    0xbec00000U,
    0x1fa00000U,
    0x37d00000U,
    0x99380000U,
    0x87840000U,
    0x82c60000U,
    0xb1a30000U,
    0xb8db8000U,
    0x14a7c000U,
    0xb85ce000U,
    0x6ff53000U,
    0x8c29b800U,
    0x5f1b8400U,
    0x582e200U,
    0x8bc23300U,
    0xf72c3a80U,
    0xa88b47c0U,
    0xff5b80e0U,
    0x3667c1b0U,
    0xf9fce398U,
    0x6f25326cU,
    0x3491b99eU,
    0xa15f844bU,
    0x164e366U,
    0xd8713273U,
    0x16efbb9aU,
    0xb2b88725U,
    0x43596295U,
    0x5865f3a9U,
    0xd6f0db1fU,
    0x12be7420U,
    0xb3523b74U,
    0xe06c4432U,
    0x7ae60135U,
    0x54b3009dU,
    0xd843838dU,
    0x3ff3c205U,
    0xc422e061U,
    0x4b1232dbU,
    0xef94390aU,
    0xa6cf47edU,
    0x43bd81d1U,
    0xc9d4c143U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0xa8000000U,
    0xc000000U,
    0x22000000U,
    0x27000000U,
    0xf8800000U,
    0x65c00000U,
    0x4c600000U,
    0xdd500000U,
    0x49b80000U,
    0x81240000U,
    0x8cfe0000U,
    0x6c890000U,
    0x23db8000U,
    0xe5734000U,
    0x90d66000U,
    0x5bf7d000U,
    0x5c099800U,
    0x5a183c00U,
    0x930de200U,
    0xce849300U,
    0xc4dffa80U,
    0xbdefeec0U,
    0x450478a0U,
    0xbf9caf30U,
    0x8d521808U,
    0x31ab7d5cU,
    0x353b81c2U,
    0xbae34067U,
    0xcd8e6199U,
    0xd243d119U,
    0x7d2f98ecU,
    0x66e53f3fU,
    0x57906268U,
    0xe15ad0ccU,
    0x3ac19faU,
    0xa227db3U,
    0xe66000c7U,
    0x8650029cU,
    0x9b3800e2U,
    0x7fe40317U,
    0xb21e03f1U,
    0xff1901d5U,
    0xfc838116U,
    0xfbc7428cU,
    0xe17062afU,
    0xecad250U,
    0xf6f41918U,
    0x8f967ea4U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x78000000U,
    0x7c000000U,
    0xe2000000U,
    0x11000000U,
    0xb800000U,
    0x7ec00000U,
    0xf9600000U,
    0x25500000U,
    0xbfa80000U,
    0x402c0000U,
    0xa8e20000U,
    0x968b0000U,
    0x9f418000U,
    0xa2b54000U,
    0xe1a8a000U,
    0x1325b000U,
    0x827a3800U,
    0x4bde3c00U,
    0x1ce92200U,
    0xe090f100U,
    0x88529b80U,
    0xf63b8f40U,
    0x1ff31be0U,
    0xf21eccf0U,
    0xc913ba08U,
    0x47877e04U,
    0x34c3804eU,
    0xec6e424bU,
    0xb0c1220dU,
    0x327cf261U,
    0xa3d098b8U,
    0xf8e08d4fU,
    0xae9a98e0U,
    0x3478e70U,
    0x90b91ac8U,
    0x88b9cca4U,
    0x64b0385eU,
    0x1eb93c33U,
    0xa3aaa3c1U,
    0x323eb30bU,
    0x21f3baedU,
    0x31177c11U,
    0x7b8b8270U,
    0x36d241ebU,
    0x2d6b20beU,
    0xc34bf243U,
    0x30bb1909U,
    0xb8a2cfafU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x18000000U,
    0x3c000000U,
    0x3e000000U,
    0x99000000U,
    0xd3800000U,
    0x13c00000U,
    0x3ee00000U,
    0x58500000U,
    0x51280000U,
    0xb8ac0000U,
    0x60660000U,
    0x22070000U,
    0xf70d8000U,
    0x4286c000U,
    0x1449a000U,
    0x37393000U,
    0xfda11800U,
    0x7df14c00U,
    0xb0c42200U,
    0x267ff100U,
    0x3708bb80U,
    0xe2987fc0U,
    0x44d3a60U,
    0xdf22bdf0U,
    0xd9aa9978U,
    0x7fe08ca4U,
    0x17c802aeU,
    0x6cfc027fU,
    0xf74e03e3U,
    0xcfab0035U,
    0x62eb8292U,
    0xd641c039U,
    0x302422ccU,
    0xa72ff3c2U,
    0x55a0b92dU,
    0xb9f47ec6U,
    0x42cb3a6fU,
    0x9975bed7U,
    0x418f196fU,
    0x1cca4c57U,
    0xb067a12fU,
    0x6a0233f7U,
    0xc3029bbfU,
    0xa88c8effU,
    0x974e00a3U,
    0x7fab0115U,
    0x9aeb8242U,
    0x1a41c391U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x98000000U,
    0x64000000U,
    0x2e000000U,
    0xab000000U,
    0xfc800000U,
    0xe6c00000U,
    0xf8a00000U,
    0x26500000U,
    0xf4680000U,
    0x2bec0000U,
    0x8daa0000U,
    0x39d70000U,
    0xf22a8000U,
    0xef88c000U,
    0x4e50e000U,
    0xd879d000U,
    0x19e2f800U,
    0xfcbb2400U,
    0xd85a6200U,
    0x27611100U,
    0x237a1b80U,
    0xdd7ef640U,
    0xe7a9860U,
    0x6e13490U,
    0x5620f938U,
    0x618025ecU,
    0x955ae012U,
    0x2cfed14bU,
    0x3207abaU,
    0x4e1fe5e5U,
    0x7b0080fbU,
    0x849fc108U,
    0x12da611eU,
    0x4ea11309U,
    0xe95a1a69U,
    0x26eef583U,
    0x66329984U,
    0x899d341cU,
    0xf942f83aU,
    0xfeeb24dfU,
    0xe23263a4U,
    0x378d12ecU,
    0xca501892U,
    0x6669f58bU,
    0x2af01b1aU,
    0x6439f555U,
    0x10981833U,
    0x74d5f4ccU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0xa8000000U,
    0x6c000000U,
    0xf2000000U,
    0xdf000000U,
    0x42800000U,
    0x15c00000U,
    0x57200000U,
    0x63500000U,
    0x4e80000U,
    0xed640000U,
    0x5c2a0000U,
    0x57d90000U,
    0xf0238000U,
    0x45dd4000U,
    0x1f396000U,
    0x3f4a9000U,
    0xcef09800U,
    0xf6761400U,
    0x80bae200U,
    0x6f07d100U,
    0x3a81fa80U,
    0x71c88640U,
    0x592878a0U,
    0xe65cc4b0U,
    0xf57a9b48U,
    0x483f143cU,
    0xc1d1632aU,
    0x212e92a7U,
    0x825a9ab4U,
    0xfb6f1501U,
    0xcd396271U,
    0x304a902eU,
    0x8470986eU,
    0x1fb615b9U,
    0x8d9ae325U,
    0xbf57d3c8U,
    0x8ee9f90bU,
    0x566c86a6U,
    0x10a27832U,
    0xc715c4c3U,
    0x56911adaU,
    0x83d654b8U,
    0x862a0354U,
    0xa4d902e6U,
    0xe0a383e5U,
    0x1f1d415fU,
    0xa29961b7U,
    0x25da92bbU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x48000000U,
    0x4c000000U,
    0xd6000000U,
    0x63000000U,
    0x9f800000U,
    0xbf400000U,
    0xb6a00000U,
    0x76d00000U,
    0x2ae80000U,
    0xffe40000U,
    0xb3720000U,
    0x2ba50000U,
    0x764f8000U,
    0x6425c000U,
    0xc102e000U,
    0x3e8bb000U,
    0x31d5c800U,
    0x3f700400U,
    0x1da56200U,
    0xe54a7100U,
    0xe3a52a80U,
    0x7a5eb540U,
    0x123f2b20U,
    0xf21fb430U,
    0xe902abd8U,
    0xc29f75ccU,
    0x5fcfcbdeU,
    0x871078dU,
    0x5038e022U,
    0xa31ab127U,
    0x7f804a2dU,
    0x4f54c4feU,
    0xaeba0211U,
    0x72d10234U,
    0xb0f5800eU,
    0x4af4c185U,
    0x4ff760e6U,
    0xb7f71bdU,
    0x7fa2aafaU,
    0xa44f766bU,
    0x9d27c8b3U,
    0xeb950653U,
    0x7d4ae103U,
    0xa7bfb14bU,
    0x404fc92fU,
    0xf7310645U,
    0x4698e12aU,
    0x85cab063U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x98000000U,
    0x64000000U,
    0x6000000U,
    0x65000000U,
    0x55800000U,
    0xb6400000U,
    0x17600000U,
    0x15d00000U,
    0x7c280000U,
    0x633c0000U,
    0x71be0000U,
    0x91670000U,
    0x30de8000U,
    0x49b1c000U,
    0xe5692000U,
    0xfecbf000U,
    0xe0a12800U,
    0x4af2bc00U,
    0x4f9fa200U,
    0xc1463100U,
    0xd9f60980U,
    0xc71e4cc0U,
    0x16800860U,
    0xd6d54c90U,
    0x5ca88b98U,
    0x48ef8c54U,
    0x1c8928b6U,
    0x69cebe89U,
    0x5e21a1a5U,
    0x60213193U,
    0x71288b5eU,
    0xeaaf8f91U,
    0xf5e928b5U,
    0x4d1ebdcfU,
    0xe989a3a0U,
    0xb45d3270U,
    0x44768948U,
    0xbd588fecU,
    0xfbffab52U,
    0xc4037e97U,
    0x16168090U,
    0xad1dc09cU,
    0x999f209eU,
    0x4c40f171U,
    0x1069aa65U,
    0x23587e77U,
    0xfaf60044U,
    0x978b026eU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x68000000U,
    0x5c000000U,
    0xaa000000U,
    0x5d000000U,
    0x91800000U,
    0x34400000U,
    0x4a00000U,
    0xf7d00000U,
    0x19e80000U,
    0xf4fc0000U,
    0x3d7a0000U,
    0x4d390000U,
    0xc79d8000U,
    0xf35e4000U,
    0xd0232000U,
    0x7613f000U,
    0xb716e800U,
    0xac8bc400U,
    0xb5d6a200U,
    0x58f1b100U,
    0xaf6fc980U,
    0x44313440U,
    0xb015cba0U,
    0x58083470U,
    0x44084928U,
    0x8e167434U,
    0xc30b6866U,
    0x3a9584e1U,
    0x52d5809aU,
    0xfc72429bU,
    0x56b120a9U,
    0xded6f346U,
    0x1e7169a9U,
    0x27ac863eU,
    0x9d480185U,
    0x432c0364U,
    0x44920006U,
    0xa9c50071U,
    0x92e780e2U,
    0xe2674137U,
    0xbdbea0b3U,
    0xd84db0e5U,
    0xf6b5ca8cU,
    0xeed83452U,
    0x6604887U,
    0x3aa767bU,
    0x3516b01U,
    0xe83c87b2U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xc8000000U,
    0x64000000U,
    0x9a000000U,
    0xfd000000U,
    0xa6800000U,
    0xecc00000U,
    0x86200000U,
    0x8500000U,
    0xabe80000U,
    0xcef40000U,
    0x74660000U,
    0x8ea50000U,
    0xfb8e8000U,
    0xfa584000U,
    0x82f02000U,
    0x1a7c1000U,
    0xf1bcf800U,
    0xfc187400U,
    0x8616a200U,
    0xeb105100U,
    0x558ad880U,
    0xe55167c0U,
    0x556cd920U,
    0x5e346490U,
    0x344258e8U,
    0x4dfc2534U,
    0xf5fa7b3aU,
    0x19e434e3U,
    0xc7e881d0U,
    0x50fd4085U,
    0xc37ea1fdU,
    0xed24512cU,
    0x1dccd81bU,
    0x6ea467ccU,
    0x6b8a59abU,
    0xe25825b4U,
    0xdef47b77U,
    0x2c75343aU,
    0xf2a000eeU,
    0x3d900269U,
    0x3148014bU,
    0x27640089U,
    0x372e0176U,
    0xc0c10008U,
    0x38208384U,
    0x4f5942c2U,
    0x70a07fU,
    0x4cb5523eU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x88000000U,
    0x74000000U,
    0x6e000000U,
    0x2f000000U,
    0x7f800000U,
    0x4c400000U,
    0xfea00000U,
    0xc9d00000U,
    0x23e80000U,
    0x8ffc0000U,
    0x3dea0000U,
    0xf8e50000U,
    0xde688000U,
    0x3ebac000U,
    0xe9dc6000U,
    0xd3ebb000U,
    0x97f02800U,
    0xc1ed8400U,
    0xe2fce200U,
    0x9f7d7100U,
    0x6e2e4980U,
    0xda1f3640U,
    0x610e4820U,
    0xa08f34d0U,
    0x2bc64a38U,
    0x4ee337fcU,
    0x2d64485eU,
    0xab2a37a1U,
    0xfc8ecbe2U,
    0x81c9f50bU,
    0x77f02969U,
    0x11ed8522U,
    0xafce2ebU,
    0x7b7d73d9U,
    0x882e4beaU,
    0x811f37ffU,
    0x708e4843U,
    0xc3cf34e9U,
    0xaae64962U,
    0xcb7337cbU,
    0xf02c4889U,
    0xed063492U,
    0xe28cc8a3U,
    0xf6d0f70dU,
    0x9472a910U,
    0xd7b2468cU,
    0x3d4802f6U,
    0x962c0345U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0xe8000000U,
    0xfc000000U,
    0x12000000U,
    0x67000000U,
    0xf4800000U,
    0xeac00000U,
    0xbe600000U,
    0x40500000U,
    0xf9b80000U,
    0x89bc0000U,
    0x31ba0000U,
    0x45b90000U,
    0x3ba98000U,
    0xa6a94000U,
    0xc9386000U,
    0xc5685000U,
    0xf6c77800U,
    0xfc637c00U,
    0xaf49e200U,
    0x612d1300U,
    0x997d1980U,
    0x14ce2e40U,
    0xe37d19a0U,
    0x4fce2cf0U,
    0x65fd1bc8U,
    0x520e2cdcU,
    0xc71d1bf2U,
    0x49e2d1bU,
    0x92c51a91U,
    0xaa722e2dU,
    0xae47185cU,
    0x8cb72ea1U,
    0x1a349985U,
    0x2ff76c90U,
    0x111d7a4bU,
    0xc58a7d3aU,
    0x1f586147U,
    0xb93851a3U,
    0x7d7f7b56U,
    0x82df7cddU,
    0x8273e294U,
    0x325410fdU,
    0xeb499b7U,
    0x95376c6bU,
    0x277d7a8aU,
    0xe9da7fafU,
    0x1ce0634fU,
    0xab84500cU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0x38000000U,
    0x7c000000U,
    0xb2000000U,
    0xaf000000U,
    0xb8800000U,
    0x54c00000U,
    0x4a600000U,
    0x8a500000U,
    0x77b80000U,
    0xc1ac0000U,
    0x80b60000U,
    0x35330000U,
    0xbe658000U,
    0x5c5b4000U,
    0x6a76000U,
    0xac3bd000U,
    0x87f7b800U,
    0x5d017c00U,
    0x379ae200U,
    0xfc5c9300U,
    0xd6bedb80U,
    0x8435afc0U,
    0x33e6dae0U,
    0xab09aef0U,
    0x5688db48U,
    0x59c6ae7cU,
    0x95e35b82U,
    0x2202ec63U,
    0xa717ba81U,
    0x1c917da5U,
    0x6ac2e094U,
    0x6f6091d9U,
    0xe1d0d861U,
    0x29faaf22U,
    0x700d58c4U,
    0xf80ded41U,
    0x9c1c3b45U,
    0x42053c64U,
    0x970e0191U,
    0xc49f019dU,
    0xe6d38160U,
    0xe5684147U,
    0x32c2e0b0U,
    0x23609168U,
    0x8bd0dbecU,
    0xafaaefaU,
    0x428d5a37U,
    0x7fcded4fU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0xc8000000U,
    0x14000000U,
    0x8e000000U,
    0xcf000000U,
    0x7d800000U,
    0x5bc00000U,
    0x53200000U,
    0x49500000U,
    0x85780000U,
    0xb9ac0000U,
    0x93120000U,
    0x279d0000U,
    0xfac48000U,
    0x31b2c000U,
    0xa7126000U,
    0x9984f000U,
    0x2ddf5800U,
    0x90263400U,
    0x66c4e200U,
    0x8bab3300U,
    0xd609bb80U,
    0x33100740U,
    0xd789d920U,
    0x2c9f750U,
    0x3db203b8U,
    0xf50d037cU,
    0xcc9c8156U,
    0x114ec27fU,
    0x79786054U,
    0x13b5f249U,
    0xca09d9dbU,
    0x4909f4b5U,
    0x469200f6U,
    0x785d03d4U,
    0xfe48332U,
    0x73e2c045U,
    0x19ea61e5U,
    0xa0e8f04eU,
    0x1e6d5b28U,
    0x6a2b3524U,
    0x37d8631aU,
    0x1125f2e1U,
    0x3451dbbfU,
    0x7df5f68fU,
    0x16f80147U,
    0x3d6c01d3U,
    0x95b201c1U,
    0xf10d01d4U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0xa8000000U,
    0x64000000U,
    0x96000000U,
    0x23000000U,
    0xf800000U,
    0x50400000U,
    0xc8600000U,
    0xcd00000U,
    0x9fb80000U,
    0xa0fc0000U,
    0x550e0000U,
    0xdc810000U,
    0x97c68000U,
    0xcc21c000U,
    0xfaade000U,
    0xd477b000U,
    0xa6d8a800U,
    0x86ae9c00U,
    0x4e656200U,
    0x17d77300U,
    0xc33c980U,
    0x9ab8ecc0U,
    0xe47028a0U,
    0xede5e90U,
    0xe2b601d8U,
    0xd87d034cU,
    0x34c8831eU,
    0x3a0c011U,
    0xcaeb63d9U,
    0x2c16712fU,
    0x2154818U,
    0x7d092f4eU,
    0x7885c84bU,
    0x61c5ed00U,
    0xdf38a880U,
    0x5d3e9e40U,
    0xe03d61e0U,
    0xf8bb70f0U,
    0xa965c8e8U,
    0xde55ef84U,
    0xe760aa4aU,
    0x91529f63U,
    0x4aeb6386U,
    0xec16711fU,
    0x62154a72U,
    0x4d092cdfU,
    0xd085c870U,
    0x5c5ee8aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x58000000U,
    0x4000000U,
    0x82000000U,
    0x5000000U,
    0x5800000U,
    0x52400000U,
    0x42e00000U,
    0xcad00000U,
    0x71280000U,
    0xe8740000U,
    0x340a0000U,
    0xa070000U,
    0x79168000U,
    0x13894000U,
    0x8d4b2000U,
    0x46707000U,
    0x1f0aa800U,
    0x64804c00U,
    0x65d7a200U,
    0xddbe3100U,
    0xd1b70880U,
    0x6fa97e40U,
    0x5cbe2b60U,
    0x163a0d10U,
    0x18e00088U,
    0x8bd00354U,
    0xd6a801f6U,
    0x2f340319U,
    0x2b6a0263U,
    0x9697032fU,
    0xc8de83daU,
    0x342d42fcU,
    0xcde921cdU,
    0xf643724aU,
    0x10f6292bU,
    0xb7de0cc4U,
    0xe0a20121U,
    0x60330390U,
    0x77fc81c8U,
    0x475e43b4U,
    0x5f75a326U,
    0xbc8d3231U,
    0x21cb8b07U,
    0x7fb73d21U,
    0x44ab8a8fU,
    0x32273ef5U,
    0xae38939U,
    0xd6c33c8cU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x98000000U,
    0x34000000U,
    0x22000000U,
    0x2b000000U,
    0xbd800000U,
    0x79400000U,
    0x2fe00000U,
    0x57d00000U,
    0xaf280000U,
    0x1b640000U,
    0xf81e0000U,
    0xe40f0000U,
    0x2a148000U,
    0xb7114000U,
    0x3390e000U,
    0x44557000U,
    0x9b6e0800U,
    0xb8072c00U,
    0x441a6200U,
    0x1a0b3100U,
    0x2f0a6a80U,
    0x7931cc0U,
    0x664c8860U,
    0xb07d6dd0U,
    0x5800008U,
    0x3d40016cU,
    0x35e00216U,
    0x78d001f5U,
    0xa8a80257U,
    0x7d240123U,
    0x487e00c2U,
    0xe19f0124U,
    0x175c81a9U,
    0x82e5432aU,
    0x4b46e2abU,
    0xecee73eeU,
    0xe64c8992U,
    0xf07d6eecU,
    0xa5800325U,
    0xd4002acU,
    0xade003f6U,
    0x4cd00365U,
    0x8aa8007fU,
    0x5624033fU,
    0xf5fe026cU,
    0x98df00e5U,
    0x38bc834cU,
    0xd5354166U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x68000000U,
    0x24000000U,
    0xaa000000U,
    0x93000000U,
    0xf4800000U,
    0xc4c00000U,
    0x8da00000U,
    0xb7500000U,
    0xcff80000U,
    0x51240000U,
    0x37920000U,
    0x98410000U,
    0xcd6a8000U,
    0x40f24000U,
    0x83b3e000U,
    0x4e535000U,
    0x869b800U,
    0xb16e4400U,
    0x16eb6200U,
    0x86b01300U,
    0x1fc8da80U,
    0x4d2b5740U,
    0x11833ba0U,
    0x255c0790U,
    0xd0f88228U,
    0x8bb3420cU,
    0x1a5960f2U,
    0x1a6110c3U,
    0x6e7a593eU,
    0x6c6d1401U,
    0x7b7ad845U,
    0xf5fa571bU,
    0xca31b9baU,
    0x971a47efU,
    0x4e81631cU,
    0x9fd5124aU,
    0x8d305867U,
    0xb1981780U,
    0xf55a5910U,
    0xb8fd1768U,
    0xafa2daacU,
    0xb04e55e2U,
    0x897bb9abU,
    0x9aef4692U,
    0xa8a1e263U,
    0xf6d2532eU,
    0x42a339e9U,
    0x5cc05a9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x28000000U,
    0xcc000000U,
    0x4a000000U,
    0x81000000U,
    0x61800000U,
    0x4a400000U,
    0xdee00000U,
    0x2ed00000U,
    0x83380000U,
    0x69740000U,
    0x678a0000U,
    0x41590000U,
    0x1e7f8000U,
    0x151e4000U,
    0x3f94a000U,
    0x5558f000U,
    0x80722800U,
    0x2a12cc00U,
    0x71012200U,
    0x798fb300U,
    0xbe410880U,
    0x70f07c40U,
    0x29d5aaa0U,
    0x29a88c30U,
    0xc3a783a8U,
    0x92ba4144U,
    0xfb26a1a6U,
    0x6d75f259U,
    0xd187aaf3U,
    0xb2558d8fU,
    0x1aea00a2U,
    0xb8c90188U,
    0x602783e3U,
    0x45fa40d7U,
    0x646a1aeU,
    0x54e5f27aU,
    0x8fdfaa44U,
    0xf2b18ff1U,
    0xb380060U,
    0x757403d0U,
    0x258a02b8U,
    0x1c59001cU,
    0x1dff82aaU,
    0x125e42abU,
    0xcaf4a3d4U,
    0xb0c8f2e9U,
    0xbc2a29ccU,
    0x27f6cf12U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x98000000U,
    0xe4000000U,
    0x76000000U,
    0xb5000000U,
    0xe3800000U,
    0xae400000U,
    0xfe200000U,
    0x94d00000U,
    0x9e80000U,
    0x1bbc0000U,
    0x57860000U,
    0x90570000U,
    0xa72e8000U,
    0x8d53c000U,
    0x18b12000U,
    0x21123000U,
    0x4d9ba800U,
    0x9f4a1400U,
    0x9bb9a200U,
    0x1786f100U,
    0xf04c0980U,
    0x5727e7c0U,
    0x155d2860U,
    0xfca5d690U,
    0x570e8258U,
    0xf883c014U,
    0x7cd9206eU,
    0x35ee32e9U,
    0xe9bda840U,
    0x648d1717U,
    0x5edf2071U,
    0xef93103U,
    0xab3328a8U,
    0xc74ed56bU,
    0x5fa60123U,
    0xf1870298U,
    0x2d468143U,
    0xc8afc3bfU,
    0x2917231aU,
    0xc1953320U,
    0x955d2ab0U,
    0xbca5d668U,
    0x370e833cU,
    0x883c072U,
    0xe4d9202bU,
    0xd1ee3203U,
    0x9fbda828U,
    0xd18d172bU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0xd8000000U,
    0x24000000U,
    0x82000000U,
    0x91000000U,
    0xa2800000U,
    0x2f400000U,
    0x19200000U,
    0xed00000U,
    0x1df80000U,
    0x5e2c0000U,
    0xb74a0000U,
    0x1d3f0000U,
    0x7cca8000U,
    0x44f14000U,
    0xa1a000U,
    0x3e0a9000U,
    0x17188800U,
    0x419fd400U,
    0xd4d92200U,
    0x68e8d300U,
    0x9eb9ab80U,
    0x191b0440U,
    0x7e8a8960U,
    0x795cd790U,
    0xc221a388U,
    0xc14a9104U,
    0x36388a6aU,
    0x7b4fd46dU,
    0x9321230cU,
    0x83c4d1efU,
    0x973ab75U,
    0xba6407c1U,
    0xb9e00953U,
    0x1c3d9762U,
    0xc6580268U,
    0xafbc0154U,
    0x8b9200c2U,
    0x79c30199U,
    0x8c78827eU,
    0xb2e2428eU,
    0xeba12257U,
    0xd984d3c9U,
    0xd0d3aa17U,
    0x1af40568U,
    0xc7b80915U,
    0x47819610U,
    0xf7ca0109U,
    0x737f0076U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0xf8000000U,
    0x5c000000U,
    0x26000000U,
    0x5000000U,
    0xf2800000U,
    0x91400000U,
    0x43600000U,
    0x8d00000U,
    0x61b80000U,
    0x82740000U,
    0x90560000U,
    0xfbe30000U,
    0x62818000U,
    0x795dc000U,
    0x37702000U,
    0x7adf1000U,
    0xe6b14800U,
    0xfe91c00U,
    0xd09fa200U,
    0xde55d300U,
    0x4af6e880U,
    0xc218cfc0U,
    0x9f0749e0U,
    0x19a1e70U,
    0x6ec62218U,
    0x84ac10d4U,
    0xa0e8c8aaU,
    0x910dcf5U,
    0x1c818075U,
    0x105dc247U,
    0x3bf02254U,
    0x429f1398U,
    0x89514b66U,
    0xcf791cf9U,
    0x26c7a399U,
    0xc0b1d0dbU,
    0xaf8e850U,
    0x221fcd88U,
    0x4f08c8bcU,
    0x980dc66U,
    0xcad9818bU,
    0xfeb9c1aaU,
    0x83fe2087U,
    0xfe9811c6U,
    0x7f5ec95bU,
    0xc263dfe2U,
    0x705803dbU,
    0x2be400d0U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x58000000U,
    0x3c000000U,
    0x82000000U,
    0x53000000U,
    0x5c800000U,
    0xd3c00000U,
    0x67e00000U,
    0xb6500000U,
    0x4fa80000U,
    0x58ec0000U,
    0x70c20000U,
    0x137f0000U,
    0x31918000U,
    0x1e494000U,
    0x5bbae000U,
    0x8ef65000U,
    0x15d35800U,
    0xfafe8c00U,
    0x53c16200U,
    0x27ec1100U,
    0x565a3b80U,
    0x9fae9f40U,
    0xf15b60U,
    0x4cd18df0U,
    0x9178e388U,
    0x6289530cU,
    0x42c2db92U,
    0x8877ccffU,
    0xe91b80f7U,
    0xa38a4265U,
    0xb54161c4U,
    0xb2c1020U,
    0x573a384eU,
    0x453e9d2bU,
    0xae39586fU,
    0x1ead8f8fU,
    0x1772e161U,
    0x1f8a521aU,
    0x77595a2dU,
    0xb83d8eb6U,
    0xdbbae0b1U,
    0xcef65302U,
    0xf5d35959U,
    0x2afe8ea0U,
    0xbc16250U,
    0x1bec1258U,
    0xd45a3a14U,
    0xccae9ce6U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x38000000U,
    0xdc000000U,
    0x92000000U,
    0xf000000U,
    0x97800000U,
    0x7fc00000U,
    0xee200000U,
    0x49500000U,
    0x8b780000U,
    0xa8240000U,
    0x50460000U,
    0x8deb0000U,
    0x95718000U,
    0xbd334000U,
    0x8cc16000U,
    0x5bb93000U,
    0xa1915800U,
    0x5ec45400U,
    0x34aee200U,
    0xe6157300U,
    0x691fba80U,
    0x3e8125c0U,
    0xe1495ae0U,
    0x7f705470U,
    0xe30e2c8U,
    0x594a72fcU,
    0x6370383eU,
    0x3c2d674fU,
    0x2647bb10U,
    0xccf52569U,
    0x9ff75abbU,
    0x5a7f55a3U,
    0x8aa760c7U,
    0x8302335dU,
    0x8d98dbe8U,
    0x34d317fdU,
    0x47a983a9U,
    0x9387404aU,
    0x21df60bcU,
    0x9b26309eU,
    0x45dedb9fU,
    0x15381508U,
    0x78d8018dU,
    0xfdb40261U,
    0xa89e0036U,
    0xb05f0142U,
    0x9def8331U,
    0x7d6c41ffU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0x38000000U,
    0x54000000U,
    0x5a000000U,
    0xf000000U,
    0xc6800000U,
    0x60400000U,
    0x4aa00000U,
    0x17d00000U,
    0xd1780000U,
    0x38a40000U,
    0xb4da0000U,
    0xb9eb0000U,
    0x9dfc8000U,
    0xff64000U,
    0x5cf06000U,
    0x3c771000U,
    0x652fa800U,
    0xe813e400U,
    0xc0ee200U,
    0x3e1e5300U,
    0xfd014a80U,
    0xa59db640U,
    0xa8d7aae0U,
    0x7ff7e650U,
    0x94f4e1e8U,
    0x6065517cU,
    0xc325c97aU,
    0xd11ff691U,
    0xcb85caa2U,
    0xcdcff633U,
    0x1e7dc9b7U,
    0x5e2bf41fU,
    0x4487c883U,
    0xcb50f729U,
    0xde234910U,
    0x8492b4aeU,
    0x6b512af7U,
    0x4e3aa759U,
    0xbc800208U,
    0x3f40008aU,
    0x14200149U,
    0xb3900226U,
    0xf9d8013dU,
    0x74740370U,
    0xf92203beU,
    0xee0f017fU,
    0xa5068135U,
    0xc18d40faU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0xb8000000U,
    0x34000000U,
    0x92000000U,
    0xdd000000U,
    0xff800000U,
    0xdcc00000U,
    0x9e200000U,
    0xee300000U,
    0x76280000U,
    0x92340000U,
    0x88320000U,
    0xd9250000U,
    0x80a38000U,
    0x1371c000U,
    0xafca6000U,
    0x62a59000U,
    0x56760800U,
    0xb441cc00U,
    0xa4760a00U,
    0x9941cf00U,
    0x3f60980U,
    0x4181cfc0U,
    0xb7d60b60U,
    0x46b1cf10U,
    0xac7e0928U,
    0xd545cc64U,
    0x45ec0ad6U,
    0x3e90cf17U,
    0x2d4788aeU,
    0x51e50cafU,
    0x7c97e976U,
    0x78519ee7U,
    0x22706356U,
    0x6449183U,
    0xa96f8b54U,
    0xeed10eceU,
    0x5325e86bU,
    0x79b49c84U,
    0x16f3e052U,
    0x12055245U,
    0x1d0de86bU,
    0x1f809c84U,
    0xecc1e052U,
    0x26205245U,
    0xda2e686bU,
    0xe4315c84U,
    0x4f2b8052U,
    0x77b5c245U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x8000000U,
    0xcc000000U,
    0x92000000U,
    0xb9000000U,
    0x10800000U,
    0xf3c00000U,
    0xb4200000U,
    0xe4300000U,
    0x1c380000U,
    0xb8340000U,
    0x56220000U,
    0x75230000U,
    0x10ba8000U,
    0x61e8c000U,
    0x9f1fe000U,
    0xdf8df000U,
    0xd45b8800U,
    0xc4610c00U,
    0xce5b8a00U,
    0xf1610d00U,
    0x2cdb8b80U,
    0xba10fc0U,
    0x807b8ba0U,
    0xd0510cf0U,
    0xba6389e8U,
    0x35550e14U,
    0xe0f989aaU,
    0xb820ddbU,
    0x12410b7aU,
    0xfb79ce4bU,
    0x81dc6b0aU,
    0xfd28fcabU,
    0x9cba0252U,
    0x93e7017fU,
    0x96008010U,
    0xc70fc1f8U,
    0xeb9f63ecU,
    0xe2423046U,
    0x9364e89dU,
    0xfdd33c67U,
    0x672763ecU,
    0xe9b63046U,
    0x1166e89dU,
    0xdcc03c67U,
    0x63a5e3ecU,
    0xfc6af046U,
    0x4a5b089dU,
    0xcf6ecc67U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x98000000U,
    0xec000000U,
    0x2a000000U,
    0x27000000U,
    0xa9800000U,
    0x9400000U,
    0x11e00000U,
    0x99f00000U,
    0x2de80000U,
    0x8be40000U,
    0x16f60000U,
    0x650000U,
    0x4cb88000U,
    0x7e1dc000U,
    0xd1092000U,
    0xcc841000U,
    0x63c93800U,
    0xef390400U,
    0x60493a00U,
    0x1790700U,
    0xb8293b80U,
    0x1c90540U,
    0x1c2139e0U,
    0xffdd06f0U,
    0xd3f3948U,
    0x535c066cU,
    0xfef1bbeeU,
    0x2464c649U,
    0x72a01ba9U,
    0xf0d142eU,
    0xed88031eU,
    0xa7540201U,
    0xf8fe0145U,
    0x49710100U,
    0x6c2681f7U,
    0x37dcc2b8U,
    0x1927a0d3U,
    0x54cd23aU,
    0x6bf099f4U,
    0x46f4d51aU,
    0xf87720d3U,
    0x30b5123aU,
    0xcc0fb9f4U,
    0x1a15c51aU,
    0x4f0698d3U,
    0x4d91d63aU,
    0x574fa3f4U,
    0xf0e8d21aU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0xf8000000U,
    0x84000000U,
    0x26000000U,
    0xa7000000U,
    0x3a800000U,
    0x9ec00000U,
    0x4fe00000U,
    0x87f00000U,
    0x4bf80000U,
    0xe1e40000U,
    0xce60000U,
    0xcb790000U,
    0x6a298000U,
    0x8d4000U,
    0xcbc9a000U,
    0xec66f000U,
    0x10b92800U,
    0x7e5ad400U,
    0x94392a00U,
    0x939ad500U,
    0xdf592980U,
    0xb9aad540U,
    0x3fc12a60U,
    0x627ed750U,
    0x2bbf2af8U,
    0xf6d3d5ccU,
    0x73e8aa12U,
    0xc5f397b7U,
    0xdaf68b2dU,
    0x847525a8U,
    0x2cb18202U,
    0x3c59422fU,
    0x537a031U,
    0xf60bf002U,
    0xff0eaa19U,
    0x4e8a9440U,
    0x50df08d6U,
    0x94f864e1U,
    0x1f78238cU,
    0x543fb3c4U,
    0x338e88d6U,
    0x2f5124e1U,
    0x51b7838cU,
    0x43d043c4U,
    0xc06620d6U,
    0xaaa2b0e1U,
    0x6b41098cU,
    0xd7a566c4U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0x28000000U,
    0x34000000U,
    0x76000000U,
    0x53000000U,
    0xb1800000U,
    0x57400000U,
    0xf5e00000U,
    0x4bf00000U,
    0x7cf80000U,
    0x837c0000U,
    0xab3a0000U,
    0x855f0000U,
    0x88e98000U,
    0x957f4000U,
    0xe8392000U,
    0x2ccd1000U,
    0xc3b4f800U,
    0x2291c400U,
    0x86ccfa00U,
    0xb2adc500U,
    0xa616fa80U,
    0x2b02c5c0U,
    0xbd877a20U,
    0xd418510U,
    0xcce45bf8U,
    0xeb63945cU,
    0xbf21213eU,
    0xc3411101U,
    0xf3f6f8e9U,
    0x10f2c52eU,
    0xc97f7b9aU,
    0x8a3d86e3U,
    0x39de5916U,
    0x93c94e6U,
    0xf048a24dU,
    0x527e532fU,
    0x5fafd8f3U,
    0x208fd68dU,
    0x83d3806cU,
    0x602043b5U,
    0x68d0a273U,
    0xbdb2534dU,
    0x758dda4cU,
    0x695cd6a5U,
    0x82f8018bU,
    0x947c0311U,
    0x64ba0172U,
    0x851f02a4U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x98000000U,
    0xc000000U,
    0x6a000000U,
    0x85000000U,
    0x30800000U,
    0xd7c00000U,
    0x7ae00000U,
    0x9cf00000U,
    0x33f80000U,
    0xa67c0000U,
    0x11360000U,
    0x24050000U,
    0xce148000U,
    0xb11c000U,
    0x1b856000U,
    0x9c497000U,
    0x7ea08800U,
    0xee5e5400U,
    0xb7b88a00U,
    0x94d25500U,
    0xb5768a80U,
    0x46ab5440U,
    0xf25408e0U,
    0x65bf9470U,
    0x4dc5e948U,
    0x77e72664U,
    0x1860018aU,
    0xd230013bU,
    0xab980261U,
    0x344c0248U,
    0x9aae022eU,
    0x40490191U,
    0xccba800aU,
    0x4758c131U,
    0xbd3fe29aU,
    0x5e11b309U,
    0xf31f6a36U,
    0x678fe627U,
    0x3e47e027U,
    0x6fadb2edU,
    0xb8c968b6U,
    0x8f7ae667U,
    0x5bab62c7U,
    0xcec0739dU,
    0xd87a0b7eU,
    0xb2369443U,
    0xdb9f6badU,
    0xfc4fe6d6U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x48000000U,
    0xa4000000U,
    0xb6000000U,
    0x69000000U,
    0x56800000U,
    0x18400000U,
    0x4e200000U,
    0xcc300000U,
    0xbb280000U,
    0xd0ac0000U,
    0xb0760000U,
    0x631f0000U,
    0xa59b8000U,
    0x15d54000U,
    0xffc6000U,
    0xeddcb000U,
    0xd3feb800U,
    0x47cffc00U,
    0x30f6ba00U,
    0x2253ff00U,
    0x528ba80U,
    0xfda0fc40U,
    0xa0e53ba0U,
    0x8a5abed0U,
    0x512ad978U,
    0xd3bf4f74U,
    0x25fe0022U,
    0xcec30315U,
    0x9665831aU,
    0xa2164325U,
    0xa719e176U,
    0x238af327U,
    0xc4c75a97U,
    0x65750c3bU,
    0xaf99e0d9U,
    0xe6caf2c8U,
    0x2675b3cU,
    0xac050d5eU,
    0xf211e2ebU,
    0x2f16f1a1U,
    0xa79959bcU,
    0xa2c60d1eU,
    0x4474634bU,
    0x5d00b071U,
    0x4880ba44U,
    0x254cfe2aU,
    0x36b338c9U,
    0x5175bdb4U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x38000000U,
    0xc4000000U,
    0xe6000000U,
    0x85000000U,
    0x23800000U,
    0x39c00000U,
    0x84e00000U,
    0x5ef00000U,
    0x19f80000U,
    0xc96c0000U,
    0x5e2a0000U,
    0x3c8d0000U,
    0xfd458000U,
    0x5db14000U,
    0x7545e000U,
    0xe1bf9000U,
    0xf753a800U,
    0xb2b1b400U,
    0x69cbaa00U,
    0x6cedb500U,
    0x32f9a880U,
    0x33fcb5c0U,
    0x566e2860U,
    0xdaacf6d0U,
    0x45c44bf8U,
    0xe6ef24c4U,
    0x9df78376U,
    0x8f604023U,
    0xeb326365U,
    0x271fd058U,
    0x81c982U,
    0x3f5e67bdU,
    0xaeb2621aU,
    0xdbdfd15fU,
    0x7e1caf7U,
    0x686e67fdU,
    0xbaa63ccU,
    0x8843d24cU,
    0xa633c9faU,
    0x188f6539U,
    0x8b45e34cU,
    0xd0bf938cU,
    0xaad3ab9aU,
    0xfa71b6e9U,
    0x10aba834U,
    0x4addb688U,
    0x6a61aa8cU,
    0x18a0b51aU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x88000000U,
    0xac000000U,
    0x5e000000U,
    0x2d000000U,
    0xf8800000U,
    0x88c00000U,
    0x5ea00000U,
    0x13b00000U,
    0xfb380000U,
    0x1be40000U,
    0xb94e0000U,
    0x7cef0000U,
    0x6c28000U,
    0xbbad4000U,
    0xa726e000U,
    0x7df6f000U,
    0xe0556800U,
    0xfe6bfc00U,
    0x511b6a00U,
    0x6e84fd00U,
    0xe9d9e980U,
    0xa829bc40U,
    0x3e7f0ba0U,
    0xf11f4ef0U,
    0xde8a62d8U,
    0x31c4b244U,
    0x8c290b3aU,
    0xcc644d67U,
    0x821ee3c0U,
    0xb12f169U,
    0x419b6b8cU,
    0x5a44fff6U,
    0x8179ebb1U,
    0x6a99bc41U,
    0xebc70890U,
    0xe33b4fc8U,
    0x9fe463ccU,
    0xfb5bb256U,
    0xd7f38a41U,
    0xf75d0e19U,
    0x39ee0114U,
    0x25f0012U,
    0xe57a817bU,
    0x7889437eU,
    0xc8c8e2d4U,
    0xbea9f17bU,
    0x43afeaf7U,
    0x7322bc88U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0xa8000000U,
    0xf4000000U,
    0xf6000000U,
    0xbf000000U,
    0x7c800000U,
    0x7c00000U,
    0x4ee00000U,
    0x81f00000U,
    0x95680000U,
    0xc6bc0000U,
    0x8e420000U,
    0x18a70000U,
    0x5518000U,
    0x32334000U,
    0x4d86a000U,
    0xa85e3000U,
    0x3fa74800U,
    0x85c1d400U,
    0xc7e54a00U,
    0xe266d700U,
    0x1e34c880U,
    0x279594c0U,
    0xb5526a20U,
    0xfa3ba710U,
    0xe99d21f8U,
    0x64671ecU,
    0xdcba6a0aU,
    0xfb47a6f3U,
    0x893f23b1U,
    0x6f117034U,
    0xe483ebc4U,
    0xfbc8e43eU,
    0xbcfb8005U,
    0x60e841b0U,
    0xa2f5201aU,
    0x4bfa708bU,
    0x78786a1dU,
    0xab20a6deU,
    0x160ea307U,
    0x2f1233e7U,
    0x848d4be5U,
    0xabdad732U,
    0xe4f6c90dU,
    0x3cf29514U,
    0xa0e3e854U,
    0x2f8e706U,
    0xbbf382c9U,
    0xd064412aU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x88000000U,
    0x1c000000U,
    0x16000000U,
    0xb9000000U,
    0x3f800000U,
    0x2a400000U,
    0xf3e00000U,
    0x62f00000U,
    0xf1680000U,
    0x35340000U,
    0x7bc60000U,
    0xa4a70000U,
    0xcc8c8000U,
    0x9ada4000U,
    0x2f3b6000U,
    0x9cd39000U,
    0xde3e5800U,
    0x5f446400U,
    0x72785a00U,
    0x9da36700U,
    0x3314d980U,
    0x50892540U,
    0x4cc7bba0U,
    0x762eb530U,
    0x335fe3f8U,
    0x7c7dd3d4U,
    0xb0a33906U,
    0x680f47dU,
    0xd5c28349U,
    0x39b940b6U,
    0x119e32cU,
    0x1b9ad152U,
    0xd84fbb3bU,
    0x58eab714U,
    0x6671e08fU,
    0x57aed042U,
    0x7c09badaU,
    0x460db4b7U,
    0xd11d62f6U,
    0xb384910cU,
    0xb45ad922U,
    0x56ea2763U,
    0x4b653bf0U,
    0x6227f571U,
    0xf94e026bU,
    0x336303d5U,
    0xa62282dcU,
    0x9b494323U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0x58000000U,
    0x2c000000U,
    0x12000000U,
    0x31000000U,
    0xe800000U,
    0x1f400000U,
    0x62e00000U,
    0x1bf00000U,
    0x81780000U,
    0xd02c0000U,
    0x19d60000U,
    0x49ad0000U,
    0xe7108000U,
    0x699ec000U,
    0x36dee000U,
    0xf43a3000U,
    0x3fdd5800U,
    0xe6a5c400U,
    0x1a8b5a00U,
    0x1148c500U,
    0x69fbd880U,
    0x80660640U,
    0xf6bd39e0U,
    0xa28036f0U,
    0x4d4e61a8U,
    0xf3e4f234U,
    0xc563bb92U,
    0xc62ff749U,
    0x9ece0299U,
    0x10310166U,
    0xf9de817cU,
    0x39afc0d6U,
    0x6f0062b3U,
    0x1d95f2c4U,
    0x8dd383dU,
    0xd730376bU,
    0x56631fU,
    0xf778f16dU,
    0x672db8d4U,
    0x685ef7e5U,
    0xf37082b7U,
    0xd12ec359U,
    0x3f46e346U,
    0xf2e630acU,
    0xe3f3582eU,
    0x7d64c63fU,
    0x9a2dd83aU,
    0x4cb057aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xf8000000U,
    0xa4000000U,
    0x1a000000U,
    0xa7000000U,
    0x88800000U,
    0x6b400000U,
    0x7200000U,
    0x8300000U,
    0x6cb80000U,
    0x61fc0000U,
    0x8fc20000U,
    0x4a6d0000U,
    0xc6018000U,
    0x591ec000U,
    0x15982000U,
    0xb4cc3000U,
    0x1cf4d800U,
    0xc04cfc00U,
    0x79b6da00U,
    0xa261fd00U,
    0xa175a80U,
    0xcf0f3ec0U,
    0x4977960U,
    0xdd4f0c50U,
    0xe639a108U,
    0x99a2f2ccU,
    0x3274f92aU,
    0x220cce61U,
    0x631803b6U,
    0x428c0081U,
    0xc45a0364U,
    0xd3a10156U,
    0xdd7b8253U,
    0xd68fc3b3U,
    0x465ba0e1U,
    0xbff376U,
    0x47ed7ae1U,
    0x46de0eb4U,
    0x77fa231eU,
    0xded130bfU,
    0x3ed5be9U,
    0xccde3c78U,
    0xf8f4fa34U,
    0xfa4ccedeU,
    0x2eb8005fU,
    0xd2fc00f9U,
    0xc5420350U,
    0xd22d0288U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xd8000000U,
    0x1c000000U,
    0x46000000U,
    0xd1000000U,
    0x20800000U,
    0x42400000U,
    0xae200000U,
    0xfb300000U,
    0xe1a80000U,
    0xa4fc0000U,
    0x135a0000U,
    0x4eb10000U,
    0x197a8000U,
    0x7f9e4000U,
    0x87c66000U,
    0xeee77000U,
    0xac53b800U,
    0xdb233c00U,
    0x11a9ba00U,
    0xdce23f00U,
    0x3f5b3880U,
    0xd0b07fc0U,
    0xd46f5be0U,
    0x191a0fb0U,
    0x149c62f8U,
    0x605670f4U,
    0x1529387aU,
    0x94bd7efdU,
    0x4e6fda42U,
    0x2e054ed1U,
    0xd5088024U,
    0xda9340f2U,
    0xe546e011U,
    0x87b831fcU,
    0x85e75b6eU,
    0x4bd60e8fU,
    0x20ee622bU,
    0x295b70a1U,
    0x49a9b83cU,
    0xe23e36U,
    0xd95b38d3U,
    0x31b07c55U,
    0x2cef5a46U,
    0x475a0fcbU,
    0xfcbc6211U,
    0x4a667144U,
    0xd4013b82U,
    0x72017f89U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xf8000000U,
    0x4c000000U,
    0x6a000000U,
    0x8f000000U,
    0x43800000U,
    0x2400000U,
    0x7fa00000U,
    0xf4b00000U,
    0x59280000U,
    0xfa6c0000U,
    0x47560000U,
    0xa3390000U,
    0x6d788000U,
    0xb8c9c000U,
    0xe3762000U,
    0x29d35000U,
    0x29e99800U,
    0x5d14ac00U,
    0x609f9a00U,
    0xdbddaf00U,
    0xdaef1a80U,
    0x7c886c40U,
    0x89c73960U,
    0x39fe3d70U,
    0x850820c8U,
    0xfc86534cU,
    0x49c71bc6U,
    0x19e46c45U,
    0x551138b8U,
    0x4873fd7U,
    0x5d0a2bcU,
    0x73ff924eU,
    0xda193be9U,
    0x471b3cceU,
    0x78ea07aU,
    0xc5a9058U,
    0x2ebfba67U,
    0x1e37fe54U,
    0xfdfe0292U,
    0x4b150057U,
    0x8d8e82afU,
    0x7340c118U,
    0x4526a354U,
    0xa8769312U,
    0xa449b897U,
    0x5abefe8fU,
    0x182e8288U,
    0xc8f0c32cU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0xf8000000U,
    0x14000000U,
    0xe6000000U,
    0x99000000U,
    0x47800000U,
    0xef400000U,
    0x4de00000U,
    0x12f00000U,
    0xbc780000U,
    0xdca40000U,
    0x421e0000U,
    0x17110000U,
    0xd29b8000U,
    0x8adb4000U,
    0x25b26000U,
    0x95959000U,
    0xe052f800U,
    0x5b738400U,
    0x8634fa00U,
    0x14c68500U,
    0xe8b17980U,
    0xd40cc640U,
    0x46189a60U,
    0xa9021610U,
    0x6f9801f8U,
    0x3540074U,
    0xbfe602e6U,
    0x6df502c9U,
    0x62e58051U,
    0x747a41c2U,
    0xe0b1e140U,
    0x481ad2e0U,
    0x7c069bd0U,
    0xea1314d8U,
    0xbb038384U,
    0xc08f404eU,
    0x25d463a5U,
    0x3209013U,
    0x29577ab5U,
    0xa4f9c51cU,
    0x9d7d1bddU,
    0x6f385627U,
    0x9b49e233U,
    0x3bfed1c5U,
    0x93f89a74U,
    0x3ff21791U,
    0x2de00195U,
    0x82f001ecU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0xc8000000U,
    0x4c000000U,
    0x3a000000U,
    0x1f000000U,
    0x94800000U,
    0xebc00000U,
    0x37600000U,
    0x82700000U,
    0x31f80000U,
    0x6aac0000U,
    0x701a0000U,
    0x28130000U,
    0x5c128000U,
    0x4201c000U,
    0x9b142000U,
    0xe29fb000U,
    0xcecb4800U,
    0xbceae400U,
    0xfd294a00U,
    0xed55e500U,
    0xdfa1c880U,
    0xc38727c0U,
    0x73476ba0U,
    0x46a956f0U,
    0x1a000348U,
    0xef00028cU,
    0xfc80031aU,
    0x17c00023U,
    0xc5600147U,
    0xd17000eaU,
    0x9f7802a0U,
    0x9e6c0070U,
    0xd3fa0388U,
    0x41a300acU,
    0x5a8a80aaU,
    0xaaddc20bU,
    0xdaf6221bU,
    0xa020b388U,
    0xe2c3c9e7U,
    0xd6f824d1U,
    0x3a2fe9d3U,
    0x4dcb96c4U,
    0x8a7ea15dU,
    0x9df27202U,
    0x40a56bdcU,
    0x171654a2U,
    0x388880e7U,
    0xc1d2c251U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xa8000000U,
    0x2c000000U,
    0xfe000000U,
    0x51000000U,
    0xef800000U,
    0x6400000U,
    0x57600000U,
    0x10700000U,
    0x22e80000U,
    0x5240000U,
    0xfd0e0000U,
    0xd18b0000U,
    0x37568000U,
    0xe8e54000U,
    0xbe356000U,
    0x59859000U,
    0xeb5cd800U,
    0x8efbf400U,
    0x3b3ada00U,
    0xcc14f700U,
    0x6e025b80U,
    0x990ab640U,
    0x9389b920U,
    0x504e66f0U,
    0x2a6e02d8U,
    0x1fb03b4U,
    0x75be8366U,
    0xbdc140adU,
    0xeb3b63bbU,
    0xa40e91acU,
    0x220a5990U,
    0x371eb508U,
    0x6a8fbb9cU,
    0x93d1640aU,
    0xd23e817fU,
    0x78142f0U,
    0x8a5b627aU,
    0x997e9067U,
    0xb9625b24U,
    0x497ab64cU,
    0xd161bb22U,
    0x56a6593U,
    0x7f600162U,
    0xfc700011U,
    0xbce80241U,
    0x424038bU,
    0xba8e0194U,
    0xfbcb02b4U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0xc8000000U,
    0x7c000000U,
    0xc2000000U,
    0x13000000U,
    0x61800000U,
    0xc3400000U,
    0x58200000U,
    0xa1300000U,
    0x5fb80000U,
    0x97740000U,
    0xd3020000U,
    0x418b0000U,
    0x134c8000U,
    0x2038c000U,
    0x153ca000U,
    0xe1a19000U,
    0x467a7800U,
    0xa19f3c00U,
    0xe3407a00U,
    0x88203d00U,
    0xd92efb80U,
    0xeba3ffc0U,
    0x2966d8a0U,
    0x20eae30U,
    0x330203a8U,
    0xb18b027cU,
    0xbb4c802eU,
    0xec38c071U,
    0x1f3ca0ceU,
    0x8ea19035U,
    0xe5fa7a90U,
    0x71df3f98U,
    0xdae078d4U,
    0xea503fd2U,
    0xdeb6f89fU,
    0xdde7fe9fU,
    0xa5dcda8bU,
    0xd4f1ae6dU,
    0xf34c81e4U,
    0xd038c2faU,
    0xbd3ca2a3U,
    0x2da193d1U,
    0x4c7a796aU,
    0xce9f3cbbU,
    0x40c079c5U,
    0x58603d98U,
    0xe08ef9d4U,
    0x89d3fe52U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0xf8000000U,
    0x2c000000U,
    0x96000000U,
    0xcf000000U,
    0x62800000U,
    0xdd400000U,
    0xfea00000U,
    0x4bb00000U,
    0x90380000U,
    0x10ec0000U,
    0xf9860000U,
    0x45c90000U,
    0xdae48000U,
    0x48924000U,
    0x9c59a000U,
    0x8f36f000U,
    0xca66d800U,
    0xa8d6cc00U,
    0x7d78da00U,
    0xa643cd00U,
    0x96225880U,
    0xc7f48c40U,
    0x47197b60U,
    0xa6993cf0U,
    0x3f428138U,
    0xdbab43ccU,
    0x882522b2U,
    0xccf8b1b9U,
    0xc7817bc8U,
    0x5ec53dd7U,
    0x27c8068U,
    0xccce4024U,
    0xcf67a156U,
    0x7b53f24fU,
    0x79a45ad7U,
    0xd3d8de8U,
    0x5f7df8e4U,
    0x634b7c76U,
    0xa5bb20dfU,
    0x332db39fU,
    0x447bf95cU,
    0xbbc27ffaU,
    0x21ffa30dU,
    0x600ff3d6U,
    0xb01a5b2cU,
    0x8188da1U,
    0x841f7ab7U,
    0x42103ebbU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x48000000U,
    0x5c000000U,
    0x3a000000U,
    0xe7000000U,
    0x99800000U,
    0x4400000U,
    0xbb200000U,
    0xa300000U,
    0x46b80000U,
    0x407c0000U,
    0xec8a0000U,
    0xf6d30000U,
    0xc4f08000U,
    0xf643c000U,
    0x40312000U,
    0x89b71000U,
    0x15e61800U,
    0x2acd3c00U,
    0xbef41a00U,
    0x31523d00U,
    0x69b69a80U,
    0xc5feffc0U,
    0xf2dd3ba0U,
    0x1ae92eb0U,
    0x1f428348U,
    0xe8acc12cU,
    0x816ba32eU,
    0x8817d03dU,
    0x3c1fb942U,
    0xaa05eed5U,
    0x1f092378U,
    0x8d8b13a4U,
    0x624c1aa2U,
    0x662e3c23U,
    0x74bc9877U,
    0xdb6dfd5bU,
    0xff0dbad3U,
    0x5d9aef79U,
    0xba4ba030U,
    0xc227d02eU,
    0x5aa7bb1bU,
    0x5a79ed95U,
    0xbb8322beU,
    0x275813a3U,
    0x9cbc9b91U,
    0x776dfdacU,
    0xad0db948U,
    0x569aee8aU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x58000000U,
    0xac000000U,
    0xde000000U,
    0xe9000000U,
    0x99800000U,
    0x82c00000U,
    0x9d600000U,
    0x3e700000U,
    0x6cf80000U,
    0x8ac0000U,
    0x239a0000U,
    0xb1c10000U,
    0x67fc8000U,
    0xe234000U,
    0x85c06000U,
    0xf5fc5000U,
    0x29378800U,
    0x1d48e400U,
    0x1ab58a00U,
    0x4495e500U,
    0x894b0880U,
    0x38aba7c0U,
    0x3b95e9e0U,
    0xbdd9b570U,
    0x9e48298U,
    0xbf3f42d4U,
    0xb04262feU,
    0xa92151dfU,
    0x5d490a0bU,
    0xbab6a7e6U,
    0xf48b68d8U,
    0xd157f474U,
    0x94a261aeU,
    0xe59153d7U,
    0x54d10937U,
    0x906aa654U,
    0x3de96aadU,
    0x2d3af51eU,
    0x9744e23cU,
    0x31b31332U,
    0xb20de8b5U,
    0xd705b40aU,
    0x60868322U,
    0xf352429dU,
    0xeba4e0a6U,
    0xd10312f8U,
    0x6595eae4U,
    0x14d9b746U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x8000000U,
    0x54000000U,
    0xd6000000U,
    0xe5000000U,
    0xab800000U,
    0xe9400000U,
    0x1b200000U,
    0x70b00000U,
    0x39f80000U,
    0x92c40000U,
    0xba7e0000U,
    0xdf870000U,
    0xcf498000U,
    0x462d4000U,
    0xd736e000U,
    0x5aaa1000U,
    0xeefa7800U,
    0x525ffc00U,
    0x41b3fa00U,
    0x472bd00U,
    0x7e851980U,
    0x5ad8ac40U,
    0x4e7f61a0U,
    0xb9875110U,
    0x724c98f8U,
    0xb1b5ef84U,
    0xbc6983d6U,
    0x729d4061U,
    0xd0cee21aU,
    0x296e10b3U,
    0x21047a05U,
    0xd598fd7cU,
    0xe85a7b3aU,
    0x3eaffe63U,
    0x20ebfa1dU,
    0xb46bfc8U,
    0x38231b44U,
    0xd62bafdeU,
    0x7f30e1c5U,
    0xbea911f4U,
    0x60edf95eU,
    0xeb45bf6dU,
    0x68349bc0U,
    0xde31ec88U,
    0x2b378264U,
    0x68aa410eU,
    0x85ff61ddU,
    0x40c75340U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x18000000U,
    0x54000000U,
    0xfa000000U,
    0x83000000U,
    0xca800000U,
    0x95c00000U,
    0xb7a00000U,
    0x2d300000U,
    0x70f80000U,
    0x1b5c0000U,
    0x307a0000U,
    0x75810000U,
    0x89578000U,
    0x9f72c000U,
    0x8103a000U,
    0xcd9d7000U,
    0x2d550800U,
    0x5d745c00U,
    0xe6028a00U,
    0xe5069d00U,
    0x6f812a80U,
    0xda5befc0U,
    0xddf422e0U,
    0xe8dfb290U,
    0xcc2eab08U,
    0x2d752d9cU,
    0x9e0d82a2U,
    0x2103c00bU,
    0x3d8c229cU,
    0x1543b22fU,
    0xb974a857U,
    0x4042fdeU,
    0x32020234U,
    0x5f1d0203U,
    0xcc8d808dU,
    0xa0c3c351U,
    0x502c225eU,
    0xb73b179U,
    0x1b0caabfU,
    0xde982e5fU,
    0x4fd800c2U,
    0x84ac0356U,
    0xffa202e8U,
    0xb12d0181U,
    0x56f582f6U,
    0x9e5fc155U,
    0xcff62265U,
    0x7c2b2d0U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0x48000000U,
    0x9c000000U,
    0x42000000U,
    0x51000000U,
    0xc2800000U,
    0x25c00000U,
    0x65600000U,
    0x9ff00000U,
    0xfe280000U,
    0xad5c0000U,
    0xeda60000U,
    0x8a070000U,
    0xd088000U,
    0x2086c000U,
    0x24dbe000U,
    0xeff33000U,
    0x26354800U,
    0xd9500400U,
    0x63bdca00U,
    0xd116c700U,
    0x2862880U,
    0x85d5f640U,
    0x357b61a0U,
    0xd7e9f030U,
    0x6228aaa8U,
    0xef543674U,
    0xbca80122U,
    0x489c00a3U,
    0x28c60117U,
    0x45f702ecU,
    0xbb208047U,
    0x11dac22dU,
    0x8b7de0d3U,
    0x34f433a6U,
    0xe9bdcb70U,
    0xdc16c488U,
    0x22062884U,
    0xa115f46aU,
    0xda9b6347U,
    0xf1d9f0adU,
    0xbb60a993U,
    0x8cf83686U,
    0x6da60300U,
    0x4a070280U,
    0xad088140U,
    0x7086c120U,
    0x6cdbe270U,
    0x73f33108U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0x38000000U,
    0x4000000U,
    0x76000000U,
    0xdf000000U,
    0x84800000U,
    0x84400000U,
    0xfca00000U,
    0x5c300000U,
    0x7e780000U,
    0xf5c40000U,
    0x617a0000U,
    0xd1450000U,
    0x75218000U,
    0x65e54000U,
    0x1503a000U,
    0x6996b000U,
    0x49c97800U,
    0x53784c00U,
    0x9848fa00U,
    0x5ead0d00U,
    0x5d335980U,
    0x69ffbcc0U,
    0xbf002160U,
    0xb482f0d0U,
    0x5c495ab8U,
    0x88babeacU,
    0x1221a12aU,
    0xa567b07dU,
    0x74afbb8U,
    0x3a2c0dddU,
    0xa968daf9U,
    0xad5ffda6U,
    0xe72203d6U,
    0xbcf1025eU,
    0x768380daU,
    0x6d5442c4U,
    0x472022cfU,
    0x2cf2f168U,
    0x3e915a94U,
    0x514ebfc6U,
    0x3523a177U,
    0x85e6b0b5U,
    0x65117a6dU,
    0x518c4f60U,
    0x4dcafb21U,
    0x256c0e2bU,
    0x4748dbd7U,
    0xda2ffd74U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x48000000U,
    0x5c000000U,
    0xaa000000U,
    0xb5000000U,
    0x17800000U,
    0x42400000U,
    0x6200000U,
    0xddb00000U,
    0x8de80000U,
    0xacc0000U,
    0x6fa0000U,
    0x9e5b0000U,
    0x6c3c8000U,
    0x48a3c000U,
    0xaa666000U,
    0x841000U,
    0x5ccd9800U,
    0xe9f43c00U,
    0x54d11a00U,
    0x55e7ff00U,
    0xeedf7a80U,
    0x98efefc0U,
    0xed48e3a0U,
    0x2cb0d2b0U,
    0xf46d7b08U,
    0x5388ef64U,
    0x2c4661d6U,
    0x1d3411adU,
    0xf1259a6eU,
    0xd3383c6bU,
    0x1a2b1951U,
    0x97bcfc24U,
    0x28e3fa1cU,
    0x654c2c30U,
    0x50ae8062U,
    0x6e74c0c9U,
    0xae80e012U,
    0x67ccd34bU,
    0xf57f7b8bU,
    0x421fec01U,
    0x1900e27cU,
    0xd58cd320U,
    0x9b5f78daU,
    0xf3afef25U,
    0x76e8e2e0U,
    0x3640d0d0U,
    0x20257b18U,
    0x9ab4ed5cU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x98000000U,
    0x5c000000U,
    0x12000000U,
    0x7000000U,
    0x4e800000U,
    0x4ac00000U,
    0xf7e00000U,
    0x2b700000U,
    0xa6a80000U,
    0xbfdc0000U,
    0x6e7a0000U,
    0xa7210000U,
    0x6f868000U,
    0xb556c000U,
    0xaaab2000U,
    0xe5de7000U,
    0xbd60e800U,
    0x8fb3b400U,
    0xf44e6a00U,
    0x45397700U,
    0x909f4880U,
    0xb7c605c0U,
    0xda7922e0U,
    0xd12370b0U,
    0x969c68a8U,
    0x76c477acU,
    0xf5e3c912U,
    0x471c747U,
    0x2c34822dU,
    0xbb1bc05aU,
    0x8c9fa09fU,
    0xc5c5b0c9U,
    0xcd7f4ad4U,
    0xb7b605a2U,
    0x185121efU,
    0xcf3f7081U,
    0xcb866ac8U,
    0xeb557498U,
    0x97ad48c4U,
    0x684b075eU,
    0xf72da065U,
    0x2788b102U,
    0x614bcabbU,
    0xccadc727U,
    0x34ce8219U,
    0xbafac30cU,
    0x9ef92246U,
    0xe370e1U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0x78000000U,
    0x14000000U,
    0x2a000000U,
    0x69000000U,
    0xe800000U,
    0x54c00000U,
    0x82200000U,
    0xc6b00000U,
    0x4b680000U,
    0xcfcc0000U,
    0x61b60000U,
    0xeef10000U,
    0xb08f8000U,
    0xd7d4c000U,
    0xc5a4e000U,
    0xccfcb000U,
    0xe583e800U,
    0x9f40cc00U,
    0xc6646a00U,
    0x3580f00U,
    0x10768a80U,
    0xc55be40U,
    0x19fae360U,
    0x6d01b210U,
    0xbc9a69c8U,
    0x59d50cb4U,
    0x8ea70b72U,
    0x977c7fa7U,
    0xf9c7801aU,
    0x1ea8c1adU,
    0xcf7ae27fU,
    0xbdc1b066U,
    0x4cba6bebU,
    0xb2650e6aU,
    0x994f08fbU,
    0x71707c2cU,
    0x3ed180e0U,
    0xb29c3deU,
    0xb83d6007U,
    0x37a97324U,
    0x21e08a7aU,
    0x9914bc33U,
    0xe69d6118U,
    0x18d97152U,
    0xec288859U,
    0xfda8beedU,
    0x38e36291U,
    0xbf9472d9U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x28000000U,
    0x84000000U,
    0x82000000U,
    0x55000000U,
    0x37800000U,
    0xb0400000U,
    0x3be00000U,
    0x6700000U,
    0x37380000U,
    0xb15c0000U,
    0xc66e0000U,
    0x57330000U,
    0x814f8000U,
    0xfe69c000U,
    0xfb3c6000U,
    0x87431000U,
    0x2963d800U,
    0x99a14400U,
    0x945a00U,
    0xa2d48500U,
    0xa4263a80U,
    0x31d49540U,
    0x24b26220U,
    0xd3001350U,
    0xa0945a28U,
    0xf2d48704U,
    0xac263876U,
    0xa5d49485U,
    0x8eb260b9U,
    0x20012ccU,
    0x151458cdU,
    0x1794864dU,
    0xa0463b82U,
    0x13e495c4U,
    0x826a6196U,
    0xb52c12b5U,
    0xe4425ae1U,
    0xf1fb8430U,
    0xe767b9d7U,
    0xbabe571aU,
    0xf81980d8U,
    0xcc06c3bcU,
    0x361de33aU,
    0xef19d207U,
    0xce903972U,
    0x81cb957cU,
    0x5cabe0daU,
    0x5f06d137U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0x48000000U,
    0x8c000000U,
    0x9a000000U,
    0x57000000U,
    0x4b800000U,
    0x50400000U,
    0xca00000U,
    0x65300000U,
    0xe6780000U,
    0x975c0000U,
    0x1f220000U,
    0xa1730000U,
    0xc4ce8000U,
    0xfb67c000U,
    0xf3d22000U,
    0xe0ffd000U,
    0x9b851800U,
    0x28462c00U,
    0xe8b39a00U,
    0x33ded00U,
    0x6363ba80U,
    0x7c13cc0U,
    0x9ef023a0U,
    0xaa8cd2f0U,
    0xe6cb9bc8U,
    0x2861eeacU,
    0x8e41b866U,
    0xdb23f2dU,
    0xc3bea1f4U,
    0xdaab1149U,
    0xc839bb25U,
    0xaaee3d78U,
    0xb49ca29fU,
    0x87d81320U,
    0xdef73b30U,
    0x8a89fee8U,
    0x96ce829cU,
    0x6067c10eU,
    0x25223f1U,
    0x97bfd39aU,
    0x94a519e8U,
    0x91362c87U,
    0x986b9b74U,
    0xa651ec12U,
    0xd1b9b8bfU,
    0x61ae3d0bU,
    0x49bca222U,
    0x95a810d7U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x88000000U,
    0x4000000U,
    0x66000000U,
    0xc5000000U,
    0x57800000U,
    0xcac00000U,
    0x99a00000U,
    0x6c300000U,
    0xe5f80000U,
    0x3ecc0000U,
    0x37b20000U,
    0xd3b0000U,
    0xa4678000U,
    0xb9114000U,
    0xfd86e000U,
    0xcdd59000U,
    0x1d348800U,
    0xbc6ddc00U,
    0xe50b0a00U,
    0x67809d00U,
    0xe2c7e880U,
    0xeda20cc0U,
    0x8226e2a0U,
    0x24e590d0U,
    0xf4c8938U,
    0x3861dec4U,
    0xc31908e6U,
    0x28b9d2fU,
    0xc5586a20U,
    0xaf7f4d4fU,
    0x1f92020fU,
    0x2ecb02b0U,
    0x2fbf8017U,
    0x512d43bbU,
    0x3e6ce33eU,
    0x96129204U,
    0xd190b19U,
    0xf38b9c68U,
    0xdcd86bbcU,
    0xd4bf4c42U,
    0x3fb201b9U,
    0x493b01e7U,
    0x62678113U,
    0xc114322U,
    0x2206e016U,
    0x3159058U,
    0xe294886bU,
    0x155ddcd9U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0xb8000000U,
    0x94000000U,
    0xaa000000U,
    0xb9000000U,
    0x77800000U,
    0x87c00000U,
    0x5b600000U,
    0xc2f00000U,
    0xbe280000U,
    0x97c40000U,
    0xd36a0000U,
    0x8ef50000U,
    0x70338000U,
    0x3cd4c000U,
    0x89fae000U,
    0xd4b99000U,
    0x159aa800U,
    0xd2d1a400U,
    0x72e12a00U,
    0xa6316700U,
    0x93d9cb80U,
    0x3179f4c0U,
    0x1bfae160U,
    0x39b99290U,
    0xa81aa9c8U,
    0x1c11a774U,
    0xe6012b96U,
    0x770165abU,
    0xdc91c99bU,
    0xdd4df730U,
    0x138e32bU,
    0xa74891dbU,
    0x50232910U,
    0x6cc0641bU,
    0xa1e04be3U,
    0x8a8353cU,
    0x939b8131U,
    0x55d0c2aaU,
    0x1670e29aU,
    0xef7c9231U,
    0x38e12b2aU,
    0x2f31655aU,
    0x3c59cad1U,
    0xd2b9f67aU,
    0x529ae072U,
    0xd64992f5U,
    0xcbb2abc4U,
    0xb515a47dU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0x38000000U,
    0xdc000000U,
    0xde000000U,
    0x6d000000U,
    0x90800000U,
    0x6dc00000U,
    0x1e600000U,
    0x34f00000U,
    0xf6280000U,
    0xebcc0000U,
    0x3f720000U,
    0x127d0000U,
    0x62fa8000U,
    0x5f2b4000U,
    0x94fe000U,
    0xd9b17000U,
    0x2d948800U,
    0x754d2400U,
    0xb7a60a00U,
    0x589a6700U,
    0x49d3ea80U,
    0x3c6a16c0U,
    0xf7e7e260U,
    0x33bd71b0U,
    0xca868b18U,
    0x92c02704U,
    0x55f48bdaU,
    0x30bd2473U,
    0x2f0e0bc3U,
    0xc3966610U,
    0xc041eb83U,
    0xab27177bU,
    0xa3556244U,
    0xdeaa3331U,
    0x9a136bf4U,
    0xdf005429U,
    0x3b8882f0U,
    0x3c5642f3U,
    0x5356303U,
    0xf65a3170U,
    0x923b6bb3U,
    0x29cc5623U,
    0xac7a80e0U,
    0x9feb40bbU,
    0xa7afe06fU,
    0xf08170d6U,
    0xfddc88aeU,
    0x76712651U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x88000000U,
    0xd4000000U,
    0x46000000U,
    0xd9000000U,
    0x81800000U,
    0xd5400000U,
    0xd0600000U,
    0xc0f00000U,
    0xe0380000U,
    0xf3040000U,
    0x2820000U,
    0xffdb0000U,
    0xabbd8000U,
    0x15534000U,
    0x70616000U,
    0x90efd000U,
    0xd83fb800U,
    0xaf059400U,
    0x90803a00U,
    0x60cdd500U,
    0xf33cd980U,
    0x418147c0U,
    0x755a03a0U,
    0x806f0090U,
    0xf8e780b8U,
    0xbc3c42f4U,
    0x6106e13eU,
    0x9d939361U,
    0xa759585fU,
    0xff660732U,
    0x106160c7U,
    0x60efd29aU,
    0xb03fbb4bU,
    0xcb0595f0U,
    0x5e803904U,
    0x6dcdd636U,
    0x34bcdbfdU,
    0x4dc1454dU,
    0x24ba01a9U,
    0x95df036fU,
    0xc8bf831aU,
    0x8fc8408bU,
    0x83bce050U,
    0x914c9294U,
    0xe66d80eU,
    0x15ee4649U,
    0xcbbd8393U,
    0xe5534338U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x8000000U,
    0xfc000000U,
    0xae000000U,
    0x11000000U,
    0x24800000U,
    0x8d400000U,
    0x88600000U,
    0x45f00000U,
    0x68280000U,
    0x870c0000U,
    0x918e0000U,
    0xd3d70000U,
    0xd62c8000U,
    0x5e1b4000U,
    0x69106000U,
    0x60977000U,
    0x47451800U,
    0xc3653400U,
    0x22679a00U,
    0x7ee97700U,
    0xb7bb7a80U,
    0xf5d54540U,
    0xfb2602a0U,
    0xf49b02b0U,
    0x65428218U,
    0xc47c41f4U,
    0x73f4e20aU,
    0x8d303181U,
    0xf193780bU,
    0xa3d94766U,
    0x6e280113U,
    0x3a0c023eU,
    0x330e0147U,
    0x23970204U,
    0xdccc809eU,
    0x7bab43dbU,
    0x3d86202U,
    0x3e2b73f1U,
    0x12031b73U,
    0x5f0e35c2U,
    0x858d1811U,
    0x31d93563U,
    0xf121986aU,
    0x9f82767dU,
    0x92d1f95dU,
    0xdaa50401U,
    0xbf5ce3e7U,
    0x477c3098U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x58000000U,
    0xa4000000U,
    0x2000000U,
    0x39000000U,
    0x93800000U,
    0x41c00000U,
    0x80a00000U,
    0x3e300000U,
    0xf6780000U,
    0xca140000U,
    0xd5020000U,
    0x3d810000U,
    0xb6d98000U,
    0xd43fc000U,
    0x7363e000U,
    0x9f8d1000U,
    0x9fd96800U,
    0x4fa05c00U,
    0xfea2ea00U,
    0xe12e9d00U,
    0x3ee08b80U,
    0x11484dc0U,
    0xdff802e0U,
    0x66d40350U,
    0xfc2200e8U,
    0xef7102b4U,
    0x9818326U,
    0xfcdbc373U,
    0x4139e044U,
    0x2ee8111bU,
    0x195aeb95U,
    0x13fa9ed7U,
    0x98c2888fU,
    0x63394e26U,
    0x47f981d6U,
    0xe2cfc14eU,
    0xae3be0a2U,
    0xbe691388U,
    0x66036801U,
    0x1b055e64U,
    0xfa81680eU,
    0xba445c27U,
    0x3d78eab2U,
    0x188b9ec0U,
    0xf3430b45U,
    0x96e28edaU,
    0xcd406211U,
    0x29e7d209U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0xd8000000U,
    0xb4000000U,
    0xda000000U,
    0xa1000000U,
    0xcd800000U,
    0x69400000U,
    0xae600000U,
    0x7ef00000U,
    0x8c380000U,
    0x340c0000U,
    0x9a1e0000U,
    0x10d0000U,
    0xdd8f8000U,
    0xb156c000U,
    0x1a79e000U,
    0xa4e6d000U,
    0x2d38b800U,
    0xf98d5400U,
    0xf3493a00U,
    0xaf669500U,
    0xa3675880U,
    0x3d6a8540U,
    0x2e6003e0U,
    0x3ef00390U,
    0x2c380288U,
    0x240c0014U,
    0x421e033eU,
    0xb50d01f1U,
    0x78f82e7U,
    0x1056c2daU,
    0xd7f9e3bfU,
    0xcda6d08eU,
    0x8358bae1U,
    0x877d552fU,
    0x7f71392eU,
    0x9b6a9711U,
    0x397959f7U,
    0x3c678512U,
    0xf3ef804bU,
    0x8fa6c020U,
    0x3641e198U,
    0x80ead3dcU,
    0x6f26bacaU,
    0x4c80545fU,
    0xf4c6b91eU,
    0xbf305569U,
    0x749eb9bbU,
    0xf0cc5550U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0xc8000000U,
    0x8c000000U,
    0x5e000000U,
    0xbf000000U,
    0xa9800000U,
    0x68400000U,
    0xd7e00000U,
    0x15700000U,
    0xbea80000U,
    0x41c0000U,
    0xb21a0000U,
    0xf11b0000U,
    0x6e9e8000U,
    0x85c34000U,
    0x6dada000U,
    0x23991000U,
    0xbd57d800U,
    0x7b76c400U,
    0x9b35a00U,
    0x819e8700U,
    0x34487880U,
    0x51e8d5c0U,
    0x5e6003a0U,
    0xd3003f0U,
    0x14800d8U,
    0x2d6c020cU,
    0x9ab200feU,
    0xc607016dU,
    0x2b048081U,
    0xa3984308U,
    0x7d532303U,
    0xdb6a51e4U,
    0xb9b27b6dU,
    0x4983d781U,
    0xb8568388U,
    0xfef42c3U,
    0xe17fa044U,
    0xa4ae139dU,
    0x691b59d9U,
    0xfa828544U,
    0x8fd2781dU,
    0x78b3d699U,
    0x2f1e8024U,
    0x118342cdU,
    0x8c4da371U,
    0xb5e913d0U,
    0x3c7fd90fU,
    0x242ac51aU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0xa8000000U,
    0x4000000U,
    0xba000000U,
    0xfb000000U,
    0xaf800000U,
    0x36400000U,
    0xdce00000U,
    0x42700000U,
    0xc8b80000U,
    0x298c0000U,
    0xcb420000U,
    0xce7f0000U,
    0xc6bb8000U,
    0x609ac000U,
    0x6bd4a000U,
    0x45b7d000U,
    0xd3175800U,
    0xeb952400U,
    0x2c56da00U,
    0xd7fce500U,
    0x45fbf880U,
    0xfaeef6c0U,
    0x4f638220U,
    0x7226c2d0U,
    0xa94ea2c8U,
    0xd974d03cU,
    0x7736daf6U,
    0xe7cce725U,
    0x4ba3f925U,
    0x9a12f73cU,
    0x4b19826fU,
    0xa795c3b6U,
    0xc257235cU,
    0xcee11146U,
    0xbd61fb5dU,
    0xdd2df5e1U,
    0xe4c203ceU,
    0xb83f0198U,
    0xba5b82b4U,
    0xd2eac12aU,
    0xb6ca0a3U,
    0x683bd058U,
    0xa255580dU,
    0xdeea2769U,
    0x456d5812U,
    0x8126261eU,
    0xf2cf5bc9U,
    0xfd29261bU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x18000000U,
    0x1c000000U,
    0x96000000U,
    0x9b000000U,
    0x9c800000U,
    0x34c00000U,
    0x3d600000U,
    0x94f00000U,
    0xaba80000U,
    0x60840000U,
    0xd2c20000U,
    0xde790000U,
    0xa4668000U,
    0x117a4000U,
    0xdae62000U,
    0x4ca03000U,
    0xda176800U,
    0x65102400U,
    0x639bea00U,
    0x92576700U,
    0x1cb94b80U,
    0xb20415c0U,
    0x10683e0U,
    0x598a41b0U,
    0x874e23b8U,
    0x72430dcU,
    0x8c55684aU,
    0x93a926cfU,
    0x6c9d6adfU,
    0x8cdd27ecU,
    0xf1776ba9U,
    0xaae026c2U,
    0x34b3eaf0U,
    0x76136518U,
    0xeb1b4accU,
    0xe48d1562U,
    0x98c8017bU,
    0xb3740101U,
    0x13ea03adU,
    0xa13d02bfU,
    0xcf44839cU,
    0x733343f1U,
    0x7e48a3aeU,
    0x32ae7302U,
    0xe51b480bU,
    0xa38d15d9U,
    0xf2480081U,
    0xacb4016dU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x58000000U,
    0x24000000U,
    0xca000000U,
    0xa1000000U,
    0xe2800000U,
    0xe4400000U,
    0x85600000U,
    0x44f00000U,
    0x3f280000U,
    0x62840000U,
    0x245e0000U,
    0xe56d0000U,
    0x14f58000U,
    0x673ec000U,
    0x468de000U,
    0xee4f3000U,
    0x4479f800U,
    0xf665f400U,
    0x837a7a00U,
    0xc3f23700U,
    0xaabc1b80U,
    0x7b5ec640U,
    0x94f582e0U,
    0xa73ec2d0U,
    0x268de3c8U,
    0xbe4f3354U,
    0x1c79f9c2U,
    0xd265f585U,
    0x497a78b7U,
    0x62f23706U,
    0x483c1ae3U,
    0x9f1ec548U,
    0x11958098U,
    0xe3cec1dcU,
    0x19a5e3f6U,
    0xdccb30d7U,
    0x3827f81aU,
    0x3708f435U,
    0x5d8ff8efU,
    0x5ccf6faU,
    0xeb1f8e5U,
    0x7151f627U,
    0x55ec792eU,
    0x15ab34e7U,
    0x9adf9b02U,
    0x1f3907a9U,
    0x929be3f9U,
    0x4c5633fdU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x78000000U,
    0xb4000000U,
    0xfe000000U,
    0x8d000000U,
    0x51800000U,
    0xb5c00000U,
    0xc7a00000U,
    0xd1300000U,
    0x6780000U,
    0xc8940000U,
    0x2a460000U,
    0xf7610000U,
    0x9b0b8000U,
    0x508e4000U,
    0xce54e000U,
    0x11665000U,
    0xb2122800U,
    0x871afc00U,
    0x4287aa00U,
    0x7951bd00U,
    0x5be6cb80U,
    0x174cad40U,
    0xeeed8260U,
    0x92df4390U,
    0xb5276398U,
    0xa07c10a4U,
    0x8180cb5eU,
    0xedddae33U,
    0x3be03a0U,
    0x473502a7U,
    0x476d83c1U,
    0xd31f42f1U,
    0xec87624eU,
    0xec4c116bU,
    0xae78c924U,
    0x2489af89U,
    0x105802baU,
    0xec64010dU,
    0x8b9e0103U,
    0xfec5001fU,
    0xcf358102U,
    0xdb7b424eU,
    0x811961fcU,
    0x3b89124dU,
    0xb6cd48f4U,
    0x7332ec66U,
    0xf9616227U,
    0x3e1d1296U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x8000000U,
    0x84000000U,
    0x7e000000U,
    0x49000000U,
    0x24800000U,
    0x55400000U,
    0xd3600000U,
    0x64f00000U,
    0xf2280000U,
    0x1840000U,
    0x3bda0000U,
    0xd9230000U,
    0x2e0f8000U,
    0x91064000U,
    0xb89a6000U,
    0xd74c7000U,
    0x68661800U,
    0xf374d400U,
    0xb4fb9a00U,
    0xea259700U,
    0xfd9c7b80U,
    0xc9c8a6c0U,
    0x6a3583a0U,
    0x3d9540d0U,
    0xa9dde058U,
    0x1a3e32f4U,
    0x358e794aU,
    0x2ddfa661U,
    0x64280027U,
    0x7c8402e2U,
    0x95a0197U,
    0x31630100U,
    0xafef804aU,
    0x6db640e1U,
    0xc3526267U,
    0xae787002U,
    0x56741a27U,
    0x1a63d728U,
    0x80661ab6U,
    0xc774d447U,
    0xa2fb99d8U,
    0x572595feU,
    0xaf1c7bcbU,
    0x5188a4f6U,
    0xe3d5826dU,
    0x452543c9U,
    0xac15e2d1U,
    0x2a0a3345U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x78000000U,
    0x9c000000U,
    0x6a000000U,
    0xeb000000U,
    0x26800000U,
    0x18c00000U,
    0x76a00000U,
    0x15300000U,
    0x26680000U,
    0x379c0000U,
    0xcd560000U,
    0xa4e10000U,
    0xb9568000U,
    0x4ae9c000U,
    0xd447a000U,
    0x4576f000U,
    0xe511a800U,
    0xfb989c00U,
    0x1f592a00U,
    0x73fc5f00U,
    0x25d60880U,
    0xc12e6c40U,
    0x18688160U,
    0x2294c230U,
    0x5ec722c8U,
    0xffbe329cU,
    0xeca088d2U,
    0x9637adbfU,
    0x44e722e8U,
    0x94e309bU,
    0x42e88b59U,
    0xe05bafa9U,
    0xcb792196U,
    0xf8033369U,
    0x5c000a61U,
    0xca0f6f8aU,
    0x3b1e01fbU,
    0x5e8d03beU,
    0x84c880d2U,
    0x1ca4c368U,
    0xfe2f215bU,
    0xe231f9U,
    0x2f568839U,
    0xbbe6ac4eU,
    0xb1d9a06dU,
    0x9f3bf0d7U,
    0x7d792ab3U,
    0x190c5ce2U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0xf8000000U,
    0x44000000U,
    0xc2000000U,
    0xd000000U,
    0x6b800000U,
    0x4b400000U,
    0xf0e00000U,
    0x9bb00000U,
    0xfb580000U,
    0x38fc0000U,
    0x57be0000U,
    0x555d0000U,
    0x4beb8000U,
    0xb72ec000U,
    0xba84e000U,
    0x96c75000U,
    0xfcbad800U,
    0x61db9400U,
    0x3e3e3a00U,
    0xf31cc500U,
    0xa084e080U,
    0x4fc75240U,
    0xd3ad960U,
    0xb39b9650U,
    0x9f5e3ae8U,
    0x6aecc424U,
    0x2bce226U,
    0xaacb5359U,
    0x3abcdb0dU,
    0xeca9513U,
    0x88b3bac6U,
    0x2bd306a9U,
    0x5f358095U,
    0xe683c2efU,
    0x60d7637cU,
    0x1ba5929aU,
    0xbb583b03U,
    0x98fdc72eU,
    0x87b1630dU,
    0xad449273U,
    0xfedbb96U,
    0x753e05c1U,
    0xb7860071U,
    0xfd5100e9U,
    0xb7ed8095U,
    0x913fc2efU,
    0xa589637cU,
    0x848929aU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0x8000000U,
    0x94000000U,
    0xb6000000U,
    0x5d000000U,
    0xdc800000U,
    0x3ec00000U,
    0x8d600000U,
    0xcbb00000U,
    0x8ad80000U,
    0x8b740000U,
    0x6eae0000U,
    0xda5b0000U,
    0x9fa78000U,
    0x9cca4000U,
    0x26766000U,
    0xaa2fb000U,
    0x78820800U,
    0x30de1400U,
    0xbc746a00U,
    0x2d31a500U,
    0xc3166180U,
    0xa59fb140U,
    0xac5a0ba0U,
    0x62aa1610U,
    0xb05a68f8U,
    0xaaa624U,
    0xbb51e02aU,
    0x9125f0cfU,
    0x51146ae7U,
    0xb681a5c5U,
    0xa1ce60e6U,
    0xaaebb327U,
    0x7cf409bbU,
    0x71f1148bU,
    0x457de8a3U,
    0xffa0e59fU,
    0xccc781a1U,
    0xce7a41ecU,
    0x2e2e6238U,
    0xc69bb1c4U,
    0xf9cc081aU,
    0xd6f51567U,
    0x4eebea9bU,
    0x92ffe45bU,
    0x50f601bbU,
    0xabef008bU,
    0x226982a3U,
    0x5421409fU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0xc8000000U,
    0x14000000U,
    0xd2000000U,
    0x45000000U,
    0x28800000U,
    0xebc00000U,
    0xb6600000U,
    0xc9b00000U,
    0x6dc80000U,
    0x1640000U,
    0xd43e0000U,
    0xf6830000U,
    0x80df8000U,
    0x6df6c000U,
    0xc5e9e000U,
    0x81fe3000U,
    0x7bf4a800U,
    0xbaff5400U,
    0x887d4a00U,
    0x32b16700U,
    0x7e41e180U,
    0x192a3140U,
    0xea02a8a0U,
    0xc9185610U,
    0xc69cca68U,
    0xf8c4a644U,
    0xc1f7826aU,
    0x5be2c3fbU,
    0xcaffe2dbU,
    0xd0693299U,
    0xeebd2b06U,
    0xb85e9667U,
    0x8e3d2b0dU,
    0x879e9664U,
    0xa5d2aa8U,
    0x9b2e97a4U,
    0x871528daU,
    0x658a9583U,
    0x374b29f7U,
    0x1fb99737U,
    0xf2dcabd7U,
    0x98eb57e7U,
    0x556b495fU,
    0x26266793U,
    0xc388628dU,
    0xf04bf324U,
    0x5a22c808U,
    0xb587a6b4U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xf8000000U,
    0xac000000U,
    0x1a000000U,
    0xd1000000U,
    0xd800000U,
    0xfe400000U,
    0x3ea00000U,
    0xccf00000U,
    0x78480000U,
    0xcda40000U,
    0x5c7a0000U,
    0x21810000U,
    0x244e8000U,
    0xfbcc000U,
    0x71606000U,
    0x7e191000U,
    0x5f0cb800U,
    0x8a8b7c00U,
    0x88ccda00U,
    0xe4626f00U,
    0xad886180U,
    0x6e4d11c0U,
    0x96beb860U,
    0x28ee7c70U,
    0x36585988U,
    0xaaafaef4U,
    0x9aee81deU,
    0x34cc17dU,
    0xe92860acU,
    0x3bd10baU,
    0xfb76ba93U,
    0x70a7df1U,
    0xb6825aceU,
    0x3adeac0dU,
    0xd16800acU,
    0xee1401b2U,
    0xf712002fU,
    0x6e9501b3U,
    0xc6dc83a1U,
    0x8369c196U,
    0x6b1ce2e1U,
    0x4c80d1beU,
    0x5bd8590dU,
    0x24efaf24U,
    0xbc4e834eU,
    0xd3bcc1cdU,
    0x736062ccU,
    0xb31912c2U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x8000000U,
    0x84000000U,
    0x3e000000U,
    0xe9000000U,
    0x50800000U,
    0x7ec00000U,
    0x30600000U,
    0xfab00000U,
    0x5cd80000U,
    0xdb740000U,
    0x11320000U,
    0xd1870000U,
    0x1a458000U,
    0x98b54000U,
    0x57d5e000U,
    0xc0eeb000U,
    0x947e8800U,
    0x94b53400U,
    0xadcb6a00U,
    0xf7eb8500U,
    0xddede180U,
    0xb2eab2c0U,
    0x67748ba0U,
    0x33635d0U,
    0x9284ead8U,
    0x65ddc4b4U,
    0xd3f7803aU,
    0xf3f2409fU,
    0xa3f06223U,
    0xbbebf3c1U,
    0xc7f3696aU,
    0x75ef8533U,
    0x26e7e28dU,
    0xa169b374U,
    0x663b0a2eU,
    0x780074f5U,
    0xcc1e8aa4U,
    0x5a0536f6U,
    0x27136b41U,
    0xb19f841eU,
    0xaa5fe029U,
    0x70adb182U,
    0x23d10b6fU,
    0xf6f375ebU,
    0xf9690b0dU,
    0xfa3775b4U,
    0x3a030b8eU,
    0x97047425U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x28000000U,
    0xd4000000U,
    0x42000000U,
    0xb1000000U,
    0xfb800000U,
    0x9cc00000U,
    0xf0e00000U,
    0xd0300000U,
    0x16c80000U,
    0x5f40000U,
    0x21b60000U,
    0xbf070000U,
    0x648b8000U,
    0x854c000U,
    0xe0b16000U,
    0x9c86d000U,
    0x34462800U,
    0x16bfe400U,
    0x3f974a00U,
    0x56c93700U,
    0xa5f96380U,
    0x11b2d240U,
    0xc7102920U,
    0x9888e610U,
    0x9e54cba8U,
    0x13a9f694U,
    0xd61e0166U,
    0x530302f7U,
    0x7a95810dU,
    0x1f57c323U,
    0x9024e230U,
    0xb6d112c3U,
    0x35e2ca3bU,
    0x59aef65cU,
    0x43158339U,
    0xf297c0eeU,
    0xfb44e008U,
    0xaa211044U,
    0xfbcacb2eU,
    0x586af793U,
    0x366b8233U,
    0xf964c218U,
    0x45f96217U,
    0x81b2d07dU,
    0x8f1029bbU,
    0x1c88e41cU,
    0xf454ca19U,
    0x76a9f6feU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x38000000U,
    0xf4000000U,
    0xee000000U,
    0x1f000000U,
    0xe4800000U,
    0x39400000U,
    0xea600000U,
    0x2f300000U,
    0xa7580000U,
    0x6d740000U,
    0x6fba0000U,
    0xf8090000U,
    0x540d8000U,
    0xbe094000U,
    0x970f2000U,
    0x2886f000U,
    0x2358f800U,
    0x1b644400U,
    0xd4b7da00U,
    0x7a92b500U,
    0xbe572180U,
    0xaaf2f3c0U,
    0x7062fb60U,
    0x9e2d4510U,
    0xbcda5958U,
    0xabf6acU,
    0x848001aaU,
    0xc9400359U,
    0x3260035bU,
    0x6b300149U,
    0x7158026cU,
    0x867402a5U,
    0x653a0309U,
    0xde4902ccU,
    0x5aed80d5U,
    0xa8794141U,
    0xda372238U,
    0x6ac2f353U,
    0xebbaf9f2U,
    0x8e19469aU,
    0xef005931U,
    0x3c92f59fU,
    0x7d558327U,
    0x3c7d42dbU,
    0xc4352289U,
    0xadcff10cU,
    0x4b357bb5U,
    0x615d0451U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x98000000U,
    0x14000000U,
    0x6a000000U,
    0xc9000000U,
    0x4e800000U,
    0xdd400000U,
    0x84200000U,
    0x53700000U,
    0xe580000U,
    0xdbbc0000U,
    0x74ba0000U,
    0xcd350000U,
    0x5dfd8000U,
    0x731dc000U,
    0xaf856000U,
    0xbfcb7000U,
    0xd770b800U,
    0xec5ecc00U,
    0xceadda00U,
    0x2c29bd00U,
    0x3f676080U,
    0x204272c0U,
    0x10b738e0U,
    0x7f360f90U,
    0x20f539c8U,
    0xa78f0e74U,
    0x23cab812U,
    0x616bce91U,
    0x335059caU,
    0xaf347ca8U,
    0x8e20161U,
    0x8b890397U,
    0xadc78199U,
    0x5a68c39bU,
    0xa0d8e047U,
    0x56e6b3b4U,
    0x988dd972U,
    0x1259bd41U,
    0x2dbf6122U,
    0xbbe722cU,
    0x5cad386bU,
    0xe1330c1aU,
    0xd3f0b985U,
    0x481ece08U,
    0x3c0dd8d1U,
    0x4619bf2fU,
    0x471f60b5U,
    0x758e72b5U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x8000000U,
    0x8c000000U,
    0x66000000U,
    0x71000000U,
    0x7c800000U,
    0x6a400000U,
    0x7e200000U,
    0xa2700000U,
    0x85480000U,
    0xa7a40000U,
    0xb6be0000U,
    0x9a3b0000U,
    0x18648000U,
    0x7a5b4000U,
    0xb635e000U,
    0xce6f3000U,
    0x73449800U,
    0xdeb4ec00U,
    0x46397a00U,
    0x967fdf00U,
    0x1743e180U,
    0xa4b03140U,
    0x593e1ba0U,
    0x17e4ac70U,
    0x67801bb8U,
    0xc1dfacf4U,
    0xf9e499eaU,
    0x5a84ed2dU,
    0x3b5179aaU,
    0x72abdc50U,
    0x5035e3d5U,
    0x7f6f32a3U,
    0xefc49b05U,
    0x24f4ecebU,
    0x30197909U,
    0xb80fdc55U,
    0xf40be0beU,
    0x721433eaU,
    0x93001870U,
    0xe79fafe5U,
    0x1c49a3bU,
    0x19f4ee41U,
    0xca997ad9U,
    0x334fdfc0U,
    0xfeabe13dU,
    0x3624315fU,
    0xe681b43U,
    0x934bad08U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0xa8000000U,
    0xd4000000U,
    0x4a000000U,
    0x9b000000U,
    0x3b800000U,
    0x56400000U,
    0x4ee00000U,
    0xdab00000U,
    0x6b480000U,
    0xc86c0000U,
    0xca6a0000U,
    0x95730000U,
    0x9cf38000U,
    0x5da1c000U,
    0x1edd2000U,
    0x97399000U,
    0x58017800U,
    0xbc00b400U,
    0x3e145a00U,
    0xa1152700U,
    0x89f2080U,
    0xb9d692c0U,
    0x52b0f820U,
    0xf4e7690U,
    0x8a78f988U,
    0xf562763cU,
    0x4cf2f946U,
    0x85a175f5U,
    0x62c97bf5U,
    0x92cb7a3U,
    0x891e5b9eU,
    0x1c9627b7U,
    0x53c4a162U,
    0xb9ab53d1U,
    0x9ccfd987U,
    0x828e5ecU,
    0xf18003f8U,
    0xd400004U,
    0xd56001e2U,
    0xfcf00047U,
    0x8da8021aU,
    0xc6dc0115U,
    0xeb220045U,
    0xc61f033bU,
    0x6d19806aU,
    0x9e92c32dU,
    0xcccea2e1U,
    0x10285189U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x78000000U,
    0x7c000000U,
    0xda000000U,
    0x45000000U,
    0xfb800000U,
    0x94c00000U,
    0xeae00000U,
    0x4c300000U,
    0xf7c80000U,
    0x4e6c0000U,
    0xc66a0000U,
    0x2690000U,
    0x47c8000U,
    0xeb66c000U,
    0x2deee000U,
    0x3ea55000U,
    0x9a842800U,
    0x795ea400U,
    0x3922ca00U,
    0x1457f700U,
    0x76ace080U,
    0xfe9052c0U,
    0xf5aab60U,
    0xae3d6430U,
    0xaedaa888U,
    0xbffd67e4U,
    0x1fbaa806U,
    0x170d6587U,
    0x7a92a925U,
    0x69516453U,
    0x9130aa7cU,
    0x6054662dU,
    0xa8a62920U,
    0x1d9ba547U,
    0x6bd44945U,
    0x846836e3U,
    0x2b768134U,
    0x8dffc329U,
    0x4eba6256U,
    0xe29f9268U,
    0x548c894U,
    0xe33ef4aeU,
    0x51506073U,
    0x8d3690bbU,
    0x6a544928U,
    0xe5a83463U,
    0xe2168023U,
    0x590fc054U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0xc8000000U,
    0x8c000000U,
    0x82000000U,
    0x83000000U,
    0xc9800000U,
    0xb0400000U,
    0x3ee00000U,
    0xc8b00000U,
    0xbb480000U,
    0xdb740000U,
    0x8afe0000U,
    0xdeb30000U,
    0x9e4c8000U,
    0x8ff7c000U,
    0x3a272000U,
    0x968bd000U,
    0x93c3f800U,
    0xf1ae7400U,
    0x65ccda00U,
    0x4a1a700U,
    0x99592380U,
    0x2878d340U,
    0x9b6f7aa0U,
    0x2ae9b670U,
    0xaea3fb28U,
    0x465e773cU,
    0xcbe4daaeU,
    0x3425a78dU,
    0x978f237dU,
    0xd94fd093U,
    0x8875fabeU,
    0xeb697433U,
    0xf2fe58c8U,
    0xeaa565eaU,
    0x48528207U,
    0xcaf4c1eaU,
    0x7ea3a101U,
    0xee48109bU,
    0x57fadbb2U,
    0x7e26a695U,
    0x988ba249U,
    0x92cc1231U,
    0xbb2cd915U,
    0x1c11a60fU,
    0x8a1123e0U,
    0x6f0cd2d6U,
    0x5b9178a9U,
    0xfb5ab667U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x98000000U,
    0x84000000U,
    0x16000000U,
    0x99000000U,
    0x16800000U,
    0x9e400000U,
    0x3e600000U,
    0x9a300000U,
    0x17480000U,
    0xe40000U,
    0xf8620000U,
    0xcb350000U,
    0x8dd78000U,
    0xe4b84000U,
    0x5500e000U,
    0x4c847000U,
    0x9d4c5800U,
    0xcbfb6400U,
    0x81e4ba00U,
    0xaaeb1700U,
    0xa362e180U,
    0x5ab172c0U,
    0xf01bd9e0U,
    0x580327d0U,
    0x64045838U,
    0x661f6774U,
    0x106b982U,
    0x929e16ddU,
    0x88556343U,
    0xa77930c1U,
    0x8cb3391cU,
    0x891357dfU,
    0x3e8203deU,
    0x62450222U,
    0xdc7f82adU,
    0x8d2c430bU,
    0x1ccae1fdU,
    0x9e2570a2U,
    0xc151d83cU,
    0x79e2253eU,
    0x9ef9dba3U,
    0xcd762440U,
    0x37b3d971U,
    0x689726e5U,
    0xdb4e5be6U,
    0x5afe6556U,
    0xfb7b3b2fU,
    0x3eb755d6U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x58000000U,
    0xc000000U,
    0x3a000000U,
    0x5d000000U,
    0xf3800000U,
    0x8400000U,
    0x57e00000U,
    0x81b00000U,
    0x75480000U,
    0x54740000U,
    0xe1f60000U,
    0x26a90000U,
    0xbbce8000U,
    0xffb8c000U,
    0xe651e000U,
    0xfced5000U,
    0x752eb800U,
    0x83849400U,
    0xa0575a00U,
    0x33edc700U,
    0xbfa7e380U,
    0x46445240U,
    0xcce038e0U,
    0x7d3c5570U,
    0xd786bb88U,
    0x96409644U,
    0x54e958a6U,
    0x1130c715U,
    0xbd9f6071U,
    0x93559057U,
    0xab7f5882U,
    0x2369c753U,
    0xb779e214U,
    0xe16953aeU,
    0xd670ba91U,
    0x20e99577U,
    0xd727d952U,
    0xb288044bU,
    0x39ce8228U,
    0x3eb8c104U,
    0x17d1e0c6U,
    0xf5ad51a5U,
    0xb34eba59U,
    0x5b749603U,
    0x4b7f599cU,
    0xb369c5eaU,
    0x8f79e237U,
    0xbd695262U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0xa8000000U,
    0xd4000000U,
    0xd6000000U,
    0xb3000000U,
    0xc1800000U,
    0xe7c00000U,
    0xdba00000U,
    0xf700000U,
    0x55580000U,
    0xdde40000U,
    0xa3020000U,
    0xd9830000U,
    0xfbc38000U,
    0x29be4000U,
    0xc269a000U,
    0xf3ccd000U,
    0x2dba0800U,
    0x2c73ec00U,
    0xccd1aa00U,
    0x463c3d00U,
    0x7aa82380U,
    0xb3f192c0U,
    0xdc102b20U,
    0xd2017c90U,
    0x5d0203f8U,
    0xfe83009cU,
    0x8c4381deU,
    0x8d7e4293U,
    0x7049a2c8U,
    0xcf7cd0f2U,
    0x75420963U,
    0x4de7ed86U,
    0xfb0baadfU,
    0xa59b3e8eU,
    0xf9c9a18dU,
    0x4cbcd13dU,
    0xb0e20a93U,
    0xd597ec8eU,
    0x11d3aacbU,
    0xf8bf3c84U,
    0x96eba3b4U,
    0xce8fd29cU,
    0x4598a98U,
    0xc97daf2aU,
    0xfe400befU,
    0x64eee0U,
    0xb6c82930U,
    0xcf257e28U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0xa8000000U,
    0xb4000000U,
    0x66000000U,
    0x93000000U,
    0x57800000U,
    0x4f400000U,
    0x2d200000U,
    0x99700000U,
    0x77d80000U,
    0xd7e40000U,
    0xc6120000U,
    0xc3130000U,
    0xef8f8000U,
    0x23544000U,
    0x572ba000U,
    0xd87e1000U,
    0xd557d800U,
    0x5c3a2c00U,
    0xf3ee7a00U,
    0x38173d00U,
    0x2c162380U,
    0x1a0950c0U,
    0x310bfb20U,
    0xa847f10U,
    0x3fd80138U,
    0x53e4019cU,
    0x68120146U,
    0x941302b1U,
    0x760f834aU,
    0x4b144188U,
    0x4b8ba0f3U,
    0x9d4e1376U,
    0xd82fdb99U,
    0x5dee2d6eU,
    0x6f047a12U,
    0xb5903ce4U,
    0x7253a0bdU,
    0x2daa1073U,
    0x4fbdda31U,
    0x32bd2e0dU,
    0x522bfa1cU,
    0xf4f47c81U,
    0x19800165U,
    0x28400058U,
    0x7ca001ebU,
    0x3530017aU,
    0xa57801a7U,
    0xb5d40023U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0x38000000U,
    0x34000000U,
    0x1e000000U,
    0xf3000000U,
    0x86800000U,
    0xc6c00000U,
    0xf5a00000U,
    0x68700000U,
    0x7580000U,
    0xebec0000U,
    0x881a0000U,
    0x6c010000U,
    0x7a058000U,
    0xa50b4000U,
    0x799aa000U,
    0x6a483000U,
    0xde6bc800U,
    0xe8480c00U,
    0x2f6b6a00U,
    0xdfc13d00U,
    0xfe252280U,
    0x8b3270c0U,
    0xfaace860U,
    0xbce77d10U,
    0x38800298U,
    0x5c0021cU,
    0x6b2002e2U,
    0xeab00117U,
    0xd4f8012cU,
    0x449c026aU,
    0x17c203b3U,
    0xb22d01c2U,
    0x813f8027U,
    0x67ba4104U,
    0xf167201eU,
    0x4cdf7285U,
    0x28b36813U,
    0x5ed3c92U,
    0x31f22bfU,
    0xfe8372b8U,
    0xd2d16aacU,
    0x9bb03f8aU,
    0xa378a043U,
    0xb5d5312aU,
    0x332c4b93U,
    0x8eae4d72U,
    0x82ee4b4fU,
    0xbb834f50U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x98000000U,
    0x84000000U,
    0x72000000U,
    0x73000000U,
    0xdd800000U,
    0x86400000U,
    0x4e600000U,
    0xff300000U,
    0x3ed80000U,
    0x4a40000U,
    0x61960000U,
    0x510000U,
    0xe76f8000U,
    0x1da4c000U,
    0xb0b2000U,
    0x49815000U,
    0xc433800U,
    0xe96e6400U,
    0xc8be1a00U,
    0x4f8e3500U,
    0xe54aa380U,
    0x6be09040U,
    0xad699be0U,
    0x9abef750U,
    0xc8f81a8U,
    0xf0d4c2dcU,
    0xf1b3233eU,
    0x15155295U,
    0x648d382fU,
    0x9cdb67f5U,
    0xafa79a0aU,
    0x580bf722U,
    0xa416018bU,
    0x4211024aU,
    0xbb0f80c2U,
    0xc194c0dbU,
    0x705320e2U,
    0x4f65529eU,
    0x51b53b25U,
    0x650f6557U,
    0xcc8998c1U,
    0xd0cef608U,
    0xc1b782d9U,
    0xdd00c219U,
    0x789d238cU,
    0x6ad05323U,
    0xaeacb816U,
    0xf68aa73cU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x18000000U,
    0x9c000000U,
    0x32000000U,
    0x3d000000U,
    0x5c800000U,
    0xb3400000U,
    0x83200000U,
    0x59700000U,
    0x90c80000U,
    0x19f40000U,
    0xd18e0000U,
    0xc7c90000U,
    0x447c8000U,
    0xfc57c000U,
    0x42bae000U,
    0x46a3b000U,
    0x28a1b800U,
    0x47a6ac00U,
    0xb6355a00U,
    0x41fc1f00U,
    0xed806380U,
    0x5c97140U,
    0xf169d9e0U,
    0x24dbdc30U,
    0x5ff282a8U,
    0xca9ec184U,
    0x1046603aU,
    0x38b47079U,
    0x9fbb5b1eU,
    0x4a351dd8U,
    0xe3fce287U,
    0xc89eb2f6U,
    0xc55339f7U,
    0x70386ff5U,
    0x9af33a3bU,
    0x5a086cfbU,
    0xe91b3910U,
    0x8a8c6f38U,
    0xb05d387cU,
    0xc8b16ee6U,
    0x17afba4fU,
    0xce2fad49U,
    0x4de9d87dU,
    0xc79bdd64U,
    0xa4d283c1U,
    0x9feec2e9U,
    0xaa8e6166U,
    0x80407244U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x38000000U,
    0x94000000U,
    0xd6000000U,
    0x99000000U,
    0x3800000U,
    0x43400000U,
    0xc5a00000U,
    0x59f00000U,
    0x2ec80000U,
    0x4be40000U,
    0xa9ca0000U,
    0x9d790000U,
    0x9b198000U,
    0x6c964000U,
    0x9d2e000U,
    0x8d67d000U,
    0x7305d800U,
    0xf0897c00U,
    0x73d53a00U,
    0x5673af00U,
    0x3f836180U,
    0x295593c0U,
    0xf6bd3b60U,
    0x8967ae90U,
    0x8d0161b8U,
    0x15889334U,
    0x3a4eb8d6U,
    0xf638efa9U,
    0x22a201f8U,
    0x7f6d013aU,
    0xc41b8375U,
    0x1e0b42ecU,
    0xd50162f2U,
    0x71889007U,
    0x344eb885U,
    0xcb38ecc4U,
    0xcf2200feU,
    0x312d00a5U,
    0xd43b83daU,
    0x9dbb4225U,
    0x3de96234U,
    0x20dc9056U,
    0x76ecb8e9U,
    0x4455efd8U,
    0xd339828aU,
    0x8b2642fdU,
    0xef3ae090U,
    0xe133d0b8U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x38000000U,
    0xa4000000U,
    0xb6000000U,
    0x29000000U,
    0x48800000U,
    0x7a400000U,
    0x9ba00000U,
    0x16f00000U,
    0xd80000U,
    0xeef40000U,
    0x4ca0000U,
    0x88e90000U,
    0x25df8000U,
    0x5c6c4000U,
    0x4d98e000U,
    0x58d6b000U,
    0x3aeb9800U,
    0x6adb9c00U,
    0x35e17a00U,
    0xe3502d00U,
    0xab3f6180U,
    0x28bef1c0U,
    0x1d617b60U,
    0xe9102e50U,
    0xe89f6038U,
    0xaa4ef334U,
    0x93b9787aU,
    0x8ae42d8dU,
    0x12d561acU,
    0x71e7f222U,
    0x6546fb35U,
    0xba386f84U,
    0xc43583d2U,
    0xd13543e1U,
    0x5bbf63b2U,
    0xb6fef36dU,
    0xd0c17860U,
    0xe6e02cd0U,
    0x98c76378U,
    0x9afaf314U,
    0xbad37a0aU,
    0x3dfd2dc5U,
    0x7f52e3d0U,
    0xb93fb3a4U,
    0xb7b41bfeU,
    0x7cf7dc03U,
    0xdbd999e7U,
    0x9769fb9U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x38000000U,
    0x1c000000U,
    0xd2000000U,
    0x51000000U,
    0xc9800000U,
    0x65c00000U,
    0x23600000U,
    0x21b00000U,
    0xb4580000U,
    0x8abc0000U,
    0x48d60000U,
    0x48fd0000U,
    0x1d608000U,
    0xeab3c000U,
    0x38db6000U,
    0x40fe9000U,
    0xa97ec800U,
    0x1cac7400U,
    0xa7cbaa00U,
    0xa63e500U,
    0x543be080U,
    0x938d5340U,
    0xc0c5aa60U,
    0xbce2e630U,
    0x4b6d61a8U,
    0xe5b39034U,
    0x4a464aeeU,
    0xa1a3b693U,
    0xf446c94bU,
    0x2aa07461U,
    0xd8c5a994U,
    0x70e2e4a8U,
    0x16d60b4U,
    0x38b391aeU,
    0x69c648f3U,
    0x8963b57bU,
    0xcca6c8c9U,
    0x3fd07520U,
    0x867dab06U,
    0xbe2ee747U,
    0xde836155U,
    0xdb4293faU,
    0x8828c97bU,
    0xa191779fU,
    0xa1cb29ffU,
    0xdd6025cfU,
    0xab88167U,
    0x8cfc1d3U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0xd8000000U,
    0xdc000000U,
    0x3a000000U,
    0x4d000000U,
    0x60800000U,
    0xf0c00000U,
    0x76a00000U,
    0xe5700000U,
    0xc0580000U,
    0xfe740000U,
    0x3fde0000U,
    0x57210000U,
    0x772c8000U,
    0x4736c000U,
    0xef31e000U,
    0x7b283000U,
    0x45384800U,
    0xee2fec00U,
    0xf9afaa00U,
    0x24e2dd00U,
    0xc21d6180U,
    0xa11ef340U,
    0xf289a8e0U,
    0x29c7dd30U,
    0x2837e188U,
    0xbebd3344U,
    0xa16acaeaU,
    0xc6482cb7U,
    0x196ac938U,
    0xca482e26U,
    0x1b6acbb3U,
    0xcb482e18U,
    0x99eac89cU,
    0xaa882d56U,
    0xb5cacaf1U,
    0xf2382ed1U,
    0x63b2caebU,
    0x19fc2dceU,
    0xea94c807U,
    0x55d92e5aU,
    0x623e4a7fU,
    0xbbbaec9cU,
    0xc5fd2afcU,
    0xd0851c0cU,
    0x18d801a4U,
    0x2b40370U,
    0x4b7e0142U,
    0xb35100c9U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0xc8000000U,
    0xcc000000U,
    0xd6000000U,
    0x3f000000U,
    0xc9800000U,
    0xe5400000U,
    0x65e00000U,
    0xb9300000U,
    0x11980000U,
    0x915c0000U,
    0x17f20000U,
    0xac2f0000U,
    0xf9188000U,
    0x4e9f4000U,
    0x88cf2000U,
    0xaaa1d000U,
    0xfdd51800U,
    0x923b5400U,
    0x7a02ba00U,
    0x3905c500U,
    0xae988080U,
    0x18df41c0U,
    0x52af21a0U,
    0xf9d1d3f0U,
    0x882d1878U,
    0x931757ccU,
    0xcf88ba7eU,
    0x8246c669U,
    0x986a0231U,
    0x8e7300b1U,
    0x516a8071U,
    0x8f04351U,
    0x15b7a061U,
    0x744e9339U,
    0xd7623bc5U,
    0x2ff684e3U,
    0x483da176U,
    0x730d93e1U,
    0x5f90ba85U,
    0x7a5ac483U,
    0x9c780326U,
    0x946c0069U,
    0xb86a0131U,
    0xfe730331U,
    0x396a8231U,
    0xf4f040b1U,
    0xbb7a071U,
    0x874e9351U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x38000000U,
    0xf4000000U,
    0x26000000U,
    0x33000000U,
    0xe4800000U,
    0x95c00000U,
    0x42e00000U,
    0xbbb00000U,
    0xe0980000U,
    0x2bd40000U,
    0x55fa0000U,
    0x71310000U,
    0x8a418000U,
    0x5fae4000U,
    0x6e88a000U,
    0x4d3f000U,
    0x6b6ba800U,
    0x3df6a400U,
    0xcd228a00U,
    0x804b1500U,
    0x8ea18180U,
    0xa71e41c0U,
    0xb290a360U,
    0x7ec7f310U,
    0x6271a878U,
    0x3077a71cU,
    0x657b090aU,
    0x52f1579bU,
    0x13b32319U,
    0xfc8cb179U,
    0xf1c289e9U,
    0x8cfb1551U,
    0x74b980adU,
    0xee0a4377U,
    0x5f0aa3f4U,
    0xe686f2e1U,
    0x88c829eaU,
    0x597de604U,
    0x18f1a806U,
    0x22b7a769U,
    0x51b0a5eU,
    0x7f81540aU,
    0x6d4b221bU,
    0xd28b0d9U,
    0x20408b19U,
    0x5eae1579U,
    0xaf1a03e9U,
    0x7e810051U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0xb8000000U,
    0xcc000000U,
    0xd2000000U,
    0x99000000U,
    0x77800000U,
    0x35c00000U,
    0xe6e00000U,
    0x50b00000U,
    0x5d880000U,
    0x40c40000U,
    0xb37e0000U,
    0x54650000U,
    0xb8e68000U,
    0x3bb7c000U,
    0x431f6000U,
    0xaa8cd000U,
    0x1458c800U,
    0xfc2ca400U,
    0xfec12a00U,
    0xc867b700U,
    0xf2ee8180U,
    0x9eb3c340U,
    0x4e816160U,
    0x7259d370U,
    0x9b3649a8U,
    0xd25f6554U,
    0xab204896U,
    0x9a4e65b3U,
    0xcf30cbc5U,
    0x3c58a6d5U,
    0x4837298dU,
    0xc6b431U,
    0x93760393U,
    0xa4610246U,
    0x10f883d8U,
    0x4fa2c07cU,
    0x5d11e002U,
    0xe18f1285U,
    0xfad1a926U,
    0xbe7177a8U,
    0x2de96054U,
    0x7e2dd216U,
    0xffc04973U,
    0x83fe64e5U,
    0xbd38ca45U,
    0x955ca595U,
    0x77a928edU,
    0x5113b741U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0xd8000000U,
    0x5c000000U,
    0x9e000000U,
    0x31000000U,
    0xf7800000U,
    0xb400000U,
    0xf1e00000U,
    0x29300000U,
    0x61980000U,
    0xfe440000U,
    0xa4660000U,
    0xdd610000U,
    0x8ee88000U,
    0x77ac4000U,
    0xa14be000U,
    0xcaedd000U,
    0x95b91800U,
    0x3e4e1400U,
    0x847a7a00U,
    0xed7f8500U,
    0x6f08380U,
    0xf3a84040U,
    0x634de2e0U,
    0x65fcd030U,
    0x53299918U,
    0xc29655b4U,
    0x7ecf9ba6U,
    0x35b755e9U,
    0x4e471b99U,
    0x6c6b14c9U,
    0x3974faa1U,
    0x1cf2c66dU,
    0xb3e18fU,
    0x3bd9d178U,
    0xa8271becU,
    0x5e1b1672U,
    0x110cfbbfU,
    0xc786c6c8U,
    0x834de0b4U,
    0x75fcd026U,
    0xeb2999a9U,
    0xce965779U,
    0x38cf9bf9U,
    0x58b75539U,
    0x27c71819U,
    0x562b1489U,
    0x3f14f841U,
    0x3e82c65dU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x58000000U,
    0xbc000000U,
    0x6e000000U,
    0x85000000U,
    0xf7800000U,
    0xf9c00000U,
    0xb6a00000U,
    0x9ef00000U,
    0x40980000U,
    0x354c0000U,
    0xf5f20000U,
    0x720d0000U,
    0x1b148000U,
    0xa9e4000U,
    0x24b6000U,
    0x79655000U,
    0x11464800U,
    0x47ec2c00U,
    0x901aa00U,
    0x819b3d00U,
    0xe0de8280U,
    0x9f2f43c0U,
    0xba35e1e0U,
    0xbdba1030U,
    0x3c6ba8d8U,
    0x86da3ce4U,
    0x2e380066U,
    0x57bc00f3U,
    0xfb6a0184U,
    0x7241035cU,
    0x416682b8U,
    0x3d53405eU,
    0xc1ffe36dU,
    0x680b1309U,
    0xa4152865U,
    0xf2057e05U,
    0x5b15e0bfU,
    0x2a8a12b4U,
    0xb253a9ceU,
    0x21663eefU,
    0xad5200d6U,
    0x29fd0121U,
    0x8c0c82f3U,
    0x76124084U,
    0x191963dcU,
    0x29985078U,
    0x24cac93eU,
    0xfd3e6d9dU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0xd8000000U,
    0xcc000000U,
    0xba000000U,
    0x11000000U,
    0xb1800000U,
    0xbec00000U,
    0xd1600000U,
    0x98300000U,
    0xa4980000U,
    0x11440000U,
    0xb0b20000U,
    0x6fd50000U,
    0x40ea8000U,
    0xb6f2c000U,
    0x5df36000U,
    0x9d7b1000U,
    0x62326800U,
    0xd58bb400U,
    0x50d38a00U,
    0xd6766500U,
    0x72b88380U,
    0x62d7c2c0U,
    0x361e2e0U,
    0xfd3dd0f0U,
    0x930b0988U,
    0xdc91a774U,
    0xd41622eU,
    0x42ae13bfU,
    0x9ad8e803U,
    0x5f79775bU,
    0x6f20e8b7U,
    0x960d7415U,
    0x1b0ae938U,
    0x189c777eU,
    0x335269e7U,
    0xdbbb46fU,
    0x944b8939U,
    0x3732677aU,
    0x1a0a82a3U,
    0xc102c229U,
    0xf98b6382U,
    0x5acf119fU,
    0x7f786b13U,
    0xff2ab7a3U,
    0xbe13098bU,
    0xf15a42fU,
    0x6e936099U,
    0x984b12aaU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x8000000U,
    0xc000000U,
    0x9e000000U,
    0x77000000U,
    0xf9800000U,
    0x4400000U,
    0x7c600000U,
    0x83b00000U,
    0xea880000U,
    0xbfdc0000U,
    0x89220000U,
    0x45570000U,
    0xef88000U,
    0xc8664000U,
    0xd9b32000U,
    0x2f9cd000U,
    0x9f443800U,
    0xbffc400U,
    0xc8e79a00U,
    0x6b695700U,
    0xaa3a8280U,
    0xf6c143c0U,
    0xf7a3a0a0U,
    0x909690f0U,
    0x4add1a58U,
    0xa1a815ecU,
    0xcb99239eU,
    0x1d57d2cdU,
    0xdafeba97U,
    0x427e86dfU,
    0x4a4387bU,
    0x3b0fc7c1U,
    0x878f9976U,
    0x634555f6U,
    0xbdf08359U,
    0x83fa41d5U,
    0x4f12074U,
    0xd57bd0bdU,
    0xed34bb0fU,
    0x7458793U,
    0xfff6b915U,
    0x72e28454U,
    0xbe663a8dU,
    0xb2a8c677U,
    0x701f18cfU,
    0xe80f1733U,
    0x1c09a1e5U,
    0xa61d920cU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x78000000U,
    0xac000000U,
    0x5a000000U,
    0x11000000U,
    0x53800000U,
    0xf3400000U,
    0x63e00000U,
    0xed300000U,
    0xca980000U,
    0x4cc0000U,
    0x2ea60000U,
    0x1dd0000U,
    0xeb328000U,
    0x898ac000U,
    0xa2436000U,
    0x10635000U,
    0xe739800U,
    0xd16e5400U,
    0x45fa7a00U,
    0xbe3bc500U,
    0x14148280U,
    0x9617c140U,
    0x7b11e160U,
    0x2a9992f0U,
    0x74c8f888U,
    0x66b106f4U,
    0xc5d7e226U,
    0x65349289U,
    0x6e827841U,
    0xbac7c439U,
    0xa1aa8145U,
    0xcd46c017U,
    0xace56278U,
    0x1be5010U,
    0x9d411bb8U,
    0xf4e4975cU,
    0xbdb91bc2U,
    0xbf589497U,
    0x49e71a54U,
    0xb439959aU,
    0x5d0b9b7bU,
    0x799255feU,
    0xaa447bc9U,
    0xf46ac521U,
    0x906000c9U,
    0x4e7002cdU,
    0xf1780363U,
    0x55fc029eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0xd8000000U,
    0xc4000000U,
    0xb2000000U,
    0x1d000000U,
    0xf1800000U,
    0xe4400000U,
    0xfce00000U,
    0x34300000U,
    0xbd180000U,
    0x818c0000U,
    0x1c420000U,
    0x8fd0000U,
    0x5e338000U,
    0x6416c000U,
    0xc219e000U,
    0xe51f9000U,
    0x59fb800U,
    0x8e409400U,
    0x25f7da00U,
    0x77b4c500U,
    0x44420280U,
    0x8cfd01c0U,
    0xcc3383e0U,
    0x4916c3d0U,
    0xeb99e1a8U,
    0xc55f9364U,
    0x4b7fb90eU,
    0xa77097e5U,
    0x696fda35U,
    0x1278c641U,
    0xa4e00387U,
    0xb0300316U,
    0x2f180165U,
    0xac8c01f5U,
    0x35c200a1U,
    0x28bd02d7U,
    0x10d3837eU,
    0x4d26c1e1U,
    0x8e81e32bU,
    0x80d392ecU,
    0xe53db986U,
    0xb28d9531U,
    0xc6dc5903U,
    0x922e04c8U,
    0x9a19e1a8U,
    0x611f9364U,
    0x979fb90eU,
    0xa34097e5U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x28000000U,
    0x2c000000U,
    0x96000000U,
    0x7000000U,
    0x14800000U,
    0xd4c00000U,
    0x4c600000U,
    0x23300000U,
    0xc3180000U,
    0x8e840000U,
    0x15ca0000U,
    0x47e30000U,
    0xe7708000U,
    0xe1af4000U,
    0x70c62000U,
    0xe6607000U,
    0xca270800U,
    0xe48d9400U,
    0xdcdbaa00U,
    0x3061a500U,
    0xad2a0380U,
    0xc01301c0U,
    0x20088120U,
    0x501b4070U,
    0x181422f8U,
    0x40770acU,
    0xba1d8a0aU,
    0x9101d74fU,
    0x138d0b63U,
    0xc05e96dfU,
    0x98b329bdU,
    0x6f4ae776U,
    0xe026207bU,
    0x4d907255U,
    0x9b5f08b2U,
    0x523996f5U,
    0xa089aaf4U,
    0x6c6a6e0U,
    0x91708250U,
    0x96af4208U,
    0x2c462314U,
    0x2ea072c6U,
    0x38470955U,
    0xecbd94c4U,
    0x9d43aaf8U,
    0x6d25a4acU,
    0xe000000aU,
    0x7000024fU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x38000000U,
    0xe4000000U,
    0x4e000000U,
    0x7b000000U,
    0x80800000U,
    0x46c00000U,
    0x3f600000U,
    0xda300000U,
    0x17080000U,
    0xd29c0000U,
    0xb7c20000U,
    0xbae10000U,
    0x5f6b8000U,
    0xa3d4000U,
    0x3f0aa000U,
    0x3e857000U,
    0x25ddc800U,
    0x6bf2b400U,
    0xeafeea00U,
    0xb76b8700U,
    0xc6220280U,
    0x9d1103c0U,
    0xd7838060U,
    0x74514350U,
    0x98a0a1d8U,
    0x68c8727cU,
    0x947c4b3aU,
    0x72b2f4f7U,
    0xbdddc8ffU,
    0x7ff2b573U,
    0xbcfeea21U,
    0x186b87e2U,
    0x30a200e3U,
    0x44d101f1U,
    0x266382faU,
    0x93a1407fU,
    0x3048a25bU,
    0x26a473b5U,
    0xbd64bacU,
    0xc0fff6caU,
    0x427c4b9fU,
    0x1db2f54bU,
    0x6b5dc84dU,
    0x9632b5a0U,
    0x751ee9d8U,
    0x1b9b867cU,
    0xd64a013aU,
    0x71bd03f7U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0xd8000000U,
    0x5c000000U,
    0xe2000000U,
    0xe5000000U,
    0x5d800000U,
    0x4ac00000U,
    0x10a00000U,
    0xcaf00000U,
    0xe9080000U,
    0x17940000U,
    0x4bda0000U,
    0x432d0000U,
    0x5f208000U,
    0x1d3fc000U,
    0x2824e000U,
    0x1da51000U,
    0xd36be800U,
    0x7dc9cc00U,
    0xb0358a00U,
    0xe1be1f00U,
    0xe17a0380U,
    0xf0dd01c0U,
    0x69a882e0U,
    0x156bc3b0U,
    0xf6dee0e8U,
    0x82b812e4U,
    0x97e36afeU,
    0x58920ebfU,
    0x67436b34U,
    0xe2620d00U,
    0x364b6866U,
    0x19f60eb5U,
    0x47916a6bU,
    0xe3db0de2U,
    0xa731eb3bU,
    0x5124ce5cU,
    0xc2350bc2U,
    0xccb1de0dU,
    0xe8f6e1b1U,
    0x6c1c10a5U,
    0xfa116a75U,
    0xd91b0c0bU,
    0xf91e812U,
    0x77d4cef3U,
    0x113d08e8U,
    0x6225dee4U,
    0x1cace0feU,
    0x80f111bfU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0x48000000U,
    0xfc000000U,
    0xca000000U,
    0x4d000000U,
    0xe1800000U,
    0x2a400000U,
    0x2a200000U,
    0xf0f00000U,
    0x2b180000U,
    0x6e840000U,
    0x1ad60000U,
    0xfbf30000U,
    0xf5868000U,
    0xec4ec000U,
    0x553ce000U,
    0x387f9000U,
    0x9ec87800U,
    0x15fb8c00U,
    0xa6841a00U,
    0xa6c9dd00U,
    0x51ee0380U,
    0x68870240U,
    0x45c880a0U,
    0x8379c0b0U,
    0xd84c6208U,
    0x233252c4U,
    0xdf6a18aeU,
    0xe24edd9dU,
    0x9626812eU,
    0x5afec26aU,
    0xb604e184U,
    0xc70b9139U,
    0xcc8679e7U,
    0x1bcc8da5U,
    0x48749a95U,
    0x26c41c6aU,
    0x11ec6284U,
    0x88251b9U,
    0x95d21b27U,
    0xcb7adfc5U,
    0x24488045U,
    0xe939c0b2U,
    0x926c6298U,
    0x3c2520bU,
    0xbc721988U,
    0x70cadc84U,
    0x46f0820eU,
    0xec0dc02dU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x18000000U,
    0xec000000U,
    0x5a000000U,
    0xc3000000U,
    0x72800000U,
    0x67c00000U,
    0x33200000U,
    0x59700000U,
    0xcd080000U,
    0x17840000U,
    0x445a0000U,
    0x21650000U,
    0xd10e8000U,
    0xb58ec000U,
    0x5b4f2000U,
    0x11f03000U,
    0x99d1a800U,
    0xae2f1c00U,
    0xa6ea0a00U,
    0x9d44ef00U,
    0xb0f20180U,
    0x145103c0U,
    0xc97c83e0U,
    0xc51fc370U,
    0x3393a108U,
    0xda5ff0bcU,
    0x4c6a08a2U,
    0xd684ee93U,
    0x39d20306U,
    0xbe2103faU,
    0x6ef48078U,
    0x595bc1fbU,
    0x1ee9a245U,
    0x614af36bU,
    0x22ec8b3dU,
    0x134e2d5fU,
    0x15e721e3U,
    0xd7c4300eU,
    0xeb23a846U,
    0x557e1f5aU,
    0xa71689a8U,
    0xcc9b2c23U,
    0xdac1a1a1U,
    0x1cbef26dU,
    0x213e8888U,
    0x9e6f2f7cU,
    0xf193a142U,
    0x355ff2e3U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0x58000000U,
    0x4c000000U,
    0x8e000000U,
    0x5d000000U,
    0x15800000U,
    0xd6400000U,
    0x2e200000U,
    0x84f00000U,
    0x5b080000U,
    0xc8c0000U,
    0xc9d20000U,
    0xf6d0000U,
    0x78528000U,
    0x83204000U,
    0x697e6000U,
    0xf1471000U,
    0xf4bf7800U,
    0x5c348c00U,
    0xcfe19a00U,
    0xff8edf00U,
    0x715a0080U,
    0x34a103c0U,
    0xfc2083e0U,
    0xfffd41f0U,
    0xa784e358U,
    0x3d5b5044U,
    0xbabb1a6eU,
    0xa1229e2dU,
    0xea7662eeU,
    0x71cb124aU,
    0x136d7b54U,
    0x3e598ee1U,
    0xfa33192bU,
    0xe6ee9e3fU,
    0xb804607eU,
    0x1c161085U,
    0x4617fbf2U,
    0x7905cf60U,
    0x8f977b97U,
    0x49488fe2U,
    0xe8bb9b6fU,
    0x1a2fdf51U,
    0xb6fa80d3U,
    0x701c40abU,
    0x380463d8U,
    0xdc161384U,
    0xe617f98eU,
    0x4905cfddU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x98000000U,
    0x84000000U,
    0xe6000000U,
    0x13000000U,
    0x78800000U,
    0xafc00000U,
    0x1ee00000U,
    0xccb00000U,
    0xde080000U,
    0x27040000U,
    0x768e0000U,
    0x30c10000U,
    0x9c638000U,
    0x127c4000U,
    0x4d76a000U,
    0x2ff97000U,
    0x613ce800U,
    0x6a432400U,
    0xe6afca00U,
    0x17031700U,
    0x5e880180U,
    0x5cc40140U,
    0xf66e01e0U,
    0xfb710050U,
    0x44eb81f8U,
    0xdb8425cU,
    0xbb98a27aU,
    0x6f4872f3U,
    0x45376999U,
    0x3c4b658dU,
    0x1dbf6903U,
    0xe38f64aeU,
    0xb516b22U,
    0x333e651fU,
    0xb75ae84bU,
    0xe13627daU,
    0xaa4a4b3cU,
    0x6ba57eaU,
    0x8713212bU,
    0xc68030b5U,
    0xd8c7c9ffU,
    0x10771464U,
    0xe86e03f9U,
    0x3c710162U,
    0xa26b8180U,
    0xa5784140U,
    0xa3f8a1e0U,
    0x9b387050U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x28000000U,
    0x8c000000U,
    0x2a000000U,
    0x9b000000U,
    0xe7800000U,
    0xfb400000U,
    0x86200000U,
    0x43f00000U,
    0xae080000U,
    0x4d0c0000U,
    0xde820000U,
    0xbbd30000U,
    0x98f48000U,
    0x2984c000U,
    0xa64e2000U,
    0xc0bb9000U,
    0x5c259800U,
    0x90e2ac00U,
    0xd5953a00U,
    0x442ff00U,
    0x67a80080U,
    0xb9bc01c0U,
    0x7caa0220U,
    0x9e2f00f0U,
    0x27fe8008U,
    0xa81bc05cU,
    0x4c18a336U,
    0x8a1c5181U,
    0x2b173986U,
    0xcf91fee2U,
    0x775c82a0U,
    0xac38c33bU,
    0xd8e42342U,
    0x4994911bU,
    0xb65b19b9U,
    0x58b96c79U,
    0xf82d9a52U,
    0x36eeaec8U,
    0x649738f7U,
    0x78d1ff6cU,
    0x7b7c801eU,
    0xc4c8c0adU,
    0xb96c22f8U,
    0x73d8915fU,
    0xc4f91880U,
    0x3b9a6dc0U,
    0x29511820U,
    0xa9266ff0U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0xc8000000U,
    0x3c000000U,
    0xda000000U,
    0x53000000U,
    0x2e800000U,
    0x11400000U,
    0x94a00000U,
    0x7e700000U,
    0xac080000U,
    0x2040000U,
    0x771a0000U,
    0x309f0000U,
    0x6c5e8000U,
    0xf3cc000U,
    0xc8a12000U,
    0x5467b000U,
    0xd713f800U,
    0x2092bc00U,
    0x745e5a00U,
    0xcb22cf00U,
    0xe6a00180U,
    0xe17003c0U,
    0x708800a0U,
    0x4c440030U,
    0xdf3a0048U,
    0x30af01bcU,
    0xa07683d2U,
    0x3108c109U,
    0xa99322e8U,
    0x9ccb1bcU,
    0xf4ff78e2U,
    0x63457df1U,
    0xbb3f96cU,
    0xa2e2bfcaU,
    0xe25659edU,
    0xaa26cf3eU,
    0x773a0033U,
    0xfcaf025dU,
    0x527683b6U,
    0x6e08c0afU,
    0x9513227fU,
    0x778cb257U,
    0x94df7bcbU,
    0x5f757c59U,
    0x1d9bf800U,
    0xcfd6bc00U,
    0xade45a00U,
    0xe6cdcf00U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x28000000U,
    0x54000000U,
    0xba000000U,
    0x85000000U,
    0x43800000U,
    0x29c00000U,
    0x70e00000U,
    0x81b00000U,
    0x4c080000U,
    0xa60c0000U,
    0xbb1a0000U,
    0x248b0000U,
    0x934f8000U,
    0xf4bdc000U,
    0xe797e000U,
    0x7bc0d000U,
    0x1f94800U,
    0x8352400U,
    0xc8d32a00U,
    0xc17f3700U,
    0xa9600080U,
    0x9d7002c0U,
    0xf7680220U,
    0x2a7c0090U,
    0x15f20248U,
    0xd2370344U,
    0x9ddd83e6U,
    0xdafac2b3U,
    0xfca260cdU,
    0x38612a1U,
    0x49c928f3U,
    0xa0f4349eU,
    0xd9af81dcU,
    0x300dc10aU,
    0x481fe221U,
    0x840cd280U,
    0xe2034973U,
    0xf90e276dU,
    0xad94ab71U,
    0x16cef4dbU,
    0xb66de2aaU,
    0xebfbd142U,
    0x153eca65U,
    0x5744e7e6U,
    0x76bec800U,
    0xce84e400U,
    0x8e5eca00U,
    0x6b34e700U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0x18000000U,
    0xec000000U,
    0xf2000000U,
    0xa1000000U,
    0x8e800000U,
    0xcbc00000U,
    0xdd200000U,
    0xe7900000U,
    0x2a080000U,
    0xed040000U,
    0xec8e0000U,
    0x2c70000U,
    0xa7a18000U,
    0x325ec000U,
    0xa4272000U,
    0x251e1000U,
    0x83cee800U,
    0xf92fbc00U,
    0x71925200U,
    0xfd0fb900U,
    0xc4880080U,
    0x16c40040U,
    0xc9ae00e0U,
    0x79570070U,
    0x67a98018U,
    0x925ac0ecU,
    0x342920f2U,
    0x4d1910a1U,
    0x77cf688eU,
    0xe7217ccbU,
    0x229d72ddU,
    0xd285a9e7U,
    0x81c0e8aaU,
    0x28bcadU,
    0xf313d20cU,
    0xb4c17972U,
    0xa0a7203fU,
    0x93de109eU,
    0xda6ee8b6U,
    0xe87fbcf4U,
    0xe23a5215U,
    0x715bb9deU,
    0xa3ae00deU,
    0x745700fbU,
    0xfb298080U,
    0x889ac040U,
    0x7f8920e0U,
    0x8d491070U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x18000000U,
    0xbc000000U,
    0xce000000U,
    0xab000000U,
    0xbe800000U,
    0x98400000U,
    0x17200000U,
    0x17500000U,
    0xe2080000U,
    0xbd0c0000U,
    0x89820000U,
    0xf8c10000U,
    0x3c618000U,
    0x2fbc000U,
    0xa314e000U,
    0xe32eb000U,
    0x9d55e800U,
    0xb028400U,
    0x6e8df200U,
    0xa0493500U,
    0xbb280080U,
    0xc15c00c0U,
    0xf50a0020U,
    0xcd8d0010U,
    0xbac38018U,
    0x516ac0bcU,
    0xb37d60ceU,
    0xf7d970abU,
    0x94308beU,
    0x88ad3498U,
    0xd8999a17U,
    0xbee07117U,
    0x94b91262U,
    0x3f37857dU,
    0x5af5e829U,
    0xff128428U,
    0x1d25f204U,
    0x3e5535aeU,
    0x118200f5U,
    0x84c10034U,
    0xd26180cdU,
    0xb9fbc028U,
    0x594e0dfU,
    0xc76eb093U,
    0x4475e880U,
    0xb75284c0U,
    0x3205f220U,
    0x85053510U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0xb8000000U,
    0x84000000U,
    0xd6000000U,
    0x83000000U,
    0xdc800000U,
    0x6f400000U,
    0x56200000U,
    0x80b00000U,
    0x5a080000U,
    0xc90c0000U,
    0x9d860000U,
    0xaecf0000U,
    0x5aeb8000U,
    0x37584000U,
    0xb6d56000U,
    0x1a1c3000U,
    0x3dffc800U,
    0x992bf400U,
    0x763be200U,
    0x844acb00U,
    0xe6a80080U,
    0x95fc00c0U,
    0x952e0060U,
    0xfc3300f0U,
    0xa54580b8U,
    0xd72b4084U,
    0x2130e0d6U,
    0xa6c77083U,
    0xc6e728dcU,
    0xf550846fU,
    0xabd2ca56U,
    0x79994f80U,
    0xdc374adaU,
    0xf5420f09U,
    0xff2faa7dU,
    0xed397f9eU,
    0x4cc68202U,
    0x17eafb83U,
    0x7cd9c838U,
    0x9b14f42dU,
    0x9c7862efU,
    0x65ee8b01U,
    0x79d36012U,
    0xec9330acU,
    0xe3b44880U,
    0xb683b4c0U,
    0x7e468260U,
    0xbfaafbf0U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x38000000U,
    0xd4000000U,
    0xca000000U,
    0xa7000000U,
    0xd9800000U,
    0xc8c00000U,
    0x9ce00000U,
    0xec500000U,
    0x76080000U,
    0xf10c0000U,
    0x38860000U,
    0x184b0000U,
    0xd8a38000U,
    0x12fd4000U,
    0xddf4a000U,
    0x987e7000U,
    0x16bf9800U,
    0x83558c00U,
    0xe3834e00U,
    0xf7c10500U,
    0x41680080U,
    0x669c00c0U,
    0xa1ee0060U,
    0xdad700b0U,
    0xeb4d8038U,
    0xb2a40d4U,
    0x1d3920caU,
    0x289430a7U,
    0x84e6b8d9U,
    0x2851bcc8U,
    0x540df69cU,
    0xa0cb9ecU,
    0xc70bf6f6U,
    0x6987b931U,
    0xf0c876d8U,
    0x48eaf968U,
    0x2654d600U,
    0xd10889b6U,
    0x28854ecfU,
    0xf04a059bU,
    0x84ab80ddU,
    0x34f14048U,
    0x64f2a034U,
    0x2cf57010U,
    0xa0fc1880U,
    0xef8ccc0U,
    0x5bffee60U,
    0xf17375b0U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x78000000U,
    0xec000000U,
    0x52000000U,
    0x13000000U,
    0x43800000U,
    0xd0c00000U,
    0x9de00000U,
    0x1f900000U,
    0x5b080000U,
    0x97840000U,
    0xceca0000U,
    0x6ceb0000U,
    0x37178000U,
    0x2446c000U,
    0x88a12000U,
    0x5fbb3000U,
    0x6bf73800U,
    0x2b568c00U,
    0xe0e11e00U,
    0x3511d900U,
    0x5f4a0080U,
    0xef2b0040U,
    0x497780a0U,
    0x5b16c0b0U,
    0x36492078U,
    0x3baf30ecU,
    0xac353852U,
    0xc3398c13U,
    0x5abc9e43U,
    0xad7c19d0U,
    0x7d1ca01dU,
    0x8b46f05fU,
    0xf12998fbU,
    0xb87f7c27U,
    0x739506b6U,
    0x49036580U,
    0x2489a6e5U,
    0x3d459577U,
    0xc4203eebU,
    0x46fae97fU,
    0x69d538aeU,
    0xc0a98c28U,
    0x8bb49e31U,
    0x75f819edU,
    0xda56a078U,
    0xc86df0ecU,
    0x4a5e1852U,
    0x4069bc13U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0xa8000000U,
    0xc4000000U,
    0x2e000000U,
    0xdb000000U,
    0x3f800000U,
    0xf0400000U,
    0x85200000U,
    0x18100000U,
    0xdd080000U,
    0x60840000U,
    0x1ce0000U,
    0x1e6b0000U,
    0xaba8000U,
    0xf1544000U,
    0x16aee000U,
    0xa257b000U,
    0xfd2ef800U,
    0x841a8400U,
    0x7f089200U,
    0xe1802100U,
    0x63460080U,
    0xceaf0040U,
    0x6e5480e0U,
    0x472f40b0U,
    0x691c60a8U,
    0xf787f0c4U,
    0xc44e182eU,
    0xe32634dbU,
    0xb71cea3fU,
    0x648ee5f0U,
    0x8fc07205U,
    0x95689158U,
    0x2d3478bdU,
    0x6d1ec490U,
    0x798e7249U,
    0x4f43916aU,
    0xc4aef80cU,
    0x2b5a84aeU,
    0xba892e7U,
    0x62d02139U,
    0xacee006fU,
    0x827b00e8U,
    0x19b280e9U,
    0xfad040f2U,
    0x80e0e028U,
    0x887cb084U,
    0x5cb478ceU,
    0xb65ec46bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0x38000000U,
    0xbc000000U,
    0xea000000U,
    0xd9000000U,
    0x16800000U,
    0xb6c00000U,
    0xcce00000U,
    0x2dd00000U,
    0x3f080000U,
    0x7d8c0000U,
    0x954a0000U,
    0x4eaf0000U,
    0xaf38000U,
    0x9eb3c000U,
    0xea9aa000U,
    0xd4a39000U,
    0x2bf86800U,
    0x9435ec00U,
    0x465f8e00U,
    0xf94a3d00U,
    0xaca20080U,
    0xf7f300c0U,
    0x2e3180a0U,
    0x5750c0f0U,
    0x6bc32038U,
    0x4c6f50bcU,
    0x81948eaU,
    0xcc69bcd9U,
    0xc8174616U,
    0x6c6341b6U,
    0x381e664cU,
    0x546311edU,
    0x8414ae1fU,
    0xbe696d4dU,
    0x5d11488dU,
    0xa8e5bcc2U,
    0xebdd4678U,
    0x640c410bU,
    0xc60de6aeU,
    0x5b00d1c7U,
    0xbb860e3bU,
    0xce46fde6U,
    0xf52320bbU,
    0xc4bf5093U,
    0x6b9148b8U,
    0x2e25bc7cU,
    0xbf3d464aU,
    0x5dc4129U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0xd8000000U,
    0xe4000000U,
    0xb6000000U,
    0x57000000U,
    0x28800000U,
    0x8c00000U,
    0x9ea00000U,
    0x3ef00000U,
    0x8880000U,
    0x18c40000U,
    0x16ae0000U,
    0xb2fb0000U,
    0x82858000U,
    0x1dca4000U,
    0xdf256000U,
    0xc5be7000U,
    0x3c670800U,
    0xb55acc00U,
    0x77f48a00U,
    0xeb019f00U,
    0x3a858080U,
    0x9ca4040U,
    0x512560e0U,
    0xc6be70b0U,
    0x7ae708d8U,
    0xe9acce4U,
    0x77d48ab6U,
    0x8a319f57U,
    0x842d80a8U,
    0x273e4048U,
    0xd1a3607eU,
    0x5271708eU,
    0xe64488d0U,
    0xb96f8cfcU,
    0x3cda6aa0U,
    0xe0beafe5U,
    0xe5ea682aU,
    0x4a10bc55U,
    0x451582a1U,
    0xc994534bU,
    0x97528a6cU,
    0xeefe9f09U,
    0x208e00b7U,
    0xc4cb00feU,
    0xf4ad80a8U,
    0x8bfe4048U,
    0x1903607eU,
    0x8b81708eU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x78000000U,
    0x94000000U,
    0x6a000000U,
    0xdb000000U,
    0x60800000U,
    0xea400000U,
    0xed600000U,
    0xe9500000U,
    0x8880000U,
    0x96440000U,
    0xbb660000U,
    0x45b0000U,
    0x350f8000U,
    0x398d4000U,
    0x6dc0a000U,
    0x51a6b000U,
    0xb3718800U,
    0x493fe400U,
    0x4c547600U,
    0x99092500U,
    0xa78f8080U,
    0x6ccd4040U,
    0x9220a060U,
    0xadb6b0b0U,
    0x24198878U,
    0x936be494U,
    0x185a766aU,
    0xd30625dbU,
    0xac8e00e0U,
    0xc44f00aaU,
    0x9461808dU,
    0xbed24059U,
    0x7c492070U,
    0x2060f002U,
    0x4d6a8d1U,
    0x6f4014dfU,
    0xaceb5e55U,
    0x109f71d3U,
    0x332bfe00U,
    0xfe39c1f8U,
    0x92da765bU,
    0xa246252fU,
    0x416e006fU,
    0x775f00f9U,
    0x98980e0U,
    0x55c640aaU,
    0xa5a7208dU,
    0x697ff059U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0x68000000U,
    0x2c000000U,
    0x36000000U,
    0x13000000U,
    0x63800000U,
    0x62400000U,
    0x78a00000U,
    0x89300000U,
    0xf880000U,
    0x344c0000U,
    0xfbaa0000U,
    0xb2b30000U,
    0x29ce8000U,
    0x56eec000U,
    0x57996000U,
    0xcdba3000U,
    0x1c44b800U,
    0xb7a2e400U,
    0x14bdea00U,
    0x62c42300U,
    0x716e8080U,
    0x2fdec0c0U,
    0x901160a0U,
    0xe5f63030U,
    0xb9eeb868U,
    0x3a11e42cU,
    0x68f36a36U,
    0x456ae313U,
    0x3dd7e0e3U,
    0x914f0a2U,
    0xfb7dd8d8U,
    0xef28d4b9U,
    0x59715267U,
    0xde2ac718U,
    0xcbf96a4dU,
    0x8ee9e361U,
    0xd391606aU,
    0x77b630c4U,
    0x94eb8e7U,
    0xaf21e458U,
    0x397b6a4dU,
    0x4e26e3bcU,
    0x93fde03aU,
    0xcae7f061U,
    0xc99358e3U,
    0x52b614a2U,
    0x79c032d8U,
    0xaeecf7b9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x28000000U,
    0x4000000U,
    0x4a000000U,
    0xad000000U,
    0xce800000U,
    0xffc00000U,
    0x45200000U,
    0x19900000U,
    0x92880000U,
    0x79cc0000U,
    0xb6220000U,
    0x28130000U,
    0x22ca8000U,
    0x43ac4000U,
    0xf256a000U,
    0x85a1d000U,
    0xe1526800U,
    0xa425bc00U,
    0x491ff200U,
    0xb243c900U,
    0x436a8080U,
    0xf8fc40c0U,
    0xe37ea020U,
    0x2e3dd030U,
    0xe2d86828U,
    0x456abc04U,
    0xcbff724aU,
    0xf2f089adU,
    0xae74a04eU,
    0xf0b2d03fU,
    0x518e865U,
    0x2c49fc29U,
    0x9c6952baU,
    0x8772197dU,
    0xb430e87cU,
    0x77d5fc45U,
    0x97e352ccU,
    0x523d198cU,
    0x54d0681fU,
    0x9e66bc58U,
    0xfe7d7219U,
    0x8b38940U,
    0x39162099U,
    0x7a4290a1U,
    0x5764484eU,
    0xaaf72c3fU,
    0x6273ba65U,
    0xaeb8e529U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0x78000000U,
    0x74000000U,
    0xf6000000U,
    0x5f000000U,
    0x7f800000U,
    0x5d400000U,
    0xe0e00000U,
    0xf0100000U,
    0x99880000U,
    0xea4c0000U,
    0xc3620000U,
    0x27570000U,
    0xdc6f8000U,
    0xb8db4000U,
    0xd1256000U,
    0x503ef000U,
    0x2d3a7800U,
    0x4bb19400U,
    0x6e70ee00U,
    0xa85cb100U,
    0x6be78080U,
    0xc99740c0U,
    0xc3c76020U,
    0x7129f070U,
    0xe035f878U,
    0x753ad474U,
    0x4fbd8ef6U,
    0xe07e415fU,
    0x8357f8ffU,
    0xe26dd49dU,
    0xcbd20ec0U,
    0x5ca50180U,
    0xdc729861U,
    0x9953245eU,
    0x6f687615U,
    0x15549508U,
    0x2d62765bU,
    0x9c5f9551U,
    0x7de7f667U,
    0xc69fd54fU,
    0xb44f1613U,
    0x206d6538U,
    0x82df8e63U,
    0x2c2941e4U,
    0xf6b8787fU,
    0x28f6945dU,
    0xfd976ee0U,
    0xd5cbf1f0U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0xa8000000U,
    0xe4000000U,
    0x66000000U,
    0x11000000U,
    0xff800000U,
    0x30c00000U,
    0x90a00000U,
    0x72700000U,
    0xd1880000U,
    0x75cc0000U,
    0xd12a0000U,
    0xcfbd0000U,
    0x94a28000U,
    0xa4724000U,
    0x18846000U,
    0x16401000U,
    0xcbef7800U,
    0xcc104c00U,
    0x6e5dea00U,
    0xabbc7700U,
    0x32aa8080U,
    0x157e40c0U,
    0x370e60a0U,
    0x8e8d10d0U,
    0xbf45f8a8U,
    0xd86e0ce4U,
    0xaed38a66U,
    0x21f16711U,
    0xd34f787fU,
    0x4a604cf0U,
    0xd1d5ea30U,
    0xfb7077a2U,
    0xd20080f9U,
    0x1f034051U,
    0xaa8ce017U,
    0x794f500eU,
    0x196998c3U,
    0xf9521c70U,
    0xf53ef2eeU,
    0x25e02b75U,
    0x29121265U,
    0xffdf7b49U,
    0xbe738a0fU,
    0x93816706U,
    0xa2c778ffU,
    0xefac4c30U,
    0xa8ffea90U,
    0xd0cd7772U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xe8000000U,
    0x4c000000U,
    0xe000000U,
    0x49000000U,
    0x93800000U,
    0x81c00000U,
    0x49600000U,
    0xdc300000U,
    0x51880000U,
    0x86c40000U,
    0xb3e20000U,
    0x3e7f0000U,
    0x71268000U,
    0x5f90c000U,
    0x305ae000U,
    0xa0379000U,
    0xd789b800U,
    0x53c5dc00U,
    0x3667f600U,
    0x52bc1300U,
    0xe9ce8080U,
    0x4564c040U,
    0xf230e020U,
    0xe88c90f0U,
    0xfd4d38e8U,
    0x7e2a1c4cU,
    0x791b960eU,
    0xe41b4349U,
    0x9d9dd813U,
    0x37568cc1U,
    0x5abeae69U,
    0x35c55f2cU,
    0x736c4e39U,
    0xef36cf8aU,
    0xd107f61dU,
    0x778c13c7U,
    0xe3c680aaU,
    0xfe60c022U,
    0xeeb2e0bfU,
    0xfc39089U,
    0x4063b8f3U,
    0x6fbedc51U,
    0x20437651U,
    0x27a3d378U,
    0x23dae093U,
    0x61f79081U,
    0xbee9b849U,
    0x7ff5dcdcU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0x68000000U,
    0x8c000000U,
    0xe6000000U,
    0xbf000000U,
    0x3d800000U,
    0x85c00000U,
    0x59a00000U,
    0x67d00000U,
    0x47880000U,
    0x54c40000U,
    0x272a0000U,
    0x819d0000U,
    0xc0ee8000U,
    0x3d3cc000U,
    0xdbbc6000U,
    0x49faf000U,
    0x6c935800U,
    0x6b9c00U,
    0xf07e7a00U,
    0xb35ccd00U,
    0x18c68080U,
    0x2128c040U,
    0x4e9e60a0U,
    0x4563f0d0U,
    0x5cf7d868U,
    0xe81a5c8cU,
    0x77249ae6U,
    0xa99efdbfU,
    0xece3b8bdU,
    0xb34acc5U,
    0xcb5c2f9U,
    0xf87c61b7U,
    0xf5142afU,
    0xe6cda198U,
    0xaa2ba2e1U,
    0x711f91aeU,
    0x15a69ab5U,
    0x61d7fda4U,
    0x888f382cU,
    0xd1416c8dU,
    0x46e52238U,
    0xb2335132U,
    0xfe32fabdU,
    0xf8390da3U,
    0x373e603dU,
    0xb2b3f085U,
    0xd37fd859U,
    0xe0de5c67U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xb8000000U,
    0x54000000U,
    0x5e000000U,
    0xfb000000U,
    0xbd800000U,
    0xe6400000U,
    0x8be00000U,
    0x12900000U,
    0xa6880000U,
    0xcbcc0000U,
    0xb5a60000U,
    0x9d750000U,
    0x52138000U,
    0xc2414000U,
    0x9defe000U,
    0x359cb000U,
    0xf90d5800U,
    0x648ca400U,
    0x72ce1e00U,
    0x712e7900U,
    0xdfb58080U,
    0xcb3440c0U,
    0xf1fc6060U,
    0x5cddf050U,
    0x6162b8b8U,
    0xe3501454U,
    0x5e23465eU,
    0xfc32ddfbU,
    0xb6739e3dU,
    0x97963926U,
    0x100fe06bU,
    0x180cb082U,
    0x6405587eU,
    0xb600a4cfU,
    0x17081e53U,
    0xb78b7932U,
    0x434e0031U,
    0xcd69001fU,
    0x495d80cbU,
    0xcb284091U,
    0x52b2606cU,
    0x1b4f0e9U,
    0xf03f383fU,
    0x2c7854dcU,
    0xea912685U,
    0x52862d72U,
    0xa5cca635U,
    0xa6ae6d79U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0xe8000000U,
    0xd4000000U,
    0xf2000000U,
    0xc9000000U,
    0x43800000U,
    0x30400000U,
    0x41600000U,
    0xb7f00000U,
    0xf6880000U,
    0xf5cc0000U,
    0xba260000U,
    0x4190000U,
    0xeb68000U,
    0x54694000U,
    0x82752000U,
    0x75cb9000U,
    0x7a2fb800U,
    0x6416c400U,
    0x9eb77600U,
    0xbc624f00U,
    0x56708080U,
    0x87c040c0U,
    0xb32ba060U,
    0x279ed090U,
    0xaef498e8U,
    0xfd0854d4U,
    0xe1884ef2U,
    0x7144cbc9U,
    0x46e456c3U,
    0x9db0dff0U,
    0xaae9b8a1U,
    0xf3bfc4e7U,
    0xb5e9f67eU,
    0xf3370fb1U,
    0x332ba020U,
    0xe79ed0d9U,
    0xcef498dfU,
    0x6d08543dU,
    0x9884e68U,
    0xa544cb26U,
    0xb4e456bfU,
    0x54b0df2fU,
    0xe969b871U,
    0xc3ffc42dU,
    0xf489f62bU,
    0x44c70f24U,
    0xc5a3a053U,
    0x1252d02eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0xe8000000U,
    0xb4000000U,
    0xfa000000U,
    0x9000000U,
    0x31800000U,
    0xd8c00000U,
    0x35200000U,
    0x25900000U,
    0xda880000U,
    0xfc440000U,
    0xb2620000U,
    0x4b770000U,
    0x1ab68000U,
    0x5e174000U,
    0x8341a000U,
    0x1ce19000U,
    0x2d389800U,
    0xf1d74c00U,
    0xbce53200U,
    0x1d302900U,
    0x39dc8080U,
    0x78e44040U,
    0xf352020U,
    0x84d1d070U,
    0xb367b8e8U,
    0xdef59cb4U,
    0x80760afaU,
    0x4e35f509U,
    0x3155aab1U,
    0x59a36598U,
    0x26dbb295U,
    0x86636915U,
    0xf17f2092U,
    0x33b2d078U,
    0x1f9b3880U,
    0xb381dc86U,
    0x9dcb2a39U,
    0xf2a0253bU,
    0x225012fdU,
    0x7121f9a8U,
    0x779b3853U,
    0x4781dcc0U,
    0x47cb2a29U,
    0x8ba0254bU,
    0xfbd012d9U,
    0x1de1f96cU,
    0xb8bb384fU,
    0x6b11dc6cU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x68000000U,
    0x3c000000U,
    0x86000000U,
    0xb5000000U,
    0x36800000U,
    0x49400000U,
    0xa3200000U,
    0xc0700000U,
    0x9d880000U,
    0xeecc0000U,
    0xbee20000U,
    0xdd190000U,
    0xaf5e8000U,
    0xc3f7c000U,
    0x224e6000U,
    0x24ac5000U,
    0x4dbee800U,
    0xe8e0d400U,
    0xe01b1200U,
    0x15d6f700U,
    0xf4b48080U,
    0x6062c0c0U,
    0x6852e020U,
    0xaa729090U,
    0x26860868U,
    0xe147443cU,
    0xbf219a86U,
    0xd67f73b5U,
    0x4085fab6U,
    0xe4462389U,
    0x71a79203U,
    0xcb383790U,
    0x59a46055U,
    0x17395082U,
    0x6fa26870U,
    0x5a3e14c4U,
    0xd23f277U,
    0xa9716703U,
    0x9d0e08b1U,
    0xea8b44d8U,
    0x7f439a65U,
    0xee26731fU,
    0xa2fb7a88U,
    0x6ec1e31aU,
    0x7ee1f25eU,
    0xfd186775U,
    0x3f5888a5U,
    0xabf084b5U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x28000000U,
    0x8c000000U,
    0x1e000000U,
    0xd1000000U,
    0x98800000U,
    0x15c00000U,
    0x5fe00000U,
    0xaeb00000U,
    0x65c80000U,
    0x27ec0000U,
    0x6ab60000U,
    0x67c10000U,
    0xc0ee8000U,
    0xaf3ec000U,
    0xf480e000U,
    0x5bc39000U,
    0xc6e74800U,
    0x2a39bc00U,
    0x46026e00U,
    0x2507a300U,
    0x4280e080U,
    0xc6c390c0U,
    0x20674860U,
    0x7ef9bc90U,
    0xa9626e28U,
    0x1277a38cU,
    0x66a8e09eU,
    0x9e9f9011U,
    0xb79948f8U,
    0x2b14bc85U,
    0x5cdaee77U,
    0x74386322U,
    0x370e80fbU,
    0x4d8ec036U,
    0xef48e092U,
    0x3d2f90e2U,
    0x1cd148b7U,
    0xd438bc8dU,
    0xc70cee8fU,
    0xf58963adU,
    0x4b4800b4U,
    0xaf2c0098U,
    0xd3d600b9U,
    0x9db100b4U,
    0x4a4680fbU,
    0xbfa2c036U,
    0xba1ee092U,
    0x645e90e2U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0xd8000000U,
    0xe4000000U,
    0xe2000000U,
    0x7b000000U,
    0x59800000U,
    0xa0c00000U,
    0x12a00000U,
    0x20b00000U,
    0xbcc80000U,
    0x4ac0000U,
    0xb1b60000U,
    0x12430000U,
    0x23e18000U,
    0x7ed84000U,
    0xe0dd2000U,
    0x3dde3000U,
    0x2d59d800U,
    0xc71d2c00U,
    0x10f21a00U,
    0x842d5300U,
    0x93fd2080U,
    0x29ae30c0U,
    0xd931d860U,
    0xcc012cb0U,
    0x7e0c1ad8U,
    0xad0253e4U,
    0xa88aa062U,
    0xbe4570bbU,
    0xede57839U,
    0xbdb5c10U,
    0xac56e2caU,
    0x619e4fc4U,
    0xbbbee2deU,
    0x95424fbfU,
    0x1c60e208U,
    0xf71d4fc2U,
    0x8ff6209U,
    0x2a0fcaU,
    0xc1f5c286U,
    0x8aaf7fd6U,
    0x64b0ba1fU,
    0x8ec4239aU,
    0x17ae58a2U,
    0xd4366c95U,
    0xb486badeU,
    0xa84723bfU,
    0x7cefd808U,
    0xa55e2cc2U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x58000000U,
    0x44000000U,
    0x86000000U,
    0xdf000000U,
    0x1f800000U,
    0xa4400000U,
    0x29e00000U,
    0xced00000U,
    0xa8480000U,
    0x3e40000U,
    0xebd60000U,
    0x5ac70000U,
    0xb9218000U,
    0xe2f24000U,
    0x803f6000U,
    0x8d147000U,
    0xb1efb800U,
    0xaadf2400U,
    0xbe4bee00U,
    0x74e7d500U,
    0xe85f6080U,
    0x3c847040U,
    0xc9c7b860U,
    0xecab24f0U,
    0x93b5ee58U,
    0x354d544U,
    0xbd00e006U,
    0x9685309fU,
    0xacc7587fU,
    0x7e2e1454U,
    0xd972b671U,
    0x527ac18aU,
    0x23f256aeU,
    0x24bff19cU,
    0x20d50e14U,
    0x4b41e54eU,
    0x4e6fb828U,
    0xbe9f24d8U,
    0xafabee96U,
    0xe37d5e5U,
    0x9e17601bU,
    0xa460708fU,
    0xbb91b8d7U,
    0xcd2c24d3U,
    0x1cf46eaeU,
    0x8b36959cU,
    0xbc978014U,
    0xd6a5404eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0xc8000000U,
    0x74000000U,
    0xda000000U,
    0x9f000000U,
    0x13800000U,
    0x80400000U,
    0x47600000U,
    0x6e100000U,
    0xce480000U,
    0xf2640000U,
    0x9a920000U,
    0x71810000U,
    0x53488000U,
    0x82e54000U,
    0x8754a000U,
    0x63ad7000U,
    0x3eb27800U,
    0xc57fa400U,
    0xa6588600U,
    0xbd255900U,
    0x667ca080U,
    0x5bd97040U,
    0x58687820U,
    0x3d9aa490U,
    0x6e0206c8U,
    0x25011974U,
    0x3c80805aU,
    0xcbc140dfU,
    0x7b26a033U,
    0x877c7010U,
    0xe552f88fU,
    0xb0aee41aU,
    0xfb362614U,
    0x2c3d296dU,
    0xbbc5809U,
    0x71f694b1U,
    0x3996de34U,
    0x8c02cd7cU,
    0xb60afe01U,
    0xd90afda5U,
    0xb28c26deU,
    0x1ec829fbU,
    0x3faed88eU,
    0x60b6d41bU,
    0xf878fe94U,
    0x6dbfd2dU,
    0x48eca629U,
    0x90596921U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x28000000U,
    0xfc000000U,
    0x96000000U,
    0x13000000U,
    0xe3800000U,
    0x96400000U,
    0xf600000U,
    0x2b300000U,
    0x14480000U,
    0x56640000U,
    0x3db60000U,
    0x4a890000U,
    0xf8c68000U,
    0xe5a9c000U,
    0xff986000U,
    0x615bb000U,
    0xeffdf800U,
    0x47ea0400U,
    0xcaf2c600U,
    0x87610b00U,
    0xe7306080U,
    0xda4fb040U,
    0x8163f860U,
    0x9c370410U,
    0xa5ca4628U,
    0x9125cbfcU,
    0xa8588016U,
    0x9174c053U,
    0x8520e083U,
    0xe25f7086U,
    0x64751827U,
    0x4da174d7U,
    0x4399de82U,
    0x975d7f45U,
    0xecf13e5eU,
    0x8c660f9cU,
    0xa0b22617U,
    0x1e0e7b9eU,
    0xdf0d7823U,
    0x2d8ac49bU,
    0x414c260cU,
    0xaee37bf2U,
    0xc47df8efU,
    0x7daa045bU,
    0x1b92c602U,
    0x53510b05U,
    0xaef8603eU,
    0xf56bb08cU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0xa8000000U,
    0x14000000U,
    0x5a000000U,
    0xa9000000U,
    0xbc800000U,
    0x80400000U,
    0xf3e00000U,
    0xa0500000U,
    0xb6480000U,
    0xece40000U,
    0x43d20000U,
    0xf58b0000U,
    0x6cce8000U,
    0xcba34000U,
    0xdfb6a000U,
    0xf0181000U,
    0xbda68800U,
    0xe0bba400U,
    0x239cae00U,
    0x56644d00U,
    0x749ea080U,
    0xf1ec1040U,
    0xd55c8820U,
    0x54c4a430U,
    0x7a82ea8U,
    0x19b80d14U,
    0x271c80daU,
    0x5a2840e9U,
    0x6178209cU,
    0xb6bb50b0U,
    0x2c90285bU,
    0x2de3b4b4U,
    0x8b5a26ecU,
    0x3fcfe945U,
    0xae2a0e7fU,
    0x6b7c5d35U,
    0xa7b8283fU,
    0x1c17b41bU,
    0x4ba026e1U,
    0x9fb0e938U,
    0xd01e8e8cU,
    0x8da01de8U,
    0x48ba0809U,
    0x3793e4c4U,
    0xc648e6cU,
    0xdd9f1d05U,
    0x4d6e885fU,
    0x551fa405U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x18000000U,
    0x84000000U,
    0xee000000U,
    0x45000000U,
    0x7e800000U,
    0xe2c00000U,
    0x64a00000U,
    0x5a900000U,
    0xbc80000U,
    0x28240000U,
    0xf7560000U,
    0xae30000U,
    0xb3f58000U,
    0x80764000U,
    0x1039e000U,
    0x345fd000U,
    0x8d6ea800U,
    0x95b84c00U,
    0x51eda00U,
    0x89826100U,
    0x934fe080U,
    0x83ecd040U,
    0x4f732860U,
    0x35ba0cb0U,
    0x95193a18U,
    0x418ab184U,
    0xbf4ac86eU,
    0xf1e5dc05U,
    0x6077921eU,
    0xe032fd52U,
    0x4c5412fcU,
    0xb967bd9eU,
    0x63b87205U,
    0xc41e2d9dU,
    0x19073a71U,
    0x348db19cU,
    0x99c948c1U,
    0xf7209cebU,
    0x5ad3f2f3U,
    0xe7af6d8fU,
    0xbd1d5a16U,
    0x9d8721a6U,
    0xb54b80a9U,
    0xeae1402cU,
    0x43f2601dU,
    0xf87e9019U,
    0x243cc81fU,
    0xc256dc99U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0xf8000000U,
    0x3c000000U,
    0x22000000U,
    0x7000000U,
    0xf9800000U,
    0xf400000U,
    0x55e00000U,
    0x74b00000U,
    0xaa480000U,
    0xeb640000U,
    0x227a0000U,
    0x20e50000U,
    0x323b8000U,
    0xc081c000U,
    0x43cb2000U,
    0xfc25f000U,
    0x3b915800U,
    0x5e555400U,
    0x5b7aee00U,
    0xcc6cf300U,
    0x4bf92080U,
    0x77a4f040U,
    0x8bd0d8a0U,
    0x6e3194d0U,
    0xd28a4ef8U,
    0xccc8c33cU,
    0x11a358a2U,
    0xd2d45447U,
    0x12bb6e59U,
    0xf34833dfU,
    0x97e9802dU,
    0x3b0c008U,
    0x7bc2a028U,
    0x2025303cU,
    0x699bf823U,
    0x71546413U,
    0x66fb1645U,
    0xdd2d97b3U,
    0x3b11b690U,
    0xfd9ca758U,
    0xd7584e6cU,
    0xdff9c39aU,
    0xd1aad81bU,
    0x32d4944bU,
    0x62b1ce50U,
    0xdb490340U,
    0x53e87821U,
    0x1db1a484U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x88000000U,
    0x84000000U,
    0x92000000U,
    0x4d000000U,
    0x95800000U,
    0x3cc00000U,
    0x50200000U,
    0x92900000U,
    0x13c80000U,
    0x20ac0000U,
    0xefde0000U,
    0xd5230000U,
    0xa3148000U,
    0xed0e4000U,
    0x58e2000U,
    0xe4c25000U,
    0xec2a1800U,
    0xc926c00U,
    0x48c19200U,
    0x6a255100U,
    0xb982080U,
    0x2c4d50c0U,
    0x5d6098e0U,
    0x3c7f2cb0U,
    0xa47b3288U,
    0x38794184U,
    0xf6741812U,
    0x95716c8dU,
    0xd3f51275U,
    0x21bb118cU,
    0x7de0058U,
    0x212300d6U,
    0x59148061U,
    0x940e40ddU,
    0x8a0e20f2U,
    0x1102506dU,
    0xbb8a1861U,
    0xefc26c32U,
    0x9ea99283U,
    0xe4d951f8U,
    0xa7ae20d3U,
    0x4b52508bU,
    0x2621818U,
    0x24fe6c17U,
    0xed3f9269U,
    0xe4965199U,
    0xbcc4a000U,
    0x902f1050U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x48000000U,
    0x8c000000U,
    0x3e000000U,
    0xeb000000U,
    0xb3800000U,
    0xa1c00000U,
    0x2f600000U,
    0x48900000U,
    0x82480000U,
    0xd6a40000U,
    0xf3fe0000U,
    0x80d30000U,
    0x45e88000U,
    0xcfd2c000U,
    0xb46ee000U,
    0x13153000U,
    0xff817800U,
    0x3fce3c00U,
    0x94652600U,
    0x312c100U,
    0xe7866080U,
    0x4bc7f040U,
    0x6e6f98e0U,
    0x5a1b0cb0U,
    0x81045e48U,
    0xb28cfd8cU,
    0x534b46beU,
    0x9c2131abU,
    0x64bff8d3U,
    0xaefbfc51U,
    0xf4554687U,
    0x39a23174U,
    0x527f7874U,
    0xa41d3cf1U,
    0xca0da69eU,
    0x5100017aU,
    0xa888011U,
    0x7742c0eaU,
    0x9e26e0c7U,
    0xf9b130d6U,
    0x7a7f7875U,
    0xd81d3c44U,
    0x5c0da633U,
    0x860001efU,
    0xcf0880a7U,
    0xb182c0a0U,
    0x3cc6e019U,
    0xfbe1300eU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0xf8000000U,
    0x64000000U,
    0xa000000U,
    0x43000000U,
    0x10800000U,
    0xb400000U,
    0x36a00000U,
    0xfe300000U,
    0xf3c80000U,
    0x91ec0000U,
    0x3e960000U,
    0xd0f70000U,
    0xc3ab8000U,
    0x93bc4000U,
    0xc901a000U,
    0x9388b000U,
    0x7bcec800U,
    0xcde95400U,
    0x30987a00U,
    0x69f49b00U,
    0x682a2080U,
    0xec74f0c0U,
    0xfeef6860U,
    0x1811e4f0U,
    0x66beb2f8U,
    0xa481cf64U,
    0xa94c5a8aU,
    0x79ab6b83U,
    0x88b0c8f0U,
    0x2d82543bU,
    0x9acdfaaeU,
    0x9263db6aU,
    0x4d5e0081U,
    0x811b0076U,
    0x9d3d8044U,
    0xb34b4068U,
    0xf2aa201dU,
    0x6434f002U,
    0xb8cf6806U,
    0x1d61e4bfU,
    0x5bd6b2a6U,
    0xaf5dcf87U,
    0x6e125a7bU,
    0x7bb06b14U,
    0x650d4871U,
    0x6589144dU,
    0xa6c7daeaU,
    0x6c672b02U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x38000000U,
    0x44000000U,
    0x4a000000U,
    0x57000000U,
    0xa6800000U,
    0x3f400000U,
    0xbda00000U,
    0xb6900000U,
    0x5dc80000U,
    0x88e40000U,
    0x3c360000U,
    0xfdd30000U,
    0xd26f8000U,
    0x4d764000U,
    0x3d71a000U,
    0x2571f000U,
    0xb177a800U,
    0x73721400U,
    0x58788a00U,
    0xf0f2b100U,
    0xd2be2080U,
    0x9e97b040U,
    0xb1ce0860U,
    0x6ee7e4b0U,
    0xed392238U,
    0x3a53a544U,
    0x12a92acaU,
    0x74134117U,
    0xf8818846U,
    0xea41a4cfU,
    0x502082e5U,
    0x91565542U,
    0xfa2082afU,
    0x365655dbU,
    0x4a08230U,
    0xfd165565U,
    0xcb008211U,
    0x58865570U,
    0x7a48824fU,
    0xb82255f8U,
    0x5d5e82e4U,
    0xcc2155daU,
    0x6f59023fU,
    0xbf23152aU,
    0x33d6a2e9U,
    0xef65e514U,
    0x6cf88ad5U,
    0x2cb2b127U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x38000000U,
    0x3c000000U,
    0xd6000000U,
    0xbd000000U,
    0x4c800000U,
    0xc0400000U,
    0xbe200000U,
    0xd6300000U,
    0xf8c80000U,
    0xec640000U,
    0xdf1e0000U,
    0xf9770000U,
    0x1d6f8000U,
    0x3d99c000U,
    0x58346000U,
    0xc9cb5000U,
    0xaeee8800U,
    0x6e53a400U,
    0xe5d9d200U,
    0x8a1e3b00U,
    0xe1fbe080U,
    0x1f229040U,
    0x1cb2e8e0U,
    0xad8cf4f0U,
    0xeac15a38U,
    0x1b6e9f3cU,
    0xe89bb256U,
    0xb66bfdU,
    0x2b8ce82cU,
    0x7fcbf470U,
    0xa3e6da66U,
    0xfad35f1aU,
    0xe991d296U,
    0xda3a3b2dU,
    0xb6c5e025U,
    0x7d659034U,
    0x8d956837U,
    0x803134e7U,
    0x5cb3af0U,
    0x40e2cf72U,
    0xef52ba93U,
    0x7f580f46U,
    0xf75f5ab5U,
    0x13599fe8U,
    0x95432baU,
    0x5a5fab5dU,
    0x97d08843U,
    0xcd14a42eU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x28000000U,
    0xf4000000U,
    0xe2000000U,
    0x25000000U,
    0x92800000U,
    0x62400000U,
    0xe200000U,
    0x2b00000U,
    0x1cc80000U,
    0xe26c0000U,
    0x679a0000U,
    0x47f50000U,
    0x15668000U,
    0x48194000U,
    0x1b312000U,
    0x9709d000U,
    0x5f82e800U,
    0xa4c04400U,
    0x5e631200U,
    0x1969300U,
    0x78f7a080U,
    0x7ee090c0U,
    0xaedbc8a0U,
    0xb05594d0U,
    0x2c13fa28U,
    0xb13fd7f4U,
    0x36003262U,
    0xd70643e5U,
    0x3f89c8b2U,
    0xd4cc9472U,
    0xa66f7a86U,
    0xdd939726U,
    0x6ef79256U,
    0xb9e6d3f3U,
    0x19520037U,
    0x40990010U,
    0x407c8001U,
    0xbdac400cU,
    0x2877a0c3U,
    0x29a090a6U,
    0xba7bc854U,
    0xf4a59446U,
    0xf4fbfab0U,
    0x80e3d76eU,
    0x3dd232e4U,
    0x35df4381U,
    0xd1d548b1U,
    0xbbd0d436U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xe8000000U,
    0xac000000U,
    0xd6000000U,
    0x1f000000U,
    0x53800000U,
    0x24c00000U,
    0x25a00000U,
    0x3fd00000U,
    0xf1480000U,
    0x46640000U,
    0x2df20000U,
    0x60570000U,
    0xb3828000U,
    0xb4ccc000U,
    0x1da06000U,
    0x8bd07000U,
    0x63497800U,
    0x2361ec00U,
    0xb77cca00U,
    0x8103500U,
    0xe16ae080U,
    0x8a78b040U,
    0xf69b1820U,
    0x3269cf0U,
    0xf99732e8U,
    0x28ad19acU,
    0x495e4a56U,
    0x6f0cf55fU,
    0xfb8280f3U,
    0xa8ccc094U,
    0x3a060edU,
    0xc8d07063U,
    0xec978cfU,
    0xb4a1ecf5U,
    0x175ccaa8U,
    0xc00355bU,
    0x6602e045U,
    0xd70cb0efU,
    0xf8118e9U,
    0x1ac59c02U,
    0x96afb257U,
    0xba52d9a9U,
    0xca8eaa7fU,
    0x30474583U,
    0x36e918bcU,
    0xb4b19c21U,
    0xca35b265U,
    0x6871d9c8U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x18000000U,
    0x4000000U,
    0x46000000U,
    0x5d000000U,
    0x61800000U,
    0x2d400000U,
    0xfd600000U,
    0x5d300000U,
    0x96c80000U,
    0x8f240000U,
    0xfad20000U,
    0xa350000U,
    0xb04d8000U,
    0xfce64000U,
    0x807b6000U,
    0xa3a15000U,
    0xce13d800U,
    0x2e1cf400U,
    0x9e1f6600U,
    0x76199b00U,
    0xba1ee080U,
    0xe0131040U,
    0xff12b820U,
    0x859ca4d0U,
    0x945b3e18U,
    0x25f22f04U,
    0xa8e566c6U,
    0x9e789b1dU,
    0xdaa960c1U,
    0x399450bdU,
    0x465e58c5U,
    0x6fab489U,
    0x406406c8U,
    0x8cb8cbd6U,
    0x538d385dU,
    0xbe4fe43aU,
    0xfdedde0cU,
    0x83f53f5cU,
    0x45edde73U,
    0x17f53f35U,
    0x3bedde44U,
    0x9ef53f66U,
    0x46dde0dU,
    0xeab53f39U,
    0xde8dde89U,
    0xc7c53f2bU,
    0xd4a5deb8U,
    0x38913f63U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x68000000U,
    0x84000000U,
    0x9a000000U,
    0xc7000000U,
    0x4c800000U,
    0x37400000U,
    0xd4600000U,
    0xe5700000U,
    0x64c80000U,
    0x83ac0000U,
    0x78560000U,
    0x38db0000U,
    0xe1928000U,
    0x60fa4000U,
    0xba08a000U,
    0x5703f000U,
    0x748f0800U,
    0xeb471400U,
    0xa2665600U,
    0x3c770f00U,
    0x754c2080U,
    0x3f62b0c0U,
    0xd7f52860U,
    0x3e8ea430U,
    0xb449fe68U,
    0x62efeb84U,
    0x253b7e1aU,
    0x9425ab07U,
    0xd59bdeacU,
    0x52fa5bc7U,
    0x990ad65cU,
    0xb18a4f91U,
    0xecc80076U,
    0xf7ac0030U,
    0xea5600a6U,
    0x4bdb007cU,
    0x5f12808bU,
    0x14ba40f1U,
    0xb8e8a0dcU,
    0x4233f0c1U,
    0x88a708f0U,
    0xbadb1482U,
    0x6a98568bU,
    0x62700f02U,
    0x8840a0b2U,
    0xe4eff073U,
    0xf43908e0U,
    0x31ac14eaU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x38000000U,
    0xc4000000U,
    0xf6000000U,
    0x9b000000U,
    0xf7800000U,
    0xaa400000U,
    0x66600000U,
    0x32900000U,
    0x42c80000U,
    0xadac0000U,
    0x15ba0000U,
    0x9b50000U,
    0x8bb78000U,
    0xaeb24000U,
    0xee3c6000U,
    0xb9f93000U,
    0xdcd3b800U,
    0x12a90400U,
    0xa4347600U,
    0x70fa4100U,
    0x3651e080U,
    0x3c6e70c0U,
    0x639058a0U,
    0xbc4e74d0U,
    0x4d61ae38U,
    0x8d1f75c4U,
    0xc481ae76U,
    0xc1cf755bU,
    0x8e29aed7U,
    0xd1f375baU,
    0xe0dbae7eU,
    0x80aa75e6U,
    0x19362eacU,
    0x247d35e2U,
    0xaf95ce0cU,
    0x64a45ecU,
    0xac6816f4U,
    0x3b937179U,
    0x84a58d3U,
    0x536b74c3U,
    0xea1e2e74U,
    0x10135a1U,
    0x687cea7U,
    0x84c3457dU,
    0xbead9643U,
    0x6e38319cU,
    0x79fbb804U,
    0x7cd50451U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0xd8000000U,
    0xf4000000U,
    0xea000000U,
    0xbd000000U,
    0x5b800000U,
    0xddc00000U,
    0x4d200000U,
    0xfd500000U,
    0xbf480000U,
    0x396c0000U,
    0x84ba0000U,
    0x4eb70000U,
    0xc3b98000U,
    0xe0314000U,
    0x39ffa000U,
    0x46d75000U,
    0xf2867800U,
    0xfc48bc00U,
    0xa5e66200U,
    0x37f2dd00U,
    0x59dc2080U,
    0x680110c0U,
    0x4c0858a0U,
    0x4e02acf0U,
    0x7f05bad8U,
    0xca8a31f4U,
    0x984dba6aU,
    0xc7e6317dU,
    0x56f7ba7bU,
    0xc45131edU,
    0x16ce3ab5U,
    0xda07139U,
    0x88119aadU,
    0xb272140U,
    0x9e5fe2cdU,
    0x13c39deaU,
    0xf22380c7U,
    0x97d640b9U,
    0xd70e2002U,
    0x268a10e6U,
    0x2643d8edU,
    0x60e8ece2U,
    0x68799aa1U,
    0xb61b213dU,
    0x6c2de20eU,
    0xd89d59U,
    0x91800012U,
    0x50c000aeU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0xf8000000U,
    0xec000000U,
    0xfa000000U,
    0xeb000000U,
    0xc2800000U,
    0x5c400000U,
    0x37e00000U,
    0x40f00000U,
    0xd7e80000U,
    0x50f40000U,
    0x7fea0000U,
    0x34f30000U,
    0x91e58000U,
    0xc9fdc000U,
    0x426a2000U,
    0xbc337000U,
    0xeb460800U,
    0x9766b400U,
    0x4bbd7600U,
    0x508ebb00U,
    0xb3460880U,
    0x4b66b440U,
    0x69bd7620U,
    0x278ebb70U,
    0x73c60878U,
    0x1026b4acU,
    0x66dd76daU,
    0xd03ebb9bU,
    0x514e08baU,
    0x5c62b4f0U,
    0xf93f76edU,
    0xf4c9bbdbU,
    0x68a9886dU,
    0xf19874a0U,
    0x555ad692U,
    0xb5f40befU,
    0x506020fcU,
    0x13307069U,
    0xb7cb88d0U,
    0xce2f7453U,
    0x43dd5697U,
    0x9fbecbbeU,
    0x268d803bU,
    0xf249c033U,
    0xeae020fcU,
    0xe3707069U,
    0x5a2b88d0U,
    0x15df7453U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x28000000U,
    0x9c000000U,
    0xe6000000U,
    0x59000000U,
    0x7c800000U,
    0x5e400000U,
    0x35e00000U,
    0xea300000U,
    0x1e80000U,
    0x503c0000U,
    0x1ee20000U,
    0x65bd0000U,
    0x14208000U,
    0x9214c000U,
    0x2dfee000U,
    0x20c95000U,
    0xad2800U,
    0x3052b400U,
    0x4e117600U,
    0xabf19700U,
    0xc9cd2880U,
    0x4422b4c0U,
    0xda1976a0U,
    0x1fd9710U,
    0xfec728a8U,
    0xeda3b45cU,
    0x36dbf646U,
    0xaf545749U,
    0xbb9948d4U,
    0x13e2402U,
    0x2e683e73U,
    0x55ffb3a3U,
    0xf4cd16d5U,
    0xcaa10752U,
    0xb75660edU,
    0xdf919006U,
    0xf339c8e1U,
    0x1d6ae410U,
    0xbe76dec8U,
    0x1306e36aU,
    0x3b883e0fU,
    0x6fcfb335U,
    0x7d251614U,
    0x169d078aU,
    0x67b460e1U,
    0x7f2c9010U,
    0x7d9948c8U,
    0x883e246aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x38000000U,
    0xbc000000U,
    0x76000000U,
    0x9d000000U,
    0x26800000U,
    0x6f400000U,
    0x57600000U,
    0xd6f00000U,
    0x33680000U,
    0x2cf40000U,
    0x906a0000U,
    0x43710000U,
    0x2ba98000U,
    0x2c5ac000U,
    0x67bee000U,
    0x1d0b1000U,
    0x66808800U,
    0x4f43e400U,
    0x766fe00U,
    0xeefa0b00U,
    0x8f608880U,
    0x5af3e440U,
    0xd6efe20U,
    0x65fe0b50U,
    0x44e288b8U,
    0x7b36e4fcU,
    0xb14d7e56U,
    0x2e65cbcdU,
    0x4a7de89eU,
    0xdf233493U,
    0x44111601U,
    0xc5583f1bU,
    0xa3301eadU,
    0x3d451bbfU,
    0x106a0011U,
    0x3710018U,
    0xba98026U,
    0x7c5ac083U,
    0x5fbee0eeU,
    0xa10b10a9U,
    0x1080882eU,
    0xd243e4bdU,
    0x21e6fe81U,
    0x81ba0b09U,
    0xd8008826U,
    0x8c03e483U,
    0x3e06feeeU,
    0x490a0ba9U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x58000000U,
    0x54000000U,
    0x26000000U,
    0x4b000000U,
    0x5800000U,
    0x95c00000U,
    0xc4e00000U,
    0x2df00000U,
    0x12e80000U,
    0x4ef40000U,
    0x2b6e0000U,
    0xa1310000U,
    0x8e8b8000U,
    0xb0444000U,
    0x6121e000U,
    0xe114f000U,
    0x331fb800U,
    0x2e14ac00U,
    0x8947600U,
    0xc4d03300U,
    0xbff7b880U,
    0x6fe0ac40U,
    0x387a7660U,
    0xbf213350U,
    0x8e1c38d8U,
    0x7894ec14U,
    0xacd39646U,
    0xe3f1c31bU,
    0x45e580ddU,
    0x1754081U,
    0xd7aa6082U,
    0x5550b036U,
    0x2c3e584fU,
    0xd0005c8fU,
    0x180bcec9U,
    0x34049fc7U,
    0x7603ce19U,
    0x13009f2bU,
    0x5185ce6eU,
    0xb3c59f7dU,
    0x8fe04e17U,
    0x2870df94U,
    0x872a2edcU,
    0x8a106f8bU,
    0x69c7699U,
    0xb3d4336bU,
    0xc071b80eU,
    0x9b25ac2dU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0x98000000U,
    0x34000000U,
    0x52000000U,
    0x45000000U,
    0x63800000U,
    0x23c00000U,
    0xdc200000U,
    0xc8f00000U,
    0x6280000U,
    0xd1fc0000U,
    0x3ba20000U,
    0xe13f0000U,
    0xb0b8000U,
    0x188c4000U,
    0xc346a000U,
    0xbb641000U,
    0x899a9800U,
    0x66bd2c00U,
    0xb2cada00U,
    0xbdace300U,
    0xa6329880U,
    0x25812cc0U,
    0xc4c8daa0U,
    0xc2a3e330U,
    0x8cb11818U,
    0x33c16cf4U,
    0xb4247af2U,
    0xc4f4f375U,
    0x502a007bU,
    0x5ef300d7U,
    0x2921802eU,
    0xf37f40bdU,
    0xb1e720fdU,
    0x6fdb50c6U,
    0x2e5db8b5U,
    0xb0967c6cU,
    0xab3f626eU,
    0xba069feaU,
    0x890ffaa4U,
    0x9588b352U,
    0x9cc4a0a4U,
    0x56ab105fU,
    0xeeb91872U,
    0xeecd6ce3U,
    0xe3ae7aeeU,
    0xb537f32aU,
    0xc9038004U,
    0xf5804062U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x98000000U,
    0xac000000U,
    0x32000000U,
    0x29000000U,
    0x14800000U,
    0x2c00000U,
    0xcde00000U,
    0xadf00000U,
    0xb3e80000U,
    0xa6fc0000U,
    0xc6620000U,
    0xf4bb0000U,
    0xf4b8000U,
    0x23a1c000U,
    0x1ed0a000U,
    0x9f75000U,
    0xa5efe800U,
    0x59fe7c00U,
    0x8debb600U,
    0xcdfae300U,
    0x63e7e880U,
    0x4ef27cc0U,
    0xf261b6a0U,
    0x6abde370U,
    0x144e6818U,
    0x1e28bc6cU,
    0x89a9692U,
    0xc6db7359U,
    0xc5f9200cU,
    0x47ed906eU,
    0x98f4c85fU,
    0xad68ecf4U,
    0x5134fe3fU,
    0xb503cf08U,
    0xde8bb6b9U,
    0x57cae3b0U,
    0x36fe888U,
    0xb23e7c37U,
    0xf48bb62dU,
    0x12cae38cU,
    0x85efe833U,
    0xe9fe7c99U,
    0xb5ebb6d3U,
    0x11fae36bU,
    0xc9e7e808U,
    0xcbf27cf7U,
    0xd4e1b68dU,
    0x417de3fcU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x98000000U,
    0xb4000000U,
    0xde000000U,
    0x61000000U,
    0xca800000U,
    0x63c00000U,
    0x39200000U,
    0xc9300000U,
    0x6b280000U,
    0x923c0000U,
    0xa6aa0000U,
    0x7e750000U,
    0x70c38000U,
    0x38ae4000U,
    0xff766000U,
    0xa4c5000U,
    0x5364c800U,
    0xea596c00U,
    0xa973da00U,
    0x87413f00U,
    0xd3ecc880U,
    0xa6956cc0U,
    0xa3d1da20U,
    0x53383f90U,
    0x3c2d4818U,
    0xa5b22c74U,
    0x6dee3afeU,
    0xb79f2ff1U,
    0x415460d2U,
    0x8cf55017U,
    0xf70548c7U,
    0x678e2c38U,
    0x73443a39U,
    0xedea2f45U,
    0x7797e0c1U,
    0x615b1016U,
    0x1cf328f1U,
    0x6f027c59U,
    0xd380f2f8U,
    0xad434309U,
    0x8cec3a16U,
    0xbd162fe1U,
    0x29de09aU,
    0x25de10c0U,
    0xa638a871U,
    0xb8a03c99U,
    0x3f7492d8U,
    0x2a461399U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xb8000000U,
    0x3c000000U,
    0x82000000U,
    0x79000000U,
    0x1d800000U,
    0xf6400000U,
    0x67a00000U,
    0x8d300000U,
    0x82a80000U,
    0x22b40000U,
    0xc5ee0000U,
    0xcc950000U,
    0xb8958000U,
    0xee9ec000U,
    0xf199a000U,
    0x3b1f5000U,
    0x93d97800U,
    0x5abbb400U,
    0xd9ecc200U,
    0x3e934700U,
    0x69977880U,
    0x771eb440U,
    0xb9d14260U,
    0xa7b98710U,
    0x7a60d838U,
    0x33d4e47cU,
    0x6abdbae2U,
    0x11ecf369U,
    0xaa9dba25U,
    0x6f9cf38aU,
    0xb015ba05U,
    0x5f58f3a4U,
    0x3573bac7U,
    0xf609f3b8U,
    0x2f003a78U,
    0x2863354U,
    0x3cca1afdU,
    0xcf66a32fU,
    0x44514294U,
    0x1f98799U,
    0xc5c0d809U,
    0x92e4e4f8U,
    0xd215ba4fU,
    0x7658f3c5U,
    0xf0f3bac5U,
    0x2c49f353U,
    0x72a03a76U,
    0xcab633f0U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x88000000U,
    0x34000000U,
    0xd6000000U,
    0xe5000000U,
    0x25800000U,
    0x89c00000U,
    0xa2600000U,
    0x93b00000U,
    0xe3680000U,
    0xd8340000U,
    0x53ae0000U,
    0xcdd30000U,
    0xf2d68000U,
    0x78584000U,
    0xc31fe000U,
    0x6301000U,
    0xc2aab800U,
    0x5e580c00U,
    0xee17de00U,
    0x77b25700U,
    0xed64b880U,
    0x913b0c40U,
    0x6c295e60U,
    0xcb1e1770U,
    0x72355808U,
    0x74a81c74U,
    0xcb5d66b6U,
    0x439a5b95U,
    0xca7b662dU,
    0x990d5bfdU,
    0xe78be694U,
    0xaac21b46U,
    0x9ae486aeU,
    0x83fd4b55U,
    0x2ac15e4fU,
    0xdaea17bfU,
    0xe3fb588aU,
    0x5acb1cc8U,
    0x52e3e629U,
    0xd7f61b70U,
    0x8cca868aU,
    0xb7ee4b75U,
    0xf277de2cU,
    0x50257abU,
    0x158cb882U,
    0x61cf0cbcU,
    0xe6675e9fU,
    0xcdbd17e5U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0xa8000000U,
    0xe4000000U,
    0x2e000000U,
    0xc7000000U,
    0xfe800000U,
    0x22c00000U,
    0xfae00000U,
    0xf2300000U,
    0x7be80000U,
    0xcfb40000U,
    0x79a20000U,
    0x28910000U,
    0xc3f88000U,
    0x49874000U,
    0x64466000U,
    0x342d3000U,
    0x92d28800U,
    0xc8d29c00U,
    0x69d0e600U,
    0x44559f00U,
    0x4e188880U,
    0x1d379c40U,
    0x216a66a0U,
    0x6373df50U,
    0x144e6828U,
    0x8c29eca4U,
    0x7edc8e8eU,
    0x52dd7397U,
    0x28d486d6U,
    0x99d9af86U,
    0xbc5a80f4U,
    0x2164025U,
    0xd73ee08dU,
    0xc86a7059U,
    0x5af4e805U,
    0xc80facf9U,
    0x540a6e68U,
    0x76030363U,
    0xdb026e99U,
    0x9c87038cU,
    0x2fc86ef0U,
    0xed6203acU,
    0xe972ee87U,
    0x5d444363U,
    0xe5a40ec0U,
    0xa9a3387U,
    0x6ef2e6b7U,
    0xe049f4bU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x98000000U,
    0xd4000000U,
    0x1e000000U,
    0xe5000000U,
    0x6b800000U,
    0xb9400000U,
    0x56e00000U,
    0x33700000U,
    0xed680000U,
    0x423c0000U,
    0x678a0000U,
    0x93470000U,
    0x3deb8000U,
    0x95f64000U,
    0x73a06000U,
    0x679f1000U,
    0xf91d5800U,
    0xc3dac400U,
    0x407c5600U,
    0x5fe8e300U,
    0xe2f6d880U,
    0x172c84c0U,
    0xfe5c3620U,
    0x37f3b0U,
    0xa08b8018U,
    0x6fc64014U,
    0x7028603eU,
    0x72d31055U,
    0xf5ff58f3U,
    0x23a1c46dU,
    0x6f9dd648U,
    0x519a3d6U,
    0x91dd3806U,
    0x6f75d43bU,
    0xcf690e11U,
    0xd53e2710U,
    0x93088ec8U,
    0x228f67c3U,
    0x88c36eaaU,
    0x3ca63761U,
    0xa71e5697U,
    0xc6d3e34bU,
    0xbbf75843U,
    0xceadc44aU,
    0xf81fd63bU,
    0xee52a3aeU,
    0xe834b8e2U,
    0xcc8894b7U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0xe8000000U,
    0xc000000U,
    0x22000000U,
    0xa3000000U,
    0xd0800000U,
    0x8bc00000U,
    0x44a00000U,
    0x13f00000U,
    0xc280000U,
    0xac3c0000U,
    0x6e860000U,
    0x22cd0000U,
    0xdb208000U,
    0x7ab1c000U,
    0x8844a000U,
    0x27e6f000U,
    0xd8912800U,
    0x657b8c00U,
    0xdae3c200U,
    0xb11b4300U,
    0x9931a880U,
    0xfb0a4cc0U,
    0x48762e0U,
    0xbdcdb310U,
    0x31a88068U,
    0xa67dc0ccU,
    0xda6aa0c2U,
    0x32d7f0b3U,
    0xc197a838U,
    0x22f74c87U,
    0xa7afe266U,
    0xe37073b0U,
    0x77e2205cU,
    0x109a30e7U,
    0x997508caU,
    0xecbc21U,
    0xf6164a3fU,
    0x67b63fdaU,
    0xf1cb4244U,
    0x33a68366U,
    0xf57b08b3U,
    0xf2edbc44U,
    0x5d18ca1eU,
    0xab36ff99U,
    0xb0096207U,
    0xd80cb35dU,
    0x14060022U,
    0xd60d00d6U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x88000000U,
    0x24000000U,
    0x5e000000U,
    0x85000000U,
    0xb6800000U,
    0x1c00000U,
    0xf2200000U,
    0x42f00000U,
    0x6aa80000U,
    0x5e3c0000U,
    0xa20a0000U,
    0xb7010000U,
    0x698a8000U,
    0xbc4f4000U,
    0x486d6000U,
    0x239a1000U,
    0x85b68800U,
    0x14c4c00U,
    0x62ea4a00U,
    0x205b3300U,
    0xd0940880U,
    0x823f0cc0U,
    0x400d2a20U,
    0xe00023d0U,
    0xf0080008U,
    0x580c00e4U,
    0xac02007eU,
    0x7a0d0055U,
    0xdb08803eU,
    0x33824025U,
    0xb745e0acU,
    0xf3e850c7U,
    0xb0db68dcU,
    0x28581c5fU,
    0x349b2250U,
    0xfc322ff5U,
    0x150daa83U,
    0xde8e6322U,
    0xd5cfe04aU,
    0xf4295084U,
    0x6bf1e844U,
    0xa6275c49U,
    0x84fe42fcU,
    0x63a43fa2U,
    0x42b9223dU,
    0xf0cf2fc7U,
    0x52ad2ac6U,
    0xc2302393U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x98000000U,
    0x94000000U,
    0x6e000000U,
    0xa3000000U,
    0x96800000U,
    0x3e400000U,
    0x56200000U,
    0x91700000U,
    0xbba80000U,
    0xcdbc0000U,
    0x6dc20000U,
    0x41eb0000U,
    0xdd938000U,
    0xf3b64000U,
    0xe6cb6000U,
    0x7b657000U,
    0x69d28800U,
    0xf09f5400U,
    0xd638ca00U,
    0x60b5300U,
    0x6f030880U,
    0xcc8214c0U,
    0x83402aa0U,
    0xfba86370U,
    0xadb2e018U,
    0xbdc43054U,
    0xa9e868ceU,
    0xd19764d3U,
    0x9baa20eU,
    0x2bcb37aaU,
    0x4ee82ab8U,
    0xc11463f2U,
    0x98f0e00dU,
    0x116f3043U,
    0x2cdbe803U,
    0x19112434U,
    0x6cf9c290U,
    0xaf624709U,
    0x67d0a2f3U,
    0x839c3767U,
    0xa8b9aa54U,
    0x3449231cU,
    0xc3280065U,
    0x90fc0005U,
    0xd620086U,
    0x9edb00f7U,
    0xa81b8085U,
    0x3b7a4046U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x58000000U,
    0x5c000000U,
    0x7a000000U,
    0xcd000000U,
    0x80800000U,
    0x5e400000U,
    0x4ce00000U,
    0x5b100000U,
    0x5b680000U,
    0x58dc0000U,
    0x31420000U,
    0x9d610000U,
    0x5fdf8000U,
    0x54c0c000U,
    0x97ae2000U,
    0x33731000U,
    0xa83aa800U,
    0xa058b400U,
    0x23070600U,
    0x538cf500U,
    0x45cf2880U,
    0xad2574c0U,
    0x34a6a0U,
    0xb45e25d0U,
    0xfd0420d8U,
    0x688e109cU,
    0x2a4728daU,
    0xe2e9741dU,
    0xe81ea6d8U,
    0x30e32502U,
    0x3119a0b6U,
    0x6e6fd056U,
    0x5456887bU,
    0x4d0aa4d6U,
    0x40822e25U,
    0xfe44819aU,
    0x9cee0efeU,
    0x3169101U,
    0x76b2606U,
    0x22dee5e0U,
    0xfc4a00c3U,
    0x1ded00e3U,
    0x195806dU,
    0x182dc079U,
    0xccbba07eU,
    0x681ed05fU,
    0xf0e108caU,
    0x9116647bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0xb8000000U,
    0x94000000U,
    0x1a000000U,
    0x4b000000U,
    0xa5800000U,
    0x7bc00000U,
    0x48600000U,
    0xd2700000U,
    0xe4e80000U,
    0xa33c0000U,
    0x60c20000U,
    0x35ed0000U,
    0x8db18000U,
    0x1e804000U,
    0x16462000U,
    0xafa7f000U,
    0xbc1af800U,
    0x4b908c00U,
    0x27539e00U,
    0x4cb53b00U,
    0x88017880U,
    0xfc01ccc0U,
    0x96063ea0U,
    0xd50f8b10U,
    0x4c842038U,
    0x14af054U,
    0x8c2b78baU,
    0xaad0cc5bU,
    0xdb75be1dU,
    0xee62cbefU,
    0x6f7380d2U,
    0x246d4059U,
    0x3c77a0e1U,
    0x5e7b0c8U,
    0xe5bcd890U,
    0x92877c73U,
    0x88416673U,
    0x46a9b7f6U,
    0xc698e653U,
    0x8fd5f721U,
    0x5ffcc659U,
    0x732f0757U,
    0xc55fbe4dU,
    0xf3b3cb04U,
    0x878000d6U,
    0x64c0008dU,
    0x57e0009bU,
    0xf2b00033U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x8000000U,
    0x5c000000U,
    0x62000000U,
    0x81000000U,
    0xed800000U,
    0x87c00000U,
    0x6e600000U,
    0x9e300000U,
    0x58e80000U,
    0xf1740000U,
    0x4aca0000U,
    0xa9ed0000U,
    0xe4f28000U,
    0x2904c000U,
    0x6182a000U,
    0xcdcfd000U,
    0x2361f800U,
    0x19b0ec00U,
    0x225fe00U,
    0x1093bf00U,
    0xd2317880U,
    0x72ed2c40U,
    0xc7fde20U,
    0x5545af90U,
    0xa728a088U,
    0x3b12d01cU,
    0x52fb7842U,
    0xd6002c11U,
    0x4f0d5ee5U,
    0xb6816fdbU,
    0x2f4a008cU,
    0x322d005fU,
    0xc8928095U,
    0xa634c0e6U,
    0xdceaa02cU,
    0xe77bd06bU,
    0x65cbf8deU,
    0xaf6dec59U,
    0x53bf7ec6U,
    0x4f237fe3U,
    0x9719d829U,
    0x88fffceeU,
    0x9304a61bU,
    0x948583bcU,
    0x8e45fe33U,
    0x4fa3bfdeU,
    0x47597828U,
    0x94592c3dU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xb8000000U,
    0xec000000U,
    0x66000000U,
    0x23000000U,
    0xab800000U,
    0xadc00000U,
    0x1b600000U,
    0x17100000U,
    0x9e80000U,
    0xc5c0000U,
    0xabca0000U,
    0x88690000U,
    0x74998000U,
    0xa023c000U,
    0x2531e000U,
    0x15d6f000U,
    0x6f0dd800U,
    0x5d8d6c00U,
    0x16c2ce00U,
    0xce34d00U,
    0x64d65880U,
    0xdd8bacc0U,
    0xd6c8ae20U,
    0x2ce37d50U,
    0x34d9e038U,
    0x658af02cU,
    0x3ac7d846U,
    0x4ae46c73U,
    0x17db4e13U,
    0xce008d41U,
    0x9707b8fdU,
    0x518d5cf4U,
    0xcd7682U,
    0xc7e211f1U,
    0x9b592e88U,
    0xfa4cbdb3U,
    0x88aa00bbU,
    0xb379001fU,
    0x3b7180bdU,
    0xdf7fc08cU,
    0x9d7be0deU,
    0xdc7ff025U,
    0x66f458f7U,
    0xc9beac9bU,
    0x919b2e10U,
    0xb8a9bdb2U,
    0xbb718026U,
    0x1f7fc05bU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0xd8000000U,
    0x44000000U,
    0x7e000000U,
    0x61000000U,
    0x23800000U,
    0x7ec00000U,
    0xf1200000U,
    0x26500000U,
    0x1fe80000U,
    0xcf7c0000U,
    0x1dbe0000U,
    0xbe950000U,
    0x6bcf8000U,
    0xc4af4000U,
    0xd59d6000U,
    0x3f46d000U,
    0x14e01800U,
    0x8bf45c00U,
    0x15f5da00U,
    0xa4f82100U,
    0x3f7d7880U,
    0x15b28cc0U,
    0x4295c260U,
    0x41cc7d10U,
    0x3a8a258U,
    0xd31aad84U,
    0x1c00ba9eU,
    0xfa02f1b1U,
    0x7f03601bU,
    0x5283d0eaU,
    0x85479837U,
    0xcbe71c13U,
    0xa976ba9aU,
    0x58bbf194U,
    0xf31ae031U,
    0xac059047U,
    0x520b78c6U,
    0xf30b8c43U,
    0xb08c42feU,
    0xde4a3d2cU,
    0xf7644283U,
    0x95363d9fU,
    0xf4da4275U,
    0x5aa33d4fU,
    0x6495c25cU,
    0xa4cc7dd7U,
    0x3e28a2cfU,
    0xdcdaad6bU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0xa8000000U,
    0x7c000000U,
    0x16000000U,
    0x6d000000U,
    0x7b800000U,
    0x66400000U,
    0xe3200000U,
    0x87d00000U,
    0xf3680000U,
    0xf9f40000U,
    0x17320000U,
    0xa8dd0000U,
    0xcfec8000U,
    0x3f38c000U,
    0x94d8e000U,
    0x79e69000U,
    0x42359800U,
    0x47551400U,
    0x63a9ba00U,
    0xb71c3100U,
    0xad857880U,
    0xeb478440U,
    0x28ae22a0U,
    0x59942510U,
    0xc4404228U,
    0x1423753cU,
    0x9f53ba36U,
    0x47a5313dU,
    0xc513f8f3U,
    0x1286444aU,
    0x3fc042fdU,
    0x32637586U,
    0xdc73bab6U,
    0xd07531ceU,
    0x9e7bf8b9U,
    0x97724474U,
    0x3ef242acU,
    0xf7be754bU,
    0x681f3aadU,
    0x890df1feU,
    0xe9831824U,
    0x6944d472U,
    0x8fafdabfU,
    0x491f61d4U,
    0x1c84809aU,
    0x96ccc0c5U,
    0x8beae0b4U,
    0xbd3b909aU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0xb8000000U,
    0x24000000U,
    0xe000000U,
    0xd1000000U,
    0x96800000U,
    0x5c00000U,
    0x12600000U,
    0x69b00000U,
    0x41a80000U,
    0x3ed40000U,
    0x689e0000U,
    0x7fb30000U,
    0x64a18000U,
    0x8e5f4000U,
    0xd05a6000U,
    0x6957d000U,
    0xf3da4800U,
    0x941aec00U,
    0xc57b3e00U,
    0xc14e7f00U,
    0xcca82880U,
    0xa2593c40U,
    0x225f7660U,
    0x625793f0U,
    0x25a9638U,
    0xf25c0364U,
    0x4a533eeeU,
    0x6e5a7f61U,
    0x605628ceU,
    0xb15a3c91U,
    0x27d6f6c4U,
    0x221cd36cU,
    0x307ef6e1U,
    0x59c8d38eU,
    0x1860f602U,
    0x26bbd372U,
    0x4e2176f9U,
    0x31949348U,
    0x553316bdU,
    0xdb674304U,
    0xb3f5e7eU,
    0x626aaf1bU,
    0x91b3e0cbU,
    0x5ac9070U,
    0xc0d62898U,
    0x19a3c86U,
    0xcd36f6dfU,
    0x6f6cd386U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x28000000U,
    0x4c000000U,
    0x4a000000U,
    0xe5000000U,
    0x7c800000U,
    0x45400000U,
    0x8b600000U,
    0x90500000U,
    0x7c280000U,
    0xda340000U,
    0x76f60000U,
    0x1c590000U,
    0x96208000U,
    0x8f3bc000U,
    0x72752000U,
    0x3d111000U,
    0x1b472800U,
    0xb0656400U,
    0x97dc0e00U,
    0xdeef8900U,
    0xa39a0880U,
    0xb7007440U,
    0xed8d26e0U,
    0xf7c3ed50U,
    0x7d2e86a8U,
    0xe0b03d0cU,
    0x7cbc0e2aU,
    0x5ebf89f5U,
    0x17b20834U,
    0x71347419U,
    0xf97b2609U,
    0x429aed69U,
    0xdd8e06e2U,
    0xcfcbfd76U,
    0xf9292eabU,
    0xb6be993cU,
    0xfbbd2055U,
    0x8b3510dcU,
    0x64792871U,
    0x5a186492U,
    0x9ec28e99U,
    0xeba94915U,
    0xf0f1a838U,
    0xf357a400U,
    0xefa1ae37U,
    0xe6f159eaU,
    0x945e003aU,
    0x6a2d00feU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x28000000U,
    0xfc000000U,
    0xa000000U,
    0xf9000000U,
    0x8e800000U,
    0x6bc00000U,
    0x2ae00000U,
    0x9a300000U,
    0xe4280000U,
    0x24540000U,
    0xe4da0000U,
    0xc8190000U,
    0x137c8000U,
    0xe704c000U,
    0xe1812000U,
    0x6645d000U,
    0x4ea00800U,
    0x8194cc00U,
    0xc932b600U,
    0x83a4c700U,
    0xc91b2880U,
    0x9f81c40U,
    0x5ac63e20U,
    0x6860cb50U,
    0xa3f2bea8U,
    0xb3c00bbcU,
    0xeee19eaaU,
    0x6438dbe9U,
    0xbb2f1606U,
    0x71d5d787U,
    0x49200a8U,
    0xdbd008fU,
    0x316e8068U,
    0x3d79c01aU,
    0xd00fa062U,
    0x680c103cU,
    0xdc07a859U,
    0x5a0cdccbU,
    0xd10f1e45U,
    0x72811b7bU,
    0x61c0b6f7U,
    0xd3e9c750U,
    0x14bda89bU,
    0x8fe5dcfeU,
    0xebb9e99U,
    0x7ee1db6dU,
    0x2c33968dU,
    0x372117aeU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x38000000U,
    0xb4000000U,
    0x46000000U,
    0x4b000000U,
    0xfc800000U,
    0x86400000U,
    0x3a00000U,
    0xb6700000U,
    0x52e80000U,
    0x73540000U,
    0xc3da0000U,
    0xd7970000U,
    0x493d8000U,
    0xc0ce4000U,
    0x64eae000U,
    0x60557000U,
    0x1b506800U,
    0x9fdc7400U,
    0x8d9a6200U,
    0x78391b00U,
    0xbd408880U,
    0xa72e0440U,
    0x143f8a20U,
    0x9f4f2fb0U,
    0x2220ab8U,
    0x9fb16ff4U,
    0x2f80eae6U,
    0x3ec01fbbU,
    0xdbe28264U,
    0xfadf6bc2U,
    0x661f60ddU,
    0x58ff30b9U,
    0x9a888f0U,
    0x6f7a04baU,
    0x33658a42U,
    0xca982f18U,
    0x36bf8a22U,
    0x160f2f88U,
    0xa3020aaaU,
    0xe0816f04U,
    0xfc48ea58U,
    0x82a41f09U,
    0xf3f082efU,
    0x252c6b73U,
    0x4130e06aU,
    0xcc270c6U,
    0xb6ede80eU,
    0xdd5234a7U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0x58000000U,
    0x9c000000U,
    0x1e000000U,
    0x3f000000U,
    0x83800000U,
    0x2400000U,
    0x18e00000U,
    0x1bd00000U,
    0xe1280000U,
    0xad7c0000U,
    0x4120000U,
    0x48b0000U,
    0x8dc38000U,
    0xcacc000U,
    0x83b6000U,
    0xa377b000U,
    0xf3141800U,
    0x130c3400U,
    0xa5834600U,
    0xf1492100U,
    0x2d6cf880U,
    0xe29744c0U,
    0xf84c3ea0U,
    0x95e2a5f0U,
    0x4153a6d8U,
    0x33ee515cU,
    0x7251803eU,
    0xa667c00fU,
    0x7b18e07bU,
    0xe70b706eU,
    0xdf87785eU,
    0xbc4784b8U,
    0xd7e55e7cU,
    0xc05e1590U,
    0x7f643e1fU,
    0xab9ea5ddU,
    0x20c1a654U,
    0x6625518aU,
    0x22f20095U,
    0x105b00a6U,
    0x176b809cU,
    0xcf90c048U,
    0x52c960e5U,
    0x1f2cb0ffU,
    0x27f9853U,
    0x8f9cf474U,
    0x32ca26d4U,
    0x4f2591c3U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0xd8000000U,
    0xfc000000U,
    0x6a000000U,
    0xab000000U,
    0x71800000U,
    0xfc00000U,
    0x83200000U,
    0x33b00000U,
    0x95680000U,
    0x5b5c0000U,
    0xd3fe0000U,
    0xc870000U,
    0x1f478000U,
    0x66ac000U,
    0x26d82000U,
    0xe30f000U,
    0xe8aa7800U,
    0xef76ec00U,
    0xcbc89a00U,
    0xe5265f00U,
    0x4ab5d880U,
    0x83ecdcc0U,
    0x971ac260U,
    0x8104330U,
    0xa79f3a58U,
    0x1d506f3cU,
    0x3af1808aU,
    0x9201c05bU,
    0xc709a0c9U,
    0x938130c3U,
    0xb0cbd831U,
    0xbcabdc64U,
    0x17d428eU,
    0xa6ca83ffU,
    0xbdaf1aa1U,
    0xbbfc9ff0U,
    0xe885f8e9U,
    0xe9402c9eU,
    0xf76ebad8U,
    0x2451af95U,
    0x8c782016U,
    0xe40f072U,
    0xf4e27889U,
    0x1c9aec79U,
    0x24de9aaeU,
    0x413d5fa2U,
    0x6f2c5848U,
    0x11b11c01U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0x38000000U,
    0x2c000000U,
    0xe6000000U,
    0xb7000000U,
    0x59800000U,
    0xea400000U,
    0xdf200000U,
    0x17d00000U,
    0x4ae80000U,
    0xb5b40000U,
    0x6b9e0000U,
    0xeac10000U,
    0x5fe18000U,
    0xe939c000U,
    0xc558e000U,
    0x7263000U,
    0xabdb3800U,
    0xf4e8b400U,
    0xfeb99a00U,
    0xec150100U,
    0x9b8a5880U,
    0x3f434440U,
    0xa3a44260U,
    0x91a85d0U,
    0x4f097ab8U,
    0x5587316cU,
    0xbc4f6006U,
    0x802af027U,
    0x5a5c5801U,
    0x6aa64416U,
    0x3b93c201U,
    0x92c6458cU,
    0x13e61a75U,
    0xdf3dc1a8U,
    0x4a5b380dU,
    0x72a8b487U,
    0xa7999a92U,
    0x9cc501b7U,
    0xb0e258baU,
    0x4cb74483U,
    0xf11a4240U,
    0x430b857aU,
    0x380fa5aU,
    0xe34af193U,
    0xcda98066U,
    0x7a1dc049U,
    0xe48ee0d6U,
    0xc2c33058U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x68000000U,
    0x3c000000U,
    0xd6000000U,
    0x51000000U,
    0x1a800000U,
    0x49c00000U,
    0xdf200000U,
    0xead00000U,
    0xfa680000U,
    0x5d3c0000U,
    0x9d1a0000U,
    0x884f0000U,
    0x5b688000U,
    0xcfbac000U,
    0x78d8e000U,
    0x59645000U,
    0xb4b10800U,
    0xc55dec00U,
    0xeb20ca00U,
    0x50d0d900U,
    0x85696880U,
    0xf2bf7cc0U,
    0x4c532220U,
    0xa5a665b0U,
    0xf3102ae8U,
    0xdd4889fcU,
    0x53e26076U,
    0xe57d9021U,
    0x6e736852U,
    0x5bf07cc5U,
    0x45bba261U,
    0xafdca587U,
    0xeae8cab6U,
    0x3fcd985U,
    0xd1bb68f8U,
    0x65dc7c5bU,
    0xdde9a236U,
    0x207fa5f4U,
    0xbef24a21U,
    0x25351921U,
    0xb911081eU,
    0x2a4deceaU,
    0x5068ca45U,
    0x3a3cd9e9U,
    0x469b6852U,
    0x30c7c74U,
    0x9981a298U,
    0x1043a54dU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x58000000U,
    0x14000000U,
    0xda000000U,
    0xf3000000U,
    0x1800000U,
    0x7e400000U,
    0x28600000U,
    0x55d00000U,
    0x21a80000U,
    0x2efc0000U,
    0x4c9e0000U,
    0x12490000U,
    0x966f8000U,
    0x94da4000U,
    0x4f2d2000U,
    0xc737f000U,
    0x27b2f800U,
    0x477c7400U,
    0x6eda2e00U,
    0xcc2ce100U,
    0x2eb85880U,
    0xc5fdc4c0U,
    0xf913f660U,
    0x60265d0U,
    0xc5090ed8U,
    0x8c8211d4U,
    0xdecd203aU,
    0xe8a7f0e3U,
    0xcc7af839U,
    0xb5074baU,
    0x806c2eaaU,
    0x69d9e1b2U,
    0x7a9d87aU,
    0x9bfe8463U,
    0x28195605U,
    0x5083d5e9U,
    0xe8c0d647U,
    0x65ac953bU,
    0x6cfc7618U,
    0xcb982518U,
    0x19c42e44U,
    0x4325e1bbU,
    0xa937d8fdU,
    0xbeb7843dU,
    0x3df6d684U,
    0x5d199522U,
    0x540df6d7U,
    0x7a0b6593U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0xa8000000U,
    0xcc000000U,
    0x22000000U,
    0xb1000000U,
    0xbe800000U,
    0xea400000U,
    0x9de00000U,
    0xf3100000U,
    0x48280000U,
    0x523c0000U,
    0x609e0000U,
    0xe6ef0000U,
    0x90908000U,
    0xeee9c000U,
    0x8c9fa000U,
    0xd4e35000U,
    0x59920800U,
    0x84631400U,
    0x20d2e600U,
    0x160cdd00U,
    0x87032880U,
    0x298684c0U,
    0xbbcfce60U,
    0xf22559b0U,
    0x473c6628U,
    0x501a1d0cU,
    0x2fa408c2U,
    0xaaf014c1U,
    0x853c6676U,
    0x911a1d96U,
    0x59240897U,
    0x3cb0144eU,
    0x92dc66b4U,
    0x1f0a1db9U,
    0x8d8c086bU,
    0x35cc14f3U,
    0xd1226607U,
    0xe0b51d4eU,
    0xc8d48832U,
    0x7a09d486U,
    0x750bc676U,
    0x80854d7eU,
    0x614800e2U,
    0xf66c0098U,
    0x49d600edU,
    0xac83006dU,
    0x3346800cU,
    0x8f6ac0faU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0xd8000000U,
    0x64000000U,
    0xaa000000U,
    0xc1000000U,
    0x47800000U,
    0x8f400000U,
    0x94a00000U,
    0xbb300000U,
    0x49680000U,
    0xc55c0000U,
    0x34b20000U,
    0xba2d0000U,
    0x3ffb8000U,
    0x748d4000U,
    0xadc22000U,
    0x566dd000U,
    0xf1d19800U,
    0xf97bc400U,
    0xdc436200U,
    0x862b9f00U,
    0x31fa3880U,
    0xbf8654c0U,
    0xbb435aa0U,
    0x46accb90U,
    0x8e38e258U,
    0x7ce6dfa4U,
    0xef18188aU,
    0x4d9b8491U,
    0x4f5ac23fU,
    0xa5bb0f7bU,
    0x85a18066U,
    0x44bc40deU,
    0x922ba004U,
    0xb3fd901bU,
    0xf280383fU,
    0x7ac754eaU,
    0x1ee2da48U,
    0x52108bcbU,
    0x64134217U,
    0x3b1b4f66U,
    0x6f98204eU,
    0x925cd0dcU,
    0xbc38187fU,
    0xb9eb8495U,
    0x3292c22bU,
    0x4bd70f0fU,
    0x207b80c4U,
    0x5fcd40c3U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x68000000U,
    0x24000000U,
    0xa2000000U,
    0x15000000U,
    0x4f800000U,
    0xee400000U,
    0xb600000U,
    0x6d700000U,
    0xb3a80000U,
    0x21dc0000U,
    0x9cf20000U,
    0x76ef0000U,
    0x8e308000U,
    0x1b4b4000U,
    0x94eba000U,
    0xfb3f9000U,
    0x44cf9800U,
    0xa2af1400U,
    0xbc5d5e00U,
    0xafb5eb00U,
    0xa606b880U,
    0xc704c4c0U,
    0x9281e6a0U,
    0x35c22fb0U,
    0x2f25dee8U,
    0x5712abe4U,
    0x33571882U,
    0x69385465U,
    0xf9c4fe87U,
    0x69257b7aU,
    0x4019a041U,
    0xd9d0909cU,
    0xa0ff18feU,
    0x38e4546aU,
    0xad36feb0U,
    0x8bca7bd1U,
    0x4292014U,
    0xf39bd082U,
    0xd994b854U,
    0x389bc4f2U,
    0xad196635U,
    0xaa556f86U,
    0xbc7e37U,
    0x10823bbbU,
    0x50c80085U,
    0xa8ac0076U,
    0x2d5a0027U,
    0xf23300daU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0xd8000000U,
    0xf4000000U,
    0x16000000U,
    0xfd000000U,
    0xc3800000U,
    0x53400000U,
    0x8a200000U,
    0x27b00000U,
    0x5be80000U,
    0x17540000U,
    0x323e0000U,
    0xd5af0000U,
    0xeff8000U,
    0xaec24000U,
    0x286be000U,
    0xdc1b1000U,
    0x2c191800U,
    0xd41a0400U,
    0x701e0a00U,
    0x8e131700U,
    0x5f137880U,
    0x7e9c5440U,
    0xc6db7260U,
    0x72744330U,
    0xc5098a58U,
    0x478557b4U,
    0xfd4698f6U,
    0xb328448dU,
    0x2a3dea7bU,
    0x1ac0797U,
    0x48fc60c4U,
    0xbbcd506eU,
    0xc7ecf8eeU,
    0x6d5e1489U,
    0x4d3092a3U,
    0xcd2f5355U,
    0xbb309249U,
    0x402f5323U,
    0xc0b09262U,
    0xd76f533dU,
    0x849092a2U,
    0xf9df530cU,
    0xaf89223U,
    0x40cb5392U,
    0x71669284U,
    0xe1945389U,
    0xae5112f3U,
    0x7fb2138bU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x48000000U,
    0xe4000000U,
    0xbe000000U,
    0x51000000U,
    0xd1800000U,
    0xb7c00000U,
    0x1f600000U,
    0x47500000U,
    0x16280000U,
    0xaf7c0000U,
    0x485e0000U,
    0xa6ab0000U,
    0xe13e8000U,
    0xf4ff4000U,
    0x8946000U,
    0x54dd000U,
    0x222db800U,
    0x9780c00U,
    0x25543e00U,
    0x95273100U,
    0x15f15880U,
    0x311d9cc0U,
    0xc68d6660U,
    0x3b46adf0U,
    0xb3223ec8U,
    0xb8f03124U,
    0x6291d85eU,
    0xc249dc61U,
    0xb6a786f9U,
    0x99343da3U,
    0x38fbe669U,
    0xa295ed32U,
    0xa2405e99U,
    0x46aae179U,
    0xd13ce02eU,
    0xdcf59082U,
    0x1c91587eU,
    0xf34d9c59U,
    0x97256671U,
    0x66faad0eU,
    0xc39c3e7bU,
    0x5bcb313aU,
    0xe56758f4U,
    0x385a9c0bU,
    0x2ea5e656U,
    0x653eed67U,
    0xbafede08U,
    0x1195a12fU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0xf8000000U,
    0x9c000000U,
    0x76000000U,
    0xd000000U,
    0x9f800000U,
    0xc9c00000U,
    0x9b200000U,
    0x98100000U,
    0x76180000U,
    0x971c0000U,
    0xb6960000U,
    0x865f0000U,
    0x90f08000U,
    0x26294000U,
    0x2f962000U,
    0x7bdaf000U,
    0x763d0800U,
    0xad829400U,
    0xfec5a600U,
    0x27ae6700U,
    0xcf5da680U,
    0x35726740U,
    0xcceba620U,
    0x2a3d67d0U,
    0x3b8326d8U,
    0xc3c8274cU,
    0xd02306aeU,
    0x629dd741U,
    0x44568e31U,
    0x2ffa0388U,
    0xceab08aaU,
    0xfadd9410U,
    0x27b5265cU,
    0x554727c7U,
    0x1c6b86caU,
    0x83789791U,
    0x21eeae02U,
    0x85b3f3bbU,
    0x9a4880a3U,
    0x3ce54051U,
    0xa23820bcU,
    0x6f89f078U,
    0x41c388e6U,
    0xcf28d49eU,
    0x1a15063cU,
    0x6912d738U,
    0xef9e0ec6U,
    0x9bdf434eU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xd8000000U,
    0x34000000U,
    0xd6000000U,
    0x8d000000U,
    0xd3800000U,
    0xea400000U,
    0xfd600000U,
    0xca100000U,
    0x74180000U,
    0x85140000U,
    0xc920000U,
    0xd9d70000U,
    0x743a8000U,
    0x3ee9c000U,
    0x585ca000U,
    0x8d707000U,
    0x11074800U,
    0x1982ec00U,
    0x6d49ba00U,
    0xc9eddb00U,
    0x44d1ba80U,
    0xdfb9dbc0U,
    0xd0a3bae0U,
    0xfb3edb90U,
    0x26613a38U,
    0x54931ba4U,
    0x2dd79aeeU,
    0xc2306b29U,
    0xe3e0523dU,
    0x53d847c3U,
    0x533dc8c0U,
    0x3a6b2c09U,
    0x5e951a34U,
    0xcaddab4cU,
    0xa6b6f2d8U,
    0xb52b3705U,
    0xcc720014U,
    0xd087005fU,
    0x40c280c2U,
    0x72adc0abU,
    0x36a0b6U,
    0x48e37085U,
    0xe557c82dU,
    0xd6f82c58U,
    0x17459a36U,
    0x6e76b45U,
    0xfc5ad2cdU,
    0xe37187c8U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x48000000U,
    0x64000000U,
    0xfa000000U,
    0x17000000U,
    0xdd800000U,
    0xd0c00000U,
    0x9ba00000U,
    0x34f00000U,
    0xebf80000U,
    0x92740000U,
    0xd8b20000U,
    0xc41b0000U,
    0x656f8000U,
    0x3a51c000U,
    0xc98a6000U,
    0x32c91000U,
    0xc0a7c800U,
    0xe7714400U,
    0x9e3b3e00U,
    0xa7591100U,
    0x1b093e80U,
    0x738211c0U,
    0x85c6bee0U,
    0xed23d150U,
    0xefb4dea8U,
    0x299ec134U,
    0xda11652U,
    0x1df48523U,
    0x2b75a88fU,
    0x503c54f3U,
    0x6256f694U,
    0x25875507U,
    0xcccf809fU,
    0xbda1c0c5U,
    0x65f260efU,
    0xf77d1035U,
    0x1635c858U,
    0xa35a44ecU,
    0x710cbefeU,
    0x2c8cd17dU,
    0x3c495e02U,
    0xc7e401a9U,
    0x631cf651U,
    0xc0e855e8U,
    0x369200aaU,
    0x142b009dU,
    0xc7378003U,
    0x7fd5c0cbU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x88000000U,
    0x44000000U,
    0xa6000000U,
    0x6b000000U,
    0xcd800000U,
    0x47400000U,
    0x69e00000U,
    0x62300000U,
    0xa1380000U,
    0x78bc0000U,
    0x1f20000U,
    0x3f1d0000U,
    0xfaa58000U,
    0x95d9c000U,
    0x840fa000U,
    0x60b1000U,
    0x7b02c800U,
    0xb58f3c00U,
    0x8b4a6200U,
    0x8beae100U,
    0xaf386280U,
    0x7b7e140U,
    0xf27de260U,
    0x2f5e21b0U,
    0x34ca42e8U,
    0x39a931f4U,
    0x4c5a8a4eU,
    0xfd4b0d9fU,
    0x38ed6883U,
    0xbeb42cd8U,
    0xdaf0aa6aU,
    0x9a99ddfaU,
    0x9e000abU,
    0xd2300032U,
    0xc9380042U,
    0xccbc00f9U,
    0x2ff20076U,
    0x101d00b3U,
    0x91258011U,
    0xb999c0ddU,
    0x206fa068U,
    0x237b1026U,
    0xb3dac8e6U,
    0xaf033cf0U,
    0x2b806280U,
    0xcc4be1d2U,
    0x546fe2a8U,
    0xad73216fU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0xe8000000U,
    0xf4000000U,
    0x4a000000U,
    0x51000000U,
    0xae800000U,
    0xb5c00000U,
    0xb5a00000U,
    0x7a500000U,
    0x67580000U,
    0xdfdc0000U,
    0xe51a0000U,
    0x35370000U,
    0xed298000U,
    0xd09ec000U,
    0x3f766000U,
    0x23c17000U,
    0x7aa89800U,
    0x7fd44400U,
    0x1510de00U,
    0x6d359b00U,
    0x212ade80U,
    0x86929b40U,
    0xd07b5ee0U,
    0x96405b90U,
    0x30ef3e08U,
    0xd13a2b64U,
    0x6f2c2642U,
    0xc59baf35U,
    0xe3f918ecU,
    0xdb068480U,
    0xdf84bed9U,
    0xab4febbaU,
    0x3869c65eU,
    0xd3f31ff5U,
    0xa30e6033U,
    0xa38d70e4U,
    0xc54a98fcU,
    0xcb6f44d1U,
    0xd87b5e47U,
    0xf2405bc6U,
    0xf2ef3e4eU,
    0xa43a2bc2U,
    0x63ac26a3U,
    0xd55baf8bU,
    0xb2d91846U,
    0x459684a6U,
    0xa3fcbee1U,
    0xbb03ebbeU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xf8000000U,
    0x34000000U,
    0x76000000U,
    0x4d000000U,
    0x88800000U,
    0x93c00000U,
    0x9e200000U,
    0x5fd00000U,
    0x40d80000U,
    0x9b540000U,
    0x511a0000U,
    0xde710000U,
    0x7b4e8000U,
    0x7de5c000U,
    0xd9fea000U,
    0x9b0c7000U,
    0x558bf800U,
    0xb34f4400U,
    0x71e0e600U,
    0x7bf6fb00U,
    0x1002e680U,
    0x6803fbc0U,
    0x9c0e6660U,
    0xa033b70U,
    0xf7044698U,
    0x878b8b44U,
    0x20479eeeU,
    0xc8697f09U,
    0xdab02066U,
    0x12e9b09aU,
    0x1a755878U,
    0xd5433405U,
    0x54eb1ed8U,
    0x6f79bf2eU,
    0x89c200f1U,
    0x1250004U,
    0x4454809cU,
    0x6a94c044U,
    0xa43020d5U,
    0xc29b0c8U,
    0xecd55890U,
    0xa953345dU,
    0x72131e5fU,
    0x9ffdbf63U,
    0xee000088U,
    0x90000d9U,
    0xe68000d1U,
    0x5ac0001aU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0x68000000U,
    0x44000000U,
    0x32000000U,
    0x19000000U,
    0x5d800000U,
    0x52400000U,
    0x2b600000U,
    0x5c100000U,
    0xd9980000U,
    0x7dc0000U,
    0xcab20000U,
    0xa5a50000U,
    0x14bb8000U,
    0x6aa3c000U,
    0xf232e000U,
    0x64667000U,
    0xfa902800U,
    0x3752cc00U,
    0x7f7c9a00U,
    0xf1802b00U,
    0x64471a80U,
    0xe063eb40U,
    0x6895fa60U,
    0xbe559b30U,
    0x3afdd208U,
    0x8fcb5774U,
    0x392b483aU,
    0x97727c6dU,
    0xf585d2e7U,
    0xb647577fU,
    0x896148acU,
    0x5d1b7c13U,
    0xa814527dU,
    0x239d9760U,
    0xcada288dU,
    0xbd3bcca8U,
    0xc2ed1afeU,
    0x145aebfdU,
    0x4ffc7a40U,
    0x44435bfaU,
    0x306cb2afU,
    0x9092e7e9U,
    0xe25b80efU,
    0x24f3c0e9U,
    0xe0cae048U,
    0x4faa7096U,
    0x81ba2843U,
    0xd12bccfaU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x28000000U,
    0xcc000000U,
    0x4a000000U,
    0x63000000U,
    0x6e800000U,
    0x26400000U,
    0x3ee00000U,
    0xa1700000U,
    0x4bf80000U,
    0x5bb40000U,
    0x845a0000U,
    0x94ad0000U,
    0xf5978000U,
    0x198f4000U,
    0x26c1e000U,
    0x1da2d000U,
    0xa81fb800U,
    0xe94c9c00U,
    0xaa619200U,
    0x2c37d500U,
    0xa7961280U,
    0xbe8895c0U,
    0x5e4ff260U,
    0x4aee45b0U,
    0x7f724a48U,
    0x86fbd97cU,
    0xd03e5802U,
    0xe59e4c1fU,
    0x81862aecU,
    0x22cf49f9U,
    0xebad80b2U,
    0xa91240e8U,
    0x28ce60b1U,
    0xa8a990cfU,
    0x579c58b7U,
    0x56874c84U,
    0x724baa4eU,
    0x70ed0914U,
    0x347be0f2U,
    0x247fd02dU,
    0xbc703821U,
    0xb877dca8U,
    0x4e7a72b2U,
    0x4f780556U,
    0x8efe2acdU,
    0x8c3b4951U,
    0xf7978000U,
    0x68f40beU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x98000000U,
    0x6c000000U,
    0x16000000U,
    0x45000000U,
    0x5a800000U,
    0x77c00000U,
    0x93e00000U,
    0xc9d00000U,
    0x5580000U,
    0xf7940000U,
    0x1ef60000U,
    0x70eb0000U,
    0x7e5a8000U,
    0x2c184000U,
    0x21b72000U,
    0xe3cc7000U,
    0xd9e55800U,
    0xf2d16400U,
    0x3ed5fa00U,
    0x38dd5700U,
    0xc5d77a80U,
    0x235117c0U,
    0xda965aa0U,
    0x60766710U,
    0xe5298238U,
    0xd2bf437cU,
    0xec4b582eU,
    0x4cae6439U,
    0xaaf97af4U,
    0xeaee178eU,
    0xdd5adac7U,
    0x7b952757U,
    0xf8fc227aU,
    0x7def731cU,
    0xd0d720eaU,
    0x21dc7045U,
    0xe15d5858U,
    0x3595649bU,
    0xf1fbfa90U,
    0xe1625716U,
    0x7a1bfac7U,
    0x84b25776U,
    0x4943fad4U,
    0xe626575cU,
    0x9535fab3U,
    0x8d0d5738U,
    0x6e8f7ab3U,
    0x2dc5171bU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0xb8000000U,
    0x54000000U,
    0xce000000U,
    0x93000000U,
    0xa1800000U,
    0xe3400000U,
    0x76600000U,
    0x13b00000U,
    0xc8380000U,
    0x66740000U,
    0xfa920000U,
    0x2fef0000U,
    0x4fc8000U,
    0xc05dc000U,
    0x8ecb2000U,
    0x7f211000U,
    0x30d18800U,
    0xd50f7c00U,
    0xce88ba00U,
    0xcdd100U,
    0x4c2c3a80U,
    0x215411c0U,
    0x5e4d1ae0U,
    0x54ee0110U,
    0x89721258U,
    0xd913bd44U,
    0x75ad0896U,
    0xe612bcd7U,
    0xee239ab7U,
    0xe85cc1f4U,
    0xc2c5b221U,
    0x552f6df7U,
    0x5d7a031U,
    0xb8cd015U,
    0x1642a83dU,
    0xc8ea6c3dU,
    0x1b733236U,
    0xb819ad5dU,
    0x652a0057U,
    0xaddb0046U,
    0x878e80f7U,
    0x5c42c065U,
    0x2defa072U,
    0x7df8d04bU,
    0x34d0a8c0U,
    0x63056c51U,
    0x698fb2b3U,
    0xbf446dacU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0xb8000000U,
    0x4000000U,
    0x3e000000U,
    0x3b000000U,
    0x2e800000U,
    0x80400000U,
    0x5a00000U,
    0x8df00000U,
    0x51780000U,
    0x88340000U,
    0xb2160000U,
    0x1c250000U,
    0x61368000U,
    0xf592c000U,
    0x1bef2000U,
    0x43559000U,
    0x6a0bf800U,
    0x6d0e3c00U,
    0xb980c600U,
    0x1cc2c900U,
    0x3cee4680U,
    0xa7d409c0U,
    0x774f66a0U,
    0x492099f0U,
    0x1cbc1e18U,
    0xf75d65f4U,
    0x2c0b7826U,
    0x7209fccfU,
    0x99016688U,
    0x1f81998fU,
    0x13c49e2dU,
    0x946ea5f2U,
    0x189cd8e4U,
    0x626fac4eU,
    0x7f9d3e50U,
    0x66e9f5adU,
    0x72d80081U,
    0xcac40013U,
    0x6bee00a9U,
    0x1b5100a9U,
    0x7e008031U,
    0xdb07c0ceU,
    0x3e81a0c3U,
    0x84350f9U,
    0xb9aad839U,
    0xb7faac81U,
    0x5473be4eU,
    0x9dbf35fbU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x38000000U,
    0xac000000U,
    0xda000000U,
    0x3b000000U,
    0x73800000U,
    0xa400000U,
    0xbd600000U,
    0x95100000U,
    0x8d980000U,
    0xac540000U,
    0x77e0000U,
    0xdd0f0000U,
    0x6a848000U,
    0x4ec24000U,
    0xea5e000U,
    0x21375000U,
    0x7a6be800U,
    0x64958c00U,
    0xa0ddfa00U,
    0x90b01b00U,
    0x37277a80U,
    0xe87d5bc0U,
    0xb8861a20U,
    0x31c84bd0U,
    0x93281218U,
    0x767a977cU,
    0x6d8600c2U,
    0x1f4b0047U,
    0x33e28031U,
    0x25d9408dU,
    0xe63f602cU,
    0x8bea1008U,
    0x49d28899U,
    0x9c349c08U,
    0xa0edf244U,
    0x25dc7eeU,
    0x3a75e8ddU,
    0xc78a8c6aU,
    0xac417a4eU,
    0xc4665b0eU,
    0x619c9aa1U,
    0x16550bbaU,
    0x8c717244U,
    0x868b8770U,
    0xf4ce0888U,
    0x85a2dc4bU,
    0x7ab612aaU,
    0xe425973fU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xf8000000U,
    0xe4000000U,
    0x62000000U,
    0xdf000000U,
    0x8d800000U,
    0xfd400000U,
    0x1600000U,
    0x2bd00000U,
    0xe5580000U,
    0xd3940000U,
    0xb2b60000U,
    0x9a830000U,
    0xdcc48000U,
    0xf226c000U,
    0xdbb2e000U,
    0xe2021000U,
    0x1f014800U,
    0xad8edc00U,
    0xad4fea00U,
    0xf96a2700U,
    0xcfdd6a80U,
    0x875fe7c0U,
    0xc930aa0U,
    0x3f3f3790U,
    0x67cea258U,
    0xdda4fb74U,
    0xd9f2803aU,
    0x3ee5c0abU,
    0x31966037U,
    0xadb4d096U,
    0x370ba816U,
    0x7188ccedU,
    0xb40a20bU,
    0x1463fbdaU,
    0x6558005bU,
    0x1394005fU,
    0x92b600aaU,
    0xca8300c0U,
    0x24c480a8U,
    0x1626c0bdU,
    0xb9b2e0c8U,
    0x3d0210f8U,
    0x92814838U,
    0x50cedcb9U,
    0xac2feaa7U,
    0xd2ba271aU,
    0x2a856a14U,
    0x54cbe7ffU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x98000000U,
    0xd4000000U,
    0x6e000000U,
    0x1f000000U,
    0xf800000U,
    0x4ac00000U,
    0x3de00000U,
    0x2b500000U,
    0x47d80000U,
    0x709c0000U,
    0x9ab60000U,
    0x36870000U,
    0xf6468000U,
    0x72afc000U,
    0xa5732000U,
    0xdebd000U,
    0xe35ea800U,
    0xabd14400U,
    0xda9b7a00U,
    0x73babf00U,
    0xf20bfa80U,
    0xdd027f40U,
    0x1a865a20U,
    0xbc4a6f50U,
    0x2ba5d2b8U,
    0xe9fbfb84U,
    0x6aa880d6U,
    0x3174c09bU,
    0xc3e3a059U,
    0xec531091U,
    0x3c5308c4U,
    0x445954aaU,
    0x2058f21bU,
    0xc65b2b0eU,
    0x955ea86fU,
    0x20d14467U,
    0x1b1b7ab6U,
    0x367abf0fU,
    0x586bfa96U,
    0x68927fadU,
    0xebe5a64U,
    0xf8866fadU,
    0xf94bd2ddU,
    0xe520fb69U,
    0x3bb80085U,
    0x5e0c00b8U,
    0xd70e00cfU,
    0xe38b0058U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x28000000U,
    0x84000000U,
    0x9a000000U,
    0xfd000000U,
    0xd5800000U,
    0xc5c00000U,
    0x5b600000U,
    0x3fb00000U,
    0x9d380000U,
    0x98740000U,
    0x37520000U,
    0x9c4b0000U,
    0xb0a18000U,
    0xdbd5c000U,
    0xb6026000U,
    0x2300b000U,
    0xd2856800U,
    0x7d4e7400U,
    0x6329e200U,
    0x251f0900U,
    0x63e26280U,
    0xc7f5c9c0U,
    0xe79382e0U,
    0xf6abb950U,
    0x40d50ac8U,
    0xc880bdd4U,
    0x4043e052U,
    0xd6a57029U,
    0x70df0807U,
    0x108ac42cU,
    0x7c468a3cU,
    0xe0ae7d83U,
    0x93d80009U,
    0xa204005fU,
    0x910a0044U,
    0xab8f006eU,
    0x32cb8069U,
    0x5beac064U,
    0xabf1e036U,
    0x999e7001U,
    0x1a68836U,
    0x405b04dcU,
    0x5cceeaecU,
    0x44e1cd9fU,
    0x4f76e879U,
    0x7d0b4e4U,
    0xd00a0262U,
    0x880a7965U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x8000000U,
    0x24000000U,
    0xee000000U,
    0xcb000000U,
    0x1a800000U,
    0xdb400000U,
    0xd5600000U,
    0xdab00000U,
    0xf5380000U,
    0x67f40000U,
    0xf5a0000U,
    0xa9c10000U,
    0x5a298000U,
    0x9d7c000U,
    0x708f2000U,
    0x6e4c9000U,
    0x5cefb800U,
    0x87754c00U,
    0x39157a00U,
    0x692aa100U,
    0x1f5efa80U,
    0x31c861c0U,
    0x26225a60U,
    0x7bd23170U,
    0x798b4268U,
    0x75cc2d54U,
    0xb826a086U,
    0x58db509fU,
    0xf700981cU,
    0x4889dc84U,
    0x8242c229U,
    0x76ebedeeU,
    0x12718054U,
    0xe093c06dU,
    0x8ced20d5U,
    0xff79907fU,
    0xf51c387dU,
    0x13238c39U,
    0x3253da3eU,
    0xc441f162U,
    0x9e662e3U,
    0xbef5bd52U,
    0x6cda98faU,
    0x8108dc23U,
    0xff8b4217U,
    0xeacc2d42U,
    0xa4a6a035U,
    0xdc9b5022U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x68000000U,
    0x9c000000U,
    0x6e000000U,
    0x9f000000U,
    0xd3800000U,
    0x1c400000U,
    0xcea00000U,
    0xd7f00000U,
    0xc9780000U,
    0xa7bc0000U,
    0x41da0000U,
    0x134d0000U,
    0x45238000U,
    0x5fbe4000U,
    0x85d6a000U,
    0xe94c5000U,
    0x5829e800U,
    0x1532ec00U,
    0x49106600U,
    0x862e2900U,
    0xc231e680U,
    0x16916940U,
    0xec66c6e0U,
    0x67927930U,
    0xe0e00e88U,
    0xc85f85acU,
    0x420ca0e6U,
    0xb9015033U,
    0xc08a68b5U,
    0xb9ccac6fU,
    0xb9e6c61bU,
    0x38d279c8U,
    0xf3c00e3aU,
    0xecef85b3U,
    0xfe54a075U,
    0x490d504fU,
    0xe888680bU,
    0x45cdacd0U,
    0xa7e7464eU,
    0xcfdd3901U,
    0xbc4f2ee4U,
    0x9ea09573U,
    0xaff0682cU,
    0x4d71acdeU,
    0x3dbd4659U,
    0x2cd039f0U,
    0x31ccae31U,
    0x15eed515U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0xa8000000U,
    0xbc000000U,
    0x66000000U,
    0x3b000000U,
    0x1b800000U,
    0x66c00000U,
    0x74600000U,
    0xfb00000U,
    0x51780000U,
    0x111c0000U,
    0xf4aa0000U,
    0xd70000U,
    0x25418000U,
    0x76a04000U,
    0x39d12000U,
    0x47c31000U,
    0x12eae800U,
    0x79f9a400U,
    0xa05bf200U,
    0x1804e100U,
    0x40ad280U,
    0x1207f140U,
    0xb1003ae0U,
    0xee8e5510U,
    0xfa43c848U,
    0x6f26b4acU,
    0x261b1aaeU,
    0x312a45d7U,
    0x2910a055U,
    0xc0a350a1U,
    0xeadbc869U,
    0x804ab402U,
    0x42291a96U,
    0x9e9145c4U,
    0x8632037U,
    0x49b81065U,
    0x5a7968fbU,
    0xf292e451U,
    0x86615234U,
    0xaeb0b182U,
    0x77f09ab9U,
    0x75d0522U,
    0x55800084U,
    0xa1c00050U,
    0x69e0002fU,
    0x27000e6U,
    0x969800b3U,
    0xc46c0035U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0xf8000000U,
    0x64000000U,
    0xa2000000U,
    0x73000000U,
    0xca800000U,
    0x3bc00000U,
    0x5ca00000U,
    0x1c700000U,
    0x33b80000U,
    0x15140000U,
    0xce6a0000U,
    0x5d510000U,
    0x9c8a8000U,
    0x2c6c000U,
    0xa92de000U,
    0xe3385000U,
    0x19d63800U,
    0x2a4a6400U,
    0xc1e2fe00U,
    0xa51d8100U,
    0xf66f1e80U,
    0xd955d1c0U,
    0xe812660U,
    0x89cbb5f0U,
    0x7a9d898U,
    0x7af73494U,
    0x367446baU,
    0xfcb02527U,
    0xc9928010U,
    0xeca2c0ecU,
    0x247fe0d4U,
    0xb7bd5064U,
    0x8716b85dU,
    0x456da456U,
    0xf3dd9e03U,
    0x5471127U,
    0x2d66c62bU,
    0x7fd2e5b1U,
    0xeb4d60c7U,
    0x506f9050U,
    0xf8515807U,
    0xaf04f48aU,
    0x2c8126e5U,
    0x3acbb526U,
    0x2d29d85aU,
    0x713734dcU,
    0x92d446e6U,
    0x84c02501U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0xf8000000U,
    0xc000000U,
    0xca000000U,
    0x53000000U,
    0xef800000U,
    0x7ac00000U,
    0xde600000U,
    0x8b100000U,
    0xc5d80000U,
    0x3dbc0000U,
    0x9fa60000U,
    0xeff0000U,
    0x520c8000U,
    0xaf0a4000U,
    0x6d89e000U,
    0xcdc85000U,
    0xfe8e800U,
    0x64dca400U,
    0x6d301200U,
    0x70ebcb00U,
    0x1159f280U,
    0x1cf39b40U,
    0x5d091a20U,
    0xd2833f50U,
    0x584708d8U,
    0xce2bf45cU,
    0xa1347a92U,
    0x5aed2f4fU,
    0xf258005dU,
    0x1b7c0065U,
    0xd3c6005bU,
    0xcaef00b2U,
    0x4a54800cU,
    0xb77640c0U,
    0x9cfe04eU,
    0x61e750ebU,
    0xa9dc68e7U,
    0x7bae4e6U,
    0x84a7f27eU,
    0x5709be7U,
    0x16c39a75U,
    0xe4667f7bU,
    0x901a68b0U,
    0xce55e487U,
    0x79737279U,
    0xd4c6dbbbU,
    0xf36c7afeU,
    0x51912f6cU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x48000000U,
    0x94000000U,
    0xd6000000U,
    0xa1000000U,
    0x65800000U,
    0x7dc00000U,
    0x5fe00000U,
    0xd6b00000U,
    0x59780000U,
    0xf9940000U,
    0x1fa20000U,
    0xb8990000U,
    0x8a298000U,
    0xed52c000U,
    0x71cea000U,
    0xa5e13000U,
    0x1db3a800U,
    0xeff9d400U,
    0xded99a00U,
    0x6d0e1900U,
    0xff8f3a80U,
    0x86cb29c0U,
    0xa16692e0U,
    0x65fffdf0U,
    0xfdd488a8U,
    0x1f8a2464U,
    0x76c492feU,
    0x8966fd05U,
    0xc1fd087bU,
    0x63d8e488U,
    0x2a8a328cU,
    0xc547cd3aU,
    0x55aea0abU,
    0xfb913006U,
    0xc8aba8afU,
    0x2c1dd406U,
    0xea639ae1U,
    0x13731945U,
    0xba9cbaedU,
    0x5d24e947U,
    0x79dbb23aU,
    0x11810dd3U,
    0x5bc2005aU,
    0xd6e9002dU,
    0x17318011U,
    0xbab6c015U,
    0x9374a015U,
    0x7a9c30dbU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x8000000U,
    0x6c000000U,
    0x7a000000U,
    0x77000000U,
    0x74800000U,
    0x9c00000U,
    0xabe00000U,
    0xff900000U,
    0x51580000U,
    0xa6340000U,
    0x4c6a0000U,
    0x54db0000U,
    0x1e7f8000U,
    0x61cb4000U,
    0x97e3e000U,
    0x6d911000U,
    0xda561800U,
    0xa0b2e400U,
    0x5ea60a00U,
    0xf1be0b00U,
    0x9f2fea80U,
    0xeff41bc0U,
    0xc7867260U,
    0xdb4dbf50U,
    0xd7239868U,
    0xa3f2a43cU,
    0xcd826a92U,
    0x34405b8bU,
    0xc7a81286U,
    0xbc38efd2U,
    0x6b63e0c5U,
    0xc85110d1U,
    0xebb61866U,
    0xb822e4acU,
    0x737e0ac4U,
    0x324a0b16U,
    0x2a5ea8dU,
    0x33bf1b2dU,
    0xfc21f27aU,
    0x1572fffeU,
    0xa74a78c1U,
    0x6528b4c9U,
    0x58f3f29cU,
    0x530dff45U,
    0x4287f8cfU,
    0x74ccf459U,
    0x306592caU,
    0xe6dcafd8U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x8000000U,
    0x7c000000U,
    0x5a000000U,
    0x33000000U,
    0xb8800000U,
    0x92c00000U,
    0x2fe00000U,
    0xafd00000U,
    0xdc180000U,
    0x447c0000U,
    0x3be60000U,
    0xf9d70000U,
    0x8d1b8000U,
    0x2bf24000U,
    0x3fa4e000U,
    0x51f65000U,
    0xdca69800U,
    0x417bd400U,
    0xa260ba00U,
    0x3c9d7f00U,
    0x42ba5a80U,
    0x2002f40U,
    0xa7014220U,
    0xae8ebbd0U,
    0x63c69828U,
    0xd06bd4acU,
    0xa398baf2U,
    0x8317fdfU,
    0x4fc45a6aU,
    0x626b2f9dU,
    0xdc9cc2edU,
    0x72bbfbdeU,
    0x9a01f863U,
    0xd303c4d5U,
    0x8884c23aU,
    0xac7fbcdU,
    0x5be7f800U,
    0x89d4c40bU,
    0xb51f42e4U,
    0xcff5bb1dU,
    0x11a318adU,
    0x44f2947eU,
    0xd21da73U,
    0x58326f9dU,
    0xa7c5a266U,
    0x2e68eb47U,
    0x1e98009bU,
    0x35bc005fU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0xf8000000U,
    0x1c000000U,
    0x62000000U,
    0x77000000U,
    0xf3800000U,
    0x93c00000U,
    0xcb600000U,
    0x3500000U,
    0x19980000U,
    0xf4740000U,
    0x6a0000U,
    0xe2d70000U,
    0xb55c8000U,
    0x789f4000U,
    0x16f26000U,
    0x392f9000U,
    0xa4f6e800U,
    0x762c3400U,
    0xab7bd200U,
    0xd7ecaf00U,
    0xef1bb280U,
    0x3b303fc0U,
    0x743da60U,
    0x73204b90U,
    0xf7fce898U,
    0x1bab348cU,
    0x7dbf527aU,
    0x6007ef3bU,
    0x9003d2e9U,
    0x1808af38U,
    0x4c09b23aU,
    0x9a033f77U,
    0x6b0d5ab9U,
    0x918c0be8U,
    0xe4c00828U,
    0x38e8e4eeU,
    0x90955a25U,
    0xd2f80bc6U,
    0xf72a0881U,
    0x19ffe498U,
    0x16a9daa4U,
    0xb5374b74U,
    0x9a406840U,
    0xa3a474c2U,
    0x41b53205U,
    0xb20c7fd0U,
    0x4f073a72U,
    0xf879b87U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0x48000000U,
    0xbc000000U,
    0x2000000U,
    0xdf000000U,
    0xb8800000U,
    0xb1c00000U,
    0xc8600000U,
    0x77d00000U,
    0x8f180000U,
    0xcefc0000U,
    0xc5620000U,
    0xf85b0000U,
    0xca538000U,
    0xed524000U,
    0x51dd6000U,
    0x6151000U,
    0xe771d800U,
    0x49212400U,
    0x12787200U,
    0xc2a57700U,
    0xb13f1280U,
    0xc8076740U,
    0xfc074a60U,
    0xe2030350U,
    0xcf0bd828U,
    0xf08624ecU,
    0xdc9f2aaU,
    0xca6c3773U,
    0xa8d1f272U,
    0x37903792U,
    0x7f33f212U,
    0xd0b3749U,
    0x8f8072d7U,
    0x454977e4U,
    0x23a512a8U,
    0x94b06772U,
    0xfe4eca12U,
    0x2d264359U,
    0xa47f3804U,
    0x43a674e6U,
    0xc4b4ca29U,
    0x564143d9U,
    0x812eb854U,
    0xee7f345eU,
    0x20a22a56U,
    0x7e3a1391U,
    0x38800036U,
    0xf1c0000fU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xa8000000U,
    0x94000000U,
    0xde000000U,
    0x11000000U,
    0xf1800000U,
    0xb8c00000U,
    0x95200000U,
    0xad700000U,
    0x94380000U,
    0x71d40000U,
    0x4d8e0000U,
    0x32c50000U,
    0xfa238000U,
    0x7df0c000U,
    0x75762000U,
    0xc831b000U,
    0xabdde800U,
    0x1a888400U,
    0xee424600U,
    0xf962c900U,
    0x9f17e680U,
    0xada3b9c0U,
    0xb83c2e20U,
    0x63da8df0U,
    0x1e838088U,
    0xa840c064U,
    0xd46e20d6U,
    0x2495b0b5U,
    0xda6be887U,
    0xcd99843dU,
    0x87efc6baU,
    0xa7570904U,
    0xe1c24670U,
    0xa0a2c9a4U,
    0xf3b7e66cU,
    0x1c13b91eU,
    0xcf242eabU,
    0x3a7e8d5aU,
    0xe8b58094U,
    0x4291c0f2U,
    0x763a003U,
    0x7e1070a2U,
    0x54264822U,
    0xa4fcf4bbU,
    0x80f20ef4U,
    0x36ff3d3bU,
    0x13f068f4U,
    0xc7d44a1U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x88000000U,
    0x2c000000U,
    0x66000000U,
    0x75000000U,
    0xe3800000U,
    0x2fc00000U,
    0xbaa00000U,
    0xeed00000U,
    0xea980000U,
    0xf3f40000U,
    0xd1820000U,
    0x58cd0000U,
    0x6298000U,
    0x419d4000U,
    0x61742000U,
    0x47c7f000U,
    0x26a50800U,
    0x60da9400U,
    0xc390ee00U,
    0xfe79fb00U,
    0xa74d4e80U,
    0x67e34bc0U,
    0xb23c66e0U,
    0xf22e2fb0U,
    0x53918068U,
    0xc679409cU,
    0x634e208eU,
    0x5deef029U,
    0x2936880dU,
    0x48aed476U,
    0xf9d74e3fU,
    0x261a4bb4U,
    0xd4b7e633U,
    0x766e6ff2U,
    0x8af42061U,
    0x8407f0f5U,
    0x9a0508d5U,
    0x8b0a94b6U,
    0x4288ee58U,
    0xe4dfb07U,
    0xaa6f4e44U,
    0xa4fe4bfcU,
    0xbd0de63dU,
    0x6f876fa8U,
    0x59c7a07aU,
    0x37a3b078U,
    0xa95aa863U,
    0x8f5d24e9U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0xb8000000U,
    0x9c000000U,
    0xc6000000U,
    0xb5000000U,
    0xab800000U,
    0x79400000U,
    0xc600000U,
    0x78b00000U,
    0xe2780000U,
    0xc35c0000U,
    0x65860000U,
    0x38470000U,
    0xe5e88000U,
    0x7efb4000U,
    0x8e962000U,
    0x4022f000U,
    0x9f538800U,
    0x438d7c00U,
    0xbd4b6a00U,
    0x66689900U,
    0x23b5ca80U,
    0xd8f12940U,
    0x4b906220U,
    0x63aea5d0U,
    0x52108098U,
    0xade7404cU,
    0x2af020deU,
    0x5c95f0b9U,
    0x872308d5U,
    0x63da3c50U,
    0x7e434a61U,
    0x10e169b4U,
    0x7570c2c5U,
    0x67dc1582U,
    0xf443a8abU,
    0x7be88c53U,
    0x67f0627aU,
    0xcb1ea589U,
    0xa86880f0U,
    0x62bb406fU,
    0x31762039U,
    0x4dd2f021U,
    0xf4b88b3U,
    0xd1617cf8U,
    0x57356a29U,
    0x513399f3U,
    0x43b4a79U,
    0x9fbd691fU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0xe8000000U,
    0xc4000000U,
    0x3e000000U,
    0x47000000U,
    0xf4800000U,
    0x83c00000U,
    0xdc600000U,
    0xb5d00000U,
    0x74980000U,
    0x38340000U,
    0x23060000U,
    0x7a890000U,
    0xccb8000U,
    0x9ce5c000U,
    0xe0112000U,
    0x2bf3d000U,
    0x476cd800U,
    0x935d0400U,
    0x6a57b200U,
    0x19d32700U,
    0x4e951280U,
    0x613137c0U,
    0xe08eeaa0U,
    0xe5c6e3b0U,
    0x97660048U,
    0xcb590074U,
    0x665380f6U,
    0x93d1c0f3U,
    0xdf972022U,
    0x16bad000U,
    0xa9c75816U,
    0xfd68c471U,
    0xa5e925cU,
    0x89d4f70eU,
    0xf69fca0bU,
    0x3d353337U,
    0xf28ad8fbU,
    0x58c4046eU,
    0x1ae43207U,
    0xfb12e779U,
    0xcd7a32fdU,
    0x79afe767U,
    0xc2b7b2a7U,
    0xefc327d5U,
    0xc66d1203U,
    0x9cd537a9U,
    0x5f10ea1aU,
    0x637be323U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x28000000U,
    0x14000000U,
    0x92000000U,
    0xbd000000U,
    0xa0800000U,
    0xe400000U,
    0x94e00000U,
    0xe6500000U,
    0x5d980000U,
    0x33bc0000U,
    0x7d460000U,
    0x5f650000U,
    0x5f938000U,
    0x56b0c000U,
    0x41c6e000U,
    0x672db000U,
    0xcc79f800U,
    0xb960bc00U,
    0x20946200U,
    0x733daf00U,
    0x63070280U,
    0x5385df40U,
    0x85cb9a20U,
    0x8d2813f0U,
    0x5d78e008U,
    0x7e4b0e4U,
    0x3dd4781aU,
    0x7c597c19U,
    0x49f021aU,
    0x8939dfa7U,
    0x6a0d9a26U,
    0xd10d1315U,
    0x1e8b6049U,
    0xad44702bU,
    0x276a983cU,
    0x7398cc2eU,
    0x48b8fac5U,
    0x52c06393U,
    0xfcac78d1U,
    0x4db57c9dU,
    0x3e410246U,
    0xfce0dfd0U,
    0x52581accU,
    0x7f98d32cU,
    0xa6be001dU,
    0xc9c900b8U,
    0xc32d80ccU,
    0x7679c00eU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x68000000U,
    0xb4000000U,
    0xfa000000U,
    0xcf000000U,
    0xb9800000U,
    0x67c00000U,
    0x27600000U,
    0x3d700000U,
    0xf8380000U,
    0xeb1c0000U,
    0x61c60000U,
    0x16610000U,
    0x79f38000U,
    0xad7ac000U,
    0x803e6000U,
    0x671e1000U,
    0xb7c1c800U,
    0xff669400U,
    0x41775200U,
    0x4632bd00U,
    0xb61cb280U,
    0xa3476d40U,
    0x32289a20U,
    0xf65929b0U,
    0xee66048U,
    0x22b21004U,
    0x535fc832U,
    0x6b948bU,
    0x70fad22bU,
    0xc5f57d1cU,
    0xf37752e4U,
    0x8d32bdd5U,
    0x3d9cb246U,
    0x4f876d01U,
    0x3ec89af6U,
    0xd7e929c4U,
    0x923e6052U,
    0x5c1e109bU,
    0x5441c813U,
    0xa7a69430U,
    0xb7975242U,
    0xa882bd14U,
    0x9344b26aU,
    0xba2b6de0U,
    0x12569a67U,
    0x6ce4290dU,
    0x31b3e04aU,
    0xa4d9d07aU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xc8000000U,
    0xec000000U,
    0x42000000U,
    0x1f000000U,
    0x77800000U,
    0xe5c00000U,
    0xe8600000U,
    0xa9500000U,
    0x70180000U,
    0x9c340000U,
    0x71c20000U,
    0x1e6f0000U,
    0xb05f8000U,
    0xe69f4000U,
    0x9b726000U,
    0xf8e91000U,
    0x8f1da800U,
    0x7bbf5400U,
    0x3c04e200U,
    0x4a062f00U,
    0x930b0280U,
    0x658f7fc0U,
    0x32c34ae0U,
    0x73e27b90U,
    0xe926028U,
    0x8779107cU,
    0x42e5a8eaU,
    0xe41b54a3U,
    0x6a3ee2fdU,
    0x68cd2f16U,
    0x88ee825dU,
    0xb71b3f93U,
    0x6fb4aa0fU,
    0xa0f2b40U,
    0x330028c1U,
    0x558f1457U,
    0xaac9025bU,
    0x57e07fc7U,
    0xa09cca27U,
    0xda7d3bd6U,
    0x2a600099U,
    0x765000a6U,
    0x6798006fU,
    0x29f400a5U,
    0x51a20043U,
    0x5b3f008cU,
    0x82478019U,
    0x65ab40c2U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0xd8000000U,
    0xf4000000U,
    0x2e000000U,
    0x73000000U,
    0x1e800000U,
    0x67400000U,
    0x9f600000U,
    0xde700000U,
    0x7ab80000U,
    0x2f140000U,
    0xb7ce0000U,
    0x3b2b0000U,
    0xf79a8000U,
    0x3f87c000U,
    0xc8cc2000U,
    0xefa09000U,
    0xb5d93800U,
    0xe9652c00U,
    0x997d2a00U,
    0xea328500U,
    0xeb5d8a80U,
    0xee2ad5c0U,
    0x761c1220U,
    0x3c43a910U,
    0xbdeea0f8U,
    0x1b3350e4U,
    0x9cdb1856U,
    0x6aeebc57U,
    0x33be92e8U,
    0xdc9069e0U,
    0x150c802fU,
    0x2188c00aU,
    0xd3c0a05bU,
    0xad285046U,
    0x99988aU,
    0x70d7c3eU,
    0xf084b214U,
    0xb44ff958U,
    0x51e13816U,
    0x61312c4cU,
    0x11d32ab5U,
    0xdf698537U,
    0xbe7f0ac6U,
    0xab915f7U,
    0x271e327eU,
    0x9bc839b5U,
    0xe12d1815U,
    0xaa91bc84U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0x28000000U,
    0xec000000U,
    0xca000000U,
    0x51000000U,
    0x17800000U,
    0xf1c00000U,
    0x65200000U,
    0xc7500000U,
    0xd2180000U,
    0xcc740000U,
    0x524a0000U,
    0x5aed0000U,
    0x35738000U,
    0x69cb4000U,
    0x812ce000U,
    0xf1597000U,
    0x911fc800U,
    0x4efdf400U,
    0x920cf600U,
    0x55049b00U,
    0xd1819680U,
    0x9acfabc0U,
    0xbab3e60U,
    0xcd1d6f30U,
    0x8cff6048U,
    0x3f0230dcU,
    0x508b2802U,
    0xb540844dU,
    0xce613ef5U,
    0xa6306f4cU,
    0x3cace038U,
    0x619970a7U,
    0x2bbfc840U,
    0x646df40aU,
    0xc734f6cdU,
    0xe3209bbdU,
    0x8c5396ffU,
    0xac96ab6eU,
    0x1e32be91U,
    0xc8ab2f03U,
    0x8f980008U,
    0xacb400cdU,
    0xc0ea0052U,
    0x9c7d006bU,
    0xaa4b8075U,
    0x8eef4097U,
    0xcb7ee0c5U,
    0x36c0700cU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0xf8000000U,
    0x3c000000U,
    0x4e000000U,
    0x19000000U,
    0x56800000U,
    0x7e400000U,
    0x65200000U,
    0xa7500000U,
    0xe2780000U,
    0xb52c0000U,
    0xf5e0000U,
    0x36790000U,
    0x8f288000U,
    0x9c524000U,
    0xbfe2000U,
    0xf0edf000U,
    0xc8b6b800U,
    0xe14cac00U,
    0xaea44600U,
    0x5d9e9f00U,
    0x1e12fe80U,
    0xc0d23340U,
    0x5eb6b820U,
    0x344cacf0U,
    0xee244658U,
    0xb6de9f8cU,
    0x9bb2fe36U,
    0x3cc23365U,
    0xc16eb838U,
    0x4170ac97U,
    0x30a2466bU,
    0xec9b9f55U,
    0x9c9c7eb1U,
    0x84957377U,
    0xa89e18d5U,
    0xae9a1c14U,
    0x739c5eebU,
    0x571183ffU,
    0x7e582035U,
    0x54f8f01bU,
    0xdb603896U,
    0x2277ec45U,
    0x552ae62dU,
    0x1f5d2ff3U,
    0x7e7c667dU,
    0x4b266fbaU,
    0xee52c618U,
    0x5cf5dfe8U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x98000000U,
    0x34000000U,
    0xbe000000U,
    0x59000000U,
    0xff800000U,
    0x1fc00000U,
    0xae600000U,
    0xb7700000U,
    0x1180000U,
    0xc26c0000U,
    0xdd7e0000U,
    0xd61b0000U,
    0x6cec8000U,
    0x9134c000U,
    0xedb3a000U,
    0x92f2f000U,
    0x81d6a800U,
    0xce89a400U,
    0x3c4bea00U,
    0x93a23900U,
    0xc21d4280U,
    0x2eb9d40U,
    0xf036a820U,
    0xb639a4d0U,
    0xab33ea38U,
    0x42be39a4U,
    0x387b42a6U,
    0x7b9c9d2dU,
    0x242861U,
    0xb7d66496U,
    0x7b8cca69U,
    0xe9c8090cU,
    0xfb664a09U,
    0x52fbc958U,
    0x61df6abdU,
    0xfe8af982U,
    0x3448e258U,
    0x3fae6d0bU,
    0x48128028U,
    0xe5efc0cbU,
    0x56bf20c9U,
    0x567630aaU,
    0x1a9d087bU,
    0x5ba754dfU,
    0x8e1b4291U,
    0xb8ec9da1U,
    0x1f3c2853U,
    0xbcba6414U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0xf8000000U,
    0xb4000000U,
    0x12000000U,
    0x39000000U,
    0x2d800000U,
    0x4bc00000U,
    0xa1e00000U,
    0xc8f00000U,
    0xf1180000U,
    0x3dec0000U,
    0xd6fe0000U,
    0xce170000U,
    0x6b668000U,
    0x71bac000U,
    0xbdbd6000U,
    0x5bb43000U,
    0xd0b38800U,
    0x943f0400U,
    0xa709200U,
    0x54501900U,
    0x2f431a80U,
    0x2faf1d40U,
    0xced38820U,
    0x6e0f0410U,
    0xd7089258U,
    0xba8c19e4U,
    0x51451a6aU,
    0xa0a41dcdU,
    0x9053081fU,
    0xd54ec462U,
    0xfaad72d4U,
    0x1555e967U,
    0xf6cd723aU,
    0xd665e938U,
    0x6357238U,
    0x7379e991U,
    0xd9d372e9U,
    0x3482e998U,
    0x764bf24cU,
    0xb22f2942U,
    0x8d1012adU,
    0xd3e1d9eaU,
    0x41fefa21U,
    0xd49aed61U,
    0x6a25e044U,
    0x2919f072U,
    0x99e8686dU,
    0x9cf1f423U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x98000000U,
    0x3c000000U,
    0xe2000000U,
    0xbb000000U,
    0x6c800000U,
    0x7a400000U,
    0xa0a00000U,
    0x70b00000U,
    0xcc180000U,
    0xcea40000U,
    0x71ba0000U,
    0x479d0000U,
    0xa6e8000U,
    0x88504000U,
    0xc700e000U,
    0x2e831000U,
    0x91413800U,
    0x642f8c00U,
    0xaef1be00U,
    0xb2bbb900U,
    0xe7108680U,
    0x6a2435c0U,
    0x9ff938e0U,
    0xa13b8cf0U,
    0x1fd3bef8U,
    0x71c2b90cU,
    0xa46406faU,
    0xe9597547U,
    0x7c8f586eU,
    0x724cdc31U,
    0x54a86634U,
    0x6b32506U,
    0x311a0096U,
    0xc72d00f9U,
    0x3e768053U,
    0x4af44078U,
    0xccbae02fU,
    0xee1e10f9U,
    0x15afb843U,
    0x2d3fcca3U,
    0xa5d15e87U,
    0x96c8a9b9U,
    0x1ae9be64U,
    0xb01fb9a9U,
    0x8caa86a8U,
    0x9ab93540U,
    0x8317b827U,
    0xd42bcc0aU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x68000000U,
    0x74000000U,
    0x72000000U,
    0x8b000000U,
    0x7f800000U,
    0x31400000U,
    0x43200000U,
    0x88700000U,
    0x49580000U,
    0x722c0000U,
    0x38f20000U,
    0x6d9f0000U,
    0x874b8000U,
    0xe223c000U,
    0x10f76000U,
    0x79901000U,
    0xe5428800U,
    0x1268c00U,
    0x1b7fb600U,
    0x3adc7d00U,
    0x2d653e80U,
    0xf6d6f140U,
    0x636888e0U,
    0xbd58c50U,
    0x9de63608U,
    0xd210bd64U,
    0x9601de9aU,
    0xd10921bfU,
    0xe08f60edU,
    0x2ccc10eaU,
    0x91688834U,
    0xc0d58cddU,
    0x82663610U,
    0xf350bd05U,
    0xbd21defcU,
    0x2d7921e5U,
    0xdbd76063U,
    0xd5e01066U,
    0xd61a8895U,
    0x9c0a8c05U,
    0x460db69eU,
    0x99037d98U,
    0xe48ebeccU,
    0x26c5314eU,
    0x667e87dU,
    0xb9599cbeU,
    0x4a2ebeb9U,
    0x44f5311bU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0x58000000U,
    0x1c000000U,
    0x6a000000U,
    0xff000000U,
    0xe9800000U,
    0x2400000U,
    0x5ea00000U,
    0xc5f00000U,
    0x4580000U,
    0x38240000U,
    0xb63e0000U,
    0x64b50000U,
    0x397e8000U,
    0xd0924000U,
    0xad4e6000U,
    0xdf2dd000U,
    0xa3b82800U,
    0xdcfb5c00U,
    0x30dcde00U,
    0xb8e9bd00U,
    0xdd5af680U,
    0x2ca7e1c0U,
    0xc6f8a8a0U,
    0x57dc1c30U,
    0x6d6c3e78U,
    0x45162decU,
    0xd50cbeb2U,
    0xf6816d23U,
    0x3bc45e23U,
    0xf4eafdcdU,
    0xdf54164fU,
    0xb7ad71ebU,
    0xa97060c8U,
    0x9898d02eU,
    0x3946a849U,
    0x1291c4dU,
    0x72b2be0aU,
    0xbc746d90U,
    0x4e1adecdU,
    0xf288bdcfU,
    0xadc276abU,
    0xb1e4a1a8U,
    0x61d648beU,
    0x18668c01U,
    0x839cf6d9U,
    0x96c6e1d4U,
    0xee6028c1U,
    0xd69f5cedU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0xa8000000U,
    0x34000000U,
    0x12000000U,
    0xbd000000U,
    0xb3800000U,
    0x50c00000U,
    0x6200000U,
    0x14d00000U,
    0xd7f80000U,
    0xbca40000U,
    0x259a0000U,
    0x5c110000U,
    0xedd18000U,
    0x1e7bc000U,
    0x56f6000U,
    0x72357000U,
    0xd082800U,
    0xbb85d400U,
    0xf4c05e00U,
    0x4c2ca700U,
    0x35d27680U,
    0x427873c0U,
    0x4363a8e0U,
    0x2d3f1430U,
    0xab86bec8U,
    0x6cc617c4U,
    0xb02f3e3aU,
    0xe3d9d749U,
    0x457a5e41U,
    0x79eda7ddU,
    0xdc7bf6fdU,
    0x4067b340U,
    0xcdb6c88bU,
    0x23cb6411U,
    0x8ea7169bU,
    0xc89c03c9U,
    0xd79a0047U,
    0xd111004fU,
    0x965180f8U,
    0x8abbc0d9U,
    0xb94f60e7U,
    0xefe57059U,
    0x7b7028f2U,
    0xeae1d4a0U,
    0x64fa5e68U,
    0x542da7d2U,
    0x9dbf630U,
    0xf477b330U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x38000000U,
    0x94000000U,
    0x2a000000U,
    0x77000000U,
    0xc8800000U,
    0x27400000U,
    0xcf600000U,
    0x42d00000U,
    0xeb80000U,
    0xdee40000U,
    0x58120000U,
    0xa51d0000U,
    0x8a9c8000U,
    0xd50c000U,
    0xf97ae000U,
    0xf2c75000U,
    0x77a83800U,
    0x32739c00U,
    0x2c429200U,
    0xf1e74300U,
    0x7498aa80U,
    0x7059dfc0U,
    0x16feb860U,
    0x950a5c70U,
    0x338ef2d8U,
    0x1c9d324U,
    0x3d24f292U,
    0x9e30d323U,
    0x1daa7282U,
    0x657d1320U,
    0xb4cc125fU,
    0x5eaa8381U,
    0x17fecab3U,
    0x8c8e4f0fU,
    0x454c60ecU,
    0xf46e90cfU,
    0x845c5827U,
    0x4cf90c9eU,
    0x3a0cca68U,
    0xdf034fa7U,
    0x3488e075U,
    0x114a5069U,
    0x3e6cb860U,
    0x43575c60U,
    0xbc72728aU,
    0x894913d3U,
    0x3a66129aU,
    0x15383e4U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x88000000U,
    0x84000000U,
    0xe6000000U,
    0xe5000000U,
    0x4a800000U,
    0x25c00000U,
    0xfd600000U,
    0x11700000U,
    0xb5180000U,
    0xe4ec0000U,
    0x233e0000U,
    0x8b350000U,
    0x3f338000U,
    0xf136c000U,
    0xe0372000U,
    0xc4b9b000U,
    0x807b3800U,
    0xd1995400U,
    0x2c7a00U,
    0x2d39900U,
    0xd2894280U,
    0xb9cfcd40U,
    0xc76eb820U,
    0x6e769430U,
    0xf096da28U,
    0xca9e9f4U,
    0xb216daeeU,
    0xed69e921U,
    0x976da8cU,
    0x6919e9f0U,
    0x7eeeda1fU,
    0x2c35e980U,
    0x46b0da06U,
    0x5370e9a4U,
    0x861b5a92U,
    0x636a291bU,
    0xb8727ae5U,
    0x3d96991fU,
    0xb222c293U,
    0xf9d50db4U,
    0x7107980fU,
    0xb48a241fU,
    0x1cc66250U,
    0x2dea7d68U,
    0x3bb380c2U,
    0x85f6c0f4U,
    0x99d7202dU,
    0xe109b0fdU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x28000000U,
    0xc4000000U,
    0x9a000000U,
    0x9b000000U,
    0xbf800000U,
    0x60400000U,
    0xf8200000U,
    0x3b100000U,
    0xe2380000U,
    0x4dac0000U,
    0xf85e0000U,
    0x199d0000U,
    0x90f18000U,
    0xf48c000U,
    0x15a4e000U,
    0x54579000U,
    0xe79b8800U,
    0x61f69c00U,
    0x3c3d600U,
    0xe66db00U,
    0x563e5e80U,
    0xbfa14740U,
    0x7520820U,
    0xcc125cb0U,
    0x43b93688U,
    0x8cec4b34U,
    0xd4f45632U,
    0xd54f1b1fU,
    0x2ead3e05U,
    0x1bdf174bU,
    0xafdae04fU,
    0x5dda902fU,
    0xa2d20808U,
    0x77525cd9U,
    0xa4193617U,
    0x27bc4b6bU,
    0xe6ec5635U,
    0x67f31b96U,
    0xaecb3e00U,
    0xd4ee17fdU,
    0x78f56018U,
    0x2b4f502eU,
    0xdfa7687cU,
    0x175d0c9bU,
    0xb41e5e25U,
    0x5fb147ccU,
    0xfaea086eU,
    0x11fe5cc9U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x38000000U,
    0xdc000000U,
    0xaa000000U,
    0x29000000U,
    0xb2800000U,
    0x83c00000U,
    0xd6600000U,
    0x65300000U,
    0x80580000U,
    0x86e40000U,
    0xbf20000U,
    0x42b50000U,
    0xeb148000U,
    0x22444000U,
    0xe6266000U,
    0xb616b000U,
    0xceccf800U,
    0xd2ebf400U,
    0x85feaa00U,
    0xfdb32d00U,
    0xea985280U,
    0x209d9c0U,
    0xdd007860U,
    0x2c8bb4f0U,
    0xd4cacad8U,
    0x3e09decU,
    0xb782a12U,
    0xe4726d35U,
    0x2df2b278U,
    0x9bf295aU,
    0x7498e03cU,
    0x5503f0caU,
    0x88c1824U,
    0x42cc0426U,
    0xb0e0b2abU,
    0xa8fa29b2U,
    0x93460aeU,
    0xd253b06fU,
    0x93e07809U,
    0x237bb4c4U,
    0xd072ca4dU,
    0x53f49d19U,
    0x6eb22a01U,
    0x99136d20U,
    0xe74c32bbU,
    0xc6aa695aU,
    0xc0d8007aU,
    0x240021U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xa8000000U,
    0xb4000000U,
    0xe6000000U,
    0x15000000U,
    0x63800000U,
    0xf1c00000U,
    0xc5a00000U,
    0xedf00000U,
    0x6b580000U,
    0x682c0000U,
    0xfd320000U,
    0x4b7f0000U,
    0x71178000U,
    0x984bc000U,
    0x8b662000U,
    0xc4d2b000U,
    0x43efa800U,
    0xf928400U,
    0x8e093600U,
    0x810e8d00U,
    0xf58c9e80U,
    0x5ccf0940U,
    0xba2028e0U,
    0x4e354450U,
    0x5dfd16c8U,
    0xf3533da4U,
    0x42cb6ceU,
    0x173a4de1U,
    0xa47d3e65U,
    0x559679b4U,
    0xf909a0eeU,
    0xc98570f8U,
    0x7ec38880U,
    0xf1233434U,
    0x24bb1ebbU,
    0x9db4c973U,
    0x343e084cU,
    0x5afbf49aU,
    0x3d8be57U,
    0x9362b938U,
    0xe8d800b3U,
    0xc9ec00f1U,
    0xf09200acU,
    0x28f0030U,
    0x544f80b7U,
    0x5167c08fU,
    0xf3d420d5U,
    0x6b6db0b9U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0xa8000000U,
    0x9c000000U,
    0xea000000U,
    0xbf000000U,
    0x54800000U,
    0x12400000U,
    0x33a00000U,
    0xd5900000U,
    0x47380000U,
    0x2f2c0000U,
    0x6bd20000U,
    0x56990000U,
    0xa9b18000U,
    0x3a694000U,
    0x48f26000U,
    0x4f46d000U,
    0x142ef800U,
    0xc15f8c00U,
    0x9dd18e00U,
    0x4398fb00U,
    0x22357680U,
    0xca27740U,
    0xc11f78e0U,
    0x3576cc30U,
    0x6c83eec8U,
    0x164e2becU,
    0x8da38ec2U,
    0x6c91fb63U,
    0xeebcf65eU,
    0x4ae7379dU,
    0xf4bf182fU,
    0x1de91c6bU,
    0x5c3c9656U,
    0x95a8e7a9U,
    0x789860baU,
    0x88b3d008U,
    0xc7ed782fU,
    0x2b3fcc64U,
    0x2d2a6e69U,
    0x28db6b01U,
    0x981bee29U,
    0xacf22bddU,
    0xc1498eb8U,
    0x6524fbe3U,
    0x84df764eU,
    0xba177715U,
    0xfffcf8f3U,
    0xd7c68cb1U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x8000000U,
    0x7c000000U,
    0x72000000U,
    0xc3000000U,
    0x73800000U,
    0x50400000U,
    0x2de00000U,
    0x40300000U,
    0xfe580000U,
    0x5e2c0000U,
    0x75960000U,
    0xcf870000U,
    0x42498000U,
    0x1ee54000U,
    0xebbde000U,
    0xda139000U,
    0x7dc0c800U,
    0x84a31c00U,
    0x8154ea00U,
    0x3fa46500U,
    0x16dda280U,
    0x49e23940U,
    0x2634a8a0U,
    0xc355cc90U,
    0x44a9c228U,
    0xe154e9acU,
    0xcfa980faU,
    0xced540ffU,
    0x3de5e021U,
    0x283f9043U,
    0x7256c856U,
    0xf4241c6cU,
    0xc29d6aa1U,
    0xb20125ddU,
    0xa3004278U,
    0x8381a981U,
    0x884c60baU,
    0x59ead001U,
    0x4e33287fU,
    0x4f5b8c36U,
    0xeeaba299U,
    0x5655392eU,
    0xb225283fU,
    0x2f9c8c76U,
    0xa0822202U,
    0x4bc0796cU,
    0xf1a0c816U,
    0xc7d31c2cU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x58000000U,
    0x74000000U,
    0x5e000000U,
    0xa1000000U,
    0x23800000U,
    0x68c00000U,
    0xd7200000U,
    0x1b500000U,
    0xdbf80000U,
    0xd6640000U,
    0xabb20000U,
    0x2d050000U,
    0x198a8000U,
    0x1fccc000U,
    0x49a1a000U,
    0x221a7000U,
    0xef176800U,
    0xc6955400U,
    0x815bee00U,
    0xbcf7ff00U,
    0xc0e60680U,
    0x8efe6bc0U,
    0x6be44860U,
    0x8277e4f0U,
    0xe9a726b8U,
    0x3219db44U,
    0x67120086U,
    0xda950015U,
    0xf352809dU,
    0x37f8c0f9U,
    0x1c6ba0acU,
    0x64bb7007U,
    0xf78fe852U,
    0x26cc946cU,
    0xfe28ce53U,
    0x24d54f93U,
    0xc13acee5U,
    0x8a404fe9U,
    0x6c684eebU,
    0x1cb88f1bU,
    0x5383ee35U,
    0x10c3ff4dU,
    0x732c0611U,
    0x2d5f6b40U,
    0x56fcc84dU,
    0xdfee245dU,
    0x3c740656U,
    0x78ab6b5cU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x58000000U,
    0x24000000U,
    0x56000000U,
    0x41000000U,
    0x4e800000U,
    0x400000U,
    0xe7600000U,
    0x33700000U,
    0xc980000U,
    0xdeac0000U,
    0xabda0000U,
    0x2e450000U,
    0x12628000U,
    0xa3f9c000U,
    0x1dc2000U,
    0x5d48f000U,
    0xabe8b800U,
    0x9c3c8c00U,
    0xf074e200U,
    0xad126900U,
    0x2566da80U,
    0x3c7b2540U,
    0xc7141860U,
    0xf664bc70U,
    0x55f8fab8U,
    0x90dad514U,
    0x7bc4208eU,
    0xd7a4f025U,
    0x952b8f8U,
    0xd4098c71U,
    0xae0e62f1U,
    0xb507a917U,
    0x7080fa3dU,
    0x3d46d5ecU,
    0xdbe62089U,
    0x243df080U,
    0xe47238e6U,
    0xa3194caaU,
    0x406ac211U,
    0x24f39945U,
    0x8656e299U,
    0x5f8b69eeU,
    0x66c65a80U,
    0x7b2be5d1U,
    0x9610b807U,
    0x70e08c75U,
    0xf9b6e200U,
    0x6dbb69f3U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0xa8000000U,
    0x3c000000U,
    0x3e000000U,
    0x65000000U,
    0x92800000U,
    0x4ac00000U,
    0xfe00000U,
    0x52900000U,
    0xd9f80000U,
    0xd8ac0000U,
    0x82360000U,
    0x77cf0000U,
    0x196b8000U,
    0x925b4000U,
    0xe11d2000U,
    0xebb33000U,
    0xda82b800U,
    0x46cd6400U,
    0xe9ef8200U,
    0xf390bf00U,
    0xe17eba80U,
    0xf56a9b40U,
    0x445a18a0U,
    0x98161410U,
    0x17359a88U,
    0x5d46ab6cU,
    0xe7ab2016U,
    0xcfbc3019U,
    0x4089388cU,
    0xf9c6247fU,
    0xe46aa235U,
    0xe4df8f24U,
    0x51d20268U,
    0x2b54ffafU,
    0x7d901a69U,
    0x1c7eebf5U,
    0x83eb809cU,
    0xf49b409bU,
    0x58fd2097U,
    0xb02330a8U,
    0x7fab8bdU,
    0x8da164c9U,
    0xc8b98289U,
    0xf90fbf5aU,
    0xbc8d3a2dU,
    0xa7cddb6dU,
    0xf169388bU,
    0x8e5624c6U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0xd8000000U,
    0x4000000U,
    0x16000000U,
    0xe5000000U,
    0x78800000U,
    0xb0400000U,
    0x5600000U,
    0x5c300000U,
    0x3fd80000U,
    0x4aac0000U,
    0xea9a0000U,
    0x77470000U,
    0xe6e88000U,
    0x5df3c000U,
    0x28782000U,
    0x8cbeb000U,
    0x39b9800U,
    0x65ceec00U,
    0x51a38200U,
    0x1b10dd00U,
    0x85889a80U,
    0x6cc1f140U,
    0x53293860U,
    0x74589c50U,
    0xc76aba38U,
    0xd7384114U,
    0x565a204eU,
    0x5c65b0a1U,
    0x66b1188eU,
    0x44962c45U,
    0xc64922a5U,
    0xb06aade8U,
    0x1cbba2acU,
    0x9b9e6db3U,
    0x81cb02cdU,
    0x57a31dddU,
    0x2610bab1U,
    0xf90f4122U,
    0xca8aa05fU,
    0xb34a702aU,
    0x50eb3897U,
    0x48f39cdfU,
    0x98f83a07U,
    0xe0fc812eU,
    0x14f28028U,
    0xcaf4c0f8U,
    0xf3f0a09dU,
    0x997d70bcU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x28000000U,
    0x3c000000U,
    0x92000000U,
    0xb7000000U,
    0x60800000U,
    0xdc00000U,
    0xa8200000U,
    0x3100000U,
    0x2db80000U,
    0xea640000U,
    0xe2720000U,
    0xfd470000U,
    0x4def8000U,
    0x773f4000U,
    0xaca3e000U,
    0x58dcd000U,
    0x5498b800U,
    0x80faf400U,
    0xaf89ae00U,
    0x594c7b00U,
    0xfbe69680U,
    0xb63dcfc0U,
    0xed26d860U,
    0x49e64d0U,
    0x88fd76c8U,
    0x63851f2cU,
    0xf34c603aU,
    0x58e3904bU,
    0x78bb5812U,
    0xc5e624aaU,
    0x7b3116e0U,
    0xe6a68f32U,
    0xebd73897U,
    0xb215b49eU,
    0x94324e4fU,
    0x4224ab0aU,
    0x80142eafU,
    0x13343b75U,
    0xfaaaf63eU,
    0x89de5fa2U,
    0x3d1d8032U,
    0xe0b840c4U,
    0xe1ec6044U,
    0xd339036U,
    0xc7a3580fU,
    0xba5224dbU,
    0xc65b16faU,
    0x74558f76U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x98000000U,
    0xc000000U,
    0x6e000000U,
    0x15000000U,
    0x54800000U,
    0xa5c00000U,
    0xd1600000U,
    0x8900000U,
    0x78780000U,
    0x71a40000U,
    0x857a0000U,
    0x112d0000U,
    0x12b68000U,
    0x13474000U,
    0xcfa92000U,
    0xf8783000U,
    0xb1afd800U,
    0xe57c7400U,
    0x2128da00U,
    0x8ab13700U,
    0x1f4b8280U,
    0xa1a703c0U,
    0xed7cf8e0U,
    0xe52944f0U,
    0x40b182f8U,
    0xf04a033cU,
    0x822a7876U,
    0x673e04d9U,
    0xd000a25aU,
    0x68063380U,
    0xf407a09dU,
    0x520b7061U,
    0xe304f8a7U,
    0x4d8d445cU,
    0x9f4b8231U,
    0x61a703c9U,
    0x8d7cf8a8U,
    0xd52944dfU,
    0xd8b18291U,
    0xfc4a030fU,
    0xec2a7832U,
    0x723e04c8U,
    0x8480a2f4U,
    0xcdc63328U,
    0x2567a038U,
    0x5a9b70abU,
    0x9b7cf88eU,
    0x3c29449fU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x38000000U,
    0x54000000U,
    0x8a000000U,
    0x43000000U,
    0xba800000U,
    0xf1400000U,
    0x9f200000U,
    0x8e700000U,
    0xb8d80000U,
    0x56c0000U,
    0xa7d60000U,
    0xe9e70000U,
    0x39a8000U,
    0xb94cc000U,
    0x6324e000U,
    0x487d1000U,
    0xf5dfd800U,
    0x4ee39c00U,
    0xfb119600U,
    0xb7051d00U,
    0xa082ce80U,
    0xaa4d4140U,
    0xa1ad38a0U,
    0xcd398c90U,
    0x30f4ce18U,
    0xbb9a4184U,
    0xad4fb832U,
    0xc9294c57U,
    0xdb7e2e10U,
    0x775c5162U,
    0xeba4e09dU,
    0xee3d106bU,
    0x7a7fd88dU,
    0xa2d39c18U,
    0x5e69969dU,
    0x99591d49U,
    0xaaacce31U,
    0x8bb641ddU,
    0x7b9b8c2U,
    0x69be4c95U,
    0x68bcaeb6U,
    0x2d3c91e5U,
    0x80f60087U,
    0x73970012U,
    0x1142808fU,
    0x2f20c0deU,
    0x4672e0eaU,
    0x4da10bbU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xa8000000U,
    0x5c000000U,
    0x22000000U,
    0x2b000000U,
    0xaa800000U,
    0xd3400000U,
    0x3a200000U,
    0xd1b00000U,
    0xf0d80000U,
    0x774c0000U,
    0x3c2a0000U,
    0xbcb90000U,
    0xd7558000U,
    0xf3834000U,
    0x2acde000U,
    0x27e99000U,
    0x9ed59800U,
    0xe640dc00U,
    0xa9ad7600U,
    0xcb702900U,
    0x9f350e80U,
    0xc5996540U,
    0x506de060U,
    0x62199030U,
    0x94ad9848U,
    0x94fcdc2cU,
    0x7fff768aU,
    0x75752977U,
    0x36328e08U,
    0xd41f25b8U,
    0xf1a780f0U,
    0x7f764032U,
    0x1326082U,
    0xbc93d08aU,
    0x79edf846U,
    0x47da0cbcU,
    0x5fcd0e63U,
    0x546565b7U,
    0xf41fe0edU,
    0x21ac9096U,
    0x4772189eU,
    0x85369c17U,
    0x6a9f1653U,
    0x2ce3f9baU,
    0xe458f67fU,
    0xd03692aU,
    0x1780eef8U,
    0xccccf590U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0xc8000000U,
    0x14000000U,
    0xa2000000U,
    0x65000000U,
    0x74800000U,
    0x22c00000U,
    0x2ce00000U,
    0x80900000U,
    0x96b80000U,
    0x26c40000U,
    0x26e60000U,
    0x19f0000U,
    0xd8318000U,
    0xbd09c000U,
    0xc88d6000U,
    0x64c37000U,
    0x73e89800U,
    0x4d18a400U,
    0x76f38200U,
    0xefe2b700U,
    0x9b167a80U,
    0x41f963c0U,
    0x666d6020U,
    0x11537090U,
    0xf9d09868U,
    0xd1ca444U,
    0x16f5826aU,
    0x1fedb771U,
    0x31ffa56U,
    0x9df4a387U,
    0xd0660078U,
    0xd65f0032U,
    0xe85180d2U,
    0x5b59c0e2U,
    0x18d560daU,
    0xb3977056U,
    0x15369828U,
    0x2d83a4fbU,
    0xd0440248U,
    0xf124777bU,
    0x31f29a81U,
    0x3e67d34fU,
    0x6d569895U,
    0x1fd3a415U,
    0x21c027bU,
    0x13707756U,
    0xebac9a07U,
    0x683cd338U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x78000000U,
    0x9c000000U,
    0x6e000000U,
    0x3000000U,
    0xeb800000U,
    0xbf400000U,
    0x8ee00000U,
    0xf6500000U,
    0x4bf80000U,
    0xb54c0000U,
    0x3fe20000U,
    0x10dd0000U,
    0xac348000U,
    0x17624000U,
    0x641d2000U,
    0x4d93d000U,
    0xa7de0800U,
    0x3db10c00U,
    0x412d3a00U,
    0x407fdb00U,
    0xfa0e1280U,
    0xa90d0740U,
    0xca8520e0U,
    0xf1cfd0f0U,
    0x3d240818U,
    0xde700c2cU,
    0xe103ba16U,
    0x6e8c9b9fU,
    0x63c5b205U,
    0xe02197fcU,
    0x4ef28885U,
    0x29cf4cb9U,
    0x312a1addU,
    0x187d0b6fU,
    0xb6069ae2U,
    0xf034b7aU,
    0x2d81baf6U,
    0xe8419b4bU,
    0xef693235U,
    0xb81fd77fU,
    0x4395a8f0U,
    0x14dd9c5cU,
    0xae3a920fU,
    0x626f4748U,
    0xa09800dbU,
    0xf5c0078U,
    0x97a00d8U,
    0xc081004dU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x48000000U,
    0xe4000000U,
    0xa2000000U,
    0x4f000000U,
    0x6b800000U,
    0x6c400000U,
    0x29a00000U,
    0xf0f00000U,
    0x77180000U,
    0x514c0000U,
    0x152a0000U,
    0x4b310000U,
    0xccf38000U,
    0xc916c000U,
    0xf0466000U,
    0x87abd000U,
    0xe9f7c800U,
    0x499dbc00U,
    0xb588be00U,
    0x7d470500U,
    0x13211680U,
    0x463d6940U,
    0x18746060U,
    0x86d6d0b0U,
    0x51ae48a8U,
    0xfcfa7c14U,
    0x211d5eeaU,
    0x44a15abU,
    0x9da8be49U,
    0xaf70563U,
    0x64191622U,
    0x34c1692cU,
    0x70666076U,
    0xe41bd0f5U,
    0x74cfc868U,
    0x9061bc41U,
    0x141abe58U,
    0x3cca0545U,
    0x7460965cU,
    0xb616a9ddU,
    0x73cb804cU,
    0x1feac0b3U,
    0xda5460bfU,
    0x5a66d0caU,
    0xef1648e2U,
    0xad467c43U,
    0xb2f5eebU,
    0xfa3715e6U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x98000000U,
    0xb4000000U,
    0xa6000000U,
    0x1f000000U,
    0x68800000U,
    0x5ac00000U,
    0x57a00000U,
    0x51700000U,
    0xe2180000U,
    0xfcc0000U,
    0xd22e0000U,
    0x2a3f0000U,
    0x50f48000U,
    0x175ec000U,
    0x7e272000U,
    0x78309000U,
    0x49f9f800U,
    0x30d8e400U,
    0xd46e7600U,
    0xc15bbd00U,
    0xe928ae80U,
    0x9cbfc940U,
    0x51312020U,
    0x46739010U,
    0x469b7838U,
    0xb70524e4U,
    0xf48bd63eU,
    0x20c6edabU,
    0x92acf64eU,
    0xacf67d05U,
    0xdd550e1fU,
    0xd32e991bU,
    0xf9bb780dU,
    0xfcb524faU,
    0xe133d6aeU,
    0x2e7aeddeU,
    0x3a9af654U,
    0x3d057d8cU,
    0xf98f8e97U,
    0xf14f596bU,
    0xbfe8d852U,
    0xc91b74e8U,
    0x814d0e64U,
    0x37e2997eU,
    0x4515788bU,
    0xc34a24deU,
    0x16e7567dU,
    0x86942ddbU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x8000000U,
    0x34000000U,
    0x6e000000U,
    0xa3000000U,
    0xd9800000U,
    0xc9c00000U,
    0x23e00000U,
    0x7ef00000U,
    0x6ed80000U,
    0x8ec40000U,
    0x5c620000U,
    0xc03b0000U,
    0xaabd8000U,
    0x92f7c000U,
    0xfcdfa000U,
    0x97c3d000U,
    0x18e02800U,
    0x7b79c400U,
    0xad168200U,
    0x682ec100U,
    0x6c110a80U,
    0xd0a0d5c0U,
    0x6d5da060U,
    0x4a08d090U,
    0xe505a8e8U,
    0xfe8a0464U,
    0x264b2266U,
    0x75261197U,
    0xde94a237U,
    0x14ead1aaU,
    0xb976829aU,
    0xbc1ec127U,
    0x18a90a25U,
    0xb954d554U,
    0x7407a034U,
    0x4e07d049U,
    0x130228a9U,
    0x8182c45cU,
    0xf5cb02caU,
    0x79e90125U,
    0xb3f6aa9eU,
    0x145705b6U,
    0x9e87881dU,
    0xb64e147aU,
    0x9d2caa92U,
    0xba98057eU,
    0x72e00883U,
    0x2e76d486U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x18000000U,
    0xc000000U,
    0x22000000U,
    0xc5000000U,
    0x13800000U,
    0x2a400000U,
    0x3d200000U,
    0x6e900000U,
    0xff80000U,
    0x17440000U,
    0x92aa0000U,
    0x1ed10000U,
    0x8bde8000U,
    0x50554000U,
    0x7e10e000U,
    0x53b7000U,
    0x98a9e800U,
    0x6fdfdc00U,
    0xa65b1600U,
    0xf5190b00U,
    0x81ba1e80U,
    0x7c69a7c0U,
    0x673ae0e0U,
    0xfdaa70b0U,
    0x6c576878U,
    0xe41a9c7cU,
    0xdc33f63aU,
    0xc1267bc9U,
    0x9499f6b1U,
    0xa6f77b2fU,
    0x56c776ceU,
    0x65e23bf4U,
    0x3c7796caU,
    0xed094bc5U,
    0xa7867e47U,
    0x14429770U,
    0xb22f68d0U,
    0xac1e9c1dU,
    0x1839f681U,
    0xe7277ba8U,
    0x179f767dU,
    0x46763b30U,
    0x8405964fU,
    0x860c4ba2U,
    0x930afee7U,
    0x8882d728U,
    0xc6cb0869U,
    0xcde1accaU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0xe8000000U,
    0xac000000U,
    0xae000000U,
    0xa1000000U,
    0x90800000U,
    0x54c00000U,
    0x9a200000U,
    0x93100000U,
    0xcf80000U,
    0xd4c0000U,
    0xb2620000U,
    0x93f30000U,
    0xf4c38000U,
    0xea204000U,
    0x4b162000U,
    0x18fdf000U,
    0xe7419800U,
    0x11648400U,
    0xc750e00U,
    0x91890300U,
    0xb440b680U,
    0x16e37740U,
    0x1d37a0e0U,
    0x75eeb010U,
    0xa2b43888U,
    0x20a934fcU,
    0x44dab646U,
    0x395c770dU,
    0x431620beU,
    0xa4fdf0b5U,
    0xc141986aU,
    0x4c648497U,
    0xdaf50e7eU,
    0xc8490332U,
    0x10e0b690U,
    0x7033777fU,
    0x1b6fa036U,
    0xbf72b03dU,
    0x860e38adU,
    0x2d06349dU,
    0xe8336e6U,
    0x4dc33709U,
    0x4ea180e7U,
    0xc5d340a6U,
    0x99d5a026U,
    0xafddb0faU,
    0x7ad7b89cU,
    0x50597449U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0xa8000000U,
    0x24000000U,
    0x9a000000U,
    0x1000000U,
    0xe2800000U,
    0x29c00000U,
    0xcd600000U,
    0x8b300000U,
    0x90980000U,
    0xf440000U,
    0x2eaa0000U,
    0x8f5f0000U,
    0x4d2b8000U,
    0x8414c000U,
    0xc985e000U,
    0x524cb000U,
    0x7a22b800U,
    0xe997f400U,
    0xc1c56a00U,
    0x496a3500U,
    0xe1303280U,
    0xa99a71c0U,
    0x61ce60e0U,
    0xb9687050U,
    0xd93f58c8U,
    0x259f44b4U,
    0xdfcdd232U,
    0x2262c125U,
    0x3abed8f8U,
    0xeed484e8U,
    0x3b63b24fU,
    0x643ab132U,
    0x21198075U,
    0x710fc060U,
    0x1a846044U,
    0xc5c77011U,
    0xe36cd829U,
    0xb83f8406U,
    0x571a32d3U,
    0x5e05715cU,
    0xcb05e041U,
    0x2b8cb05dU,
    0x7f42b838U,
    0xd6a7f434U,
    0x635d6a55U,
    0x632e354fU,
    0xb71a327dU,
    0xe05710cU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0x78000000U,
    0x1c000000U,
    0x86000000U,
    0x21000000U,
    0x60800000U,
    0x3c400000U,
    0x80e00000U,
    0x92300000U,
    0xb6180000U,
    0xc48c0000U,
    0x64a0000U,
    0xd7ef0000U,
    0xbbb68000U,
    0x8ede4000U,
    0xe225a000U,
    0xb3907000U,
    0xb2431800U,
    0x95e74c00U,
    0xf0b38a00U,
    0x21518d00U,
    0xfbe3b280U,
    0xf5b8f140U,
    0x3bd68060U,
    0x70ae4050U,
    0x4cdda098U,
    0xe92c700cU,
    0xfc1118feU,
    0xbb844c3dU,
    0xabcf0ae6U,
    0x6520cd1dU,
    0x42109260U,
    0x6686c1eeU,
    0x5d483856U,
    0x657c06U,
    0xbe7f3228U,
    0x4ef9b11fU,
    0x4abda0c3U,
    0x365c7024U,
    0x3269185fU,
    0xdd784c30U,
    0x657d0ac8U,
    0xd973cd94U,
    0xaf741272U,
    0xe67b8183U,
    0xe2f118bbU,
    0x44b44cabU,
    0x63570a65U,
    0xb0eccd42U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x8000000U,
    0xfc000000U,
    0x5a000000U,
    0x41000000U,
    0x84800000U,
    0xa5400000U,
    0x6a200000U,
    0x7bb00000U,
    0xc8580000U,
    0x68840000U,
    0x874e0000U,
    0xff290000U,
    0xe93b8000U,
    0x7e174000U,
    0x3b2e6000U,
    0x873fb000U,
    0xb91d5800U,
    0x14ad9c00U,
    0xeffdb600U,
    0xefa7900U,
    0xfa750e80U,
    0x773f15c0U,
    0x511b80a0U,
    0x78a74070U,
    0xdf66028U,
    0xbbfbb04cU,
    0xd8f35852U,
    0xc9749cbdU,
    0xfebe36deU,
    0x22d939e4U,
    0xacd6e6eU,
    0xc2eda51eU,
    0xec535802U,
    0x96849c63U,
    0xf8463667U,
    0x24ad39dbU,
    0x27fb6ebcU,
    0xd2f0a5fcU,
    0x107ed8acU,
    0x3e3edc6dU,
    0x299dd644U,
    0x87ecc901U,
    0x26d3d626U,
    0x44c5c974U,
    0xb5e85624U,
    0xcbd2897aU,
    0x2463683U,
    0x15ad39dcU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x98000000U,
    0xc4000000U,
    0x6000000U,
    0xb000000U,
    0x4f800000U,
    0x35400000U,
    0x52600000U,
    0xb1700000U,
    0x3dd80000U,
    0xdd840000U,
    0x604e0000U,
    0xf2ef0000U,
    0x1db48000U,
    0xc9fdc000U,
    0xb5182000U,
    0xdfa6d000U,
    0x4bd74800U,
    0x5e892c00U,
    0x53c2b200U,
    0xd5a99100U,
    0xdad95a80U,
    0xf80badc0U,
    0xf40c80a0U,
    0x6e09c010U,
    0x870e20b8U,
    0x158dd014U,
    0xfc4dc89eU,
    0x10ebeccfU,
    0xc0b61249U,
    0x1576813eU,
    0xbd8329dU,
    0xbe8b5144U,
    0xa3cdfacfU,
    0x9da4bd7cU,
    0x86d5e865U,
    0x3a0d3cfbU,
    0xf9015ac3U,
    0x2a8fad24U,
    0xfdc280f9U,
    0x72a6c02cU,
    0x1f5aa0c5U,
    0x9c4010deU,
    0x20ede8a0U,
    0xa8b93c16U,
    0x99775a80U,
    0x51d4adb8U,
    0x778000a1U,
    0xe1400085U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x48000000U,
    0x74000000U,
    0x36000000U,
    0xe3000000U,
    0x7e800000U,
    0x70400000U,
    0xaf600000U,
    0xd6300000U,
    0xfd980000U,
    0x95840000U,
    0x1ac60000U,
    0xf9210000U,
    0x625f8000U,
    0x692bc000U,
    0x5a582000U,
    0xf52f5000U,
    0xa85ed800U,
    0x68266c00U,
    0x41ddb200U,
    0x50e27500U,
    0x7dfcca80U,
    0x573489c0U,
    0x26198020U,
    0x904ac070U,
    0x7f67a0e8U,
    0x8e3490c4U,
    0x719ef87eU,
    0x9f8d3c97U,
    0xbbc56a48U,
    0x52a51993U,
    0x8f9ef851U,
    0xc88d3c66U,
    0x53456af2U,
    0x71e519f3U,
    0x167ef82fU,
    0x1afd3cd8U,
    0x37bd6aeeU,
    0xd15119c3U,
    0x8fa0f88eU,
    0x6183c58U,
    0xe044eacbU,
    0x976bd918U,
    0x4a3f58a2U,
    0xf98ac69U,
    0x884121fU,
    0xf343e57bU,
    0xc1e3b272U,
    0x5e7775ffU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x38000000U,
    0xc000000U,
    0x9a000000U,
    0x8f000000U,
    0x8a800000U,
    0xc2c00000U,
    0xbb600000U,
    0x1db00000U,
    0xc9980000U,
    0x530c0000U,
    0x8820000U,
    0x31c70000U,
    0x83e28000U,
    0x64734000U,
    0x6e716000U,
    0x997d5000U,
    0x7ffa5800U,
    0x373f8400U,
    0x3b5f1a00U,
    0xa0622d00U,
    0x3134a280U,
    0x5654b940U,
    0xc9e200e0U,
    0xf3770050U,
    0x98fa8058U,
    0xe9bf401cU,
    0x7f9360a2U,
    0x360a5083U,
    0x2500d810U,
    0x4d80c44dU,
    0x6c4c7a31U,
    0xd7a87ddfU,
    0xbfd47af2U,
    0x4ba47d0eU,
    0x5dd67a21U,
    0xa8a37d32U,
    0x5d54fa53U,
    0xdd603d09U,
    0x60bd9aafU,
    0x98116d2eU,
    0x9d45c2d9U,
    0x5c29e9bfU,
    0x9e985837U,
    0x8588849bU,
    0x8459a30U,
    0x19ad6de9U,
    0xb6dfc22aU,
    0xec22e9dbU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x58000000U,
    0x5c000000U,
    0xae000000U,
    0x83000000U,
    0xc4800000U,
    0xd4400000U,
    0x18200000U,
    0xc7500000U,
    0xd8b80000U,
    0xdd0c0000U,
    0xf860000U,
    0x34c70000U,
    0x6e608000U,
    0xaa704000U,
    0x4672000U,
    0xbb76d000U,
    0x9dee7800U,
    0x20b00c00U,
    0x91034600U,
    0xd9893700U,
    0xbbcc9e80U,
    0x5ce8ab40U,
    0xa13e00a0U,
    0x76cb0010U,
    0x2b668078U,
    0x99f7400cU,
    0xeea7a0f6U,
    0x5e1690dfU,
    0xf711586aU,
    0x29adc57U,
    0x1f533edcU,
    0xc4b23b13U,
    0x53095840U,
    0xdc86dc5aU,
    0xa84d3ef7U,
    0xe6293bb9U,
    0x1c57d8b9U,
    0x403d9c82U,
    0xa74c9ee4U,
    0x94a8abc2U,
    0x371e0085U,
    0x629b0053U,
    0x6f5e809aU,
    0xccbb40edU,
    0x5701a06eU,
    0x2e8190d0U,
    0x8549d8a3U,
    0xa1a69c5aU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x18000000U,
    0xc000000U,
    0xb2000000U,
    0x9000000U,
    0xe0800000U,
    0x3cc00000U,
    0xbba00000U,
    0x6cb00000U,
    0x86580000U,
    0x5b040000U,
    0x39860000U,
    0xd4410000U,
    0x236a8000U,
    0x71114000U,
    0x5de3e000U,
    0x86d7b000U,
    0xb7cc9800U,
    0x8a2ac400U,
    0x1cf3f600U,
    0x33eb100U,
    0x9d100e80U,
    0x3fe385c0U,
    0x87de0020U,
    0xf3450070U,
    0x10ec80b8U,
    0x105040bcU,
    0x340960aaU,
    0xce06f005U,
    0x30f7852U,
    0x558d7435U,
    0x76476e5bU,
    0x82607550U,
    0x859df8bdU,
    0xdf2834f7U,
    0x867a8e1fU,
    0x32f2c53fU,
    0xd03de082U,
    0xc092b069U,
    0xeda0186cU,
    0xa3ba844eU,
    0xc1da9612U,
    0x9448413cU,
    0x43677622U,
    0x611af12cU,
    0xf5e76ec7U,
    0x92d0752bU,
    0x9c5f8a0U,
    0x312c3408U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0xe8000000U,
    0x74000000U,
    0xe2000000U,
    0xf000000U,
    0x20800000U,
    0x98c00000U,
    0x10e00000U,
    0xe6700000U,
    0xb3d80000U,
    0xda040000U,
    0x730e0000U,
    0x68b0000U,
    0xdc78000U,
    0xa369c000U,
    0xc8396000U,
    0xd6f6d000U,
    0x316f800U,
    0x9eed8400U,
    0xe77f8200U,
    0x5252e900U,
    0x83419a80U,
    0xaaaf7dc0U,
    0xd15800a0U,
    0x1dc40050U,
    0x8b6e00c8U,
    0x9c3b00e4U,
    0xa4ff800aU,
    0xe41dc07bU,
    0xca6f60c2U,
    0x9db9d097U,
    0x4dbf7830U,
    0x45bf447eU,
    0x81b962a3U,
    0x1bb9f93cU,
    0x88b80240U,
    0x3e3b291cU,
    0x4bf8fadeU,
    0x7499adf5U,
    0x2aaef88dU,
    0x11598451U,
    0x3dc982e1U,
    0x1b6de9a3U,
    0x74301a4eU,
    0xd0f9bdefU,
    0x610e016U,
    0xc56410d9U,
    0xbd301819U,
    0xd57694f7U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0xa8000000U,
    0x4c000000U,
    0x4e000000U,
    0x97000000U,
    0xc5800000U,
    0x7d400000U,
    0xa7600000U,
    0x3bf00000U,
    0x55280000U,
    0xf8040000U,
    0x84020000U,
    0xb2010000U,
    0xe1048000U,
    0xb6854000U,
    0xbac26000U,
    0x3227000U,
    0xce14b800U,
    0xd61e2c00U,
    0x770fea00U,
    0xe0933b00U,
    0x58dadf80U,
    0xfe2b2940U,
    0x2b800020U,
    0x3a400010U,
    0xeae00008U,
    0x9ab00024U,
    0x1448002aU,
    0x18f40013U,
    0x5aaa0013U,
    0xa0450025U,
    0x7e68031U,
    0x4234401fU,
    0xa98ee029U,
    0x7653300eU,
    0xa5fcd815U,
    0x9f395c3eU,
    0xdc1dd221U,
    0x3209572cU,
    0x7413d5b8U,
    0xab1f226dU,
    0x78c078eU,
    0x11577550U,
    0x787b521bU,
    0x967d1701U,
    0xd17d35bfU,
    0x9cfc124fU,
    0x3db8df8fU,
    0x7cda2959U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x38000000U,
    0x8c000000U,
    0x5a000000U,
    0x21000000U,
    0x3b800000U,
    0x38400000U,
    0xcbe00000U,
    0x69f00000U,
    0x2d980000U,
    0x2c040000U,
    0x6a060000U,
    0xe9070000U,
    0x9f808000U,
    0xd641c000U,
    0x3ce46000U,
    0x2972d000U,
    0xf590800U,
    0xe425dc00U,
    0xf057c200U,
    0x66895f00U,
    0xf7efcf80U,
    0xbddaacc0U,
    0x93e00020U,
    0x35f00030U,
    0xaf980038U,
    0x91040004U,
    0x3386000eU,
    0x7c470023U,
    0x35e08016U,
    0xa6f1c008U,
    0xe11c600eU,
    0x54c6d00eU,
    0x83270832U,
    0x48d6dc1aU,
    0x2849420bU,
    0x75cb9f0bU,
    0x3e8d2f9aU,
    0xabeebcfaU,
    0x3fdde807U,
    0x2ee6cc05U,
    0x6c72aa37U,
    0x3ada530eU,
    0x3b67058dU,
    0x43312fdaU,
    0xa1b88d8aU,
    0x485233e1U,
    0x2a8bafabU,
    0x4de87cd5U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0xc8000000U,
    0xdc000000U,
    0x4a000000U,
    0x4f000000U,
    0x53800000U,
    0xe2c00000U,
    0x86600000U,
    0x10f00000U,
    0x7ed80000U,
    0xb4040000U,
    0xe6020000U,
    0xed010000U,
    0xf0818000U,
    0x33464000U,
    0xf7a6e000U,
    0x8f125000U,
    0xc3ea7800U,
    0x1f3e9c00U,
    0xa0311600U,
    0xf3bf3300U,
    0xb9740780U,
    0x5b1e36c0U,
    0x9de00020U,
    0x6e300010U,
    0x92b80008U,
    0xdbf4000cU,
    0x35a0032U,
    0x67c50037U,
    0xdae38012U,
    0x81b74013U,
    0x2a7f6014U,
    0xea901038U,
    0x542e9821U,
    0x6dddcc04U,
    0xed82ee1fU,
    0x6bc3ef2dU,
    0x8e1f1b9U,
    0xcab255fbU,
    0x17ffff9cU,
    0x1956eadcU,
    0x58cff615U,
    0xc969633fU,
    0xeb7c7f8aU,
    0xf811aafcU,
    0xe4689628U,
    0x7bfd7308U,
    0xdb50e7a0U,
    0xebcd66f1U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x28000000U,
    0x34000000U,
    0x6a000000U,
    0xa5000000U,
    0xda800000U,
    0x10c00000U,
    0xd5200000U,
    0xc6900000U,
    0xfcf80000U,
    0x2040000U,
    0xf1060000U,
    0xc0850000U,
    0x4dc68000U,
    0x13a14000U,
    0x8851a000U,
    0xe6db5000U,
    0xbb112800U,
    0xc7b8d400U,
    0x7618600U,
    0xaf762900U,
    0xe94a7480U,
    0x3b6cc7c0U,
    0x6780020U,
    0x2c40030U,
    0xac260028U,
    0xe2150034U,
    0xf33e800aU,
    0x80a5400dU,
    0xc9d7a01aU,
    0x939e5029U,
    0xf977a836U,
    0x2499404U,
    0xa6e82635U,
    0x8d397931U,
    0x5fa55cbfU,
    0x3e5513c0U,
    0xbdd9061cU,
    0x7e966900U,
    0x80fb54bbU,
    0x2c03d7f0U,
    0xc6060808U,
    0xa302c404U,
    0xd9810e1cU,
    0x1945ad2cU,
    0xe462dabdU,
    0x16f63ae2U,
    0x800df2b5U,
    0x270feee6U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0xd8000000U,
    0xe4000000U,
    0xbe000000U,
    0x37000000U,
    0xdd800000U,
    0x3d400000U,
    0xf3200000U,
    0x6bd00000U,
    0x3c480000U,
    0xba040000U,
    0x99060000U,
    0x52830000U,
    0xd4c68000U,
    0xa866c000U,
    0x4bf72000U,
    0x341df000U,
    0x8c0db800U,
    0xda4ec00U,
    0x9d14ea00U,
    0x492a1900U,
    0xad771e80U,
    0x46de0240U,
    0x97680020U,
    0xf5d40030U,
    0x7b4e0018U,
    0xf870034U,
    0x48408036U,
    0x23a5c039U,
    0xd211a02fU,
    0xc0ab300dU,
    0x26329837U,
    0xbefd1c0fU,
    0x7b3f523cU,
    0x7dddf51aU,
    0xd8ed748fU,
    0x1d96db6eU,
    0xe8ee3e86U,
    0xd594f264U,
    0xb4ed380dU,
    0x5f912c2eU,
    0xe5ed4a3cU,
    0x51152900U,
    0xbb2b86baU,
    0xa8741e77U,
    0xfe5fd21fU,
    0xc2a83520U,
    0x8b34d4b8U,
    0x8a79eb70U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x28000000U,
    0x84000000U,
    0xda000000U,
    0x23000000U,
    0x31800000U,
    0xcec00000U,
    0x2aa00000U,
    0x96100000U,
    0x4b580000U,
    0xae040000U,
    0xa1060000U,
    0xe810000U,
    0x19448000U,
    0xb1614000U,
    0xf0342000U,
    0xdb0ed000U,
    0x13bd1800U,
    0x4cf38c00U,
    0x96a97600U,
    0x4e28d500U,
    0x7a6b7080U,
    0xb8c3ac0U,
    0x33f80020U,
    0xcf140030U,
    0x9de0008U,
    0x59450024U,
    0x5162800aU,
    0x40304021U,
    0x6308a036U,
    0xbfbb9008U,
    0x12f7380cU,
    0x6fa85c33U,
    0x5caeee0aU,
    0x852f1925U,
    0xefeca692U,
    0x8f4e7febU,
    0x1258c888U,
    0xec8526f3U,
    0x5642ce2eU,
    0xfee5c938U,
    0x57f7bebeU,
    0xcb2cf3f3U,
    0xfeed3e98U,
    0x39c8b3caU,
    0xa71b9eb7U,
    0x3e623fcU,
    0x5f7626baU,
    0x376a3fe1U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x38000000U,
    0x84000000U,
    0x56000000U,
    0x27000000U,
    0x2b800000U,
    0xc7c00000U,
    0x4f600000U,
    0xd9900000U,
    0xdfb80000U,
    0x77040000U,
    0xf3820000U,
    0x73c50000U,
    0xb1648000U,
    0x4291c000U,
    0x263c2000U,
    0xc1c6b000U,
    0xb0633800U,
    0x46145c00U,
    0xe67abe00U,
    0xa367bb00U,
    0xd390ec80U,
    0x1ab94dc0U,
    0x85820020U,
    0x84c50010U,
    0x2e48028U,
    0x9151c024U,
    0x75c200eU,
    0xbb56b021U,
    0x125b3815U,
    0xd1d05c09U,
    0x7118be0aU,
    0xcef2bb31U,
    0xf22c6c93U,
    0xf6bc8df6U,
    0x8f842017U,
    0x41c2b00dU,
    0xf0613814U,
    0xe6115c38U,
    0x767e3e22U,
    0x9b667b31U,
    0x5794cc9cU,
    0x4cbbfdf9U,
    0xa2833806U,
    0xaf445c30U,
    0xc522be02U,
    0xde33bb3aU,
    0xdecaec8dU,
    0x64e84dfaU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0xf8000000U,
    0x3c000000U,
    0x5a000000U,
    0x1b000000U,
    0xa8800000U,
    0x1c400000U,
    0x7b600000U,
    0x81100000U,
    0x4f080000U,
    0xab040000U,
    0x80860000U,
    0xf8410000U,
    0xd608000U,
    0x3817c000U,
    0xc089e000U,
    0x45c6d000U,
    0xfca6d800U,
    0xaab44400U,
    0xdf386200U,
    0xa7781b00U,
    0x6a1fe880U,
    0x720ba840U,
    0xa2860020U,
    0x1f410030U,
    0xdfe08008U,
    0x2f57c004U,
    0xeb69e03eU,
    0xe496d00fU,
    0x92ced816U,
    0x9ba04406U,
    0xb836622aU,
    0xe87d1b07U,
    0x9c99689eU,
    0x334d6860U,
    0x20676033U,
    0xc994101aU,
    0x6349b828U,
    0x3864543aU,
    0xc597da3dU,
    0xd14d4f01U,
    0xe760b2a6U,
    0xb152757U,
    0x8c0952b5U,
    0x2f83f75dU,
    0x3ec78a81U,
    0xa423b37dU,
    0x7ef1e89fU,
    0x705ea84dU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x28000000U,
    0x3c000000U,
    0xd2000000U,
    0x7b000000U,
    0xef800000U,
    0x48400000U,
    0xc9200000U,
    0x88100000U,
    0x90a80000U,
    0xa3040000U,
    0x8b820000U,
    0xbe450000U,
    0xe4248000U,
    0xda914000U,
    0xa269e000U,
    0x64e29000U,
    0x1671d800U,
    0xc81a7c00U,
    0xdefac200U,
    0x23890900U,
    0x2c16a080U,
    0x86a99540U,
    0xbe020020U,
    0x61050010U,
    0x98848028U,
    0xcdc14024U,
    0xee61e00aU,
    0x40b6900fU,
    0xf9fbd834U,
    0x6e0b7c1eU,
    0x754423bU,
    0x24094912U,
    0xb851c0b2U,
    0xad8b4562U,
    0xf514b804U,
    0xa2dac38U,
    0x9dc0fa0aU,
    0x2664e50bU,
    0x4cb13ab3U,
    0x93ffa079U,
    0x10d82bcU,
    0x6d60c57U,
    0xc54f78b6U,
    0xe5f7e954U,
    0x825ac207U,
    0xe4d90911U,
    0xe81ea0b9U,
    0xefd957cU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0xf8000000U,
    0xbc000000U,
    0xc2000000U,
    0x57000000U,
    0xc0800000U,
    0x30c00000U,
    0x82200000U,
    0x28b00000U,
    0x66380000U,
    0xcb040000U,
    0x72860000U,
    0x3fc50000U,
    0x4ea58000U,
    0x2277c000U,
    0xf1de000U,
    0xe1321000U,
    0x737cb800U,
    0xb6670400U,
    0x24520600U,
    0xf9aed100U,
    0xa20d2580U,
    0xd7f8e1c0U,
    0x88a60020U,
    0x6b750030U,
    0x4a9d8028U,
    0xe73c02cU,
    0x451be03eU,
    0x5237102fU,
    0x7df93830U,
    0xeba0c415U,
    0x8df7e630U,
    0xe358c10cU,
    0x21d79da0U,
    0x76eae5caU,
    0x84698639U,
    0x7ba81102U,
    0x950b45b4U,
    0x77c31e3U,
    0xf064d80dU,
    0xad52d417U,
    0x1c2b5e1bU,
    0xfd4fc501U,
    0x199d9b92U,
    0xd0f034ceU,
    0xf0daa3b9U,
    0xf91f0d1U,
    0xe10ec589U,
    0x417bf1d7U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x88000000U,
    0xc000000U,
    0xca000000U,
    0x37000000U,
    0x2b800000U,
    0x9d400000U,
    0xd2e00000U,
    0x56b00000U,
    0x55c80000U,
    0xeb040000U,
    0x39820000U,
    0x3e430000U,
    0xc7638000U,
    0xb2f44000U,
    0x5da86000U,
    0xf6725000U,
    0x3f6bb800U,
    0xe7d65c00U,
    0xb23d6a00U,
    0xb62dd700U,
    0x4b375580U,
    0xfd89be40U,
    0x49620020U,
    0x63f30010U,
    0x9b2b8018U,
    0x8fb0401cU,
    0xdf4a6022U,
    0x38c15003U,
    0x9ea03832U,
    0x42d61c0dU,
    0x7abf0a0aU,
    0x5ee88727U,
    0xd956db4U,
    0x2b5ca255U,
    0xdde8a35U,
    0x441fc72aU,
    0x4c3e8d96U,
    0xef2ab253U,
    0x81b55233U,
    0x4e4fcb3fU,
    0x9e425fbdU,
    0x9766396cU,
    0x2af6ed87U,
    0xa9a8e24dU,
    0xb876ea12U,
    0xce6d9739U,
    0x315535b7U,
    0x33fcee7dU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0x38000000U,
    0x54000000U,
    0x12000000U,
    0xed000000U,
    0x9c800000U,
    0x89400000U,
    0x8a600000U,
    0x7500000U,
    0xc1380000U,
    0x91040000U,
    0x82860000U,
    0xd2450000U,
    0x81e28000U,
    0x9391c000U,
    0x189aa000U,
    0x6a749000U,
    0xbf096800U,
    0x90ede400U,
    0x507cca00U,
    0xdf629300U,
    0xfd31a80U,
    0xfa78d9c0U,
    0xa6660020U,
    0x21550030U,
    0xce3a8028U,
    0x8885c014U,
    0xfb44a00eU,
    0x97659015U,
    0xf3d5e804U,
    0x247d243bU,
    0x5d62ea27U,
    0x7ad2c322U,
    0x62fa52a2U,
    0x5246dc1U,
    0x12370210U,
    0x47efe714U,
    0x2df8b888U,
    0x7ca6aee0U,
    0x9bf5508eU,
    0x6acf8ac1U,
    0x33c9ba8aU,
    0x8d4c49c5U,
    0x210f680eU,
    0xbe8e437U,
    0xfbfe4a14U,
    0x1ba3530cU,
    0xee71ba9eU,
    0x550849d6U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x48000000U,
    0x14000000U,
    0x6e000000U,
    0xc9000000U,
    0xf3800000U,
    0xd4c00000U,
    0x89e00000U,
    0xbb100000U,
    0x7eb80000U,
    0xe5040000U,
    0x11820000U,
    0x4fc30000U,
    0x59648000U,
    0x73524000U,
    0xd18a000U,
    0x9eb77000U,
    0x400c4800U,
    0x15089c00U,
    0xbc8c2600U,
    0x3f4b0f00U,
    0x542cf880U,
    0x947b45c0U,
    0xcde20020U,
    0xbd130010U,
    0x53bc8018U,
    0xa0864024U,
    0x5042a012U,
    0x4fa07005U,
    0x91b2c81bU,
    0xbe8ddc32U,
    0x744a063cU,
    0xaca93f35U,
    0xd83e90a2U,
    0x9845e9eeU,
    0x1ba64e3fU,
    0x9fb1a329U,
    0xe78ab69cU,
    0xcfcae6f7U,
    0x6c68b6a4U,
    0x3fd9e6c9U,
    0xea5436a0U,
    0x969fa6e1U,
    0xae769686U,
    0x7fefd6c1U,
    0x3b1c5ebcU,
    0x4bb60ae2U,
    0xa98c5887U,
    0xf6c835eaU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0xf8000000U,
    0x4c000000U,
    0x76000000U,
    0x7000000U,
    0xb5800000U,
    0x5f400000U,
    0x91e00000U,
    0x80900000U,
    0xb2980000U,
    0xb1040000U,
    0x52820000U,
    0xdac50000U,
    0xa6a48000U,
    0xa577c000U,
    0x80a6000U,
    0x729fb000U,
    0x51063800U,
    0x6282ac00U,
    0xb2c37a00U,
    0x12a7cf00U,
    0x9f71a480U,
    0x790c44c0U,
    0xc01a0020U,
    0xbbc10010U,
    0xac268028U,
    0xa3b2c024U,
    0x20aee03eU,
    0x9ce87013U,
    0x9a8c581dU,
    0x485d1c01U,
    0xc7a5422dU,
    0xaff56317U,
    0xecadea4U,
    0x5a3f8be0U,
    0xbf71a48cU,
    0xa90c44fcU,
    0x981a001cU,
    0x67c10002U,
    0x2226803fU,
    0xe8b2c01eU,
    0xe32ee021U,
    0xc4a8700eU,
    0xbeec5824U,
    0x978d1c0eU,
    0xe4dd4225U,
    0x9e616333U,
    0xeed0deafU,
    0x31fe8bd2U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0xb8000000U,
    0xfc000000U,
    0x26000000U,
    0xe3000000U,
    0xc1800000U,
    0xcec00000U,
    0x3ce00000U,
    0x41900000U,
    0xe9780000U,
    0xb5040000U,
    0x5a860000U,
    0x93430000U,
    0x24278000U,
    0x2675c000U,
    0x956fe000U,
    0xb4bd3000U,
    0x30651800U,
    0x49d30c00U,
    0x90daf600U,
    0x8bb7a700U,
    0xa80e2c80U,
    0x5bee9bc0U,
    0x15fe0020U,
    0x5470030U,
    0xdf218018U,
    0x8bf6c03cU,
    0x35a8602eU,
    0x2f58f03fU,
    0x6a72f809U,
    0xab6a3c38U,
    0x3bb9ee30U,
    0x9fe7ab33U,
    0x20135a8fU,
    0xb7bcfcd0U,
    0xc1e7cc9aU,
    0x5f10abddU,
    0xa03c982eU,
    0x5421cc28U,
    0x5e74963fU,
    0x96c570aU,
    0x62bb5482U,
    0x6b6167eaU,
    0x74500e15U,
    0x78199b29U,
    0x5451c283U,
    0x281a30fdU,
    0x7c52da91U,
    0x9c1a3ce4U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xb8000000U,
    0x64000000U,
    0x7a000000U,
    0xf5000000U,
    0xb5800000U,
    0xd7c00000U,
    0x78600000U,
    0xdff00000U,
    0xca580000U,
    0x6b040000U,
    0xfa860000U,
    0xb7410000U,
    0x4a228000U,
    0xc855c000U,
    0x9cb2000U,
    0x4afd000U,
    0xaedda800U,
    0x9346ac00U,
    0xd0233e00U,
    0x4d558300U,
    0x544a9f80U,
    0xf6f62c0U,
    0xc8be0020U,
    0xc3b50030U,
    0x5afc8008U,
    0x4410c014U,
    0x16fa02eU,
    0x1fbb1019U,
    0x9734081eU,
    0xaabcbc3dU,
    0xc2b5b62dU,
    0xd7cff35U,
    0x52d4099eU,
    0xe8c4df7U,
    0x868fa192U,
    0xea8be1eaU,
    0x3c8e1f96U,
    0x3f8ba2c9U,
    0xd90fa014U,
    0x504b100fU,
    0xc56c083aU,
    0xf5b8bc31U,
    0xfa33b636U,
    0x2b3dff35U,
    0xd7768999U,
    0xe4198decU,
    0x42a481b4U,
    0xe61431ebU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x28000000U,
    0x6c000000U,
    0xa2000000U,
    0x55000000U,
    0x89800000U,
    0xc400000U,
    0x1d600000U,
    0xcdb00000U,
    0x25580000U,
    0x73040000U,
    0xf2820000U,
    0xc2c50000U,
    0xf5a08000U,
    0x11114000U,
    0x37cb6000U,
    0x71891000U,
    0xb5eca800U,
    0xe3df4c00U,
    0xa7c3e200U,
    0x4262b00U,
    0xf951cd80U,
    0xf4ae9ac0U,
    0x633a0020U,
    0x20310010U,
    0xb71a8028U,
    0x11604004U,
    0x9fb1e00aU,
    0xe859501bU,
    0xae854828U,
    0x18c21c15U,
    0x44a4aa22U,
    0x46913703U,
    0xe48de787U,
    0xdc6aedf3U,
    0x5f9e87a9U,
    0x82a7fdccU,
    0x8d902fb4U,
    0x120db1e4U,
    0x70ab4dbfU,
    0x4d3edacbU,
    0x6733e027U,
    0x539c5006U,
    0xd0a5c805U,
    0x40935c31U,
    0xcf8fca2eU,
    0x9ae8273fU,
    0xcb594fbaU,
    0xd401a1c4U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0xb8000000U,
    0xd4000000U,
    0xaa000000U,
    0x6b000000U,
    0xff800000U,
    0xc2c00000U,
    0x9e200000U,
    0x44500000U,
    0xf5980000U,
    0xaf840000U,
    0x4ac20000U,
    0x52250000U,
    0x4a538000U,
    0x8c9dc000U,
    0xef02a000U,
    0xdd875000U,
    0x65c65800U,
    0x6fa47c00U,
    0xff93d600U,
    0x2b3a5100U,
    0x7c937280U,
    0x88bef4c0U,
    0xd8538020U,
    0x739dc010U,
    0x1a82a028U,
    0x447501cU,
    0xbc66582eU,
    0x3d347c35U,
    0x3e2bd62aU,
    0xabee511aU,
    0x3c4972bfU,
    0xb7dff4f0U,
    0x46e20007U,
    0xe9750001U,
    0x4a4b8015U,
    0xfad9c037U,
    0x7c60a03cU,
    0xdd325021U,
    0xee2dd838U,
    0x63edbc39U,
    0x504b7604U,
    0xc9dc0107U,
    0x87e4aabeU,
    0x7df248caU,
    0x77097622U,
    0xa6390131U,
    0xa6172aa5U,
    0x6cff88eaU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0x48000000U,
    0x54000000U,
    0x96000000U,
    0xdb000000U,
    0x1d800000U,
    0x79400000U,
    0xd9600000U,
    0xf0500000U,
    0x22a80000U,
    0xb5840000U,
    0xfd460000U,
    0x67630000U,
    0x6f508000U,
    0xe12a4000U,
    0x43c6a000U,
    0xafa2b000U,
    0x3575d800U,
    0x89186c00U,
    0xddbd8a00U,
    0x454e6b00U,
    0x8d123280U,
    0x85ca4d40U,
    0xbad08020U,
    0xc6a4030U,
    0x6ca6a018U,
    0x94f2b004U,
    0x425dd812U,
    0x11dc6c15U,
    0x6f9b8a25U,
    0x97d6b36U,
    0xdd6ab287U,
    0xa8240d5eU,
    0xdd302016U,
    0x34fbf00cU,
    0x142bf810U,
    0x49449c29U,
    0x2160f22dU,
    0x9c53b70cU,
    0xb8ace0beU,
    0xe4850a4eU,
    0xf9c118b7U,
    0x4ea29645U,
    0x9f16a83U,
    0xacdb616aU,
    0x311b2a15U,
    0x11bcdb1dU,
    0xaf4feab3U,
    0x8416215fU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x68000000U,
    0xa4000000U,
    0x26000000U,
    0x8f000000U,
    0x92800000U,
    0x61c00000U,
    0xfce00000U,
    0x6ff00000U,
    0x89780000U,
    0xa6840000U,
    0xefc60000U,
    0x77e50000U,
    0xcb708000U,
    0xfbb4000U,
    0x6ce12000U,
    0xc7f73000U,
    0x8d797800U,
    0x90801400U,
    0x8c64e00U,
    0x4167c700U,
    0x8cb2cf80U,
    0x7c5b73c0U,
    0x91908020U,
    0x2f4b4030U,
    0xd7192028U,
    0x10b33004U,
    0xf65f781aU,
    0x2c951429U,
    0x6ccece09U,
    0x67588723U,
    0x9d15efa4U,
    0xad8943d8U,
    0x2b79781fU,
    0xdf80142bU,
    0x3a464e0aU,
    0x30a7c72dU,
    0x1852cfa1U,
    0xb7ab73f4U,
    0x3ee8801bU,
    0x6cf4010U,
    0xaa5f2017U,
    0x696302dU,
    0xc1cff806U,
    0x4cde5416U,
    0x8957ee29U,
    0x62bb71aU,
    0xffaa97bcU,
    0x4aec57daU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0xa8000000U,
    0x34000000U,
    0x2a000000U,
    0xc3000000U,
    0x6b800000U,
    0x67400000U,
    0x41600000U,
    0x83300000U,
    0x49280000U,
    0xf840000U,
    0x35460000U,
    0xe670000U,
    0xaeb78000U,
    0x5b6d4000U,
    0xf865a000U,
    0x53b75000U,
    0xc9e91800U,
    0x6fa0dc00U,
    0x82107a00U,
    0x72fcab00U,
    0xddec980U,
    0xef0b1140U,
    0xdd78020U,
    0x1f5d4030U,
    0xb8cda038U,
    0x3c73503cU,
    0x544f182aU,
    0x72b7dc0dU,
    0x656ffa0aU,
    0x165eb30U,
    0xa335699aU,
    0x592f4159U,
    0x57871830U,
    0xa943dc10U,
    0x1061fa2aU,
    0x47b6eb3fU,
    0xf3ece9a7U,
    0xf4a1014eU,
    0x75933801U,
    0xbbecc16U,
    0xa5bac21cU,
    0xc4bc2731U,
    0x48382b88U,
    0x36fe2676U,
    0x4fda9398U,
    0xf80aaa5fU,
    0xbc52718cU,
    0x131c9d6dU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0xe8000000U,
    0xcc000000U,
    0x5e000000U,
    0x39000000U,
    0x43800000U,
    0x8fc00000U,
    0x75e00000U,
    0x68900000U,
    0x10e80000U,
    0x97840000U,
    0x95c20000U,
    0xcee10000U,
    0x94118000U,
    0xc1af4000U,
    0xbc226000U,
    0x6070f000U,
    0xb9f8c800U,
    0xb7af9c00U,
    0x29253e00U,
    0x6df6cf00U,
    0xd7393480U,
    0xa5cb8f40U,
    0x5c718020U,
    0x6fff4010U,
    0x52aa6008U,
    0xeca4f00cU,
    0xff32c83aU,
    0x735a9c33U,
    0x259ebe17U,
    0x43fc8f0eU,
    0x5ca8d490U,
    0x2da53f63U,
    0xa8b2a83dU,
    0x869b6c0aU,
    0xfb7ff60cU,
    0xfe85329U,
    0xb9058a9fU,
    0x3860040U,
    0xafc0d492U,
    0x45e13f6eU,
    0x8090a817U,
    0xdcea6c27U,
    0xc9867601U,
    0xacc31308U,
    0x8d65eaa3U,
    0x1bd7f043U,
    0xb4499cb7U,
    0xd4b1e367U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x48000000U,
    0x34000000U,
    0xe2000000U,
    0xaf000000U,
    0xdf800000U,
    0x1cc00000U,
    0x52200000U,
    0xfed00000U,
    0xbaa80000U,
    0x7d840000U,
    0xd3c60000U,
    0x3da50000U,
    0xba108000U,
    0x948a4000U,
    0x5555a000U,
    0x24691000U,
    0x30a47800U,
    0xaa907c00U,
    0xe7cfa600U,
    0x43b7b100U,
    0xf49ca680U,
    0xa2d80d40U,
    0x20b88020U,
    0x390e4030U,
    0x6e93a028U,
    0x3dcc1004U,
    0x20b4f812U,
    0xa51a3c0dU,
    0x8f1a0638U,
    0xd41ea12bU,
    0x4998deb7U,
    0xea587147U,
    0x2fff2634U,
    0xf9edf10fU,
    0xf3610686U,
    0xdf351d5bU,
    0x69daf806U,
    0x353b3c32U,
    0xecc863eU,
    0x5931e10aU,
    0xcddfeb0U,
    0xc1bb2143U,
    0x778efe00U,
    0xc4d49d0eU,
    0xa9aad888U,
    0xd402d04cU,
    0x9201f8afU,
    0x57008065U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x88000000U,
    0xa4000000U,
    0x4a000000U,
    0x5f000000U,
    0x94800000U,
    0x90c00000U,
    0x71e00000U,
    0x89f00000U,
    0x4a980000U,
    0x9a840000U,
    0x55c20000U,
    0xa2610000U,
    0x11b58000U,
    0xcdbc4000U,
    0xd3912000U,
    0x17285000U,
    0x293ff800U,
    0xab572400U,
    0x52cbc600U,
    0xd2ce2f00U,
    0x92c9df80U,
    0xb2ceccc0U,
    0x2cd8020U,
    0x8ac84010U,
    0x2ecb2008U,
    0x64cd502cU,
    0x3bc87822U,
    0xaf4a6429U,
    0x3f8f6612U,
    0x4e6a3f17U,
    0xc79f07a5U,
    0x8d05b8e4U,
    0x1783be3cU,
    0x42444b32U,
    0xe026b99aU,
    0xf194f3caU,
    0x3c2a8797U,
    0xefb9f8d1U,
    0xf8929e3eU,
    0xd1ac1b18U,
    0x7af941bbU,
    0x2833d7e4U,
    0xfaf94186U,
    0x6833d7e6U,
    0xdaf94199U,
    0xd833d7ddU,
    0x52f94182U,
    0x7c33d7d7U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xb8000000U,
    0x2c000000U,
    0x2e000000U,
    0xe7000000U,
    0x2e800000U,
    0xa6c00000U,
    0x58e00000U,
    0x61b00000U,
    0xf8c80000U,
    0x5c840000U,
    0xb7c60000U,
    0x2d650000U,
    0x4ff18000U,
    0x75edc000U,
    0x49556000U,
    0x417f7000U,
    0x184e3800U,
    0x4d42f400U,
    0xe9a3f600U,
    0x4e172700U,
    0x55de3d80U,
    0xadd85e40U,
    0xe1d98020U,
    0x5fd9c030U,
    0x30db6028U,
    0x8a5e700cU,
    0x2e99b82eU,
    0xbf7a340bU,
    0x174f160bU,
    0x67c19739U,
    0xc563658bU,
    0x4bf0da69U,
    0xffedce36U,
    0x1455d328U,
    0x8afdcb96U,
    0x590f795bU,
    0x7ae7bda3U,
    0x58b19e70U,
    0x294ae010U,
    0xc8c3b018U,
    0xdfe4d81fU,
    0xdf31443eU,
    0xd60f2e35U,
    0x90626339U,
    0xd4771384U,
    0x1caf3d54U,
    0xdaf71385U,
    0x4a6f3d61U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x88000000U,
    0xec000000U,
    0x1a000000U,
    0xb5000000U,
    0x46800000U,
    0xf7c00000U,
    0xe3200000U,
    0x1c900000U,
    0x35780000U,
    0x88840000U,
    0x7cc20000U,
    0x6a70000U,
    0x32d18000U,
    0x5a1c4000U,
    0x2a736000U,
    0x5bcad000U,
    0xf1eea800U,
    0xa9fdb400U,
    0x6a42fe00U,
    0x964f900U,
    0x55f2f480U,
    0x808ea3c0U,
    0x38098020U,
    0xccc84010U,
    0x26696038U,
    0xeb9d00cU,
    0xe1a52822U,
    0x8d52f43bU,
    0x215a1e06U,
    0x3391692dU,
    0x86fcbc91U,
    0xd9c287fdU,
    0x58273618U,
    0x71179d17U,
    0xf73ca2b5U,
    0xfde0eeeeU,
    0x6b300a9dU,
    0x672a5aeaU,
    0x325b7492U,
    0x2216e3e7U,
    0x6b8e021U,
    0x4da5900cU,
    0x77564818U,
    0xa4582437U,
    0xfd14b622U,
    0x9d3cdd0bU,
    0x20e642a5U,
    0xf1b27ef6U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xf8000000U,
    0xec000000U,
    0xa2000000U,
    0xcd000000U,
    0x7a800000U,
    0x86400000U,
    0x83200000U,
    0x3e500000U,
    0x38b80000U,
    0x67840000U,
    0xc4c60000U,
    0x89630000U,
    0x4f728000U,
    0x33efc000U,
    0xc9bb6000U,
    0x87071000U,
    0x3836800U,
    0x82c25400U,
    0xc2617200U,
    0x1ef4b900U,
    0xb42b8280U,
    0x355ebdc0U,
    0xa9b48020U,
    0xb78cc030U,
    0x9c49e018U,
    0x62a8d014U,
    0xb118083eU,
    0xd795443bU,
    0x5b5a1a28U,
    0x36b2ed33U,
    0xc80cf09eU,
    0x248904e1U,
    0xd1cd8280U,
    0x8f6dbdffU,
    0xc4fe0036U,
    0x35a7003dU,
    0xea148017U,
    0xbe9cc00dU,
    0x6751e005U,
    0xcc3cd004U,
    0xeec60804U,
    0xa0624433U,
    0xb3f69a3eU,
    0x9eaa2d0eU,
    0x4b1b109eU,
    0xc696d4d1U,
    0x2bd90ab2U,
    0x69f039c6U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x88000000U,
    0x34000000U,
    0x12000000U,
    0x4f000000U,
    0x8800000U,
    0x2e400000U,
    0xa00000U,
    0x8a300000U,
    0xc3b80000U,
    0x6f840000U,
    0x62c60000U,
    0x4e70000U,
    0x29928000U,
    0xef0c4000U,
    0xeb7da000U,
    0x58629000U,
    0x85d37800U,
    0xc8adc400U,
    0xdcbb200U,
    0x2f9fe500U,
    0x91f06180U,
    0x3adf75c0U,
    0xabd48020U,
    0x61ab4030U,
    0xb84f2038U,
    0x165ed014U,
    0x3f96d822U,
    0xaa0b540dU,
    0xf0feca04U,
    0x8a52113U,
    0x7e315382U,
    0x31b8d0cbU,
    0x708741a0U,
    0xe245a5d2U,
    0x1ea45828U,
    0x3b37143fU,
    0x2a3b6a02U,
    0x2043b118U,
    0x19a42bacU,
    0xe7b214e5U,
    0x467e739cU,
    0xe7e600feU,
    0xaf1199bbU,
    0x184ef1ffU,
    0x665a9209U,
    0x792351bU,
    0x460a3992U,
    0x5efb61deU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0x38000000U,
    0xd4000000U,
    0x7a000000U,
    0x91000000U,
    0x6800000U,
    0x47400000U,
    0x96600000U,
    0x3b300000U,
    0x5ba80000U,
    0x1f840000U,
    0xbdc60000U,
    0xa7270000U,
    0x42568000U,
    0xb519c000U,
    0x40eaa000U,
    0xfe1d000U,
    0x61f58800U,
    0x1509b400U,
    0xcf117a00U,
    0x9a7dd300U,
    0x715fa980U,
    0x6d090540U,
    0x3b108020U,
    0xd07ec030U,
    0x85c2038U,
    0x87881034U,
    0xd257280eU,
    0xad1c6435U,
    0xa4eaf21eU,
    0x9de76724U,
    0x1cf65381U,
    0xbd8e1651U,
    0x63550985U,
    0x9b98d57eU,
    0xbad080eU,
    0xe7837403U,
    0x89c35a19U,
    0xd26c328U,
    0xeb500180U,
    0x679fa17cU,
    0x7da8522fU,
    0x882b706U,
    0x5c45db84U,
    0x9e0a26eU,
    0x46f2f3aeU,
    0x1c8cc66aU,
    0x8dd001a3U,
    0x30dfa155U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0xf8000000U,
    0x4c000000U,
    0x8a000000U,
    0xd9000000U,
    0x17800000U,
    0x6e400000U,
    0xeca00000U,
    0x2a100000U,
    0x8b180000U,
    0x6a840000U,
    0xd7c20000U,
    0xb5e70000U,
    0x6318000U,
    0x3fcfc000U,
    0x6bfe6000U,
    0x51325000U,
    0x8f4bc800U,
    0xed3a3c00U,
    0xa7533200U,
    0x113fc500U,
    0x9555e080U,
    0x643a80c0U,
    0x38d38020U,
    0x2b78c010U,
    0x8ff7e038U,
    0xe529900cU,
    0x314fa83eU,
    0xb23b6c13U,
    0x3d37a22U,
    0x81f93936U,
    0xf8333285U,
    0x80cbd5dbU,
    0xff78489bU,
    0x39f6ecdaU,
    0xae297a3aU,
    0x83ca3906U,
    0xb9f8b2b3U,
    0x143715f2U,
    0xdacda8bdU,
    0xee787cfaU,
    0x9a775225U,
    0x66e9525U,
    0x3c6da89bU,
    0x5d687cf5U,
    0xe6ef520cU,
    0x32aa9521U,
    0xff0fa8adU,
    0x8e9f7ccfU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0xc8000000U,
    0x24000000U,
    0x2e000000U,
    0xe1000000U,
    0xc0800000U,
    0x9d400000U,
    0x4b600000U,
    0xea300000U,
    0x84880000U,
    0x8f840000U,
    0xfcc20000U,
    0x36a10000U,
    0x2c108000U,
    0xedde4000U,
    0xc53d2000U,
    0xd9cf7000U,
    0xa4e00800U,
    0x26f58400U,
    0x6a2b2a00U,
    0x4f91bb00U,
    0x1b1b4180U,
    0x3c9e7c40U,
    0xd45a8020U,
    0x14fb4010U,
    0x35efa008U,
    0x12b03004U,
    0x85cda832U,
    0x36e4b409U,
    0x25f6020bU,
    0x51ab4f38U,
    0x155063b0U,
    0xc8ba4367U,
    0xee0aebb2U,
    0x8dc4876aU,
    0x7e266189U,
    0xb5510c77U,
    0x98ba8825U,
    0x60ec410U,
    0xb9c48a3aU,
    0x98218b0eU,
    0x7056e9b8U,
    0x763ac860U,
    0x7a4c8220U,
    0x32200f3cU,
    0xef57c391U,
    0xbfbe7369U,
    0x138d4398U,
    0x2053342U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x28000000U,
    0x94000000U,
    0x3e000000U,
    0xed000000U,
    0xd7800000U,
    0x13c00000U,
    0xbe200000U,
    0x1cb00000U,
    0x4ed80000U,
    0x64840000U,
    0x59460000U,
    0xe2610000U,
    0x9d548000U,
    0x6e494000U,
    0x71e8a000U,
    0x779bf000U,
    0xf6e46800U,
    0x5c153c00U,
    0xa02c5e00U,
    0x6eb89100U,
    0x5ed6f580U,
    0x838f4ec0U,
    0x2ca8020U,
    0x2cac4030U,
    0x83fa2008U,
    0x12b3b024U,
    0xdbd8480aU,
    0x2f078c25U,
    0x7080960fU,
    0xa7465d3bU,
    0x2f66c3b5U,
    0xdad6e3c4U,
    0x558e2b8fU,
    0x5bce9ff7U,
    0x552cd5bbU,
    0x553cfecdU,
    0xef12c834U,
    0xeaabcc09U,
    0x32fab62aU,
    0xdf35ed21U,
    0xa31e8bacU,
    0x17a16fc7U,
    0x276bd88U,
    0x977cc2dfU,
    0xd3f41609U,
    0x15bf1d15U,
    0x305663bfU,
    0x59c913c7U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x48000000U,
    0xac000000U,
    0xd2000000U,
    0xb3000000U,
    0x2800000U,
    0x38400000U,
    0x63e00000U,
    0x6f100000U,
    0x98e80000U,
    0x33840000U,
    0x31c60000U,
    0x5d270000U,
    0x7ab18000U,
    0xbd1a4000U,
    0xd9f96000U,
    0x726c9000U,
    0xb7c09800U,
    0x18209400U,
    0x55350200U,
    0xd6ddbf00U,
    0x7bdec880U,
    0xe858af40U,
    0xc99f8020U,
    0xcb94030U,
    0xa20ee038U,
    0x2911d00cU,
    0x3de87812U,
    0x2c06442bU,
    0x1204fa34U,
    0x5305bb2cU,
    0x32855280U,
    0x7046844eU,
    0xcfe3cab8U,
    0xbd11106bU,
    0x2bef48beU,
    0x3102ef70U,
    0x986e006U,
    0x3ec5d000U,
    0x15a67800U,
    0x25f54424U,
    0xea7b7a10U,
    0x43acfb15U,
    0xeae3b281U,
    0x6293547fU,
    0xe82db28bU,
    0xf20545cU,
    0x9b232b4U,
    0x5f991446U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xe8000000U,
    0xb4000000U,
    0x3a000000U,
    0x9f000000U,
    0x85800000U,
    0x3dc00000U,
    0x38e00000U,
    0x34f00000U,
    0x7a280000U,
    0x78840000U,
    0x4b420000U,
    0x96a30000U,
    0xd8d08000U,
    0xabf4000U,
    0x9f19a000U,
    0x6c4fd000U,
    0x8e31f800U,
    0xcb4dac00U,
    0x77b12e00U,
    0x889a700U,
    0x12559780U,
    0x7af9d940U,
    0x5e3a8020U,
    0xa2584010U,
    0x3eb2018U,
    0xc2639004U,
    0xdcb0d83aU,
    0xf7093c2dU,
    0xd093760eU,
    0xd79cdb27U,
    0xbf0fc1a1U,
    0x5495924fU,
    0x759d19aeU,
    0x6c0fae5dU,
    0xb716efa6U,
    0x5958354aU,
    0x746a8e10U,
    0xa4a5771cU,
    0xa3d4ef9aU,
    0x3d3b354cU,
    0x99da0e12U,
    0x32a370eU,
    0xac054f9aU,
    0x3600e553U,
    0x9901f636U,
    0x84809b23U,
    0xf546e190U,
    0xaba5024bU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0xc8000000U,
    0x54000000U,
    0xf2000000U,
    0x39000000U,
    0xe9800000U,
    0x44c00000U,
    0x59e00000U,
    0x5f100000U,
    0xe4b80000U,
    0xb6840000U,
    0x46420000U,
    0xdda30000U,
    0x13b38000U,
    0x3a8e4000U,
    0xf2cea000U,
    0x80699000U,
    0x195cc800U,
    0x9391cc00U,
    0xaffee600U,
    0xa2af00U,
    0xe0300880U,
    0x34e9dc0U,
    0x8a98020U,
    0x3eb94010U,
    0xeb872018U,
    0xf5c0d01cU,
    0x8463e832U,
    0x99d51c15U,
    0x4c5f0e3cU,
    0x5414b30eU,
    0x143c86baU,
    0xbc46ed1U,
    0xe363a6b6U,
    0x4750bec7U,
    0xe1a4e81U,
    0xa3b2a2e1U,
    0xd28cc09bU,
    0xb6cf51eeU,
    0xca6f6632U,
    0xbc5fef19U,
    0xdc152890U,
    0x203d4df6U,
    0x89c1e804U,
    0x12661c29U,
    0xfad48e1aU,
    0xb8def339U,
    0xc350268eU,
    0x641efec9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x58000000U,
    0x8c000000U,
    0xee000000U,
    0x7b000000U,
    0x28800000U,
    0xf4c00000U,
    0x94600000U,
    0xe2700000U,
    0x86280000U,
    0xe9840000U,
    0x5460000U,
    0xfd210000U,
    0xe1518000U,
    0x747ac000U,
    0x61786000U,
    0xf2fd7000U,
    0xeb8d800U,
    0x5e1bc400U,
    0x700fe600U,
    0x98508300U,
    0x19f84380U,
    0x8e3ab940U,
    0x5edf8020U,
    0xb66fc030U,
    0xb727e008U,
    0x4052b00cU,
    0x55ff3816U,
    0x40397423U,
    0x15d8de3bU,
    0xc6edf71eU,
    0xcfe69d8aU,
    0x3a364e7dU,
    0xcc889d85U,
    0xee934e48U,
    0x89f1d89U,
    0x57c88e46U,
    0xd0b6fdbfU,
    0x5d4f3e60U,
    0x517645bdU,
    0x8aa98a5cU,
    0x7417b97U,
    0xb822cd40U,
    0xfad6de29U,
    0x4c38f713U,
    0x3bd91db7U,
    0x9de98e68U,
    0xd7677d84U,
    0x96f5fe6eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0x78000000U,
    0x64000000U,
    0xf2000000U,
    0xeb000000U,
    0xc800000U,
    0x79c00000U,
    0x6d200000U,
    0x6fb00000U,
    0x3dc80000U,
    0xb9840000U,
    0x10420000U,
    0x35610000U,
    0x66d38000U,
    0xbd1bc000U,
    0x659f2000U,
    0xf6599000U,
    0x44785800U,
    0xdd4ce400U,
    0x6e448e00U,
    0x20630900U,
    0x3f568d80U,
    0xbd5a4640U,
    0x78f98020U,
    0xfc8ec010U,
    0x1766a008U,
    0xc5d7501cU,
    0x8d9ef81eU,
    0xfa5bb419U,
    0xfa7a763cU,
    0xa848bd3aU,
    0x67c4fb83U,
    0x2826fb5eU,
    0x3e377bbbU,
    0x218d3b4bU,
    0x32e05ba7U,
    0x390ab62U,
    0x81fa03b2U,
    0xb0d4f58U,
    0x4a250d93U,
    0xbd318640U,
    0x610ea010U,
    0xd523500cU,
    0x6bb4f823U,
    0x9fceb40dU,
    0x5a83f62eU,
    0xc67d00U,
    0xdaa25ba0U,
    0x12f1ab73U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x18000000U,
    0x1c000000U,
    0x22000000U,
    0x87000000U,
    0xac800000U,
    0x58400000U,
    0x2fe00000U,
    0xfab00000U,
    0x50680000U,
    0x70440000U,
    0x6be20000U,
    0xe4b10000U,
    0x456d8000U,
    0x43c4c000U,
    0x8322e000U,
    0xb1101000U,
    0x1739b800U,
    0x4599a400U,
    0xfb4c2200U,
    0x85576f00U,
    0x62dd6d80U,
    0xb42fa740U,
    0x8da2e020U,
    0x2e501010U,
    0xb459b808U,
    0x5769a42cU,
    0x9cc42206U,
    0x13a36f07U,
    0x7b576d88U,
    0xa7daa761U,
    0xfad600bU,
    0xd165d006U,
    0x5df6d803U,
    0x5f0d7412U,
    0x58b77a12U,
    0x976edb1bU,
    0xfcc0f792U,
    0x83a56c58U,
    0xd351af9aU,
    0xa3d9d856U,
    0x31abb583U,
    0x7462d36eU,
    0x76759a3fU,
    0xabcecb36U,
    0x2f114fa2U,
    0x4238c852U,
    0x561f8d8cU,
    0xa38fb75dU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0xd8000000U,
    0x34000000U,
    0xc2000000U,
    0x7b000000U,
    0x20800000U,
    0xa8c00000U,
    0x76e00000U,
    0x50500000U,
    0xccf80000U,
    0xfcc40000U,
    0x84e60000U,
    0x13570000U,
    0x287f8000U,
    0x4e02c000U,
    0xbd07a000U,
    0xa1811000U,
    0x37445800U,
    0xe4a7c400U,
    0xc174e600U,
    0x8cda700U,
    0xb3ad5a80U,
    0xe2bd63c0U,
    0x93e7a020U,
    0x5d11030U,
    0xd9bc5838U,
    0x9363c43cU,
    0xbd12e636U,
    0x875aa70dU,
    0x2f32dab0U,
    0x87efa3deU,
    0xc2980028U,
    0xf054001aU,
    0x1cfe0025U,
    0x34c30028U,
    0x98e18005U,
    0x3d51c032U,
    0xa57e2011U,
    0xd784d01aU,
    0x4e447802U,
    0x5f201439U,
    0xb9311e32U,
    0xeec733cU,
    0xa11a64beU,
    0xbc11c0c6U,
    0xd8dfbcb1U,
    0x5d77c4f6U,
    0xe6cd7abeU,
    0xdeaab3e7U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x38000000U,
    0x4000000U,
    0x8e000000U,
    0x13000000U,
    0xa2800000U,
    0xbf400000U,
    0x2a200000U,
    0x4ad00000U,
    0x54480000U,
    0x23440000U,
    0xb0260000U,
    0x3fd70000U,
    0xe9c98000U,
    0x8c85c000U,
    0xbc462000U,
    0x60a37000U,
    0xf9911800U,
    0xcc6cd400U,
    0xf091da00U,
    0xdbeb2100U,
    0x1251ce80U,
    0x6e083640U,
    0x6ce62020U,
    0x61337030U,
    0xd1f91838U,
    0x82f8d40cU,
    0x7fda0eU,
    0x6f382101U,
    0x4d1e4ea3U,
    0x3bcaf644U,
    0xe5818008U,
    0x5bc1c01fU,
    0x5a602032U,
    0x7874701eU,
    0x4d8981bU,
    0xe8a91409U,
    0x4a77fa0fU,
    0x5dd8510bU,
    0x3728d692U,
    0x74b0e24cU,
    0x5239fa05U,
    0xec9b513aU,
    0xce0f5693U,
    0x7ce62277U,
    0x89305a3eU,
    0xddfae108U,
    0x30f9eea5U,
    0x99784670U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0xf8000000U,
    0x94000000U,
    0x16000000U,
    0x47000000U,
    0x54800000U,
    0x46c00000U,
    0xa600000U,
    0xed900000U,
    0xdd580000U,
    0x1ac40000U,
    0xa0660000U,
    0x70950000U,
    0x5cd88000U,
    0xa183c000U,
    0x6b42a000U,
    0x9325b000U,
    0x67b2b800U,
    0xd56d6400U,
    0xa7ea9600U,
    0x8e2ae300U,
    0x1cca5480U,
    0x259bcec0U,
    0x5ba2a020U,
    0x2b75b030U,
    0x520ab828U,
    0x33f96404U,
    0x7c34963eU,
    0xdb2be325U,
    0x214cd485U,
    0x44d90ed1U,
    0x45868035U,
    0x3542c021U,
    0xa824202aU,
    0x4937703fU,
    0x56ae9809U,
    0xa80e1423U,
    0x36fa0e2dU,
    0xd9b5f70dU,
    0x9e6eda82U,
    0xc168f9f9U,
    0x71ee5ab8U,
    0x692f39efU,
    0x584afaa6U,
    0x9b5f89c7U,
    0xc5c0c2b7U,
    0xd0e12deeU,
    0xc850f4a3U,
    0x7dba7ee1U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x88000000U,
    0x74000000U,
    0xa6000000U,
    0x41000000U,
    0x89800000U,
    0xa9c00000U,
    0xdaa00000U,
    0xfa700000U,
    0xf2280000U,
    0xcfc40000U,
    0xbba20000U,
    0xe3f30000U,
    0x23ef8000U,
    0xe9604000U,
    0x93d1a000U,
    0xf6de3000U,
    0x24a98800U,
    0x72860c00U,
    0x347ee00U,
    0xf5e76500U,
    0xc5961b80U,
    0xdcbc3d40U,
    0x81f9a020U,
    0x891a3010U,
    0x770b8818U,
    0x15750c3cU,
    0xea86e22U,
    0x2987251dU,
    0x79c7bba9U,
    0xc2a20d50U,
    0xf6702802U,
    0xa82c3c3aU,
    0x5cc4662eU,
    0xd5266902U,
    0x82b4759eU,
    0xd90c186eU,
    0x60739ba7U,
    0x412b7d78U,
    0x31458012U,
    0xa2e7403cU,
    0xe5142028U,
    0x78f97022U,
    0xdc9da83eU,
    0x9ccf7c22U,
    0x50d24625U,
    0xc05c193fU,
    0x29ee5dadU,
    0x22672459U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xa8000000U,
    0x2c000000U,
    0x52000000U,
    0x5f000000U,
    0x76800000U,
    0x5a400000U,
    0xe3600000U,
    0xadf00000U,
    0x4a780000U,
    0x70440000U,
    0x18620000U,
    0xd5730000U,
    0xa5388000U,
    0x3ea14000U,
    0xe7536000U,
    0x2b299000U,
    0xb26e7800U,
    0xed88f400U,
    0xb13eb200U,
    0xa8a00b00U,
    0xa6535780U,
    0x40ae47c0U,
    0x69ab6020U,
    0xe2d9010U,
    0xf7ec7818U,
    0xf34bf404U,
    0x471e322aU,
    0x38b54b0bU,
    0x379a3794U,
    0xcbf0d7d7U,
    0xf37f983dU,
    0xffc72406U,
    0xada12a20U,
    0x93d72f2fU,
    0xe66a7db8U,
    0x1b8d68d7U,
    0xe03b1db2U,
    0x6b27f8f2U,
    0x5195e58cU,
    0xf10a4ccdU,
    0x707a3793U,
    0x2340d7feU,
    0x4ce79838U,
    0x6833242fU,
    0xb4db2a11U,
    0xb7102f11U,
    0x4348fd9bU,
    0xdf1b28feU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xe8000000U,
    0xe4000000U,
    0xde000000U,
    0xbb000000U,
    0xe8800000U,
    0x24400000U,
    0x4ba00000U,
    0x7c300000U,
    0xfd680000U,
    0xc2440000U,
    0x8ca60000U,
    0xa6b70000U,
    0xe82d8000U,
    0xec634000U,
    0x63512000U,
    0x2b9f000U,
    0x82bc5800U,
    0x42ba0400U,
    0xa2bb0200U,
    0x12bc2d00U,
    0xfab9f980U,
    0x1eb84f40U,
    0xc0b92020U,
    0x7bbdf030U,
    0x933a5838U,
    0xb77d042cU,
    0xfcde823aU,
    0x80eb6d39U,
    0x7d86d9b7U,
    0xbfc2bf6eU,
    0x3366f81aU,
    0x95d7b439U,
    0x7dfbfa2aU,
    0x919c9933U,
    0xf2cf8385U,
    0xf0779649U,
    0x72cf83b4U,
    0x30779677U,
    0x92cf8398U,
    0x8077966eU,
    0x7acf83a8U,
    0x6477967aU,
    0xa4cf838aU,
    0xdf77966bU,
    0x4c4f83a4U,
    0xfb37966fU,
    0x7ef83b9U,
    0x87079661U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x98000000U,
    0x3c000000U,
    0x6e000000U,
    0x53000000U,
    0xb2800000U,
    0xfa400000U,
    0x50600000U,
    0x5ed00000U,
    0xcc080000U,
    0x80440000U,
    0x89620000U,
    0x8d530000U,
    0x89c98000U,
    0x53e0c000U,
    0xf313e000U,
    0xdba87000U,
    0x98371800U,
    0x7a9b5400U,
    0x41293200U,
    0x86767300U,
    0x18fdae80U,
    0x12fc9440U,
    0x33fbe020U,
    0xec7c7010U,
    0x5fbd1818U,
    0xe31c540cU,
    0x45eab226U,
    0xba51b30fU,
    0x494dce9bU,
    0xc4a32454U,
    0xeaf4980cU,
    0x69bc942eU,
    0xac19520cU,
    0xc969c31bU,
    0xbb12d695U,
    0xfac706fU,
    0x3237aa19U,
    0x4b9de727U,
    0x56af7c96U,
    0xa1b69766U,
    0x6e5b56aeU,
    0xb50cb07eU,
    0x43c44a36U,
    0x4a59736U,
    0xcaf064a0U,
    0x39b9c37fU,
    0x41864adU,
    0x6d6dc34cU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xe8000000U,
    0x8c000000U,
    0x92000000U,
    0x17000000U,
    0x26800000U,
    0x9ac00000U,
    0xbe600000U,
    0x6bd00000U,
    0xfe880000U,
    0x5cc40000U,
    0xef660000U,
    0xdc510000U,
    0xf3ca8000U,
    0xbfe34000U,
    0x8f926000U,
    0xce2d9000U,
    0x2f763800U,
    0x9b387400U,
    0x519db600U,
    0x7929e300U,
    0x99f7a680U,
    0xc9ff2040U,
    0x33fa6020U,
    0x68f99030U,
    0xfc783808U,
    0x21bd7414U,
    0x5159363aU,
    0x2c4fa323U,
    0xfea146a4U,
    0xdeb4f045U,
    0xe9dab829U,
    0xf38a3416U,
    0x51455627U,
    0x5927330eU,
    0xdbf3fe85U,
    0xf6fac474U,
    0xb979ee3fU,
    0x303c0702U,
    0xbd1c28bdU,
    0xe0eeb75dU,
    0xa7107096U,
    0xd9ef537aU,
    0x5c95feb8U,
    0x66abc450U,
    0xf8b36e34U,
    0xc8df4708U,
    0xfc0e48a3U,
    0x38032775U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x98000000U,
    0x5c000000U,
    0xe000000U,
    0xc5000000U,
    0xe0800000U,
    0x54400000U,
    0x59a00000U,
    0xb6900000U,
    0x9d80000U,
    0x41440000U,
    0x61220000U,
    0x1ed50000U,
    0xe7a8000U,
    0xaad0c000U,
    0xd478e000U,
    0x5d17000U,
    0xf3fea800U,
    0xe212c400U,
    0x8798c200U,
    0xb7e77d00U,
    0xf031fc80U,
    0xf0cefac0U,
    0x3b5ae020U,
    0x9e047010U,
    0xbd042828U,
    0x4c820414U,
    0x92402226U,
    0x58a60d17U,
    0x4175483U,
    0x96983ef1U,
    0x3d602218U,
    0x63760d05U,
    0x1aef54beU,
    0xa00c3ef9U,
    0x74ba2204U,
    0x82370d17U,
    0x2bcfd4b3U,
    0x26ddfee2U,
    0x26c2423dU,
    0x26e7bd38U,
    0x3ab11c88U,
    0xc38b8ac9U,
    0x817e4800U,
    0x9d57b43aU,
    0xbbc6a04U,
    0x7db4b922U,
    0x3009bea3U,
    0xcb847c4U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0x38000000U,
    0xfc000000U,
    0xea000000U,
    0x61000000U,
    0x30800000U,
    0xcb400000U,
    0xf0a00000U,
    0xb0100000U,
    0x31580000U,
    0x72440000U,
    0xcc260000U,
    0x99550000U,
    0xf4fc8000U,
    0xdcd5c000U,
    0x4139e000U,
    0xa0365000U,
    0x12098800U,
    0x7fb94400U,
    0x4c773a00U,
    0xc12a1500U,
    0x396ce880U,
    0xa4481ec0U,
    0xa59fe020U,
    0x5e235030U,
    0x64550828U,
    0x1e7c8424U,
    0xde96da0eU,
    0x4518453fU,
    0xcd6360baU,
    0x58f45ad8U,
    0xec6c5a2cU,
    0x4ac88502U,
    0x11de0094U,
    0x4103cac8U,
    0x60823222U,
    0x53469113U,
    0x9ca232a1U,
    0x62145bdaU,
    0xac5a809fU,
    0xa8c20acaU,
    0x6665d21eU,
    0x5971c108U,
    0x8fa93aa2U,
    0x1d29dfeaU,
    0x836eda88U,
    0x5d4e8fedU,
    0xf91dd281U,
    0x47670bfcU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0xf8000000U,
    0x1c000000U,
    0x32000000U,
    0xeb000000U,
    0x73800000U,
    0x21400000U,
    0x7de00000U,
    0x55b00000U,
    0x30880000U,
    0x42440000U,
    0x8a620000U,
    0xcaf10000U,
    0xdc6d8000U,
    0x6b73c000U,
    0xc62ae000U,
    0xd149000U,
    0xe6d8d800U,
    0x96795c00U,
    0x342a6a00U,
    0x8612bf00U,
    0x55b9580U,
    0xff3cc840U,
    0xadc8e020U,
    0xfda59010U,
    0xecd55808U,
    0x25fa9c2cU,
    0x75688a3eU,
    0x6bf22f07U,
    0x18e94d8cU,
    0x2bb0947aU,
    0xc18d0a3cU,
    0xaec5ef18U,
    0xbea1ad97U,
    0xab550479U,
    0x42b85212U,
    0x858f7307U,
    0x70c127a6U,
    0xbfa32b64U,
    0x9fd31fb5U,
    0xda7ee745U,
    0x2e29ad8aU,
    0x19110450U,
    0x10da523fU,
    0xe37e7306U,
    0x66aca78aU,
    0x23d0eb57U,
    0x1879ffb4U,
    0x1d2a7750U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x98000000U,
    0x1c000000U,
    0x5e000000U,
    0xab000000U,
    0x85800000U,
    0x3cc00000U,
    0xa6600000U,
    0x23700000U,
    0xbc880000U,
    0xd3c40000U,
    0xc1e20000U,
    0x5ab70000U,
    0xfc6a8000U,
    0xcdf0c000U,
    0xa5cae000U,
    0xf961f000U,
    0x8cf5d800U,
    0x414fec00U,
    0xd1278600U,
    0x2ad10300U,
    0x101ba380U,
    0xe6fdb840U,
    0x27c8e020U,
    0xac66f010U,
    0x12775838U,
    0x300b2c14U,
    0xcf876626U,
    0xedc3f307U,
    0x7ae6fb97U,
    0xa735946aU,
    0x8caf0601U,
    0xad96c31fU,
    0x31bbc391U,
    0x9e6c885cU,
    0xc8f7d829U,
    0xa348ec23U,
    0x9425061fU,
    0xcc55c328U,
    0x2d5b43b8U,
    0x3e5f487bU,
    0x57ddb837U,
    0x1d1adc0cU,
    0xc47abe15U,
    0xb8881f3fU,
    0xd1c37d8bU,
    0xd4e39753U,
    0x243625a3U,
    0xdd2fbb44U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x38000000U,
    0xc4000000U,
    0x6e000000U,
    0x59000000U,
    0x36800000U,
    0xb7c00000U,
    0xb5e00000U,
    0xc7900000U,
    0xc2f80000U,
    0x62c40000U,
    0xe1620000U,
    0xb550000U,
    0x9a988000U,
    0xef15c000U,
    0xe43c2000U,
    0xada27000U,
    0x13304800U,
    0xb74d7400U,
    0xfa4f1e00U,
    0x7ac91f00U,
    0xe009d480U,
    0x256f53c0U,
    0xf03e2020U,
    0x1ba77010U,
    0x3e30c828U,
    0xc7ccb404U,
    0xe8893e0eU,
    0x53aa6f31U,
    0xa75b1c9bU,
    0x3df6e7d6U,
    0xd42f9e2dU,
    0x3a18df3dU,
    0x25d7f485U,
    0xb95823f5U,
    0xacf6e81eU,
    0xaeafc439U,
    0xfdbf60bU,
    0x5b33db10U,
    0xbb4aa2a5U,
    0xd84948e7U,
    0xa1c8a2afU,
    0x1d8c48dcU,
    0x572822b1U,
    0xf39d88ccU,
    0xb19602adU,
    0xffaf8c8U,
    0xa246cab3U,
    0xdba64cd9U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0x8000000U,
    0xf4000000U,
    0x12000000U,
    0x67000000U,
    0x1800000U,
    0xe8400000U,
    0xb9200000U,
    0xb6f00000U,
    0x5c680000U,
    0x4d440000U,
    0xe7a20000U,
    0x83310000U,
    0x9b0b8000U,
    0x3f944000U,
    0x9fbda000U,
    0x69dd9000U,
    0x78eb800U,
    0x55574c00U,
    0x85586200U,
    0x654b9900U,
    0xbbb4ef80U,
    0x9bce9f40U,
    0xbe77a020U,
    0x74a89010U,
    0x48a73808U,
    0x16b20c1cU,
    0x314e4202U,
    0x99b2493dU,
    0xd4cff784U,
    0x3bf04359U,
    0x86eb7a20U,
    0x6281452aU,
    0xb3c235a6U,
    0xe2624a71U,
    0x6c532db5U,
    0x6dd9967eU,
    0x5d8e7795U,
    0xe6510375U,
    0xe6df5a0cU,
    0xe2099504U,
    0xf712ad87U,
    0xd778d64fU,
    0x3c3a57b0U,
    0x8e99d348U,
    0x1b2fc21aU,
    0x61e3093bU,
    0xfb13d7bbU,
    0x797c934cU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0x88000000U,
    0x54000000U,
    0x96000000U,
    0x31000000U,
    0x7f800000U,
    0xfec00000U,
    0x91200000U,
    0x85500000U,
    0x24c80000U,
    0xbdc40000U,
    0xf1a20000U,
    0x99150000U,
    0xaeae8000U,
    0x2c704000U,
    0x4d98a000U,
    0xa30db000U,
    0xe7610800U,
    0x6c30bc00U,
    0x45fed600U,
    0x35bef900U,
    0xc5dd4280U,
    0x5f6fca40U,
    0x37d2a020U,
    0xf78cb010U,
    0x5d258828U,
    0x2f51fc34U,
    0xa7caf622U,
    0x3d460915U,
    0x9de26aa5U,
    0x4b76864cU,
    0xe31fde3fU,
    0x524e452fU,
    0xd083948cU,
    0xa4413355U,
    0x2667e28bU,
    0xbb77a6aU,
    0xc73d2811U,
    0xb69c4c0eU,
    0x6f8bfe3eU,
    0x6126b515U,
    0x9d54bcb0U,
    0x58cc7f50U,
    0xafc09caaU,
    0xdea48f57U,
    0x8397b49eU,
    0xb9e9c351U,
    0x7290ca9dU,
    0x266a3663U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x68000000U,
    0x3c000000U,
    0x52000000U,
    0xf7000000U,
    0x69800000U,
    0x66400000U,
    0x91600000U,
    0x20b00000U,
    0x52580000U,
    0xf7440000U,
    0xb1e60000U,
    0xf2710000U,
    0x5ff98000U,
    0x4f574000U,
    0xad2fe000U,
    0x2a3f9000U,
    0x93743800U,
    0x377f0c00U,
    0x91965200U,
    0x9a8adb00U,
    0x59291d80U,
    0xb4392ec0U,
    0x7e71e020U,
    0xa5fa9030U,
    0xa453b808U,
    0xa6ad4c0cU,
    0xd37e321aU,
    0x57970b0fU,
    0x238d4594U,
    0xa5aff2fdU,
    0x24fdea3aU,
    0xdcd39729U,
    0x20692facU,
    0xb0db25c4U,
    0x4a8325aeU,
    0xa1c322c2U,
    0x72203210U,
    0x1f520b3dU,
    0x152ac59fU,
    0x6e3db2c9U,
    0xa5758a21U,
    0xc67e4700U,
    0x611577b6U,
    0x3049f9d8U,
    0x30892f8cU,
    0xa2b25f4U,
    0xfbbb258dU,
    0xb13722caU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0xa8000000U,
    0xec000000U,
    0xb6000000U,
    0x95000000U,
    0xef800000U,
    0x61c00000U,
    0x55200000U,
    0x90700000U,
    0xc3480000U,
    0x36c40000U,
    0xfda60000U,
    0x41370000U,
    0xe32b8000U,
    0xacd14000U,
    0x2ff96000U,
    0x332eb000U,
    0x54d52800U,
    0xfbfb3c00U,
    0xb12cee00U,
    0x33d3d900U,
    0xdb7b0b80U,
    0x1c6b3640U,
    0x7db76020U,
    0x906db030U,
    0x7bb0a838U,
    0x4d697c1cU,
    0x8300e2aU,
    0x32af293bU,
    0x2412c3adU,
    0xfb5cfa65U,
    0x139a461bU,
    0x773da528U,
    0x1f8885adU,
    0xa0615f78U,
    0x5a12c3baU,
    0x325cfa46U,
    0x21a460aU,
    0x1ffda519U,
    0xbb288591U,
    0x28d15f54U,
    0x95fac3b9U,
    0x6028fa46U,
    0x8654462bU,
    0x99bea522U,
    0x33cd05afU,
    0x63831f47U,
    0x67c6238cU,
    0x88240a6bU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0xd8000000U,
    0xd4000000U,
    0x2a000000U,
    0xd3000000U,
    0x62800000U,
    0xcbc00000U,
    0x59e00000U,
    0x64500000U,
    0x7f80000U,
    0x89440000U,
    0x62220000U,
    0x45b50000U,
    0x7ad8000U,
    0x7cbac000U,
    0xec60a000U,
    0x6f165000U,
    0x5ade1800U,
    0x40745400U,
    0x3f4c3e00U,
    0xdd6c3f00U,
    0xd8df6a80U,
    0x7f7073c0U,
    0xb3cd2020U,
    0x87ac9010U,
    0x3cbeb828U,
    0x4c62042cU,
    0xdf122636U,
    0x82d86b35U,
    0x9473548aU,
    0x154c4cf4U,
    0xe6a4ab8U,
    0xba58e3e2U,
    0xb4b1981eU,
    0xea2b9425U,
    0xe3f91e1fU,
    0x3b44af3bU,
    0xc523d2a4U,
    0xbd3777d0U,
    0xc76a8633U,
    0x93da3b09U,
    0x69f74c9dU,
    0xe20918dcU,
    0xd549f497U,
    0xee6b1cceU,
    0xaa5bd294U,
    0xdcb377ccU,
    0xe6288609U,
    0x1dff3b2aU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x48000000U,
    0x84000000U,
    0x76000000U,
    0x3000000U,
    0xa1800000U,
    0x400000U,
    0xca00000U,
    0x46f00000U,
    0xfd480000U,
    0x85c40000U,
    0x6ae20000U,
    0x51530000U,
    0xe6398000U,
    0xc2ce4000U,
    0x12822000U,
    0xa9c2b000U,
    0xe8e29800U,
    0xc56cc00U,
    0xf0be6200U,
    0x5d0bf500U,
    0x99679f80U,
    0x3413fe40U,
    0x501ba020U,
    0xd9fcf010U,
    0x5928b818U,
    0x97507c0cU,
    0xed3efa12U,
    0x874e3921U,
    0x54c07d9dU,
    0xee664b40U,
    0x8b961f88U,
    0x8759be50U,
    0x7adb803bU,
    0xd09d400dU,
    0x353ba035U,
    0x5b4cf00cU,
    0xbec0b815U,
    0x67647c35U,
    0x9314fa0cU,
    0xd7993930U,
    0xa2bbfdafU,
    0x380b0b7bU,
    0x23e5bfa6U,
    0x69d14e63U,
    0xe6f93821U,
    0x62aa3c3eU,
    0x3616da0fU,
    0x4d1b8904U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0xe8000000U,
    0x14000000U,
    0x22000000U,
    0x8d000000U,
    0x19800000U,
    0xf7c00000U,
    0x69200000U,
    0x14700000U,
    0x78980000U,
    0xaa440000U,
    0xf4e60000U,
    0x94530000U,
    0xaf688000U,
    0x541b4000U,
    0x1802a000U,
    0x2c041000U,
    0xbe07e800U,
    0xab070c00U,
    0x5e805e00U,
    0x7742f900U,
    0xa565db80U,
    0x79760c0U,
    0x1c4a2020U,
    0x316f5030U,
    0x4f1d4818U,
    0xde871c04U,
    0xb741b63aU,
    0xc566f505U,
    0x17950588U,
    0xf44ad9e3U,
    0x256b5ba6U,
    0x6d1f20cdU,
    0x53800022U,
    0xaec00031U,
    0x32a0003cU,
    0x7eb0002bU,
    0xe038000fU,
    0x5df40003U,
    0xc75e0025U,
    0xa767000bU,
    0x3a96801aU,
    0x9dcc4033U,
    0x2aac202bU,
    0xf83c5005U,
    0x71f5c834U,
    0x795c5c12U,
    0xc63163fU,
    0x6412e531U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0x58000000U,
    0x4c000000U,
    0x2e000000U,
    0x59000000U,
    0x57800000U,
    0x2b400000U,
    0x14a00000U,
    0xb4100000U,
    0x3ac80000U,
    0x32c40000U,
    0xd6e60000U,
    0xdf310000U,
    0xe19a8000U,
    0x26aec000U,
    0x6b306000U,
    0x139e7000U,
    0x29ad4800U,
    0x79b0fc00U,
    0x195efa00U,
    0x34c3500U,
    0xa0845880U,
    0xe5c60240U,
    0x4862e020U,
    0xdbf4b030U,
    0xc27b2808U,
    0xf01f8c14U,
    0xf0e93216U,
    0x62120913U,
    0xbfcac28bU,
    0x33444756U,
    0xb8a3f0b5U,
    0xea164e7aU,
    0x6bc9322dU,
    0x71420909U,
    0x9fa2c290U,
    0xbc90474bU,
    0x5b0df088U,
    0x60a34e42U,
    0x6615b20eU,
    0x65cdc931U,
    0x78402294U,
    0x9024f764U,
    0xdbd6d8bcU,
    0x61acc24aU,
    0x8db4800bU,
    0xb5bc003U,
    0x7c4ce02bU,
    0xba01b027U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0x68000000U,
    0xcc000000U,
    0xae000000U,
    0x27000000U,
    0xf7800000U,
    0x98c00000U,
    0xa7a00000U,
    0x5fb00000U,
    0xdba80000U,
    0x9440000U,
    0x64620000U,
    0xe9910000U,
    0x7df8000U,
    0x44cf4000U,
    0x41506000U,
    0xa87e7000U,
    0x77bb800U,
    0xacfd7c00U,
    0x223ee600U,
    0xf69ead00U,
    0x54ad7580U,
    0x52c5f940U,
    0x82a7e020U,
    0xf1353010U,
    0xbe9d808U,
    0x65a20c3cU,
    0x66b2de1aU,
    0x43289133U,
    0x5a01f3abU,
    0x9d042449U,
    0xfa86ad9dU,
    0xda46f576U,
    0x29e2be01U,
    0x7c56e13bU,
    0xe2fa4ba4U,
    0x9539584dU,
    0xb9184b88U,
    0x98685850U,
    0xff67cbbfU,
    0x98171852U,
    0x541fabb6U,
    0x4aed6844U,
    0xc9261387U,
    0xeff11468U,
    0x674f7583U,
    0x9394f975U,
    0x6ad86000U,
    0xd64a7018U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x68000000U,
    0xdc000000U,
    0x96000000U,
    0xb9000000U,
    0x1c800000U,
    0xf400000U,
    0xefa00000U,
    0x80300000U,
    0xba680000U,
    0xddc40000U,
    0xade20000U,
    0x59130000U,
    0xaa1d8000U,
    0x458f4000U,
    0x3fd0e000U,
    0x387db000U,
    0xf85f4800U,
    0x64a82400U,
    0x4ba0da00U,
    0x3231ad00U,
    0xf168b980U,
    0xea44df40U,
    0x25256020U,
    0x5676f010U,
    0xf94da818U,
    0x3ab6942cU,
    0x242a121aU,
    0x92e2c937U,
    0x49283a5U,
    0xdddfc26eU,
    0x376d11a7U,
    0xcb464b53U,
    0xeda57203U,
    0xa333391cU,
    0x51e8abacU,
    0xc301166cU,
    0x1b8063b4U,
    0x16c1725fU,
    0xda67d9b0U,
    0xb1d52f40U,
    0x157f4811U,
    0x7ed82426U,
    0x9ce8da0cU,
    0xb585ad3bU,
    0xebc2b9afU,
    0x84e3df77U,
    0xfd92e004U,
    0xa15eb020U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x38000000U,
    0xd4000000U,
    0x16000000U,
    0xd9000000U,
    0x6a800000U,
    0xe9400000U,
    0x73200000U,
    0xe1700000U,
    0xa1b80000U,
    0x71c40000U,
    0xdd620000U,
    0x3dd50000U,
    0x690a8000U,
    0x691dc000U,
    0x4f70a000U,
    0xecbfb000U,
    0xad454800U,
    0xbd221400U,
    0x1c752a00U,
    0xb53f0900U,
    0xad84b380U,
    0x6c431c0U,
    0xfae22020U,
    0x8167010U,
    0x7a6fe828U,
    0xa9cca414U,
    0x32f8e20eU,
    0x59e5dd35U,
    0x3993b985U,
    0x96ad48f6U,
    0xd0297bbaU,
    0x1b6ee5eaU,
    0x574d2a14U,
    0x6dbb093cU,
    0xa3c6b38eU,
    0x8a6131fdU,
    0xa50a01cU,
    0xc4cfb01cU,
    0xfe7d482dU,
    0xa1a61402U,
    0x9c372a1bU,
    0x649a090cU,
    0x19b6339aU,
    0x2e5df1fdU,
    0x71508022U,
    0xd14cc014U,
    0x6cb82032U,
    0xed477038U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x88000000U,
    0xd4000000U,
    0xce000000U,
    0xfb000000U,
    0xb8800000U,
    0xc3400000U,
    0xa4e00000U,
    0xe8500000U,
    0x8ab80000U,
    0x69c40000U,
    0x46a60000U,
    0xa1330000U,
    0xb22a8000U,
    0xb4584000U,
    0x7494a000U,
    0xef9b7000U,
    0xe3325800U,
    0x1b2d0400U,
    0x8ddbfa00U,
    0x6a557700U,
    0x43bfaa80U,
    0x4569c0U,
    0xd0662020U,
    0xd9173030U,
    0x9f58f818U,
    0x84117414U,
    0x98dd2222U,
    0xd9d73335U,
    0x807c70b3U,
    0x6be02efeU,
    0xed5f28eU,
    0x5afc6dc0U,
    0xf1a3da11U,
    0x2bb5471eU,
    0xa06bd298U,
    0x453f5dfbU,
    0x40052220U,
    0xa0033313U,
    0x300270a9U,
    0xd8072ef7U,
    0x5c017298U,
    0x1a032df4U,
    0x3503fa38U,
    0x4381773cU,
    0x7bc1aa84U,
    0x67a269f9U,
    0x4cb2a035U,
    0x62e87004U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x8000000U,
    0x9c000000U,
    0x32000000U,
    0xeb000000U,
    0xa0800000U,
    0xc1400000U,
    0x1f600000U,
    0xc2700000U,
    0xc7e80000U,
    0x37c40000U,
    0x83260000U,
    0x90950000U,
    0xf15e8000U,
    0x5f8c4000U,
    0x7f36e000U,
    0x5a8a9000U,
    0x66b0d800U,
    0xa04dc400U,
    0xc013aa00U,
    0x281d0b00U,
    0x74e99b80U,
    0xc3440340U,
    0x4c606020U,
    0x86f2d030U,
    0x70a83828U,
    0x65a65434U,
    0xa4d3f202U,
    0xefbd8f27U,
    0x533c518cU,
    0x607ed87aU,
    0x341f4388U,
    0x86ecc740U,
    0x88454a0fU,
    0x3ce79b34U,
    0x4fb1439bU,
    0xf3cdc75eU,
    0x95d5ca0eU,
    0x883adb09U,
    0x78ff23b0U,
    0x115e1769U,
    0xef8d7212U,
    0x731cf01U,
    0x1e8ab18bU,
    0xc0b4485bU,
    0xe54f9babU,
    0xb9910344U,
    0xa2dee002U,
    0xa4e900dU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0xf8000000U,
    0x14000000U,
    0x32000000U,
    0x1d000000U,
    0xa2800000U,
    0x60400000U,
    0xa4200000U,
    0x7f00000U,
    0x93080000U,
    0xffc40000U,
    0xf6e20000U,
    0xeb970000U,
    0xecd98000U,
    0xb53bc000U,
    0xa12ea000U,
    0x6f309000U,
    0x2e6c6800U,
    0xd4905400U,
    0x3b5fe200U,
    0x4bf8d100U,
    0x8b4e6780U,
    0xfe63440U,
    0x23152020U,
    0x559c5010U,
    0x499b4838U,
    0x379b040cU,
    0xdc9d2a3eU,
    0x99181505U,
    0xaadded8cU,
    0xea3eb147U,
    0x6aca588U,
    0x89f6b548U,
    0x200a0fb1U,
    0x7e42605dU,
    0x3f20c202U,
    0x5a778126U,
    0x84ceafb7U,
    0x7521f074U,
    0x13772a01U,
    0xf44b1527U,
    0x38666d9dU,
    0xedd27149U,
    0x87fb85b0U,
    0x3d4de546U,
    0x8e0c7aaU,
    0x4096a44dU,
    0x4959480eU,
    0xb6fc042aU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x78000000U,
    0x6c000000U,
    0x1e000000U,
    0x55000000U,
    0x77800000U,
    0x3cc00000U,
    0xcc200000U,
    0xd9100000U,
    0x51e80000U,
    0xce440000U,
    0x4f620000U,
    0x9df50000U,
    0xc6df8000U,
    0x75bfc000U,
    0x9e4d6000U,
    0x4993f000U,
    0xb1aa2800U,
    0x4c26fc00U,
    0x9914c600U,
    0xf1eb3100U,
    0x3e447080U,
    0x3762ab40U,
    0xf1f0e020U,
    0xd8d93010U,
    0x20b8c828U,
    0xe9cacc3cU,
    0x75538e1eU,
    0x7d8e3d1bU,
    0x95329e87U,
    0xc8fb6655U,
    0x3faa56bdU,
    0x7121aa5fU,
    0xaa91d8bbU,
    0x372b975aU,
    0xad614602U,
    0xbef5f104U,
    0xa05c90a2U,
    0xc4ff9b55U,
    0x31aa2815U,
    0xc26fc0cU,
    0x3914c626U,
    0x1eb3102U,
    0x46447088U,
    0x5b62ab42U,
    0xeff0e035U,
    0x8dd9301bU,
    0x5738c80cU,
    0xd50acc37U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x48000000U,
    0x4c000000U,
    0xe2000000U,
    0xd000000U,
    0x44800000U,
    0x29400000U,
    0x3200000U,
    0xb8d00000U,
    0xebe80000U,
    0xc8c40000U,
    0xd2e60000U,
    0x58b30000U,
    0x21198000U,
    0x757e4000U,
    0x99886000U,
    0xe7361000U,
    0x37dce800U,
    0xa09ee400U,
    0x94baea00U,
    0x31ee2900U,
    0x61c05e80U,
    0x6864c340U,
    0xe6f7e020U,
    0x6fbb5030U,
    0xe6d0818U,
    0xb706b40cU,
    0xdd866212U,
    0xdbc2dd13U,
    0xf1605cb8U,
    0x14770e43U,
    0x9dfcd4b1U,
    0xa2cbfa7aU,
    0xc114d6b8U,
    0xb78c3752U,
    0xc831e210U,
    0x1e5b9d1dU,
    0xfd5fbc86U,
    0xf6d85e4aU,
    0xc61fdc93U,
    0xd0fa4e77U,
    0x464d34b7U,
    0xb853aa62U,
    0xcca85e8cU,
    0x74e0c351U,
    0x5bb1e039U,
    0xda98502aU,
    0x6dbc883dU,
    0xf36cf435U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x58000000U,
    0x54000000U,
    0x6000000U,
    0x61000000U,
    0xd0800000U,
    0x2dc00000U,
    0x96a00000U,
    0x59d00000U,
    0x7b80000U,
    0x88440000U,
    0x8de60000U,
    0x93b10000U,
    0x70498000U,
    0xf7eec000U,
    0xc6b8a000U,
    0xa8c33000U,
    0xd8258800U,
    0x6114c400U,
    0x77988e00U,
    0xc550e500U,
    0x987d5680U,
    0x69e081c0U,
    0xdb72020U,
    0x654cf030U,
    0x116ca808U,
    0xd27d340cU,
    0xbae3a616U,
    0xaa361115U,
    0x9109d081U,
    0x768a60d8U,
    0x62ca5894U,
    0x152fa4fbU,
    0xcd9b568dU,
    0x6e5181eaU,
    0x5bfea03fU,
    0xc3a2300bU,
    0x5f54083cU,
    0x37e0425U,
    0xf2662e3fU,
    0xf3f2d53bU,
    0x31a95ea1U,
    0x165e85efU,
    0xe1f10e06U,
    0xb6ae2517U,
    0xb7ddf692U,
    0x74b7b1edU,
    0x1cca82eU,
    0x2aad3404U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x88000000U,
    0x54000000U,
    0xfa000000U,
    0x37000000U,
    0x21800000U,
    0x60c00000U,
    0x30200000U,
    0x91300000U,
    0x1bb80000U,
    0x92440000U,
    0x43620000U,
    0x42d70000U,
    0x51298000U,
    0xc7084000U,
    0x8f3ca000U,
    0x9806d000U,
    0x4c053800U,
    0xf603cc00U,
    0x21046600U,
    0x3080b100U,
    0xd8404180U,
    0xbc67b9c0U,
    0xd7572020U,
    0xfbe99010U,
    0x48281838U,
    0x6b895c0cU,
    0x197ffe22U,
    0xd962ad15U,
    0x5d09fbeU,
    0x18a884cdU,
    0xc3cda7a8U,
    0xcd1f48c8U,
    0x6a33c194U,
    0x8c3cf9f8U,
    0x3380003cU,
    0x73c0002dU,
    0x83a00034U,
    0xa2f00004U,
    0x78180000U,
    0xb40031U,
    0xb37a0019U,
    0x16630017U,
    0x18538011U,
    0xe66b4025U,
    0xb6ef2012U,
    0x1ead901cU,
    0xcaca1834U,
    0x799e5c2aU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0xe8000000U,
    0x2c000000U,
    0xce000000U,
    0xdf000000U,
    0x74800000U,
    0xa0400000U,
    0x10a00000U,
    0x19f00000U,
    0x28880000U,
    0x4fc40000U,
    0xe6660000U,
    0x18150000U,
    0xda5a8000U,
    0x427b4000U,
    0x1dcb6000U,
    0x76e17000U,
    0xca577800U,
    0x93fb6400U,
    0x8c0da200U,
    0xc782d500U,
    0x7ac22780U,
    0x9fe5e840U,
    0xc5d7e020U,
    0x553f3030U,
    0x95ee9828U,
    0xa1555414U,
    0x7d7fba3aU,
    0x5949c10bU,
    0xcea47db3U,
    0x4ef21977U,
    0x800985bdU,
    0x99823d58U,
    0xedc7478cU,
    0x97659862U,
    0x43941838U,
    0xb69e143cU,
    0x369cda18U,
    0xf69cb12eU,
    0x569d05a2U,
    0x6987d44U,
    0xee98a78dU,
    0xc29ea874U,
    0xc9c8029U,
    0xd39e403dU,
    0xa719e006U,
    0x75e303dU,
    0x17fa1812U,
    0xe0f141eU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x8000000U,
    0x24000000U,
    0xa000000U,
    0xbd000000U,
    0x75800000U,
    0xfbc00000U,
    0xaa600000U,
    0xf9100000U,
    0x1bc80000U,
    0x3f440000U,
    0x1a260000U,
    0xc7b30000U,
    0x1c3d8000U,
    0x75dc4000U,
    0xfc0b2000U,
    0x73215000U,
    0x10356800U,
    0xaefd6c00U,
    0x183f3e00U,
    0x6fde6300U,
    0x990a5080U,
    0x9aa24a40U,
    0xcdf0a020U,
    0x979e1030U,
    0x23abc818U,
    0x47547c2cU,
    0x826f7602U,
    0x28355f09U,
    0x42fb8682U,
    0x563e056fU,
    0x68db6ebdU,
    0x598b294eU,
    0x30e17092U,
    0x96531a62U,
    0x79edc83cU,
    0xb4f77c1aU,
    0x981af61eU,
    0xd6d1f3bU,
    0xcb6a69aU,
    0x82bc5545U,
    0x9b86aaU,
    0xfb2e0543U,
    0x11136e8dU,
    0x4fcf2978U,
    0x5d477096U,
    0x33201a4eU,
    0xb0304819U,
    0x7efb3c3fU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0xb8000000U,
    0x4c000000U,
    0x26000000U,
    0xb7000000U,
    0x86800000U,
    0x64c00000U,
    0xcd600000U,
    0xde700000U,
    0xa2280000U,
    0x71440000U,
    0xdd260000U,
    0xdad70000U,
    0x8ebc8000U,
    0xac59c000U,
    0x4b686000U,
    0x90643000U,
    0x9f03800U,
    0x176a7400U,
    0xce640600U,
    0x12f6fb00U,
    0x27ef1b80U,
    0xa5a52d40U,
    0x1512e020U,
    0xbb5af030U,
    0x7decd838U,
    0x3ca38424U,
    0xa0925e2eU,
    0x1b1bbf13U,
    0xb149a589U,
    0x7433626dU,
    0xaf8b1d81U,
    0x5053d669U,
    0xec7dfbabU,
    0xa63fdd63U,
    0x3b9e381eU,
    0xa289741bU,
    0xdfd68628U,
    0x853c3b2cU,
    0x871dfba5U,
    0xf4fdd4cU,
    0xff363829U,
    0x270d7417U,
    0x77908600U,
    0xcd9b3b13U,
    0x8d897bb1U,
    0x65521d4aU,
    0xeff8581cU,
    0x97e4435U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0xe8000000U,
    0xb4000000U,
    0x22000000U,
    0x45000000U,
    0xed800000U,
    0x25400000U,
    0xa1600000U,
    0xa8100000U,
    0xee480000U,
    0x9bc40000U,
    0xcea60000U,
    0x64b70000U,
    0x1ff98000U,
    0xb1bb4000U,
    0x65fa000U,
    0x558c1000U,
    0x8566a800U,
    0x7210ac00U,
    0x274d4a00U,
    0x38437b00U,
    0xd0e29880U,
    0xfb518640U,
    0x18282020U,
    0x73545030U,
    0x5c2e8838U,
    0x5954fc0cU,
    0x9d2bc23aU,
    0x7ed3872dU,
    0x496f5a88U,
    0x10350151U,
    0x813efa9bU,
    0xb29a1179U,
    0x97afd2b0U,
    0x3312fd56U,
    0xc0cab899U,
    0xc05d677U,
    0x8e06a819U,
    0xdb00ac19U,
    0xe854a36U,
    0x47c77b15U,
    0x98a498a0U,
    0xe3b6864aU,
    0x8779a021U,
    0x917b1038U,
    0x367f282aU,
    0x7efbec1eU,
    0x863aea29U,
    0xea1b6b2aU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0xd8000000U,
    0x94000000U,
    0x52000000U,
    0x49000000U,
    0x7e800000U,
    0xfa400000U,
    0x35e00000U,
    0x45700000U,
    0xf6780000U,
    0x5bc40000U,
    0x82260000U,
    0x11570000U,
    0xf4298000U,
    0xe46ac000U,
    0xfc8ea000U,
    0xad7f9000U,
    0x4c46c800U,
    0xd6e5b400U,
    0x36f33200U,
    0xc8b8df00U,
    0x91649380U,
    0x4a363fc0U,
    0x43192020U,
    0x5bf65030U,
    0xfc3fe838U,
    0x5623e40cU,
    0x6354da36U,
    0x6d2f3b25U,
    0x72ee4994U,
    0x4aca04d2U,
    0x5e98e9bfU,
    0x123194ceU,
    0x17182195U,
    0xe9f320edU,
    0x853a9393U,
    0xf0a53fcfU,
    0xd16a01aU,
    0xacb900fU,
    0x7e98c838U,
    0xc236b43cU,
    0xff1cb20fU,
    0xa5f51f33U,
    0x433bb3a8U,
    0xeba76fdeU,
    0x3a974822U,
    0x8e0b743fU,
    0xb13b9231U,
    0xb2a04f24U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x18000000U,
    0x1c000000U,
    0xae000000U,
    0x8f000000U,
    0x90800000U,
    0x7bc00000U,
    0x4ee00000U,
    0xbc300000U,
    0xc0380000U,
    0x1e440000U,
    0xc0a20000U,
    0xc4970000U,
    0xa8aa8000U,
    0x50ecc000U,
    0x1b4ee000U,
    0xfd5c7000U,
    0xf37f800U,
    0xebbc400U,
    0x42827e00U,
    0x4ac7a700U,
    0xa963c980U,
    0x1b71edc0U,
    0x431e6020U,
    0x7f93b010U,
    0x82299838U,
    0xee287414U,
    0xa82be606U,
    0x932fd307U,
    0xf9a82fabU,
    0xa76e3ee3U,
    0x440e4f84U,
    0x32798eceU,
    0xd8e5d78bU,
    0xdf36faebU,
    0x56bcb1aeU,
    0xbe81e9c4U,
    0xb4c07e05U,
    0x3e60a711U,
    0x97f1499bU,
    0x96d92dfaU,
    0xbe72803cU,
    0xae98c03aU,
    0x55d4e017U,
    0xf88f7002U,
    0xefbf7821U,
    0xfd000412U,
    0x11861e38U,
    0xd4471728U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x28000000U,
    0xb4000000U,
    0x22000000U,
    0xa7000000U,
    0xb800000U,
    0xf3c00000U,
    0x64200000U,
    0x7b700000U,
    0xd5880000U,
    0x74240000U,
    0x33720000U,
    0x91890000U,
    0xae228000U,
    0x8734000U,
    0xc0ca000U,
    0xd8e39000U,
    0xc0d67800U,
    0x8f3cfc00U,
    0x9a8c0e00U,
    0xaba15900U,
    0x12b52780U,
    0xaaafa240U,
    0x42d67820U,
    0xb83cfc10U,
    0x990c0e08U,
    0x3c615934U,
    0x7c95278aU,
    0xc2dfa26dU,
    0xbede7828U,
    0x98d8fc39U,
    0xc5de0e0aU,
    0x25585908U,
    0x631fa793U,
    0xc5f8e273U,
    0x5428d81dU,
    0xa5966c24U,
    0x9858f606U,
    0x339ee52cU,
    0x5bbd89b8U,
    0xbec96b71U,
    0x8a47279eU,
    0x58e6a252U,
    0x80d4f816U,
    0xaf3fbc1fU,
    0x4a88ae16U,
    0x83a6c92fU,
    0xa6b15fb0U,
    0x88aa5e45U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x38000000U,
    0x54000000U,
    0x4e000000U,
    0x17000000U,
    0x6a800000U,
    0x6b400000U,
    0xa2a00000U,
    0x80b00000U,
    0x6280000U,
    0xdaa40000U,
    0x34b60000U,
    0xd8290000U,
    0x45a18000U,
    0x3237c000U,
    0xa96ba000U,
    0xbe03f000U,
    0xcf077800U,
    0xae80f400U,
    0xad44aa00U,
    0xd9a46d00U,
    0xf035f180U,
    0x34691b40U,
    0x5877820U,
    0xb5c0f430U,
    0x17e4aa08U,
    0xbd146d2cU,
    0x801df18eU,
    0xadcd1b55U,
    0x15b17833U,
    0x11a9f435U,
    0x9a652a12U,
    0x64d3ad36U,
    0x8dfe51a6U,
    0x49daeb75U,
    0xe8280032U,
    0xbda40003U,
    0x4636001fU,
    0x57690000U,
    0x91018037U,
    0xf187c039U,
    0x8bc3a038U,
    0x18e7f01cU,
    0x33917824U,
    0x9d59f407U,
    0x4c6d2a12U,
    0xb187ad1aU,
    0x6bc05197U,
    0x88e7eb54U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x18000000U,
    0xe4000000U,
    0xf2000000U,
    0x85000000U,
    0xe800000U,
    0xb1c00000U,
    0xf5200000U,
    0x9c100000U,
    0x5e80000U,
    0x3d240000U,
    0x30160000U,
    0x9beb0000U,
    0x46238000U,
    0xb596c000U,
    0xb7ac2000U,
    0x7b441000U,
    0xe6e2e800U,
    0x64345400U,
    0x9b7d9e00U,
    0x870f4100U,
    0x6b11b480U,
    0x4e6f3140U,
    0xe262e820U,
    0x84f45430U,
    0xeadd9e18U,
    0x3bdf413cU,
    0x7f59b486U,
    0x3f9b3179U,
    0xde3ce81cU,
    0x8aeb5411U,
    0x62a01e1bU,
    0x5568110U,
    0x4e0814bbU,
    0xcb96e15eU,
    0xfcafa01dU,
    0x86c2d01eU,
    0xdea6c817U,
    0xb3544436U,
    0xa909762aU,
    0xa8101533U,
    0xbfefaa90U,
    0xd426b070U,
    0xc0977c96U,
    0xa12b7563U,
    0x2e839e32U,
    0xe1c04127U,
    0x7d2434a8U,
    0x9012f147U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x58000000U,
    0xdc000000U,
    0xe6000000U,
    0x89000000U,
    0x74800000U,
    0xa8400000U,
    0x7b200000U,
    0xb2100000U,
    0xb8b80000U,
    0x47240000U,
    0x44120000U,
    0x9bb0000U,
    0xbfa68000U,
    0x5250c000U,
    0x279de000U,
    0x9f31b000U,
    0xcbac8800U,
    0x6f1a4400U,
    0xc176f200U,
    0x18c5100U,
    0x258d5480U,
    0x6f89f7c0U,
    0x688c8820U,
    0x410a4410U,
    0xffcef218U,
    0x9fa85114U,
    0x4d1f5496U,
    0x1272f7f7U,
    0x4a0a0819U,
    0x284a8432U,
    0x146b1205U,
    0xeffde13eU,
    0xb981dc88U,
    0xc6c3b3dbU,
    0x8c627a37U,
    0x3cb21523U,
    0x5269a694U,
    0x16fea6fcU,
    0xa5075c87U,
    0xba8373dfU,
    0x95479a26U,
    0x3da7a510U,
    0xf1572eb0U,
    0x41fe2d0U,
    0x46f72e8eU,
    0xd24fe2fdU,
    0x5b6f2eb2U,
    0x227be2e1U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0xe8000000U,
    0xb4000000U,
    0x2000000U,
    0xf1000000U,
    0xa4800000U,
    0x50c00000U,
    0x73a00000U,
    0xb0500000U,
    0x68180000U,
    0xb7a40000U,
    0x1a520000U,
    0xcd1f0000U,
    0xe1238000U,
    0x53954000U,
    0xae3aa000U,
    0x3b39000U,
    0xb92ac800U,
    0xd4b8400U,
    0x213b1600U,
    0xb0325500U,
    0x466f8680U,
    0xd7aa16c0U,
    0x488ac820U,
    0xc1b8410U,
    0xda31638U,
    0xa756553cU,
    0xc79d86baU,
    0x1ee516edU,
    0xc3b14820U,
    0x192ac42cU,
    0x1d4bb611U,
    0x393ac528U,
    0xec34cea6U,
    0xf06bd2c1U,
    0x24a8fe3aU,
    0x1d0f0101U,
    0xf85cf897U,
    0x2ec457dbU,
    0x64a690beU,
    0x1fd743c5U,
    0xc15ecea9U,
    0x6e40d2fdU,
    0xce617e23U,
    0x31714125U,
    0x8b8fd8aeU,
    0x119987f9U,
    0x5de77893U,
    0x9e3517cdU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x68000000U,
    0x7c000000U,
    0xa2000000U,
    0x69000000U,
    0x63800000U,
    0x24400000U,
    0x18600000U,
    0x55500000U,
    0x9ff80000U,
    0x5c640000U,
    0xd3520000U,
    0xe0fd0000U,
    0xf8e78000U,
    0x37914000U,
    0xaa5ee000U,
    0x50129000U,
    0xa81a0800U,
    0x4771fc00U,
    0x31cdb200U,
    0x4049cb00U,
    0x850fd680U,
    0x52e88dc0U,
    0x99fa0820U,
    0x6361fc10U,
    0xd7d5b228U,
    0x743dcb1cU,
    0xda45d69aU,
    0xe3618ddfU,
    0x97d78808U,
    0xd439bc0aU,
    0xaa46d230U,
    0x8b671b15U,
    0xebd4be9cU,
    0x763ea1caU,
    0xc341522fU,
    0xe8e65b1dU,
    0xcf925e84U,
    0x6e5831edU,
    0x96115a02U,
    0x771ea717U,
    0x93f26c8dU,
    0xbd09bac5U,
    0x76edecbcU,
    0x8ffcfaefU,
    0xa4610c94U,
    0x17536adeU,
    0x26fc84a6U,
    0x27e3d6cdU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x18000000U,
    0xdc000000U,
    0x16000000U,
    0x1f000000U,
    0x3a800000U,
    0x55c00000U,
    0x9e200000U,
    0x72d00000U,
    0x4c980000U,
    0x10240000U,
    0x71d60000U,
    0x801f0000U,
    0xeae18000U,
    0xcd76c000U,
    0x7b09e000U,
    0x2e593000U,
    0xb0823800U,
    0x7cc63400U,
    0xeba09e00U,
    0xb5914900U,
    0x437c6280U,
    0x36d29ac0U,
    0x469a3820U,
    0xf9223430U,
    0xe4569e38U,
    0xf75e492cU,
    0xfd05e286U,
    0x37805af7U,
    0x5a45d825U,
    0x48640437U,
    0x84b52636U,
    0x132ebd39U,
    0xf38c9ca1U,
    0xde9823ebU,
    0xe52382b6U,
    0x1254aaf3U,
    0x5859800aU,
    0xdf82c029U,
    0xbe47e023U,
    0xd2623034U,
    0x25b5b80eU,
    0xf2aff43fU,
    0x56c8fe3bU,
    0x1c7eb92dU,
    0x2c57baa9U,
    0x435d9ed7U,
    0xcf009e1aU,
    0x5281492eU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0xe8000000U,
    0xe4000000U,
    0x7a000000U,
    0xb3000000U,
    0xd6800000U,
    0x93c00000U,
    0x16200000U,
    0x79900000U,
    0x43780000U,
    0x24240000U,
    0x7e920000U,
    0x17fb0000U,
    0x78e78000U,
    0xc8354000U,
    0xd0ac2000U,
    0x323c5000U,
    0x63c4d800U,
    0xbe209400U,
    0xfd97ce00U,
    0x4979e900U,
    0x7f211880U,
    0x4c1075c0U,
    0xfe3cd820U,
    0xddc49410U,
    0x6725ce18U,
    0x12e91cU,
    0x3e98baU,
    0x64c135f9U,
    0xeaa2f83eU,
    0xa153c43cU,
    0xffde962dU,
    0xb8733d38U,
    0x6cf76bfU,
    0x55cb8ce7U,
    0xb34ab8aeU,
    0xa88965f5U,
    0x2aac2012U,
    0xc13c502dU,
    0xd544d839U,
    0x5de09409U,
    0x3b7ce00U,
    0xd4e9e910U,
    0x465918acU,
    0xdb3475e2U,
    0x562ed831U,
    0x59ff940aU,
    0x9e24e26U,
    0xb1b7a914U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0xb8000000U,
    0xc4000000U,
    0xca000000U,
    0x89000000U,
    0xa9800000U,
    0x50c00000U,
    0x81600000U,
    0x6d500000U,
    0xf1c80000U,
    0xf640000U,
    0xee560000U,
    0x714d0000U,
    0x46218000U,
    0x87f3c000U,
    0x597b2000U,
    0x10bfd000U,
    0xf05b8800U,
    0x11cc6c00U,
    0xdf665600U,
    0x46530300U,
    0xbd4d4680U,
    0xf0213840U,
    0xf38820U,
    0xb3f86c30U,
    0x60f85628U,
    0x887a032cU,
    0xad3ac6aeU,
    0xc29ff871U,
    0xd5a92812U,
    0xadb47c12U,
    0x6058fe02U,
    0xd9c9bf38U,
    0x367188eU,
    0xf850976aU,
    0x464a38aeU,
    0x14a24751U,
    0x33b03099U,
    0xeb5deb54U,
    0x254d4697U,
    0x44213857U,
    0xd2f3883eU,
    0x4ef86c08U,
    0xbb785619U,
    0x95ba0333U,
    0x4fdac6b0U,
    0x760ff86cU,
    0xc81281dU,
    0x9f407c26U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xa8000000U,
    0x8c000000U,
    0x6e000000U,
    0x4f000000U,
    0x9800000U,
    0x43400000U,
    0x83e00000U,
    0xa5b00000U,
    0xdd580000U,
    0x11e40000U,
    0x3cb60000U,
    0x9fd90000U,
    0x69228000U,
    0x75134000U,
    0x730d6000U,
    0x3509f000U,
    0x360d3800U,
    0x718f2c00U,
    0xadccea00U,
    0x8faea700U,
    0xe559c180U,
    0xd5e320c0U,
    0x2eb53820U,
    0xc6db2c30U,
    0xba2ea08U,
    0xddd3a734U,
    0x92ad41aaU,
    0x55d960e3U,
    0x422d83bU,
    0x7d959c23U,
    0xa6ccb20aU,
    0x54287b24U,
    0xdf18138aU,
    0xe482abcaU,
    0x8bc0138cU,
    0x7626abe7U,
    0x149613a5U,
    0x9c4fabf3U,
    0x8ec93b8U,
    0x74b8ebd3U,
    0x2957f3b2U,
    0x91681bfdU,
    0x7ff84b99U,
    0xd6b477dfU,
    0x22d9c18aU,
    0xc9a320f3U,
    0x2cd53829U,
    0x7c2b2c31U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x48000000U,
    0x24000000U,
    0xbe000000U,
    0xa7000000U,
    0xda800000U,
    0x5a400000U,
    0x94200000U,
    0xff300000U,
    0x12d80000U,
    0xd6240000U,
    0x9a360000U,
    0x6d5b0000U,
    0x93e18000U,
    0xfbd44000U,
    0xbb8a2000U,
    0x73ec7000U,
    0x73fd7800U,
    0xe96f400U,
    0x712fa200U,
    0xb8995900U,
    0xaa05cd80U,
    0x9101d4c0U,
    0x39857820U,
    0x8ec2f430U,
    0x2161a218U,
    0x9596592cU,
    0x9aa4d92U,
    0xf7da94c9U,
    0x69a0d80fU,
    0xbff5c419U,
    0xbcb97a2eU,
    0xd379d3aU,
    0x3fdd37b7U,
    0x8da209f6U,
    0x61f26f8bU,
    0xabbc8decU,
    0x9fb6b5a8U,
    0x419820d1U,
    0xa7855a2bU,
    0x39c0ed14U,
    0x63e1cf8fU,
    0x13d0bde5U,
    0x4f8fed91U,
    0x35eda4deU,
    0xb8f8003cU,
    0x4e14000cU,
    0x326e0019U,
    0x513f0001U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0xf8000000U,
    0xf4000000U,
    0x9a000000U,
    0x41000000U,
    0xf4800000U,
    0xa4400000U,
    0x56600000U,
    0x97700000U,
    0x81980000U,
    0xd7640000U,
    0x3f20000U,
    0x75d90000U,
    0x9078000U,
    0x9885c000U,
    0x9a46a000U,
    0x5675000U,
    0x2ef5c800U,
    0xbf580400U,
    0xfe45f200U,
    0x7762bb00U,
    0x33f21f80U,
    0xaddaaec0U,
    0x8d07c820U,
    0xfa810410U,
    0x2f427208U,
    0x6be77b1cU,
    0xcbb4bfbeU,
    0x1dbdfefdU,
    0xcd720006U,
    0xa0990000U,
    0x73e78035U,
    0x2fb5c035U,
    0x2fbea02bU,
    0xf0735018U,
    0xc21fc806U,
    0xf8a50425U,
    0x5650723dU,
    0xa90e7b34U,
    0x774b3f97U,
    0x702c3ec3U,
    0xbbdea026U,
    0xe2035024U,
    0xf507c803U,
    0x4e81042eU,
    0x95427203U,
    0x5ae77b06U,
    0xc734bf8cU,
    0x4dfdfefaU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0xa8000000U,
    0x94000000U,
    0xae000000U,
    0xbf000000U,
    0x9b800000U,
    0x71400000U,
    0xfba00000U,
    0x33d00000U,
    0x51d80000U,
    0xdca40000U,
    0xf4560000U,
    0xca9d0000U,
    0xee078000U,
    0xdf034000U,
    0x4b81a000U,
    0xa946f000U,
    0xc7a0b800U,
    0x9d07c00U,
    0x40defa00U,
    0xf8262500U,
    0x1e934280U,
    0x407c04c0U,
    0x2676b820U,
    0xbd0d7c30U,
    0xc6f97a28U,
    0x81b5651cU,
    0xf96ae2aaU,
    0x2d4ef4e5U,
    0x71d8000bU,
    0x6ca4001fU,
    0xfc56000eU,
    0x2e9d0000U,
    0xe8078014U,
    0xf4034029U,
    0x7e01a03fU,
    0x6706f018U,
    0xa780b81bU,
    0x4b407c2eU,
    0xeaa6fa05U,
    0x1752253bU,
    0xbb1d4286U,
    0x564504ddU,
    0x3c27382cU,
    0xa8933c00U,
    0x637f5a03U,
    0xf7f0d515U,
    0x754bfabfU,
    0x8dd878dfU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x88000000U,
    0xbc000000U,
    0x46000000U,
    0x65000000U,
    0x2800000U,
    0xcb400000U,
    0x90a00000U,
    0x4ff00000U,
    0xe6280000U,
    0xcda40000U,
    0xa9720000U,
    0xff6d0000U,
    0x52008000U,
    0x4f064000U,
    0x980e000U,
    0x80c6b000U,
    0x97676800U,
    0xcd15f400U,
    0x7dfc6a00U,
    0xca3bad00U,
    0x10dc6b80U,
    0x1f0a6b40U,
    0x72956820U,
    0x6038f410U,
    0x5bdcea28U,
    0xf48ded24U,
    0xe5548ba2U,
    0x6ad8db6fU,
    0x7c080031U,
    0xb5140009U,
    0x39fa0028U,
    0x88390016U,
    0x97da8006U,
    0xa8f403cU,
    0x24526028U,
    0x1a5df02aU,
    0x284f082aU,
    0x431040dU,
    0xdac9e230U,
    0x3775e900U,
    0x4e6fe9bbU,
    0x9a867253U,
    0xbf4789afU,
    0xcaa2825cU,
    0xfcf20183U,
    0x9acc655U,
    0xb86183acU,
    0xb490df7cU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x58000000U,
    0x8c000000U,
    0xe2000000U,
    0xc7000000U,
    0xb8800000U,
    0xb4400000U,
    0x70a00000U,
    0x5bf00000U,
    0xf3c80000U,
    0x43a40000U,
    0xfd720000U,
    0x9a8d0000U,
    0xf0858000U,
    0x1040c000U,
    0xe6a16000U,
    0xc2f69000U,
    0x364cf800U,
    0x465a400U,
    0x6310b200U,
    0xc298bd00U,
    0x909a9b80U,
    0x4f9efc40U,
    0xdb1ef820U,
    0xbd58a410U,
    0x52fd3228U,
    0x3d8c7d0cU,
    0x9801fb96U,
    0x6c016c63U,
    0x72058018U,
    0xaf00c021U,
    0x6c816006U,
    0xda469021U,
    0x55a4f80aU,
    0x2471a435U,
    0xff0ab204U,
    0x8741bd21U,
    0xd6251b91U,
    0x32b73c4bU,
    0x40e81800U,
    0xae93f402U,
    0x815d2a2dU,
    0xa8fb892cU,
    0xd68ed1a4U,
    0xf287e544U,
    0x4746d1bcU,
    0x3623e555U,
    0xa2b4d1bbU,
    0x28eee552U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0x48000000U,
    0xf4000000U,
    0xa6000000U,
    0x9d000000U,
    0xc3800000U,
    0xb8c00000U,
    0xf4a00000U,
    0x84b00000U,
    0x87a80000U,
    0xe5a40000U,
    0xed360000U,
    0xc8690000U,
    0x5868000U,
    0x95c44000U,
    0xf26a000U,
    0xd077b000U,
    0x690ea800U,
    0xae15bc00U,
    0x921ef600U,
    0xcb8e4d00U,
    0x6752b980U,
    0x957cbb40U,
    0xfd18a820U,
    0xa30cbc30U,
    0xe9107608U,
    0xbe9e0d14U,
    0xdbca1992U,
    0x3db60b7dU,
    0x6a2e8009U,
    0x14604017U,
    0x2c10a038U,
    0x211eb03aU,
    0x4108282fU,
    0xea11fc1cU,
    0xc185608U,
    0xba89fd1eU,
    0xbed4118bU,
    0xe2bd075cU,
    0xf1385e1cU,
    0xc1fff134U,
    0xe15a4faaU,
    0x93ebf659U,
    0xc1449193U,
    0x13604754U,
    0xe0907e24U,
    0x41580114U,
    0x3ec47b0U,
    0xa944fa56U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x98000000U,
    0x4c000000U,
    0xde000000U,
    0xe1000000U,
    0xbf800000U,
    0x36c00000U,
    0x7ca00000U,
    0x2cd00000U,
    0xea880000U,
    0xc3a40000U,
    0xb2560000U,
    0xc3cd0000U,
    0x39c18000U,
    0x7a22c000U,
    0x49976000U,
    0xceeb7000U,
    0xead7c800U,
    0x87899c00U,
    0x2264600U,
    0xd5976d00U,
    0x98ed5a80U,
    0x6fd50240U,
    0x3209c820U,
    0x47e09c30U,
    0x29b1c628U,
    0xdc78ad2cU,
    0x70bbbaa6U,
    0x971cb253U,
    0x4f496017U,
    0xef827008U,
    0x7ec04807U,
    0xb8a65c21U,
    0x96d0a639U,
    0x18edd18U,
    0xf25f28dU,
    0x413ee48U,
    0xd72e4623U,
    0xe0f36d0dU,
    0xf61b5ab9U,
    0x30c80279U,
    0x7940482eU,
    0xb2665c20U,
    0xc70a609U,
    0x305edd05U,
    0x1c2df287U,
    0x5c77ee75U,
    0x7858463cU,
    0xd82e6d2bU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x68000000U,
    0xfc000000U,
    0x46000000U,
    0x7f000000U,
    0x68800000U,
    0xcfc00000U,
    0x3ea00000U,
    0xbc900000U,
    0x6d980000U,
    0x67a40000U,
    0xfb160000U,
    0x32d90000U,
    0xb2c18000U,
    0xab254000U,
    0x26d6e000U,
    0xe97fb000U,
    0xefd4b800U,
    0x76faa400U,
    0x24914e00U,
    0x19998d00U,
    0x4da0e080U,
    0x1a1172c0U,
    0xb15ab820U,
    0xaf87a430U,
    0x6346ce08U,
    0xb365cd2cU,
    0x9f37809aU,
    0x148b82ffU,
    0x6878e031U,
    0x3c52b02fU,
    0x93bb3812U,
    0xc8f2e41fU,
    0x5e282e15U,
    0xfeee7d10U,
    0xb0cd388aU,
    0x779c26c6U,
    0x2ea62e04U,
    0xa4937d0fU,
    0xd99ab8abU,
    0x6da066e9U,
    0xaa114e28U,
    0xd9598d2cU,
    0x5380e09cU,
    0x254172e2U,
    0xcc62b805U,
    0xf7b3a410U,
    0xdb48ce0cU,
    0x56d8cd20U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0xe8000000U,
    0x1c000000U,
    0x16000000U,
    0xa3000000U,
    0x28800000U,
    0x8cc00000U,
    0xb4a00000U,
    0xc8f00000U,
    0xc7480000U,
    0xd1a40000U,
    0x8b760000U,
    0xf0f0000U,
    0x87c08000U,
    0xa0214000U,
    0x2237e000U,
    0xa8ec3000U,
    0xc5d65800U,
    0xcaffa400U,
    0xdf0fd600U,
    0x4fc63d00U,
    0xcc214380U,
    0x4c313c40U,
    0xffe85820U,
    0xe754a430U,
    0xf3395638U,
    0xe0287d24U,
    0x237623baU,
    0x330c4c47U,
    0xe1c1e025U,
    0x7b233018U,
    0xfeb6d832U,
    0x2e2ee407U,
    0xc4703617U,
    0x898e0d35U,
    0xbc011bb4U,
    0xa601985cU,
    0x3b070e08U,
    0x4c83d910U,
    0x6ec7f5b4U,
    0x1da1717eU,
    0x557623a3U,
    0xc00c4c69U,
    0xc141e00eU,
    0x7be3300dU,
    0xb416d81eU,
    0x59dee43bU,
    0x3db83629U,
    0x77ea0d24U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xc8000000U,
    0xc000000U,
    0x4e000000U,
    0xc3000000U,
    0xf5800000U,
    0xb400000U,
    0x68e00000U,
    0xfb500000U,
    0x99180000U,
    0xa9e40000U,
    0xa3d60000U,
    0xf4df0000U,
    0x47c18000U,
    0xff204000U,
    0xbc776000U,
    0x16ff000U,
    0x5a8c5800U,
    0xbc5dcc00U,
    0x72072a00U,
    0x8501df00U,
    0xda84b680U,
    0xc732c0U,
    0x68a25820U,
    0x6a36cc30U,
    0x2708aa38U,
    0x9b1a9f2cU,
    0x4e456b2U,
    0xc55782c3U,
    0x7218e033U,
    0xe064b000U,
    0x2e94b805U,
    0x53397c2eU,
    0x7139228U,
    0xae78a33dU,
    0x88f724b5U,
    0x52af91daU,
    0x5fad7cb5U,
    0xa92d5dcfU,
    0xb7ebd693U,
    0x644cc2ddU,
    0x3ff80023U,
    0x51b40035U,
    0x2f4e0027U,
    0xe67b000dU,
    0x44f78011U,
    0xfcaf402fU,
    0x2caee02dU,
    0x94abb00cU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0x68000000U,
    0x14000000U,
    0x86000000U,
    0x8f000000U,
    0x3a800000U,
    0x7e400000U,
    0xa0200000U,
    0xe5f00000U,
    0xb1f80000U,
    0xeaa40000U,
    0x33b60000U,
    0xe5df0000U,
    0x79538000U,
    0x654d4000U,
    0x21fba000U,
    0xb2a1b000U,
    0xafb63800U,
    0x87d9f400U,
    0x18570200U,
    0xc4cc9900U,
    0xe3396b80U,
    0xe3c3b5c0U,
    0xd0e5b820U,
    0xad94b430U,
    0xe32ca238U,
    0xf82d293cU,
    0x84af539aU,
    0x95ea41c5U,
    0xff4aba01U,
    0xcfc2d13U,
    0x923c9b6U,
    0x80719ce3U,
    0x8d396b92U,
    0xb8c3b5ccU,
    0x8c65b815U,
    0xacd4b415U,
    0x118ca220U,
    0x779d291fU,
    0x1377538dU,
    0x15be41c6U,
    0x4784ba2bU,
    0x7dc72d1aU,
    0xe3e649b9U,
    0xe513dcc2U,
    0x64694ba6U,
    0x858b45deU,
    0x319e2029U,
    0x7c73f038U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x48000000U,
    0x4c000000U,
    0x2a000000U,
    0xdd000000U,
    0x49800000U,
    0xbec00000U,
    0x55600000U,
    0x8a300000U,
    0x12680000U,
    0xf4e40000U,
    0xc8f60000U,
    0x550f0000U,
    0x37d08000U,
    0xbd1c4000U,
    0xa4296000U,
    0x14c7d000U,
    0x4865a800U,
    0x23b3ac00U,
    0x3caa6600U,
    0xe9806300U,
    0xec32d80U,
    0x6d65dd40U,
    0x1e352820U,
    0x3c6fec30U,
    0x4fe30638U,
    0x7677b324U,
    0x7f4e8592U,
    0x95f27153U,
    0xdc894e2aU,
    0x69108f07U,
    0x7878abaaU,
    0x661a2e4bU,
    0x4aaccda7U,
    0x96814d41U,
    0x36416016U,
    0x2023d01eU,
    0x6093a80aU,
    0xe6bcac0dU,
    0x437ae600U,
    0x189c2329U,
    0x80ea4db5U,
    0xa4a20d60U,
    0x1fd08007U,
    0xa11c4020U,
    0x2629602bU,
    0x15c7d02eU,
    0x63e5a80eU,
    0xc73ac25U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0xa8000000U,
    0xbc000000U,
    0x6a000000U,
    0x6d000000U,
    0x95800000U,
    0xc9c00000U,
    0x90200000U,
    0x4b900000U,
    0xf8c80000U,
    0x1da40000U,
    0x86520000U,
    0x76eb0000U,
    0xbd368000U,
    0x441f4000U,
    0xe60ae000U,
    0x9d07d000U,
    0x4d872800U,
    0xedc0cc00U,
    0xbe22de00U,
    0x58974900U,
    0xd6484080U,
    0x46e5b040U,
    0x2731a820U,
    0xf11f8c10U,
    0x57883e18U,
    0x7ac09914U,
    0xcea768aaU,
    0x88d17c6fU,
    0x1da9763aU,
    0xe457c50bU,
    0xd7ecfebdU,
    0xdab56966U,
    0xa4d8a0aeU,
    0x9dad606dU,
    0xa452001cU,
    0xb7eb0018U,
    0x8ab68036U,
    0xcdf4014U,
    0x21aae03bU,
    0xce57d037U,
    0xdaef2838U,
    0x1f34cc09U,
    0xc518de33U,
    0xb1884906U,
    0x85c4c09aU,
    0x2225f052U,
    0x297c833U,
    0x43481c3cU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x48000000U,
    0x7c000000U,
    0x5a000000U,
    0x2b000000U,
    0xfc800000U,
    0xa1c00000U,
    0x8ce00000U,
    0xa7900000U,
    0x99a80000U,
    0x8c640000U,
    0x9c560000U,
    0xde4f0000U,
    0x67718000U,
    0xec3c4000U,
    0xa2c8e000U,
    0x6b55000U,
    0x80da1800U,
    0xb55a8400U,
    0xd71a1e00U,
    0x70b99f00U,
    0x730b6880U,
    0x22508b40U,
    0xeb4b9820U,
    0x3ef6c430U,
    0xc7afe38U,
    0x4a68cf2cU,
    0x27877092U,
    0x35450f5fU,
    0x1200636U,
    0x89731b3aU,
    0x21397687U,
    0xcf4d1444U,
    0xc0f6f091U,
    0x19794f46U,
    0x43e8e628U,
    0x3fc64b35U,
    0xe9e36eb2U,
    0x617906cU,
    0x4decee9eU,
    0x42c0d077U,
    0xcc638ebfU,
    0xbc56c05cU,
    0x8e48f691U,
    0x9f715458U,
    0xd83e10b5U,
    0x84cc1f64U,
    0x77b2fe16U,
    0x575ccf3cU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0xf8000000U,
    0xa4000000U,
    0x7e000000U,
    0x71000000U,
    0xc7800000U,
    0xb5c00000U,
    0x54200000U,
    0xa1b00000U,
    0xa4580000U,
    0xe7a40000U,
    0x22720000U,
    0x7d7d0000U,
    0xab938000U,
    0xc4edc000U,
    0xdc7c2000U,
    0x24127000U,
    0x8d2b4800U,
    0xa25d9c00U,
    0x72a01e00U,
    0x3bf4c900U,
    0x49bf6180U,
    0xc034b4c0U,
    0x7498c820U,
    0x52005c10U,
    0x13043e28U,
    0xcc82b93cU,
    0x8d4629beU,
    0xaf6428e9U,
    0x23d3563fU,
    0x9a0d550cU,
    0xc76d7f99U,
    0x7bd7dd1U,
    0xa934298bU,
    0x471928d1U,
    0x91c0d63eU,
    0x6a209509U,
    0x70b15fafU,
    0x93df0de7U,
    0xaa6761beU,
    0xd250b4fcU,
    0xa2cac838U,
    0x7ecd5c2dU,
    0xe4cfbe19U,
    0x4bcb7927U,
    0xd4809abU,
    0x870b58dbU,
    0xc2eb9e0aU,
    0x497d093eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x88000000U,
    0xd4000000U,
    0x46000000U,
    0x63000000U,
    0x1c800000U,
    0x3cc00000U,
    0xb4e00000U,
    0x77f00000U,
    0x58780000U,
    0xa4640000U,
    0x11320000U,
    0x3d990000U,
    0x3a128000U,
    0x820e4000U,
    0xd95ba000U,
    0x92f2b000U,
    0x47fc5800U,
    0x7425c400U,
    0xc1131600U,
    0xa28d5f00U,
    0x879d4b80U,
    0x5b104dc0U,
    0x138ed820U,
    0x9e1b8410U,
    0xc850b608U,
    0xf2bef34U,
    0xb5cb13a2U,
    0x153889f5U,
    0xe7c54e31U,
    0x44659b08U,
    0xa136dd8fU,
    0x459e52fbU,
    0xb610b3afU,
    0x980a39f8U,
    0x2859162fU,
    0xab705f15U,
    0x4bdcba9U,
    0xe0870dc1U,
    0x3ec7f830U,
    0x39e77400U,
    0xc774e3eU,
    0xb63c9b2eU,
    0x9b445d9dU,
    0x88a012f5U,
    0x4dd313b4U,
    0x6e6c89f4U,
    0x7c6f4e2aU,
    0x19689b3fU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xb8000000U,
    0xcc000000U,
    0x1a000000U,
    0x9000000U,
    0x18800000U,
    0x70400000U,
    0x7ca00000U,
    0xc0100000U,
    0x89b80000U,
    0x86240000U,
    0x55560000U,
    0xa79f0000U,
    0x37718000U,
    0xcccbc000U,
    0x47ed6000U,
    0x843f5000U,
    0x3ce08800U,
    0xc4b22400U,
    0x65ac1200U,
    0xa5998d00U,
    0x6277b480U,
    0x264837c0U,
    0xfaa90820U,
    0x8e1de430U,
    0x53b77238U,
    0x3a29dd2cU,
    0x425ebcaeU,
    0x6d15d3f3U,
    0x8f3e7a26U,
    0x71643932U,
    0x5e71cebeU,
    0xa4480ef0U,
    0x6faec691U,
    0x849aeaf3U,
    0x5ef034bcU,
    0x880cf7ffU,
    0xe10de825U,
    0x898d741aU,
    0xa1cc9a02U,
    0xa16ba91eU,
    0xc37ba69dU,
    0x8fc1baedU,
    0xb66bca5U,
    0x2771d3c6U,
    0xe4c87a37U,
    0x63eb390bU,
    0x5a384eb7U,
    0x5be7cecfU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0xb8000000U,
    0x84000000U,
    0xb2000000U,
    0x29000000U,
    0xcf800000U,
    0xd400000U,
    0x57200000U,
    0x45900000U,
    0x2e880000U,
    0xb2a40000U,
    0x55d60000U,
    0x1c2d0000U,
    0x27778000U,
    0xe9fbc000U,
    0x4b5d2000U,
    0x768c1000U,
    0x26a38800U,
    0x8fd2dc00U,
    0x792eba00U,
    0x66f59100U,
    0xfbbe2080U,
    0x48f8e640U,
    0xd8dc0820U,
    0x9dcd1c30U,
    0x22859a28U,
    0x10c4811cU,
    0xa36228aeU,
    0x1535fa61U,
    0x5a59920cU,
    0xfd099d3aU,
    0x39e7b29bU,
    0x81f17b5fU,
    0x4b3bba9bU,
    0xc13c6740U,
    0xac3e20afU,
    0x71b8e64aU,
    0x25fc0800U,
    0x55d1c09U,
    0xc98d9a36U,
    0x220811cU,
    0xdc1428a8U,
    0x68c8fa59U,
    0xcb061236U,
    0xee865d0cU,
    0x5ec49292U,
    0x1c646b41U,
    0x31b1b2a9U,
    0x99c7b64U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x8000000U,
    0x34000000U,
    0x3a000000U,
    0xd000000U,
    0x7f800000U,
    0xbb400000U,
    0x9a00000U,
    0xd8700000U,
    0x37080000U,
    0xb8240000U,
    0x74320000U,
    0x5c2b0000U,
    0xdc978000U,
    0xcdda4000U,
    0x3bdea000U,
    0x70dc5000U,
    0x6c5d2800U,
    0xef9cdc00U,
    0x27faca00U,
    0x6ef4500U,
    0x61738f80U,
    0x328eba40U,
    0x6e62a820U,
    0x72129c10U,
    0x371e6a18U,
    0xd63c151cU,
    0x978b2782U,
    0x75e3264dU,
    0xeb51422eU,
    0x7fbbc913U,
    0x77ce6d87U,
    0x18c22372U,
    0x8ce66da0U,
    0x8ed6236bU,
    0xd9fc6dbbU,
    0x79e92361U,
    0x47f1edb8U,
    0xbc4c6378U,
    0xd982cd81U,
    0xe8457347U,
    0x5924c5a8U,
    0x5db4bf5eU,
    0xfc6a07afU,
    0xd1b13676U,
    0xda68ca1aU,
    0xc2b44506U,
    0xeaec0f8fU,
    0x3770fa63U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x68000000U,
    0x3c000000U,
    0xba000000U,
    0xbf000000U,
    0x9a800000U,
    0xd9400000U,
    0x5c600000U,
    0x41100000U,
    0x5f680000U,
    0xa8e40000U,
    0x61560000U,
    0xfc8b0000U,
    0x65378000U,
    0x499d4000U,
    0xac5ee000U,
    0xfc7c5000U,
    0xbc8fb800U,
    0xc537b400U,
    0x599eda00U,
    0xb4593b00U,
    0xa8782c80U,
    0x3a8fb940U,
    0xc0303820U,
    0x7c1ef430U,
    0xf79e3a18U,
    0x2d5a6b1cU,
    0x27fe149aU,
    0xde4a4d4fU,
    0x8b91820eU,
    0x3e2ddf1fU,
    0xb080cebeU,
    0xbe43766aU,
    0xf2e1aeadU,
    0x6e56666fU,
    0x6e0ef681U,
    0xf0728269U,
    0xc7fe149cU,
    0x6e4a4d6aU,
    0x83918202U,
    0x722ddf0eU,
    0x6280ceb6U,
    0x3d43765fU,
    0xd261ae92U,
    0x8166678U,
    0xa8eef6bfU,
    0x68228270U,
    0xc4f6149dU,
    0x87be4d61U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x28000000U,
    0x4c000000U,
    0xda000000U,
    0xd3000000U,
    0xad800000U,
    0xd1c00000U,
    0x6fa00000U,
    0xb8300000U,
    0xf1b80000U,
    0x9c240000U,
    0x9cf60000U,
    0x629d0000U,
    0x3f528000U,
    0xc0af4000U,
    0xbdeb6000U,
    0x210a5000U,
    0xd8d8d800U,
    0x60368c00U,
    0x85bc9e00U,
    0x82214500U,
    0x9f5dd80U,
    0xee1f6bc0U,
    0xdc125820U,
    0x94dcc30U,
    0x68b9fe28U,
    0xaaa21534U,
    0xdcb1858aU,
    0xfeffa7d3U,
    0x5fc12616U,
    0xb2a49904U,
    0x8b51b83U,
    0x30fae2c0U,
    0xe2c2fbb1U,
    0x7226f2cdU,
    0x31f5c382U,
    0x2a186ed7U,
    0x9a10658eU,
    0x284eb7fbU,
    0x5a3c9e20U,
    0xce1453dU,
    0xb1d5ddacU,
    0x84ef6bc8U,
    0xc78a583dU,
    0xb099cc0dU,
    0xb057fe3cU,
    0x3f2b152dU,
    0x232d058cU,
    0x1129e7c5U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xd8000000U,
    0xc000000U,
    0xee000000U,
    0x9d000000U,
    0xf2800000U,
    0x18c00000U,
    0xd4e00000U,
    0xf3700000U,
    0x11e80000U,
    0xdb640000U,
    0x29360000U,
    0xf5c90000U,
    0xf8f28000U,
    0xf1a8c000U,
    0x40456000U,
    0x8b27f000U,
    0x5a132800U,
    0x73d97400U,
    0xbd2d7600U,
    0xdd802f00U,
    0x81407f80U,
    0x8fa32140U,
    0xf3d7a820U,
    0x6bb8b430U,
    0x139a9608U,
    0xe60f1f34U,
    0x5f9637b6U,
    0xfe9da543U,
    0xdc89f61bU,
    0xb351ef17U,
    0x187f9fb4U,
    0x84f81172U,
    0xc13fe023U,
    0xc75b300fU,
    0xfce84837U,
    0xe1e38425U,
    0xc5f2de00U,
    0x132c9b38U,
    0xa084e9b0U,
    0x83c13e67U,
    0x9f651f88U,
    0xf334d162U,
    0x7acc8001U,
    0x7175c019U,
    0x52e9e02bU,
    0x9ce2300aU,
    0xc772c837U,
    0x3ef4418U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x8000000U,
    0x5c000000U,
    0xf6000000U,
    0x69000000U,
    0xf800000U,
    0x59c00000U,
    0x22600000U,
    0x6ef00000U,
    0x73280000U,
    0xb4e40000U,
    0x10b60000U,
    0x48f0000U,
    0xb6718000U,
    0x306e4000U,
    0x66c1e000U,
    0xd4e43000U,
    0x60b40800U,
    0xec8f1c00U,
    0x5a713e00U,
    0xce6ebb00U,
    0x53c7bb80U,
    0x2d619f40U,
    0x50738820U,
    0xc16e5c30U,
    0x6d415e38U,
    0x9f24cb2cU,
    0x89d25382U,
    0x4efab357U,
    0xe01ebe1dU,
    0x67abfb2aU,
    0x59a1dbbbU,
    0x4f94ef7aU,
    0x6d5fe02aU,
    0x488f303cU,
    0xd8738819U,
    0x5d6e5c1bU,
    0x7b415e05U,
    0x4624cb00U,
    0x8e525398U,
    0x4b3ab34dU,
    0x347ebe26U,
    0x605bfb3eU,
    0x2509dbacU,
    0xa2b0ef4dU,
    0x5f89e005U,
    0x22f03035U,
    0x1d2a080cU,
    0xd9e41c09U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xd8000000U,
    0x2c000000U,
    0xfa000000U,
    0x3000000U,
    0xce800000U,
    0x31c00000U,
    0xff600000U,
    0xb4f00000U,
    0x5c080000U,
    0xae40000U,
    0xf7b60000U,
    0xd0ab0000U,
    0x3e768000U,
    0xf3c8c000U,
    0x98866000U,
    0x8c35000U,
    0x52e5d800U,
    0x1bb59400U,
    0x4aa89e00U,
    0x6d728300U,
    0xe54a0380U,
    0x85447640U,
    0xda55820U,
    0xe5165430U,
    0x89387e18U,
    0x71891314U,
    0x65a1bbb6U,
    0x8116b24bU,
    0xe73e1e1eU,
    0xf48a4330U,
    0x8a2463abU,
    0x51532658U,
    0x1d1e8029U,
    0x8ddcc016U,
    0x53386031U,
    0x828c5016U,
    0x43255838U,
    0x14d65433U,
    0x16587e0eU,
    0x95791311U,
    0xe1a9bb82U,
    0xa7f2b24cU,
    0xea881e36U,
    0x2721432fU,
    0x7ad2e392U,
    0x935be671U,
    0x7af8e034U,
    0x31ef902cU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x78000000U,
    0xc4000000U,
    0xf2000000U,
    0x9f000000U,
    0x74800000U,
    0x87c00000U,
    0x18200000U,
    0xfa700000U,
    0xa080000U,
    0x3ba40000U,
    0x75360000U,
    0xc3eb0000U,
    0x84f58000U,
    0x16cdc000U,
    0xc5012000U,
    0xa7801000U,
    0xdd443800U,
    0x6e40400U,
    0x83d06e00U,
    0x583a1900U,
    0x28cfe780U,
    0xb4029640U,
    0x2a07b820U,
    0xb02c430U,
    0xce84ce18U,
    0xa4c7c90cU,
    0x5aa2ff9eU,
    0x10b28271U,
    0xf9adee1cU,
    0x3293d917U,
    0xe0d8c785U,
    0x1a19866dU,
    0x1be0038U,
    0xe48f003fU,
    0xf638026U,
    0x796c025U,
    0x5f5ca01eU,
    0x3359d020U,
    0x8d5b181bU,
    0x3c5b141cU,
    0xd1dfd62eU,
    0x379cdd06U,
    0x87fd29acU,
    0x64ee5f4fU,
    0x9470c7a3U,
    0x330d866dU,
    0xa20001eU,
    0x95700008U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x48000000U,
    0xbc000000U,
    0xae000000U,
    0x1000000U,
    0x19800000U,
    0xfcc00000U,
    0xc7600000U,
    0x8bf00000U,
    0xca180000U,
    0x67e40000U,
    0xeab20000U,
    0x9bbb0000U,
    0x20768000U,
    0xe9d84000U,
    0xc002e000U,
    0x2005f000U,
    0x30014800U,
    0x1807ac00U,
    0xf400d600U,
    0x1203d300U,
    0xaf01e380U,
    0x1881bec0U,
    0xe545c820U,
    0x3ba4ec10U,
    0x4c94b618U,
    0x41ee6314U,
    0xadfa4b92U,
    0x8d57e2efU,
    0x710e560bU,
    0xbbcf9310U,
    0xc9a9039eU,
    0x29db4eebU,
    0xe0000003U,
    0x1000001dU,
    0x28000001U,
    0xec00000dU,
    0xe600002eU,
    0xbd000036U,
    0xb7800012U,
    0xfdc00018U,
    0xdee00004U,
    0x7730002eU,
    0xd780007U,
    0xec140002U,
    0x20aa0007U,
    0xfc5f0027U,
    0xcac48021U,
    0x72634028U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x8000000U,
    0x84000000U,
    0xae000000U,
    0x89000000U,
    0xea800000U,
    0xbb400000U,
    0xb0a00000U,
    0x32500000U,
    0xd5080000U,
    0x67240000U,
    0x75960000U,
    0xabef0000U,
    0xbd508000U,
    0x828e4000U,
    0xe0e72000U,
    0xeb77f000U,
    0xe19b0800U,
    0x424bf400U,
    0x4d82ea00U,
    0x18c4ed00U,
    0x1603680U,
    0xa9b3fa40U,
    0x5ffd8820U,
    0x47ab430U,
    0x69bd4a38U,
    0x30595d24U,
    0x89aa1e82U,
    0x2f70fe61U,
    0x6f9cea0bU,
    0xbb4fed12U,
    0x3f06b682U,
    0x2f82ba4aU,
    0x9bc2280eU,
    0xbce7041dU,
    0xe9776226U,
    0x329a591fU,
    0x17cb7ca5U,
    0x1945a765U,
    0xd3a71688U,
    0x1fd40a7eU,
    0x9dce802fU,
    0x8e454019U,
    0xc821a033U,
    0x5216b033U,
    0xb42ca820U,
    0xafb2443cU,
    0xe2fec234U,
    0x38f8e936U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x98000000U,
    0xb4000000U,
    0xbe000000U,
    0xe3000000U,
    0xe800000U,
    0xa9400000U,
    0x9f600000U,
    0xd4300000U,
    0x8b180000U,
    0x2ee40000U,
    0xf1f60000U,
    0xec390000U,
    0x52328000U,
    0xcc1ac000U,
    0x2660a000U,
    0xdfb57000U,
    0x5bdad800U,
    0x78475400U,
    0x68e27a00U,
    0x96f74300U,
    0x34bda580U,
    0xe476cac0U,
    0xcffe5820U,
    0xb2149430U,
    0x98485a08U,
    0xe5ccf334U,
    0x3a09dda6U,
    0x4829eeedU,
    0xf57a7a0fU,
    0x65534308U,
    0xc42ba58bU,
    0xef7fcadeU,
    0x8054d821U,
    0x4daa5428U,
    0x6ebefa05U,
    0xe1708307U,
    0xb6798599U,
    0x7bd07afcU,
    0xd56ea03cU,
    0x1418700eU,
    0x72665820U,
    0x91b09422U,
    0xf0de5a2bU,
    0x5ac5f33dU,
    0xcba35d83U,
    0x54972ee5U,
    0xd0cda1bU,
    0xc8af332fU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x38000000U,
    0xfc000000U,
    0x42000000U,
    0x47000000U,
    0xdd800000U,
    0x8c400000U,
    0xa3e00000U,
    0xbfd00000U,
    0xd8f80000U,
    0x1b640000U,
    0xb9120000U,
    0xf2df0000U,
    0x27168000U,
    0x7dbc000U,
    0x3594e000U,
    0xc21a9000U,
    0x9c30f800U,
    0x27298c00U,
    0x239cb200U,
    0xf2744700U,
    0x73cdc280U,
    0x29cefdc0U,
    0x62cc7820U,
    0x75494c10U,
    0x2a0cd238U,
    0xd26a1714U,
    0x18ff5a8eU,
    0xbb6621ffU,
    0x914d230U,
    0x9ade1701U,
    0xe3155a8fU,
    0xb9dd21f7U,
    0x30905206U,
    0x589ad700U,
    0xcdf73a9eU,
    0x88c71c3U,
    0x3fac4a37U,
    0x955dcb30U,
    0xb0517089U,
    0x8bbabaebU,
    0x2901baa2U,
    0xa087b1faU,
    0xac0aa29U,
    0xe0235b0fU,
    0xef7388b6U,
    0xe54c36f3U,
    0xb20b88a9U,
    0x9e6836d7U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x48000000U,
    0x94000000U,
    0x2e000000U,
    0x45000000U,
    0x6800000U,
    0x67c00000U,
    0xb8e00000U,
    0x4ad00000U,
    0x1ae80000U,
    0xe5640000U,
    0x96920000U,
    0xef490000U,
    0x52928000U,
    0xc9484000U,
    0xa391a000U,
    0x31cdf000U,
    0xc9556800U,
    0x1ba81400U,
    0xca450e00U,
    0xfca7cf00U,
    0x63705280U,
    0x171be140U,
    0xd1bde820U,
    0x99cd5410U,
    0xed542e08U,
    0x8dab7f34U,
    0x83461a92U,
    0x8264565U,
    0xfbb42e2bU,
    0xc27b7f01U,
    0xbf2e1a89U,
    0x5a82456dU,
    0x9dc62e1cU,
    0xf3e27f27U,
    0xd9549a85U,
    0x33ae055cU,
    0xae458e16U,
    0x4aa68f17U,
    0xfa7372b9U,
    0xab9e5145U,
    0xdd79201dU,
    0x62a8b019U,
    0xc6c4483aU,
    0x4864a40aU,
    0x94134633U,
    0xce8a6b08U,
    0xeb7194b0U,
    0xe319ca71U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0xd8000000U,
    0x54000000U,
    0x1a000000U,
    0xe9000000U,
    0x34800000U,
    0xc2400000U,
    0x2b200000U,
    0x98b00000U,
    0x22880000U,
    0x14a40000U,
    0xa3760000U,
    0x8d6b0000U,
    0xd0728000U,
    0x90e8c000U,
    0x46b5a000U,
    0xa9885000U,
    0x2d268800U,
    0x47b38400U,
    0x10b0200U,
    0x19663100U,
    0x1b957180U,
    0x8639ee40U,
    0x702a0820U,
    0xc8d44430U,
    0xbd9a2218U,
    0x58dda134U,
    0x747cd9b6U,
    0x930efa55U,
    0xbc642226U,
    0x112a10aU,
    0x67785995U,
    0x5e8d3a44U,
    0xf2a3021cU,
    0x6c723103U,
    0x16eb7196U,
    0x59b6ee4bU,
    0xea0e8833U,
    0xf0e78436U,
    0x27550220U,
    0x5e59310cU,
    0xa339f1a2U,
    0xaaae2e4aU,
    0x4993280fU,
    0x433bd41eU,
    0xbaad8a29U,
    0xf195b523U,
    0xc73e7383U,
    0x78afdf5bU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0xb8000000U,
    0x34000000U,
    0x2a000000U,
    0x93000000U,
    0x6e800000U,
    0x89400000U,
    0x9200000U,
    0xaa900000U,
    0xc4380000U,
    0x9aa40000U,
    0xec520000U,
    0xdddf0000U,
    0xfcd18000U,
    0x1d9fc000U,
    0x5072a000U,
    0xd4ced000U,
    0x862a5800U,
    0x4ad95400U,
    0x4051da00U,
    0xd3ddf100U,
    0xadd43080U,
    0xdc1d13c0U,
    0x11b1d820U,
    0xd9ad9410U,
    0xf218fa38U,
    0x50b7e12cU,
    0xf02f48aeU,
    0x8fda57cdU,
    0xfbd17a2aU,
    0x91c2134U,
    0x4237e8a3U,
    0x3f6f87ceU,
    0xbbf8a20cU,
    0x3ec5b537U,
    0x8de51283U,
    0x1c7366eeU,
    0x6acc6aaeU,
    0x6f2b22c8U,
    0xbf5d48afU,
    0x2b9557f5U,
    0x4db8fa08U,
    0xb767e100U,
    0x4f374884U,
    0xa8ee57caU,
    0x2f3b7a01U,
    0x6027210eU,
    0x1f1468afU,
    0x4fff47f5U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xc8000000U,
    0x6c000000U,
    0x1e000000U,
    0x2d000000U,
    0x71800000U,
    0x9c00000U,
    0x9600000U,
    0x4a700000U,
    0x6f580000U,
    0xc0a40000U,
    0xe3120000U,
    0xb52f0000U,
    0x17ff8000U,
    0x87b04000U,
    0x243e6000U,
    0x91d07000U,
    0xcccea800U,
    0xdbcdac00U,
    0xb54e5e00U,
    0x1e0e9300U,
    0x32295780U,
    0xc17c88c0U,
    0x88f0c820U,
    0x7a1ddc10U,
    0x5180f638U,
    0xd9c33f1cU,
    0x516709b2U,
    0x9e721bdbU,
    0xd5599fa7U,
    0x9fa154dbU,
    0xa1903e04U,
    0xe06ee30eU,
    0x66dfff88U,
    0xcd6524d5U,
    0x874960eU,
    0x74584f30U,
    0x8024219bU,
    0x4d50f7f8U,
    0xf48e2189U,
    0x3b6bf7faU,
    0x865ba18fU,
    0xf320b7c1U,
    0xf1d041a6U,
    0xfccb87feU,
    0xf3cd09bfU,
    0xa9491bc5U,
    0xc80c1faaU,
    0x732a14dbU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x68000000U,
    0xc4000000U,
    0xc6000000U,
    0xa7000000U,
    0x71800000U,
    0x3400000U,
    0x2c200000U,
    0x41700000U,
    0xfc580000U,
    0xf640000U,
    0x5d520000U,
    0x752d0000U,
    0x473f8000U,
    0xfc354000U,
    0x4b792000U,
    0x8594b000U,
    0x1f4ff800U,
    0xeaefec00U,
    0x8cdd8a00U,
    0x4aa22900U,
    0xbbb61f80U,
    0xc73f84c0U,
    0xbc36d820U,
    0xeb7b5c10U,
    0xf5927228U,
    0x774dc51cU,
    0x2eeb959aU,
    0x4addadf1U,
    0xeda0c791U,
    0xca34d8f9U,
    0xc47caa14U,
    0x9012990cU,
    0xaa0be7b9U,
    0x9cd68fdU,
    0x782cd234U,
    0x73b8350bU,
    0x3ff74d92U,
    0xaa9ff1e8U,
    0x360735bcU,
    0x8f055dceU,
    0x15839f9fU,
    0xb543c4d7U,
    0xe3227821U,
    0xf4f7ac19U,
    0x391b2a2dU,
    0x8443d924U,
    0x6da0c7a5U,
    0x8a34d8f4U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0xf8000000U,
    0x24000000U,
    0x36000000U,
    0x7000000U,
    0xe6800000U,
    0xb8400000U,
    0xc2e00000U,
    0xcab00000U,
    0x1a80000U,
    0x2a40000U,
    0x6c520000U,
    0x9d1b0000U,
    0xd40a8000U,
    0x7071c000U,
    0x6d082000U,
    0xbdf03000U,
    0x69cb7800U,
    0xfa56d400U,
    0x6a19d200U,
    0x7a8f5f00U,
    0xc430f980U,
    0x45ed8b40U,
    0x62435820U,
    0xbfe6e410U,
    0xa132aa18U,
    0x9a698b34U,
    0x57812bbeU,
    0x19c6d449U,
    0xfc21a1adU,
    0x60106f51U,
    0xf1fb7201U,
    0xedbeaf0aU,
    0x595ba196U,
    0xf4ef6f4fU,
    0xc3c3f213U,
    0x81246f18U,
    0xb9101b7U,
    0x6a3a9f7cU,
    0xb89aaa22U,
    0x2ccd8b19U,
    0x95d32bbeU,
    0x77ddd468U,
    0xab21a6U,
    0x8b21af6eU,
    0x8e935231U,
    0x25be9f32U,
    0x1558d980U,
    0x7eedbb71U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0xa8000000U,
    0xa4000000U,
    0xc2000000U,
    0xa5000000U,
    0x55800000U,
    0xcd400000U,
    0x49600000U,
    0x85900000U,
    0x47a80000U,
    0x90240000U,
    0x76f60000U,
    0x4b390000U,
    0xf40c8000U,
    0xe4974000U,
    0x202a2000U,
    0x60639000U,
    0x7616e800U,
    0xcdebcc00U,
    0x39c1da00U,
    0xc3a23300U,
    0x2cb78880U,
    0x6ad86b40U,
    0xf55cc820U,
    0xe9185c30U,
    0xbfff3208U,
    0xe62dff04U,
    0xd76052aaU,
    0xe935869U,
    0xe12fc090U,
    0xd7e37759U,
    0xe57da3dU,
    0x790b3307U,
    0xd51308b0U,
    0xf6b2b4cU,
    0x9c00e82bU,
    0xe02cc14U,
    0xe3055a30U,
    0x2281730cU,
    0x95c3a890U,
    0x75a6fb42U,
    0xc3b0a01bU,
    0x2e5dd004U,
    0x798480cU,
    0x6c3b1c32U,
    0xe48b1216U,
    0x4c536f13U,
    0x1c0c3a9fU,
    0xa096d476U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x88000000U,
    0xa4000000U,
    0x3a000000U,
    0xbb000000U,
    0x2b800000U,
    0x95c00000U,
    0xb7600000U,
    0x57300000U,
    0xb9580000U,
    0xdea40000U,
    0xa6560000U,
    0xd3690000U,
    0x51798000U,
    0x6bb64000U,
    0x591a2000U,
    0x5d015000U,
    0x66821800U,
    0xb413c00U,
    0xb025de00U,
    0xc915f300U,
    0x794b1d80U,
    0x936de8c0U,
    0xb1783820U,
    0xfbb06c30U,
    0x611fc608U,
    0x7100cf2cU,
    0xf880c3a2U,
    0x8a451be9U,
    0x20a4a5aeU,
    0x7756c4deU,
    0x5bea5e22U,
    0x733ab339U,
    0x5f10bd87U,
    0x9c4ef8d0U,
    0x19ee0022U,
    0x43d0000U,
    0x7a978025U,
    0xb08b4013U,
    0x120da011U,
    0x734a1003U,
    0x606fb81bU,
    0x1efb2c1bU,
    0xe4726614U,
    0xe57adf24U,
    0xa9b77bbcU,
    0xee1a37c9U,
    0x5880c392U,
    0xfa451beeU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x48000000U,
    0xc4000000U,
    0xb2000000U,
    0xcd000000U,
    0xcc800000U,
    0x71400000U,
    0x7a00000U,
    0x78300000U,
    0x27480000U,
    0x94e40000U,
    0x9a920000U,
    0xe7f90000U,
    0xa8e88000U,
    0x48d44000U,
    0xbfdd2000U,
    0x661c1000U,
    0x72fea800U,
    0xa86d0400U,
    0x6f93ba00U,
    0x577e0500U,
    0x57ae2d80U,
    0x2c77a440U,
    0xf86b8820U,
    0x47951410U,
    0x237f1208U,
    0x3daa0124U,
    0x6d751792U,
    0x42ede171U,
    0x49d0858cU,
    0x255aa063U,
    0xf858321bU,
    0x3cdb1128U,
    0xa9993f9bU,
    0x8c39a54bU,
    0x710c9f97U,
    0x5ec1f577U,
    0x9671791U,
    0x5954e162U,
    0xa1805a2U,
    0xf4fee055U,
    0x2f6d1231U,
    0x72130114U,
    0xd4bd97b6U,
    0x9a49a14cU,
    0xe065a5bbU,
    0xd7d2b06eU,
    0x4e5c9a2fU,
    0x23db1520U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x48000000U,
    0xac000000U,
    0xb2000000U,
    0x8f000000U,
    0xd7800000U,
    0x14c00000U,
    0x9b600000U,
    0x70300000U,
    0x70780000U,
    0x35a40000U,
    0xe8560000U,
    0xb5cf0000U,
    0xa61d8000U,
    0x75104000U,
    0x276c6000U,
    0xc5cf1000U,
    0xce1db800U,
    0x9149c00U,
    0xed68d600U,
    0xaecdf300U,
    0x79de580U,
    0x20d229c0U,
    0x2e89d820U,
    0x1dbf8c30U,
    0xf8436e38U,
    0xfe266f0cU,
    0xc690b392U,
    0xedab9aebU,
    0x83ae5d8cU,
    0xd6adb5d3U,
    0xf22a8e2dU,
    0xfb6d3f39U,
    0x1fcf6b8cU,
    0x3d1b16fbU,
    0x1490b382U,
    0x92ab9af5U,
    0xfc2e5dbbU,
    0x5e6db5f7U,
    0x934a8e30U,
    0xa85d3f13U,
    0xa376bb5U,
    0x937f16e4U,
    0xb026b3beU,
    0x43949adfU,
    0xb12bdd8fU,
    0x6ee9f5ddU,
    0x2c08ee24U,
    0xedf92f27U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x18000000U,
    0x64000000U,
    0x76000000U,
    0xdb000000U,
    0x15800000U,
    0x37c00000U,
    0x63a00000U,
    0xa5b00000U,
    0xbbf80000U,
    0x6a640000U,
    0xa1160000U,
    0xb9cd0000U,
    0x9b5a8000U,
    0x7e52c000U,
    0xfb282000U,
    0xbb0c3000U,
    0x927a9800U,
    0x2fa44c00U,
    0x1fb4ae00U,
    0x1afd3500U,
    0x7ee23980U,
    0x52529dc0U,
    0x312ab820U,
    0xd20c7c30U,
    0xfaf83628U,
    0xcee47934U,
    0x3a541786U,
    0x9d2968d9U,
    0xd80ea1bdU,
    0x33fbd1c6U,
    0x7664960dU,
    0xc3138909U,
    0xdcca2fb6U,
    0x29ded4c4U,
    0x4e123795U,
    0x24c58c5U,
    0xb398b9b8U,
    0xae705dd1U,
    0xaa5a9835U,
    0x12d44c26U,
    0x1c6cae3bU,
    0x8de93506U,
    0x7c2c39bcU,
    0xac8b9dddU,
    0xb0be3829U,
    0x3687bc15U,
    0xf644961cU,
    0x4a63892fU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x38000000U,
    0xdc000000U,
    0x82000000U,
    0xcf000000U,
    0x6a800000U,
    0x4dc00000U,
    0xa0e00000U,
    0x4f500000U,
    0xca180000U,
    0xc3240000U,
    0xdab20000U,
    0x5ccd0000U,
    0x5c7b8000U,
    0x3b7c000U,
    0xdf49e000U,
    0x4a3a9000U,
    0x39163800U,
    0xe0bb7400U,
    0x94d61e00U,
    0x105b2f00U,
    0x13817680U,
    0x3e401ac0U,
    0x8ea7d820U,
    0xa9f5e410U,
    0x77ea2628U,
    0xd2c95b3cU,
    0x997ee88eU,
    0xe231f5f7U,
    0x560cce80U,
    0xd21caee3U,
    0xaf202612U,
    0xc0b05b3fU,
    0xbfcf688eU,
    0x8cff35d8U,
    0x5d74aebcU,
    0x9728fee4U,
    0x87ae7e04U,
    0x396f7f1bU,
    0x210f2e83U,
    0x249f3ecbU,
    0xc0e79e23U,
    0x5f55ef25U,
    0xa2191698U,
    0xd7244ac3U,
    0xbcb18018U,
    0xcdcec034U,
    0x7bf86036U,
    0xebf45031U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xa8000000U,
    0xe4000000U,
    0x3e000000U,
    0xb7000000U,
    0xaf800000U,
    0xd6400000U,
    0x71e00000U,
    0x69300000U,
    0xdf980000U,
    0x75a40000U,
    0xe5d60000U,
    0x682f0000U,
    0x98f98000U,
    0xea574000U,
    0x2e6e2000U,
    0x111f7000U,
    0x7f677800U,
    0x83f61c00U,
    0x9bae200U,
    0xbc330700U,
    0x251fed80U,
    0x9960e2c0U,
    0x98f15820U,
    0xcc3d6c30U,
    0x4b739a38U,
    0xa87e1b2cU,
    0xb7928faaU,
    0x57cfa5f9U,
    0xecf15afU,
    0xce4abeddU,
    0x1b8a1a33U,
    0xd6295b29U,
    0xeffcaf8eU,
    0xa5d0d5cfU,
    0x48286db2U,
    0xc8fca2f9U,
    0xf250f805U,
    0x626a5c1eU,
    0xcb1b4203U,
    0xf6643700U,
    0x9b773585U,
    0x707aced7U,
    0x1b94e215U,
    0x3dc8070fU,
    0x2fc86d92U,
    0x32cca2ccU,
    0x5c48f805U,
    0xc68e5c16U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0xd8000000U,
    0x4000000U,
    0x2a000000U,
    0x2f000000U,
    0xc1800000U,
    0x5fc00000U,
    0xc7200000U,
    0x7300000U,
    0x76e80000U,
    0x9ee40000U,
    0x79160000U,
    0xa15d0000U,
    0x1b498000U,
    0x4d94c000U,
    0xa81b2000U,
    0x562dd000U,
    0x90403800U,
    0xede3ec00U,
    0x56930e00U,
    0x5b9d5100U,
    0x82edad80U,
    0xce43540U,
    0x42131820U,
    0x22da3c30U,
    0xb78d3628U,
    0x6537bd2cU,
    0xf5e923b6U,
    0x964a441U,
    0x97d215aaU,
    0x7afe197bU,
    0xa93ab638U,
    0x481a7d0bU,
    0x862d83afU,
    0x5840b46cU,
    0x81e08d81U,
    0xa094e55dU,
    0x5a9aa02cU,
    0x466d1028U,
    0xbda51819U,
    0x1b773c28U,
    0xbd0cb63aU,
    0x1777d39U,
    0x8a0c039dU,
    0x64f07468U,
    0x4fcdadacU,
    0x54d4354bU,
    0x8d7b1828U,
    0x57fe3c3fU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x68000000U,
    0x5c000000U,
    0xae000000U,
    0xad000000U,
    0x5a800000U,
    0x9ac00000U,
    0xcea00000U,
    0xf5b00000U,
    0xbdc80000U,
    0x99640000U,
    0x91960000U,
    0x8ab90000U,
    0xce0c8000U,
    0x67414000U,
    0xf9e5e000U,
    0x8454f000U,
    0x559ea800U,
    0x1aff7400U,
    0x12694600U,
    0x30556d00U,
    0x679f9180U,
    0x39fd2c40U,
    0xf5ed4820U,
    0x98128430U,
    0x6ffb6e08U,
    0xaceb5904U,
    0x1093379aU,
    0xe63cb157U,
    0xfdcc718bU,
    0x7960dc5bU,
    0xa197603eU,
    0xf2b8b012U,
    0xfa09c821U,
    0x9547c42eU,
    0xfae08e1eU,
    0x73d2a91aU,
    0x95df1f99U,
    0x4e9f856fU,
    0x297a57b6U,
    0x78290172U,
    0x4337398aU,
    0x310b584eU,
    0xeec08e2cU,
    0xdca2a921U,
    0xc6b71faaU,
    0x324b854fU,
    0x6d245793U,
    0x37f4015cU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x88000000U,
    0xac000000U,
    0x4a000000U,
    0x3d000000U,
    0x99800000U,
    0x9b400000U,
    0xdf200000U,
    0x3700000U,
    0x3980000U,
    0x31640000U,
    0x49d20000U,
    0x61af0000U,
    0x8de8000U,
    0xc6424000U,
    0x56a06000U,
    0xf037d000U,
    0x20bf2800U,
    0xf011ec00U,
    0xdb49ea00U,
    0x834e4100U,
    0xe749bf80U,
    0xe14d4ac0U,
    0xc64d4820U,
    0xeac93c10U,
    0x44084238U,
    0x4a6ded14U,
    0xab3835a2U,
    0x3250dbebU,
    0x9be9dfb2U,
    0x3c7a9adfU,
    0x1772603eU,
    0x7d98d022U,
    0x8261a82dU,
    0x5b53ac3fU,
    0x9c698a30U,
    0x44399128U,
    0x52d697a6U,
    0x2f2ca6f1U,
    0x871ca233U,
    0xc3a37d07U,
    0x35b3fd9aU,
    0xc9ffa7e4U,
    0x6633fd98U,
    0x2fbfa7d3U,
    0xc093fdacU,
    0xe78fa7c2U,
    0x942bfdb2U,
    0x799ba7fcU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0xc8000000U,
    0xf4000000U,
    0xf6000000U,
    0xf000000U,
    0x76800000U,
    0xa7c00000U,
    0xb8200000U,
    0x1d300000U,
    0x3b980000U,
    0xa8e40000U,
    0x2f960000U,
    0x636f0000U,
    0x225b8000U,
    0x2bc44000U,
    0x5226a000U,
    0x373000U,
    0x8c19b800U,
    0x4aa65400U,
    0x44f32e00U,
    0x98bd0900U,
    0xc550a580U,
    0x74cf16c0U,
    0xf1291820U,
    0x413e6430U,
    0xc4111638U,
    0xb32f1d3cU,
    0x983d2bb2U,
    0xad912ffdU,
    0x5a6e059dU,
    0xbbdc26f3U,
    0xa86a005U,
    0x85c73025U,
    0x5121b824U,
    0x5cb25406U,
    0xd6dd2e01U,
    0xb5060914U,
    0x738525abU,
    0x3c4056f2U,
    0x6062381bU,
    0xb3521414U,
    0xbbcd8e0cU,
    0x67ae3911U,
    0x16ff1d94U,
    0xb43642ddU,
    0x5a19b60fU,
    0x55a32d07U,
    0xa711388U,
    0x3783bc2U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0xe8000000U,
    0xe4000000U,
    0x96000000U,
    0xed000000U,
    0x2a800000U,
    0xaec00000U,
    0x13e00000U,
    0xdf900000U,
    0x95180000U,
    0xdc240000U,
    0xd4f20000U,
    0x7f4f0000U,
    0xcd5e8000U,
    0xbb014000U,
    0x67822000U,
    0x34413000U,
    0x522a800U,
    0xc0713400U,
    0x388ee600U,
    0x323f4700U,
    0xcf56c080U,
    0x2ffd8ac0U,
    0xf328820U,
    0xba2f0410U,
    0x960ace38U,
    0x1afb3314U,
    0x39b006baU,
    0x6ee8fdf9U,
    0x4aea6085U,
    0x7cedfaebU,
    0x21ea0012U,
    0xb36b002fU,
    0x11ac8006U,
    0x704e401aU,
    0xd4dca03aU,
    0x86407035U,
    0xde20881aU,
    0xb7f0040fU,
    0x4cc4e3dU,
    0x831e7332U,
    0x712026b8U,
    0x1e76cdcdU,
    0x818e48b1U,
    0x36b98ec8U,
    0x8094c610U,
    0x649a7739U,
    0x566689bU,
    0xfb53bec5U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0xc8000000U,
    0x4c000000U,
    0x66000000U,
    0x1000000U,
    0x49800000U,
    0x7c00000U,
    0x6fe00000U,
    0xa3900000U,
    0x13880000U,
    0xd240000U,
    0x7ff20000U,
    0x88d90000U,
    0xdc98000U,
    0x7d004000U,
    0xa7816000U,
    0x6ac7b000U,
    0xf063c800U,
    0x6d566c00U,
    0x79e96e00U,
    0xcf744700U,
    0x29d5880U,
    0x6fefee40U,
    0x6670a820U,
    0x9718dc10U,
    0x762b2608U,
    0x8c966b2cU,
    0x570f56b2U,
    0x5611953U,
    0xa6d5b8b9U,
    0xc5281e50U,
    0xf612003aU,
    0x6a49003dU,
    0x77c18021U,
    0xc7e44017U,
    0x7f93602fU,
    0xd8eb010U,
    0x88224814U,
    0x1c722c23U,
    0xe81a0e0aU,
    0x2aaaf736U,
    0x90d710b6U,
    0xdc29c271U,
    0xab90a607U,
    0x3f8f2b2aU,
    0xfb27b68aU,
    0x6f6e962U,
    0x455f10b8U,
    0x200dc25dU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0xe8000000U,
    0x3c000000U,
    0xe6000000U,
    0xaf000000U,
    0xc5800000U,
    0x61c00000U,
    0x8ea00000U,
    0x72300000U,
    0x24e80000U,
    0xa4640000U,
    0x9b160000U,
    0x4a1f0000U,
    0xeeae8000U,
    0x48054000U,
    0x4c00e000U,
    0xbe02b000U,
    0x2b00b800U,
    0xf7808c00U,
    0x14c5de00U,
    0x2263d00U,
    0x7970c580U,
    0xe0c0540U,
    0x39365820U,
    0x436d3c30U,
    0xb8a3e638U,
    0xf537f114U,
    0x3d6bfbbaU,
    0x73a3884fU,
    0x52b6a599U,
    0xc1aff55bU,
    0x4d800029U,
    0xcdc0003cU,
    0x60a00021U,
    0xb1300007U,
    0xef68000aU,
    0x56a4000dU,
    0x3636002eU,
    0xf6ef0021U,
    0x81668029U,
    0xff914016U,
    0x7d5ee039U,
    0x2249b01aU,
    0x7a503825U,
    0x51fecc06U,
    0x2d7dbe18U,
    0xbe3ecd00U,
    0xf0de1db6U,
    0xf8b797eU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x88000000U,
    0x1c000000U,
    0x16000000U,
    0xc1000000U,
    0x2c800000U,
    0x3cc00000U,
    0x46200000U,
    0xecb00000U,
    0x8e380000U,
    0xede40000U,
    0x27160000U,
    0xa2cd0000U,
    0xe13f8000U,
    0xf4664000U,
    0xed53e000U,
    0xf72e3000U,
    0x322dc800U,
    0x8cafc400U,
    0x236eb600U,
    0x7ac80900U,
    0xc538c980U,
    0xd664d3c0U,
    0x56502820U,
    0x84a8f430U,
    0xff6afe28U,
    0xcccc8d1cU,
    0x743a1fa2U,
    0x72e4aac7U,
    0x7696c9a5U,
    0xd48dd3c0U,
    0xd2d9a803U,
    0x6e73b423U,
    0xa51e9e1bU,
    0x13d0fd20U,
    0x38ea3784U,
    0xbb8c5eccU,
    0xcb5c37a7U,
    0xa4315ee7U,
    0xf0fbb7aaU,
    0xc0c31ee5U,
    0x402657a3U,
    0x75b42ed6U,
    0x46ba1f89U,
    0x5324aaebU,
    0xaa36c99dU,
    0xb5fdd3dfU,
    0xbe41a807U,
    0x4fe7b41aU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x38000000U,
    0xe4000000U,
    0xe000000U,
    0x7d000000U,
    0xc9800000U,
    0xecc00000U,
    0x9da00000U,
    0x19900000U,
    0xfc980000U,
    0x16640000U,
    0xe6b60000U,
    0xc9490000U,
    0xd4198000U,
    0x3923c000U,
    0x74d02000U,
    0x71fcf000U,
    0xc853a800U,
    0x48beac00U,
    0x73353600U,
    0xf8cf500U,
    0x1ab9a880U,
    0x24366ec0U,
    0x950d8820U,
    0xf2ff5c30U,
    0xa4d11e08U,
    0x19fc992cU,
    0x84533e8eU,
    0x2abcabf9U,
    0xdc3628a3U,
    0x510caeefU,
    0x4cfc281aU,
    0xe1d46c27U,
    0x347c9621U,
    0x6693c513U,
    0xca1a20b2U,
    0xc2432e3U,
    0x41531628U,
    0xc7390526U,
    0x1ef380a8U,
    0x1ab02dfU,
    0xa4e89e2bU,
    0x158f5916U,
    0xb1bb1ebfU,
    0xe4b45bd6U,
    0x364b808cU,
    0x229f02cdU,
    0x3669e22U,
    0x6332591eU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0xa8000000U,
    0xfc000000U,
    0xe6000000U,
    0xe9000000U,
    0x73800000U,
    0xe6400000U,
    0xda600000U,
    0xe3300000U,
    0x4eb80000U,
    0x47240000U,
    0x29d20000U,
    0x3f4d0000U,
    0x833a8000U,
    0x8c634000U,
    0x9230e000U,
    0x193cb000U,
    0xc3608800U,
    0xa8b33c00U,
    0x5cfae200U,
    0x57442b00U,
    0x6de48d80U,
    0x17743bc0U,
    0xb7da6820U,
    0x70968c10U,
    0xe7aaea28U,
    0xd1cd5734U,
    0x9cfe0faaU,
    0xb746e0ffU,
    0x1de60d99U,
    0x6f737beaU,
    0xe3d88814U,
    0x6a973c1dU,
    0xe8a8e234U,
    0x4b492b33U,
    0x93e0d80U,
    0x8b677bd4U,
    0x24b2880fU,
    0xc2fe3c1cU,
    0xea406222U,
    0x4676b16U,
    0xfe346dabU,
    0xf7388bd0U,
    0x662e030U,
    0x9531b01eU,
    0xafba0809U,
    0x18a07c34U,
    0x81920203U,
    0xf02c9b27U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x18000000U,
    0x6c000000U,
    0x1e000000U,
    0x5b000000U,
    0xfc800000U,
    0x93c00000U,
    0xb5600000U,
    0xf2900000U,
    0x5da80000U,
    0x2240000U,
    0x58320000U,
    0x145d0000U,
    0x5e198000U,
    0x8f3ec000U,
    0xaf886000U,
    0xe2167000U,
    0x90689800U,
    0x4c40c400U,
    0xe6204e00U,
    0xc2312300U,
    0x855cb880U,
    0x3b9f7f40U,
    0xbd797820U,
    0x42a87410U,
    0xd4a0b628U,
    0x42f7972cU,
    0xa8bc6e86U,
    0x80ca985bU,
    0x64b78ea7U,
    0x679b2846U,
    0xfb7cf6b7U,
    0xd5ae5c58U,
    0x8625c0a3U,
    0x92370b5bU,
    0x8d59ce1eU,
    0xff9fe331U,
    0xd77cd880U,
    0x6bad0f40U,
    0x6d23e024U,
    0x76b5b026U,
    0x72997801U,
    0x54f8741aU,
    0x7ee8b631U,
    0xca839715U,
    0xfcc66e85U,
    0x9be3987cU,
    0x94540e83U,
    0x574ce864U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0xa8000000U,
    0x24000000U,
    0xda000000U,
    0x99000000U,
    0x9e800000U,
    0x85400000U,
    0x4a200000U,
    0xf7f00000U,
    0x57680000U,
    0x45e40000U,
    0xa920000U,
    0x37bb0000U,
    0x11f98000U,
    0xac5b4000U,
    0x886c2000U,
    0x84665000U,
    0xe550800U,
    0x195e1400U,
    0x78ef1a00U,
    0x3a222900U,
    0x7ff17380U,
    0xa36efd40U,
    0x87e0a820U,
    0x1f930410U,
    0x573e3218U,
    0xd7be6d2cU,
    0xe1f961aaU,
    0x6459c049U,
    0x1c6f4196U,
    0xf6609076U,
    0xb351c99fU,
    0x5ddec45dU,
    0x64ab7380U,
    0xee81fd48U,
    0xd432831U,
    0xbe274402U,
    0x35f19221U,
    0x426c7d2fU,
    0x2563c9adU,
    0xccd5c458U,
    0x7a1af394U,
    0xfdcebd5aU,
    0x34550819U,
    0x705e143aU,
    0x2e6f1a2dU,
    0x2b622921U,
    0x47d173b2U,
    0xe99efd51U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x48000000U,
    0xe4000000U,
    0xf2000000U,
    0xf5000000U,
    0x6d800000U,
    0xd8c00000U,
    0x78e00000U,
    0x31700000U,
    0xddb80000U,
    0xf1a40000U,
    0x6f560000U,
    0xc72b0000U,
    0xefea8000U,
    0xaf084000U,
    0x827e2000U,
    0xd1c01000U,
    0x8b666800U,
    0x6ab38c00U,
    0x1fdab600U,
    0xc8929f00U,
    0x9b4bff80U,
    0x55dc7fc0U,
    0xe192c820U,
    0x18cbdc30U,
    0xf61afe18U,
    0x5ff50334U,
    0x7ff92192U,
    0xe1026cf9U,
    0xa787019cU,
    0x31c27ccdU,
    0x9b6169a3U,
    0x42b1f0f2U,
    0x2bdbdfb4U,
    0x72936ff1U,
    0x8a482021U,
    0xca5b103cU,
    0xcc54e836U,
    0xdafcc37U,
    0x1faa9610U,
    0xfaad8f15U,
    0xbf2917aeU,
    0x53e8b3cfU,
    0x910ade2bU,
    0xb17a131dU,
    0xf343c996U,
    0x2f22a0ecU,
    0x551117a3U,
    0x7b8cb3ceU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0xe8000000U,
    0x54000000U,
    0xc6000000U,
    0x23000000U,
    0xbb800000U,
    0xefc00000U,
    0x29200000U,
    0xff700000U,
    0xe0180000U,
    0xcb640000U,
    0x2920000U,
    0x81c90000U,
    0xd1c88000U,
    0x59c94000U,
    0xbdcda000U,
    0x3cdb000U,
    0x9ccdd800U,
    0xb54bbc00U,
    0xbf8f2e00U,
    0xe280100U,
    0xa51b6f80U,
    0x83e4eac0U,
    0x9ed0f820U,
    0x832b4c10U,
    0x299d5608U,
    0x31a70d24U,
    0xeb3119baU,
    0x6fe17d5U,
    0x8d311991U,
    0xf5fe17d8U,
    0xfeb11986U,
    0xde3e17cfU,
    0xf9911998U,
    0x564e17deU,
    0x6409199bU,
    0x51ea17dbU,
    0xf43b198dU,
    0xc09317f2U,
    0xeccb99b3U,
    0xad4e57fbU,
    0xb38c3990U,
    0xe42ee7dfU,
    0xfc1b6198U,
    0x89651bd2U,
    0x2f916fa4U,
    0xdd49eaeaU,
    0xab8a780dU,
    0xe82b0c09U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x58000000U,
    0x44000000U,
    0x22000000U,
    0x61000000U,
    0x2c800000U,
    0x21c00000U,
    0x4ee00000U,
    0xee100000U,
    0x65a80000U,
    0xd9a40000U,
    0x54320000U,
    0x23d90000U,
    0x9ed88000U,
    0xb45cc000U,
    0x669d2000U,
    0xadfa9000U,
    0x52aa4800U,
    0x3e220400U,
    0x4777e00U,
    0x967d0f00U,
    0x4ec6c80U,
    0x7887bf40U,
    0x1bc7e820U,
    0x4be05410U,
    0x70921608U,
    0x7d6c9b24U,
    0xffc1da96U,
    0xb9e07451U,
    0x6993daa8U,
    0x85e97448U,
    0xa4035aa3U,
    0xd201b47cU,
    0x89047aadU,
    0xa086245eU,
    0x1fc4b2afU,
    0x49e1e04bU,
    0x81966ca8U,
    0x9eabf7dU,
    0x9a056809U,
    0xd5019423U,
    0xe685b60eU,
    0xccc3cb03U,
    0x5c66329eU,
    0xc8d0204bU,
    0x44c9cc9aU,
    0x5bf1ef4dU,
    0x72388003U,
    0x7b4cc021U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xa8000000U,
    0xcc000000U,
    0xb6000000U,
    0xf9000000U,
    0xe5800000U,
    0xc8400000U,
    0x5ea00000U,
    0x93100000U,
    0x3f880000U,
    0x3d640000U,
    0x28f20000U,
    0xe5b90000U,
    0x2abb8000U,
    0x763b4000U,
    0x7bf96000U,
    0x1d1d3000U,
    0x78aa0800U,
    0x18348c00U,
    0xacdc5200U,
    0x40492d00U,
    0x68836c80U,
    0x6fc2ca40U,
    0x6de0e820U,
    0xf336fc10U,
    0xaa5d3a08U,
    0xf289913cU,
    0xbae6b6aaU,
    0xebb02b73U,
    0x2d9cb68dU,
    0x736d2b6eU,
    0xfd53691U,
    0x10ef6b5eU,
    0xf697d695U,
    0xb7c91b7bU,
    0x43c4bea0U,
    0x4be0a76eU,
    0x7232e49cU,
    0xdbdd066aU,
    0xe8cdda0bU,
    0x6746e12aU,
    0xd2265eb0U,
    0xc6d6d76fU,
    0x3d698c92U,
    0x22d0ba7bU,
    0x769800fU,
    0x4dd2403fU,
    0xebeae007U,
    0xc812702eU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0xb8000000U,
    0x74000000U,
    0x9a000000U,
    0x35000000U,
    0xc7800000U,
    0xbfc00000U,
    0xe3200000U,
    0x87b00000U,
    0x32e80000U,
    0xa5640000U,
    0xac560000U,
    0xe0fd0000U,
    0xda788000U,
    0x9e3fc000U,
    0xa4dca000U,
    0x334f5000U,
    0x2297e800U,
    0x165fdc00U,
    0x2b0ace00U,
    0x4e728100U,
    0x5aca1980U,
    0x52510d40U,
    0x37fbc820U,
    0xfcfb4c30U,
    0xec7f8628U,
    0x753b0d24U,
    0xe459bfaeU,
    0xb20e905dU,
    0x57f73f86U,
    0x620c507dU,
    0x8ff31fb9U,
    0x260cc07bU,
    0x3df0579eU,
    0xdf084c68U,
    0x1473718cU,
    0xcfcc116dU,
    0x5d5261aU,
    0x30395d13U,
    0x6bded79fU,
    0xf1ca8c5dU,
    0x72d75184U,
    0x86bc814bU,
    0xa19e6e08U,
    0x5429d103U,
    0x3fc3f194U,
    0x2327d152U,
    0x27b7863eU,
    0xa2ef0d2fU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0xe8000000U,
    0x14000000U,
    0x56000000U,
    0x79000000U,
    0x8800000U,
    0xd6c00000U,
    0xb8e00000U,
    0xec900000U,
    0xcf880000U,
    0xca40000U,
    0x99b20000U,
    0x8c7b0000U,
    0x30fe8000U,
    0xc0394000U,
    0xd9dda000U,
    0x91cd3000U,
    0x22830800U,
    0xadc42400U,
    0xff626600U,
    0x1bd1df00U,
    0x4129b880U,
    0x9a155640U,
    0x54482820U,
    0xdac45410U,
    0x62e6ce18U,
    0xf97cb14U,
    0x440c56baU,
    0x1e6ed45U,
    0xc412d6b5U,
    0x294fad4eU,
    0xc4776baU,
    0x89269d71U,
    0x1f67eacU,
    0x1359b97aU,
    0x280a98a4U,
    0x8be1265cU,
    0xcf168033U,
    0xb6cd4009U,
    0x5707a017U,
    0xad823031U,
    0xac478806U,
    0xf9226432U,
    0xd9f34624U,
    0xbf5eaf1bU,
    0x8209908aU,
    0xb0e50258U,
    0xe894e631U,
    0x118c9f39U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x38000000U,
    0xf4000000U,
    0x5a000000U,
    0x6d000000U,
    0xb9800000U,
    0xd0400000U,
    0xb600000U,
    0x9900000U,
    0x8e480000U,
    0x4a40000U,
    0x69b20000U,
    0x963b0000U,
    0xadbf8000U,
    0xd4ffc000U,
    0x641aa000U,
    0x54cc5000U,
    0xa642800U,
    0x4e112c00U,
    0x410ab200U,
    0x67400300U,
    0x9fe05880U,
    0x522440U,
    0x25690820U,
    0x3e56bc10U,
    0x1a6e3a18U,
    0x46d27f1cU,
    0xadab428eU,
    0x92f3cb7dU,
    0x8fdcc2b6U,
    0x26e80b4bU,
    0xb3146296U,
    0xf08f5b78U,
    0x1b07cab4U,
    0x4a85b773U,
    0x6c5d883U,
    0x8ba2e46bU,
    0x9362814U,
    0xc5fa2c3bU,
    0x6b9d3207U,
    0x578bc339U,
    0xc780f88eU,
    0x8f417444U,
    0x3e0a021U,
    0x8653500aU,
    0xae69a836U,
    0x7cd5ec22U,
    0xb0af9220U,
    0x1373933bU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x38000000U,
    0xdc000000U,
    0xa2000000U,
    0x7b000000U,
    0xc2800000U,
    0x22c00000U,
    0xf1a00000U,
    0x37b00000U,
    0x37e80000U,
    0xaae40000U,
    0x6520000U,
    0x33b0000U,
    0xd3198000U,
    0x48efc000U,
    0xe663e000U,
    0xa5919000U,
    0x271c9800U,
    0x9ee8b400U,
    0xb652600U,
    0xea16a500U,
    0xfa5fe180U,
    0x8a0d2540U,
    0xf434f820U,
    0x80ade410U,
    0x4103de18U,
    0xf580412cU,
    0xaa45bf8eU,
    0xfc62a477U,
    0x4292a788U,
    0x279ed04eU,
    0x772de188U,
    0x462574U,
    0x2365780aU,
    0x9e162406U,
    0x6c5a3e33U,
    0x70ed12fU,
    0xbb2a797U,
    0x65eed061U,
    0x89e5e1b0U,
    0xa8d22559U,
    0xbbff7800U,
    0x85b9243aU,
    0x1fd9be2fU,
    0x884e111bU,
    0x3c52c79cU,
    0x343f806bU,
    0x5b99198aU,
    0x452bc15fU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0xc8000000U,
    0x44000000U,
    0xba000000U,
    0xa5000000U,
    0xfb800000U,
    0xb3400000U,
    0xc2200000U,
    0x5c300000U,
    0x32d80000U,
    0x67e40000U,
    0x52d60000U,
    0x458f0000U,
    0x9e2b8000U,
    0x685c4000U,
    0xb5272000U,
    0x96b35000U,
    0x181be800U,
    0xcf803c00U,
    0x1422a00U,
    0xc323c900U,
    0xedb24580U,
    0xec98b8c0U,
    0x1a414820U,
    0x7a02c30U,
    0x10756238U,
    0x5e7ce53cU,
    0xbb14a7b2U,
    0x556c1dd1U,
    0x67ccf8eU,
    0x71461d9U,
    0x836fc5a6U,
    0xad7bf8e0U,
    0x2b95e81aU,
    0x2aab3c0aU,
    0x9d9faa28U,
    0xa3c0891dU,
    0x7de6e5b6U,
    0x27d3a8c5U,
    0x660b8027U,
    0x516c4038U,
    0x9c7f2017U,
    0xb217503bU,
    0x40ede81cU,
    0x923f3c3dU,
    0x17b1aa11U,
    0x699b890bU,
    0xf1c3659bU,
    0x8ce4e8f9U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x68000000U,
    0xfc000000U,
    0x1a000000U,
    0xe1000000U,
    0xb2800000U,
    0x8ec00000U,
    0x4200000U,
    0xfe900000U,
    0x76980000U,
    0xa5640000U,
    0x9cf20000U,
    0xc3e90000U,
    0x4bca8000U,
    0x575d4000U,
    0x74c0e000U,
    0x55255000U,
    0xd413c800U,
    0xbc5fb400U,
    0x2f440600U,
    0x65621900U,
    0xfcf4b880U,
    0x33ebdec0U,
    0xf3cba820U,
    0xc35ea410U,
    0x92c5ae08U,
    0xae21bd34U,
    0x8791969aU,
    0x801a23ffU,
    0xa5a25ea6U,
    0x9fd597e8U,
    0x74fe5884U,
    0xe0138ec7U,
    0xca58e033U,
    0x9c415024U,
    0x1ae1c809U,
    0xb2b6b41aU,
    0xa40e8617U,
    0xa1ff5914U,
    0x249458b9U,
    0xf79e8ef1U,
    0xe7e0600dU,
    0xaa351030U,
    0x53cba806U,
    0x535ea43dU,
    0xdac5ae39U,
    0x8221bd2aU,
    0xf5919691U,
    0x9d1a23c4U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0x8000000U,
    0x7c000000U,
    0xd6000000U,
    0x91000000U,
    0xcb800000U,
    0xf0400000U,
    0x3ea00000U,
    0xbab00000U,
    0x3380000U,
    0xd0640000U,
    0x5dd20000U,
    0x2c6b0000U,
    0x6bc98000U,
    0x96fe4000U,
    0xdb86e000U,
    0x68423000U,
    0x9aa24800U,
    0xa8b07c00U,
    0x303a9200U,
    0x20e42d00U,
    0x2113b180U,
    0xb80e4fc0U,
    0xd41f2820U,
    0xe1970c10U,
    0x8ccfba18U,
    0x5c7c212cU,
    0x38478b82U,
    0x62a72edfU,
    0xbcb7c395U,
    0x2a3c52f4U,
    0x6fe4d18aU,
    0x7963fc0U,
    0x55c98035U,
    0x8bfe400dU,
    0xae06e02fU,
    0xc5023023U,
    0xb1824812U,
    0xf407c0cU,
    0x10229212U,
    0x2b702d13U,
    0x8ad9b18bU,
    0xef14ffcU,
    0xdf9ca81eU,
    0x31d64c2bU,
    0x626ada19U,
    0x5ecf513eU,
    0x4f78a3b1U,
    0x18c022c5U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0xb8000000U,
    0xfc000000U,
    0x62000000U,
    0xc1000000U,
    0x56800000U,
    0x46400000U,
    0x3200000U,
    0x9a100000U,
    0xb9380000U,
    0x90e40000U,
    0xf8f20000U,
    0x78cf0000U,
    0xa2ac8000U,
    0x6e1bc000U,
    0x6cf6e000U,
    0xfece9000U,
    0xda84800U,
    0x339e1400U,
    0xf9320200U,
    0x732f6100U,
    0x71dd3c80U,
    0x8417e7c0U,
    0x5a382820U,
    0xe7604410U,
    0xf8322a38U,
    0x85ab2504U,
    0xc79d16aeU,
    0x2f33c2ffU,
    0x8429beb8U,
    0xc05846e0U,
    0xcbd5748dU,
    0xead9f3c5U,
    0xaf922a36U,
    0xc8fb250dU,
    0x730516a0U,
    0x8f87c2efU,
    0x1cc3bebdU,
    0x8f6346d0U,
    0x1c33f4bdU,
    0xeba933c8U,
    0xcc9a4a16U,
    0xfcb17507U,
    0xaef3e9dU,
    0x263886dbU,
    0xc5651485U,
    0xd937a3f3U,
    0xc32a0204U,
    0x39db6108U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0x8000000U,
    0x4000000U,
    0xaa000000U,
    0x4d000000U,
    0x88800000U,
    0xad400000U,
    0x2ba00000U,
    0x4d700000U,
    0x8cb80000U,
    0x39640000U,
    0xa6120000U,
    0x3baf0000U,
    0xcc4c8000U,
    0x341e4000U,
    0x43912000U,
    0xae68d000U,
    0xb2a9a800U,
    0x4ecaa400U,
    0x24595a00U,
    0xf8b7c500U,
    0x425cd780U,
    0xbbb4c3c0U,
    0xddde0820U,
    0xcb773410U,
    0xdfbf5238U,
    0xaee4f104U,
    0xd2d18582U,
    0x93cf32c1U,
    0xe4db0d8aU,
    0xb1f246c3U,
    0xd3ff7fbaU,
    0xb3c567ffU,
    0xdde1d210U,
    0xf555b106U,
    0x1f0c25b3U,
    0x50b9a2d8U,
    0x3f638583U,
    0xb51032e7U,
    0x4c2f8da9U,
    0xa88806f2U,
    0x947c5f81U,
    0x6f02b7c8U,
    0x8184fa1cU,
    0x6fc15506U,
    0xdbe45f82U,
    0xe656b7ceU,
    0x688efa3aU,
    0x347a553cU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x38000000U,
    0xf4000000U,
    0x12000000U,
    0x79000000U,
    0xc800000U,
    0x59400000U,
    0xb4600000U,
    0x19500000U,
    0xf4980000U,
    0x62a40000U,
    0x1df20000U,
    0xc26d0000U,
    0x75498000U,
    0x8d7fc000U,
    0x9a34a000U,
    0xb64a1000U,
    0xc4fe8800U,
    0xb1f58400U,
    0x746b3a00U,
    0x364ddb00U,
    0x84f9b680U,
    0x11f3a2c0U,
    0xc469a820U,
    0xe495410U,
    0x70fa9228U,
    0x3f08f2cU,
    0xbd69248eU,
    0x2ca2dfdU,
    0x29bb0ca4U,
    0xb791b9ceU,
    0xa43cbe8bU,
    0xf654e6eaU,
    0x4b1fb22bU,
    0xaa615f07U,
    0x66510c9fU,
    0x8318b9d7U,
    0xc6673eaeU,
    0x305626d5U,
    0xd01a923fU,
    0x47e08f11U,
    0x77912493U,
    0x443e2df4U,
    0xe6510c8cU,
    0xc318b9f1U,
    0x66673eb5U,
    0x805626f2U,
    0xe81a9235U,
    0xb3e08f2bU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x58000000U,
    0xd4000000U,
    0x16000000U,
    0xcf000000U,
    0x48800000U,
    0x34c00000U,
    0xd4e00000U,
    0x43900000U,
    0x42280000U,
    0x55a40000U,
    0x1a320000U,
    0xda1f0000U,
    0xb6ba8000U,
    0xfb0cc000U,
    0x557a000U,
    0x87cb3000U,
    0xfdb13800U,
    0x365aa400U,
    0xee9e7600U,
    0x687e4f00U,
    0x4aed5080U,
    0x8b46ab40U,
    0xeca61820U,
    0xdb65410U,
    0x1e586e38U,
    0x52981b34U,
    0x227d3e96U,
    0x1feab075U,
    0xcec126a5U,
    0x49e7e463U,
    0x6a11c88aU,
    0xf56c3f69U,
    0xb301d63bU,
    0xa2817f01U,
    0x51c668bbU,
    0x19670f67U,
    0x6ad0ee27U,
    0xe78bdb2dU,
    0x67901eb7U,
    0x7c2d4064U,
    0x26a7be80U,
    0x18b6704cU,
    0xbbde8681U,
    0x27d8d469U,
    0x1ddaf09cU,
    0x20dd9b5bU,
    0x395f2006U,
    0x618f039U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0xd8000000U,
    0x5c000000U,
    0x26000000U,
    0x9000000U,
    0x94800000U,
    0x45c00000U,
    0xb9200000U,
    0x8e100000U,
    0xc7980000U,
    0x43640000U,
    0xd5720000U,
    0x6eeb0000U,
    0xdb898000U,
    0x6ff8c000U,
    0x1197e000U,
    0xf5ddb000U,
    0xc040800U,
    0xe070400U,
    0xed043e00U,
    0x5e83d100U,
    0xb2c76c80U,
    0x78a21ec0U,
    0x79506820U,
    0x327d7410U,
    0xe0d45618U,
    0xd93ea52cU,
    0x53333ab6U,
    0xc38cbbd7U,
    0x13fb52a9U,
    0xe795cfd2U,
    0x94dd049dU,
    0x1c806aedU,
    0x31c7be20U,
    0x7b241108U,
    0x4d130c96U,
    0xa4186ee9U,
    0xc720000fU,
    0x9b10000fU,
    0x1518002cU,
    0xbfa40007U,
    0x20d20008U,
    0xf93b0008U,
    0x83318020U,
    0xab8cc029U,
    0x97fde02cU,
    0x9d92b016U,
    0xbbdf8805U,
    0x8104c400U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x78000000U,
    0xb4000000U,
    0x6000000U,
    0x29000000U,
    0x98800000U,
    0x15c00000U,
    0xe2e00000U,
    0xd8500000U,
    0xa7280000U,
    0xf8540000U,
    0x572e0000U,
    0xb0570000U,
    0xcb2c8000U,
    0x7a54c000U,
    0x50292000U,
    0xcdd4f000U,
    0xf4686800U,
    0xa2703400U,
    0xdb18c600U,
    0x3fef2300U,
    0x5c320480U,
    0x37b81a40U,
    0x4318c620U,
    0x1bef2330U,
    0x42320498U,
    0xfab81a54U,
    0xa598c63eU,
    0x932f231dU,
    0x3e520499U,
    0x1e281a5eU,
    0x78d0c618U,
    0xa6eb2318U,
    0x2cb404a1U,
    0x8e7b1a68U,
    0x43fa4631U,
    0x94bce326U,
    0xe09fa4b4U,
    0x89ac2a44U,
    0x2c978e03U,
    0x814ce738U,
    0x9fc62aa0U,
    0xd9e7cd77U,
    0x5fd524beU,
    0x2b6bea50U,
    0x5bf42e36U,
    0xca5fd708U,
    0x2cde291U,
    0xfd84c979U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x48000000U,
    0x94000000U,
    0x9e000000U,
    0x7d000000U,
    0x81800000U,
    0x8c400000U,
    0x87e00000U,
    0xffb00000U,
    0x18c80000U,
    0xe7b40000U,
    0x4ce0000U,
    0x8db70000U,
    0x37c88000U,
    0x39354000U,
    0xae0c2000U,
    0xac91b000U,
    0xab5fc800U,
    0xca6dbc00U,
    0xd867aa00U,
    0xaef38300U,
    0xaea95780U,
    0xc44c540U,
    0x47e7aa20U,
    0x9fb38330U,
    0xc8c95798U,
    0xafb4c574U,
    0x90cfaa32U,
    0x13b78315U,
    0x4acf57bfU,
    0xb8b7c56bU,
    0x22492a12U,
    0x2b75c336U,
    0x54ebf79eU,
    0xd2a33554U,
    0x3fd2c214U,
    0xaa3dcf0fU,
    0x231d959fU,
    0x3b8a0a77U,
    0x7ed4bf99U,
    0x31bfc941U,
    0x645f4814U,
    0x4ecfc2cU,
    0x5aa58a0bU,
    0xcbd53337U,
    0xe43e1f88U,
    0x161c3966U,
    0x2e0c202dU,
    0x6c91b00aU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0xf8000000U,
    0xdc000000U,
    0xe000000U,
    0x91000000U,
    0xad800000U,
    0xe8400000U,
    0x49a00000U,
    0xadf00000U,
    0xb8880000U,
    0xc5f40000U,
    0x8c8e0000U,
    0x3ff10000U,
    0x478d8000U,
    0x2976c000U,
    0x414b6000U,
    0xba16b000U,
    0x71dfe800U,
    0xa30bdc00U,
    0xb4aa00U,
    0xb6ab9100U,
    0x6342c580U,
    0x3f20d540U,
    0x7b34aa20U,
    0xa3eb9130U,
    0xd162c5a8U,
    0x4790d55cU,
    0xd19caa1eU,
    0x6eaf9107U,
    0xf44c5abU,
    0x6925d578U,
    0x46372a35U,
    0xf86c513dU,
    0x742425b9U,
    0xadb0a553U,
    0x528221bU,
    0x3202fd0cU,
    0x8f07879aU,
    0x1481985cU,
    0x11c7458aU,
    0x8be21546U,
    0xa751ca2aU,
    0x27fc2102U,
    0xa9b8ad9eU,
    0x4519c942U,
    0xbf6d603cU,
    0x24a3b004U,
    0xbe74683bU,
    0x99c81c1eU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x18000000U,
    0x64000000U,
    0x2000000U,
    0xb5000000U,
    0x6800000U,
    0x3cc00000U,
    0x51a00000U,
    0x8bb00000U,
    0xe8a80000U,
    0x2fb40000U,
    0x4aaa0000U,
    0x8ab30000U,
    0xa42d8000U,
    0xca73c000U,
    0x938ea000U,
    0xf6c3d000U,
    0xc8a30800U,
    0xe337e400U,
    0xef68ee00U,
    0xb3966900U,
    0x28593380U,
    0xbefeec40U,
    0xdec8ee20U,
    0x88266910U,
    0x38f133b8U,
    0x54aec7cU,
    0x8e62ee26U,
    0xd3956909U,
    0x985cb3b8U,
    0x46f92c51U,
    0x4acc4e27U,
    0x9226b906U,
    0xe9f7bbacU,
    0x1cac873U,
    0x7a6a01dU,
    0x84b7d00dU,
    0x2f29083eU,
    0xfff4e411U,
    0xeecd6e14U,
    0x3021a92fU,
    0x4cf593a2U,
    0xef4a3c50U,
    0x47646600U,
    0xb3154d1eU,
    0x1398fda1U,
    0xa4db956dU,
    0xfb39f58dU,
    0x17eb7167U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0x88000000U,
    0xd4000000U,
    0x82000000U,
    0x7000000U,
    0x10800000U,
    0x91c00000U,
    0xaa600000U,
    0x52100000U,
    0x48780000U,
    0x8e140000U,
    0xde7e0000U,
    0xab110000U,
    0x99fc8000U,
    0xa2554000U,
    0x765a2000U,
    0xd8215000U,
    0x6b321800U,
    0xecdd400U,
    0xaa9c9600U,
    0xd1c78700U,
    0xca638680U,
    0xa21404c0U,
    0x907c9620U,
    0xd2178730U,
    0x887b86a8U,
    0x2e1004d4U,
    0x8e7a9602U,
    0x23128705U,
    0x4df90688U,
    0x205444d5U,
    0x715c3606U,
    0xc8a69721U,
    0xfaf13ea2U,
    0xa4a8c0c1U,
    0xf88ab814U,
    0x99b8c402U,
    0x44702e15U,
    0x7c6a432bU,
    0x3b692892U,
    0x4bee07daU,
    0x2a2d1e80U,
    0x584c90f9U,
    0x565a2022U,
    0x48215008U,
    0x43321820U,
    0x8acdd41dU,
    0xa09c961eU,
    0x2c78714U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0xd8000000U,
    0xbc000000U,
    0xc2000000U,
    0xc9000000U,
    0x5d800000U,
    0x50400000U,
    0x7e00000U,
    0x5eb00000U,
    0xf7680000U,
    0xab40000U,
    0xf16e0000U,
    0xadb70000U,
    0xfed8000U,
    0xd71c000U,
    0x7bc86000U,
    0xf67d000U,
    0x41762800U,
    0xa1c93c00U,
    0x1a66aa00U,
    0xaef40300U,
    0xe088df80U,
    0xfc04f840U,
    0x6206aa20U,
    0xd9040330U,
    0xf580df98U,
    0x3440f85cU,
    0x79e0aa16U,
    0x55b7031fU,
    0x63eb5fa8U,
    0x772386eU,
    0xa6cb4a01U,
    0xf4e6130bU,
    0xa63097a9U,
    0xf0a91479U,
    0x8015a83cU,
    0x53bffc09U,
    0xe32b4a15U,
    0xa3561312U,
    0x6cd8979fU,
    0xda5d147aU,
    0xae9ba833U,
    0x1cb8fc3dU,
    0xd9aeca21U,
    0x6d93d321U,
    0xbbfef793U,
    0x28cdc47bU,
    0xe7e00006U,
    0xeeb00014U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0xb8000000U,
    0x24000000U,
    0x6000000U,
    0xa5000000U,
    0x1e800000U,
    0x4c00000U,
    0xdfa00000U,
    0xec700000U,
    0x5ee80000U,
    0xc0740000U,
    0xd4ea0000U,
    0x9f770000U,
    0x1d688000U,
    0x9e32c000U,
    0x5989a000U,
    0xb1a2f000U,
    0x95748800U,
    0x26e0400U,
    0x37b2ae00U,
    0x8c9f900U,
    0x4d444d80U,
    0x9ee44e40U,
    0xc892ae20U,
    0x2179f910U,
    0xb48c4d98U,
    0x43204e54U,
    0x3bb0ae0eU,
    0xb2caf919U,
    0xfa46cd99U,
    0xcb618e7dU,
    0xebd38e09U,
    0xc699c918U,
    0x209965aeU,
    0x9598ba46U,
    0x531c881eU,
    0x23da0428U,
    0x4278ae1bU,
    0x2f0ef921U,
    0x6964cdb9U,
    0x8d28e5fU,
    0x1d190e35U,
    0x6ad80909U,
    0xf6fa45aaU,
    0x44cb8a42U,
    0x97432017U,
    0x79e3302bU,
    0x2517a83fU,
    0x263d340dU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x78000000U,
    0xac000000U,
    0xfa000000U,
    0xbf000000U,
    0x21800000U,
    0x44400000U,
    0xc1e00000U,
    0x8b300000U,
    0xa4280000U,
    0xd1340000U,
    0xb2e0000U,
    0xa8b50000U,
    0x33688000U,
    0xeb56c000U,
    0xab5de000U,
    0x94f91000U,
    0x812c1800U,
    0x7fb61c00U,
    0xe6eb3a00U,
    0x29109300U,
    0x57bda380U,
    0x2d4e5240U,
    0xbac33a20U,
    0x94249330U,
    0x8693a388U,
    0xeafb5274U,
    0xd02bba3eU,
    0x9732531bU,
    0x162e43b6U,
    0x4a32425bU,
    0xd4afa236U,
    0x7df04f0aU,
    0x3a0b7986U,
    0x40a7d179U,
    0x1452819fU,
    0x6adcdd7eU,
    0x20bba3a4U,
    0xe8cf5263U,
    0x2085ba1bU,
    0x14c75330U,
    0xbd26c3b0U,
    0xc214825dU,
    0xe03a420dU,
    0xc0d5f34U,
    0x35a1619fU,
    0x2d0cd6dU,
    0xb1f3b96U,
    0x8b1f8e72U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0xc8000000U,
    0xd4000000U,
    0xd6000000U,
    0x21000000U,
    0x95800000U,
    0x3e400000U,
    0xb8600000U,
    0x8b900000U,
    0x1c580000U,
    0x69940000U,
    0x5b5a0000U,
    0xe5150000U,
    0x3c9c8000U,
    0xa9334000U,
    0x2c6a2000U,
    0x5c7df000U,
    0xd3672800U,
    0x7d175c00U,
    0x6099da00U,
    0x8b331f00U,
    0xb6e4680U,
    0x20fc9dc0U,
    0xaca1da20U,
    0x2d371f10U,
    0x726c4688U,
    0x897d9df4U,
    0x40e75a12U,
    0xaa515f25U,
    0x997ae6bdU,
    0xe8e32dfcU,
    0x8e525237U,
    0x577ff32aU,
    0xd5e61493U,
    0x19d66edeU,
    0x9e3b4eb0U,
    0xd90231f0U,
    0x39852825U,
    0x4465c37U,
    0x83675a17U,
    0xf5115f3eU,
    0x949ae6b4U,
    0x8d332df1U,
    0xe26a520cU,
    0x617bf338U,
    0x44e41486U,
    0xb4576ed5U,
    0x6c7dce82U,
    0xab6471e0U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0xb8000000U,
    0x94000000U,
    0xaa000000U,
    0x11000000U,
    0x67800000U,
    0xa0c00000U,
    0x53200000U,
    0xb7500000U,
    0xa2780000U,
    0x11540000U,
    0x5d7e0000U,
    0xd5d10000U,
    0xf3e8000U,
    0x53b4c000U,
    0xce8a2000U,
    0xd8399000U,
    0x7b36a800U,
    0x2c8ac00U,
    0xf558ae00U,
    0x7403b500U,
    0xda025480U,
    0x1900c6c0U,
    0x5b80ae20U,
    0x26c7b530U,
    0x7c2454a8U,
    0x6bd5c6c4U,
    0x74382e0eU,
    0x85367515U,
    0x19cef482U,
    0x93d996c0U,
    0xb422617U,
    0xbde7893dU,
    0x5774d296U,
    0x5faa1fedU,
    0xf268f4bfU,
    0x90cc96f9U,
    0xb05aa621U,
    0x19864928U,
    0x7bc672b4U,
    0x95a24fd9U,
    0xd814fc94U,
    0x7d986affU,
    0xcb20000eU,
    0xf3500008U,
    0x10780012U,
    0x8454003aU,
    0x28fe0013U,
    0xf011001aU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xc8000000U,
    0xe4000000U,
    0x76000000U,
    0x29000000U,
    0x7800000U,
    0xbbc00000U,
    0x5de00000U,
    0x6d500000U,
    0xdc680000U,
    0x24540000U,
    0xebea0000U,
    0xb7930000U,
    0x22098000U,
    0x64c54000U,
    0x3366a000U,
    0x3112f000U,
    0x4a4de800U,
    0xdce1cc00U,
    0xbed1b600U,
    0x39ae6300U,
    0xc4b07c80U,
    0x3f387040U,
    0x1d3bb620U,
    0x2a3d6310U,
    0x70b9fcb8U,
    0x2fd305cU,
    0xe1dd1612U,
    0x44ef9329U,
    0x111414a5U,
    0x9a4cfc56U,
    0x84e4a013U,
    0xe2d5f007U,
    0x63ae6832U,
    0x7fb78c0dU,
    0x67be9604U,
    0x8879d31eU,
    0xcb9b34b0U,
    0xfbcb4c7cU,
    0xee27e81eU,
    0x74b2cc2eU,
    0x57383619U,
    0x693b2326U,
    0xe43edc9fU,
    0x75be805eU,
    0x977c5e24U,
    0x51faf35U,
    0x3789ca92U,
    0xc0021353U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0x68000000U,
    0x64000000U,
    0xfe000000U,
    0x5d000000U,
    0x8c800000U,
    0x99400000U,
    0x6d600000U,
    0x8af00000U,
    0xc6480000U,
    0xe3f40000U,
    0x7cce0000U,
    0x33b70000U,
    0x1b2e8000U,
    0x71044000U,
    0xa685a000U,
    0x2247b000U,
    0xa0e14800U,
    0x6d30d400U,
    0xf56d0200U,
    0x2be4ff00U,
    0x78b47580U,
    0x6eaa3d40U,
    0xfac30220U,
    0x1fa3ff30U,
    0x2152f598U,
    0x111a7d44U,
    0xdbe8a23aU,
    0xbda34f29U,
    0x2e553da7U,
    0x2a9ae953U,
    0x152e0019U,
    0x9407000fU,
    0x4606803cU,
    0x31004031U,
    0x683a008U,
    0x5244b007U,
    0xd8e1c83bU,
    0x61339439U,
    0x6f6e2214U,
    0x88e30f02U,
    0xa9369dadU,
    0x7b6e5966U,
    0xee7c83fU,
    0xf830940fU,
    0x6deea213U,
    0x34a04f0aU,
    0x44d5bdaaU,
    0xf2d9a945U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0xe8000000U,
    0xdc000000U,
    0x9e000000U,
    0xf9000000U,
    0x15800000U,
    0x4f400000U,
    0x42a00000U,
    0x3e300000U,
    0x3e380000U,
    0xb340000U,
    0x2dba0000U,
    0x29710000U,
    0x89b8000U,
    0xd7064000U,
    0x44856000U,
    0x26c6b000U,
    0xa3e0a800U,
    0x6d931c00U,
    0xc98b5200U,
    0xe44a4900U,
    0x9d2a4380U,
    0x2f7848c0U,
    0x50915220U,
    0x960b4910U,
    0x8009c3a8U,
    0x750a08ccU,
    0x868e321aU,
    0x34ccf927U,
    0xc9eaeb8fU,
    0x39b54f2U,
    0xd82001fU,
    0x9b450034U,
    0x90a1801fU,
    0x8137403dU,
    0xe6bee030U,
    0x13f0f026U,
    0x475dc83cU,
    0xb961ac3bU,
    0x5251fa08U,
    0xefe85524U,
    0x1e9a918aU,
    0x220441ccU,
    0xb7067185U,
    0x9481b1fcU,
    0x5ec239a0U,
    0xa7e35de6U,
    0xc79723bfU,
    0x728af8ceU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x88000000U,
    0xc4000000U,
    0x9e000000U,
    0x1f000000U,
    0x60800000U,
    0x3a400000U,
    0xb3a00000U,
    0xa3700000U,
    0x19980000U,
    0x20740000U,
    0xfb1e0000U,
    0x47370000U,
    0x15398000U,
    0x73834000U,
    0xa0c7a000U,
    0x98e3b000U,
    0x17515800U,
    0xac2bb400U,
    0xea0b0a00U,
    0x4ab86900U,
    0x79453180U,
    0x3124d5c0U,
    0x34350a20U,
    0x7fbf6930U,
    0xd0c4b198U,
    0xd0e395fcU,
    0xb354aa02U,
    0xc22fd901U,
    0x7d0a69bfU,
    0xee3861fbU,
    0xdd07801aU,
    0x9d84400fU,
    0xf7c62013U,
    0x5c64f013U,
    0x4310f83cU,
    0x888b0437U,
    0xedfdd235U,
    0xf7679d3eU,
    0xf5901b9bU,
    0x9cc4cdaU,
    0x50dec39aU,
    0xf957b8efU,
    0xfb2de9beU,
    0x2e8c21f3U,
    0x1ef9a036U,
    0x5de4b018U,
    0x36d0d803U,
    0x89ecf431U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0xc8000000U,
    0xc000000U,
    0xf6000000U,
    0x91000000U,
    0xbc800000U,
    0x2400000U,
    0x38e00000U,
    0x4a700000U,
    0x7b880000U,
    0xfd740000U,
    0x2e0a0000U,
    0x27b10000U,
    0x1ead8000U,
    0xfa274000U,
    0xed5e000U,
    0x341cf000U,
    0x760f6800U,
    0xf3b21400U,
    0x7cabfa00U,
    0xa9251300U,
    0x11550980U,
    0xe1dcdf40U,
    0x9729fa20U,
    0xaee01310U,
    0xcb7289a8U,
    0x5f0a9f7cU,
    0xcb319a12U,
    0x24eba313U,
    0x6c00195U,
    0xbea07b58U,
    0x2897083dU,
    0xa6f9a413U,
    0x6379721bU,
    0x61bff70aU,
    0xc51b9b83U,
    0xda8ad87cU,
    0x69f28998U,
    0x704a9f6fU,
    0xd1519a3eU,
    0x1dba32dU,
    0xc728019cU,
    0x96e47b69U,
    0xf75082bU,
    0xa50ca40aU,
    0xac36f22dU,
    0x96db736U,
    0xb801fb8dU,
    0x8404686bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0x78000000U,
    0x4c000000U,
    0x52000000U,
    0xe7000000U,
    0x28800000U,
    0x62400000U,
    0x600000U,
    0x1300000U,
    0x4b480000U,
    0xec340000U,
    0x38ce0000U,
    0x2cf10000U,
    0xc1ef8000U,
    0x2f22c000U,
    0x42d5e000U,
    0xf2bc5000U,
    0x1258d800U,
    0x852a1400U,
    0x70014a00U,
    0x18015700U,
    0xdc036380U,
    0x1a033d40U,
    0xd3074a20U,
    0x36845730U,
    0xd742e3a8U,
    0xcfe0fd4cU,
    0x4bf52a3eU,
    0x296ec723U,
    0xed61dbbcU,
    0x72b7b975U,
    0x8b8b3834U,
    0x1513443bU,
    0x3b18123cU,
    0xafc88335U,
    0x1c704986U,
    0x7fa8fa70U,
    0x354711baU,
    0x90e02e42U,
    0x8f73bba0U,
    0x292d2954U,
    0x72000008U,
    0x17000018U,
    0xf0800004U,
    0x1e400037U,
    0x2a600002U,
    0xaa300003U,
    0x31c8001dU,
    0x6974000dU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xd8000000U,
    0xac000000U,
    0xe2000000U,
    0xb3000000U,
    0x3800000U,
    0xd5400000U,
    0x76600000U,
    0xaab00000U,
    0x9480000U,
    0x93b40000U,
    0xfdca0000U,
    0xa3770000U,
    0x6bea8000U,
    0x5921c000U,
    0xe3d7e000U,
    0x327ad000U,
    0x34bc7800U,
    0x6f9fcc00U,
    0x6f4b5200U,
    0xe6b13f00U,
    0xbb492780U,
    0x98b7c540U,
    0x42495220U,
    0x4c323f10U,
    0x289a798U,
    0x12110544U,
    0x8cdc3216U,
    0xd42d2f3bU,
    0xb6803fa0U,
    0xb3c71968U,
    0x3da39816U,
    0x4b111c0eU,
    0x685d2a3dU,
    0x3ce9f302U,
    0x8ca0f5b4U,
    0xab933a7aU,
    0x69d95baU,
    0x23c82a7eU,
    0x6a760da0U,
    0x176d3653U,
    0x7de12794U,
    0x2bf3c571U,
    0x412b5223U,
    0xa0013f3aU,
    0x3001278aU,
    0xa803c56bU,
    0x6403520aU,
    0x96053f23U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0xe8000000U,
    0x9c000000U,
    0x6a000000U,
    0xbf000000U,
    0xdd800000U,
    0xac400000U,
    0x42200000U,
    0xd0100000U,
    0xe8380000U,
    0x59140000U,
    0x80ba0000U,
    0x7d50000U,
    0xeb5f8000U,
    0x4da24000U,
    0x67536000U,
    0xf99d1000U,
    0x34409800U,
    0x5620fc00U,
    0xb6157a00U,
    0x653a2d00U,
    0x4f955a80U,
    0x77d5cc0U,
    0x3cb77a20U,
    0x1beb2d10U,
    0x448da88U,
    0x381e1cecU,
    0xb2019a1aU,
    0x8b017d37U,
    0xb84a292U,
    0xc941b0c3U,
    0xc8a7182dU,
    0x3dd6bc1cU,
    0x6c5c1a02U,
    0x74223d37U,
    0x651242b7U,
    0x1abbe0daU,
    0x70d3600aU,
    0x1add100aU,
    0x63e0983fU,
    0x670fc02U,
    0x9e0d7a13U,
    0xcf3e2d2cU,
    0x90975a97U,
    0x4afc5cffU,
    0xc8f2fa03U,
    0x2dcc6d1dU,
    0x225c3abcU,
    0x5254cdfU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x18000000U,
    0x74000000U,
    0x26000000U,
    0x43000000U,
    0xdc800000U,
    0x1c400000U,
    0x76a00000U,
    0xad100000U,
    0x82480000U,
    0x6c140000U,
    0xe3ce0000U,
    0x7bd30000U,
    0x23ac8000U,
    0xe723c000U,
    0xd2d72000U,
    0x9e2ef000U,
    0xeae73800U,
    0x1bb11400U,
    0xcf5e5a00U,
    0xbe5ae100U,
    0x97dd5280U,
    0xec1fe340U,
    0x7e785a20U,
    0x878de130U,
    0xe977d2b8U,
    0x50bb2354U,
    0x26dfa26U,
    0x5c43d12dU,
    0x56a34ab1U,
    0x1d130744U,
    0xca4db811U,
    0x15d42aU,
    0xb1cbfa2cU,
    0x1ed4d12fU,
    0xbc29ca91U,
    0x27e7c741U,
    0xb830180cU,
    0x459fe415U,
    0xc5b96227U,
    0xf5ebf531U,
    0x40830897U,
    0x2645024fU,
    0xcfa508bbU,
    0x28920244U,
    0x4b8f8890U,
    0xcb76c275U,
    0x9dba2894U,
    0xa1e8f256U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x58000000U,
    0xdc000000U,
    0xaa000000U,
    0xa9000000U,
    0x6b800000U,
    0xcbc00000U,
    0x64600000U,
    0x92900000U,
    0x7bf80000U,
    0xe5940000U,
    0xf77e0000U,
    0x8ad10000U,
    0xd85b8000U,
    0xf163c000U,
    0x83156000U,
    0x513a9000U,
    0xde722800U,
    0x802acc00U,
    0x4a4cf600U,
    0xc7daaf00U,
    0x74a24280U,
    0x2873c0c0U,
    0x432af620U,
    0x28cfaf30U,
    0xd79fc2a8U,
    0x830500ecU,
    0x2821636U,
    0x43ff07U,
    0x1fa50a82U,
    0xaef39cc6U,
    0x356c282cU,
    0x346bcc35U,
    0xbbef761bU,
    0x162d6f22U,
    0x99492292U,
    0x4d5850fcU,
    0xe0e35e2eU,
    0xa9d6a31cU,
    0x6ade549aU,
    0xa9213fdbU,
    0x40b47cb2U,
    0x55cff3d5U,
    0x421e8abdU,
    0xdfc05cd3U,
    0x3a61480bU,
    0xb5955c1eU,
    0x7f7b5e11U,
    0x1ed2a303U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x28000000U,
    0xb4000000U,
    0xde000000U,
    0x5000000U,
    0xd1800000U,
    0x5dc00000U,
    0x25e00000U,
    0x6bd00000U,
    0x8c480000U,
    0xaa540000U,
    0xb98a0000U,
    0xdbb30000U,
    0x9c5e8000U,
    0x7afa4000U,
    0x538f2000U,
    0x40b6b000U,
    0xa8dc0800U,
    0x66bebc00U,
    0x3aca600U,
    0xba84b300U,
    0x91434880U,
    0x45a7d940U,
    0xc1f22620U,
    0x857ef310U,
    0xf34c68b8U,
    0xc8d16964U,
    0x64ce2e2aU,
    0x3c104f3dU,
    0xa2a8ce8fU,
    0xdd01da65U,
    0x9d87669eU,
    0xffc4966aU,
    0xdae468a6U,
    0x4955696fU,
    0xb10c2e05U,
    0xddf74f24U,
    0xaf7c4ea2U,
    0xc8489a64U,
    0x8c56c6adU,
    0xc088665fU,
    0xf03740a8U,
    0x329d655eU,
    0x3f9c8001U,
    0x6a1d4039U,
    0xb1dba015U,
    0x9d3ff030U,
    0x656da82dU,
    0xdbe24c31U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0xe8000000U,
    0xac000000U,
    0x9e000000U,
    0x13000000U,
    0xb800000U,
    0x68400000U,
    0x2fa00000U,
    0x21d00000U,
    0x99d80000U,
    0x3a540000U,
    0x899e0000U,
    0x1f10000U,
    0x82498000U,
    0x512e4000U,
    0x9298e000U,
    0x3674b000U,
    0xcc097800U,
    0xd98d6c00U,
    0x62cc7a00U,
    0xe6e8f100U,
    0x5f7bc480U,
    0x10647c0U,
    0xb685fa20U,
    0x38c6b130U,
    0x106324a8U,
    0x1032f7fcU,
    0x28ac821aU,
    0x17dbdd1bU,
    0x51575e8fU,
    0x961e06f8U,
    0x43b14698U,
    0x64e89ac1U,
    0x5a7d24a4U,
    0xe583f7c0U,
    0x53450216U,
    0x28259d33U,
    0x2797be9cU,
    0x4d7eb6dbU,
    0xbc063eb9U,
    0xe604f6dfU,
    0x700dea0U,
    0x218146d7U,
    0xa140268eU,
    0x5226ad9U,
    0xcf14bca6U,
    0xc6be2bd1U,
    0x57e60017U,
    0x76750015U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x18000000U,
    0x7c000000U,
    0xea000000U,
    0x27000000U,
    0x3a800000U,
    0x4c400000U,
    0x99600000U,
    0x4c700000U,
    0x4780000U,
    0xeef40000U,
    0x743a0000U,
    0xfd970000U,
    0xef4d8000U,
    0xdb6fc000U,
    0x31fa6000U,
    0xdc329000U,
    0xa71c5800U,
    0xd86c400U,
    0xdec5fa00U,
    0xd1226f00U,
    0xb3120980U,
    0x9d0b94c0U,
    0x8b087a20U,
    0x60daf10U,
    0x7b886998U,
    0xfd4904fcU,
    0x306c2226U,
    0x997f6b0fU,
    0x3b7793a2U,
    0xf6fc6bf5U,
    0x56b3aba8U,
    0x935b3fdcU,
    0x18e589a4U,
    0x60b354f6U,
    0x8e5f9a31U,
    0x8d60ff1bU,
    0x8276519fU,
    0xd57950c6U,
    0xe9778028U,
    0x3df8c018U,
    0x6e37e01bU,
    0x9c1d503dU,
    0x2d06383dU,
    0xad845411U,
    0xec1a23bU,
    0x5920ab1dU,
    0x2715f3acU,
    0x130afbc5U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x28000000U,
    0xbc000000U,
    0xae000000U,
    0xef000000U,
    0x5a800000U,
    0x58400000U,
    0xc3200000U,
    0xcf100000U,
    0x3c080000U,
    0xed940000U,
    0x104a0000U,
    0xcb10000U,
    0x265e8000U,
    0x11384000U,
    0xdb0f6000U,
    0xdb173000U,
    0x6e091800U,
    0xc936400U,
    0x35cf9a00U,
    0x26741d00U,
    0x13dd280U,
    0xb30f6540U,
    0xc7111a20U,
    0x500c5d10U,
    0xcb92b2a8U,
    0xd3485564U,
    0xd030022aU,
    0x2d1b393fU,
    0x269f2883U,
    0xa359485fU,
    0x7eb950bcU,
    0x14cd1c69U,
    0xe3f7d293U,
    0x1bfe657cU,
    0x2c6f9a1bU,
    0xf1241d36U,
    0x5e15d2bdU,
    0x18b6540U,
    0xc3531a11U,
    0xd295d2dU,
    0x53863297U,
    0x21c1154fU,
    0x77e1e211U,
    0xbf744926U,
    0x50b95083U,
    0xbbcd1c6bU,
    0x1977d2a5U,
    0xd3be657aU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0x18000000U,
    0x3c000000U,
    0x6a000000U,
    0xdd000000U,
    0xdc800000U,
    0xf6c00000U,
    0xf9a00000U,
    0x9e100000U,
    0xfbd80000U,
    0x2e940000U,
    0xdf1e0000U,
    0x46370000U,
    0xff8e8000U,
    0xb22fc000U,
    0xa23b6000U,
    0xb2e29000U,
    0xe7f28800U,
    0xd7aef400U,
    0x7e7cfe00U,
    0x7a815900U,
    0x89c21e80U,
    0xbc20cfc0U,
    0xf2527e20U,
    0x5bbe9930U,
    0x74a17e98U,
    0xfa965fc4U,
    0x411ef626U,
    0xb5376d3fU,
    0xb80b0082U,
    0x376cc6f3U,
    0x90d98891U,
    0x951232c2U,
    0x505d769cU,
    0xb9d76be4U,
    0x1cf96837U,
    0xcf44a40dU,
    0x5fe3960dU,
    0x9376fd0aU,
    0x756908aaU,
    0xd9daf2e2U,
    0x779096acU,
    0x259e3be0U,
    0xff68009U,
    0x23abc03cU,
    0x507d601eU,
    0xe1819004U,
    0xfa420831U,
    0x77663414U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x78000000U,
    0xe4000000U,
    0xde000000U,
    0x8b000000U,
    0x44800000U,
    0xdcc00000U,
    0xeb200000U,
    0xb0700000U,
    0xb0e80000U,
    0x8f40000U,
    0xa62a0000U,
    0x2ed30000U,
    0x8ddf8000U,
    0xa078c000U,
    0xddcca000U,
    0xc7843000U,
    0xa443f800U,
    0x5de59400U,
    0xc653de00U,
    0x531f6d00U,
    0x1a5aed80U,
    0xcc3c5240U,
    0x1c2c5e20U,
    0x3bd7ad10U,
    0xa25e4db8U,
    0x883c626cU,
    0x922da63eU,
    0x78d53929U,
    0x7ad8138fU,
    0x6ef8cf4eU,
    0x2c0c6bafU,
    0x7219b5eU,
    0x52711595U,
    0x51edc672U,
    0xd175803bU,
    0x296bc030U,
    0x67b32002U,
    0x5f4cf010U,
    0x84475837U,
    0x4de5a406U,
    0xee522602U,
    0x7f1df903U,
    0x585cb38dU,
    0x7d38ff66U,
    0xdad9399U,
    0x28930f50U,
    0xd13f4b91U,
    0xfad6b79U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0xa8000000U,
    0x2c000000U,
    0xa000000U,
    0xd000000U,
    0xd800000U,
    0xf3400000U,
    0x49600000U,
    0x53300000U,
    0x2ae80000U,
    0x6ab40000U,
    0x67ae0000U,
    0x50d10000U,
    0xea1c8000U,
    0x7fc4000U,
    0x1c09e000U,
    0x83c21000U,
    0x8fa08800U,
    0xcd12fc00U,
    0x46b95200U,
    0xbc6a5700U,
    0xb765b80U,
    0xa9084840U,
    0x6a45d220U,
    0xaae61730U,
    0x7b77bba8U,
    0x910e5854U,
    0x4e435a0aU,
    0xdce1eb3bU,
    0xd47469aaU,
    0xbd8d4f57U,
    0xba866189U,
    0x6bc2f347U,
    0xc3a25398U,
    0x3712f473U,
    0xb3bb602bU,
    0x35ef5009U,
    0xde35e80bU,
    0xe76cac1cU,
    0x39f03a1bU,
    0x7ecabb2fU,
    0xabe7818dU,
    0xecf4e35fU,
    0x674cdba2U,
    0x76a10870U,
    0xde96b21fU,
    0x96fd4731U,
    0x838c538aU,
    0x983f449U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0xe8000000U,
    0xcc000000U,
    0xba000000U,
    0x1d000000U,
    0x6c800000U,
    0x37400000U,
    0x6e00000U,
    0x9ad00000U,
    0x3dd80000U,
    0xcc540000U,
    0x579a0000U,
    0x46330000U,
    0x4a0f8000U,
    0x950c4000U,
    0xd08de000U,
    0x454b9000U,
    0x47ea0800U,
    0x345d7400U,
    0xa394f200U,
    0xa83f2300U,
    0xe907f480U,
    0x28125c0U,
    0x54437220U,
    0xb1676310U,
    0x8e1014b8U,
    0xb1f9b5ecU,
    0xb1a6fa1aU,
    0xdc365723U,
    0x47090696U,
    0x418d06ebU,
    0x73cb0681U,
    0xddaa06eeU,
    0xb63e86b7U,
    0xc20546ddU,
    0x2904e6b6U,
    0xa28696f1U,
    0x4410e98U,
    0xe96772ffU,
    0xaa12748aU,
    0xc7fe65d3U,
    0x16a11237U,
    0xadb0b323U,
    0x1ccffcbaU,
    0x702b51e8U,
    0xeffa0028U,
    0x7aa30016U,
    0x47b7802fU,
    0x59c8400aU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x18000000U,
    0x2c000000U,
    0x62000000U,
    0x4b000000U,
    0xbd800000U,
    0x5cc00000U,
    0xb4200000U,
    0x31900000U,
    0xee880000U,
    0x7e140000U,
    0x414e0000U,
    0xebb70000U,
    0x86188000U,
    0xce1fc000U,
    0x3a1de000U,
    0x141ad000U,
    0xed1cb800U,
    0x399bc00U,
    0xcede9e00U,
    0x443d7d00U,
    0x8a8c0280U,
    0xe8105140U,
    0x244e1e20U,
    0xaf36bd30U,
    0x345fe298U,
    0xb77d8174U,
    0x816a2626U,
    0x3420c13bU,
    0xf1949c80U,
    0x8e8e2c66U,
    0xae149c89U,
    0x594e2c6cU,
    0xc7b49c8dU,
    0xe41e2c5aU,
    0x851c9caaU,
    0x879a2c47U,
    0x48da9c9bU,
    0x59392c6bU,
    0x320c1c93U,
    0x2051ec66U,
    0x3a297cbaU,
    0xcbc4fc79U,
    0x3a02485U,
    0xa253906aU,
    0x612c02b2U,
    0xe405177U,
    0xa3661e37U,
    0x6c72bd2aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x98000000U,
    0xb4000000U,
    0xb2000000U,
    0xf9000000U,
    0x2d800000U,
    0xa2400000U,
    0xd3e00000U,
    0x39300000U,
    0xaf980000U,
    0x9eb40000U,
    0xd0da0000U,
    0x6ad50000U,
    0xd6ac8000U,
    0x1129c000U,
    0x9e6d2000U,
    0x220e5000U,
    0x87be800U,
    0x7581bc00U,
    0x76463a00U,
    0x91e48300U,
    0x88316380U,
    0xae19b7c0U,
    0x3af2ba20U,
    0x48394310U,
    0x87664388U,
    0xf6f2e7f4U,
    0xfe3dd206U,
    0xa4653f3dU,
    0xde7759a4U,
    0xeffd34caU,
    0x2ac3d98dU,
    0x5220f4d5U,
    0xf94f9b0U,
    0x47cba4d4U,
    0x54db91aeU,
    0xf0d7d8c6U,
    0xf3aa8ba2U,
    0x72a80be3U,
    0x5b2c8037U,
    0x2369c03cU,
    0xf58d202eU,
    0x7f3e5013U,
    0x8de3e829U,
    0xa635bc0bU,
    0x391c3a36U,
    0xa0718309U,
    0xa0fde3b5U,
    0x244077e9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0x38000000U,
    0x74000000U,
    0x2000000U,
    0x4d000000U,
    0x9c800000U,
    0xdfc00000U,
    0x40e00000U,
    0x30300000U,
    0x9380000U,
    0x82b40000U,
    0x7dfe0000U,
    0x79d50000U,
    0x7f8d8000U,
    0x3d4cc000U,
    0x692a2000U,
    0xeadad000U,
    0xa5014800U,
    0x6081b400U,
    0xb1c47600U,
    0xbe71300U,
    0xdbb76780U,
    0x737f72c0U,
    0x8311f620U,
    0x9fefd330U,
    0x9cbb4788U,
    0x1bf4a2dcU,
    0x8bdb3e2eU,
    0xdf83a72dU,
    0x98469188U,
    0x1ca0a1cfU,
    0x3692b189U,
    0x76af71daU,
    0x529e79b8U,
    0xc9a205f3U,
    0x6e102f83U,
    0xb36fc6e6U,
    0x5b7e0029U,
    0x5f150030U,
    0x81ed803cU,
    0xefbcc00aU,
    0x8472203cU,
    0xf39ed011U,
    0x93274803U,
    0xe6d0b41fU,
    0x260ff61cU,
    0x120ad33dU,
    0xf00ec78dU,
    0xed0c62f9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0x28000000U,
    0xc000000U,
    0x2000000U,
    0x39000000U,
    0xa5800000U,
    0x1b400000U,
    0x3ca00000U,
    0xb2500000U,
    0xd5780000U,
    0x61d40000U,
    0xe13e0000U,
    0xc7f50000U,
    0x2aa98000U,
    0x83ec4000U,
    0x4e4de000U,
    0x859a5000U,
    0x91a52800U,
    0xd1d4fc00U,
    0x293eb200U,
    0x1bf67900U,
    0xf0abb080U,
    0x9eeedac0U,
    0xe5cf3220U,
    0xa5de3930U,
    0x31805088U,
    0xdd458afcU,
    0xdba59a2aU,
    0xf4d78533U,
    0x76bc8288U,
    0xedb4e3f2U,
    0x4f896283U,
    0xfab3f5U,
    0x92924aa7U,
    0xf19b4feeU,
    0x87a578beU,
    0xeed176d1U,
    0x4bbb2815U,
    0xb631fc1cU,
    0x47cf3214U,
    0xacde390fU,
    0x9c005087U,
    0x3a058af7U,
    0xcd059a1dU,
    0x73878518U,
    0x44482baU,
    0xae20e3d8U,
    0x379762baU,
    0x6e1fb3c5U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0x88000000U,
    0xc000000U,
    0x46000000U,
    0x63000000U,
    0x7a800000U,
    0xf2c00000U,
    0x68e00000U,
    0x9cd00000U,
    0x57980000U,
    0x5540000U,
    0x9fda0000U,
    0xbf750000U,
    0x9bed8000U,
    0xfc394000U,
    0xc521e000U,
    0x20b57000U,
    0x868df800U,
    0x7eae2400U,
    0x139eae00U,
    0x2f55c300U,
    0x6aded880U,
    0xdef7f7c0U,
    0x97a92e20U,
    0x2c198310U,
    0x1412b888U,
    0xf27bc7fcU,
    0x5c053602U,
    0x7e02d713U,
    0xc701ee99U,
    0xc08020e4U,
    0x5fc5409cU,
    0x7d60e3efU,
    0x52961823U,
    0xaebe5413U,
    0x8be6d621U,
    0xa656a702U,
    0x855b968eU,
    0x9db244d3U,
    0x8b0f8e9cU,
    0xe4ed10caU,
    0xd8bed8baU,
    0xe7f7d0U,
    0xd12e02U,
    0x499d8329U,
    0x1250b8bcU,
    0x275ac7caU,
    0x64b2b637U,
    0xac8e970fU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x48000000U,
    0x94000000U,
    0x72000000U,
    0xfb000000U,
    0xa2800000U,
    0x4f400000U,
    0x42200000U,
    0x52100000U,
    0xc7580000U,
    0x3940000U,
    0x1e9e0000U,
    0x2cf70000U,
    0x8daf8000U,
    0xc73d4000U,
    0xe0272000U,
    0x1114d000U,
    0xd9d9f800U,
    0x9ad14400U,
    0x9dbd4200U,
    0xb3673500U,
    0xd5332280U,
    0x32cfa7c0U,
    0x4c0cc220U,
    0xe7ed7530U,
    0xd29b8298U,
    0x12f637ccU,
    0x88aa1a32U,
    0xbce115U,
    0x58e13884U,
    0xa3f746f2U,
    0xad2bfa9aU,
    0x5b7933c6U,
    0xa481f834U,
    0x36454416U,
    0x33a34213U,
    0x1bd0353aU,
    0xf03ca299U,
    0x7ca2e7c4U,
    0x5b53e206U,
    0x5c7da52cU,
    0x70047a9fU,
    0xe80473c4U,
    0xc406d806U,
    0xa019416U,
    0x2702ba2dU,
    0x44857111U,
    0xc647e09dU,
    0x1ba6d2e6U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xc8000000U,
    0xec000000U,
    0x2000000U,
    0x77000000U,
    0x2f800000U,
    0x3c00000U,
    0x63600000U,
    0x94700000U,
    0xc9f80000U,
    0x14f40000U,
    0x51ba0000U,
    0x82550000U,
    0x7ad8000U,
    0xa15b4000U,
    0x6fe6e000U,
    0xde355000U,
    0x105a5800U,
    0x4964ac00U,
    0x9f708600U,
    0xfc7c1700U,
    0xb4349580U,
    0x3b5bd0c0U,
    0x8ce70620U,
    0xf7b25710U,
    0x7a9ff588U,
    0xb885c0fcU,
    0xbc43be12U,
    0x78a7ab2bU,
    0x23172b88U,
    0x7b8c7be1U,
    0x44082d99U,
    0x1fca2cebU,
    0x88add830U,
    0xcadaec14U,
    0x5223e603U,
    0xf0560702U,
    0xf8aa2dbeU,
    0x42db2ce3U,
    0x9e225818U,
    0x250ac20U,
    0x47aa8614U,
    0x8159170eU,
    0x9fe1159dU,
    0x163490e1U,
    0xfc5be63aU,
    0x4b620720U,
    0xe8702dbfU,
    0xd3fe2ce8U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0x8000000U,
    0xc4000000U,
    0xea000000U,
    0x15000000U,
    0x17800000U,
    0x2cc00000U,
    0x6be00000U,
    0x5500000U,
    0x34280000U,
    0xf3d40000U,
    0x5d6e0000U,
    0x1df50000U,
    0x525c8000U,
    0x334d4000U,
    0xd2c6a000U,
    0x5ce01000U,
    0xe3d50800U,
    0xb56d2c00U,
    0xa9f3ae00U,
    0xe05c9300U,
    0xea4bb480U,
    0xeb426a40U,
    0x8f212e20U,
    0x8ab4d330U,
    0x8b799488U,
    0xdafb3a54U,
    0x7d3c8622U,
    0x865cef01U,
    0x314bb2b2U,
    0x73c3c551U,
    0xf9643ca7U,
    0x1613064aU,
    0xe70ea008U,
    0x7f641020U,
    0xbd130802U,
    0x278c2c12U,
    0xc5212e35U,
    0xfb4d332U,
    0xb4f994a6U,
    0x623b3a7eU,
    0xf4dc861cU,
    0x520cef2aU,
    0xf8e3b2b3U,
    0xb9d7c548U,
    0xd86a3ca6U,
    0x22760655U,
    0xea9a2013U,
    0xbaad503dU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x48000000U,
    0x94000000U,
    0x26000000U,
    0xdd000000U,
    0xe3800000U,
    0xf3400000U,
    0x47600000U,
    0x59300000U,
    0x19880000U,
    0x1bb40000U,
    0xab4e0000U,
    0xcc930000U,
    0x679f8000U,
    0x66e94000U,
    0xbe872000U,
    0xd0c27000U,
    0x5424c800U,
    0x2e55ec00U,
    0x8bf9200U,
    0x963cb700U,
    0x96f88b80U,
    0xbade0340U,
    0x488e1220U,
    0xf236f730U,
    0x9f082bb8U,
    0x3771334cU,
    0x9d6bfa32U,
    0x61c66b15U,
    0x8da2f1b1U,
    0x5212287bU,
    0x675c438aU,
    0x4acbef69U,
    0x4cd18000U,
    0x6a7a401dU,
    0x3918a014U,
    0x862b3013U,
    0xa2a3e820U,
    0x6a979c37U,
    0x7a9b5a2eU,
    0x65695b14U,
    0x7dc719acU,
    0xdfa2b46dU,
    0x991699bbU,
    0x11d8f472U,
    0xce0e3999U,
    0xdef3c458U,
    0xa92dd189U,
    0x9a245856U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0x88000000U,
    0x24000000U,
    0x86000000U,
    0xd5000000U,
    0x3f800000U,
    0xddc00000U,
    0xa2600000U,
    0xb6100000U,
    0xe8d80000U,
    0xa0940000U,
    0x909a0000U,
    0x350000U,
    0x3c6d8000U,
    0x67b94000U,
    0xc500a000U,
    0x27837000U,
    0xa1c10800U,
    0x78660c00U,
    0x49152600U,
    0xa059ff00U,
    0x11d5c680U,
    0x5bf01c0U,
    0xf602a620U,
    0x1d05bf10U,
    0x3b80e688U,
    0xabc131fcU,
    0xff610e02U,
    0xad91c319U,
    0xb31b48a9U,
    0xd7f682c9U,
    0x190ece8dU,
    0x352c0deeU,
    0x3e9a0021U,
    0x41350034U,
    0x2ded801fU,
    0xbb79402aU,
    0x56e0a00fU,
    0xbd537011U,
    0x52f9081bU,
    0x66220c33U,
    0xacb72632U,
    0x6b28ff13U,
    0xf79a46b5U,
    0x74b741c2U,
    0x772d861dU,
    0xfd9e8f19U,
    0xf3b6ce8fU,
    0x93a80dfaU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xd8000000U,
    0x6c000000U,
    0x52000000U,
    0x2b000000U,
    0x55800000U,
    0x9bc00000U,
    0x56600000U,
    0x18700000U,
    0x98a80000U,
    0x74f40000U,
    0x9dee0000U,
    0x1cd50000U,
    0x40388000U,
    0x7e6bc000U,
    0x8a17e000U,
    0x76db5000U,
    0x159b800U,
    0x799a7c00U,
    0xee7b2600U,
    0x83cc6f00U,
    0xec049580U,
    0x9201a240U,
    0xb05a620U,
    0x8586af30U,
    0x43c5f588U,
    0x3a643274U,
    0x4a737e16U,
    0xb3ac432bU,
    0x21708b9cU,
    0x629717eU,
    0x4ab57583U,
    0x584bf24dU,
    0xe6c29e29U,
    0xfee61308U,
    0xeb37b38dU,
    0x1d89cd54U,
    0x39a733b0U,
    0x90160d60U,
    0x9ded39fU,
    0x9ad85d6aU,
    0x935feb9bU,
    0x7299e165U,
    0x6bfb2da9U,
    0xc00ade4fU,
    0xd6600007U,
    0xd8700014U,
    0xb8a80026U,
    0xa4f40027U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x88000000U,
    0x44000000U,
    0xf6000000U,
    0xef000000U,
    0x47800000U,
    0x38c00000U,
    0x8fe00000U,
    0x20700000U,
    0xcc780000U,
    0x96f40000U,
    0x283e0000U,
    0xe8550000U,
    0x4c688000U,
    0xf6394000U,
    0x5356a000U,
    0x55ecf000U,
    0xb5fed800U,
    0xe5354c00U,
    0xe65fde00U,
    0x47e05300U,
    0x8474cd80U,
    0xca7838c0U,
    0x21f15e20U,
    0xa3b81330U,
    0x6294ed88U,
    0xda8888f4U,
    0x7ec9a602U,
    0xe06cef21U,
    0x743d4bb5U,
    0x325467cfU,
    0xe16ced93U,
    0xf0bc88efU,
    0xf17a636U,
    0x1749ef37U,
    0x3badcb88U,
    0x2e5927ceU,
    0xe3e44d96U,
    0x827578e8U,
    0x7d79fe24U,
    0xaa71e329U,
    0x297ab586U,
    0xf47084ccU,
    0x527ed811U,
    0xcdf54c33U,
    0xc1bfde30U,
    0xf390531aU,
    0x360ccd85U,
    0xf78c38dbU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x38000000U,
    0xfc000000U,
    0xc2000000U,
    0x27000000U,
    0x32800000U,
    0x8ac00000U,
    0x84200000U,
    0x17d00000U,
    0xf6980000U,
    0x44540000U,
    0x77de0000U,
    0x2d330000U,
    0x136c8000U,
    0x341ac000U,
    0x86976000U,
    0x87fed000U,
    0x6ce75800U,
    0xc4f2c400U,
    0x5bcc4e00U,
    0xac0ac500U,
    0xb1a80080U,
    0x5439d9c0U,
    0x1f46ce20U,
    0xfc670530U,
    0xf935e0b8U,
    0x356ac9d4U,
    0x9d1c762eU,
    0x3916d10fU,
    0xdcbb1688U,
    0x6e85d8ddU,
    0x38c480a2U,
    0x2b2319edU,
    0xb151ae09U,
    0x7a59d528U,
    0xd972b887U,
    0xb7880dd8U,
    0x44e83822U,
    0x6b581408U,
    0x5af5163dU,
    0xcecb0123U,
    0x3188ce9fU,
    0x9de9dcf2U,
    0x5cd9ae93U,
    0x95b00cd1U,
    0xcaac7683U,
    0xd4bb08d6U,
    0x3a83d899U,
    0xdec1ddfcU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x18000000U,
    0x6c000000U,
    0xaa000000U,
    0x81000000U,
    0x50800000U,
    0xdac00000U,
    0xf3200000U,
    0xdd500000U,
    0x15b80000U,
    0xf2d40000U,
    0x8fe0000U,
    0x18b10000U,
    0x51ce8000U,
    0x1b39c000U,
    0xaf11e000U,
    0x205e9000U,
    0xdea6e800U,
    0x25119400U,
    0x715c7e00U,
    0x3627ad00U,
    0x83d7a480U,
    0x307fd8c0U,
    0x674fe20U,
    0x6ceb6d30U,
    0x996ec4a8U,
    0xad2d88c4U,
    0x73cb7626U,
    0x2e38a92bU,
    0x99953282U,
    0xc19de1e4U,
    0xe40124b2U,
    0x1e0218ddU,
    0xe7031e1eU,
    0x6b80fd23U,
    0x1340acbfU,
    0x1560dcd5U,
    0x5eb66832U,
    0xbac9543aU,
    0x6abb1e07U,
    0x3554fd28U,
    0x11beac87U,
    0x9cd1dcd4U,
    0x47f8e810U,
    0x17309414U,
    0x9c8afe0cU,
    0x495a6d0dU,
    0x8a2044bbU,
    0x91d448e9U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xa8000000U,
    0xec000000U,
    0x32000000U,
    0xb7000000U,
    0x11800000U,
    0x6400000U,
    0x7b600000U,
    0x5b300000U,
    0x5a80000U,
    0x1d740000U,
    0xdece0000U,
    0x76470000U,
    0x23648000U,
    0x2f364000U,
    0x23ade000U,
    0xdc70d000U,
    0xa64cd800U,
    0xe4861c00U,
    0xf8c10a00U,
    0x18a51700U,
    0x170b80U,
    0xe4ff2640U,
    0x3b6cea20U,
    0x54d5c730U,
    0x6e5bd398U,
    0xbc793a54U,
    0x59ade00aU,
    0x1770d00bU,
    0x4dccd814U,
    0xe9c61c39U,
    0x8210a2eU,
    0x1ed5173aU,
    0x5d5f0b92U,
    0x13fb267bU,
    0x8aeaea25U,
    0x6296c736U,
    0xed3953b1U,
    0xa34c7a5fU,
    0x82028003U,
    0x8f054007U,
    0x3587602bU,
    0x88419013U,
    0x5665b80fU,
    0x11b08c08U,
    0x20683224U,
    0xd757db0aU,
    0xef1cd9acU,
    0x2e9f2d46U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x8000000U,
    0x3c000000U,
    0xfe000000U,
    0xed000000U,
    0xae800000U,
    0x54400000U,
    0xba600000U,
    0x94f00000U,
    0xf4180000U,
    0xf0b40000U,
    0xf67e0000U,
    0x20410000U,
    0x18608000U,
    0xf7f54000U,
    0x6f9f6000U,
    0x3e73b000U,
    0xda588800U,
    0x1dd38400U,
    0x3b0d4a00U,
    0x999e700U,
    0x87736580U,
    0xc6dec3c0U,
    0x82922a20U,
    0xf6ea5730U,
    0xa5abeda8U,
    0x8e4d47f4U,
    0x5b7f6022U,
    0xeec3b03fU,
    0x3c208817U,
    0x9597840fU,
    0xcf6b4a29U,
    0x86ce71aU,
    0x39ede591U,
    0xa82a83deU,
    0xe18dca36U,
    0xffdca719U,
    0x5e1405bbU,
    0xc9a973d9U,
    0xb84ca219U,
    0x2a7cd33eU,
    0x6e4027b1U,
    0x8d64e0c8U,
    0xbd75e5b9U,
    0xf1de83d0U,
    0xab13ca0cU,
    0xf32da717U,
    0xfe0c85abU,
    0x8b1833e4U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0xf8000000U,
    0x14000000U,
    0xda000000U,
    0x33000000U,
    0xcc800000U,
    0xb7400000U,
    0xae600000U,
    0xc8700000U,
    0xbd080000U,
    0xf7340000U,
    0x6f6e0000U,
    0xa9410000U,
    0x7f648000U,
    0x83f2c000U,
    0x4cca2000U,
    0x25151000U,
    0xd1ff3800U,
    0xb179b400U,
    0xa83ca200U,
    0x1f5bd700U,
    0x80aed980U,
    0xaa640b40U,
    0x8a768220U,
    0x6a0ec730U,
    0x49b1e1a8U,
    0x72dbf54U,
    0x5a2201eU,
    0xe9511035U,
    0x6f19381eU,
    0x84cb418U,
    0xee56220dU,
    0xe9981728U,
    0xd408799dU,
    0xc8b7db7eU,
    0xb4ad9a3cU,
    0xe0636320U,
    0xe176fb98U,
    0xe28d1c4cU,
    0xdcf27baeU,
    0x8e4fdc68U,
    0xdb505bb6U,
    0xd01ecc4bU,
    0xfac963aeU,
    0x18127840U,
    0x547f4192U,
    0xa9ba6f51U,
    0x859f3808U,
    0xda09b43bU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x68000000U,
    0x8c000000U,
    0xe2000000U,
    0x19000000U,
    0x83800000U,
    0x61400000U,
    0x25600000U,
    0x9d900000U,
    0x37b80000U,
    0xf0d40000U,
    0xb0da0000U,
    0xd4410000U,
    0x74e18000U,
    0x2dd64000U,
    0x6d5fe000U,
    0x86005000U,
    0x3706a800U,
    0xd8860c00U,
    0x8bc04200U,
    0xafa67700U,
    0x55b38680U,
    0x6d4f86c0U,
    0x43ffa220U,
    0xf4362710U,
    0xf50d2ea8U,
    0x351d8adcU,
    0x10e5e03aU,
    0x3d15033U,
    0x365f2810U,
    0x6c844c1aU,
    0xbdc5a23aU,
    0x10a7273bU,
    0xd134aeb1U,
    0x1c8fcae1U,
    0x1158000dU,
    0x4c040034U,
    0x202000dU,
    0xc905000eU,
    0x9b83800aU,
    0x85434014U,
    0x4b64600fU,
    0x66971012U,
    0xad38c830U,
    0x12101c25U,
    0xf4f90a30U,
    0x6cb02b2dU,
    0xdecd6c95U,
    0xeabbfdd1U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x78000000U,
    0xbc000000U,
    0xc2000000U,
    0x49000000U,
    0x1b800000U,
    0x12c00000U,
    0xe200000U,
    0xa8700000U,
    0x1ff80000U,
    0x3eb40000U,
    0x4fde0000U,
    0x4dc30000U,
    0xcaa38000U,
    0xbe34c000U,
    0xe7986000U,
    0xdea1d000U,
    0xc831a800U,
    0x4899cc00U,
    0x42235e00U,
    0x32756d00U,
    0xbaff3580U,
    0x2f371ec0U,
    0xd01b3e20U,
    0x2664bd30U,
    0xfb169db8U,
    0xfd6ad2ecU,
    0x781e603eU,
    0x9266d01fU,
    0x1d142808U,
    0x7a6a0c3eU,
    0x909ebe18U,
    0x6e277d2bU,
    0xd8737db3U,
    0x87fcc2f8U,
    0x32b42821U,
    0xf5da0c3bU,
    0xb8c6be28U,
    0x13237d15U,
    0xe5f57dabU,
    0xf23bc2cfU,
    0x6411a83aU,
    0xd9e9cc06U,
    0xde5b5e3eU,
    0x12016d15U,
    0x410135b4U,
    0x3f841efeU,
    0xdcc0be0bU,
    0xfd247d34U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x18000000U,
    0x34000000U,
    0x8a000000U,
    0xd3000000U,
    0x90800000U,
    0x78c00000U,
    0xa6e00000U,
    0x31300000U,
    0x15280000U,
    0xc5f40000U,
    0xddce0000U,
    0x95c50000U,
    0xaf668000U,
    0x2a71c000U,
    0x4b892000U,
    0x32e09000U,
    0x6b313800U,
    0xfe29d400U,
    0x7171de00U,
    0x370f7300U,
    0xd426ef80U,
    0x84d74e40U,
    0x9498fe20U,
    0xb81fe330U,
    0xa6dfd788U,
    0x4d3a9a44U,
    0xa58f2026U,
    0x93e1903dU,
    0x2cb1b82aU,
    0x94691430U,
    0x50507e22U,
    0x8e5b2313U,
    0xd1f8778bU,
    0xb16fca78U,
    0x55d13801U,
    0x3b19d41fU,
    0xce59de16U,
    0x31fb732dU,
    0x8168efa8U,
    0x5dd24e76U,
    0x171e7e27U,
    0x705e232dU,
    0x68fef79dU,
    0xc2ee0a6fU,
    0xb5901801U,
    0xc93d4430U,
    0xe78ee600U,
    0x4ce3a71fU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x88000000U,
    0x1c000000U,
    0x4a000000U,
    0x4d000000U,
    0xfc800000U,
    0x22400000U,
    0x8b200000U,
    0x15900000U,
    0x5cf80000U,
    0xadd40000U,
    0x62da0000U,
    0xb0c70000U,
    0x7a638000U,
    0x19374000U,
    0xa0a96000U,
    0x61ca1000U,
    0x937c8800U,
    0x7810b400U,
    0xe83bfa00U,
    0x19b17d00U,
    0xb8ee9e80U,
    0x4fef4ec0U,
    0x566a9a20U,
    0xc4af6d10U,
    0x9fc81698U,
    0xd878faccU,
    0x3b92e002U,
    0xeff95017U,
    0x1a57e80aU,
    0x319a41fU,
    0x3c26f21dU,
    0x6c15890fU,
    0xfe3d84b0U,
    0x7eb063d6U,
    0x39686c88U,
    0x192ac7f3U,
    0xe30f1e82U,
    0x101b0ef5U,
    0x9ba27a13U,
    0xd5d13d36U,
    0xd6dc7e98U,
    0xb6c61eecU,
    0xc5657215U,
    0x3cb2c914U,
    0x286ce485U,
    0xcfae73ccU,
    0xbc4ee482U,
    0xefbd73fcU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x18000000U,
    0x2c000000U,
    0xbe000000U,
    0xc7000000U,
    0xe2800000U,
    0x1b400000U,
    0x3be00000U,
    0xe8d00000U,
    0x7780000U,
    0x31940000U,
    0x1d9a0000U,
    0xf0c50000U,
    0x8d248000U,
    0x3ef1c000U,
    0x8d0fe000U,
    0x84d93000U,
    0xca215800U,
    0x9c71e400U,
    0xb6496200U,
    0x6f3c8b00U,
    0x3af03c80U,
    0xb70e74c0U,
    0x39de8220U,
    0xb5a1bb10U,
    0x28b36488U,
    0x216e90f4U,
    0x3cc96026U,
    0xd079f01bU,
    0xab103827U,
    0xdadc1405U,
    0xbd235a3eU,
    0x96f59f0dU,
    0x490fe6a1U,
    0xdede2bcbU,
    0x87248499U,
    0x2bf3a0daU,
    0x368a3821U,
    0x6a191422U,
    0x1007da2cU,
    0x78045f3cU,
    0xdc00068dU,
    0x76071be7U,
    0xf305dca6U,
    0x708244cfU,
    0x62435a10U,
    0x1e659f22U,
    0x1117e6bdU,
    0x27da2bc3U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x98000000U,
    0xd4000000U,
    0x6000000U,
    0x91000000U,
    0xb3800000U,
    0xd7c00000U,
    0x2b600000U,
    0xef900000U,
    0x5f180000U,
    0x3a540000U,
    0x2b7a0000U,
    0xab430000U,
    0xaa258000U,
    0xb6b3c000U,
    0xb5292000U,
    0x5e38f000U,
    0xa4642800U,
    0x5910ac00U,
    0xdd5ab600U,
    0xa7f38700U,
    0xc409a280U,
    0x180e33c0U,
    0xe20b9620U,
    0xd90f7710U,
    0xd98f8ab8U,
    0xb2c99ffcU,
    0xb8eea006U,
    0x1e5c3025U,
    0xc3728839U,
    0xd1489c18U,
    0xa72a3e0aU,
    0x693c1b00U,
    0x96e41c8bU,
    0x5556e8dfU,
    0x6df92a9bU,
    0xb101afebU,
    0xe3862818U,
    0x5fc7ac3dU,
    0x97653623U,
    0xa593472aU,
    0x1c1d0280U,
    0x1ed103ecU,
    0xde3c9e0eU,
    0xe4642b3aU,
    0xb9149484U,
    0x2d5974ccU,
    0x3ff49483U,
    0x100974c0U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0xc8000000U,
    0xfc000000U,
    0xfe000000U,
    0x81000000U,
    0x3e800000U,
    0x30c00000U,
    0x13600000U,
    0x8a300000U,
    0xfec80000U,
    0xf0f40000U,
    0x2eaa0000U,
    0xdb430000U,
    0xaf258000U,
    0xfe914000U,
    0xd4186000U,
    0xbc4db000U,
    0x7e35e800U,
    0x5ccb0400U,
    0x9ff10e00U,
    0xa92aaf00U,
    0xe1077780U,
    0x8e82fd40U,
    0x18c16e20U,
    0x1f631f10U,
    0xbc309fb8U,
    0x83cef97cU,
    0x3077e012U,
    0x9f6ff02fU,
    0xf6a00807U,
    0x15d3f41cU,
    0x133e863dU,
    0xaedb1b33U,
    0x6c2c11bbU,
    0x55811642U,
    0xdd42f790U,
    0xba23bd60U,
    0xd2110e17U,
    0xa3daaf38U,
    0x24af779eU,
    0xf846fd40U,
    0xfea36e13U,
    0x49d41f16U,
    0xfd3f1fbcU,
    0x17dcb978U,
    0x66aa000bU,
    0x67430004U,
    0xb125801bU,
    0x8f914036U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x48000000U,
    0xc4000000U,
    0xf2000000U,
    0x73000000U,
    0x24800000U,
    0x1dc00000U,
    0xe7600000U,
    0x2d700000U,
    0x1780000U,
    0x5eb40000U,
    0x4b1a0000U,
    0x22430000U,
    0x6a248000U,
    0x5dd54000U,
    0xe468a000U,
    0x2839d000U,
    0x4c13b800U,
    0x750bb400U,
    0x644ef600U,
    0xcaecdf00U,
    0x5afce580U,
    0x11f100c0U,
    0xd0be5620U,
    0x6fd10f10U,
    0x376d5db8U,
    0x3cbdb4f4U,
    0xc9d62032U,
    0x1e6f9021U,
    0x7f3f9804U,
    0x4a972428U,
    0x53cdee1bU,
    0x63aabb36U,
    0x85bab85U,
    0xcfe56bd7U,
    0x46b0c5a9U,
    0x871d90c0U,
    0xf4454e33U,
    0x3b236b27U,
    0x425013b0U,
    0x192adfc5U,
    0x209c33a5U,
    0xf5064fffU,
    0x7d872ba4U,
    0x26442bf5U,
    0x3822659aU,
    0x1ed740e1U,
    0x58ea760aU,
    0xb9f99f0cU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x68000000U,
    0x2c000000U,
    0x8e000000U,
    0x7000000U,
    0x16800000U,
    0x93c00000U,
    0x10a00000U,
    0x96700000U,
    0xadd80000U,
    0xffb40000U,
    0x607e0000U,
    0xd2470000U,
    0x3de08000U,
    0x59104000U,
    0x750fe000U,
    0xab1b3000U,
    0x8935800U,
    0x5049c400U,
    0x987d2600U,
    0x3647f100U,
    0x2fe70d80U,
    0x68157bc0U,
    0x208ac620U,
    0x8c58c130U,
    0x2f25598U,
    0xc71fbff4U,
    0x2691603aU,
    0xe74c703bU,
    0x36fc383bU,
    0xe182b435U,
    0x9d419e1fU,
    0x7765052fU,
    0x9cd173a7U,
    0xf6af4ee4U,
    0xe1eeed8eU,
    0x938d4bebU,
    0x20df1e24U,
    0xec324515U,
    0xdc3e13a6U,
    0xf8a43ed6U,
    0x7a72559cU,
    0x43dfbfe4U,
    0x28b16013U,
    0x1efc7023U,
    0x6d843838U,
    0xa346b419U,
    0xc8679e1fU,
    0xce56051eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0xb8000000U,
    0x74000000U,
    0xae000000U,
    0x59000000U,
    0xfa800000U,
    0x11c00000U,
    0xdbe00000U,
    0x45f00000U,
    0x15780000U,
    0xd9340000U,
    0xa1a0000U,
    0x4c050000U,
    0x9a048000U,
    0xd704c000U,
    0x73852000U,
    0x5340b000U,
    0xbe216800U,
    0x3012a400U,
    0x98a4600U,
    0x36cd0b00U,
    0xc2eca180U,
    0x9df974c0U,
    0x93f56620U,
    0x5878bb10U,
    0x7db14988U,
    0x2adb10f4U,
    0xa160000eU,
    0x1430000dU,
    0xee980023U,
    0x4cc40022U,
    0xa7620010U,
    0xe1310019U,
    0x3e1e801dU,
    0xc201c007U,
    0x1301a03bU,
    0x95847032U,
    0x16444834U,
    0x26a21402U,
    0xa2d32e23U,
    0xdfebaf03U,
    0xc17ce79eU,
    0xe7317fc7U,
    0xcb1d47a9U,
    0x12850fe9U,
    0x9dc10fb6U,
    0x21e31bfdU,
    0x62f02199U,
    0xef9b4d2U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0x68000000U,
    0x1c000000U,
    0x1a000000U,
    0xb7000000U,
    0x1a800000U,
    0xedc00000U,
    0xeaa00000U,
    0xf9700000U,
    0xd3980000U,
    0x4fb40000U,
    0x11ba0000U,
    0x10030000U,
    0x58018000U,
    0x94044000U,
    0x76036000U,
    0xc5039000U,
    0xb1855800U,
    0xed400400U,
    0xb062d600U,
    0x9578100U,
    0xc728a580U,
    0x768dc9c0U,
    0xa77bb620U,
    0xd2271110U,
    0x7b47db8U,
    0xddbd8ddcU,
    0xf200003aU,
    0xeb000017U,
    0xe080003eU,
    0x2ac00031U,
    0x9820001cU,
    0x8b0003cU,
    0x2338003cU,
    0x1c40013U,
    0xd8a20032U,
    0xb2770028U,
    0xa31b803eU,
    0x7d77403aU,
    0xfd9ae022U,
    0x1eb3d036U,
    0xd63c3819U,
    0x38409435U,
    0x59e60e3aU,
    0x7013c51eU,
    0x14913b1U,
    0xbad9d8f3U,
    0xd1d64bbdU,
    0x49eadcf6U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x38000000U,
    0x4000000U,
    0x36000000U,
    0x2f000000U,
    0x1e800000U,
    0x5400000U,
    0x72e00000U,
    0x3c100000U,
    0x22180000U,
    0xaa540000U,
    0xbc7e0000U,
    0x6a030000U,
    0x6d038000U,
    0xdf86c000U,
    0x80c5a000U,
    0x67207000U,
    0x60b15800U,
    0x44694400U,
    0x9e1d5200U,
    0x58516300U,
    0x4578ca80U,
    0xeb8407c0U,
    0x4ec6f220U,
    0xac221330U,
    0xf83212b8U,
    0x562f83ecU,
    0xf678002eU,
    0x57040031U,
    0x3a860035U,
    0x63470027U,
    0xd5e58009U,
    0x1e91c000U,
    0x15582011U,
    0xc1b5b004U,
    0xb1ef780fU,
    0x53dbf42bU,
    0xb0f7aa33U,
    0x2d0b5715U,
    0xf4cf4093U,
    0x826ee0ddU,
    0xa918caafU,
    0x12d407f3U,
    0xfe3ef21bU,
    0x8a66133aU,
    0x5e5412b1U,
    0x927883e2U,
    0x1105802aU,
    0xcd81c011U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0x8000000U,
    0x6c000000U,
    0x2000000U,
    0x5000000U,
    0x1f800000U,
    0x27400000U,
    0xa2200000U,
    0x41900000U,
    0xb8280000U,
    0x41d40000U,
    0x908e0000U,
    0x90810000U,
    0x91c48000U,
    0x38e54000U,
    0x91f1e000U,
    0x4c185000U,
    0xf32f4800U,
    0xc952ec00U,
    0x54a1200U,
    0x36666d00U,
    0x5f37f680U,
    0xa7ef040U,
    0x341df220U,
    0x72b3d30U,
    0xf523ea8U,
    0x3e485c54U,
    0x26e28022U,
    0xef0402bU,
    0x929b6028U,
    0xf5ec1015U,
    0x43322805U,
    0x907bfc12U,
    0xf51aba28U,
    0x26add111U,
    0x27162ca9U,
    0xeaef3159U,
    0x5db1f6acU,
    0x36bbf044U,
    0x2f7f7202U,
    0xbb9b7d3aU,
    0x88695eaaU,
    0x91744c78U,
    0x75d8a83aU,
    0xf7cfbc16U,
    0x52a7da0aU,
    0x2054c102U,
    0xd8ce8486U,
    0xb4208d72U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x98000000U,
    0x84000000U,
    0x22000000U,
    0x85000000U,
    0xd4800000U,
    0xc7400000U,
    0xd7200000U,
    0x9900000U,
    0x3b80000U,
    0x51d40000U,
    0xb11e0000U,
    0x81830000U,
    0xabc28000U,
    0xe463c000U,
    0xf4b0a000U,
    0x932dd000U,
    0x20ec0800U,
    0x808db400U,
    0xb63f1200U,
    0x30119d00U,
    0x5c7f3680U,
    0x9fb1c4c0U,
    0xdca9b220U,
    0x602b4d30U,
    0xeb6fbeb8U,
    0xe24cb0e4U,
    0x58dc8006U,
    0xb0e0c011U,
    0xf3f22030U,
    0xa40e1005U,
    0xb97ca813U,
    0x1b306410U,
    0x63eb1a3dU,
    0xa3082923U,
    0x58fe24b5U,
    0xe0f359e5U,
    0xff8c04b9U,
    0x43bd49d2U,
    0x71d0acb2U,
    0xc11d2df9U,
    0x8983b6afU,
    0xb7c104f1U,
    0x42639214U,
    0x53b15d0dU,
    0xc2ad16b3U,
    0x332fd4fdU,
    0x90ed1a11U,
    0x688f2904U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x68000000U,
    0x94000000U,
    0x2000000U,
    0xd7000000U,
    0xfe800000U,
    0xfac00000U,
    0x7a00000U,
    0x93100000U,
    0xeab80000U,
    0xe4d40000U,
    0x989e0000U,
    0xf5870000U,
    0x42458000U,
    0x50604000U,
    0x31372000U,
    0x83eb5000U,
    0xb20e1800U,
    0xc37de400U,
    0xc7f06e00U,
    0xba494900U,
    0x1c8e80U,
    0x724108c0U,
    0x98614e20U,
    0xb5311930U,
    0x99e91698U,
    0x990bacdcU,
    0xabfb803aU,
    0xe8374015U,
    0x946aa018U,
    0x974f1029U,
    0x659f3825U,
    0xe805b41bU,
    0x5405f601U,
    0x6203ed11U,
    0xa7064085U,
    0x968751c7U,
    0x6ec2f887U,
    0x5a5a5e9U,
    0x4415ae92U,
    0x143d58c1U,
    0x1e12d608U,
    0x9f38bd14U,
    0x669058beU,
    0xa8feb5e8U,
    0xb4b496b8U,
    0xa9afecd0U,
    0x766aa02aU,
    0xf04f102fU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0xe8000000U,
    0x4c000000U,
    0x3e000000U,
    0x4f000000U,
    0x63800000U,
    0x8ac00000U,
    0x97200000U,
    0x64300000U,
    0xbe480000U,
    0x3f40000U,
    0x73ea0000U,
    0x7d830000U,
    0x75c28000U,
    0xeca04000U,
    0x5af2e000U,
    0xb36eb000U,
    0x5ac41800U,
    0xdf20ec00U,
    0xd8312e00U,
    0x784f2500U,
    0xe8f43780U,
    0x62692b40U,
    0x8641ce20U,
    0xce669510U,
    0x61d0afb8U,
    0xf95e8744U,
    0x438a801aU,
    0xf3544003U,
    0x1f18e037U,
    0xddedb017U,
    0x9a869822U,
    0xba40ac31U,
    0x4863ce2aU,
    0x6ad1950aU,
    0xf8d82fb7U,
    0x504dc762U,
    0x4f2e019U,
    0xac6eb016U,
    0x3144180aU,
    0x9e0ec3fU,
    0x99112e30U,
    0x1f7f2520U,
    0xb3c3784U,
    0xa45d2b5fU,
    0x10bce18U,
    0x5d159500U,
    0x3d7a2fb1U,
    0x723ac772U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x28000000U,
    0x7c000000U,
    0xde000000U,
    0x7f000000U,
    0xa6800000U,
    0x6b400000U,
    0xe8e00000U,
    0xf5500000U,
    0xa9180000U,
    0x2b140000U,
    0xda7e0000U,
    0x82850000U,
    0x11468000U,
    0x2de04000U,
    0xb6d36000U,
    0x91dfb000U,
    0xd3341800U,
    0xab0dc400U,
    0x84eda200U,
    0x4338f300U,
    0x366b080U,
    0x71966fc0U,
    0xaf38c220U,
    0x35664330U,
    0x52922888U,
    0xc7baebc4U,
    0x926802aU,
    0x60f0402fU,
    0x87ab603fU,
    0x37dbb01bU,
    0x18321823U,
    0x9f8cc405U,
    0x76ad220dU,
    0x2659b322U,
    0x99f55083U,
    0xfa289fd0U,
    0x401f3a2cU,
    0x7e95772dU,
    0xd1b872a6U,
    0x3a212cc5U,
    0x20726ab1U,
    0xc7e9e8ebU,
    0xdbb948afU,
    0x27215bcaU,
    0x7f49807U,
    0x652c8405U,
    0xd69e423bU,
    0x2dd6030fU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x28000000U,
    0x14000000U,
    0xf6000000U,
    0xbf000000U,
    0x17800000U,
    0xf8400000U,
    0x21a00000U,
    0xfd300000U,
    0x41f80000U,
    0x92f40000U,
    0xd81a0000U,
    0xae630000U,
    0x34d08000U,
    0x556e4000U,
    0x6a3e2000U,
    0xd510f000U,
    0x4f885800U,
    0xa32e8c00U,
    0x889ffa00U,
    0x3da15100U,
    0xef30bb80U,
    0x90fd8ac0U,
    0x56715a20U,
    0xfddfe110U,
    0x2a86c3b8U,
    0xb6c3f6d4U,
    0xb966f82aU,
    0x77503c15U,
    0xbb298205U,
    0xa49f2d3bU,
    0x17a7198fU,
    0xe23257fbU,
    0xe67e1b95U,
    0x12b33ac0U,
    0xc5bf220dU,
    0xb1559d1eU,
    0x3c2b618cU,
    0x6f1f2bc5U,
    0x5de1398aU,
    0xa296a7cbU,
    0xa7cc438cU,
    0x4a8eb6cbU,
    0x31a85801U,
    0xa25e8c3dU,
    0xd6c7fa2fU,
    0xa965511fU,
    0xbf52bbbcU,
    0xff2a8ad7U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x8000000U,
    0x24000000U,
    0xae000000U,
    0x5000000U,
    0x17800000U,
    0x73c00000U,
    0x6c200000U,
    0x71500000U,
    0xe5e80000U,
    0x3d140000U,
    0x6e0a0000U,
    0x26610000U,
    0x2bb58000U,
    0x4f1d4000U,
    0x2a6aa000U,
    0xd2d33000U,
    0x202e0800U,
    0x28334c00U,
    0x7ade7600U,
    0x374bbd00U,
    0xe205c480U,
    0x9f065640U,
    0xe4815620U,
    0xbd45cd10U,
    0x8a616ca8U,
    0xe1b62a7cU,
    0x44192822U,
    0xc8e93c19U,
    0xbe90de03U,
    0x1bcac13dU,
    0x9b403a87U,
    0xeb63e755U,
    0xf8304490U,
    0xc2db164dU,
    0xbb4bf634U,
    0x9806fd3fU,
    0x3c0764aaU,
    0xd2016660U,
    0x77055e3aU,
    0x90878104U,
    0xeb429a97U,
    0xa364d75cU,
    0x7c344cbeU,
    0x9cd95a40U,
    0xb6480015U,
    0xab840007U,
    0xe1c2003dU,
    0xbb250002U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0xb8000000U,
    0xfc000000U,
    0xf6000000U,
    0x53000000U,
    0xff800000U,
    0xc2400000U,
    0x7e00000U,
    0x50500000U,
    0x8dc80000U,
    0xd1940000U,
    0x5e6e0000U,
    0xc5250000U,
    0xf4778000U,
    0x1f3cc000U,
    0x766a6000U,
    0x71207000U,
    0x66727800U,
    0x7638cc00U,
    0x94ecca00U,
    0xe3e7e300U,
    0xaa53c080U,
    0xb0c9f940U,
    0xb1112a20U,
    0x2dab5330U,
    0xaf83d888U,
    0xaa45454cU,
    0x53e1980eU,
    0xd2517c0fU,
    0x6ccb5235U,
    0x77179f18U,
    0xc6a91291U,
    0xac03a64fU,
    0x9e03d89cU,
    0x7054570U,
    0x7d819834U,
    0x23417c38U,
    0xa1635230U,
    0xc8939f16U,
    0xe4ef128dU,
    0xbbe2a658U,
    0x465258a8U,
    0xcec88579U,
    0xa6127832U,
    0xd828cc02U,
    0xc8c4ca3cU,
    0x123e337U,
    0x3e75c094U,
    0x9a38f95fU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0xd8000000U,
    0x64000000U,
    0x3e000000U,
    0x41000000U,
    0xdc800000U,
    0x84400000U,
    0xe2e00000U,
    0x76500000U,
    0xa180000U,
    0xaa940000U,
    0xe2be0000U,
    0xc7270000U,
    0x56758000U,
    0x5edc000U,
    0xd9bca000U,
    0xb4a53000U,
    0x87b42800U,
    0x73cf9400U,
    0x4b4f6a00U,
    0x310e1300U,
    0xf2ec4080U,
    0x283e3fc0U,
    0x7e664a20U,
    0x5216e330U,
    0xf8fcc898U,
    0x74c09bdcU,
    0x54a30816U,
    0x37b06429U,
    0xcbca6217U,
    0x5f4d770cU,
    0xd70da281U,
    0xd7e988f8U,
    0xcabac897U,
    0xbb239bfdU,
    0x6c70880dU,
    0xaeea427U,
    0x9c3d422eU,
    0x88628729U,
    0xdf10aaaeU,
    0xa67eece2U,
    0xeb852a96U,
    0x15c32cddU,
    0x58218a83U,
    0x7bf21ccdU,
    0xe52ba290U,
    0xab1a88e3U,
    0xc61148a6U,
    0xdef95be8U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x58000000U,
    0x4c000000U,
    0xe000000U,
    0x5000000U,
    0xc6800000U,
    0xcac00000U,
    0x5e600000U,
    0xb4300000U,
    0x83c80000U,
    0x4740000U,
    0x316e0000U,
    0x4f230000U,
    0x8a148000U,
    0x1d5dc000U,
    0x60ece000U,
    0xd060b000U,
    0x71334800U,
    0xa54bc400U,
    0x9eb23e00U,
    0x370a6700U,
    0xb712e780U,
    0x7da3540U,
    0x1c2a5e20U,
    0x97071730U,
    0x55854fb8U,
    0xa5454154U,
    0xc252836U,
    0x7d95b423U,
    0xe319163bU,
    0xf74cd315U,
    0xedb771a7U,
    0x88f2661U,
    0xbd57cfb4U,
    0x827f815cU,
    0x72fb4809U,
    0x613fc417U,
    0x4fdc3e35U,
    0x28296739U,
    0x65066797U,
    0x5687f554U,
    0x72c6be06U,
    0x4267a724U,
    0xe23607a0U,
    0xcace8565U,
    0xccf7163eU,
    0xfeafd336U,
    0xd7c3f1a6U,
    0xf4e2e66fU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x48000000U,
    0x54000000U,
    0x1a000000U,
    0x7000000U,
    0x87800000U,
    0x86c00000U,
    0xdd200000U,
    0xcab00000U,
    0xa6680000U,
    0xb7f40000U,
    0x838e0000U,
    0x5650000U,
    0xa3d08000U,
    0x13bb4000U,
    0x85482000U,
    0x18409000U,
    0x49659800U,
    0x65d36c00U,
    0x7ab8ce00U,
    0xcfce3500U,
    0x56021380U,
    0xc1043240U,
    0xee806e20U,
    0xcc45e530U,
    0x9367ab88U,
    0x42d3ce74U,
    0x2d3b3832U,
    0x109bc25U,
    0xdf23f60eU,
    0x11b78935U,
    0x4fe9e5b3U,
    0xfc37bb74U,
    0x962f8b91U,
    0x9a935e43U,
    0x445ea020U,
    0xb4dad008U,
    0xed9b380dU,
    0x8a79bc12U,
    0x3ebf615U,
    0x3a33893dU,
    0xff2fe5a6U,
    0xd016bb67U,
    0xa190b8cU,
    0x3cb91e7eU,
    0x66c80009U,
    0x3c84002eU,
    0x5f460014U,
    0x2ee10024U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0xf8000000U,
    0x34000000U,
    0x5e000000U,
    0x83000000U,
    0x5a800000U,
    0x72400000U,
    0xc2e00000U,
    0xa6700000U,
    0xcfe80000U,
    0x10b40000U,
    0x5c4a0000U,
    0xdea30000U,
    0xaf928000U,
    0xf18c000U,
    0x2f1d2000U,
    0x9f1b3000U,
    0x971cb800U,
    0x4b19a400U,
    0xd919ca00U,
    0x301b2300U,
    0xb79bb180U,
    0x1c596040U,
    0xf67e6a20U,
    0xe0acd310U,
    0x4bd029b8U,
    0x32f8f444U,
    0xb1e9981eU,
    0x23b6941dU,
    0xecf722fU,
    0x70e18724U,
    0xff70fba8U,
    0x406a8351U,
    0x6770fb87U,
    0x246a8359U,
    0x2170fbbdU,
    0x836a834cU,
    0xddf0fb81U,
    0x462a8347U,
    0x1b90fba9U,
    0x111a837eU,
    0x4c18fbbbU,
    0xd59e8375U,
    0x1d5afb99U,
    0xbdf9835dU,
    0x216a7b99U,
    0x7cf64363U,
    0xfdafdbbbU,
    0x3256b36aU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0xe8000000U,
    0xdc000000U,
    0x32000000U,
    0xcb000000U,
    0xd1800000U,
    0x16c00000U,
    0x36a00000U,
    0x48700000U,
    0xb1d80000U,
    0x4d340000U,
    0x72be0000U,
    0x5e670000U,
    0xdfd58000U,
    0xb72c4000U,
    0xa5a96000U,
    0xeecd000U,
    0x9489b800U,
    0x8d5d9c00U,
    0x7f732e00U,
    0x82581900U,
    0x68f64580U,
    0xd19fd3c0U,
    0x6d7ce20U,
    0x7dac8930U,
    0x9ae89d98U,
    0x6a899fdcU,
    0xec58d81aU,
    0x51f54c07U,
    0xab1c9614U,
    0xb196852eU,
    0xb5ceeb8eU,
    0x383c8af2U,
    0xa1256ba1U,
    0xdbb7cad0U,
    0xbff98ba0U,
    0x91075afaU,
    0x6815393U,
    0x954216deU,
    0x9b65c595U,
    0x475093d7U,
    0x336d2e0fU,
    0xf84f1938U,
    0xbcfbc585U,
    0x4c8793c0U,
    0xda40ae35U,
    0x2ce75912U,
    0x494a5a2U,
    0xc54843eaU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0xe8000000U,
    0x4c000000U,
    0x8e000000U,
    0xd9000000U,
    0xa8800000U,
    0x52400000U,
    0x3ea00000U,
    0x3ab00000U,
    0x44e80000U,
    0x32740000U,
    0x70a0000U,
    0x83e70000U,
    0x91948000U,
    0x269c4000U,
    0x9d78e000U,
    0xa8ed3000U,
    0x4c71a800U,
    0x860eb400U,
    0x5f629a00U,
    0xe9d51100U,
    0x3391780U,
    0x58498a40U,
    0xcfc6fa20U,
    0xba606110U,
    0xd7525f98U,
    0x9c790e74U,
    0x346b481aU,
    0x54308403U,
    0x73adb23bU,
    0x7250e502U,
    0xc2ffed90U,
    0x7b29eb47U,
    0xd014a58cU,
    0xa4596f68U,
    0x35991783U,
    0xbef98a7cU,
    0x8d2efa0cU,
    0xcd146119U,
    0x1ed85fb4U,
    0xd8de0e54U,
    0xbddfc835U,
    0xc35cc42bU,
    0x3c1d5229U,
    0x8039d530U,
    0xf3cc45beU,
    0x76045f55U,
    0x5d00bf8fU,
    0xda833e73U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x8000000U,
    0x6c000000U,
    0x22000000U,
    0xc9000000U,
    0x30800000U,
    0x47400000U,
    0x9ea00000U,
    0xfcb00000U,
    0x44f80000U,
    0x7d740000U,
    0x221a0000U,
    0xd0e70000U,
    0x72928000U,
    0x8f0b4000U,
    0xbf2fe000U,
    0xc7df5000U,
    0xf8002800U,
    0x34011400U,
    0x2607b200U,
    0x9706d100U,
    0xd387ef80U,
    0xd2c2eac0U,
    0xcb62d220U,
    0xec56c110U,
    0x166a2798U,
    0x827faec4U,
    0x8535c822U,
    0x7339440bU,
    0xc4951a10U,
    0x500c8536U,
    0x60afbd8eU,
    0x271b6bcaU,
    0xf265158fU,
    0x84d53fddU,
    0x552f47a5U,
    0x42dfbedaU,
    0x9a800015U,
    0xa2400004U,
    0xec20001fU,
    0x62f00011U,
    0xe2d80021U,
    0xaa84003dU,
    0xda420001U,
    0x98230032U,
    0x24f0801cU,
    0x65d84025U,
    0x71076034U,
    0x6483102dU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x18000000U,
    0xa4000000U,
    0x1a000000U,
    0xc7000000U,
    0x46800000U,
    0x20400000U,
    0xbd600000U,
    0xc3900000U,
    0xba880000U,
    0xc2540000U,
    0x312a0000U,
    0xa4e50000U,
    0x41528000U,
    0x1da9c000U,
    0x6ba1a000U,
    0x16b21000U,
    0x587a1800U,
    0x154e6400U,
    0x8cf1fa00U,
    0x7219ff00U,
    0xa85a4e80U,
    0xa2384740U,
    0xf28da20U,
    0x39e72f10U,
    0xe0d37688U,
    0x6b6df344U,
    0xee829826U,
    0xcc42a439U,
    0x3b62da0eU,
    0xaa922f35U,
    0x3909f697U,
    0xc7903361U,
    0xf0893809U,
    0x3d55b411U,
    0xc3aa4237U,
    0x86a58b3cU,
    0x9f31aca5U,
    0x82bfdc70U,
    0x366b6e98U,
    0x2f029756U,
    0x8a83e22fU,
    0xb6439b30U,
    0xcc61b4a7U,
    0xe414b85fU,
    0xa54814b7U,
    0xc4f2a861U,
    0xee180c8fU,
    0x659cc69U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x18000000U,
    0x44000000U,
    0xee000000U,
    0x29000000U,
    0x87800000U,
    0xe9400000U,
    0x6da00000U,
    0x2bd00000U,
    0x44a80000U,
    0x54140000U,
    0x33ce0000U,
    0xfd270000U,
    0xd4128000U,
    0xf3cbc000U,
    0x9d22a000U,
    0x4411b000U,
    0xebc86800U,
    0xd923cc00U,
    0xaa10c200U,
    0xc2ce7100U,
    0x5ea1e480U,
    0x4356c040U,
    0xaf6ee220U,
    0x75730130U,
    0x7f9ac98U,
    0xfb7f7c64U,
    0x46bce826U,
    0xfadb0c21U,
    0x2f6ee223U,
    0xb573012eU,
    0x67f9aca7U,
    0x6b7f7c6bU,
    0x5ebce800U,
    0xbedb0c30U,
    0xc16ee228U,
    0x9c73010bU,
    0xe079ac91U,
    0x823f7c64U,
    0x331ce83fU,
    0x950b0c13U,
    0x85c6e212U,
    0xc8670130U,
    0xd3b7ac92U,
    0x7f187c51U,
    0xe70e6807U,
    0x66c0cc0eU,
    0x18e44218U,
    0x8c76b107U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0x78000000U,
    0xbc000000U,
    0x6000000U,
    0xc3000000U,
    0x39800000U,
    0xcd400000U,
    0x5aa00000U,
    0x34b00000U,
    0xbdb80000U,
    0xcb740000U,
    0xb7da0000U,
    0x82250000U,
    0xa9718000U,
    0xfedac000U,
    0x26a26000U,
    0x52b1f000U,
    0x2ebaf800U,
    0xfaf67c00U,
    0xbe99b200U,
    0x6283f900U,
    0x58c67f80U,
    0xb9e3e0c0U,
    0x19105220U,
    0x728dc910U,
    0xc28f6788U,
    0xda8eacdcU,
    0x3689783eU,
    0x388dbc3fU,
    0x3f885209U,
    0xbc09c92cU,
    0xb44d6790U,
    0x146facdcU,
    0xd41af837U,
    0xfe467c2dU,
    0x5b21b229U,
    0x65f7f91dU,
    0x911c7fa5U,
    0x44c6e0c2U,
    0x8fe1d224U,
    0x8217092dU,
    0x870d07a2U,
    0x71cf5cdbU,
    0xff2b8009U,
    0x3dbfc033U,
    0x8b73e000U,
    0x97db3012U,
    0xf2209820U,
    0xd1738c2cU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0x88000000U,
    0x84000000U,
    0xaa000000U,
    0x41000000U,
    0x94800000U,
    0x8ec00000U,
    0x8c600000U,
    0xab700000U,
    0xb2f80000U,
    0xa4340000U,
    0x36de0000U,
    0xe0e10000U,
    0xe9b18000U,
    0xb0994000U,
    0x1447a000U,
    0xd9a71000U,
    0xda932800U,
    0x77ce7400U,
    0x366e3e00U,
    0x70fee700U,
    0xf1337d80U,
    0xd05f7cc0U,
    0xd3261e20U,
    0x5751b730U,
    0xfa2e75a8U,
    0x555b58fcU,
    0x8da2a802U,
    0xc8973411U,
    0x9ac99e02U,
    0x7ce9f72cU,
    0x9d385587U,
    0x2cd508c2U,
    0xcb6e2029U,
    0x227a500aU,
    0x40f28821U,
    0x5bbc6436U,
    0x2f12960cU,
    0x5d88d333U,
    0x1ccb63bcU,
    0x23efcbd5U,
    0xcab9eb8dU,
    0x393afddU,
    0x7f4b7da7U,
    0x4eab7cd7U,
    0xeb981e0eU,
    0x29c0b72eU,
    0x17e7f5a7U,
    0xa3618dcU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0xd8000000U,
    0x3c000000U,
    0x4a000000U,
    0xeb000000U,
    0xcf800000U,
    0x49400000U,
    0xb3e00000U,
    0xab300000U,
    0x82580000U,
    0xe2f40000U,
    0x217a0000U,
    0x2610000U,
    0xf7778000U,
    0xab3bc000U,
    0x3a006000U,
    0xd3069000U,
    0xe383b800U,
    0x6b41ac00U,
    0xbce3d200U,
    0x12b20300U,
    0x6a1d4380U,
    0x7592d5c0U,
    0xc8e3220U,
    0x7a9e5310U,
    0xd511ba8U,
    0xa32a29ecU,
    0x58cc3816U,
    0xe7fe6c1fU,
    0x6ba1b23aU,
    0xa4519316U,
    0x33ab7b85U,
    0x600db9ddU,
    0xe858001eU,
    0xf9f40000U,
    0x96fa003bU,
    0xc7210006U,
    0xd6978012U,
    0xd70bc025U,
    0x3dd8600fU,
    0x93b29028U,
    0xbe99b835U,
    0x8b50ac26U,
    0x7a2c5229U,
    0xf04dc31aU,
    0xf33f2381U,
    0x460145c8U,
    0x39000a0aU,
    0xb8853f17U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x8000000U,
    0xdc000000U,
    0x8e000000U,
    0x23000000U,
    0x99800000U,
    0x2c00000U,
    0x32200000U,
    0x75900000U,
    0x1d280000U,
    0xbbd40000U,
    0x834e0000U,
    0xd5230000U,
    0x6158000U,
    0x86ef4000U,
    0x11716000U,
    0xc89a3000U,
    0x9e6cf800U,
    0xef313c00U,
    0x7ef84e00U,
    0xbc9b3d00U,
    0x9c6e0a80U,
    0xda33c040U,
    0x607aae20U,
    0x7dd94d30U,
    0xdd8812b8U,
    0xa9048c5cU,
    0xb082f822U,
    0x72423c07U,
    0xa065ce1bU,
    0xa5f07d14U,
    0xb0d96aa4U,
    0xd70ef077U,
    0xda45d60fU,
    0x2c603125U,
    0xb3f2bc99U,
    0x37ddc172U,
    0x148aea8eU,
    0xa986b06fU,
    0x2ac7363dU,
    0x7e22412bU,
    0x8394a4b8U,
    0xea2a8d6cU,
    0x7052bcabU,
    0x2c8dc148U,
    0x5d82ea81U,
    0xe8c2b057U,
    0xab213610U,
    0xed15413eU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0xa8000000U,
    0x94000000U,
    0x6000000U,
    0xb1000000U,
    0x3b800000U,
    0x54c00000U,
    0x45e00000U,
    0xf9700000U,
    0x6b680000U,
    0x15340000U,
    0x86ce0000U,
    0xffe50000U,
    0x1a738000U,
    0xc7ec4000U,
    0x7b752000U,
    0x46b7000U,
    0x83b42800U,
    0xcb8a6c00U,
    0xf1c76e00U,
    0xb864d300U,
    0x3cb11d80U,
    0xa50ddc40U,
    0x1087ce20U,
    0x3c42e330U,
    0x15a59588U,
    0x46d1806cU,
    0x16bc280aU,
    0xb30e6c15U,
    0x79816e09U,
    0x1bc5d300U,
    0x63649da4U,
    0x1c309c70U,
    0xf14f6e30U,
    0xb120d322U,
    0xcc971d9cU,
    0x1a1cdc7cU,
    0x5a5a4e3aU,
    0x3dfba314U,
    0x5c2b3595U,
    0xd812b074U,
    0x385b203bU,
    0xc2fe703eU,
    0xd2afa83eU,
    0xa9522c3dU,
    0xa47c4e1cU,
    0xd7eaa31aU,
    0xa376b59eU,
    0x186bf076U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x88000000U,
    0x44000000U,
    0xc2000000U,
    0x77000000U,
    0x96800000U,
    0x2a400000U,
    0x13a00000U,
    0xcc300000U,
    0x46a80000U,
    0x79f40000U,
    0xc0ce0000U,
    0x3a70000U,
    0x84328000U,
    0x62af4000U,
    0x2bf2a000U,
    0x3fcc5000U,
    0xd1269800U,
    0x6c702400U,
    0x60daa00U,
    0x71468900U,
    0x53236380U,
    0xbb703040U,
    0x608b8a20U,
    0x43069930U,
    0x8c83db98U,
    0xf1400464U,
    0x93269802U,
    0xdb702421U,
    0xf08daa28U,
    0xcb068939U,
    0xc8836387U,
    0x3340305bU,
    0xe4238a14U,
    0x4df2991eU,
    0xdacddbacU,
    0xd8a70470U,
    0x4b41836U,
    0x75ef6412U,
    0x9dd70a18U,
    0x8d3ed93fU,
    0xd96bfbbdU,
    0x5c971454U,
    0x661ca001U,
    0x5e1b501dU,
    0xa21c1827U,
    0x5c1b6423U,
    0xb5190a36U,
    0x5a99d917U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0xe8000000U,
    0xc000000U,
    0xde000000U,
    0x65000000U,
    0xb1800000U,
    0xd9400000U,
    0x2ee00000U,
    0xa3100000U,
    0xe6880000U,
    0x3df40000U,
    0x9d9e0000U,
    0xcf7f0000U,
    0xa6e8000U,
    0xde64000U,
    0xc391e000U,
    0xd44e3000U,
    0xed548800U,
    0xf2ea5c00U,
    0x8b247200U,
    0x4933a300U,
    0x9c393680U,
    0x4b8de540U,
    0xb070fa20U,
    0x82d9ff30U,
    0xf09d4498U,
    0x22fe4664U,
    0x8529cc9aU,
    0xda041a73U,
    0xe705be8fU,
    0x8283b94dU,
    0x91c2882eU,
    0x70215c21U,
    0x3db4f21eU,
    0x4fae316U,
    0xc42e5698U,
    0xd9819563U,
    0x15439217U,
    0x90e69304U,
    0x56153e84U,
    0xbf0af976U,
    0xe8b5e83fU,
    0x6d7d2c12U,
    0x96f9a08U,
    0x5d618f3eU,
    0xe9502ca1U,
    0x70ee2a62U,
    0xb82736b2U,
    0x1b2e559U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0x38000000U,
    0x54000000U,
    0xf6000000U,
    0x63000000U,
    0xab800000U,
    0xad400000U,
    0xf0e00000U,
    0x64500000U,
    0x99d80000U,
    0x40b40000U,
    0xcb8e0000U,
    0x1a690000U,
    0xb0be8000U,
    0x44a6c000U,
    0xe352000U,
    0x664ff000U,
    0xb048f800U,
    0x834b8c00U,
    0xb0cc6200U,
    0xd98df300U,
    0xe76a4c80U,
    0xb43b9fc0U,
    0x70649a20U,
    0xfe967f30U,
    0x6e7e2ea8U,
    0xbd026ce4U,
    0x6480d6aeU,
    0x4c4e0e5U,
    0x58a434b5U,
    0x6432d3ccU,
    0xaf4bd82cU,
    0x72c97c2aU,
    0x7c8c1a27U,
    0x87edbf30U,
    0xdefb8ebfU,
    0x8fc25cf6U,
    0xff238eb9U,
    0x5b765cdcU,
    0x62ad8e94U,
    0xb21f5ce7U,
    0x41930eadU,
    0xff99cd7U,
    0x49462eafU,
    0x6ee66cfeU,
    0xcb56d6a0U,
    0x59e0caU,
    0x40f4b497U,
    0xa7ed13eeU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x68000000U,
    0x7c000000U,
    0xc6000000U,
    0x11000000U,
    0x25800000U,
    0x60400000U,
    0xc0600000U,
    0x61100000U,
    0xdd280000U,
    0x4d740000U,
    0x323a0000U,
    0xcd5f0000U,
    0xa4cc8000U,
    0x9a264000U,
    0x36706000U,
    0xe8bcf000U,
    0x859ea800U,
    0xb769bc00U,
    0x22135a00U,
    0x13aa1700U,
    0xbfb76e80U,
    0xf69ae440U,
    0x41edf220U,
    0xc4d3ab10U,
    0x6d0c3498U,
    0xe404f354U,
    0xa2009cbaU,
    0xf3064f4fU,
    0xb6854689U,
    0x86c51840U,
    0x2ea6c82bU,
    0x33b14c03U,
    0x289ff203U,
    0x74e8ab17U,
    0x6352b495U,
    0xce49b350U,
    0xaae67ca4U,
    0x51d3ff67U,
    0xba8f0e9fU,
    0x1f421471U,
    0xa8e15a24U,
    0xd2d11719U,
    0x5409ee80U,
    0xdd87a464U,
    0x54431222U,
    0x4a621b38U,
    0x8e147cbaU,
    0xfda8ff5cU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0xf8000000U,
    0x8c000000U,
    0xd6000000U,
    0xb000000U,
    0xcb800000U,
    0xfec00000U,
    0xa4a00000U,
    0xe0900000U,
    0xe1180000U,
    0x78340000U,
    0xbf8e0000U,
    0x862f0000U,
    0x6388000U,
    0xe266c000U,
    0x6833e000U,
    0xe788f000U,
    0x3a2d7800U,
    0x78394c00U,
    0x9d647e00U,
    0xf9b21100U,
    0xc448b680U,
    0x5e0ea7c0U,
    0xade90620U,
    0x261b5d30U,
    0xc5b4c898U,
    0x7a48b6d4U,
    0x410fb09eU,
    0x6c6afad3U,
    0xfddd4e8dU,
    0x2d912be6U,
    0x799e9834U,
    0xf171bc38U,
    0x9be9063aU,
    0xbd1b5d0dU,
    0x9634c881U,
    0x5888b6c0U,
    0xcbafb0a1U,
    0xbfafad4U,
    0x1454e9aU,
    0xa0652bc5U,
    0xa9309822U,
    0x690ebc39U,
    0xd869860bU,
    0xc7d99d2cU,
    0xa09128aaU,
    0x411b46c0U,
    0x483448aaU,
    0x178a76fdU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x88000000U,
    0x84000000U,
    0xc6000000U,
    0xf5000000U,
    0xc8800000U,
    0xef400000U,
    0x13a00000U,
    0x79d00000U,
    0x31180000U,
    0x96740000U,
    0xf2ce0000U,
    0x286f0000U,
    0x433c8000U,
    0xc2654000U,
    0xe837a000U,
    0xffeff000U,
    0xa3fd4800U,
    0xfd021400U,
    0x8c87c200U,
    0x4942c100U,
    0x36a79880U,
    0x39504bc0U,
    0x5a5a8a20U,
    0x43d0d530U,
    0x7e185a98U,
    0xd1f68af4U,
    0x3a0b1282U,
    0x230b9ed1U,
    0xb9885089U,
    0x8dc81ff9U,
    0xf7ee6828U,
    0xe7fca41eU,
    0x5b032a0fU,
    0xa9802536U,
    0x9c192adU,
    0x5de5dec2U,
    0xecf5709bU,
    0xd689afe2U,
    0xba4e0012U,
    0x72f0034U,
    0x309c8034U,
    0x6bb5401bU,
    0x512fa01bU,
    0xed9bf03cU,
    0x97334836U,
    0x206d1411U,
    0x73b4239U,
    0x6467811bU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0xd8000000U,
    0x3c000000U,
    0x16000000U,
    0x6d000000U,
    0xd6800000U,
    0x4cc00000U,
    0xeee00000U,
    0xa8d00000U,
    0x1ae80000U,
    0xd0340000U,
    0x1f3e0000U,
    0x3c5d0000U,
    0x33cf8000U,
    0x1585c000U,
    0x9b436000U,
    0x2aa2f000U,
    0x33f1c800U,
    0x78592400U,
    0x69cc5e00U,
    0x96801b00U,
    0xacc5fc80U,
    0x7ee7f240U,
    0xc0d59620U,
    0xfeed3f30U,
    0xfa37a288U,
    0x643ae96cU,
    0x87dfea96U,
    0xa98f0d7fU,
    0xb7a154adU,
    0xdd752647U,
    0x9899802bU,
    0xf92cc000U,
    0xb752e000U,
    0x4aaa3012U,
    0x99152800U,
    0x8a8a1433U,
    0xf020f60cU,
    0x7136cf2dU,
    0xe7bfea84U,
    0xb19f0d48U,
    0x75a954bcU,
    0x7891266bU,
    0x93cf8029U,
    0x6585c03cU,
    0x63436009U,
    0xa6a2f006U,
    0xfdf1c83eU,
    0x2959241aU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0x68000000U,
    0x8c000000U,
    0x6e000000U,
    0xff000000U,
    0x9b800000U,
    0xef400000U,
    0xe1600000U,
    0xa7100000U,
    0xa2580000U,
    0xd8740000U,
    0x24a0000U,
    0xa5a90000U,
    0x7788000U,
    0xbf804000U,
    0xed45e000U,
    0x63b000U,
    0x7b965800U,
    0x32988c00U,
    0x34539200U,
    0xd53d5f00U,
    0xc4606680U,
    0x9953fc0U,
    0x6b9dca20U,
    0xcd1d310U,
    0xa7f9f4a8U,
    0xb94160f4U,
    0xba652cbaU,
    0x7e94acf3U,
    0xc19de93U,
    0x359703dbU,
    0x5d988034U,
    0x67d0403cU,
    0x667de011U,
    0x2307b001U,
    0xdd84580fU,
    0x3c458c11U,
    0xc4e11205U,
    0xdf541f04U,
    0x54bd06b7U,
    0xfe26cfcbU,
    0xbe76720bU,
    0x414eef26U,
    0x482e3e9fU,
    0x2339b3c8U,
    0x4f64580dU,
    0xb8158c00U,
    0x49d91226U,
    0x8f301f2aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x98000000U,
    0xc000000U,
    0xb2000000U,
    0x25000000U,
    0x69800000U,
    0xc3c00000U,
    0xa9600000U,
    0xdef00000U,
    0xdef80000U,
    0xd1940000U,
    0xdb0a0000U,
    0xd1ed0000U,
    0x35db8000U,
    0x91c3c000U,
    0x5c66e000U,
    0xbf75d000U,
    0x39380800U,
    0x5ef67c00U,
    0x9ef8c600U,
    0xf197bf00U,
    0x6b0d0d80U,
    0x49ef2ec0U,
    0x39d8ce20U,
    0x23c5c310U,
    0x7967cb88U,
    0xd6f191ecU,
    0xfafc4386U,
    0xf7902dd3U,
    0x40086584U,
    0x2f6f42f5U,
    0xba9ee014U,
    0x92e1d00fU,
    0xe8320828U,
    0x161b7c11U,
    0xe8a34627U,
    0x8a947f0eU,
    0x458bedaaU,
    0xceaafefaU,
    0x1ef8c62aU,
    0xb197bf07U,
    0x4b0d0db4U,
    0xf9ef2ef4U,
    0xa1d8ce04U,
    0x2fc5c320U,
    0xcb67cbafU,
    0xf3f191e6U,
    0x937c4392U,
    0x34502dedU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0xa8000000U,
    0xc4000000U,
    0x9e000000U,
    0x11000000U,
    0xfe800000U,
    0x52c00000U,
    0x16e00000U,
    0xef700000U,
    0x1ab80000U,
    0x78940000U,
    0x434a0000U,
    0x4e90000U,
    0x4b3c8000U,
    0xd5d64000U,
    0xf1eba000U,
    0x3bba3000U,
    0x9e176800U,
    0x8d8f6400U,
    0xb00b4e00U,
    0x474afb00U,
    0x7aeaf180U,
    0xaa3e50c0U,
    0xd3562620U,
    0xcf2c9f10U,
    0x775d3fa8U,
    0xfe62ebd4U,
    0x78b7778aU,
    0x64d8ffe1U,
    0x402471afU,
    0x879510c0U,
    0x14cb061dU,
    0x64a9ef21U,
    0x51d77a0U,
    0xb41ffdaU,
    0x2fa0f194U,
    0x6bd750efU,
    0xf0eaa605U,
    0xcd3adf2eU,
    0x58d69facU,
    0xad68dbe1U,
    0x8a781f82U,
    0x3d739bcfU,
    0x41bd3fb3U,
    0x112ebddU,
    0x6a0f778aU,
    0x884cfff1U,
    0x356e7191U,
    0x567c10e6U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0xe8000000U,
    0x4c000000U,
    0xaa000000U,
    0x6d000000U,
    0x34800000U,
    0x82c00000U,
    0x69a00000U,
    0xd3900000U,
    0xe9a80000U,
    0xe7340000U,
    0x76be0000U,
    0xc85b0000U,
    0x4e288000U,
    0x42724000U,
    0x7a59e000U,
    0xf72b9000U,
    0xc8f6c800U,
    0xcb98d400U,
    0xc909ce00U,
    0x26231100U,
    0x3ad46680U,
    0x4f4b0240U,
    0xb5410620U,
    0xc4e0c530U,
    0xc37528b8U,
    0x94da5354U,
    0x40ec809aU,
    0x61d05763U,
    0x94cae6b2U,
    0xc206427fU,
    0xe106662fU,
    0x7e861517U,
    0xbfc480b2U,
    0xb5245768U,
    0x1d54e687U,
    0x2a0d4261U,
    0x59a6e638U,
    0xab905519U,
    0xadab60bcU,
    0x5130c77aU,
    0x59bcae93U,
    0xddd8d67aU,
    0x52684839U,
    0xc4159436U,
    0xf4eeae37U,
    0x4fd5c105U,
    0xafcdce81U,
    0x89810649U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0xc8000000U,
    0x44000000U,
    0xfa000000U,
    0x83000000U,
    0x1a800000U,
    0xbd400000U,
    0x1fa00000U,
    0xbad00000U,
    0x5bd80000U,
    0x4e740000U,
    0x8f8a0000U,
    0xbaed0000U,
    0x695d8000U,
    0xa7314000U,
    0xf22aa000U,
    0x7f3f1000U,
    0x5e05f800U,
    0x69006400U,
    0x1868200U,
    0x5bc62100U,
    0xd4e09080U,
    0x9872edc0U,
    0x82897a20U,
    0x316b4510U,
    0x799b9288U,
    0x2d558cdcU,
    0x2d1b4a92U,
    0x6112b8c1U,
    0xcf3d1096U,
    0xf603adecU,
    0x7d03da1cU,
    0x43845532U,
    0x54c66a83U,
    0x7061e8c3U,
    0x5c37c8bcU,
    0x4a999ddU,
    0x2c780034U,
    0x80a40003U,
    0xc6520037U,
    0x43990036U,
    0xce578002U,
    0x679c403dU,
    0x64572000U,
    0x5c9e5001U,
    0xf2d75804U,
    0x5fdb740fU,
    0x94717a15U,
    0x7c8f4537U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x98000000U,
    0x5c000000U,
    0xd2000000U,
    0x27000000U,
    0xaf800000U,
    0xa9400000U,
    0x1a600000U,
    0x19100000U,
    0xfd380000U,
    0x38740000U,
    0x39ae0000U,
    0xbb0f0000U,
    0xbc3e8000U,
    0xf6f5c000U,
    0x6e6b6000U,
    0x9ea9d000U,
    0xd4899800U,
    0x757ccc00U,
    0x7c958200U,
    0xef7f4700U,
    0x3f946680U,
    0x3efd3cc0U,
    0x6bd21a20U,
    0x681c8b30U,
    0xfa076498U,
    0xd303bbe4U,
    0x49831c86U,
    0x84767e7U,
    0x84e2668cU,
    0xb6d63cddU,
    0x149a9a35U,
    0x1ac24b29U,
    0xc124848cU,
    0xd474abfcU,
    0x43a964a6U,
    0xa80cbbcaU,
    0x95bd9cafU,
    0x6eb2a7dfU,
    0x728906a3U,
    0x747fecdcU,
    0x12130206U,
    0x48be870bU,
    0x1231068aU,
    0x924becd0U,
    0x665d023aU,
    0x8fe1870dU,
    0x35786b0U,
    0x3eda2cc7U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x28000000U,
    0x2c000000U,
    0x22000000U,
    0x3000000U,
    0xca800000U,
    0x75400000U,
    0xc4200000U,
    0xb3100000U,
    0x61e80000U,
    0xa8340000U,
    0x627e0000U,
    0xb990000U,
    0xf2ea8000U,
    0x8ab64000U,
    0x9b3ae000U,
    0xfdb9d000U,
    0x6afab800U,
    0xdd86400U,
    0x644c4200U,
    0x58e7bd00U,
    0x18f3de80U,
    0xeb9c6040U,
    0x82e8fa20U,
    0x12b6d930U,
    0x8f3d1ca8U,
    0xdbb99d44U,
    0x67ffc4aaU,
    0xe65a697bU,
    0xd88dde80U,
    0x23056074U,
    0x1a827a30U,
    0xfd409922U,
    0xf827fc9bU,
    0xb9104d63U,
    0x4eed7c88U,
    0x40b60d4cU,
    0x143f9c9bU,
    0x53bdd47U,
    0x34bb24a5U,
    0x2f7ab946U,
    0x801de69dU,
    0xfe2b4444U,
    0xc954d81eU,
    0x9d4ef42bU,
    0xe5669a32U,
    0x31304937U,
    0x6fffc49fU,
    0x1a5a6974U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0x78000000U,
    0x14000000U,
    0xea000000U,
    0xb3000000U,
    0x45800000U,
    0x24400000U,
    0x3ba00000U,
    0x47100000U,
    0x4f480000U,
    0x93b40000U,
    0x5bda0000U,
    0xadbf0000U,
    0x2b488000U,
    0xf1b6c000U,
    0x34df2000U,
    0xbe3d1000U,
    0x3a0e7800U,
    0xc2931c00U,
    0x4b0cca00U,
    0x18137900U,
    0xb4cb4e80U,
    0x8ef39940U,
    0x46f8b220U,
    0xf36f6510U,
    0x6fe70498U,
    0xf4b22074U,
    0xd45edcbeU,
    0x8afaec55U,
    0xfd6b4e82U,
    0xfee39948U,
    0xbe30b237U,
    0x339b6528U,
    0xd81d04b2U,
    0x9d5d204cU,
    0x247e5c86U,
    0x38a82c54U,
    0xa3066e8bU,
    0x1d85897bU,
    0x80444a20U,
    0x79a5b921U,
    0x98146ebaU,
    0xf4ce896cU,
    0xeef6ca14U,
    0x96fc7933U,
    0x8b6bcebeU,
    0x7be1597eU,
    0x1eb59216U,
    0x67597529U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x28000000U,
    0x54000000U,
    0x12000000U,
    0x5d000000U,
    0x69800000U,
    0xf0c00000U,
    0x96e00000U,
    0xd0f00000U,
    0x99780000U,
    0x69140000U,
    0xad0a0000U,
    0xa12b0000U,
    0x663a8000U,
    0x70304000U,
    0x879b2000U,
    0x9de65000U,
    0x9e778800U,
    0xe93f3c00U,
    0xe4b7de00U,
    0x6edec300U,
    0x43c10580U,
    0xa462a6c0U,
    0xe6b25620U,
    0x5bdeff10U,
    0x9e465bb8U,
    0xd6a725e4U,
    0x552f3aaU,
    0xb6aa49c5U,
    0xe5f8a59cU,
    0x7450b6e3U,
    0x112cfe08U,
    0x7e38931dU,
    0x7c368d93U,
    0x799d9ad2U,
    0xaee58812U,
    0xecf03c34U,
    0x3f7f5e28U,
    0xb6118313U,
    0xb18aa58aU,
    0x6c6fb6dbU,
    0x121c7e2dU,
    0x6b23d326U,
    0xa7972d91U,
    0x9d4b8accU,
    0xcc892025U,
    0x35e95039U,
    0xbadf0815U,
    0x11c07c01U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x68000000U,
    0xac000000U,
    0x22000000U,
    0x35000000U,
    0x28800000U,
    0xc6400000U,
    0xc4600000U,
    0x9db00000U,
    0x73180000U,
    0xa6d40000U,
    0x1f2a0000U,
    0x390d0000U,
    0x1eda8000U,
    0x3f744000U,
    0xa33ae000U,
    0x1203d000U,
    0x8d010800U,
    0xcc877400U,
    0xd8476a00U,
    0xbb649f00U,
    0x2c375380U,
    0xbfdbddc0U,
    0x91f46220U,
    0x6e7aeb10U,
    0x11e0b988U,
    0xf7602e4U,
    0x1b3b51baU,
    0xf602a6fbU,
    0x930533a0U,
    0xb3854df9U,
    0x69c70a38U,
    0x77a30f2eU,
    0x1b14bbabU,
    0xce8b79e5U,
    0xb9180024U,
    0x7fd4002eU,
    0x35aa003cU,
    0x5a4d0031U,
    0x9a3a803aU,
    0xc884401bU,
    0x3642e00aU,
    0x1c67d009U,
    0xc9b30835U,
    0x951e742aU,
    0x1dd7ea2fU,
    0x20addf0cU,
    0xe2cf339bU,
    0x34784dfeU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0xc8000000U,
    0x54000000U,
    0xa000000U,
    0x3b000000U,
    0xf4800000U,
    0xf6c00000U,
    0xf2a00000U,
    0xab00000U,
    0xbbc80000U,
    0x21140000U,
    0x5afe0000U,
    0xea9f0000U,
    0x88c8000U,
    0x2af74000U,
    0xc0a92000U,
    0x8f879000U,
    0xa245b800U,
    0xb4601400U,
    0xe0121e00U,
    0x2d7ff900U,
    0xc4df3f80U,
    0x4ae80940U,
    0x7fe1a620U,
    0xe054ed30U,
    0x261fa198U,
    0x124fb074U,
    0xfe533992U,
    0xb7183465U,
    0x6dcc9fbaU,
    0xe413d94aU,
    0x2f7fbe37U,
    0xcbdb292cU,
    0x646da794U,
    0x7a208d6dU,
    0xb2728003U,
    0xd068401eU,
    0x6025a00dU,
    0x2170d03fU,
    0xa0ec981fU,
    0x54e78428U,
    0xbcd7a636U,
    0x54dfed1dU,
    0x22ed21afU,
    0x9be7f068U,
    0xf2569980U,
    0x8118e46aU,
    0xb8c807bdU,
    0x39905d5aU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x8000000U,
    0x9c000000U,
    0xb2000000U,
    0xab000000U,
    0xc9800000U,
    0x74c00000U,
    0xdce00000U,
    0xd5f00000U,
    0x57380000U,
    0xc140000U,
    0x924e0000U,
    0x2d6f0000U,
    0x8ff98000U,
    0xcaf14000U,
    0x60ba6000U,
    0x79d15000U,
    0xc82c7800U,
    0x63d87c00U,
    0xf5e60e00U,
    0x1f752300U,
    0x667a7d80U,
    0x6e33e4c0U,
    0xa45c7620U,
    0x48265f30U,
    0xb913f398U,
    0xeacc87dcU,
    0xb72beba2U,
    0x245aabd7U,
    0x88201d94U,
    0xd912b4c6U,
    0x9ac80e08U,
    0xbf2a2316U,
    0xb85bfd81U,
    0x3a26a4e4U,
    0x72101629U,
    0x534c0f23U,
    0xcbe80b95U,
    0x64babbd5U,
    0xefd60591U,
    0x252b98ceU,
    0x5f5a780aU,
    0x59a37c25U,
    0x49d18e08U,
    0x602b6304U,
    0xefd99dbbU,
    0x3fe3f4d8U,
    0x20726e3bU,
    0x81fb732bU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x98000000U,
    0xc4000000U,
    0xb6000000U,
    0x7d000000U,
    0x51800000U,
    0xfd400000U,
    0xb200000U,
    0xb2100000U,
    0xd4080000U,
    0x16340000U,
    0x4c9a0000U,
    0x7bff0000U,
    0x314a8000U,
    0x9911c000U,
    0x288ba000U,
    0x42f2f000U,
    0xeeff8800U,
    0xeccadc00U,
    0xee551200U,
    0xbca94d00U,
    0xf266be80U,
    0x2f346f40U,
    0xeb189a20U,
    0x9bb89110U,
    0xfbeb2c98U,
    0x4e47e264U,
    0x33a50486U,
    0x50d0ce61U,
    0xb6d1e95U,
    0xd0869f6bU,
    0x6ec7120aU,
    0x55624d3aU,
    0x59b63e91U,
    0x20daaf66U,
    0x3b59ba0aU,
    0x791ba104U,
    0x80bf04b0U,
    0x2f6fce76U,
    0xb6879ea9U,
    0xebc75f51U,
    0x50e4b23bU,
    0x8af4bd0cU,
    0x92fbb6bbU,
    0x6ecb736cU,
    0x2d542807U,
    0xcc282c15U,
    0x2ca29a15U,
    0x12579107U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x48000000U,
    0x2c000000U,
    0x1e000000U,
    0xf1000000U,
    0x15800000U,
    0x4a400000U,
    0xd6e00000U,
    0x60500000U,
    0x38e80000U,
    0x25b40000U,
    0xa3a0000U,
    0xaf990000U,
    0x60aa8000U,
    0xcc514000U,
    0x66eae000U,
    0x74b73000U,
    0x8fba2800U,
    0xadda7c00U,
    0x9a4eca00U,
    0xb2002300U,
    0xaf049480U,
    0x4486be40U,
    0xcfc6e220U,
    0xd4a75f10U,
    0x9ab2dea8U,
    0x46badd64U,
    0xec5816b2U,
    0x3a0e915bU,
    0xefe6748fU,
    0x19d58e48U,
    0xccaeca1fU,
    0x9250232dU,
    0x37ec9488U,
    0xf132be4bU,
    0x8dfce23eU,
    0x573e5f3cU,
    0xe4185e9dU,
    0x7beb9d79U,
    0x9f32f694U,
    0x4f9a16bU,
    0xb6bc5cafU,
    0xd45ff26fU,
    0x6e080028U,
    0x5e40017U,
    0x92d2002dU,
    0x1a2d0022U,
    0x22908017U,
    0x4fc84038U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0xe8000000U,
    0x5c000000U,
    0xce000000U,
    0xef000000U,
    0x5f800000U,
    0x8400000U,
    0x82600000U,
    0xe4100000U,
    0xcd980000U,
    0xa9f40000U,
    0xf9ce0000U,
    0xb20b0000U,
    0xd62d8000U,
    0x4f5a4000U,
    0x21506000U,
    0xf97fb000U,
    0xb9265800U,
    0x37f0ac00U,
    0x2ecbea00U,
    0x498e8700U,
    0x5469d680U,
    0x583859c0U,
    0xe7c03220U,
    0x42246b30U,
    0x2a725cb8U,
    0xff896efcU,
    0x3f6fbc9aU,
    0x9dbc9ee7U,
    0x628184abU,
    0x56c782f7U,
    0x2aa236b5U,
    0x29b2a9d9U,
    0x17ad8a31U,
    0x901e3719U,
    0x58b40e95U,
    0x9f2db5f8U,
    0x63d83820U,
    0x58941c0bU,
    0x6c58323aU,
    0x68d06b05U,
    0x4a3c5c88U,
    0x6c26ed4U,
    0x12a23ca5U,
    0x8db6deeaU,
    0x9da9e4b4U,
    0x51c32f7U,
    0x7a326ebaU,
    0xe9ed05f8U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0xa8000000U,
    0xcc000000U,
    0xf6000000U,
    0x37000000U,
    0x6f800000U,
    0xa1400000U,
    0xb6e00000U,
    0xfb500000U,
    0xb8180000U,
    0x9a340000U,
    0x460e0000U,
    0xcecf0000U,
    0x766e8000U,
    0xc05c4000U,
    0x2053e000U,
    0x119b7000U,
    0x54711800U,
    0x6b6d6c00U,
    0x6df2200U,
    0x75902300U,
    0xfbfe480U,
    0x278259c0U,
    0x3d40ba20U,
    0x88e10f30U,
    0x90532698U,
    0x89990ae4U,
    0xc076468aU,
    0x696a3ac3U,
    0xa3dabe85U,
    0x171326d9U,
    0x7a0489U,
    0x68a229cfU,
    0xbe312202U,
    0xdc0f2314U,
    0xffc964baU,
    0x16ea19d4U,
    0x6a9d5a10U,
    0xdf57f2bU,
    0x9d2cbea0U,
    0x4fb826e9U,
    0x8782848bU,
    0xcd4569c4U,
    0xb0e2421fU,
    0xf4571318U,
    0xb39d1c82U,
    0x17445c3U,
    0x31ee8008U,
    0x6d1c4024U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x18000000U,
    0xa4000000U,
    0x36000000U,
    0xeb000000U,
    0xc3800000U,
    0x4bc00000U,
    0xfca00000U,
    0xc7300000U,
    0xedb80000U,
    0xac140000U,
    0xf4a0000U,
    0x52090000U,
    0xe1ed8000U,
    0x83bc000U,
    0x84d5a000U,
    0x5c6df000U,
    0x24f83800U,
    0x91f7cc00U,
    0xd99e5600U,
    0x3360b100U,
    0x3d95d380U,
    0x798b72c0U,
    0x562bee20U,
    0xc69cbd10U,
    0xeee625a8U,
    0x815233dcU,
    0xa4ac05a6U,
    0x1fd903f9U,
    0x5b061d85U,
    0x3b81fff6U,
    0x3fc053beU,
    0xa2a4b2f7U,
    0x90344e3cU,
    0xbc384d2eU,
    0x3ad39da8U,
    0xdb6e3ff6U,
    0x1d7ff3a7U,
    0xbb3042f4U,
    0x9fb9f609U,
    0xa110413cU,
    0x4fca6bb8U,
    0x664e7efeU,
    0xc48d981dU,
    0xeeaa3c2bU,
    0x86de6e02U,
    0x95837d12U,
    0x30c18595U,
    0xf722c3f1U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x28000000U,
    0xc4000000U,
    0x62000000U,
    0x1d000000U,
    0xbc800000U,
    0x3ec00000U,
    0xebe00000U,
    0x3f900000U,
    0x28a80000U,
    0xdcf40000U,
    0x93fa0000U,
    0x5ebd0000U,
    0xd21a8000U,
    0x482e4000U,
    0xbc35a000U,
    0xcb1dd000U,
    0xf6ae0800U,
    0x2ff31400U,
    0x247e6e00U,
    0x1bfee300U,
    0x4abdd680U,
    0xb81a8040U,
    0x12ae620U,
    0x4ab3b710U,
    0x2cde1888U,
    0xc3cdb364U,
    0x33a338aaU,
    0x5bb72361U,
    0xc65810b0U,
    0x1a0aa773U,
    0x5c7568dU,
    0x6864c04aU,
    0x80d74600U,
    0xd10a670dU,
    0x1e4210bfU,
    0xab27a76aU,
    0xf775d683U,
    0xa8be8071U,
    0xe518e61bU,
    0x9daab716U,
    0xe4769896U,
    0xef3af347U,
    0x385e18afU,
    0x790db350U,
    0x9a4338a3U,
    0xe927237aU,
    0x7a7010a7U,
    0x3c3ea757U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x68000000U,
    0xa4000000U,
    0x36000000U,
    0x2f000000U,
    0x6f800000U,
    0x5c00000U,
    0x40a00000U,
    0xc9b00000U,
    0xd2580000U,
    0x8a940000U,
    0x9c2a0000U,
    0x396f0000U,
    0x638f8000U,
    0xe75e4000U,
    0x2811a000U,
    0xe76a7000U,
    0xa8899800U,
    0xdedb2c00U,
    0x32d38600U,
    0xa04c1100U,
    0xc0f81780U,
    0x7a275dc0U,
    0x5ef59e20U,
    0x81b97d10U,
    0x76c23198U,
    0xc5253cccU,
    0x497611baU,
    0x187e0cf9U,
    0xfc61a9b5U,
    0xd99110d7U,
    0x49aa17b9U,
    0xe1ac5df4U,
    0x65a81e3fU,
    0x3ac3d0cU,
    0x74ae11a0U,
    0xd72a0ccdU,
    0x40eba99bU,
    0x194e10cfU,
    0x907d9792U,
    0x28661dffU,
    0xe793be30U,
    0xf2a94d13U,
    0xd02809beU,
    0xeb6f60feU,
    0x1a898fa1U,
    0x97d871f7U,
    0x2a541811U,
    0x60e6c03U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0xf8000000U,
    0x64000000U,
    0x5e000000U,
    0x9000000U,
    0xff800000U,
    0x9bc00000U,
    0xffe00000U,
    0x4ef00000U,
    0x2f380000U,
    0x2940000U,
    0x980a0000U,
    0x114b0000U,
    0x94ee8000U,
    0x573ec000U,
    0x2692a000U,
    0x2608b000U,
    0x84f2800U,
    0x936f6c00U,
    0xa8fb8600U,
    0x87701b00U,
    0x61f9ad80U,
    0xd8f28cc0U,
    0xa3a2e20U,
    0xcf11b710U,
    0xd8c88bb8U,
    0xda2e27c4U,
    0x8d5eab9eU,
    0xb4a357c9U,
    0xf855a38fU,
    0x446e4bd6U,
    0x1e79ad99U,
    0x3328cebU,
    0x15da2e0eU,
    0x91e1b71cU,
    0xff08ba5U,
    0xbcba27f9U,
    0x4b54abafU,
    0xace857faU,
    0x933b23a1U,
    0x88908bf6U,
    0xc70b0d82U,
    0x6bca3cf5U,
    0x32ad0604U,
    0x1adb29U,
    0x3f010d85U,
    0x2a813cc0U,
    0xbe438619U,
    0x23241b34U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x78000000U,
    0x5c000000U,
    0x6a000000U,
    0x1000000U,
    0x82800000U,
    0x94c00000U,
    0xaa00000U,
    0xf100000U,
    0xdc380000U,
    0xd340000U,
    0xf6ea0000U,
    0x412f0000U,
    0xcc098000U,
    0x735ec000U,
    0xd2006000U,
    0x7d061000U,
    0x7885a800U,
    0x1dc1e400U,
    0xac26de00U,
    0xadd5f900U,
    0xbd9b9280U,
    0x81a20ec0U,
    0x3c92f620U,
    0xd27edd10U,
    0x3f572c98U,
    0xe15ee7fcU,
    0xcf054cbeU,
    0xf583f7c7U,
    0x1d4364a2U,
    0xede3d3ecU,
    0x6bf45a86U,
    0x114afadeU,
    0xbeb8003eU,
    0x29f40038U,
    0xe44a000bU,
    0xe23f000dU,
    0x231801bU,
    0x236ac021U,
    0xcc6a603cU,
    0xa9e91039U,
    0x3cac281cU,
    0xf54f242aU,
    0xa8bebe25U,
    0xd2f7e90bU,
    0xefcc3aa6U,
    0xd078eafbU,
    0xaa57a82bU,
    0x4ddae424U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x88000000U,
    0x14000000U,
    0xa2000000U,
    0x49000000U,
    0x4a800000U,
    0xc3400000U,
    0xfe600000U,
    0xc5b00000U,
    0x84b80000U,
    0xab540000U,
    0xf74e0000U,
    0xfd0f0000U,
    0x89ef8000U,
    0xef1d4000U,
    0x25c42000U,
    0xc321d000U,
    0xa4d02800U,
    0x508e2400U,
    0x6729a200U,
    0x3fb85f00U,
    0x50d43b80U,
    0x828d50c0U,
    0xc62e0a20U,
    0xd13f3b30U,
    0xb997b998U,
    0x21ebdfecU,
    0xeb1d9982U,
    0xdfc50ff5U,
    0xa6223190U,
    0xd0566bceU,
    0x6ccfb388U,
    0x38cfe4e9U,
    0x3acba00dU,
    0xa3cc903aU,
    0xd14c0821U,
    0x8e0bf421U,
    0xc66f8a1aU,
    0xe8dd7b29U,
    0x6fe41986U,
    0x4d734fc2U,
    0x871f9198U,
    0x41c1fbd4U,
    0x89223b90U,
    0x49d650d7U,
    0x300f8a34U,
    0xf96d7b08U,
    0x295c19b9U,
    0x1f274ffbU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0xe8000000U,
    0xec000000U,
    0x62000000U,
    0x4f000000U,
    0xc6800000U,
    0xe1400000U,
    0x8a200000U,
    0x88f00000U,
    0xc4280000U,
    0xea540000U,
    0xd09e0000U,
    0x55db0000U,
    0xe1f98000U,
    0x4c0a4000U,
    0x9da1e000U,
    0xda36d000U,
    0xc2ced800U,
    0x31428400U,
    0x32204200U,
    0x1cf36d00U,
    0xd22f9180U,
    0xc3527640U,
    0xd71f1a20U,
    0x5f1fa930U,
    0x31833b8U,
    0x6918cb5cU,
    0xba19d39aU,
    0xf69e1b4bU,
    0xb4df0b80U,
    0x9a789f7fU,
    0xbcc94993U,
    0x3444f26fU,
    0xb7a15818U,
    0x2937c426U,
    0x1e4e221aU,
    0xeb00fd36U,
    0x18872985U,
    0xb4476267U,
    0x77a1e022U,
    0xc936d010U,
    0x6e4ed809U,
    0x302841fU,
    0xf4804215U,
    0xd6436d29U,
    0x38a7918eU,
    0xfb6765eU,
    0x8f091a3eU,
    0x8920a904U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x68000000U,
    0x6c000000U,
    0x32000000U,
    0xad000000U,
    0x35800000U,
    0x12400000U,
    0x9e200000U,
    0x24900000U,
    0xa4180000U,
    0x59340000U,
    0x11ce0000U,
    0xc18f0000U,
    0x3aaf8000U,
    0x97ba4000U,
    0xcbe7e000U,
    0xa5f25000U,
    0xfb2bc800U,
    0x13f99c00U,
    0x76c64a00U,
    0xf3e7c500U,
    0xd1f26280U,
    0xad2b47c0U,
    0x50fa0220U,
    0xb4401930U,
    0x1525c898U,
    0x5a15d2ecU,
    0xa8da28baU,
    0x7bd382ebU,
    0x7fbfe0b4U,
    0x67e51ef7U,
    0xf7f62aafU,
    0xe6289bc3U,
    0x4e7ba809U,
    0x8858c25U,
    0x5fc4622aU,
    0x5863090eU,
    0x3cb060b8U,
    0x1b8f5ecdU,
    0x3ba9caa1U,
    0xf03ecbe5U,
    0xc4a6600dU,
    0x6657101eU,
    0xa1fba838U,
    0x1bc58c39U,
    0xa664621aU,
    0x73b30926U,
    0x5b0860b3U,
    0x186b5efcU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0xe8000000U,
    0x5c000000U,
    0x92000000U,
    0xe5000000U,
    0x75800000U,
    0xddc00000U,
    0xb7a00000U,
    0xfe900000U,
    0x50f80000U,
    0xa9b40000U,
    0xae2a0000U,
    0x2f2b0000U,
    0x2ca98000U,
    0x226e4000U,
    0xd34c6000U,
    0x469d5000U,
    0x22840800U,
    0x1d401c00U,
    0xe7e07600U,
    0xd0f78900U,
    0x3fccae80U,
    0x2cdf20c0U,
    0x55e7fe20U,
    0x65f2d510U,
    0xb24938b8U,
    0xb51bb9fcU,
    0xc443389aU,
    0xb060b9c7U,
    0xe032b8bcU,
    0x51eaf9d5U,
    0x758cd8bfU,
    0xbb8a9ccU,
    0xd55350abU,
    0x7459f5fdU,
    0xf1a4c68fU,
    0x65926cdfU,
    0x5a7b801dU,
    0x48f14001U,
    0xcbcfe009U,
    0x2d81038U,
    0xd2e1e825U,
    0x1d730c16U,
    0x46081e28U,
    0x4d7ac51fU,
    0x6870d089U,
    0x6b8cb5c4U,
    0xc4b9268aU,
    0xe1d57cdbU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x88000000U,
    0x3c000000U,
    0xa6000000U,
    0xad000000U,
    0x67800000U,
    0xdbc00000U,
    0xd4a00000U,
    0x5e500000U,
    0x580000U,
    0x70740000U,
    0xda4a0000U,
    0x3b4f0000U,
    0xa2ca8000U,
    0x94000U,
    0xb9286000U,
    0xbfb8f000U,
    0x9dc14800U,
    0xa9a62c00U,
    0xd1d4a600U,
    0x779ce100U,
    0x8ad6e880U,
    0x1518fdc0U,
    0xfa956e20U,
    0xa47c8d10U,
    0x6960ae98U,
    0x7f5ace4U,
    0xc98aae82U,
    0xb3eaacdfU,
    0xca982e91U,
    0x2557ecdfU,
    0x92da4e83U,
    0x18301ccdU,
    0xdf298686U,
    0x32bb70c7U,
    0xa4740aaU,
    0x6a6461faU,
    0xb1706029U,
    0xb3ccf03fU,
    0x818b4817U,
    0xafe92c3dU,
    0x9c9e263fU,
    0x9055a138U,
    0x415e88bcU,
    0x59f00df2U,
    0x8c2608U,
    0xa66ea111U,
    0xb65e0898U,
    0x15764de1U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x28000000U,
    0x94000000U,
    0x82000000U,
    0xa1000000U,
    0x13800000U,
    0x69400000U,
    0x90200000U,
    0x7d700000U,
    0xa7580000U,
    0x6bd40000U,
    0x52ea0000U,
    0x8cef0000U,
    0x2bec8000U,
    0x536c4000U,
    0x4cab2000U,
    0xc4ad000U,
    0xbd5f6800U,
    0x66d6ec00U,
    0x1f6c3200U,
    0x2ad6500U,
    0xa3484580U,
    0x61db95c0U,
    0x8315da20U,
    0x4288c910U,
    0xb63bd798U,
    0x328460d4U,
    0x3ac3d7aaU,
    0x996060f5U,
    0xbd51d798U,
    0xf22b60ecU,
    0x588f57b6U,
    0xbb3c20fbU,
    0x7f02f7b6U,
    0xb485b0d6U,
    0x11c23fbfU,
    0x8fe1ccc9U,
    0x3d9045a6U,
    0x164f95efU,
    0xb05fda11U,
    0x2b57c902U,
    0x912f57bcU,
    0x8a0c20e6U,
    0x91faf7b2U,
    0xae61b0ecU,
    0xcdd03f9bU,
    0x49eaccc7U,
    0xe26ec5b1U,
    0x1728d5cbU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0xb8000000U,
    0x94000000U,
    0xa000000U,
    0xb000000U,
    0x4800000U,
    0x7cc00000U,
    0x2200000U,
    0x9d00000U,
    0xb3980000U,
    0xe0740000U,
    0xd00a0000U,
    0xe20b0000U,
    0x3d0b8000U,
    0xd38cc000U,
    0x14482000U,
    0xaae91000U,
    0x4bfdb800U,
    0xf0459400U,
    0x12e20e00U,
    0x75f3dd00U,
    0xb4f6480U,
    0xe46b27c0U,
    0xdc3e3620U,
    0x46e18910U,
    0xdff6cab8U,
    0x50492aecU,
    0xe8eeca8eU,
    0x8cfd2af5U,
    0xdac4ca9aU,
    0xd7262afeU,
    0xec574ab7U,
    0x70deeac6U,
    0x22156ab4U,
    0x333cfad9U,
    0x50635299U,
    0x6c35aefcU,
    0x54e97c81U,
    0xbaff63feU,
    0xa7c3a016U,
    0x4ea5d00aU,
    0xb9159808U,
    0x9fbc843cU,
    0x50a7b628U,
    0xf8124932U,
    0x703f6a95U,
    0x98e7fadcU,
    0x3ef0d2a3U,
    0xefcd6ed6U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0xc8000000U,
    0x24000000U,
    0x62000000U,
    0x7000000U,
    0x13800000U,
    0xec400000U,
    0xa8a00000U,
    0x6df00000U,
    0x2d080000U,
    0x5dd40000U,
    0xe93e0000U,
    0x793b0000U,
    0x913c8000U,
    0x853b4000U,
    0xff3aa000U,
    0x143ed000U,
    0x41bcd800U,
    0xc8ff6c00U,
    0x74d8aa00U,
    0xe6ea1100U,
    0x8f035980U,
    0x17801b40U,
    0xbe46f220U,
    0xb7a53d30U,
    0x9275d3b8U,
    0x874b9a74U,
    0x9075d392U,
    0x904b9a79U,
    0xabf5d380U,
    0x880b9a45U,
    0xa955d3aeU,
    0xc6fb9a76U,
    0xf5ddd398U,
    0x706f9a57U,
    0xa7c3d3bdU,
    0x88e49a60U,
    0xb35753a6U,
    0x3dfbda72U,
    0x885bf3b3U,
    0xd2a0a5aU,
    0xb1e5ab92U,
    0x39d52660U,
    0xab3b2199U,
    0x4e3aa776U,
    0x9abe002bU,
    0x857b0038U,
    0x119c8025U,
    0x1ccb4006U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0xa8000000U,
    0x3c000000U,
    0xe2000000U,
    0x51000000U,
    0x84800000U,
    0xd1400000U,
    0x29a00000U,
    0xe2900000U,
    0xbfa80000U,
    0xb40000U,
    0x5bfa0000U,
    0x2790000U,
    0x5dbf8000U,
    0x685e4000U,
    0xf5eb6000U,
    0x8090d000U,
    0xaea8a800U,
    0x24371400U,
    0xbabc3200U,
    0x83dd5100U,
    0x832e4280U,
    0x35f5c640U,
    0xa4591a20U,
    0x5fe90510U,
    0x7d9490a8U,
    0x502b074cU,
    0x3071108aU,
    0xc99c475fU,
    0x30df0b0U,
    0xc0a6d748U,
    0x82143883U,
    0xb8e81367U,
    0x96172290U,
    0x26e8167fU,
    0x85143214U,
    0xc3695133U,
    0x78d44287U,
    0x78cc65bU,
    0x51e69a21U,
    0xbb7451dU,
    0x6a7ff0bfU,
    0x81bbd774U,
    0x1a59b8a4U,
    0x3ceb5340U,
    0x9011c287U,
    0xa1eb866aU,
    0xbe927a1bU,
    0x8da9d519U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x68000000U,
    0x6c000000U,
    0x92000000U,
    0x6d000000U,
    0x94800000U,
    0x51c00000U,
    0x25600000U,
    0xcb500000U,
    0xd9680000U,
    0x1b40000U,
    0x847e0000U,
    0xe7fd0000U,
    0x73bf8000U,
    0xf9984000U,
    0x9f6de000U,
    0xaab15000U,
    0x7bf9c800U,
    0x69b89400U,
    0x689ad600U,
    0x41e95700U,
    0x92726880U,
    0x341ff240U,
    0xc2a9e20U,
    0x6d108330U,
    0x4e4cde88U,
    0xbbc6b56cU,
    0x3c655ebaU,
    0xe9d7f56bU,
    0xaba93e8cU,
    0x2753e547U,
    0x8b6a9697U,
    0x4cb66153U,
    0xa0fa689fU,
    0xde3bf26eU,
    0x3adc9e05U,
    0xa0c98308U,
    0x2b055ebbU,
    0x3f87f573U,
    0xae413e98U,
    0xab27e568U,
    0xd0749690U,
    0x611b6172U,
    0xcade88bU,
    0x1ad7b27cU,
    0x902f7e29U,
    0x7715d313U,
    0xdf4b1685U,
    0x65432142U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0x98000000U,
    0x9c000000U,
    0xf6000000U,
    0x49000000U,
    0x20800000U,
    0x1400000U,
    0x84a00000U,
    0x88b00000U,
    0x9df80000U,
    0xa7940000U,
    0x1f8a0000U,
    0x440f0000U,
    0x66c88000U,
    0xcca9c000U,
    0xe07f6000U,
    0x5450f000U,
    0x96de800U,
    0x9f9f1400U,
    0x1f455200U,
    0x39a1f900U,
    0xea31d380U,
    0xf7be7cc0U,
    0xb8b23a20U,
    0x95fc2d10U,
    0xc3916198U,
    0xa58db5f4U,
    0x630be186U,
    0x934f75f7U,
    0x1b6e0185U,
    0x2c9d45f6U,
    0x78c60996U,
    0x1d6061c3U,
    0x21535382U,
    0x2fe8bcf3U,
    0xffddda0cU,
    0x6f611d38U,
    0x4251e9adU,
    0xd06951f2U,
    0x4719dbacU,
    0x520358ddU,
    0xd3076034U,
    0xb784f039U,
    0xbcc7e82cU,
    0x5760141dU,
    0x2e55d23cU,
    0xe6c3907U,
    0xda1cb38cU,
    0x80858cd6U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x58000000U,
    0x7c000000U,
    0x2a000000U,
    0x73000000U,
    0xe2800000U,
    0xd6400000U,
    0x58e00000U,
    0x1ef00000U,
    0x11280000U,
    0x30540000U,
    0x673a0000U,
    0x178f0000U,
    0x72468000U,
    0x4ee3c000U,
    0x27f06000U,
    0x90ab1000U,
    0x5c96b800U,
    0x959fa400U,
    0x7b9b7a00U,
    0xe98cb00U,
    0x8d1e9180U,
    0xa6da9c40U,
    0xb8fda220U,
    0x27ac7f10U,
    0xb8135398U,
    0x22ddf344U,
    0xdef849b6U,
    0x56ae284fU,
    0x1d906032U,
    0x181b1008U,
    0x755eb836U,
    0xab3ba42eU,
    0x55897a0aU,
    0x5543cb04U,
    0xb26211b6U,
    0x8cb65c65U,
    0xfcb4217U,
    0x2fa4af27U,
    0x9b958b96U,
    0x3919475cU,
    0xe8dd8ba2U,
    0xfdfd4762U,
    0x8c2f8ba0U,
    0xa7d6477bU,
    0x32fb0b9dU,
    0x64ae874aU,
    0x7297eb8fU,
    0xc0995778U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x78000000U,
    0x74000000U,
    0x9e000000U,
    0x67000000U,
    0x17800000U,
    0xb2400000U,
    0xd8e00000U,
    0xc3100000U,
    0xc5880000U,
    0x91b40000U,
    0x8a7e0000U,
    0x992b0000U,
    0xb1418000U,
    0x9962c000U,
    0xfa572000U,
    0x90ecb000U,
    0x61e75800U,
    0x9391ec00U,
    0xf04d5a00U,
    0xf312c300U,
    0x9d8ef680U,
    0x75b5d940U,
    0x1c7d2220U,
    0xf22f9f30U,
    0x4cc4f4b8U,
    0xd226f65cU,
    0x52368ebeU,
    0xf63c856dU,
    0xcec9203fU,
    0x19d7b035U,
    0x7caed823U,
    0x3e072c2dU,
    0x37047a0fU,
    0xff857334U,
    0xce402e93U,
    0x4ae2f551U,
    0x4e115831U,
    0x2b0eec0aU,
    0x5372da13U,
    0xf75b032eU,
    0x309856b3U,
    0x6f3ba97bU,
    0xe4d5a11U,
    0x2412c30dU,
    0x120ef693U,
    0xc3f5d94eU,
    0x229d2209U,
    0x223f9f00U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0xe8000000U,
    0x24000000U,
    0xc2000000U,
    0x21000000U,
    0xeb800000U,
    0xb0400000U,
    0x29200000U,
    0x5dd00000U,
    0x2a280000U,
    0xcb40000U,
    0x6ada0000U,
    0xf1490000U,
    0x19448000U,
    0x56a04000U,
    0x3796a000U,
    0xbe0bd000U,
    0xb4e36800U,
    0x37b26c00U,
    0xdc5f9a00U,
    0x54899d00U,
    0xff217080U,
    0xe6d3ba40U,
    0xdcaa5220U,
    0x9702110U,
    0xdcbd82a8U,
    0xa9384b54U,
    0xd67cb89aU,
    0x23de0659U,
    0x7ecca038U,
    0xcb02d00cU,
    0xe87e828U,
    0x69c22c31U,
    0x613a00U,
    0x53764d16U,
    0x21b81880U,
    0xecb8d667U,
    0xf139480aU,
    0xea7dfc17U,
    0x7dd8522eU,
    0x51cd2115U,
    0xe78302a7U,
    0xb6410b59U,
    0x3a2698a1U,
    0x2f51967cU,
    0xbdeb680eU,
    0x73d66c07U,
    0xfd2d9a07U,
    0x4c349d11U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0xa8000000U,
    0x24000000U,
    0xde000000U,
    0xd1000000U,
    0x23800000U,
    0xbc00000U,
    0x3d600000U,
    0x85f00000U,
    0x38280000U,
    0x7540000U,
    0x36be0000U,
    0x2f8f0000U,
    0xe4428000U,
    0x6ca04000U,
    0xc792a000U,
    0xf75b3000U,
    0x9b3ee800U,
    0xfd4ccc00U,
    0xaea12600U,
    0x8493ff00U,
    0x9fdbad80U,
    0xac789440U,
    0x916d6e20U,
    0x1a740330U,
    0xd1ec6398U,
    0xc933a744U,
    0x3c9e58aU,
    0xbce06879U,
    0xdd30200fU,
    0xc5cb7000U,
    0x91e4483aU,
    0xbcb3fc0fU,
    0x4d09ce12U,
    0xa404331cU,
    0x1e060bb1U,
    0xb1042b77U,
    0x3386e3aaU,
    0xa3c7e758U,
    0x19654580U,
    0x5bf4584fU,
    0xe92c4820U,
    0x24d7fc0aU,
    0x3d7fce17U,
    0x12ef3316U,
    0x61b28bb6U,
    0x548f6b78U,
    0xc0c0c3a0U,
    0xc1e7974eU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x58000000U,
    0x9c000000U,
    0x2a000000U,
    0x87000000U,
    0xde800000U,
    0x40c00000U,
    0x4be00000U,
    0xee300000U,
    0xaa480000U,
    0x7f140000U,
    0x109e0000U,
    0x19ef0000U,
    0x9f038000U,
    0xe287c000U,
    0x3ac66000U,
    0xa4e21000U,
    0xf4b21800U,
    0x5c8b4400U,
    0x99f36e00U,
    0xa72e9300U,
    0x2de48380U,
    0xeb328b40U,
    0x57cf1620U,
    0x6753c730U,
    0xeebbf598U,
    0x79b85c4cU,
    0x6f3b7bb6U,
    0xbbf81f57U,
    0x2e1e0032U,
    0xa92f001dU,
    0xece38039U,
    0xa0b7c03bU,
    0xe28e600eU,
    0xc0f6103dU,
    0x10ac1817U,
    0x82a4442eU,
    0x9390ee21U,
    0xeb59532dU,
    0xf68ae39fU,
    0xdef49b5cU,
    0x19ab0e00U,
    0x5d238300U,
    0xf8d51b86U,
    0x25fe0f65U,
    0xe71a1839U,
    0x16af442fU,
    0xb7a56e2aU,
    0x36159329U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x58000000U,
    0x64000000U,
    0xe2000000U,
    0xfb000000U,
    0xc5800000U,
    0x4f400000U,
    0x27a00000U,
    0x5b00000U,
    0x3dd80000U,
    0x3f540000U,
    0x8cca0000U,
    0x8ebb0000U,
    0x8f028000U,
    0x3f87c000U,
    0x3040a000U,
    0x90215000U,
    0xe9f63800U,
    0xbbfa1c00U,
    0x97a6b200U,
    0x6db2c900U,
    0x71db7b80U,
    0x715229c0U,
    0xa9c82a20U,
    0x363d8510U,
    0x1cc1f1b8U,
    0x69e1fce4U,
    0x989763b6U,
    0xc0aaa5c9U,
    0xc96a0020U,
    0x300b000aU,
    0x975a801fU,
    0xdf93c02eU,
    0xc32aa027U,
    0x7f2a5026U,
    0xb92cb806U,
    0x4029dc22U,
    0xeeac121bU,
    0x3c689931U,
    0x308fc3a5U,
    0xf09ff5c1U,
    0x33f63800U,
    0xf4fa1c18U,
    0x826b202U,
    0x2df2c926U,
    0x29fb7b9cU,
    0xa4a229e9U,
    0x94302a32U,
    0xb8998538U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x18000000U,
    0x54000000U,
    0xce000000U,
    0x85000000U,
    0xc2800000U,
    0xebc00000U,
    0x9a600000U,
    0x6d500000U,
    0xdcb80000U,
    0x1af40000U,
    0x28e0000U,
    0x439d0000U,
    0xec068000U,
    0xca07c000U,
    0x73072000U,
    0x83823000U,
    0xff464800U,
    0xa0a2c400U,
    0xfbb50600U,
    0xdf2eef00U,
    0x9eae2080U,
    0x9eef68c0U,
    0x7cc6e20U,
    0xd83a1b30U,
    0xf8336e88U,
    0xe06e43e4U,
    0x1e09c8a6U,
    0xf5585ce5U,
    0xc0e0001bU,
    0x12900035U,
    0xa8d8003eU,
    0x62a4000bU,
    0x4b60013U,
    0xe6a9002fU,
    0xbae88034U,
    0x61cac01dU,
    0x8139a016U,
    0xb8b1f031U,
    0x14af682aU,
    0xdedf42fU,
    0x344dce2bU,
    0xaf7feb36U,
    0x14920684U,
    0x81deb7caU,
    0x8a2286b9U,
    0x2c7077d5U,
    0x774d26acU,
    0x64f887fbU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x8000000U,
    0x2c000000U,
    0xa000000U,
    0xf000000U,
    0xf8800000U,
    0x77400000U,
    0x3be00000U,
    0xc0700000U,
    0xd9c80000U,
    0x1ed40000U,
    0x395a0000U,
    0xb1ef0000U,
    0xd0058000U,
    0x58014000U,
    0x3401e000U,
    0x5e039000U,
    0x21015800U,
    0xd186f400U,
    0x8ac39200U,
    0xbb266300U,
    0x74527d80U,
    0x551cab40U,
    0x3c8b2a20U,
    0x3e370710U,
    0x4faab798U,
    0x46633c5cU,
    0xb745a2U,
    0xde88f5bU,
    0xe200003aU,
    0x1300000fU,
    0x9a800024U,
    0x2440000aU,
    0xc160000eU,
    0x94300038U,
    0x10a8000aU,
    0xa6e40019U,
    0x23f2003eU,
    0x180b0001U,
    0xb77800cU,
    0x374a4021U,
    0x4966035U,
    0xa939d03cU,
    0xfc5f3832U,
    0x666b240eU,
    0x4fc6aa1bU,
    0x6ca2472fU,
    0xeb915798U,
    0x61bfac76U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x78000000U,
    0x9c000000U,
    0xd2000000U,
    0x83000000U,
    0xed800000U,
    0x74400000U,
    0x16a00000U,
    0x36100000U,
    0x77280000U,
    0x9af40000U,
    0x469a0000U,
    0xd54f0000U,
    0x2878000U,
    0x13c2c000U,
    0x2de66000U,
    0x5734d000U,
    0x527b3800U,
    0x58f91c00U,
    0xcf3f2a00U,
    0x9cdec100U,
    0xe2e9fe80U,
    0x4217ee40U,
    0x512a7220U,
    0x7ff70d10U,
    0x2e1fec98U,
    0xf98b334cU,
    0x40e126beU,
    0xfbb3e277U,
    0x60bd800cU,
    0x39dc03cU,
    0xadc9e03dU,
    0x6421036U,
    0x85a7582fU,
    0xf392cc0aU,
    0xd76b9212U,
    0xba511d1bU,
    0xbd8ab4afU,
    0x1ee2ff65U,
    0x82b734b8U,
    0xda3f3f7fU,
    0xac5ed4bfU,
    0x22d2f5aU,
    0x9a718ca3U,
    0xde5be35cU,
    0x91281eaaU,
    0x5ff1fe6dU,
    0x7e1f2a0eU,
    0xb18ec115U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x98000000U,
    0xfc000000U,
    0xf6000000U,
    0x83000000U,
    0xcf800000U,
    0x83400000U,
    0x39200000U,
    0x9a700000U,
    0x61f80000U,
    0x7a140000U,
    0x8faa0000U,
    0x411b0000U,
    0x26828000U,
    0xe9c1c000U,
    0x8ee46000U,
    0x8397f000U,
    0x2fef3800U,
    0xc7ba2c00U,
    0x37b1b200U,
    0xd51ead00U,
    0x64813580U,
    0x18c49cc0U,
    0x5862ea20U,
    0x22577110U,
    0x250dbfb8U,
    0xde2f1de4U,
    0xf55aed86U,
    0xa22780efU,
    0xe9f08025U,
    0xf4bec014U,
    0x5034e02dU,
    0x4259303bU,
    0x5fa3d815U,
    0x93b71c39U,
    0x7f186a16U,
    0x6182b11eU,
    0x5c43df9eU,
    0x70a3edd6U,
    0x923755bfU,
    0xf35c6cd2U,
    0x69255200U,
    0xa2779d1aU,
    0xedfaedbfU,
    0x841780c0U,
    0x68a8801cU,
    0x849ac020U,
    0xd0c6e007U,
    0x9c663033U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0xc8000000U,
    0x8c000000U,
    0xf6000000U,
    0x2d000000U,
    0xaa800000U,
    0xc9400000U,
    0x3ca00000U,
    0xfd100000U,
    0xdcc80000U,
    0x75f40000U,
    0xaffe0000U,
    0xc96b0000U,
    0x78658000U,
    0x71774000U,
    0x3fbce000U,
    0xd4a7000U,
    0xeb314800U,
    0x289f8400U,
    0x759c1200U,
    0xd71e1900U,
    0x725bd680U,
    0x48f81940U,
    0x50efba20U,
    0xaaa0ed30U,
    0xe0130cb8U,
    0x5e4ec47cU,
    0xc0b49e92U,
    0xad5c9d53U,
    0x957e2825U,
    0xf82db407U,
    0xe0c23a20U,
    0x663ad2dU,
    0xf071ec80U,
    0x733fb457U,
    0xd1085680U,
    0x39105954U,
    0x66c8da16U,
    0x4ef6dd33U,
    0xd87b24acU,
    0x62ac7061U,
    0x18524bcU,
    0x46c77074U,
    0x3360a480U,
    0xef03051U,
    0xf87c4483U,
    0x72aa4048U,
    0x39850c86U,
    0x2c1c45dU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0xe8000000U,
    0x24000000U,
    0x5e000000U,
    0xe3000000U,
    0x19800000U,
    0xd8c00000U,
    0xea200000U,
    0x63900000U,
    0x46f80000U,
    0xda740000U,
    0xb2ca0000U,
    0x59dd0000U,
    0x77648000U,
    0xa3744000U,
    0x264aa000U,
    0xe39b3000U,
    0xc0077800U,
    0x60001c00U,
    0x7000ae00U,
    0xb8054500U,
    0xcc037680U,
    0x7a0070c0U,
    0xbd077620U,
    0xfa836910U,
    0xc1402088U,
    0x32e169d4U,
    0x89b60e9aU,
    0x25696cd9U,
    0x9c89583fU,
    0x68bf6c3cU,
    0xeb157634U,
    0x2eba692bU,
    0xd416a097U,
    0x853c29e9U,
    0xc5d22ea0U,
    0x239b1ce8U,
    0xa0000038U,
    0x1000003cU,
    0xc8000004U,
    0x7400001bU,
    0xb6000019U,
    0xc7000029U,
    0x47800010U,
    0x3bc00028U,
    0xf3a00034U,
    0xbb500010U,
    0xacd80021U,
    0xb9e40010U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0xf8000000U,
    0x24000000U,
    0x8e000000U,
    0x75000000U,
    0x8e800000U,
    0xb1c00000U,
    0x68a00000U,
    0x59b00000U,
    0xc4180000U,
    0x2dd40000U,
    0xf8a0000U,
    0x67bb0000U,
    0xd7e18000U,
    0xc0d2c000U,
    0x1509a000U,
    0x40783000U,
    0x1e434800U,
    0x61e42400U,
    0x31d2d600U,
    0x58cd900U,
    0x8cb9d780U,
    0x2463bbc0U,
    0x23923e20U,
    0x666bcd10U,
    0x8a69c9b8U,
    0x786986fcU,
    0xb7689f9eU,
    0xcae89fd9U,
    0x5cab683bU,
    0xa14ed431U,
    0xda983e25U,
    0xd410cd19U,
    0x5b284987U,
    0x640b46c2U,
    0x10f93f91U,
    0x3284afeaU,
    0xabc22022U,
    0x8ba1f00fU,
    0x76336818U,
    0x8d5ad418U,
    0xa5b23e2aU,
    0x3e1bcd16U,
    0x3ed1c9b1U,
    0xd80d86c0U,
    0xafa9fa5U,
    0xd1879fcbU,
    0x8440e812U,
    0xc2e71430U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x28000000U,
    0x4c000000U,
    0x9e000000U,
    0x19000000U,
    0x96800000U,
    0x67c00000U,
    0xe9e00000U,
    0x28500000U,
    0x65980000U,
    0x27740000U,
    0x86ae0000U,
    0xd77d0000U,
    0xf6a28000U,
    0x67764000U,
    0x66abe000U,
    0xe7793000U,
    0xcea1e800U,
    0x3752400U,
    0xb4ae8600U,
    0x607ef300U,
    0x4127e880U,
    0xf236cdc0U,
    0x3a8a8e20U,
    0xa1cfe730U,
    0xcea0688U,
    0xb0db5ac4U,
    0x9b5000aaU,
    0xf01ae9e3U,
    0x2d30880fU,
    0x210e5432U,
    0x9a8a8e27U,
    0x71cfe70eU,
    0x4ea0697U,
    0xecdb5adfU,
    0x2d5000bbU,
    0xa51ae9e6U,
    0x25b08816U,
    0x5fce5412U,
    0xe5ea8e1cU,
    0x3e5fe70dU,
    0x8892068cU,
    0xe3ff5ad0U,
    0xce66008dU,
    0x5513e9c3U,
    0x55bc083eU,
    0xefc5141fU,
    0x75e3ee1bU,
    0xbe509711U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x88000000U,
    0xcc000000U,
    0xc6000000U,
    0xb9000000U,
    0xdf800000U,
    0xac00000U,
    0x41600000U,
    0xdb00000U,
    0xd680000U,
    0x43140000U,
    0x303e0000U,
    0x2c0d0000U,
    0x9ea38000U,
    0xa5534000U,
    0x1b1ee000U,
    0x2c9ff000U,
    0x3a5de800U,
    0x253dac00U,
    0xe5892e00U,
    0xb567ff00U,
    0x4fb26780U,
    0x9e6ea640U,
    0xd3942620U,
    0xd478a330U,
    0x742d2188U,
    0x1eb3b54cU,
    0x5def8f82U,
    0x87530a43U,
    0x581d0819U,
    0x241f5c12U,
    0xaa1f461dU,
    0xff1d133dU,
    0xd69ba983U,
    0xed5ba95eU,
    0xbfb829a5U,
    0x7ec8e94cU,
    0x8bc6c983U,
    0x1ae71976U,
    0x2d7321beU,
    0x30eb575U,
    0xa0240fb2U,
    0x24144a71U,
    0xe2bde829U,
    0x5b4dac08U,
    0x56012e24U,
    0xc103ff1fU,
    0xbb8467acU,
    0x30c7a669U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xe8000000U,
    0x34000000U,
    0x66000000U,
    0x5d000000U,
    0x3800000U,
    0xf8c00000U,
    0x5ea00000U,
    0xbc900000U,
    0xd6880000U,
    0xdbf40000U,
    0x853e0000U,
    0x822d0000U,
    0xb0648000U,
    0x47304000U,
    0x959e2000U,
    0x77bef000U,
    0xd36e0800U,
    0xd1018c00U,
    0x79879e00U,
    0xd7c0c100U,
    0xb6225e80U,
    0xf2d65740U,
    0x4769b620U,
    0xa702bd30U,
    0xec874888U,
    0x30435a74U,
    0xc0e4569aU,
    0xc573db7dU,
    0x9e782831U,
    0xd44b7c13U,
    0x6a579632U,
    0xf12c4d07U,
    0xcae140b4U,
    0x1276d675U,
    0x8afdc88cU,
    0x180e1a6fU,
    0x28b6f69eU,
    0xe7596b75U,
    0x3e1e001cU,
    0x5b7d0001U,
    0x1bcc801aU,
    0x8944025U,
    0x7088201aU,
    0xa6f7f021U,
    0x56bc8819U,
    0x92e8cc3fU,
    0xdac33e1eU,
    0x9da37132U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x38000000U,
    0x64000000U,
    0x96000000U,
    0x11000000U,
    0x4d800000U,
    0xf5400000U,
    0x99e00000U,
    0x4cd00000U,
    0x3e580000U,
    0x1d740000U,
    0x2cea0000U,
    0x19bf0000U,
    0xaca18000U,
    0xf530c000U,
    0xe28fa000U,
    0xeb2ef000U,
    0x6d9c6800U,
    0xc750fc00U,
    0x321d1200U,
    0x5176b00U,
    0xaf78c080U,
    0x6503c7c0U,
    0x5384da20U,
    0xd8466710U,
    0xd6603a98U,
    0x69090fcU,
    0x9f3ca8aeU,
    0x7f673bc9U,
    0x6f13c81dU,
    0x9c7e0c28U,
    0x7817a05U,
    0x56479718U,
    0x3365d28dU,
    0x1514acceU,
    0x277c1a99U,
    0x5905a0eeU,
    0x5184e086U,
    0x6746f7c4U,
    0xeee49234U,
    0x2853ab1cU,
    0xe29d608fU,
    0xe7d237daU,
    0xe8d93223U,
    0x26b65b3aU,
    0x7aca8897U,
    0x5d4d0bd0U,
    0x9b0a001cU,
    0x606f0032U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xd8000000U,
    0xb4000000U,
    0x8e000000U,
    0x49000000U,
    0x70800000U,
    0xbec00000U,
    0x2f200000U,
    0x47300000U,
    0x59780000U,
    0x19d40000U,
    0x34ee0000U,
    0xbbd90000U,
    0x7ea38000U,
    0x2575c000U,
    0x52992000U,
    0x86c73000U,
    0xcb272800U,
    0x81375400U,
    0x4c7a4e00U,
    0x8b527500U,
    0xf92feb80U,
    0x237b34c0U,
    0xbed24620U,
    0x9d6f1130U,
    0x9d9f0da8U,
    0x8342d5ccU,
    0x77654396U,
    0x8bd0a0ddU,
    0xffeaa82bU,
    0x285b942eU,
    0x9fe0ee02U,
    0xe110850eU,
    0xcec9e39eU,
    0xce6f50eeU,
    0xda192009U,
    0x7c07300bU,
    0x12072832U,
    0xb07541cU,
    0x33824e34U,
    0xd1467533U,
    0x1c61ebacU,
    0x285234dbU,
    0xc6a9c61cU,
    0x583ed118U,
    0x8db02dbbU,
    0xe0b8e5d7U,
    0xaf77eb98U,
    0x8d9f34d2U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x8000000U,
    0x9c000000U,
    0x8a000000U,
    0x71000000U,
    0xe800000U,
    0x5cc00000U,
    0x83600000U,
    0x31900000U,
    0x75280000U,
    0x51340000U,
    0x865a0000U,
    0x50cf0000U,
    0x90668000U,
    0x82114000U,
    0xc56f6000U,
    0x73909000U,
    0xb82d2800U,
    0xa5b7c400U,
    0xb39fbe00U,
    0x4928a700U,
    0xeb317e80U,
    0x8f584440U,
    0xda4ff620U,
    0xd2a4f310U,
    0x66776898U,
    0x17d6744U,
    0x25fad6a2U,
    0x383ec077U,
    0xcddf281aU,
    0x248cc408U,
    0xccc33e19U,
    0xcb66e734U,
    0xcd909e80U,
    0xef2d9477U,
    0x2837be1cU,
    0x14dca70fU,
    0x860b7e9aU,
    0x6207444bU,
    0xbd01763bU,
    0xec81b30fU,
    0xa1c208b7U,
    0xfe2f744U,
    0x80517e8aU,
    0x72c8447dU,
    0x4d67f603U,
    0x7e90f32aU,
    0x6cad68a1U,
    0xe0726776U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0xb8000000U,
    0xf4000000U,
    0x36000000U,
    0xb7000000U,
    0x99800000U,
    0x6bc00000U,
    0xa8200000U,
    0xac500000U,
    0x7df80000U,
    0x92b40000U,
    0xbd0a0000U,
    0x1c5f0000U,
    0xad208000U,
    0xfcd4c000U,
    0xc4ba2000U,
    0x62d6f000U,
    0x1fbdd800U,
    0x8955dc00U,
    0x9d7bd600U,
    0x43f6f500U,
    0x169d080U,
    0x7cee80c0U,
    0xb92e2e20U,
    0xe20ed910U,
    0x89dd5e98U,
    0x64e269f4U,
    0x5f4888eU,
    0xfe6f9cedU,
    0x196fd835U,
    0x78eedc09U,
    0x87295610U,
    0xc9093513U,
    0x6a597089U,
    0x7a23b0fbU,
    0xb5515614U,
    0x177d3503U,
    0x3ef370bbU,
    0x85ecb0c2U,
    0x43a9d610U,
    0x964df51dU,
    0x953b5094U,
    0xb51140e2U,
    0x7d9e8e2bU,
    0x3803e92dU,
    0xb4022682U,
    0x560185c5U,
    0x6702a681U,
    0x218545f6U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x28000000U,
    0xec000000U,
    0xea000000U,
    0xc5000000U,
    0x97800000U,
    0xb4400000U,
    0x6da00000U,
    0x2d300000U,
    0x32080000U,
    0x3540000U,
    0x56de0000U,
    0xb9cb0000U,
    0xf6b08000U,
    0x1c484000U,
    0x33f6e000U,
    0x786a9000U,
    0x11830800U,
    0x5b400c00U,
    0xdf229a00U,
    0x5ef41900U,
    0xc3ee6780U,
    0xafc21740U,
    0xa3e7f220U,
    0x4d96c530U,
    0x34b915b8U,
    0x471c9254U,
    0x112807aaU,
    0xbfa0c74bU,
    0xc321a22U,
    0x138c5915U,
    0xe0108797U,
    0xadfc8742U,
    0xb13afa0bU,
    0x325dc931U,
    0xd0b0fabU,
    0x59d0cb48U,
    0x29188001U,
    0xf22c4003U,
    0xb720e028U,
    0x92f59029U,
    0x99ed883aU,
    0x12c34c26U,
    0xf064fa0dU,
    0xffd6c905U,
    0x761b8fafU,
    0x38a88b63U,
    0xe66016U,
    0x6512d036U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0xd8000000U,
    0x84000000U,
    0xc6000000U,
    0xed000000U,
    0xf2800000U,
    0xb1c00000U,
    0x53200000U,
    0xc0500000U,
    0x9f880000U,
    0x40340000U,
    0xa53e0000U,
    0x68c90000U,
    0x6cd28000U,
    0x274dc000U,
    0x9795a000U,
    0xf1ae7000U,
    0xae48800U,
    0x1f730400U,
    0x65df1600U,
    0x60bac500U,
    0xe48ee880U,
    0xe7b7a340U,
    0xd27cbe20U,
    0x842a7130U,
    0x4ea0d6a8U,
    0xc8101244U,
    0xd2e9c896U,
    0x58041351U,
    0x44059639U,
    0x6603050fU,
    0xfd0548a2U,
    0x2a80d349U,
    0x35c2b633U,
    0x9520b51aU,
    0x2d546082U,
    0x6d0da743U,
    0xf1f12817U,
    0xf61d7417U,
    0xa89b9e31U,
    0xf359c116U,
    0x6779fea1U,
    0x32a9667bU,
    0x996456b5U,
    0x6630d26fU,
    0x3838e8b4U,
    0xf24aa365U,
    0x91103e1dU,
    0xee6eb13dU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x68000000U,
    0x24000000U,
    0xce000000U,
    0xc9000000U,
    0xb800000U,
    0xedc00000U,
    0xfda00000U,
    0xa500000U,
    0x41680000U,
    0xf9b40000U,
    0x3f5a0000U,
    0xe12f0000U,
    0x54d68000U,
    0x52a4000U,
    0xbad6a000U,
    0xbc2fb000U,
    0xc9532800U,
    0x1ded8c00U,
    0xdef31600U,
    0x10ba5900U,
    0x5d1d5080U,
    0xf4b6040U,
    0x72201e20U,
    0x19922510U,
    0x6dcbce98U,
    0xa4630544U,
    0x11f570baU,
    0xc63a9059U,
    0x6d5f960bU,
    0x8a2f1926U,
    0xc557080U,
    0x9c6a9076U,
    0x24379636U,
    0x479b1929U,
    0x950f70b9U,
    0x90459073U,
    0xb5611608U,
    0x66715918U,
    0xd9f9d091U,
    0xcbfa204bU,
    0xc0fa3e09U,
    0x8878d50bU,
    0x7938c6bcU,
    0xc3db794aU,
    0xf66beea4U,
    0x6336f576U,
    0xe518f8b0U,
    0x634cac77U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x28000000U,
    0x74000000U,
    0x6e000000U,
    0x55000000U,
    0x6e800000U,
    0xa9400000U,
    0x4c600000U,
    0xe1d00000U,
    0x8eb80000U,
    0xa2740000U,
    0x4e4e0000U,
    0xb7790000U,
    0x5a548000U,
    0x897a4000U,
    0xe7542000U,
    0x33fab000U,
    0xf0114800U,
    0x29b2400U,
    0xb44d200U,
    0x4b609f00U,
    0xb0560080U,
    0x8a7cd4c0U,
    0x20d53a20U,
    0x3e3b4b30U,
    0x637baa8U,
    0xe0addff4U,
    0xcdeea0aaU,
    0xd78824edU,
    0x9f5e5213U,
    0xb563df11U,
    0xad56a0b9U,
    0xe0fc24c3U,
    0x1f905222U,
    0x7b5adf00U,
    0x9362208bU,
    0xfc5664e3U,
    0x187c7231U,
    0xbfd46f12U,
    0x43bd6895U,
    0xe0f440d3U,
    0x50c2038U,
    0x9c1eb00eU,
    0x9a074819U,
    0xfb062416U,
    0x9b86521fU,
    0x17c7df23U,
    0xcd20a0b2U,
    0xd9b124eeU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x38000000U,
    0xf4000000U,
    0x12000000U,
    0xe9000000U,
    0x82800000U,
    0x8c400000U,
    0x77200000U,
    0xfb700000U,
    0x4c580000U,
    0xbe940000U,
    0xe24a0000U,
    0x799d0000U,
    0x4e768000U,
    0x50dac000U,
    0x1dd22000U,
    0xfcebd000U,
    0x5d2c2800U,
    0x8fcda400U,
    0xfc5d7a00U,
    0xd690c500U,
    0xe4d7d80U,
    0x8f9911c0U,
    0x8d75f220U,
    0xcf5c7110U,
    0x1160f88U,
    0xee8ba0c4U,
    0x53fbddaeU,
    0xb4a101edU,
    0x79b77a2cU,
    0x713dc52eU,
    0xd9c3fda6U,
    0x6e7d1daU,
    0x7195d237U,
    0xfbcea129U,
    0xae5ea7bfU,
    0x1f95c4f2U,
    0x9cc807abU,
    0x3bddd4eeU,
    0xe528fb1U,
    0x262860ebU,
    0xa44d7daaU,
    0xd29911c4U,
    0x3df5f203U,
    0xba1c7104U,
    0xccb60f9aU,
    0x6dbba0d1U,
    0x7a83ddbcU,
    0x184501ebU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x8000000U,
    0x44000000U,
    0xce000000U,
    0x47000000U,
    0x6f800000U,
    0x35400000U,
    0x68200000U,
    0x6d300000U,
    0xdab80000U,
    0x11d40000U,
    0x6dee0000U,
    0xc1ff0000U,
    0x2ef48000U,
    0x75d4000U,
    0xba03a000U,
    0x9106b000U,
    0x4835800U,
    0xc1ac00U,
    0xdc65a200U,
    0x69902500U,
    0x234fcf80U,
    0xd10a06c0U,
    0x16a9da20U,
    0x2ede7930U,
    0x4c449598U,
    0x38a23ff4U,
    0xcbf46fa2U,
    0xd5d8b6e1U,
    0xd1c4820bU,
    0x78e0d515U,
    0xd955b781U,
    0x272f5ae8U,
    0xf498000bU,
    0xbfe4002bU,
    0x76d60006U,
    0x726b002cU,
    0x4cba8018U,
    0xdad24037U,
    0xe86f2014U,
    0xadbff00fU,
    0x6656f818U,
    0x74ac1c1dU,
    0xf3dc7a0bU,
    0xc2c3c92aU,
    0xb1654da4U,
    0x3f15d3fbU,
    0xe688ed9cU,
    0xafec63d0U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0xc8000000U,
    0xd4000000U,
    0x72000000U,
    0xbb000000U,
    0xc800000U,
    0xadc00000U,
    0x96e00000U,
    0xff900000U,
    0x59e80000U,
    0xa340000U,
    0x8e5e0000U,
    0xb2290000U,
    0xc5d58000U,
    0x5e4d4000U,
    0xa6802000U,
    0x9ac45000U,
    0xa4603800U,
    0x7752d400U,
    0x168d6600U,
    0x49e3ab00U,
    0x29176680U,
    0xcb2bce40U,
    0xda50fe20U,
    0x7b0c6f30U,
    0xd7a418a8U,
    0x54b7e17cU,
    0xa89f4692U,
    0x404b9e45U,
    0xb386c614U,
    0x2b43bb22U,
    0x3c22fe99U,
    0x33f00a62U,
    0xabd802bU,
    0xa6b94014U,
    0xa8be2021U,
    0xe5bd503bU,
    0x183db837U,
    0x1e7b940dU,
    0x8fdb461eU,
    0x826afb04U,
    0x574de9fU,
    0x8795a63U,
    0xeede383eU,
    0xb1ebd429U,
    0xee30e623U,
    0x945aeb1dU,
    0x2d29469bU,
    0x73569e50U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0x38000000U,
    0x7c000000U,
    0xae000000U,
    0x81000000U,
    0xf6800000U,
    0x81c00000U,
    0xc2600000U,
    0x48300000U,
    0x90e80000U,
    0x23140000U,
    0x727a0000U,
    0x6b2b0000U,
    0xca768000U,
    0x7fccc000U,
    0xb3806000U,
    0xe5463000U,
    0x8ca12800U,
    0xedd1a400U,
    0x979cb600U,
    0x8c5a4f00U,
    0x753a8b80U,
    0x408b9240U,
    0xe4237e20U,
    0x65151b10U,
    0x177d75b8U,
    0xbfad4944U,
    0x4cb2ebaeU,
    0x8e29a24fU,
    0x5ef05633U,
    0x190bbf34U,
    0x5265438bU,
    0x3034c67bU,
    0xcec8035U,
    0x9d17c03dU,
    0xcb7ee00aU,
    0xe1aef00cU,
    0xe5b3481fU,
    0x3ca89437U,
    0xd311e0dU,
    0xf46c2b25U,
    0x6dd0dda9U,
    0xd79b2d4bU,
    0x6c58bd9dU,
    0x65391d7cU,
    0x788b9587U,
    0x9827b959U,
    0xcb13a398U,
    0x967e3643U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xa8000000U,
    0x44000000U,
    0x2e000000U,
    0x1d000000U,
    0x9800000U,
    0x3fc00000U,
    0x73e00000U,
    0x6ff00000U,
    0x60a80000U,
    0xdc540000U,
    0xf27a0000U,
    0xe36d0000U,
    0xddb18000U,
    0x628e4000U,
    0xd40a000U,
    0xaca1b000U,
    0x8c568800U,
    0xea7c9c00U,
    0x2f692600U,
    0x47b71b00U,
    0xf988bd80U,
    0x5dc30c40U,
    0xb4e68e20U,
    0xdd707710U,
    0xffedb388U,
    0x1ff43b7cU,
    0x88a81d8aU,
    0xb852bc41U,
    0x2c780623U,
    0x5668eb2bU,
    0x903695a0U,
    0x734a2062U,
    0x63a3201dU,
    0xcad6f01dU,
    0xd33da819U,
    0x45ce6c03U,
    0xb2e68e08U,
    0xc470773dU,
    0xf86db3b8U,
    0xcd343b73U,
    0x5ac81d85U,
    0xac62bc7bU,
    0x1130061cU,
    0xf8cceb2dU,
    0xb649585U,
    0x73b32078U,
    0x3f88a023U,
    0x24c5b038U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x88000000U,
    0x84000000U,
    0xbe000000U,
    0x81000000U,
    0x57800000U,
    0x73400000U,
    0x23e00000U,
    0xa4900000U,
    0x48a80000U,
    0xa5b40000U,
    0x819a0000U,
    0x7fef0000U,
    0x18528000U,
    0x540d4000U,
    0x78c7a000U,
    0xc2a73000U,
    0xcc776800U,
    0x9cbfec00U,
    0x44da2200U,
    0x190d8b00U,
    0x3544f280U,
    0x7ee14840U,
    0x21106a20U,
    0x10ec1710U,
    0x66d41898U,
    0x4cb1f64U,
    0x8e635282U,
    0xc8d67871U,
    0x4dcf0217U,
    0x3de7fb14U,
    0x95943aafU,
    0x67299459U,
    0x4af52025U,
    0x107a7038U,
    0x6078c830U,
    0x387cdc31U,
    0x547f4a1fU,
    0xfe79670bU,
    0x497e50b3U,
    0x1bfa8375U,
    0x813bb899U,
    0x50982f4aU,
    0x806e3aa5U,
    0x1f169470U,
    0xd1efa001U,
    0x5153301fU,
    0xe78d6815U,
    0x2580ec32U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0xb8000000U,
    0x4c000000U,
    0x7e000000U,
    0xd1000000U,
    0x7c800000U,
    0x91c00000U,
    0xaba00000U,
    0x7f700000U,
    0x45880000U,
    0x2b940000U,
    0x1f9e0000U,
    0xf490000U,
    0xdfb18000U,
    0x82aec000U,
    0xad20e000U,
    0x75b3b000U,
    0xd1ac2800U,
    0x66a5f400U,
    0x75f23600U,
    0x514f5100U,
    0xbeb0e180U,
    0xe62eb740U,
    0xe77e20U,
    0x1813d530U,
    0x33d81fa8U,
    0x21aaa25cU,
    0x1ea6018eU,
    0x99f00763U,
    0x5f4cd617U,
    0xd7b5e118U,
    0xd6ad4999U,
    0xef25836bU,
    0x62b5a83bU,
    0x302f3408U,
    0xf5e4d639U,
    0x9e91e106U,
    0xf91b499cU,
    0x1588836bU,
    0x23922833U,
    0x4b9cf431U,
    0x4d4bb60aU,
    0xc8b5912cU,
    0x632e0180U,
    0x3e640776U,
    0x9ed2d62fU,
    0x79fce127U,
    0xcd9cc980U,
    0xb04b4346U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x28000000U,
    0x4c000000U,
    0x9e000000U,
    0xf1000000U,
    0xe5800000U,
    0x58c00000U,
    0xb5e00000U,
    0xcf100000U,
    0x71b80000U,
    0xc5b40000U,
    0xd48e0000U,
    0xf67f0000U,
    0xdcd08000U,
    0xa2dc4000U,
    0xe8e7e000U,
    0x24913000U,
    0x907fa800U,
    0x89d73c00U,
    0xf55efe00U,
    0x8f206b00U,
    0xadf3e280U,
    0xae292cc0U,
    0x8b4e3620U,
    0xbb1e2730U,
    0x835498U,
    0xb7444bd4U,
    0xd62202aaU,
    0xc4731ce3U,
    0x8ef1e1fU,
    0x9faa5b18U,
    0xb98acaabU,
    0x65f950d1U,
    0x5911a820U,
    0x3cb83c2cU,
    0xa6367e1aU,
    0x49482b0fU,
    0x5c1a02abU,
    0x68071ccbU,
    0xec011e01U,
    0xae055b26U,
    0x89024ab2U,
    0x818110c7U,
    0x8ac04821U,
    0xdae20c27U,
    0xdb975613U,
    0xccfc571bU,
    0x28939cb3U,
    0xae7a07f8U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0xa8000000U,
    0xa4000000U,
    0xc2000000U,
    0x77000000U,
    0x40800000U,
    0xc0400000U,
    0xc0a00000U,
    0xda700000U,
    0xf1e80000U,
    0x25140000U,
    0x1ffa0000U,
    0x846b0000U,
    0x92d28000U,
    0xbf984000U,
    0xcefaa000U,
    0xd1e9d000U,
    0x1512d800U,
    0xc7f8b400U,
    0x18696a00U,
    0x5cd55900U,
    0xae99a580U,
    0x3b788040U,
    0x26299220U,
    0x55777d10U,
    0x1d6a37b8U,
    0xf354fd64U,
    0x5259258aU,
    0x659fc079U,
    0x85fbb228U,
    0x2f6ded29U,
    0xfc50cf82U,
    0xfeddd97dU,
    0x53d8378aU,
    0x585bfd52U,
    0x6699a584U,
    0x4f788050U,
    0xac299215U,
    0x16777d3aU,
    0x37ea378aU,
    0xe014fd40U,
    0x107925a2U,
    0x8afc048U,
    0xf433b22eU,
    0x1049ed10U,
    0xd2e2cf9fU,
    0x85d2d94eU,
    0x2f18b7acU,
    0x46bcbd71U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x48000000U,
    0x74000000U,
    0x46000000U,
    0xff000000U,
    0x46800000U,
    0xea400000U,
    0xdc600000U,
    0x2900000U,
    0x2b880000U,
    0x99340000U,
    0xefba0000U,
    0xd10b0000U,
    0x1738000U,
    0x6adf4000U,
    0xda1d2000U,
    0xce3bf000U,
    0xb1cf1800U,
    0xad572400U,
    0xc9285a00U,
    0x44844f00U,
    0x5b412280U,
    0xf1e3c540U,
    0x5853e220U,
    0xaaacdb10U,
    0x7540c0b8U,
    0x6ae01e6cU,
    0x40d2a2b2U,
    0x33ec854dU,
    0x95a6c209U,
    0x4f332b03U,
    0x48bdd8bbU,
    0xfb883a4bU,
    0x21337894U,
    0x33bc8a72U,
    0x53094092U,
    0xf0745e5fU,
    0xa75c0297U,
    0x30d8356fU,
    0x71cfa26U,
    0x29bbff22U,
    0x6e089aadU,
    0xa7f45155U,
    0x309b8012U,
    0x4e7b400dU,
    0xb8af2001U,
    0xdc44f037U,
    0xcb669809U,
    0x60136411U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x68000000U,
    0xcc000000U,
    0x7a000000U,
    0x9d000000U,
    0x58800000U,
    0xd3c00000U,
    0xe4a00000U,
    0xdd300000U,
    0x8e80000U,
    0x53d40000U,
    0x983e0000U,
    0x786b0000U,
    0x6c128000U,
    0xf69a4000U,
    0x405de000U,
    0x987a1000U,
    0xc08cc800U,
    0xdbc2f400U,
    0xf8a36600U,
    0x2f33a900U,
    0x49ecc380U,
    0x1957e440U,
    0x1afece20U,
    0xbe4a0d30U,
    0xffe40db8U,
    0x4252e944U,
    0x1d7e43baU,
    0xec0da443U,
    0x36032e06U,
    0x27001d13U,
    0x2580c5b4U,
    0x9b441d43U,
    0x5f63259dU,
    0xf5950d53U,
    0xafdd6d92U,
    0xc63db973U,
    0x936beb8bU,
    0x3390005aU,
    0xf0dde03cU,
    0x47ba103eU,
    0xbe2cc81eU,
    0x8bf2f408U,
    0xc0cb6626U,
    0x6327a902U,
    0x4f72c386U,
    0x210ce460U,
    0x26844e19U,
    0xc8c44d2fU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xa8000000U,
    0x34000000U,
    0x12000000U,
    0x37000000U,
    0xc6800000U,
    0x4c00000U,
    0xbae00000U,
    0x4e700000U,
    0xe2180000U,
    0x1dd40000U,
    0xb2ca0000U,
    0xa9d0000U,
    0xb8118000U,
    0x63ae4000U,
    0x75ab2000U,
    0x98ac5000U,
    0x8d2a5800U,
    0x56f8400U,
    0x104cce00U,
    0x45e3b00U,
    0x89f09180U,
    0x3d5ba9c0U,
    0x1e763620U,
    0xfa1eaf10U,
    0xa1d4a788U,
    0x64cc06fcU,
    0x8799118aU,
    0x7d91e9ddU,
    0xb3ef162cU,
    0xfc8bff21U,
    0xaabd7f93U,
    0x2584c2f0U,
    0x40457fa0U,
    0xf120c2c3U,
    0x5e177fa5U,
    0x26a9c2e7U,
    0x542cffb1U,
    0x2ea82f1U,
    0xaf0e5fbeU,
    0xd7fc92e0U,
    0x992527beU,
    0xa1246ceU,
    0xe4aa31b8U,
    0x3b29b9e5U,
    0x586f4e16U,
    0x8dc97b06U,
    0x481831b1U,
    0x26d0b9c3U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xc8000000U,
    0x94000000U,
    0x6a000000U,
    0xed000000U,
    0x9f800000U,
    0x31400000U,
    0x21a00000U,
    0x4b500000U,
    0x2e680000U,
    0x13340000U,
    0x1f5a0000U,
    0x356b0000U,
    0x3fb58000U,
    0xa69b4000U,
    0xef0c2000U,
    0xa7809000U,
    0x2d408800U,
    0x3fa78c00U,
    0xbc507200U,
    0x94e87900U,
    0x29f4dc80U,
    0x65bfcc40U,
    0xb29b5a20U,
    0xc50b2510U,
    0xaa8786b8U,
    0xc2c0e95cU,
    0xc6e6dc92U,
    0x9f0cc75U,
    0xb5bcda02U,
    0xea9f6537U,
    0xe90c26adU,
    0x9c843975U,
    0xd1c5f480U,
    0xde67905cU,
    0x4a35802eU,
    0x3adb403fU,
    0xb12c2022U,
    0xad90902aU,
    0xea888824U,
    0xf3c38c21U,
    0xe762720aU,
    0x5fb77917U,
    0x969b5cacU,
    0xc70f8c75U,
    0x4382fa38U,
    0x8f40f523U,
    0x46a32e8eU,
    0x49d3f56aU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0xb8000000U,
    0x44000000U,
    0x46000000U,
    0xf7000000U,
    0xa1800000U,
    0xc9c00000U,
    0x1d200000U,
    0xe6100000U,
    0x89b80000U,
    0x4a740000U,
    0xa1ca0000U,
    0x4ab90000U,
    0x55f18000U,
    0x7b0ac000U,
    0x401ca000U,
    0x35267000U,
    0xa175800U,
    0x63bf9c00U,
    0xf7758600U,
    0x4d4fbd00U,
    0xd7fd6280U,
    0x9196e2c0U,
    0x1f7dfe20U,
    0x5ad19110U,
    0xc4189ca8U,
    0x932373fcU,
    0xad17628eU,
    0x8a3fe2c1U,
    0xc2b47e19U,
    0x526f5111U,
    0x80ee3caeU,
    0x4eac03dfU,
    0x3d49ba98U,
    0x2ffebec5U,
    0x75975813U,
    0xa97f9c31U,
    0x15d58601U,
    0x219fbd34U,
    0x1ce5628fU,
    0x4732e2d9U,
    0xcdaffe03U,
    0x82cc9112U,
    0x53b1cb8U,
    0xc734b3e3U,
    0x8da84293U,
    0x22ce52eaU,
    0xf53c0634U,
    0x7f317d20U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x48000000U,
    0xec000000U,
    0xaa000000U,
    0x69000000U,
    0xf6800000U,
    0xbec00000U,
    0xcce00000U,
    0x18700000U,
    0x2d580000U,
    0x13d40000U,
    0x228a0000U,
    0x935f0000U,
    0x54d58000U,
    0xeb0b4000U,
    0x201be000U,
    0x1d729000U,
    0x31df6800U,
    0xa4110400U,
    0x68e82e00U,
    0x7de8bb00U,
    0x596d3180U,
    0x4aaba3c0U,
    0x46cb2620U,
    0x6b7b6f10U,
    0xf9461798U,
    0x10a0ccdcU,
    0x45531b2U,
    0xa6cfa3ebU,
    0x5b792612U,
    0xd1406f16U,
    0x8ca197b7U,
    0xe6508cc8U,
    0x23c951abU,
    0x7fd73f7U,
    0x6822e24U,
    0xb6c7bb3dU,
    0x40e0b18cU,
    0xc274e3eaU,
    0xc5ac635U,
    0x956ff09U,
    0x364cff84U,
    0x36ba88ceU,
    0xba26ffadU,
    0x789588f5U,
    0xff2b7fadU,
    0x278ac8f6U,
    0x8fda9f86U,
    0xe31758c4U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x90000000U,
    0x78000000U,
    0x84000000U,
    0xa000000U,
    0xfd000000U,
    0x40800000U,
    0x9c400000U,
    0xbee00000U,
    0xae900000U,
    0xbd480000U,
    0xcfb40000U,
    0xaefe0000U,
    0xdf4f0000U,
    0xeb68000U,
    0x7ec000U,
    0x240fa000U,
    0x75d51000U,
    0xf62d0800U,
    0xb1e5f400U,
    0x57121a00U,
    0xb8cfb00U,
    0x80176280U,
    0x860e8740U,
    0xd4d03220U,
    0xc8a9df30U,
    0x32a75098U,
    0xa8775864U,
    0xf7df62beU,
    0xe8fa8751U,
    0xe44e323aU,
    0xb536df2bU,
    0x47b9d096U,
    0x4d2d9862U,
    0xca66c293U,
    0x70d49745U,
    0xf2abba05U,
    0x47a2eb3fU,
    0x84f2ea92U,
    0x9d9ab37eU,
    0x251b083fU,
    0xfd5ef436U,
    0x29ba9a07U,
    0xea2d3b25U,
    0x6fe642b4U,
    0xb8115776U,
    0xa20c9a3dU,
    0x2ed63b08U,
    0xddaec298U,
    0x8e209757U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x38000000U,
    0xbc000000U,
    0x2a000000U,
    0xa1000000U,
    0x75800000U,
    0x14c00000U,
    0x31a00000U,
    0xdeb00000U,
    0xba080000U,
    0x21540000U,
    0xd35e0000U,
    0x860d0000U,
    0xcb528000U,
    0x525ec000U,
    0xe3886000U,
    0xe7921000U,
    0xdffe2800U,
    0x173a9c00U,
    0xfc9fbe00U,
    0x8b280900U,
    0xd0a2cf80U,
    0x4b36e340U,
    0x9ecd7620U,
    0x38f74530U,
    0x89efb988U,
    0xaa01a644U,
    0x6102cfaeU,
    0x5586e35fU,
    0x4c57622U,
    0x9a3451cU,
    0x62b1b99bU,
    0x900ca66eU,
    0x80504fa8U,
    0xa6d82340U,
    0x92cd1611U,
    0xfaf15511U,
    0x8cef91a3U,
    0x59863a78U,
    0xc6c7f1b4U,
    0xca42a5cU,
    0x9131d99dU,
    0x37cab649U,
    0xd9706786U,
    0x332fbf59U,
    0xaca0283bU,
    0x41379c03U,
    0x2fcd3e30U,
    0x7576c901U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x18000000U,
    0xa4000000U,
    0x32000000U,
    0x75000000U,
    0xbb800000U,
    0xc2c00000U,
    0xa2200000U,
    0xe8300000U,
    0xfda80000U,
    0xd8540000U,
    0xa5fe0000U,
    0xbdab0000U,
    0xf8578000U,
    0xf5f9c000U,
    0x15aba000U,
    0x4456d000U,
    0x63ff4800U,
    0x52afec00U,
    0x8ad36e00U,
    0x1abf8500U,
    0x324ebb80U,
    0xc0c19240U,
    0xf260620U,
    0x17b07930U,
    0xbd68bdb8U,
    0x1771eb6cU,
    0x524ebba6U,
    0xb0c19259U,
    0xf7260614U,
    0x3b07901U,
    0x9768bd90U,
    0xc671eb75U,
    0xdbcebb82U,
    0x701927eU,
    0xee860605U,
    0x29407907U,
    0xc8e0bd91U,
    0xf615eb60U,
    0x8398bb83U,
    0x62fe9275U,
    0xb32f8629U,
    0x6112b939U,
    0x251c9db7U,
    0x47bafb49U,
    0xf5cc53a4U,
    0x7407ae62U,
    0x5a03a03dU,
    0x2902d01dU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0xf8000000U,
    0x4c000000U,
    0xce000000U,
    0xad000000U,
    0xed800000U,
    0x2f400000U,
    0xfe600000U,
    0xb6900000U,
    0x22980000U,
    0x829c0000U,
    0xd29e0000U,
    0x3a9d0000U,
    0xfe9e8000U,
    0x84994000U,
    0xab9b2000U,
    0x251d5000U,
    0x4ad83800U,
    0x767f5400U,
    0x11ce2e00U,
    0x7ba1dd00U,
    0x6d306980U,
    0x1fab7d40U,
    0x753069a0U,
    0x63ab7d50U,
    0x233069b8U,
    0xf2ab7d4cU,
    0xf8b06986U,
    0x3ceb7d5fU,
    0x255069b5U,
    0x83b7d74U,
    0x1428698eU,
    0x13777d7fU,
    0x1a4e69b1U,
    0x1de67d52U,
    0x14d6e9b9U,
    0x217e3d72U,
    0x934d498dU,
    0xba672d7cU,
    0x8c90d1b2U,
    0x6d9c695dU,
    0x7c1de798U,
    0x455fb054U,
    0x4a3b980aU,
    0x572a4409U,
    0x43f5b62eU,
    0x508b9907U,
    0x78c5dfadU,
    0xde20e45cU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0xc8000000U,
    0x1c000000U,
    0xba000000U,
    0xff000000U,
    0x99800000U,
    0x1c400000U,
    0xeca00000U,
    0x8b900000U,
    0xd8380000U,
    0x703c0000U,
    0x1c3e0000U,
    0x8e390000U,
    0x5d388000U,
    0xb6bec000U,
    0x49fe2000U,
    0x86dbf000U,
    0xee0c0800U,
    0x4310c400U,
    0xa4fc2600U,
    0x8c5d4300U,
    0xf9cc1f80U,
    0x60f45e40U,
    0x284c1fa0U,
    0x20b45e50U,
    0x9eec1f98U,
    0x64245e5cU,
    0x17541faaU,
    0x14585e5bU,
    0x5dca1f84U,
    0xeef15e64U,
    0x414a9fa2U,
    0x34339e63U,
    0xf82abf99U,
    0xb7416e41U,
    0x932637afU,
    0x32d36a5dU,
    0x621a31a8U,
    0xb66cd97eU,
    0x28e2a63fU,
    0x23368313U,
    0xedacbf8dU,
    0x9046e62U,
    0x6480b7aeU,
    0x4ec4aa6eU,
    0xff64918dU,
    0xf675e946U,
    0xc58e8e2fU,
    0x1c54b726U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0x48000000U,
    0xe4000000U,
    0x9e000000U,
    0x8f000000U,
    0x52800000U,
    0x1400000U,
    0xada00000U,
    0xc100000U,
    0x15a80000U,
    0x2dac0000U,
    0x41aa0000U,
    0x9baf0000U,
    0x7aa88000U,
    0xef2ac000U,
    0x58ede000U,
    0x6a091000U,
    0x44bd6800U,
    0xf87fc00U,
    0x36c3f600U,
    0xf7609b00U,
    0x2175fb80U,
    0xd5dad6c0U,
    0x6df5fba0U,
    0x9b9ad6f0U,
    0x32d5fb88U,
    0x66cad6ccU,
    0xc2ddfb9aU,
    0xa376d6f5U,
    0x8dffbbdU,
    0x9a75d6d6U,
    0x615d7ba9U,
    0xefb016d6U,
    0xeeb81b82U,
    0x6683c6d5U,
    0xe7409387U,
    0x2ea12adeU,
    0xd4940d97U,
    0x4de94df8U,
    0xb98a8009U,
    0x8079c003U,
    0xade7603fU,
    0xa430d029U,
    0xb67a0806U,
    0x56e72c16U,
    0x70b1fe19U,
    0x643bb712U,
    0x9bc605b6U,
    0x88e261c4U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0xe8000000U,
    0xb4000000U,
    0xb6000000U,
    0x31000000U,
    0x5e800000U,
    0x73400000U,
    0x36e00000U,
    0x50300000U,
    0xf4d80000U,
    0xb0dc0000U,
    0x9eda0000U,
    0x43df0000U,
    0xe75f8000U,
    0x4f18c000U,
    0x147d6000U,
    0xee88d000U,
    0x30715800U,
    0xcbbfac00U,
    0xb42e3600U,
    0xd5248100U,
    0xb8978080U,
    0x6e89e640U,
    0xf07780a0U,
    0x6bb9e670U,
    0xa42f8088U,
    0x3d25e674U,
    0xc9580b2U,
    0xd88ae659U,
    0xc172009fU,
    0x353e2655U,
    0xd76d6088U,
    0xbc5f649U,
    0x5ca1b885U,
    0x2c519a5dU,
    0x71af6eb8U,
    0xabe60b71U,
    0x94b1561fU,
    0xec9f5121U,
    0x13bb5886U,
    0x382d8a42U,
    0x9f21568bU,
    0x9b92774dU,
    0x5f0bb815U,
    0x58b3bc16U,
    0xc6980e0fU,
    0x80bcfd32U,
    0xf1af6eb3U,
    0x6be60b7dU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0x58000000U,
    0xf4000000U,
    0x52000000U,
    0xe7000000U,
    0xba800000U,
    0xadc00000U,
    0x31600000U,
    0x39300000U,
    0xa8880000U,
    0xaa8c0000U,
    0x558e0000U,
    0x7b0d0000U,
    0x54cb8000U,
    0xdaa94000U,
    0xad1ee000U,
    0xfa547000U,
    0x86bf4800U,
    0x50849c00U,
    0x2ec4f200U,
    0xe1e2f900U,
    0x57f47080U,
    0x296ad4c0U,
    0x2d7c70a0U,
    0x24e6d4d0U,
    0xa27270b8U,
    0x222bd4e4U,
    0x9fd9f0aeU,
    0x35b294d9U,
    0xc84f10baU,
    0x826ae4e0U,
    0xa1fe5894U,
    0x42378cbU,
    0xea912a98U,
    0x658c1c5U,
    0xb8f3ba32U,
    0x7fea652fU,
    0x46be8287U,
    0x70852de1U,
    0x9ec3802aU,
    0x69e54033U,
    0xfbf0e02fU,
    0x8f697014U,
    0x987cc814U,
    0x7961dc30U,
    0xb5341233U,
    0xbe8b8927U,
    0x9788b890U,
    0xa40b08f1U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0x28000000U,
    0xcc000000U,
    0x86000000U,
    0x35000000U,
    0xf1800000U,
    0x17c00000U,
    0xf2e00000U,
    0xf700000U,
    0xb0a80000U,
    0x26ac0000U,
    0xabaa0000U,
    0xee2d0000U,
    0x2be88000U,
    0x8e09c000U,
    0xfffa000U,
    0xea139000U,
    0xed1e3800U,
    0x5d63b400U,
    0xe9b60a00U,
    0xa9cd1d00U,
    0x151aa680U,
    0xc96383c0U,
    0x6bb2a6a0U,
    0x66cf83f0U,
    0x7f98a698U,
    0xd62283dcU,
    0xf9102692U,
    0xb99b43efU,
    0xc32786b3U,
    0x5894d3e2U,
    0x365bbe8fU,
    0xd5c667e7U,
    0x1de734b3U,
    0x35f3bae4U,
    0x37e8b21fU,
    0x500b692dU,
    0x3ef90c95U,
    0xe1900ee6U,
    0x61deb807U,
    0xa7067419U,
    0x8683aa16U,
    0xc9438d0cU,
    0x3fa41ebeU,
    0xcad5f7c9U,
    0xe1790cb3U,
    0xcf500ee8U,
    0x4beb82fU,
    0x3ab6743dU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x28000000U,
    0xe4000000U,
    0x5a000000U,
    0xeb000000U,
    0x44800000U,
    0xc6400000U,
    0x85a00000U,
    0x67d00000U,
    0x30a80000U,
    0x2eac0000U,
    0xefaa0000U,
    0xd82d0000U,
    0xc6ef8000U,
    0x130ec000U,
    0xa479e000U,
    0x6833000U,
    0x71406800U,
    0xb7244c00U,
    0xa4957e00U,
    0x688bd300U,
    0xc4bdad80U,
    0x826508c0U,
    0x39b5ada0U,
    0xbf1908f0U,
    0x74b7ad98U,
    0x169808e4U,
    0x6b722d92U,
    0x14fbc8ddU,
    0x92c44d84U,
    0x4be638e7U,
    0xb675c595U,
    0x757d44d6U,
    0x3902d3b4U,
    0x3b83dbcfU,
    0x40c78038U,
    0x34e2c004U,
    0x30f3e023U,
    0xc43e3002U,
    0x6e27e82aU,
    0xcf168c12U,
    0x4e9e09U,
    0x1459e32aU,
    0xe8904583U,
    0x168e84fdU,
    0x95bcb39bU,
    0x7de22be6U,
    0x93740833U,
    0x18f8bc0bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xc8000000U,
    0xdc000000U,
    0xce000000U,
    0xb1000000U,
    0x28800000U,
    0xd7400000U,
    0x8fe00000U,
    0x8f00000U,
    0xef380000U,
    0x853c0000U,
    0x2e3a0000U,
    0x5bf0000U,
    0xb57e8000U,
    0xbc58c000U,
    0x188e2000U,
    0x69e05000U,
    0x35f1d800U,
    0x51be9c00U,
    0xc7792600U,
    0x535ad900U,
    0x7909de80U,
    0x8221c740U,
    0x7f51dea0U,
    0xa9adc770U,
    0xb933de88U,
    0xc69ec77cU,
    0x8aaf5ebaU,
    0x2eb5074bU,
    0x285dfe89U,
    0xca8e9767U,
    0xb6e68683U,
    0x9c779b52U,
    0x667ed8a0U,
    0x43db4e50U,
    0x1a49d81bU,
    0x2fc29c31U,
    0xc0a32630U,
    0x315d900U,
    0xdcf5eb5U,
    0x1050763U,
    0x2085fea1U,
    0xab42977eU,
    0x71e486b7U,
    0x71f49b4aU,
    0x1bba58beU,
    0x9c7c8e5cU,
    0x10d97830U,
    0x25ca0c12U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xa8000000U,
    0xa4000000U,
    0x86000000U,
    0x83000000U,
    0x7e800000U,
    0x6bc00000U,
    0x9ea00000U,
    0xc6d00000U,
    0x6b280000U,
    0x512c0000U,
    0x682e0000U,
    0x6fad0000U,
    0x63ed8000U,
    0xe108c000U,
    0xd3de000U,
    0x2e21d000U,
    0xda11c800U,
    0xc5083c00U,
    0xcb3c6200U,
    0xcd221700U,
    0xb4966180U,
    0x6ca98c0U,
    0xf19e61a0U,
    0x8df698d0U,
    0x5cb861b8U,
    0x296798d4U,
    0xf273e192U,
    0x7cfe58fdU,
    0xf98581b3U,
    0xa34648ddU,
    0xae6229acU,
    0x3af664c7U,
    0x4c39e38bU,
    0x5a45ff6U,
    0x84544811U,
    0xfaecfc22U,
    0xd68f822bU,
    0xd97ec729U,
    0xb0c229abU,
    0xbc2664d5U,
    0x4711e3a2U,
    0x44885fe7U,
    0x447a482dU,
    0x3141fc32U,
    0x3362020aU,
    0xbb760722U,
    0xc37fc9b9U,
    0xf9c7b4f6U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0xa8000000U,
    0x1c000000U,
    0x9a000000U,
    0xdd000000U,
    0x80800000U,
    0xa5c00000U,
    0x8e00000U,
    0xb8500000U,
    0x4d880000U,
    0xb88c0000U,
    0xe40a0000U,
    0xfbcb0000U,
    0x3e2b8000U,
    0xaefec000U,
    0x5ab62000U,
    0x70def000U,
    0xf1821800U,
    0xc7451c00U,
    0xe427b200U,
    0xa6333500U,
    0xbf1bd780U,
    0xbc64cbc0U,
    0x5b91d7a0U,
    0x226fcbf0U,
    0x4d5a57a8U,
    0x24c10bf4U,
    0xf2647782U,
    0xf093fbf3U,
    0x7dec6fa4U,
    0x111de7c4U,
    0x27605d84U,
    0xbc1012edU,
    0xca2daa06U,
    0xc8fa2903U,
    0x2db665b5U,
    0x955cfeddU,
    0x60c18024U,
    0xec65c017U,
    0x1395a029U,
    0xe6c300fU,
    0x6f5e383bU,
    0x4dc0ec27U,
    0xf4e62a2bU,
    0x1254e90fU,
    0x28884596U,
    0x8c0e0ed6U,
    0xc7c99828U,
    0xb42bdc20U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0x18000000U,
    0x5c000000U,
    0x5a000000U,
    0x6b000000U,
    0x95800000U,
    0xb8c00000U,
    0x7ea00000U,
    0x300000U,
    0x62e80000U,
    0xd5ec0000U,
    0xda6a0000U,
    0xa9af0000U,
    0x728e8000U,
    0xd27e4000U,
    0x9234a000U,
    0x1dea7000U,
    0xce6b2800U,
    0x27ac8400U,
    0x378dc200U,
    0x32ff7700U,
    0xd2755680U,
    0x7f0a71c0U,
    0xf6bf56a0U,
    0x169571f0U,
    0x46d9d688U,
    0x210731fcU,
    0x1687768eU,
    0xc94241ebU,
    0xf062de98U,
    0x579085f1U,
    0xc05bbcbdU,
    0xc04582dfU,
    0xa2e5c222U,
    0x98d3771fU,
    0x13f569aU,
    0x695571daU,
    0x4ff9d6a4U,
    0x9ef731ccU,
    0xdd4f7696U,
    0x935e41e3U,
    0xf9c0dea2U,
    0xf82385e9U,
    0xe1773ca2U,
    0xd688c2d4U,
    0x847de215U,
    0x2b344736U,
    0x976c5e86U,
    0xfd2ec5ecU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x18000000U,
    0x94000000U,
    0xda000000U,
    0x25000000U,
    0x79800000U,
    0xf5c00000U,
    0x98a00000U,
    0x69b00000U,
    0x78e80000U,
    0xf1ec0000U,
    0x966e0000U,
    0x24ab0000U,
    0x648b8000U,
    0x437b4000U,
    0xe7f7e000U,
    0x448d3000U,
    0x137a1800U,
    0x5ff6d400U,
    0xc088fa00U,
    0xd17a7f00U,
    0xeef25280U,
    0x630a65c0U,
    0x1bc52a0U,
    0xfd165d0U,
    0xff7fd288U,
    0xe1f625d4U,
    0x978e328eU,
    0x11fc15f1U,
    0x34b1aab8U,
    0x656a81f8U,
    0x762d30a6U,
    0xb7ca8ec5U,
    0x629c9a00U,
    0x82a00f1fU,
    0xacb1aabeU,
    0xb16a81f3U,
    0xc2d3093U,
    0x82ca8eeeU,
    0x31c9a24U,
    0xe3600f1fU,
    0xee11aa8dU,
    0xfdda81f2U,
    0xd4530a9U,
    0x86e68ec5U,
    0xdd29a0fU,
    0xae7b0f37U,
    0xf2722a9cU,
    0x4f4dc1f5U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0xf8000000U,
    0x1c000000U,
    0xa000000U,
    0xc1000000U,
    0xc6800000U,
    0xd8c00000U,
    0xbae00000U,
    0xd6b00000U,
    0xe8880000U,
    0xfd8c0000U,
    0x650e0000U,
    0x62cb0000U,
    0x61a98000U,
    0x865e4000U,
    0x1d76a000U,
    0x59eaf000U,
    0x677af800U,
    0x62a3cc00U,
    0xc7968a00U,
    0x3f5c1d00U,
    0x87f48880U,
    0x2b2ffcc0U,
    0x4c9a88a0U,
    0x8a94fcd0U,
    0xebdb0888U,
    0x7236bcc4U,
    0xf54ba8b6U,
    0x67eb4cc3U,
    0x87ed0b4U,
    0xd321c0f3U,
    0x42d17a85U,
    0xa2fe6dc5U,
    0xe9e62a2bU,
    0x7d31ed30U,
    0xf4c9f0b1U,
    0xeaa970dfU,
    0x21db22a0U,
    0x533051c3U,
    0xc3cdd82eU,
    0x172b7c31U,
    0x569cd235U,
    0x13922100U,
    0x615f7ab7U,
    0x58f56dcaU,
    0x92afaa07U,
    0x7ddfad11U,
    0xf93750b8U,
    0x52cf80e5U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x88000000U,
    0xec000000U,
    0xc2000000U,
    0xe9000000U,
    0xc2800000U,
    0x95400000U,
    0x7ea00000U,
    0x65f00000U,
    0xf180000U,
    0xa41c0000U,
    0xcf9e0000U,
    0xb85f0000U,
    0x43bf8000U,
    0xd0ebc000U,
    0x5604a000U,
    0x3f06b000U,
    0xbd83f800U,
    0x8c4ec00U,
    0x6660c600U,
    0x8b977300U,
    0x688b3c80U,
    0xe915440U,
    0x280d3ca0U,
    0x52d25450U,
    0x842cbca8U,
    0x2a669454U,
    0x19979c8aU,
    0x298be46fU,
    0x3010c4baU,
    0xf749b855U,
    0x2973fa8aU,
    0xe15a2770U,
    0x59380015U,
    0x1ac0029U,
    0x16a60036U,
    0xf9f30010U,
    0x7519800dU,
    0x3918c03aU,
    0xab1d203fU,
    0xea1e7035U,
    0xd49ed81aU,
    0xbda9c00U,
    0x707e1e05U,
    0x150def27U,
    0x66552283U,
    0x7e6cbb5cU,
    0x41401e3aU,
    0x88a2ef26U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x38000000U,
    0xa4000000U,
    0xd6000000U,
    0x35000000U,
    0x37800000U,
    0x1f400000U,
    0xbd200000U,
    0x78100000U,
    0xeef80000U,
    0xf5fc0000U,
    0x337e0000U,
    0x5dbf0000U,
    0x42da8000U,
    0x2c6b4000U,
    0xd7c66000U,
    0x92e4d000U,
    0x2ef77800U,
    0x860fc400U,
    0xcef6be00U,
    0x560c9700U,
    0x66f57780U,
    0x7a0e3040U,
    0x2cf377a0U,
    0x3d0d3050U,
    0xf877f7a8U,
    0x20c9707cU,
    0x6d9317a6U,
    0xfabae055U,
    0x465c0f93U,
    0x99aef458U,
    0x6e27499eU,
    0x296e75fU,
    0x423ae031U,
    0x319c9001U,
    0xfb4d982aU,
    0x58d3542cU,
    0x909b262eU,
    0x62cfc317U,
    0xf69651b0U,
    0x7c3df375U,
    0x89b2610U,
    0x36cfc30cU,
    0x389651beU,
    0x5d3df356U,
    0xd11b2604U,
    0xb88fc308U,
    0x643651b5U,
    0xf6df373U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0xf8000000U,
    0x74000000U,
    0xea000000U,
    0x3000000U,
    0xb6800000U,
    0xf2c00000U,
    0x8e600000U,
    0x84b00000U,
    0xb8c80000U,
    0x19cc0000U,
    0xe04a0000U,
    0x5a090000U,
    0xffa88000U,
    0xb8ff4000U,
    0xb4c4e000U,
    0x8367b000U,
    0x7331a800U,
    0x438f1c00U,
    0xb5ed0a00U,
    0x8558b900U,
    0xb7943c80U,
    0x9d5b2ac0U,
    0x33963ca0U,
    0xef5e2af0U,
    0x7494bcb8U,
    0x4bd86afcU,
    0xf150dc86U,
    0x993c9ae1U,
    0x842794bcU,
    0x191136e1U,
    0xeb99b691U,
    0xcff0d3ddU,
    0x2cece032U,
    0x68dbb03cU,
    0xd7d3a83cU,
    0xc3fa1c0aU,
    0xb6478a1cU,
    0xfba2f910U,
    0xce525c9dU,
    0x89badae3U,
    0x8be3f4aaU,
    0xf8f5c6f3U,
    0xd06efe83U,
    0xc91d7fd3U,
    0x2732c233U,
    0x398a550eU,
    0x1eeefeaaU,
    0x8fdd7fdfU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0xb8000000U,
    0xc000000U,
    0x2000000U,
    0xa7000000U,
    0xed800000U,
    0x9fc00000U,
    0xe2600000U,
    0xf0100000U,
    0x60480000U,
    0x694c0000U,
    0xb1ce0000U,
    0xfc8f0000U,
    0xb0a98000U,
    0x871c4000U,
    0x5e242000U,
    0x48b03000U,
    0xc8bf0800U,
    0xe3556400U,
    0x71691a00U,
    0x387cc900U,
    0xc8b6a980U,
    0x88bbfbc0U,
    0xc350a9a0U,
    0xa168fbd0U,
    0x807f29a8U,
    0xc4b7bbe4U,
    0x8abc8986U,
    0x6454cbe7U,
    0x4cee2186U,
    0x1fbddfceU,
    0x26d413bdU,
    0x7aa842e9U,
    0x41aa805U,
    0x25a51415U,
    0xae74323dU,
    0xda5a9d1fU,
    0xca073b99U,
    0x830116d4U,
    0x7b82ba3bU,
    0xe6c3b926U,
    0x12e20184U,
    0x2951eff9U,
    0xf26d1b8bU,
    0x43fe26c1U,
    0x2e743209U,
    0x9a5a9d2dU,
    0xea073b96U,
    0x530116c8U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x28000000U,
    0xbc000000U,
    0x82000000U,
    0x7b000000U,
    0x89800000U,
    0xc3c00000U,
    0xbe00000U,
    0x7700000U,
    0xed380000U,
    0xf83c0000U,
    0x70be0000U,
    0x45fb0000U,
    0x225a8000U,
    0x800bc000U,
    0xad262000U,
    0xc163000U,
    0x530fe800U,
    0xd8a2a400U,
    0xedd33a00U,
    0x13ed2500U,
    0x7e507e80U,
    0x7f2dc740U,
    0x62367ea0U,
    0x729ac750U,
    0x5e6afe88U,
    0x7b96075cU,
    0x89c85e82U,
    0xb1c0f773U,
    0xb8e316a2U,
    0xa2f3a36dU,
    0xb4ffe480U,
    0x1cdd125dU,
    0xc04fc802U,
    0x9203941cU,
    0x23005219U,
    0xbd834132U,
    0xcdc1e4adU,
    0xdae6126fU,
    0x49f5480fU,
    0x25785430U,
    0x4b1e720cU,
    0xf5a97131U,
    0x6c700c98U,
    0x3cbfb654U,
    0xffcf22bU,
    0x755eb130U,
    0x93882c85U,
    0x81e28663U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0x68000000U,
    0x84000000U,
    0xba000000U,
    0xed000000U,
    0xe9800000U,
    0x6bc00000U,
    0x58200000U,
    0xfad00000U,
    0x7e180000U,
    0x379c0000U,
    0x6c5a0000U,
    0x7c7b0000U,
    0xf2ac8000U,
    0x5eb7c000U,
    0x2fe000U,
    0x3ff03000U,
    0xc54c5800U,
    0x86479400U,
    0x49e30a00U,
    0x6ff62b00U,
    0x9d4dcd80U,
    0x4a406540U,
    0x87e14da0U,
    0x50f7a570U,
    0x1dceada8U,
    0x7207954cU,
    0x5902f5b2U,
    0x1b80016dU,
    0xf2c1ff9cU,
    0x63a62a56U,
    0xf8143226U,
    0x75ba4f0cU,
    0x4b8f7f90U,
    0xa3e6ea42U,
    0xdaf55227U,
    0xb8cabf03U,
    0xef82478eU,
    0xe0c18e71U,
    0x2aa3602eU,
    0x5b97f030U,
    0x9b7bb808U,
    0x7e2ba433U,
    0x88f55229U,
    0x11cabf10U,
    0x9c0247bcU,
    0x96018e78U,
    0xf303603dU,
    0x4e87f017U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x98000000U,
    0x1c000000U,
    0xca000000U,
    0xe7000000U,
    0x4d800000U,
    0xb8400000U,
    0xaca00000U,
    0xd0f00000U,
    0x40180000U,
    0xfd9c0000U,
    0xadda0000U,
    0x357f0000U,
    0xbb8f8000U,
    0x52934000U,
    0xd38fa000U,
    0xa693f000U,
    0x2d8bc800U,
    0x1f962400U,
    0xc908a600U,
    0xdb566300U,
    0xbd6d1480U,
    0xb5c5dc40U,
    0x74e294a0U,
    0xcc569c70U,
    0x18ed3488U,
    0x39856c74U,
    0x8646fcaeU,
    0xb5a34873U,
    0x24765a9cU,
    0x1cd92b4aU,
    0x95f94e0fU,
    0x94ff724U,
    0x1bf65a84U,
    0x8f992b60U,
    0x86d94e1cU,
    0x8afff72bU,
    0xe8ce5a99U,
    0xe1b52b55U,
    0x403b4e2bU,
    0xcdacf70bU,
    0x5fa3da90U,
    0x13756b46U,
    0x69596e3fU,
    0x21bf4711U,
    0xf7ea32b9U,
    0x3000ff48U,
    0x48002009U,
    0x2400b007U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x78000000U,
    0xc4000000U,
    0x5a000000U,
    0xa3000000U,
    0xd8800000U,
    0xbf400000U,
    0xfde00000U,
    0xc900000U,
    0x50e80000U,
    0x146c0000U,
    0xe52e0000U,
    0x39cb0000U,
    0x1adf8000U,
    0xff44000U,
    0x3e3e6000U,
    0xa8e2b000U,
    0xd114a800U,
    0xaa29ec00U,
    0xe74a5600U,
    0xa89ed900U,
    0x3b948d80U,
    0x4a6f62c0U,
    0xfc2b0da0U,
    0x724b22d0U,
    0x951d6d88U,
    0xf15592f4U,
    0x514fc596U,
    0xd9b7ec5U,
    0xee141380U,
    0x3caae7edU,
    0x79097e36U,
    0x7aff7502U,
    0x72c6bba9U,
    0x3f240bd1U,
    0x9bb2a835U,
    0xd75eec20U,
    0xcd33d61aU,
    0xa91d992bU,
    0x2f536dbcU,
    0x84e92d5U,
    0xe61845adU,
    0xf1d33ed9U,
    0xba0c73aeU,
    0xd27f57d3U,
    0x85845614U,
    0xeec5d921U,
    0x71230dbeU,
    0xbab722c3U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x98000000U,
    0xa4000000U,
    0x3e000000U,
    0x59000000U,
    0x2e800000U,
    0x9bc00000U,
    0xd200000U,
    0x2e900000U,
    0x89c80000U,
    0x394c0000U,
    0x4b8a0000U,
    0x802d0000U,
    0x99798000U,
    0x1f954000U,
    0xcb4c6000U,
    0x408f9000U,
    0x15ac5800U,
    0x7f3eac00U,
    0x58f23200U,
    0xa0bfbb00U,
    0x61b01f80U,
    0x445a69c0U,
    0x89019fa0U,
    0x968329f0U,
    0x4fc7ff98U,
    0x3b21b9d4U,
    0x4b9227beU,
    0x3d4a55fdU,
    0xc58c75b1U,
    0x312a7eebU,
    0x1bf8323aU,
    0x8652bb0dU,
    0x5699f99U,
    0x279f29f6U,
    0x7025ffa3U,
    0xfe10b9ecU,
    0xab09a7afU,
    0x8aee15c1U,
    0x66db95a0U,
    0xa0c1aef9U,
    0xb0a38a16U,
    0x84d7c719U,
    0x5ca815bbU,
    0x9b9eedbU,
    0x87366a14U,
    0x39d1722U,
    0x8e202d82U,
    0x4714d2e0U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x58000000U,
    0xb4000000U,
    0xfe000000U,
    0x55000000U,
    0xc2800000U,
    0x6dc00000U,
    0x67a00000U,
    0x1dd00000U,
    0xf8e80000U,
    0xf46c0000U,
    0xc4ae0000U,
    0x2d8b0000U,
    0x79b8000U,
    0x6bd14000U,
    0xa1e8e000U,
    0xcce91000U,
    0x4a6cb800U,
    0x31af2c00U,
    0xff0e0200U,
    0x325a5f00U,
    0xb870e180U,
    0x423e7ec0U,
    0x610361a0U,
    0x7c833ed0U,
    0x98c58188U,
    0xb5212ed4U,
    0x2812b99eU,
    0x2b4f42f9U,
    0x17bc5ba1U,
    0x69400decU,
    0x1b660211U,
    0xaef65f37U,
    0x21fee1a8U,
    0xbba57ee0U,
    0x5fd0e19eU,
    0x1fee7ec9U,
    0x39eb6191U,
    0x98ef3eebU,
    0x46b81b9U,
    0x2caa2ec9U,
    0xd189399eU,
    0x159e02f4U,
    0x74d4bba5U,
    0xc8691de4U,
    0x36aaba3dU,
    0x82897312U,
    0x2618e3bcU,
    0x7d9321e4U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x68000000U,
    0xa4000000U,
    0x2000000U,
    0xcf000000U,
    0xd9800000U,
    0x92400000U,
    0x26e00000U,
    0x6bd00000U,
    0x55880000U,
    0x360c0000U,
    0xf74a0000U,
    0x56290000U,
    0x5ebe8000U,
    0xf555c000U,
    0x8a4ce000U,
    0x88aef000U,
    0x217d8800U,
    0xdbf7c400U,
    0xc47b9600U,
    0xc976c100U,
    0x1db9af80U,
    0x2ad3ebc0U,
    0x450f2fa0U,
    0x20ca2bf0U,
    0xcd69cfb8U,
    0x9cdddbccU,
    0x7242c7a2U,
    0x16e3dfe5U,
    0x63d7b1a2U,
    0x18eeed6U,
    0x5c0f1614U,
    0x9c4a0132U,
    0x8dabcfbdU,
    0x3f8dbd8U,
    0xa364790U,
    0x73df1fd9U,
    0xfbc5d1afU,
    0x7ca5ded9U,
    0x79367e22U,
    0xa45f353eU,
    0x6087d196U,
    0xbec0defbU,
    0xfe22fe19U,
    0x38f3f53fU,
    0x8bfdb196U,
    0x9e37eeffU,
    0x79d9961bU,
    0x60c3c13bU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x68000000U,
    0xc4000000U,
    0x2a000000U,
    0x1f000000U,
    0x62800000U,
    0xc7c00000U,
    0xb0600000U,
    0xb8f00000U,
    0xdee80000U,
    0x126c0000U,
    0x40aa0000U,
    0xdd490000U,
    0x98f88000U,
    0x9db3c000U,
    0x6949e000U,
    0x7afab000U,
    0x16b74800U,
    0x79cadc00U,
    0xe3c2200U,
    0x2a51c100U,
    0x33fdf680U,
    0x1d3269c0U,
    0x258d76a0U,
    0xda1da9f0U,
    0xda8696b8U,
    0x9bc219fcU,
    0x56635ea2U,
    0x79f205cdU,
    0xe16e1ca8U,
    0x6c2ab4caU,
    0x7f8d4230U,
    0xd18b13bU,
    0x2c035ebcU,
    0x2e0205e5U,
    0x55061cb3U,
    0x4d86b4ddU,
    0xcd474221U,
    0xb3a1b117U,
    0x2293deb7U,
    0x791dc5f6U,
    0xae05fc87U,
    0x950504e2U,
    0x2d808a34U,
    0xfd44ad1eU,
    0xdba41c9cU,
    0xe693b4f8U,
    0x531dc21dU,
    0xb1077106U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x38000000U,
    0xac000000U,
    0x12000000U,
    0x8d000000U,
    0x42800000U,
    0x90c00000U,
    0x84600000U,
    0x5d00000U,
    0x1de80000U,
    0x596c0000U,
    0x3aaa0000U,
    0x434b0000U,
    0x29da8000U,
    0x5a134000U,
    0xbe0a2000U,
    0xaf8b000U,
    0x85e3d800U,
    0x90954c00U,
    0x7acf8a00U,
    0x109a0900U,
    0x2f305780U,
    0x7af880c0U,
    0x5de2d7a0U,
    0x2c97c0f0U,
    0x60caf7a8U,
    0x99870fcU,
    0xd3b1afa6U,
    0x75397cd7U,
    0x160485a2U,
    0xfb0385f4U,
    0x6987aa32U,
    0xd145b910U,
    0xf1230fb3U,
    0x72f58ce1U,
    0x5c1dfd9cU,
    0xd8f639cbU,
    0xbd1b5814U,
    0xa8710c3cU,
    0x90dd2a34U,
    0x5696f912U,
    0xa9c92f87U,
    0xdd1d3cdbU,
    0x787625b9U,
    0xb8df75c1U,
    0xf296d20dU,
    0x2fcc053dU,
    0xee1dfdb1U,
    0xa5f639daU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x78000000U,
    0xcc000000U,
    0x2e000000U,
    0xd5000000U,
    0xbe800000U,
    0xd4c00000U,
    0x57600000U,
    0x8d500000U,
    0x6ad80000U,
    0x1e5c0000U,
    0xa59a0000U,
    0x8b7d0000U,
    0xff6d8000U,
    0xc9964000U,
    0x85bc2000U,
    0xbf0f5000U,
    0xf140f800U,
    0x38268c00U,
    0x28756a00U,
    0xb82d7100U,
    0xf8b28b80U,
    0x454fc540U,
    0xcae70ba0U,
    0xce158570U,
    0xf1f92b98U,
    0x61abd574U,
    0x31f65386U,
    0x916a1947U,
    0x3c90998dU,
    0xcb3f7872U,
    0x3c94a22U,
    0x12222107U,
    0x57727397U,
    0xb9a94954U,
    0xcdf26195U,
    0x3768f467U,
    0x4d93a01aU,
    0xefb81032U,
    0xe00b5810U,
    0xc29c36U,
    0x6564322dU,
    0xee52ed1dU,
    0xdd5b39b5U,
    0x221b6876U,
    0x3f38121bU,
    0xc1cdbd39U,
    0x1923c1a1U,
    0x54f1e44cU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0xc8000000U,
    0x8c000000U,
    0x86000000U,
    0x8d000000U,
    0x11800000U,
    0x66400000U,
    0xb1e00000U,
    0x16d00000U,
    0x33680000U,
    0x63ec0000U,
    0xf22a0000U,
    0x988f0000U,
    0x763b8000U,
    0x71c5c000U,
    0x9aa5a000U,
    0x16b79000U,
    0xd3fef800U,
    0x2966f400U,
    0xb118600U,
    0xdfcb6900U,
    0x5a6f80U,
    0xe4535cc0U,
    0x15abefa0U,
    0x4bc99cf0U,
    0xa25dcf88U,
    0x5357ccd4U,
    0x572c97baU,
    0xf509a8f7U,
    0x6e78699bU,
    0x9921f5d4U,
    0x5ff6201fU,
    0xc49e500dU,
    0x1b715813U,
    0x375e6438U,
    0x66d4fe37U,
    0xb685d04U,
    0x17ee49b9U,
    0xa02fa5c1U,
    0xd78f7825U,
    0xe0bc340eU,
    0xd07a60fU,
    0xd1853906U,
    0xc643378dU,
    0x21e138ceU,
    0xded511b0U,
    0xbf6ec1d1U,
    0xe5e80601U,
    0x7f2da910U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x78000000U,
    0x84000000U,
    0x36000000U,
    0xb5000000U,
    0x2e800000U,
    0x15c00000U,
    0xdc200000U,
    0xdb700000U,
    0x2a480000U,
    0x5cc0000U,
    0xb08a0000U,
    0x28690000U,
    0x87bc8000U,
    0xae474000U,
    0xf7676000U,
    0xba90d000U,
    0x611e7800U,
    0x3ef68c00U,
    0x980fe200U,
    0x30ac2300U,
    0x911bc880U,
    0xe6f272c0U,
    0xcc0d48a0U,
    0xceac32f0U,
    0xd81ea8b8U,
    0x7a77a2dcU,
    0x5acdb0a6U,
    0x8908fefdU,
    0x3828aaabU,
    0x99d911d0U,
    0x5851e020U,
    0xc8be9015U,
    0x3fc59837U,
    0xab211c13U,
    0x6ef6fa25U,
    0x900a7f3eU,
    0xacaa5297U,
    0x9318ddd5U,
    0x1df1621bU,
    0xd38e6323U,
    0xc3ea2895U,
    0xa4fce2d4U,
    0x53a0d09cU,
    0xbe312ed0U,
    0x7aaa52bbU,
    0x5618ddfdU,
    0x2b71622bU,
    0xf24e6307U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xc8000000U,
    0xfc000000U,
    0xde000000U,
    0x89000000U,
    0xa0800000U,
    0xccc00000U,
    0x58200000U,
    0x60b00000U,
    0xe3380000U,
    0x1ebc0000U,
    0xfa0000U,
    0x9b1f0000U,
    0x8e0e8000U,
    0x8bc0c000U,
    0x49a32000U,
    0x98f3d000U,
    0x65da9800U,
    0xb92a1c00U,
    0x56f43a00U,
    0xd4d81b00U,
    0x8dae6e80U,
    0x88307f40U,
    0x13faeea0U,
    0x389fbf70U,
    0xd94f4e88U,
    0x10a0af7cU,
    0xa074f6baU,
    0xd1a6343U,
    0x3b0ed48dU,
    0x5547a461U,
    0x3c612025U,
    0xa850d012U,
    0x35ae1813U,
    0xdc35dc3aU,
    0xa1f99a03U,
    0x979b0b31U,
    0xc4cfd6b1U,
    0x5ee5b368U,
    0x63964c85U,
    0x1c0eb858U,
    0xd4c19a17U,
    0x3c270b01U,
    0x1ab5d68aU,
    0xb03ab378U,
    0xdd38cc98U,
    0xc7be7854U,
    0xf87aba09U,
    0x53d8db10U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x28000000U,
    0xe4000000U,
    0xc6000000U,
    0x3b000000U,
    0xcd800000U,
    0xbd400000U,
    0xab600000U,
    0xf7100000U,
    0x73780000U,
    0xe3fc0000U,
    0x783a0000U,
    0xab9b0000U,
    0xbeab8000U,
    0x7fa2c000U,
    0xc731e000U,
    0x2409d000U,
    0x92150800U,
    0x99f9e400U,
    0xb93e4e00U,
    0x671bb500U,
    0xef6afd80U,
    0x95065e40U,
    0xf2837da0U,
    0x86c39e70U,
    0x15231da8U,
    0x5df38e74U,
    0x1b2c75a2U,
    0xc6e17a4dU,
    0x9a56d393U,
    0xd01afb43U,
    0xe0ef6820U,
    0xe542f42cU,
    0x9762a62aU,
    0xcd178121U,
    0x527bbbbeU,
    0x1f7f0f5dU,
    0x11fc4e0aU,
    0x8d3cb53eU,
    0xa91b7dbcU,
    0x206f9e5bU,
    0xb6811d9cU,
    0x90c48e70U,
    0x2625f5a1U,
    0x6474ba58U,
    0x486eb39bU,
    0xb286eb61U,
    0x66c20016U,
    0x25270032U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x58000000U,
    0x54000000U,
    0x32000000U,
    0x93000000U,
    0x77800000U,
    0x71c00000U,
    0x58a00000U,
    0x3b900000U,
    0xe0380000U,
    0x6bc0000U,
    0xbfa0000U,
    0xa11f0000U,
    0x31ea8000U,
    0x79e04000U,
    0x8776e000U,
    0x29c97000U,
    0x4e34e800U,
    0x9928d400U,
    0xe1c69a00U,
    0x70a47f00U,
    0x97907380U,
    0x363b0a40U,
    0xffb8f3a0U,
    0xbb784a70U,
    0x955e9388U,
    0x8b8e7a5cU,
    0x6d561b9eU,
    0x2d1f9e49U,
    0x97ea8992U,
    0x78e6456dU,
    0xd3f2880fU,
    0x778ee431U,
    0x33561239U,
    0xc8199b0fU,
    0xa96ee1a9U,
    0xe1a1d162U,
    0xeb10721dU,
    0xc47fab2fU,
    0x54de6995U,
    0x134c3549U,
    0x6d76e037U,
    0x2ec97016U,
    0xabb4e820U,
    0xcbe8d413U,
    0x96e69a0fU,
    0x6ef47f0fU,
    0x1d0873b9U,
    0x98170a49U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x28000000U,
    0xd4000000U,
    0xb6000000U,
    0xcd000000U,
    0xaa800000U,
    0xfc00000U,
    0x5a600000U,
    0x61d00000U,
    0xdef80000U,
    0x977c0000U,
    0xa33a0000U,
    0xae190000U,
    0x396e8000U,
    0x47a7c000U,
    0xa8b56000U,
    0x6caed000U,
    0xaac7b800U,
    0x84e76c00U,
    0x48135200U,
    0x919ba100U,
    0xa02fdf80U,
    0x1006a040U,
    0x18035fa0U,
    0x9c046070U,
    0x9202bfb8U,
    0x5304704cU,
    0xb386e7b2U,
    0x13460c79U,
    0x98a56d9fU,
    0x9131114aU,
    0xb0ead835U,
    0x13e5bc09U,
    0x5596ea03U,
    0xd3d9cd21U,
    0x80dacU,
    0xddf3c178U,
    0x410f602eU,
    0xfd77d016U,
    0x81c93835U,
    0x8690ac38U,
    0xa05e3227U,
    0x73497129U,
    0xb55267bcU,
    0xf838cc56U,
    0x999e8dbeU,
    0x24280157U,
    0x1e00001aU,
    0xd900001fU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x58000000U,
    0x54000000U,
    0xc6000000U,
    0x4f000000U,
    0x1f800000U,
    0x94400000U,
    0xfae00000U,
    0xe2d00000U,
    0xa4b80000U,
    0xe63c0000U,
    0xa4fe0000U,
    0x7ad90000U,
    0x192e8000U,
    0x69e44000U,
    0x6752e000U,
    0xa5fed000U,
    0x765fa800U,
    0x48ead400U,
    0x7243b600U,
    0xe5e54100U,
    0xb554a780U,
    0xccfe5a40U,
    0xd6dc27a0U,
    0x9b2f1a50U,
    0x48e64798U,
    0x3bd08a6cU,
    0xbc3b8f8eU,
    0x91f9ce79U,
    0x5bf1bfU,
    0xbfeccb6aU,
    0xc9c1a838U,
    0xefa3d40fU,
    0x54b53626U,
    0xf7ad0127U,
    0xa92047b7U,
    0x98758a62U,
    0x9a8b0fa8U,
    0x1f548e79U,
    0xa1ff91a7U,
    0xf85a5b4cU,
    0xfbeae02fU,
    0xa7c2d015U,
    0xaca1a81dU,
    0xd933d43cU,
    0xeaed3617U,
    0x3410125U,
    0xf16647bbU,
    0x50908a65U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0x48000000U,
    0x54000000U,
    0x5a000000U,
    0xaf000000U,
    0xe2800000U,
    0x6cc00000U,
    0xe7e00000U,
    0xa5900000U,
    0xd9780000U,
    0xcafc0000U,
    0x59ba0000U,
    0xbb190000U,
    0x75298000U,
    0x31e3c000U,
    0x8c956000U,
    0xfaf9b000U,
    0xa1bbc800U,
    0xd71a5c00U,
    0x23287a00U,
    0xd8e56500U,
    0xcf14d980U,
    0x81bbca40U,
    0x671f59a0U,
    0x1b2d0a70U,
    0xd4e1b9b8U,
    0x89127a74U,
    0x20bc91aaU,
    0x709b5661U,
    0x3a6bc3bcU,
    0xbd421f4aU,
    0xa7a3c804U,
    0xbbb65c11U,
    0xc68a7a1dU,
    0x70506508U,
    0x951f59b3U,
    0x302d0a7eU,
    0x4461b997U,
    0xed27a75U,
    0x37dc9184U,
    0x42cb5656U,
    0xbc73c38dU,
    0x11ee1f66U,
    0x2201c80aU,
    0x3035c11U,
    0xd481fa2cU,
    0x95c6a53eU,
    0xec61b9a8U,
    0x8ad27a5dU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x78000000U,
    0x84000000U,
    0xf2000000U,
    0x79000000U,
    0x7d800000U,
    0x6bc00000U,
    0x8ce00000U,
    0xce900000U,
    0x83380000U,
    0xe1bc0000U,
    0xb4fe0000U,
    0xcb5d0000U,
    0x196a8000U,
    0x40e14000U,
    0xe0916000U,
    0x1c3cf000U,
    0x9f383800U,
    0x27be5400U,
    0x27fdca00U,
    0xbbda0d00U,
    0x85282980U,
    0x5ac3d840U,
    0x2d64a9a0U,
    0x43539850U,
    0xcd949b8U,
    0xd7af286cU,
    0x578491a6U,
    0x46c1cc4dU,
    0xeb62839aU,
    0xd0542553U,
    0x7c583805U,
    0x4bee5409U,
    0x4da5ca06U,
    0x8b360d2aU,
    0xb40e29beU,
    0x43b2d86eU,
    0x8c4829adU,
    0x3b93d86dU,
    0xb0bca98fU,
    0xe57f985fU,
    0x3e9f49b6U,
    0x128e2863U,
    0x84f0118eU,
    0x7aed8c47U,
    0xec2163b8U,
    0x6f5954bU,
    0x3bef6017U,
    0x75a1f01cU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0xf8000000U,
    0x3c000000U,
    0x8e000000U,
    0x1d000000U,
    0xac800000U,
    0x61c00000U,
    0x90e00000U,
    0xaf900000U,
    0xac80000U,
    0x314c0000U,
    0x330e0000U,
    0x4daf0000U,
    0xca9b8000U,
    0xf6644000U,
    0x2151a000U,
    0x85afd000U,
    0xde9a3800U,
    0x9c61dc00U,
    0x1e501200U,
    0x422bf500U,
    0x32d83980U,
    0x4fc7e7c0U,
    0x5de5b9a0U,
    0xdb10a7d0U,
    0xc70999a8U,
    0xd7a837f4U,
    0xbd9f8196U,
    0x65e17bfbU,
    0x87118bb5U,
    0xf90fc2fcU,
    0xa2a9b81eU,
    0xd5199c24U,
    0xb627b21aU,
    0x84f7251fU,
    0xe71f8190U,
    0x65217bf7U,
    0x15718b82U,
    0xba5fc2fbU,
    0x6c01b81bU,
    0x16059c25U,
    0x9101b226U,
    0x4a842503U,
    0xb8c2019eU,
    0x8e663becU,
    0x5d55abaeU,
    0x2bab52f7U,
    0x5399a021U,
    0xc8e3d03fU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0xb8000000U,
    0x74000000U,
    0xbe000000U,
    0x97000000U,
    0xa3800000U,
    0xb5c00000U,
    0x50e00000U,
    0x65700000U,
    0x5cd80000U,
    0xaa5c0000U,
    0x691a0000U,
    0x3abd0000U,
    0xec6d8000U,
    0x76604000U,
    0xfe37e000U,
    0x6b7c1000U,
    0x7a8ba800U,
    0x10103400U,
    0xaf6b5a00U,
    0x5be0fd00U,
    0x94f6e680U,
    0x441a9840U,
    0xd83966a0U,
    0x412bd870U,
    0xeac10698U,
    0xef668874U,
    0x42b2ceb6U,
    0x413bec69U,
    0xfdaa5c99U,
    0xc086754cU,
    0x68442831U,
    0x92217421U,
    0x86133a05U,
    0x346dad08U,
    0xd2652eaaU,
    0x1837fc66U,
    0x9879f4beU,
    0xdf0a4145U,
    0x46d57212U,
    0xe20c8939U,
    0x1c505c8bU,
    0x3b4b7563U,
    0x3ef1a836U,
    0xbd1d342fU,
    0xb4beda14U,
    0x336cbd17U,
    0x9e30686U,
    0x39f7886dU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0x48000000U,
    0x74000000U,
    0x9e000000U,
    0x5b000000U,
    0x3f800000U,
    0xe3400000U,
    0xa1a00000U,
    0x52300000U,
    0xa6180000U,
    0xb55c0000U,
    0x1cfe0000U,
    0xdac90000U,
    0x92d28000U,
    0x348cc000U,
    0x63f16000U,
    0xc47c9000U,
    0xac0cc800U,
    0xf531f400U,
    0xd39f8e00U,
    0x31a1300U,
    0xe1da4a80U,
    0x683f8e40U,
    0x9c2b2aa0U,
    0xb7431e50U,
    0xefa7e298U,
    0xd132ea4cU,
    0xd5986c8aU,
    0xf418f951U,
    0xc5a262dU,
    0x727b7707U,
    0xb30f0c82U,
    0xfcb1696fU,
    0x6fda6e32U,
    0x4b3f4337U,
    0x7fab6291U,
    0xce072a4bU,
    0xc3038cbbU,
    0x9384a97aU,
    0x31418e1dU,
    0x58a31318U,
    0xdcb0cab7U,
    0xbfdf4e5eU,
    0x933c4aadU,
    0x33aa8e78U,
    0x6c07aabaU,
    0x7206de4eU,
    0x69040295U,
    0xb682ba5dU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x68000000U,
    0x94000000U,
    0xb2000000U,
    0x49000000U,
    0x4a800000U,
    0x77400000U,
    0xeea00000U,
    0xd0f00000U,
    0x10680000U,
    0xb72c0000U,
    0x618e0000U,
    0x5d7b0000U,
    0xb3168000U,
    0x339c000U,
    0x47336000U,
    0xdc8df000U,
    0xf5f93800U,
    0xf552ac00U,
    0xeb1a7600U,
    0xae84f300U,
    0x4d414c80U,
    0x23a263c0U,
    0xf0722ca0U,
    0xd22f93d0U,
    0x350b1488U,
    0x3d3d3ffcU,
    0xa0316292U,
    0xe909ccd9U,
    0xeb382e3eU,
    0x9337af0bU,
    0xce8c028cU,
    0xcff3cc6U,
    0xd7d7963fU,
    0x85cc30eU,
    0xf22514a9U,
    0xd4b63ffaU,
    0x794fe28fU,
    0x301c0ce6U,
    0x5d054e2fU,
    0xb8815f20U,
    0x9e43ba81U,
    0x142450d9U,
    0xcfb68035U,
    0x6ac9c00eU,
    0xd5db6028U,
    0x38e1f02fU,
    0xa0d7382eU,
    0xa5d9ac32U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x28000000U,
    0xec000000U,
    0x6e000000U,
    0xff000000U,
    0x6f800000U,
    0x72c00000U,
    0xfd600000U,
    0xed00000U,
    0x83680000U,
    0x89ac0000U,
    0xca0000U,
    0x41f0000U,
    0x8a748000U,
    0xd559c000U,
    0xdbd4a000U,
    0x51e8d000U,
    0xa5eba800U,
    0x6fe91400U,
    0xc2ea2200U,
    0x646b1900U,
    0x4229c780U,
    0x200d48c0U,
    0x307d67a0U,
    0xd02598f0U,
    0xc976cf88U,
    0x4cdc8cecU,
    0x3214ed82U,
    0x310b95d7U,
    0x60ff2a19U,
    0x6d65dd28U,
    0x36d4cda2U,
    0x976a85c4U,
    0x53a82215U,
    0x55c8192bU,
    0x169f47b7U,
    0x63788deU,
    0xca7f47aeU,
    0x352788f7U,
    0x53f747aeU,
    0x5c9b88c6U,
    0x6b3547adU,
    0xccf888c9U,
    0x6363c79bU,
    0x19d248d0U,
    0xa0e9e7afU,
    0xe56c58f5U,
    0x2aaa6f82U,
    0x89485ce8U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0xd8000000U,
    0x2c000000U,
    0xbe000000U,
    0x41000000U,
    0xa2800000U,
    0xd0c00000U,
    0x71600000U,
    0xed900000U,
    0x76580000U,
    0x6a9c0000U,
    0xb5fe0000U,
    0x916f0000U,
    0xc1b48000U,
    0x31ee4000U,
    0x26712000U,
    0x70bd000U,
    0x83a55800U,
    0xdbf20c00U,
    0x44baa00U,
    0x7884f100U,
    0xcbc64580U,
    0x88e3bb40U,
    0xe4d765a0U,
    0x7e786b50U,
    0x572a3da8U,
    0xd216674cU,
    0x221f979eU,
    0x863d9647U,
    0x458d5231U,
    0x43606d17U,
    0x229317b9U,
    0x6ddfd673U,
    0x44da720dU,
    0x7258bd04U,
    0x609ccf8eU,
    0x46fc9a59U,
    0xbcec7812U,
    0x2af5dc2aU,
    0x1ec8f23bU,
    0xd445fd05U,
    0xaca76f97U,
    0xd0760a4cU,
    0xa20c8027U,
    0x3b224024U,
    0x70372025U,
    0xdca8d017U,
    0x3457d81dU,
    0x41bf4c1fU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0xd8000000U,
    0x84000000U,
    0xc6000000U,
    0xaf000000U,
    0x19800000U,
    0xe4400000U,
    0x29600000U,
    0x73b00000U,
    0x81280000U,
    0x96c0000U,
    0xfa0e0000U,
    0x44bf0000U,
    0x5128000U,
    0x86b84000U,
    0x2c126000U,
    0x103b5000U,
    0x61d4a800U,
    0x5182400U,
    0xbf076600U,
    0x31807d00U,
    0x9844c880U,
    0xdb6525c0U,
    0xc2b6a8a0U,
    0xb3ae75d0U,
    0x32aa00a8U,
    0x982a51fcU,
    0x7eb669eU,
    0x13c92cddU,
    0x279b2e2fU,
    0xacc74936U,
    0x2fa36689U,
    0x29152cdfU,
    0x7cbd2e2bU,
    0x5114493fU,
    0x8bfe695U,
    0x6f126ce0U,
    0x93bdce04U,
    0x68975907U,
    0x5cf92eacU,
    0x9e7118e9U,
    0x640e0004U,
    0x2fbf003eU,
    0xfa92801fU,
    0x7df8402eU,
    0xc4f2602dU,
    0x3cb5032U,
    0xf9ca81fU,
    0xd0c42419U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0x68000000U,
    0x94000000U,
    0x3e000000U,
    0x63000000U,
    0x88800000U,
    0x66400000U,
    0xe4600000U,
    0xf0500000U,
    0xab980000U,
    0xe3dc0000U,
    0x6cba0000U,
    0x706f0000U,
    0xbbb58000U,
    0x230ac000U,
    0x9d646000U,
    0x7dd29000U,
    0x2a580800U,
    0x7b7c8c00U,
    0xbfccde00U,
    0x8e40ed00U,
    0xb067a780U,
    0x6e511740U,
    0x989bc7a0U,
    0x35f8770U,
    0x9ef9cf88U,
    0xaa0c0b64U,
    0x28e09192U,
    0x162641U,
    0x18fb561dU,
    0xf509a119U,
    0xaa62999fU,
    0x6b55aa70U,
    0x7f1a082eU,
    0x7f9f8c28U,
    0xbddb5e16U,
    0xffb92d11U,
    0xc0ec47b0U,
    0x21f64764U,
    0x6d6a2f89U,
    0x30375b78U,
    0x3dcb7992U,
    0x2741fa4eU,
    0x95e46033U,
    0xdb929028U,
    0x6e38083bU,
    0xdb2c8c3bU,
    0x7c54de02U,
    0xf99ced01U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0xb8000000U,
    0x4c000000U,
    0xd6000000U,
    0x55000000U,
    0x8d800000U,
    0x82c00000U,
    0x3fa00000U,
    0x1c300000U,
    0xd280000U,
    0x21ec0000U,
    0x274e0000U,
    0x70fd0000U,
    0x62168000U,
    0x5df4000U,
    0x26632000U,
    0xe7109000U,
    0x6058b800U,
    0x40a59400U,
    0x8ab3a200U,
    0xb6a4f00U,
    0xf085680U,
    0x271c0bc0U,
    0x49c376a0U,
    0x53209bd0U,
    0xe975ceb8U,
    0x43480fccU,
    0x62f8ec96U,
    0x751100dfU,
    0x375d9a23U,
    0x12209b0aU,
    0xcef0d4a0U,
    0x9a8ad4faU,
    0xb9dd9817U,
    0x8640431U,
    0x9e139a02U,
    0x4bdd9b26U,
    0x2f665488U,
    0x749594e0U,
    0x439eb808U,
    0x68849417U,
    0x97432220U,
    0xe1640f10U,
    0x3d93f6a1U,
    0xb01edbe0U,
    0x3b466ebdU,
    0x766dfe7U,
    0xb093f4a2U,
    0x19a44d2U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x68000000U,
    0x24000000U,
    0x66000000U,
    0x51000000U,
    0x2b800000U,
    0x9ac00000U,
    0x7a00000U,
    0xaf300000U,
    0xa4b80000U,
    0xc07c0000U,
    0x1ada0000U,
    0x7c6f0000U,
    0x5148000U,
    0xd04bc000U,
    0xf0e0e000U,
    0xd354d000U,
    0xefaed800U,
    0x5364400U,
    0x77b97200U,
    0x7cff1f00U,
    0x8a9a7e80U,
    0xa28a7f40U,
    0x13429ea0U,
    0xba62af70U,
    0x6a164688U,
    0x86cbeb6cU,
    0xd3a3b492U,
    0x61333465U,
    0x71bb2a0bU,
    0xfdfe9b31U,
    0xb919eca1U,
    0x744eb067U,
    0x56e2b828U,
    0x22555420U,
    0xb42d4a13U,
    0xf7f28b35U,
    0x541954beU,
    0xb5c8e46bU,
    0x7f217216U,
    0x49731f14U,
    0x93587eb0U,
    0xc1a97f55U,
    0xc0341ebbU,
    0xf23a6f4cU,
    0xe33826a3U,
    0xa8bbfb56U,
    0xe2790ca6U,
    0xfdda605eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0x48000000U,
    0xb4000000U,
    0x46000000U,
    0xdb000000U,
    0xc8800000U,
    0x43c00000U,
    0x77200000U,
    0x28900000U,
    0xd5f80000U,
    0xc43c0000U,
    0x9e1e0000U,
    0xcd0f0000U,
    0xd7b08000U,
    0x296ec000U,
    0x87c56000U,
    0x39205000U,
    0x67920800U,
    0xab788c00U,
    0x14fef200U,
    0x95ba9b00U,
    0xe05b9780U,
    0xae681440U,
    0xd46f7a0U,
    0x8fe44450U,
    0x4732ffa8U,
    0x6afc86cU,
    0x9ae28dbaU,
    0x80b49341U,
    0x1becfa2bU,
    0xcd021737U,
    0xeb8565b9U,
    0x57428f77U,
    0x36e5600cU,
    0x8ab05011U,
    0x5aea0803U,
    0xdc848c21U,
    0xb5c0f22fU,
    0xc4259b35U,
    0xa41317abU,
    0x983ad474U,
    0xdc1d9794U,
    0x380b1446U,
    0x8030779fU,
    0xac29847bU,
    0xdc211f87U,
    0xe812587bU,
    0x23b6589U,
    0x51d8f6eU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x48000000U,
    0xb4000000U,
    0x22000000U,
    0xdb000000U,
    0x54800000U,
    0xd1400000U,
    0xb9600000U,
    0x64500000U,
    0x5aa80000U,
    0xd0ec0000U,
    0x7d0e0000U,
    0x28190000U,
    0x7bd48000U,
    0x876ac000U,
    0x14c96000U,
    0xce3d7000U,
    0x13e12800U,
    0xe8104c00U,
    0x564b2600U,
    0xa6795d00U,
    0xc5023780U,
    0xb985dec0U,
    0x2cc557a0U,
    0x1fa1aed0U,
    0xa4f0ff98U,
    0xc0db22fcU,
    0xae72b98aU,
    0x1c9f0fd1U,
    0x5a91a602U,
    0x960a9d27U,
    0x749fd7b7U,
    0xfe926ec3U,
    0xac0d1f81U,
    0xe39c92e6U,
    0x7412f1bdU,
    0x304e33d3U,
    0xf77da838U,
    0x4e868c02U,
    0x5644461bU,
    0x2be12d31U,
    0xb4119f9dU,
    0x904a52c3U,
    0xa77d9193U,
    0xb68643e9U,
    0xaa46003fU,
    0xbde50024U,
    0x4d128028U,
    0x1fcfc028U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xa8000000U,
    0xac000000U,
    0x4a000000U,
    0x21000000U,
    0x91800000U,
    0x59c00000U,
    0x8e00000U,
    0xb5300000U,
    0xdbe80000U,
    0xcb2c0000U,
    0x5e4e0000U,
    0x68b90000U,
    0x42b28000U,
    0xa92bc000U,
    0x9348a000U,
    0x533ff000U,
    0x4a727800U,
    0x984c3400U,
    0xd3b8da00U,
    0xca32ad00U,
    0x156cdc80U,
    0x8c6f47c0U,
    0x29ea7ca0U,
    0xde29b7d0U,
    0x61ca8498U,
    0x867e43ccU,
    0x18d2feb2U,
    0x595f1ee7U,
    0xc2025a20U,
    0x5d056d2fU,
    0xe3827ca4U,
    0xcc5b7e9U,
    0xd76484beU,
    0x2bf743c8U,
    0x29887e9aU,
    0x9758decdU,
    0x4504fa35U,
    0x47839d34U,
    0x7ac284b3U,
    0x646243d0U,
    0x9f74fea9U,
    0x7ca1ef3U,
    0xad7eda1dU,
    0x4857ad3dU,
    0xe1185c90U,
    0x3b2187d4U,
    0x4cd65cbcU,
    0xc75887d5U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0xf8000000U,
    0xd4000000U,
    0x4a000000U,
    0xf000000U,
    0x4a800000U,
    0xed400000U,
    0x44e00000U,
    0xd7500000U,
    0xaa780000U,
    0xe03c0000U,
    0x25a0000U,
    0xc6490000U,
    0xbdd78000U,
    0x373c4000U,
    0xecd8e000U,
    0x290fb000U,
    0xa324800U,
    0xcced5c00U,
    0x3ae15600U,
    0x82568100U,
    0x77f99380U,
    0x43f8ac40U,
    0x19fb73a0U,
    0x8efe1c70U,
    0xc07ebbb8U,
    0x9f3f0044U,
    0xdf0d86U,
    0xd70a3171U,
    0x9f36d614U,
    0x716ac132U,
    0x492173a6U,
    0x61f71c79U,
    0xeb493b8fU,
    0x74534048U,
    0xbeffed83U,
    0x28798171U,
    0xd33e9e2fU,
    0x4ede9d36U,
    0x6a0fa5a0U,
    0xeb1dd73U,
    0x9caa4820U,
    0xef815c33U,
    0xb8c3561fU,
    0x7b23813cU,
    0x7af4138fU,
    0x8bcdec57U,
    0x461413a3U,
    0x489dec46U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0x98000000U,
    0xb4000000U,
    0xa2000000U,
    0xdf000000U,
    0x60800000U,
    0x6dc00000U,
    0xffe00000U,
    0xf2700000U,
    0x18a80000U,
    0x26c0000U,
    0x10a0000U,
    0x60bb0000U,
    0x86f18000U,
    0x47694000U,
    0x9a8ee000U,
    0x77fcf000U,
    0x2fd18800U,
    0x1078cc00U,
    0x7690c200U,
    0x505c8d00U,
    0x6c017680U,
    0xf6010fc0U,
    0xd0596a0U,
    0x7786fff0U,
    0x21459ea8U,
    0x842773e4U,
    0x7093bc8eU,
    0x555b0ec9U,
    0x17814226U,
    0x9145cd3eU,
    0x6c27969eU,
    0xc91ffd5U,
    0xdb5e1e89U,
    0xde8533cdU,
    0x8cc4dca1U,
    0xbe62bef4U,
    0xfe342a2fU,
    0xbb0af136U,
    0xcbbf5c9eU,
    0x6470fefbU,
    0xa5ab4a37U,
    0x9def4125U,
    0x5c48348bU,
    0x6a98c2d4U,
    0x3f600036U,
    0xfb00026U,
    0x5f480032U,
    0x141c0037U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x58000000U,
    0xfc000000U,
    0x46000000U,
    0x3d000000U,
    0x7f800000U,
    0x8cc00000U,
    0x39600000U,
    0xbaf00000U,
    0x68f80000U,
    0x953c0000U,
    0x8dde0000U,
    0x9ae90000U,
    0xc2f08000U,
    0x4fe4000U,
    0x5b3fa000U,
    0x24d89000U,
    0x76ff800U,
    0xc9374400U,
    0x391a0200U,
    0x2f881900U,
    0x86031680U,
    0x9d00c540U,
    0xaf82b6a0U,
    0xe4c15550U,
    0x9d65ce98U,
    0xf4515cU,
    0x13fe6c8eU,
    0xd7bdd863U,
    0x7e9a021fU,
    0x2f48192cU,
    0x416316a0U,
    0xd6f0c55fU,
    0xa6fab6b6U,
    0x3c3d556dU,
    0x105bce82U,
    0x912d517bU,
    0xff16eca6U,
    0x704f986dU,
    0xf9e3a218U,
    0xbeb58900U,
    0x61da6ebfU,
    0x14ecc154U,
    0x8bf194b2U,
    0xa97a9c71U,
    0x8f8002bU,
    0xe53c000aU,
    0x35de003eU,
    0x56e9002aU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0x68000000U,
    0xc4000000U,
    0x5e000000U,
    0xb9000000U,
    0x77800000U,
    0x37400000U,
    0xbfa00000U,
    0xe3300000U,
    0x3fe80000U,
    0x7dac0000U,
    0x5f8e0000U,
    0x34fb0000U,
    0x46378000U,
    0x6a68c000U,
    0xa1e8e000U,
    0x24ad1000U,
    0x18095800U,
    0xfbbd2400U,
    0x5591fe00U,
    0x135cd300U,
    0x7902f280U,
    0x978679c0U,
    0x74412a0U,
    0x47a069d0U,
    0x4f32ca88U,
    0xa5e98df4U,
    0x9aadd492U,
    0x910f4ec5U,
    0x743ffe05U,
    0xced7d32bU,
    0x36fd72b8U,
    0x7d32b9f6U,
    0x66eaf29fU,
    0x3a2a79faU,
    0x90ca12a2U,
    0x275b69f0U,
    0x3f054ab8U,
    0xb2814de2U,
    0x12c534a3U,
    0x3be25edbU,
    0xa416a639U,
    0xe11af727U,
    0xe3248cbfU,
    0xf0f26aeeU,
    0x7f8e003aU,
    0xe4fb000cU,
    0x8e378030U,
    0x3e68c03bU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0xc8000000U,
    0x94000000U,
    0xfe000000U,
    0xdf000000U,
    0x19800000U,
    0x59400000U,
    0x3c600000U,
    0xefd00000U,
    0xd6c80000U,
    0x7c8c0000U,
    0xdb6a0000U,
    0x8fd0000U,
    0x22d48000U,
    0x724ec000U,
    0x69486000U,
    0xb6ce9000U,
    0x8c8ee800U,
    0xf369e400U,
    0xacf9ce00U,
    0x14d37d00U,
    0x39490b80U,
    0x8ecb89c0U,
    0x308b6ba0U,
    0xa96819f0U,
    0x45f90398U,
    0x46533dfcU,
    0x878aadaaU,
    0x34efd0d9U,
    0xfabbce15U,
    0xc9327d2eU,
    0xd3df8bb3U,
    0xe6449c8U,
    0x82d58ba4U,
    0x624949cfU,
    0x71490b9bU,
    0xdacb89f9U,
    0x2e8b6ba0U,
    0x466819e9U,
    0x94790391U,
    0x8b133dd4U,
    0x45eaad82U,
    0x43fd0d4U,
    0x35f3ce1bU,
    0xecfe7d0cU,
    0x34d58b93U,
    0xe94949e4U,
    0x76c90bbbU,
    0x6c8b89e5U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0xf8000000U,
    0x94000000U,
    0xe2000000U,
    0x1f000000U,
    0xc1800000U,
    0xd0400000U,
    0x9b600000U,
    0x60700000U,
    0xacf80000U,
    0x41bc0000U,
    0xa45e0000U,
    0xa5e90000U,
    0x2a358000U,
    0xfc9e4000U,
    0xe24ce000U,
    0x57e6f000U,
    0x46b18800U,
    0xaa5ec400U,
    0x8ce82600U,
    0xf6b1cd00U,
    0x6259e680U,
    0x90ec5540U,
    0xe8b306a0U,
    0xf35fa550U,
    0x38690e98U,
    0x4762174U,
    0x66f848a6U,
    0xd2bf5c51U,
    0x83dcc61eU,
    0x70ab3d16U,
    0xfbd66e8eU,
    0x6f2b9172U,
    0x1a96a0b0U,
    0x2ccc285eU,
    0xfe22081dU,
    0x7995840fU,
    0x234f4612U,
    0xa7607d14U,
    0x4e710ea8U,
    0xb5fa217cU,
    0x153e4898U,
    0xc69a5c70U,
    0x594f4604U,
    0xfc607d31U,
    0x75f10e8bU,
    0x7eba2174U,
    0x55de48b6U,
    0xfdaa5c6dU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0xb8000000U,
    0xec000000U,
    0xee000000U,
    0xdd000000U,
    0x24800000U,
    0x2e400000U,
    0xfae00000U,
    0xb4500000U,
    0x50180000U,
    0x955c0000U,
    0xa3a0000U,
    0x52ab0000U,
    0xcf178000U,
    0x8a7e4000U,
    0x954b2000U,
    0xefc35000U,
    0xdc243800U,
    0xaef25c00U,
    0x53a88e00U,
    0xed97c900U,
    0xd3c3380U,
    0xd92d1f40U,
    0xfed513a0U,
    0x63594f70U,
    0x6b3caba8U,
    0x2e5354U,
    0x40508586U,
    0x2188a6fU,
    0x3e59ae3dU,
    0x8fbf9918U,
    0xe6f8b94U,
    0x2ab10363U,
    0xe4ebd82U,
    0x8241d65aU,
    0xf4e6a030U,
    0xd9561020U,
    0x5c989807U,
    0xef1f4c08U,
    0xf2df960eU,
    0xd5fac532U,
    0x668a85b2U,
    0x15e38a54U,
    0x4bd62e34U,
    0xf3ddd930U,
    0xf77eab97U,
    0xe1c95365U,
    0x5985059dU,
    0x5ac1ca67U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xd0000000U,
    0x38000000U,
    0x84000000U,
    0x6a000000U,
    0xb3000000U,
    0x21800000U,
    0x2e400000U,
    0xc0a00000U,
    0x70f00000U,
    0x91980000U,
    0x4edc0000U,
    0xc0fe0000U,
    0xa1cf0000U,
    0xefb18000U,
    0x3fbc4000U,
    0xffee6000U,
    0xb6863000U,
    0xf5c02800U,
    0x45e46400U,
    0xc5d1f600U,
    0x9d2e0300U,
    0x28e68c80U,
    0xb554b440U,
    0x6deeeca0U,
    0xe1818450U,
    0x4e4144a8U,
    0x30a6a064U,
    0x98f752a6U,
    0x2d9ed345U,
    0xa0d9963cU,
    0x19fb3329U,
    0x33492494U,
    0xe0739072U,
    0xd158fa8cU,
    0x4fb9f74aU,
    0x57ef802eU,
    0x2a83400cU,
    0xcbc7e02aU,
    0xa4e67039U,
    0xd350480bU,
    0xf8ed5425U,
    0x75005e02U,
    0x2486273eU,
    0xa2c11ab1U,
    0xfe60874cU,
    0xb096483cU,
    0xc00e540bU,
    0x9857de25U,
    0x3d696739U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0xf8000000U,
    0x94000000U,
    0x2e000000U,
    0xd7000000U,
    0x86800000U,
    0x59400000U,
    0x19e00000U,
    0x28500000U,
    0x83d80000U,
    0xd79c0000U,
    0xe1fa0000U,
    0xa96b0000U,
    0x30968000U,
    0xcdfd4000U,
    0xf36be000U,
    0x59959000U,
    0xd47ba800U,
    0x40afdc00U,
    0xa3317600U,
    0x1ccce900U,
    0xbaa22380U,
    0x28b4d140U,
    0x6a0bc3a0U,
    0xc3864170U,
    0x1ac4eba8U,
    0xc323dd5cU,
    0xcb72fd96U,
    0xf8ace479U,
    0xd736161dU,
    0xa2cf390cU,
    0x25a4eb9cU,
    0xc233dd6aU,
    0x894afdb2U,
    0x2360e47cU,
    0x63141624U,
    0x9f383900U,
    0x5c486b89U,
    0x28e59d4aU,
    0xd5d79d87U,
    0xc6183446U,
    0xde3c5e2aU,
    0x79ce7505U,
    0x4920b5acU,
    0xa71a84aU,
    0x1d28481eU,
    0x96f64c2dU,
    0xcd68de35U,
    0x694351bU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x98000000U,
    0x6c000000U,
    0xd6000000U,
    0x37000000U,
    0x2d800000U,
    0x11c00000U,
    0xd3e00000U,
    0x71700000U,
    0x2c80000U,
    0x1e8c0000U,
    0xacaa0000U,
    0x26390000U,
    0x71878000U,
    0x4fc74000U,
    0x70e22000U,
    0x36f79000U,
    0x6a08a800U,
    0xbbe90400U,
    0x379cea00U,
    0xd1d7c500U,
    0xe01f7680U,
    0x8110ccc0U,
    0x997ad6a0U,
    0x84201cf0U,
    0xad905eb8U,
    0x823e88c4U,
    0x93841c9eU,
    0xa2c049dfU,
    0x6c67802bU,
    0xa5b74012U,
    0xe9aa2000U,
    0xdebb9026U,
    0xa0c2a82cU,
    0x9160040eU,
    0x41336a0aU,
    0xc6ec8512U,
    0x131f5694U,
    0x9e925cd6U,
    0xfdbffea3U,
    0x274758f1U,
    0x99a11493U,
    0x34559dd4U,
    0xc5dbe22fU,
    0x88f71126U,
    0xd90e949cU,
    0x46edde6U,
    0xe35bc20bU,
    0x3ab58115U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x18000000U,
    0x4c000000U,
    0x46000000U,
    0xf7000000U,
    0x18800000U,
    0x84400000U,
    0xbe600000U,
    0xcf500000U,
    0xc0380000U,
    0xa4fc0000U,
    0x62de0000U,
    0x2ded0000U,
    0x69828000U,
    0x4bc64000U,
    0xb2a62000U,
    0x1d771000U,
    0xe50f2800U,
    0xa1932c00U,
    0xb71b6e00U,
    0x449ad00U,
    0xba76ef80U,
    0x35886a40U,
    0xe1d24fa0U,
    0xeb793a50U,
    0x2e1b47b8U,
    0x9fcd066cU,
    0xbcb701beU,
    0x56ab877fU,
    0x2b64802fU,
    0x72d74002U,
    0xc1faa009U,
    0xc75c5033U,
    0x602b883eU,
    0x4c227c3cU,
    0xbe326608U,
    0xcbed9106U,
    0x4e82a981U,
    0xdb42eb70U,
    0x92e7ce3dU,
    0xb114fd13U,
    0xd759e786U,
    0xc82d564bU,
    0x782289b1U,
    0x4434fb75U,
    0x62ec660bU,
    0xed00912dU,
    0x180298eU,
    0x5fc4ab6dU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xb8000000U,
    0x64000000U,
    0xd6000000U,
    0x8b000000U,
    0xf1800000U,
    0x7dc00000U,
    0x9fa00000U,
    0xf300000U,
    0xf6380000U,
    0x4e7c0000U,
    0x121e0000U,
    0x45890000U,
    0x37028000U,
    0x73834000U,
    0x78c26000U,
    0xf123d000U,
    0xed740800U,
    0xfb5e4400U,
    0xf96a8a00U,
    0x1dd2c700U,
    0x93ede680U,
    0x19905b40U,
    0x4d8d06a0U,
    0x4b00cb50U,
    0x51836e98U,
    0xedc15f4cU,
    0x57a3ecb6U,
    0xd334dc55U,
    0x443e0003U,
    0x13790037U,
    0x689a801fU,
    0xc9cf4038U,
    0xd5646000U,
    0xe316d027U,
    0x81c88813U,
    0x4964042dU,
    0xb1126a22U,
    0xacce571eU,
    0x8be58e93U,
    0x5954cf5dU,
    0x98a9048aU,
    0x90730872U,
    0x51d86234U,
    0x5d291303U,
    0x53b58480U,
    0x979485cU,
    0xd9988204U,
    0x59498328U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x18000000U,
    0x3c000000U,
    0x16000000U,
    0xc5000000U,
    0x43800000U,
    0xd1c00000U,
    0x7b200000U,
    0x11300000U,
    0xacb80000U,
    0xb0fc0000U,
    0x231a0000U,
    0x7c890000U,
    0x5c78000U,
    0x39234000U,
    0x5634a000U,
    0xc83f1000U,
    0xd5bbb800U,
    0x257f6400U,
    0x57db0a00U,
    0x942ee300U,
    0xdd308280U,
    0xd2ba1b40U,
    0xe1fba2a0U,
    0x829a4b70U,
    0x5a4ebab8U,
    0xd2633f44U,
    0x695188beU,
    0xd6edf84bU,
    0x8094a03bU,
    0xe1cf103aU,
    0x2fa3b80bU,
    0x7c73643eU,
    0xeed90a0dU,
    0x61abe30eU,
    0x79f502a0U,
    0x221c5b6dU,
    0x50a828dU,
    0x7f031b73U,
    0x28842284U,
    0xdb450b7dU,
    0x37601a89U,
    0x5ad52f44U,
    0xaf2db092U,
    0xfb1dc50U,
    0xc2fb0a1fU,
    0x6c1ee31eU,
    0x5c088297U,
    0x9a861b50U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xc8000000U,
    0xbc000000U,
    0xbe000000U,
    0x15000000U,
    0x38800000U,
    0x4cc00000U,
    0x7d200000U,
    0xbf900000U,
    0x9380000U,
    0x1b7c0000U,
    0xbb9a0000U,
    0x2baf0000U,
    0xf6c68000U,
    0xc224c000U,
    0x172000U,
    0x2e7fd000U,
    0x731af800U,
    0xf6b7c00U,
    0x7e1fa00U,
    0xbb26300U,
    0xa02f7780U,
    0xb3821a40U,
    0x9146d7a0U,
    0x61650a70U,
    0x2710f88U,
    0xbd8ea67cU,
    0x4d48dbaU,
    0x2f5f7953U,
    0xd28f2015U,
    0x2353d016U,
    0xec18f83bU,
    0x40e87c35U,
    0x48a57a0cU,
    0xefd5a316U,
    0x62dcd7bcU,
    0x36ca0a7fU,
    0xeab78f9dU,
    0x5aaa6640U,
    0xf443ad86U,
    0xf1e0a96fU,
    0x62b5d82bU,
    0x86a8ac24U,
    0xda41023aU,
    0x1ce61f14U,
    0x2e300db3U,
    0xc868b943U,
    0xc64802bU,
    0x8ef7c02fU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x98000000U,
    0x4c000000U,
    0xc6000000U,
    0xd5000000U,
    0xb5800000U,
    0x70400000U,
    0x5be00000U,
    0xb2300000U,
    0x4ec80000U,
    0x790c0000U,
    0xddae0000U,
    0x6afd0000U,
    0x5ac18000U,
    0xad214000U,
    0x9112000U,
    0x6adc1000U,
    0x7a523800U,
    0x89bd5400U,
    0x21a1b600U,
    0xbad4d900U,
    0xfc7ea080U,
    0x62045ac0U,
    0x170600a0U,
    0x12850ad0U,
    0xac318b8U,
    0x15254ef4U,
    0xb517169eU,
    0xa4dc83e7U,
    0x7b56a02fU,
    0xb63c5012U,
    0x42e49822U,
    0x81b1041eU,
    0x8b8d2e2cU,
    0x769dd16U,
    0x87dd8e99U,
    0x33d087dbU,
    0x57fa0e3fU,
    0xeb44cd24U,
    0xaf6036bcU,
    0x9df193e7U,
    0xe66b1836U,
    0x685d4436U,
    0xa8958e14U,
    0xb0988d18U,
    0xc2b09689U,
    0x530cc3f2U,
    0x7ea8002cU,
    0x627c0007U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x28000000U,
    0xc4000000U,
    0x7e000000U,
    0x3d000000U,
    0x4e800000U,
    0xd6400000U,
    0x3e200000U,
    0xaf100000U,
    0xda580000U,
    0xf79c0000U,
    0x257e0000U,
    0xc40d0000U,
    0xce618000U,
    0x9034c000U,
    0xc9c8e000U,
    0xec841000U,
    0xc9477800U,
    0x2fa54c00U,
    0x8d25e00U,
    0xd3bd9f00U,
    0x796a6f80U,
    0xb5d11940U,
    0xdd3d0fa0U,
    0xcf2cc950U,
    0x1bf317b8U,
    0x5a295574U,
    0xd176d1b2U,
    0x92699645U,
    0x4257982dU,
    0x5bfd5c0aU,
    0x8a4b261eU,
    0xec45d32fU,
    0x3d21b189U,
    0xbc944660U,
    0xd2998015U,
    0x37f8c03cU,
    0x704ee03bU,
    0xcf451036U,
    0xdea0f809U,
    0xc508c32U,
    0xfefd3e21U,
    0xd8cc4f1cU,
    0x380277a9U,
    0xac058550U,
    0xda07499eU,
    0xd305ca5bU,
    0x5b833e12U,
    0x5cc14f20U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x8000000U,
    0xa4000000U,
    0xda000000U,
    0x77000000U,
    0xf9800000U,
    0xeac00000U,
    0x6c600000U,
    0xe5b00000U,
    0xfab80000U,
    0xc6fc0000U,
    0x75de0000U,
    0xd8cf0000U,
    0x9ea38000U,
    0x65d7c000U,
    0x4108e000U,
    0x1433000U,
    0x35a20800U,
    0x1a568400U,
    0x1ac97200U,
    0x5a40100U,
    0xc253f480U,
    0x96cb1d40U,
    0xeba694a0U,
    0x6750ed50U,
    0xbc4ffca8U,
    0x22e29974U,
    0x96f466aaU,
    0xcc1f2c5dU,
    0xd72ae81cU,
    0xc6d5b400U,
    0x9a8b7a02U,
    0x8082852aU,
    0x46428691U,
    0x14231c77U,
    0x7c93600dU,
    0x98a8f03fU,
    0x4514e80eU,
    0x126ab420U,
    0x9970fa1dU,
    0x6fd9450eU,
    0xcfcc66a2U,
    0xd7232c43U,
    0x1714e839U,
    0x816ab403U,
    0x9af0fa2fU,
    0x62194503U,
    0x522c6697U,
    0x7c532c7aU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x68000000U,
    0x84000000U,
    0xda000000U,
    0x7b000000U,
    0x90800000U,
    0xc00000U,
    0x9ee00000U,
    0xad500000U,
    0x85480000U,
    0xba0c0000U,
    0xe6aa0000U,
    0x1adb0000U,
    0x9ea38000U,
    0x9b74c000U,
    0x12fee000U,
    0x58153000U,
    0xcaec6800U,
    0x52f8ac00U,
    0xb8130a00U,
    0xfaefed00U,
    0x2afcbf80U,
    0x5412a1c0U,
    0xa4ebdfa0U,
    0x8bf851f0U,
    0xbf92d7a8U,
    0x34ad0df4U,
    0x15d955b2U,
    0x8c247cd5U,
    0x1cb10804U,
    0x2a995c0bU,
    0xd0818200U,
    0xe0c2713bU,
    0xaee3ddafU,
    0xd555e0d4U,
    0x694c6a34U,
    0xe4091d2bU,
    0x47afb793U,
    0xf15cfdc7U,
    0xee3dda2U,
    0x555e0f4U,
    0x214c6a25U,
    0x70091d32U,
    0xf5afb79eU,
    0xe5cfdc7U,
    0x4463dd94U,
    0x7e95e0feU,
    0x2f2c6a09U,
    0xdd991d2dU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x48000000U,
    0xe4000000U,
    0xa6000000U,
    0xdd000000U,
    0x2f800000U,
    0xac00000U,
    0x94a00000U,
    0x1c900000U,
    0xdee80000U,
    0xbaac0000U,
    0xc14a0000U,
    0xfcbb0000U,
    0x4ee68000U,
    0x8670c000U,
    0x7699e000U,
    0xd531d000U,
    0x2df8b800U,
    0x4e808400U,
    0x5f417200U,
    0x69602700U,
    0x88b7cb80U,
    0xd43d90c0U,
    0xeca2aba0U,
    0x709780f0U,
    0xbced73a8U,
    0x71aa14dcU,
    0x7bcf59baU,
    0x3dfc67e5U,
    0x7685d813U,
    0xd3469412U,
    0x9b64aa38U,
    0xbbb6b320U,
    0xc2bb6195U,
    0x6fe723cbU,
    0x33f3ca10U,
    0x1b5ba32cU,
    0xb91039a1U,
    0x8b2d77f8U,
    0x5a8c8003U,
    0x959bc03eU,
    0xdbb76028U,
    0x92bd101eU,
    0xb7e3582cU,
    0x2ff65403U,
    0x115d4a1eU,
    0x2617632dU,
    0xdfabd99fU,
    0xa2cba7e5U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0x58000000U,
    0xc4000000U,
    0x42000000U,
    0xdb000000U,
    0x72800000U,
    0x48400000U,
    0x55a00000U,
    0xd1f00000U,
    0x8c780000U,
    0xafbc0000U,
    0x5bde0000U,
    0x5490000U,
    0x75208000U,
    0x8ab64000U,
    0xe75a6000U,
    0xd80b7000U,
    0x87062800U,
    0x54847c00U,
    0x1439e00U,
    0x9426e300U,
    0x77311480U,
    0x179e3340U,
    0xb2edf4a0U,
    0xafd60350U,
    0x1c4f3c98U,
    0x9ca64f5cU,
    0x50706a8eU,
    0xcab9e06dU,
    0x45ea81eU,
    0x1e8e3c1bU,
    0x3547fe22U,
    0x2e249319U,
    0xb837bc8fU,
    0x4f1c0f61U,
    0xbdac0a9aU,
    0xef7906bU,
    0x1cfe0024U,
    0xecf90010U,
    0x14f88013U,
    0xfa4001U,
    0x2afc6017U,
    0x6dfe7039U,
    0x9978a81fU,
    0x483b3c24U,
    0xb4197e0cU,
    0x5f2bd302U,
    0xceb55cb3U,
    0xe55d3f5cU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x98000000U,
    0xac000000U,
    0x86000000U,
    0xc1000000U,
    0x14800000U,
    0xc0c00000U,
    0x32e00000U,
    0x5100000U,
    0x79980000U,
    0x8adc0000U,
    0x7d7a0000U,
    0x16cb0000U,
    0x9c628000U,
    0xead24000U,
    0x8af92000U,
    0x41881000U,
    0x29c19800U,
    0xd260fc00U,
    0xcfd41a00U,
    0x3c7c7d00U,
    0xc24abd80U,
    0x7ca72540U,
    0xe8331da0U,
    0x17ea7570U,
    0x941325a8U,
    0x251bd97cU,
    0x6e1d078eU,
    0xcd9d0857U,
    0x60db182fU,
    0x1a7ebc27U,
    0xf34f3a0aU,
    0xd0236d27U,
    0xb4f3a58eU,
    0x3b0e996aU,
    0xfc04a796U,
    0xce005853U,
    0xe5032020U,
    0x9683102aU,
    0xb3c31804U,
    0xcd62bc3bU,
    0x96553a03U,
    0x5e386d16U,
    0x696925b4U,
    0xf3d0d95bU,
    0xd27f8795U,
    0x174f4850U,
    0x72223811U,
    0xf7f6ac2bU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x28000000U,
    0x74000000U,
    0x66000000U,
    0xaf000000U,
    0x94800000U,
    0x86c00000U,
    0x200000U,
    0x8c500000U,
    0xc9380000U,
    0x5a7c0000U,
    0x631e0000U,
    0x53290000U,
    0xfba48000U,
    0x3e11c000U,
    0x1fd86000U,
    0x4e085000U,
    0x7a72a800U,
    0xd26c4c00U,
    0xbc05a00U,
    0x35a32b00U,
    0xa5111180U,
    0xd5b0c40U,
    0xd7cbf1a0U,
    0xc6d79c50U,
    0xacfbb998U,
    0xa4db407cU,
    0x4c8dab92U,
    0x9bb1b761U,
    0x82c8280bU,
    0x4f548c0aU,
    0x27bcba0eU,
    0x81babb3bU,
    0x8ebbd9b6U,
    0x4a3f1074U,
    0x54f903aeU,
    0x8d8fb6fU,
    0x968af217U,
    0x96b3673cU,
    0xf74f4ba6U,
    0x8611275fU,
    0x53de6020U,
    0x240d5038U,
    0x5f70283bU,
    0xd3e88c1aU,
    0xa482ba0aU,
    0xeec3bb3aU,
    0x94275999U,
    0x5a52d077U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xf0000000U,
    0xa8000000U,
    0x84000000U,
    0xea000000U,
    0xb7000000U,
    0xff800000U,
    0x7a400000U,
    0xa0600000U,
    0xcd100000U,
    0xbad80000U,
    0xa61c0000U,
    0xfeba0000U,
    0xb10d0000U,
    0xbb628000U,
    0x9c93c000U,
    0x7d99e000U,
    0xbefdb000U,
    0x1e698800U,
    0x55f43400U,
    0x9a084600U,
    0xa2e55500U,
    0x2fd7a580U,
    0x277c5f40U,
    0x6d2ec5a0U,
    0xef132f70U,
    0xb9de2d98U,
    0xfb986b4cU,
    0x47fe83b2U,
    0xacea7a6dU,
    0x3f338808U,
    0x93a93400U,
    0xdbd2c617U,
    0xa57a952eU,
    0xbe2c4587U,
    0xa90ef61U,
    0xdc9fcda3U,
    0x2079db59U,
    0x1aad0b9eU,
    0x1534e64U,
    0xabb94e25U,
    0xad8fa13cU,
    0x6ca48388U,
    0x2db77a7dU,
    0x29690806U,
    0x6a76f413U,
    0x492605U,
    0xf2862509U,
    0x4ac54da6U,
    0x19a61b7eU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x50000000U,
    0x48000000U,
    0xc000000U,
    0xfa000000U,
    0x93000000U,
    0xb3800000U,
    0x89400000U,
    0x2e200000U,
    0xbe900000U,
    0x4b280000U,
    0x74ec0000U,
    0x990a0000U,
    0x87d0000U,
    0xb5278000U,
    0x2111c000U,
    0x886fa000U,
    0xd1cb7000U,
    0xd01b6800U,
    0x3c13b400U,
    0x86e91e00U,
    0x260fff00U,
    0xf1fff380U,
    0xb76266c0U,
    0xf8b5d3a0U,
    0x49b9d6f0U,
    0xddc49b98U,
    0x3ae1d2e4U,
    0xd4f4cd8aU,
    0x5d1a29e7U,
    0x9a916834U,
    0x2d2eb403U,
    0xb5ee9e38U,
    0xe58e3f11U,
    0x80b8538bU,
    0x8d4516eaU,
    0xf824bbabU,
    0x679762c4U,
    0x73aa058bU,
    0xa2fedf6U,
    0xc86c9e18U,
    0xf1cf3f1fU,
    0x601dd3afU,
    0x2415d6d0U,
    0xc2ee9bbdU,
    0xd00cd2c4U,
    0x98fb4d9bU,
    0x97e7e9f7U,
    0xc274c834U,
    0xeed8c428U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x70000000U,
    0x98000000U,
    0x14000000U,
    0x82000000U,
    0x61000000U,
    0xf1800000U,
    0x5e400000U,
    0xbe600000U,
    0x5b100000U,
    0x5d980000U,
    0x7d5c0000U,
    0x8bfa0000U,
    0x6a4f0000U,
    0xe0648000U,
    0x84144000U,
    0x631ae000U,
    0x559ff000U,
    0xe1597800U,
    0x55ff3400U,
    0x754ee600U,
    0x7ee3c500U,
    0xdcd6b580U,
    0x91b9c540U,
    0x7e2ad5a0U,
    0xf6717570U,
    0xce0fcd88U,
    0x3b06f16cU,
    0xe48433aeU,
    0xfdc2b069U,
    0x6921780eU,
    0x98f33431U,
    0xcecce612U,
    0x7da0c516U,
    0x3d303595U,
    0x13ee855cU,
    0x1756b584U,
    0xaf9c576U,
    0x8bcad5aeU,
    0xf6217568U,
    0xc677cd8cU,
    0x360af15bU,
    0xff06339bU,
    0x8e81b040U,
    0x10c7f808U,
    0xea4741dU,
    0x25b08638U,
    0xe028753eU,
    0x89752d88U,
    0x80890178U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x58000000U,
    0x54000000U,
    0x52000000U,
    0x71000000U,
    0x8a800000U,
    0x20c00000U,
    0xb8600000U,
    0x41300000U,
    0x49f80000U,
    0x1cbc0000U,
    0xc19e0000U,
    0x558b0000U,
    0x24638000U,
    0x5f354000U,
    0x9efde000U,
    0xa53e7000U,
    0x42df7800U,
    0x13acec00U,
    0xaff7ca00U,
    0x9e9e5900U,
    0xb7880U,
    0x1120f340U,
    0x721318a0U,
    0xe2ecc350U,
    0xc8d40088U,
    0x678c1f54U,
    0xa564d29eU,
    0x3db29a41U,
    0xa23f780aU,
    0x435cec1dU,
    0x74efca08U,
    0xf3d25905U,
    0x680d788eU,
    0x4d27f351U,
    0x8c1698aaU,
    0x85ee8353U,
    0x395460a6U,
    0xe8cc2f5eU,
    0xe545ca9bU,
    0x95254654U,
    0x98122a06U,
    0x77ec2931U,
    0x58520086U,
    0x3a4b1f6aU,
    0x918152bbU,
    0x7f40da5cU,
    0xa827181eU,
    0xb490dc19U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x10000000U,
    0x78000000U,
    0x44000000U,
    0xca000000U,
    0x45000000U,
    0xdd800000U,
    0xd8400000U,
    0x66200000U,
    0x58d00000U,
    0xa3780000U,
    0x555c0000U,
    0xb58a0000U,
    0x32f10000U,
    0xbdad8000U,
    0x35244000U,
    0x9e576000U,
    0x31bcb000U,
    0x27bad800U,
    0x3cbb5400U,
    0x76392600U,
    0x62fccf00U,
    0xb31f5d80U,
    0x54aa6040U,
    0xdea585a0U,
    0xed113470U,
    0x151ca3b8U,
    0x47adfb74U,
    0xb823fe26U,
    0xfd79b25U,
    0xffe7bb4U,
    0xf29aaf44U,
    0x72e8d83bU,
    0x5f865406U,
    0x1146a604U,
    0x3da58f35U,
    0x2397bd98U,
    0xabdf9064U,
    0xc34fbd8eU,
    0xfa13906eU,
    0x199dbda5U,
    0x906e9056U,
    0x17423d9aU,
    0x5ea7d07eU,
    0x2d12ddbdU,
    0x751e206fU,
    0x57aae5bdU,
    0xc0218455U,
    0x4bd47badU,
    0xc5fbaf5bU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x18000000U,
    0xdc000000U,
    0xbe000000U,
    0x63000000U,
    0x25800000U,
    0x30c00000U,
    0xf1200000U,
    0xf5b00000U,
    0xb6f80000U,
    0xafdc0000U,
    0xbe6e0000U,
    0x3a950000U,
    0x60488000U,
    0x5ca64000U,
    0x1175a000U,
    0x6dd8d000U,
    0x736d8800U,
    0x34110400U,
    0x810c5200U,
    0xe7445300U,
    0x14e1fa80U,
    0xd6119f40U,
    0x1c0c72a0U,
    0xc1c09b50U,
    0x31a020b8U,
    0xff4c85cU,
    0xc499da3eU,
    0x3c89572bU,
    0x4b83a8b1U,
    0x3bc0cc63U,
    0x70a50800U,
    0x97774433U,
    0x82d9f202U,
    0xc0ec8325U,
    0xa3d4729eU,
    0x37ac9b6dU,
    0xff3620b1U,
    0x15bdc850U,
    0x993f5a2bU,
    0xd57a1722U,
    0x501e8891U,
    0xacce5c44U,
    0x70e52024U,
    0xa4129015U,
    0x890e2829U,
    0x7340d439U,
    0x5ee75a12U,
    0xcf161710U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x98000000U,
    0x5c000000U,
    0xba000000U,
    0xd5000000U,
    0x78800000U,
    0x89c00000U,
    0xa3600000U,
    0x24900000U,
    0xf1880000U,
    0x6eec0000U,
    0x207a0000U,
    0x8cf30000U,
    0x6e9e8000U,
    0xb9204000U,
    0xa5b1a000U,
    0xf83af000U,
    0x94d41800U,
    0xdaa7c00U,
    0xdbdec200U,
    0xb584c100U,
    0x6d451980U,
    0xb0a217c0U,
    0x62f101a0U,
    0x35986bf0U,
    0x4aa7c3a8U,
    0x57f0aafcU,
    0x5d18da0eU,
    0x6b61bd2bU,
    0x30975b80U,
    0x9f8996eeU,
    0xf5e93836U,
    0xf3ffcc30U,
    0x4eb7fa10U,
    0x53bb0d12U,
    0x1a92e3acU,
    0x22891ae7U,
    0x696be212U,
    0xac3d7134U,
    0x1ad621b9U,
    0x86aedbf8U,
    0xa0587b94U,
    0xb3c326ddU,
    0xb664802dU,
    0x7c134001U,
    0x484f2002U,
    0x558ab00aU,
    0x58edb833U,
    0xc77c8c07U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0xb8000000U,
    0x3c000000U,
    0x6a000000U,
    0xf9000000U,
    0xe9800000U,
    0x81c00000U,
    0xbe00000U,
    0x2e500000U,
    0xcc80000U,
    0xed2c0000U,
    0xfa7a0000U,
    0x3f330000U,
    0xe3da8000U,
    0xaa454000U,
    0x8727a000U,
    0x2367000U,
    0xbc58f800U,
    0x28821400U,
    0x94436a00U,
    0xc0214d00U,
    0x6cb76b80U,
    0x731bc7c0U,
    0x5c2793a0U,
    0x76b5d3f0U,
    0x121ef9a8U,
    0x39a79edcU,
    0x25731206U,
    0xdcf91913U,
    0x947321bcU,
    0x517abaddU,
    0xd3b5202eU,
    0xc19f3021U,
    0x6965582aU,
    0xf3176439U,
    0x9d691215U,
    0x3c5a191fU,
    0xe881a1a5U,
    0xb443fac1U,
    0x7020801fU,
    0xd4b6400eU,
    0x4f1d202dU,
    0x36233002U,
    0x8fb7581bU,
    0xfb986414U,
    0xb861920fU,
    0x2e90590bU,
    0xf2ae8193U,
    0x98bfcaecU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xe8000000U,
    0x94000000U,
    0x56000000U,
    0xcb000000U,
    0x74800000U,
    0xdb400000U,
    0x9a00000U,
    0x78d00000U,
    0x55480000U,
    0x5aec0000U,
    0xb13e0000U,
    0xccf70000U,
    0x7f5c8000U,
    0xb2c5c000U,
    0x2d666000U,
    0xfeb05000U,
    0xf7fc800U,
    0x96d40c00U,
    0x524d8600U,
    0x246a8300U,
    0x937a8980U,
    0xc4d2c5c0U,
    0xf74d41a0U,
    0x17eac9d0U,
    0x16bec7a8U,
    0x1f374aecU,
    0x6fb8ce12U,
    0x5eb04f09U,
    0xbf7befa7U,
    0x5ed6d6ebU,
    0x364ce012U,
    0x9a6e9031U,
    0xcc7b2802U,
    0xe6569c26U,
    0xe708ae30U,
    0x6acb1f1bU,
    0xb52ea7aeU,
    0x43dc1ac9U,
    0x4d85861bU,
    0xbac6832fU,
    0x296489b2U,
    0x90b5c5c2U,
    0x4879c198U,
    0xc85309d5U,
    0x800ea78dU,
    0xc44c1afeU,
    0x8f6d8623U,
    0x37fa830eU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xd8000000U,
    0x9c000000U,
    0x56000000U,
    0xa1000000U,
    0x7f800000U,
    0x3c00000U,
    0xb6e00000U,
    0x34100000U,
    0xf780000U,
    0x279c0000U,
    0x668a0000U,
    0x54750000U,
    0x732c8000U,
    0x6fc04000U,
    0x18e1a000U,
    0x59179000U,
    0x4efed800U,
    0xc15e8400U,
    0x65e80a00U,
    0x94a1e500U,
    0x14358180U,
    0xbd040U,
    0xc43359a0U,
    0xa8095470U,
    0x60315398U,
    0xd20db15cU,
    0x4f30522eU,
    0x908a213bU,
    0x6570ab9bU,
    0x84ade563U,
    0x9801a01cU,
    0xbc07903fU,
    0x606d81fU,
    0xc9028409U,
    0x3b820a07U,
    0xc9c4e523U,
    0x41e101a2U,
    0xea979079U,
    0x7338f9b9U,
    0x92bbc477U,
    0xe47b0bb6U,
    0x6f1f7549U,
    0x5bcbf824U,
    0x2ed5540fU,
    0x2a1d720eU,
    0x7e4df135U,
    0x5217d3afU,
    0xb678f141U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x18000000U,
    0xd4000000U,
    0xa2000000U,
    0x43000000U,
    0xbb800000U,
    0xcdc00000U,
    0xede00000U,
    0xbf500000U,
    0xc580000U,
    0xa7bc0000U,
    0xa1ee0000U,
    0x61310000U,
    0xa2c88000U,
    0x78064000U,
    0x2401e000U,
    0x5a047000U,
    0x27042800U,
    0x1821400U,
    0x5ac70a00U,
    0xf461cd00U,
    0x3196e380U,
    0x5a3f2b40U,
    0xd52acba0U,
    0x40513f50U,
    0x79dbc198U,
    0xf7df27cU,
    0xbe8ba21eU,
    0x27259909U,
    0x43300996U,
    0xa1ca9649U,
    0x23800020U,
    0x59c00006U,
    0xafe00005U,
    0x4c500020U,
    0xafd80010U,
    0xbe7c0000U,
    0xee0e0038U,
    0x9d61000eU,
    0x1510802dU,
    0x127a401cU,
    0x680fe032U,
    0x8465703fU,
    0x8994a82bU,
    0xde385421U,
    0xdf28ea3eU,
    0xcf54bd33U,
    0xb45a4bbbU,
    0x23bb7f75U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x78000000U,
    0x94000000U,
    0xba000000U,
    0xe9000000U,
    0x7b800000U,
    0x7d400000U,
    0xa5200000U,
    0xccb00000U,
    0xa9080000U,
    0xba2c0000U,
    0xc19e0000U,
    0x8170000U,
    0xa1fb8000U,
    0x95864000U,
    0x4e45e000U,
    0x7a3b000U,
    0xa276b800U,
    0x9d6a8400U,
    0xfdbfde00U,
    0xf726cf00U,
    0x89b4ee80U,
    0xdc8c58c0U,
    0x846a56a0U,
    0x8e3adcd0U,
    0x566388a8U,
    0x6a9713d4U,
    0xaf3ae636U,
    0x91e60b31U,
    0x61d0d0b8U,
    0xdd1e27dbU,
    0xdd3800eU,
    0xb31a4010U,
    0x7ed3e011U,
    0x3198b012U,
    0x133803U,
    0x7dfbc427U,
    0xd381be1dU,
    0xf1433f25U,
    0xbb27b6acU,
    0xf7b56cd6U,
    0xd78b3082U,
    0x92ea97c5U,
    0x4afeb811U,
    0xf3068439U,
    0xc281de22U,
    0x5ec1cf38U,
    0x5c676eadU,
    0xab9618d7U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x38000000U,
    0x2c000000U,
    0xa000000U,
    0x69000000U,
    0x45800000U,
    0xf5c00000U,
    0x9ae00000U,
    0x21300000U,
    0x79480000U,
    0xcdac0000U,
    0x3b9a0000U,
    0x58510000U,
    0xebe8000U,
    0x62854000U,
    0x17452000U,
    0x4da3f000U,
    0xc91f800U,
    0x5d8f400U,
    0xf073aa00U,
    0xe7ef0500U,
    0xb5be3880U,
    0xd205b8c0U,
    0xf507c0a0U,
    0x17814cf0U,
    0xc0c66ab8U,
    0xed6349ecU,
    0x91f4d236U,
    0xac2eb127U,
    0x705ab294U,
    0x9db44dcdU,
    0x410c803dU,
    0xd688401cU,
    0xd649a02dU,
    0x5b2bb033U,
    0xbad85827U,
    0x2ef3440dU,
    0x72abf234U,
    0xe51c4137U,
    0xcd15ca82U,
    0x5e19f9c0U,
    0x7d920a0eU,
    0xbc58b525U,
    0x27b46083U,
    0x700bfce5U,
    0xcf08b29aU,
    0x11894dc6U,
    0x84c8002bU,
    0xd46c0022U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x30000000U,
    0x98000000U,
    0xc4000000U,
    0xd6000000U,
    0xe3000000U,
    0xb4800000U,
    0x19400000U,
    0x2c600000U,
    0xa5900000U,
    0xe6b80000U,
    0x49dc0000U,
    0x88ce0000U,
    0x7f330000U,
    0x768e8000U,
    0xd1d44000U,
    0xb9596000U,
    0x78d5000U,
    0x10500800U,
    0x579fcc00U,
    0xb62cd600U,
    0x18e1fd00U,
    0xfcd67d80U,
    0x6adace40U,
    0xdc4875a0U,
    0xf6760250U,
    0xf2ea2388U,
    0x2843bf5cU,
    0x4de53e2eU,
    0x7b54212dU,
    0xcf1d43bbU,
    0x856def45U,
    0xf583b61eU,
    0x40c3ad1fU,
    0x6a6f5bbU,
    0xc232425bU,
    0xd0b4399U,
    0x5612ef5cU,
    0x4d7b362dU,
    0x97f8ed00U,
    0xd9bf15a5U,
    0xaf585242U,
    0x48caba9U,
    0x34d4335aU,
    0xe6de881eU,
    0xc64b8c10U,
    0xaf75b60dU,
    0x2f6cad1fU,
    0x748675aaU,
    0xf945024fU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0xc8000000U,
    0xa4000000U,
    0xca000000U,
    0x79000000U,
    0x68800000U,
    0x49400000U,
    0xf2200000U,
    0x8d300000U,
    0xada80000U,
    0x2e8c0000U,
    0xcf3e0000U,
    0x51d10000U,
    0x6c7f8000U,
    0x2af7c000U,
    0xf1cbe000U,
    0xf21e3000U,
    0x8b643800U,
    0xa7159c00U,
    0xac9a6600U,
    0xbd200f00U,
    0x9ab31a80U,
    0x2b69a1c0U,
    0xd66922a0U,
    0x84ed3dd0U,
    0xccacc498U,
    0x6a0af2c4U,
    0x87c3e2aU,
    0x40f1632dU,
    0x38cf24b8U,
    0x298c2e3U,
    0xae26063aU,
    0x3b35ff35U,
    0x92aac2acU,
    0x10f0dfbU,
    0x95fefc9fU,
    0x5f326ec3U,
    0xf8afd80eU,
    0xc80bac26U,
    0x657e5e13U,
    0x7a75933aU,
    0x64897ca8U,
    0xf639aef6U,
    0xd9523826U,
    0x75389c08U,
    0x10d3e618U,
    0xd8facf0bU,
    0x95b17a91U,
    0xdced51c7U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x38000000U,
    0x4000000U,
    0x12000000U,
    0xd000000U,
    0xe7800000U,
    0xfec00000U,
    0x7c600000U,
    0xc5700000U,
    0x3580000U,
    0xba3c0000U,
    0xe4ce0000U,
    0x6f550000U,
    0xc60a8000U,
    0x35354000U,
    0x44786000U,
    0xa8ee7000U,
    0xcd055800U,
    0xc7870400U,
    0xeec00200U,
    0x3461f900U,
    0xf973b680U,
    0x155a5e40U,
    0xa538eea0U,
    0xe485a50U,
    0x76126cb8U,
    0x44ace34cU,
    0x8c21ba36U,
    0x8254cd0dU,
    0x118a0c92U,
    0x93f2935eU,
    0x4c1ce213U,
    0x479fc92dU,
    0xc75c0ebaU,
    0x883a6a51U,
    0xf9cbd488U,
    0xc0d5d771U,
    0x4ce001aU,
    0x5f55000bU,
    0x9e0a8027U,
    0x4135401aU,
    0x6e78600cU,
    0xa1ee700fU,
    0x3885582eU,
    0x34470404U,
    0x75200206U,
    0xfd1f903U,
    0x864bb698U,
    0x6a165e6bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0x28000000U,
    0x8c000000U,
    0xfe000000U,
    0x61000000U,
    0x82800000U,
    0xc5400000U,
    0x64e00000U,
    0x32700000U,
    0xc3880000U,
    0x6a6c0000U,
    0x549a0000U,
    0xbb570000U,
    0xb5e8000U,
    0x7ef5c000U,
    0x8fcea000U,
    0xa00bd000U,
    0xedaf1800U,
    0x553eac00U,
    0x5dc7d600U,
    0xd2a12900U,
    0x5b123680U,
    0x4f3fecc0U,
    0x2ec72ea0U,
    0xdf2640f0U,
    0xe5d67888U,
    0xc81ea9dcU,
    0xcf10ee02U,
    0xd53d953fU,
    0x9dc6589dU,
    0x72a0b9d7U,
    0xeb115635U,
    0x6738e93aU,
    0xa2c696aeU,
    0x21233cc9U,
    0x84d6b6a3U,
    0x4a9d2cf4U,
    0xa570e8bU,
    0xb1d850fcU,
    0xafb7c085U,
    0xb12bd5e5U,
    0x81782010U,
    0x33a21032U,
    0x1993b817U,
    0x2a7e7c1eU,
    0xfa244e16U,
    0xc5514521U,
    0xaa5fc08eU,
    0x5c77d5d2U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x58000000U,
    0x34000000U,
    0x5a000000U,
    0x5b000000U,
    0xd0800000U,
    0x19400000U,
    0xf6a00000U,
    0xe3d00000U,
    0x41d80000U,
    0xb07c0000U,
    0xa52e0000U,
    0x70b10000U,
    0x83ef8000U,
    0x55d34000U,
    0x34dbe000U,
    0x81fab000U,
    0x67ed2800U,
    0x17d54c00U,
    0xbbdab600U,
    0x5b786b00U,
    0x7dad5980U,
    0x5f49140U,
    0x1b4e71a0U,
    0xb700dd50U,
    0xfe834798U,
    0xf847f644U,
    0x2d23fe0eU,
    0x7214d709U,
    0x9a3927b8U,
    0xff0f064fU,
    0x5c22b614U,
    0x51946b0dU,
    0x8ffb59a7U,
    0x76e9917cU,
    0x2457f1afU,
    0x161e9d4fU,
    0xb699278aU,
    0x7df065aU,
    0x2d7ab623U,
    0xa8a86b2aU,
    0x84755981U,
    0xd188915eU,
    0xbc6071b0U,
    0xa8b1dd51U,
    0xf7ecc794U,
    0xefd4b643U,
    0x3fd81e1fU,
    0x97e671cU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x28000000U,
    0xfc000000U,
    0x72000000U,
    0x31000000U,
    0x65800000U,
    0x27400000U,
    0xe600000U,
    0x57100000U,
    0xfda80000U,
    0x40cc0000U,
    0x2b5e0000U,
    0x8350000U,
    0x63da8000U,
    0x8f5c000U,
    0x33ff2000U,
    0xb8023000U,
    0xe4047800U,
    0xc6037400U,
    0xcf07fe00U,
    0xe80b500U,
    0x8fc59980U,
    0x3ea59ac0U,
    0x4f37e1a0U,
    0xc15feed0U,
    0xcd349fb8U,
    0x985f9bccU,
    0x34b4a632U,
    0xbd1df133U,
    0x23d01f8eU,
    0x738f5befU,
    0x8b39062fU,
    0xc26012aU,
    0x92f5479eU,
    0xdefb1fccU,
    0xbf80000fU,
    0xaa400023U,
    0x79e00032U,
    0x31500017U,
    0xbe48003eU,
    0xcc9c0026U,
    0xaa960001U,
    0x2ee90037U,
    0xd0ac800bU,
    0x674cc004U,
    0x751ba00fU,
    0xefd2f00bU,
    0x4989d80eU,
    0x3638842fU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0x18000000U,
    0xac000000U,
    0x1e000000U,
    0x9b000000U,
    0x3f800000U,
    0x7a400000U,
    0x91a00000U,
    0xe7500000U,
    0x98180000U,
    0x84bc0000U,
    0x136a0000U,
    0x8cb70000U,
    0x2ee98000U,
    0x5bf34000U,
    0x5fc92000U,
    0x3645000U,
    0x1d35c800U,
    0xe7a81400U,
    0xb1d51600U,
    0x38d89300U,
    0x3bd8dd80U,
    0x685efb40U,
    0xac1f15a0U,
    0xf6bdef70U,
    0x36698388U,
    0x78313c64U,
    0x7329fe0eU,
    0x1c14d70fU,
    0x373803a9U,
    0xe72e7c59U,
    0x3e12de2eU,
    0xa3b8723U,
    0xbfae4b84U,
    0x7dd22855U,
    0xd6df682bU,
    0xe8d8041dU,
    0xe3d87e29U,
    0x645b9709U,
    0xe21b23a0U,
    0x75bd2c61U,
    0xa5ee961bU,
    0x1c70d31aU,
    0x798a7d9aU,
    0xc4c2eb44U,
    0xd5607dbaU,
    0xf235eb76U,
    0xca29fd87U,
    0x1e96ab58U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xe8000000U,
    0x74000000U,
    0x8a000000U,
    0xd7000000U,
    0xcf800000U,
    0x5bc00000U,
    0x2e600000U,
    0x76d00000U,
    0xbdd80000U,
    0x9abc0000U,
    0xaeee0000U,
    0x28710000U,
    0xe4ee8000U,
    0x5f77c000U,
    0xbb6d6000U,
    0x9cb3b000U,
    0x908c800U,
    0x1460d400U,
    0xe9d03a00U,
    0x9659c100U,
    0xd37a8380U,
    0xcb8c4740U,
    0x6f244ba0U,
    0x5ff19350U,
    0xf32cf198U,
    0xf712924cU,
    0x7cbb9222U,
    0x2feba511U,
    0x2ef4f1a0U,
    0x5dae9274U,
    0xda55920bU,
    0x39aa52eU,
    0xa81a71a2U,
    0xa1d95262U,
    0x24b8f20dU,
    0x13e91520U,
    0x40f2b995U,
    0x98a98658U,
    0x5ed0c814U,
    0x69dcd420U,
    0x80be3a2dU,
    0xe1e8c10eU,
    0x7bf403b3U,
    0x412b8758U,
    0x2c112bb4U,
    0xd53e2375U,
    0xb52a39b1U,
    0xe6134679U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0x58000000U,
    0x84000000U,
    0xb2000000U,
    0x95000000U,
    0xd8800000U,
    0xb0400000U,
    0xb3a00000U,
    0x63d00000U,
    0xfc80000U,
    0xf76c0000U,
    0xf73e0000U,
    0x13370000U,
    0x283a8000U,
    0xaab64000U,
    0x8afd6000U,
    0x88567000U,
    0x680e9800U,
    0x45083c00U,
    0x498c4e00U,
    0x3ce8b00U,
    0xc96d0980U,
    0x1c39e9c0U,
    0xb591a0U,
    0xbbfad5d0U,
    0xd2d55fa8U,
    0x15491edcU,
    0xaa29b63eU,
    0x281bc73dU,
    0x2aa35fb2U,
    0x85521ec8U,
    0x548d362cU,
    0x574a8738U,
    0x72cbfbeU,
    0x649e2eddU,
    0x40e0ce2fU,
    0x7ff3cb38U,
    0xd9dce9b6U,
    0xcfc2d9c8U,
    0xe62e9b4U,
    0x98b5d9ceU,
    0x5ff869bdU,
    0x70d399edU,
    0xe84d09b9U,
    0xaea9e9f5U,
    0xae5d91a9U,
    0xbe06d5f7U,
    0xab035f97U,
    0x33821ef5U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x68000000U,
    0x94000000U,
    0x26000000U,
    0x77000000U,
    0x2800000U,
    0x91400000U,
    0xfea00000U,
    0x66100000U,
    0x41980000U,
    0x8dbc0000U,
    0xc2ea0000U,
    0x21d70000U,
    0x687b8000U,
    0xd20ac000U,
    0x9fe56000U,
    0x80b5d000U,
    0x6b8ba800U,
    0x6255c00U,
    0xe256c600U,
    0x24bbfb00U,
    0x8b6e4780U,
    0xa0142540U,
    0x469e6fa0U,
    0x573bb970U,
    0xbfadc988U,
    0x5759274U,
    0xcb682612U,
    0xc014eb11U,
    0xf6988fbbU,
    0x2f38a97cU,
    0x43a901b3U,
    0xb7721e6cU,
    0x9a6ec83eU,
    0xb5908c14U,
    0x655d6e1dU,
    0x40dea73fU,
    0xdb18818cU,
    0x90ffde4aU,
    0x56482813U,
    0xfac39c16U,
    0x8661a61aU,
    0x9752b25U,
    0x616c6f92U,
    0xdd10b94aU,
    0x491c498cU,
    0x11f8526eU,
    0xebcec622U,
    0xed07fb0cU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0x28000000U,
    0xc4000000U,
    0xce000000U,
    0xf5000000U,
    0x6b800000U,
    0x80c00000U,
    0x10a00000U,
    0x7d700000U,
    0x3c680000U,
    0x1f4c0000U,
    0xfefa0000U,
    0xc0350000U,
    0xa50f8000U,
    0xdb1cc000U,
    0x1023e000U,
    0x8b301000U,
    0xe38e7800U,
    0xec594400U,
    0x72459200U,
    0x31e68f00U,
    0x36173080U,
    0x1f39b9c0U,
    0x9d16c8a0U,
    0x89bc3df0U,
    0x8250ba98U,
    0x2fdaa2c4U,
    0xf681f212U,
    0xf465f35U,
    0x6e60a881U,
    0x60d5edf8U,
    0xc69aa283U,
    0xa9e336dcU,
    0xca13f835U,
    0xdd3c8406U,
    0xb213f223U,
    0xf13f5f3dU,
    0x5815288dU,
    0x1a3c2de4U,
    0xee96c290U,
    0x357fe6ecU,
    0xb0f66014U,
    0xada9d01fU,
    0x9a6a182cU,
    0xe499432U,
    0x6b7a0a29U,
    0x4df6db2eU,
    0x32295a96U,
    0x2cafb2ebU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x8000000U,
    0xc000000U,
    0x32000000U,
    0xc5000000U,
    0x7e800000U,
    0x60c00000U,
    0xd2600000U,
    0x8db00000U,
    0x6e80000U,
    0x60c0000U,
    0x897a0000U,
    0xb0f30000U,
    0xd9cb8000U,
    0xc99c000U,
    0xa106a000U,
    0x3086b000U,
    0x2fc25800U,
    0xfde08c00U,
    0xa5f6fa00U,
    0x4f4f9100U,
    0xd05a4080U,
    0xd96515c0U,
    0x7c3398a0U,
    0x69ac59f0U,
    0x6c2bc2a8U,
    0x456978d4U,
    0x6c49da2aU,
    0xbddfe117U,
    0x8c273886U,
    0xdf15e9d6U,
    0xe9381ab1U,
    0x155334daU,
    0x8d9a000fU,
    0x183001eU,
    0x17438020U,
    0xde25c01dU,
    0x6a14a019U,
    0x2fb9b03cU,
    0xe193d806U,
    0x69fa4c07U,
    0x7733da17U,
    0x982ce118U,
    0x36cb8a0U,
    0x2f4c29d2U,
    0xa05eba89U,
    0x616584fdU,
    0xe830582aU,
    0x5faf8c21U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0xa8000000U,
    0x24000000U,
    0x92000000U,
    0xc9000000U,
    0xca800000U,
    0xf9c00000U,
    0x36a00000U,
    0xf2500000U,
    0xbce80000U,
    0x4ccc0000U,
    0x315a0000U,
    0x40170000U,
    0xd0c8000U,
    0x1bfbc000U,
    0xfc41e000U,
    0x96e3f000U,
    0x4ab17800U,
    0x815e4c00U,
    0x8817b200U,
    0x790b9f00U,
    0xd1fa3180U,
    0xb9465cc0U,
    0xea67c9a0U,
    0xe873d0f0U,
    0xb4799b88U,
    0x4907bfccU,
    0xa80d222U,
    0x59c4af05U,
    0xc6a629a6U,
    0x5a5020c7U,
    0x98e8e39cU,
    0xdec9f3f5U,
    0xf85f6013U,
    0x8a93303cU,
    0xf4ce1812U,
    0x2d5d7c24U,
    0xe11aa20U,
    0x2a0ae304U,
    0x6799bb6U,
    0xb007bfc9U,
    0xc800d22fU,
    0x7404af01U,
    0xca0629a4U,
    0x450020d0U,
    0x7c80e3a6U,
    0xa2c5f3e1U,
    0x35256027U,
    0xc1143038U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xf8000000U,
    0xdc000000U,
    0x32000000U,
    0x53000000U,
    0xd2800000U,
    0x62c00000U,
    0xe1e00000U,
    0x85100000U,
    0xf3a80000U,
    0x44cc0000U,
    0x7d1e0000U,
    0x86550000U,
    0xf2098000U,
    0xdaf84000U,
    0x2647a000U,
    0x7e21b000U,
    0xb7766800U,
    0x85fadc00U,
    0x1ec23a00U,
    0xe3e7fd00U,
    0x5e103980U,
    0x152836c0U,
    0x300fd1a0U,
    0x21faaad0U,
    0xb0c24bb8U,
    0xe2e0e7d4U,
    0xcf921a06U,
    0x5d6b0d23U,
    0x6f2871aaU,
    0x770b1ae7U,
    0x957c23a6U,
    0x87063bebU,
    0x94862038U,
    0x47c5f039U,
    0x9e67c816U,
    0xac526c1bU,
    0x2d0bd229U,
    0xa27c6132U,
    0xdb8223a7U,
    0x87433bcaU,
    0xdfa7a006U,
    0x7731b021U,
    0xeede6804U,
    0x5e36dc3cU,
    0x7b5c3a3eU,
    0x8872fd01U,
    0xad79b992U,
    0x7b0076dfU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0xb8000000U,
    0x54000000U,
    0xf2000000U,
    0xb7000000U,
    0x3e800000U,
    0x56c00000U,
    0x11e00000U,
    0xe6500000U,
    0x86e80000U,
    0xbb8c0000U,
    0xec1e0000U,
    0x9d950000U,
    0xd2898000U,
    0xe39a4000U,
    0xc0d1e000U,
    0xb429f000U,
    0x906f0800U,
    0x41489c00U,
    0x3bfc9a00U,
    0x2ec37d00U,
    0x65e36380U,
    0x645326c0U,
    0x99edeba0U,
    0x690dfad0U,
    0x1cde91b8U,
    0xc97277d4U,
    0xbd5b7a16U,
    0xd338d01U,
    0x3c7beb8aU,
    0xaf84fafcU,
    0x6d4111bdU,
    0xaea137fdU,
    0x8ff51a0fU,
    0x9f993d15U,
    0x9ed2839cU,
    0xc52ad6d3U,
    0xfbeae3acU,
    0x260966d8U,
    0x165c0ba5U,
    0x7db40addU,
    0xa3b999a2U,
    0x81e6ebdfU,
    0x1e51e02fU,
    0xb2e9f03eU,
    0x598f0805U,
    0xe3189c16U,
    0xf7149a25U,
    0x764f7d09U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0x88000000U,
    0xb4000000U,
    0x22000000U,
    0xdf000000U,
    0x85800000U,
    0xc6c00000U,
    0xe2e00000U,
    0x51d00000U,
    0x4d80000U,
    0x51bc0000U,
    0x1aa0000U,
    0xe110000U,
    0xe6bc8000U,
    0xc02ac000U,
    0x2d26000U,
    0x5f5df000U,
    0xbe7cc800U,
    0xabcc0400U,
    0x4b840200U,
    0xf7c53d00U,
    0xc6628780U,
    0x6b970b40U,
    0xd07acfa0U,
    0xcacdcf70U,
    0xd706adb8U,
    0xf184027cU,
    0x84c4621aU,
    0xde5cd11U,
    0x5c50cfb2U,
    0x761ccf56U,
    0x915a2dabU,
    0x8f7ec25bU,
    0x8f4e0229U,
    0x71c43d2eU,
    0x236607a2U,
    0x5d11cb50U,
    0xbd3aafb3U,
    0x2fed3f69U,
    0xa8b4e5a9U,
    0x1acfc65dU,
    0xaf04803aU,
    0xad86c010U,
    0x22c0601dU,
    0x78e0f01bU,
    0xb2d24837U,
    0x175bc43cU,
    0x6a78e224U,
    0xb9cf0d2cU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0x88000000U,
    0xec000000U,
    0xa000000U,
    0x85000000U,
    0x7800000U,
    0xb2c00000U,
    0xbbe00000U,
    0x9900000U,
    0x5a380000U,
    0x345c0000U,
    0xde0e0000U,
    0x76570000U,
    0x6a5c8000U,
    0x550ec000U,
    0xc2d2a000U,
    0x28187000U,
    0xbaa99800U,
    0x23e18400U,
    0xfd91a200U,
    0xe439c500U,
    0x2f5bbd80U,
    0x328e7640U,
    0xa016a5a0U,
    0xebfd3250U,
    0xd73ba7a8U,
    0x9fdb876cU,
    0x46cd020aU,
    0xb8b6b517U,
    0xec4ea5a8U,
    0x51f13266U,
    0x476da781U,
    0x7a808766U,
    0x91478205U,
    0xcf237523U,
    0xcd768593U,
    0x592c8264U,
    0x37241f8fU,
    0xe970b358U,
    0x9f299810U,
    0x48218424U,
    0xe3f1a218U,
    0xc669c52bU,
    0x4b03bd9cU,
    0xd4827642U,
    0x9240a5a3U,
    0x97a63276U,
    0x853127b0U,
    0x338e4777U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0xd8000000U,
    0x34000000U,
    0xee000000U,
    0x4d000000U,
    0x79800000U,
    0xf8c00000U,
    0xe7600000U,
    0xe8700000U,
    0x92b80000U,
    0x665c0000U,
    0x5dee0000U,
    0xd0b70000U,
    0x15db8000U,
    0xbe2b4000U,
    0x751e000U,
    0x5aeb1000U,
    0x92313800U,
    0xcd9a9400U,
    0x260c0200U,
    0x65836100U,
    0x8ac76680U,
    0x98656940U,
    0xcef5dea0U,
    0x5cf8bd50U,
    0x977e3ca8U,
    0x70bbcc54U,
    0x815de21eU,
    0x6f687119U,
    0xe0f65e85U,
    0x71fffd5aU,
    0xdef9dcb3U,
    0x407bdc70U,
    0x8a395a34U,
    0x5d1ea503U,
    0xd1483cbdU,
    0x2320cc54U,
    0x2506227U,
    0x8f683119U,
    0x90f23e9bU,
    0x99f8ad6bU,
    0x22fa84a2U,
    0x427d1854U,
    0x1d3b802eU,
    0x879b402eU,
    0x1d09e03fU,
    0x45071026U,
    0xf5873829U,
    0x12c19433U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x50000000U,
    0xf8000000U,
    0xc4000000U,
    0x56000000U,
    0xa5000000U,
    0x18800000U,
    0x98400000U,
    0x9e200000U,
    0x47500000U,
    0xfc80000U,
    0xa36c0000U,
    0xab7a0000U,
    0xa1130000U,
    0xc8ed8000U,
    0x4eb84000U,
    0x9ff16000U,
    0xd9dc5000U,
    0x60063800U,
    0xb0041c00U,
    0x8801ce00U,
    0x6c06e700U,
    0x6a025180U,
    0x370579c0U,
    0xeb81e9a0U,
    0x25c525f0U,
    0x1ee347a8U,
    0x413092e4U,
    0xd6b8ae16U,
    0xebf6b715U,
    0x7de69a3U,
    0xa90265ccU,
    0xc285a78dU,
    0x274782ceU,
    0x19a2761cU,
    0x896bb3aU,
    0x2628ff94U,
    0x9dccefaU,
    0x58000005U,
    0x54000039U,
    0x8e000000U,
    0x31000008U,
    0xb6800020U,
    0xf940000bU,
    0xd0a0003cU,
    0x7a100019U,
    0x89680032U,
    0x7c7c0027U,
    0x3a92001fU,
    0x452f0010U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x58000000U,
    0xfc000000U,
    0x2a000000U,
    0xfd000000U,
    0x72800000U,
    0x92400000U,
    0xc0e00000U,
    0xe8700000U,
    0x81680000U,
    0x4d0c0000U,
    0x343e0000U,
    0x44310000U,
    0xa28b8000U,
    0x44ff4000U,
    0xae95a000U,
    0xa6197000U,
    0x5fe4d800U,
    0x63f36c00U,
    0x87aace00U,
    0x40ad3100U,
    0x372fae80U,
    0x1befd3c0U,
    0xeb48f6a0U,
    0x9adfffd0U,
    0x57419898U,
    0xde66bee4U,
    0xe8376e0eU,
    0x9088411bU,
    0xa5fd76a4U,
    0x2611bff4U,
    0x915fb8a0U,
    0x11808ef4U,
    0x33c6163eU,
    0x3b225d05U,
    0x975360a2U,
    0x103fe2c6U,
    0xd232d821U,
    0x958e6c28U,
    0x1b7f4e2bU,
    0x1653713cU,
    0x8b98eb4U,
    0x5d75e3c8U,
    0xf7ef8eaeU,
    0x3948e3e6U,
    0xabda0eb4U,
    0x87c6a3e3U,
    0x15242ea0U,
    0x8c5093efU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xb8000000U,
    0x6c000000U,
    0x22000000U,
    0x83000000U,
    0x93800000U,
    0xdfc00000U,
    0xbaa00000U,
    0x58300000U,
    0x65780000U,
    0xa75c0000U,
    0x172a0000U,
    0x1350000U,
    0x39fc8000U,
    0x991b4000U,
    0xf9492000U,
    0xa422b000U,
    0x9572e800U,
    0x409ed400U,
    0x1895a00U,
    0x9b020700U,
    0x6f868280U,
    0x15c72b40U,
    0x5da2eaa0U,
    0x3db7bf70U,
    0x77be1098U,
    0x2f7c485cU,
    0x805b5a36U,
    0x92ab0707U,
    0xa3f0029eU,
    0x9d96b57U,
    0x626f4aa2U,
    0x48d24f7cU,
    0xbd2fd89aU,
    0x96352c5dU,
    0x47c6825U,
    0x57dc940fU,
    0xeb6efa2cU,
    0xdc52f728U,
    0xb76bca90U,
    0x86550f43U,
    0xb86cf897U,
    0x87d29c7eU,
    0x5caa001eU,
    0xc2f5000bU,
    0xf95c803fU,
    0x9e2b4017U,
    0x95b1200aU,
    0x33beb007U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0xe8000000U,
    0x1c000000U,
    0xc2000000U,
    0xf000000U,
    0x38800000U,
    0x6f400000U,
    0x6b600000U,
    0x5cb00000U,
    0x23080000U,
    0xe3ec0000U,
    0x6a9e0000U,
    0xe2b30000U,
    0x9e0b8000U,
    0xc6ac000U,
    0x595d2000U,
    0xd092b000U,
    0x78dd0800U,
    0x86556c00U,
    0xc17be600U,
    0x65415500U,
    0xa862cc80U,
    0xee354ac0U,
    0xcf4a44a0U,
    0x9a09e6d0U,
    0x4a6f0288U,
    0x505cc3f4U,
    0x4113e632U,
    0x161d5533U,
    0x6bf4cca2U,
    0x6c6a4ae0U,
    0x295fc4a4U,
    0x89026cfU,
    0x1cd9a2acU,
    0xb054b3fbU,
    0x107bce2eU,
    0x90c68907U,
    0xf0a422aaU,
    0xd29173f7U,
    0x97db6e11U,
    0x8ed1f90cU,
    0xd6398aa7U,
    0xfa236fe4U,
    0x2ad52029U,
    0x3eb035U,
    0x1b230828U,
    0xa7566c3cU,
    0xacf86605U,
    0xf987951cU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x90000000U,
    0x68000000U,
    0xc4000000U,
    0xc6000000U,
    0x6b000000U,
    0xa1800000U,
    0x32400000U,
    0x55200000U,
    0xbff00000U,
    0xa5080000U,
    0x86ac0000U,
    0x9a0000U,
    0x8bf30000U,
    0x7b0b8000U,
    0xf1aac000U,
    0x5b1be000U,
    0xb8b05000U,
    0xe6a8c800U,
    0x709aa400U,
    0x53f42600U,
    0x470a6700U,
    0x9bac0c80U,
    0x321fdac0U,
    0xb43544a0U,
    0x1e6cbef0U,
    0xb67902a8U,
    0x8b6049d4U,
    0x8d42632U,
    0x7fa6725U,
    0x11240ca3U,
    0xb9f3dacfU,
    0xee0f44a3U,
    0xb72fbed7U,
    0x5ada82a4U,
    0x1ad689edU,
    0x2fdc626U,
    0x3fa53727U,
    0x7c35449fU,
    0x8a6cbee3U,
    0x38790294U,
    0xb46049e8U,
    0x754262cU,
    0x9aba671dU,
    0x23840cb7U,
    0x5f43dad9U,
    0xbfa7448cU,
    0xbc33bed4U,
    0xaa68828dU,
    0xa87989fcU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0x48000000U,
    0x4c000000U,
    0x7a000000U,
    0xa1000000U,
    0x3800000U,
    0x15c00000U,
    0x49600000U,
    0x89700000U,
    0x57d80000U,
    0x963c0000U,
    0x500e0000U,
    0x7cf70000U,
    0xf91c8000U,
    0xadd8c000U,
    0x7739a000U,
    0x738cf000U,
    0x99343800U,
    0xf8780400U,
    0x68af1a00U,
    0x5ae08900U,
    0x44b35680U,
    0xcabe9a40U,
    0x914deea0U,
    0xd8d55e50U,
    0x7e49d4a8U,
    0x6456e76cU,
    0x2f0b9a3aU,
    0x5874493fU,
    0x5c5cf684U,
    0xeff96a47U,
    0x936b56acU,
    0x1c829a6eU,
    0xe143eea4U,
    0x54225e63U,
    0xcf5554bdU,
    0x858e277dU,
    0x22323a37U,
    0x8af8b90fU,
    0xc6e8cebbU,
    0x2416e53U,
    0xb2a44c89U,
    0xcf121364U,
    0xf228b834U,
    0x8a0c40fU,
    0xe16ba28U,
    0x21ac7906U,
    0xa5676e8cU,
    0x43769e52U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x78000000U,
    0x4c000000U,
    0xbe000000U,
    0x2d000000U,
    0x95800000U,
    0xcf400000U,
    0x7aa00000U,
    0xd9700000U,
    0xf380000U,
    0xeb1c0000U,
    0x39aa0000U,
    0xb0f10000U,
    0xa67a8000U,
    0x60bb4000U,
    0x435c2000U,
    0x698d5000U,
    0x50407800U,
    0xdc217400U,
    0x3eb69e00U,
    0xa75ad300U,
    0xb38a5c80U,
    0x67453340U,
    0x1ea2a4a0U,
    0xc3720770U,
    0x58389ab8U,
    0xd99fc44cU,
    0xbc6c1e26U,
    0x391931fU,
    0x726e7ca9U,
    0x96946364U,
    0xcbe8dcb4U,
    0x17d2735bU,
    0xe44c84acU,
    0x17225742U,
    0x9a30629eU,
    0xab98f060U,
    0xef6e201aU,
    0xdb105034U,
    0xd8a8f828U,
    0x5b773419U,
    0x243a3e3dU,
    0x7f9dc333U,
    0x2d6c84baU,
    0x50125741U,
    0xdc28629dU,
    0xc7b4f067U,
    0xf0dc2035U,
    0xf7cd5033U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0x18000000U,
    0x94000000U,
    0xe000000U,
    0x13000000U,
    0x71800000U,
    0x3400000U,
    0x31a00000U,
    0x20100000U,
    0x27480000U,
    0x726c0000U,
    0xffbe0000U,
    0x21970000U,
    0xcc0f8000U,
    0x7fc94000U,
    0xcdaee000U,
    0x97db1000U,
    0x46e7c800U,
    0xefb42400U,
    0xbc5aee00U,
    0x38a68b00U,
    0xc961f80U,
    0x668f73c0U,
    0xa10857a0U,
    0xf54917d0U,
    0x836dd9a8U,
    0xb73accf4U,
    0xc6556e2eU,
    0x106fcb11U,
    0x86b8ff8dU,
    0xe51463c5U,
    0xb1cf9fb9U,
    0xbead33f1U,
    0x565f37bbU,
    0xcda047f8U,
    0x521571b7U,
    0x64bb8c5U,
    0x2e92817U,
    0x1c7f3409U,
    0xebf52614U,
    0xb27eaf0eU,
    0x28f2f1aaU,
    0xfbfef8dbU,
    0x2fb1c82bU,
    0xdc5f2401U,
    0x88a36e23U,
    0x8494cb28U,
    0xea897fb2U,
    0x3b0a23caU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0x78000000U,
    0x34000000U,
    0x22000000U,
    0x6f000000U,
    0x43800000U,
    0xe8400000U,
    0x8f200000U,
    0x32b00000U,
    0x38480000U,
    0x4dec0000U,
    0x799e0000U,
    0x5a330000U,
    0x89888000U,
    0xd18d4000U,
    0x558be000U,
    0xaf887000U,
    0x48f4800U,
    0x1d0f3400U,
    0xae48c600U,
    0x40eed700U,
    0xf51e2680U,
    0x1f2bac0U,
    0x96efeea0U,
    0x581fced0U,
    0x7d724888U,
    0xb52b29ecU,
    0x737e4616U,
    0xd6e09721U,
    0xf2d546beU,
    0x2a5b8aeaU,
    0x495546a6U,
    0xb61b8afcU,
    0x447546b3U,
    0x1bab8ac1U,
    0x47bd46abU,
    0x8a078ac4U,
    0x930346adU,
    0x8d848af3U,
    0x6143c6bcU,
    0xf9a5caf1U,
    0xc2762684U,
    0x3eaebac5U,
    0x7739ee95U,
    0xbfc0cec7U,
    0xf564c882U,
    0xa9569f5U,
    0x8d7d2608U,
    0xc7e5a72aU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0xd8000000U,
    0xe4000000U,
    0x3e000000U,
    0x13000000U,
    0x8b800000U,
    0x19c00000U,
    0x56a00000U,
    0x27700000U,
    0x6a880000U,
    0xceac0000U,
    0x4e9a0000U,
    0x37f30000U,
    0x14ce8000U,
    0x93ca4000U,
    0x1e4a6000U,
    0xe08b1000U,
    0xebacc800U,
    0xfa197400U,
    0x97b76a00U,
    0x4aa8b700U,
    0xa09f4880U,
    0xecf78ec0U,
    0x934f00a0U,
    0x880bbaf0U,
    0x81ee8aa8U,
    0x617d5dfcU,
    0x63ea1eU,
    0xf051f705U,
    0xb13ba8b1U,
    0x6606def1U,
    0x3701a8bbU,
    0x9585decbU,
    0x3ac72890U,
    0x5239ef7U,
    0xdab748b3U,
    0x22b8ef9U,
    0xfadd008dU,
    0xaf94baf6U,
    0xe09a0abfU,
    0xcf41dddU,
    0x834f0a37U,
    0x600ca71fU,
    0xbdef00a4U,
    0xbb7bbaefU,
    0x2d668abfU,
    0x68d15de8U,
    0x2379ea2bU,
    0x2962f73aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x78000000U,
    0x34000000U,
    0x86000000U,
    0x53000000U,
    0xb800000U,
    0xc7c00000U,
    0xd8e00000U,
    0x80f00000U,
    0x69180000U,
    0xab7c0000U,
    0x3ace0000U,
    0x68770000U,
    0x8d5b8000U,
    0xd85e4000U,
    0xc0dce000U,
    0x2c995000U,
    0x23b88800U,
    0x3aab400U,
    0xde411a00U,
    0x9a257500U,
    0x5891b680U,
    0x1ad9c40U,
    0x2344bea0U,
    0xaea26850U,
    0x36d4c4a8U,
    0xb38b0d54U,
    0x17d49a36U,
    0xd0c3519U,
    0xb896d6b7U,
    0x71aa8c5dU,
    0x6b40d69dU,
    0xf2a18c78U,
    0xfcd556bdU,
    0x5288cc51U,
    0xc9523698U,
    0x924fdc62U,
    0xac365eb5U,
    0xee7c385dU,
    0x5a4fcca2U,
    0xb033f97aU,
    0x47f603eU,
    0xab4b103bU,
    0x16b26802U,
    0xaf38e41bU,
    0x39ec1210U,
    0xda668115U,
    0x95b7cc8bU,
    0xbcbff965U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x18000000U,
    0x4000000U,
    0x7a000000U,
    0x1f000000U,
    0x14800000U,
    0x85400000U,
    0xfd200000U,
    0xfe300000U,
    0xd9980000U,
    0x21fc0000U,
    0xe2ea0000U,
    0xa5410000U,
    0x2d268000U,
    0xf6304000U,
    0xb59b6000U,
    0x47ff3000U,
    0x83e90800U,
    0xd4c28c00U,
    0xa3e2f600U,
    0x9ad32700U,
    0x33cf5280U,
    0x9d71e440U,
    0x85bd3aa0U,
    0xce4c5870U,
    0xc5b6c4b8U,
    0xf05df36cU,
    0x4d9b603eU,
    0xf3ff302dU,
    0x81e90800U,
    0xbfc28c1aU,
    0xd562f61dU,
    0x4932727U,
    0xa06f52a4U,
    0xf901e459U,
    0xb5853aacU,
    0x94c05866U,
    0x3e4c489U,
    0x8ad0f372U,
    0x5bcfe03bU,
    0x81727031U,
    0xfbbee81eU,
    0xab4cfc1fU,
    0xce361e1bU,
    0x619edb3eU,
    0x35ffcc81U,
    0xf0ef7f5bU,
    0xa6419628U,
    0x47a01712U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x88000000U,
    0x6c000000U,
    0xa2000000U,
    0x4f000000U,
    0x35800000U,
    0x33400000U,
    0x3a00000U,
    0x6100000U,
    0x98980000U,
    0x187c0000U,
    0x75ce0000U,
    0x57430000U,
    0x8da48000U,
    0x4b12c000U,
    0x921ca000U,
    0x96be3000U,
    0x292a0800U,
    0xf0f5c400U,
    0x5c2ece00U,
    0xfe76eb00U,
    0xccef1780U,
    0xb797d940U,
    0xf5d9bfa0U,
    0xaedc2d50U,
    0x9d5d7988U,
    0x8f1f024cU,
    0x243ca02aU,
    0xe3ee3017U,
    0x12120822U,
    0x9e99c414U,
    0x3978ce07U,
    0xdd49eb04U,
    0x968597a5U,
    0xe4c6195eU,
    0xdfe19f8bU,
    0x4030dd5bU,
    0x25cbd1b3U,
    0xef44f65eU,
    0xc9a06632U,
    0xf5111f16U,
    0xf71dd1b8U,
    0x803bf676U,
    0x8deae62aU,
    0x8f10df1fU,
    0x6c1df1b4U,
    0x53bb0664U,
    0x4faa4e07U,
    0xdc342b2eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x98000000U,
    0xc4000000U,
    0xb6000000U,
    0xc9000000U,
    0x8d800000U,
    0xed400000U,
    0x51600000U,
    0xeeb00000U,
    0x9e880000U,
    0xaac0000U,
    0xd97e0000U,
    0x33470000U,
    0xd4618000U,
    0xa9374000U,
    0x98c86000U,
    0x314b5000U,
    0x5a0bd800U,
    0x2a689400U,
    0x4558ce00U,
    0xdc90cd00U,
    0x3c59f480U,
    0xf911dac0U,
    0xfd1a4ca0U,
    0x12721ed0U,
    0x30a95aa8U,
    0xba7a47c4U,
    0x25c0600eU,
    0x9ba75035U,
    0xc995d803U,
    0x83df9417U,
    0x4b514e28U,
    0xb8fb8d38U,
    0x407949aU,
    0xd6018af2U,
    0xb90614b0U,
    0x4586cad2U,
    0xb14674adU,
    0x23619af1U,
    0x91b3acaaU,
    0xda0e0ed1U,
    0x6a6ae286U,
    0x655983edU,
    0x8c937605U,
    0xa45f0910U,
    0x3d14e295U,
    0x4b1e83e6U,
    0xdb72f633U,
    0xbd284912U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x58000000U,
    0x34000000U,
    0x92000000U,
    0xc5000000U,
    0x12800000U,
    0x36c00000U,
    0xf1600000U,
    0xd2900000U,
    0xbc080000U,
    0x2fac0000U,
    0x4e5e0000U,
    0x5dc10000U,
    0x78e18000U,
    0xe5d14000U,
    0xf62fe000U,
    0x811bf000U,
    0x53e51800U,
    0x8c572c00U,
    0x516c8a00U,
    0x933ce900U,
    0xc955c980U,
    0x3eccfc0U,
    0x45ff31a0U,
    0xa83013d0U,
    0x897ea398U,
    0xcdf7d6f4U,
    0x1599e00eU,
    0x226f039U,
    0x82b2980aU,
    0x5bbb6c18U,
    0x1694ea36U,
    0xa60b5931U,
    0x66a8b19cU,
    0x6adc53c8U,
    0x6406c3b7U,
    0x6a0066e2U,
    0x81049818U,
    0x48866c1cU,
    0x9fc36a0cU,
    0x45e7190cU,
    0xb350d182U,
    0x9aebe3f2U,
    0xd97bbbb7U,
    0x35f0fad6U,
    0x519d6a1dU,
    0x5826192aU,
    0x2bb1518fU,
    0xef3aa3d1U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x58000000U,
    0x1c000000U,
    0x96000000U,
    0xcd000000U,
    0x3800000U,
    0xccc00000U,
    0x31e00000U,
    0x29500000U,
    0xcab80000U,
    0xfb9c0000U,
    0x7d2e0000U,
    0x7c10000U,
    0x17628000U,
    0x42124000U,
    0x4d9da000U,
    0xe02a9000U,
    0x4c443800U,
    0x6fa7c400U,
    0xa1f09200U,
    0x23cab500U,
    0x72108380U,
    0xb598c040U,
    0xec291ba0U,
    0x72459450U,
    0xe6a5b198U,
    0x2874e56cU,
    0xb40ba00eU,
    0x8d77902bU,
    0x5388b80bU,
    0xdbb48408U,
    0x916fb233U,
    0x78626507U,
    0x1e911ba9U,
    0x25d9944aU,
    0xb58bb19eU,
    0xeb5e557U,
    0x6ee92039U,
    0xd2a5d019U,
    0xba751806U,
    0x130e1414U,
    0x25f38a3aU,
    0x9c9a11dU,
    0x391789a0U,
    0xd31e2173U,
    0x676fb204U,
    0x5626502U,
    0xa5111ba1U,
    0x5199476U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x30000000U,
    0xd8000000U,
    0x94000000U,
    0xbe000000U,
    0x29000000U,
    0x99800000U,
    0x29400000U,
    0x86a00000U,
    0xd9d00000U,
    0x11980000U,
    0x827c0000U,
    0x8f0a0000U,
    0x14410000U,
    0x61248000U,
    0xb9944000U,
    0x3ebbe000U,
    0xaaeb9000U,
    0x8c321800U,
    0xf1ed7400U,
    0xd6b24e00U,
    0xb628f300U,
    0xf9d6d180U,
    0x819ca740U,
    0xa7f29a0U,
    0xf30a4370U,
    0xe6477fb8U,
    0x6223c47cU,
    0xb711e00eU,
    0xa77a9019U,
    0x9c8e9801U,
    0xfa053423U,
    0xbf03ae3fU,
    0x9c826325U,
    0xaac049a8U,
    0xe0e59376U,
    0x7bf687a3U,
    0xc689206cU,
    0x1503b63eU,
    0xcb82172fU,
    0x7a448791U,
    0x60242062U,
    0xc15360dU,
    0xdfb571eU,
    0x6349e7a5U,
    0x7166f074U,
    0xeeb24e08U,
    0xd228f312U,
    0xffd6d1baU,
    0xc9ca761U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x30000000U,
    0xa8000000U,
    0xc4000000U,
    0x72000000U,
    0xb3000000U,
    0x36800000U,
    0x9cc00000U,
    0xdfa00000U,
    0x1af00000U,
    0x5be80000U,
    0xda8c0000U,
    0xc4da0000U,
    0xd7470000U,
    0x88e28000U,
    0x5211c000U,
    0xa9fae000U,
    0x4374f000U,
    0x2fae2800U,
    0x3ceebc00U,
    0xc60b4a00U,
    0x2719ef00U,
    0xb8626c80U,
    0x67d0a5c0U,
    0x97dea4a0U,
    0xb1c6e9f0U,
    0x2c21c688U,
    0xd1b6bafcU,
    0xad0a6022U,
    0x1d9e300dU,
    0x2a4481eU,
    0xe1708c11U,
    0x64af023bU,
    0xf669633aU,
    0x74cd6ea6U,
    0x55b9c6cdU,
    0x9113ca0cU,
    0x577f2f27U,
    0x8bb20cb8U,
    0x1a0995c9U,
    0xf9186c8fU,
    0x1d67a5d6U,
    0xa05424adU,
    0x269b29e1U,
    0x2126acU,
    0x7b54ae1U,
    0xfc0ec819U,
    0x1d4c31U,
    0xc4e7e211U,
    0x1416931fU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x58000000U,
    0x4c000000U,
    0x56000000U,
    0x89000000U,
    0x4a800000U,
    0xa9c00000U,
    0xc0e00000U,
    0xf500000U,
    0x2b280000U,
    0xcc0c0000U,
    0x86be0000U,
    0x5e410000U,
    0xc9a78000U,
    0x51774000U,
    0x631a2000U,
    0x49361000U,
    0x9bbe9800U,
    0x4ec7ac00U,
    0x5f63d200U,
    0x214dd00U,
    0xd70bd380U,
    0x473b54c0U,
    0xce076ba0U,
    0x6506e8d0U,
    0xac842198U,
    0x28c499c4U,
    0x9e63a00eU,
    0xbc905017U,
    0x34cb383bU,
    0xdafc25U,
    0x4ed16a11U,
    0xfb68611bU,
    0x80af19b7U,
    0x2b4e65cbU,
    0x4d9aca08U,
    0x52f4310aU,
    0x205a21a3U,
    0x901599f3U,
    0x5c0c202fU,
    0x7ebb1033U,
    0xa2471826U,
    0x97a1ec27U,
    0xcc767208U,
    0x33998d2cU,
    0x3ff16b8cU,
    0x98dbe8e0U,
    0xa2d5a1bcU,
    0x1d6ed9cbU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x50000000U,
    0x78000000U,
    0xc000000U,
    0x8a000000U,
    0x51000000U,
    0x43800000U,
    0x27c00000U,
    0xaa600000U,
    0xd4900000U,
    0xc6980000U,
    0xa93c0000U,
    0x92ca0000U,
    0xb5470000U,
    0xe218000U,
    0xf9344000U,
    0xe8692000U,
    0xc333f000U,
    0xf168b800U,
    0x4b5c400U,
    0x78ad2a00U,
    0x1d4b100U,
    0x38be2980U,
    0x780b5340U,
    0xea7b1a0U,
    0xf0716770U,
    0x24482388U,
    0xef071264U,
    0xf482a016U,
    0x4f40b027U,
    0xb7201814U,
    0x6eb27403U,
    0x19acb22cU,
    0xca52851eU,
    0x3b7bbb98U,
    0x2c6a2668U,
    0xd34b22bU,
    0xae6e8526U,
    0xb831bb97U,
    0xb3ed2666U,
    0x18f53228U,
    0xf90ac50aU,
    0xf5209b97U,
    0x7bb2d663U,
    0x542f8a2bU,
    0x12940135U,
    0x7d9e31b8U,
    0x4bb92744U,
    0xde8b03b3U,
    0x4ce3e24fU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x48000000U,
    0xf4000000U,
    0x62000000U,
    0x35000000U,
    0x9f800000U,
    0x6400000U,
    0xcde00000U,
    0x51100000U,
    0x13380000U,
    0x469c0000U,
    0x196a0000U,
    0x23c70000U,
    0x82a38000U,
    0x3577c000U,
    0x36d6000U,
    0x7ac2f000U,
    0x63231800U,
    0x80334400U,
    0x4e0de600U,
    0x7314e100U,
    0x463d7580U,
    0x691e6e40U,
    0x472b0da0U,
    0x5223da70U,
    0x45b7f388U,
    0x714f7f74U,
    0xef76e01aU,
    0xfa693009U,
    0x8b447822U,
    0x9e66b434U,
    0x39557e2dU,
    0x25dc6531U,
    0x630ff38cU,
    0x30937f58U,
    0x667ce030U,
    0xabfe3034U,
    0xbff819U,
    0x4edd7409U,
    0x9f8a1e30U,
    0x5e559529U,
    0x175d6bbeU,
    0xe6ccfb56U,
    0x7d35e63fU,
    0xe588e102U,
    0xb7577590U,
    0xaed96e72U,
    0xef888dacU,
    0xa6541a7aU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xb0000000U,
    0xf8000000U,
    0xac000000U,
    0x12000000U,
    0x65000000U,
    0x23800000U,
    0xe5c00000U,
    0x29e00000U,
    0xc4b00000U,
    0xb5f80000U,
    0x1fdc0000U,
    0x598a0000U,
    0x24470000U,
    0x31268000U,
    0x72d74000U,
    0xce8f2000U,
    0xb2c63000U,
    0x1f60d800U,
    0x5af7a400U,
    0x65d89a00U,
    0x188cbd00U,
    0xe1c72480U,
    0xbfe15540U,
    0xf7b0dca0U,
    0x57cc170U,
    0xfa9a9e88U,
    0x6d2cd85cU,
    0x7851a036U,
    0xcacd7037U,
    0xf3e5f812U,
    0x35b6941eU,
    0x887ec232U,
    0x3d1c590bU,
    0xcee89e86U,
    0x8ab7d851U,
    0x5afd200fU,
    0xe55d303fU,
    0xc5cc5819U,
    0xd967e413U,
    0x41f13a09U,
    0x915dcd39U,
    0xbc8dcadU,
    0xf660c160U,
    0x1b709e90U,
    0xbd1bd86fU,
    0xeef202fU,
    0x2ab63011U,
    0xeaf8d81dU,
    0x1d5ba43fU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0x78000000U,
    0x14000000U,
    0x3a000000U,
    0x6d000000U,
    0xff800000U,
    0xec400000U,
    0x6c600000U,
    0xe5d00000U,
    0xd8180000U,
    0xcd3c0000U,
    0x6f0a0000U,
    0xa4830000U,
    0xa0c78000U,
    0x60a24000U,
    0x8b73e000U,
    0x146ab000U,
    0x33d61800U,
    0x5b1b4400U,
    0x45bef600U,
    0x1c97d00U,
    0xa323ef80U,
    0xd135ad40U,
    0xb0c17a0U,
    0x16875970U,
    0x91c379a8U,
    0xd9272074U,
    0x5c358036U,
    0xc48d4031U,
    0x92c66018U,
    0x91a7f01aU,
    0x12f0782fU,
    0xd32cb425U,
    0x9b368e2aU,
    0xee09c919U,
    0xb5076192U,
    0x3b836471U,
    0x8e46f616U,
    0x5657d13U,
    0x5851ef8dU,
    0x4d5aad46U,
    0x64d997afU,
    0xb9a1941U,
    0xef7d19a0U,
    0x646cd064U,
    0xbbd7f836U,
    0x71ef419U,
    0x3bd6e36U,
    0x3acf7901U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x88000000U,
    0xc4000000U,
    0xb6000000U,
    0x6f000000U,
    0x6b800000U,
    0x7400000U,
    0xeae00000U,
    0x6100000U,
    0x4e480000U,
    0xf4ec0000U,
    0x9f9a0000U,
    0x32810000U,
    0xc3c28000U,
    0xe620c000U,
    0x1bb5e000U,
    0x2abfd000U,
    0x78b4e800U,
    0x933b9400U,
    0x36f71e00U,
    0x55db100U,
    0x10241d80U,
    0xd4b2b5c0U,
    0xd13f15a0U,
    0x7f7f1f0U,
    0x35de63b8U,
    0x42e114ccU,
    0x9210801aU,
    0xe04dc03dU,
    0x27ed6017U,
    0xe1e1016U,
    0x28c38815U,
    0x9ba4842bU,
    0xe3f6160dU,
    0xd3d9f51bU,
    0x35e7ebb3U,
    0x459490fdU,
    0x1d0c162eU,
    0xd008f500U,
    0xba8d6b9cU,
    0x654850f4U,
    0xe96bf613U,
    0x97da253eU,
    0x43e1039dU,
    0x4a9204f0U,
    0x868b880dU,
    0x5f48842fU,
    0x946c1618U,
    0xd558f536U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x98000000U,
    0xf4000000U,
    0x16000000U,
    0x6f000000U,
    0x51800000U,
    0xc2400000U,
    0x42a00000U,
    0x45900000U,
    0xa6d80000U,
    0xa13c0000U,
    0x8b8a0000U,
    0xf0830000U,
    0xe8c18000U,
    0x37634000U,
    0xe275e000U,
    0x9c6bd000U,
    0x62306800U,
    0xb7cf4400U,
    0xa122e600U,
    0xa6d60b00U,
    0xefbeb80U,
    0xb1682f40U,
    0x5ab463a0U,
    0xf30fbb70U,
    0x54476da8U,
    0xeda5b444U,
    0x3413800eU,
    0xb49c4039U,
    0x7b9e602bU,
    0x3a1b9012U,
    0x405c0837U,
    0x26fbd416U,
    0xed6d6e01U,
    0xd0b19f3aU,
    0x3608e5adU,
    0x10c22049U,
    0xf3608e3bU,
    0x9c764f35U,
    0x4f6a8db9U,
    0x49b2646dU,
    0xf889e826U,
    0xcb00041bU,
    0x1f850617U,
    0x7942db28U,
    0xd52003baU,
    0x70d72b6eU,
    0x41fae586U,
    0x30ed2052U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x88000000U,
    0xdc000000U,
    0xea000000U,
    0x5b000000U,
    0xe3800000U,
    0x48400000U,
    0x45a00000U,
    0x39100000U,
    0x8b380000U,
    0xf1dc0000U,
    0xdcee0000U,
    0xc9810000U,
    0xb3418000U,
    0xd627c000U,
    0x69562000U,
    0x9a9df000U,
    0xfecf6800U,
    0xe6d49400U,
    0x80da8600U,
    0xc468f300U,
    0x12476780U,
    0xa6a01c40U,
    0xfe902fa0U,
    0xed787850U,
    0x517c4198U,
    0x6b7fdf74U,
    0x5879803aU,
    0xf7fbc003U,
    0xddb82020U,
    0x1f1cf005U,
    0x2f8ee820U,
    0xb7f35433U,
    0xe00ca613U,
    0x4db5030aU,
    0x4aa80f8bU,
    0x31248860U,
    0xb0d2a9a4U,
    0xe1dc8b50U,
    0x14ed2621U,
    0xf582c30fU,
    0xc9462f9bU,
    0x5257872U,
    0x56d3c1b1U,
    0x38d91f5bU,
    0xe06e201fU,
    0x3c41f01eU,
    0x43a16828U,
    0x7015942eU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0xc8000000U,
    0x4c000000U,
    0xf6000000U,
    0x25000000U,
    0x800000U,
    0x45400000U,
    0x59a00000U,
    0xb9500000U,
    0x8ba80000U,
    0x744c0000U,
    0x993a0000U,
    0xf2030000U,
    0x5f048000U,
    0xf384c000U,
    0x10c7a000U,
    0xd4639000U,
    0xe9b4f800U,
    0x9d5e9c00U,
    0x63b70600U,
    0x665ee300U,
    0x5a302d80U,
    0x6d9edac0U,
    0xe7d175a0U,
    0x37ecd6f0U,
    0x436c0ba8U,
    0xb42b69ecU,
    0x5288001aU,
    0x485c003fU,
    0x6b320007U,
    0x4f1f0006U,
    0x8596800fU,
    0x39cbc00bU,
    0x20f9202bU,
    0xf0e45036U,
    0xa6f7d834U,
    0xfff9cc22U,
    0xc3645e12U,
    0x9633ef0fU,
    0x5b9bd393U,
    0xe2d2a5ddU,
    0x476c5e15U,
    0xce2fef05U,
    0xa189d3a1U,
    0x1ddda5f2U,
    0xe6f2de34U,
    0x1ff82f28U,
    0x9362f381U,
    0x2e36f5f0U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x98000000U,
    0x5c000000U,
    0xae000000U,
    0xeb000000U,
    0x68800000U,
    0x72400000U,
    0xff200000U,
    0xb4d00000U,
    0x38680000U,
    0x280c0000U,
    0x9c7a0000U,
    0x74050000U,
    0xaa008000U,
    0xf9024000U,
    0x1d87a000U,
    0x69c35000U,
    0xb9e0c800U,
    0x97b16c00U,
    0x989f8e00U,
    0xcc332f00U,
    0xfe5fcd80U,
    0x3f509cc0U,
    0xf6aaa5a0U,
    0x1f6ba0f0U,
    0x668f6398U,
    0x113ea3fcU,
    0xb9a0003eU,
    0xed90002bU,
    0x4fc80035U,
    0xde9c0021U,
    0xc3320017U,
    0xb4d90031U,
    0xa012800eU,
    0x4e0b400bU,
    0x437d202bU,
    0x9684103bU,
    0xf147e816U,
    0xb3a07c3aU,
    0x490e603U,
    0x1a4d1329U,
    0x435a8b8aU,
    0x10d7dff9U,
    0x3a6a6623U,
    0x150a5331U,
    0x73fdabb7U,
    0x58c6cfc0U,
    0x90650e31U,
    0x74746f3eU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x28000000U,
    0xac000000U,
    0x2e000000U,
    0x3d000000U,
    0xaf800000U,
    0xc5c00000U,
    0x7600000U,
    0x7d900000U,
    0x5ae80000U,
    0x434c0000U,
    0x973a0000U,
    0xbc010000U,
    0xa6078000U,
    0xa100c000U,
    0xf986a000U,
    0x7cc55000U,
    0x2ae5f800U,
    0xab55e400U,
    0xcf0aba00U,
    0x549f6900U,
    0xf77f980U,
    0x85bc00c0U,
    0x1646a1a0U,
    0x4a1b4f0U,
    0x8bf463b8U,
    0xf6faf9e4U,
    0xc9600032U,
    0xd090000fU,
    0xbd680019U,
    0x7a8c0030U,
    0x965a002aU,
    0x50910015U,
    0x7d6f8021U,
    0x1a8cc021U,
    0xc65ca03cU,
    0x7894503eU,
    0xd16a7832U,
    0x34892420U,
    0xfb5e1a1aU,
    0xd7173917U,
    0x14af81b2U,
    0x33e824d8U,
    0x86cd3bbdU,
    0x8dfb4dedU,
    0x57e0c23fU,
    0xa4d64d04U,
    0x3ac9e3a8U,
    0x2bfb39e1U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0x28000000U,
    0x4000000U,
    0x36000000U,
    0xe7000000U,
    0xc0800000U,
    0x40400000U,
    0x9da00000U,
    0xa8d00000U,
    0x38780000U,
    0xf09c0000U,
    0xf46e0000U,
    0x13050000U,
    0x9e828000U,
    0xc341c000U,
    0x1b22e000U,
    0x2790d000U,
    0x615ea800U,
    0x2e0c8c00U,
    0xb6b53e00U,
    0x8bc9eb00U,
    0x12d72980U,
    0xbd78a840U,
    0xd91d61a0U,
    0xcfadf450U,
    0x146277b8U,
    0x3eb0534cU,
    0xdfce0032U,
    0x1cd5000dU,
    0x67a801fU,
    0x39dc024U,
    0x5aece037U,
    0x9845d028U,
    0xf1a4281aU,
    0xfad14c03U,
    0x9979de19U,
    0xff1c3b06U,
    0x70ab0194U,
    0xf8e5e452U,
    0x4cf2bfb4U,
    0x9368cf58U,
    0x9385f624U,
    0xbec17731U,
    0x2ee4dfabU,
    0x9bf0df6fU,
    0x1bed3e14U,
    0xa7c5eb08U,
    0x3d612994U,
    0x6531a873U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x10000000U,
    0xd8000000U,
    0x4c000000U,
    0xae000000U,
    0xfd000000U,
    0x41800000U,
    0xab400000U,
    0xd9e00000U,
    0xf8f00000U,
    0x52d80000U,
    0x4f7c0000U,
    0x54ea0000U,
    0x4d030000U,
    0x49878000U,
    0x1f474000U,
    0x2be42000U,
    0x73f1d000U,
    0xa258f800U,
    0xbbc9400U,
    0xdb4abe00U,
    0x2d929900U,
    0x48ebd280U,
    0xdb00de40U,
    0xc8850aa0U,
    0x38c29a70U,
    0xe9a2cca8U,
    0x994d774U,
    0xa2ea001eU,
    0x3c030027U,
    0x86078015U,
    0x59074028U,
    0x6b84200dU,
    0x6c41d006U,
    0x8760f80dU,
    0x4130942bU,
    0x9cf8be32U,
    0x84ad9907U,
    0x8c6652b7U,
    0x71b49e7eU,
    0xf83eaab3U,
    0x1b080a77U,
    0x34f414a5U,
    0x3cda937cU,
    0x927fc62eU,
    0x56a4d3eU,
    0x3e42cc81U,
    0xdc64d77dU,
    0x49b20021U,
    0x843f0009U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xa8000000U,
    0x44000000U,
    0x16000000U,
    0x51000000U,
    0x5f800000U,
    0xa0400000U,
    0xe3a00000U,
    0xbbd00000U,
    0xe2980000U,
    0x9efc0000U,
    0x16ca0000U,
    0xe4250000U,
    0xd7948000U,
    0x33fc000U,
    0x7a2ee000U,
    0x16d5d000U,
    0xd7191800U,
    0xc5be4400U,
    0xb1efb600U,
    0xb328300U,
    0x2a69d180U,
    0x7d742f40U,
    0x78caa9a0U,
    0x29207b70U,
    0x9212e798U,
    0x10796c5cU,
    0x290d9832U,
    0x47c1840dU,
    0x3fe15617U,
    0xf2775329U,
    0x4248c9b8U,
    0x88e66b6dU,
    0x74f71f8aU,
    0xa98bf862U,
    0xc505b60fU,
    0x9187833dU,
    0xfd455197U,
    0x5e27ef4dU,
    0xf4964987U,
    0x4bbcab6bU,
    0xcced7fa4U,
    0xe6b1e85cU,
    0x7d2a4e03U,
    0x3850173fU,
    0x78d9ff90U,
    0x9e5e2856U,
    0x59cae36U,
    0x79c72fU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x78000000U,
    0x7c000000U,
    0x52000000U,
    0xd5000000U,
    0x1b800000U,
    0xe8c00000U,
    0xf4200000U,
    0x3100000U,
    0xbca80000U,
    0xcbcc0000U,
    0x5c3a0000U,
    0x23a10000U,
    0x51d78000U,
    0xf98a4000U,
    0xad5ea000U,
    0xf750b000U,
    0xaecad800U,
    0xafb96400U,
    0xaf627200U,
    0xdbf51b00U,
    0x5980f80U,
    0xa37324c0U,
    0x9ddbf7a0U,
    0x3b10b0f0U,
    0x60adfdb8U,
    0xa9cc7fe4U,
    0xa13d5826U,
    0x3c23243bU,
    0x9714d212U,
    0x8aa9ab3eU,
    0x60c8d78cU,
    0xb8bb40d0U,
    0x79e6058fU,
    0x4b3ebffU,
    0x3379522cU,
    0xfd42eb2cU,
    0x6be1f783U,
    0x71b1b0f1U,
    0x18fa7d86U,
    0x3d863fdeU,
    0x9bc3f802U,
    0x5ca39420U,
    0x23560a29U,
    0x38cccf19U,
    0x34b8a5b3U,
    0x63e35bf8U,
    0x85b38a0bU,
    0x7efb8f30U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x38000000U,
    0x6c000000U,
    0x82000000U,
    0xdf000000U,
    0x38800000U,
    0x13c00000U,
    0xea600000U,
    0x38f00000U,
    0xaa280000U,
    0x630c0000U,
    0x565e0000U,
    0xd0e10000U,
    0xb4328000U,
    0x98c94000U,
    0xb8392000U,
    0x2e10b000U,
    0xe71c8800U,
    0xca47ac00U,
    0xf423e200U,
    0x62d3a900U,
    0x75fefa80U,
    0x174edc0U,
    0x4469d2a0U,
    0x12ab1d0U,
    0xe58f9898U,
    0x309e04ecU,
    0x79060816U,
    0x7182ec37U,
    0xfa44c216U,
    0x6c221910U,
    0x1ed0f2a0U,
    0x3ffa01e8U,
    0x8a7310b4U,
    0x92e9a8edU,
    0x4fedea06U,
    0xe86d453eU,
    0x232c38b3U,
    0x2a8bf4c5U,
    0xc01da01cU,
    0x3ec4f036U,
    0x75e12800U,
    0x9fb35c16U,
    0x218aca00U,
    0x569cf50eU,
    0x9002309aU,
    0x880518c0U,
    0xb4076208U,
    0x1e07e912U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0xb8000000U,
    0xdc000000U,
    0x66000000U,
    0xa7000000U,
    0xf7800000U,
    0x6400000U,
    0xc6200000U,
    0xd7700000U,
    0x18f80000U,
    0x731c0000U,
    0xc20a0000U,
    0x8ca50000U,
    0xb7b28000U,
    0xa0194000U,
    0x878ca000U,
    0xcfe21000U,
    0xeb11e800U,
    0xffad3400U,
    0xd390f600U,
    0x3a6c9f00U,
    0x81f66880U,
    0xfe3bc540U,
    0x1cf9a0a0U,
    0x791da170U,
    0x5b0c1e98U,
    0x70221a6cU,
    0x98716836U,
    0x1b7d741bU,
    0x75cd60fU,
    0xa12ecf02U,
    0xb153a08aU,
    0x9f88a15fU,
    0x43e69eb5U,
    0xa5175a6dU,
    0x4cafc812U,
    0x26166404U,
    0x212dbe11U,
    0x7153bb21U,
    0x7f8f76acU,
    0x33e66e49U,
    0x1d153e38U,
    0x90affb20U,
    0x40115682U,
    0x862d3e4cU,
    0x86d07616U,
    0x79ccdf2cU,
    0xf5c248b9U,
    0xca659544U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x70000000U,
    0xd8000000U,
    0x3c000000U,
    0xbe000000U,
    0xc1000000U,
    0xa8800000U,
    0x67c00000U,
    0x79e00000U,
    0xc0d00000U,
    0x1e380000U,
    0x49c0000U,
    0x8c6e0000U,
    0x6e650000U,
    0xee928000U,
    0xb89e4000U,
    0x7268a000U,
    0xcf64d000U,
    0x36131800U,
    0x75e3c00U,
    0x37893200U,
    0xb1b49500U,
    0xe92be780U,
    0xab424040U,
    0xdc22dfa0U,
    0xa636ec50U,
    0xc76855b8U,
    0xde4954cU,
    0xaad7980eU,
    0xe5397c03U,
    0x9f1d1201U,
    0xe42b0523U,
    0x25c2dfb3U,
    0x26e6ec66U,
    0xb95055bbU,
    0x79789549U,
    0xfeb9980bU,
    0xb75c7c24U,
    0xcf8f9214U,
    0x9db54539U,
    0xff2a7f86U,
    0x8e423c4bU,
    0xf6a34da1U,
    0xbef6a97fU,
    0xd708aa26U,
    0x274e939U,
    0xaaca75abU,
    0x5892057cU,
    0xcd9a2027U,
    0x90ea9032U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xf0000000U,
    0x98000000U,
    0x1c000000U,
    0xba000000U,
    0x29000000U,
    0xd8800000U,
    0x89c00000U,
    0x32200000U,
    0xc6100000U,
    0x7c180000U,
    0xeb7c0000U,
    0xe88e0000U,
    0xfa10000U,
    0xe5528000U,
    0x7afc4000U,
    0x9cfa000U,
    0xcc47f000U,
    0xfd617800U,
    0xe2f2dc00U,
    0xaba88200U,
    0xad333b00U,
    0xba8cdf80U,
    0xe2a3d940U,
    0x7bd087a0U,
    0x903ab550U,
    0x526edd98U,
    0x4710a26cU,
    0x809df83eU,
    0xd4bf9c2bU,
    0x21ada230U,
    0xbc348b31U,
    0x6e0c07beU,
    0xb967f56fU,
    0xe4f3fdb4U,
    0x28ab1249U,
    0x34b3203dU,
    0x6fcab005U,
    0xff445837U,
    0x1ce56c33U,
    0xdbb05a14U,
    0x944b172aU,
    0xff01a599U,
    0x93837e46U,
    0x8447fa1eU,
    0x2960e716U,
    0xccf6ddbcU,
    0x4caca257U,
    0x62b3f818U,
    0x64ce9c05U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x68000000U,
    0x3c000000U,
    0x6a000000U,
    0x45000000U,
    0xd8800000U,
    0xec00000U,
    0x8ba00000U,
    0xd1f00000U,
    0xc2b80000U,
    0x755c0000U,
    0x24ce0000U,
    0x84a10000U,
    0x5c708000U,
    0x2cf9c000U,
    0x143b2000U,
    0x409ff000U,
    0x84e99800U,
    0x1c133c00U,
    0xee2f5a00U,
    0xe9b6cf00U,
    0xccdcd480U,
    0x6c8c1f40U,
    0x42c6eca0U,
    0x29a51350U,
    0xf8f50e98U,
    0xa83e107cU,
    0x6a9f9802U,
    0x21ee3c33U,
    0x7491da38U,
    0x88ee0f32U,
    0x5e1774b6U,
    0x772a2f5dU,
    0xeb3454aeU,
    0xef19df76U,
    0x3abccbcU,
    0xf7f7e356U,
    0x25ba1699U,
    0x84d9ec7bU,
    0x408d6236U,
    0x10c3c315U,
    0x88a13695U,
    0x1e761c4bU,
    0xb5fcfa07U,
    0x16bcff25U,
    0x63586c99U,
    0xebcdd37aU,
    0xa926aebeU,
    0xe2342072U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0xb8000000U,
    0x14000000U,
    0xe6000000U,
    0xc9000000U,
    0x70800000U,
    0x1b400000U,
    0xede00000U,
    0xf3900000U,
    0xc3c80000U,
    0x83ec0000U,
    0xdfde0000U,
    0x1ae10000U,
    0x2e148000U,
    0x160b4000U,
    0x9848e000U,
    0xef2c5000U,
    0xecf8d800U,
    0x15527c00U,
    0x6bec5600U,
    0x3dbd100U,
    0xb0e5f980U,
    0x2517f5c0U,
    0xf18941a0U,
    0x2e8e99d0U,
    0x8f0b2f98U,
    0x20ca64dcU,
    0xb86ed836U,
    0xc31f7c19U,
    0x71c6d62fU,
    0x5a1913bU,
    0xdf1998bU,
    0x509ce5f1U,
    0x510779beU,
    0xf481b5d8U,
    0x9543218fU,
    0xb8e489c6U,
    0xc911978aU,
    0xe38e08c3U,
    0x318e3603U,
    0x8e8dc108U,
    0x5f0941a9U,
    0xa8ce99c5U,
    0x146b2f86U,
    0x311a64e6U,
    0x5ec6d831U,
    0xbc237c0aU,
    0x6630d63bU,
    0xa63c9119U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xb0000000U,
    0x88000000U,
    0x4000000U,
    0x4e000000U,
    0x8f000000U,
    0xb4800000U,
    0xa4c00000U,
    0x8a200000U,
    0x1700000U,
    0x99d80000U,
    0x5bc0000U,
    0xc12e0000U,
    0xb9270000U,
    0x37f68000U,
    0xd818c000U,
    0x4a1de000U,
    0xd7181000U,
    0xbe992800U,
    0x53d92c00U,
    0x84ba3a00U,
    0xdaaa3300U,
    0x1965ec80U,
    0x91147c40U,
    0x574fa4a0U,
    0x9cb18050U,
    0xc47f56a8U,
    0xce8d8f7cU,
    0x8f17280aU,
    0x804e2c3dU,
    0x3434ba39U,
    0x12bef30eU,
    0x9ae0c9cU,
    0xffe76c4bU,
    0xc8d60cbcU,
    0x24eb6c5aU,
    0x48800c81U,
    0x6c06c54U,
    0xdf208cbeU,
    0x4cf3ac52U,
    0x8a9dec82U,
    0xd5d87c47U,
    0x2fb9a49bU,
    0x902a805aU,
    0xbaa7d6a6U,
    0xabb24f60U,
    0xbcfc482cU,
    0x4efc21U,
    0x74307228U,
    0x32bfcf0eU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0xd8000000U,
    0xe4000000U,
    0xaa000000U,
    0xe3000000U,
    0x82800000U,
    0x1dc00000U,
    0xeb200000U,
    0xf7d00000U,
    0xdab80000U,
    0xb8dc0000U,
    0x54ee0000U,
    0x79270000U,
    0xd78000U,
    0x9a3b4000U,
    0xea196000U,
    0xab4ab000U,
    0x3e326800U,
    0xfac9dc00U,
    0xa974a200U,
    0x102cc300U,
    0x6b81b980U,
    0xac45da40U,
    0x8c6531a0U,
    0x7531f650U,
    0xb44c9ba8U,
    0x92b55974U,
    0x1e0a681eU,
    0x6bd5dc0dU,
    0x44baa214U,
    0x9dbc325U,
    0x416e39bcU,
    0x94629a46U,
    0xf1325190U,
    0xae4c4652U,
    0x39b17384U,
    0xa08bc560U,
    0x3811aa07U,
    0xe698af00U,
    0x9f88f3b7U,
    0x4978573U,
    0xda5f4a33U,
    0xb9295f04U,
    0xfa03fb8dU,
    0x5b04e954U,
    0xd6818025U,
    0xffc0402dU,
    0x3420e004U,
    0x3b56f000U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x78000000U,
    0x1c000000U,
    0xd6000000U,
    0x11000000U,
    0x9d800000U,
    0xc400000U,
    0xc6e00000U,
    0x38900000U,
    0xf3680000U,
    0xb64c0000U,
    0xcf7a0000U,
    0x70e50000U,
    0x99928000U,
    0xf6ef4000U,
    0xd60ca000U,
    0xa79f9000U,
    0x4573d800U,
    0x21785400U,
    0x5de74600U,
    0x42141900U,
    0xe3ad0180U,
    0xe96930c0U,
    0x5948f9a0U,
    0xb7fdb4f0U,
    0x2322c798U,
    0xf03769ecU,
    0x4e1bd806U,
    0x4b34542bU,
    0xa49d4613U,
    0x53f1191fU,
    0x9fbf818cU,
    0xfc670c0U,
    0x9fa45983U,
    0x39f224f9U,
    0x8b91fb2U,
    0x6b433dccU,
    0x1a669e38U,
    0x41554d14U,
    0x2dcac7baU,
    0xfa3b69d3U,
    0xdf81d80cU,
    0x6f415438U,
    0x6067c619U,
    0x1e525909U,
    0xcd492187U,
    0xc5fce0d6U,
    0x18250195U,
    0xdab530e9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0xe8000000U,
    0xc000000U,
    0x5e000000U,
    0xed000000U,
    0x4e800000U,
    0xc0400000U,
    0x68e00000U,
    0xc7f00000U,
    0x63d80000U,
    0x58fc0000U,
    0x712a0000U,
    0x21a30000U,
    0x73948000U,
    0xf76dc000U,
    0x8040a000U,
    0x88e3d000U,
    0x97f4f800U,
    0xfbdc6c00U,
    0xbcf85e00U,
    0x232d5100U,
    0x92a28a80U,
    0xd0158e40U,
    0x79a852a0U,
    0x28e4f270U,
    0x27f0d4a8U,
    0x33dbdf6cU,
    0xc0fe5812U,
    0x952cbc2fU,
    0x73a02625U,
    0xc090fd24U,
    0x54e874beU,
    0xe840f48U,
    0x2040a03eU,
    0x38e3d00aU,
    0x5ff4f819U,
    0x87dc6c0bU,
    0xaf85e24U,
    0xc22d512cU,
    0x82228a8fU,
    0xfd558e58U,
    0x5fc85293U,
    0x2f54f257U,
    0x2cc8d4abU,
    0xacd7df7cU,
    0xd20c5820U,
    0xec73bc2dU,
    0x711ea617U,
    0x165e3d2eU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0xc8000000U,
    0x9c000000U,
    0x7e000000U,
    0xf000000U,
    0x37800000U,
    0xd6400000U,
    0x6e200000U,
    0x5e100000U,
    0xefb80000U,
    0x475c0000U,
    0xbaae0000U,
    0x65650000U,
    0x9eb68000U,
    0x536ac000U,
    0x61012000U,
    0x40835000U,
    0xd5c46800U,
    0xaa65b400U,
    0x89313600U,
    0x15289f00U,
    0x3720c380U,
    0x4a948440U,
    0xd87d0ba0U,
    0x9c3da050U,
    0xb1ff5b8U,
    0x91891b6cU,
    0x11f3480aU,
    0x29cfe40bU,
    0x8d5de35U,
    0x745eeb18U,
    0x232855a0U,
    0xe4208b51U,
    0x63160029U,
    0xf1390031U,
    0xd988035U,
    0x1f4fc00fU,
    0x6e17a03cU,
    0x7b99038U,
    0x4b5d482dU,
    0xfcaae41fU,
    0x3e635e1cU,
    0x4b342b28U,
    0xf4297591U,
    0x37a3db79U,
    0xff526814U,
    0x821cb43eU,
    0xdd09b62cU,
    0x82375f18U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x10000000U,
    0x18000000U,
    0x8c000000U,
    0x52000000U,
    0xd7000000U,
    0x31800000U,
    0xdfc00000U,
    0x80200000U,
    0x5cb00000U,
    0x93180000U,
    0xa27c0000U,
    0x44ae0000U,
    0xeae10000U,
    0x92158000U,
    0x45ef4000U,
    0xb8802000U,
    0x2b443000U,
    0x59674800U,
    0x22d52400U,
    0x88490a00U,
    0x61f31300U,
    0x7b788a80U,
    0x482fc440U,
    0xafa462a0U,
    0xa6709050U,
    0x5bf8098U,
    0x188dd754U,
    0x1c51681eU,
    0x4a0c1437U,
    0x9c15c22aU,
    0x78e87712U,
    0x2204209eU,
    0x9f07a761U,
    0x45838018U,
    0x11c24005U,
    0x1d23a030U,
    0x3636700cU,
    0x2f5ce813U,
    0x2a9f5426U,
    0xa9bbe205U,
    0xfa8d4736U,
    0x2356e897U,
    0xff8dc356U,
    0x85d2aa1cU,
    0xf1c96314U,
    0xca326286U,
    0x355d9076U,
    0x899c009dU,
    0x563f974bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x8000000U,
    0x7c000000U,
    0x32000000U,
    0xf7000000U,
    0x38800000U,
    0xd2400000U,
    0x31a00000U,
    0x72100000U,
    0xd9c80000U,
    0xc9ac0000U,
    0x32da0000U,
    0x3de70000U,
    0x4eb38000U,
    0xb85dc000U,
    0xd8a72000U,
    0xe7943000U,
    0x808c800U,
    0x38cb6c00U,
    0x202aae00U,
    0xd11a3b00U,
    0x3b829f80U,
    0x64c0abc0U,
    0x86e4f7a0U,
    0x9c3537f0U,
    0x491a3188U,
    0x8f8190f4U,
    0x8ac7e80aU,
    0x53e35c2bU,
    0x5bb06626U,
    0xdfda5726U,
    0x5e61b180U,
    0x3e7050d6U,
    0xc0bac82eU,
    0x99906c25U,
    0x150b2e1cU,
    0x234cfb1eU,
    0x94ec3fb4U,
    0xfffe5bfeU,
    0xcbb09f85U,
    0x17dbabdeU,
    0x826577afU,
    0x1c73f7d8U,
    0x3fbc91a1U,
    0xdd1360eeU,
    0xf549800cU,
    0xe5eac027U,
    0xde7ca020U,
    0xf475f03eU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x50000000U,
    0x98000000U,
    0xa4000000U,
    0x62000000U,
    0xf3000000U,
    0x70800000U,
    0xf3400000U,
    0x1e200000U,
    0xaf00000U,
    0x20880000U,
    0xcc6c0000U,
    0xb87e0000U,
    0xf7e50000U,
    0x8938000U,
    0xb2dd4000U,
    0x4c576000U,
    0xf538f000U,
    0xccc6a800U,
    0x1be78c00U,
    0x16944600U,
    0xe7db4f00U,
    0xfdd4ec80U,
    0x1df91ac0U,
    0xf520a4a0U,
    0x9e7226d0U,
    0xd1c8aab8U,
    0x714e55c4U,
    0x5a0a481eU,
    0x802e3c2dU,
    0xb8db8e26U,
    0xf3513301U,
    0xebbd82a2U,
    0xc28499e9U,
    0xd8416e23U,
    0xaaa18312U,
    0xcbb7ca8bU,
    0x55aaa5d9U,
    0x121ae027U,
    0x9b0b035U,
    0xd6aa4824U,
    0xca9e3c0aU,
    0x96f38e05U,
    0x968d3339U,
    0xf56b82bdU,
    0x57fd99e9U,
    0x2a24ee11U,
    0xd0f5c31dU,
    0x478d2ab8U,
    0x16ea15d3U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0x78000000U,
    0x3c000000U,
    0xd2000000U,
    0x8d000000U,
    0x29800000U,
    0x12c00000U,
    0xd1600000U,
    0xdc300000U,
    0xa3180000U,
    0x863c0000U,
    0x552e0000U,
    0xd4270000U,
    0x8908000U,
    0x6ec94000U,
    0x5c55a000U,
    0x94aeb000U,
    0x92e61800U,
    0x1ff23400U,
    0xd9ff7200U,
    0xcdc93100U,
    0x4ad3ac80U,
    0x72ebfa40U,
    0x70c694a0U,
    0x44653e50U,
    0x99b4dea8U,
    0x6bdecb4cU,
    0x9e5b3836U,
    0x4e99c403U,
    0x3afaca22U,
    0xfb4eb530U,
    0xdc9446a0U,
    0xe8cebf68U,
    0x17576a2aU,
    0xd62c0500U,
    0xb2a45e9eU,
    0x96d78b4eU,
    0xb0ee9837U,
    0xd5c7743cU,
    0x59e4d203U,
    0x1d708130U,
    0xd9bd3494U,
    0x34ec8e40U,
    0x5bc24691U,
    0x56e5bf7dU,
    0xb1f1ea0fU,
    0xa6fe4538U,
    0x194f7eb7U,
    0x9977b79U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x68000000U,
    0x6c000000U,
    0x5e000000U,
    0xc7000000U,
    0xde800000U,
    0xd2400000U,
    0x77e00000U,
    0x48500000U,
    0x45080000U,
    0x4f2c0000U,
    0x975e0000U,
    0x5f210000U,
    0x2ff78000U,
    0x3bbec000U,
    0xff6a000U,
    0xcbb8d000U,
    0xd7f4a800U,
    0x9fbabc00U,
    0x8df61e00U,
    0x6ab83900U,
    0xca75df80U,
    0xa17e0dc0U,
    0xb15657a0U,
    0x4c8fa1d0U,
    0xcbebc198U,
    0xefa34c4U,
    0x56958802U,
    0x89acac1fU,
    0xb11c1635U,
    0xc2c6553eU,
    0xaaa169baU,
    0x3d3188deU,
    0xb91c161dU,
    0xbec65507U,
    0x7ca16983U,
    0xc63188e1U,
    0x519c1613U,
    0xc786551dU,
    0x8bc16990U,
    0x9b2188efU,
    0xbdf41620U,
    0x12ba5514U,
    0x2e77698fU,
    0xc37c88ecU,
    0x40559609U,
    0x39099523U,
    0x992849b3U,
    0x6c5b98f5U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0xb8000000U,
    0x7c000000U,
    0x3e000000U,
    0x51000000U,
    0x2a800000U,
    0x8400000U,
    0x62200000U,
    0xa4f00000U,
    0xf3b80000U,
    0x845c0000U,
    0xdd4a0000U,
    0x1ce70000U,
    0xc0948000U,
    0x7c6f4000U,
    0x7595a000U,
    0x24e9d000U,
    0xad19800U,
    0xb14bac00U,
    0xae75e00U,
    0x5906700U,
    0x5cef4480U,
    0xd6d34340U,
    0x7f4dfca0U,
    0xe3e57f70U,
    0x53101a88U,
    0x6aaf244cU,
    0xe5f0b826U,
    0xf13d3c13U,
    0x181b6609U,
    0xb56e1b37U,
    0x131382abU,
    0xaaf8849U,
    0xb5f1663dU,
    0xb9391b0fU,
    0xdc1f0286U,
    0xf76cc876U,
    0x7c16c61dU,
    0x712bcb20U,
    0x97301a9cU,
    0xd35f2451U,
    0x1ac8b81eU,
    0xa0213c3cU,
    0xbf16610U,
    0x28391b3bU,
    0x569f0285U,
    0xf2cc858U,
    0xa636c617U,
    0xa9dbcb12U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xd0000000U,
    0xa8000000U,
    0xc000000U,
    0x5e000000U,
    0x63000000U,
    0x75800000U,
    0xebc00000U,
    0xd8600000U,
    0x9a300000U,
    0xf6980000U,
    0xd5bc0000U,
    0x5eae0000U,
    0x2e230000U,
    0x45918000U,
    0x9acec000U,
    0xa217a000U,
    0xac0dd000U,
    0x1cf08800U,
    0xd07ec400U,
    0x7dcbaa00U,
    0x1592d100U,
    0x72cdfc80U,
    0xe115e40U,
    0x220d54a0U,
    0xd7f38a50U,
    0xa9fe5688U,
    0xc80f8f64U,
    0xaef6a822U,
    0x9d7dd427U,
    0x134c8215U,
    0x2fd1c52fU,
    0x136edea0U,
    0x71414b61U,
    0x5825021cU,
    0x6a930514U,
    0x114f7ebeU,
    0xfad39b5dU,
    0xa9ea0a16U,
    0x6100010bU,
    0xa082f484U,
    0x51425a74U,
    0xc820deb9U,
    0x62924b6fU,
    0xcd4c8217U,
    0xcd1c523U,
    0xc6eede92U,
    0x4a814b62U,
    0x28450238U,
    0xfca30514U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x30000000U,
    0x88000000U,
    0xd4000000U,
    0xaa000000U,
    0xdb000000U,
    0x24800000U,
    0x20c00000U,
    0xa7600000U,
    0x36b00000U,
    0x25380000U,
    0xa31c0000U,
    0x78e0000U,
    0x4c270000U,
    0x6f928000U,
    0xd72cc000U,
    0x5f776000U,
    0x61ddb000U,
    0xcfe82800U,
    0xe4152c00U,
    0x969ba00U,
    0xabd73900U,
    0x308f1880U,
    0xdea49f40U,
    0xca54d0a0U,
    0x15cbc350U,
    0x3e86a2a8U,
    0x33c3a65cU,
    0x77e3c80aU,
    0x8c735c29U,
    0xd15c7200U,
    0x652f650fU,
    0xa877ea81U,
    0x935c3a4bU,
    0x7a28da2aU,
    0x9ef18923U,
    0x349bb0a1U,
    0x87ca7361U,
    0xf9808aa3U,
    0x49418a53U,
    0x1620f211U,
    0x5c94a524U,
    0x37aa0aaeU,
    0x6db14a4fU,
    0x41b9923eU,
    0xa3de150aU,
    0x90e8a284U,
    0xf294a651U,
    0x9ea9481eU,
    0xde339c17U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x88000000U,
    0xfc000000U,
    0xe2000000U,
    0x7000000U,
    0x5c800000U,
    0x8b400000U,
    0x5da00000U,
    0xdeb00000U,
    0x9b680000U,
    0x400c0000U,
    0xedde0000U,
    0x17630000U,
    0x67d48000U,
    0x71bac000U,
    0x46342000U,
    0x662eb000U,
    0xd4a9c800U,
    0x72e84c00U,
    0x28c9c600U,
    0xb3bb3300U,
    0x71339280U,
    0x12afdbc0U,
    0xd3ecfaa0U,
    0x454ce7d0U,
    0xd7a5488U,
    0x9654e8ccU,
    0xbd7f682aU,
    0xfe533c33U,
    0x917eae32U,
    0xe4540f22U,
    0xe27b3c8dU,
    0xa6d4d4dcU,
    0x8c3d4618U,
    0xa0f1f304U,
    0x854fb28eU,
    0xed7d6bd9U,
    0x46533288U,
    0x457babcdU,
    0x8a5112b4U,
    0x8f7a1bc4U,
    0x1525a8eU,
    0xb9fb97d1U,
    0x71133cb8U,
    0x5ad8d4dcU,
    0x23e3460dU,
    0xc092f329U,
    0x361b32aaU,
    0xeb87abc6U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0x78000000U,
    0x54000000U,
    0x56000000U,
    0x6f000000U,
    0x4d800000U,
    0xac400000U,
    0x2b200000U,
    0x1a700000U,
    0x70680000U,
    0x2a1c0000U,
    0xfa720000U,
    0x406d0000U,
    0x32188000U,
    0x5e764000U,
    0x6e6c6000U,
    0x9189000U,
    0x45f78800U,
    0xad2d7400U,
    0x6fbf9e00U,
    0xf3c3b300U,
    0xf664fe80U,
    0x5fd0cec0U,
    0x79db60a0U,
    0x9c137df0U,
    0x97bf9e38U,
    0x67c3b30cU,
    0xc064fe86U,
    0xc0d0cee9U,
    0x4c5b60abU,
    0x64537dfeU,
    0xea9f9e3eU,
    0x12b3b33cU,
    0xfd8cfe9fU,
    0x468ccec4U,
    0x9d0960bdU,
    0x3e4e7df2U,
    0xa8ef1e1cU,
    0x66d9f326U,
    0x69929eadU,
    0xff95ec3U,
    0xeae668aaU,
    0xcd1549e7U,
    0xa93ce016U,
    0x9c02d00fU,
    0xda01e827U,
    0xfd04e414U,
    0xfc82962cU,
    0xa2c5873cU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x78000000U,
    0x74000000U,
    0xba000000U,
    0x5000000U,
    0xb4800000U,
    0xb2400000U,
    0x56e00000U,
    0xf6100000U,
    0xd480000U,
    0xdb5c0000U,
    0x86160000U,
    0x854f0000U,
    0x67598000U,
    0x20154000U,
    0x364f6000U,
    0x18dff000U,
    0x99d0b800U,
    0x636aec00U,
    0xbeefc600U,
    0x862f9d00U,
    0x158beb80U,
    0x18fa1cc0U,
    0x53642da0U,
    0xaad581d0U,
    0x5cefc608U,
    0xa72f9d14U,
    0xc30bebb6U,
    0xcbba1cd9U,
    0x73042d90U,
    0x9f8581ccU,
    0x9c7c60bU,
    0x3d239d39U,
    0xaa35eb8eU,
    0xd1f91cc8U,
    0xc9e3ad86U,
    0x1793c1c7U,
    0xd38f2629U,
    0x5bfa2d2eU,
    0xe4e5b3b6U,
    0xf1640e1U,
    0xbfca3392U,
    0xca1c00c9U,
    0xd774d382U,
    0xbe9ab0f0U,
    0x85350b9fU,
    0x587cacc8U,
    0x1b25f590U,
    0x59339deaU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x68000000U,
    0xa4000000U,
    0xe6000000U,
    0xaf000000U,
    0x9d800000U,
    0xea400000U,
    0xf600000U,
    0xb1900000U,
    0x8b480000U,
    0xf2dc0000U,
    0x8d920000U,
    0x61490000U,
    0xffd88000U,
    0x2912c000U,
    0xd18f6000U,
    0x237a9000U,
    0x9ba08800U,
    0x4b36f400U,
    0x76fd2e00U,
    0x85e1a100U,
    0x5a540380U,
    0xd46f78c0U,
    0xb9292da0U,
    0xafced9f0U,
    0x821d2e18U,
    0xb131a12cU,
    0xa3fc03a2U,
    0xd6378f5U,
    0xd8932d83U,
    0x29cbd9f2U,
    0x9d1fae06U,
    0xa4b6613dU,
    0x9db9e386U,
    0x8c0228e3U,
    0x620445a2U,
    0xd9057de2U,
    0x2a856807U,
    0xbbc7a419U,
    0xa722461aU,
    0xf7f30531U,
    0x85cc589U,
    0xe57bdd0U,
    0x9a6a082dU,
    0x522d341fU,
    0xa44ace3bU,
    0xaf59f12bU,
    0x87d3ebbbU,
    0x1e2f1cefU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0xc8000000U,
    0x14000000U,
    0xce000000U,
    0x35000000U,
    0xd3800000U,
    0xcac00000U,
    0x52200000U,
    0x18f00000U,
    0xe2c80000U,
    0x623c0000U,
    0xacf60000U,
    0xbcc90000U,
    0x4f3a8000U,
    0x1375c000U,
    0x640fe000U,
    0xf21c5000U,
    0x23021800U,
    0xaa80d400U,
    0xdb409a00U,
    0xfe0df00U,
    0xbe538280U,
    0xc79cbc0U,
    0x309318a0U,
    0xa85914d0U,
    0xa1609a38U,
    0xf310df3cU,
    0x3a9b82aaU,
    0xff45cbe9U,
    0x49e518a1U,
    0xff5014d8U,
    0xa1fa1a3fU,
    0x7551f03U,
    0x3dfc628aU,
    0xbd559bddU,
    0x76f9008dU,
    0x93d5c0c6U,
    0x7bbe002cU,
    0xc5350034U,
    0x46c8032U,
    0xec8cc036U,
    0x4e5d6027U,
    0x7065902eU,
    0x4693f805U,
    0x6159841eU,
    0x78e60226U,
    0xbad0cb36U,
    0x523878bfU,
    0x24f584e6U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0x8000000U,
    0x34000000U,
    0xca000000U,
    0xd3000000U,
    0xbf800000U,
    0x51400000U,
    0xc200000U,
    0x6a700000U,
    0x8a680000U,
    0x341c0000U,
    0x4760000U,
    0xdb6b0000U,
    0x4c9d8000U,
    0x30b6c000U,
    0x5d0ae000U,
    0xa14a7000U,
    0x4bee0800U,
    0x3c5d8400U,
    0x44d70600U,
    0x4fd9e300U,
    0x93943680U,
    0x56fd46c0U,
    0x736330a0U,
    0x1754a5d0U,
    0x889f0628U,
    0x82b5e314U,
    0x820a368aU,
    0xf8ca46c9U,
    0x3fa8b090U,
    0xa2f965e9U,
    0xd9606635U,
    0xf4555334U,
    0x2f18dea6U,
    0xeff6b2c7U,
    0x702c3eb1U,
    0x8bbbc2feU,
    0xd941b696U,
    0x782786cfU,
    0x8077d094U,
    0x4969d5edU,
    0x839a8e3dU,
    0x6135a71eU,
    0x1d4a50b1U,
    0xf5ef15f5U,
    0x5586e2dU,
    0x3853d701U,
    0xa91a5885U,
    0xfaf591d1U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0xf8000000U,
    0xb4000000U,
    0xa6000000U,
    0x9d000000U,
    0xfe800000U,
    0xaf400000U,
    0x69200000U,
    0x45100000U,
    0x71d80000U,
    0x38cc0000U,
    0x7b120000U,
    0x8d90000U,
    0x784f8000U,
    0x6d514000U,
    0xc17b6000U,
    0xbb1f1000U,
    0x2d289800U,
    0x8ee47c00U,
    0x26779e00U,
    0xf76bab00U,
    0x95409d80U,
    0x3e227840U,
    0x449703a0U,
    0x7319d370U,
    0xd12f9e18U,
    0x14e7ab14U,
    0xc1729d86U,
    0x7eeb7849U,
    0x4b8083b7U,
    0x3dc4937aU,
    0xa466fe0eU,
    0x7f31bb18U,
    0x1b4d85a3U,
    0xad24473U,
    0xbebe7db1U,
    0x3c792865U,
    0x15997b8cU,
    0x9a6aff54U,
    0xc3c47803U,
    0x3d662c1aU,
    0xafb66607U,
    0xf509c704U,
    0x77701b91U,
    0xdbecef60U,
    0xe103602eU,
    0xa483102aU,
    0xa8429803U,
    0x70a17c17U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x70000000U,
    0x8000000U,
    0x24000000U,
    0x8a000000U,
    0x11000000U,
    0x40800000U,
    0x46400000U,
    0x91200000U,
    0xb8100000U,
    0xf0680000U,
    0x727c0000U,
    0xfb160000U,
    0xbdeb0000U,
    0xf2be8000U,
    0xe375c000U,
    0x475a6000U,
    0x8903f000U,
    0x7c851800U,
    0xb042ec00U,
    0x5626c600U,
    0x4f922300U,
    0x49aae580U,
    0x7e9a25c0U,
    0xc5e423a0U,
    0x627406d0U,
    0x1fd8c628U,
    0xb345230cU,
    0x3ba2658aU,
    0xbf54e5d5U,
    0x59c8c380U,
    0xa02e36ddU,
    0x3459be1aU,
    0xec833f19U,
    0xa8413bbeU,
    0x2a26eaeaU,
    0x99960018U,
    0xfeab002fU,
    0x811e8038U,
    0x5825c03aU,
    0xe4926034U,
    0x302ff021U,
    0x2c5b1817U,
    0x9085ec2cU,
    0x7e46461cU,
    0x9d20e32cU,
    0x661005acU,
    0x636b15c6U,
    0x7fbdbb6U,
    0x77d7dadaU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x10000000U,
    0x58000000U,
    0x74000000U,
    0x66000000U,
    0x8f000000U,
    0x26800000U,
    0x6c400000U,
    0xd7600000U,
    0x90d00000U,
    0xb0480000U,
    0x8e9c0000U,
    0x5dd20000U,
    0x7c90000U,
    0xcf5b8000U,
    0xee704000U,
    0x8f386000U,
    0xc231000U,
    0xc5330800U,
    0x92db2c00U,
    0x2b64600U,
    0x5b1e5100U,
    0x7d17d180U,
    0xd1eee2c0U,
    0xf6997a0U,
    0x272cb3f0U,
    0x3e4c4618U,
    0x1d9b5134U,
    0xc15651aeU,
    0xbe8ba2d9U,
    0xfbb877afU,
    0xa966e3ceU,
    0x4bd4ae08U,
    0xcf2d0cU,
    0x25d97f92U,
    0x8034cfe6U,
    0xe9596836U,
    0x41713c09U,
    0x59bece13U,
    0x28653d1eU,
    0x3e51f78eU,
    0x100fa3d8U,
    0x5bff4e30U,
    0x7c007d2cU,
    0x6a001798U,
    0x6d05f3daU,
    0x8787a616U,
    0xe9c40101U,
    0x8fa73982U,
    0xc2f69edeU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x10000000U,
    0xa8000000U,
    0xac000000U,
    0x1a000000U,
    0x43000000U,
    0x58800000U,
    0x7e400000U,
    0xcba00000U,
    0x4f300000U,
    0x98a80000U,
    0xf19c0000U,
    0xd8360000U,
    0xbe2b0000U,
    0x4add8000U,
    0xaa13c000U,
    0x90db2000U,
    0x89103000U,
    0xf85d0800U,
    0x4f55fc00U,
    0x37fe0600U,
    0xb6672700U,
    0xf6531880U,
    0x5c7b1ac0U,
    0x8a51ea0U,
    0x57b03dd0U,
    0xc6e80628U,
    0x2a3c2714U,
    0x3f0698a2U,
    0x8a84daefU,
    0xa1403e8cU,
    0x31270debU,
    0x76768e38U,
    0xbd8d1b1bU,
    0x99e83e86U,
    0x90bb0de3U,
    0x26408e18U,
    0xbfa61b04U,
    0x6135be88U,
    0xd5a8cdd8U,
    0xf41bae0aU,
    0xbf62b32U,
    0xa48b6acU,
    0xab8d31f3U,
    0x90eda816U,
    0x33d0c06U,
    0xbc85ae2bU,
    0xb8412b3cU,
    0xaa3369cU,
    0x40b5f1faU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0xd8000000U,
    0xfc000000U,
    0xde000000U,
    0x2f000000U,
    0x74800000U,
    0xc3400000U,
    0x38a00000U,
    0x68f00000U,
    0x64480000U,
    0x76bc0000U,
    0x5ff60000U,
    0xccc90000U,
    0xbbfa8000U,
    0x20554000U,
    0xf4b82000U,
    0x3ef39000U,
    0x9f4ec800U,
    0x983cfc00U,
    0x21b72e00U,
    0xa9ef9700U,
    0xb7cd3e80U,
    0x157e6bc0U,
    0x3e1210a0U,
    0x219dfcd0U,
    0xeac12e38U,
    0x5666973cU,
    0x8c97beaeU,
    0x11db2bd3U,
    0xa8e230a1U,
    0xbad26ce4U,
    0x80f9e612U,
    0xeed36b07U,
    0x5afa10bdU,
    0x33d1fcf9U,
    0xb77f2e36U,
    0x8f139723U,
    0x1a1b3ebcU,
    0xed076bf9U,
    0x758090bcU,
    0x20c4bcfeU,
    0xc3670e0bU,
    0x95100737U,
    0xe71df6a7U,
    0xd08797e4U,
    0xa141beb9U,
    0xa9a22bc9U,
    0x8370b0bdU,
    0xb8b2cf2U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xd0000000U,
    0xe8000000U,
    0x6c000000U,
    0xee000000U,
    0x8d000000U,
    0xf6800000U,
    0xf2c00000U,
    0x39a00000U,
    0x48700000U,
    0x13c80000U,
    0x7abc0000U,
    0x51f60000U,
    0xe4890000U,
    0x42598000U,
    0x9867c000U,
    0x72552000U,
    0xbbf99000U,
    0xf016d800U,
    0xd19dfc00U,
    0xf9433200U,
    0x25e1c300U,
    0xb7141280U,
    0xd81f1fc0U,
    0xc60120a0U,
    0xc107dcd0U,
    0xa884b238U,
    0x47c30324U,
    0x4b26b2a2U,
    0x38b44fefU,
    0x496d58a1U,
    0x494d70e8U,
    0x467df83eU,
    0x55516c3bU,
    0x627a6a11U,
    0x2752ff01U,
    0x597b808bU,
    0x8d08cf4U,
    0x373eca36U,
    0xccb0af28U,
    0xd36e78afU,
    0x1e4de0c5U,
    0x87faa01cU,
    0xb617500fU,
    0x509a7813U,
    0x31c3ac2aU,
    0xb220ca01U,
    0x1435af05U,
    0x8ca9f8aaU,
    0x616f20c6U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0xb8000000U,
    0x14000000U,
    0x9e000000U,
    0xd7000000U,
    0x51800000U,
    0x25400000U,
    0xe1a00000U,
    0x95f00000U,
    0x1e80000U,
    0x6f1c0000U,
    0xf5760000U,
    0x96290000U,
    0xf4788000U,
    0x3b644000U,
    0x1e146000U,
    0xa038d000U,
    0x8440800U,
    0x1235400U,
    0x4234f600U,
    0xfa8bef00U,
    0x510e5680U,
    0xc549a6c0U,
    0xd66ca0a0U,
    0x595b49d0U,
    0xf3527638U,
    0xad9aaf2cU,
    0x77b4b6b6U,
    0xb9cc36f9U,
    0x13ac48a9U,
    0x6f388de0U,
    0x9dc0e80bU,
    0x9263c410U,
    0x28929e1aU,
    0xcf96b15U,
    0x28a628b1U,
    0x53755dceU,
    0x152a602eU,
    0x5bfdd012U,
    0x39228834U,
    0x1632143bU,
    0x48e162cU,
    0x760e7f1dU,
    0x2ccebe9fU,
    0xe72a62e3U,
    0x26fe3ea6U,
    0xb1a222ccU,
    0xfdf45ebeU,
    0x3deff2e0U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x98000000U,
    0x14000000U,
    0x2000000U,
    0x27000000U,
    0xcc800000U,
    0x8c400000U,
    0x58a00000U,
    0x33d00000U,
    0x2a680000U,
    0x22bc0000U,
    0x2a520000U,
    0xc5ab0000U,
    0x16df8000U,
    0xb604000U,
    0x39b76000U,
    0xd25b3000U,
    0x6b276800U,
    0x7153c00U,
    0x8c8fb600U,
    0x26cd0f00U,
    0x736ac780U,
    0x573d6bc0U,
    0x639771a0U,
    0x3ccb64f0U,
    0x806a3608U,
    0x39ba4f04U,
    0x18d0278eU,
    0x30ed1bf1U,
    0x2bf8f986U,
    0x497528fcU,
    0x2ebd883bU,
    0xfc554c2eU,
    0x40a83e2bU,
    0x2d5f431eU,
    0xd3a779baU,
    0xf95568c8U,
    0xbb2ae813U,
    0x559e7c23U,
    0xc3475602U,
    0x8267f28U,
    0x9192cfb1U,
    0x93cf67f7U,
    0x60edafb4U,
    0x73f857f5U,
    0xfd70c78dU,
    0xfcba6bdcU,
    0x4352f18cU,
    0x982c24e7U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0x98000000U,
    0xac000000U,
    0x12000000U,
    0xb1000000U,
    0xe0800000U,
    0x6fc00000U,
    0x9200000U,
    0x83b00000U,
    0xb1280000U,
    0xc19c0000U,
    0x79320000U,
    0xfbed0000U,
    0x26398000U,
    0x7e404000U,
    0x2664a000U,
    0x55507000U,
    0x73bf5800U,
    0xc7072c00U,
    0xb7878a00U,
    0xe0452f00U,
    0xf5605880U,
    0x2cd12ec0U,
    0x18fdd2a0U,
    0x87e501f0U,
    0x32160a38U,
    0x91596f04U,
    0xbb96f8beU,
    0x121c5edfU,
    0x7f730a82U,
    0x618e6df7U,
    0x996f2004U,
    0xc0fd3033U,
    0x8be27804U,
    0x90171c24U,
    0x685c720cU,
    0x6f127317U,
    0xc3d88a8eU,
    0xd5532df9U,
    0xb3ba000dU,
    0xa701002aU,
    0x67838036U,
    0x7841402eU,
    0x59672001U,
    0x3ed13001U,
    0xa9f87822U,
    0x67661c04U,
    0x5dd7f228U,
    0x987f3322U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0xb8000000U,
    0x34000000U,
    0x7e000000U,
    0x6d000000U,
    0x65800000U,
    0x94400000U,
    0x67a00000U,
    0xfb100000U,
    0xd7080000U,
    0xcf1c0000U,
    0xd8920000U,
    0xda4b0000U,
    0x13398000U,
    0xcac74000U,
    0xb7676000U,
    0x8777d000U,
    0xdcfdd800U,
    0x34202400U,
    0xfe53de00U,
    0x972a0700U,
    0x2f482180U,
    0x92b92ec0U,
    0x3881ffa0U,
    0x99c429f0U,
    0xdfe25e08U,
    0xc6b14734U,
    0x871d4186U,
    0x2495fec9U,
    0x984da791U,
    0x9c3f4de6U,
    0x3044e00eU,
    0x61a7900aU,
    0x2113806U,
    0xdc8bb412U,
    0x8e58e61dU,
    0xeeb6b31bU,
    0xcb1b4785U,
    0xce93ddfbU,
    0x9b4c5812U,
    0x2cbb642fU,
    0xf586be2dU,
    0xec46d71aU,
    0xf3a479b7U,
    0x95124ae4U,
    0x20f4185U,
    0x9e9efec7U,
    0x32d4278cU,
    0xd0e80dc3U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0x18000000U,
    0x24000000U,
    0x6a000000U,
    0xaf000000U,
    0xc3800000U,
    0x2a400000U,
    0xa0600000U,
    0xed100000U,
    0x8b180000U,
    0x70c0000U,
    0xca960000U,
    0x2b5f0000U,
    0xd86a8000U,
    0x8c054000U,
    0xb606e000U,
    0x3104f000U,
    0x6e856800U,
    0x7ac28400U,
    0x7a53e00U,
    0xa2327900U,
    0xaae90f80U,
    0x88c07e40U,
    0xcca231a0U,
    0xabb10750U,
    0x5fafbe08U,
    0xf327390cU,
    0x2ff7efaeU,
    0xeac88e55U,
    0x1ab159bcU,
    0x712c8372U,
    0x29e00022U,
    0x5850002dU,
    0x50f80036U,
    0x945c0024U,
    0x93ee0016U,
    0x4a430018U,
    0x3064803aU,
    0x2516402aU,
    0xc71a601cU,
    0x510eb018U,
    0x2b910811U,
    0x2ddf3415U,
    0x9ea8b626U,
    0xc5a70d19U,
    0xd135d99eU,
    0xf76ac35fU,
    0xf826010U,
    0x3c42b035U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x70000000U,
    0xe8000000U,
    0xac000000U,
    0x12000000U,
    0x5000000U,
    0x68800000U,
    0x13400000U,
    0x73e00000U,
    0xb7d00000U,
    0xfe880000U,
    0xda5c0000U,
    0x17560000U,
    0x71cf0000U,
    0xf3ba8000U,
    0x7982c000U,
    0x1dc52000U,
    0x93a37000U,
    0x67b47800U,
    0xcd994c00U,
    0x85f22e00U,
    0x60f9bd00U,
    0x4a644d80U,
    0xa1014c0U,
    0x1d2863a0U,
    0x55eaa9d0U,
    0x76c8ae08U,
    0xe63b7d0cU,
    0x96416d92U,
    0x5b6364f7U,
    0x4941b9eU,
    0xfd6fe5faU,
    0x858c8016U,
    0x45ddc009U,
    0xb997a014U,
    0xe1edb01eU,
    0x60cf581dU,
    0xfd393c31U,
    0x99c2d624U,
    0xcda1312fU,
    0xa0b7c3bfU,
    0x381b19ebU,
    0xba31f638U,
    0xbe5d4131U,
    0x99513b8cU,
    0x2ecc95e1U,
    0x4238f81bU,
    0xf8448c12U,
    0xd4658e24U,
    0x2d140d3dU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xf0000000U,
    0x88000000U,
    0xc4000000U,
    0xa000000U,
    0x8f000000U,
    0x41800000U,
    0xc0c00000U,
    0xd2a00000U,
    0x39d00000U,
    0x43f80000U,
    0xc32c0000U,
    0xc8520000U,
    0x6b3b0000U,
    0x858e8000U,
    0x8381c000U,
    0xebc16000U,
    0xc924f000U,
    0xe17e800U,
    0x9cdc1400U,
    0xf43e7a00U,
    0xdc0ebb00U,
    0x5f462f80U,
    0x8f635b40U,
    0x39f255a0U,
    0x4d6ae070U,
    0x5bb0fa08U,
    0xe08f7b0cU,
    0xdd074f8aU,
    0xb287ab4dU,
    0x6745bd80U,
    0xa366f462U,
    0xa7f6801aU,
    0xb06dc01fU,
    0xd933602eU,
    0xafcff033U,
    0x4a616804U,
    0x9771d42cU,
    0x9c2d1a30U,
    0x31d14b39U,
    0x47ff47b7U,
    0x692e8f44U,
    0xb7554f9fU,
    0xa2bcab5cU,
    0x814b3d93U,
    0x5b273473U,
    0x5d17e007U,
    0xcb593017U,
    0xdfc8839U,
    0x862fe428U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xb0000000U,
    0xd8000000U,
    0x6c000000U,
    0x36000000U,
    0x9f000000U,
    0x50800000U,
    0xfdc00000U,
    0xc6600000U,
    0xfd100000U,
    0x3df80000U,
    0x106c0000U,
    0x90560000U,
    0x26590000U,
    0xfb1a8000U,
    0x38bd4000U,
    0xbfc8a000U,
    0x21225000U,
    0x27b70800U,
    0xad0d5c00U,
    0x4fc0fa00U,
    0x9b633500U,
    0x8967780U,
    0x89bba540U,
    0x3c4c0da0U,
    0x6a65d050U,
    0xeb12da38U,
    0x72fc253cU,
    0x28e9dfaeU,
    0xd994a977U,
    0xba3bff9bU,
    0xaf0bb96cU,
    0xcac457a1U,
    0x2e4b564U,
    0x8ad3a5abU,
    0x3a9adc67U,
    0x96fd283dU,
    0x5aee4c3bU,
    0xa491521cU,
    0x9fb93922U,
    0x734d0584U,
    0x52e18c7bU,
    0xa2d0a016U,
    0xee9e5035U,
    0x7cf90830U,
    0x2be85c02U,
    0x7147a08U,
    0x4fb752aU,
    0xd7ea57a6U,
    0x3911b568U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0xb8000000U,
    0xe4000000U,
    0xee000000U,
    0x43000000U,
    0xf0800000U,
    0x90400000U,
    0x30a00000U,
    0xcf700000U,
    0xa6680000U,
    0xf99c0000U,
    0x1fb20000U,
    0x7e8f0000U,
    0xc24c8000U,
    0xa8ae4000U,
    0xda79e000U,
    0x30e2d000U,
    0xb7d62800U,
    0x151ffc00U,
    0x65f31600U,
    0xf32c8f00U,
    0x36bf3280U,
    0x3206a6c0U,
    0x8900a4a0U,
    0x7d8469f0U,
    0x13c67628U,
    0xe8601f3cU,
    0x8b90faa6U,
    0xb7bb8af5U,
    0xd3859ab5U,
    0xb0c71ad9U,
    0x8e252afU,
    0x93d636c8U,
    0xdb1d6cb6U,
    0x16f645d2U,
    0xbbafc818U,
    0x42fd2c18U,
    0xeca53e0fU,
    0x5737320U,
    0x2b6c2492U,
    0x7a1a29cbU,
    0xc7779604U,
    0x3a6ecf2fU,
    0xd39cd28dU,
    0x82b776f3U,
    0x75080ca8U,
    0x468ad5c8U,
    0xe648002fU,
    0x66ac001bU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x10000000U,
    0x98000000U,
    0x9c000000U,
    0xae000000U,
    0x3d000000U,
    0xa4800000U,
    0xa4400000U,
    0xdda00000U,
    0x1f00000U,
    0x35580000U,
    0xc02c0000U,
    0xa9320000U,
    0x98bb0000U,
    0x16798000U,
    0x829e4000U,
    0xc24f2000U,
    0xdea61000U,
    0xc073d800U,
    0x9996c00U,
    0x7c9d600U,
    0xd0657700U,
    0x9490be80U,
    0xe948bb40U,
    0xb20e8a0U,
    0x56b38c70U,
    0xc17f7608U,
    0x491d2734U,
    0xe18c468eU,
    0xb6c7c763U,
    0x18e2e6adU,
    0x76d39758U,
    0xbdec1e8aU,
    0x1457eb52U,
    0x50af90b0U,
    0x7775b07aU,
    0x7219d83fU,
    0xac0e6c2cU,
    0xbc02562bU,
    0x7e003713U,
    0x5061ebcU,
    0x2880eb47U,
    0x924410adU,
    0x7ca0f071U,
    0xb777831U,
    0xac1a3c3eU,
    0xb90cae2aU,
    0xc844b23U,
    0x704590bbU,
    0xd7a2b067U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x28000000U,
    0x64000000U,
    0x1e000000U,
    0xf1000000U,
    0x41800000U,
    0xcbc00000U,
    0xdae00000U,
    0xbd500000U,
    0xfb380000U,
    0xefec0000U,
    0x9b160000U,
    0xc0190000U,
    0x2f5f8000U,
    0x19ffc000U,
    0x688f6000U,
    0xdf865000U,
    0x7ac7b800U,
    0xfb646400U,
    0x66964200U,
    0x9dd9100U,
    0x36b96980U,
    0x7e2f1940U,
    0xdef0aba0U,
    0xf5cd4850U,
    0x1226a238U,
    0x9d340114U,
    0x7b29b192U,
    0xe9712d5dU,
    0xcb0f51adU,
    0x8741bd75U,
    0x32a009afU,
    0x7f70495aU,
    0x6e089394U,
    0x80c6ec50U,
    0x5467803dU,
    0xb613c025U,
    0x9399601dU,
    0xf9f5018U,
    0x7d983806U,
    0x869ba40eU,
    0x1019220eU,
    0x275bc12bU,
    0xdfed1baU,
    0x4e8b7d5fU,
    0x6286e982U,
    0x4140d94eU,
    0xdfa7cba5U,
    0xcf71873U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xd0000000U,
    0xd8000000U,
    0x34000000U,
    0x9a000000U,
    0x57000000U,
    0xda800000U,
    0xe400000U,
    0x4da00000U,
    0x40700000U,
    0xf6980000U,
    0x6c0000U,
    0x96b20000U,
    0x767d0000U,
    0xfd398000U,
    0x711a4000U,
    0xfbae6000U,
    0x8bd2f000U,
    0xe7eb2800U,
    0xbd728c00U,
    0xb31d9600U,
    0x58ac1700U,
    0xab55f280U,
    0x6eaeb940U,
    0xf251e4a0U,
    0xc928ee70U,
    0x79927638U,
    0xbc48a704U,
    0xd402baaeU,
    0x8a03c579U,
    0xef06dab0U,
    0x3e803568U,
    0x4c4672a8U,
    0x2ea5f952U,
    0xf404abU,
    0xafdd5e5aU,
    0x974ebe06U,
    0xd8829b0cU,
    0xcd4264a6U,
    0xbd23ae72U,
    0x1137960fU,
    0x8dbd173aU,
    0xe05e72a7U,
    0xe089f94cU,
    0xbbe604acU,
    0x49d05e7eU,
    0x44ef3e3fU,
    0x9df4db39U,
    0x3a5e0487U,
    0x178c5e54U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xb8000000U,
    0xcc000000U,
    0xea000000U,
    0x25000000U,
    0xa5800000U,
    0xba400000U,
    0x4ba00000U,
    0xc6b00000U,
    0x93480000U,
    0xaa7c0000U,
    0x2e720000U,
    0xee2f0000U,
    0xf2ab8000U,
    0x7f694000U,
    0x4788a000U,
    0x551cb000U,
    0x27a63800U,
    0x3cb62400U,
    0x2e4b8e00U,
    0x13f8d700U,
    0xc6369c80U,
    0x4c8d49c0U,
    0x7b9e92a0U,
    0x7360def0U,
    0x3d2ae28U,
    0x79e2704U,
    0x116184a6U,
    0xa2d19dc7U,
    0xec1804b4U,
    0x1027ddcaU,
    0x4ff324bbU,
    0xfa6e2de3U,
    0xf20fbcbdU,
    0x775bb9e8U,
    0x70018a8aU,
    0xa8000ae5U,
    0x5406383aU,
    0xf6062401U,
    0x77038e10U,
    0x4c84d735U,
    0xf5c49ca6U,
    0xd4e249c5U,
    0x28951296U,
    0xefb99eedU,
    0x72920e02U,
    0x42be971eU,
    0x5315bc8cU,
    0xb6f8b9faU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x50000000U,
    0x98000000U,
    0x44000000U,
    0xc6000000U,
    0xa7000000U,
    0x2b800000U,
    0xb4400000U,
    0x5c200000U,
    0x31500000U,
    0x43a80000U,
    0xbb7c0000U,
    0x9d960000U,
    0x9e4f0000U,
    0x214b8000U,
    0xec84000U,
    0xdc8de000U,
    0x77ad9000U,
    0xf57e4800U,
    0x46930400U,
    0x67c9ae00U,
    0x6c092b00U,
    0x9a6b5f80U,
    0xb41981c0U,
    0x7b6171a0U,
    0x8f4ead0U,
    0x1db9ce08U,
    0x5d73fb04U,
    0x5afb778eU,
    0xd4d355c5U,
    0x6ced77b7U,
    0xbedc55e8U,
    0xb186f7b3U,
    0xd14415c0U,
    0xb6a317b3U,
    0x599585f4U,
    0x184b5f98U,
    0x264981deU,
    0x754971a2U,
    0xf0c8ead8U,
    0x6f8fce2dU,
    0x22cfb39U,
    0xa238f78dU,
    0xf73715fdU,
    0x45de9797U,
    0x5802c5ccU,
    0xa4053fbfU,
    0x360051ccU,
    0x6f04d984U,
    0xf7857ed5U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0xd0000000U,
    0x8000000U,
    0xcc000000U,
    0xee000000U,
    0xd3000000U,
    0x52800000U,
    0x4ac00000U,
    0xa5e00000U,
    0xbed00000U,
    0x68780000U,
    0x562c0000U,
    0x51920000U,
    0x47db0000U,
    0x42df8000U,
    0xb75cc000U,
    0xf5192000U,
    0x33389000U,
    0x83882800U,
    0xbc63ac00U,
    0x2941200U,
    0xd55b3100U,
    0xa81f0580U,
    0xc2bbbf40U,
    0x43cc97a0U,
    0x97404e70U,
    0x3ba0b208U,
    0x3ef46104U,
    0x17c98daaU,
    0xdd404347U,
    0xbaa38d99U,
    0x89774377U,
    0x188e0da7U,
    0x42e08362U,
    0xd650adb7U,
    0x7bb8d34aU,
    0x804ba582U,
    0xc204ef79U,
    0x8d021fabU,
    0xf987b255U,
    0xc45a808U,
    0xc5246c02U,
    0xea32b21bU,
    0xb92f613aU,
    0xf5160d97U,
    0xba1c835dU,
    0x47baad98U,
    0x764fd34aU,
    0x750625bcU,
    0x2d832f59U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0xe8000000U,
    0xb4000000U,
    0x22000000U,
    0x81000000U,
    0x21800000U,
    0x56400000U,
    0xc2200000U,
    0xa9100000U,
    0xe6480000U,
    0x2fdc0000U,
    0x5e560000U,
    0xb5ef0000U,
    0x988e8000U,
    0x3e3ec000U,
    0xf921e000U,
    0x15943000U,
    0xa788d800U,
    0xe8bc6400U,
    0x7de64e00U,
    0x39731b00U,
    0xe77dcd80U,
    0xa5810cc0U,
    0x7c4303a0U,
    0xa723d7d0U,
    0xb291ae08U,
    0x6d082b2cU,
    0x5a7b9592U,
    0x203a8d1U,
    0x3104ad92U,
    0x6984fcddU,
    0x1244bb88U,
    0x82543d9U,
    0x9c16d80aU,
    0xe5cf643eU,
    0xf89ece13U,
    0xbdf2db10U,
    0x4abaad94U,
    0xbce7fcfeU,
    0xb8f43ba1U,
    0x413883edU,
    0x8fa7b811U,
    0x61569412U,
    0x636f761bU,
    0x1c4b4f22U,
    0x12db5b8cU,
    0xb9d273d0U,
    0x58ae8009U,
    0xa62ec025U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x90000000U,
    0xb8000000U,
    0x1c000000U,
    0x1a000000U,
    0xd1000000U,
    0x3800000U,
    0x65c00000U,
    0x27a00000U,
    0xc0500000U,
    0xe3b80000U,
    0x516c0000U,
    0x4960000U,
    0x8f9b0000U,
    0xe0f98000U,
    0xee8f4000U,
    0x71a22000U,
    0xd357b000U,
    0x9d3e1800U,
    0x52b3400U,
    0x33f0c200U,
    0x6defab00U,
    0x6dd0fb80U,
    0xa97fe540U,
    0x824fb9a0U,
    0xf9840e50U,
    0x44c4e228U,
    0x2c231b34U,
    0x919763a6U,
    0x7a1b9163U,
    0x463d5b88U,
    0x2fac1563U,
    0x69b201aeU,
    0xa58bca59U,
    0xe326180fU,
    0x9517341aU,
    0x4f5ec211U,
    0x5ad8ab33U,
    0xc1f7b91U,
    0xc53ba55dU,
    0xe92c1996U,
    0x21f0fe55U,
    0x88eeda3dU,
    0xd0549f06U,
    0x1bb839adU,
    0x6d6c4e51U,
    0x8e914222U,
    0xe69ceb35U,
    0xff7cdbbcU,
    0x914f5554U,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x48000000U,
    0xec000000U,
    0xb2000000U,
    0x3000000U,
    0xf3800000U,
    0x70c00000U,
    0x3f200000U,
    0x9c300000U,
    0xec580000U,
    0x28ec0000U,
    0x9bf60000U,
    0x76fb0000U,
    0xb91f8000U,
    0x5a0ec000U,
    0xa622000U,
    0x9ed37000U,
    0x65cc4800U,
    0x64c42400U,
    0x1926aa00U,
    0xf9319700U,
    0x5add8c80U,
    0xbea9c140U,
    0x7a92a6a0U,
    0xe7ad9650U,
    0x76128a28U,
    0xbee9e704U,
    0x86f6449aU,
    0x147f256fU,
    0x69582c9eU,
    0xae68716bU,
    0x35b2ceb8U,
    0x639dc258U,
    0x3e49e809U,
    0xc8059404U,
    0xac06c202U,
    0x9201c302U,
    0x5306ee9fU,
    0xbb85b270U,
    0x9cc22037U,
    0x8d237020U,
    0x9f34482cU,
    0x1fd82414U,
    0x5828aa1bU,
    0xa4d69735U,
    0xeacc0c80U,
    0x55400166U,
    0x72e10686U,
    0x91972671U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0xa8000000U,
    0x4000000U,
    0x2a000000U,
    0xcb000000U,
    0x32800000U,
    0x68400000U,
    0xada00000U,
    0xabf00000U,
    0x2ba80000U,
    0xfddc0000U,
    0x66b20000U,
    0xb58f0000U,
    0x97ee8000U,
    0x627cc000U,
    0x8a466000U,
    0xf2a5f000U,
    0x4b70c800U,
    0x54e92c00U,
    0xe4fae600U,
    0x40030700U,
    0xe001ae80U,
    0x50020cc0U,
    0xd807c8a0U,
    0xac02cbf0U,
    0x2e068628U,
    0xe105f72cU,
    0xf985e6a2U,
    0x5ac4e0ddU,
    0xc5e7ce80U,
    0x657fcc3U,
    0x805f00aeU,
    0xd677e7c4U,
    0x9b6e6025U,
    0xd339f01dU,
    0x2262c809U,
    0xf5962c3aU,
    0xe83c663fU,
    0x78e3c73bU,
    0xb9d5ce91U,
    0x1f98fcf7U,
    0xb011808aU,
    0xa4fb27dbU,
    0xa0000020U,
    0xb000003dU,
    0x8800003fU,
    0x74000012U,
    0x8200003fU,
    0xcf00003eU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xd0000000U,
    0x38000000U,
    0x7c000000U,
    0x6000000U,
    0xf7000000U,
    0xae800000U,
    0x79400000U,
    0x9d600000U,
    0x22500000U,
    0xc5880000U,
    0x625c0000U,
    0x86120000U,
    0xff690000U,
    0xfccd8000U,
    0xdf3d4000U,
    0x94472000U,
    0xd2e45000U,
    0xda97c800U,
    0x232e6c00U,
    0x9a28ae00U,
    0x77a94900U,
    0xd26a0580U,
    0x534db8c0U,
    0xf7fd2ba0U,
    0x4ae0b1f0U,
    0x56958e18U,
    0x2d281904U,
    0xf92a4db6U,
    0x9b2b94ebU,
    0x262d25afU,
    0x91a9e8d2U,
    0xf56ae3b2U,
    0xc5cedde7U,
    0xf2bd201aU,
    0xd181500dU,
    0x83c04821U,
    0x46262c06U,
    0xe2300e34U,
    0x8059591bU,
    0xfb176d93U,
    0xa8eac4e3U,
    0x480d6d87U,
    0xd79fc4fdU,
    0xdf32edbcU,
    0xf7db84d7U,
    0x7fd04da9U,
    0x484e94deU,
    0x477aa5beU,
    0x88a1a8d3U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x70000000U,
    0xd8000000U,
    0x84000000U,
    0xd6000000U,
    0xc5000000U,
    0x92800000U,
    0xb6400000U,
    0xdb200000U,
    0xa0b00000U,
    0x3380000U,
    0x600c0000U,
    0x79f60000U,
    0xd9d0000U,
    0xbf788000U,
    0x6c2b4000U,
    0xb8c3e000U,
    0x9f641000U,
    0xf892d800U,
    0x5c0bdc00U,
    0x1bf17600U,
    0x269dd300U,
    0x1cfcd080U,
    0x46ef9240U,
    0x94a326a0U,
    0xa0740150U,
    0x285c9618U,
    0x7698c30cU,
    0x14f8888eU,
    0x8aee0e7dU,
    0x6ea730a3U,
    0xef778240U,
    0x2ddffe89U,
    0x415edd50U,
    0x2e1b603cU,
    0xd5bf5028U,
    0xa049380dU,
    0xf7d3cc3cU,
    0x97adae39U,
    0x56070f26U,
    0x85032696U,
    0x7284016cU,
    0xc6449633U,
    0x324c331U,
    0x24b68880U,
    0xd53f0e5fU,
    0xa509b09fU,
    0xeb71c26fU,
    0xbbdc9eb3U,
    0x645d8d5aU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0xc8000000U,
    0x8c000000U,
    0xa000000U,
    0xfd000000U,
    0x44800000U,
    0x35400000U,
    0xff200000U,
    0xd3b00000U,
    0x38880000U,
    0x88bc0000U,
    0x94f20000U,
    0x2eab0000U,
    0xf18d8000U,
    0x7238c000U,
    0x22b52000U,
    0xb60bb000U,
    0xe0fc7800U,
    0xbf516c00U,
    0x5afe00U,
    0xba200b00U,
    0x23303880U,
    0x73cc1fc0U,
    0x549d46a0U,
    0xb0c3d4f0U,
    0x1ce7de08U,
    0xd7bb14U,
    0x469e409aU,
    0x69c673c7U,
    0xee623890U,
    0x9a971fecU,
    0x4438c69bU,
    0x4db714e6U,
    0xeb88fe14U,
    0x873b0b0eU,
    0x4a35b8a9U,
    0x1948dfeeU,
    0x2ada66aaU,
    0xa46364c8U,
    0x796263dU,
    0x30be1705U,
    0x20f19e8eU,
    0x50adc8edU,
    0xd28e7834U,
    0x85ba6c33U,
    0x28777e14U,
    0xcfe8cb22U,
    0x40ad1885U,
    0xda8bafd2U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0x78000000U,
    0x8c000000U,
    0x86000000U,
    0x53000000U,
    0x93800000U,
    0x2bc00000U,
    0x68e00000U,
    0xb0f00000U,
    0x1a380000U,
    0x5c4c0000U,
    0x45360000U,
    0xdddd0000U,
    0xb13d8000U,
    0x3cb4000U,
    0x8f6a000U,
    0x363bd000U,
    0xea48e800U,
    0xbe312400U,
    0xba5b5200U,
    0x90fd5100U,
    0xbe2fb480U,
    0x7884ac40U,
    0x944766a0U,
    0xf523bd50U,
    0x2315f218U,
    0xcd4a8124U,
    0x67b15ca6U,
    0xa4988857U,
    0xe899b49fU,
    0xce99ac67U,
    0xad9ae69dU,
    0x9618fd7aU,
    0x49db5238U,
    0x2b3d5121U,
    0x4ecfb49bU,
    0x9474ac78U,
    0x707f66acU,
    0x766fbd4dU,
    0x73a3f23aU,
    0x68578121U,
    0x2decdcb0U,
    0x3c63c86bU,
    0x92b714aaU,
    0x141e7c49U,
    0x18dc0eb2U,
    0xa9b8d951U,
    0x78b8006U,
    0x65d64021U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xb0000000U,
    0x18000000U,
    0x44000000U,
    0x6e000000U,
    0x8d000000U,
    0x7b800000U,
    0xf7c00000U,
    0xea00000U,
    0xed700000U,
    0x26280000U,
    0xbdc0000U,
    0xc8b20000U,
    0xff8d0000U,
    0x62a8000U,
    0x1bdf4000U,
    0xb3e000U,
    0x1389d000U,
    0x342d5800U,
    0xbcdad400U,
    0x9834f200U,
    0x12ca7300U,
    0xb6c99a80U,
    0xa8cb30c0U,
    0x5dcde8a0U,
    0xd24f03f0U,
    0x538f1238U,
    0x942fa31cU,
    0x6cdec29eU,
    0x3030e4fdU,
    0x4ec99abdU,
    0x9ccb30c2U,
    0x4bcde8bdU,
    0xab4f03c2U,
    0x5e0f1223U,
    0xaaefa30bU,
    0x77fec28fU,
    0xa780e4e7U,
    0x1dc19a98U,
    0x8da730c2U,
    0xabf7e88dU,
    0xb26e03c0U,
    0xb6bf922bU,
    0x4561e30bU,
    0xb9d5a2b0U,
    0x505b74f3U,
    0x2f75a2b2U,
    0x392b74efU,
    0x75da286U,
    0xff774eaU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x58000000U,
    0x94000000U,
    0xae000000U,
    0xe9000000U,
    0xe4800000U,
    0xa3400000U,
    0x70600000U,
    0xb7500000U,
    0x61080000U,
    0x91dc0000U,
    0x58160000U,
    0x6b6f0000U,
    0xc1898000U,
    0x249c4000U,
    0xe5756000U,
    0xdebe5000U,
    0x26c17800U,
    0x1ba48c00U,
    0xee742e00U,
    0xa9388100U,
    0x8605e580U,
    0xd50564c0U,
    0x36864ba0U,
    0x3842a5d0U,
    0x1fe14e08U,
    0x2396d114U,
    0x11ac9dbeU,
    0xf82de8e1U,
    0xb9ec659dU,
    0xffc924cfU,
    0xae7b2b9aU,
    0x5060f5c6U,
    0xe756363bU,
    0x990d5d34U,
    0x15d93391U,
    0xae1529d2U,
    0x166ae02aU,
    0x8b0d1019U,
    0x6edd9800U,
    0x71969c28U,
    0xcaa83622U,
    0x37ae5d3aU,
    0x3d2eb389U,
    0xd76a69d8U,
    0x53880015U,
    0x1f9c0023U,
    0x9af60031U,
    0x127f0012U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x18000000U,
    0x7c000000U,
    0x86000000U,
    0xa7000000U,
    0xda800000U,
    0x2400000U,
    0x51600000U,
    0x45500000U,
    0x23980000U,
    0x594c0000U,
    0x2f160000U,
    0x56f90000U,
    0x86188000U,
    0xdd894000U,
    0x6a362000U,
    0xdc95000U,
    0x5e514800U,
    0x5f1d4c00U,
    0x6c0ed600U,
    0x4cf1f100U,
    0x75eebd80U,
    0xee3a840U,
    0xe096eba0U,
    0x1b3e1950U,
    0xdab8f638U,
    0xa478a12cU,
    0xc05ff59eU,
    0xe6eee463U,
    0xe6603d87U,
    0x37d3e866U,
    0x25d84bafU,
    0x22e0945U,
    0x53479e1cU,
    0x74e0bd22U,
    0x81966ba3U,
    0x6bb594dU,
    0xf278d632U,
    0xef58f125U,
    0xa86e3db1U,
    0x626e866U,
    0x3bb6cbb7U,
    0x9b0e497cU,
    0x5e713e03U,
    0x83acad03U,
    0x4d870386U,
    0xe0c64553U,
    0xbf27c825U,
    0x7a310c06U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x38000000U,
    0xfc000000U,
    0x86000000U,
    0x11000000U,
    0x5800000U,
    0xdcc00000U,
    0xe7e00000U,
    0x79500000U,
    0x94780000U,
    0x4bac0000U,
    0x5960000U,
    0x43990000U,
    0x7aff8000U,
    0x45ef4000U,
    0x4a332000U,
    0x146a5000U,
    0x94f2f800U,
    0xf88c0400U,
    0x6f23da00U,
    0x9cb00100U,
    0xe62aa180U,
    0x5d524b40U,
    0xbe78fba0U,
    0x84a80a50U,
    0xfd10fa38U,
    0x24da5114U,
    0xacd85996U,
    0x58de4f7bU,
    0x6adb218fU,
    0x29d80b6bU,
    0x7f5a5b98U,
    0xcd181a67U,
    0x64b8a20eU,
    0x324a4502U,
    0xe1c5dbabU,
    0x7c675a73U,
    0x3893822aU,
    0xd81c151eU,
    0x3b39239eU,
    0x98e5e68U,
    0x3aa1d83fU,
    0x18765400U,
    0xedc92213U,
    0x9a000527U,
    0xc7077b8bU,
    0x4c874a42U,
    0x3543da17U,
    0x8520013eU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x90000000U,
    0x98000000U,
    0x84000000U,
    0xe2000000U,
    0x75000000U,
    0xf7800000U,
    0x9c00000U,
    0xe0600000U,
    0xa0100000U,
    0xac780000U,
    0xa5ac0000U,
    0x59b20000U,
    0xb4090000U,
    0xcdc78000U,
    0x22664000U,
    0xa517e000U,
    0x53ffb000U,
    0xb06c7800U,
    0xdfd23400U,
    0x8319e200U,
    0xe33b6500U,
    0x798fff80U,
    0x1505cd40U,
    0xa781fda0U,
    0x71c11870U,
    0xf4627a18U,
    0xda16e114U,
    0x5d7a659eU,
    0xb02c9c45U,
    0x2577e03eU,
    0xa3efb00cU,
    0x6414783dU,
    0x6e7e343bU,
    0xa0abe223U,
    0xa632650bU,
    0xa1c87fabU,
    0x4ba38d5cU,
    0x15761da0U,
    0x8beea876U,
    0x8160205U,
    0x78d519U,
    0x2ba987afU,
    0x42b2f970U,
    0xc88d9fadU,
    0x20853d42U,
    0xab45e5a2U,
    0x6e26dc4cU,
    0x41b2002cU,
    0xf0090036U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x50000000U,
    0x8000000U,
    0xc000000U,
    0xce000000U,
    0x25000000U,
    0x64800000U,
    0x37c00000U,
    0x89a00000U,
    0x36d00000U,
    0xca980000U,
    0x178c0000U,
    0xd2b60000U,
    0x3aed0000U,
    0xd8418000U,
    0xefe0c000U,
    0x4372000U,
    0x1e2c9000U,
    0xa4631800U,
    0x10706c00U,
    0x9fcbea00U,
    0x35525b00U,
    0x32dc9f80U,
    0x86d3c40U,
    0x6e8055a0U,
    0x70c3f750U,
    0xb627d218U,
    0x1892a704U,
    0x147a6dbaU,
    0x5d3e0b57U,
    0x4c58a011U,
    0x90ad501aU,
    0x84a3b812U,
    0xae513c10U,
    0x8b5e5239U,
    0xef2e6703U,
    0x4ae34da3U,
    0x20b39b41U,
    0xc9ec383fU,
    0x7dc0fc16U,
    0x2ea6f218U,
    0x5953372cU,
    0xecd8f587U,
    0xc56ea77aU,
    0x56046a0fU,
    0x81039b14U,
    0x16843f99U,
    0x84c06c6bU,
    0xcc23edaaU,
    0xa792cb56U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x90000000U,
    0xe8000000U,
    0xc4000000U,
    0x66000000U,
    0x21000000U,
    0xdb800000U,
    0xe5400000U,
    0x6ba00000U,
    0x52900000U,
    0x42b80000U,
    0xc16c0000U,
    0x16760000U,
    0xb88f0000U,
    0xedc58000U,
    0x1a61c000U,
    0xd2f46000U,
    0x5b499000U,
    0x52a17800U,
    0xd513f400U,
    0xddffc600U,
    0x51cdff00U,
    0xf4665580U,
    0x47f68b40U,
    0x3ecdf3a0U,
    0x2ae2e450U,
    0x2f32de08U,
    0xe92b9b34U,
    0xe456eb92U,
    0x785b8055U,
    0x465fe003U,
    0x9b5b5029U,
    0xaade9807U,
    0x5c98a415U,
    0x43b95e16U,
    0xcae95b1cU,
    0xbb310b93U,
    0x872cd06cU,
    0x31577803U,
    0xbddcf437U,
    0xae1a460cU,
    0x897c3f18U,
    0x5a0a35a5U,
    0x8f031b51U,
    0xee828b9cU,
    0x10c21055U,
    0xfbe69826U,
    0x6cb4a42aU,
    0x106f5e36U,
    0x55f65b12U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0x8000000U,
    0x14000000U,
    0x22000000U,
    0x5d000000U,
    0x6c800000U,
    0x9ac00000U,
    0x4ca00000U,
    0x54d00000U,
    0xbe780000U,
    0xbc6c0000U,
    0xb60000U,
    0xeb090000U,
    0x62468000U,
    0xb463c000U,
    0x2573e000U,
    0xb6283000U,
    0x90d7b800U,
    0xe47b2c00U,
    0x9d69a200U,
    0x6a33db00U,
    0x6cae780U,
    0xb65a340U,
    0x34f0a5a0U,
    0x106e4850U,
    0x7eb5fa38U,
    0xe00cc71cU,
    0x41c2fd9aU,
    0x17245449U,
    0x8b95602aU,
    0x169bf002U,
    0x6bdc580bU,
    0xde3f1c3dU,
    0x5081a0aU,
    0x7141f736U,
    0xdbe5c5b4U,
    0x8835b86dU,
    0x7bc9a214U,
    0x37e3db23U,
    0x9632e793U,
    0x40c9a34eU,
    0x1c66a59cU,
    0x2177487aU,
    0xcc2b7a1dU,
    0xe1d30725U,
    0xb6ff1d9aU,
    0x6ca96461U,
    0x35125816U,
    0xf95a1c22U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x18000000U,
    0x54000000U,
    0xa000000U,
    0x29000000U,
    0x7800000U,
    0x2bc00000U,
    0x69600000U,
    0xb7900000U,
    0xd6080000U,
    0xd85c0000U,
    0xda320000U,
    0x987f0000U,
    0x26808000U,
    0x10434000U,
    0x24a36000U,
    0x19f77000U,
    0x5d19d800U,
    0x5f17d400U,
    0x4d4f3200U,
    0x9e7e5d00U,
    0xb1814b80U,
    0xa4c592c0U,
    0x89e519a0U,
    0x10d0bff0U,
    0xf62f8a28U,
    0x74edf91cU,
    0xda0d218eU,
    0x665c5bf9U,
    0x69328024U,
    0x1efc402fU,
    0x46c3e00bU,
    0xce4302cU,
    0xd952b81dU,
    0x56eca432U,
    0x7f0cea2dU,
    0x1fda8911U,
    0xd1f4f982U,
    0x411b8fdaU,
    0x8915b205U,
    0x924e1d3fU,
    0xf6f8abbdU,
    0xeac2a2d8U,
    0xc2e5218eU,
    0x52505bd2U,
    0x34688027U,
    0xd4f4022U,
    0x7e796039U,
    0x2184703bU,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x70000000U,
    0x48000000U,
    0xe4000000U,
    0x6e000000U,
    0x7f000000U,
    0x27800000U,
    0x47c00000U,
    0x37a00000U,
    0x89d00000U,
    0xf9a80000U,
    0x81bc0000U,
    0x2cb20000U,
    0xa15d0000U,
    0xb6848000U,
    0xdf47c000U,
    0x37e66000U,
    0x89b7d000U,
    0xfdac800U,
    0x15c1e400U,
    0x3aa67200U,
    0x73537b00U,
    0x1cef4f80U,
    0x8f5ffdc0U,
    0x69875da0U,
    0xe8c756f0U,
    0x4820da38U,
    0x12144f2cU,
    0xc0d758aU,
    0xfd6ba2e5U,
    0xe39e8029U,
    0x3fa6c016U,
    0xcdd0e00aU,
    0x87ad1012U,
    0xc6b82816U,
    0xa731f40aU,
    0x6c9ada28U,
    0x90254f1dU,
    0xe13f5bcU,
    0xae0d62d9U,
    0x786e600bU,
    0x9d1bd00dU,
    0xc4e0c806U,
    0xf430e429U,
    0x118f217U,
    0xa6e5bb36U,
    0x1137afbbU,
    0xf9eedf1U,
    0x15a575adU,
    0xccd7a2fcU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xd0000000U,
    0xb8000000U,
    0x44000000U,
    0xba000000U,
    0x81000000U,
    0x4e800000U,
    0x21c00000U,
    0xda600000U,
    0x71500000U,
    0x82b80000U,
    0xac2c0000U,
    0x8ff60000U,
    0x7d0d0000U,
    0xcf058000U,
    0x5d814000U,
    0xf240e000U,
    0x9b217000U,
    0x9f41800U,
    0xa20c5c00U,
    0x8a82aa00U,
    0xdbc1d500U,
    0xbb602d80U,
    0xefd01140U,
    0x1b7a67a0U,
    0x324cb450U,
    0x44a05218U,
    0x7eb1f924U,
    0x2dab1f96U,
    0xf3b0d865U,
    0x552e0020U,
    0x25710021U,
    0xd6cb8005U,
    0xfc60401cU,
    0x9e53600bU,
    0xaf3d3005U,
    0xd6697838U,
    0x38d06c17U,
    0x32f85210U,
    0x120df93cU,
    0xa2851fa6U,
    0xc7c1d854U,
    0x9565800fU,
    0x6cd1400aU,
    0x90f8e025U,
    0xe70d7025U,
    0x3e02183dU,
    0x9b015c18U,
    0xff872a1eU,
    0x740950bU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0xf8000000U,
    0xec000000U,
    0xc6000000U,
    0x21000000U,
    0xd4800000U,
    0x52400000U,
    0x6ee00000U,
    0x16f00000U,
    0x37080000U,
    0xb9bc0000U,
    0x37560000U,
    0xe59b0000U,
    0x27078000U,
    0x95874000U,
    0xf6c1a000U,
    0x94a3d000U,
    0x6c10f800U,
    0xbf8cc00U,
    0x69b60600U,
    0x7b6aed00U,
    0x54086480U,
    0xfe3f1dc0U,
    0xca97c2a0U,
    0x42ba20d0U,
    0xecd15e28U,
    0x765af104U,
    0xb5211ab6U,
    0xa0d67cefU,
    0xa05e002fU,
    0x4c270023U,
    0xc851800cU,
    0xcc1c4008U,
    0xefc62010U,
    0xcc24902aU,
    0x88515827U,
    0xec1b1c23U,
    0xbfc6fe35U,
    0x34222103U,
    0x6456629fU,
    0x2a19f0d9U,
    0x9ec1a619U,
    0xe0a23d3eU,
    0x36171ca3U,
    0x44fc91caU,
    0x88366496U,
    0xd7a81dd2U,
    0x8fae42abU,
    0x73aa60c8U,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x90000000U,
    0x88000000U,
    0xd4000000U,
    0x9a000000U,
    0x8b000000U,
    0xd9800000U,
    0x60c00000U,
    0x6200000U,
    0xe4100000U,
    0x37680000U,
    0xb5bc0000U,
    0xe1f60000U,
    0x8dd0000U,
    0xf4078000U,
    0xaa02c000U,
    0x7305e000U,
    0x1586f000U,
    0xa6c4c800U,
    0xc3243400U,
    0x2c911a00U,
    0x52f6f00U,
    0xadddd80U,
    0x63039dc0U,
    0xdd8127a0U,
    0x92c602d0U,
    0xc9263218U,
    0x2f90ab34U,
    0x8af8f9aU,
    0xf01a06d1U,
    0xee200024U,
    0xe0100007U,
    0xc5680028U,
    0x7abc001eU,
    0x2a760015U,
    0x371d0014U,
    0xb1a7802aU,
    0xa5d2c036U,
    0x9bcde003U,
    0x24eaf037U,
    0x767ac804U,
    0x9a553411U,
    0xe089a2cU,
    0x124caf02U,
    0x6c29bd8dU,
    0xd45aadf7U,
    0xfc478fbfU,
    0xee6606cbU,
    0x3076000dU,
    0xfc1d0028U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0xf0000000U,
    0xa8000000U,
    0xe4000000U,
    0x5a000000U,
    0xa1000000U,
    0xa5800000U,
    0xb3c00000U,
    0x22200000U,
    0xd9700000U,
    0x82680000U,
    0x1edc0000U,
    0x91920000U,
    0xc0bd0000U,
    0x70008000U,
    0x6804c000U,
    0x84016000U,
    0xaa027000U,
    0x9029800U,
    0x41870400U,
    0xe9c26200U,
    0x83218700U,
    0x7cf2f680U,
    0x31af46c0U,
    0x3cf9f4a0U,
    0x48e0b1f0U,
    0x42d39a38U,
    0x6ed9f30cU,
    0xf9928cb2U,
    0x44bd05c5U,
    0xda00001cU,
    0x61000021U,
    0xc5800027U,
    0x43c00038U,
    0x8a20000bU,
    0x3d700023U,
    0xd868003eU,
    0xbfdc0019U,
    0x3412002dU,
    0x737d001bU,
    0x52208030U,
    0xb174c01cU,
    0x669601dU,
    0xb4de7037U,
    0x98909807U,
    0x813a040aU,
    0x99c2e224U,
    0xeb25472aU,
    0xf8f39684U,
    0x9bad36c6U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x90000000U,
    0x18000000U,
    0xc000000U,
    0xd2000000U,
    0xc9000000U,
    0xba800000U,
    0xdb400000U,
    0x72e00000U,
    0x4ef00000U,
    0xcfc80000U,
    0x837c0000U,
    0xdcd60000U,
    0xa6190000U,
    0x85e38000U,
    0x3f764000U,
    0x1f0ba000U,
    0xc5e7000U,
    0xf1861800U,
    0x90c2fc00U,
    0xef221e00U,
    0xbd574500U,
    0x2edc9480U,
    0x66c023c0U,
    0x50232aa0U,
    0xf8d016d0U,
    0xd01a2638U,
    0x7ae48934U,
    0x1af0b29eU,
    0x71cdaae7U,
    0x8781812U,
    0xb757fc21U,
    0xcbdf9e02U,
    0xfe440520U,
    0xca62b4b4U,
    0x24b113e6U,
    0x9bad12bbU,
    0xdccadad1U,
    0xa4fd8012U,
    0x313400bU,
    0x84be2014U,
    0xd2713012U,
    0xd38e3827U,
    0x281acc1dU,
    0xa6e7a616U,
    0xb0f7c90aU,
    0x24ce9294U,
    0x78fc9ae1U,
    0xa9162038U,
    0xd1bd3016U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xf0000000U,
    0x68000000U,
    0xac000000U,
    0x1a000000U,
    0x63000000U,
    0x24800000U,
    0x28c00000U,
    0x2c200000U,
    0xdf100000U,
    0xaf080000U,
    0x8fdc0000U,
    0x36720000U,
    0xbb7f0000U,
    0xa3a28000U,
    0x4f52c000U,
    0xf9ef2000U,
    0x43ee3000U,
    0x10ea8800U,
    0x7c6c5c00U,
    0x8ac3200U,
    0x568cff00U,
    0x469c1d80U,
    0xd710b6c0U,
    0x130d0fa0U,
    0x2ddd79f0U,
    0x61711a28U,
    0x41ff530cU,
    0x5e650792U,
    0x3ef3e5d7U,
    0x49ba083cU,
    0xcc819c03U,
    0x44c19207U,
    0x16200f2eU,
    0x4c11b598U,
    0xe38edad6U,
    0xb19b586U,
    0x52dafcU,
    0x76bb587U,
    0x282ddacbU,
    0xe849359cU,
    0xe3bf1aedU,
    0x27861589U,
    0x1c412adfU,
    0xbce49d8aU,
    0xc73176d4U,
    0xae1aaf98U,
    0xf5d289dbU,
    0xe42c3230U,
    0xe24cff11U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x30000000U,
    0x28000000U,
    0x24000000U,
    0x8a000000U,
    0xb1000000U,
    0xe0800000U,
    0xbc00000U,
    0x61a00000U,
    0x46500000U,
    0x84a80000U,
    0xe43c0000U,
    0x77b20000U,
    0x39190000U,
    0x4c228000U,
    0xb16c000U,
    0x21cf6000U,
    0x48f000U,
    0xe30a9800U,
    0x7d6eac00U,
    0xc89f8a00U,
    0xb7631b00U,
    0x9976db80U,
    0x3a3cf9c0U,
    0x44b431a0U,
    0x9c9e12f0U,
    0x3562f218U,
    0xdc76873cU,
    0x48bc29b2U,
    0xf2767ec5U,
    0xb3ba1808U,
    0x43f16c15U,
    0x68fa6a22U,
    0x1912b22U,
    0x6b0923aaU,
    0x496fa5daU,
    0xba99a3bbU,
    0x3a6065f4U,
    0xfff4439cU,
    0x2efe55c9U,
    0xfe91bb84U,
    0x808809e8U,
    0x3b2ca98aU,
    0x1479bee2U,
    0x9c57f825U,
    0xedaf5c0aU,
    0xe8bf9229U,
    0xe277770aU,
    0x4bbc31b5U,
    0x7ff212ecU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0x50000000U,
    0x18000000U,
    0xb4000000U,
    0x2000000U,
    0x7b000000U,
    0xcc800000U,
    0xe1c00000U,
    0x19a00000U,
    0x80900000U,
    0xeea80000U,
    0x6fc0000U,
    0x4e760000U,
    0x695b0000U,
    0xd7e78000U,
    0x40704000U,
    0xb45c6000U,
    0x5a633000U,
    0xf2310800U,
    0x9ab91c00U,
    0xed97fa00U,
    0x4b2edb00U,
    0x68ba0d80U,
    0x9e90efc0U,
    0xbaf97a0U,
    0x6f7a04d0U,
    0xe6351228U,
    0x88b8b704U,
    0xae969f8eU,
    0x63af18f9U,
    0x937ce826U,
    0x48316c23U,
    0x45bd123bU,
    0x1b14b732U,
    0x35e89fb3U,
    0xa79818f5U,
    0x30c5681dU,
    0x32262c2fU,
    0x73d0f213U,
    0x93ccc737U,
    0x864a77a6U,
    0xc00e74c7U,
    0xcce9fa03U,
    0x5019db09U,
    0x3d838db9U,
    0x9a47afc6U,
    0xf2e27792U,
    0x49f274f9U,
    0x6c1ffa1fU,
    0xf382db38U,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0x98000000U,
    0xbc000000U,
    0xae000000U,
    0x87000000U,
    0xf0800000U,
    0xc7c00000U,
    0xca00000U,
    0xd5100000U,
    0x46080000U,
    0xa5dc0000U,
    0x44f20000U,
    0x9d7b0000U,
    0xdbe58000U,
    0xee764000U,
    0x37bc2000U,
    0x82c01000U,
    0x2d238800U,
    0xe9535c00U,
    0xdbe84a00U,
    0x18aaa300U,
    0x39cea980U,
    0x4578d6c0U,
    0x7e0c3a0U,
    0x707565f0U,
    0xb8ba6208U,
    0x5643af14U,
    0xf8e34b8eU,
    0xccf639cbU,
    0x797a282dU,
    0x69e50c3eU,
    0x5777e23fU,
    0xd839ef34U,
    0x9856b99U,
    0x484129ebU,
    0xb7e62019U,
    0xb877100dU,
    0x3cbc0814U,
    0xd4421c1bU,
    0x49e3ea02U,
    0x777f306U,
    0xe03c8181U,
    0x2581dad3U,
    0x7e45218bU,
    0x8ce78afcU,
    0xe6f28980U,
    0x7c78c6e6U,
    0x28634b8aU,
    0x5b3639e5U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0x18000000U,
    0x64000000U,
    0x1e000000U,
    0x1b000000U,
    0x5a800000U,
    0xf1c00000U,
    0x53a00000U,
    0xa1100000U,
    0xe2880000U,
    0xf5c0000U,
    0x8bf20000U,
    0xa8ff0000U,
    0xcce38000U,
    0xc5704000U,
    0x4f3ae000U,
    0xd8415000U,
    0x94e6e800U,
    0x41702c00U,
    0xa13b2a00U,
    0xb410b00U,
    0xb2606180U,
    0xcab462c0U,
    0xf79baba0U,
    0xebd739f0U,
    0xfbaca228U,
    0x678c3704U,
    0x8edd438eU,
    0xb715edU,
    0xda9f8821U,
    0x26513c2fU,
    0xe2ef2219U,
    0xbcec770eU,
    0x47efa384U,
    0xed6a45cdU,
    0xd4ab600bU,
    0xfb0e101dU,
    0x201f8804U,
    0xc7913c21U,
    0x894f2203U,
    0xa9fc772aU,
    0xa367a39fU,
    0x9d3645c2U,
    0x1bd96022U,
    0xb9311000U,
    0xe5dc0822U,
    0x52317c3fU,
    0x775dc229U,
    0xdff1271cU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0x30000000U,
    0xf8000000U,
    0x14000000U,
    0xce000000U,
    0x35000000U,
    0x800000U,
    0xe3c00000U,
    0x97200000U,
    0xe7100000U,
    0xd0e80000U,
    0xc73c0000U,
    0xc9760000U,
    0xf81d0000U,
    0xb2628000U,
    0xeaf44000U,
    0xaa586000U,
    0x20035000U,
    0x90021800U,
    0x28060c00U,
    0xdc00ea00U,
    0x2205cf00U,
    0xef032580U,
    0xfb80d1c0U,
    0xd645afa0U,
    0x74674ed0U,
    0x93f01218U,
    0xa0d8d31cU,
    0xf0c7b786U,
    0xdea142c9U,
    0xf650f82dU,
    0x830d1c18U,
    0xa08c920bU,
    0xf2cd9339U,
    0x60ab579bU,
    0x1a5b52c4U,
    0x98000002U,
    0x64000015U,
    0xd600003eU,
    0x1100003bU,
    0x36800005U,
    0xc2c00038U,
    0x59a00001U,
    0x31d0000eU,
    0x4748003cU,
    0xc3ec0004U,
    0x8ebe001aU,
    0xd8310001U,
    0xabfc8012U,
    0xd5d5400fU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x10000000U,
    0x28000000U,
    0x14000000U,
    0x62000000U,
    0x87000000U,
    0x8c800000U,
    0xbac00000U,
    0x5f200000U,
    0xb9d00000U,
    0xf8d80000U,
    0xeacc0000U,
    0x74b60000U,
    0xdee90000U,
    0x3fe78000U,
    0x1df3c000U,
    0xdb8ae000U,
    0x5dd73000U,
    0xe2dc6800U,
    0x31cffc00U,
    0x9e342200U,
    0xa92b5700U,
    0x7f447380U,
    0xf0670e40U,
    0x41b4b1a0U,
    0xdd6e6950U,
    0x6da52a38U,
    0xa2105b14U,
    0x867ed992U,
    0xe6589541U,
    0xaf0e8832U,
    0xfb14cc34U,
    0xbbfe4a23U,
    0x551dab0bU,
    0x516fd1beU,
    0x3a39945U,
    0xb142211U,
    0xc3fb5725U,
    0x91c7398U,
    0x376b0e67U,
    0xcea2b1afU,
    0x1497694bU,
    0x97baaa27U,
    0x6bff9b1fU,
    0x5d1a39a2U,
    0x356aa543U,
    0x59a36035U,
    0xb011f03bU,
    0x397f0813U,
    0x56de0c30U,
    0x80000000U,
    0xc0000000U,
    0x60000000U,
    0x50000000U,
    0x98000000U,
    0xf4000000U,
    0xfa000000U,
    0xc7000000U,
    0x95800000U,
    0x80c00000U,
    0xaaa00000U,
    0x17100000U,
    0xdb980000U,
    0x554c0000U,
    0xd4f20000U,
    0xd0ed0000U,
    0xca658000U,
    0x2db04000U,
    0x34886000U,
    0x2ad6f000U,
    0xe3bb2800U,
    0x371a3400U,
    0x750ffa00U,
    0xa012ab00U,
    0x26196180U,
    0x898cf240U,
    0xb854fba0U,
    0x96f9a970U,
    0x4d793238U,
    0x50be2f24U,
    0x989dd3beU,
    0x52ce9d69U,
    0xcf334838U,
    0x29ccc43cU,
    0xcb4d203U,
    0x89f05U,
    0x5e969ba9U,
    0x5d5e5958U,
    0xceed9a02U,
    0xcf655b11U,
    0xbb35c9beU,
    0x13cb8655U,
    0xabb6e1abU,
    0xc58db277U,
    0x46531b8fU,
    0x3fe1941U,
    0x23fdfa3bU,
    0xd3ffab0aU,
    0x7bfce1bdU,
    0x47fcb273U,
    0xd1fc9bb2U,
    0x18ff5949U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0x28000000U,
    0xa4000000U,
    0x7e000000U,
    0xe5000000U,
    0x8d800000U,
    0x8ec00000U,
    0x12600000U,
    0x1bf00000U,
    0x14880000U,
    0xa6bc0000U,
    0xdad20000U,
    0xbdf0000U,
    0x17a68000U,
    0xd914c000U,
    0xd03d6000U,
    0xac915000U,
    0x62fb9800U,
    0x6cf36400U,
    0x360e6a00U,
    0x46ff8d00U,
    0xd2f08080U,
    0xf309bdc0U,
    0xbb798aa0U,
    0x743460f0U,
    0x456e1228U,
    0xde89792cU,
    0x85b81282U,
    0x6e5404f5U,
    0x8a9cf835U,
    0x9c013420U,
    0x62017234U,
    0x47072906U,
    0xea850aadU,
    0x1443a0ccU,
    0x2e27f23eU,
    0x91d3e926U,
    0xfb586a98U,
    0xb8e2f0d4U,
    0xefb46a1dU,
    0x6aac8d2bU,
    0x6f6c00a3U,
    0xad8e7dd1U,
    0x69386a93U,
    0x6312f0c8U,
    0xdb3c6a23U,
    0xbc108d2fU,
    0x9dbe00a9U,
    0x2517df9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xb0000000U,
    0x28000000U,
    0x3c000000U,
    0x6e000000U,
    0x7000000U,
    0x81800000U,
    0xf400000U,
    0x3600000U,
    0x59500000U,
    0xaff80000U,
    0xd06c0000U,
    0x8fb20000U,
    0x4bef0000U,
    0x85f08000U,
    0x180ac000U,
    0xf165a000U,
    0x40511000U,
    0x217b0800U,
    0xd2ac5400U,
    0xc5944600U,
    0x2adeb900U,
    0x9cdd2d80U,
    0x6fd93740U,
    0x2c5c4ba0U,
    0xd21c5e70U,
    0x43ffce28U,
    0xc6682d1cU,
    0xcb4cb82U,
    0x6a9e63U,
    0xf7b06e31U,
    0xcfea3d3eU,
    0x4ff543b3U,
    0x650f0a6eU,
    0x25e3080aU,
    0xa790542aU,
    0xabde4638U,
    0x65db90fU,
    0x3f1fada2U,
    0xf7cf76aU,
    0x35a96bb9U,
    0xd4178e73U,
    0xbd99663eU,
    0x8bb9693dU,
    0x64898595U,
    0xeaa77343U,
    0x84f18582U,
    0x428b7372U,
    0x81a3859aU,
    0xd374734dU,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0x10000000U,
    0x18000000U,
    0xd4000000U,
    0x66000000U,
    0xfd000000U,
    0x4d800000U,
    0x8a400000U,
    0xa1a00000U,
    0xe9700000U,
    0xcd380000U,
    0xe78c0000U,
    0x9f560000U,
    0xa90f0000U,
    0x31918000U,
    0x96a4000U,
    0x1e076000U,
    0xd9071000U,
    0x83811800U,
    0xab43a400U,
    0x4625ce00U,
    0x2c301700U,
    0xba1b1a80U,
    0x343e9840U,
    0x340834a0U,
    0x8c13df50U,
    0x2b2d5608U,
    0x63a5f314U,
    0x9a77b4aeU,
    0x1ba9f71U,
    0x9a4db63fU,
    0xe3b7a31aU,
    0xe3584ca2U,
    0x49186b59U,
    0xb8b8001dU,
    0xe9cc003dU,
    0xe0f6002aU,
    0x797f0038U,
    0xcf298001U,
    0x4da64004U,
    0xb71601aU,
    0xee38102dU,
    0x9308982bU,
    0x2695e42fU,
    0xabecae28U,
    0x52c4070cU,
    0x5a65828eU,
    0xd8947c5aU,
    0xc2ed1abfU,
    0xd941984aU,
    0x80000000U,
    0xc0000000U,
    0xa0000000U,
    0x90000000U,
    0x28000000U,
    0xa4000000U,
    0x2a000000U,
    0x9f000000U,
    0x32800000U,
    0xc4400000U,
    0xf7a00000U,
    0xed700000U,
    0xf0680000U,
    0xffdc0000U,
    0x6e520000U,
    0x385b0000U,
    0x67958000U,
    0x93bc000U,
    0x1056000U,
    0x6f86f000U,
    0x6dc1e800U,
    0xbb64cc00U,
    0x6997a600U,
    0x7c384700U,
    0xc841280U,
    0x94432c0U,
    0x762354a0U,
    0x5b145f0U,
    0x5e8bce08U,
    0xec8b4b14U,
    0xaf8cd4a2U,
    0x9b0d85cdU,
    0xde492e20U,
    0x866d7b3eU,
    0xa6dddcaeU,
    0x7dd479f2U,
    0xc39a001bU,
    0x75f70013U,
    0x6b2f8023U,
    0x9afcc007U,
    0xd762e021U,
    0x17963029U,
    0xd1390835U,
    0xbd05fc10U,
    0x59812e29U,
    0x54c17b17U,
    0x98e7dcbdU,
    0x2a5379c0U,
    0xe25d8004U,
    0xe097c03cU,
    0x27bf602aU,
    0x6341f02cU,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0x70000000U,
    0x48000000U,
    0xc000000U,
    0xbe000000U,
    0x69000000U,
    0x40800000U,
    0x35400000U,
    0x97e00000U,
    0x40300000U,
    0xb2180000U,
    0xa3ec0000U,
    0xb1520000U,
    0xba690000U,
    0xac908000U,
    0x84cfc000U,
    0xfd412000U,
    0x5be01000U,
    0x1e33f800U,
    0xab1aac00U,
    0xab681e00U,
    0x88143d00U,
    0x93884a80U,
    0x85a5f340U,
    0x7651f4a0U,
    0x6bee1e70U,
    0x7d536618U,
    0xe46d512cU,
    0xb59374aaU,
    0x8c48de5fU,
    0xc402c61dU,
    0x72028129U,
    0x3701ac87U,
    0x5982624bU,
    0x3dc12007U,
    0xaea0102eU,
    0x69d3f81eU,
    0x9b2aac3eU,
    0x51701e02U,
    0x27f83d08U,
    0x9cda4a8dU,
    0x56ccf345U,
    0x9a417488U,
    0xda61de62U,
    0x17f24629U,
    0xffbd412eU,
    0x19b88c80U,
    0x84be725eU,
    0xde38d800U,
    0x407fbc12U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0x30000000U,
    0xe8000000U,
    0x34000000U,
    0x12000000U,
    0xfd000000U,
    0xe0800000U,
    0x50400000U,
    0x2aa00000U,
    0xb3f00000U,
    0x5580000U,
    0x4a6c0000U,
    0xebd60000U,
    0x5be90000U,
    0xe5168000U,
    0x720cc000U,
    0x77c1e000U,
    0x7362b000U,
    0x6b933800U,
    0xe948cc00U,
    0xeae65600U,
    0x61579f00U,
    0x3aa85e80U,
    0xb1355f40U,
    0x92b968a0U,
    0x8bbcb050U,
    0xe13bee38U,
    0xf07f931cU,
    0x2c59e8a2U,
    0xc8e97041U,
    0xce948e1eU,
    0x95cde322U,
    0xfca530a4U,
    0x94f60c67U,
    0x7cd96028U,
    0x30ab7025U,
    0xb0325817U,
    0x43fbc0dU,
    0xecfa0e39U,
    0xa1d231dU,
    0xd54ad08dU,
    0xbce1bc59U,
    0x652d83dU,
    0x232a7c16U,
    0xfbf56e2fU,
    0x215f5310U,
    0xe06e08a2U,
    0xfad2c061U,
    0x75693637U,
    0x6e55ef11U,
    0x80000000U,
    0xc0000000U,
    0xe0000000U,
    0xb0000000U,
    0xa8000000U,
    0x2c000000U,
    0x96000000U,
    0x23000000U,
    0x15800000U,
    0xf1400000U,
    0x54600000U,
    0x8a900000U,
    0xe0380000U,
    0xf06c0000U,
    0x9a720000U,
    0x67690000U,
    0x5df68000U,
    0xef2ec000U,
    0x19172000U,
    0xa7e5000U,
    0x658be800U,
    0x43a75400U,
    0xe237d600U,
    0xab8fd100U,
    0xc4a62b80U,
    0x1db7e740U,
    0xf7c85da0U,
    0x2244a670U,
    0xc9e0be18U,
    0x7d3451cU,
    0x3a5a5d92U,
    0xddfda667U,
    0xd5ce3e2fU,
    0xd3418533U,
    0xa5677d98U,
    0xe616f658U,
    0x1f9561aU,
    0xcbcd1125U,
    0x8c430bb0U,
    0x3ee0b77aU,
    0xb0553591U,
    0xfa1d3262U,
    0x5184819U,
    0xe9ec414U,
    0xa0dd9e3eU,
    0x6f38151eU,
    0xb3ed35a3U,
    0xa831326aU,
    0x968a480eU,
    0x8e27c439U,
    0x77731e01U,
    0xf5ead504U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xf0000000U,
    0xf8000000U,
    0x14000000U,
    0x3a000000U,
    0x89000000U,
    0x9b800000U,
    0xbbc00000U,
    0x5e00000U,
    0x55700000U,
    0xb9080000U,
    0x7e3c0000U,
    0x5c160000U,
    0x673f0000U,
    0x2f968000U,
    0x60fa4000U,
    0xc766000U,
    0x6a8cf000U,
    0x89fb5800U,
    0x87f1b400U,
    0x79481200U,
    0x901f9900U,
    0x481c880U,
    0x674695c0U,
    0xc6a13aa0U,
    0xf1d3bcd0U,
    0x25dbca08U,
    0x2676d2cU,
    0x78b73a96U,
    0xbbecbcf9U,
    0xf3cd4a10U,
    0xb45d2d37U,
    0x28a15a80U,
    0xa2d04cf0U,
    0x675e1239U,
    0x2a20992eU,
    0x2a974889U,
    0xc57cd5d4U,
    0xacb75a81U,
    0x61ef4cfdU,
    0x2ac8921bU,
    0x27dad91aU,
    0x7f612896U,
    0x893025caU,
    0x812c02a7U,
    0x81aef8c0U,
    0x74e88039U,
    0x27494022U,
    0x9b1ee03aU,
    0xa205b03cU,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x88000000U,
    0x4000000U,
    0x5a000000U,
    0x45000000U,
    0x1b800000U,
    0xa2400000U,
    0x68600000U,
    0x23900000U,
    0xedf80000U,
    0xe9ac0000U,
    0xf1760000U,
    0x9da90000U,
    0x63708000U,
    0xbca9c000U,
    0xd2f36000U,
    0xd3ef7000U,
    0xa513b800U,
    0x83f5400U,
    0x658c5e00U,
    0xd985d900U,
    0xdb451380U,
    0xc5e5e940U,
    0x6ad2ada0U,
    0x91a8050U,
    0x32f96638U,
    0x972a4d2cU,
    0xd8b2adbaU,
    0x2f8a807dU,
    0xa4816614U,
    0x2cc64d00U,
    0xc9a4ad88U,
    0x95b38045U,
    0x7009e61eU,
    0x3cc38d31U,
    0xf1a1cdafU,
    0x79b5f05fU,
    0xde0ade03U,
    0xabc51924U,
    0xab26f3b0U,
    0x9a73596dU,
    0x512a7593U,
    0xfbb6a458U,
    0xc7088015U,
    0xf645c024U,
    0x6a65602fU,
    0x7a967034U,
    0xd07b3809U,
    0xd8ea940cU,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0xd0000000U,
    0xf8000000U,
    0x1c000000U,
    0x2e000000U,
    0xf000000U,
    0xc3800000U,
    0x24400000U,
    0xe6a00000U,
    0x72100000U,
    0x2bd80000U,
    0x2c0c0000U,
    0xf4320000U,
    0x580f0000U,
    0xde338000U,
    0x950f4000U,
    0x14b22000U,
    0x99c91000U,
    0x27d3c800U,
    0x83e0400U,
    0x543c8e00U,
    0x9a3a0f00U,
    0x653f0980U,
    0x8ebef440U,
    0x4efa27a0U,
    0x9a5eab70U,
    0xc94ec628U,
    0x2e144b04U,
    0xe5da27b6U,
    0xd30eab73U,
    0x1fb6c615U,
    0x98484b34U,
    0xa9027b3U,
    0xc61dab7eU,
    0xf3ef4617U,
    0x52040b22U,
    0x110387b0U,
    0xc484fb60U,
    0xd3c52e19U,
    0x8e05f23U,
    0xa9b4e1b0U,
    0xbb4ae058U,
    0xef14e196U,
    0xd95ae076U,
    0x1ccce1abU,
    0x3956e069U,
    0x3efee187U,
    0x7259e040U,
    0xd4d6190U,
    0xcc16a069U,
    0x80000000U,
    0x40000000U,
    0x60000000U,
    0xf0000000U,
    0x28000000U,
    0x24000000U,
    0x9e000000U,
    0x4d000000U,
    0x34800000U,
    0x63c00000U,
    0xf1a00000U,
    0x9c700000U,
    0x95680000U,
    0xb45c0000U,
    0x98560000U,
    0xa4590000U,
    0x508000U,
    0xc85cc000U,
    0x4a576000U,
    0x33585000U,
    0x17d0d800U,
    0xfa1f6c00U,
    0xc8b00a00U,
    0xa34a5b00U,
    0xa2687a80U,
    0x73d99ec0U,
    0x121790a0U,
    0xdabb55d0U,
    0x2465238U,
    0x8ae0f72cU,
    0x24179092U,
    0xf3bb55f5U,
    0xc8c6520dU,
    0x5420f70aU,
    0xc93790b2U,
    0x280b55f7U,
    0x320e521bU,
    0x310cf726U,
    0xf08990a6U,
    0x5bce55e5U,
    0x5ba8d224U,
    0xc1793705U,
    0x2fe670a5U,
    0x1496c5d3U,
    0x9e796a10U,
    0xac670b12U,
    0xf0d622b2U,
    0x859f32d3U,
    0xbef67ab5U,
    0x4fac9ec8U,
    0x5779108dU,
    0xd6e295c9U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x30000000U,
    0x88000000U,
    0xbc000000U,
    0x26000000U,
    0xd000000U,
    0x35800000U,
    0x76c00000U,
    0x5ee00000U,
    0xb7500000U,
    0x75880000U,
    0x139c0000U,
    0x19320000U,
    0xdd9f0000U,
    0x78348000U,
    0x561bc000U,
    0x7f4a000U,
    0x2f7b5000U,
    0x51601800U,
    0x1a93a400U,
    0xbbee6a00U,
    0x6b894900U,
    0xea999180U,
    0x96b328c0U,
    0xb05fdba0U,
    0x9656f1f0U,
    0x1e08f228U,
    0x7c5e2d3cU,
    0xd857dbaaU,
    0xbf0af1e3U,
    0xd7daf20bU,
    0x97912d1cU,
    0x4e6b5b8cU,
    0x3d4d31d2U,
    0x847c5218U,
    0xa9e57d2fU,
    0x79d7c38bU,
    0xa3c955e6U,
    0xa3c9814U,
    0x94446431U,
    0xd6a0ca0eU,
    0xb7f11900U,
    0x677f09adU,
    0xcd644ce8U,
    0xc9191adU,
    0x3eef28e4U,
    0xe20ddb9cU,
    0xba59f1ecU,
    0xc554720eU,
    0x3289ed3dU,
    0x80000000U,
    0x40000000U,
    0xe0000000U,
    0xb0000000U,
    0x18000000U,
    0x1c000000U,
    0xf2000000U,
    0xd1000000U,
    0xc6800000U,
    0xdb400000U,
    0x24a00000U,
    0x34f00000U,
    0xdbf80000U,
    0x24cc0000U,
    0x2fd60000U,
    0xb6cd0000U,
    0xed68000U,
    0x884f4000U,
    0x79932000U,
    0x46e8f000U,
    0x8062d800U,
    0xa997dc00U,
    0xaee8be00U,
    0x64601700U,
    0xf793e680U,
    0x95e8ca40U,
    0x6fe6f8a0U,
    0x18536d50U,
    0xbb0ae618U,
    0xb9358b3cU,
    0x2c1ef8beU,
    0x609f6d6bU,
    0x86dce61aU,
    0x6ef88b23U,
    0xfc4878b5U,
    0x2f902d6eU,
    0x29efc61eU,
    0xcde07b2cU,
    0x6152a0bbU,
    0x798bf15cU,
    0x8c71782aU,
    0x2bbd6c05U,
    0x43efc605U,
    0x40e07b1aU,
    0xb5d2a09cU,
    0xc3cbf14bU,
    0x76517820U,
    0xd80d6c3fU,
    0x4eb7c637U,
    0x81dc7b02U,
    0x877ca08cU,
    0x8a8af14aU,
    0x80000000U,
    0x40000000U,
    0x20000000U,
    0xf0000000U,
    0xe8000000U,
    0xb4000000U,
    0xa000000U,
    0x6d000000U,
    0xa7800000U,
    0x73400000U,
    0x11e00000U,
    0x3a300000U,
    0x7e680000U,
    0xcd9c0000U,
    0xfed60000U,
    0xfdb0000U,
    0xb6b28000U,
    0x1aac000U,
    0xe3bfe000U,
    0xcac47000U,
    0xb5a77800U,
    0x29557400U,
    0xd49e3600U,
    0x33569d00U,
    0xc19b9280U,
    0x18d780c0U,
    0x14dec4a0U,
    0x3234add0U,
    0x5a6f4e28U,
    0xff98e92cU,
    0x3fd724b2U,
    0xfe5bddd1U,
    0x16f2b618U,
    0xd0cb5d26U,
    0x6048f2a3U,
    0x718e30fbU,
    0x20aadcb7U,
    0x823869efU,
    0x52856031U,
    0xc8c2b00aU,
    0xfca6983bU,
    0xbcd6043dU,
    0x66ddce2eU,
    0xd332293bU,
    0x5be8c4a1U,
    0xb7dfadc6U,
    0x5ab5ce27U,
    0x77ae2939U,
    0xc0bec4a6U,
    0xe244adc7U,
    0xb8674e07U,
    0xe674e935U,
    0x80000000U,
    0xc0000000U,
    0x20000000U,
    0x70000000U,
    0x58000000U,
    0xe4000000U,
    0x92000000U,
    0x59000000U,
    0x64800000U,
    0x2b400000U,
    0x64600000U,
    0xf7100000U,
    0xa2a80000U,
    0xeb7c0000U,
    0x1e720000U,
    0x1b3f0000U,
    0x8f968000U,
    0x4fef4000U,
    0x3c18e000U,
    0x40e23000U,
    0x3c539800U,
    0x96cc4c00U,
    0x346bae00U,
    0xdf5100U,
    0x86470f80U,
    0x5ae12fc0U,
    0x6950c1a0U,
    0xfc4c0ef0U,
    0x402a3628U,
    0x933c1d2cU,
    0x8392219eU,
    0x41ed3ee5U,
    0x631d2e12U,
    0xb760111fU,
    0xce97efb5U,
    0x2f6f1fc0U,
    0xd55959b6U,
    0x558342feU,
    0x13c5183dU,
    0x69230c3dU,
    0x70734e28U,
    0xd43d6113U,
    0x7014978fU,
    0x712d63c7U,
    0xabbb6f99U,
    0x8ed35fd5U,
    0xc68d39afU,
    0x158d32e8U,
    0x2c0ae02eU,
    0xa1cd3024U,
    0x9fed1836U,
    0xd41f0c09U,
    0x80000000U,
    0x40000000U,
    0xa0000000U,
    0xb0000000U,
    0x58000000U,
    0x84000000U,
    0x4a000000U,
    0x1d000000U,
    0x83800000U,
    0xfec00000U,
    0x52200000U,
    0x5ad00000U,
    0xf3f80000U,
    0x6d6c0000U,
    0xbf60000U,
    0x75af0000U,
    0x32d48000U,
    0x6ffd4000U,
    0x36fe000U,
    0xecf5f000U,
    0xb32f7800U,
    0xcb945400U,
    0x891cfa00U,
    0x169a6f00U,
    0xc659ab80U,
    0xd379c740U,
    0xff2831a0U,
    0xad941850U,
    0xa21d8208U,
    0xf61d3b3cU,
    0xb41fd1beU,
    0x651de84dU,
    0xc09cfa24U,
    0xb55a6f36U,
    0xb7f9ab9aU,
    0xc769c754U,
    0x6f03182U,
    0x1e281858U,
    0x10138232U,
    0xf3de3b36U,
    0xebd51a0U,
    0x818fa874U,
    0xa3079a3eU,
    0x6c82df26U,
    0xf44133aaU,
    0x8d64636fU,
    0x3735b3acU,
    0xb689234cU,
    0x6d8253b0U,
    0x59c0d35aU,
    0x34a32b93U,
    0x1397876eU,
};
}
