## Copyright 2009 Intel Corporation
## SPDX-License-Identifier: Apache-2.0

set(COMPONENT_NAME openvkl)

set(COMPONENT_PATH ${INSTALL_DIR_ABSOLUTE})
if (INSTALL_IN_SEPARATE_DIRECTORIES)
  set(COMPONENT_PATH ${INSTALL_DIR_ABSOLUTE}/${COMPONENT_NAME})
endif()

if (OPENVKL_HASH)
  set(OPENVKL_URL_HASH URL_HASH SHA256=${OPENVKL_HASH})
endif()

string(REGEX REPLACE "(^[0-9]+\.[0-9]+\.[0-9]+$)" "v\\1" OPENVKL_ARCHIVE ${OPENVKL_VERSION})
set(OPENVKL_BRANCH "${OPENVKL_ARCHIVE}" CACHE STRING "Which branch of OpenVKL to build" )
set(OPENVKL_URL "https://github.com/openvkl/openvkl/archive/${OPENVKL_ARCHIVE}.zip"
  CACHE STRING "Location to clone OpenVKL source from")

string(REGEX MATCH ".*\.zip$" ZIP_FILENAME ${OPENVKL_URL})
if (ZIP_FILENAME)
  set(OPENVKL_CLONE_URL URL ${OPENVKL_URL})
else()
  set(OPENVKL_CLONE_URL GIT_REPOSITORY ${OPENVKL_URL} GIT_TAG ${OPENVKL_BRANCH})
endif()

ExternalProject_Add(${COMPONENT_NAME}
  PREFIX ${COMPONENT_NAME}
  DOWNLOAD_DIR ${COMPONENT_NAME}
  STAMP_DIR ${COMPONENT_NAME}/stamp
  SOURCE_DIR ${COMPONENT_NAME}/src
  BINARY_DIR ${COMPONENT_NAME}/build
  LIST_SEPARATOR | # Use the alternate list separator
  ${OPENVKL_CLONE_URL}
  ${OPENVKL_URL_HASH}
  CMAKE_ARGS
    -DCMAKE_PREFIX_PATH=${CMAKE_PREFIX_PATH}
    -DCMAKE_CXX_COMPILER=${CMAKE_CXX_COMPILER}
    -DCMAKE_C_COMPILER=${CMAKE_C_COMPILER}
    -DCMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE}
    -DCMAKE_INSTALL_PREFIX:PATH=${COMPONENT_PATH}
    -DCMAKE_INSTALL_INCLUDEDIR=${CMAKE_INSTALL_INCLUDEDIR}
    -DCMAKE_INSTALL_LIBDIR=${CMAKE_INSTALL_LIBDIR}
    -DCMAKE_INSTALL_DOCDIR=${CMAKE_INSTALL_DOCDIR}
    -DCMAKE_INSTALL_BINDIR=${CMAKE_INSTALL_BINDIR}
    -DCMAKE_BUILD_TYPE=${DEPENDENCIES_BUILD_TYPE}
    $<$<BOOL:${DOWNLOAD_TBB}>:-DRKCOMMON_TBB_ROOT=${TBB_PATH}>
    $<$<BOOL:${DOWNLOAD_ISPC}>:-DISPC_EXECUTABLE=${ISPC_PATH}>
    $<$<BOOL:${DOWNLOAD_ISPC}>:-Dispcrt_DIR=${ispcrt_DIR}>
    -DBUILD_BENCHMARKS=OFF
    -DBUILD_EXAMPLES=OFF
    -DBUILD_TESTING=OFF
    -DCMAKE_OSX_ARCHITECTURES=${CMAKE_OSX_ARCHITECTURES}
    -DCMAKE_OSX_DEPLOYMENT_TARGET=${CMAKE_OSX_DEPLOYMENT_TARGET}
    -DOPENVKL_ISA_SSE4=${BUILD_ISA_SSE4}
    -DOPENVKL_ISA_AVX=${BUILD_ISA_AVX}
    -DOPENVKL_ISA_AVX2=${BUILD_ISA_AVX2}
    -DOPENVKL_ISA_AVX512SKX=${BUILD_ISA_AVX512}
    -DOPENVKL_ISA_NEON=${BUILD_ISA_NEON}
    -DOPENVKL_ISA_NEON2X=${BUILD_ISA_NEON2X}
    -DOPENVKL_ENABLE_DEVICE_GPU=${BUILD_GPU_SUPPORT}
  BUILD_COMMAND ${DEFAULT_BUILD_COMMAND}
  BUILD_ALWAYS ${ALWAYS_REBUILD}
)

list(APPEND CMAKE_PREFIX_PATH ${COMPONENT_PATH})
string(REPLACE ";" "|" CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH}")

ExternalProject_Add_StepDependencies(${COMPONENT_NAME}
  configure
    rkcommon
    embree
    $<$<BOOL:${DOWNLOAD_ISPC}>:ispc>
    $<$<BOOL:${BUILD_ISPCRT_FROM_SOURCE}>:ispcrt>
)
