//
// C++ Implementation: CFireEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CFireEdit.hpp"

CFireEditDlg::CFireEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.hcolor, SIGNAL(released()), this, SLOT(slotEditColor()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CFireEditDlg::~CFireEditDlg() {
}

void CFireEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CFireEditDlg::slotGetData(FolderListItem *i)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;
    
    point=i;
    
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());

    ui.locx->setValue(i->GetValue("x",i).toDouble());
    ui.locy->setValue(i->GetValue("y",i).toDouble());
    ui.locz->setValue(i->GetValue("z",i).toDouble());
    
    ui.scax->setValue(i->GetValue("scax",i).toDouble());
    ui.scay->setValue(i->GetValue("scay",i).toDouble());
    ui.scaz->setValue(i->GetValue("scaz",i).toDouble());

    ui.rotx->setValue(i->GetValue("rotx",i).toDouble());
    ui.roty->setValue(i->GetValue("roty",i).toDouble());
    ui.rotz->setValue(i->GetValue("rotz",i).toDouble());

    ui.height->setText(i->GetValue("height",i));
    ui.speed->setText(i->GetValue("speed",i));
        
    strncpy(mybuff,i->GetValue("hotcolor",i).toAscii().constData() ,8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    mycolor.setRgb(colorr,colorg,colorb);
    if ( mycolor.isValid() ){
      QPixmap pix (100,15);
      pix.fill( mycolor );
      QIcon icon(pix);
      ui.hcolor->setIcon( icon );
      QSize size(100,15);
      ui.hcolor->setIconSize( size );      
    }
    qWarning( "CFireEditDlg::slotGetData(): Geht !" );
}

void CFireEditDlg::slotEditData()
{
    char mybuff[256];

    if(point != NULL){
        point->setText(0,ui.text->text());

        point->SetValue("on",ui.on->isChecked() ? "1" : "0");

        point->SetValue("x",ui.locx->text());
        point->SetValue("y",ui.locy->text());
        point->SetValue("z",ui.locz->text());
    
        point->SetValue("scax",ui.scax->text());
        point->SetValue("scay",ui.scay->text());
        point->SetValue("scaz",ui.scaz->text());

        point->SetValue("rotx",ui.rotx->text());
        point->SetValue("roty",ui.roty->text());
        point->SetValue("rotz",ui.rotz->text());

        point->SetValue("height",ui.height->text());
        point->SetValue("speed",ui.speed->text());
        
        sprintf(mybuff,"%02X%02X%02X",mycolor.red(),mycolor.green(),mycolor.blue());
        point->SetValue("hotcolor",mybuff);

        point->updategl();
    }
    qWarning( "CFireEditDlg::slotEditData(): Geht !" );
}

void CFireEditDlg::slotEditColor()
{
    QColor color = QColorDialog::getColor(mycolor,this );
    
    if ( color.isValid() ) {
        QPixmap pix (100,15) ;
        pix.fill( color );
        QIcon icon(pix);
        ui.hcolor->setIcon( icon );
        QSize size(100,15);
        ui.hcolor->setIconSize( size );      
        mycolor = color;
    }
    qWarning( "CFireEditDlg::slotEditColorAmb(): Geht !" );
}
