# qemu-web-desktop: Installation 

<br>
<img src="src/html/desktop/images/darts_logo.png" height=200>
<br>

This documentation details how to install the qemu-web-desktop/DARTS.
The installation steps for further GPU pass-through are described in [GPU.md](GPU.md).
To configure the service, refer to [CONFIGURE.md](CONFIGURE.md).

Table of contents:

1. [Installation: The short story](#installation-the-short-story)
2. [Installation in an ideal world (automatic, Debian/Ubuntu)](#installation-in-an-ideal-world-automatic-debianubuntu)
3. [Installation step by step (manual, other Linux)](#installation-step-by-step-manual-other-linux)

## Installation: The short story

1. First identify a computer with some sturdy CPU and memory, possibly GPU's.
1. Install a Debian-class system (e.g. Ubuntu/Debian/Mint/...). 
1. Then install the service package with `sudo apt install qemu-web-desktop`. You may also get the latest Debian package at the [Releases page](https://gitlab.com/soleil-data-treatment/soleil-software-projects/qemu-web-desktop/-/releases) or [at Debian](https://packages.debian.org/unstable/qemu-web-desktop)
1. Edit the machine list file with command `sudo -E qwdctl machines` and un-comment one of the entries (e.g. the Slax one). 
1. Open the URL http://localhost/qemu-web-desktop/, enter a fake user ID (the authentication is inactivated at start), and click on Create. A VM should start.

We have prepared two video that demonstrate the semi-automatic procedure.

[![DARTS Installation and configuration](paper/darts-install.png)](https://drive.google.com/file/d/11_t28Z3FyjXDqtCmHf2XMezbjKC89ch8/view?usp=drive_link "DARTS Installation and configuration")
[![DARTS Usage](paper/darts-usage.png)](https://drive.google.com/file/d/1RKQSW5vSIWFbyKSe5D0DnqulWMzi2_yE/view?usp=drive_link "DARTS Usage")

----------------------------------------------------------------------------------------------

## Installation in an ideal world (automatic, Debian/Ubuntu)

This service has been packaged for Debian. Get the [qemu-web-desktop.deb](https://packages.debian.org/sid/qemu-web-desktop) or type (from Debian 12):
```
sudo apt install qemu-web-desktop
```

Otherwise, install required packages. On a Debian-class system:
```bash
sudo apt install apache2 libapache2-mod-perl2 libapache2-mpm-itk
sudo apt install novnc websockify confget
sudo apt install qemu-kvm bridge-utils qemu iptables dnsmasq libguestfs-tools
sudo apt install libcgi-pm-perl liblist-moreutils-perl libsys-cpu-perl libsys-cpuload-perl libsys-meminfo-perl libnet-dns-perl libproc-background-perl  libproc-processtable-perl libemail-valid-perl libnet-smtps-perl libmail-imapclient-perl libnet-ldap-perl libemail-valid-perl libjson-perl libwww-perl libtext-qrcode-perl
```

:warning: if you just cloned the repository, make sure you collect the src/html/desktop/machines directory with [LFS](https://git-lfs.github.com/). Install it with `sudo apt install git-lfs` then, from the repo, `git-lfs install; git lfs pull`.

Then simply go in the `src` directory and type:
```bash
cd src
sudo make install
```

On a Debian class system, this should be enough.
In case the `make` command fails, you may proceed with a manual installation, as follows.

## Installation step by step (manual, other Linux)

Make sure permissions are set:
```bash
sudo adduser --system --home /var/lib/qemu-web-desktop --force-badname _qemu-web-desktop
sudo chmod 755 /etc/qemu-ifup
```
- copy the `html/machines` and `html/snapshots` directories into `/var/lib/qemu-web-desktop`.
- copy the html directory (except `machines` and `snapshots`) content into e.g. `/usr/share/qemu-web-desktop/html`. You should now have a 'desktop' item there.
- copy the cgi-bin directory content into e.g. `/usr/lib/cgi-bin` (Apache2 / Debian).
- copy the `apache.conf` file as e.g. `/etc/apache2/conf-available/qemu-web-desktop.conf`.
- uncomment or add available VM's in `/etc/qemu-web-desktop/machines.conf`.

and finally:
```bash
sudo chown -R _qemu-web-desktop /usr/share/qemu-web-desktop/html/
sudo find /usr/share/qemu-web-desktop/html/ -type f -exec chmod a+r {} +
sudo find /usr/share/qemu-web-desktop/html/ -type d -exec chmod a+rx {} +
sudo chmod 755 /usr/lib/cgi-bin/qemu-web-desktop.pl
sudo chmod a+xr /var/lib/qemu-web-desktop/
sudo a2enconf qemu-web-desktop
sudo a2enmod cgi
sudo a2enmod include
sudo service apache2 restart
sudo -E qwdctl download
```

To un-install, just do a `cd src; sudo make uninstall`.

:warning: In case you manually install the software, and target directories are customized, make sure to edit the `qwdctl` file to change the filapath to configuration files (at start).
