/*
 * Copyright (C) 2009  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */

#include "qsourcehighlightframe.h"
#include "ui_qsourcehighlightframe.h"

QSourceHighlightFrame::QSourceHighlightFrame(QWidget *parent) :
    QFrame(parent),
    m_ui(new Ui::QSourceHighlightFrame)
{
    m_ui->setupUi(this);
}

QSourceHighlightFrame::~QSourceHighlightFrame()
{
    delete m_ui;
}

void QSourceHighlightFrame::changeEvent(QEvent *e)
{
    QFrame::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

srchiliteqt::TextEditHighlighted *QSourceHighlightFrame::getInputTextEdit() const {
    return m_ui->inputTextEdit;
}

srchiliteqt::TextEditHighlighted *QSourceHighlightFrame::getOutputTextEdit() const {
    return m_ui->outputTextEdit;
}

QSplitter *QSourceHighlightFrame::splitter() {
    return m_ui->splitter;
}

void QSourceHighlightFrame::setPreviewContents(const QString &contents) {
    m_ui->previewWebView->setHtml(contents);
}

void QSourceHighlightFrame::setNoPreview() {
    m_ui->previewWebView->setHtml(
            "<html><body>Sorry, no preview available for this output format.</body></html>"
            );
}
