% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storeDelayedObject.R
\name{storeDelayedObject}
\alias{storeDelayedObject}
\alias{reloadDelayedObject}
\alias{storeDelayedObject,ConstantArraySeed-method}
\alias{storeDelayedObject,DelayedAbind-method}
\alias{storeDelayedObject,ANY-method}
\alias{storeDelayedObject,DelayedAperm-method}
\alias{storeDelayedObject,DelayedNaryIsoOp-method}
\alias{storeDelayedObject,DelayedSetDimnames-method}
\alias{storeDelayedObject,DelayedSubassign-method}
\alias{storeDelayedObject,DelayedSubset-method}
\alias{storeDelayedObject,DelayedUnaryIsoOpStack-method}
\alias{storeDelayedObject,DelayedUnaryIsoOpWithArgs-method}
\alias{storeDelayedObject,SVT_SparseMatrix-method}
\alias{storeDelayedObject,array-method}
\alias{storeDelayedObject,denseMatrix-method}
\alias{storeDelayedObject,sparseMatrix-method}
\title{Store operations in a DelayedArray}
\arguments{
\item{x}{Any of the delayed operation classes from \pkg{DelayedArray}.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}

\item{...}{Arguments to be passed to specific methods.}
}
\value{
The contents of \code{x} are saved to \code{file}, and \code{NULL} is invisibly returned.
}
\description{
Store the delayed operations of a \linkS4class{DelayedArray} in a HDF5 file.
}
\examples{
library(DelayedArray)
X <- DelayedArray(matrix(runif(100), ncol=20))
Y <- cbind(X, DelayedArray::ConstantArray(value=50, c(5, 10)))

library(rhdf5)
temp <- tempfile()
dir.create(temp)

fpath <- file.path(temp, "foo.h5")
fhandle <- H5Fcreate(fpath)
storeDelayedObject(Y@seed, fhandle, "YAY")
rhdf5::h5ls(fhandle)
H5Fclose(fhandle)

fhandle <- H5Fopen(fpath, "H5F_ACC_RDONLY")
reloadDelayedObject(fhandle, "YAY")
H5Fclose(fhandle)

}
\author{
Aaron Lun
}
