% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{significants}
\alias{significants}
\alias{significants,DEGSet-method}
\alias{significants,DESeqResults-method}
\alias{significants,TopTags-method}
\alias{significants,list-method}
\title{Method to get the significant genes}
\usage{
significants(object, padj = 0.05, fc = 0, direction = NULL, full = FALSE, ...)

\S4method{significants}{DEGSet}(object, padj = 0.05, fc = 0, direction = NULL, full = FALSE, ...)

\S4method{significants}{DESeqResults}(object, padj = 0.05, fc = 0, direction = NULL, full = FALSE, ...)

\S4method{significants}{TopTags}(object, padj = 0.05, fc = 0, direction = NULL, full = FALSE, ...)

\S4method{significants}{list}(
  object,
  padj = 0.05,
  fc = 0,
  direction = NULL,
  full = FALSE,
  newFDR = FALSE,
  ...
)
}
\arguments{
\item{object}{\link{DEGSet}}

\item{padj}{Cutoff for the FDR column.}

\item{fc}{Cutoff for the log2FC column.}

\item{direction}{Whether to take down/up/ignore. Valid arguments are
down, up and NULL.}

\item{full}{Whether to return full table or not.}

\item{...}{Passed to \link{deg}. Default: value = NULL.
Value can be 'raw', 'shrunken'.}

\item{newFDR}{Whether to recalculate the FDR or not.
See https://support.bioconductor.org/p/104059/#104072.
Only used when a list is giving to the method.}
}
\value{
a \link[dplyr:tbl_df]{dplyr::tbl_df} data frame. \code{gene} column has the feature name.
In the case of using this method with the results from \link{degComps},
\code{log2FoldChange} has the higher foldChange from the comparisons, and
\code{padj} has the padj associated to the previous column. Then, there is
two columns for each comparison, one for the log2FoldChange and another
for the padj.
}
\description{
Function to get the features that are significant
according to some thresholds from a \link{DEGSet},
\link[DESeq2:DESeqResults]{DESeq2::DESeqResults} and \link[edgeR:topTags]{edgeR::topTags}.
}
\examples{
library(DESeq2)
dds <- makeExampleDESeqDataSet(betaSD=1)
colData(dds)[["treatment"]] <- sample(colData(dds)[["condition"]], 12)
  design(dds) <-  ~ condition + treatment
dds <- DESeq(dds)
res <- degComps(dds, contrast = list("treatment_B_vs_A",
                                     c("condition", "A", "B")))
significants(res, full = TRUE)
# significants(res, full = TRUE, padj = 1) # all genes
}
\author{
Lorena Pantano
}
