% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/plageParam.R
\docType{class}
\name{plageParam-class}
\alias{plageParam-class}
\alias{plageParam}
\title{\code{plageParam} class}
\usage{
plageParam(
  exprData,
  geneSets,
  assay = NA_character_,
  annotation = NA_character_,
  minSize = 1,
  maxSize = Inf
)
}
\arguments{
\item{exprData}{The expression data.  Must be one of the classes
supported by \code{\linkS4class{GsvaExprData}}.  Type \code{help(GsvaExprData)} to consult
the available classes.}

\item{geneSets}{The gene sets.  Must be one of the classes supported by
\code{\linkS4class{GsvaGeneSets}}.}

\item{assay}{The name of the assay to use in case \code{exprData} is a multi-assay
container, otherwise ignored.  By default, the first assay is used.}

\item{annotation}{The name of a Bioconductor annotation package for the gene
identifiers occurring in the row names of the expression data matrix.  This
can be used to map gene identifiers occurring in the gene sets if those are
provided in a \code{\link{GeneSetCollection}}.  By default gene identifiers used in
expression data matrix and gene sets are matched directly.}

\item{minSize}{Minimum size of the resulting gene sets after gene identifier
mapping. By default, the minimum size is 1.}

\item{maxSize}{Maximum size of the resulting gene sets after gene identifier
mapping. By default, the maximum size is \code{Inf}.}
}
\value{
A new \code{\linkS4class{plageParam}} object.
}
\description{
Method-specific parameters for the PLAGE method.

Objects of class \code{plageParam} contain the parameters for running
the \code{PLAGE} method.
}
\details{
Since this method does not take any method-specific parameters, the parameter
class does not add any slots to the common slots inherited from
\code{\linkS4class{GsvaMethodParam}}.

\code{PLAGE} does not take any method-specific parameters in addition to
an expression data set and a collection of gene sets.
}
\examples{
library(GSVA)
library(GSVAdata)

data(leukemia)
data(c2BroadSets)

## for simplicity, use only a subset of the sample data
ses <- leukemia_eset[1:1000, ]
gsc <- c2BroadSets[1:100]
pp1 <- plageParam(ses, gsc)
pp1

}
\references{
Tomfohr, J. et al. Pathway level analysis of gene expression
using singular value decomposition.
\emph{BMC Bioinformatics}, 6:225, 2005.
\href{https://doi.org/10.1186/1471-2105-6-225}{DOI}
}
\seealso{
\code{\linkS4class{GsvaExprData}},
\code{\linkS4class{GsvaGeneSets}},
\code{\linkS4class{GsvaMethodParam}},
\code{\linkS4class{zscoreParam}},
\code{\linkS4class{ssgseaParam}},
\code{\linkS4class{gsvaParam}}
}
