% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-group_by.R
\name{group_by.tbl_lazy}
\alias{group_by.tbl_lazy}
\title{Group by one or more variables}
\usage{
\method{group_by}{tbl_lazy}(.data, ..., .add = FALSE, add = NULL, .drop = TRUE)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}

\item{.add}{When \code{FALSE}, the default, \code{group_by()} will
override existing groups. To add to the existing groups, use
\code{.add = TRUE}.

This argument was previously called \code{add}, but that prevented
creating a new grouping variable called \code{add}, and conflicts with
our naming conventions.}

\item{add}{Deprecated. Please use \code{.add} instead.}

\item{.drop}{Not supported by this method.}
}
\description{
This is a method for the dplyr \code{\link[=group_by]{group_by()}} generic. It is translated to
the \verb{GROUP BY} clause of the SQL query when used with
\code{\link[=summarise.tbl_lazy]{summarise()}} and to the \verb{PARTITION BY} clause of
window functions when used with \code{\link[=mutate.tbl_lazy]{mutate()}}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(g = c(1, 1, 1, 2, 2), x = c(4, 3, 6, 9, 2))
db \%>\%
  group_by(g) \%>\%
  summarise(n()) \%>\%
  show_query()

db \%>\%
  group_by(g) \%>\%
  mutate(x2 = x / sum(x, na.rm = TRUE)) \%>\%
  show_query()
}
